/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.telemetry.BonnShutterTelemetry;
import org.lsst.sal.cccamera.telemetry.FilterChangerTelemetry;
import org.lsst.sal.cccamera.telemetry.Fp_CcdTelemetry;
import org.lsst.sal.cccamera.telemetry.Fp_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Fp_RebTotalPowerTelemetry;
import org.lsst.sal.cccamera.telemetry.Fp_SegmentTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_RtdsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFilterChangerTelemetry() throws Exception {
        float motorTemperature = 0.5327886f;
        float motorEncoder = 0.23305213f;
        float linearPosition = 0.48485178f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FilterChangerTelemetry(motorTemperature, motorEncoder, linearPosition));
        Assert.assertTrue((boolean)(item instanceof FilterChangerTelemetry));
        FilterChangerTelemetry item_ = (FilterChangerTelemetry)item;
        Assert.assertEquals((float)motorTemperature, (float)item_.getMotorTemperature(), (float)1.0E-6f);
        Assert.assertEquals((float)motorEncoder, (float)item_.getMotorEncoder(), (float)1.0E-6f);
        Assert.assertEquals((float)linearPosition, (float)item_.getLinearPosition(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveBonnShutterTelemetry() throws Exception {
        float shutter5V = 0.7365258f;
        float shutter36V = 0.9524612f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new BonnShutterTelemetry(shutter5V, shutter36V));
        Assert.assertTrue((boolean)(item instanceof BonnShutterTelemetry));
        BonnShutterTelemetry item_ = (BonnShutterTelemetry)item;
        Assert.assertEquals((float)shutter5V, (float)item_.getShutter5V(), (float)1.0E-6f);
        Assert.assertEquals((float)shutter36V, (float)item_.getShutter36V(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] digital_VbefLDO = new double[]{0.1976214051246643, 0.2756111f, 0.3378385901451111};
        String location = "x";
        double[] digital_IbefLDO = new double[]{0.9087362885475159, 0.640973f, 0.20784467458724976};
        double[] digital_VaftLDO = new double[]{0.014158666133880615, 0.8944817185401917, 0.17212438583374023};
        double[] digital_IaftLDO = new double[]{0.9838724136352539, 0.890504777431488, 0.11074632406234741};
        double[] digital_VaftSwch = new double[]{0.6021215319633484, 0.44235873222351074, 0.5397210717201233};
        double[] analog_VbefLDO = new double[]{0.6926897168159485, 0.10200345516204834, 0.366751492023468};
        double[] analog_IbefLDO = new double[]{0.7805096507072449, 0.8747261762619019, 0.9472829103469849};
        double[] analog_VaftLDO = new double[]{0.8885076642036438, 0.556930422782898, 0.5792065262794495};
        double[] analog_IaftLDO = new double[]{0.2961454391479492, 0.19636154174804688, 0.0023627877235412598};
        double[] analog_VaftSwch = new double[]{0.28500616550445557, 0.6686477661132812, 0.6660289168357849};
        double[] od_VbefLDO = new double[]{0.7577430605888367, 0.578338623046875, 0.9150266051292419};
        double[] od_IbefLDO = new double[]{0.0884554386138916, 0.36490005254745483, 0.04228156805038452};
        double[] od_VaftLDO = new double[]{0.6637503504753113, 0.036338627338409424, 0.26751482486724854};
        double[] od_VaftLDO2 = new double[]{0.8637517094612122, 0.9317817687988281, 0.1997787356376648};
        double[] od_IaftLDO = new double[]{0.6986638903617859, 0.8881232738494873, 0.8241537809371948};
        double[] od_VaftSwch = new double[]{0.1614902f, 0.6801071166992188, 0.3216143250465393};
        double[] clockhi_VbefLDO = new double[]{0.876488f, 0.4421016573905945, 0.06011462211608887};
        double[] clockhi_IbefLDO = new double[]{0.9373458623886108, 0.4472420811653137, 0.3018820285797119};
        double[] clockhi_VaftLDO = new double[]{0.1699813f, 0.37811917066574097, 0.756597f};
        double[] clockhi_IaftLDO = new double[]{0.2650805711746216, 0.3713676333427429, 0.9410897493362427};
        double[] clockhi_VaftSwch = new double[]{0.3219779133796692, 0.3683926463127136, 0.7247708439826965};
        double[] clocklo_VbefLDO = new double[]{0.3784014f, 0.04783368110656738, 0.9104452133178711};
        double[] clocklo_IbefLDO = new double[]{0.8519304394721985, 0.6333589553833008, 0.49671435356140137};
        double[] clocklo_VaftLDO = new double[]{0.8823203444480896, 0.050605833530426025, 0.7618787884712219};
        double[] clocklo_VaftLDO2 = new double[]{0.5727295875549316, 0.1308283805847168, 0.998331f};
        double[] clocklo_IaftLDO = new double[]{0.3498866558074951, 0.17562341690063477, 0.6904461979866028};
        double[] clocklo_VaftSwch = new double[]{0.2425074f, 0.6432969570159912, 0.28806257247924805};
        double[] heater_VbefLDO = new double[]{0.11362528800964355, 0.7981902956962585, 0.05058586597442627};
        double[] heater_IbefLDO = new double[]{0.410033f, 0.2327372431755066, 0.8834550380706787};
        double[] heater_VaftLDO = new double[]{0.17927193641662598, 0.4878249168395996, 0.7535895705223083};
        double[] heater_IaftLDO = new double[]{0.3272079825401306, 0.7254730463027954, 0.25193703174591064};
        double[] heater_VaftSwch = new double[]{0.7666507363319397, 0.8382720947265625, 0.2768780589103699};
        double[] hvbias_VbefSwch = new double[]{0.694943f, 0.4774436354637146, 0.8706921339035034};
        double[] hvbias_IbefSwch = new double[]{0.9188368320465088, 0.8191748261451721, 0.7146965861320496};
        double[] power = new double[]{0.6422613263130188, 0.7838386297225952, 0.5628254413604736};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(digital_VbefLDO, location, digital_IbefLDO, digital_VaftLDO, digital_IaftLDO, digital_VaftSwch, analog_VbefLDO, analog_IbefLDO, analog_VaftLDO, analog_IaftLDO, analog_VaftSwch, od_VbefLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_IaftLDO, od_VaftSwch, clockhi_VbefLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_IaftLDO, clockhi_VaftSwch, clocklo_VbefLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_IaftLDO, clocklo_VaftSwch, heater_VbefLDO, heater_IbefLDO, heater_VaftLDO, heater_IaftLDO, heater_VaftSwch, hvbias_VbefSwch, hvbias_IbefSwch, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double boardTemp0 = 0.5396012663841248;
        double boardTemp1 = 0.2356804f;
        double boardTemp2 = 0.76755690574646;
        double boardTemp3 = 0.2852470874786377;
        double boardTemp4 = 0.2208581566810608;
        double boardTemp5 = 0.04956305f;
        double boardTemp6 = 0.2891341f;
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertEquals((double)boardTemp0, (double)item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertEquals((double)boardTemp1, (double)item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertEquals((double)boardTemp2, (double)item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertEquals((double)boardTemp3, (double)item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertEquals((double)boardTemp4, (double)item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertEquals((double)boardTemp5, (double)item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertEquals((double)boardTemp6, (double)item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_VQMonitorTelemetry() throws Exception {
        double vqmpressure = 0.08017098903656006;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_VQMonitorTelemetry(vqmpressure));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitorTelemetry));
        Vacuum_VQMonitorTelemetry item_ = (Vacuum_VQMonitorTelemetry)item;
        Assert.assertEquals((double)vqmpressure, (double)item_.getVqmpressure(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumpsTelemetry() throws Exception {
        double ionpump_voltage = 0.975362f;
        double ionpump_current = 0.5168592929840088;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_IonPumpsTelemetry(ionpump_voltage, ionpump_current));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumpsTelemetry));
        Vacuum_IonPumpsTelemetry item_ = (Vacuum_IonPumpsTelemetry)item;
        Assert.assertEquals((double)ionpump_voltage, (double)item_.getIonpump_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)ionpump_current, (double)item_.getIonpump_current(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboTelemetry() throws Exception {
        double rpm = 0.1514669f;
        double power = 0.07667070627212524;
        double voltage = 0.002496182918548584;
        double pumpTemperature = 0.05834996700286865;
        double status = 0.8367744088172913;
        double cntrlrSinkTemperature = 0.2647276520729065;
        double driveFrequency = 0.834425f;
        double current = 0.9504293203353882;
        double cntrlrAirTemperature = 0.2851177453994751;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboTelemetry(rpm, power, voltage, pumpTemperature, status, cntrlrSinkTemperature, driveFrequency, current, cntrlrAirTemperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboTelemetry));
        Vacuum_TurboTelemetry item_ = (Vacuum_TurboTelemetry)item;
        Assert.assertEquals((double)rpm, (double)item_.getRpm(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpTemperature, (double)item_.getPumpTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)status, (double)item_.getStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrSinkTemperature, (double)item_.getCntrlrSinkTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)driveFrequency, (double)item_.getDriveFrequency(), (double)1.0E-6f);
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrAirTemperature, (double)item_.getCntrlrAirTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double rejectTemperature = 0.40919822454452515;
        double autoOffEnabled = 0.010683178901672363;
        double power = 0.4298448f;
        double setPower = 0.010835111141204834;
        double temperature = 0.50991290807724;
        double autoOnTemperature = 0.8421172499656677;
        double setpoint = 0.5516842007637024;
        double autoOffTemperature = 0.11451911926269531;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(rejectTemperature, autoOffEnabled, power, setPower, temperature, autoOnTemperature, setpoint, autoOffTemperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2Telemetry() throws Exception {
        double temperature = 0.9108472466468811;
        double rejectTemperature = 0.687547f;
        double autoOnTemperature = 0.20582687854766846;
        double setpoint = 0.8887909054756165;
        double power = 0.1397416591644287;
        double autoOffEnabled = 0.12922364473342896;
        double autoOffTemperature = 0.4991423487663269;
        double setPower = 0.060374677181243896;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold2Telemetry(temperature, rejectTemperature, autoOnTemperature, setpoint, power, autoOffEnabled, autoOffTemperature, setPower));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2Telemetry));
        Vacuum_Cold2Telemetry item_ = (Vacuum_Cold2Telemetry)item;
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_RtdsTelemetry() throws Exception {
        double temperatureCold1 = 0.9349001049995422;
        double temperatureCold2 = 0.9818090796470642;
        double temperatureCryo = 0.18668502569198608;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_RtdsTelemetry(temperatureCold1, temperatureCold2, temperatureCryo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_RtdsTelemetry));
        Vacuum_RtdsTelemetry item_ = (Vacuum_RtdsTelemetry)item;
        Assert.assertEquals((double)temperatureCold1, (double)item_.getTemperatureCold1(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatureCold2, (double)item_.getTemperatureCold2(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatureCryo, (double)item_.getTemperatureCryo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold1Telemetry() throws Exception {
        double setPower = 0.21072006225585938;
        double power = 0.8145656585693359;
        double rejectTemperature = 0.7258254885673523;
        double autoOnTemperature = 0.791206419467926;
        double autoOffTemperature = 0.7525073885917664;
        double temperature = 0.480847f;
        double autoOffEnabled = 0.46290475130081177;
        double setpoint = 0.01742708683013916;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold1Telemetry(setPower, power, rejectTemperature, autoOnTemperature, autoOffTemperature, temperature, autoOffEnabled, setpoint));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1Telemetry));
        Vacuum_Cold1Telemetry item_ = (Vacuum_Cold1Telemetry)item;
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double bpu_Maq20_I = 0.34737056493759155;
        double ion_Pumps_I = 0.7279629111289978;
        double fpga_T = 0.3086232542991638;
        double bpu_Maq20_V = 0.8943129181861877;
        double board_T = 0.8320593237876892;
        double body_Purge_V = 0.9500392079353333;
        double pwr_Cry_HCU_V = 0.8717734217643738;
        double pwr_Cry_HCU_I = 0.9418385624885559;
        double body_Purge_I = 0.3426443934440613;
        double gauges_V = 0.8763936161994934;
        double main_T = 0.10976654291152954;
        double main_V = 0.31328171491622925;
        double ion_Pumps_V = 0.17146307229995728;
        double main_I = 0.5648835897445679;
        double gauges_I = 0.03226763f;
        double fes_Shu_HCU_I = 0.8929800391197205;
        double fes_Shu_HCU_V = 0.007169842720031738;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(bpu_Maq20_I, ion_Pumps_I, fpga_T, bpu_Maq20_V, board_T, body_Purge_V, pwr_Cry_HCU_V, pwr_Cry_HCU_I, body_Purge_I, gauges_V, main_T, main_V, ion_Pumps_V, main_I, gauges_I, fes_Shu_HCU_I, fes_Shu_HCU_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.6722826361656189;
        double fpga_T = 0.9735507965087891;
        double cryo_Turbo_I = 0.3938329815864563;
        double main_V = 0.15796732902526855;
        double main_T = 0.513742208480835;
        double cryo_Turbo_V = 0.13346683979034424;
        double main_I = 0.5879005789756775;
        double fes_I = 0.4709498882293701;
        double fes_V = 0.7932596206665039;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, fpga_T, cryo_Turbo_I, main_V, main_T, cryo_Turbo_V, main_I, fes_I, fes_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I, (double)item_.getFes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V, (double)item_.getFes_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double heater_I = 0.8530024886131287;
        double protection_I = 0.4846211075782776;
        double dirty_48V_I = 0.2812246084213257;
        double dirty_24V_I = 0.2088964f;
        double clean_5_24V_I = 0.33946776390075684;
        double rebps_0 = 0.9399528503417969;
        double dirty_28V_I = 0.4634294f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(heater_I, protection_I, dirty_48V_I, dirty_24V_I, clean_5_24V_I, rebps_0, dirty_28V_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0, (double)item_.getRebps_0(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_B_V = 0.43860727548599243;
        double otm_0_A_V = 0.8752903938293457;
        double otm_0_A_I = 0.3097681999206543;
        double otm_0_B_I = 0.6414281129837036;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_B_V, otm_0_A_V, otm_0_A_I, otm_0_B_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.5263808965682983;
        double main_T = 0.6607657074928284;
        double main_V = 0.1538516879081726;
        double main_I = 0.730922f;
        double fpga_T = 0.09853965044021606;
        double cryotel0_I = 0.4730631709098816;
        double cryotel0_V = 0.03276348114013672;
        double cryotel1_I = 0.1517086625099182;
        double cryotel1_V = 0.5341876149177551;
        double cryotel2_I = 0.03012669086456299;
        double cryotel2_V = 0.3266274929046631;
        double reb_bulk_I = 0.4241926074028015;
        double reb_bulk_V = 0.5327516794204712;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, main_T, main_V, main_I, fpga_T, cryotel0_I, cryotel0_V, cryotel1_I, cryotel1_V, cryotel2_I, cryotel2_V, reb_bulk_I, reb_bulk_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I, (double)item_.getCryotel0_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V, (double)item_.getCryotel0_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I, (double)item_.getCryotel1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V, (double)item_.getCryotel1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I, (double)item_.getCryotel2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V, (double)item_.getCryotel2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_bulk_I, (double)item_.getReb_bulk_I(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_bulk_V, (double)item_.getReb_bulk_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.9782283902168274;
        double freeSpace = 0.02872532606124878;
        double freeFraction = 0.1469811201095581;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeSpace, freeFraction));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFp_RebTelemetry() throws Exception {
        double[] anaI = new double[]{0.009285271167755127, 0.5658922791481018, 0.24188333749771118};
        double[] anaV = new double[]{0.9930896759033203, 0.9017523527145386, 0.5053524374961853};
        double[] aspicl_Temp0 = new double[]{0.8244085907936096, 0.8311557173728943, 0.9940950870513916};
        double[] aspicl_Temp1 = new double[]{0.07694637775421143, 0.31527024507522583, 0.1104759f};
        double[] aspicl_Temp2 = new double[]{0.8978132009506226, 0.9137728214263916, 0.01397031545639038};
        double[] aspicu_Temp0 = new double[]{0.4956052899360657, 0.749509f, 0.9661128520965576};
        double[] aspicu_Temp1 = new double[]{0.32585716247558594, 0.4143051505088806, 0.281935453414917};
        double[] aspicu_Temp2 = new double[]{0.13068228960037231, 0.21339058876037598, 0.7240076065063477};
        double[] clkHI = new double[]{0.7242322564125061, 0.8225416541099548, 0.6510754227638245};
        double[] clkHV = new double[]{0.4045470356941223, 0.449058f, 0.14185333251953125};
        double[] clkLI = new double[]{0.27757835388183594, 0.862157940864563, 0.5791764855384827};
        double[] clkLV = new double[]{0.15868091583251953, 0.21217858791351318, 0.6607599258422852};
        double[] digI = new double[]{0.5157999396324158, 0.5123403668403625, 0.07157433032989502};
        double[] digV = new double[]{0.8760720491409302, 0.880825936794281, 0.9437201619148254};
        double[] htrV = new double[]{0.23266452550888062, 0.6564675569534302, 0.9533509612083435};
        double[] htrW = new double[]{0.38640785217285156, 0.06089651584625244, 0.3476797342300415};
        double[] hVBiasSwitch = new double[]{0.8089441657066345, 0.812930703163147, 0.21386587619781494};
        String location = "e";
        double[] oDI = new double[]{0.5340974926948547, 0.8659553527832031, 0.7646315097808838};
        double[] oDV = new double[]{0.11168360710144043, 0.09111642837524414, 0.23992103338241577};
        double[] pClkL = new double[]{0.3090554475784302, 0.7101601958274841, 0.16126281023025513};
        double[] pClkU = new double[]{0.7116009593009949, 0.4492213f, 0.5851067304611206};
        double[] power = new double[]{0.05842858552932739, 0.8385970592498779, 0.4137454628944397};
        double[] ref05V = new double[]{0.758403480052948, 0.8805614709854126, 0.3952442407608032};
        double[] ref125V = new double[]{0.4411519169807434, 0.5543213486671448, 0.20808666944503784};
        double[] ref15V = new double[]{0.14494377374649048, 0.7514247298240662, 0.7411676049232483};
        double[] ref25V = new double[]{0.45281195640563965, 0.9956294894218445, 0.3998481035232544};
        double[] refN12 = new double[]{0.1898796f, 0.5980870723724365, 0.04151439666748047};
        double[] refP12 = new double[]{0.6667261123657227, 0.43983322381973267, 0.6512831449508667};
        double[] rGL = new double[]{0.04921752214431763, 0.12424784898757935, 0.005783796310424805};
        double[] rGU = new double[]{0.7827691435813904, 0.2818986177444458, 0.06125783920288086};
        double[] rTDTemp = new double[]{0.44551634788513184, 0.8759012222290039, 0.3322707414627075};
        double[] sClkL = new double[]{0.6014798283576965, 0.5543889403343201, 0.22514891624450684};
        double[] sClkU = new double[]{0.34356874227523804, 0.4499297f, 0.432578980922699};
        double[] temp1 = new double[]{0.9500213265419006, 0.7041158676147461, 0.5905601978302002};
        double[] temp10 = new double[]{0.15868675708770752, 0.5372181534767151, 0.9015504717826843};
        double[] temp2 = new double[]{0.5459669232368469, 0.9277271628379822, 0.8693253993988037};
        double[] temp3 = new double[]{0.6906915307044983, 0.6232205033302307, 0.5039002895355225};
        double[] temp4 = new double[]{0.372947096824646, 0.3661847f, 0.3001787066459656};
        double[] temp5 = new double[]{0.8834424614906311, 0.14057272672653198, 0.6173708438873291};
        double[] temp6 = new double[]{0.9612026810646057, 0.04801511764526367, 0.3075166344642639};
        double[] temp7 = new double[]{0.8862569332122803, 0.2429012f, 0.45531415939331055};
        double[] temp8 = new double[]{0.747342586517334, 0.13618344068527222, 0.4878356456756592};
        double[] temp9 = new double[]{0.5048176050186157, 0.5763466358184814, 0.5830276608467102};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, htrV, htrW, hVBiasSwitch, location, oDI, oDV, pClkL, pClkU, power, ref05V, ref125V, ref15V, ref25V, refN12, refP12, rGL, rGU, rTDTemp, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Fp_RebTelemetry));
        Fp_RebTelemetry item_ = (Fp_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFp_CcdTelemetry() throws Exception {
        double[] gDV = new double[]{0.18113607168197632, 0.12990832328796387, 0.7105728387832642, 0.9349414706230164, 0.731433629989624, 0.1032055f, 0.1187739372253418, 0.551204264163971, 0.7887552976608276};
        String location = "w";
        double[] oDV = new double[]{0.2644098401069641, 0.2190326452255249, 0.932983f, 0.973775f, 0.3396545f, 0.3942485f, 0.06861793994903564, 0.9346742630004883, 0.6745418310165405};
        double[] oGV = new double[]{0.14120906591415405, 0.4500460624694824, 0.7089152932167053, 0.2076675295829773, 0.31833577156066895, 0.09148335456848145, 0.8739694356918335, 0.011934459209442139, 0.8722001910209656};
        double[] rDV = new double[]{0.13280963897705078, 0.22874730825424194, 0.44182825088500977, 0.4428752064704895, 0.014871478080749512, 0.7785090804100037, 0.2980414628982544, 0.2342730164527893, 0.35692495107650757};
        double[] temp = new double[]{0.005169034004211426, 0.41407597064971924, 0.30284178256988525, 0.3750242590904236, 0.6544218063354492, 0.58131343126297, 0.5212643146514893, 0.786777913570404, 0.49979186058044434};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_CcdTelemetry(gDV, location, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Fp_CcdTelemetry));
        Fp_CcdTelemetry item_ = (Fp_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFp_SegmentTelemetry() throws Exception {
        double[] i = new double[]{0.8632792830467224, 0.8847594261169434, 0.8851886987686157, 0.7348409295082092, 0.23631882667541504, 0.20344233512878418, 0.9699575304985046, 0.3071577548980713, 0.09066444635391235, 0.4878164f, 0.6894885897636414, 0.04080832004547119, 0.4690309762954712, 0.9243154525756836, 0.3648267388343811, 0.3376834988594055, 0.37369292974472046, 0.45799845457077026, 0.7849602103233337, 0.5333129167556763, 0.97985f, 0.8697410821914673, 0.7315243482589722, 0.1804996132850647, 0.923492968082428, 0.34092408418655396, 0.013272345066070557, 0.10649305582046509, 0.8345610499382019, 0.8406642079353333, 0.6731714010238647, 0.638889729976654, 0.13770556449890137, 0.015667974948883057, 0.3332202434539795, 0.9151987433433533, 0.5983132123947144, 0.3930413f, 0.1267513632774353, 0.3148263096809387, 0.733614981174469, 0.6697113513946533, 0.050904035568237305, 0.3045209050178528, 0.698835551738739, 0.22198176383972168, 0.7720783948898315, 0.03413683f, 0.5856906771659851, 0.05425792932510376, 0.3065725564956665, 0.914562f, 0.8024911284446716, 0.561866819858551, 0.6524629592895508, 0.8501238226890564, 0.7371757626533508, 0.3195068836212158, 0.395433247089386, 0.37063318490982056, 0.7104004621505737, 0.7501804232597351, 0.7821298241615295, 0.34100186824798584, 0.10711503028869629, 0.8710756897926331, 0.4342998266220093, 0.33723026514053345, 0.9117512106895447, 0.2600153684616089, 0.1531394124031067, 0.9253020882606506, 0.872222363948822, 0.11161643266677856, 0.4767692f, 0.6135520339012146, 0.4675411581993103, 0.4446919f, 0.3485068082809448, 0.9594364762306213, 0.3672473430633545, 0.6357722282409668, 0.42668914794921875, 0.378991f, 0.3403865098953247, 0.9576561450958252, 0.9184102416038513, 0.4528998136520386, 0.6180059313774109, 0.43196988105773926, 0.0030002593994140625, 0.6589388847351074, 0.634658694267273, 0.3117980360984802, 0.7828250527381897, 0.33912956714630127, 0.2980002164840698, 0.9111488461494446, 0.5686032772064209, 0.5744142532348633, 0.4660971760749817, 0.32455867528915405, 0.18661415576934814, 0.37383097410202026, 0.9825586080551147, 0.13037598133087158, 0.8517256379127502, 0.9634333848953247, 0.3411770462989807, 0.25867152214050293, 0.15205252170562744, 0.8976141214370728, 0.0636865496635437, 0.4083990454673767, 0.46033036708831787, 0.5177094340324402, 0.9938944578170776, 0.3131089210510254, 0.9489572048187256, 0.8960791230201721, 0.5843248963356018, 0.6405413150787354, 0.6184304356575012, 0.665179431438446, 0.6012641191482544, 0.7447822093963623, 0.8340408205986023, 0.01802504062652588, 0.5524716377258301, 0.011943638324737549, 0.7377426028251648, 0.04702198505401611, 0.1787082552909851, 0.3087698817253113, 0.19880056381225586, 0.47124534845352173, 0.0036298036575317383, 0.48100972175598145, 0.27893543243408203, 0.5872438549995422, 0.742646336555481, 0.8933253288269043, 0.30920177698135376, 0.00541454553604126};
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Fp_SegmentTelemetry));
        Fp_SegmentTelemetry item_ = (Fp_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFp_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.35901355743408203;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Fp_RebTotalPowerTelemetry));
        Fp_RebTotalPowerTelemetry item_ = (Fp_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }
}

