/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.telemetry.BonnShutterTelemetry;
import org.lsst.sal.cccamera.telemetry.FilterChangerTelemetry;
import org.lsst.sal.cccamera.telemetry.Fp_CcdTelemetry;
import org.lsst.sal.cccamera.telemetry.Fp_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Fp_RebTotalPowerTelemetry;
import org.lsst.sal.cccamera.telemetry.Fp_SegmentTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_RtdsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFilterChangerTelemetry() throws Exception {
        float motorTemperature = 0.36565733f;
        float motorEncoder = 0.06765795f;
        float linearPosition = 0.571001f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FilterChangerTelemetry(motorTemperature, motorEncoder, linearPosition));
        Assert.assertTrue((boolean)(item instanceof FilterChangerTelemetry));
        FilterChangerTelemetry item_ = (FilterChangerTelemetry)item;
        Assert.assertEquals((float)motorTemperature, (float)item_.getMotorTemperature(), (float)1.0E-6f);
        Assert.assertEquals((float)motorEncoder, (float)item_.getMotorEncoder(), (float)1.0E-6f);
        Assert.assertEquals((float)linearPosition, (float)item_.getLinearPosition(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveBonnShutterTelemetry() throws Exception {
        float shutter5V = 0.3994167f;
        float shutter36V = 0.41856527f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new BonnShutterTelemetry(shutter5V, shutter36V));
        Assert.assertTrue((boolean)(item instanceof BonnShutterTelemetry));
        BonnShutterTelemetry item_ = (BonnShutterTelemetry)item;
        Assert.assertEquals((float)shutter5V, (float)item_.getShutter5V(), (float)1.0E-6f);
        Assert.assertEquals((float)shutter36V, (float)item_.getShutter36V(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] digital_VbefLDO = new double[]{0.5444425940513611, 0.6956780552864075, 0.008641839027404785};
        String location = "";
        double[] digital_IbefLDO = new double[]{0.5423893332481384, 0.6076556444168091, 0.7694752812385559};
        double[] digital_VaftLDO = new double[]{0.727053f, 0.8313153982162476, 0.38894426822662354};
        double[] digital_IaftLDO = new double[]{0.4957488179206848, 0.381571f, 0.9427034258842468};
        double[] digital_VaftSwch = new double[]{0.35475146770477295, 0.9338545799255371, 0.6159851551055908};
        double[] analog_VbefLDO = new double[]{0.8021369576454163, 0.9599621891975403, 0.4993806f};
        double[] analog_IbefLDO = new double[]{0.9001702070236206, 0.829734206199646, 0.7675462365150452};
        double[] analog_VaftLDO = new double[]{0.4452148675918579, 0.510695f, 0.873681902885437};
        double[] analog_IaftLDO = new double[]{0.5338900685310364, 0.963172f, 0.27522122859954834};
        double[] analog_VaftSwch = new double[]{0.4494468f, 0.10036486387252808, 0.13265305757522583};
        double[] od_VbefLDO = new double[]{0.778120219707489, 0.2903081774711609, 0.023699283599853516};
        double[] od_IbefLDO = new double[]{0.2603601813316345, 0.8256701231002808, 0.5299704670906067};
        double[] od_VaftLDO = new double[]{0.0824732780456543, 0.9314156174659729, 0.6179431676864624};
        double[] od_VaftLDO2 = new double[]{0.7447406649589539, 0.7064468860626221, 0.5192534327507019};
        double[] od_IaftLDO = new double[]{0.6178314089775085, 0.09379088878631592, 0.3732725977897644};
        double[] od_VaftSwch = new double[]{0.3123772144317627, 0.3434414267539978, 0.3771934509277344};
        double[] clockhi_VbefLDO = new double[]{0.3778343200683594, 0.22163933515548706, 0.5517924427986145};
        double[] clockhi_IbefLDO = new double[]{0.651652991771698, 0.5180367231369019, 0.9713512659072876};
        double[] clockhi_VaftLDO = new double[]{0.608476f, 0.22524887323379517, 0.9630126357078552};
        double[] clockhi_IaftLDO = new double[]{0.06866782903671265, 0.34441041946411133, 0.2202223539352417};
        double[] clockhi_VaftSwch = new double[]{0.32170265913009644, 0.8338043689727783, 0.7473955750465393};
        double[] clocklo_VbefLDO = new double[]{0.22523283958435059, 0.04850787f, 0.5823819041252136};
        double[] clocklo_IbefLDO = new double[]{0.2988243103027344, 0.8369970321655273, 0.2857654094696045};
        double[] clocklo_VaftLDO = new double[]{0.23230499029159546, 0.28623634576797485, 0.5503937005996704};
        double[] clocklo_VaftLDO2 = new double[]{0.9183058738708496, 0.2909461259841919, 0.6576314568519592};
        double[] clocklo_IaftLDO = new double[]{0.6336575150489807, 0.5121147036552429, 0.3220444321632385};
        double[] clocklo_VaftSwch = new double[]{0.856450617313385, 0.4120151996612549, 0.32654857635498047};
        double[] heater_VbefLDO = new double[]{0.6317614316940308, 0.025355815887451172, 0.07298839092254639};
        double[] heater_IbefLDO = new double[]{0.26769375801086426, 0.41402631998062134, 0.1964951753616333};
        double[] heater_VaftLDO = new double[]{0.4466623067855835, 0.4199574589729309, 0.899032711982727};
        double[] heater_IaftLDO = new double[]{0.8155596852302551, 0.654699444770813, 0.22514522075653076};
        double[] heater_VaftSwch = new double[]{0.926028f, 0.661967f, 0.4660797715187073};
        double[] hvbias_VbefSwch = new double[]{0.9350160956382751, 0.6609916090965271, 0.9289290308952332};
        double[] hvbias_IbefSwch = new double[]{0.2519201f, 0.2471522092819214, 0.07819592952728271};
        double[] power = new double[]{0.6815697550773621, 0.6558336019515991, 0.03810513f};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(digital_VbefLDO, location, digital_IbefLDO, digital_VaftLDO, digital_IaftLDO, digital_VaftSwch, analog_VbefLDO, analog_IbefLDO, analog_VaftLDO, analog_IaftLDO, analog_VaftSwch, od_VbefLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_IaftLDO, od_VaftSwch, clockhi_VbefLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_IaftLDO, clockhi_VaftSwch, clocklo_VbefLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_IaftLDO, clocklo_VaftSwch, heater_VbefLDO, heater_IbefLDO, heater_VaftLDO, heater_IaftLDO, heater_VaftSwch, hvbias_VbefSwch, hvbias_IbefSwch, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double boardTemp0 = 0.07685893774032593;
        double boardTemp1 = 0.9008873701095581;
        double boardTemp2 = 0.2528366446495056;
        double boardTemp3 = 0.4659690856933594;
        double boardTemp4 = 0.2931435f;
        double boardTemp5 = 0.8940519690513611;
        double boardTemp6 = 0.2746056318283081;
        String location = "g";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertEquals((double)boardTemp0, (double)item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertEquals((double)boardTemp1, (double)item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertEquals((double)boardTemp2, (double)item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertEquals((double)boardTemp3, (double)item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertEquals((double)boardTemp4, (double)item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertEquals((double)boardTemp5, (double)item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertEquals((double)boardTemp6, (double)item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_VQMonitorTelemetry() throws Exception {
        double vqmpressure = 0.5707722306251526;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_VQMonitorTelemetry(vqmpressure));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitorTelemetry));
        Vacuum_VQMonitorTelemetry item_ = (Vacuum_VQMonitorTelemetry)item;
        Assert.assertEquals((double)vqmpressure, (double)item_.getVqmpressure(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumpsTelemetry() throws Exception {
        double ionpump_voltage = 0.8508858680725098;
        double ionpump_current = 0.324676513671875;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_IonPumpsTelemetry(ionpump_voltage, ionpump_current));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumpsTelemetry));
        Vacuum_IonPumpsTelemetry item_ = (Vacuum_IonPumpsTelemetry)item;
        Assert.assertEquals((double)ionpump_voltage, (double)item_.getIonpump_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)ionpump_current, (double)item_.getIonpump_current(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboTelemetry() throws Exception {
        double rpm = 0.4996801018714905;
        double power = 0.2803533673286438;
        double voltage = 0.5281224250793457;
        double turboSpeed = 0.8113967180252075;
        double pumpTemperature = 0.20921391248703003;
        double status = 0.919331f;
        double cntrlrSinkTemperature = 0.15211504697799683;
        double driveFrequency = 0.1929841f;
        double current = 0.1848042607307434;
        double cntrlrAirTemperature = 0.465553343296051;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboTelemetry(rpm, power, voltage, turboSpeed, pumpTemperature, status, cntrlrSinkTemperature, driveFrequency, current, cntrlrAirTemperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboTelemetry));
        Vacuum_TurboTelemetry item_ = (Vacuum_TurboTelemetry)item;
        Assert.assertEquals((double)rpm, (double)item_.getRpm(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpTemperature, (double)item_.getPumpTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)status, (double)item_.getStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrSinkTemperature, (double)item_.getCntrlrSinkTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)driveFrequency, (double)item_.getDriveFrequency(), (double)1.0E-6f);
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrAirTemperature, (double)item_.getCntrlrAirTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double rejectTemperature = 0.5700189471244812;
        double autoOffEnabled = 0.0494743f;
        double power = 0.1003677248954773;
        double setPower = 0.09727442264556885;
        double temperature = 0.24976319074630737;
        double autoOnTemperature = 0.14794373512268066;
        double setpoint = 0.09035599231719971;
        double autoOffTemperature = 0.5068118572235107;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(rejectTemperature, autoOffEnabled, power, setPower, temperature, autoOnTemperature, setpoint, autoOffTemperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2Telemetry() throws Exception {
        double temperature = 0.5165084004402161;
        double rejectTemperature = 0.9408081769943237;
        double autoOnTemperature = 0.26719367504119873;
        double setpoint = 0.8248472213745117;
        double power = 0.053814053535461426;
        double autoOffEnabled = 0.5187243819236755;
        double autoOffTemperature = 0.9087271094322205;
        double setPower = 0.9063484072685242;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold2Telemetry(temperature, rejectTemperature, autoOnTemperature, setpoint, power, autoOffEnabled, autoOffTemperature, setPower));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2Telemetry));
        Vacuum_Cold2Telemetry item_ = (Vacuum_Cold2Telemetry)item;
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_RtdsTelemetry() throws Exception {
        double temperatureCold1 = 0.95255047082901;
        double temperatureCold2 = 0.881436f;
        double temperatureCryo = 0.1027945876121521;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_RtdsTelemetry(temperatureCold1, temperatureCold2, temperatureCryo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_RtdsTelemetry));
        Vacuum_RtdsTelemetry item_ = (Vacuum_RtdsTelemetry)item;
        Assert.assertEquals((double)temperatureCold1, (double)item_.getTemperatureCold1(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatureCold2, (double)item_.getTemperatureCold2(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatureCryo, (double)item_.getTemperatureCryo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold1Telemetry() throws Exception {
        double setPower = 0.2808569669723511;
        double power = 0.4572157859802246;
        double rejectTemperature = 0.8346399664878845;
        double autoOnTemperature = 0.1962890625;
        double autoOffTemperature = 0.2926040291786194;
        double temperature = 0.6542792916297913;
        double autoOffEnabled = 0.3726828694343567;
        double setpoint = 0.46251094341278076;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold1Telemetry(setPower, power, rejectTemperature, autoOnTemperature, autoOffTemperature, temperature, autoOffEnabled, setpoint));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1Telemetry));
        Vacuum_Cold1Telemetry item_ = (Vacuum_Cold1Telemetry)item;
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double bpu_Maq20_I = 0.3193243145942688;
        double ion_Pumps_I = 0.3706586956977844;
        double fpga_T = 0.8869090676307678;
        double bpu_Maq20_V = 0.9937039613723755;
        double fes_Shu_HCU_I = 0.19808429479599;
        double board_T = 0.15577363967895508;
        double body_Purge_V = 0.659696638584137;
        double pwr_Cry_HCU_V = 0.044072628021240234;
        double pwr_Cry_HCU_I = 0.35289841890335083;
        double body_Purge_I = 0.26424747705459595;
        double fes_Shu_HCU_V = 0.7171663641929626;
        double gauges_V = 0.31904345750808716;
        double main_T = 0.6289815902709961;
        double main_V = 0.34782183170318604;
        double ion_Pumps_V = 0.4623984098434448;
        double main_I = 0.03394496440887451;
        double gauges_I = 0.5244044661521912;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(bpu_Maq20_I, ion_Pumps_I, fpga_T, bpu_Maq20_V, fes_Shu_HCU_I, board_T, body_Purge_V, pwr_Cry_HCU_V, pwr_Cry_HCU_I, body_Purge_I, fes_Shu_HCU_V, gauges_V, main_T, main_V, ion_Pumps_V, main_I, gauges_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.11709833145141602;
        double fpga_T = 0.4795324206352234;
        double cryo_Turbo_I = 0.782646656036377;
        double main_V = 0.6695271134376526;
        double main_T = 0.5121548771858215;
        double cryo_Turbo_V = 0.2617705464363098;
        double main_I = 0.27514833211898804;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, fpga_T, cryo_Turbo_I, main_V, main_T, cryo_Turbo_V, main_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double heater_I = 0.8513689637184143;
        double protection_I = 0.09483903646469116;
        double dirty_48V_I = 0.2880900502204895;
        double dirty_24V_I = 0.06190735101699829;
        double clean_5_24V_I = 0.1931254267692566;
        double rebps_0 = 0.06668978929519653;
        double dirty_28V_I = 0.16006678342819214;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(heater_I, protection_I, dirty_48V_I, dirty_24V_I, clean_5_24V_I, rebps_0, dirty_28V_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0, (double)item_.getRebps_0(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_B_V = 0.27921462059020996;
        double otm_0_A_V = 0.8730942010879517;
        double otm_0_A_I = 0.8501834869384766;
        double otm_0_B_I = 0.3579018712043762;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_B_V, otm_0_A_V, otm_0_A_I, otm_0_B_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.8696876764297485;
        double main_T = 0.8626740574836731;
        double main_V = 0.8256478309631348;
        double main_I = 0.4204432964324951;
        double fpga_T = 0.3785746097564697;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, main_T, main_V, main_I, fpga_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.9558301568031311;
        double freeSpace = 0.07319802045822144;
        double freeFraction = 0.9752457141876221;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeSpace, freeFraction));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFp_RebTelemetry() throws Exception {
        double[] anaI = new double[]{0.3518139123916626, 0.9940738081932068, 0.7629812359809875};
        double[] anaV = new double[]{0.40967506170272827, 0.1955548f, 0.8188180327415466};
        double[] aspicl_Temp0 = new double[]{0.805572509765625, 0.0915299654006958, 0.5571169257164001};
        double[] aspicl_Temp1 = new double[]{0.5297868251800537, 0.1083616f, 0.8170342445373535};
        double[] aspicl_Temp2 = new double[]{0.39029455184936523, 0.03245729207992554, 0.0771544f};
        double[] aspicu_Temp0 = new double[]{0.6253944039344788, 0.7377392053604126, 0.3233994245529175};
        double[] aspicu_Temp1 = new double[]{0.10205626487731934, 0.7030717730522156, 0.3422772288322449};
        double[] aspicu_Temp2 = new double[]{0.20957303047180176, 0.623198390007019, 0.8787863850593567};
        double[] clkHI = new double[]{0.7579361200332642, 0.1715014f, 0.8883354067802429};
        double[] clkHV = new double[]{0.1439586877822876, 0.018800735473632812, 0.3617393970489502};
        double[] clkLI = new double[]{0.7972317337989807, 0.8253456950187683, 0.8163586854934692};
        double[] clkLV = new double[]{0.5457910299301147, 0.836626410484314, 0.980205774307251};
        double[] digI = new double[]{0.7885984182357788, 0.424838662147522, 0.3071276f};
        double[] digV = new double[]{0.4132169f, 0.01981222629547119, 0.7761707305908203};
        double[] htrV = new double[]{0.04545038938522339, 0.4529954791069031, 0.34995073080062866};
        double[] htrW = new double[]{0.2715141177177429, 0.07092666625976562, 0.4394496f};
        double[] hVBiasSwitch = new double[]{0.08574283123016357, 0.5146961808204651, 0.9062464237213135};
        String location = "";
        double[] oDI = new double[]{0.26001375913619995, 0.6229004263877869, 0.3141421675682068};
        double[] oDV = new double[]{0.9994347095489502, 0.5962113738059998, 0.6705964207649231};
        double[] pClkL = new double[]{0.38250982761383057, 0.3556661605834961, 0.7757212519645691};
        double[] pClkU = new double[]{0.14799284934997559, 0.01172637939453125, 0.9923641085624695};
        double[] power = new double[]{0.7778740525245667, 0.6481812596321106, 0.09424054622650146};
        double[] ref05V = new double[]{0.09243494272232056, 0.846501350402832, 0.6962411999702454};
        double[] ref125V = new double[]{0.9155762195587158, 0.6724908351898193, 0.7404934763908386};
        double[] ref15V = new double[]{0.6423062086105347, 0.3885188102722168, 0.8921326398849487};
        double[] ref25V = new double[]{0.13518112897872925, 0.047433435916900635, 0.7023965716362};
        double[] refN12 = new double[]{0.7760049104690552, 0.47076523303985596, 0.9501650929450989};
        double[] refP12 = new double[]{0.32409411668777466, 0.575740396976471, 0.885834813117981};
        double[] rGL = new double[]{0.7826586365699768, 0.22693806886672974, 0.3246299f};
        double[] rGU = new double[]{0.6487501859664917, 0.7435328364372253, 0.9011955857276917};
        double[] rTDTemp = new double[]{0.1350187063217163, 0.3059648871421814, 0.8811157941818237};
        double[] sClkL = new double[]{0.4720706343650818, 0.809583842754364, 0.530962f};
        double[] sClkU = new double[]{0.5121822357177734, 0.9273414015769958, 0.1259489f};
        double[] temp1 = new double[]{0.8852877020835876, 0.4297632575035095, 0.5498489141464233};
        double[] temp10 = new double[]{0.09333747625350952, 0.7271665930747986, 0.43705064058303833};
        double[] temp2 = new double[]{0.6257441639900208, 0.8445626497268677, 0.7345280647277832};
        double[] temp3 = new double[]{0.3962767720222473, 0.02667129f, 0.03164154291152954};
        double[] temp4 = new double[]{0.6872087717056274, 0.28083235025405884, 0.46498173475265503};
        double[] temp5 = new double[]{0.4443695f, 0.5950102210044861, 0.760514497756958};
        double[] temp6 = new double[]{0.920830249786377, 0.5145847201347351, 0.10968774557113647};
        double[] temp7 = new double[]{0.9940268993377686, 0.7169210910797119, 0.7415061593055725};
        double[] temp8 = new double[]{0.643465518951416, 0.4256610870361328, 0.9521958827972412};
        double[] temp9 = new double[]{0.3529811501502991, 0.2860618829727173, 0.12607192993164062};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, htrV, htrW, hVBiasSwitch, location, oDI, oDV, pClkL, pClkU, power, ref05V, ref125V, ref15V, ref25V, refN12, refP12, rGL, rGU, rTDTemp, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Fp_RebTelemetry));
        Fp_RebTelemetry item_ = (Fp_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFp_CcdTelemetry() throws Exception {
        double[] gDV = new double[]{0.9344543814659119, 0.571897f, 0.5963594913482666, 0.2374504804611206, 0.011470317840576172, 0.1951778f, 0.6017722487449646, 0.3040431f, 0.8814266324043274};
        String location = "";
        double[] oDV = new double[]{0.9041741490364075, 0.12834423780441284, 0.3603968024253845, 0.4494091868400574, 0.030228376388549805, 0.49550437927246094, 0.44420385360717773, 0.5723927617073059, 0.01846456527709961};
        double[] oGV = new double[]{0.8732677102088928, 0.7745010852813721, 0.008116722106933594, 0.4760128855705261, 0.507442831993103, 0.7076520323753357, 0.5258184671401978, 0.8131405711174011, 0.19448333978652954};
        double[] rDV = new double[]{0.6963885426521301, 0.42318958044052124, 0.250414f, 0.18982505798339844, 0.687866747379303, 0.09356868267059326, 0.2463078498840332, 0.9854075312614441, 0.48031747341156006};
        double[] temp = new double[]{0.06487125158309937, 0.7954068183898926, 0.11016291379928589, 0.17981386184692383, 0.8396306037902832, 0.26013612747192383, 0.23665273189544678, 0.9777112603187561, 0.7121177315711975};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_CcdTelemetry(gDV, location, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Fp_CcdTelemetry));
        Fp_CcdTelemetry item_ = (Fp_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFp_SegmentTelemetry() throws Exception {
        double[] i = new double[]{0.011460423469543457, 0.04457747936248779, 0.800111711025238, 0.24677908420562744, 0.7336034178733826, 0.8423047661781311, 0.038469672203063965, 0.9684793949127197, 0.19005513191223145, 0.4912036061286926, 0.5835068225860596, 0.6261651515960693, 0.026599586009979248, 0.8404200673103333, 0.9843844771385193, 0.8751201629638672, 0.6035534143447876, 0.553376317024231, 0.4261629581451416, 0.49712783098220825, 0.2837545871734619, 0.7989555597305298, 0.7486593127250671, 0.10137492418289185, 0.2630747f, 0.962894f, 0.2597065567970276, 0.27124422788619995, 0.20248931646347046, 0.9968196749687195, 0.16947948932647705, 0.1332862377166748, 0.2192828f, 0.7177543640136719, 0.08703964948654175, 0.5052968263626099, 0.4121708273887634, 0.7694599628448486, 0.8757721781730652, 0.9518499374389648, 0.05150198936462402, 0.7941092848777771, 0.9142528772354126, 0.9497514367103577, 0.9598853588104248, 0.8893787860870361, 0.309744f, 0.7952383756637573, 0.8673360347747803, 0.6587892174720764, 0.1725413203239441, 0.11250185966491699, 0.6532258987426758, 0.13419604301452637, 0.6934769153594971, 0.7330593466758728, 0.21797144412994385, 0.8565957546234131, 0.43984562158584595, 0.08205372095108032, 0.1716240644454956, 0.25835347175598145, 0.16580885648727417, 0.9457471966743469, 0.823606014251709, 0.7756658792495728, 0.14401185512542725, 0.9099817872047424, 0.9251385927200317, 0.4292819f, 0.8909226059913635, 0.7984728217124939, 0.8989483714103699, 0.8045603036880493, 0.4575839638710022, 0.9394100308418274, 0.6132451891899109, 0.8148303627967834, 0.6715084910392761, 0.026496827602386475, 0.17049521207809448, 0.4863317608833313, 0.778911828994751, 0.08442831039428711, 0.31605666875839233, 0.4159807562828064, 0.4870653748512268, 0.60768061876297, 0.3852988f, 0.947679877281189, 0.03508007526397705, 0.21477282047271729, 0.7365331053733826, 0.4273499846458435, 0.42184656858444214, 0.187908f, 0.22519594430923462, 0.8354001045227051, 0.5392314195632935, 0.4807614f, 0.9046261310577393, 0.3777068853378296, 0.6471555233001709, 0.24646002054214478, 0.06097674369812012, 0.2276879f, 0.28817933797836304, 0.625389575958252, 0.2529340386390686, 0.05370879f, 0.47913795709609985, 0.5409241914749146, 0.9077301025390625, 0.5044581890106201, 0.39577537775039673, 0.07365727424621582, 0.4783262610435486, 0.7422877550125122, 0.045916974544525146, 0.7550081610679626, 0.27561044692993164, 0.9586936831474304, 0.8233168721199036, 0.8636088967323303, 0.01512974500656128, 0.6405952572822571, 0.766857922077179, 0.687667727470398, 0.34952735900878906, 0.00993675f, 0.690349817276001, 0.28923535346984863, 0.26285213232040405, 0.3771381378173828, 0.6719495058059692, 0.7682473063468933, 0.07676881551742554, 0.24139052629470825, 0.2275436520576477, 0.4622993f, 0.9350489377975464, 0.4637170433998108, 0.5707303285598755, 0.15987098217010498};
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Fp_SegmentTelemetry));
        Fp_SegmentTelemetry item_ = (Fp_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFp_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.12369662523269653;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Fp_RebTotalPowerTelemetry));
        Fp_RebTotalPowerTelemetry item_ = (Fp_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }
}

