/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class FitsFilesWrittenEvent
extends CameraEvent {
    private final String imageName;
    private final double timeStampFilesWritten;
    private final String rootFileName;
    private final String relativeFileNames;
    private final String fileNode;

    public FitsFilesWrittenEvent(int priority, String imageName, double timeStampFilesWritten, String rootFileName, String relativeFileNames, String fileNode) {
        super(priority);
        this.imageName = imageName;
        this.timeStampFilesWritten = timeStampFilesWritten;
        this.rootFileName = rootFileName;
        this.relativeFileNames = relativeFileNames;
        this.fileNode = fileNode;
    }

    public String getImageName() {
        return this.imageName;
    }

    public double getTimeStampFilesWritten() {
        return this.timeStampFilesWritten;
    }

    public String getRootFileName() {
        return this.rootFileName;
    }

    public String getRelativeFileNames() {
        return this.relativeFileNames;
    }

    public String getFileNode() {
        return this.fileNode;
    }

    public String toString() {
        return "FitsFilesWrittenEvent{imageName=" + this.imageName + ", timeStampFilesWritten=" + this.timeStampFilesWritten + ", rootFileName=" + this.rootFileName + ", relativeFileNames=" + this.relativeFileNames + ", fileNode=" + this.fileNode + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int priority;
        private String imageName;
        private double timeStampFilesWritten;
        private String rootFileName;
        private String relativeFileNames;
        private String fileNode;

        private Builder() {
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public Builder timeStampFilesWritten(double timeStampFilesWritten) {
            this.timeStampFilesWritten = timeStampFilesWritten;
            return this;
        }

        public Builder rootFileName(String rootFileName) {
            this.rootFileName = rootFileName;
            return this;
        }

        public Builder relativeFileNames(String relativeFileNames) {
            this.relativeFileNames = relativeFileNames;
            return this;
        }

        public Builder fileNode(String fileNode) {
            this.fileNode = fileNode;
            return this;
        }

        public FitsFilesWrittenEvent build() {
            return new FitsFilesWrittenEvent(this.priority, this.imageName, this.timeStampFilesWritten, this.rootFileName, this.relativeFileNames, this.fileNode);
        }
    }
}

