/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.telemetry.BonnShutterTelemetry;
import org.lsst.sal.cccamera.telemetry.FilterChangerTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_R22Telemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebPSTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFilterChangerTelemetry() throws Exception {
        float motorTemperature = 0.80999666f;
        float motorEncoder = 0.87402326f;
        float linearPosition = 0.14178312f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FilterChangerTelemetry(motorTemperature, motorEncoder, linearPosition));
        Assert.assertTrue((boolean)(item instanceof FilterChangerTelemetry));
        FilterChangerTelemetry item_ = (FilterChangerTelemetry)item;
        Assert.assertEquals((float)motorTemperature, (float)item_.getMotorTemperature(), (float)1.0E-6f);
        Assert.assertEquals((float)motorEncoder, (float)item_.getMotorEncoder(), (float)1.0E-6f);
        Assert.assertEquals((float)linearPosition, (float)item_.getLinearPosition(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveBonnShutterTelemetry() throws Exception {
        float shutter5V = 0.17586815f;
        float shutter36V = 0.33828157f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new BonnShutterTelemetry(shutter5V, shutter36V));
        Assert.assertTrue((boolean)(item instanceof BonnShutterTelemetry));
        BonnShutterTelemetry item_ = (BonnShutterTelemetry)item;
        Assert.assertEquals((float)shutter5V, (float)item_.getShutter5V(), (float)1.0E-6f);
        Assert.assertEquals((float)shutter36V, (float)item_.getShutter36V(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_R22Telemetry() throws Exception {
        double reb1_analog_IbefLDO = 0.6187385320663452;
        double reb1_heater_IbefLDO = 0.545904278755188;
        double reb1_clockhi_VaftSwch = 0.40586984157562256;
        double reb2_clockhi_IaftLDO = 0.8204331398010254;
        double reb2_heater_IaftLDO = 0.4479323f;
        double reb2_digital_VaftLDO = 0.3169436454772949;
        double reb0_heater_VaftLDO = 0.07807135581970215;
        double reb1_digital_IaftLDO = 0.07647973299026489;
        double reb0_digital_IbefLDO = 0.44509416818618774;
        double reb0_Power = 0.45981645584106445;
        double reb2_OD_IaftLDO = 0.9981975555419922;
        double reb2_clocklo_IbefLDO = 0.17241257429122925;
        double reb1_digital_VbefLDO = 0.1978340744972229;
        double reb1_clockhi_IbefLDO = 0.17217093706130981;
        double reb2_heater_VbefLDO = 0.6790739297866821;
        double reb1_clocklo_VaftLDO = 0.10500502586364746;
        double reb0_analog_VaftLDO = 0.4812912344932556;
        double reb2_clocklo_VaftSwch = 0.6346797943115234;
        double reb2_analog_VbefLDO = 0.16317439079284668;
        double reb0_clockhi_VaftLDO = 0.47433704137802124;
        double reb2_hvbias_VbefSwch = 0.7452647686004639;
        double reb2_OD_VaftLDO2 = 0.5059914588928223;
        double reb1_OD_VaftLDO2 = 0.856564462184906;
        double reb0_clockhi_VbefLDO = 0.2917814254760742;
        double reb0_OD_VaftLDO2 = 0.8130668997764587;
        double reb2_analog_IaftLDO = 0.3917103409767151;
        double reb2_clocklo_IaftLDO = 0.19739621877670288;
        double reb0_analog_VaftSwch = 0.2953476905822754;
        double reb1_OD_IaftLDO = 0.004425227642059326;
        double reb1_clockhi_VaftLDO = 0.8903229236602783;
        double reb2_Power = 0.5085130333900452;
        double reb0_clocklo_VaftLDO2 = 0.04353010654449463;
        double reb2_clockhi_IbefLDO = 0.7548102736473083;
        double reb2_analog_IbefLDO = 0.3203164339065552;
        double reb0_heater_VaftSwch = 0.4175090789794922;
        double reb1_analog_IaftLDO = 0.1067974f;
        double reb0_digital_IaftLDO = 0.8453167080879211;
        double reb0_analog_VbefLDO = 0.13330018520355225;
        double reb0_analog_IbefLDO = 0.49629926681518555;
        double reb1_digital_IbefLDO = 0.6743577122688293;
        double reb1_heater_IaftLDO = 0.47228187322616577;
        double reb1_heater_VaftLDO = 0.0023023486137390137;
        double reb2_heater_IbefLDO = 0.3940557837486267;
        double reb1_clockhi_IaftLDO = 0.22270601987838745;
        double reb0_digital_VaftLDO = 0.48140984773635864;
        double reb0_OD_VaftSwch = 0.030275821685791016;
        double reb1_OD_VaftLDO = 0.4710425138473511;
        double reb1_OD_VaftSwch = 0.7597308158874512;
        double reb2_hvbias_IbefSwch = 0.3401355f;
        double reb2_clockhi_VbefLDO = 0.7920231819152832;
        double reb0_digital_VaftSwch = 0.4358493685722351;
        double reb0_OD_VaftLDO = 0.849946916103363;
        double reb0_OD_IaftLDO = 0.5127871036529541;
        double reb0_clocklo_VbefLDO = 0.5471908450126648;
        double reb2_OD_VaftSwch = 0.5348250865936279;
        double reb0_clocklo_IbefLDO = 0.756996214389801;
        double reb0_OD_VbefLDO = 0.2898898720741272;
        double reb1_clocklo_VaftSwch = 0.9397528767585754;
        double reb1_clockhi_VbefLDO = 0.6208028793334961;
        double reb2_clockhi_VaftSwch = 0.8012942671775818;
        double reb2_OD_VaftLDO = 0.2754226326942444;
        double reb1_OD_IbefLDO = 0.530706524848938;
        double reb0_analog_IaftLDO = 0.7597888112068176;
        double reb1_clocklo_IaftLDO = 0.4441121816635132;
        double reb1_hvbias_VbefSwch = 0.38934582471847534;
        double reb1_hvbias_IbefSwch = 0.24884724617004395;
        double reb1_analog_VbefLDO = 0.6310590505599976;
        double reb1_heater_VbefLDO = 0.7730971574783325;
        double reb2_clocklo_VaftLDO = 0.6482424736022949;
        double reb2_digital_IaftLDO = 0.1459333896636963;
        double reb2_clocklo_VbefLDO = 0.6906232833862305;
        double reb1_analog_VaftSwch = 0.4050159f;
        double reb2_clocklo_VaftLDO2 = 0.1610490083694458;
        double reb0_clockhi_IaftLDO = 0.016855478286743164;
        double reb1_analog_VaftLDO = 0.14342546463012695;
        double reb0_heater_VbefLDO = 0.3442254662513733;
        double reb1_heater_VaftSwch = 0.7518329620361328;
        double reb0_heater_IbefLDO = 0.5052889585494995;
        double reb1_digital_VaftSwch = 0.08975344896316528;
        double reb0_heater_IaftLDO = 0.8730581998825073;
        double reb2_digital_VbefLDO = 0.6952483654022217;
        double reb2_digital_IbefLDO = 0.22655218839645386;
        double reb0_clockhi_IbefLDO = 0.5505384802818298;
        double reb2_analog_VaftLDO = 0.014067888259887695;
        double reb1_Power = 0.03614205f;
        double reb0_hvbias_IbefSwch = 0.37096112966537476;
        double reb2_OD_IbefLDO = 0.3495739698410034;
        double reb1_OD_VbefLDO = 0.7331953048706055;
        double reb1_clocklo_IbefLDO = 0.44190144538879395;
        double reb1_clocklo_VbefLDO = 0.8249333500862122;
        double reb2_OD_VbefLDO = 0.3438388705253601;
        double reb1_digital_VaftLDO = 0.6647447347640991;
        double reb2_heater_VaftSwch = 0.09924596548080444;
        double reb0_OD_IbefLDO = 0.388649046421051;
        double reb0_hvbias_VbefSwch = 0.192366361618042;
        double reb2_heater_VaftLDO = 0.3791356682777405;
        double reb0_digital_VbefLDO = 0.6766318678855896;
        double reb2_digital_VaftSwch = 0.4565402865409851;
        double reb0_clocklo_VaftLDO = 0.5763600468635559;
        double reb0_clockhi_VaftSwch = 0.8063295483589172;
        double reb0_clocklo_IaftLDO = 0.20522820949554443;
        double reb2_analog_VaftSwch = 0.04169929027557373;
        double reb1_clocklo_VaftLDO2 = 0.5060730576515198;
        double reb2_clockhi_VaftLDO = 0.4233966f;
        double reb0_clocklo_VaftSwch = 0.02714228630065918;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_R22Telemetry(reb1_analog_IbefLDO, reb1_heater_IbefLDO, reb1_clockhi_VaftSwch, reb2_clockhi_IaftLDO, reb2_heater_IaftLDO, reb2_digital_VaftLDO, reb0_heater_VaftLDO, reb1_digital_IaftLDO, reb0_digital_IbefLDO, reb0_Power, reb2_OD_IaftLDO, reb2_clocklo_IbefLDO, reb1_digital_VbefLDO, reb1_clockhi_IbefLDO, reb2_heater_VbefLDO, reb1_clocklo_VaftLDO, reb0_analog_VaftLDO, reb2_clocklo_VaftSwch, reb2_analog_VbefLDO, reb0_clockhi_VaftLDO, reb2_hvbias_VbefSwch, reb2_OD_VaftLDO2, reb1_OD_VaftLDO2, reb0_clockhi_VbefLDO, reb0_OD_VaftLDO2, reb2_analog_IaftLDO, reb2_clocklo_IaftLDO, reb0_analog_VaftSwch, reb1_OD_IaftLDO, reb1_clockhi_VaftLDO, reb2_Power, reb0_clocklo_VaftLDO2, reb2_clockhi_IbefLDO, reb2_analog_IbefLDO, reb0_heater_VaftSwch, reb1_analog_IaftLDO, reb0_digital_IaftLDO, reb0_analog_VbefLDO, reb0_analog_IbefLDO, reb1_digital_IbefLDO, reb1_heater_IaftLDO, reb1_heater_VaftLDO, reb2_heater_IbefLDO, reb1_clockhi_IaftLDO, reb0_digital_VaftLDO, reb0_OD_VaftSwch, reb1_OD_VaftLDO, reb1_OD_VaftSwch, reb2_hvbias_IbefSwch, reb2_clockhi_VbefLDO, reb0_digital_VaftSwch, reb0_OD_VaftLDO, reb0_OD_IaftLDO, reb0_clocklo_VbefLDO, reb2_OD_VaftSwch, reb0_clocklo_IbefLDO, reb0_OD_VbefLDO, reb1_clocklo_VaftSwch, reb1_clockhi_VbefLDO, reb2_clockhi_VaftSwch, reb2_OD_VaftLDO, reb1_OD_IbefLDO, reb0_analog_IaftLDO, reb1_clocklo_IaftLDO, reb1_hvbias_VbefSwch, reb1_hvbias_IbefSwch, reb1_analog_VbefLDO, reb1_heater_VbefLDO, reb2_clocklo_VaftLDO, reb2_digital_IaftLDO, reb2_clocklo_VbefLDO, reb1_analog_VaftSwch, reb2_clocklo_VaftLDO2, reb0_clockhi_IaftLDO, reb1_analog_VaftLDO, reb0_heater_VbefLDO, reb1_heater_VaftSwch, reb0_heater_IbefLDO, reb1_digital_VaftSwch, reb0_heater_IaftLDO, reb2_digital_VbefLDO, reb2_digital_IbefLDO, reb0_clockhi_IbefLDO, reb2_analog_VaftLDO, reb1_Power, reb0_hvbias_IbefSwch, reb2_OD_IbefLDO, reb1_OD_VbefLDO, reb1_clocklo_IbefLDO, reb1_clocklo_VbefLDO, reb2_OD_VbefLDO, reb1_digital_VaftLDO, reb2_heater_VaftSwch, reb0_OD_IbefLDO, reb0_hvbias_VbefSwch, reb2_heater_VaftLDO, reb0_digital_VbefLDO, reb2_digital_VaftSwch, reb0_clocklo_VaftLDO, reb0_clockhi_VaftSwch, reb0_clocklo_IaftLDO, reb2_analog_VaftSwch, reb1_clocklo_VaftLDO2, reb2_clockhi_VaftLDO, reb0_clocklo_VaftSwch));
        Assert.assertTrue((boolean)(item instanceof Rebpower_R22Telemetry));
        Rebpower_R22Telemetry item_ = (Rebpower_R22Telemetry)item;
        Assert.assertEquals((double)reb1_analog_IbefLDO, (double)item_.getReb1_analog_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_IbefLDO, (double)item_.getReb1_heater_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_VaftSwch, (double)item_.getReb1_clockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_IaftLDO, (double)item_.getReb2_clockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_IaftLDO, (double)item_.getReb2_heater_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_VaftLDO, (double)item_.getReb2_digital_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_VaftLDO, (double)item_.getReb0_heater_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_IaftLDO, (double)item_.getReb1_digital_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_IbefLDO, (double)item_.getReb0_digital_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_Power, (double)item_.getReb0_Power(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_IaftLDO, (double)item_.getReb2_OD_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_IbefLDO, (double)item_.getReb2_clocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_VbefLDO, (double)item_.getReb1_digital_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_IbefLDO, (double)item_.getReb1_clockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_VbefLDO, (double)item_.getReb2_heater_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_VaftLDO, (double)item_.getReb1_clocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_VaftLDO, (double)item_.getReb0_analog_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_VaftSwch, (double)item_.getReb2_clocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_VbefLDO, (double)item_.getReb2_analog_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_VaftLDO, (double)item_.getReb0_clockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_hvbias_VbefSwch, (double)item_.getReb2_hvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_VaftLDO2, (double)item_.getReb2_OD_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_VaftLDO2, (double)item_.getReb1_OD_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_VbefLDO, (double)item_.getReb0_clockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_VaftLDO2, (double)item_.getReb0_OD_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_IaftLDO, (double)item_.getReb2_analog_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_IaftLDO, (double)item_.getReb2_clocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_VaftSwch, (double)item_.getReb0_analog_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_IaftLDO, (double)item_.getReb1_OD_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_VaftLDO, (double)item_.getReb1_clockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_Power, (double)item_.getReb2_Power(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_VaftLDO2, (double)item_.getReb0_clocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_IbefLDO, (double)item_.getReb2_clockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_IbefLDO, (double)item_.getReb2_analog_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_VaftSwch, (double)item_.getReb0_heater_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_analog_IaftLDO, (double)item_.getReb1_analog_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_IaftLDO, (double)item_.getReb0_digital_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_VbefLDO, (double)item_.getReb0_analog_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_IbefLDO, (double)item_.getReb0_analog_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_IbefLDO, (double)item_.getReb1_digital_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_IaftLDO, (double)item_.getReb1_heater_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_VaftLDO, (double)item_.getReb1_heater_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_IbefLDO, (double)item_.getReb2_heater_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_IaftLDO, (double)item_.getReb1_clockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_VaftLDO, (double)item_.getReb0_digital_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_VaftSwch, (double)item_.getReb0_OD_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_VaftLDO, (double)item_.getReb1_OD_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_VaftSwch, (double)item_.getReb1_OD_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_hvbias_IbefSwch, (double)item_.getReb2_hvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_VbefLDO, (double)item_.getReb2_clockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_VaftSwch, (double)item_.getReb0_digital_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_VaftLDO, (double)item_.getReb0_OD_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_IaftLDO, (double)item_.getReb0_OD_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_VbefLDO, (double)item_.getReb0_clocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_VaftSwch, (double)item_.getReb2_OD_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_IbefLDO, (double)item_.getReb0_clocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_VbefLDO, (double)item_.getReb0_OD_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_VaftSwch, (double)item_.getReb1_clocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_VbefLDO, (double)item_.getReb1_clockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_VaftSwch, (double)item_.getReb2_clockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_VaftLDO, (double)item_.getReb2_OD_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_IbefLDO, (double)item_.getReb1_OD_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_IaftLDO, (double)item_.getReb0_analog_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_IaftLDO, (double)item_.getReb1_clocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_hvbias_VbefSwch, (double)item_.getReb1_hvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_hvbias_IbefSwch, (double)item_.getReb1_hvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_analog_VbefLDO, (double)item_.getReb1_analog_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_VbefLDO, (double)item_.getReb1_heater_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_VaftLDO, (double)item_.getReb2_clocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_IaftLDO, (double)item_.getReb2_digital_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_VbefLDO, (double)item_.getReb2_clocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_analog_VaftSwch, (double)item_.getReb1_analog_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_VaftLDO2, (double)item_.getReb2_clocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_IaftLDO, (double)item_.getReb0_clockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_analog_VaftLDO, (double)item_.getReb1_analog_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_VbefLDO, (double)item_.getReb0_heater_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_VaftSwch, (double)item_.getReb1_heater_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_IbefLDO, (double)item_.getReb0_heater_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_VaftSwch, (double)item_.getReb1_digital_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_IaftLDO, (double)item_.getReb0_heater_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_VbefLDO, (double)item_.getReb2_digital_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_IbefLDO, (double)item_.getReb2_digital_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_IbefLDO, (double)item_.getReb0_clockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_VaftLDO, (double)item_.getReb2_analog_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_Power, (double)item_.getReb1_Power(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_hvbias_IbefSwch, (double)item_.getReb0_hvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_IbefLDO, (double)item_.getReb2_OD_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_VbefLDO, (double)item_.getReb1_OD_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_IbefLDO, (double)item_.getReb1_clocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_VbefLDO, (double)item_.getReb1_clocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_VbefLDO, (double)item_.getReb2_OD_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_VaftLDO, (double)item_.getReb1_digital_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_VaftSwch, (double)item_.getReb2_heater_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_IbefLDO, (double)item_.getReb0_OD_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_hvbias_VbefSwch, (double)item_.getReb0_hvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_VaftLDO, (double)item_.getReb2_heater_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_VbefLDO, (double)item_.getReb0_digital_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_VaftSwch, (double)item_.getReb2_digital_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_VaftLDO, (double)item_.getReb0_clocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_VaftSwch, (double)item_.getReb0_clockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_IaftLDO, (double)item_.getReb0_clocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_VaftSwch, (double)item_.getReb2_analog_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_VaftLDO2, (double)item_.getReb1_clocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_VaftLDO, (double)item_.getReb2_clockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_VaftSwch, (double)item_.getReb0_clocklo_VaftSwch(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebPSTelemetry() throws Exception {
        double p00_BoardTemp2 = 0.20204466581344604;
        double p00_BoardTemp3 = 0.4414917230606079;
        double p00_BoardTemp4 = 0.8437589406967163;
        double p00_BoardTemp5 = 0.8764467239379883;
        double p00_BoardTemp0 = 0.4024495482444763;
        double p00_BoardTemp1 = 0.42289382219314575;
        double p00_BoardTemp6 = 0.9662340879440308;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebPSTelemetry(p00_BoardTemp2, p00_BoardTemp3, p00_BoardTemp4, p00_BoardTemp5, p00_BoardTemp0, p00_BoardTemp1, p00_BoardTemp6));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebPSTelemetry));
        Rebpower_RebPSTelemetry item_ = (Rebpower_RebPSTelemetry)item;
        Assert.assertEquals((double)p00_BoardTemp2, (double)item_.getP00_BoardTemp2(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp3, (double)item_.getP00_BoardTemp3(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp4, (double)item_.getP00_BoardTemp4(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp5, (double)item_.getP00_BoardTemp5(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp0, (double)item_.getP00_BoardTemp0(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp1, (double)item_.getP00_BoardTemp1(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp6, (double)item_.getP00_BoardTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VQMonitorTelemetry() throws Exception {
        double vqmpressure = 0.11944049596786499;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_VQMonitorTelemetry(vqmpressure));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitorTelemetry));
        Vacuum_VQMonitorTelemetry item_ = (Vacuum_VQMonitorTelemetry)item;
        Assert.assertEquals((double)vqmpressure, (double)item_.getVqmpressure(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumpsTelemetry() throws Exception {
        double ionpump_voltage = 0.7138491868972778;
        double ionpump_current = 0.15329605340957642;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_IonPumpsTelemetry(ionpump_voltage, ionpump_current));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumpsTelemetry));
        Vacuum_IonPumpsTelemetry item_ = (Vacuum_IonPumpsTelemetry)item;
        Assert.assertEquals((double)ionpump_voltage, (double)item_.getIonpump_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)ionpump_current, (double)item_.getIonpump_current(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboTelemetry() throws Exception {
        double rpm = 0.3902401328086853;
        double power = 0.1239391f;
        double voltage = 0.8015385270118713;
        double turboSpeed = 0.03770667314529419;
        double pumpTemperature = 0.2436668872833252;
        double status = 0.35733717679977417;
        double cntrlrSinkTemperature = 0.6375284790992737;
        double driveFrequency = 0.9946182370185852;
        double current = 0.3443509340286255;
        double cntrlrAirTemperature = 0.8494451642036438;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboTelemetry(rpm, power, voltage, turboSpeed, pumpTemperature, status, cntrlrSinkTemperature, driveFrequency, current, cntrlrAirTemperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboTelemetry));
        Vacuum_TurboTelemetry item_ = (Vacuum_TurboTelemetry)item;
        Assert.assertEquals((double)rpm, (double)item_.getRpm(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpTemperature, (double)item_.getPumpTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)status, (double)item_.getStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrSinkTemperature, (double)item_.getCntrlrSinkTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)driveFrequency, (double)item_.getDriveFrequency(), (double)1.0E-6f);
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrAirTemperature, (double)item_.getCntrlrAirTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double rejectTemperature = 0.7361348271369934;
        double autoOffEnabled = 0.4846060276031494;
        double power = 0.9953231811523438;
        double setPower = 0.08402401208877563;
        double temperature = 0.3612545132637024;
        double autoOnTemperature = 0.6111468076705933;
        double setpoint = 0.046657443046569824;
        double autoOffTemperature = 0.7034997344017029;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(rejectTemperature, autoOffEnabled, power, setPower, temperature, autoOnTemperature, setpoint, autoOffTemperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2Telemetry() throws Exception {
        double temperature = 0.6944841146469116;
        double rejectTemperature = 0.4423891305923462;
        double autoOnTemperature = 0.8195973038673401;
        double setpoint = 0.8911446928977966;
        double power = 0.9449220299720764;
        double autoOffEnabled = 0.3727429509162903;
        double autoOffTemperature = 0.3365599f;
        double setPower = 0.2162773609161377;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold2Telemetry(temperature, rejectTemperature, autoOnTemperature, setpoint, power, autoOffEnabled, autoOffTemperature, setPower));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2Telemetry));
        Vacuum_Cold2Telemetry item_ = (Vacuum_Cold2Telemetry)item;
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold1Telemetry() throws Exception {
        double setPower = 0.08686792850494385;
        double power = 0.5236115455627441;
        double rejectTemperature = 0.11660957336425781;
        double autoOnTemperature = 0.6386212110519409;
        double autoOffTemperature = 0.5465096235275269;
        double temperature = 0.8977733850479126;
        double autoOffEnabled = 0.7412078380584717;
        double setpoint = 0.33134692907333374;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold1Telemetry(setPower, power, rejectTemperature, autoOnTemperature, autoOffTemperature, temperature, autoOffEnabled, setpoint));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1Telemetry));
        Vacuum_Cold1Telemetry item_ = (Vacuum_Cold1Telemetry)item;
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double bpu_Maq20_I = 0.14201372861862183;
        double ion_Pumps_I = 0.4168702960014343;
        double fpga_T = 0.9587225317955017;
        double bpu_Maq20_V = 0.8275997042655945;
        double fes_Shu_HCU_I = 0.7852810621261597;
        double board_T = 0.6418435573577881;
        double body_Purge_V = 0.3457095f;
        double pwr_Cry_HCU_V = 0.5672187209129333;
        double pwr_Cry_HCU_I = 0.45319098234176636;
        double body_Purge_I = 0.09826427698135376;
        double fes_Shu_HCU_V = 0.37387335300445557;
        double gauges_V = 0.3292325735092163;
        double main_T = 0.2597543001174927;
        double main_V = 0.7892430424690247;
        double ion_Pumps_V = 0.11749368906021118;
        double main_I = 0.9075458645820618;
        double gauges_I = 0.839673f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(bpu_Maq20_I, ion_Pumps_I, fpga_T, bpu_Maq20_V, fes_Shu_HCU_I, board_T, body_Purge_V, pwr_Cry_HCU_V, pwr_Cry_HCU_I, body_Purge_I, fes_Shu_HCU_V, gauges_V, main_T, main_V, ion_Pumps_V, main_I, gauges_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.905518651008606;
        double fpga_T = 0.07874f;
        double cryo_Turbo_I = 0.1136139f;
        double main_V = 0.8729338049888611;
        double main_T = 0.5535796880722046;
        double cryo_Turbo_V = 0.587564f;
        double main_I = 0.17806684970855713;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, fpga_T, cryo_Turbo_I, main_V, main_T, cryo_Turbo_V, main_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double heater_I = 0.32693952322006226;
        double protection_I = 0.7770497798919678;
        double dirty_48V_I = 0.6567665934562683;
        double dirty_24V_I = 0.5460378527641296;
        double clean_5_24V_I = 0.7081224322319031;
        double rebps_0 = 0.3934918f;
        double dirty_28V_I = 0.8275190591812134;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(heater_I, protection_I, dirty_48V_I, dirty_24V_I, clean_5_24V_I, rebps_0, dirty_28V_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0, (double)item_.getRebps_0(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_B_V = 0.10685265064239502;
        double otm_0_A_V = 0.3429415225982666;
        double otm_0_A_I = 0.4982871413230896;
        double otm_0_B_I = 0.5403322577476501;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_B_V, otm_0_A_V, otm_0_A_I, otm_0_B_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.02185011f;
        double main_T = 0.9457008838653564;
        double main_V = 0.5799921751022339;
        double main_I = 0.6035947203636169;
        double fpga_T = 0.4841491f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, main_T, main_V, main_I, fpga_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
    }
}

