/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.CCSConfiguredEvent;
import org.lsst.sal.camera.event.EndInitializeGuiderEvent;
import org.lsst.sal.camera.event.EndInitializeImageEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.event.FileCommandExecutionEvent;
import org.lsst.sal.cccamera.event.FitsFilesWrittenEvent;
import org.lsst.sal.cccamera.event.FocalPlaneDAQSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FocalPlaneHardwareIdSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FocalPlaneRaftTempControlSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FocalPlaneRaftTempControlStatusSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FocalPlaneSequencerSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.cccamera.event.ImageStoredEvent;
import org.lsst.sal.cccamera.event.ImageVisualizationEvent;
import org.lsst.sal.cccamera.event.ShutterBladeMotionProfileEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 899;
        String imageType = "";
        String groupId = "e";
        String additionalKeys = "";
        String additionalValues = "j";
        int imagesInSequence = 902;
        String imageName = "lpkystpmanw";
        int imageIndex = 564;
        String imageSource = "n";
        String imageController = "d";
        String imageDate = "sqfvxu";
        int imageNumber = 782;
        double timeStampAcquisitionStart = 0.3559340238571167;
        double requestedExposureTime = 0.24237751960754395;
        double timeStampEndOfReadout = 0.9880634546279907;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, imageType, groupId, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, requestedExposureTime, timeStampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timeStampEndOfReadout, (double)item_.getTimeStampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 456;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws Exception {
        int priority = 418;
        String filterName = "";
        String filterType = "";
        SALEvent item = this.testSendReceive((SALEvent)new StartSetFilterEvent(priority, filterName, filterType));
        Assert.assertTrue((boolean)(item instanceof StartSetFilterEvent));
        StartSetFilterEvent item_ = (StartSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws Exception {
        int priority = 168;
        SALEvent item = this.testSendReceive((SALEvent)new StartUnloadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent item_ = (StartUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 30;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 83;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndInitializeGuiderEvent() throws Exception {
        int priority = 996;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeGuiderEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndInitializeGuiderEvent));
        EndInitializeGuiderEvent item_ = (EndInitializeGuiderEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 89;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 767;
        String imageType = "x";
        String groupId = "";
        String additionalKeys = "u";
        String additionalValues = "";
        int imagesInSequence = 899;
        String imageName = "moaezfanauhnnootuhjusprpml";
        int imageIndex = 487;
        String imageSource = "";
        String imageController = "t";
        String imageDate = "";
        int imageNumber = 798;
        double timeStampAcquisitionStart = 0.6404802799224854;
        double exposureTime = 0.8353633284568787;
        String imageTag = "ageunvdyvuwxmpzbhnnlfaodrmazjfkyewrpjmw";
        double timestampDateObs = 0.9196158051490784;
        double timestampDateEnd = 0.8115205764770508;
        double measuredShutterOpenTime = 0.5131617784500122;
        double darkTime = 0.4400886297225952;
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, imageType, groupId, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws Exception {
        int priority = 968;
        SALEvent item = this.testSendReceive((SALEvent)new EndUnloadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent item_ = (EndUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws Exception {
        int priority = 150;
        SALEvent item = this.testSendReceive((SALEvent)new EndRotateCarouselEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent item_ = (EndRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws Exception {
        int priority = 453;
        SALEvent item = this.testSendReceive((SALEvent)new StartLoadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartLoadFilterEvent));
        StartLoadFilterEvent item_ = (StartLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 362;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 744;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveCCSConfiguredEvent() throws Exception {
        int priority = 988;
        SALEvent item = this.testSendReceive((SALEvent)new CCSConfiguredEvent(priority));
        Assert.assertTrue((boolean)(item instanceof CCSConfiguredEvent));
        CCSConfiguredEvent item_ = (CCSConfiguredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws Exception {
        int priority = 776;
        SALEvent item = this.testSendReceive((SALEvent)new EndLoadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndLoadFilterEvent));
        EndLoadFilterEvent item_ = (EndLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 665;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 236;
        String imageType = "";
        String groupId = "m";
        String additionalKeys = "p";
        String additionalValues = "";
        int imagesInSequence = 509;
        String imageName = "jhymuggilkxlhgpseuuibuyrl";
        int imageIndex = 604;
        String imageSource = "";
        String imageController = "";
        String imageDate = "z";
        int imageNumber = 798;
        double timeStampAcquisitionStart = 0.8901541829109192;
        double exposureTime = 0.5602242946624756;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, imageType, groupId, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeImageEvent() throws Exception {
        int priority = 908;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndInitializeImageEvent));
        EndInitializeImageEvent item_ = (EndInitializeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws Exception {
        int priority = 396;
        String filterName = "";
        String filterType = "";
        int filterSlot = 753;
        double filterPosition = 0.7246916890144348;
        SALEvent item = this.testSendReceive((SALEvent)new EndSetFilterEvent(priority, filterName, filterType, filterSlot, filterPosition));
        Assert.assertTrue((boolean)(item instanceof EndSetFilterEvent));
        EndSetFilterEvent item_ = (EndSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
        Assert.assertEquals((long)filterSlot, (long)item_.getFilterSlot());
        Assert.assertEquals((double)filterPosition, (double)item_.getFilterPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 280;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws Exception {
        int priority = 320;
        String filterNames = "nuioaorfjzvnqofqitxyuovvualrabkzcmdpadrmgbelsctwtzrcarsgmdvjvekeuiuydtesolnhtnyevpdyypbtxoocfivmsgrsfuvgtpclhgfkkmzaxdlilkirgkocdikkw";
        SALEvent item = this.testSendReceive((SALEvent)new AvailableFiltersEvent(priority, filterNames));
        Assert.assertTrue((boolean)(item instanceof AvailableFiltersEvent));
        AvailableFiltersEvent item_ = (AvailableFiltersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 305;
        String imageType = "r";
        String groupId = "t";
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 444;
        String imageName = "dkupplkollcj";
        int imageIndex = 751;
        String imageSource = "";
        String imageController = "m";
        String imageDate = "wl";
        int imageNumber = 704;
        double timeStampAcquisitionStart = 0.10950464010238647;
        double exposureTime = 0.5500080585479736;
        double timeStampStartOfReadout = 0.8885334730148315;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, imageType, groupId, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, timeStampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timeStampStartOfReadout, (double)item_.getTimeStampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws Exception {
        int priority = 268;
        SALEvent item = this.testSendReceive((SALEvent)new StartRotateCarouselEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent item_ = (StartRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 923;
        String imageName = "";
        String ccdLocation = "e";
        String raftBay = "";
        String ccdSlot = "l";
        Object[] ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V};
        int[] overRows = new int[]{108, 197, 853, 73, 879, 412, 762, 705, 160};
        int[] overCols = new int[]{322, 972, 539, 15, 712, 67, 521, 647, 101};
        int[] readRows = new int[]{759, 984, 923, 822, 293, 987, 309, 173, 677};
        int[] readCols = new int[]{483, 137, 444, 904, 584, 225, 670, 384, 6};
        int[] readCols2 = new int[]{594, 571, 735, 566, 251, 470, 457, 24, 485};
        int[] preCols = new int[]{269, 358, 202, 222, 373, 223, 984, 664, 471};
        int[] preRows = new int[]{674, 872, 302, 162, 785, 184, 551, 326, 36};
        int[] postCols = new int[]{190, 971, 170, 743, 788, 434, 291, 638, 127};
        int[] underCols = new int[]{852, 378, 652, 186, 947, 281, 691, 84, 12};
        String daqFolder = "o";
        String daqAnnotation = "b";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, ccdLocation, raftBay, ccdSlot, (ImageReadoutParametersEvent.CcdType[])ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((int[])overRows, (int[])item_.getOverRows());
        Assert.assertArrayEquals((int[])overCols, (int[])item_.getOverCols());
        Assert.assertArrayEquals((int[])readRows, (int[])item_.getReadRows());
        Assert.assertArrayEquals((int[])readCols, (int[])item_.getReadCols());
        Assert.assertArrayEquals((int[])readCols2, (int[])item_.getReadCols2());
        Assert.assertArrayEquals((int[])preCols, (int[])item_.getPreCols());
        Assert.assertArrayEquals((int[])preRows, (int[])item_.getPreRows());
        Assert.assertArrayEquals((int[])postCols, (int[])item_.getPostCols());
        Assert.assertArrayEquals((int[])underCols, (int[])item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        int priority = 275;
        String ccdLocation = "a";
        String raftBay = "";
        String ccdSlot = "q";
        String rebSerialNumber = "w";
        String rebLSSTName = "w";
        String ccdLSSTName = "";
        String raftLSSTName = "r";
        String ccdManSerNum = "y";
        String ccdManufacturer = "z";
        Object[] ccdType = new FocalPlaneSummaryInfoEvent.CcdType[]{FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL};
        double[] ccdTempSetPoint = new double[]{0.01287013292312622, 0.0018898248672485352, 0.13100403547286987, 0.5621614456176758, 0.348626971244812, 0.2438182234764099, 0.0923229455947876, 0.8818138241767883, 0.5860308408737183};
        String sequencerKey = "b";
        String sequencerChecksum = "";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(priority, ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, (FocalPlaneSummaryInfoEvent.CcdType[])ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((double[])ccdTempSetPoint, (double[])item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveFocalPlaneHardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 711;
        int version = 529;
        String rebLocation = "";
        String rebLSSTName = "w";
        String ccdLocation = "v";
        String ccdLSSTName = "";
        String ccdManSerNum = "";
        String raftLocation = "";
        String raftLSSTName = "c";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneHardwareIdSettingsAppliedEvent(priority, version, rebLocation, rebLSSTName, ccdLocation, ccdLSSTName, ccdManSerNum, raftLocation, raftLSSTName));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneHardwareIdSettingsAppliedEvent));
        FocalPlaneHardwareIdSettingsAppliedEvent item_ = (FocalPlaneHardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)rebLocation, (Object)item_.getRebLocation());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)raftLocation, (Object)item_.getRaftLocation());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
    }

    @Test
    public void sendReceiveFocalPlaneRaftTempControlStatusSettingsAppliedEvent() throws Exception {
        int priority = 611;
        int version = 786;
        String raftLocation = "";
        boolean raft_TempControl_active = true;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneRaftTempControlStatusSettingsAppliedEvent(priority, version, raftLocation, raft_TempControl_active));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneRaftTempControlStatusSettingsAppliedEvent));
        FocalPlaneRaftTempControlStatusSettingsAppliedEvent item_ = (FocalPlaneRaftTempControlStatusSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)raftLocation, (Object)item_.getRaftLocation());
        Assert.assertEquals((Object)raft_TempControl_active, (Object)item_.isRaft_TempControl_active());
    }

    @Test
    public void sendReceiveFocalPlaneRaftTempControlSettingsAppliedEvent() throws Exception {
        int priority = 330;
        int version = 891;
        String raftLocation = "f";
        double raft_TempControl_awGain = 0.4515455961227417;
        double raft_TempControl_basePower = 0.786760687828064;
        double raft_TempControl_gain = 0.11390924453735352;
        double raft_TempControl_maxInput = 0.27820414304733276;
        double raft_TempControl_maxOutput = 0.8154560327529907;
        double raft_TempControl_minInput = 0.8078804016113281;
        double raft_TempControl_minOutput = 0.01894927f;
        String raft_TempControl_rebs = "";
        double raft_TempControl_setTemp = 0.9307073354721069;
        double raft_TempControl_smoothTime = 0.974181592464447;
        String raft_TempControl_tempChans = "";
        double raft_TempControl_timeConst = 0.9204593300819397;
        double raft_TempControl_tolerance = 0.844366192817688;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneRaftTempControlSettingsAppliedEvent(priority, version, raftLocation, raft_TempControl_awGain, raft_TempControl_basePower, raft_TempControl_gain, raft_TempControl_maxInput, raft_TempControl_maxOutput, raft_TempControl_minInput, raft_TempControl_minOutput, raft_TempControl_rebs, raft_TempControl_setTemp, raft_TempControl_smoothTime, raft_TempControl_tempChans, raft_TempControl_timeConst, raft_TempControl_tolerance));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneRaftTempControlSettingsAppliedEvent));
        FocalPlaneRaftTempControlSettingsAppliedEvent item_ = (FocalPlaneRaftTempControlSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)raftLocation, (Object)item_.getRaftLocation());
        Assert.assertEquals((double)raft_TempControl_awGain, (double)item_.getRaft_TempControl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_basePower, (double)item_.getRaft_TempControl_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_gain, (double)item_.getRaft_TempControl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_maxInput, (double)item_.getRaft_TempControl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_maxOutput, (double)item_.getRaft_TempControl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_minInput, (double)item_.getRaft_TempControl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_minOutput, (double)item_.getRaft_TempControl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)raft_TempControl_rebs, (Object)item_.getRaft_TempControl_rebs());
        Assert.assertEquals((double)raft_TempControl_setTemp, (double)item_.getRaft_TempControl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_smoothTime, (double)item_.getRaft_TempControl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)raft_TempControl_tempChans, (Object)item_.getRaft_TempControl_tempChans());
        Assert.assertEquals((double)raft_TempControl_timeConst, (double)item_.getRaft_TempControl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_tolerance, (double)item_.getRaft_TempControl_tolerance(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocalPlaneDAQSettingsAppliedEvent() throws Exception {
        int priority = 630;
        int version = 46;
        String sequencerconfig_daqFolder = "z";
        boolean sequencerconfig_emulatedDAQ = false;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneDAQSettingsAppliedEvent(priority, version, sequencerconfig_daqFolder, sequencerconfig_emulatedDAQ));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneDAQSettingsAppliedEvent));
        FocalPlaneDAQSettingsAppliedEvent item_ = (FocalPlaneDAQSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)sequencerconfig_daqFolder, (Object)item_.getSequencerconfig_daqFolder());
        Assert.assertEquals((Object)sequencerconfig_emulatedDAQ, (Object)item_.isSequencerconfig_emulatedDAQ());
    }

    @Test
    public void sendReceiveFocalPlaneSequencerSettingsAppliedEvent() throws Exception {
        int priority = 968;
        int version = 480;
        String sequencerconfig_metaDataRegisters = "a";
        int sequencerconfig_overCols = 596;
        int sequencerconfig_overRows = 121;
        int sequencerconfig_postCols = 535;
        int sequencerconfig_postRows = 591;
        int sequencerconfig_preCols = 309;
        int sequencerconfig_preRows = 439;
        int sequencerconfig_readCols = 528;
        int sequencerconfig_readCols2 = 726;
        int sequencerconfig_readRows = 458;
        boolean sequencerconfig_scanMode = false;
        String sequencerconfig_sequencer = "v";
        int sequencerconfig_underCols = 78;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSequencerSettingsAppliedEvent(priority, version, sequencerconfig_metaDataRegisters, sequencerconfig_overCols, sequencerconfig_overRows, sequencerconfig_postCols, sequencerconfig_postRows, sequencerconfig_preCols, sequencerconfig_preRows, sequencerconfig_readCols, sequencerconfig_readCols2, sequencerconfig_readRows, sequencerconfig_scanMode, sequencerconfig_sequencer, sequencerconfig_underCols));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSequencerSettingsAppliedEvent));
        FocalPlaneSequencerSettingsAppliedEvent item_ = (FocalPlaneSequencerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)sequencerconfig_metaDataRegisters, (Object)item_.getSequencerconfig_metaDataRegisters());
        Assert.assertEquals((long)sequencerconfig_overCols, (long)item_.getSequencerconfig_overCols());
        Assert.assertEquals((long)sequencerconfig_overRows, (long)item_.getSequencerconfig_overRows());
        Assert.assertEquals((long)sequencerconfig_postCols, (long)item_.getSequencerconfig_postCols());
        Assert.assertEquals((long)sequencerconfig_postRows, (long)item_.getSequencerconfig_postRows());
        Assert.assertEquals((long)sequencerconfig_preCols, (long)item_.getSequencerconfig_preCols());
        Assert.assertEquals((long)sequencerconfig_preRows, (long)item_.getSequencerconfig_preRows());
        Assert.assertEquals((long)sequencerconfig_readCols, (long)item_.getSequencerconfig_readCols());
        Assert.assertEquals((long)sequencerconfig_readCols2, (long)item_.getSequencerconfig_readCols2());
        Assert.assertEquals((long)sequencerconfig_readRows, (long)item_.getSequencerconfig_readRows());
        Assert.assertEquals((Object)sequencerconfig_scanMode, (Object)item_.isSequencerconfig_scanMode());
        Assert.assertEquals((Object)sequencerconfig_sequencer, (Object)item_.getSequencerconfig_sequencer());
        Assert.assertEquals((long)sequencerconfig_underCols, (long)item_.getSequencerconfig_underCols());
    }

    @Test
    public void sendReceiveShutterBladeMotionProfileEvent() throws Exception {
        int priority = 300;
        ShutterBladeMotionProfileEvent.Blade blade = ShutterBladeMotionProfileEvent.Blade.MINUS_X;
        ShutterBladeMotionProfileEvent.Direction direction = ShutterBladeMotionProfileEvent.Direction.CLOSE;
        double timestampStart = 0.5766582489013672;
        double startPosition = 0.3993929f;
        double targetDuration = 0.9301658272743225;
        double targetPosition = 0.380687f;
        double endPosition = 0.5195137858390808;
        double actualDuration = 0.4002823829650879;
        int hallSensorCount = 254;
        double[] timestampHallSensor = new double[]{0.8927491903305054, 0.6827614307403564, 0.16119670867919922, 0.9963732957839966, 0.07531487941741943, 0.2367112f, 0.6531934142112732, 0.3906674385070801, 0.2345457673072815, 0.482200026512146, 0.2835758328437805, 0.8459919691085815, 0.2846637964248657, 0.5211543440818787, 0.7494170665740967, 0.29583287239074707, 0.25458717346191406, 0.2159196138381958, 0.07165837287902832, 0.53737473487854, 0.3688596487045288, 0.7609010338783264, 0.2154766321182251, 0.4796936511993408, 0.380581796169281, 0.8659494519233704, 0.8885037302970886, 0.4119594097137451, 0.2212618f, 0.7315186858177185, 0.02538210153579712, 0.5617164969444275, 0.5828642249107361, 0.05298245f, 0.17073094844818115, 0.08198577165603638, 0.10556250810623169, 0.300825834274292, 0.15915173292160034, 0.4622097f, 0.021161377429962158, 0.5130382180213928, 0.7473477721214294, 0.6755883693695068, 0.5228105187416077, 0.037378907203674316, 0.9072979688644409, 0.9558776617050171, 0.688093900680542, 0.7588313817977905, 0.4588811993598938, 0.3201286196708679, 0.3820696473121643, 0.7292030453681946, 0.36418086290359497, 0.02814584970474243, 0.382207453250885, 0.12228578329086304, 0.973324716091156, 0.38076627254486084, 0.6869021058082581, 0.6132139563560486, 0.5931679606437683, 0.22166311740875244, 0.04742974042892456, 0.6217074990272522, 0.1260806918144226, 0.41364985704421997, 0.6695913672447205, 0.06597131490707397, 0.01783144474029541, 0.4308992028236389, 0.5011999607086182, 4.4840574264526367E-4, 0.07299137115478516, 0.14174103736877441, 0.8059961199760437, 0.6128490567207336, 0.6959515810012817, 0.2795097231864929, 0.8401201963424683, 0.8434627056121826, 0.03871506452560425, 0.01616931f, 0.42615455389022827, 0.3754054307937622, 0.2668830156326294, 0.29815244674682617, 0.3598290681838989, 0.8939803838729858, 0.4671194553375244, 0.08714598417282104, 0.6992331743240356, 0.4956783652305603, 0.5278825759887695, 0.6096928715705872, 0.6548991799354553, 0.564589f, 0.9360262751579285, 0.9758511185646057, 0.6161421537399292, 0.6513291001319885, 0.7912827730178833, 0.7242476940155029, 0.674912691116333, 0.16533923149108887, 0.2855575f, 0.7123373746871948, 0.2191150188446045, 0.5070011615753174, 0.40193772315979004, 0.3482709527015686, 0.90446937084198, 0.5560566782951355, 0.02749556303024292, 0.08437883853912354, 0.7347772717475891, 0.8349572420120239, 0.05315440893173218, 0.8198965191841125, 0.5077343583106995, 0.7708647847175598, 0.2524857521057129, 0.9283267855644226, 0.4557059407234192, 0.08200287818908691, 0.8293628096580505, 0.8970068693161011, 0.2322337031364441, 0.659993f, 0.9325717687606812, 0.4854145050048828, 0.18520653247833252, 0.35989898443222046, 0.22506767511367798, 0.14500826597213745, 0.10195744037628174, 0.7472650408744812, 0.7284701466560364, 0.5455885529518127, 0.8110129237174988, 0.19291293621063232, 0.7421621084213257, 0.09804767370223999, 0.4464316964149475, 0.3112324f, 0.15415281057357788, 0.6058251857757568, 0.10584050416946411, 0.8688523173332214, 0.05147433280944824, 0.7004167437553406, 0.6102726459503174, 0.16373854875564575, 0.2257222f, 0.6810241937637329, 0.1661999225616455, 0.9088693857192993, 0.11945706605911255, 0.2741441f, 0.766837f, 0.7217692732810974, 0.5272254347801208, 0.7229553461074829, 0.9956062436103821, 0.9965223670005798, 0.14721661806106567, 0.4042872190475464, 0.6199347376823425, 0.746765673160553, 0.9629706144332886, 0.8263643383979797, 0.6142929196357727, 0.6880226731300354, 0.6466214656829834, 0.6851903200149536, 0.41917216777801514, 0.5601454377174377, 0.33406996726989746, 0.5312292575836182, 0.7347690463066101, 0.36329346895217896, 0.4870149f, 0.22898507118225098, 0.6373441815376282, 0.6345996856689453, 0.276350736618042, 0.5662907958030701, 0.4810322f, 0.17140984535217285, 0.2860983610153198, 0.2018665075302124, 0.8623965978622437, 0.2078021764755249, 0.027436554431915283, 0.3213622570037842, 0.8489788770675659, 0.17418742179870605, 0.08984065055847168, 0.4241867661476135, 0.9418308734893799, 0.9684880375862122, 0.9527187347412109, 0.18455815315246582, 0.6065274477005005, 0.4981291890144348, 0.8888053894042969, 0.24716395139694214, 0.18402493000030518, 0.9244294762611389, 0.7530982494354248, 0.6354634165763855, 0.11419862508773804, 0.06763821840286255, 0.15208107233047485, 0.502015f, 0.4687958359718323, 0.2776569128036499, 0.8017957806587219, 0.646397590637207, 0.11037266254425049, 0.4113478f, 0.2250347137451172, 0.3065752387046814, 0.4486308693885803, 0.5043429136276245, 0.11318850517272949, 0.511311f, 0.8501695990562439, 0.10861527919769287, 0.13340067863464355, 0.909978985786438, 0.632366418838501, 0.8650884032249451, 0.033549726009368896, 0.6954838037490845, 0.11287665367126465, 0.674673318862915, 0.06375402212142944, 0.5577300786972046};
        int[] hallSensorID = new int[]{993, 496, 869, 682, 374, 476, 490, 557, 366, 525, 265, 565, 106, 583, 249, 267, 515, 222, 127, 800, 670, 429, 224, 819, 927, 868, 927, 780, 41, 185, 73, 772, 155, 81, 269, 956, 583, 371, 970, 582, 172, 314, 161, 235, 811, 53, 106, 546, 982, 69, 330, 210, 396, 554, 361, 76, 554, 594, 946, 784, 811, 775, 235, 187, 112, 68, 668, 274, 51, 332, 413, 941, 341, 711, 112, 427, 568, 25, 478, 757, 558, 177, 702, 402, 480, 627, 847, 791, 811, 834, 534, 392, 348, 774, 123, 920, 308, 941, 430, 81, 143, 410, 503, 880, 791, 463, 899, 928, 693, 255, 650, 1, 663, 453, 454, 549, 917, 483, 950, 479, 630, 848, 720, 632, 15, 376, 501, 727, 3, 17, 93, 988, 839, 600, 780, 802, 220, 798, 997, 815, 679, 859, 770, 201, 797, 205, 30, 974, 344, 909, 49, 632, 215, 54, 931, 787, 81, 419, 620, 388, 890, 163, 311, 992, 206, 156, 719, 655, 242, 929, 986, 147, 202, 369, 298, 89, 237, 798, 786, 330, 684, 6, 358, 422, 378, 522, 595, 262, 382, 657, 93, 900, 435, 560, 631, 929, 512, 328, 973, 235, 619, 100, 614, 705, 673, 685, 646, 277, 481, 316, 503, 541, 54, 427, 951, 237, 379, 40, 476, 988, 48, 135, 700, 705, 483, 787, 290, 203, 786, 89, 410, 234, 517, 370, 918, 629, 769, 746, 257, 113};
        double[] hallSensorPosition = new double[]{0.7822174429893494, 0.5979655385017395, 0.7027034163475037, 0.9898995161056519, 0.12456047534942627, 0.8187646269798279, 0.4652571678161621, 0.3246997594833374, 0.7379271984100342, 0.006887316703796387, 0.4530452489852905, 0.3875085115432739, 0.721917450428009, 0.27117353677749634, 0.7593408823013306, 0.7404987812042236, 0.7256408929824829, 0.854900598526001, 0.157843f, 0.583867609500885, 0.5232800841331482, 0.5524739623069763, 0.17146915197372437, 0.312854528427124, 0.6501095294952393, 0.161163330078125, 0.8502786159515381, 0.1887073516845703, 0.21293115615844727, 0.07158505916595459, 0.4632687568664551, 0.9889718294143677, 0.019225597381591797, 0.7258667349815369, 0.16032713651657104, 0.747619f, 0.5122162699699402, 0.9605627059936523, 0.487312376499176, 0.576705813407898, 0.13985759019851685, 0.6057502627372742, 0.9010071754455566, 0.9271302223205566, 0.7254574298858643, 0.7387614846229553, 0.7340636253356934, 0.6733422875404358, 0.912837028503418, 0.7502734661102295, 0.3962177038192749, 0.8504967093467712, 0.6118409037590027, 0.6346777081489563, 0.6007689237594604, 0.3154820203781128, 0.6184857487678528, 0.3816053867340088, 0.5990188121795654, 0.7066761255264282, 0.7915622591972351, 0.9401387572288513, 0.4550822377204895, 0.8304072618484497, 0.6631735563278198, 0.3236621022224426, 0.3548798f, 0.5723358392715454, 0.48923712968826294, 0.09669744968414307, 0.512495f, 0.014815092086791992, 0.11774694919586182, 0.7637425661087036, 0.0013309121131896973, 0.1103748083114624, 0.7935634851455688, 0.695536732673645, 0.5241841077804565, 0.8185601234436035, 0.02027106285095215, 0.8648861050605774, 0.86362f, 0.4383272f, 0.7694481611251831, 0.20988517999649048, 0.28067994117736816, 0.16905808448791504, 0.83838f, 0.23789077997207642, 0.1053884f, 0.9961449503898621, 0.697284996509552, 0.0728883147239685, 0.976794421672821, 0.4362572431564331, 0.1906307339668274, 0.5290064215660095, 0.8240458965301514, 0.6852403879165649, 0.43380147218704224, 0.6640772223472595, 0.5545397996902466, 0.3085957169532776, 0.9116076231002808, 0.2826339602470398, 0.2424364686012268, 0.8993031978607178, 0.389864444732666, 0.87402f, 0.24330562353134155, 0.5271173715591431, 0.8121272325515747, 0.7979332804679871, 0.3415534496307373, 0.3222883939743042, 0.9028640389442444, 0.17943823337554932, 0.6503531336784363, 0.00792855f, 0.03374302387237549, 0.9140632152557373, 0.3034737f, 0.5301044583320618, 0.8447704315185547, 0.5800148248672485, 0.9197233319282532, 0.3724360466003418, 0.7258525490760803, 0.5308462977409363, 0.689347505569458, 0.4999144673347473, 0.15168523788452148, 0.3233150839805603, 0.6739442944526672, 0.8003124594688416, 0.8840603828430176, 0.1999720335006714, 0.3641918897628784, 0.1045953f, 0.586685299873352, 0.07568937540054321, 0.6804636716842651, 0.4218956232070923, 0.5800520777702332, 0.306423f, 0.7984023094177246, 0.549782395362854, 0.45498377084732056, 0.08471924066543579, 0.4435202479362488, 0.1747344732284546, 0.4860857129096985, 0.20062655210494995, 0.5253089070320129, 0.49706172943115234, 0.1789099f, 0.922715425491333, 0.21220701932907104, 0.16325223445892334, 0.5513094067573547, 0.13890838623046875, 0.21476882696151733, 0.3092518448829651, 0.6099345684051514, 0.600970983505249, 0.21676874160766602, 0.08100646734237671, 0.9224645495414734, 0.04314148426055908, 0.03470128774642944, 0.45235252380371094, 0.7059468626976013, 0.2009183168411255, 0.29771554470062256, 0.1817813515663147, 0.7181359529495239, 0.9000556468963623, 0.7156334519386292, 0.5936198234558105, 0.7342118620872498, 0.6810342669487, 0.476121723651886, 0.6187577247619629, 0.06356239318847656, 0.08649373054504395, 0.007741868495941162, 0.3463588356971741, 0.47391778230667114, 0.18728214502334595, 0.4285205602645874, 0.7102625370025635, 0.8721213340759277, 0.028969526290893555, 0.025536537170410156, 0.929409384727478, 0.9869453310966492, 0.020075678825378418, 0.276092529296875, 0.8361074328422546, 0.21995443105697632, 0.38420385122299194, 0.31224966049194336, 0.23293238878250122, 0.40147173404693604, 0.39219456911087036, 0.5753852725028992, 0.22028517723083496, 0.8018012642860413, 0.36188453435897827, 0.3241550326347351, 0.9119870662689209, 0.8102445602416992, 0.24977731704711914, 0.9065913558006287, 0.813798725605011, 0.8789604902267456, 0.9017178416252136, 0.4344574213027954, 0.1655225157737732, 0.8238404393196106, 0.7224611043930054, 0.995449960231781, 0.8556565046310425, 0.3343989849090576, 0.16390752792358398, 0.4870567321777344, 0.8007899522781372, 0.5389488339424133, 0.21893548965454102, 0.8761265277862549, 0.46057581901550293, 0.9353818297386169, 0.19551920890808105, 0.39240384101867676, 0.0318138f, 0.6826966404914856, 0.7906205654144287, 0.2049654722213745, 0.7586924433708191};
        boolean[] hallSensorTransition = new boolean[]{true, true, false, false, false, false, false, true, false, true, false, false, false, true, false, true, true, true, true, false, true, true, false, true, false, true, false, false, false, false, true, true, false, true, false, true, true, false, false, false, false, false, true, false, false, true, true, false, true, false, true, true, false, true, true, true, false, true, true, false, true, true, false, false, true, true, false, false, true, true, false, false, true, true, false, false, true, true, true, false, true, true, true, true, false, true, false, true, false, false, false, false, false, true, false, false, false, false, false, false, true, true, false, true, false, false, false, false, false, true, true, true, false, true, true, true, false, false, true, false, true, true, false, false, true, false, false, true, true, false, false, true, true, true, true, false, true, true, true, true, false, true, false, false, true, false, true, true, true, true, true, false, true, false, false, true, true, true, true, false, true, true, true, false, false, true, true, true, false, false, false, false, true, true, false, true, true, true, false, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, true, false, true, true, false, false, false, true, false, true, false, true, false, true, false, false, false, true, true, false, true, true, true, false, false, true, false, false, false, false, true, false, false, false, false, false, true, true, true, false, true, false, false, false, true, false};
        int encoderCount = 184;
        double[] timestampEncoder = new double[]{0.4606884f, 0.6602405309677124, 0.9092357754707336, 0.8978352546691895, 0.50284343957901, 0.21597141027450562, 0.002817809581756592, 0.33124858140945435, 0.1895303726196289, 0.7303743362426758, 0.34034425020217896, 0.735842227935791, 0.4493151903152466, 0.931314f, 0.1333240270614624, 0.06915563344955444, 0.8116698861122131, 0.8750594854354858, 0.38524436950683594, 0.9800442457199097, 0.28536665439605713, 0.2334151268005371, 0.1388377547264099, 0.5651848912239075, 0.5733909606933594, 0.41720718145370483, 0.26448744535446167, 0.35695648193359375, 0.8900324106216431, 0.4097848f, 0.2699854373931885, 0.3449241f, 0.6514145731925964, 0.7461811900138855, 0.5459582805633545, 0.5232203006744385, 0.690171480178833, 0.10290920734405518, 0.679862916469574, 0.6237860321998596, 0.17658203840255737, 0.7969587445259094, 0.1981566f, 0.2166767716407776, 0.09368312358856201, 0.6079548001289368, 0.8828257322311401, 0.8750627636909485, 0.3472723364830017, 0.6027861833572388, 0.7847954034805298, 0.2713779807090759, 0.5309661030769348, 0.566125750541687, 0.18084394931793213, 0.8151566982269287, 0.10243260860443115, 0.6225319504737854, 0.02865135669708252, 0.20091331005096436, 0.5535042881965637, 0.216303288936615, 0.33076733350753784, 0.21007037162780762, 0.8211714029312134, 0.724603533744812, 0.1649855375289917, 0.524152934551239, 0.1386559009552002, 0.18888407945632935, 0.746355f, 0.6425913572311401, 0.16918432712554932, 0.4212082624435425, 0.6034871339797974, 0.25848788022994995, 0.20617163181304932, 0.6782745122909546, 0.955681f, 0.3962072f, 0.5218521356582642, 0.1899036169052124, 0.4225732088088989, 0.03787273168563843, 0.3646594285964966, 0.7142853140830994, 0.8675350546836853, 0.9096395373344421, 0.3596722483634949, 0.4937942624092102, 0.1310117244720459, 0.12645351886749268, 0.0751606822013855, 0.1677112579345703, 0.6396954655647278, 0.8349857330322266, 0.6537532806396484, 0.41739994287490845, 0.9492185115814209, 0.1932897f, 0.74419766664505, 0.07167041301727295, 0.5874601602554321, 0.592810332775116, 0.5374249219894409, 0.67213f, 0.5862097144126892, 0.08965545892715454, 0.7400966882705688, 0.8178134560585022, 0.6225771307945251, 0.4591280221939087, 0.4945831894874573, 0.09346562623977661, 0.11807596683502197, 0.02763331f, 0.9640874862670898, 0.7953070998191833, 0.17072665691375732, 0.6420723795890808, 0.8862138390541077, 0.6513652205467224, 0.10997647047042847, 0.4971882104873657, 0.4016244411468506, 0.08052986860275269, 0.3799621f, 0.5101470947265625, 0.8836053609848022, 0.426071f, 0.5660336017608643, 0.978637158870697, 0.0295704f, 0.8567120432853699, 0.703027f, 0.11930537223815918, 0.7800835967063904, 0.9634101986885071, 0.6401426196098328, 0.00840681791305542, 0.5613293051719666, 0.3452872633934021, 0.6132214665412903, 0.452708f, 0.2126712203025818, 0.9168487787246704, 0.2955929f, 0.4381973147392273, 0.7747090458869934, 0.1645141839981079, 0.296500027179718, 0.3348594903945923, 0.04089456796646118, 0.9079667925834656, 0.26252996921539307, 0.7911467552185059, 0.5862413048744202, 0.19596493244171143, 0.6517412066459656, 0.8109247088432312, 0.5020307898521423, 0.09269309043884277, 0.7096713781356812, 0.4633186459541321, 0.610880970954895, 0.2357664704322815, 0.8266355991363525, 0.8923792243003845, 0.7904093265533447, 0.007546544075012207, 0.02032071352005005, 0.1448100209236145, 0.6774519681930542, 0.9350197315216064, 0.8183979392051697, 0.9617493748664856, 0.3929516673088074, 0.8882981538772583, 0.9426085352897644, 0.2420047f, 0.6579023599624634, 0.792611f, 0.3765166401863098, 0.8020473122596741, 0.3539528250694275, 0.8028817176818848, 0.17002063989639282, 0.2709732f, 0.012377262115478516, 0.2536681294441223, 0.5590114593505859, 0.17061054706573486, 0.13917946815490723, 0.6210432052612305, 0.10065692663192749, 0.1617475152015686, 0.6523122191429138, 0.2882046699523926, 0.8141778707504272, 0.0724054f, 0.9226796627044678, 0.055135905742645264, 0.12229812145233154, 0.16417354345321655, 0.0801962f, 0.17703211307525635, 0.38655567169189453, 0.404455304145813, 0.9292687773704529, 0.7496299147605896, 0.27523887157440186, 0.5782743096351624, 0.27734827995300293, 0.6158115863800049, 0.1788643f, 0.4409077763557434, 0.9314776659011841, 0.6713199019432068, 0.5559794902801514, 0.8455294370651245, 0.479996919631958, 0.6631540656089783, 0.9409094452857971, 0.7073533535003662, 0.1218177080154419, 0.8578788042068481, 0.4422512f, 0.6322062015533447, 0.8091465830802917, 0.5049675107002258, 0.8019691109657288, 0.1533641219139099, 0.3595404624938965, 0.9193195104598999, 0.4434826374053955, 0.4118521213531494, 0.7011619210243225, 0.4847882390022278, 0.7149277925491333, 0.17381781339645386};
        double[] encoderPosition = new double[]{0.22563612461090088, 0.5550898909568787, 0.6106980443000793, 0.7112863063812256, 0.22369462251663208, 0.3586241f, 0.33843398094177246, 0.9524278044700623, 0.41063958406448364, 0.7489414215087891, 0.9759699106216431, 0.6229037642478943, 0.655523f, 0.27287375926971436, 0.24761521816253662, 0.804999589920044, 0.7068792581558228, 0.23437517881393433, 0.8339337110519409, 0.4058322310447693, 0.15907102823257446, 0.5351780652999878, 0.13439089059829712, 0.6852855086326599, 0.2801274061203003, 0.285383403301239, 0.626501202583313, 0.999459f, 0.9808174967765808, 0.8505963683128357, 0.8351826071739197, 0.7829119563102722, 0.9551782011985779, 0.8803683519363403, 0.9467967748641968, 0.05507081747055054, 0.37750154733657837, 0.32929152250289917, 0.6068287491798401, 0.19070512056350708, 0.9657025337219238, 0.811535120010376, 0.839469f, 0.6548264026641846, 0.3849772810935974, 0.2369445562362671, 0.060768187046051025, 0.947840690612793, 0.9907975792884827, 0.3677181005477905, 0.1419163942337036, 0.23200958967208862, 0.621763288974762, 0.1554107666015625, 0.5610649585723877, 0.37559783458709717, 0.32896852493286133, 0.8055156469345093, 0.08459645509719849, 0.33248448371887207, 0.5507811307907104, 0.9486668705940247, 0.6936050653457642, 0.5140964984893799, 0.7448531985282898, 0.941771388053894, 0.7484720349311829, 0.7645028829574585, 0.010468602180480957, 0.6878884434700012, 0.6218031644821167, 0.6412501335144043, 0.8648171424865723, 0.8498541712760925, 0.26377958059310913, 0.3724910616874695, 0.37040263414382935, 0.47953593730926514, 0.7584148049354553, 0.3092666268348694, 0.9946192502975464, 0.8228532075881958, 0.8266887664794922, 0.140167236328125, 0.36675918102264404, 0.9616162776947021, 0.20355886220932007, 0.06938314437866211, 0.885668f, 0.4787197709083557, 0.7090548872947693, 0.5793200731277466, 0.5293838381767273, 0.0858263373374939, 0.8258102536201477, 0.0721203088760376, 0.2859575152397156, 0.12554824352264404, 0.4413476586341858, 0.3928038477897644, 0.1249426007270813, 0.6870742440223694, 0.6962341070175171, 0.02819424867630005, 0.07759493589401245, 0.2796071767807007, 0.25997406244277954, 0.21378272771835327, 0.7095667123794556, 0.2569117546081543, 0.8244872093200684, 0.5943259000778198, 0.4248991012573242, 0.5343916416168213, 0.7275944948196411, 0.8179831504821777, 0.7096013426780701, 0.2837026119232178, 0.7916221618652344, 0.10853838920593262, 0.6353712677955627, 0.8158840537071228, 0.15866601467132568, 0.58169f, 0.9305132627487183, 0.49988818168640137, 0.9259874224662781, 0.7411353588104248, 0.370410680770874, 0.4273747205734253, 0.11232644319534302, 0.11544859409332275, 0.531707f, 0.3855026960372925, 0.12662345170974731, 0.55040442943573, 0.4334644079208374, 0.18660622835159302, 0.7508691549301147, 0.941911518573761, 0.798945963382721, 0.3171289563179016, 0.3028132915496826, 0.6361914873123169, 0.610375702381134, 0.38867151737213135, 0.3044389f, 0.8059951663017273, 0.996269166469574, 0.8227730989456177, 0.6689545512199402, 0.5698431730270386, 0.9400115013122559, 0.2900077f, 0.23121285438537598, 0.706488f, 0.685739f, 0.5056788325309753, 0.810676f, 0.545616090297699, 0.35282236337661743, 0.30199337005615234, 0.9172133803367615, 0.02047944f, 0.1660524f, 0.3338874578475952, 0.521131f, 0.2465037703514099, 0.830807626247406, 0.10707056522369385, 0.9210320711135864, 0.1554531455039978, 0.09999215602874756, 0.1573919f, 0.895658016204834, 0.2465330958366394, 0.11442923545837402, 0.4659762978553772, 0.8361278176307678, 0.00861752f, 0.975890040397644, 0.511019766330719, 0.06850481033325195, 0.8819335699081421, 0.5103369355201721, 0.5715826153755188, 0.8169936537742615, 0.1390208601951599, 0.779719f, 0.9887209534645081, 0.277072012424469, 0.915184736251831, 0.538340151309967, 0.42300945520401, 0.6953703761100769, 0.9652260541915894, 0.14212846755981445, 0.733724f, 0.6471393704414368, 0.9887987971305847, 0.9968788623809814, 0.8430869579315186, 0.3988179f, 0.4897953271865845, 0.26867908239364624, 0.8790637850761414, 0.2067958116531372, 0.8197957873344421, 0.5233194828033447, 0.4429087f, 0.07633805274963379, 0.021564245223999023, 0.1617315411567688, 0.0942736268043518, 0.15730106830596924, 0.3211820721626282, 0.87872f, 0.04913193f, 0.9343748688697815, 0.11765807867050171, 0.9988874793052673, 0.7465725541114807, 0.3558666706085205, 0.3533428907394409, 0.996278703212738, 0.8528434634208679, 0.291401743888855, 0.4994316101074219, 0.04557693004608154, 0.5686679482460022, 0.2983502149581909, 0.6061123609542847, 0.2985035181045532, 0.813226f, 0.7704379558563232, 0.009990692138671875, 0.14833104610443115, 0.14033353328704834, 0.6291144490242004, 0.19138479232788086};
        SALEvent item = this.testSendReceive((SALEvent)new ShutterBladeMotionProfileEvent(priority, blade, direction, timestampStart, startPosition, targetDuration, targetPosition, endPosition, actualDuration, hallSensorCount, timestampHallSensor, hallSensorID, hallSensorPosition, hallSensorTransition, encoderCount, timestampEncoder, encoderPosition));
        Assert.assertTrue((boolean)(item instanceof ShutterBladeMotionProfileEvent));
        ShutterBladeMotionProfileEvent item_ = (ShutterBladeMotionProfileEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)blade, (Object)item_.getBlade());
        Assert.assertEquals((Object)direction, (Object)item_.getDirection());
        Assert.assertEquals((double)timestampStart, (double)item_.getTimestampStart(), (double)1.0E-6f);
        Assert.assertEquals((double)startPosition, (double)item_.getStartPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)targetDuration, (double)item_.getTargetDuration(), (double)1.0E-6f);
        Assert.assertEquals((double)targetPosition, (double)item_.getTargetPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)endPosition, (double)item_.getEndPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)actualDuration, (double)item_.getActualDuration(), (double)1.0E-6f);
        Assert.assertEquals((long)hallSensorCount, (long)item_.getHallSensorCount());
        Assert.assertArrayEquals((double[])timestampHallSensor, (double[])item_.getTimestampHallSensor(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])hallSensorID, (int[])item_.getHallSensorID());
        Assert.assertArrayEquals((double[])hallSensorPosition, (double[])item_.getHallSensorPosition(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])hallSensorTransition, (boolean[])item_.getHallSensorTransition());
        Assert.assertEquals((long)encoderCount, (long)item_.getEncoderCount());
        Assert.assertArrayEquals((double[])timestampEncoder, (double[])item_.getTimestampEncoder(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])encoderPosition, (double[])item_.getEncoderPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageStoredEvent() throws Exception {
        int priority = 554;
        String imageName = "qhxmncebblhkdblsqs";
        double timeStampImageStored = 0.9644457697868347;
        SALEvent item = this.testSendReceive((SALEvent)new ImageStoredEvent(priority, imageName, timeStampImageStored));
        Assert.assertTrue((boolean)(item instanceof ImageStoredEvent));
        ImageStoredEvent item_ = (ImageStoredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timeStampImageStored, (double)item_.getTimeStampImageStored(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFitsFilesWrittenEvent() throws Exception {
        int priority = 296;
        String imageName = "gmlnjxhoehsowscimqglhewdwngqrb";
        double timeStampFilesWritten = 0.986163318157196;
        String rootFileName = "d";
        String relativeFileNames = "";
        String fileNode = "";
        SALEvent item = this.testSendReceive((SALEvent)new FitsFilesWrittenEvent(priority, imageName, timeStampFilesWritten, rootFileName, relativeFileNames, fileNode));
        Assert.assertTrue((boolean)(item instanceof FitsFilesWrittenEvent));
        FitsFilesWrittenEvent item_ = (FitsFilesWrittenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timeStampFilesWritten, (double)item_.getTimeStampFilesWritten(), (double)1.0E-6f);
        Assert.assertEquals((Object)rootFileName, (Object)item_.getRootFileName());
        Assert.assertEquals((Object)relativeFileNames, (Object)item_.getRelativeFileNames());
        Assert.assertEquals((Object)fileNode, (Object)item_.getFileNode());
    }

    @Test
    public void sendReceiveFileCommandExecutionEvent() throws Exception {
        int priority = 666;
        String imageName = "whxmvkmfzxbywzkvv";
        double timestampCommandComplete = 0.22758746147155762;
        String command = "";
        int rc = 559;
        SALEvent item = this.testSendReceive((SALEvent)new FileCommandExecutionEvent(priority, imageName, timestampCommandComplete, command, rc));
        Assert.assertTrue((boolean)(item instanceof FileCommandExecutionEvent));
        FileCommandExecutionEvent item_ = (FileCommandExecutionEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampCommandComplete, (double)item_.getTimestampCommandComplete(), (double)1.0E-6f);
        Assert.assertEquals((Object)command, (Object)item_.getCommand());
        Assert.assertEquals((long)rc, (long)item_.getRc());
    }

    @Test
    public void sendReceiveImageVisualizationEvent() throws Exception {
        int priority = 669;
        String imageName = "eimnnnsixrkvjbnlpnezxwubj";
        double timestampVisualizationAvailable = 0.33633846044540405;
        String url = "";
        String thumbnail = "t";
        SALEvent item = this.testSendReceive((SALEvent)new ImageVisualizationEvent(priority, imageName, timestampVisualizationAvailable, url, thumbnail));
        Assert.assertTrue((boolean)(item instanceof ImageVisualizationEvent));
        ImageVisualizationEvent item_ = (ImageVisualizationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampVisualizationAvailable, (double)item_.getTimestampVisualizationAvailable(), (double)1.0E-6f);
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)thumbnail, (Object)item_.getThumbnail());
    }

    @Test
    public void sendReceiveSettingVersionsEvent() throws Exception {
        int priority = 226;
        String recommendedSettingsVersion = "";
        String recommendedSettingsLabels = "";
        String settingsUrl = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingVersionsEvent(priority, recommendedSettingsVersion, recommendedSettingsLabels, settingsUrl));
        Assert.assertTrue((boolean)(item instanceof SettingVersionsEvent));
        SettingVersionsEvent item_ = (SettingVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)recommendedSettingsVersion, (Object)item_.getRecommendedSettingsVersion());
        Assert.assertEquals((Object)recommendedSettingsLabels, (Object)item_.getRecommendedSettingsLabels());
        Assert.assertEquals((Object)settingsUrl, (Object)item_.getSettingsUrl());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 116;
        int errorCode = 259;
        String errorReport = "";
        String traceback = "";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveAppliedSettingsMatchStartEvent() throws Exception {
        int priority = 630;
        boolean appliedSettingsMatchStartIsTrue = false;
        SALEvent item = this.testSendReceive((SALEvent)new AppliedSettingsMatchStartEvent(priority, appliedSettingsMatchStartIsTrue));
        Assert.assertTrue((boolean)(item instanceof AppliedSettingsMatchStartEvent));
        AppliedSettingsMatchStartEvent item_ = (AppliedSettingsMatchStartEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)appliedSettingsMatchStartIsTrue, (Object)item_.isAppliedSettingsMatchStartIsTrue());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 201;
        int level = 605;
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 288;
        String name = "";
        int level = 663;
        String message = "f";
        String traceback = "";
        String filePath = "j";
        String functionName = "";
        int lineNumber = 344;
        int process = 489;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, name, level, message, traceback, filePath, functionName, lineNumber, process));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
    }

    @Test
    public void sendReceiveSettingsAppliedEvent() throws Exception {
        int priority = 209;
        String settingsVersion = "ydzuxqeadhsupppvdtuqnhujcmhhhsohdszawjbsjgdrjuebfzwbdmatcfqfcmcjgbxmyihihxpsmyievkzlpvwvjtqmxjfrdjghvqyzdkbqolftkmqgbyctwbyltjtpojslrvqygvliyeusxsqvhxqmallgvbdariwdizmdsv";
        String otherSettingsEvents = "n";
        SALEvent item = this.testSendReceive((SALEvent)new SettingsAppliedEvent(priority, settingsVersion, otherSettingsEvents));
        Assert.assertTrue((boolean)(item instanceof SettingsAppliedEvent));
        SettingsAppliedEvent item_ = (SettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)settingsVersion, (Object)item_.getSettingsVersion());
        Assert.assertEquals((Object)otherSettingsEvents, (Object)item_.getOtherSettingsEvents());
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 466;
        int mode = 842;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 665;
        String salVersion = "t";
        String xmlVersion = "yenawpytbxhive";
        String openSpliceVersion = "qbd";
        String cscVersion = "fckdrfcozgfangl";
        String subsystemVersions = "";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 232;
        boolean heartbeat = true;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        int priority = 88;
        String authorizedUsers = "";
        String nonAuthorizedCSCs = "";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(priority, authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }
}

