package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Vacuum_CryoTelemetry extends CameraTelemetry {
  private final double rejectTemperature;

  private final double autoOffEnabled;

  private final double power;

  private final double setPower;

  private final double temperature;

  private final double autoOnTemperature;

  private final double setpoint;

  private final double autoOffTemperature;

  public Vacuum_CryoTelemetry(double rejectTemperature, double autoOffEnabled, double power,
      double setPower, double temperature, double autoOnTemperature, double setpoint,
      double autoOffTemperature) {
    this.rejectTemperature = rejectTemperature;
    this.autoOffEnabled = autoOffEnabled;
    this.power = power;
    this.setPower = setPower;
    this.temperature = temperature;
    this.autoOnTemperature = autoOnTemperature;
    this.setpoint = setpoint;
    this.autoOffTemperature = autoOffTemperature;
  }

  public double getRejectTemperature() {
    return rejectTemperature;
  }

  public double getAutoOffEnabled() {
    return autoOffEnabled;
  }

  public double getPower() {
    return power;
  }

  public double getSetPower() {
    return setPower;
  }

  public double getTemperature() {
    return temperature;
  }

  public double getAutoOnTemperature() {
    return autoOnTemperature;
  }

  public double getSetpoint() {
    return setpoint;
  }

  public double getAutoOffTemperature() {
    return autoOffTemperature;
  }

  @Override
  public String toString() {
    return "Vacuum_CryoTelemetry{" + "rejectTemperature=" + rejectTemperature +
        ", autoOffEnabled=" + autoOffEnabled +", power=" + power +", setPower=" + setPower +
        ", temperature=" + temperature +", autoOnTemperature=" + autoOnTemperature +
        ", setpoint=" + setpoint +", autoOffTemperature=" + autoOffTemperature +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double rejectTemperature;

    private double autoOffEnabled;

    private double power;

    private double setPower;

    private double temperature;

    private double autoOnTemperature;

    private double setpoint;

    private double autoOffTemperature;

    private Builder() {
    }

    public Builder rejectTemperature(double rejectTemperature) {
      this.rejectTemperature = rejectTemperature;
      return this;
    }

    public Builder autoOffEnabled(double autoOffEnabled) {
      this.autoOffEnabled = autoOffEnabled;
      return this;
    }

    public Builder power(double power) {
      this.power = power;
      return this;
    }

    public Builder setPower(double setPower) {
      this.setPower = setPower;
      return this;
    }

    public Builder temperature(double temperature) {
      this.temperature = temperature;
      return this;
    }

    public Builder autoOnTemperature(double autoOnTemperature) {
      this.autoOnTemperature = autoOnTemperature;
      return this;
    }

    public Builder setpoint(double setpoint) {
      this.setpoint = setpoint;
      return this;
    }

    public Builder autoOffTemperature(double autoOffTemperature) {
      this.autoOffTemperature = autoOffTemperature;
      return this;
    }

    public Vacuum_CryoTelemetry build() {
      return new Vacuum_CryoTelemetry(rejectTemperature, autoOffEnabled, power, setPower, temperature, autoOnTemperature, setpoint, autoOffTemperature);
    }
  }
}
