package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class ImageStoredEvent extends CameraEvent {
  private final String imageName;

  private final double timeStampImageStored;

  public ImageStoredEvent(int priority, String imageName, double timeStampImageStored) {
    super (priority);
    this.imageName = imageName;
    this.timeStampImageStored = timeStampImageStored;
  }

  public String getImageName() {
    return imageName;
  }

  public double getTimeStampImageStored() {
    return timeStampImageStored;
  }

  @Override
  public String toString() {
    return "ImageStoredEvent{" + "imageName=" + imageName +
        ", timeStampImageStored=" + timeStampImageStored +"}";
  }
}
