package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class FocalPlaneSequencerSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final String sequencerconfig_metaDataRegisters;

  private final int sequencerconfig_overCols;

  private final int sequencerconfig_overRows;

  private final int sequencerconfig_postCols;

  private final int sequencerconfig_postRows;

  private final int sequencerconfig_preCols;

  private final int sequencerconfig_preRows;

  private final int sequencerconfig_readCols;

  private final int sequencerconfig_readCols2;

  private final int sequencerconfig_readRows;

  private final boolean sequencerconfig_scanMode;

  private final String sequencerconfig_sequencer;

  private final int sequencerconfig_underCols;

  public FocalPlaneSequencerSettingsAppliedEvent(int priority, int version,
      String sequencerconfig_metaDataRegisters, int sequencerconfig_overCols,
      int sequencerconfig_overRows, int sequencerconfig_postCols, int sequencerconfig_postRows,
      int sequencerconfig_preCols, int sequencerconfig_preRows, int sequencerconfig_readCols,
      int sequencerconfig_readCols2, int sequencerconfig_readRows, boolean sequencerconfig_scanMode,
      String sequencerconfig_sequencer, int sequencerconfig_underCols) {
    super (priority);
    this.version = version;
    this.sequencerconfig_metaDataRegisters = sequencerconfig_metaDataRegisters;
    this.sequencerconfig_overCols = sequencerconfig_overCols;
    this.sequencerconfig_overRows = sequencerconfig_overRows;
    this.sequencerconfig_postCols = sequencerconfig_postCols;
    this.sequencerconfig_postRows = sequencerconfig_postRows;
    this.sequencerconfig_preCols = sequencerconfig_preCols;
    this.sequencerconfig_preRows = sequencerconfig_preRows;
    this.sequencerconfig_readCols = sequencerconfig_readCols;
    this.sequencerconfig_readCols2 = sequencerconfig_readCols2;
    this.sequencerconfig_readRows = sequencerconfig_readRows;
    this.sequencerconfig_scanMode = sequencerconfig_scanMode;
    this.sequencerconfig_sequencer = sequencerconfig_sequencer;
    this.sequencerconfig_underCols = sequencerconfig_underCols;
  }

  public int getVersion() {
    return version;
  }

  public String getSequencerconfig_metaDataRegisters() {
    return sequencerconfig_metaDataRegisters;
  }

  public int getSequencerconfig_overCols() {
    return sequencerconfig_overCols;
  }

  public int getSequencerconfig_overRows() {
    return sequencerconfig_overRows;
  }

  public int getSequencerconfig_postCols() {
    return sequencerconfig_postCols;
  }

  public int getSequencerconfig_postRows() {
    return sequencerconfig_postRows;
  }

  public int getSequencerconfig_preCols() {
    return sequencerconfig_preCols;
  }

  public int getSequencerconfig_preRows() {
    return sequencerconfig_preRows;
  }

  public int getSequencerconfig_readCols() {
    return sequencerconfig_readCols;
  }

  public int getSequencerconfig_readCols2() {
    return sequencerconfig_readCols2;
  }

  public int getSequencerconfig_readRows() {
    return sequencerconfig_readRows;
  }

  public boolean isSequencerconfig_scanMode() {
    return sequencerconfig_scanMode;
  }

  public String getSequencerconfig_sequencer() {
    return sequencerconfig_sequencer;
  }

  public int getSequencerconfig_underCols() {
    return sequencerconfig_underCols;
  }

  @Override
  public String toString() {
    return "FocalPlaneSequencerSettingsAppliedEvent{" + "version=" + version +
        ", sequencerconfig_metaDataRegisters=" + sequencerconfig_metaDataRegisters +
        ", sequencerconfig_overCols=" + sequencerconfig_overCols +
        ", sequencerconfig_overRows=" + sequencerconfig_overRows +
        ", sequencerconfig_postCols=" + sequencerconfig_postCols +
        ", sequencerconfig_postRows=" + sequencerconfig_postRows +
        ", sequencerconfig_preCols=" + sequencerconfig_preCols +
        ", sequencerconfig_preRows=" + sequencerconfig_preRows +
        ", sequencerconfig_readCols=" + sequencerconfig_readCols +
        ", sequencerconfig_readCols2=" + sequencerconfig_readCols2 +
        ", sequencerconfig_readRows=" + sequencerconfig_readRows +
        ", sequencerconfig_scanMode=" + sequencerconfig_scanMode +
        ", sequencerconfig_sequencer=" + sequencerconfig_sequencer +
        ", sequencerconfig_underCols=" + sequencerconfig_underCols +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private int version;

    private String sequencerconfig_metaDataRegisters;

    private int sequencerconfig_overCols;

    private int sequencerconfig_overRows;

    private int sequencerconfig_postCols;

    private int sequencerconfig_postRows;

    private int sequencerconfig_preCols;

    private int sequencerconfig_preRows;

    private int sequencerconfig_readCols;

    private int sequencerconfig_readCols2;

    private int sequencerconfig_readRows;

    private boolean sequencerconfig_scanMode;

    private String sequencerconfig_sequencer;

    private int sequencerconfig_underCols;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(int version) {
      this.version = version;
      return this;
    }

    public Builder sequencerconfig_metaDataRegisters(String sequencerconfig_metaDataRegisters) {
      this.sequencerconfig_metaDataRegisters = sequencerconfig_metaDataRegisters;
      return this;
    }

    public Builder sequencerconfig_overCols(int sequencerconfig_overCols) {
      this.sequencerconfig_overCols = sequencerconfig_overCols;
      return this;
    }

    public Builder sequencerconfig_overRows(int sequencerconfig_overRows) {
      this.sequencerconfig_overRows = sequencerconfig_overRows;
      return this;
    }

    public Builder sequencerconfig_postCols(int sequencerconfig_postCols) {
      this.sequencerconfig_postCols = sequencerconfig_postCols;
      return this;
    }

    public Builder sequencerconfig_postRows(int sequencerconfig_postRows) {
      this.sequencerconfig_postRows = sequencerconfig_postRows;
      return this;
    }

    public Builder sequencerconfig_preCols(int sequencerconfig_preCols) {
      this.sequencerconfig_preCols = sequencerconfig_preCols;
      return this;
    }

    public Builder sequencerconfig_preRows(int sequencerconfig_preRows) {
      this.sequencerconfig_preRows = sequencerconfig_preRows;
      return this;
    }

    public Builder sequencerconfig_readCols(int sequencerconfig_readCols) {
      this.sequencerconfig_readCols = sequencerconfig_readCols;
      return this;
    }

    public Builder sequencerconfig_readCols2(int sequencerconfig_readCols2) {
      this.sequencerconfig_readCols2 = sequencerconfig_readCols2;
      return this;
    }

    public Builder sequencerconfig_readRows(int sequencerconfig_readRows) {
      this.sequencerconfig_readRows = sequencerconfig_readRows;
      return this;
    }

    public Builder sequencerconfig_scanMode(boolean sequencerconfig_scanMode) {
      this.sequencerconfig_scanMode = sequencerconfig_scanMode;
      return this;
    }

    public Builder sequencerconfig_sequencer(String sequencerconfig_sequencer) {
      this.sequencerconfig_sequencer = sequencerconfig_sequencer;
      return this;
    }

    public Builder sequencerconfig_underCols(int sequencerconfig_underCols) {
      this.sequencerconfig_underCols = sequencerconfig_underCols;
      return this;
    }

    public FocalPlaneSequencerSettingsAppliedEvent build() {
      return new FocalPlaneSequencerSettingsAppliedEvent(priority, version, sequencerconfig_metaDataRegisters, sequencerconfig_overCols, sequencerconfig_overRows, sequencerconfig_postCols, sequencerconfig_postRows, sequencerconfig_preCols, sequencerconfig_preRows, sequencerconfig_readCols, sequencerconfig_readCols2, sequencerconfig_readRows, sequencerconfig_scanMode, sequencerconfig_sequencer, sequencerconfig_underCols);
    }
  }
}
