package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class FocalPlaneDAQSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final String sequencerconfig_daqFolder;

  private final boolean sequencerconfig_emulatedDAQ;

  public FocalPlaneDAQSettingsAppliedEvent(int priority, int version,
      String sequencerconfig_daqFolder, boolean sequencerconfig_emulatedDAQ) {
    super (priority);
    this.version = version;
    this.sequencerconfig_daqFolder = sequencerconfig_daqFolder;
    this.sequencerconfig_emulatedDAQ = sequencerconfig_emulatedDAQ;
  }

  public int getVersion() {
    return version;
  }

  public String getSequencerconfig_daqFolder() {
    return sequencerconfig_daqFolder;
  }

  public boolean isSequencerconfig_emulatedDAQ() {
    return sequencerconfig_emulatedDAQ;
  }

  @Override
  public String toString() {
    return "FocalPlaneDAQSettingsAppliedEvent{" + "version=" + version +
        ", sequencerconfig_daqFolder=" + sequencerconfig_daqFolder +
        ", sequencerconfig_emulatedDAQ=" + sequencerconfig_emulatedDAQ +"}";
  }
}
