/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.telemetry.BonnShutterTelemetry;
import org.lsst.sal.cccamera.telemetry.FilterChangerTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_R22Telemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebPSTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFilterChangerTelemetry() throws Exception {
        float motorTemperature = 0.21293116f;
        float motorEncoder = 0.07158506f;
        float linearPosition = 0.46326876f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FilterChangerTelemetry(motorTemperature, motorEncoder, linearPosition));
        Assert.assertTrue((boolean)(item instanceof FilterChangerTelemetry));
        FilterChangerTelemetry item_ = (FilterChangerTelemetry)item;
        Assert.assertEquals((float)motorTemperature, (float)item_.getMotorTemperature(), (float)1.0E-6f);
        Assert.assertEquals((float)motorEncoder, (float)item_.getMotorEncoder(), (float)1.0E-6f);
        Assert.assertEquals((float)linearPosition, (float)item_.getLinearPosition(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveBonnShutterTelemetry() throws Exception {
        float shutter5V = 0.9889718f;
        float shutter36V = 0.019225597f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new BonnShutterTelemetry(shutter5V, shutter36V));
        Assert.assertTrue((boolean)(item instanceof BonnShutterTelemetry));
        BonnShutterTelemetry item_ = (BonnShutterTelemetry)item;
        Assert.assertEquals((float)shutter5V, (float)item_.getShutter5V(), (float)1.0E-6f);
        Assert.assertEquals((float)shutter36V, (float)item_.getShutter36V(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_R22Telemetry() throws Exception {
        double reb1_analog_IbefLDO = 0.7258667349815369;
        double reb1_heater_IbefLDO = 0.16032713651657104;
        double reb1_clockhi_VaftSwch = 0.747619f;
        double reb2_clockhi_IaftLDO = 0.5122162699699402;
        double reb2_heater_IaftLDO = 0.9605627059936523;
        double reb2_digital_VaftLDO = 0.487312376499176;
        double reb0_heater_VaftLDO = 0.576705813407898;
        double reb1_digital_IaftLDO = 0.13985759019851685;
        double reb0_digital_IbefLDO = 0.6057502627372742;
        double reb0_Power = 0.9010071754455566;
        double reb2_OD_IaftLDO = 0.9271302223205566;
        double reb2_clocklo_IbefLDO = 0.7254574298858643;
        double reb1_digital_VbefLDO = 0.7387614846229553;
        double reb1_clockhi_IbefLDO = 0.7340636253356934;
        double reb2_heater_VbefLDO = 0.6733422875404358;
        double reb1_clocklo_VaftLDO = 0.912837028503418;
        double reb0_analog_VaftLDO = 0.7502734661102295;
        double reb2_clocklo_VaftSwch = 0.3962177038192749;
        double reb2_analog_VbefLDO = 0.8504967093467712;
        double reb0_clockhi_VaftLDO = 0.6118409037590027;
        double reb2_hvbias_VbefSwch = 0.6346777081489563;
        double reb2_OD_VaftLDO2 = 0.6007689237594604;
        double reb1_OD_VaftLDO2 = 0.3154820203781128;
        double reb0_clockhi_VbefLDO = 0.6184857487678528;
        double reb0_OD_VaftLDO2 = 0.3816053867340088;
        double reb2_analog_IaftLDO = 0.5990188121795654;
        double reb2_clocklo_IaftLDO = 0.7066761255264282;
        double reb0_analog_VaftSwch = 0.7915622591972351;
        double reb1_OD_IaftLDO = 0.9401387572288513;
        double reb1_clockhi_VaftLDO = 0.4550822377204895;
        double reb2_Power = 0.8304072618484497;
        double reb0_clocklo_VaftLDO2 = 0.6631735563278198;
        double reb2_clockhi_IbefLDO = 0.3236621022224426;
        double reb2_analog_IbefLDO = 0.3548798f;
        double reb0_heater_VaftSwch = 0.5723358392715454;
        double reb1_analog_IaftLDO = 0.48923712968826294;
        double reb0_digital_IaftLDO = 0.09669744968414307;
        double reb0_analog_VbefLDO = 0.512495f;
        double reb0_analog_IbefLDO = 0.014815092086791992;
        double reb1_digital_IbefLDO = 0.11774694919586182;
        double reb1_heater_IaftLDO = 0.7637425661087036;
        double reb1_heater_VaftLDO = 0.0013309121131896973;
        double reb2_heater_IbefLDO = 0.1103748083114624;
        double reb1_clockhi_IaftLDO = 0.7935634851455688;
        double reb0_digital_VaftLDO = 0.695536732673645;
        double reb0_OD_VaftSwch = 0.5241841077804565;
        double reb1_OD_VaftLDO = 0.8185601234436035;
        double reb1_OD_VaftSwch = 0.02027106285095215;
        double reb2_hvbias_IbefSwch = 0.8648861050605774;
        double reb2_clockhi_VbefLDO = 0.86362f;
        double reb0_digital_VaftSwch = 0.4383272f;
        double reb0_OD_VaftLDO = 0.7694481611251831;
        double reb0_OD_IaftLDO = 0.20988517999649048;
        double reb0_clocklo_VbefLDO = 0.28067994117736816;
        double reb2_OD_VaftSwch = 0.16905808448791504;
        double reb0_clocklo_IbefLDO = 0.83838f;
        double reb0_OD_VbefLDO = 0.23789077997207642;
        double reb1_clocklo_VaftSwch = 0.1053884f;
        double reb1_clockhi_VbefLDO = 0.9961449503898621;
        double reb2_clockhi_VaftSwch = 0.697284996509552;
        double reb2_OD_VaftLDO = 0.0728883147239685;
        double reb1_OD_IbefLDO = 0.976794421672821;
        double reb0_analog_IaftLDO = 0.4362572431564331;
        double reb1_clocklo_IaftLDO = 0.1906307339668274;
        double reb1_hvbias_VbefSwch = 0.5290064215660095;
        double reb1_hvbias_IbefSwch = 0.8240458965301514;
        double reb1_analog_VbefLDO = 0.6852403879165649;
        double reb1_heater_VbefLDO = 0.43380147218704224;
        double reb2_clocklo_VaftLDO = 0.6640772223472595;
        double reb2_digital_IaftLDO = 0.5545397996902466;
        double reb2_clocklo_VbefLDO = 0.3085957169532776;
        double reb1_analog_VaftSwch = 0.9116076231002808;
        double reb2_clocklo_VaftLDO2 = 0.2826339602470398;
        double reb0_clockhi_IaftLDO = 0.2424364686012268;
        double reb1_analog_VaftLDO = 0.8993031978607178;
        double reb0_heater_VbefLDO = 0.389864444732666;
        double reb1_heater_VaftSwch = 0.87402f;
        double reb0_heater_IbefLDO = 0.24330562353134155;
        double reb1_digital_VaftSwch = 0.5271173715591431;
        double reb0_heater_IaftLDO = 0.8121272325515747;
        double reb2_digital_VbefLDO = 0.7979332804679871;
        double reb2_digital_IbefLDO = 0.3415534496307373;
        double reb0_clockhi_IbefLDO = 0.3222883939743042;
        double reb2_analog_VaftLDO = 0.9028640389442444;
        double reb1_Power = 0.17943823337554932;
        double reb0_hvbias_IbefSwch = 0.6503531336784363;
        double reb2_OD_IbefLDO = 0.00792855f;
        double reb1_OD_VbefLDO = 0.03374302387237549;
        double reb1_clocklo_IbefLDO = 0.9140632152557373;
        double reb1_clocklo_VbefLDO = 0.3034737f;
        double reb2_OD_VbefLDO = 0.5301044583320618;
        double reb1_digital_VaftLDO = 0.8447704315185547;
        double reb2_heater_VaftSwch = 0.5800148248672485;
        double reb0_OD_IbefLDO = 0.9197233319282532;
        double reb0_hvbias_VbefSwch = 0.3724360466003418;
        double reb2_heater_VaftLDO = 0.7258525490760803;
        double reb0_digital_VbefLDO = 0.5308462977409363;
        double reb2_digital_VaftSwch = 0.689347505569458;
        double reb0_clocklo_VaftLDO = 0.4999144673347473;
        double reb0_clockhi_VaftSwch = 0.15168523788452148;
        double reb0_clocklo_IaftLDO = 0.3233150839805603;
        double reb2_analog_VaftSwch = 0.6739442944526672;
        double reb1_clocklo_VaftLDO2 = 0.8003124594688416;
        double reb2_clockhi_VaftLDO = 0.8840603828430176;
        double reb0_clocklo_VaftSwch = 0.1999720335006714;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_R22Telemetry(reb1_analog_IbefLDO, reb1_heater_IbefLDO, reb1_clockhi_VaftSwch, reb2_clockhi_IaftLDO, reb2_heater_IaftLDO, reb2_digital_VaftLDO, reb0_heater_VaftLDO, reb1_digital_IaftLDO, reb0_digital_IbefLDO, reb0_Power, reb2_OD_IaftLDO, reb2_clocklo_IbefLDO, reb1_digital_VbefLDO, reb1_clockhi_IbefLDO, reb2_heater_VbefLDO, reb1_clocklo_VaftLDO, reb0_analog_VaftLDO, reb2_clocklo_VaftSwch, reb2_analog_VbefLDO, reb0_clockhi_VaftLDO, reb2_hvbias_VbefSwch, reb2_OD_VaftLDO2, reb1_OD_VaftLDO2, reb0_clockhi_VbefLDO, reb0_OD_VaftLDO2, reb2_analog_IaftLDO, reb2_clocklo_IaftLDO, reb0_analog_VaftSwch, reb1_OD_IaftLDO, reb1_clockhi_VaftLDO, reb2_Power, reb0_clocklo_VaftLDO2, reb2_clockhi_IbefLDO, reb2_analog_IbefLDO, reb0_heater_VaftSwch, reb1_analog_IaftLDO, reb0_digital_IaftLDO, reb0_analog_VbefLDO, reb0_analog_IbefLDO, reb1_digital_IbefLDO, reb1_heater_IaftLDO, reb1_heater_VaftLDO, reb2_heater_IbefLDO, reb1_clockhi_IaftLDO, reb0_digital_VaftLDO, reb0_OD_VaftSwch, reb1_OD_VaftLDO, reb1_OD_VaftSwch, reb2_hvbias_IbefSwch, reb2_clockhi_VbefLDO, reb0_digital_VaftSwch, reb0_OD_VaftLDO, reb0_OD_IaftLDO, reb0_clocklo_VbefLDO, reb2_OD_VaftSwch, reb0_clocklo_IbefLDO, reb0_OD_VbefLDO, reb1_clocklo_VaftSwch, reb1_clockhi_VbefLDO, reb2_clockhi_VaftSwch, reb2_OD_VaftLDO, reb1_OD_IbefLDO, reb0_analog_IaftLDO, reb1_clocklo_IaftLDO, reb1_hvbias_VbefSwch, reb1_hvbias_IbefSwch, reb1_analog_VbefLDO, reb1_heater_VbefLDO, reb2_clocklo_VaftLDO, reb2_digital_IaftLDO, reb2_clocklo_VbefLDO, reb1_analog_VaftSwch, reb2_clocklo_VaftLDO2, reb0_clockhi_IaftLDO, reb1_analog_VaftLDO, reb0_heater_VbefLDO, reb1_heater_VaftSwch, reb0_heater_IbefLDO, reb1_digital_VaftSwch, reb0_heater_IaftLDO, reb2_digital_VbefLDO, reb2_digital_IbefLDO, reb0_clockhi_IbefLDO, reb2_analog_VaftLDO, reb1_Power, reb0_hvbias_IbefSwch, reb2_OD_IbefLDO, reb1_OD_VbefLDO, reb1_clocklo_IbefLDO, reb1_clocklo_VbefLDO, reb2_OD_VbefLDO, reb1_digital_VaftLDO, reb2_heater_VaftSwch, reb0_OD_IbefLDO, reb0_hvbias_VbefSwch, reb2_heater_VaftLDO, reb0_digital_VbefLDO, reb2_digital_VaftSwch, reb0_clocklo_VaftLDO, reb0_clockhi_VaftSwch, reb0_clocklo_IaftLDO, reb2_analog_VaftSwch, reb1_clocklo_VaftLDO2, reb2_clockhi_VaftLDO, reb0_clocklo_VaftSwch));
        Assert.assertTrue((boolean)(item instanceof Rebpower_R22Telemetry));
        Rebpower_R22Telemetry item_ = (Rebpower_R22Telemetry)item;
        Assert.assertEquals((double)reb1_analog_IbefLDO, (double)item_.getReb1_analog_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_IbefLDO, (double)item_.getReb1_heater_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_VaftSwch, (double)item_.getReb1_clockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_IaftLDO, (double)item_.getReb2_clockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_IaftLDO, (double)item_.getReb2_heater_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_VaftLDO, (double)item_.getReb2_digital_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_VaftLDO, (double)item_.getReb0_heater_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_IaftLDO, (double)item_.getReb1_digital_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_IbefLDO, (double)item_.getReb0_digital_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_Power, (double)item_.getReb0_Power(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_IaftLDO, (double)item_.getReb2_OD_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_IbefLDO, (double)item_.getReb2_clocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_VbefLDO, (double)item_.getReb1_digital_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_IbefLDO, (double)item_.getReb1_clockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_VbefLDO, (double)item_.getReb2_heater_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_VaftLDO, (double)item_.getReb1_clocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_VaftLDO, (double)item_.getReb0_analog_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_VaftSwch, (double)item_.getReb2_clocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_VbefLDO, (double)item_.getReb2_analog_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_VaftLDO, (double)item_.getReb0_clockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_hvbias_VbefSwch, (double)item_.getReb2_hvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_VaftLDO2, (double)item_.getReb2_OD_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_VaftLDO2, (double)item_.getReb1_OD_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_VbefLDO, (double)item_.getReb0_clockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_VaftLDO2, (double)item_.getReb0_OD_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_IaftLDO, (double)item_.getReb2_analog_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_IaftLDO, (double)item_.getReb2_clocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_VaftSwch, (double)item_.getReb0_analog_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_IaftLDO, (double)item_.getReb1_OD_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_VaftLDO, (double)item_.getReb1_clockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_Power, (double)item_.getReb2_Power(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_VaftLDO2, (double)item_.getReb0_clocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_IbefLDO, (double)item_.getReb2_clockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_IbefLDO, (double)item_.getReb2_analog_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_VaftSwch, (double)item_.getReb0_heater_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_analog_IaftLDO, (double)item_.getReb1_analog_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_IaftLDO, (double)item_.getReb0_digital_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_VbefLDO, (double)item_.getReb0_analog_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_IbefLDO, (double)item_.getReb0_analog_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_IbefLDO, (double)item_.getReb1_digital_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_IaftLDO, (double)item_.getReb1_heater_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_VaftLDO, (double)item_.getReb1_heater_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_IbefLDO, (double)item_.getReb2_heater_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_IaftLDO, (double)item_.getReb1_clockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_VaftLDO, (double)item_.getReb0_digital_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_VaftSwch, (double)item_.getReb0_OD_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_VaftLDO, (double)item_.getReb1_OD_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_VaftSwch, (double)item_.getReb1_OD_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_hvbias_IbefSwch, (double)item_.getReb2_hvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_VbefLDO, (double)item_.getReb2_clockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_VaftSwch, (double)item_.getReb0_digital_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_VaftLDO, (double)item_.getReb0_OD_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_IaftLDO, (double)item_.getReb0_OD_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_VbefLDO, (double)item_.getReb0_clocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_VaftSwch, (double)item_.getReb2_OD_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_IbefLDO, (double)item_.getReb0_clocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_VbefLDO, (double)item_.getReb0_OD_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_VaftSwch, (double)item_.getReb1_clocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_VbefLDO, (double)item_.getReb1_clockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_VaftSwch, (double)item_.getReb2_clockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_VaftLDO, (double)item_.getReb2_OD_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_IbefLDO, (double)item_.getReb1_OD_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_IaftLDO, (double)item_.getReb0_analog_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_IaftLDO, (double)item_.getReb1_clocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_hvbias_VbefSwch, (double)item_.getReb1_hvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_hvbias_IbefSwch, (double)item_.getReb1_hvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_analog_VbefLDO, (double)item_.getReb1_analog_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_VbefLDO, (double)item_.getReb1_heater_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_VaftLDO, (double)item_.getReb2_clocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_IaftLDO, (double)item_.getReb2_digital_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_VbefLDO, (double)item_.getReb2_clocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_analog_VaftSwch, (double)item_.getReb1_analog_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_VaftLDO2, (double)item_.getReb2_clocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_IaftLDO, (double)item_.getReb0_clockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_analog_VaftLDO, (double)item_.getReb1_analog_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_VbefLDO, (double)item_.getReb0_heater_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_VaftSwch, (double)item_.getReb1_heater_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_IbefLDO, (double)item_.getReb0_heater_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_VaftSwch, (double)item_.getReb1_digital_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_IaftLDO, (double)item_.getReb0_heater_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_VbefLDO, (double)item_.getReb2_digital_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_IbefLDO, (double)item_.getReb2_digital_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_IbefLDO, (double)item_.getReb0_clockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_VaftLDO, (double)item_.getReb2_analog_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_Power, (double)item_.getReb1_Power(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_hvbias_IbefSwch, (double)item_.getReb0_hvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_IbefLDO, (double)item_.getReb2_OD_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_VbefLDO, (double)item_.getReb1_OD_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_IbefLDO, (double)item_.getReb1_clocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_VbefLDO, (double)item_.getReb1_clocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_VbefLDO, (double)item_.getReb2_OD_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_VaftLDO, (double)item_.getReb1_digital_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_VaftSwch, (double)item_.getReb2_heater_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_IbefLDO, (double)item_.getReb0_OD_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_hvbias_VbefSwch, (double)item_.getReb0_hvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_VaftLDO, (double)item_.getReb2_heater_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_VbefLDO, (double)item_.getReb0_digital_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_VaftSwch, (double)item_.getReb2_digital_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_VaftLDO, (double)item_.getReb0_clocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_VaftSwch, (double)item_.getReb0_clockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_IaftLDO, (double)item_.getReb0_clocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_VaftSwch, (double)item_.getReb2_analog_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_VaftLDO2, (double)item_.getReb1_clocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_VaftLDO, (double)item_.getReb2_clockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_VaftSwch, (double)item_.getReb0_clocklo_VaftSwch(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebPSTelemetry() throws Exception {
        double p00_BoardTemp2 = 0.3641918897628784;
        double p00_BoardTemp3 = 0.1045953f;
        double p00_BoardTemp4 = 0.586685299873352;
        double p00_BoardTemp5 = 0.07568937540054321;
        double p00_BoardTemp0 = 0.6804636716842651;
        double p00_BoardTemp1 = 0.4218956232070923;
        double p00_BoardTemp6 = 0.5800520777702332;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebPSTelemetry(p00_BoardTemp2, p00_BoardTemp3, p00_BoardTemp4, p00_BoardTemp5, p00_BoardTemp0, p00_BoardTemp1, p00_BoardTemp6));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebPSTelemetry));
        Rebpower_RebPSTelemetry item_ = (Rebpower_RebPSTelemetry)item;
        Assert.assertEquals((double)p00_BoardTemp2, (double)item_.getP00_BoardTemp2(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp3, (double)item_.getP00_BoardTemp3(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp4, (double)item_.getP00_BoardTemp4(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp5, (double)item_.getP00_BoardTemp5(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp0, (double)item_.getP00_BoardTemp0(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp1, (double)item_.getP00_BoardTemp1(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp6, (double)item_.getP00_BoardTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VQMonitorTelemetry() throws Exception {
        double vqmpressure = 0.306423f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_VQMonitorTelemetry(vqmpressure));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitorTelemetry));
        Vacuum_VQMonitorTelemetry item_ = (Vacuum_VQMonitorTelemetry)item;
        Assert.assertEquals((double)vqmpressure, (double)item_.getVqmpressure(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumpsTelemetry() throws Exception {
        double ionpump_voltage = 0.7984023094177246;
        double ionpump_current = 0.549782395362854;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_IonPumpsTelemetry(ionpump_voltage, ionpump_current));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumpsTelemetry));
        Vacuum_IonPumpsTelemetry item_ = (Vacuum_IonPumpsTelemetry)item;
        Assert.assertEquals((double)ionpump_voltage, (double)item_.getIonpump_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)ionpump_current, (double)item_.getIonpump_current(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboTelemetry() throws Exception {
        double rpm = 0.45498377084732056;
        double power = 0.08471924066543579;
        double voltage = 0.4435202479362488;
        double turboSpeed = 0.1747344732284546;
        double pumpTemperature = 0.4860857129096985;
        double status = 0.20062655210494995;
        double cntrlrSinkTemperature = 0.5253089070320129;
        double driveFrequency = 0.49706172943115234;
        double current = 0.1789099f;
        double cntrlrAirTemperature = 0.922715425491333;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboTelemetry(rpm, power, voltage, turboSpeed, pumpTemperature, status, cntrlrSinkTemperature, driveFrequency, current, cntrlrAirTemperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboTelemetry));
        Vacuum_TurboTelemetry item_ = (Vacuum_TurboTelemetry)item;
        Assert.assertEquals((double)rpm, (double)item_.getRpm(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpTemperature, (double)item_.getPumpTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)status, (double)item_.getStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrSinkTemperature, (double)item_.getCntrlrSinkTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)driveFrequency, (double)item_.getDriveFrequency(), (double)1.0E-6f);
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrAirTemperature, (double)item_.getCntrlrAirTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double rejectTemperature = 0.21220701932907104;
        double autoOffEnabled = 0.16325223445892334;
        double power = 0.5513094067573547;
        double setPower = 0.13890838623046875;
        double temperature = 0.21476882696151733;
        double autoOnTemperature = 0.3092518448829651;
        double setpoint = 0.6099345684051514;
        double autoOffTemperature = 0.600970983505249;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(rejectTemperature, autoOffEnabled, power, setPower, temperature, autoOnTemperature, setpoint, autoOffTemperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2Telemetry() throws Exception {
        double temperature = 0.21676874160766602;
        double rejectTemperature = 0.08100646734237671;
        double autoOnTemperature = 0.9224645495414734;
        double setpoint = 0.04314148426055908;
        double power = 0.03470128774642944;
        double autoOffEnabled = 0.45235252380371094;
        double autoOffTemperature = 0.7059468626976013;
        double setPower = 0.2009183168411255;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold2Telemetry(temperature, rejectTemperature, autoOnTemperature, setpoint, power, autoOffEnabled, autoOffTemperature, setPower));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2Telemetry));
        Vacuum_Cold2Telemetry item_ = (Vacuum_Cold2Telemetry)item;
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold1Telemetry() throws Exception {
        double setPower = 0.29771554470062256;
        double power = 0.1817813515663147;
        double rejectTemperature = 0.7181359529495239;
        double autoOnTemperature = 0.9000556468963623;
        double autoOffTemperature = 0.7156334519386292;
        double temperature = 0.5936198234558105;
        double autoOffEnabled = 0.7342118620872498;
        double setpoint = 0.6810342669487;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold1Telemetry(setPower, power, rejectTemperature, autoOnTemperature, autoOffTemperature, temperature, autoOffEnabled, setpoint));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1Telemetry));
        Vacuum_Cold1Telemetry item_ = (Vacuum_Cold1Telemetry)item;
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double bpu_Maq20_I = 0.476121723651886;
        double ion_Pumps_I = 0.6187577247619629;
        double fpga_T = 0.06356239318847656;
        double bpu_Maq20_V = 0.08649373054504395;
        double fes_Shu_HCU_I = 0.007741868495941162;
        double board_T = 0.3463588356971741;
        double body_Purge_V = 0.47391778230667114;
        double pwr_Cry_HCU_V = 0.18728214502334595;
        double pwr_Cry_HCU_I = 0.4285205602645874;
        double body_Purge_I = 0.7102625370025635;
        double fes_Shu_HCU_V = 0.8721213340759277;
        double gauges_V = 0.028969526290893555;
        double main_T = 0.025536537170410156;
        double main_V = 0.929409384727478;
        double ion_Pumps_V = 0.9869453310966492;
        double main_I = 0.020075678825378418;
        double gauges_I = 0.276092529296875;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(bpu_Maq20_I, ion_Pumps_I, fpga_T, bpu_Maq20_V, fes_Shu_HCU_I, board_T, body_Purge_V, pwr_Cry_HCU_V, pwr_Cry_HCU_I, body_Purge_I, fes_Shu_HCU_V, gauges_V, main_T, main_V, ion_Pumps_V, main_I, gauges_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.8361074328422546;
        double fpga_T = 0.21995443105697632;
        double cryo_Turbo_I = 0.38420385122299194;
        double main_V = 0.31224966049194336;
        double main_T = 0.23293238878250122;
        double cryo_Turbo_V = 0.40147173404693604;
        double main_I = 0.39219456911087036;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, fpga_T, cryo_Turbo_I, main_V, main_T, cryo_Turbo_V, main_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double heater_I = 0.5753852725028992;
        double protection_I = 0.22028517723083496;
        double dirty_48V_I = 0.8018012642860413;
        double dirty_24V_I = 0.36188453435897827;
        double clean_5_24V_I = 0.3241550326347351;
        double rebps_0 = 0.9119870662689209;
        double dirty_28V_I = 0.8102445602416992;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(heater_I, protection_I, dirty_48V_I, dirty_24V_I, clean_5_24V_I, rebps_0, dirty_28V_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0, (double)item_.getRebps_0(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_B_V = 0.24977731704711914;
        double otm_0_A_V = 0.9065913558006287;
        double otm_0_A_I = 0.813798725605011;
        double otm_0_B_I = 0.8789604902267456;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_B_V, otm_0_A_V, otm_0_A_I, otm_0_B_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.9017178416252136;
        double main_T = 0.4344574213027954;
        double main_V = 0.1655225157737732;
        double main_I = 0.8238404393196106;
        double fpga_T = 0.7224611043930054;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, main_T, main_V, main_I, fpga_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
    }
}

