/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.CCSConfiguredEvent;
import org.lsst.sal.camera.event.EndInitializeGuiderEvent;
import org.lsst.sal.camera.event.EndInitializeImageEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.event.FocalPlaneDAQSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FocalPlaneHardwareIdSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FocalPlaneRaftTempControlSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FocalPlaneRaftTempControlStatusSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FocalPlaneSequencerSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FocalPlaneSummaryInfoEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 899;
        String imageType = "";
        String groupId = "e";
        String additionalKeys = "";
        String additionalValues = "j";
        int imagesInSequence = 902;
        String imageName = "lpkystpmanw";
        int imageIndex = 564;
        String imageSource = "n";
        String imageController = "d";
        String imageDate = "sqfvxu";
        int imageNumber = 782;
        double timeStampAcquisitionStart = 0.3559340238571167;
        double exposureTime = 0.24237751960754395;
        double timeStampEndOfReadout = 0.9880634546279907;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, imageType, groupId, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, timeStampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timeStampEndOfReadout, (double)item_.getTimeStampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 456;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws Exception {
        int priority = 418;
        String filterName = "";
        SALEvent item = this.testSendReceive((SALEvent)new StartSetFilterEvent(priority, filterName));
        Assert.assertTrue((boolean)(item instanceof StartSetFilterEvent));
        StartSetFilterEvent item_ = (StartSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws Exception {
        int priority = 21;
        SALEvent item = this.testSendReceive((SALEvent)new StartUnloadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent item_ = (StartUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 168;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 30;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndInitializeGuiderEvent() throws Exception {
        int priority = 83;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeGuiderEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndInitializeGuiderEvent));
        EndInitializeGuiderEvent item_ = (EndInitializeGuiderEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 996;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 89;
        String imageType = "";
        String groupId = "x";
        String additionalKeys = "";
        String additionalValues = "u";
        int imagesInSequence = 386;
        String imageName = "amoaezfanauhnnoot";
        int imageIndex = 370;
        String imageSource = "j";
        String imageController = "";
        String imageDate = "prpmldi";
        int imageNumber = 862;
        double timeStampAcquisitionStart = 0.0364545f;
        double exposureTime = 0.16007602214813232;
        String imageTag = "qcaageunvdyvuwxmpz";
        double timestampDateObs = 0.19930672645568848;
        double timestampDateEnd = 0.002245903f;
        double expTime = 0.29876023530960083;
        double darkTime = 0.21695858240127563;
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, imageType, groupId, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, expTime, darkTime));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)expTime, (double)item_.getExpTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws Exception {
        int priority = 343;
        SALEvent item = this.testSendReceive((SALEvent)new EndUnloadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent item_ = (EndUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws Exception {
        int priority = 267;
        SALEvent item = this.testSendReceive((SALEvent)new EndRotateCarouselEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent item_ = (EndRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws Exception {
        int priority = 550;
        SALEvent item = this.testSendReceive((SALEvent)new StartLoadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartLoadFilterEvent));
        StartLoadFilterEvent item_ = (StartLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 128;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 23;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveCCSConfiguredEvent() throws Exception {
        int priority = 521;
        SALEvent item = this.testSendReceive((SALEvent)new CCSConfiguredEvent(priority));
        Assert.assertTrue((boolean)(item instanceof CCSConfiguredEvent));
        CCSConfiguredEvent item_ = (CCSConfiguredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws Exception {
        int priority = 520;
        SALEvent item = this.testSendReceive((SALEvent)new EndLoadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndLoadFilterEvent));
        EndLoadFilterEvent item_ = (EndLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 452;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 405;
        String imageType = "f";
        String groupId = "";
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 744;
        String imageName = "";
        int imageIndex = 445;
        String imageSource = "mw";
        String imageController = "t";
        String imageDate = "ai";
        int imageNumber = 150;
        double timeStampAcquisitionStart = 0.2524649500846863;
        double exposureTime = 0.637143075466156;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, imageType, groupId, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeImageEvent() throws Exception {
        int priority = 744;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndInitializeImageEvent));
        EndInitializeImageEvent item_ = (EndInitializeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws Exception {
        int priority = 988;
        String filterName = "zmyymnpodojhymuggilkxlhgpseuuibuyrlojdhzqoveaoljumwxnuioaorfjzvnqofqitxyuovvualrabkzcmdpadrmgbelsctwtzrcarsgmdvjvekeuiuydtesolnhtnyevpdyypbtxoocfivmsgrsfuvgtpclhgfkkmzaxdlilkirgkocdikkwpvrrtxwoodkupplkollcjrpomewlsbnekplueqilpcjekrkrzoxdddmstg";
        SALEvent item = this.testSendReceive((SALEvent)new EndSetFilterEvent(priority, filterName));
        Assert.assertTrue((boolean)(item instanceof EndSetFilterEvent));
        EndSetFilterEvent item_ = (EndSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 322;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws Exception {
        int priority = 972;
        String filterNames = "xepfhnbalwbbvpjjlkmgjgegwjxarixcbliiqhlcuvyeokvqfqyopyzkchujmsoynpdaobosbnvaqpqbwcwopreybzpbsajryjnegvmcstfbbblnhzowivzorqcfesdkjpffyoozlesdckkxaufzjksuaglzfdnugafnvmueolsyotiiwwktnbppqswarjdvmqyjsggyhpeieyhmxsthjqexhvrnv";
        SALEvent item = this.testSendReceive((SALEvent)new AvailableFiltersEvent(priority, filterNames));
        Assert.assertTrue((boolean)(item instanceof AvailableFiltersEvent));
        AvailableFiltersEvent item_ = (AvailableFiltersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 688;
        String imageType = "t";
        String groupId = "z";
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 346;
        String imageName = "";
        int imageIndex = 571;
        String imageSource = "";
        String imageController = "";
        String imageDate = "v";
        int imageNumber = 373;
        double timeStampAcquisitionStart = 0.6869021058082581;
        double exposureTime = 0.6132139563560486;
        double timeStampStartOfReadout = 0.5931679606437683;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, imageType, groupId, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, timeStampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timeStampStartOfReadout, (double)item_.getTimeStampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws Exception {
        int priority = 39;
        SALEvent item = this.testSendReceive((SALEvent)new StartRotateCarouselEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent item_ = (StartRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 690;
        String imageName = "i";
        String ccdLocation = "";
        String raftBay = "p";
        String ccdSlot = "";
        Object[] ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V};
        int[] overRows = new int[]{440, 478, 3, 340, 962, 86, 14, 619, 68};
        int[] overCols = new int[]{333, 427, 605, 880, 253, 235, 553, 355, 719};
        int[] readRows = new int[]{230, 441, 318, 679, 846, 89, 63, 348, 159};
        int[] readCols = new int[]{874, 956, 722, 738, 242, 263, 694, 337, 178};
        int[] readCols2 = new int[]{261, 133, 237, 380, 289, 625, 74, 622, 134};
        int[] preCols = new int[]{962, 181, 615, 105, 277, 692, 813, 84, 219};
        int[] preRows = new int[]{251, 913, 951, 512, 735, 600, 106, 485, 11};
        int[] postCols = new int[]{870, 797, 525, 704, 681, 800, 202, 402, 519};
        int[] underCols = new int[]{630, 865, 757, 341, 708, 144, 102, 22, 32};
        String daqFolder = "s";
        String daqAnnotation = "z";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, ccdLocation, raftBay, ccdSlot, (ImageReadoutParametersEvent.CcdType[])ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((int[])overRows, (int[])item_.getOverRows());
        Assert.assertArrayEquals((int[])overCols, (int[])item_.getOverCols());
        Assert.assertArrayEquals((int[])readRows, (int[])item_.getReadRows());
        Assert.assertArrayEquals((int[])readCols, (int[])item_.getReadCols());
        Assert.assertArrayEquals((int[])readCols2, (int[])item_.getReadCols2());
        Assert.assertArrayEquals((int[])preCols, (int[])item_.getPreCols());
        Assert.assertArrayEquals((int[])preRows, (int[])item_.getPreRows());
        Assert.assertArrayEquals((int[])postCols, (int[])item_.getPostCols());
        Assert.assertArrayEquals((int[])underCols, (int[])item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        int priority = 509;
        String ccdLocation = "";
        String raftBay = "";
        String ccdSlot = "v";
        String rebSerialNumber = "v";
        String rebLSSTName = "s";
        String ccdLSSTName = "z";
        String raftLSSTName = "";
        String ccdManSerNum = "g";
        String ccdManufacturer = "q";
        Object[] ccdType = new FocalPlaneSummaryInfoEvent.CcdType[]{FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V};
        double[] ccdTempSetPoint = new double[]{0.2860983610153198, 0.2018665075302124, 0.8623965978622437, 0.2078021764755249, 0.027436554431915283, 0.3213622570037842, 0.8489788770675659, 0.17418742179870605, 0.08984065055847168};
        String sequencerKey = "";
        String sequencerChecksum = "x";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(priority, ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, (FocalPlaneSummaryInfoEvent.CcdType[])ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((double[])ccdTempSetPoint, (double[])item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveFocalPlaneHardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 916;
        int version = 655;
        String rebLocation = "h";
        String rebLSSTName = "l";
        String ccdLocation = "";
        String ccdLSSTName = "u";
        String ccdManSerNum = "q";
        String raftLocation = "";
        String raftLSSTName = "";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneHardwareIdSettingsAppliedEvent(priority, version, rebLocation, rebLSSTName, ccdLocation, ccdLSSTName, ccdManSerNum, raftLocation, raftLSSTName));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneHardwareIdSettingsAppliedEvent));
        FocalPlaneHardwareIdSettingsAppliedEvent item_ = (FocalPlaneHardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)rebLocation, (Object)item_.getRebLocation());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)raftLocation, (Object)item_.getRaftLocation());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
    }

    @Test
    public void sendReceiveFocalPlaneRaftTempControlStatusSettingsAppliedEvent() throws Exception {
        int priority = 32;
        int version = 393;
        String raftLocation = "";
        boolean raft_TempControl_active = true;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneRaftTempControlStatusSettingsAppliedEvent(priority, version, raftLocation, raft_TempControl_active));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneRaftTempControlStatusSettingsAppliedEvent));
        FocalPlaneRaftTempControlStatusSettingsAppliedEvent item_ = (FocalPlaneRaftTempControlStatusSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)raftLocation, (Object)item_.getRaftLocation());
        Assert.assertEquals((Object)raft_TempControl_active, (Object)item_.isRaft_TempControl_active());
    }

    @Test
    public void sendReceiveFocalPlaneRaftTempControlSettingsAppliedEvent() throws Exception {
        int priority = 309;
        int version = 522;
        String raftLocation = "";
        double raft_TempControl_awGain = 0.2250347137451172;
        double raft_TempControl_basePower = 0.3065752387046814;
        double raft_TempControl_gain = 0.4486308693885803;
        double raft_TempControl_maxInput = 0.5043429136276245;
        double raft_TempControl_maxOutput = 0.11318850517272949;
        double raft_TempControl_minInput = 0.511311f;
        double raft_TempControl_minOutput = 0.8501695990562439;
        String raft_TempControl_rebs = "";
        double raft_TempControl_setTemp = 0.13340067863464355;
        double raft_TempControl_smoothTime = 0.909978985786438;
        String raft_TempControl_tempChans = "d";
        double raft_TempControl_timeConst = 0.033549726009368896;
        double raft_TempControl_tolerance = 0.6954838037490845;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneRaftTempControlSettingsAppliedEvent(priority, version, raftLocation, raft_TempControl_awGain, raft_TempControl_basePower, raft_TempControl_gain, raft_TempControl_maxInput, raft_TempControl_maxOutput, raft_TempControl_minInput, raft_TempControl_minOutput, raft_TempControl_rebs, raft_TempControl_setTemp, raft_TempControl_smoothTime, raft_TempControl_tempChans, raft_TempControl_timeConst, raft_TempControl_tolerance));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneRaftTempControlSettingsAppliedEvent));
        FocalPlaneRaftTempControlSettingsAppliedEvent item_ = (FocalPlaneRaftTempControlSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)raftLocation, (Object)item_.getRaftLocation());
        Assert.assertEquals((double)raft_TempControl_awGain, (double)item_.getRaft_TempControl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_basePower, (double)item_.getRaft_TempControl_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_gain, (double)item_.getRaft_TempControl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_maxInput, (double)item_.getRaft_TempControl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_maxOutput, (double)item_.getRaft_TempControl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_minInput, (double)item_.getRaft_TempControl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_minOutput, (double)item_.getRaft_TempControl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)raft_TempControl_rebs, (Object)item_.getRaft_TempControl_rebs());
        Assert.assertEquals((double)raft_TempControl_setTemp, (double)item_.getRaft_TempControl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_smoothTime, (double)item_.getRaft_TempControl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)raft_TempControl_tempChans, (Object)item_.getRaft_TempControl_tempChans());
        Assert.assertEquals((double)raft_TempControl_timeConst, (double)item_.getRaft_TempControl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_tolerance, (double)item_.getRaft_TempControl_tolerance(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocalPlaneDAQSettingsAppliedEvent() throws Exception {
        int priority = 842;
        int version = 38;
        String sequencerconfig_daqFolder = "";
        boolean sequencerconfig_emulatedDAQ = true;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneDAQSettingsAppliedEvent(priority, version, sequencerconfig_daqFolder, sequencerconfig_emulatedDAQ));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneDAQSettingsAppliedEvent));
        FocalPlaneDAQSettingsAppliedEvent item_ = (FocalPlaneDAQSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)sequencerconfig_daqFolder, (Object)item_.getSequencerconfig_daqFolder());
        Assert.assertEquals((Object)sequencerconfig_emulatedDAQ, (Object)item_.isSequencerconfig_emulatedDAQ());
    }

    @Test
    public void sendReceiveFocalPlaneSequencerSettingsAppliedEvent() throws Exception {
        int priority = 993;
        int version = 496;
        String sequencerconfig_metaDataRegisters = "g";
        int sequencerconfig_overCols = 374;
        int sequencerconfig_overRows = 476;
        int sequencerconfig_postCols = 490;
        int sequencerconfig_postRows = 557;
        int sequencerconfig_preCols = 366;
        int sequencerconfig_preRows = 525;
        int sequencerconfig_readCols = 265;
        int sequencerconfig_readCols2 = 565;
        int sequencerconfig_readRows = 106;
        boolean sequencerconfig_scanMode = true;
        String sequencerconfig_sequencer = "";
        int sequencerconfig_underCols = 267;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSequencerSettingsAppliedEvent(priority, version, sequencerconfig_metaDataRegisters, sequencerconfig_overCols, sequencerconfig_overRows, sequencerconfig_postCols, sequencerconfig_postRows, sequencerconfig_preCols, sequencerconfig_preRows, sequencerconfig_readCols, sequencerconfig_readCols2, sequencerconfig_readRows, sequencerconfig_scanMode, sequencerconfig_sequencer, sequencerconfig_underCols));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSequencerSettingsAppliedEvent));
        FocalPlaneSequencerSettingsAppliedEvent item_ = (FocalPlaneSequencerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)sequencerconfig_metaDataRegisters, (Object)item_.getSequencerconfig_metaDataRegisters());
        Assert.assertEquals((long)sequencerconfig_overCols, (long)item_.getSequencerconfig_overCols());
        Assert.assertEquals((long)sequencerconfig_overRows, (long)item_.getSequencerconfig_overRows());
        Assert.assertEquals((long)sequencerconfig_postCols, (long)item_.getSequencerconfig_postCols());
        Assert.assertEquals((long)sequencerconfig_postRows, (long)item_.getSequencerconfig_postRows());
        Assert.assertEquals((long)sequencerconfig_preCols, (long)item_.getSequencerconfig_preCols());
        Assert.assertEquals((long)sequencerconfig_preRows, (long)item_.getSequencerconfig_preRows());
        Assert.assertEquals((long)sequencerconfig_readCols, (long)item_.getSequencerconfig_readCols());
        Assert.assertEquals((long)sequencerconfig_readCols2, (long)item_.getSequencerconfig_readCols2());
        Assert.assertEquals((long)sequencerconfig_readRows, (long)item_.getSequencerconfig_readRows());
        Assert.assertEquals((Object)sequencerconfig_scanMode, (Object)item_.isSequencerconfig_scanMode());
        Assert.assertEquals((Object)sequencerconfig_sequencer, (Object)item_.getSequencerconfig_sequencer());
        Assert.assertEquals((long)sequencerconfig_underCols, (long)item_.getSequencerconfig_underCols());
    }

    @Test
    public void sendReceiveSettingVersionsEvent() throws Exception {
        int priority = 515;
        String recommendedSettingsVersion = "";
        String recommendedSettingsLabels = "";
        String settingsUrl = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingVersionsEvent(priority, recommendedSettingsVersion, recommendedSettingsLabels, settingsUrl));
        Assert.assertTrue((boolean)(item instanceof SettingVersionsEvent));
        SettingVersionsEvent item_ = (SettingVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)recommendedSettingsVersion, (Object)item_.getRecommendedSettingsVersion());
        Assert.assertEquals((Object)recommendedSettingsLabels, (Object)item_.getRecommendedSettingsLabels());
        Assert.assertEquals((Object)settingsUrl, (Object)item_.getSettingsUrl());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 670;
        int errorCode = 429;
        String errorReport = "";
        String traceback = "l";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveAppliedSettingsMatchStartEvent() throws Exception {
        int priority = 868;
        boolean appliedSettingsMatchStartIsTrue = false;
        SALEvent item = this.testSendReceive((SALEvent)new AppliedSettingsMatchStartEvent(priority, appliedSettingsMatchStartIsTrue));
        Assert.assertTrue((boolean)(item instanceof AppliedSettingsMatchStartEvent));
        AppliedSettingsMatchStartEvent item_ = (AppliedSettingsMatchStartEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)appliedSettingsMatchStartIsTrue, (Object)item_.isAppliedSettingsMatchStartIsTrue());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 780;
        int level = 41;
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 185;
        String name = "";
        int level = 772;
        String message = "f";
        String traceback = "q";
        String filePath = "";
        String functionName = "g";
        int lineNumber = 582;
        int process = 172;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, name, level, message, traceback, filePath, functionName, lineNumber, process));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
    }

    @Test
    public void sendReceiveSettingsAppliedEvent() throws Exception {
        int priority = 314;
        String settingsVersion = "xxzkwwneoogvaqaqwbdxpekigtoptrbizuvelqbeqaztjdwyysopgkrcfzmbojfboddazlbejnzmrgoqsnypfrtnqtmoqgwhdfjgfblquwnporwzppfwqkbngkuzdwzidmnqjbswmaywayynowtrwnulfacxhnmwrnxivxmzbatnddasc";
        String otherSettingsEvents = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingsAppliedEvent(priority, settingsVersion, otherSettingsEvents));
        Assert.assertTrue((boolean)(item instanceof SettingsAppliedEvent));
        SettingsAppliedEvent item_ = (SettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)settingsVersion, (Object)item_.getSettingsVersion());
        Assert.assertEquals((Object)otherSettingsEvents, (Object)item_.getOtherSettingsEvents());
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 135;
        int mode = 700;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 705;
        String salVersion = "";
        String xmlVersion = "cfkvyqfaa";
        String openSpliceVersion = "dyphkrogiab";
        String cscVersion = "ydtauvlrcbin";
        String subsystemVersions = "v";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 314;
        boolean heartbeat = false;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        int priority = 634;
        String authorizedUsers = "";
        String nonAuthorizedCSCs = "d";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(priority, authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }
}

