/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.telemetry.BonnShutterTelemetry;
import org.lsst.sal.cccamera.telemetry.FilterChangerTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_R22Telemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebPSTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFilterChangerTelemetry() throws Exception {
        float motorTemperature = 0.75309825f;
        float motorEncoder = 0.6354634f;
        float linearPosition = 0.114198625f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FilterChangerTelemetry(motorTemperature, motorEncoder, linearPosition));
        Assert.assertTrue((boolean)(item instanceof FilterChangerTelemetry));
        FilterChangerTelemetry item_ = (FilterChangerTelemetry)item;
        Assert.assertEquals((float)motorTemperature, (float)item_.getMotorTemperature(), (float)1.0E-6f);
        Assert.assertEquals((float)motorEncoder, (float)item_.getMotorEncoder(), (float)1.0E-6f);
        Assert.assertEquals((float)linearPosition, (float)item_.getLinearPosition(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveBonnShutterTelemetry() throws Exception {
        float shutter5V = 0.06763822f;
        float shutter36V = 0.15208107f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new BonnShutterTelemetry(shutter5V, shutter36V));
        Assert.assertTrue((boolean)(item instanceof BonnShutterTelemetry));
        BonnShutterTelemetry item_ = (BonnShutterTelemetry)item;
        Assert.assertEquals((float)shutter5V, (float)item_.getShutter5V(), (float)1.0E-6f);
        Assert.assertEquals((float)shutter36V, (float)item_.getShutter36V(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_R22Telemetry() throws Exception {
        double reb1_analog_IbefLDO = 0.502015f;
        double reb1_heater_IbefLDO = 0.4687958359718323;
        double reb1_clockhi_VaftSwch = 0.2776569128036499;
        double reb2_clockhi_IaftLDO = 0.8017957806587219;
        double reb2_heater_IaftLDO = 0.646397590637207;
        double reb2_digital_VaftLDO = 0.11037266254425049;
        double reb0_heater_VaftLDO = 0.4113478f;
        double reb1_digital_IaftLDO = 0.2250347137451172;
        double reb0_digital_IbefLDO = 0.3065752387046814;
        double reb0_Power = 0.4486308693885803;
        double reb2_OD_IaftLDO = 0.5043429136276245;
        double reb2_clocklo_IbefLDO = 0.11318850517272949;
        double reb1_digital_VbefLDO = 0.511311f;
        double reb1_clockhi_IbefLDO = 0.8501695990562439;
        double reb2_heater_VbefLDO = 0.10861527919769287;
        double reb1_clocklo_VaftLDO = 0.13340067863464355;
        double reb0_analog_VaftLDO = 0.909978985786438;
        double reb2_clocklo_VaftSwch = 0.632366418838501;
        double reb2_analog_VbefLDO = 0.8650884032249451;
        double reb0_clockhi_VaftLDO = 0.033549726009368896;
        double reb2_hvbias_VbefSwch = 0.6954838037490845;
        double reb2_OD_VaftLDO2 = 0.11287665367126465;
        double reb1_OD_VaftLDO2 = 0.674673318862915;
        double reb0_clockhi_VbefLDO = 0.06375402212142944;
        double reb0_OD_VaftLDO2 = 0.5577300786972046;
        double reb2_analog_IaftLDO = 0.0346936f;
        double reb2_clocklo_IaftLDO = 0.25591927766799927;
        double reb0_analog_VaftSwch = 0.861728f;
        double reb1_OD_IaftLDO = 0.6790806651115417;
        double reb1_clockhi_VaftLDO = 0.500071f;
        double reb2_Power = 0.0706256628036499;
        double reb0_clocklo_VaftLDO2 = 0.5492081046104431;
        double reb2_clockhi_IbefLDO = 0.5675011873245239;
        double reb2_analog_IbefLDO = 0.2477231f;
        double reb0_heater_VaftSwch = 0.6511227488517761;
        double reb1_analog_IaftLDO = 0.25721925497055054;
        double reb0_digital_IaftLDO = 0.053745925426483154;
        double reb0_analog_VbefLDO = 0.13506555557250977;
        double reb0_analog_IbefLDO = 0.5684199333190918;
        double reb1_digital_IbefLDO = 0.1792144775390625;
        double reb1_heater_IaftLDO = 0.420258f;
        double reb1_heater_VaftLDO = 0.24494272470474243;
        double reb2_heater_IbefLDO = 0.3861231803894043;
        double reb1_clockhi_IaftLDO = 0.47374796867370605;
        double reb0_digital_VaftLDO = 0.32380956411361694;
        double reb0_OD_VaftSwch = 0.34402942657470703;
        double reb1_OD_VaftLDO = 0.40112733840942383;
        double reb1_OD_VaftSwch = 0.4736320972442627;
        double reb2_hvbias_IbefSwch = 0.6918114423751831;
        double reb2_clockhi_VbefLDO = 0.963251531124115;
        double reb0_digital_VaftSwch = 0.18191653490066528;
        double reb0_OD_VaftLDO = 0.16838771104812622;
        double reb0_OD_IaftLDO = 0.9623038172721863;
        double reb0_clocklo_VbefLDO = 0.15011334419250488;
        double reb2_OD_VaftSwch = 0.48530107736587524;
        double reb0_clocklo_IbefLDO = 0.4137721657752991;
        double reb0_OD_VbefLDO = 0.0766598f;
        double reb1_clocklo_VaftSwch = 0.7253578305244446;
        double reb1_clockhi_VbefLDO = 0.1221545934677124;
        double reb2_clockhi_VaftSwch = 0.779416024684906;
        double reb2_OD_VaftLDO = 0.2768756151199341;
        double reb1_OD_IbefLDO = 0.4441349506378174;
        double reb0_analog_IaftLDO = 0.5148841738700867;
        double reb1_clocklo_IaftLDO = 0.00691455602645874;
        double reb1_hvbias_VbefSwch = 0.5889905095100403;
        double reb1_hvbias_IbefSwch = 0.862678587436676;
        double reb1_analog_VbefLDO = 0.759788f;
        double reb1_heater_VbefLDO = 0.24051225185394287;
        double reb2_clocklo_VaftLDO = 0.5518115162849426;
        double reb2_digital_IaftLDO = 0.5088573098182678;
        double reb2_clocklo_VbefLDO = 0.8950796723365784;
        double reb1_analog_VaftSwch = 0.17582905292510986;
        double reb2_clocklo_VaftLDO2 = 0.26496803760528564;
        double reb0_clockhi_IaftLDO = 0.4779793620109558;
        double reb1_analog_VaftLDO = 0.15224981307983398;
        double reb0_heater_VbefLDO = 0.10457044839859009;
        double reb1_heater_VaftSwch = 0.7497748136520386;
        double reb0_heater_IbefLDO = 0.1686194f;
        double reb1_digital_VaftSwch = 0.30979394912719727;
        double reb0_heater_IaftLDO = 0.21112632751464844;
        double reb2_digital_VbefLDO = 0.3359434f;
        double reb2_digital_IbefLDO = 0.147347092628479;
        double reb0_clockhi_IbefLDO = 0.9024807214736938;
        double reb2_analog_VaftLDO = 0.9873150587081909;
        double reb1_Power = 0.7804882526397705;
        double reb0_hvbias_IbefSwch = 0.21205365657806396;
        double reb2_OD_IbefLDO = 0.19770705699920654;
        double reb1_OD_VbefLDO = 0.0017998814582824707;
        double reb1_clocklo_IbefLDO = 0.893978476524353;
        double reb1_clocklo_VbefLDO = 0.5026865005493164;
        double reb2_OD_VbefLDO = 0.2176659107208252;
        double reb1_digital_VaftLDO = 0.6090694069862366;
        double reb2_heater_VaftSwch = 0.9734766483306885;
        double reb0_OD_IbefLDO = 0.8928537964820862;
        double reb0_hvbias_VbefSwch = 0.0497211217880249;
        double reb2_heater_VaftLDO = 0.2681116461753845;
        double reb0_digital_VbefLDO = 0.529084324836731;
        double reb2_digital_VaftSwch = 0.05878615379333496;
        double reb0_clocklo_VaftLDO = 0.5883772969245911;
        double reb0_clockhi_VaftSwch = 0.6124424338340759;
        double reb0_clocklo_IaftLDO = 0.928119f;
        double reb2_analog_VaftSwch = 0.25203055143356323;
        double reb1_clocklo_VaftLDO2 = 0.23448187112808228;
        double reb2_clockhi_VaftLDO = 0.06101113557815552;
        double reb0_clocklo_VaftSwch = 0.2818338871002197;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_R22Telemetry(reb1_analog_IbefLDO, reb1_heater_IbefLDO, reb1_clockhi_VaftSwch, reb2_clockhi_IaftLDO, reb2_heater_IaftLDO, reb2_digital_VaftLDO, reb0_heater_VaftLDO, reb1_digital_IaftLDO, reb0_digital_IbefLDO, reb0_Power, reb2_OD_IaftLDO, reb2_clocklo_IbefLDO, reb1_digital_VbefLDO, reb1_clockhi_IbefLDO, reb2_heater_VbefLDO, reb1_clocklo_VaftLDO, reb0_analog_VaftLDO, reb2_clocklo_VaftSwch, reb2_analog_VbefLDO, reb0_clockhi_VaftLDO, reb2_hvbias_VbefSwch, reb2_OD_VaftLDO2, reb1_OD_VaftLDO2, reb0_clockhi_VbefLDO, reb0_OD_VaftLDO2, reb2_analog_IaftLDO, reb2_clocklo_IaftLDO, reb0_analog_VaftSwch, reb1_OD_IaftLDO, reb1_clockhi_VaftLDO, reb2_Power, reb0_clocklo_VaftLDO2, reb2_clockhi_IbefLDO, reb2_analog_IbefLDO, reb0_heater_VaftSwch, reb1_analog_IaftLDO, reb0_digital_IaftLDO, reb0_analog_VbefLDO, reb0_analog_IbefLDO, reb1_digital_IbefLDO, reb1_heater_IaftLDO, reb1_heater_VaftLDO, reb2_heater_IbefLDO, reb1_clockhi_IaftLDO, reb0_digital_VaftLDO, reb0_OD_VaftSwch, reb1_OD_VaftLDO, reb1_OD_VaftSwch, reb2_hvbias_IbefSwch, reb2_clockhi_VbefLDO, reb0_digital_VaftSwch, reb0_OD_VaftLDO, reb0_OD_IaftLDO, reb0_clocklo_VbefLDO, reb2_OD_VaftSwch, reb0_clocklo_IbefLDO, reb0_OD_VbefLDO, reb1_clocklo_VaftSwch, reb1_clockhi_VbefLDO, reb2_clockhi_VaftSwch, reb2_OD_VaftLDO, reb1_OD_IbefLDO, reb0_analog_IaftLDO, reb1_clocklo_IaftLDO, reb1_hvbias_VbefSwch, reb1_hvbias_IbefSwch, reb1_analog_VbefLDO, reb1_heater_VbefLDO, reb2_clocklo_VaftLDO, reb2_digital_IaftLDO, reb2_clocklo_VbefLDO, reb1_analog_VaftSwch, reb2_clocklo_VaftLDO2, reb0_clockhi_IaftLDO, reb1_analog_VaftLDO, reb0_heater_VbefLDO, reb1_heater_VaftSwch, reb0_heater_IbefLDO, reb1_digital_VaftSwch, reb0_heater_IaftLDO, reb2_digital_VbefLDO, reb2_digital_IbefLDO, reb0_clockhi_IbefLDO, reb2_analog_VaftLDO, reb1_Power, reb0_hvbias_IbefSwch, reb2_OD_IbefLDO, reb1_OD_VbefLDO, reb1_clocklo_IbefLDO, reb1_clocklo_VbefLDO, reb2_OD_VbefLDO, reb1_digital_VaftLDO, reb2_heater_VaftSwch, reb0_OD_IbefLDO, reb0_hvbias_VbefSwch, reb2_heater_VaftLDO, reb0_digital_VbefLDO, reb2_digital_VaftSwch, reb0_clocklo_VaftLDO, reb0_clockhi_VaftSwch, reb0_clocklo_IaftLDO, reb2_analog_VaftSwch, reb1_clocklo_VaftLDO2, reb2_clockhi_VaftLDO, reb0_clocklo_VaftSwch));
        Assert.assertTrue((boolean)(item instanceof Rebpower_R22Telemetry));
        Rebpower_R22Telemetry item_ = (Rebpower_R22Telemetry)item;
        Assert.assertEquals((double)reb1_analog_IbefLDO, (double)item_.getReb1_analog_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_IbefLDO, (double)item_.getReb1_heater_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_VaftSwch, (double)item_.getReb1_clockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_IaftLDO, (double)item_.getReb2_clockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_IaftLDO, (double)item_.getReb2_heater_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_VaftLDO, (double)item_.getReb2_digital_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_VaftLDO, (double)item_.getReb0_heater_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_IaftLDO, (double)item_.getReb1_digital_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_IbefLDO, (double)item_.getReb0_digital_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_Power, (double)item_.getReb0_Power(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_IaftLDO, (double)item_.getReb2_OD_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_IbefLDO, (double)item_.getReb2_clocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_VbefLDO, (double)item_.getReb1_digital_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_IbefLDO, (double)item_.getReb1_clockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_VbefLDO, (double)item_.getReb2_heater_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_VaftLDO, (double)item_.getReb1_clocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_VaftLDO, (double)item_.getReb0_analog_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_VaftSwch, (double)item_.getReb2_clocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_VbefLDO, (double)item_.getReb2_analog_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_VaftLDO, (double)item_.getReb0_clockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_hvbias_VbefSwch, (double)item_.getReb2_hvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_VaftLDO2, (double)item_.getReb2_OD_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_VaftLDO2, (double)item_.getReb1_OD_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_VbefLDO, (double)item_.getReb0_clockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_VaftLDO2, (double)item_.getReb0_OD_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_IaftLDO, (double)item_.getReb2_analog_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_IaftLDO, (double)item_.getReb2_clocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_VaftSwch, (double)item_.getReb0_analog_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_IaftLDO, (double)item_.getReb1_OD_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_VaftLDO, (double)item_.getReb1_clockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_Power, (double)item_.getReb2_Power(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_VaftLDO2, (double)item_.getReb0_clocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_IbefLDO, (double)item_.getReb2_clockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_IbefLDO, (double)item_.getReb2_analog_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_VaftSwch, (double)item_.getReb0_heater_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_analog_IaftLDO, (double)item_.getReb1_analog_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_IaftLDO, (double)item_.getReb0_digital_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_VbefLDO, (double)item_.getReb0_analog_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_IbefLDO, (double)item_.getReb0_analog_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_IbefLDO, (double)item_.getReb1_digital_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_IaftLDO, (double)item_.getReb1_heater_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_VaftLDO, (double)item_.getReb1_heater_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_IbefLDO, (double)item_.getReb2_heater_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_IaftLDO, (double)item_.getReb1_clockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_VaftLDO, (double)item_.getReb0_digital_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_VaftSwch, (double)item_.getReb0_OD_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_VaftLDO, (double)item_.getReb1_OD_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_VaftSwch, (double)item_.getReb1_OD_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_hvbias_IbefSwch, (double)item_.getReb2_hvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_VbefLDO, (double)item_.getReb2_clockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_VaftSwch, (double)item_.getReb0_digital_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_VaftLDO, (double)item_.getReb0_OD_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_IaftLDO, (double)item_.getReb0_OD_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_VbefLDO, (double)item_.getReb0_clocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_VaftSwch, (double)item_.getReb2_OD_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_IbefLDO, (double)item_.getReb0_clocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_VbefLDO, (double)item_.getReb0_OD_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_VaftSwch, (double)item_.getReb1_clocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_VbefLDO, (double)item_.getReb1_clockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_VaftSwch, (double)item_.getReb2_clockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_VaftLDO, (double)item_.getReb2_OD_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_IbefLDO, (double)item_.getReb1_OD_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_IaftLDO, (double)item_.getReb0_analog_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_IaftLDO, (double)item_.getReb1_clocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_hvbias_VbefSwch, (double)item_.getReb1_hvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_hvbias_IbefSwch, (double)item_.getReb1_hvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_analog_VbefLDO, (double)item_.getReb1_analog_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_VbefLDO, (double)item_.getReb1_heater_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_VaftLDO, (double)item_.getReb2_clocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_IaftLDO, (double)item_.getReb2_digital_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_VbefLDO, (double)item_.getReb2_clocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_analog_VaftSwch, (double)item_.getReb1_analog_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_VaftLDO2, (double)item_.getReb2_clocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_IaftLDO, (double)item_.getReb0_clockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_analog_VaftLDO, (double)item_.getReb1_analog_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_VbefLDO, (double)item_.getReb0_heater_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_VaftSwch, (double)item_.getReb1_heater_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_IbefLDO, (double)item_.getReb0_heater_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_VaftSwch, (double)item_.getReb1_digital_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_IaftLDO, (double)item_.getReb0_heater_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_VbefLDO, (double)item_.getReb2_digital_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_IbefLDO, (double)item_.getReb2_digital_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_IbefLDO, (double)item_.getReb0_clockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_VaftLDO, (double)item_.getReb2_analog_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_Power, (double)item_.getReb1_Power(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_hvbias_IbefSwch, (double)item_.getReb0_hvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_IbefLDO, (double)item_.getReb2_OD_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_VbefLDO, (double)item_.getReb1_OD_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_IbefLDO, (double)item_.getReb1_clocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_VbefLDO, (double)item_.getReb1_clocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_VbefLDO, (double)item_.getReb2_OD_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_VaftLDO, (double)item_.getReb1_digital_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_VaftSwch, (double)item_.getReb2_heater_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_IbefLDO, (double)item_.getReb0_OD_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_hvbias_VbefSwch, (double)item_.getReb0_hvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_VaftLDO, (double)item_.getReb2_heater_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_VbefLDO, (double)item_.getReb0_digital_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_VaftSwch, (double)item_.getReb2_digital_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_VaftLDO, (double)item_.getReb0_clocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_VaftSwch, (double)item_.getReb0_clockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_IaftLDO, (double)item_.getReb0_clocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_VaftSwch, (double)item_.getReb2_analog_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_VaftLDO2, (double)item_.getReb1_clocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_VaftLDO, (double)item_.getReb2_clockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_VaftSwch, (double)item_.getReb0_clocklo_VaftSwch(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebPSTelemetry() throws Exception {
        double p00_BoardTemp2 = 0.35309863090515137;
        double p00_BoardTemp3 = 0.937881f;
        double p00_BoardTemp4 = 0.7643618583679199;
        double p00_BoardTemp5 = 0.35663992166519165;
        double p00_BoardTemp0 = 0.7248210906982422;
        double p00_BoardTemp1 = 0.00886458158493042;
        double p00_BoardTemp6 = 0.8635683059692383;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebPSTelemetry(p00_BoardTemp2, p00_BoardTemp3, p00_BoardTemp4, p00_BoardTemp5, p00_BoardTemp0, p00_BoardTemp1, p00_BoardTemp6));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebPSTelemetry));
        Rebpower_RebPSTelemetry item_ = (Rebpower_RebPSTelemetry)item;
        Assert.assertEquals((double)p00_BoardTemp2, (double)item_.getP00_BoardTemp2(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp3, (double)item_.getP00_BoardTemp3(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp4, (double)item_.getP00_BoardTemp4(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp5, (double)item_.getP00_BoardTemp5(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp0, (double)item_.getP00_BoardTemp0(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp1, (double)item_.getP00_BoardTemp1(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp6, (double)item_.getP00_BoardTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VQMonitorTelemetry() throws Exception {
        double vqmpressure = 0.525514f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_VQMonitorTelemetry(vqmpressure));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitorTelemetry));
        Vacuum_VQMonitorTelemetry item_ = (Vacuum_VQMonitorTelemetry)item;
        Assert.assertEquals((double)vqmpressure, (double)item_.getVqmpressure(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumpsTelemetry() throws Exception {
        double ionpump_voltage = 0.4517327547073364;
        double ionpump_current = 0.9946938753128052;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_IonPumpsTelemetry(ionpump_voltage, ionpump_current));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumpsTelemetry));
        Vacuum_IonPumpsTelemetry item_ = (Vacuum_IonPumpsTelemetry)item;
        Assert.assertEquals((double)ionpump_voltage, (double)item_.getIonpump_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)ionpump_current, (double)item_.getIonpump_current(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboTelemetry() throws Exception {
        double rpm = 0.11279827356338501;
        double power = 0.8843053579330444;
        double voltage = 0.9963942170143127;
        double turboSpeed = 0.4767602f;
        double pumpTemperature = 0.7324386835098267;
        double status = 0.0687408447265625;
        double cntrlrSinkTemperature = 0.14175671339035034;
        double driveFrequency = 0.2010408f;
        double current = 0.16168522834777832;
        double cntrlrAirTemperature = 0.02596902847290039;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboTelemetry(rpm, power, voltage, turboSpeed, pumpTemperature, status, cntrlrSinkTemperature, driveFrequency, current, cntrlrAirTemperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboTelemetry));
        Vacuum_TurboTelemetry item_ = (Vacuum_TurboTelemetry)item;
        Assert.assertEquals((double)rpm, (double)item_.getRpm(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpTemperature, (double)item_.getPumpTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)status, (double)item_.getStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrSinkTemperature, (double)item_.getCntrlrSinkTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)driveFrequency, (double)item_.getDriveFrequency(), (double)1.0E-6f);
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrAirTemperature, (double)item_.getCntrlrAirTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double rejectTemperature = 0.35271936655044556;
        double autoOffEnabled = 0.522193193435669;
        double power = 0.05116891860961914;
        double setPower = 0.8524715900421143;
        double temperature = 0.677761971950531;
        double autoOnTemperature = 0.6856864094734192;
        double setpoint = 0.15195822715759277;
        double autoOffTemperature = 0.7192482352256775;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(rejectTemperature, autoOffEnabled, power, setPower, temperature, autoOnTemperature, setpoint, autoOffTemperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2Telemetry() throws Exception {
        double temperature = 0.8364443778991699;
        double rejectTemperature = 0.161748468875885;
        double autoOnTemperature = 0.6321895122528076;
        double setpoint = 0.10460102558135986;
        double power = 0.7797408103942871;
        double autoOffEnabled = 0.7016832828521729;
        double autoOffTemperature = 0.0922970175743103;
        double setPower = 0.8619933128356934;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold2Telemetry(temperature, rejectTemperature, autoOnTemperature, setpoint, power, autoOffEnabled, autoOffTemperature, setPower));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2Telemetry));
        Vacuum_Cold2Telemetry item_ = (Vacuum_Cold2Telemetry)item;
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold1Telemetry() throws Exception {
        double setPower = 0.3623538017272949;
        double power = 0.33647865056991577;
        double rejectTemperature = 0.10063028335571289;
        double autoOnTemperature = 0.710841f;
        double autoOffTemperature = 0.6896804571151733;
        double temperature = 0.4579014182090759;
        double autoOffEnabled = 0.2700703740119934;
        double setpoint = 0.27534347772598267;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold1Telemetry(setPower, power, rejectTemperature, autoOnTemperature, autoOffTemperature, temperature, autoOffEnabled, setpoint));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1Telemetry));
        Vacuum_Cold1Telemetry item_ = (Vacuum_Cold1Telemetry)item;
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double bpu_Maq20_I = 0.5729556679725647;
        double ion_Pumps_I = 0.8949098587036133;
        double fpga_T = 0.7206348180770874;
        double bpu_Maq20_V = 0.8623384237289429;
        double fes_Shu_HCU_I = 0.4858793616294861;
        double board_T = 0.45777201652526855;
        double body_Purge_V = 0.5911467671394348;
        double pwr_Cry_HCU_V = 0.393549382686615;
        double pwr_Cry_HCU_I = 0.6219715476036072;
        double body_Purge_I = 0.40645831823349;
        double fes_Shu_HCU_V = 0.0836363434791565;
        double gauges_V = 0.748494029045105;
        double main_T = 0.5268413424491882;
        double main_V = 0.29950016736984253;
        double ion_Pumps_V = 0.24664908647537231;
        double main_I = 0.767871618270874;
        double gauges_I = 0.2619808316230774;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(bpu_Maq20_I, ion_Pumps_I, fpga_T, bpu_Maq20_V, fes_Shu_HCU_I, board_T, body_Purge_V, pwr_Cry_HCU_V, pwr_Cry_HCU_I, body_Purge_I, fes_Shu_HCU_V, gauges_V, main_T, main_V, ion_Pumps_V, main_I, gauges_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.48851585388183594;
        double fpga_T = 0.3681f;
        double cryo_Turbo_I = 0.177703857421875;
        double main_V = 0.8507076501846313;
        double main_T = 0.3890703320503235;
        double cryo_Turbo_V = 0.8853934407234192;
        double main_I = 0.16424894332885742;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, fpga_T, cryo_Turbo_I, main_V, main_T, cryo_Turbo_V, main_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double heater_I = 0.582197368144989;
        double protection_I = 0.5306582450866699;
        double dirty_48V_I = 0.2015218734741211;
        double dirty_24V_I = 0.5292513370513916;
        double clean_5_24V_I = 0.5915347337722778;
        double rebps_0 = 0.17069f;
        double dirty_28V_I = 0.6826686859130859;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(heater_I, protection_I, dirty_48V_I, dirty_24V_I, clean_5_24V_I, rebps_0, dirty_28V_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0, (double)item_.getRebps_0(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_B_V = 0.6330636143684387;
        double otm_0_A_V = 0.49333226680755615;
        double otm_0_A_I = 0.05587393045425415;
        double otm_0_B_I = 0.5080180764198303;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_B_V, otm_0_A_V, otm_0_A_I, otm_0_B_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.3663373f;
        double main_T = 0.9903306365013123;
        double main_V = 0.28888654708862305;
        double main_I = 0.43917596340179443;
        double fpga_T = 0.4342119097709656;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, main_T, main_V, main_I, fpga_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
    }
}

