/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.telemetry.BonnShutterTelemetry;
import org.lsst.sal.cccamera.telemetry.FilterChangerTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_R22Telemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebPSTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFilterChangerTelemetry() throws Exception {
        float motorTemperature = 0.10977274f;
        float motorEncoder = 0.5512157f;
        float linearPosition = 0.39684182f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FilterChangerTelemetry(motorTemperature, motorEncoder, linearPosition));
        Assert.assertTrue((boolean)(item instanceof FilterChangerTelemetry));
        FilterChangerTelemetry item_ = (FilterChangerTelemetry)item;
        Assert.assertEquals((float)motorTemperature, (float)item_.getMotorTemperature(), (float)1.0E-6f);
        Assert.assertEquals((float)motorEncoder, (float)item_.getMotorEncoder(), (float)1.0E-6f);
        Assert.assertEquals((float)linearPosition, (float)item_.getLinearPosition(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveBonnShutterTelemetry() throws Exception {
        float shutter5V = 0.052951694f;
        float shutter36V = 0.6895899f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new BonnShutterTelemetry(shutter5V, shutter36V));
        Assert.assertTrue((boolean)(item instanceof BonnShutterTelemetry));
        BonnShutterTelemetry item_ = (BonnShutterTelemetry)item;
        Assert.assertEquals((float)shutter5V, (float)item_.getShutter5V(), (float)1.0E-6f);
        Assert.assertEquals((float)shutter36V, (float)item_.getShutter36V(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_R22Telemetry() throws Exception {
        double reb1_analog_IbefLDO = 0.855726f;
        double reb1_heater_IbefLDO = 0.2652818560600281;
        double reb1_clockhi_VaftSwch = 0.9297782182693481;
        double reb2_clockhi_IaftLDO = 0.7525027394294739;
        double reb2_heater_IaftLDO = 0.8187400698661804;
        double reb2_digital_VaftLDO = 0.9196393489837646;
        double reb0_heater_VaftLDO = 0.8585658669471741;
        double reb1_digital_IaftLDO = 0.6897554993629456;
        double reb0_digital_IbefLDO = 0.7235310673713684;
        double reb0_Power = 0.2210521101951599;
        double reb2_OD_IaftLDO = 8.614659309387207E-4;
        double reb2_clocklo_IbefLDO = 0.758385f;
        double reb1_digital_VbefLDO = 0.986163318157196;
        double reb1_clockhi_IbefLDO = 0.8220734000205994;
        double reb2_heater_VbefLDO = 0.2030126452445984;
        double reb1_clocklo_VaftLDO = 0.1932382583618164;
        double reb0_analog_VaftLDO = 0.062367022037506104;
        double reb2_clocklo_VaftSwch = 0.7379392981529236;
        double reb2_analog_VbefLDO = 0.7134362459182739;
        double reb0_clockhi_VaftLDO = 0.3505188226699829;
        double reb2_hvbias_VbefSwch = 0.09814947843551636;
        double reb2_OD_VaftLDO2 = 0.16175276041030884;
        double reb1_OD_VaftLDO2 = 0.8024162650108337;
        double reb0_clockhi_VbefLDO = 0.8596912026405334;
        double reb0_OD_VaftLDO2 = 0.41652631759643555;
        double reb2_analog_IaftLDO = 0.27237361669540405;
        double reb2_clocklo_IaftLDO = 0.9842463135719299;
        double reb0_analog_VaftSwch = 0.8040790557861328;
        double reb1_OD_IaftLDO = 0.344898521900177;
        double reb1_clockhi_VaftLDO = 0.7289501428604126;
        double reb2_Power = 0.9045096039772034;
        double reb0_clocklo_VaftLDO2 = 0.7711588144302368;
        double reb2_clockhi_IbefLDO = 0.22900527715682983;
        double reb2_analog_IbefLDO = 0.6242959499359131;
        double reb0_heater_VaftSwch = 0.796847939491272;
        double reb1_analog_IaftLDO = 0.19282597303390503;
        double reb0_digital_IaftLDO = 0.22758746147155762;
        double reb0_analog_VbefLDO = 0.4324553608894348;
        double reb0_analog_IbefLDO = 0.3753041625022888;
        double reb1_digital_IbefLDO = 0.16835826635360718;
        double reb1_heater_IaftLDO = 0.5050604343414307;
        double reb1_heater_VaftLDO = 0.06370240449905396;
        double reb2_heater_IbefLDO = 0.7674635052680969;
        double reb1_clockhi_IaftLDO = 0.06612330675125122;
        double reb0_digital_VaftLDO = 0.24641722440719604;
        double reb0_OD_VaftSwch = 0.4908837676048279;
        double reb1_OD_VaftLDO = 0.5330145359039307;
        double reb1_OD_VaftSwch = 0.7250893115997314;
        double reb2_hvbias_IbefSwch = 0.9086655378341675;
        double reb2_clockhi_VbefLDO = 0.5705804228782654;
        double reb0_digital_VaftSwch = 0.3904784321784973;
        double reb0_OD_VaftLDO = 0.3178486227989197;
        double reb0_OD_IaftLDO = 0.8363955616950989;
        double reb0_clocklo_VbefLDO = 0.01528573f;
        double reb2_OD_VaftSwch = 0.19582092761993408;
        double reb0_clocklo_IbefLDO = 0.6402224898338318;
        double reb0_OD_VbefLDO = 0.7362356781959534;
        double reb1_clocklo_VaftSwch = 0.9210574626922607;
        double reb1_clockhi_VbefLDO = 0.2001828f;
        double reb2_clockhi_VaftSwch = 0.2087729573249817;
        double reb2_OD_VaftLDO = 0.0972716212272644;
        double reb1_OD_IbefLDO = 0.5894113183021545;
        double reb0_analog_IaftLDO = 0.14540356397628784;
        double reb1_clocklo_IaftLDO = 0.48003554344177246;
        double reb1_hvbias_VbefSwch = 0.9238985776901245;
        double reb1_hvbias_IbefSwch = 0.4512117f;
        double reb1_analog_VbefLDO = 0.33633846044540405;
        double reb1_heater_VbefLDO = 0.3604347f;
        double reb2_clocklo_VaftLDO = 0.716579020023346;
        double reb2_digital_IaftLDO = 0.8807411193847656;
        double reb2_clocklo_VbefLDO = 0.22478598356246948;
        double reb1_analog_VaftSwch = 0.01323777437210083;
        double reb2_clocklo_VaftLDO2 = 0.48775774240493774;
        double reb0_clockhi_IaftLDO = 0.3348802924156189;
        double reb1_analog_VaftLDO = 0.03337627649307251;
        double reb0_heater_VbefLDO = 0.5512261986732483;
        double reb1_heater_VaftSwch = 0.3685334324836731;
        double reb0_heater_IbefLDO = 0.14840304851531982;
        double reb1_digital_VaftSwch = 0.5868754982948303;
        double reb0_heater_IaftLDO = 0.2468433380126953;
        double reb2_digital_VbefLDO = 0.5710065364837646;
        double reb2_digital_IbefLDO = 0.1229315996170044;
        double reb0_clockhi_IbefLDO = 0.36650723218917847;
        double reb2_analog_VaftLDO = 0.3143569827079773;
        double reb1_Power = 0.7865678668022156;
        double reb0_hvbias_IbefSwch = 0.7533522248268127;
        double reb2_OD_IbefLDO = 0.189189612865448;
        double reb1_OD_VbefLDO = 0.4931233525276184;
        double reb1_clocklo_IbefLDO = 0.5774151682853699;
        double reb1_clocklo_VbefLDO = 0.10885119438171387;
        double reb2_OD_VbefLDO = 0.18275481462478638;
        double reb1_digital_VaftLDO = 0.6625542044639587;
        double reb2_heater_VaftSwch = 0.65358f;
        double reb0_OD_IbefLDO = 0.4216992259025574;
        double reb0_hvbias_VbefSwch = 0.49060964584350586;
        double reb2_heater_VaftLDO = 0.576188862323761;
        double reb0_digital_VbefLDO = 0.7076285481452942;
        double reb2_digital_VaftSwch = 0.8091249465942383;
        double reb0_clocklo_VaftLDO = 0.5208961963653564;
        double reb0_clockhi_VaftSwch = 0.745803952217102;
        double reb0_clocklo_IaftLDO = 0.4315042495727539;
        double reb2_analog_VaftSwch = 0.06382858753204346;
        double reb1_clocklo_VaftLDO2 = 0.44760453701019287;
        double reb2_clockhi_VaftLDO = 0.22132503986358643;
        double reb0_clocklo_VaftSwch = 0.582874059677124;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_R22Telemetry(reb1_analog_IbefLDO, reb1_heater_IbefLDO, reb1_clockhi_VaftSwch, reb2_clockhi_IaftLDO, reb2_heater_IaftLDO, reb2_digital_VaftLDO, reb0_heater_VaftLDO, reb1_digital_IaftLDO, reb0_digital_IbefLDO, reb0_Power, reb2_OD_IaftLDO, reb2_clocklo_IbefLDO, reb1_digital_VbefLDO, reb1_clockhi_IbefLDO, reb2_heater_VbefLDO, reb1_clocklo_VaftLDO, reb0_analog_VaftLDO, reb2_clocklo_VaftSwch, reb2_analog_VbefLDO, reb0_clockhi_VaftLDO, reb2_hvbias_VbefSwch, reb2_OD_VaftLDO2, reb1_OD_VaftLDO2, reb0_clockhi_VbefLDO, reb0_OD_VaftLDO2, reb2_analog_IaftLDO, reb2_clocklo_IaftLDO, reb0_analog_VaftSwch, reb1_OD_IaftLDO, reb1_clockhi_VaftLDO, reb2_Power, reb0_clocklo_VaftLDO2, reb2_clockhi_IbefLDO, reb2_analog_IbefLDO, reb0_heater_VaftSwch, reb1_analog_IaftLDO, reb0_digital_IaftLDO, reb0_analog_VbefLDO, reb0_analog_IbefLDO, reb1_digital_IbefLDO, reb1_heater_IaftLDO, reb1_heater_VaftLDO, reb2_heater_IbefLDO, reb1_clockhi_IaftLDO, reb0_digital_VaftLDO, reb0_OD_VaftSwch, reb1_OD_VaftLDO, reb1_OD_VaftSwch, reb2_hvbias_IbefSwch, reb2_clockhi_VbefLDO, reb0_digital_VaftSwch, reb0_OD_VaftLDO, reb0_OD_IaftLDO, reb0_clocklo_VbefLDO, reb2_OD_VaftSwch, reb0_clocklo_IbefLDO, reb0_OD_VbefLDO, reb1_clocklo_VaftSwch, reb1_clockhi_VbefLDO, reb2_clockhi_VaftSwch, reb2_OD_VaftLDO, reb1_OD_IbefLDO, reb0_analog_IaftLDO, reb1_clocklo_IaftLDO, reb1_hvbias_VbefSwch, reb1_hvbias_IbefSwch, reb1_analog_VbefLDO, reb1_heater_VbefLDO, reb2_clocklo_VaftLDO, reb2_digital_IaftLDO, reb2_clocklo_VbefLDO, reb1_analog_VaftSwch, reb2_clocklo_VaftLDO2, reb0_clockhi_IaftLDO, reb1_analog_VaftLDO, reb0_heater_VbefLDO, reb1_heater_VaftSwch, reb0_heater_IbefLDO, reb1_digital_VaftSwch, reb0_heater_IaftLDO, reb2_digital_VbefLDO, reb2_digital_IbefLDO, reb0_clockhi_IbefLDO, reb2_analog_VaftLDO, reb1_Power, reb0_hvbias_IbefSwch, reb2_OD_IbefLDO, reb1_OD_VbefLDO, reb1_clocklo_IbefLDO, reb1_clocklo_VbefLDO, reb2_OD_VbefLDO, reb1_digital_VaftLDO, reb2_heater_VaftSwch, reb0_OD_IbefLDO, reb0_hvbias_VbefSwch, reb2_heater_VaftLDO, reb0_digital_VbefLDO, reb2_digital_VaftSwch, reb0_clocklo_VaftLDO, reb0_clockhi_VaftSwch, reb0_clocklo_IaftLDO, reb2_analog_VaftSwch, reb1_clocklo_VaftLDO2, reb2_clockhi_VaftLDO, reb0_clocklo_VaftSwch));
        Assert.assertTrue((boolean)(item instanceof Rebpower_R22Telemetry));
        Rebpower_R22Telemetry item_ = (Rebpower_R22Telemetry)item;
        Assert.assertEquals((double)reb1_analog_IbefLDO, (double)item_.getReb1_analog_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_IbefLDO, (double)item_.getReb1_heater_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_VaftSwch, (double)item_.getReb1_clockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_IaftLDO, (double)item_.getReb2_clockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_IaftLDO, (double)item_.getReb2_heater_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_VaftLDO, (double)item_.getReb2_digital_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_VaftLDO, (double)item_.getReb0_heater_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_IaftLDO, (double)item_.getReb1_digital_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_IbefLDO, (double)item_.getReb0_digital_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_Power, (double)item_.getReb0_Power(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_IaftLDO, (double)item_.getReb2_OD_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_IbefLDO, (double)item_.getReb2_clocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_VbefLDO, (double)item_.getReb1_digital_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_IbefLDO, (double)item_.getReb1_clockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_VbefLDO, (double)item_.getReb2_heater_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_VaftLDO, (double)item_.getReb1_clocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_VaftLDO, (double)item_.getReb0_analog_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_VaftSwch, (double)item_.getReb2_clocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_VbefLDO, (double)item_.getReb2_analog_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_VaftLDO, (double)item_.getReb0_clockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_hvbias_VbefSwch, (double)item_.getReb2_hvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_VaftLDO2, (double)item_.getReb2_OD_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_VaftLDO2, (double)item_.getReb1_OD_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_VbefLDO, (double)item_.getReb0_clockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_VaftLDO2, (double)item_.getReb0_OD_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_IaftLDO, (double)item_.getReb2_analog_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_IaftLDO, (double)item_.getReb2_clocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_VaftSwch, (double)item_.getReb0_analog_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_IaftLDO, (double)item_.getReb1_OD_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_VaftLDO, (double)item_.getReb1_clockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_Power, (double)item_.getReb2_Power(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_VaftLDO2, (double)item_.getReb0_clocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_IbefLDO, (double)item_.getReb2_clockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_IbefLDO, (double)item_.getReb2_analog_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_VaftSwch, (double)item_.getReb0_heater_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_analog_IaftLDO, (double)item_.getReb1_analog_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_IaftLDO, (double)item_.getReb0_digital_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_VbefLDO, (double)item_.getReb0_analog_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_IbefLDO, (double)item_.getReb0_analog_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_IbefLDO, (double)item_.getReb1_digital_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_IaftLDO, (double)item_.getReb1_heater_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_VaftLDO, (double)item_.getReb1_heater_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_IbefLDO, (double)item_.getReb2_heater_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_IaftLDO, (double)item_.getReb1_clockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_VaftLDO, (double)item_.getReb0_digital_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_VaftSwch, (double)item_.getReb0_OD_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_VaftLDO, (double)item_.getReb1_OD_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_VaftSwch, (double)item_.getReb1_OD_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_hvbias_IbefSwch, (double)item_.getReb2_hvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_VbefLDO, (double)item_.getReb2_clockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_VaftSwch, (double)item_.getReb0_digital_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_VaftLDO, (double)item_.getReb0_OD_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_IaftLDO, (double)item_.getReb0_OD_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_VbefLDO, (double)item_.getReb0_clocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_VaftSwch, (double)item_.getReb2_OD_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_IbefLDO, (double)item_.getReb0_clocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_VbefLDO, (double)item_.getReb0_OD_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_VaftSwch, (double)item_.getReb1_clocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clockhi_VbefLDO, (double)item_.getReb1_clockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_VaftSwch, (double)item_.getReb2_clockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_VaftLDO, (double)item_.getReb2_OD_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_IbefLDO, (double)item_.getReb1_OD_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_analog_IaftLDO, (double)item_.getReb0_analog_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_IaftLDO, (double)item_.getReb1_clocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_hvbias_VbefSwch, (double)item_.getReb1_hvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_hvbias_IbefSwch, (double)item_.getReb1_hvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_analog_VbefLDO, (double)item_.getReb1_analog_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_VbefLDO, (double)item_.getReb1_heater_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_VaftLDO, (double)item_.getReb2_clocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_IaftLDO, (double)item_.getReb2_digital_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_VbefLDO, (double)item_.getReb2_clocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_analog_VaftSwch, (double)item_.getReb1_analog_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clocklo_VaftLDO2, (double)item_.getReb2_clocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_IaftLDO, (double)item_.getReb0_clockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_analog_VaftLDO, (double)item_.getReb1_analog_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_VbefLDO, (double)item_.getReb0_heater_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_heater_VaftSwch, (double)item_.getReb1_heater_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_IbefLDO, (double)item_.getReb0_heater_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_VaftSwch, (double)item_.getReb1_digital_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_heater_IaftLDO, (double)item_.getReb0_heater_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_VbefLDO, (double)item_.getReb2_digital_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_IbefLDO, (double)item_.getReb2_digital_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_IbefLDO, (double)item_.getReb0_clockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_VaftLDO, (double)item_.getReb2_analog_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_Power, (double)item_.getReb1_Power(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_hvbias_IbefSwch, (double)item_.getReb0_hvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_IbefLDO, (double)item_.getReb2_OD_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_OD_VbefLDO, (double)item_.getReb1_OD_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_IbefLDO, (double)item_.getReb1_clocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_VbefLDO, (double)item_.getReb1_clocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_OD_VbefLDO, (double)item_.getReb2_OD_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_digital_VaftLDO, (double)item_.getReb1_digital_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_VaftSwch, (double)item_.getReb2_heater_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_OD_IbefLDO, (double)item_.getReb0_OD_IbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_hvbias_VbefSwch, (double)item_.getReb0_hvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_heater_VaftLDO, (double)item_.getReb2_heater_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_digital_VbefLDO, (double)item_.getReb0_digital_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_digital_VaftSwch, (double)item_.getReb2_digital_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_VaftLDO, (double)item_.getReb0_clocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clockhi_VaftSwch, (double)item_.getReb0_clockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_IaftLDO, (double)item_.getReb0_clocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_analog_VaftSwch, (double)item_.getReb2_analog_VaftSwch(), (double)1.0E-6f);
        Assert.assertEquals((double)reb1_clocklo_VaftLDO2, (double)item_.getReb1_clocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertEquals((double)reb2_clockhi_VaftLDO, (double)item_.getReb2_clockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertEquals((double)reb0_clocklo_VaftSwch, (double)item_.getReb0_clocklo_VaftSwch(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebPSTelemetry() throws Exception {
        double p00_BoardTemp2 = 0.47678375244140625;
        double p00_BoardTemp3 = 0.9815229177474976;
        double p00_BoardTemp4 = 0.8861351013183594;
        double p00_BoardTemp5 = 0.26060914993286133;
        double p00_BoardTemp0 = 0.40995967388153076;
        double p00_BoardTemp1 = 0.3302185535430908;
        double p00_BoardTemp6 = 0.2610187530517578;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebPSTelemetry(p00_BoardTemp2, p00_BoardTemp3, p00_BoardTemp4, p00_BoardTemp5, p00_BoardTemp0, p00_BoardTemp1, p00_BoardTemp6));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebPSTelemetry));
        Rebpower_RebPSTelemetry item_ = (Rebpower_RebPSTelemetry)item;
        Assert.assertEquals((double)p00_BoardTemp2, (double)item_.getP00_BoardTemp2(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp3, (double)item_.getP00_BoardTemp3(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp4, (double)item_.getP00_BoardTemp4(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp5, (double)item_.getP00_BoardTemp5(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp0, (double)item_.getP00_BoardTemp0(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp1, (double)item_.getP00_BoardTemp1(), (double)1.0E-6f);
        Assert.assertEquals((double)p00_BoardTemp6, (double)item_.getP00_BoardTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VQMonitorTelemetry() throws Exception {
        double vqmpressure = 0.540095865726471;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_VQMonitorTelemetry(vqmpressure));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitorTelemetry));
        Vacuum_VQMonitorTelemetry item_ = (Vacuum_VQMonitorTelemetry)item;
        Assert.assertEquals((double)vqmpressure, (double)item_.getVqmpressure(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumpsTelemetry() throws Exception {
        double ionpump_voltage = 0.1026091f;
        double ionpump_current = 0.4469099f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_IonPumpsTelemetry(ionpump_voltage, ionpump_current));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumpsTelemetry));
        Vacuum_IonPumpsTelemetry item_ = (Vacuum_IonPumpsTelemetry)item;
        Assert.assertEquals((double)ionpump_voltage, (double)item_.getIonpump_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)ionpump_current, (double)item_.getIonpump_current(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboTelemetry() throws Exception {
        double rpm = 0.22739005088806152;
        double power = 0.09896194934844971;
        double voltage = 0.5870565176010132;
        double turboSpeed = 0.5822194218635559;
        double pumpTemperature = 0.5386918187141418;
        double status = 0.6131938695907593;
        double cntrlrSinkTemperature = 0.8008796572685242;
        double driveFrequency = 0.2701093554496765;
        double current = 0.18812376260757446;
        double cntrlrAirTemperature = 0.3437894f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboTelemetry(rpm, power, voltage, turboSpeed, pumpTemperature, status, cntrlrSinkTemperature, driveFrequency, current, cntrlrAirTemperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboTelemetry));
        Vacuum_TurboTelemetry item_ = (Vacuum_TurboTelemetry)item;
        Assert.assertEquals((double)rpm, (double)item_.getRpm(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpTemperature, (double)item_.getPumpTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)status, (double)item_.getStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrSinkTemperature, (double)item_.getCntrlrSinkTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)driveFrequency, (double)item_.getDriveFrequency(), (double)1.0E-6f);
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrAirTemperature, (double)item_.getCntrlrAirTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double rejectTemperature = 0.0325050950050354;
        double autoOffEnabled = 0.9351528882980347;
        double power = 0.2944710850715637;
        double setPower = 0.17696022987365723;
        double temperature = 0.8251739144325256;
        double autoOnTemperature = 0.5536596179008484;
        double setpoint = 0.012217521667480469;
        double autoOffTemperature = 0.2790037989616394;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(rejectTemperature, autoOffEnabled, power, setPower, temperature, autoOnTemperature, setpoint, autoOffTemperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2Telemetry() throws Exception {
        double temperature = 0.8167297840118408;
        double rejectTemperature = 0.2526538372039795;
        double autoOnTemperature = 0.37689924240112305;
        double setpoint = 0.72347092628479;
        double power = 0.7146243453025818;
        double autoOffEnabled = 0.4205285906791687;
        double autoOffTemperature = 0.9744883179664612;
        double setPower = 0.8269518613815308;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold2Telemetry(temperature, rejectTemperature, autoOnTemperature, setpoint, power, autoOffEnabled, autoOffTemperature, setPower));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2Telemetry));
        Vacuum_Cold2Telemetry item_ = (Vacuum_Cold2Telemetry)item;
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold1Telemetry() throws Exception {
        double setPower = 0.5299327373504639;
        double power = 0.12921392917633057;
        double rejectTemperature = 0.8403084874153137;
        double autoOnTemperature = 0.2651034f;
        double autoOffTemperature = 0.2321536f;
        double temperature = 0.24338674545288086;
        double autoOffEnabled = 0.2175209f;
        double setpoint = 0.24748414754867554;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold1Telemetry(setPower, power, rejectTemperature, autoOnTemperature, autoOffTemperature, temperature, autoOffEnabled, setpoint));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1Telemetry));
        Vacuum_Cold1Telemetry item_ = (Vacuum_Cold1Telemetry)item;
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double bpu_Maq20_I = 0.3773950934410095;
        double ion_Pumps_I = 0.0967077f;
        double fpga_T = 0.3596503f;
        double bpu_Maq20_V = 0.41401517391204834;
        double fes_Shu_HCU_I = 0.8236048221588135;
        double board_T = 0.64303f;
        double body_Purge_V = 0.7711450457572937;
        double pwr_Cry_HCU_V = 0.6237296462059021;
        double pwr_Cry_HCU_I = 0.023287057876586914;
        double body_Purge_I = 0.40233057737350464;
        double fes_Shu_HCU_V = 0.4228951930999756;
        double gauges_V = 0.2748332f;
        double main_T = 0.30031102895736694;
        double main_V = 0.6927521824836731;
        double ion_Pumps_V = 0.037424683570861816;
        double main_I = 0.2015022f;
        double gauges_I = 0.024693548679351807;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(bpu_Maq20_I, ion_Pumps_I, fpga_T, bpu_Maq20_V, fes_Shu_HCU_I, board_T, body_Purge_V, pwr_Cry_HCU_V, pwr_Cry_HCU_I, body_Purge_I, fes_Shu_HCU_V, gauges_V, main_T, main_V, ion_Pumps_V, main_I, gauges_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.7132042646408081;
        double fpga_T = 0.4456857442855835;
        double cryo_Turbo_I = 0.9054670929908752;
        double main_V = 0.3275317f;
        double main_T = 0.17269080877304077;
        double cryo_Turbo_V = 0.9117224216461182;
        double main_I = 0.9080513715744019;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, fpga_T, cryo_Turbo_I, main_V, main_T, cryo_Turbo_V, main_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double heater_I = 0.40556687116622925;
        double protection_I = 0.7757561802864075;
        double dirty_48V_I = 0.793748f;
        double dirty_24V_I = 0.250373f;
        double clean_5_24V_I = 0.08731728792190552;
        double rebps_0 = 0.9066471457481384;
        double dirty_28V_I = 0.7543467879295349;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(heater_I, protection_I, dirty_48V_I, dirty_24V_I, clean_5_24V_I, rebps_0, dirty_28V_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0, (double)item_.getRebps_0(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_B_V = 0.6659121513366699;
        double otm_0_A_V = 0.03457885980606079;
        double otm_0_A_I = 0.012080729007720947;
        double otm_0_B_I = 0.1956343650817871;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_B_V, otm_0_A_V, otm_0_A_I, otm_0_B_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.1312609314918518;
        double main_T = 0.17674553394317627;
        double main_V = 0.1836094856262207;
        double main_I = 0.6274861693382263;
        double fpga_T = 0.4388948678970337;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, main_T, main_V, main_I, fpga_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
    }
}

