/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.CCSConfiguredEvent;
import org.lsst.sal.camera.event.EndInitializeGuiderEvent;
import org.lsst.sal.camera.event.EndInitializeImageEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.cccamera.CCCamera;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 905;
        String imageType = "oozlesdckkxaufzjksuaglzfdnugafnvmueolsyotiiwwktnbppqswarjdvmqyjsggyhpeieyhmxsthjqexhvrnvehtzzyacghyievhzqndcmiedpvlosnkjzjuuelccashwbzlwlvxlrubehevrqjukuesnyzotxvwbpeikmvlpfktaxpdxmlyolrslvuhwmyfmtnpka";
        String groupId = "uymsozvlmwvpvwsczyygfqxmcaepcv";
        int imagesInSequence = 949;
        String imageName = "feydnqcek";
        int imageIndex = 523;
        String imageSource = "m";
        String imageController = "";
        String imageDate = "htly";
        int imageNumber = 270;
        double timeStampAcquisitionStart = 0.7530982494354248;
        double exposureTime = 0.6354634165763855;
        double timeStampEndOfReadout = 0.11419862508773804;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, imageType, groupId, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, timeStampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timeStampEndOfReadout, (double)item_.getTimeStampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 89;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws Exception {
        int priority = 624;
        String filterName = "fvbjifmszhikjkwjedzeimvffipgumgxuxbpunhjralcafgnlydoxlpmrfpqxrgygazxxzkwwneoogvaqaqwbdxpekigtoptrbizuvelqbeqaztjdwyysopgkrcfzmbo";
        SALEvent item = this.testSendReceive((SALEvent)new StartSetFilterEvent(priority, filterName));
        Assert.assertTrue((boolean)(item instanceof StartSetFilterEvent));
        StartSetFilterEvent item_ = (StartSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws Exception {
        int priority = 791;
        SALEvent item = this.testSendReceive((SALEvent)new StartUnloadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent item_ = (StartUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 463;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 899;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndInitializeGuiderEvent() throws Exception {
        int priority = 928;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeGuiderEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndInitializeGuiderEvent));
        EndInitializeGuiderEvent item_ = (EndInitializeGuiderEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 693;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 255;
        String imageType = "zlbejnzmrgoqsnypfrtnqtmoqgwhdfjgfblquwnporwzppfwqkbngkuzdwzidmnqjbswmaywayynowtrwnulfacxhnmwrnxivxmzbatnddascitozxtcfkvyqfaajdyphkrogiabrydtauvlrcbinovajubbdnysr";
        String groupId = "hrew";
        int imagesInSequence = 796;
        String imageName = "jjnfoobpzsyvmzw";
        int imageIndex = 441;
        String imageSource = "";
        String imageController = "";
        String imageDate = "vcl";
        int imageNumber = 659;
        double timeStampAcquisitionStart = 0.4550822377204895;
        double exposureTime = 0.8304072618484497;
        String imageTag = "kltbvrhgvouipdzgrdpesevgjslvnvaabfgnhxtvoj";
        double timestampDateObs = 0.8993031978607178;
        double timestampDateEnd = 0.389864444732666;
        double expTime = 0.87402f;
        double darkTime = 0.24330562353134155;
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, imageType, groupId, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, expTime, darkTime));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)expTime, (double)item_.getExpTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws Exception {
        int priority = 989;
        SALEvent item = this.testSendReceive((SALEvent)new EndUnloadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent item_ = (EndUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws Exception {
        int priority = 2;
        SALEvent item = this.testSendReceive((SALEvent)new EndRotateCarouselEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent item_ = (EndRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws Exception {
        int priority = 791;
        SALEvent item = this.testSendReceive((SALEvent)new StartLoadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartLoadFilterEvent));
        StartLoadFilterEvent item_ = (StartLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 522;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 120;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveCCSConfiguredEvent() throws Exception {
        int priority = 846;
        SALEvent item = this.testSendReceive((SALEvent)new CCSConfiguredEvent(priority));
        Assert.assertTrue((boolean)(item instanceof CCSConfiguredEvent));
        CCSConfiguredEvent item_ = (CCSConfiguredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws Exception {
        int priority = 799;
        SALEvent item = this.testSendReceive((SALEvent)new EndLoadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndLoadFilterEvent));
        EndLoadFilterEvent item_ = (EndLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 842;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 551;
        String imageType = "fjdcygrt";
        String groupId = "rcekkmppbabqpewcaumtxwnnhxdxousukjpdoiujcivovaqkmutsjsdwutkucxnkmcaokqncaqvhcnrspiofdrptratbkajdbywwqebdasnjlscwtzrsustgxfzgxavknpsuwcs";
        int imagesInSequence = 597;
        String imageName = "lckk";
        int imageIndex = 781;
        String imageSource = "";
        String imageController = "";
        String imageDate = "";
        int imageNumber = 338;
        double timeStampAcquisitionStart = 0.7775058150291443;
        double exposureTime = 0.10151857137680054;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, imageType, groupId, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeImageEvent() throws Exception {
        int priority = 724;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndInitializeImageEvent));
        EndInitializeImageEvent item_ = (EndInitializeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws Exception {
        int priority = 398;
        String filterName = "zkopkhrdbeqjbjivltqcbvksqdwsrdkragxankbzfmqwccmlofjzmiztzpbnfpg";
        SALEvent item = this.testSendReceive((SALEvent)new EndSetFilterEvent(priority, filterName));
        Assert.assertTrue((boolean)(item instanceof EndSetFilterEvent));
        EndSetFilterEvent item_ = (EndSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 208;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws Exception {
        int priority = 690;
        String filterNames = "pgyxtuvgsklntesqjwhetavdyxrdiukvymcttfohealssscajwuw";
        SALEvent item = this.testSendReceive((SALEvent)new AvailableFiltersEvent(priority, filterNames));
        Assert.assertTrue((boolean)(item instanceof AvailableFiltersEvent));
        AvailableFiltersEvent item_ = (AvailableFiltersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 807;
        String imageType = "kbfxsomuctoauuxmjjgnwqphxdpctesikdvbkudtgpjdpmotwmouafgbkkjjgxccdyvuoherhkxhnkkckkfqeyvmoyupmrcntbzfyselziwzdafualjcejeewreankfolkflbpvhvpykfuqlptqxhqwocmidhftfrbbvuqffcgfrzdbygnrqkkvbbieyykwpejjulnyzoqlplwaljyjzrnavkzkpecckdjdgwsspqd";
        String groupId = "xsrhhzcjfsgzljzdbejtqhztxvrgspliwuqzuglcmmagvqpkcorirrijxkadmahkdas";
        int imagesInSequence = 708;
        String imageName = "mkakrxjiycrfcdkzzvzeyd";
        int imageIndex = 521;
        String imageSource = "q";
        String imageController = "";
        String imageDate = "vbkexxk";
        int imageNumber = 43;
        double timeStampAcquisitionStart = 0.4058322310447693;
        double exposureTime = 0.15907102823257446;
        double timeStampStartOfReadout = 0.5351780652999878;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, imageType, groupId, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, timeStampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timeStampStartOfReadout, (double)item_.getTimeStampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws Exception {
        int priority = 292;
        SALEvent item = this.testSendReceive((SALEvent)new StartRotateCarouselEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent item_ = (StartRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 430;
        String imageName = "";
        String ccdNames = "";
        String raftBay = "";
        String ccdSlot = "";
        Object[] ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V};
        int[] overRows = new int[]{252, 924, 189, 522, 453, 34, 31, 428, 662};
        int[] overCols = new int[]{812, 393, 653, 638, 144, 918, 618, 168, 916};
        int[] readRows = new int[]{218, 592, 765, 591, 31, 566, 636, 618, 914};
        int[] readCols = new int[]{157, 776, 571, 531, 231, 231, 142, 227, 745};
        int[] readCols2 = new int[]{954, 391, 584, 726, 648, 496, 76, 697, 910};
        int[] preCols = new int[]{683, 948, 462, 249, 366, 196, 598, 916, 873};
        int[] preRows = new int[]{456, 230, 757, 68, 197, 123, 849, 993, 917};
        int[] postCols = new int[]{243, 784, 467, 761, 963, 939, 50, 10, 929};
        int[] underCols = new int[]{914, 876, 272, 893, 378, 378, 555, 385, 811};
        String daqFolder = "";
        String daqAnnotation = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, ccdNames, raftBay, ccdSlot, (ImageReadoutParametersEvent.CcdType[])ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdNames, (Object)item_.getCcdNames());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((int[])overRows, (int[])item_.getOverRows());
        Assert.assertArrayEquals((int[])overCols, (int[])item_.getOverCols());
        Assert.assertArrayEquals((int[])readRows, (int[])item_.getReadRows());
        Assert.assertArrayEquals((int[])readCols, (int[])item_.getReadCols());
        Assert.assertArrayEquals((int[])readCols2, (int[])item_.getReadCols2());
        Assert.assertArrayEquals((int[])preCols, (int[])item_.getPreCols());
        Assert.assertArrayEquals((int[])preRows, (int[])item_.getPreRows());
        Assert.assertArrayEquals((int[])postCols, (int[])item_.getPostCols());
        Assert.assertArrayEquals((int[])underCols, (int[])item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveSettingVersionsEvent() throws Exception {
        int priority = 530;
        String recommendedSettingsVersion = "";
        String recommendedSettingsLabels = "";
        String settingsUrl = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingVersionsEvent(priority, recommendedSettingsVersion, recommendedSettingsLabels, settingsUrl));
        Assert.assertTrue((boolean)(item instanceof SettingVersionsEvent));
        SettingVersionsEvent item_ = (SettingVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)recommendedSettingsVersion, (Object)item_.getRecommendedSettingsVersion());
        Assert.assertEquals((Object)recommendedSettingsLabels, (Object)item_.getRecommendedSettingsLabels());
        Assert.assertEquals((Object)settingsUrl, (Object)item_.getSettingsUrl());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 89;
        int errorCode = 696;
        String errorReport = "";
        String traceback = "";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveAppliedSettingsMatchStartEvent() throws Exception {
        int priority = 923;
        boolean appliedSettingsMatchStartIsTrue = false;
        SALEvent item = this.testSendReceive((SALEvent)new AppliedSettingsMatchStartEvent(priority, appliedSettingsMatchStartIsTrue));
        Assert.assertTrue((boolean)(item instanceof AppliedSettingsMatchStartEvent));
        AppliedSettingsMatchStartEvent item_ = (AppliedSettingsMatchStartEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)appliedSettingsMatchStartIsTrue, (Object)item_.isAppliedSettingsMatchStartIsTrue());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 260;
        int level = 51;
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 89;
        String name = "";
        int level = 848;
        String message = "";
        String traceback = "";
        String filePath = "";
        String functionName = "";
        int lineNumber = 656;
        int process = 482;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, name, level, message, traceback, filePath, functionName, lineNumber, process));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
    }

    @Test
    public void sendReceiveSettingsAppliedEvent() throws Exception {
        int priority = 271;
        String settingsVersion = "nephetgmsiibgdriudkkgalhgsvpsvezzhsjwhuwstkppshewoapenvgtmubdmhuyapritluircfw";
        String otherSettingsEvents = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingsAppliedEvent(priority, settingsVersion, otherSettingsEvents));
        Assert.assertTrue((boolean)(item instanceof SettingsAppliedEvent));
        SettingsAppliedEvent item_ = (SettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)settingsVersion, (Object)item_.getSettingsVersion());
        Assert.assertEquals((Object)otherSettingsEvents, (Object)item_.getOtherSettingsEvents());
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 420;
        int mode = 976;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 191;
        String salVersion = "fkmkxcpmsylccjo";
        String xmlVersion = "qqhxmncebblhkd";
        String openSpliceVersion = "lsqslavgm";
        String cscVersion = "njxhoeh";
        String subsystemVersions = "";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 342;
        boolean heartbeat = true;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }
}

