package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Vacuum_Cold2Telemetry extends CameraTelemetry {
  private final double temp;

  private final double rejectTemperature;

  private final double autoOnTemperature;

  private final double setpoint;

  private final double power;

  private final double autoOffEnabled;

  private final double autoOffTemperature;

  private final double setPower;

  public Vacuum_Cold2Telemetry(double temp, double rejectTemperature, double autoOnTemperature,
      double setpoint, double power, double autoOffEnabled, double autoOffTemperature,
      double setPower) {
    this.temp = temp;
    this.rejectTemperature = rejectTemperature;
    this.autoOnTemperature = autoOnTemperature;
    this.setpoint = setpoint;
    this.power = power;
    this.autoOffEnabled = autoOffEnabled;
    this.autoOffTemperature = autoOffTemperature;
    this.setPower = setPower;
  }

  public double getTemp() {
    return temp;
  }

  public double getRejectTemperature() {
    return rejectTemperature;
  }

  public double getAutoOnTemperature() {
    return autoOnTemperature;
  }

  public double getSetpoint() {
    return setpoint;
  }

  public double getPower() {
    return power;
  }

  public double getAutoOffEnabled() {
    return autoOffEnabled;
  }

  public double getAutoOffTemperature() {
    return autoOffTemperature;
  }

  public double getSetPower() {
    return setPower;
  }

  @Override
  public String toString() {
    return "Vacuum_Cold2Telemetry{" + "temp=" + temp +", rejectTemperature=" + rejectTemperature +
        ", autoOnTemperature=" + autoOnTemperature +", setpoint=" + setpoint +", power=" + power +
        ", autoOffEnabled=" + autoOffEnabled +", autoOffTemperature=" + autoOffTemperature +
        ", setPower=" + setPower +"}";
  }
}
