package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Vacuum_TurboTelemetry extends CameraTelemetry {
  private final double rpm;

  private final double power;

  private final double voltage;

  private final double turboSpeed;

  private final double pumpTemperature;

  private final double status;

  private final double cntrlrSinkTemperature;

  private final double driveFrequency;

  private final double current;

  private final double cntrlrAirTemperature;

  public Vacuum_TurboTelemetry(double rpm, double power, double voltage, double turboSpeed,
      double pumpTemperature, double status, double cntrlrSinkTemperature, double driveFrequency,
      double current, double cntrlrAirTemperature) {
    this.rpm = rpm;
    this.power = power;
    this.voltage = voltage;
    this.turboSpeed = turboSpeed;
    this.pumpTemperature = pumpTemperature;
    this.status = status;
    this.cntrlrSinkTemperature = cntrlrSinkTemperature;
    this.driveFrequency = driveFrequency;
    this.current = current;
    this.cntrlrAirTemperature = cntrlrAirTemperature;
  }

  public double getRpm() {
    return rpm;
  }

  public double getPower() {
    return power;
  }

  public double getVoltage() {
    return voltage;
  }

  public double getTurboSpeed() {
    return turboSpeed;
  }

  public double getPumpTemperature() {
    return pumpTemperature;
  }

  public double getStatus() {
    return status;
  }

  public double getCntrlrSinkTemperature() {
    return cntrlrSinkTemperature;
  }

  public double getDriveFrequency() {
    return driveFrequency;
  }

  public double getCurrent() {
    return current;
  }

  public double getCntrlrAirTemperature() {
    return cntrlrAirTemperature;
  }

  @Override
  public String toString() {
    return "Vacuum_TurboTelemetry{" + "rpm=" + rpm +", power=" + power +", voltage=" + voltage +
        ", turboSpeed=" + turboSpeed +", pumpTemperature=" + pumpTemperature +", status=" + status +
        ", cntrlrSinkTemperature=" + cntrlrSinkTemperature +", driveFrequency=" + driveFrequency +
        ", current=" + current +", cntrlrAirTemperature=" + cntrlrAirTemperature +"}";
  }
}
