package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Vacuum_CryoTelemetry extends CameraTelemetry {
  private final double rejectTemperature;

  private final double autoOffEnabled;

  private final double power;

  private final double setPower;

  private final double temperature;

  private final double autoOnTemperature;

  private final double setpoint;

  private final double autoOffTemperature;

  public Vacuum_CryoTelemetry(double rejectTemperature, double autoOffEnabled, double power,
      double setPower, double temperature, double autoOnTemperature, double setpoint,
      double autoOffTemperature) {
    this.rejectTemperature = rejectTemperature;
    this.autoOffEnabled = autoOffEnabled;
    this.power = power;
    this.setPower = setPower;
    this.temperature = temperature;
    this.autoOnTemperature = autoOnTemperature;
    this.setpoint = setpoint;
    this.autoOffTemperature = autoOffTemperature;
  }

  public double getRejectTemperature() {
    return rejectTemperature;
  }

  public double getAutoOffEnabled() {
    return autoOffEnabled;
  }

  public double getPower() {
    return power;
  }

  public double getSetPower() {
    return setPower;
  }

  public double getTemperature() {
    return temperature;
  }

  public double getAutoOnTemperature() {
    return autoOnTemperature;
  }

  public double getSetpoint() {
    return setpoint;
  }

  public double getAutoOffTemperature() {
    return autoOffTemperature;
  }

  @Override
  public String toString() {
    return "Vacuum_CryoTelemetry{" + "rejectTemperature=" + rejectTemperature +
        ", autoOffEnabled=" + autoOffEnabled +", power=" + power +", setPower=" + setPower +
        ", temperature=" + temperature +", autoOnTemperature=" + autoOnTemperature +
        ", setpoint=" + setpoint +", autoOffTemperature=" + autoOffTemperature +"}";
  }
}
