package org.lsst.sal.cccamera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

public class FilterChangerDetailedStateEvent extends CameraStateChangeEvent {
  private final FilterChangerState substate;

  public FilterChangerDetailedStateEvent(int priority, FilterChangerState substate) {
    super (priority);
    this.substate = substate;
  }

  @Override
  public FilterChangerState getSubstate() {
    return substate;
  }

  @Override
  public String toString() {
    return "FilterChangerDetailedStateEvent{" + "substate=" + substate +"}";
  }

  public enum FilterChangerState implements SALEnum {
    UNLOADING,

    LOADING,

    LOADED,

    UNLOADED,

    ROTATING
  }
}
