package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class LogMessageEvent extends CameraEvent {
  private final int level;

  private final String message;

  private final String traceback;

  private final String filePath;

  private final String functionName;

  private final int lineNumber;

  private final int process;

  public LogMessageEvent(int priority, int level, String message, String traceback, String filePath,
      String functionName, int lineNumber, int process) {
    super (priority);
    this.level = level;
    this.message = message;
    this.traceback = traceback;
    this.filePath = filePath;
    this.functionName = functionName;
    this.lineNumber = lineNumber;
    this.process = process;
  }

  public int getLevel() {
    return level;
  }

  public String getMessage() {
    return message;
  }

  public String getTraceback() {
    return traceback;
  }

  public String getFilePath() {
    return filePath;
  }

  public String getFunctionName() {
    return functionName;
  }

  public int getLineNumber() {
    return lineNumber;
  }

  public int getProcess() {
    return process;
  }

  @Override
  public String toString() {
    return "LogMessageEvent{" + "level=" + level +", message=" + message +
        ", traceback=" + traceback +", filePath=" + filePath +", functionName=" + functionName +
        ", lineNumber=" + lineNumber +", process=" + process +"}";
  }
}
