/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.telemetry.BonnShutterTelemetry;
import org.lsst.sal.cccamera.telemetry.FilterChangerTelemetry;
import org.lsst.sal.cccamera.telemetry.VacuumCryoTelColdPlate1Telemetry;
import org.lsst.sal.cccamera.telemetry.VacuumCryoTelColdPlate2Telemetry;
import org.lsst.sal.cccamera.telemetry.VacuumCryoTelCryoPlateTelemetry;
import org.lsst.sal.cccamera.telemetry.VacuumIonPumpTelemetry;
import org.lsst.sal.cccamera.telemetry.VacuumPowerDistributionUnitTelemetry;
import org.lsst.sal.cccamera.telemetry.VacuumPressureGaugeTelemetry;
import org.lsst.sal.cccamera.telemetry.VacuumStatusTelemetry;
import org.lsst.sal.cccamera.telemetry.VacuumTurboPumpTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFilterChangerTelemetry() throws Exception {
        float motorTemperature = 0.33021855f;
        float motorEncoder = 0.26101875f;
        float linearPosition = 0.54009587f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FilterChangerTelemetry(motorTemperature, motorEncoder, linearPosition));
        Assert.assertTrue((boolean)(item instanceof FilterChangerTelemetry));
        FilterChangerTelemetry item_ = (FilterChangerTelemetry)item;
        Assert.assertEquals((float)motorTemperature, (float)item_.getMotorTemperature(), (float)1.0E-6f);
        Assert.assertEquals((float)motorEncoder, (float)item_.getMotorEncoder(), (float)1.0E-6f);
        Assert.assertEquals((float)linearPosition, (float)item_.getLinearPosition(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumTurboPumpTelemetry() throws Exception {
        double turboContTempAir = 0.1026091f;
        double turboContTempSink = 0.4469099f;
        double turboCurrent = 0.22739005088806152;
        double turboDriveFreq = 0.09896194934844971;
        double turboPower = 0.5870565176010132;
        double turboPumpTemp = 0.5822194218635559;
        float turboRPM = 0.5386918f;
        double turboSpeed = 0.6131938695907593;
        double turboStatus = 0.8008796572685242;
        double turboVoltage = 0.2701093554496765;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumTurboPumpTelemetry(turboContTempAir, turboContTempSink, turboCurrent, turboDriveFreq, turboPower, turboPumpTemp, turboRPM, turboSpeed, turboStatus, turboVoltage));
        Assert.assertTrue((boolean)(item instanceof VacuumTurboPumpTelemetry));
        VacuumTurboPumpTelemetry item_ = (VacuumTurboPumpTelemetry)item;
        Assert.assertEquals((double)turboContTempAir, (double)item_.getTurboContTempAir(), (double)1.0E-6f);
        Assert.assertEquals((double)turboContTempSink, (double)item_.getTurboContTempSink(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)turboDriveFreq, (double)item_.getTurboDriveFreq(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
        Assert.assertEquals((float)turboRPM, (float)item_.getTurboRPM(), (float)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)turboStatus, (double)item_.getTurboStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumIonPumpTelemetry() throws Exception {
        double cIP1_V = 0.18812376260757446;
        double cIP1_I = 0.3437894f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumIonPumpTelemetry(cIP1_V, cIP1_I));
        Assert.assertTrue((boolean)(item instanceof VacuumIonPumpTelemetry));
        VacuumIonPumpTelemetry item_ = (VacuumIonPumpTelemetry)item;
        Assert.assertEquals((double)cIP1_V, (double)item_.getCIP1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cIP1_I, (double)item_.getCIP1_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumCryoTelColdPlate1Telemetry() throws Exception {
        double cold1AutoOff = 0.0325050950050354;
        double cold1Pwr = 0.9351528882980347;
        double cold1RejectTemp = 0.2944710850715637;
        double cold1Temp = 0.17696022987365723;
        double cold1SetPt = 0.8251739144325256;
        double cold1SetPwr = 0.5536596179008484;
        double cold1AutoOffTemp = 0.012217521667480469;
        double cold1AutoOnTemp = 0.2790037989616394;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumCryoTelColdPlate1Telemetry(cold1AutoOff, cold1Pwr, cold1RejectTemp, cold1Temp, cold1SetPt, cold1SetPwr, cold1AutoOffTemp, cold1AutoOnTemp));
        Assert.assertTrue((boolean)(item instanceof VacuumCryoTelColdPlate1Telemetry));
        VacuumCryoTelColdPlate1Telemetry item_ = (VacuumCryoTelColdPlate1Telemetry)item;
        Assert.assertEquals((double)cold1AutoOff, (double)item_.getCold1AutoOff(), (double)1.0E-6f);
        Assert.assertEquals((double)cold1Pwr, (double)item_.getCold1Pwr(), (double)1.0E-6f);
        Assert.assertEquals((double)cold1RejectTemp, (double)item_.getCold1RejectTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)cold1Temp, (double)item_.getCold1Temp(), (double)1.0E-6f);
        Assert.assertEquals((double)cold1SetPt, (double)item_.getCold1SetPt(), (double)1.0E-6f);
        Assert.assertEquals((double)cold1SetPwr, (double)item_.getCold1SetPwr(), (double)1.0E-6f);
        Assert.assertEquals((double)cold1AutoOffTemp, (double)item_.getCold1AutoOffTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)cold1AutoOnTemp, (double)item_.getCold1AutoOnTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumCryoTelColdPlate2Telemetry() throws Exception {
        double cold2AutoOff = 0.8167297840118408;
        double cold2Pwr = 0.2526538372039795;
        double cold2RejectTemp = 0.37689924240112305;
        double cold2Temp = 0.72347092628479;
        double cold2SetPt = 0.7146243453025818;
        double cold2SetPwr = 0.4205285906791687;
        double cold2AutoOffTemp = 0.9744883179664612;
        double cold2AutoOnTemp = 0.8269518613815308;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumCryoTelColdPlate2Telemetry(cold2AutoOff, cold2Pwr, cold2RejectTemp, cold2Temp, cold2SetPt, cold2SetPwr, cold2AutoOffTemp, cold2AutoOnTemp));
        Assert.assertTrue((boolean)(item instanceof VacuumCryoTelColdPlate2Telemetry));
        VacuumCryoTelColdPlate2Telemetry item_ = (VacuumCryoTelColdPlate2Telemetry)item;
        Assert.assertEquals((double)cold2AutoOff, (double)item_.getCold2AutoOff(), (double)1.0E-6f);
        Assert.assertEquals((double)cold2Pwr, (double)item_.getCold2Pwr(), (double)1.0E-6f);
        Assert.assertEquals((double)cold2RejectTemp, (double)item_.getCold2RejectTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)cold2Temp, (double)item_.getCold2Temp(), (double)1.0E-6f);
        Assert.assertEquals((double)cold2SetPt, (double)item_.getCold2SetPt(), (double)1.0E-6f);
        Assert.assertEquals((double)cold2SetPwr, (double)item_.getCold2SetPwr(), (double)1.0E-6f);
        Assert.assertEquals((double)cold2AutoOffTemp, (double)item_.getCold2AutoOffTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)cold2AutoOnTemp, (double)item_.getCold2AutoOnTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumCryoTelCryoPlateTelemetry() throws Exception {
        double cryoAutoOff = 0.5299327373504639;
        double cryoPwr = 0.12921392917633057;
        double cryoRejectTemp = 0.8403084874153137;
        double cryoTemp = 0.2651034f;
        double cryoSetPt = 0.2321536f;
        double cryoSetPwr = 0.24338674545288086;
        double cryoAutoOffTemp = 0.2175209f;
        double cryoAutoOnTemp = 0.24748414754867554;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumCryoTelCryoPlateTelemetry(cryoAutoOff, cryoPwr, cryoRejectTemp, cryoTemp, cryoSetPt, cryoSetPwr, cryoAutoOffTemp, cryoAutoOnTemp));
        Assert.assertTrue((boolean)(item instanceof VacuumCryoTelCryoPlateTelemetry));
        VacuumCryoTelCryoPlateTelemetry item_ = (VacuumCryoTelCryoPlateTelemetry)item;
        Assert.assertEquals((double)cryoAutoOff, (double)item_.getCryoAutoOff(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoPwr, (double)item_.getCryoPwr(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoRejectTemp, (double)item_.getCryoRejectTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoTemp, (double)item_.getCryoTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoSetPt, (double)item_.getCryoSetPt(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoSetPwr, (double)item_.getCryoSetPwr(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoAutoOffTemp, (double)item_.getCryoAutoOffTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoAutoOnTemp, (double)item_.getCryoAutoOnTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumPressureGaugeTelemetry() throws Exception {
        double vqmpressure = 0.3773950934410095;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumPressureGaugeTelemetry(vqmpressure));
        Assert.assertTrue((boolean)(item instanceof VacuumPressureGaugeTelemetry));
        VacuumPressureGaugeTelemetry item_ = (VacuumPressureGaugeTelemetry)item;
        Assert.assertEquals((double)vqmpressure, (double)item_.getVqmpressure(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonnShutterTelemetry() throws Exception {
        float shutter5V = 0.0967077f;
        float shutter36V = 0.3596503f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new BonnShutterTelemetry(shutter5V, shutter36V));
        Assert.assertTrue((boolean)(item instanceof BonnShutterTelemetry));
        BonnShutterTelemetry item_ = (BonnShutterTelemetry)item;
        Assert.assertEquals((float)shutter5V, (float)item_.getShutter5V(), (float)1.0E-6f);
        Assert.assertEquals((float)shutter36V, (float)item_.getShutter36V(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumPowerDistributionUnitTelemetry() throws Exception {
        double pDU20Current = 0.41401517391204834;
        double pDU20Power = 0.8236048221588135;
        double pDU15Current = 0.64303f;
        double pDU15Power = 0.7711450457572937;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumPowerDistributionUnitTelemetry(pDU20Current, pDU20Power, pDU15Current, pDU15Power));
        Assert.assertTrue((boolean)(item instanceof VacuumPowerDistributionUnitTelemetry));
        VacuumPowerDistributionUnitTelemetry item_ = (VacuumPowerDistributionUnitTelemetry)item;
        Assert.assertEquals((double)pDU20Current, (double)item_.getPDU20Current(), (double)1.0E-6f);
        Assert.assertEquals((double)pDU20Power, (double)item_.getPDU20Power(), (double)1.0E-6f);
        Assert.assertEquals((double)pDU15Current, (double)item_.getPDU15Current(), (double)1.0E-6f);
        Assert.assertEquals((double)pDU15Power, (double)item_.getPDU15Power(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumStatusTelemetry() throws Exception {
        double vQMState = 0.6237296462059021;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumStatusTelemetry(vQMState));
        Assert.assertTrue((boolean)(item instanceof VacuumStatusTelemetry));
        VacuumStatusTelemetry item_ = (VacuumStatusTelemetry)item;
        Assert.assertEquals((double)vQMState, (double)item_.getVQMState(), (double)1.0E-6f);
    }
}

