package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class VacuumTurboPumpTelemetry extends CameraTelemetry {
  private final double turboContTempAir;

  private final double turboContTempSink;

  private final double turboCurrent;

  private final double turboDriveFreq;

  private final double turboPower;

  private final double turboPumpTemp;

  private final float turboRPM;

  private final double turboSpeed;

  private final double turboStatus;

  private final double turboVoltage;

  public VacuumTurboPumpTelemetry(double turboContTempAir, double turboContTempSink,
      double turboCurrent, double turboDriveFreq, double turboPower, double turboPumpTemp,
      float turboRPM, double turboSpeed, double turboStatus, double turboVoltage) {
    this.turboContTempAir = turboContTempAir;
    this.turboContTempSink = turboContTempSink;
    this.turboCurrent = turboCurrent;
    this.turboDriveFreq = turboDriveFreq;
    this.turboPower = turboPower;
    this.turboPumpTemp = turboPumpTemp;
    this.turboRPM = turboRPM;
    this.turboSpeed = turboSpeed;
    this.turboStatus = turboStatus;
    this.turboVoltage = turboVoltage;
  }

  public double getTurboContTempAir() {
    return turboContTempAir;
  }

  public double getTurboContTempSink() {
    return turboContTempSink;
  }

  public double getTurboCurrent() {
    return turboCurrent;
  }

  public double getTurboDriveFreq() {
    return turboDriveFreq;
  }

  public double getTurboPower() {
    return turboPower;
  }

  public double getTurboPumpTemp() {
    return turboPumpTemp;
  }

  public float getTurboRPM() {
    return turboRPM;
  }

  public double getTurboSpeed() {
    return turboSpeed;
  }

  public double getTurboStatus() {
    return turboStatus;
  }

  public double getTurboVoltage() {
    return turboVoltage;
  }

  @Override
  public String toString() {
    return "VacuumTurboPumpTelemetry{" + "turboContTempAir=" + turboContTempAir +
        ", turboContTempSink=" + turboContTempSink +", turboCurrent=" + turboCurrent +
        ", turboDriveFreq=" + turboDriveFreq +", turboPower=" + turboPower +
        ", turboPumpTemp=" + turboPumpTemp +", turboRPM=" + turboRPM +", turboSpeed=" + turboSpeed +
        ", turboStatus=" + turboStatus +", turboVoltage=" + turboVoltage +"}";
  }
}
