package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class VacuumPowerDistributionUnitTelemetry extends CameraTelemetry {
  private final double pDU20Current;

  private final double pDU20Power;

  private final double pDU15Current;

  private final double pDU15Power;

  public VacuumPowerDistributionUnitTelemetry(double pDU20Current, double pDU20Power,
      double pDU15Current, double pDU15Power) {
    this.pDU20Current = pDU20Current;
    this.pDU20Power = pDU20Power;
    this.pDU15Current = pDU15Current;
    this.pDU15Power = pDU15Power;
  }

  public double getPDU20Current() {
    return pDU20Current;
  }

  public double getPDU20Power() {
    return pDU20Power;
  }

  public double getPDU15Current() {
    return pDU15Current;
  }

  public double getPDU15Power() {
    return pDU15Power;
  }

  @Override
  public String toString() {
    return "VacuumPowerDistributionUnitTelemetry{" + "pDU20Current=" + pDU20Current +
        ", pDU20Power=" + pDU20Power +", pDU15Current=" + pDU15Current +
        ", pDU15Power=" + pDU15Power +"}";
  }
}
