package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class VacuumIonPumpTelemetry extends CameraTelemetry {
  private final double cIP1_V;

  private final double cIP1_I;

  public VacuumIonPumpTelemetry(double cIP1_V, double cIP1_I) {
    this.cIP1_V = cIP1_V;
    this.cIP1_I = cIP1_I;
  }

  public double getCIP1_V() {
    return cIP1_V;
  }

  public double getCIP1_I() {
    return cIP1_I;
  }

  @Override
  public String toString() {
    return "VacuumIonPumpTelemetry{" + "cIP1_V=" + cIP1_V +", cIP1_I=" + cIP1_I +"}";
  }
}
