package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class VacuumCryoTelCryoPlateTelemetry extends CameraTelemetry {
  private final double cryoAutoOff;

  private final double cryoPwr;

  private final double cryoRejectTemp;

  private final double cryoTemp;

  private final double cryoSetPt;

  private final double cryoSetPwr;

  private final double cryoAutoOffTemp;

  private final double cryoAutoOnTemp;

  public VacuumCryoTelCryoPlateTelemetry(double cryoAutoOff, double cryoPwr, double cryoRejectTemp,
      double cryoTemp, double cryoSetPt, double cryoSetPwr, double cryoAutoOffTemp,
      double cryoAutoOnTemp) {
    this.cryoAutoOff = cryoAutoOff;
    this.cryoPwr = cryoPwr;
    this.cryoRejectTemp = cryoRejectTemp;
    this.cryoTemp = cryoTemp;
    this.cryoSetPt = cryoSetPt;
    this.cryoSetPwr = cryoSetPwr;
    this.cryoAutoOffTemp = cryoAutoOffTemp;
    this.cryoAutoOnTemp = cryoAutoOnTemp;
  }

  public double getCryoAutoOff() {
    return cryoAutoOff;
  }

  public double getCryoPwr() {
    return cryoPwr;
  }

  public double getCryoRejectTemp() {
    return cryoRejectTemp;
  }

  public double getCryoTemp() {
    return cryoTemp;
  }

  public double getCryoSetPt() {
    return cryoSetPt;
  }

  public double getCryoSetPwr() {
    return cryoSetPwr;
  }

  public double getCryoAutoOffTemp() {
    return cryoAutoOffTemp;
  }

  public double getCryoAutoOnTemp() {
    return cryoAutoOnTemp;
  }

  @Override
  public String toString() {
    return "VacuumCryoTelCryoPlateTelemetry{" + "cryoAutoOff=" + cryoAutoOff +
        ", cryoPwr=" + cryoPwr +", cryoRejectTemp=" + cryoRejectTemp +", cryoTemp=" + cryoTemp +
        ", cryoSetPt=" + cryoSetPt +", cryoSetPwr=" + cryoSetPwr +
        ", cryoAutoOffTemp=" + cryoAutoOffTemp +", cryoAutoOnTemp=" + cryoAutoOnTemp +"}";
  }
}
