package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class VacuumCryoTelColdPlate2Telemetry extends CameraTelemetry {
  private final double cold2AutoOff;

  private final double cold2Pwr;

  private final double cold2RejectTemp;

  private final double cold2Temp;

  private final double cold2SetPt;

  private final double cold2SetPwr;

  private final double cold2AutoOffTemp;

  private final double cold2AutoOnTemp;

  public VacuumCryoTelColdPlate2Telemetry(double cold2AutoOff, double cold2Pwr,
      double cold2RejectTemp, double cold2Temp, double cold2SetPt, double cold2SetPwr,
      double cold2AutoOffTemp, double cold2AutoOnTemp) {
    this.cold2AutoOff = cold2AutoOff;
    this.cold2Pwr = cold2Pwr;
    this.cold2RejectTemp = cold2RejectTemp;
    this.cold2Temp = cold2Temp;
    this.cold2SetPt = cold2SetPt;
    this.cold2SetPwr = cold2SetPwr;
    this.cold2AutoOffTemp = cold2AutoOffTemp;
    this.cold2AutoOnTemp = cold2AutoOnTemp;
  }

  public double getCold2AutoOff() {
    return cold2AutoOff;
  }

  public double getCold2Pwr() {
    return cold2Pwr;
  }

  public double getCold2RejectTemp() {
    return cold2RejectTemp;
  }

  public double getCold2Temp() {
    return cold2Temp;
  }

  public double getCold2SetPt() {
    return cold2SetPt;
  }

  public double getCold2SetPwr() {
    return cold2SetPwr;
  }

  public double getCold2AutoOffTemp() {
    return cold2AutoOffTemp;
  }

  public double getCold2AutoOnTemp() {
    return cold2AutoOnTemp;
  }

  @Override
  public String toString() {
    return "VacuumCryoTelColdPlate2Telemetry{" + "cold2AutoOff=" + cold2AutoOff +
        ", cold2Pwr=" + cold2Pwr +", cold2RejectTemp=" + cold2RejectTemp +
        ", cold2Temp=" + cold2Temp +", cold2SetPt=" + cold2SetPt +", cold2SetPwr=" + cold2SetPwr +
        ", cold2AutoOffTemp=" + cold2AutoOffTemp +", cold2AutoOnTemp=" + cold2AutoOnTemp +"}";
  }
}
