package org.lsst.sal.cccamera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

public class RaftsDetailedStateEvent extends CameraStateChangeEvent {
  private final RaftsState substate;

  public RaftsDetailedStateEvent(int priority, RaftsState substate) {
    super (priority);
    this.substate = substate;
  }

  @Override
  public RaftsState getSubstate() {
    return substate;
  }

  @Override
  public String toString() {
    return "RaftsDetailedStateEvent{" + "substate=" + substate +"}";
  }

  public enum RaftsState implements SALEnum {
    NEEDS_CLEAR,

    CLEARING,

    INTEGRATING,

    READING_OUT,

    QUIESCENT
  }
}
