package org.lsst.sal.cccamera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

public class OfflineDetailedStateEvent extends CameraStateChangeEvent {
  private final OfflineState substate;

  public OfflineDetailedStateEvent(int priority, OfflineState substate) {
    super (priority);
    this.substate = substate;
  }

  @Override
  public OfflineState getSubstate() {
    return substate;
  }

  @Override
  public String toString() {
    return "OfflineDetailedStateEvent{" + "substate=" + substate +"}";
  }

  public enum OfflineState implements SALEnum {
    OFFLINE_AVAILABLE,

    OFFLINE_PUBLISH_ONLY
  }
}
