package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class StartIntegrationEvent extends CameraEvent {
  private final String imageType;

  private final String groupId;

  private final int imagesInSequence;

  private final String imageName;

  private final int imageIndex;

  private final String imageSource;

  private final String imageController;

  private final String imageDate;

  private final int imageNumber;

  private final double timeStampAcquisitionStart;

  private final double exposureTime;

  public StartIntegrationEvent(int priority, String imageType, String groupId, int imagesInSequence,
      String imageName, int imageIndex, String imageSource, String imageController,
      String imageDate, int imageNumber, double timeStampAcquisitionStart, double exposureTime) {
    super (priority);
    this.imageType = imageType;
    this.groupId = groupId;
    this.imagesInSequence = imagesInSequence;
    this.imageName = imageName;
    this.imageIndex = imageIndex;
    this.imageSource = imageSource;
    this.imageController = imageController;
    this.imageDate = imageDate;
    this.imageNumber = imageNumber;
    this.timeStampAcquisitionStart = timeStampAcquisitionStart;
    this.exposureTime = exposureTime;
  }

  public String getImageType() {
    return imageType;
  }

  public String getGroupId() {
    return groupId;
  }

  public int getImagesInSequence() {
    return imagesInSequence;
  }

  public String getImageName() {
    return imageName;
  }

  public int getImageIndex() {
    return imageIndex;
  }

  public String getImageSource() {
    return imageSource;
  }

  public String getImageController() {
    return imageController;
  }

  public String getImageDate() {
    return imageDate;
  }

  public int getImageNumber() {
    return imageNumber;
  }

  public double getTimeStampAcquisitionStart() {
    return timeStampAcquisitionStart;
  }

  public double getExposureTime() {
    return exposureTime;
  }

  @Override
  public String toString() {
    return "StartIntegrationEvent{" + "imageType=" + imageType +", groupId=" + groupId +
        ", imagesInSequence=" + imagesInSequence +", imageName=" + imageName +
        ", imageIndex=" + imageIndex +", imageSource=" + imageSource +
        ", imageController=" + imageController +", imageDate=" + imageDate +
        ", imageNumber=" + imageNumber +", timeStampAcquisitionStart=" + timeStampAcquisitionStart +
        ", exposureTime=" + exposureTime +"}";
  }
}
