/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.Chiller_ChillerTelemetry;
import org.lsst.sal.camera.telemetry.Chiller_FParam_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Chiller_Maq20Telemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Reb_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Sum_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_Latches_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_OnlineClamps_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_Temperatures_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Accelerobf_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Ai814_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_CarouselController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ClampXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ClampXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Hyttc580_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_LatchXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_LatchXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Pt100_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_CarrierController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_HooksController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Brakes_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket1_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket2_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket3_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket4_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket5_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Counters_Autochanger_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Counters_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Counters_Loader_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Counters_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Autochanger_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Loader_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Fcs_Mcm_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Fcs_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_Carrier_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_Hooks_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebsAverageTemp6Telemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_03Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_05Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_50Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_55Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_12Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_14Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_31Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_43Telemetry;
import org.lsst.sal.camera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_REB_Bulk_PSTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Shutter_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Cold_TempTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Cryo_TempTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_RtdTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_TrimTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Trim_HtrsTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_BodyTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_MPCTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_UTTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_VPCTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CipTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_HXTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_HipTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_InstTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.4510906934738159;
        double dirty_24V_I = 0.6826828122138977;
        double dirty_28V_I = 0.6598678231239319;
        double dirty_48V_I = 0.03727757930755615;
        double protection_I = 0.5882796049118042;
        double rebps_0_2_I = 0.29798614978790283;
        double rebps_3_5_I = 0.42802155017852783;
        double rebps_6_8_I = 0.8841565251350403;
        double rebps_9_12_I = 0.723391056060791;
        double rebps_Spr_I = 0.012175381183624268;
        double total_VA = 0.06291204690933228;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, protection_I, rebps_0_2_I, rebps_3_5_I, rebps_6_8_I, rebps_9_12_I, rebps_Spr_I, total_VA));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I, (double)item_.getRebps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I, (double)item_.getRebps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I, (double)item_.getRebps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I, (double)item_.getRebps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I, (double)item_.getRebps_Spr_I(), (double)1.0E-6f);
        Assert.assertEquals((double)total_VA, (double)item_.getTotal_VA(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double board_T = 0.5327414274215698;
        double body_Maq20_I = 0.32043081521987915;
        double body_Maq20_V = 0.6729613542556763;
        double cryo_Maq20_I = 0.27488642930984497;
        double cryo_Maq20_V = 0.3728615641593933;
        double fes_CarouselC_I = 0.9913286566734314;
        double fes_CarouselC_V = 0.8676349520683289;
        double fes_ChangerC_I = 0.17567843198776245;
        double fes_ChangerC_V = 0.38904452323913574;
        double fes_LoaderC_I = 0.296139f;
        double fes_LoaderC_V = 0.7261744737625122;
        double fpga_T = 0.6626887917518616;
        double gauges_I = 0.04965662956237793;
        double gauges_V = 0.0604214072227478;
        double int_Valves_I = 0.25971394777297974;
        double int_Valves_V = 0.18166548013687134;
        double ion_Pumps_I = 0.15060561895370483;
        double ion_Pumps_V = 0.969784677028656;
        double main_I = 0.5768238306045532;
        double main_T = 0.723280131816864;
        double main_V = 0.748953f;
        double shtr_PLC1_I = 0.8426942229270935;
        double shtr_PLC1_V = 0.17643022537231445;
        double shtr_PLC2_I = 0.48615914583206177;
        double shtr_PLC2_V = 0.5553824305534363;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(board_T, body_Maq20_I, body_Maq20_V, cryo_Maq20_I, cryo_Maq20_V, fes_CarouselC_I, fes_CarouselC_V, fes_ChangerC_I, fes_ChangerC_V, fes_LoaderC_I, fes_LoaderC_V, fpga_T, gauges_I, gauges_V, int_Valves_I, int_Valves_V, ion_Pumps_I, ion_Pumps_V, main_I, main_T, main_V, shtr_PLC1_I, shtr_PLC1_V, shtr_PLC2_I, shtr_PLC2_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I, (double)item_.getBody_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V, (double)item_.getBody_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I, (double)item_.getCryo_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V, (double)item_.getCryo_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I, (double)item_.getFes_CarouselC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V, (double)item_.getFes_CarouselC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I, (double)item_.getFes_ChangerC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V, (double)item_.getFes_ChangerC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I, (double)item_.getFes_LoaderC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V, (double)item_.getFes_LoaderC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I, (double)item_.getInt_Valves_I(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V, (double)item_.getInt_Valves_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I, (double)item_.getShtr_PLC1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V, (double)item_.getShtr_PLC1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I, (double)item_.getShtr_PLC2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V, (double)item_.getShtr_PLC2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.8494077324867249;
        double cryo_Turbo_I = 0.06183946132659912;
        double cryo_Turbo_V = 0.5651716589927673;
        double fes_Brakes_I = 0.2926744818687439;
        double fes_Brakes_V = 0.38204145431518555;
        double fes_ChangerD_I = 0.7304448485374451;
        double fes_ChangerD_V = 0.9954877495765686;
        double fes_Clamps_I = 0.965650200843811;
        double fes_Clamps_V = 0.8986307978630066;
        double fes_LoaderD_I = 0.1965857744216919;
        double fes_LoaderD_V = 0.08702284097671509;
        double fpga_T = 0.2001015f;
        double hex_Turbo_I = 0.9886152744293213;
        double hex_Turbo_V = 0.33215343952178955;
        double main_I = 0.9479057192802429;
        double main_T = 0.5957809686660767;
        double main_V = 0.03004467487335205;
        double shtr_Brakes_I = 0.6454641222953796;
        double shtr_Brakes_V = 0.5377201437950134;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, cryo_Turbo_I, cryo_Turbo_V, fes_Brakes_I, fes_Brakes_V, fes_ChangerD_I, fes_ChangerD_V, fes_Clamps_I, fes_Clamps_V, fes_LoaderD_I, fes_LoaderD_V, fpga_T, hex_Turbo_I, hex_Turbo_V, main_I, main_T, main_V, shtr_Brakes_I, shtr_Brakes_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I, (double)item_.getFes_Brakes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V, (double)item_.getFes_Brakes_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I, (double)item_.getFes_ChangerD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V, (double)item_.getFes_ChangerD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I, (double)item_.getFes_Clamps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V, (double)item_.getFes_Clamps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I, (double)item_.getFes_LoaderD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V, (double)item_.getFes_LoaderD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I, (double)item_.getHex_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V, (double)item_.getHex_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I, (double)item_.getShtr_Brakes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V, (double)item_.getShtr_Brakes_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.7814640998840332;
        double fes_CarouselD_I = 0.03719979524612427;
        double fes_CarouselD_V = 0.5513439178466797;
        double fes_Heater_I = 0.2702589f;
        double fes_Heater_V = 0.766426146030426;
        double fpga_T = 0.8041006922721863;
        double main_I = 0.5551072359085083;
        double main_T = 0.7508121132850647;
        double main_V = 0.5385303497314453;
        double purge_Fan_I = 0.9230126142501831;
        double purge_Fan_V = 0.1241145133972168;
        double shtr_Motor1_I = 0.47461992502212524;
        double shtr_Motor1_V = 0.2787594199180603;
        double shtr_Motor2_I = 0.15165424346923828;
        double shtr_Motor2_V = 0.3499273657798767;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, fes_CarouselD_I, fes_CarouselD_V, fes_Heater_I, fes_Heater_V, fpga_T, main_I, main_T, main_V, purge_Fan_I, purge_Fan_V, shtr_Motor1_I, shtr_Motor1_V, shtr_Motor2_I, shtr_Motor2_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I, (double)item_.getFes_CarouselD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V, (double)item_.getFes_CarouselD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I, (double)item_.getFes_Heater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V, (double)item_.getFes_Heater_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I, (double)item_.getPurge_Fan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V, (double)item_.getPurge_Fan_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I, (double)item_.getShtr_Motor1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V, (double)item_.getShtr_Motor1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I, (double)item_.getShtr_Motor2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V, (double)item_.getShtr_Motor2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_A_I = 0.4117283225059509;
        double otm_0_A_V = 0.23782312870025635;
        double otm_0_B_I = 0.38809633255004883;
        double otm_0_B_V = 0.5119433999061584;
        double otm_1_A_I = 0.18037575483322144;
        double otm_1_A_V = 0.27294737100601196;
        double otm_1_B_I = 0.9236583113670349;
        double otm_1_B_V = 0.9931003451347351;
        double otm_2_A_I = 0.6781256794929504;
        double otm_2_A_V = 0.3707275986671448;
        double otm_2_B_I = 0.9324435591697693;
        double otm_2_B_V = 0.5262464880943298;
        double otm_3_A_I = 0.449784517288208;
        double otm_3_A_V = 0.6117709279060364;
        double otm_3_B_I = 0.33810514211654663;
        double otm_3_B_V = 0.7756381630897522;
        double otm_4_A_I = 0.9668700695037842;
        double otm_4_A_V = 0.9696370959281921;
        double otm_4_B_I = 0.3062235713005066;
        double otm_4_B_V = 0.7944543957710266;
        double otm_5_A_I = 0.25881046056747437;
        double otm_5_A_V = 0.91333f;
        double otm_5_B_I = 0.9421666860580444;
        double otm_5_B_V = 0.9120232462882996;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_A_I, otm_0_A_V, otm_0_B_I, otm_0_B_V, otm_1_A_I, otm_1_A_V, otm_1_B_I, otm_1_B_V, otm_2_A_I, otm_2_A_V, otm_2_B_I, otm_2_B_V, otm_3_A_I, otm_3_A_V, otm_3_B_I, otm_3_B_V, otm_4_A_I, otm_4_A_V, otm_4_B_I, otm_4_B_V, otm_5_A_I, otm_5_A_V, otm_5_B_I, otm_5_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I, (double)item_.getOtm_1_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V, (double)item_.getOtm_1_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I, (double)item_.getOtm_1_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V, (double)item_.getOtm_1_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I, (double)item_.getOtm_2_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V, (double)item_.getOtm_2_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I, (double)item_.getOtm_2_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V, (double)item_.getOtm_2_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I, (double)item_.getOtm_3_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V, (double)item_.getOtm_3_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I, (double)item_.getOtm_4_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V, (double)item_.getOtm_4_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I, (double)item_.getOtm_4_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V, (double)item_.getOtm_4_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I, (double)item_.getOtm_5_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V, (double)item_.getOtm_5_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I, (double)item_.getOtm_5_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V, (double)item_.getOtm_5_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PSTelemetry() throws Exception {
        double rebbulkps_0_2_I = 0.7455727458000183;
        double rebbulkps_0_2_T = 0.9104164838790894;
        double rebbulkps_0_2_V = 0.1429547667503357;
        double rebbulkps_3_5_I = 0.26258552074432373;
        double rebbulkps_3_5_T = 0.590083f;
        double rebbulkps_3_5_V = 0.8460214138031006;
        double rebbulkps_6_8_I = 0.5365853905677795;
        double rebbulkps_6_8_T = 0.09294718503952026;
        double rebbulkps_6_8_V = 0.722268283367157;
        double rebbulkps_9_12_I = 0.8988456726074219;
        double rebbulkps_9_12_T = 0.6381955742835999;
        double rebbulkps_9_12_V = 0.5044876337051392;
        double rebbulkps_Brd_T = 0.8311173319816589;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_REB_Bulk_PSTelemetry(rebbulkps_0_2_I, rebbulkps_0_2_T, rebbulkps_0_2_V, rebbulkps_3_5_I, rebbulkps_3_5_T, rebbulkps_3_5_V, rebbulkps_6_8_I, rebbulkps_6_8_T, rebbulkps_6_8_V, rebbulkps_9_12_I, rebbulkps_9_12_T, rebbulkps_9_12_V, rebbulkps_Brd_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PSTelemetry));
        Quadbox_REB_Bulk_PSTelemetry item_ = (Quadbox_REB_Bulk_PSTelemetry)item;
        Assert.assertEquals((double)rebbulkps_0_2_I, (double)item_.getRebbulkps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T, (double)item_.getRebbulkps_0_2_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V, (double)item_.getRebbulkps_0_2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I, (double)item_.getRebbulkps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T, (double)item_.getRebbulkps_3_5_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V, (double)item_.getRebbulkps_3_5_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I, (double)item_.getRebbulkps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T, (double)item_.getRebbulkps_6_8_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V, (double)item_.getRebbulkps_6_8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I, (double)item_.getRebbulkps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T, (double)item_.getRebbulkps_9_12_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V, (double)item_.getRebbulkps_9_12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T, (double)item_.getRebbulkps_Brd_T(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)835312483);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1633290882);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1400082465);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-370515978);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)1341482664);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-840519937);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)1457561536);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)1668465225);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-2117486254);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)1289560733);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1562802890);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1326698964);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-222852784);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)1026586193);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)630946823);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1343063213);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-675789961);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)1290184497);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)497882891);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)218551942);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-2082501484);
        double[] dphi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-2000652555);
        double[] dphi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)1345417508);
        double[] dphi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)67851467);
        double[] dphi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1079721924);
        double[] dphi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1607979593);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1825962448);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)172102851);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)1715764738);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1805923321);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)1895470702);
        double[] hvbias_DAC = TestHelper.generateDoubleArray((int)71, (int)-19754412);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)71, (int)599368448);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)71, (int)-1236612884);
        String location = "";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)2044596360);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-723373253);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)2126797039);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)1354095473);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-816431692);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1711597751);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)1631467605);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, dphi_IaftLDO, dphi_IbefLDO, dphi_VaftLDO, dphi_VaftSwch, dphi_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_DAC, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO, (double[])item_.getDphi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO, (double[])item_.getDphi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO, (double[])item_.getDphi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch, (double[])item_.getDphi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO, (double[])item_.getDphi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_DAC, (double[])item_.getHvbias_DAC(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.664657711982727;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTotalPowerTelemetry));
        Rebpower_RebTotalPowerTelemetry item_ = (Rebpower_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)13, (int)-665356836);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)13, (int)379238517);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)13, (int)-376977813);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)13, (int)523262570);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)13, (int)-1241888939);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)13, (int)557961869);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)13, (int)-1213186888);
        double[] fPGATemp = TestHelper.generateDoubleArray((int)13, (int)211058237);
        String location = "w";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, fPGATemp, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fPGATemp, (double[])item_.getFPGATemp(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveHex_Cold1Telemetry() throws Exception {
        double returnTmp = 0.7269848585128784;
        double supplyTmp = 0.0999218225479126;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold1Telemetry(returnTmp, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1Telemetry));
        Hex_Cold1Telemetry item_ = (Hex_Cold1Telemetry)item;
        Assert.assertEquals((double)returnTmp, (double)item_.getReturnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2Telemetry() throws Exception {
        double returnTmp = 0.7310975790023804;
        double supplyTmp = 0.8573110699653625;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold2Telemetry(returnTmp, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2Telemetry));
        Hex_Cold2Telemetry item_ = (Hex_Cold2Telemetry)item;
        Assert.assertEquals((double)returnTmp, (double)item_.getReturnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1Telemetry() throws Exception {
        double c3ExitTmp = 0.1031796932220459;
        double c4ExitTmp = 0.2733106017112732;
        double evapExitTmp = 0.3846477270126343;
        double hexRtrnTmp = 0.5456730723381042;
        double liquidPrs = 0.6833916306495667;
        double preC3Tmp = 0.615400493144989;
        double preC4Tmp = 0.985266387462616;
        double returnPrs = 0.6262192130088806;
        double vaporPrs = 0.9268412590026855;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo1Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1Telemetry));
        Hex_Cryo1Telemetry item_ = (Hex_Cryo1Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2Telemetry() throws Exception {
        double c3ExitTmp = 0.7013934254646301;
        double c4ExitTmp = 0.7946221232414246;
        double evapExitTmp = 0.8567145466804504;
        double hexRtrnTmp = 0.10664993524551392;
        double liquidPrs = 0.6390265226364136;
        double preC3Tmp = 0.4128406047821045;
        double preC4Tmp = 0.7378131747245789;
        double returnPrs = 0.22139078378677368;
        double vaporPrs = 0.8042507171630859;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo2Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2Telemetry));
        Hex_Cryo2Telemetry item_ = (Hex_Cryo2Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3Telemetry() throws Exception {
        double c3ExitTmp = 0.6622820496559143;
        double c4ExitTmp = 0.4527856707572937;
        double evapExitTmp = 0.2221236228942871;
        double hexRtrnTmp = 0.7435727715492249;
        double liquidPrs = 0.32882362604141235;
        double preC3Tmp = 0.18640172481536865;
        double preC4Tmp = 0.331407f;
        double returnPrs = 0.49448084831237793;
        double vaporPrs = 0.6153187155723572;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo3Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3Telemetry));
        Hex_Cryo3Telemetry item_ = (Hex_Cryo3Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4Telemetry() throws Exception {
        double c3ExitTmp = 0.3528764843940735;
        double c4ExitTmp = 0.6594946384429932;
        double evapExitTmp = 0.029887735843658447;
        double hexRtrnTmp = 0.686722457408905;
        double liquidPrs = 0.5515662431716919;
        double preC3Tmp = 0.9538493156433105;
        double preC4Tmp = 0.1216285228729248;
        double returnPrs = 0.0994305f;
        double vaporPrs = 0.02028787136077881;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo4Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4Telemetry));
        Hex_Cryo4Telemetry item_ = (Hex_Cryo4Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5Telemetry() throws Exception {
        double c3ExitTmp = 0.12096691131591797;
        double c4ExitTmp = 0.8419254422187805;
        double evapExitTmp = 0.5299714803695679;
        double hexRtrnTmp = 0.4902523159980774;
        double liquidPrs = 0.36965036392211914;
        double preC3Tmp = 0.33370906114578247;
        double preC4Tmp = 0.26223433017730713;
        double returnPrs = 0.26226896047592163;
        double vaporPrs = 0.19328594207763672;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo5Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5Telemetry));
        Hex_Cryo5Telemetry item_ = (Hex_Cryo5Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6Telemetry() throws Exception {
        double c3ExitTmp = 0.7372046113014221;
        double c4ExitTmp = 0.7104390859603882;
        double evapExitTmp = 0.9478601217269897;
        double hexRtrnTmp = 0.4519529342651367;
        double liquidPrs = 0.07082492113113403;
        double preC3Tmp = 0.5902376770973206;
        double preC4Tmp = 0.1561023f;
        double returnPrs = 0.06556594371795654;
        double vaporPrs = 0.941853404045105;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo6Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6Telemetry));
        Hex_Cryo6Telemetry item_ = (Hex_Cryo6Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo1Telemetry() throws Exception {
        double afterCoolTmp = 0.5864506959915161;
        double ambientTmp = 0.79039067029953;
        double cabinetTmp = 0.08456408977508545;
        double compCurrent = 0.672473f;
        double compPower = 0.7774170637130737;
        double compVoltage = 0.9600421786308289;
        double dischrgPrs = 0.478396f;
        double dischrgtmp_M = 0.43834203481674194;
        double dischrgtmp_P = 0.07779967784881592;
        double fanSpeed = 0.5489626526832581;
        double oilLevel = 0.953304648399353;
        double oilSepTmp = 0.45221036672592163;
        double phaseSepTmp = 0.35961318016052246;
        double suctionPrs = 0.534893f;
        double suctiontmp_M = 0.574421226978302;
        double suctiontmp_P = 0.9091998934745789;
        double surgeTankTmp = 0.15150684118270874;
        double waterInTmp = 0.3635222315788269;
        double waterOutTmp = 0.28328317403793335;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo1Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1Telemetry));
        Refrig_Cryo1Telemetry item_ = (Refrig_Cryo1Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2Telemetry() throws Exception {
        double afterCoolTmp = 0.12166684865951538;
        double compCurrent = 0.23586708307266235;
        double compPower = 0.27564752101898193;
        double compVoltage = 0.4465714693069458;
        double dischrgPrs = 0.9914597868919373;
        double dischrgtmp_M = 0.5396295189857483;
        double dischrgtmp_P = 0.014325857162475586;
        double fanSpeed = 0.9867229461669922;
        double oilLevel = 0.1304640769958496;
        double oilSepTmp = 0.31598544120788574;
        double phaseSepTmp = 0.932489275932312;
        double suctionPrs = 0.0873381495475769;
        double suctiontmp_M = 0.6842671036720276;
        double suctiontmp_P = 0.2492081f;
        double surgeTankTmp = 0.1377851963043213;
        double waterInTmp = 0.8588252067565918;
        double waterOutTmp = 0.3294191360473633;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo2Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2Telemetry));
        Refrig_Cryo2Telemetry item_ = (Refrig_Cryo2Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3Telemetry() throws Exception {
        double afterCoolTmp = 0.18303775787353516;
        double compCurrent = 0.9865933656692505;
        double compPower = 0.13097500801086426;
        double compVoltage = 0.29603683948516846;
        double dischrgPrs = 0.21447932720184326;
        double dischrgtmp_M = 0.3375188112258911;
        double dischrgtmp_P = 0.9132510423660278;
        double fanSpeed = 0.36148297786712646;
        double oilLevel = 0.8401514887809753;
        double oilSepTmp = 0.4385449290275574;
        double phaseSepTmp = 0.25022536516189575;
        double suctionPrs = 0.01773691177368164;
        double suctiontmp_M = 0.26277297735214233;
        double suctiontmp_P = 0.9219653606414795;
        double surgeTankTmp = 0.6841568946838379;
        double waterInTmp = 0.8381834626197815;
        double waterOutTmp = 0.322886f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo3Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3Telemetry));
        Refrig_Cryo3Telemetry item_ = (Refrig_Cryo3Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4Telemetry() throws Exception {
        double afterCoolTmp = 0.965827226638794;
        double compCurrent = 0.32015544176101685;
        double compPower = 0.06532156467437744;
        double compVoltage = 0.41804826259613037;
        double dischrgPrs = 0.4266694188117981;
        double dischrgtmp_M = 0.33832043409347534;
        double dischrgtmp_P = 0.6689122319221497;
        double fanSpeed = 0.20162934064865112;
        double oilLevel = 0.41071271896362305;
        double oilSepTmp = 0.4938998818397522;
        double phaseSepTmp = 0.3470335602760315;
        double suctionPrs = 0.4498153328895569;
        double suctiontmp_M = 0.9123595356941223;
        double suctiontmp_P = 0.738744f;
        double surgeTankTmp = 0.8762168884277344;
        double waterInTmp = 0.7728777527809143;
        double waterOutTmp = 0.4710242748260498;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo4Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4Telemetry));
        Refrig_Cryo4Telemetry item_ = (Refrig_Cryo4Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5Telemetry() throws Exception {
        double afterCoolTmp = 0.1486014723777771;
        double ambientTmp = 0.7802398800849915;
        double cabinetTmp = 0.4902266263961792;
        double compCurrent = 0.26919543743133545;
        double compPower = 0.1802259087562561;
        double compVoltage = 0.8523287177085876;
        double dischrgPrs = 0.0439186692237854;
        double dischrgtmp_M = 0.2836172f;
        double dischrgtmp_P = 0.2545545f;
        double fanSpeed = 0.707659900188446;
        double oilLevel = 0.488411009311676;
        double oilSepTmp = 0.4030695f;
        double phaseSepTmp = 0.3777400851249695;
        double suctionPrs = 0.29047656059265137;
        double suctiontmp_M = 0.4523560404777527;
        double suctiontmp_P = 0.31406354904174805;
        double surgeTankTmp = 0.09653699398040771;
        double waterInTmp = 0.3442919850349426;
        double waterOutTmp = 0.2486640214920044;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo5Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5Telemetry));
        Refrig_Cryo5Telemetry item_ = (Refrig_Cryo5Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6Telemetry() throws Exception {
        double afterCoolTmp = 0.23160594701766968;
        double compCurrent = 0.43006718158721924;
        double compPower = 0.9591088891029358;
        double compVoltage = 0.6300771236419678;
        double dischrgPrs = 0.5959053635597229;
        double dischrgtmp_M = 0.433544397354126;
        double dischrgtmp_P = 0.8240374326705933;
        double fanSpeed = 0.8078945875167847;
        double oilLevel = 0.8755069375038147;
        double oilSepTmp = 0.9039708375930786;
        double phaseSepTmp = 0.07796567678451538;
        double suctionPrs = 0.420676589012146;
        double suctiontmp_M = 0.8989740610122681;
        double suctiontmp_P = 0.12161296606063843;
        double surgeTankTmp = 0.20896893739700317;
        double waterInTmp = 0.947770357131958;
        double waterOutTmp = 0.2951557f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo6Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6Telemetry));
        Refrig_Cryo6Telemetry item_ = (Refrig_Cryo6Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CipTelemetry() throws Exception {
        double[] cryo_I = TestHelper.generateDoubleArray((int)6, (int)-479683108);
        double[] cryo_Life = TestHelper.generateDoubleArray((int)6, (int)1297128407);
        double[] cryo_Usage = TestHelper.generateDoubleArray((int)6, (int)-901870151);
        double[] cryo_V = TestHelper.generateDoubleArray((int)6, (int)-650009694);
        String location = "x";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CipTelemetry(cryo_I, cryo_Life, cryo_Usage, cryo_V, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CipTelemetry));
        Vacuum_CipTelemetry item_ = (Vacuum_CipTelemetry)item;
        Assert.assertArrayEquals((double[])cryo_I, (double[])item_.getCryo_I(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life, (double[])item_.getCryo_Life(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage, (double[])item_.getCryo_Usage(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V, (double[])item_.getCryo_V(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double airPressure = 0.7082904577255249;
        double cryoVac = 0.8928915858268738;
        double flineCurrent = 0.8528701663017273;
        double flinePower = 0.22256118059158325;
        double flineVoltage = 0.23151761293411255;
        double forelineVac = 0.3666307330131531;
        double gaugeDose = 0.8951523900032043;
        double pumpCartPressure = 0.9892210364341736;
        double turboCurrent = 0.8720544576644897;
        double turboCycleNumber = 0.27813196182250977;
        double turboCycleTime = 0.4131561517715454;
        double turboGaugeDose = 0.854506f;
        double turboHours = 0.760930061340332;
        double turboPower = 0.05844026803970337;
        double turboPumpStatus = 0.44296252727508545;
        double turboPumpTemp = 0.8741492033004761;
        double turboSpeed = 0.5222861170768738;
        double turboVac = 0.4755227565765381;
        double turboVoltage = 0.6505237221717834;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(airPressure, cryoVac, flineCurrent, flinePower, flineVoltage, forelineVac, gaugeDose, pumpCartPressure, turboCurrent, turboCycleNumber, turboCycleTime, turboGaugeDose, turboHours, turboPower, turboPumpStatus, turboPumpTemp, turboSpeed, turboVac, turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)airPressure, (double)item_.getAirPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoVac, (double)item_.getCryoVac(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugeDose, (double)item_.getGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleNumber, (double)item_.getTurboCycleNumber(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleTime, (double)item_.getTurboCycleTime(), (double)1.0E-6f);
        Assert.assertEquals((double)turboGaugeDose, (double)item_.getTurboGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)turboHours, (double)item_.getTurboHours(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpStatus, (double)item_.getTurboPumpStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HXTelemetry() throws Exception {
        double airPressure = 0.7943531274795532;
        double flineCurrent = 0.6197706460952759;
        double flinePower = 0.3344826102256775;
        double flineVoltage = 0.3656052350997925;
        double forelineVac = 0.838508f;
        double gaugeDose = 0.9427078366279602;
        double hexVac = 0.3455565f;
        double pumpCartPressure = 0.4657749f;
        double turboCurrent = 0.6058825850486755;
        double turboCycleNumber = 0.36224573850631714;
        double turboCycleTime = 0.11827832460403442;
        double turboGaugeDose = 0.5935790538787842;
        double turboHours = 0.67257f;
        double turboPower = 0.3236528f;
        double turboPumpStatus = 0.8826066851615906;
        double turboPumpTemp = 0.5549773573875427;
        double turboSpeed = 0.5185275077819824;
        double turboVac = 0.0874180793762207;
        double turboVoltage = 0.9695937037467957;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_HXTelemetry(airPressure, flineCurrent, flinePower, flineVoltage, forelineVac, gaugeDose, hexVac, pumpCartPressure, turboCurrent, turboCycleNumber, turboCycleTime, turboGaugeDose, turboHours, turboPower, turboPumpStatus, turboPumpTemp, turboSpeed, turboVac, turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HXTelemetry));
        Vacuum_HXTelemetry item_ = (Vacuum_HXTelemetry)item;
        Assert.assertEquals((double)airPressure, (double)item_.getAirPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugeDose, (double)item_.getGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)hexVac, (double)item_.getHexVac(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleNumber, (double)item_.getTurboCycleNumber(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleTime, (double)item_.getTurboCycleTime(), (double)1.0E-6f);
        Assert.assertEquals((double)turboGaugeDose, (double)item_.getTurboGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)turboHours, (double)item_.getTurboHours(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpStatus, (double)item_.getTurboPumpStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HipTelemetry() throws Exception {
        double[] hx_I = TestHelper.generateDoubleArray((int)2, (int)523421194);
        double[] hx_Life = TestHelper.generateDoubleArray((int)2, (int)442224416);
        double[] hx_Usage = TestHelper.generateDoubleArray((int)2, (int)-144572349);
        double[] hx_V = TestHelper.generateDoubleArray((int)2, (int)1533658944);
        String location = "q";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_HipTelemetry(hx_I, hx_Life, hx_Usage, hx_V, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HipTelemetry));
        Vacuum_HipTelemetry item_ = (Vacuum_HipTelemetry)item;
        Assert.assertArrayEquals((double[])hx_I, (double[])item_.getHx_I(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life, (double[])item_.getHx_Life(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage, (double[])item_.getHx_Usage(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V, (double[])item_.getHx_V(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_InstTelemetry() throws Exception {
        double cryoFlineValveState = 0.19652915000915527;
        double flineCurrent = 0.32983511686325073;
        double flinePower = 0.4602123498916626;
        double flineVoltage = 0.20682674646377563;
        double hxFlineValveState = 0.9360202550888062;
        double instVac = 0.9764194488525391;
        double pumpCartCycling = 0.04096514f;
        double pumpCartPressure = 0.2708238959312439;
        double pumpCartTemperature = 0.20480328798294067;
        double pumpCartVenting = 0.38327813148498535;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_InstTelemetry(cryoFlineValveState, flineCurrent, flinePower, flineVoltage, hxFlineValveState, instVac, pumpCartCycling, pumpCartPressure, pumpCartTemperature, pumpCartVenting));
        Assert.assertTrue((boolean)(item instanceof Vacuum_InstTelemetry));
        Vacuum_InstTelemetry item_ = (Vacuum_InstTelemetry)item;
        Assert.assertEquals((double)cryoFlineValveState, (double)item_.getCryoFlineValveState(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)hxFlineValveState, (double)item_.getHxFlineValveState(), (double)1.0E-6f);
        Assert.assertEquals((double)instVac, (double)item_.getInstVac(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartCycling, (double)item_.getPumpCartCycling(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartTemperature, (double)item_.getPumpCartTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartVenting, (double)item_.getPumpCartVenting(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Reb_TrendingTelemetry() throws Exception {
        long[] driver_errors = TestHelper.generateLongArray((int)71, (int)1198848508);
        long[] driver_received = TestHelper.generateLongArray((int)71, (int)103955563);
        long[] driver_rx0 = TestHelper.generateLongArray((int)71, (int)1738454970);
        long[] driver_rx1 = TestHelper.generateLongArray((int)71, (int)-627619830);
        long[] driver_rx2 = TestHelper.generateLongArray((int)71, (int)-448561757);
        long[] driver_rx3 = TestHelper.generateLongArray((int)71, (int)2134049333);
        long[] firmware_cell_errors = TestHelper.generateLongArray((int)71, (int)-782861957);
        long[] firmware_last_rx = TestHelper.generateLongArray((int)71, (int)-1202272553);
        long[] firmware_last_tx = TestHelper.generateLongArray((int)71, (int)-520024172);
        long[] firmware_link_down = TestHelper.generateLongArray((int)71, (int)-393499257);
        long[] firmware_link_errors = TestHelper.generateLongArray((int)71, (int)1056183108);
        long[] firmware_link_status = TestHelper.generateLongArray((int)71, (int)-1741228926);
        long[] firmware_overflow_local0 = TestHelper.generateLongArray((int)71, (int)164131471);
        long[] firmware_overflow_local1 = TestHelper.generateLongArray((int)71, (int)887337194);
        long[] firmware_overflow_local2 = TestHelper.generateLongArray((int)71, (int)-1315545550);
        long[] firmware_overflow_local3 = TestHelper.generateLongArray((int)71, (int)-1779787179);
        long[] firmware_overflow_remote0 = TestHelper.generateLongArray((int)71, (int)-601800830);
        long[] firmware_overflow_remote1 = TestHelper.generateLongArray((int)71, (int)-2103178513);
        long[] firmware_overflow_remote2 = TestHelper.generateLongArray((int)71, (int)-881463382);
        long[] firmware_overflow_remote3 = TestHelper.generateLongArray((int)71, (int)-1137220935);
        long[] firmware_rlink_data = TestHelper.generateLongArray((int)71, (int)-1168887726);
        long[] firmware_rx_clock = TestHelper.generateLongArray((int)71, (int)-1212730453);
        long[] firmware_rx_errors = TestHelper.generateLongArray((int)71, (int)249785278);
        long[] firmware_rx_frames = TestHelper.generateLongArray((int)71, (int)24430023);
        long[] firmware_rx_op = TestHelper.generateLongArray((int)71, (int)-411905318);
        long[] firmware_tx_clock = TestHelper.generateLongArray((int)71, (int)-833229470);
        long[] firmware_tx_errors = TestHelper.generateLongArray((int)71, (int)317594068);
        long[] firmware_tx_frames = TestHelper.generateLongArray((int)71, (int)-1691047137);
        long[] firmware_tx_op = TestHelper.generateLongArray((int)71, (int)-1359419341);
        String location = "";
        long[] rds_bdi_firsts = TestHelper.generateLongArray((int)71, (int)-1681088631);
        long[] rds_bdi_frees = TestHelper.generateLongArray((int)71, (int)2096354553);
        long[] rds_bdi_lasts = TestHelper.generateLongArray((int)71, (int)-460458955);
        long[] rds_bdi_nulls = TestHelper.generateLongArray((int)71, (int)1050315473);
        long[] rds_bdi_overflows = TestHelper.generateLongArray((int)71, (int)844891602);
        long[] rds_bdi_seq_errors = TestHelper.generateLongArray((int)71, (int)-318936967);
        long[] rds_bdi_waits = TestHelper.generateLongArray((int)71, (int)986825022);
        long[] rds_discards = TestHelper.generateLongArray((int)71, (int)-1972438551);
        long[] rds_no_event = TestHelper.generateLongArray((int)71, (int)-190354332);
        long[] rds_wakes = TestHelper.generateLongArray((int)71, (int)1368270662);
        long[] rms_in_reset = TestHelper.generateLongArray((int)71, (int)-1383670735);
        long[] rms_inv_tids = TestHelper.generateLongArray((int)71, (int)-343627547);
        long[] rms_link_down = TestHelper.generateLongArray((int)71, (int)464326486);
        long[] rms_lists_posted = TestHelper.generateLongArray((int)71, (int)-1812386212);
        long[] rms_ops_posted = TestHelper.generateLongArray((int)71, (int)2132430017);
        long[] rms_orphans = TestHelper.generateLongArray((int)71, (int)-1013722796);
        long[] rms_probes = TestHelper.generateLongArray((int)71, (int)784040707);
        long[] rms_responses = TestHelper.generateLongArray((int)71, (int)-1319547359);
        long[] rms_rundowns = TestHelper.generateLongArray((int)71, (int)-1279783441);
        long[] rms_tid_hwm = TestHelper.generateLongArray((int)71, (int)-1497931914);
        long[] rms_unopened = TestHelper.generateLongArray((int)71, (int)1292651061);
        long[] rms_waits = TestHelper.generateLongArray((int)71, (int)-1787342922);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Reb_TrendingTelemetry(driver_errors, driver_received, driver_rx0, driver_rx1, driver_rx2, driver_rx3, firmware_cell_errors, firmware_last_rx, firmware_last_tx, firmware_link_down, firmware_link_errors, firmware_link_status, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_local3, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_overflow_remote3, firmware_rlink_data, firmware_rx_clock, firmware_rx_errors, firmware_rx_frames, firmware_rx_op, firmware_tx_clock, firmware_tx_errors, firmware_tx_frames, firmware_tx_op, location, rds_bdi_firsts, rds_bdi_frees, rds_bdi_lasts, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_bdi_waits, rds_discards, rds_no_event, rds_wakes, rms_in_reset, rms_inv_tids, rms_link_down, rms_lists_posted, rms_ops_posted, rms_orphans, rms_probes, rms_responses, rms_rundowns, rms_tid_hwm, rms_unopened, rms_waits));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Reb_TrendingTelemetry));
        Daq_monitor_Reb_TrendingTelemetry item_ = (Daq_monitor_Reb_TrendingTelemetry)item;
        Assert.assertArrayEquals((long[])driver_errors, (long[])item_.getDriver_errors());
        Assert.assertArrayEquals((long[])driver_received, (long[])item_.getDriver_received());
        Assert.assertArrayEquals((long[])driver_rx0, (long[])item_.getDriver_rx0());
        Assert.assertArrayEquals((long[])driver_rx1, (long[])item_.getDriver_rx1());
        Assert.assertArrayEquals((long[])driver_rx2, (long[])item_.getDriver_rx2());
        Assert.assertArrayEquals((long[])driver_rx3, (long[])item_.getDriver_rx3());
        Assert.assertArrayEquals((long[])firmware_cell_errors, (long[])item_.getFirmware_cell_errors());
        Assert.assertArrayEquals((long[])firmware_last_rx, (long[])item_.getFirmware_last_rx());
        Assert.assertArrayEquals((long[])firmware_last_tx, (long[])item_.getFirmware_last_tx());
        Assert.assertArrayEquals((long[])firmware_link_down, (long[])item_.getFirmware_link_down());
        Assert.assertArrayEquals((long[])firmware_link_errors, (long[])item_.getFirmware_link_errors());
        Assert.assertArrayEquals((long[])firmware_link_status, (long[])item_.getFirmware_link_status());
        Assert.assertArrayEquals((long[])firmware_overflow_local0, (long[])item_.getFirmware_overflow_local0());
        Assert.assertArrayEquals((long[])firmware_overflow_local1, (long[])item_.getFirmware_overflow_local1());
        Assert.assertArrayEquals((long[])firmware_overflow_local2, (long[])item_.getFirmware_overflow_local2());
        Assert.assertArrayEquals((long[])firmware_overflow_local3, (long[])item_.getFirmware_overflow_local3());
        Assert.assertArrayEquals((long[])firmware_overflow_remote0, (long[])item_.getFirmware_overflow_remote0());
        Assert.assertArrayEquals((long[])firmware_overflow_remote1, (long[])item_.getFirmware_overflow_remote1());
        Assert.assertArrayEquals((long[])firmware_overflow_remote2, (long[])item_.getFirmware_overflow_remote2());
        Assert.assertArrayEquals((long[])firmware_overflow_remote3, (long[])item_.getFirmware_overflow_remote3());
        Assert.assertArrayEquals((long[])firmware_rlink_data, (long[])item_.getFirmware_rlink_data());
        Assert.assertArrayEquals((long[])firmware_rx_clock, (long[])item_.getFirmware_rx_clock());
        Assert.assertArrayEquals((long[])firmware_rx_errors, (long[])item_.getFirmware_rx_errors());
        Assert.assertArrayEquals((long[])firmware_rx_frames, (long[])item_.getFirmware_rx_frames());
        Assert.assertArrayEquals((long[])firmware_rx_op, (long[])item_.getFirmware_rx_op());
        Assert.assertArrayEquals((long[])firmware_tx_clock, (long[])item_.getFirmware_tx_clock());
        Assert.assertArrayEquals((long[])firmware_tx_errors, (long[])item_.getFirmware_tx_errors());
        Assert.assertArrayEquals((long[])firmware_tx_frames, (long[])item_.getFirmware_tx_frames());
        Assert.assertArrayEquals((long[])firmware_tx_op, (long[])item_.getFirmware_tx_op());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])rds_bdi_firsts, (long[])item_.getRds_bdi_firsts());
        Assert.assertArrayEquals((long[])rds_bdi_frees, (long[])item_.getRds_bdi_frees());
        Assert.assertArrayEquals((long[])rds_bdi_lasts, (long[])item_.getRds_bdi_lasts());
        Assert.assertArrayEquals((long[])rds_bdi_nulls, (long[])item_.getRds_bdi_nulls());
        Assert.assertArrayEquals((long[])rds_bdi_overflows, (long[])item_.getRds_bdi_overflows());
        Assert.assertArrayEquals((long[])rds_bdi_seq_errors, (long[])item_.getRds_bdi_seq_errors());
        Assert.assertArrayEquals((long[])rds_bdi_waits, (long[])item_.getRds_bdi_waits());
        Assert.assertArrayEquals((long[])rds_discards, (long[])item_.getRds_discards());
        Assert.assertArrayEquals((long[])rds_no_event, (long[])item_.getRds_no_event());
        Assert.assertArrayEquals((long[])rds_wakes, (long[])item_.getRds_wakes());
        Assert.assertArrayEquals((long[])rms_in_reset, (long[])item_.getRms_in_reset());
        Assert.assertArrayEquals((long[])rms_inv_tids, (long[])item_.getRms_inv_tids());
        Assert.assertArrayEquals((long[])rms_link_down, (long[])item_.getRms_link_down());
        Assert.assertArrayEquals((long[])rms_lists_posted, (long[])item_.getRms_lists_posted());
        Assert.assertArrayEquals((long[])rms_ops_posted, (long[])item_.getRms_ops_posted());
        Assert.assertArrayEquals((long[])rms_orphans, (long[])item_.getRms_orphans());
        Assert.assertArrayEquals((long[])rms_probes, (long[])item_.getRms_probes());
        Assert.assertArrayEquals((long[])rms_responses, (long[])item_.getRms_responses());
        Assert.assertArrayEquals((long[])rms_rundowns, (long[])item_.getRms_rundowns());
        Assert.assertArrayEquals((long[])rms_tid_hwm, (long[])item_.getRms_tid_hwm());
        Assert.assertArrayEquals((long[])rms_unopened, (long[])item_.getRms_unopened());
        Assert.assertArrayEquals((long[])rms_waits, (long[])item_.getRms_waits());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.910401f;
        double freeFraction = 0.19562774896621704;
        double freeSpace = 0.9723993539810181;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Sum_TrendingTelemetry() throws Exception {
        long driver_errors = 136L;
        long firmware_cell_errors = 594L;
        long firmware_link_down = 866L;
        long firmware_link_errors = 604L;
        long firmware_overflow_local0 = 163L;
        long firmware_overflow_local1 = 865L;
        long firmware_overflow_local2 = 116L;
        long firmware_overflow_remote0 = 561L;
        long firmware_overflow_remote1 = 989L;
        long firmware_overflow_remote2 = 84L;
        long firmware_rx_errors = 81L;
        long firmware_tx_errors = 129L;
        long rds_bdi_nulls = 215L;
        long rds_bdi_overflows = 281L;
        long rds_bdi_seq_errors = 139L;
        long rds_discards = 903L;
        long rds_no_event = 649L;
        long rms_in_reset = 637L;
        long rms_inv_tids = 356L;
        long rms_link_down = 192L;
        long rms_orphans = 108L;
        long rms_unopened = 264L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Sum_TrendingTelemetry(driver_errors, firmware_cell_errors, firmware_link_down, firmware_link_errors, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_rx_errors, firmware_tx_errors, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_discards, rds_no_event, rms_in_reset, rms_inv_tids, rms_link_down, rms_orphans, rms_unopened));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Sum_TrendingTelemetry));
        Daq_monitor_Sum_TrendingTelemetry item_ = (Daq_monitor_Sum_TrendingTelemetry)item;
        Assert.assertEquals((long)driver_errors, (long)item_.getDriver_errors());
        Assert.assertEquals((long)firmware_cell_errors, (long)item_.getFirmware_cell_errors());
        Assert.assertEquals((long)firmware_link_down, (long)item_.getFirmware_link_down());
        Assert.assertEquals((long)firmware_link_errors, (long)item_.getFirmware_link_errors());
        Assert.assertEquals((long)firmware_overflow_local0, (long)item_.getFirmware_overflow_local0());
        Assert.assertEquals((long)firmware_overflow_local1, (long)item_.getFirmware_overflow_local1());
        Assert.assertEquals((long)firmware_overflow_local2, (long)item_.getFirmware_overflow_local2());
        Assert.assertEquals((long)firmware_overflow_remote0, (long)item_.getFirmware_overflow_remote0());
        Assert.assertEquals((long)firmware_overflow_remote1, (long)item_.getFirmware_overflow_remote1());
        Assert.assertEquals((long)firmware_overflow_remote2, (long)item_.getFirmware_overflow_remote2());
        Assert.assertEquals((long)firmware_rx_errors, (long)item_.getFirmware_rx_errors());
        Assert.assertEquals((long)firmware_tx_errors, (long)item_.getFirmware_tx_errors());
        Assert.assertEquals((long)rds_bdi_nulls, (long)item_.getRds_bdi_nulls());
        Assert.assertEquals((long)rds_bdi_overflows, (long)item_.getRds_bdi_overflows());
        Assert.assertEquals((long)rds_bdi_seq_errors, (long)item_.getRds_bdi_seq_errors());
        Assert.assertEquals((long)rds_discards, (long)item_.getRds_discards());
        Assert.assertEquals((long)rds_no_event, (long)item_.getRds_no_event());
        Assert.assertEquals((long)rms_in_reset, (long)item_.getRms_in_reset());
        Assert.assertEquals((long)rms_inv_tids, (long)item_.getRms_inv_tids());
        Assert.assertEquals((long)rms_link_down, (long)item_.getRms_link_down());
        Assert.assertEquals((long)rms_orphans, (long)item_.getRms_orphans());
        Assert.assertEquals((long)rms_unopened, (long)item_.getRms_unopened());
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)201, (int)955395906);
        String location = "i";
        double[] oDI = TestHelper.generateDoubleArray((int)201, (int)-2042322663);
        double[] oDV = TestHelper.generateDoubleArray((int)201, (int)375133405);
        double[] oGV = TestHelper.generateDoubleArray((int)201, (int)222673131);
        double[] rDV = TestHelper.generateDoubleArray((int)201, (int)-850479456);
        double[] temp = TestHelper.generateDoubleArray((int)201, (int)1494146765);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)71, (int)1144282287);
        double[] anaV = TestHelper.generateDoubleArray((int)71, (int)2008558228);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)71, (int)-685491271);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)71, (int)394235292);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)71, (int)-1189021742);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)71, (int)280110092);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)71, (int)52645011);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)71, (int)1986452098);
        double[] clkHI = TestHelper.generateDoubleArray((int)71, (int)162947782);
        double[] clkHV = TestHelper.generateDoubleArray((int)71, (int)-507415694);
        double[] clkLI = TestHelper.generateDoubleArray((int)71, (int)-352615526);
        double[] clkLV = TestHelper.generateDoubleArray((int)71, (int)591466364);
        double[] digI = TestHelper.generateDoubleArray((int)71, (int)-2120569687);
        double[] digV = TestHelper.generateDoubleArray((int)71, (int)-1186607487);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)71, (int)293842278);
        double[] htrPI = TestHelper.generateDoubleArray((int)71, (int)126253898);
        double[] htrPV = TestHelper.generateDoubleArray((int)71, (int)930430373);
        double[] htrV = TestHelper.generateDoubleArray((int)71, (int)-1631286799);
        double[] htrW = TestHelper.generateDoubleArray((int)71, (int)1767028307);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)71, (int)1651511465);
        double[] oDV = TestHelper.generateDoubleArray((int)71, (int)-1632247011);
        double[] pClk0 = TestHelper.generateDoubleArray((int)71, (int)-1501471408);
        double[] pClk1 = TestHelper.generateDoubleArray((int)71, (int)649365139);
        double[] pClkL = TestHelper.generateDoubleArray((int)71, (int)-1826204582);
        double[] pClkU = TestHelper.generateDoubleArray((int)71, (int)1705689061);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)-699154441);
        double[] rG0 = TestHelper.generateDoubleArray((int)71, (int)-1280316215);
        double[] rG1 = TestHelper.generateDoubleArray((int)71, (int)522692428);
        double[] rGL = TestHelper.generateDoubleArray((int)71, (int)-2026633003);
        double[] rGU = TestHelper.generateDoubleArray((int)71, (int)-1142484002);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)71, (int)-1180691312);
        double[] ref05V = TestHelper.generateDoubleArray((int)71, (int)2096522092);
        double[] ref125V = TestHelper.generateDoubleArray((int)71, (int)1206059398);
        double[] ref15V = TestHelper.generateDoubleArray((int)71, (int)1441866028);
        double[] ref25V = TestHelper.generateDoubleArray((int)71, (int)-1198312004);
        double[] refN12 = TestHelper.generateDoubleArray((int)71, (int)-1579504447);
        double[] refP12 = TestHelper.generateDoubleArray((int)71, (int)-716422332);
        double[] sClk0 = TestHelper.generateDoubleArray((int)71, (int)-1402711442);
        double[] sClk1 = TestHelper.generateDoubleArray((int)71, (int)1546036410);
        double[] sClkL = TestHelper.generateDoubleArray((int)71, (int)-1035258029);
        double[] sClkU = TestHelper.generateDoubleArray((int)71, (int)1768766960);
        double[] temp1 = TestHelper.generateDoubleArray((int)71, (int)-1633391189);
        double[] temp10 = TestHelper.generateDoubleArray((int)71, (int)-1666082791);
        double[] temp2 = TestHelper.generateDoubleArray((int)71, (int)1816655978);
        double[] temp3 = TestHelper.generateDoubleArray((int)71, (int)1919836968);
        double[] temp4 = TestHelper.generateDoubleArray((int)71, (int)1092962997);
        double[] temp5 = TestHelper.generateDoubleArray((int)71, (int)555237963);
        double[] temp6 = TestHelper.generateDoubleArray((int)71, (int)-1877854469);
        double[] temp7 = TestHelper.generateDoubleArray((int)71, (int)1790599076);
        double[] temp8 = TestHelper.generateDoubleArray((int)71, (int)1561205442);
        double[] temp9 = TestHelper.generateDoubleArray((int)71, (int)-1643101269);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClk1, pClkL, pClkU, power, rG0, rG1, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClk0, sClk1, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk1, (double[])item_.getPClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG1, (double[])item_.getRG1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk1, (double[])item_.getSClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.1345319151878357;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6Telemetry() throws Exception {
        double rebsAverageTemp6 = 0.16413915157318115;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebsAverageTemp6Telemetry(rebsAverageTemp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6Telemetry));
        Focal_plane_RebsAverageTemp6Telemetry item_ = (Focal_plane_RebsAverageTemp6Telemetry)item;
        Assert.assertEquals((double)rebsAverageTemp6, (double)item_.getRebsAverageTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)3024, (int)-1693379270);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_03Telemetry() throws Exception {
        double clp_RTD_03 = 0.9820212125778198;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_03Telemetry(clp_RTD_03));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_03Telemetry));
        Mpm_CLP_RTD_03Telemetry item_ = (Mpm_CLP_RTD_03Telemetry)item;
        Assert.assertEquals((double)clp_RTD_03, (double)item_.getClp_RTD_03(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_05Telemetry() throws Exception {
        double clp_RTD_05 = 0.5796330571174622;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_05Telemetry(clp_RTD_05));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_05Telemetry));
        Mpm_CLP_RTD_05Telemetry item_ = (Mpm_CLP_RTD_05Telemetry)item;
        Assert.assertEquals((double)clp_RTD_05, (double)item_.getClp_RTD_05(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_50Telemetry() throws Exception {
        double clp_RTD_50 = 0.6457613110542297;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_50Telemetry(clp_RTD_50));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_50Telemetry));
        Mpm_CLP_RTD_50Telemetry item_ = (Mpm_CLP_RTD_50Telemetry)item;
        Assert.assertEquals((double)clp_RTD_50, (double)item_.getClp_RTD_50(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_55Telemetry() throws Exception {
        double clp_RTD_55 = 0.2639222f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_55Telemetry(clp_RTD_55));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_55Telemetry));
        Mpm_CLP_RTD_55Telemetry item_ = (Mpm_CLP_RTD_55Telemetry)item;
        Assert.assertEquals((double)clp_RTD_55, (double)item_.getClp_RTD_55(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_12Telemetry() throws Exception {
        double cyp_RTD_12 = 0.03187215328216553;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_12Telemetry(cyp_RTD_12));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_12Telemetry));
        Mpm_CYP_RTD_12Telemetry item_ = (Mpm_CYP_RTD_12Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_12, (double)item_.getCyp_RTD_12(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_14Telemetry() throws Exception {
        double cyp_RTD_14 = 0.26263678073883057;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_14Telemetry(cyp_RTD_14));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_14Telemetry));
        Mpm_CYP_RTD_14Telemetry item_ = (Mpm_CYP_RTD_14Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_14, (double)item_.getCyp_RTD_14(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_31Telemetry() throws Exception {
        double cyp_RTD_31 = 0.28186362981796265;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_31Telemetry(cyp_RTD_31));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_31Telemetry));
        Mpm_CYP_RTD_31Telemetry item_ = (Mpm_CYP_RTD_31Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_31, (double)item_.getCyp_RTD_31(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_43Telemetry() throws Exception {
        double cyp_RTD_43 = 0.9397711753845215;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_43Telemetry(cyp_RTD_43));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_43Telemetry));
        Mpm_CYP_RTD_43Telemetry item_ = (Mpm_CYP_RTD_43Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_43, (double)item_.getCyp_RTD_43(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Autochanger_AutochangerTrucks_TrendingTelemetry() throws Exception {
        boolean actruckxminus_handoffInError = true;
        boolean actruckxminus_handoffSensorValue = false;
        boolean actruckxminus_onlineInError = false;
        boolean actruckxminus_onlineSensorValue = false;
        boolean actruckxminus_standbyInError = false;
        boolean actruckxminus_standbySensorValue = false;
        boolean actruckxplus_handoffInError = true;
        boolean actruckxplus_handoffSensorValue = false;
        boolean actruckxplus_onlineInError = true;
        boolean actruckxplus_onlineSensorValue = false;
        boolean actruckxplus_standbyInError = false;
        boolean actruckxplus_standbySensorValue = true;
        boolean atHandoff = false;
        boolean atOnline = true;
        boolean atStandby = false;
        int deltaDriverFollowerPosition = 399;
        int driverPosition = 465;
        int followerPosition = 472;
        boolean homingDone = true;
        boolean inError = false;
        int proximityDistance = 530;
        double proximityVoltage = 0.4188016f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry(actruckxminus_handoffInError, actruckxminus_handoffSensorValue, actruckxminus_onlineInError, actruckxminus_onlineSensorValue, actruckxminus_standbyInError, actruckxminus_standbySensorValue, actruckxplus_handoffInError, actruckxplus_handoffSensorValue, actruckxplus_onlineInError, actruckxplus_onlineSensorValue, actruckxplus_standbyInError, actruckxplus_standbySensorValue, atHandoff, atOnline, atStandby, deltaDriverFollowerPosition, driverPosition, followerPosition, homingDone, inError, proximityDistance, proximityVoltage));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry));
        Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry item_ = (Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry)item;
        Assert.assertEquals((Object)actruckxminus_handoffInError, (Object)item_.isActruckxminus_handoffInError());
        Assert.assertEquals((Object)actruckxminus_handoffSensorValue, (Object)item_.isActruckxminus_handoffSensorValue());
        Assert.assertEquals((Object)actruckxminus_onlineInError, (Object)item_.isActruckxminus_onlineInError());
        Assert.assertEquals((Object)actruckxminus_onlineSensorValue, (Object)item_.isActruckxminus_onlineSensorValue());
        Assert.assertEquals((Object)actruckxminus_standbyInError, (Object)item_.isActruckxminus_standbyInError());
        Assert.assertEquals((Object)actruckxminus_standbySensorValue, (Object)item_.isActruckxminus_standbySensorValue());
        Assert.assertEquals((Object)actruckxplus_handoffInError, (Object)item_.isActruckxplus_handoffInError());
        Assert.assertEquals((Object)actruckxplus_handoffSensorValue, (Object)item_.isActruckxplus_handoffSensorValue());
        Assert.assertEquals((Object)actruckxplus_onlineInError, (Object)item_.isActruckxplus_onlineInError());
        Assert.assertEquals((Object)actruckxplus_onlineSensorValue, (Object)item_.isActruckxplus_onlineSensorValue());
        Assert.assertEquals((Object)actruckxplus_standbyInError, (Object)item_.isActruckxplus_standbyInError());
        Assert.assertEquals((Object)actruckxplus_standbySensorValue, (Object)item_.isActruckxplus_standbySensorValue());
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atOnline, (Object)item_.isAtOnline());
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((long)deltaDriverFollowerPosition, (long)item_.getDeltaDriverFollowerPosition());
        Assert.assertEquals((long)driverPosition, (long)item_.getDriverPosition());
        Assert.assertEquals((long)followerPosition, (long)item_.getFollowerPosition());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)proximityDistance, (long)item_.getProximityDistance());
        Assert.assertEquals((double)proximityVoltage, (double)item_.getProximityVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Autochanger_Latches_TrendingTelemetry() throws Exception {
        boolean available = true;
        int filterID = 170;
        String filterName = "";
        String filterPresenceStatus = "";
        boolean latchxminus_filterEngagedSensorsInError = false;
        boolean latchxminus_filterPresenceSensorOn = false;
        boolean latchxminus_inError = false;
        boolean latchxminus_lockSensorOn = false;
        boolean latchxminus_lockSensorsInError = true;
        String latchxminus_lockStatus = "j";
        boolean latchxminus_unlockSensorOn = false;
        boolean latchxminus_unlockSensorsInError = false;
        boolean latchxplus_filterEngagedSensorsInError = true;
        boolean latchxplus_filterPresenceSensorOn = false;
        boolean latchxplus_inError = false;
        boolean latchxplus_lockSensorOn = true;
        boolean latchxplus_lockSensorsInError = false;
        String latchxplus_lockStatus = "";
        boolean latchxplus_unlockSensorOn = true;
        boolean latchxplus_unlockSensorsInError = true;
        String lockStatus = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_Latches_TrendingTelemetry(available, filterID, filterName, filterPresenceStatus, latchxminus_filterEngagedSensorsInError, latchxminus_filterPresenceSensorOn, latchxminus_inError, latchxminus_lockSensorOn, latchxminus_lockSensorsInError, latchxminus_lockStatus, latchxminus_unlockSensorOn, latchxminus_unlockSensorsInError, latchxplus_filterEngagedSensorsInError, latchxplus_filterPresenceSensorOn, latchxplus_inError, latchxplus_lockSensorOn, latchxplus_lockSensorsInError, latchxplus_lockStatus, latchxplus_unlockSensorOn, latchxplus_unlockSensorsInError, lockStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_Latches_TrendingTelemetry));
        Fcs_Autochanger_Latches_TrendingTelemetry item_ = (Fcs_Autochanger_Latches_TrendingTelemetry)item;
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((Object)latchxminus_filterEngagedSensorsInError, (Object)item_.isLatchxminus_filterEngagedSensorsInError());
        Assert.assertEquals((Object)latchxminus_filterPresenceSensorOn, (Object)item_.isLatchxminus_filterPresenceSensorOn());
        Assert.assertEquals((Object)latchxminus_inError, (Object)item_.isLatchxminus_inError());
        Assert.assertEquals((Object)latchxminus_lockSensorOn, (Object)item_.isLatchxminus_lockSensorOn());
        Assert.assertEquals((Object)latchxminus_lockSensorsInError, (Object)item_.isLatchxminus_lockSensorsInError());
        Assert.assertEquals((Object)latchxminus_lockStatus, (Object)item_.getLatchxminus_lockStatus());
        Assert.assertEquals((Object)latchxminus_unlockSensorOn, (Object)item_.isLatchxminus_unlockSensorOn());
        Assert.assertEquals((Object)latchxminus_unlockSensorsInError, (Object)item_.isLatchxminus_unlockSensorsInError());
        Assert.assertEquals((Object)latchxplus_filterEngagedSensorsInError, (Object)item_.isLatchxplus_filterEngagedSensorsInError());
        Assert.assertEquals((Object)latchxplus_filterPresenceSensorOn, (Object)item_.isLatchxplus_filterPresenceSensorOn());
        Assert.assertEquals((Object)latchxplus_inError, (Object)item_.isLatchxplus_inError());
        Assert.assertEquals((Object)latchxplus_lockSensorOn, (Object)item_.isLatchxplus_lockSensorOn());
        Assert.assertEquals((Object)latchxplus_lockSensorsInError, (Object)item_.isLatchxplus_lockSensorsInError());
        Assert.assertEquals((Object)latchxplus_lockStatus, (Object)item_.getLatchxplus_lockStatus());
        Assert.assertEquals((Object)latchxplus_unlockSensorOn, (Object)item_.isLatchxplus_unlockSensorOn());
        Assert.assertEquals((Object)latchxplus_unlockSensorsInError, (Object)item_.isLatchxplus_unlockSensorsInError());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
    }

    @Test
    public void sendReceiveFcs_Autochanger_OnlineClamps_TrendingTelemetry() throws Exception {
        String lockStatus = "e";
        int onlineClampRawStrain = 854;
        int onlineClampStrain = 845;
        int onlineclampxminus_current = 393;
        boolean onlineclampxminus_inError = true;
        boolean onlineclampxminus_lockSensorInError = true;
        boolean onlineclampxminus_lockSensorOn = false;
        String onlineclampxminus_lockStatus = "x";
        int onlineclampxminus_position = 594;
        int onlineclampxminus_sentCurrent = 601;
        boolean onlineclampxminus_unlockSensorInError = false;
        boolean onlineclampxminus_unlockSensorOn = false;
        int onlineclampxplus_current = 414;
        boolean onlineclampxplus_inError = false;
        boolean onlineclampxplus_lockSensorInError = false;
        boolean onlineclampxplus_lockSensorOn = true;
        String onlineclampxplus_lockStatus = "";
        int onlineclampxplus_position = 999;
        int onlineclampxplus_sentCurrent = 88;
        boolean onlineclampxplus_unlockSensorInError = false;
        boolean onlineclampxplus_unlockSensorOn = true;
        int onlineclampyminus_current = 947;
        boolean onlineclampyminus_inError = false;
        boolean onlineclampyminus_lockSensorInError = false;
        boolean onlineclampyminus_lockSensorOn = true;
        String onlineclampyminus_lockStatus = "r";
        int onlineclampyminus_position = 761;
        int onlineclampyminus_sentCurrent = 353;
        boolean onlineclampyminus_unlockSensorInError = false;
        boolean onlineclampyminus_unlockSensorOn = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_OnlineClamps_TrendingTelemetry(lockStatus, onlineClampRawStrain, onlineClampStrain, onlineclampxminus_current, onlineclampxminus_inError, onlineclampxminus_lockSensorInError, onlineclampxminus_lockSensorOn, onlineclampxminus_lockStatus, onlineclampxminus_position, onlineclampxminus_sentCurrent, onlineclampxminus_unlockSensorInError, onlineclampxminus_unlockSensorOn, onlineclampxplus_current, onlineclampxplus_inError, onlineclampxplus_lockSensorInError, onlineclampxplus_lockSensorOn, onlineclampxplus_lockStatus, onlineclampxplus_position, onlineclampxplus_sentCurrent, onlineclampxplus_unlockSensorInError, onlineclampxplus_unlockSensorOn, onlineclampyminus_current, onlineclampyminus_inError, onlineclampyminus_lockSensorInError, onlineclampyminus_lockSensorOn, onlineclampyminus_lockStatus, onlineclampyminus_position, onlineclampyminus_sentCurrent, onlineclampyminus_unlockSensorInError, onlineclampyminus_unlockSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_OnlineClamps_TrendingTelemetry));
        Fcs_Autochanger_OnlineClamps_TrendingTelemetry item_ = (Fcs_Autochanger_OnlineClamps_TrendingTelemetry)item;
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((long)onlineClampRawStrain, (long)item_.getOnlineClampRawStrain());
        Assert.assertEquals((long)onlineClampStrain, (long)item_.getOnlineClampStrain());
        Assert.assertEquals((long)onlineclampxminus_current, (long)item_.getOnlineclampxminus_current());
        Assert.assertEquals((Object)onlineclampxminus_inError, (Object)item_.isOnlineclampxminus_inError());
        Assert.assertEquals((Object)onlineclampxminus_lockSensorInError, (Object)item_.isOnlineclampxminus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampxminus_lockSensorOn, (Object)item_.isOnlineclampxminus_lockSensorOn());
        Assert.assertEquals((Object)onlineclampxminus_lockStatus, (Object)item_.getOnlineclampxminus_lockStatus());
        Assert.assertEquals((long)onlineclampxminus_position, (long)item_.getOnlineclampxminus_position());
        Assert.assertEquals((long)onlineclampxminus_sentCurrent, (long)item_.getOnlineclampxminus_sentCurrent());
        Assert.assertEquals((Object)onlineclampxminus_unlockSensorInError, (Object)item_.isOnlineclampxminus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampxminus_unlockSensorOn, (Object)item_.isOnlineclampxminus_unlockSensorOn());
        Assert.assertEquals((long)onlineclampxplus_current, (long)item_.getOnlineclampxplus_current());
        Assert.assertEquals((Object)onlineclampxplus_inError, (Object)item_.isOnlineclampxplus_inError());
        Assert.assertEquals((Object)onlineclampxplus_lockSensorInError, (Object)item_.isOnlineclampxplus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampxplus_lockSensorOn, (Object)item_.isOnlineclampxplus_lockSensorOn());
        Assert.assertEquals((Object)onlineclampxplus_lockStatus, (Object)item_.getOnlineclampxplus_lockStatus());
        Assert.assertEquals((long)onlineclampxplus_position, (long)item_.getOnlineclampxplus_position());
        Assert.assertEquals((long)onlineclampxplus_sentCurrent, (long)item_.getOnlineclampxplus_sentCurrent());
        Assert.assertEquals((Object)onlineclampxplus_unlockSensorInError, (Object)item_.isOnlineclampxplus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampxplus_unlockSensorOn, (Object)item_.isOnlineclampxplus_unlockSensorOn());
        Assert.assertEquals((long)onlineclampyminus_current, (long)item_.getOnlineclampyminus_current());
        Assert.assertEquals((Object)onlineclampyminus_inError, (Object)item_.isOnlineclampyminus_inError());
        Assert.assertEquals((Object)onlineclampyminus_lockSensorInError, (Object)item_.isOnlineclampyminus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampyminus_lockSensorOn, (Object)item_.isOnlineclampyminus_lockSensorOn());
        Assert.assertEquals((Object)onlineclampyminus_lockStatus, (Object)item_.getOnlineclampyminus_lockStatus());
        Assert.assertEquals((long)onlineclampyminus_position, (long)item_.getOnlineclampyminus_position());
        Assert.assertEquals((long)onlineclampyminus_sentCurrent, (long)item_.getOnlineclampyminus_sentCurrent());
        Assert.assertEquals((Object)onlineclampyminus_unlockSensorInError, (Object)item_.isOnlineclampyminus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampyminus_unlockSensorOn, (Object)item_.isOnlineclampyminus_unlockSensorOn());
    }

    @Test
    public void sendReceiveFcs_Autochanger_Temperatures_TrendingTelemetry() throws Exception {
        double cellXMinus = 0.3196784257888794;
        double clampMotorXMinus = 0.12565267086029053;
        double clampMotorXPlus = 0.7978700399398804;
        double clampMotorYMinus = 0.655930757522583;
        double frontBox = 0.5015441179275513;
        double linearRailMotorXMinus = 0.13211262226104736;
        double linearRailMotorXPlus = 0.604641318321228;
        double rearBox = 0.731478214263916;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_Temperatures_TrendingTelemetry(cellXMinus, clampMotorXMinus, clampMotorXPlus, clampMotorYMinus, frontBox, linearRailMotorXMinus, linearRailMotorXPlus, rearBox));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_Temperatures_TrendingTelemetry));
        Fcs_Autochanger_Temperatures_TrendingTelemetry item_ = (Fcs_Autochanger_Temperatures_TrendingTelemetry)item;
        Assert.assertEquals((double)cellXMinus, (double)item_.getCellXMinus(), (double)1.0E-6f);
        Assert.assertEquals((double)clampMotorXMinus, (double)item_.getClampMotorXMinus(), (double)1.0E-6f);
        Assert.assertEquals((double)clampMotorXPlus, (double)item_.getClampMotorXPlus(), (double)1.0E-6f);
        Assert.assertEquals((double)clampMotorYMinus, (double)item_.getClampMotorYMinus(), (double)1.0E-6f);
        Assert.assertEquals((double)frontBox, (double)item_.getFrontBox(), (double)1.0E-6f);
        Assert.assertEquals((double)linearRailMotorXMinus, (double)item_.getLinearRailMotorXMinus(), (double)1.0E-6f);
        Assert.assertEquals((double)linearRailMotorXPlus, (double)item_.getLinearRailMotorXPlus(), (double)1.0E-6f);
        Assert.assertEquals((double)rearBox, (double)item_.getRearBox(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Autochanger_TrendingTelemetry() throws Exception {
        String id = "c";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_TrendingTelemetry(id));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_TrendingTelemetry));
        Fcs_Autochanger_TrendingTelemetry item_ = (Fcs_Autochanger_TrendingTelemetry)item;
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcSensorsGateway_TrendingTelemetry() throws Exception {
        int carouselHoldingFilterSensor0 = 19;
        int carouselHoldingFilterSensor1 = 748;
        int carouselStoppedAtStandby = 499;
        int carouselStoppedAtStandbyC = 230;
        int carousel_CF0 = 628;
        int carousel_CF0_C = 994;
        int carousel_CF1 = 744;
        int carousel_CF1_C = 856;
        int closeSensorBLatchXminus = 500;
        int closeSensorBLatchXplus = 361;
        int closeSensorLatchXminus = 957;
        int closeSensorLatchXplus = 530;
        int engineeringKey = 313;
        int engineeringkey_C = 519;
        int filterEngagedSensorBLatchXminus = 853;
        int filterEngagedSensorBLatchXplus = 685;
        int filterEngagedSensorLatchXminus = 797;
        int filterEngagedSensorLatchXplus = 421;
        int filterIDSensor0 = 949;
        int filterIDSensor1 = 113;
        int filterIDSensor2 = 267;
        int filterIDSensor3 = 763;
        int filterIDSensor4 = 167;
        int filterIDSensor5 = 442;
        int handoffPositionSensorBXminus = 33;
        int handoffPositionSensorBXplus = 119;
        int handoffPositionSensorXminus = 675;
        int handoffPositionSensorXplus = 232;
        double inclinometerXminus = 0.7024776339530945;
        double inclinometerXplus = 0.22802305221557617;
        int loaderConnectedSensor = 84;
        int loaderConnectedSensorC = 59;
        int loaderHoldingFilterSensor0 = 890;
        int loaderHoldingFilterSensor1 = 255;
        int lockOut = 832;
        int lockOutShunt = 377;
        int lockout_C = 68;
        int lpmLatchesStatus = 489;
        int lpmLinearRail1Status = 962;
        int lpmLinearRail2Status = 190;
        int lpmOnlineClampsStatus = 321;
        int out_AF0 = 31;
        int out_AF0_C = 210;
        int out_AF1 = 391;
        int out_AF1_C = 814;
        int out_AF3 = 823;
        int out_AF3_C = 155;
        int out_AIN = 875;
        int out_AOL = 937;
        int out_AP1 = 717;
        int out_AP1_C = 13;
        int out_AP2 = 470;
        int out_AP2_C = 12;
        int out_AP3 = 517;
        int out_AP3_C = 161;
        int onlineClampXminusCloseSensor = 715;
        int onlineClampXminusCloseSensorC = 303;
        int onlineClampXminusOpenSensor = 733;
        int onlineClampXminusOpenSensorC = 874;
        int onlineClampXplusCloseSensor = 45;
        int onlineClampXplusCloseSensorC = 580;
        int onlineClampXplusOpenSensor = 240;
        int onlineClampXplusOpenSensorC = 211;
        int onlineClampYminusCloseSensor = 234;
        int onlineClampYminusCloseSensorC = 636;
        int onlineClampYminusOpenSensor = 184;
        int onlineClampYminusOpenSensorC = 963;
        int onlinePositionSensorBXminus = 917;
        int onlinePositionSensorBXplus = 727;
        int onlinePositionSensorXminus = 907;
        int onlinePositionSensorXplus = 101;
        int openSensorBLatchXminus = 102;
        int openSensorBLatchXplus = 73;
        int openSensorLatchXminus = 441;
        int openSensorLatchXplus = 828;
        int presenceLoader = 40;
        int presenceloader_C = 391;
        int standbyPositionSensorBXminus = 367;
        int standbyPositionSensorBXplus = 524;
        int standbyPositionSensorXminus = 735;
        int standbyPositionSensorXplus = 977;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry(carouselHoldingFilterSensor0, carouselHoldingFilterSensor1, carouselStoppedAtStandby, carouselStoppedAtStandbyC, carousel_CF0, carousel_CF0_C, carousel_CF1, carousel_CF1_C, closeSensorBLatchXminus, closeSensorBLatchXplus, closeSensorLatchXminus, closeSensorLatchXplus, engineeringKey, engineeringkey_C, filterEngagedSensorBLatchXminus, filterEngagedSensorBLatchXplus, filterEngagedSensorLatchXminus, filterEngagedSensorLatchXplus, filterIDSensor0, filterIDSensor1, filterIDSensor2, filterIDSensor3, filterIDSensor4, filterIDSensor5, handoffPositionSensorBXminus, handoffPositionSensorBXplus, handoffPositionSensorXminus, handoffPositionSensorXplus, inclinometerXminus, inclinometerXplus, loaderConnectedSensor, loaderConnectedSensorC, loaderHoldingFilterSensor0, loaderHoldingFilterSensor1, lockOut, lockOutShunt, lockout_C, lpmLatchesStatus, lpmLinearRail1Status, lpmLinearRail2Status, lpmOnlineClampsStatus, out_AF0, out_AF0_C, out_AF1, out_AF1_C, out_AF3, out_AF3_C, out_AIN, out_AOL, out_AP1, out_AP1_C, out_AP2, out_AP2_C, out_AP3, out_AP3_C, onlineClampXminusCloseSensor, onlineClampXminusCloseSensorC, onlineClampXminusOpenSensor, onlineClampXminusOpenSensorC, onlineClampXplusCloseSensor, onlineClampXplusCloseSensorC, onlineClampXplusOpenSensor, onlineClampXplusOpenSensorC, onlineClampYminusCloseSensor, onlineClampYminusCloseSensorC, onlineClampYminusOpenSensor, onlineClampYminusOpenSensorC, onlinePositionSensorBXminus, onlinePositionSensorBXplus, onlinePositionSensorXminus, onlinePositionSensorXplus, openSensorBLatchXminus, openSensorBLatchXplus, openSensorLatchXminus, openSensorLatchXplus, presenceLoader, presenceloader_C, standbyPositionSensorBXminus, standbyPositionSensorBXplus, standbyPositionSensorXminus, standbyPositionSensorXplus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry));
        Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry item_ = (Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)carouselHoldingFilterSensor0, (long)item_.getCarouselHoldingFilterSensor0());
        Assert.assertEquals((long)carouselHoldingFilterSensor1, (long)item_.getCarouselHoldingFilterSensor1());
        Assert.assertEquals((long)carouselStoppedAtStandby, (long)item_.getCarouselStoppedAtStandby());
        Assert.assertEquals((long)carouselStoppedAtStandbyC, (long)item_.getCarouselStoppedAtStandbyC());
        Assert.assertEquals((long)carousel_CF0, (long)item_.getCarousel_CF0());
        Assert.assertEquals((long)carousel_CF0_C, (long)item_.getCarousel_CF0_C());
        Assert.assertEquals((long)carousel_CF1, (long)item_.getCarousel_CF1());
        Assert.assertEquals((long)carousel_CF1_C, (long)item_.getCarousel_CF1_C());
        Assert.assertEquals((long)closeSensorBLatchXminus, (long)item_.getCloseSensorBLatchXminus());
        Assert.assertEquals((long)closeSensorBLatchXplus, (long)item_.getCloseSensorBLatchXplus());
        Assert.assertEquals((long)closeSensorLatchXminus, (long)item_.getCloseSensorLatchXminus());
        Assert.assertEquals((long)closeSensorLatchXplus, (long)item_.getCloseSensorLatchXplus());
        Assert.assertEquals((long)engineeringKey, (long)item_.getEngineeringKey());
        Assert.assertEquals((long)engineeringkey_C, (long)item_.getEngineeringkey_C());
        Assert.assertEquals((long)filterEngagedSensorBLatchXminus, (long)item_.getFilterEngagedSensorBLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorBLatchXplus, (long)item_.getFilterEngagedSensorBLatchXplus());
        Assert.assertEquals((long)filterEngagedSensorLatchXminus, (long)item_.getFilterEngagedSensorLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorLatchXplus, (long)item_.getFilterEngagedSensorLatchXplus());
        Assert.assertEquals((long)filterIDSensor0, (long)item_.getFilterIDSensor0());
        Assert.assertEquals((long)filterIDSensor1, (long)item_.getFilterIDSensor1());
        Assert.assertEquals((long)filterIDSensor2, (long)item_.getFilterIDSensor2());
        Assert.assertEquals((long)filterIDSensor3, (long)item_.getFilterIDSensor3());
        Assert.assertEquals((long)filterIDSensor4, (long)item_.getFilterIDSensor4());
        Assert.assertEquals((long)filterIDSensor5, (long)item_.getFilterIDSensor5());
        Assert.assertEquals((long)handoffPositionSensorBXminus, (long)item_.getHandoffPositionSensorBXminus());
        Assert.assertEquals((long)handoffPositionSensorBXplus, (long)item_.getHandoffPositionSensorBXplus());
        Assert.assertEquals((long)handoffPositionSensorXminus, (long)item_.getHandoffPositionSensorXminus());
        Assert.assertEquals((long)handoffPositionSensorXplus, (long)item_.getHandoffPositionSensorXplus());
        Assert.assertEquals((double)inclinometerXminus, (double)item_.getInclinometerXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinometerXplus, (double)item_.getInclinometerXplus(), (double)1.0E-6f);
        Assert.assertEquals((long)loaderConnectedSensor, (long)item_.getLoaderConnectedSensor());
        Assert.assertEquals((long)loaderConnectedSensorC, (long)item_.getLoaderConnectedSensorC());
        Assert.assertEquals((long)loaderHoldingFilterSensor0, (long)item_.getLoaderHoldingFilterSensor0());
        Assert.assertEquals((long)loaderHoldingFilterSensor1, (long)item_.getLoaderHoldingFilterSensor1());
        Assert.assertEquals((long)lockOut, (long)item_.getLockOut());
        Assert.assertEquals((long)lockOutShunt, (long)item_.getLockOutShunt());
        Assert.assertEquals((long)lockout_C, (long)item_.getLockout_C());
        Assert.assertEquals((long)lpmLatchesStatus, (long)item_.getLpmLatchesStatus());
        Assert.assertEquals((long)lpmLinearRail1Status, (long)item_.getLpmLinearRail1Status());
        Assert.assertEquals((long)lpmLinearRail2Status, (long)item_.getLpmLinearRail2Status());
        Assert.assertEquals((long)lpmOnlineClampsStatus, (long)item_.getLpmOnlineClampsStatus());
        Assert.assertEquals((long)out_AF0, (long)item_.getOut_AF0());
        Assert.assertEquals((long)out_AF0_C, (long)item_.getOut_AF0_C());
        Assert.assertEquals((long)out_AF1, (long)item_.getOut_AF1());
        Assert.assertEquals((long)out_AF1_C, (long)item_.getOut_AF1_C());
        Assert.assertEquals((long)out_AF3, (long)item_.getOut_AF3());
        Assert.assertEquals((long)out_AF3_C, (long)item_.getOut_AF3_C());
        Assert.assertEquals((long)out_AIN, (long)item_.getOut_AIN());
        Assert.assertEquals((long)out_AOL, (long)item_.getOut_AOL());
        Assert.assertEquals((long)out_AP1, (long)item_.getOut_AP1());
        Assert.assertEquals((long)out_AP1_C, (long)item_.getOut_AP1_C());
        Assert.assertEquals((long)out_AP2, (long)item_.getOut_AP2());
        Assert.assertEquals((long)out_AP2_C, (long)item_.getOut_AP2_C());
        Assert.assertEquals((long)out_AP3, (long)item_.getOut_AP3());
        Assert.assertEquals((long)out_AP3_C, (long)item_.getOut_AP3_C());
        Assert.assertEquals((long)onlineClampXminusCloseSensor, (long)item_.getOnlineClampXminusCloseSensor());
        Assert.assertEquals((long)onlineClampXminusCloseSensorC, (long)item_.getOnlineClampXminusCloseSensorC());
        Assert.assertEquals((long)onlineClampXminusOpenSensor, (long)item_.getOnlineClampXminusOpenSensor());
        Assert.assertEquals((long)onlineClampXminusOpenSensorC, (long)item_.getOnlineClampXminusOpenSensorC());
        Assert.assertEquals((long)onlineClampXplusCloseSensor, (long)item_.getOnlineClampXplusCloseSensor());
        Assert.assertEquals((long)onlineClampXplusCloseSensorC, (long)item_.getOnlineClampXplusCloseSensorC());
        Assert.assertEquals((long)onlineClampXplusOpenSensor, (long)item_.getOnlineClampXplusOpenSensor());
        Assert.assertEquals((long)onlineClampXplusOpenSensorC, (long)item_.getOnlineClampXplusOpenSensorC());
        Assert.assertEquals((long)onlineClampYminusCloseSensor, (long)item_.getOnlineClampYminusCloseSensor());
        Assert.assertEquals((long)onlineClampYminusCloseSensorC, (long)item_.getOnlineClampYminusCloseSensorC());
        Assert.assertEquals((long)onlineClampYminusOpenSensor, (long)item_.getOnlineClampYminusOpenSensor());
        Assert.assertEquals((long)onlineClampYminusOpenSensorC, (long)item_.getOnlineClampYminusOpenSensorC());
        Assert.assertEquals((long)onlinePositionSensorBXminus, (long)item_.getOnlinePositionSensorBXminus());
        Assert.assertEquals((long)onlinePositionSensorBXplus, (long)item_.getOnlinePositionSensorBXplus());
        Assert.assertEquals((long)onlinePositionSensorXminus, (long)item_.getOnlinePositionSensorXminus());
        Assert.assertEquals((long)onlinePositionSensorXplus, (long)item_.getOnlinePositionSensorXplus());
        Assert.assertEquals((long)openSensorBLatchXminus, (long)item_.getOpenSensorBLatchXminus());
        Assert.assertEquals((long)openSensorBLatchXplus, (long)item_.getOpenSensorBLatchXplus());
        Assert.assertEquals((long)openSensorLatchXminus, (long)item_.getOpenSensorLatchXminus());
        Assert.assertEquals((long)openSensorLatchXplus, (long)item_.getOpenSensorLatchXplus());
        Assert.assertEquals((long)presenceLoader, (long)item_.getPresenceLoader());
        Assert.assertEquals((long)presenceloader_C, (long)item_.getPresenceloader_C());
        Assert.assertEquals((long)standbyPositionSensorBXminus, (long)item_.getStandbyPositionSensorBXminus());
        Assert.assertEquals((long)standbyPositionSensorBXplus, (long)item_.getStandbyPositionSensorBXplus());
        Assert.assertEquals((long)standbyPositionSensorXminus, (long)item_.getStandbyPositionSensorXminus());
        Assert.assertEquals((long)standbyPositionSensorXplus, (long)item_.getStandbyPositionSensorXplus());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcTruckXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 67;
        boolean brakeActivated = true;
        int current = 692;
        int errorHistoryNB = 706;
        String errorRegister = "p";
        int followingError = 871;
        boolean inError = true;
        int lastErrorCode = 166;
        String lastErrorName = "k";
        String mode = "q";
        int position = 903;
        long profileAcceleration = 186L;
        long profileDeceleration = 580L;
        long profileVelocity = 186L;
        String state = "";
        int velocity = 444;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry));
        Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcTruckXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 177;
        boolean brakeActivated = false;
        int current = 183;
        int errorHistoryNB = 932;
        String errorRegister = "m";
        int followingError = 889;
        boolean inError = true;
        int lastErrorCode = 648;
        String lastErrorName = "";
        String mode = "l";
        int position = 913;
        long profileAcceleration = 62L;
        long profileDeceleration = 390L;
        long profileVelocity = 105L;
        String state = "";
        int velocity = 192;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry));
        Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Accelerobf_TrendingTelemetry() throws Exception {
        double accelerationX = 0.5205914974212646;
        double accelerationY = 0.4071318f;
        double accelerationZ = 0.9044538736343384;
        double airmass = 0.16029822826385498;
        double angularVelocityX = 0.8837661147117615;
        double angularVelocityY = 0.35979437828063965;
        double angularVelocityZ = 0.5035951137542725;
        double azimut = 0.152605f;
        double elevation = 0.39034295082092285;
        int errorHistoryNB = 654;
        String errorRegister = "";
        double gravity = 0.8492515683174133;
        boolean inError = true;
        int lastErrorCode = 690;
        String lastErrorName = "";
        double normalizedAccelerationX = 0.234718918800354;
        double normalizedAccelerationY = 0.4080614447593689;
        double normalizedAccelerationZ = 0.6104007959365845;
        double normalizedGravity = 0.9823462963104248;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Accelerobf_TrendingTelemetry(accelerationX, accelerationY, accelerationZ, airmass, angularVelocityX, angularVelocityY, angularVelocityZ, azimut, elevation, errorHistoryNB, errorRegister, gravity, inError, lastErrorCode, lastErrorName, normalizedAccelerationX, normalizedAccelerationY, normalizedAccelerationZ, normalizedGravity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Accelerobf_TrendingTelemetry));
        Fcs_Canbus0_Accelerobf_TrendingTelemetry item_ = (Fcs_Canbus0_Accelerobf_TrendingTelemetry)item;
        Assert.assertEquals((double)accelerationX, (double)item_.getAccelerationX(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationY, (double)item_.getAccelerationY(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationZ, (double)item_.getAccelerationZ(), (double)1.0E-6f);
        Assert.assertEquals((double)airmass, (double)item_.getAirmass(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityX, (double)item_.getAngularVelocityX(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityY, (double)item_.getAngularVelocityY(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityZ, (double)item_.getAngularVelocityZ(), (double)1.0E-6f);
        Assert.assertEquals((double)azimut, (double)item_.getAzimut(), (double)1.0E-6f);
        Assert.assertEquals((double)elevation, (double)item_.getElevation(), (double)1.0E-6f);
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((double)gravity, (double)item_.getGravity(), (double)1.0E-6f);
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((double)normalizedAccelerationX, (double)item_.getNormalizedAccelerationX(), (double)1.0E-6f);
        Assert.assertEquals((double)normalizedAccelerationY, (double)item_.getNormalizedAccelerationY(), (double)1.0E-6f);
        Assert.assertEquals((double)normalizedAccelerationZ, (double)item_.getNormalizedAccelerationZ(), (double)1.0E-6f);
        Assert.assertEquals((double)normalizedGravity, (double)item_.getNormalizedGravity(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Canbus0_Ai814_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 58;
        String errorRegister = "";
        boolean inError = true;
        int lastErrorCode = 500;
        String lastErrorName = "k";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Ai814_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Ai814_TrendingTelemetry));
        Fcs_Canbus0_Ai814_TrendingTelemetry item_ = (Fcs_Canbus0_Ai814_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_CarouselController_TrendingTelemetry() throws Exception {
        int averageCurrent = 78;
        boolean brakeActivated = false;
        int current = 247;
        int errorHistoryNB = 287;
        String errorRegister = "x";
        int followingError = 152;
        boolean inError = false;
        int lastErrorCode = 853;
        String lastErrorName = "f";
        String mode = "s";
        int position = 614;
        int positionSensorType = 443;
        long profileAcceleration = 92L;
        long profileDeceleration = 932L;
        long profileVelocity = 709L;
        String state = "";
        int velocity = 851;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_CarouselController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, positionSensorType, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_CarouselController_TrendingTelemetry));
        Fcs_Canbus0_CarouselController_TrendingTelemetry item_ = (Fcs_Canbus0_CarouselController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)positionSensorType, (long)item_.getPositionSensorType());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ClampXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 373;
        boolean brakeActivated = true;
        int current = 363;
        int errorHistoryNB = 51;
        String errorRegister = "c";
        int followingError = 2;
        boolean inError = false;
        int lastErrorCode = 880;
        String lastErrorName = "t";
        String mode = "m";
        int position = 321;
        long profileAcceleration = 916L;
        long profileDeceleration = 988L;
        long profileVelocity = 586L;
        String state = "";
        int velocity = 481;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ClampXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ClampXminusController_TrendingTelemetry));
        Fcs_Canbus0_ClampXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_ClampXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ClampXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 792;
        boolean brakeActivated = true;
        int current = 40;
        int errorHistoryNB = 326;
        String errorRegister = "";
        int followingError = 945;
        boolean inError = true;
        int lastErrorCode = 60;
        String lastErrorName = "";
        String mode = "e";
        int position = 624;
        long profileAcceleration = 19L;
        long profileDeceleration = 799L;
        long profileVelocity = 404L;
        String state = "o";
        int velocity = 524;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ClampXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ClampXplusController_TrendingTelemetry));
        Fcs_Canbus0_ClampXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_ClampXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Hyttc580_TrendingTelemetry() throws Exception {
        int currentSlipRing = 102;
        int plc_caAF3 = 29;
        int plc_caAF3b = 214;
        int plc_caAP1 = 292;
        int plc_caAP1b = 767;
        int plc_caAP2 = 444;
        int plc_caAP2b = 331;
        int plc_caAP3 = 41;
        int plc_caAP3b = 641;
        int plc_caBrakesActivated = 561;
        int plc_caCF0 = 432;
        int plc_caCF0b = 496;
        int plc_caCF1 = 421;
        int plc_caCF1b = 129;
        int plc_caCFC = 813;
        int plc_caCFCb = 643;
        int plc_caCS = 991;
        int plc_caCSb = 266;
        int plc_caEnableBrakes = 753;
        int plc_caEnableRotation = 831;
        int plc_caEnableShutter = 501;
        int plc_caEnableUnclamp = 993;
        int plc_caEng = 581;
        int plc_caEngb = 212;
        int plc_caLockout = 814;
        int plc_caLockoutb = 784;
        int plc_caShutterInactive = 420;
        int plc_caSleep = 596;
        int plc_enableShutterInterlock = 519;
        int plc_okDI = 568;
        int plc_okDIsafety = 830;
        int plc_powerSave = 650;
        int plc_tpCheckRotation = 905;
        int plc_tpStopRotation = 38;
        int plc_tpStopUnclamp = 828;
        double temperatures_averageClamps = 0.10796147584915161;
        double temperatures_internalHYTTC580 = 0.4437282085418701;
        double temperatures_socket1 = 0.4931296110153198;
        double temperatures_socket2 = 0.195176899433136;
        double temperatures_socket3 = 0.10653454065322876;
        double temperatures_socket4 = 0.9975863695144653;
        double temperatures_socket5 = 0.930972158908844;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Hyttc580_TrendingTelemetry(currentSlipRing, plc_caAF3, plc_caAF3b, plc_caAP1, plc_caAP1b, plc_caAP2, plc_caAP2b, plc_caAP3, plc_caAP3b, plc_caBrakesActivated, plc_caCF0, plc_caCF0b, plc_caCF1, plc_caCF1b, plc_caCFC, plc_caCFCb, plc_caCS, plc_caCSb, plc_caEnableBrakes, plc_caEnableRotation, plc_caEnableShutter, plc_caEnableUnclamp, plc_caEng, plc_caEngb, plc_caLockout, plc_caLockoutb, plc_caShutterInactive, plc_caSleep, plc_enableShutterInterlock, plc_okDI, plc_okDIsafety, plc_powerSave, plc_tpCheckRotation, plc_tpStopRotation, plc_tpStopUnclamp, temperatures_averageClamps, temperatures_internalHYTTC580, temperatures_socket1, temperatures_socket2, temperatures_socket3, temperatures_socket4, temperatures_socket5));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Hyttc580_TrendingTelemetry));
        Fcs_Canbus0_Hyttc580_TrendingTelemetry item_ = (Fcs_Canbus0_Hyttc580_TrendingTelemetry)item;
        Assert.assertEquals((long)currentSlipRing, (long)item_.getCurrentSlipRing());
        Assert.assertEquals((long)plc_caAF3, (long)item_.getPlc_caAF3());
        Assert.assertEquals((long)plc_caAF3b, (long)item_.getPlc_caAF3b());
        Assert.assertEquals((long)plc_caAP1, (long)item_.getPlc_caAP1());
        Assert.assertEquals((long)plc_caAP1b, (long)item_.getPlc_caAP1b());
        Assert.assertEquals((long)plc_caAP2, (long)item_.getPlc_caAP2());
        Assert.assertEquals((long)plc_caAP2b, (long)item_.getPlc_caAP2b());
        Assert.assertEquals((long)plc_caAP3, (long)item_.getPlc_caAP3());
        Assert.assertEquals((long)plc_caAP3b, (long)item_.getPlc_caAP3b());
        Assert.assertEquals((long)plc_caBrakesActivated, (long)item_.getPlc_caBrakesActivated());
        Assert.assertEquals((long)plc_caCF0, (long)item_.getPlc_caCF0());
        Assert.assertEquals((long)plc_caCF0b, (long)item_.getPlc_caCF0b());
        Assert.assertEquals((long)plc_caCF1, (long)item_.getPlc_caCF1());
        Assert.assertEquals((long)plc_caCF1b, (long)item_.getPlc_caCF1b());
        Assert.assertEquals((long)plc_caCFC, (long)item_.getPlc_caCFC());
        Assert.assertEquals((long)plc_caCFCb, (long)item_.getPlc_caCFCb());
        Assert.assertEquals((long)plc_caCS, (long)item_.getPlc_caCS());
        Assert.assertEquals((long)plc_caCSb, (long)item_.getPlc_caCSb());
        Assert.assertEquals((long)plc_caEnableBrakes, (long)item_.getPlc_caEnableBrakes());
        Assert.assertEquals((long)plc_caEnableRotation, (long)item_.getPlc_caEnableRotation());
        Assert.assertEquals((long)plc_caEnableShutter, (long)item_.getPlc_caEnableShutter());
        Assert.assertEquals((long)plc_caEnableUnclamp, (long)item_.getPlc_caEnableUnclamp());
        Assert.assertEquals((long)plc_caEng, (long)item_.getPlc_caEng());
        Assert.assertEquals((long)plc_caEngb, (long)item_.getPlc_caEngb());
        Assert.assertEquals((long)plc_caLockout, (long)item_.getPlc_caLockout());
        Assert.assertEquals((long)plc_caLockoutb, (long)item_.getPlc_caLockoutb());
        Assert.assertEquals((long)plc_caShutterInactive, (long)item_.getPlc_caShutterInactive());
        Assert.assertEquals((long)plc_caSleep, (long)item_.getPlc_caSleep());
        Assert.assertEquals((long)plc_enableShutterInterlock, (long)item_.getPlc_enableShutterInterlock());
        Assert.assertEquals((long)plc_okDI, (long)item_.getPlc_okDI());
        Assert.assertEquals((long)plc_okDIsafety, (long)item_.getPlc_okDIsafety());
        Assert.assertEquals((long)plc_powerSave, (long)item_.getPlc_powerSave());
        Assert.assertEquals((long)plc_tpCheckRotation, (long)item_.getPlc_tpCheckRotation());
        Assert.assertEquals((long)plc_tpStopRotation, (long)item_.getPlc_tpStopRotation());
        Assert.assertEquals((long)plc_tpStopUnclamp, (long)item_.getPlc_tpStopUnclamp());
        Assert.assertEquals((double)temperatures_averageClamps, (double)item_.getTemperatures_averageClamps(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_internalHYTTC580, (double)item_.getTemperatures_internalHYTTC580(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_socket1, (double)item_.getTemperatures_socket1(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_socket2, (double)item_.getTemperatures_socket2(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_socket3, (double)item_.getTemperatures_socket3(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_socket4, (double)item_.getTemperatures_socket4(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_socket5, (double)item_.getTemperatures_socket5(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Canbus0_LatchXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 127;
        boolean brakeActivated = true;
        int current = 614;
        int errorHistoryNB = 27;
        String errorRegister = "m";
        int followingError = 127;
        boolean inError = true;
        int lastErrorCode = 54;
        String lastErrorName = "d";
        String mode = "";
        int position = 220;
        long profileAcceleration = 685L;
        long profileDeceleration = 968L;
        long profileVelocity = 5L;
        String state = "l";
        int velocity = 261;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_LatchXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_LatchXminusController_TrendingTelemetry));
        Fcs_Canbus0_LatchXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_LatchXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_LatchXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 982;
        boolean brakeActivated = true;
        int current = 859;
        int errorHistoryNB = 478;
        String errorRegister = "w";
        int followingError = 418;
        boolean inError = true;
        int lastErrorCode = 440;
        String lastErrorName = "";
        String mode = "m";
        int position = 800;
        long profileAcceleration = 29L;
        long profileDeceleration = 495L;
        long profileVelocity = 755L;
        String state = "c";
        int velocity = 930;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_LatchXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_LatchXplusController_TrendingTelemetry));
        Fcs_Canbus0_LatchXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_LatchXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 468;
        boolean brakeActivated = false;
        int current = 219;
        int errorHistoryNB = 919;
        String errorRegister = "";
        int followingError = 202;
        boolean inError = false;
        int lastErrorCode = 384;
        String lastErrorName = "";
        String mode = "u";
        int position = 210;
        long profileAcceleration = 994L;
        long profileDeceleration = 852L;
        long profileVelocity = 592L;
        String state = "";
        int velocity = 979;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 252;
        boolean brakeActivated = false;
        int current = 788;
        int errorHistoryNB = 386;
        String errorRegister = "v";
        int followingError = 520;
        boolean inError = false;
        int lastErrorCode = 419;
        String lastErrorName = "";
        String mode = "";
        int position = 16;
        long profileAcceleration = 780L;
        long profileDeceleration = 899L;
        long profileVelocity = 563L;
        String state = "x";
        int velocity = 548;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampYminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 609;
        boolean brakeActivated = true;
        int current = 767;
        int errorHistoryNB = 254;
        String errorRegister = "";
        int followingError = 626;
        boolean inError = false;
        int lastErrorCode = 991;
        String lastErrorName = "j";
        String mode = "w";
        int position = 75;
        long profileAcceleration = 963L;
        long profileDeceleration = 936L;
        long profileVelocity = 899L;
        String state = "t";
        int velocity = 607;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineStrainGauge_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 806;
        String errorRegister = "";
        boolean inError = false;
        int lastErrorCode = 181;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry));
        Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 165;
        String errorRegister = "";
        boolean inError = false;
        int lastErrorCode = 239;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry));
        Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry item_ = (Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Pt100_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 813;
        String errorRegister = "";
        boolean inError = false;
        int lastErrorCode = 273;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Pt100_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Pt100_TrendingTelemetry));
        Fcs_Canbus0_Pt100_TrendingTelemetry item_ = (Fcs_Canbus0_Pt100_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_TempSensorsDevice1_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 799;
        String errorRegister = "d";
        boolean inError = true;
        int lastErrorCode = 869;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry));
        Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry item_ = (Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_TempSensorsDevice2_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 63;
        String errorRegister = "";
        boolean inError = true;
        int lastErrorCode = 954;
        String lastErrorName = "w";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry));
        Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry item_ = (Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus1_CarrierController_TrendingTelemetry() throws Exception {
        int averageCurrent = 851;
        boolean brakeActivated = false;
        int current = 378;
        int errorHistoryNB = 252;
        String errorRegister = "";
        int followingError = 244;
        boolean inError = false;
        int lastErrorCode = 675;
        String lastErrorName = "";
        String mode = "";
        int position = 783;
        long profileAcceleration = 540L;
        long profileDeceleration = 173L;
        long profileVelocity = 707L;
        String state = "";
        int velocity = 561;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_CarrierController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_CarrierController_TrendingTelemetry));
        Fcs_Canbus1_CarrierController_TrendingTelemetry item_ = (Fcs_Canbus1_CarrierController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus1_HooksController_TrendingTelemetry() throws Exception {
        int averageCurrent = 393;
        boolean brakeActivated = false;
        int current = 556;
        int errorHistoryNB = 85;
        String errorRegister = "u";
        int followingError = 935;
        boolean inError = false;
        int lastErrorCode = 976;
        String lastErrorName = "";
        String mode = "";
        int position = 23;
        long profileAcceleration = 77L;
        long profileDeceleration = 835L;
        long profileVelocity = 292L;
        String state = "c";
        int velocity = 760;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_HooksController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_HooksController_TrendingTelemetry));
        Fcs_Canbus1_HooksController_TrendingTelemetry item_ = (Fcs_Canbus1_HooksController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry() throws Exception {
        int acAF0b = 150;
        int acAF0s = 61;
        int acAF1b = 322;
        int acAF1s = 348;
        int acAF3b = 967;
        int acAF3s = 271;
        int acAP2b = 247;
        int acAP2s = 248;
        int clampedStatusSensor = 786;
        int forceSensor0 = 443;
        int forceSensor1 = 612;
        int keyEng = 91;
        int keyEngb = 305;
        int keyLock = 50;
        int keyLockb = 867;
        int lps_0 = 873;
        int lps_1 = 86;
        int lrh_0 = 160;
        int lrh_1 = 872;
        int loaderCarrierRelayStatus = 906;
        int loaderChainPresenceSensor = 254;
        int loaderCloseSensor1 = 747;
        int loaderCloseSensor2 = 116;
        int loaderCloseSensor3 = 69;
        int loaderCloseSensor4 = 51;
        int loaderDefaultStatus = 733;
        int loaderEngagedPositionSensor0 = 531;
        int loaderEngagedPositionSensor1 = 427;
        int loaderFilterDistanceSensor = 604;
        int loaderFilterGoodPositionStatus = 389;
        int loaderFilterPresenceSensor0 = 140;
        int loaderFilterPresenceSensor1 = 360;
        int loaderHandoffPositionSensor0 = 147;
        int loaderHandoffPositionSensor1 = 101;
        int loaderHooksRelayStatus = 708;
        int loaderOnCameraSensor0 = 787;
        int loaderOnCameraSensor1 = 154;
        int loaderOpenSensor1 = 572;
        int loaderOpenSensor2 = 256;
        int loaderOpenSensor3 = 431;
        int loaderOpenSensor4 = 411;
        int loaderStoragePositionSensor0 = 242;
        int loaderStoragePositionSensor1 = 141;
        int loader_LFD = 931;
        int loader_LFS = 827;
        int overClampedStatusSensor = 276;
        int unclampedStatusSensor = 149;
        int underClampedStatusSensor = 44;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry(acAF0b, acAF0s, acAF1b, acAF1s, acAF3b, acAF3s, acAP2b, acAP2s, clampedStatusSensor, forceSensor0, forceSensor1, keyEng, keyEngb, keyLock, keyLockb, lps_0, lps_1, lrh_0, lrh_1, loaderCarrierRelayStatus, loaderChainPresenceSensor, loaderCloseSensor1, loaderCloseSensor2, loaderCloseSensor3, loaderCloseSensor4, loaderDefaultStatus, loaderEngagedPositionSensor0, loaderEngagedPositionSensor1, loaderFilterDistanceSensor, loaderFilterGoodPositionStatus, loaderFilterPresenceSensor0, loaderFilterPresenceSensor1, loaderHandoffPositionSensor0, loaderHandoffPositionSensor1, loaderHooksRelayStatus, loaderOnCameraSensor0, loaderOnCameraSensor1, loaderOpenSensor1, loaderOpenSensor2, loaderOpenSensor3, loaderOpenSensor4, loaderStoragePositionSensor0, loaderStoragePositionSensor1, loader_LFD, loader_LFS, overClampedStatusSensor, unclampedStatusSensor, underClampedStatusSensor));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry));
        Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry item_ = (Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)acAF0b, (long)item_.getAcAF0b());
        Assert.assertEquals((long)acAF0s, (long)item_.getAcAF0s());
        Assert.assertEquals((long)acAF1b, (long)item_.getAcAF1b());
        Assert.assertEquals((long)acAF1s, (long)item_.getAcAF1s());
        Assert.assertEquals((long)acAF3b, (long)item_.getAcAF3b());
        Assert.assertEquals((long)acAF3s, (long)item_.getAcAF3s());
        Assert.assertEquals((long)acAP2b, (long)item_.getAcAP2b());
        Assert.assertEquals((long)acAP2s, (long)item_.getAcAP2s());
        Assert.assertEquals((long)clampedStatusSensor, (long)item_.getClampedStatusSensor());
        Assert.assertEquals((long)forceSensor0, (long)item_.getForceSensor0());
        Assert.assertEquals((long)forceSensor1, (long)item_.getForceSensor1());
        Assert.assertEquals((long)keyEng, (long)item_.getKeyEng());
        Assert.assertEquals((long)keyEngb, (long)item_.getKeyEngb());
        Assert.assertEquals((long)keyLock, (long)item_.getKeyLock());
        Assert.assertEquals((long)keyLockb, (long)item_.getKeyLockb());
        Assert.assertEquals((long)lps_0, (long)item_.getLps_0());
        Assert.assertEquals((long)lps_1, (long)item_.getLps_1());
        Assert.assertEquals((long)lrh_0, (long)item_.getLrh_0());
        Assert.assertEquals((long)lrh_1, (long)item_.getLrh_1());
        Assert.assertEquals((long)loaderCarrierRelayStatus, (long)item_.getLoaderCarrierRelayStatus());
        Assert.assertEquals((long)loaderChainPresenceSensor, (long)item_.getLoaderChainPresenceSensor());
        Assert.assertEquals((long)loaderCloseSensor1, (long)item_.getLoaderCloseSensor1());
        Assert.assertEquals((long)loaderCloseSensor2, (long)item_.getLoaderCloseSensor2());
        Assert.assertEquals((long)loaderCloseSensor3, (long)item_.getLoaderCloseSensor3());
        Assert.assertEquals((long)loaderCloseSensor4, (long)item_.getLoaderCloseSensor4());
        Assert.assertEquals((long)loaderDefaultStatus, (long)item_.getLoaderDefaultStatus());
        Assert.assertEquals((long)loaderEngagedPositionSensor0, (long)item_.getLoaderEngagedPositionSensor0());
        Assert.assertEquals((long)loaderEngagedPositionSensor1, (long)item_.getLoaderEngagedPositionSensor1());
        Assert.assertEquals((long)loaderFilterDistanceSensor, (long)item_.getLoaderFilterDistanceSensor());
        Assert.assertEquals((long)loaderFilterGoodPositionStatus, (long)item_.getLoaderFilterGoodPositionStatus());
        Assert.assertEquals((long)loaderFilterPresenceSensor0, (long)item_.getLoaderFilterPresenceSensor0());
        Assert.assertEquals((long)loaderFilterPresenceSensor1, (long)item_.getLoaderFilterPresenceSensor1());
        Assert.assertEquals((long)loaderHandoffPositionSensor0, (long)item_.getLoaderHandoffPositionSensor0());
        Assert.assertEquals((long)loaderHandoffPositionSensor1, (long)item_.getLoaderHandoffPositionSensor1());
        Assert.assertEquals((long)loaderHooksRelayStatus, (long)item_.getLoaderHooksRelayStatus());
        Assert.assertEquals((long)loaderOnCameraSensor0, (long)item_.getLoaderOnCameraSensor0());
        Assert.assertEquals((long)loaderOnCameraSensor1, (long)item_.getLoaderOnCameraSensor1());
        Assert.assertEquals((long)loaderOpenSensor1, (long)item_.getLoaderOpenSensor1());
        Assert.assertEquals((long)loaderOpenSensor2, (long)item_.getLoaderOpenSensor2());
        Assert.assertEquals((long)loaderOpenSensor3, (long)item_.getLoaderOpenSensor3());
        Assert.assertEquals((long)loaderOpenSensor4, (long)item_.getLoaderOpenSensor4());
        Assert.assertEquals((long)loaderStoragePositionSensor0, (long)item_.getLoaderStoragePositionSensor0());
        Assert.assertEquals((long)loaderStoragePositionSensor1, (long)item_.getLoaderStoragePositionSensor1());
        Assert.assertEquals((long)loader_LFD, (long)item_.getLoader_LFD());
        Assert.assertEquals((long)loader_LFS, (long)item_.getLoader_LFS());
        Assert.assertEquals((long)overClampedStatusSensor, (long)item_.getOverClampedStatusSensor());
        Assert.assertEquals((long)unclampedStatusSensor, (long)item_.getUnclampedStatusSensor());
        Assert.assertEquals((long)underClampedStatusSensor, (long)item_.getUnderClampedStatusSensor());
    }

    @Test
    public void sendReceiveFcs_Carousel_Brakes_TrendingTelemetry() throws Exception {
        String brakeState1 = "k";
        String brakeState2 = "";
        String brakeState3 = "f";
        long sensor1 = 381L;
        long sensor2 = 949L;
        long sensor3 = 527L;
        double temperature1 = 0.6262786388397217;
        double temperature2 = 0.581102f;
        double temperature3 = 0.7957332730293274;
        double temperature4 = 0.9048423767089844;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Brakes_TrendingTelemetry(brakeState1, brakeState2, brakeState3, sensor1, sensor2, sensor3, temperature1, temperature2, temperature3, temperature4));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Brakes_TrendingTelemetry));
        Fcs_Carousel_Brakes_TrendingTelemetry item_ = (Fcs_Carousel_Brakes_TrendingTelemetry)item;
        Assert.assertEquals((Object)brakeState1, (Object)item_.getBrakeState1());
        Assert.assertEquals((Object)brakeState2, (Object)item_.getBrakeState2());
        Assert.assertEquals((Object)brakeState3, (Object)item_.getBrakeState3());
        Assert.assertEquals((long)sensor1, (long)item_.getSensor1());
        Assert.assertEquals((long)sensor2, (long)item_.getSensor2());
        Assert.assertEquals((long)sensor3, (long)item_.getSensor3());
        Assert.assertEquals((double)temperature1, (double)item_.getTemperature1(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature2, (double)item_.getTemperature2(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature3, (double)item_.getTemperature3(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature4, (double)item_.getTemperature4(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket1_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        boolean available = false;
        String clampxminus1_clampState = "";
        int clampxminus1_filterPositionSensorValue = 390;
        int clampxminus1_filterPresenceOffset2 = 844;
        String clampxminus1_filterPresenceStatus = "i";
        int clampxminus1_lockSensorOffset1 = 869;
        int clampxminus1_lockSensorValue = 485;
        String clampxminus1_lockStatus = "";
        String clampxplus1_clampState = "";
        int clampxplus1_filterPositionSensorValue = 766;
        int clampxplus1_filterPresenceOffset2 = 758;
        String clampxplus1_filterPresenceStatus = "";
        int clampxplus1_lockSensorOffset1 = 812;
        int clampxplus1_lockSensorValue = 86;
        String clampxplus1_lockStatus = "v";
        String clampsState = "";
        boolean empty = true;
        int filterID = 110;
        String filterName = "l";
        String ioStatus = "";
        int socketID = 600;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket1_TrendingTelemetry(atStandby, available, clampxminus1_clampState, clampxminus1_filterPositionSensorValue, clampxminus1_filterPresenceOffset2, clampxminus1_filterPresenceStatus, clampxminus1_lockSensorOffset1, clampxminus1_lockSensorValue, clampxminus1_lockStatus, clampxplus1_clampState, clampxplus1_filterPositionSensorValue, clampxplus1_filterPresenceOffset2, clampxplus1_filterPresenceStatus, clampxplus1_lockSensorOffset1, clampxplus1_lockSensorValue, clampxplus1_lockStatus, clampsState, empty, filterID, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket1_TrendingTelemetry));
        Fcs_Carousel_Socket1_TrendingTelemetry item_ = (Fcs_Carousel_Socket1_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampxminus1_clampState, (Object)item_.getClampxminus1_clampState());
        Assert.assertEquals((long)clampxminus1_filterPositionSensorValue, (long)item_.getClampxminus1_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus1_filterPresenceOffset2, (long)item_.getClampxminus1_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus1_filterPresenceStatus, (Object)item_.getClampxminus1_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus1_lockSensorOffset1, (long)item_.getClampxminus1_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus1_lockSensorValue, (long)item_.getClampxminus1_lockSensorValue());
        Assert.assertEquals((Object)clampxminus1_lockStatus, (Object)item_.getClampxminus1_lockStatus());
        Assert.assertEquals((Object)clampxplus1_clampState, (Object)item_.getClampxplus1_clampState());
        Assert.assertEquals((long)clampxplus1_filterPositionSensorValue, (long)item_.getClampxplus1_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus1_filterPresenceOffset2, (long)item_.getClampxplus1_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus1_filterPresenceStatus, (Object)item_.getClampxplus1_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus1_lockSensorOffset1, (long)item_.getClampxplus1_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus1_lockSensorValue, (long)item_.getClampxplus1_lockSensorValue());
        Assert.assertEquals((Object)clampxplus1_lockStatus, (Object)item_.getClampxplus1_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket2_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        boolean available = false;
        String clampxminus2_clampState = "";
        int clampxminus2_filterPositionSensorValue = 845;
        int clampxminus2_filterPresenceOffset2 = 182;
        String clampxminus2_filterPresenceStatus = "";
        int clampxminus2_lockSensorOffset1 = 330;
        int clampxminus2_lockSensorValue = 350;
        String clampxminus2_lockStatus = "k";
        String clampxplus2_clampState = "e";
        int clampxplus2_filterPositionSensorValue = 851;
        int clampxplus2_filterPresenceOffset2 = 417;
        String clampxplus2_filterPresenceStatus = "b";
        int clampxplus2_lockSensorOffset1 = 348;
        int clampxplus2_lockSensorValue = 282;
        String clampxplus2_lockStatus = "y";
        String clampsState = "";
        boolean empty = true;
        int filterID = 321;
        String filterName = "b";
        String ioStatus = "t";
        int socketID = 331;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket2_TrendingTelemetry(atStandby, available, clampxminus2_clampState, clampxminus2_filterPositionSensorValue, clampxminus2_filterPresenceOffset2, clampxminus2_filterPresenceStatus, clampxminus2_lockSensorOffset1, clampxminus2_lockSensorValue, clampxminus2_lockStatus, clampxplus2_clampState, clampxplus2_filterPositionSensorValue, clampxplus2_filterPresenceOffset2, clampxplus2_filterPresenceStatus, clampxplus2_lockSensorOffset1, clampxplus2_lockSensorValue, clampxplus2_lockStatus, clampsState, empty, filterID, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket2_TrendingTelemetry));
        Fcs_Carousel_Socket2_TrendingTelemetry item_ = (Fcs_Carousel_Socket2_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampxminus2_clampState, (Object)item_.getClampxminus2_clampState());
        Assert.assertEquals((long)clampxminus2_filterPositionSensorValue, (long)item_.getClampxminus2_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus2_filterPresenceOffset2, (long)item_.getClampxminus2_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus2_filterPresenceStatus, (Object)item_.getClampxminus2_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus2_lockSensorOffset1, (long)item_.getClampxminus2_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus2_lockSensorValue, (long)item_.getClampxminus2_lockSensorValue());
        Assert.assertEquals((Object)clampxminus2_lockStatus, (Object)item_.getClampxminus2_lockStatus());
        Assert.assertEquals((Object)clampxplus2_clampState, (Object)item_.getClampxplus2_clampState());
        Assert.assertEquals((long)clampxplus2_filterPositionSensorValue, (long)item_.getClampxplus2_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus2_filterPresenceOffset2, (long)item_.getClampxplus2_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus2_filterPresenceStatus, (Object)item_.getClampxplus2_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus2_lockSensorOffset1, (long)item_.getClampxplus2_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus2_lockSensorValue, (long)item_.getClampxplus2_lockSensorValue());
        Assert.assertEquals((Object)clampxplus2_lockStatus, (Object)item_.getClampxplus2_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket3_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        boolean available = false;
        String clampxminus3_clampState = "l";
        int clampxminus3_filterPositionSensorValue = 255;
        int clampxminus3_filterPresenceOffset2 = 865;
        String clampxminus3_filterPresenceStatus = "";
        int clampxminus3_lockSensorOffset1 = 639;
        int clampxminus3_lockSensorValue = 153;
        String clampxminus3_lockStatus = "n";
        String clampxplus3_clampState = "";
        int clampxplus3_filterPositionSensorValue = 315;
        int clampxplus3_filterPresenceOffset2 = 181;
        String clampxplus3_filterPresenceStatus = "w";
        int clampxplus3_lockSensorOffset1 = 194;
        int clampxplus3_lockSensorValue = 50;
        String clampxplus3_lockStatus = "f";
        String clampsState = "r";
        boolean empty = true;
        int filterID = 488;
        String filterName = "";
        String ioStatus = "k";
        int socketID = 395;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket3_TrendingTelemetry(atStandby, available, clampxminus3_clampState, clampxminus3_filterPositionSensorValue, clampxminus3_filterPresenceOffset2, clampxminus3_filterPresenceStatus, clampxminus3_lockSensorOffset1, clampxminus3_lockSensorValue, clampxminus3_lockStatus, clampxplus3_clampState, clampxplus3_filterPositionSensorValue, clampxplus3_filterPresenceOffset2, clampxplus3_filterPresenceStatus, clampxplus3_lockSensorOffset1, clampxplus3_lockSensorValue, clampxplus3_lockStatus, clampsState, empty, filterID, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket3_TrendingTelemetry));
        Fcs_Carousel_Socket3_TrendingTelemetry item_ = (Fcs_Carousel_Socket3_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampxminus3_clampState, (Object)item_.getClampxminus3_clampState());
        Assert.assertEquals((long)clampxminus3_filterPositionSensorValue, (long)item_.getClampxminus3_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus3_filterPresenceOffset2, (long)item_.getClampxminus3_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus3_filterPresenceStatus, (Object)item_.getClampxminus3_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus3_lockSensorOffset1, (long)item_.getClampxminus3_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus3_lockSensorValue, (long)item_.getClampxminus3_lockSensorValue());
        Assert.assertEquals((Object)clampxminus3_lockStatus, (Object)item_.getClampxminus3_lockStatus());
        Assert.assertEquals((Object)clampxplus3_clampState, (Object)item_.getClampxplus3_clampState());
        Assert.assertEquals((long)clampxplus3_filterPositionSensorValue, (long)item_.getClampxplus3_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus3_filterPresenceOffset2, (long)item_.getClampxplus3_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus3_filterPresenceStatus, (Object)item_.getClampxplus3_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus3_lockSensorOffset1, (long)item_.getClampxplus3_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus3_lockSensorValue, (long)item_.getClampxplus3_lockSensorValue());
        Assert.assertEquals((Object)clampxplus3_lockStatus, (Object)item_.getClampxplus3_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket4_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        boolean available = false;
        String clampxminus4_clampState = "";
        int clampxminus4_filterPositionSensorValue = 920;
        int clampxminus4_filterPresenceOffset2 = 678;
        String clampxminus4_filterPresenceStatus = "d";
        int clampxminus4_lockSensorOffset1 = 639;
        int clampxminus4_lockSensorValue = 47;
        String clampxminus4_lockStatus = "";
        String clampxplus4_clampState = "";
        int clampxplus4_filterPositionSensorValue = 365;
        int clampxplus4_filterPresenceOffset2 = 545;
        String clampxplus4_filterPresenceStatus = "";
        int clampxplus4_lockSensorOffset1 = 321;
        int clampxplus4_lockSensorValue = 464;
        String clampxplus4_lockStatus = "s";
        String clampsState = "q";
        boolean empty = true;
        int filterID = 945;
        String filterName = "";
        String ioStatus = "m";
        int socketID = 515;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket4_TrendingTelemetry(atStandby, available, clampxminus4_clampState, clampxminus4_filterPositionSensorValue, clampxminus4_filterPresenceOffset2, clampxminus4_filterPresenceStatus, clampxminus4_lockSensorOffset1, clampxminus4_lockSensorValue, clampxminus4_lockStatus, clampxplus4_clampState, clampxplus4_filterPositionSensorValue, clampxplus4_filterPresenceOffset2, clampxplus4_filterPresenceStatus, clampxplus4_lockSensorOffset1, clampxplus4_lockSensorValue, clampxplus4_lockStatus, clampsState, empty, filterID, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket4_TrendingTelemetry));
        Fcs_Carousel_Socket4_TrendingTelemetry item_ = (Fcs_Carousel_Socket4_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampxminus4_clampState, (Object)item_.getClampxminus4_clampState());
        Assert.assertEquals((long)clampxminus4_filterPositionSensorValue, (long)item_.getClampxminus4_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus4_filterPresenceOffset2, (long)item_.getClampxminus4_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus4_filterPresenceStatus, (Object)item_.getClampxminus4_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus4_lockSensorOffset1, (long)item_.getClampxminus4_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus4_lockSensorValue, (long)item_.getClampxminus4_lockSensorValue());
        Assert.assertEquals((Object)clampxminus4_lockStatus, (Object)item_.getClampxminus4_lockStatus());
        Assert.assertEquals((Object)clampxplus4_clampState, (Object)item_.getClampxplus4_clampState());
        Assert.assertEquals((long)clampxplus4_filterPositionSensorValue, (long)item_.getClampxplus4_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus4_filterPresenceOffset2, (long)item_.getClampxplus4_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus4_filterPresenceStatus, (Object)item_.getClampxplus4_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus4_lockSensorOffset1, (long)item_.getClampxplus4_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus4_lockSensorValue, (long)item_.getClampxplus4_lockSensorValue());
        Assert.assertEquals((Object)clampxplus4_lockStatus, (Object)item_.getClampxplus4_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket5_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        boolean available = true;
        String clampxminus5_clampState = "";
        int clampxminus5_filterPositionSensorValue = 285;
        int clampxminus5_filterPresenceOffset2 = 599;
        String clampxminus5_filterPresenceStatus = "";
        int clampxminus5_lockSensorOffset1 = 670;
        int clampxminus5_lockSensorValue = 931;
        String clampxminus5_lockStatus = "";
        String clampxplus5_clampState = "";
        int clampxplus5_filterPositionSensorValue = 106;
        int clampxplus5_filterPresenceOffset2 = 169;
        String clampxplus5_filterPresenceStatus = "";
        int clampxplus5_lockSensorOffset1 = 192;
        int clampxplus5_lockSensorValue = 105;
        String clampxplus5_lockStatus = "a";
        String clampsState = "";
        boolean empty = false;
        int filterID = 930;
        String filterName = "";
        String ioStatus = "";
        int socketID = 40;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket5_TrendingTelemetry(atStandby, available, clampxminus5_clampState, clampxminus5_filterPositionSensorValue, clampxminus5_filterPresenceOffset2, clampxminus5_filterPresenceStatus, clampxminus5_lockSensorOffset1, clampxminus5_lockSensorValue, clampxminus5_lockStatus, clampxplus5_clampState, clampxplus5_filterPositionSensorValue, clampxplus5_filterPresenceOffset2, clampxplus5_filterPresenceStatus, clampxplus5_lockSensorOffset1, clampxplus5_lockSensorValue, clampxplus5_lockStatus, clampsState, empty, filterID, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket5_TrendingTelemetry));
        Fcs_Carousel_Socket5_TrendingTelemetry item_ = (Fcs_Carousel_Socket5_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampxminus5_clampState, (Object)item_.getClampxminus5_clampState());
        Assert.assertEquals((long)clampxminus5_filterPositionSensorValue, (long)item_.getClampxminus5_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus5_filterPresenceOffset2, (long)item_.getClampxminus5_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus5_filterPresenceStatus, (Object)item_.getClampxminus5_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus5_lockSensorOffset1, (long)item_.getClampxminus5_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus5_lockSensorValue, (long)item_.getClampxminus5_lockSensorValue());
        Assert.assertEquals((Object)clampxminus5_lockStatus, (Object)item_.getClampxminus5_lockStatus());
        Assert.assertEquals((Object)clampxplus5_clampState, (Object)item_.getClampxplus5_clampState());
        Assert.assertEquals((long)clampxplus5_filterPositionSensorValue, (long)item_.getClampxplus5_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus5_filterPresenceOffset2, (long)item_.getClampxplus5_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus5_filterPresenceStatus, (Object)item_.getClampxplus5_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus5_lockSensorOffset1, (long)item_.getClampxplus5_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus5_lockSensorValue, (long)item_.getClampxplus5_lockSensorValue());
        Assert.assertEquals((Object)clampxplus5_lockStatus, (Object)item_.getClampxplus5_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        boolean available = true;
        String clampsStateAtStandby = "z";
        int deltaPositionAtStandby = 184;
        boolean emptyAtStandby = false;
        int estimatedPosition = 222;
        int filterAtStandbyID = 398;
        String filterOnAutochangerName = "r";
        long minLocked = 544L;
        int socketAtStandbyID = 500;
        String socketAtStandbyName = "t";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_TrendingTelemetry(atStandby, available, clampsStateAtStandby, deltaPositionAtStandby, emptyAtStandby, estimatedPosition, filterAtStandbyID, filterOnAutochangerName, minLocked, socketAtStandbyID, socketAtStandbyName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_TrendingTelemetry));
        Fcs_Carousel_TrendingTelemetry item_ = (Fcs_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampsStateAtStandby, (Object)item_.getClampsStateAtStandby());
        Assert.assertEquals((long)deltaPositionAtStandby, (long)item_.getDeltaPositionAtStandby());
        Assert.assertEquals((Object)emptyAtStandby, (Object)item_.isEmptyAtStandby());
        Assert.assertEquals((long)estimatedPosition, (long)item_.getEstimatedPosition());
        Assert.assertEquals((long)filterAtStandbyID, (long)item_.getFilterAtStandbyID());
        Assert.assertEquals((Object)filterOnAutochangerName, (Object)item_.getFilterOnAutochangerName());
        Assert.assertEquals((long)minLocked, (long)item_.getMinLocked());
        Assert.assertEquals((long)socketAtStandbyID, (long)item_.getSocketAtStandbyID());
        Assert.assertEquals((Object)socketAtStandbyName, (Object)item_.getSocketAtStandbyName());
    }

    @Test
    public void sendReceiveFcs_Counters_Autochanger_TrendingTelemetry() throws Exception {
        double autochangertrucks_ALIGN_FOLLOWER = 0.8343644738197327;
        double autochangertrucks_MOVE_DRIVER_TRUCK_ALONE = 0.790593683719635;
        double autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE = 0.5374930500984192;
        double autochangertrucks_MOVE_TO_ABSOLUTE_POSITION = 0.7791630625724792;
        double latches_latchXminus_CLOSE = 0.63848f;
        double latches_latchXminus_OPEN = 0.1971091f;
        double latches_latchXplus_CLOSE = 0.36058497428894043;
        double latches_latchXplus_OPEN = 0.8409298658370972;
        double onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 0.4553765654563904;
        double onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 0.8915982246398926;
        double onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP = 0.9371393322944641;
        double onlineclamps_onlineClampXminus_OPEN_HALFWAY_RELATIVE_POSITION = 0.615372f;
        double onlineclamps_onlineClampXminus_OPEN_HOMING_ONLINECLAMP = 0.9440457820892334;
        double onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT = 0.420219f;
        double onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE = 0.18155354261398315;
        double onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 0.9970463514328003;
        double onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 0.8535187840461731;
        double onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP = 0.3346911072731018;
        double onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT = 0.29200756549835205;
        double onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 0.2666816711425781;
        double onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP = 0.34122687578201294;
        double onlineclamps_onlineClampXplus_OPEN_HALFWAY_RELATIVE_POSITION = 0.5784653425216675;
        double onlineclamps_onlineClampXplus_OPEN_HOMING_ONLINECLAMP = 0.4601287245750427;
        double onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT = 0.6771931648254395;
        double onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE = 0.5553991794586182;
        double onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 0.7675917148590088;
        double onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT = 0.2091974f;
        double onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP = 0.003401815891265869;
        double onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 0.9991077780723572;
        double onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 0.09032237529754639;
        double onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP = 0.2911042f;
        double onlineclamps_onlineClampYminus_OPEN_HALFWAY_RELATIVE_POSITION = 0.11515432596206665;
        double onlineclamps_onlineClampYminus_OPEN_HOMING_ONLINECLAMP = 0.1840064525604248;
        double onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT = 0.41136884689331055;
        double onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE = 0.5856832265853882;
        double onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 0.547085f;
        double onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 0.3362230658531189;
        double onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP = 0.7708615064620972;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Counters_Autochanger_TrendingTelemetry(autochangertrucks_ALIGN_FOLLOWER, autochangertrucks_MOVE_DRIVER_TRUCK_ALONE, autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, latches_latchXminus_CLOSE, latches_latchXminus_OPEN, latches_latchXplus_CLOSE, latches_latchXplus_OPEN, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXminus_OPEN_HALFWAY_RELATIVE_POSITION, onlineclamps_onlineClampXminus_OPEN_HOMING_ONLINECLAMP, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_OPEN_HALFWAY_RELATIVE_POSITION, onlineclamps_onlineClampXplus_OPEN_HOMING_ONLINECLAMP, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_OPEN_HALFWAY_RELATIVE_POSITION, onlineclamps_onlineClampYminus_OPEN_HOMING_ONLINECLAMP, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP));
        Assert.assertTrue((boolean)(item instanceof Fcs_Counters_Autochanger_TrendingTelemetry));
        Fcs_Counters_Autochanger_TrendingTelemetry item_ = (Fcs_Counters_Autochanger_TrendingTelemetry)item;
        Assert.assertEquals((double)autochangertrucks_ALIGN_FOLLOWER, (double)item_.getAutochangertrucks_ALIGN_FOLLOWER(), (double)1.0E-6f);
        Assert.assertEquals((double)autochangertrucks_MOVE_DRIVER_TRUCK_ALONE, (double)item_.getAutochangertrucks_MOVE_DRIVER_TRUCK_ALONE(), (double)1.0E-6f);
        Assert.assertEquals((double)autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, (double)item_.getAutochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE(), (double)1.0E-6f);
        Assert.assertEquals((double)autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, (double)item_.getAutochangertrucks_MOVE_TO_ABSOLUTE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)latches_latchXminus_CLOSE, (double)item_.getLatches_latchXminus_CLOSE(), (double)1.0E-6f);
        Assert.assertEquals((double)latches_latchXminus_OPEN, (double)item_.getLatches_latchXminus_OPEN(), (double)1.0E-6f);
        Assert.assertEquals((double)latches_latchXplus_CLOSE, (double)item_.getLatches_latchXplus_CLOSE(), (double)1.0E-6f);
        Assert.assertEquals((double)latches_latchXplus_OPEN, (double)item_.getLatches_latchXplus_OPEN(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampXminus_LOCK_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_OPEN_HALFWAY_RELATIVE_POSITION, (double)item_.getOnlineclamps_onlineClampXminus_OPEN_HALFWAY_RELATIVE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_OPEN_HOMING_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampXminus_OPEN_HOMING_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE, (double)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampXplus_LOCK_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_OPEN_HALFWAY_RELATIVE_POSITION, (double)item_.getOnlineclamps_onlineClampXplus_OPEN_HALFWAY_RELATIVE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_OPEN_HOMING_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampXplus_OPEN_HOMING_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE, (double)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampYminus_LOCK_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_OPEN_HALFWAY_RELATIVE_POSITION, (double)item_.getOnlineclamps_onlineClampYminus_OPEN_HALFWAY_RELATIVE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_OPEN_HOMING_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampYminus_OPEN_HOMING_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE, (double)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Counters_Carousel_TrendingTelemetry() throws Exception {
        double recovery_ROTATION_BACKWARD = 0.4583044f;
        double recovery_ROTATION_FORWARD = 0.0441548228263855;
        double recovery_ROTATION_STRAIGHT = 0.5807642340660095;
        double rotate_CAROUSEL_TO_ABSOLUTE_POSITION = 0.17478978633880615;
        double rotate_CAROUSEL_TO_RELATIVE_POSITION = 0.3210238814353943;
        double socket1_RELEASE_CLAMPS = 0.49725866317749023;
        double socket1_STORE_FILTER_ON_CAROUSEL = 0.3278064f;
        double socket1_UNLOCK_CLAMPS = 0.2590084f;
        double socket1_clampXminus1_RECOVERY_CLAMP_XMINUS = 0.6906159520149231;
        double socket1_clampXminus1_RECOVERY_UNCLAMP = 0.02514267f;
        double socket1_clampXminus1_RELEASE = 0.06614041328430176;
        double socket1_clampXminus1_UNLOCK = 0.7143787145614624;
        double socket1_clampXplus1_RECOVERY_UNCLAMP = 0.2780084013938904;
        double socket1_clampXplus1_RELEASE = 0.07579177618026733;
        double socket1_clampXplus1_UNLOCK = 0.56568443775177;
        double socket2_RELEASE_CLAMPS = 0.9435044527053833;
        double socket2_STORE_FILTER_ON_CAROUSEL = 0.7157146334648132;
        double socket2_UNLOCK_CLAMPS = 0.8211161494255066;
        double socket2_clampXminus2_RECOVERY_CLAMP_XMINUS = 0.5603989362716675;
        double socket2_clampXminus2_RECOVERY_UNCLAMP = 0.20266777276992798;
        double socket2_clampXminus2_RELEASE = 0.5236191153526306;
        double socket2_clampXminus2_UNLOCK = 0.2026004195213318;
        double socket2_clampXplus2_RECOVERY_UNCLAMP = 0.3612499237060547;
        double socket2_clampXplus2_RELEASE = 0.9044482111930847;
        double socket2_clampXplus2_UNLOCK = 0.12287229299545288;
        double socket3_RELEASE_CLAMPS = 0.2926226258277893;
        double socket3_STORE_FILTER_ON_CAROUSEL = 0.9003398418426514;
        double socket3_UNLOCK_CLAMPS = 0.02122288942337036;
        double socket3_clampXminus3_RECOVERY_CLAMP_XMINUS = 0.8797598481178284;
        double socket3_clampXminus3_RECOVERY_UNCLAMP = 0.0970568060874939;
        double socket3_clampXminus3_RELEASE = 0.3743353486061096;
        double socket3_clampXminus3_UNLOCK = 0.8570195436477661;
        double socket3_clampXplus3_RECOVERY_UNCLAMP = 0.7464203834533691;
        double socket3_clampXplus3_RELEASE = 0.1108478307723999;
        double socket3_clampXplus3_UNLOCK = 0.7083825469017029;
        double socket4_RELEASE_CLAMPS = 0.3303794264793396;
        double socket4_STORE_FILTER_ON_CAROUSEL = 0.46652013063430786;
        double socket4_UNLOCK_CLAMPS = 0.3113839030265808;
        double socket4_clampXminus4_RECOVERY_CLAMP_XMINUS = 0.3494352698326111;
        double socket4_clampXminus4_RECOVERY_UNCLAMP = 0.3349667191505432;
        double socket4_clampXminus4_RELEASE = 0.1378955841064453;
        double socket4_clampXminus4_UNLOCK = 0.4372509f;
        double socket4_clampXplus4_RECOVERY_UNCLAMP = 0.5971024036407471;
        double socket4_clampXplus4_RELEASE = 0.48422425985336304;
        double socket4_clampXplus4_UNLOCK = 0.23031479120254517;
        double socket5_RELEASE_CLAMPS = 0.34547924995422363;
        double socket5_STORE_FILTER_ON_CAROUSEL = 0.5456147193908691;
        double socket5_UNLOCK_CLAMPS = 0.38366132974624634;
        double socket5_clampXminus5_RECOVERY_CLAMP_XMINUS = 0.7075849175453186;
        double socket5_clampXminus5_RECOVERY_UNCLAMP = 0.6024907827377319;
        double socket5_clampXminus5_RELEASE = 0.325341f;
        double socket5_clampXminus5_UNLOCK = 0.5572124719619751;
        double socket5_clampXplus5_RECOVERY_UNCLAMP = 0.41505998373031616;
        double socket5_clampXplus5_RELEASE = 0.7670267224311829;
        double socket5_clampXplus5_UNLOCK = 0.3575679063796997;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Counters_Carousel_TrendingTelemetry(recovery_ROTATION_BACKWARD, recovery_ROTATION_FORWARD, recovery_ROTATION_STRAIGHT, rotate_CAROUSEL_TO_ABSOLUTE_POSITION, rotate_CAROUSEL_TO_RELATIVE_POSITION, socket1_RELEASE_CLAMPS, socket1_STORE_FILTER_ON_CAROUSEL, socket1_UNLOCK_CLAMPS, socket1_clampXminus1_RECOVERY_CLAMP_XMINUS, socket1_clampXminus1_RECOVERY_UNCLAMP, socket1_clampXminus1_RELEASE, socket1_clampXminus1_UNLOCK, socket1_clampXplus1_RECOVERY_UNCLAMP, socket1_clampXplus1_RELEASE, socket1_clampXplus1_UNLOCK, socket2_RELEASE_CLAMPS, socket2_STORE_FILTER_ON_CAROUSEL, socket2_UNLOCK_CLAMPS, socket2_clampXminus2_RECOVERY_CLAMP_XMINUS, socket2_clampXminus2_RECOVERY_UNCLAMP, socket2_clampXminus2_RELEASE, socket2_clampXminus2_UNLOCK, socket2_clampXplus2_RECOVERY_UNCLAMP, socket2_clampXplus2_RELEASE, socket2_clampXplus2_UNLOCK, socket3_RELEASE_CLAMPS, socket3_STORE_FILTER_ON_CAROUSEL, socket3_UNLOCK_CLAMPS, socket3_clampXminus3_RECOVERY_CLAMP_XMINUS, socket3_clampXminus3_RECOVERY_UNCLAMP, socket3_clampXminus3_RELEASE, socket3_clampXminus3_UNLOCK, socket3_clampXplus3_RECOVERY_UNCLAMP, socket3_clampXplus3_RELEASE, socket3_clampXplus3_UNLOCK, socket4_RELEASE_CLAMPS, socket4_STORE_FILTER_ON_CAROUSEL, socket4_UNLOCK_CLAMPS, socket4_clampXminus4_RECOVERY_CLAMP_XMINUS, socket4_clampXminus4_RECOVERY_UNCLAMP, socket4_clampXminus4_RELEASE, socket4_clampXminus4_UNLOCK, socket4_clampXplus4_RECOVERY_UNCLAMP, socket4_clampXplus4_RELEASE, socket4_clampXplus4_UNLOCK, socket5_RELEASE_CLAMPS, socket5_STORE_FILTER_ON_CAROUSEL, socket5_UNLOCK_CLAMPS, socket5_clampXminus5_RECOVERY_CLAMP_XMINUS, socket5_clampXminus5_RECOVERY_UNCLAMP, socket5_clampXminus5_RELEASE, socket5_clampXminus5_UNLOCK, socket5_clampXplus5_RECOVERY_UNCLAMP, socket5_clampXplus5_RELEASE, socket5_clampXplus5_UNLOCK));
        Assert.assertTrue((boolean)(item instanceof Fcs_Counters_Carousel_TrendingTelemetry));
        Fcs_Counters_Carousel_TrendingTelemetry item_ = (Fcs_Counters_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((double)recovery_ROTATION_BACKWARD, (double)item_.getRecovery_ROTATION_BACKWARD(), (double)1.0E-6f);
        Assert.assertEquals((double)recovery_ROTATION_FORWARD, (double)item_.getRecovery_ROTATION_FORWARD(), (double)1.0E-6f);
        Assert.assertEquals((double)recovery_ROTATION_STRAIGHT, (double)item_.getRecovery_ROTATION_STRAIGHT(), (double)1.0E-6f);
        Assert.assertEquals((double)rotate_CAROUSEL_TO_ABSOLUTE_POSITION, (double)item_.getRotate_CAROUSEL_TO_ABSOLUTE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)rotate_CAROUSEL_TO_RELATIVE_POSITION, (double)item_.getRotate_CAROUSEL_TO_RELATIVE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_RELEASE_CLAMPS, (double)item_.getSocket1_RELEASE_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_STORE_FILTER_ON_CAROUSEL, (double)item_.getSocket1_STORE_FILTER_ON_CAROUSEL(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_UNLOCK_CLAMPS, (double)item_.getSocket1_UNLOCK_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_clampXminus1_RECOVERY_CLAMP_XMINUS, (double)item_.getSocket1_clampXminus1_RECOVERY_CLAMP_XMINUS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_clampXminus1_RECOVERY_UNCLAMP, (double)item_.getSocket1_clampXminus1_RECOVERY_UNCLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_clampXminus1_RELEASE, (double)item_.getSocket1_clampXminus1_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_clampXminus1_UNLOCK, (double)item_.getSocket1_clampXminus1_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_clampXplus1_RECOVERY_UNCLAMP, (double)item_.getSocket1_clampXplus1_RECOVERY_UNCLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_clampXplus1_RELEASE, (double)item_.getSocket1_clampXplus1_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_clampXplus1_UNLOCK, (double)item_.getSocket1_clampXplus1_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_RELEASE_CLAMPS, (double)item_.getSocket2_RELEASE_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_STORE_FILTER_ON_CAROUSEL, (double)item_.getSocket2_STORE_FILTER_ON_CAROUSEL(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_UNLOCK_CLAMPS, (double)item_.getSocket2_UNLOCK_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_clampXminus2_RECOVERY_CLAMP_XMINUS, (double)item_.getSocket2_clampXminus2_RECOVERY_CLAMP_XMINUS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_clampXminus2_RECOVERY_UNCLAMP, (double)item_.getSocket2_clampXminus2_RECOVERY_UNCLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_clampXminus2_RELEASE, (double)item_.getSocket2_clampXminus2_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_clampXminus2_UNLOCK, (double)item_.getSocket2_clampXminus2_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_clampXplus2_RECOVERY_UNCLAMP, (double)item_.getSocket2_clampXplus2_RECOVERY_UNCLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_clampXplus2_RELEASE, (double)item_.getSocket2_clampXplus2_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_clampXplus2_UNLOCK, (double)item_.getSocket2_clampXplus2_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_RELEASE_CLAMPS, (double)item_.getSocket3_RELEASE_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_STORE_FILTER_ON_CAROUSEL, (double)item_.getSocket3_STORE_FILTER_ON_CAROUSEL(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_UNLOCK_CLAMPS, (double)item_.getSocket3_UNLOCK_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_clampXminus3_RECOVERY_CLAMP_XMINUS, (double)item_.getSocket3_clampXminus3_RECOVERY_CLAMP_XMINUS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_clampXminus3_RECOVERY_UNCLAMP, (double)item_.getSocket3_clampXminus3_RECOVERY_UNCLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_clampXminus3_RELEASE, (double)item_.getSocket3_clampXminus3_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_clampXminus3_UNLOCK, (double)item_.getSocket3_clampXminus3_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_clampXplus3_RECOVERY_UNCLAMP, (double)item_.getSocket3_clampXplus3_RECOVERY_UNCLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_clampXplus3_RELEASE, (double)item_.getSocket3_clampXplus3_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_clampXplus3_UNLOCK, (double)item_.getSocket3_clampXplus3_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_RELEASE_CLAMPS, (double)item_.getSocket4_RELEASE_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_STORE_FILTER_ON_CAROUSEL, (double)item_.getSocket4_STORE_FILTER_ON_CAROUSEL(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_UNLOCK_CLAMPS, (double)item_.getSocket4_UNLOCK_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_clampXminus4_RECOVERY_CLAMP_XMINUS, (double)item_.getSocket4_clampXminus4_RECOVERY_CLAMP_XMINUS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_clampXminus4_RECOVERY_UNCLAMP, (double)item_.getSocket4_clampXminus4_RECOVERY_UNCLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_clampXminus4_RELEASE, (double)item_.getSocket4_clampXminus4_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_clampXminus4_UNLOCK, (double)item_.getSocket4_clampXminus4_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_clampXplus4_RECOVERY_UNCLAMP, (double)item_.getSocket4_clampXplus4_RECOVERY_UNCLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_clampXplus4_RELEASE, (double)item_.getSocket4_clampXplus4_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_clampXplus4_UNLOCK, (double)item_.getSocket4_clampXplus4_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_RELEASE_CLAMPS, (double)item_.getSocket5_RELEASE_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_STORE_FILTER_ON_CAROUSEL, (double)item_.getSocket5_STORE_FILTER_ON_CAROUSEL(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_UNLOCK_CLAMPS, (double)item_.getSocket5_UNLOCK_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_clampXminus5_RECOVERY_CLAMP_XMINUS, (double)item_.getSocket5_clampXminus5_RECOVERY_CLAMP_XMINUS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_clampXminus5_RECOVERY_UNCLAMP, (double)item_.getSocket5_clampXminus5_RECOVERY_UNCLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_clampXminus5_RELEASE, (double)item_.getSocket5_clampXminus5_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_clampXminus5_UNLOCK, (double)item_.getSocket5_clampXminus5_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_clampXplus5_RECOVERY_UNCLAMP, (double)item_.getSocket5_clampXplus5_RECOVERY_UNCLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_clampXplus5_RELEASE, (double)item_.getSocket5_clampXplus5_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_clampXplus5_UNLOCK, (double)item_.getSocket5_clampXplus5_UNLOCK(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Counters_Loader_TrendingTelemetry() throws Exception {
        double carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION = 0.846003532409668;
        double carrier_MOVE_LOADERCARRIER_TO_ENGAGED = 0.28513604402542114;
        double carrier_MOVE_LOADERCARRIER_TO_HANDOFF = 0.7324286103248596;
        double carrier_MOVE_LOADERCARRIER_TO_STORAGE = 0.7612669467926025;
        double hooks_CLAMP_LOADER_HOOKS = 0.827907f;
        double hooks_CLOSE_LOADER_HOOKS = 0.5566155314445496;
        double hooks_OPEN_HOMING_LOADER_HOOKS = 0.06641978025436401;
        double hooks_UNCLAMP_LOADER_HOOKS = 0.44267964363098145;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Counters_Loader_TrendingTelemetry(carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, carrier_MOVE_LOADERCARRIER_TO_ENGAGED, carrier_MOVE_LOADERCARRIER_TO_HANDOFF, carrier_MOVE_LOADERCARRIER_TO_STORAGE, hooks_CLAMP_LOADER_HOOKS, hooks_CLOSE_LOADER_HOOKS, hooks_OPEN_HOMING_LOADER_HOOKS, hooks_UNCLAMP_LOADER_HOOKS));
        Assert.assertTrue((boolean)(item instanceof Fcs_Counters_Loader_TrendingTelemetry));
        Fcs_Counters_Loader_TrendingTelemetry item_ = (Fcs_Counters_Loader_TrendingTelemetry)item;
        Assert.assertEquals((double)carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, (double)item_.getCarrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)carrier_MOVE_LOADERCARRIER_TO_ENGAGED, (double)item_.getCarrier_MOVE_LOADERCARRIER_TO_ENGAGED(), (double)1.0E-6f);
        Assert.assertEquals((double)carrier_MOVE_LOADERCARRIER_TO_HANDOFF, (double)item_.getCarrier_MOVE_LOADERCARRIER_TO_HANDOFF(), (double)1.0E-6f);
        Assert.assertEquals((double)carrier_MOVE_LOADERCARRIER_TO_STORAGE, (double)item_.getCarrier_MOVE_LOADERCARRIER_TO_STORAGE(), (double)1.0E-6f);
        Assert.assertEquals((double)hooks_CLAMP_LOADER_HOOKS, (double)item_.getHooks_CLAMP_LOADER_HOOKS(), (double)1.0E-6f);
        Assert.assertEquals((double)hooks_CLOSE_LOADER_HOOKS, (double)item_.getHooks_CLOSE_LOADER_HOOKS(), (double)1.0E-6f);
        Assert.assertEquals((double)hooks_OPEN_HOMING_LOADER_HOOKS, (double)item_.getHooks_OPEN_HOMING_LOADER_HOOKS(), (double)1.0E-6f);
        Assert.assertEquals((double)hooks_UNCLAMP_LOADER_HOOKS, (double)item_.getHooks_UNCLAMP_LOADER_HOOKS(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Counters_TrendingTelemetry() throws Exception {
        double connect_LOADER = 0.9191878437995911;
        double disconnect_LOADER = 0.17409104108810425;
        double disengage_FILTER_FROM_CAROUSEL = 0.2152794f;
        double grab_FILTER_AT_STANDBY = 0.15327203273773193;
        double load_FILTER = 0.9256841540336609;
        double move_AND_CLAMP_FILTER_ONLINE = 0.8590456247329712;
        double rotate_SOCKET_TO_STANDBY = 0.3129313588142395;
        double set_FILTER = 0.3925696015357971;
        double set_FILTER_AT_HANDOFF_FOR_LOADER = 0.036313652992248535;
        double set_NO_FILTER = 0.2566499710083008;
        double store_FILTER_ON_CAROUSEL = 0.8815256357192993;
        double unload_FILTER = 0.26134634017944336;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Counters_TrendingTelemetry(connect_LOADER, disconnect_LOADER, disengage_FILTER_FROM_CAROUSEL, grab_FILTER_AT_STANDBY, load_FILTER, move_AND_CLAMP_FILTER_ONLINE, rotate_SOCKET_TO_STANDBY, set_FILTER, set_FILTER_AT_HANDOFF_FOR_LOADER, set_NO_FILTER, store_FILTER_ON_CAROUSEL, unload_FILTER));
        Assert.assertTrue((boolean)(item instanceof Fcs_Counters_TrendingTelemetry));
        Fcs_Counters_TrendingTelemetry item_ = (Fcs_Counters_TrendingTelemetry)item;
        Assert.assertEquals((double)connect_LOADER, (double)item_.getConnect_LOADER(), (double)1.0E-6f);
        Assert.assertEquals((double)disconnect_LOADER, (double)item_.getDisconnect_LOADER(), (double)1.0E-6f);
        Assert.assertEquals((double)disengage_FILTER_FROM_CAROUSEL, (double)item_.getDisengage_FILTER_FROM_CAROUSEL(), (double)1.0E-6f);
        Assert.assertEquals((double)grab_FILTER_AT_STANDBY, (double)item_.getGrab_FILTER_AT_STANDBY(), (double)1.0E-6f);
        Assert.assertEquals((double)load_FILTER, (double)item_.getLoad_FILTER(), (double)1.0E-6f);
        Assert.assertEquals((double)move_AND_CLAMP_FILTER_ONLINE, (double)item_.getMove_AND_CLAMP_FILTER_ONLINE(), (double)1.0E-6f);
        Assert.assertEquals((double)rotate_SOCKET_TO_STANDBY, (double)item_.getRotate_SOCKET_TO_STANDBY(), (double)1.0E-6f);
        Assert.assertEquals((double)set_FILTER, (double)item_.getSet_FILTER(), (double)1.0E-6f);
        Assert.assertEquals((double)set_FILTER_AT_HANDOFF_FOR_LOADER, (double)item_.getSet_FILTER_AT_HANDOFF_FOR_LOADER(), (double)1.0E-6f);
        Assert.assertEquals((double)set_NO_FILTER, (double)item_.getSet_NO_FILTER(), (double)1.0E-6f);
        Assert.assertEquals((double)store_FILTER_ON_CAROUSEL, (double)item_.getStore_FILTER_ON_CAROUSEL(), (double)1.0E-6f);
        Assert.assertEquals((double)unload_FILTER, (double)item_.getUnload_FILTER(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Duration_Autochanger_TrendingTelemetry() throws Exception {
        long autochangertrucks_ALIGN_FOLLOWER = 847L;
        long autochangertrucks_MOVE_DRIVER_TRUCK_ALONE = 440L;
        long autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE = 512L;
        long autochangertrucks_MOVE_TO_ABSOLUTE_POSITION = 574L;
        long latches_latchXminus_CLOSE = 611L;
        long latches_latchXminus_OPEN = 934L;
        long latches_latchXplus_CLOSE = 514L;
        long latches_latchXplus_OPEN = 674L;
        long onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 513L;
        long onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 232L;
        long onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP = 693L;
        long onlineclamps_onlineClampXminus_OPEN_HALFWAY_RELATIVE_POSITION = 414L;
        long onlineclamps_onlineClampXminus_OPEN_HOMING_ONLINECLAMP = 633L;
        long onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT = 577L;
        long onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE = 185L;
        long onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 595L;
        long onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 496L;
        long onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP = 520L;
        long onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT = 838L;
        long onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 782L;
        long onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP = 629L;
        long onlineclamps_onlineClampXplus_OPEN_HALFWAY_RELATIVE_POSITION = 731L;
        long onlineclamps_onlineClampXplus_OPEN_HOMING_ONLINECLAMP = 243L;
        long onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT = 990L;
        long onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE = 150L;
        long onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 650L;
        long onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT = 323L;
        long onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP = 263L;
        long onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 559L;
        long onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 503L;
        long onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP = 593L;
        long onlineclamps_onlineClampYminus_OPEN_HALFWAY_RELATIVE_POSITION = 163L;
        long onlineclamps_onlineClampYminus_OPEN_HOMING_ONLINECLAMP = 874L;
        long onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT = 960L;
        long onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE = 291L;
        long onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 253L;
        long onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 538L;
        long onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP = 822L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Autochanger_TrendingTelemetry(autochangertrucks_ALIGN_FOLLOWER, autochangertrucks_MOVE_DRIVER_TRUCK_ALONE, autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, latches_latchXminus_CLOSE, latches_latchXminus_OPEN, latches_latchXplus_CLOSE, latches_latchXplus_OPEN, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXminus_OPEN_HALFWAY_RELATIVE_POSITION, onlineclamps_onlineClampXminus_OPEN_HOMING_ONLINECLAMP, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_OPEN_HALFWAY_RELATIVE_POSITION, onlineclamps_onlineClampXplus_OPEN_HOMING_ONLINECLAMP, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_OPEN_HALFWAY_RELATIVE_POSITION, onlineclamps_onlineClampYminus_OPEN_HOMING_ONLINECLAMP, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Autochanger_TrendingTelemetry));
        Fcs_Duration_Autochanger_TrendingTelemetry item_ = (Fcs_Duration_Autochanger_TrendingTelemetry)item;
        Assert.assertEquals((long)autochangertrucks_ALIGN_FOLLOWER, (long)item_.getAutochangertrucks_ALIGN_FOLLOWER());
        Assert.assertEquals((long)autochangertrucks_MOVE_DRIVER_TRUCK_ALONE, (long)item_.getAutochangertrucks_MOVE_DRIVER_TRUCK_ALONE());
        Assert.assertEquals((long)autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, (long)item_.getAutochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE());
        Assert.assertEquals((long)autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, (long)item_.getAutochangertrucks_MOVE_TO_ABSOLUTE_POSITION());
        Assert.assertEquals((long)latches_latchXminus_CLOSE, (long)item_.getLatches_latchXminus_CLOSE());
        Assert.assertEquals((long)latches_latchXminus_OPEN, (long)item_.getLatches_latchXminus_OPEN());
        Assert.assertEquals((long)latches_latchXplus_CLOSE, (long)item_.getLatches_latchXplus_CLOSE());
        Assert.assertEquals((long)latches_latchXplus_OPEN, (long)item_.getLatches_latchXplus_OPEN());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXminus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_HALFWAY_RELATIVE_POSITION, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_HALFWAY_RELATIVE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_HOMING_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_HOMING_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXplus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_HALFWAY_RELATIVE_POSITION, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_HALFWAY_RELATIVE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_HOMING_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_HOMING_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampYminus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_HALFWAY_RELATIVE_POSITION, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_HALFWAY_RELATIVE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_HOMING_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_HOMING_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP());
    }

    @Test
    public void sendReceiveFcs_Duration_Carousel_TrendingTelemetry() throws Exception {
        long recovery_ROTATION_BACKWARD = 737L;
        long recovery_ROTATION_FORWARD = 969L;
        long recovery_ROTATION_STRAIGHT = 329L;
        long rotate_CAROUSEL_TO_ABSOLUTE_POSITION = 374L;
        long rotate_CAROUSEL_TO_RELATIVE_POSITION = 241L;
        long socket1_RELEASE_CLAMPS = 19L;
        long socket1_STORE_FILTER_ON_CAROUSEL = 898L;
        long socket1_UNLOCK_CLAMPS = 394L;
        long socket1_clampXminus1_RECOVERY_CLAMP_XMINUS = 323L;
        long socket1_clampXminus1_RECOVERY_UNCLAMP = 570L;
        long socket1_clampXminus1_RELEASE = 361L;
        long socket1_clampXminus1_UNLOCK = 875L;
        long socket1_clampXplus1_RECOVERY_UNCLAMP = 567L;
        long socket1_clampXplus1_RELEASE = 425L;
        long socket1_clampXplus1_UNLOCK = 902L;
        long socket2_RELEASE_CLAMPS = 388L;
        long socket2_STORE_FILTER_ON_CAROUSEL = 791L;
        long socket2_UNLOCK_CLAMPS = 346L;
        long socket2_clampXminus2_RECOVERY_CLAMP_XMINUS = 392L;
        long socket2_clampXminus2_RECOVERY_UNCLAMP = 630L;
        long socket2_clampXminus2_RELEASE = 838L;
        long socket2_clampXminus2_UNLOCK = 719L;
        long socket2_clampXplus2_RECOVERY_UNCLAMP = 662L;
        long socket2_clampXplus2_RELEASE = 260L;
        long socket2_clampXplus2_UNLOCK = 768L;
        long socket3_RELEASE_CLAMPS = 63L;
        long socket3_STORE_FILTER_ON_CAROUSEL = 841L;
        long socket3_UNLOCK_CLAMPS = 322L;
        long socket3_clampXminus3_RECOVERY_CLAMP_XMINUS = 987L;
        long socket3_clampXminus3_RECOVERY_UNCLAMP = 609L;
        long socket3_clampXminus3_RELEASE = 861L;
        long socket3_clampXminus3_UNLOCK = 167L;
        long socket3_clampXplus3_RECOVERY_UNCLAMP = 19L;
        long socket3_clampXplus3_RELEASE = 703L;
        long socket3_clampXplus3_UNLOCK = 350L;
        long socket4_RELEASE_CLAMPS = 124L;
        long socket4_STORE_FILTER_ON_CAROUSEL = 692L;
        long socket4_UNLOCK_CLAMPS = 946L;
        long socket4_clampXminus4_RECOVERY_CLAMP_XMINUS = 903L;
        long socket4_clampXminus4_RECOVERY_UNCLAMP = 488L;
        long socket4_clampXminus4_RELEASE = 976L;
        long socket4_clampXminus4_UNLOCK = 342L;
        long socket4_clampXplus4_RECOVERY_UNCLAMP = 334L;
        long socket4_clampXplus4_RELEASE = 457L;
        long socket4_clampXplus4_UNLOCK = 280L;
        long socket5_RELEASE_CLAMPS = 890L;
        long socket5_STORE_FILTER_ON_CAROUSEL = 844L;
        long socket5_UNLOCK_CLAMPS = 601L;
        long socket5_clampXminus5_RECOVERY_CLAMP_XMINUS = 695L;
        long socket5_clampXminus5_RECOVERY_UNCLAMP = 247L;
        long socket5_clampXminus5_RELEASE = 872L;
        long socket5_clampXminus5_UNLOCK = 147L;
        long socket5_clampXplus5_RECOVERY_UNCLAMP = 882L;
        long socket5_clampXplus5_RELEASE = 523L;
        long socket5_clampXplus5_UNLOCK = 883L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Carousel_TrendingTelemetry(recovery_ROTATION_BACKWARD, recovery_ROTATION_FORWARD, recovery_ROTATION_STRAIGHT, rotate_CAROUSEL_TO_ABSOLUTE_POSITION, rotate_CAROUSEL_TO_RELATIVE_POSITION, socket1_RELEASE_CLAMPS, socket1_STORE_FILTER_ON_CAROUSEL, socket1_UNLOCK_CLAMPS, socket1_clampXminus1_RECOVERY_CLAMP_XMINUS, socket1_clampXminus1_RECOVERY_UNCLAMP, socket1_clampXminus1_RELEASE, socket1_clampXminus1_UNLOCK, socket1_clampXplus1_RECOVERY_UNCLAMP, socket1_clampXplus1_RELEASE, socket1_clampXplus1_UNLOCK, socket2_RELEASE_CLAMPS, socket2_STORE_FILTER_ON_CAROUSEL, socket2_UNLOCK_CLAMPS, socket2_clampXminus2_RECOVERY_CLAMP_XMINUS, socket2_clampXminus2_RECOVERY_UNCLAMP, socket2_clampXminus2_RELEASE, socket2_clampXminus2_UNLOCK, socket2_clampXplus2_RECOVERY_UNCLAMP, socket2_clampXplus2_RELEASE, socket2_clampXplus2_UNLOCK, socket3_RELEASE_CLAMPS, socket3_STORE_FILTER_ON_CAROUSEL, socket3_UNLOCK_CLAMPS, socket3_clampXminus3_RECOVERY_CLAMP_XMINUS, socket3_clampXminus3_RECOVERY_UNCLAMP, socket3_clampXminus3_RELEASE, socket3_clampXminus3_UNLOCK, socket3_clampXplus3_RECOVERY_UNCLAMP, socket3_clampXplus3_RELEASE, socket3_clampXplus3_UNLOCK, socket4_RELEASE_CLAMPS, socket4_STORE_FILTER_ON_CAROUSEL, socket4_UNLOCK_CLAMPS, socket4_clampXminus4_RECOVERY_CLAMP_XMINUS, socket4_clampXminus4_RECOVERY_UNCLAMP, socket4_clampXminus4_RELEASE, socket4_clampXminus4_UNLOCK, socket4_clampXplus4_RECOVERY_UNCLAMP, socket4_clampXplus4_RELEASE, socket4_clampXplus4_UNLOCK, socket5_RELEASE_CLAMPS, socket5_STORE_FILTER_ON_CAROUSEL, socket5_UNLOCK_CLAMPS, socket5_clampXminus5_RECOVERY_CLAMP_XMINUS, socket5_clampXminus5_RECOVERY_UNCLAMP, socket5_clampXminus5_RELEASE, socket5_clampXminus5_UNLOCK, socket5_clampXplus5_RECOVERY_UNCLAMP, socket5_clampXplus5_RELEASE, socket5_clampXplus5_UNLOCK));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Carousel_TrendingTelemetry));
        Fcs_Duration_Carousel_TrendingTelemetry item_ = (Fcs_Duration_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((long)recovery_ROTATION_BACKWARD, (long)item_.getRecovery_ROTATION_BACKWARD());
        Assert.assertEquals((long)recovery_ROTATION_FORWARD, (long)item_.getRecovery_ROTATION_FORWARD());
        Assert.assertEquals((long)recovery_ROTATION_STRAIGHT, (long)item_.getRecovery_ROTATION_STRAIGHT());
        Assert.assertEquals((long)rotate_CAROUSEL_TO_ABSOLUTE_POSITION, (long)item_.getRotate_CAROUSEL_TO_ABSOLUTE_POSITION());
        Assert.assertEquals((long)rotate_CAROUSEL_TO_RELATIVE_POSITION, (long)item_.getRotate_CAROUSEL_TO_RELATIVE_POSITION());
        Assert.assertEquals((long)socket1_RELEASE_CLAMPS, (long)item_.getSocket1_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket1_STORE_FILTER_ON_CAROUSEL, (long)item_.getSocket1_STORE_FILTER_ON_CAROUSEL());
        Assert.assertEquals((long)socket1_UNLOCK_CLAMPS, (long)item_.getSocket1_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket1_clampXminus1_RECOVERY_CLAMP_XMINUS, (long)item_.getSocket1_clampXminus1_RECOVERY_CLAMP_XMINUS());
        Assert.assertEquals((long)socket1_clampXminus1_RECOVERY_UNCLAMP, (long)item_.getSocket1_clampXminus1_RECOVERY_UNCLAMP());
        Assert.assertEquals((long)socket1_clampXminus1_RELEASE, (long)item_.getSocket1_clampXminus1_RELEASE());
        Assert.assertEquals((long)socket1_clampXminus1_UNLOCK, (long)item_.getSocket1_clampXminus1_UNLOCK());
        Assert.assertEquals((long)socket1_clampXplus1_RECOVERY_UNCLAMP, (long)item_.getSocket1_clampXplus1_RECOVERY_UNCLAMP());
        Assert.assertEquals((long)socket1_clampXplus1_RELEASE, (long)item_.getSocket1_clampXplus1_RELEASE());
        Assert.assertEquals((long)socket1_clampXplus1_UNLOCK, (long)item_.getSocket1_clampXplus1_UNLOCK());
        Assert.assertEquals((long)socket2_RELEASE_CLAMPS, (long)item_.getSocket2_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket2_STORE_FILTER_ON_CAROUSEL, (long)item_.getSocket2_STORE_FILTER_ON_CAROUSEL());
        Assert.assertEquals((long)socket2_UNLOCK_CLAMPS, (long)item_.getSocket2_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket2_clampXminus2_RECOVERY_CLAMP_XMINUS, (long)item_.getSocket2_clampXminus2_RECOVERY_CLAMP_XMINUS());
        Assert.assertEquals((long)socket2_clampXminus2_RECOVERY_UNCLAMP, (long)item_.getSocket2_clampXminus2_RECOVERY_UNCLAMP());
        Assert.assertEquals((long)socket2_clampXminus2_RELEASE, (long)item_.getSocket2_clampXminus2_RELEASE());
        Assert.assertEquals((long)socket2_clampXminus2_UNLOCK, (long)item_.getSocket2_clampXminus2_UNLOCK());
        Assert.assertEquals((long)socket2_clampXplus2_RECOVERY_UNCLAMP, (long)item_.getSocket2_clampXplus2_RECOVERY_UNCLAMP());
        Assert.assertEquals((long)socket2_clampXplus2_RELEASE, (long)item_.getSocket2_clampXplus2_RELEASE());
        Assert.assertEquals((long)socket2_clampXplus2_UNLOCK, (long)item_.getSocket2_clampXplus2_UNLOCK());
        Assert.assertEquals((long)socket3_RELEASE_CLAMPS, (long)item_.getSocket3_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket3_STORE_FILTER_ON_CAROUSEL, (long)item_.getSocket3_STORE_FILTER_ON_CAROUSEL());
        Assert.assertEquals((long)socket3_UNLOCK_CLAMPS, (long)item_.getSocket3_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket3_clampXminus3_RECOVERY_CLAMP_XMINUS, (long)item_.getSocket3_clampXminus3_RECOVERY_CLAMP_XMINUS());
        Assert.assertEquals((long)socket3_clampXminus3_RECOVERY_UNCLAMP, (long)item_.getSocket3_clampXminus3_RECOVERY_UNCLAMP());
        Assert.assertEquals((long)socket3_clampXminus3_RELEASE, (long)item_.getSocket3_clampXminus3_RELEASE());
        Assert.assertEquals((long)socket3_clampXminus3_UNLOCK, (long)item_.getSocket3_clampXminus3_UNLOCK());
        Assert.assertEquals((long)socket3_clampXplus3_RECOVERY_UNCLAMP, (long)item_.getSocket3_clampXplus3_RECOVERY_UNCLAMP());
        Assert.assertEquals((long)socket3_clampXplus3_RELEASE, (long)item_.getSocket3_clampXplus3_RELEASE());
        Assert.assertEquals((long)socket3_clampXplus3_UNLOCK, (long)item_.getSocket3_clampXplus3_UNLOCK());
        Assert.assertEquals((long)socket4_RELEASE_CLAMPS, (long)item_.getSocket4_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket4_STORE_FILTER_ON_CAROUSEL, (long)item_.getSocket4_STORE_FILTER_ON_CAROUSEL());
        Assert.assertEquals((long)socket4_UNLOCK_CLAMPS, (long)item_.getSocket4_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket4_clampXminus4_RECOVERY_CLAMP_XMINUS, (long)item_.getSocket4_clampXminus4_RECOVERY_CLAMP_XMINUS());
        Assert.assertEquals((long)socket4_clampXminus4_RECOVERY_UNCLAMP, (long)item_.getSocket4_clampXminus4_RECOVERY_UNCLAMP());
        Assert.assertEquals((long)socket4_clampXminus4_RELEASE, (long)item_.getSocket4_clampXminus4_RELEASE());
        Assert.assertEquals((long)socket4_clampXminus4_UNLOCK, (long)item_.getSocket4_clampXminus4_UNLOCK());
        Assert.assertEquals((long)socket4_clampXplus4_RECOVERY_UNCLAMP, (long)item_.getSocket4_clampXplus4_RECOVERY_UNCLAMP());
        Assert.assertEquals((long)socket4_clampXplus4_RELEASE, (long)item_.getSocket4_clampXplus4_RELEASE());
        Assert.assertEquals((long)socket4_clampXplus4_UNLOCK, (long)item_.getSocket4_clampXplus4_UNLOCK());
        Assert.assertEquals((long)socket5_RELEASE_CLAMPS, (long)item_.getSocket5_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket5_STORE_FILTER_ON_CAROUSEL, (long)item_.getSocket5_STORE_FILTER_ON_CAROUSEL());
        Assert.assertEquals((long)socket5_UNLOCK_CLAMPS, (long)item_.getSocket5_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket5_clampXminus5_RECOVERY_CLAMP_XMINUS, (long)item_.getSocket5_clampXminus5_RECOVERY_CLAMP_XMINUS());
        Assert.assertEquals((long)socket5_clampXminus5_RECOVERY_UNCLAMP, (long)item_.getSocket5_clampXminus5_RECOVERY_UNCLAMP());
        Assert.assertEquals((long)socket5_clampXminus5_RELEASE, (long)item_.getSocket5_clampXminus5_RELEASE());
        Assert.assertEquals((long)socket5_clampXminus5_UNLOCK, (long)item_.getSocket5_clampXminus5_UNLOCK());
        Assert.assertEquals((long)socket5_clampXplus5_RECOVERY_UNCLAMP, (long)item_.getSocket5_clampXplus5_RECOVERY_UNCLAMP());
        Assert.assertEquals((long)socket5_clampXplus5_RELEASE, (long)item_.getSocket5_clampXplus5_RELEASE());
        Assert.assertEquals((long)socket5_clampXplus5_UNLOCK, (long)item_.getSocket5_clampXplus5_UNLOCK());
    }

    @Test
    public void sendReceiveFcs_Duration_Loader_TrendingTelemetry() throws Exception {
        long carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION = 400L;
        long carrier_MOVE_LOADERCARRIER_TO_ENGAGED = 204L;
        long carrier_MOVE_LOADERCARRIER_TO_HANDOFF = 984L;
        long carrier_MOVE_LOADERCARRIER_TO_STORAGE = 438L;
        long hooks_CLAMP_LOADER_HOOKS = 747L;
        long hooks_CLOSE_LOADER_HOOKS = 662L;
        long hooks_OPEN_HOMING_LOADER_HOOKS = 365L;
        long hooks_UNCLAMP_LOADER_HOOKS = 95L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Loader_TrendingTelemetry(carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, carrier_MOVE_LOADERCARRIER_TO_ENGAGED, carrier_MOVE_LOADERCARRIER_TO_HANDOFF, carrier_MOVE_LOADERCARRIER_TO_STORAGE, hooks_CLAMP_LOADER_HOOKS, hooks_CLOSE_LOADER_HOOKS, hooks_OPEN_HOMING_LOADER_HOOKS, hooks_UNCLAMP_LOADER_HOOKS));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Loader_TrendingTelemetry));
        Fcs_Duration_Loader_TrendingTelemetry item_ = (Fcs_Duration_Loader_TrendingTelemetry)item;
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_ENGAGED, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_ENGAGED());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_HANDOFF, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_HANDOFF());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_STORAGE, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_STORAGE());
        Assert.assertEquals((long)hooks_CLAMP_LOADER_HOOKS, (long)item_.getHooks_CLAMP_LOADER_HOOKS());
        Assert.assertEquals((long)hooks_CLOSE_LOADER_HOOKS, (long)item_.getHooks_CLOSE_LOADER_HOOKS());
        Assert.assertEquals((long)hooks_OPEN_HOMING_LOADER_HOOKS, (long)item_.getHooks_OPEN_HOMING_LOADER_HOOKS());
        Assert.assertEquals((long)hooks_UNCLAMP_LOADER_HOOKS, (long)item_.getHooks_UNCLAMP_LOADER_HOOKS());
    }

    @Test
    public void sendReceiveFcs_Duration_TrendingTelemetry() throws Exception {
        long connect_LOADER = 661L;
        long disconnect_LOADER = 804L;
        long disengage_FILTER_FROM_CAROUSEL = 793L;
        long grab_FILTER_AT_STANDBY = 555L;
        long load_FILTER = 573L;
        long move_AND_CLAMP_FILTER_ONLINE = 370L;
        long rotate_SOCKET_TO_STANDBY = 463L;
        long set_FILTER = 589L;
        long set_FILTER_AT_HANDOFF_FOR_LOADER = 400L;
        long set_NO_FILTER = 269L;
        long store_FILTER_ON_CAROUSEL = 419L;
        long unload_FILTER = 77L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_TrendingTelemetry(connect_LOADER, disconnect_LOADER, disengage_FILTER_FROM_CAROUSEL, grab_FILTER_AT_STANDBY, load_FILTER, move_AND_CLAMP_FILTER_ONLINE, rotate_SOCKET_TO_STANDBY, set_FILTER, set_FILTER_AT_HANDOFF_FOR_LOADER, set_NO_FILTER, store_FILTER_ON_CAROUSEL, unload_FILTER));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_TrendingTelemetry));
        Fcs_Duration_TrendingTelemetry item_ = (Fcs_Duration_TrendingTelemetry)item;
        Assert.assertEquals((long)connect_LOADER, (long)item_.getConnect_LOADER());
        Assert.assertEquals((long)disconnect_LOADER, (long)item_.getDisconnect_LOADER());
        Assert.assertEquals((long)disengage_FILTER_FROM_CAROUSEL, (long)item_.getDisengage_FILTER_FROM_CAROUSEL());
        Assert.assertEquals((long)grab_FILTER_AT_STANDBY, (long)item_.getGrab_FILTER_AT_STANDBY());
        Assert.assertEquals((long)load_FILTER, (long)item_.getLoad_FILTER());
        Assert.assertEquals((long)move_AND_CLAMP_FILTER_ONLINE, (long)item_.getMove_AND_CLAMP_FILTER_ONLINE());
        Assert.assertEquals((long)rotate_SOCKET_TO_STANDBY, (long)item_.getRotate_SOCKET_TO_STANDBY());
        Assert.assertEquals((long)set_FILTER, (long)item_.getSet_FILTER());
        Assert.assertEquals((long)set_FILTER_AT_HANDOFF_FOR_LOADER, (long)item_.getSet_FILTER_AT_HANDOFF_FOR_LOADER());
        Assert.assertEquals((long)set_NO_FILTER, (long)item_.getSet_NO_FILTER());
        Assert.assertEquals((long)store_FILTER_ON_CAROUSEL, (long)item_.getStore_FILTER_ON_CAROUSEL());
        Assert.assertEquals((long)unload_FILTER, (long)item_.getUnload_FILTER());
    }

    @Test
    public void sendReceiveFcs_Fcs_Mcm_TrendingTelemetry() throws Exception {
        int autochanger_trucks_position = 545;
        String autochanger_trucks_state = "v";
        String filter_on_autochanger = "f";
        int filter_previous_socketID = 121;
        int proximity = 274;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Fcs_Mcm_TrendingTelemetry(autochanger_trucks_position, autochanger_trucks_state, filter_on_autochanger, filter_previous_socketID, proximity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Fcs_Mcm_TrendingTelemetry));
        Fcs_Fcs_Mcm_TrendingTelemetry item_ = (Fcs_Fcs_Mcm_TrendingTelemetry)item;
        Assert.assertEquals((long)autochanger_trucks_position, (long)item_.getAutochanger_trucks_position());
        Assert.assertEquals((Object)autochanger_trucks_state, (Object)item_.getAutochanger_trucks_state());
        Assert.assertEquals((Object)filter_on_autochanger, (Object)item_.getFilter_on_autochanger());
        Assert.assertEquals((long)filter_previous_socketID, (long)item_.getFilter_previous_socketID());
        Assert.assertEquals((long)proximity, (long)item_.getProximity());
    }

    @Test
    public void sendReceiveFcs_Fcs_TrendingTelemetry() throws Exception {
        String version = "t";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Fcs_TrendingTelemetry(version));
        Assert.assertTrue((boolean)(item instanceof Fcs_Fcs_TrendingTelemetry));
        Fcs_Fcs_TrendingTelemetry item_ = (Fcs_Fcs_TrendingTelemetry)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
    }

    @Test
    public void sendReceiveFcs_Loader_Carrier_TrendingTelemetry() throws Exception {
        boolean atEngaged = false;
        boolean atHandoff = false;
        boolean atStorage = true;
        boolean controllerInError = true;
        boolean engagedSensorOn = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_Carrier_TrendingTelemetry(atEngaged, atHandoff, atStorage, controllerInError, engagedSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_Carrier_TrendingTelemetry));
        Fcs_Loader_Carrier_TrendingTelemetry item_ = (Fcs_Loader_Carrier_TrendingTelemetry)item;
        Assert.assertEquals((Object)atEngaged, (Object)item_.isAtEngaged());
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atStorage, (Object)item_.isAtStorage());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((Object)engagedSensorOn, (Object)item_.isEngagedSensorOn());
    }

    @Test
    public void sendReceiveFcs_Loader_Hooks_TrendingTelemetry() throws Exception {
        boolean allHooksInStateCLOSED = false;
        String clampState = "a";
        boolean controllerInError = false;
        boolean forceClampedStatus = true;
        boolean forceOverClampedStatus = true;
        int forceSensorVoltage0 = 323;
        int forceSensorVoltage1 = 831;
        String forceStatus = "";
        boolean forceUnclampedStatus = true;
        boolean forceUnderClampedStatus = true;
        boolean statuspublishedbyhook1_inError = true;
        boolean statuspublishedbyhook1_lockSensorOn = false;
        String statuspublishedbyhook1_lockStatus = "w";
        boolean statuspublishedbyhook1_unlockSensorOn = true;
        boolean statuspublishedbyhook2_inError = true;
        boolean statuspublishedbyhook2_lockSensorOn = false;
        String statuspublishedbyhook2_lockStatus = "s";
        boolean statuspublishedbyhook2_unlockSensorOn = true;
        boolean statuspublishedbyhook3_inError = false;
        boolean statuspublishedbyhook3_lockSensorOn = true;
        String statuspublishedbyhook3_lockStatus = "";
        boolean statuspublishedbyhook3_unlockSensorOn = false;
        boolean statuspublishedbyhook4_inError = true;
        boolean statuspublishedbyhook4_lockSensorOn = false;
        String statuspublishedbyhook4_lockStatus = "";
        boolean statuspublishedbyhook4_unlockSensorOn = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_Hooks_TrendingTelemetry(allHooksInStateCLOSED, clampState, controllerInError, forceClampedStatus, forceOverClampedStatus, forceSensorVoltage0, forceSensorVoltage1, forceStatus, forceUnclampedStatus, forceUnderClampedStatus, statuspublishedbyhook1_inError, statuspublishedbyhook1_lockSensorOn, statuspublishedbyhook1_lockStatus, statuspublishedbyhook1_unlockSensorOn, statuspublishedbyhook2_inError, statuspublishedbyhook2_lockSensorOn, statuspublishedbyhook2_lockStatus, statuspublishedbyhook2_unlockSensorOn, statuspublishedbyhook3_inError, statuspublishedbyhook3_lockSensorOn, statuspublishedbyhook3_lockStatus, statuspublishedbyhook3_unlockSensorOn, statuspublishedbyhook4_inError, statuspublishedbyhook4_lockSensorOn, statuspublishedbyhook4_lockStatus, statuspublishedbyhook4_unlockSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_Hooks_TrendingTelemetry));
        Fcs_Loader_Hooks_TrendingTelemetry item_ = (Fcs_Loader_Hooks_TrendingTelemetry)item;
        Assert.assertEquals((Object)allHooksInStateCLOSED, (Object)item_.isAllHooksInStateCLOSED());
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((Object)forceClampedStatus, (Object)item_.isForceClampedStatus());
        Assert.assertEquals((Object)forceOverClampedStatus, (Object)item_.isForceOverClampedStatus());
        Assert.assertEquals((long)forceSensorVoltage0, (long)item_.getForceSensorVoltage0());
        Assert.assertEquals((long)forceSensorVoltage1, (long)item_.getForceSensorVoltage1());
        Assert.assertEquals((Object)forceStatus, (Object)item_.getForceStatus());
        Assert.assertEquals((Object)forceUnclampedStatus, (Object)item_.isForceUnclampedStatus());
        Assert.assertEquals((Object)forceUnderClampedStatus, (Object)item_.isForceUnderClampedStatus());
        Assert.assertEquals((Object)statuspublishedbyhook1_inError, (Object)item_.isStatuspublishedbyhook1_inError());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockSensorOn, (Object)item_.isStatuspublishedbyhook1_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockStatus, (Object)item_.getStatuspublishedbyhook1_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook1_unlockSensorOn, (Object)item_.isStatuspublishedbyhook1_unlockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook2_inError, (Object)item_.isStatuspublishedbyhook2_inError());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockSensorOn, (Object)item_.isStatuspublishedbyhook2_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockStatus, (Object)item_.getStatuspublishedbyhook2_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook2_unlockSensorOn, (Object)item_.isStatuspublishedbyhook2_unlockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook3_inError, (Object)item_.isStatuspublishedbyhook3_inError());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockSensorOn, (Object)item_.isStatuspublishedbyhook3_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockStatus, (Object)item_.getStatuspublishedbyhook3_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook3_unlockSensorOn, (Object)item_.isStatuspublishedbyhook3_unlockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook4_inError, (Object)item_.isStatuspublishedbyhook4_inError());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockSensorOn, (Object)item_.isStatuspublishedbyhook4_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockStatus, (Object)item_.getStatuspublishedbyhook4_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook4_unlockSensorOn, (Object)item_.isStatuspublishedbyhook4_unlockSensorOn());
    }

    @Test
    public void sendReceiveFcs_Loader_TrendingTelemetry() throws Exception {
        String id = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_TrendingTelemetry(id));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_TrendingTelemetry));
        Fcs_Loader_TrendingTelemetry item_ = (Fcs_Loader_TrendingTelemetry)item;
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }

    @Test
    public void sendReceiveFcs_TrendingTelemetry() throws Exception {
        int canbus0 = 433;
        int canbus1 = 151;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_TrendingTelemetry(canbus0, canbus1));
        Assert.assertTrue((boolean)(item instanceof Fcs_TrendingTelemetry));
        Fcs_TrendingTelemetry item_ = (Fcs_TrendingTelemetry)item;
        Assert.assertEquals((long)canbus0, (long)item_.getCanbus0());
        Assert.assertEquals((long)canbus1, (long)item_.getCanbus1());
    }

    @Test
    public void sendReceiveShutter_TrendingTelemetry() throws Exception {
        double minusx_strokeCount = 0.8589502573013306;
        double plusx_strokeCount = 0.4137595295906067;
        double shutterstatus_axstatus_MINUSX_actPos = 0.5939998030662537;
        double shutterstatus_axstatus_MINUSX_actVel = 0.7309850454330444;
        int shutterstatus_axstatus_MINUSX_brakeEngaged = 328;
        double shutterstatus_axstatus_MINUSX_ctrlTemp = 0.61989426612854;
        int shutterstatus_axstatus_MINUSX_enabled = 759;
        int shutterstatus_axstatus_MINUSX_errorID = 969;
        int shutterstatus_axstatus_MINUSX_hasSafeTemp = 45;
        int shutterstatus_axstatus_MINUSX_highLimit = 565;
        int shutterstatus_axstatus_MINUSX_isHomed = 98;
        int shutterstatus_axstatus_MINUSX_lowLimit = 865;
        double shutterstatus_axstatus_MINUSX_setAcc = 0.23051035404205322;
        double shutterstatus_axstatus_PLUSX_actPos = 0.29538804292678833;
        double shutterstatus_axstatus_PLUSX_actVel = 0.8473324179649353;
        int shutterstatus_axstatus_PLUSX_brakeEngaged = 142;
        double shutterstatus_axstatus_PLUSX_ctrlTemp = 0.713009774684906;
        int shutterstatus_axstatus_PLUSX_enabled = 517;
        int shutterstatus_axstatus_PLUSX_errorID = 792;
        int shutterstatus_axstatus_PLUSX_hasSafeTemp = 862;
        int shutterstatus_axstatus_PLUSX_highLimit = 527;
        int shutterstatus_axstatus_PLUSX_isHomed = 655;
        int shutterstatus_axstatus_PLUSX_lowLimit = 49;
        double shutterstatus_axstatus_PLUSX_setAcc = 0.7563237547874451;
        int shutterstatus_brakePowerIsOn = 614;
        double shutterstatus_creationTime = 0.3737683892250061;
        int shutterstatus_isCalibrated = 266;
        int shutterstatus_isSafetyOn = 551;
        int shutterstatus_leapIsValid = 539;
        int shutterstatus_leapSeconds = 697;
        int shutterstatus_motionProfile = 189;
        int shutterstatus_ptpState = 149;
        int shutterstatus_smState = 882;
        int shutterstatus_tempIsSafe_CONTROL_BOX = 904;
        int shutterstatus_tempIsSafe_MINUSX_MOTOR = 482;
        int shutterstatus_tempIsSafe_PLUSX_MOTOR = 805;
        double shutterstatus_temperature_CONTROL_BOX = 0.9787943959236145;
        double shutterstatus_temperature_MINUSX_MOTOR = 0.23825335502624512;
        double shutterstatus_temperature_PLUSX_MOTOR = 0.759335994720459;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Shutter_TrendingTelemetry(minusx_strokeCount, plusx_strokeCount, shutterstatus_axstatus_MINUSX_actPos, shutterstatus_axstatus_MINUSX_actVel, shutterstatus_axstatus_MINUSX_brakeEngaged, shutterstatus_axstatus_MINUSX_ctrlTemp, shutterstatus_axstatus_MINUSX_enabled, shutterstatus_axstatus_MINUSX_errorID, shutterstatus_axstatus_MINUSX_hasSafeTemp, shutterstatus_axstatus_MINUSX_highLimit, shutterstatus_axstatus_MINUSX_isHomed, shutterstatus_axstatus_MINUSX_lowLimit, shutterstatus_axstatus_MINUSX_setAcc, shutterstatus_axstatus_PLUSX_actPos, shutterstatus_axstatus_PLUSX_actVel, shutterstatus_axstatus_PLUSX_brakeEngaged, shutterstatus_axstatus_PLUSX_ctrlTemp, shutterstatus_axstatus_PLUSX_enabled, shutterstatus_axstatus_PLUSX_errorID, shutterstatus_axstatus_PLUSX_hasSafeTemp, shutterstatus_axstatus_PLUSX_highLimit, shutterstatus_axstatus_PLUSX_isHomed, shutterstatus_axstatus_PLUSX_lowLimit, shutterstatus_axstatus_PLUSX_setAcc, shutterstatus_brakePowerIsOn, shutterstatus_creationTime, shutterstatus_isCalibrated, shutterstatus_isSafetyOn, shutterstatus_leapIsValid, shutterstatus_leapSeconds, shutterstatus_motionProfile, shutterstatus_ptpState, shutterstatus_smState, shutterstatus_tempIsSafe_CONTROL_BOX, shutterstatus_tempIsSafe_MINUSX_MOTOR, shutterstatus_tempIsSafe_PLUSX_MOTOR, shutterstatus_temperature_CONTROL_BOX, shutterstatus_temperature_MINUSX_MOTOR, shutterstatus_temperature_PLUSX_MOTOR));
        Assert.assertTrue((boolean)(item instanceof Shutter_TrendingTelemetry));
        Shutter_TrendingTelemetry item_ = (Shutter_TrendingTelemetry)item;
        Assert.assertEquals((double)minusx_strokeCount, (double)item_.getMinusx_strokeCount(), (double)1.0E-6f);
        Assert.assertEquals((double)plusx_strokeCount, (double)item_.getPlusx_strokeCount(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_actPos, (double)item_.getShutterstatus_axstatus_MINUSX_actPos(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_actVel, (double)item_.getShutterstatus_axstatus_MINUSX_actVel(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_brakeEngaged, (long)item_.getShutterstatus_axstatus_MINUSX_brakeEngaged());
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_ctrlTemp, (double)item_.getShutterstatus_axstatus_MINUSX_ctrlTemp(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_enabled, (long)item_.getShutterstatus_axstatus_MINUSX_enabled());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_errorID, (long)item_.getShutterstatus_axstatus_MINUSX_errorID());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_hasSafeTemp, (long)item_.getShutterstatus_axstatus_MINUSX_hasSafeTemp());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_highLimit, (long)item_.getShutterstatus_axstatus_MINUSX_highLimit());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_isHomed, (long)item_.getShutterstatus_axstatus_MINUSX_isHomed());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_lowLimit, (long)item_.getShutterstatus_axstatus_MINUSX_lowLimit());
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_setAcc, (double)item_.getShutterstatus_axstatus_MINUSX_setAcc(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_actPos, (double)item_.getShutterstatus_axstatus_PLUSX_actPos(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_actVel, (double)item_.getShutterstatus_axstatus_PLUSX_actVel(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_brakeEngaged, (long)item_.getShutterstatus_axstatus_PLUSX_brakeEngaged());
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_ctrlTemp, (double)item_.getShutterstatus_axstatus_PLUSX_ctrlTemp(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_enabled, (long)item_.getShutterstatus_axstatus_PLUSX_enabled());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_errorID, (long)item_.getShutterstatus_axstatus_PLUSX_errorID());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_hasSafeTemp, (long)item_.getShutterstatus_axstatus_PLUSX_hasSafeTemp());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_highLimit, (long)item_.getShutterstatus_axstatus_PLUSX_highLimit());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_isHomed, (long)item_.getShutterstatus_axstatus_PLUSX_isHomed());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_lowLimit, (long)item_.getShutterstatus_axstatus_PLUSX_lowLimit());
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_setAcc, (double)item_.getShutterstatus_axstatus_PLUSX_setAcc(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_brakePowerIsOn, (long)item_.getShutterstatus_brakePowerIsOn());
        Assert.assertEquals((double)shutterstatus_creationTime, (double)item_.getShutterstatus_creationTime(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_isCalibrated, (long)item_.getShutterstatus_isCalibrated());
        Assert.assertEquals((long)shutterstatus_isSafetyOn, (long)item_.getShutterstatus_isSafetyOn());
        Assert.assertEquals((long)shutterstatus_leapIsValid, (long)item_.getShutterstatus_leapIsValid());
        Assert.assertEquals((long)shutterstatus_leapSeconds, (long)item_.getShutterstatus_leapSeconds());
        Assert.assertEquals((long)shutterstatus_motionProfile, (long)item_.getShutterstatus_motionProfile());
        Assert.assertEquals((long)shutterstatus_ptpState, (long)item_.getShutterstatus_ptpState());
        Assert.assertEquals((long)shutterstatus_smState, (long)item_.getShutterstatus_smState());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_CONTROL_BOX, (long)item_.getShutterstatus_tempIsSafe_CONTROL_BOX());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_MINUSX_MOTOR, (long)item_.getShutterstatus_tempIsSafe_MINUSX_MOTOR());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_PLUSX_MOTOR, (long)item_.getShutterstatus_tempIsSafe_PLUSX_MOTOR());
        Assert.assertEquals((double)shutterstatus_temperature_CONTROL_BOX, (double)item_.getShutterstatus_temperature_CONTROL_BOX(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_temperature_MINUSX_MOTOR, (double)item_.getShutterstatus_temperature_MINUSX_MOTOR(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_temperature_PLUSX_MOTOR, (double)item_.getShutterstatus_temperature_PLUSX_MOTOR(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_ChillerTelemetry() throws Exception {
        double cascadeSetPoint = 0.1105089783668518;
        double chillerPumpLife = 0.9210597276687622;
        double chillerValveAct = 0.9468511343002319;
        double compressorLife = 0.3025868535041809;
        double controllerLife = 0.41682547330856323;
        double coolPercentage = 0.02113097906112671;
        double flowRate = 0.2932738661766052;
        double flowSetPoint = 0.10521078109741211;
        double fluidTemperature = 0.2363465428352356;
        double heatPercentage = 0.14390015602111816;
        double importedColdTemp = 0.6882686614990234;
        double pressureIn = 0.8476573824882507;
        double pressureOut = 0.6665184497833252;
        double pressureTank = 0.8498090505599976;
        double tankLevel = 0.24881380796432495;
        double tankSetPoint = 0.24697858095169067;
        double tempCondenser = 0.9270090460777283;
        double tempDUTInput = 0.5507165193557739;
        double tempDynamicSetPt = 0.4291202425956726;
        double tempSetPoint = 0.31646376848220825;
        double tempStage2Evap = 0.14046591520309448;
        double tempTXVBulb = 0.10621833801269531;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_ChillerTelemetry(cascadeSetPoint, chillerPumpLife, chillerValveAct, compressorLife, controllerLife, coolPercentage, flowRate, flowSetPoint, fluidTemperature, heatPercentage, importedColdTemp, pressureIn, pressureOut, pressureTank, tankLevel, tankSetPoint, tempCondenser, tempDUTInput, tempDynamicSetPt, tempSetPoint, tempStage2Evap, tempTXVBulb));
        Assert.assertTrue((boolean)(item instanceof Chiller_ChillerTelemetry));
        Chiller_ChillerTelemetry item_ = (Chiller_ChillerTelemetry)item;
        Assert.assertEquals((double)cascadeSetPoint, (double)item_.getCascadeSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)chillerPumpLife, (double)item_.getChillerPumpLife(), (double)1.0E-6f);
        Assert.assertEquals((double)chillerValveAct, (double)item_.getChillerValveAct(), (double)1.0E-6f);
        Assert.assertEquals((double)compressorLife, (double)item_.getCompressorLife(), (double)1.0E-6f);
        Assert.assertEquals((double)controllerLife, (double)item_.getControllerLife(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPercentage, (double)item_.getCoolPercentage(), (double)1.0E-6f);
        Assert.assertEquals((double)flowRate, (double)item_.getFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)flowSetPoint, (double)item_.getFlowSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)fluidTemperature, (double)item_.getFluidTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)heatPercentage, (double)item_.getHeatPercentage(), (double)1.0E-6f);
        Assert.assertEquals((double)importedColdTemp, (double)item_.getImportedColdTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureIn, (double)item_.getPressureIn(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureOut, (double)item_.getPressureOut(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureTank, (double)item_.getPressureTank(), (double)1.0E-6f);
        Assert.assertEquals((double)tankLevel, (double)item_.getTankLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)tankSetPoint, (double)item_.getTankSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCondenser, (double)item_.getTempCondenser(), (double)1.0E-6f);
        Assert.assertEquals((double)tempDUTInput, (double)item_.getTempDUTInput(), (double)1.0E-6f);
        Assert.assertEquals((double)tempDynamicSetPt, (double)item_.getTempDynamicSetPt(), (double)1.0E-6f);
        Assert.assertEquals((double)tempSetPoint, (double)item_.getTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempStage2Evap, (double)item_.getTempStage2Evap(), (double)1.0E-6f);
        Assert.assertEquals((double)tempTXVBulb, (double)item_.getTempTXVBulb(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_FParam_TrendingTelemetry() throws Exception {
        double bubblev_TIME = 0.7622305154800415;
        double clr_KI_SETPT = 0.8990662097930908;
        double cold_PERIOD = 0.949695885181427;
        double cool_CAPACITY = 0.2943531274795532;
        double dut_DT_HI = 0.5089951753616333;
        double dut_DT_LO = 0.4099313020706177;
        double dut_KI = 0.8896225690841675;
        double dut_KP = 0.256908655166626;
        double dut_TMAX = 0.1336471438407898;
        double dut_TMIN = 0.3564424514770508;
        double flowmeter_LO = 0.7358787655830383;
        double flow_ERR_MASK = 0.2476483f;
        double heat_CAPACITY = 0.35570287704467773;
        double heat_PERIOD = 0.11056089401245117;
        double pid_GAINFAC = 0.3588717579841614;
        double pid_KD = 0.462848424911499;
        double pid_KI = 0.6299748420715332;
        double pid_KP = 0.5067963600158691;
        double purge_TIME = 0.5876566171646118;
        double ramp_DEFAULT = 0.3968232274055481;
        double refrig_OFF = 0.6091803908348083;
        double setpt_SETTLE = 0.5019757747650146;
        double setpt_TOL = 0.2876335382461548;
        double tank_SETPOINT = 0.6080055236816406;
        double thermsl_MASS = 0.7917084097862244;
        double t_CTRL_MODE = 0.43527287244796753;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_FParam_TrendingTelemetry(bubblev_TIME, clr_KI_SETPT, cold_PERIOD, cool_CAPACITY, dut_DT_HI, dut_DT_LO, dut_KI, dut_KP, dut_TMAX, dut_TMIN, flowmeter_LO, flow_ERR_MASK, heat_CAPACITY, heat_PERIOD, pid_GAINFAC, pid_KD, pid_KI, pid_KP, purge_TIME, ramp_DEFAULT, refrig_OFF, setpt_SETTLE, setpt_TOL, tank_SETPOINT, thermsl_MASS, t_CTRL_MODE));
        Assert.assertTrue((boolean)(item instanceof Chiller_FParam_TrendingTelemetry));
        Chiller_FParam_TrendingTelemetry item_ = (Chiller_FParam_TrendingTelemetry)item;
        Assert.assertEquals((double)bubblev_TIME, (double)item_.getBubblev_TIME(), (double)1.0E-6f);
        Assert.assertEquals((double)clr_KI_SETPT, (double)item_.getClr_KI_SETPT(), (double)1.0E-6f);
        Assert.assertEquals((double)cold_PERIOD, (double)item_.getCold_PERIOD(), (double)1.0E-6f);
        Assert.assertEquals((double)cool_CAPACITY, (double)item_.getCool_CAPACITY(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_DT_HI, (double)item_.getDut_DT_HI(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_DT_LO, (double)item_.getDut_DT_LO(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_KI, (double)item_.getDut_KI(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_KP, (double)item_.getDut_KP(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_TMAX, (double)item_.getDut_TMAX(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_TMIN, (double)item_.getDut_TMIN(), (double)1.0E-6f);
        Assert.assertEquals((double)flowmeter_LO, (double)item_.getFlowmeter_LO(), (double)1.0E-6f);
        Assert.assertEquals((double)flow_ERR_MASK, (double)item_.getFlow_ERR_MASK(), (double)1.0E-6f);
        Assert.assertEquals((double)heat_CAPACITY, (double)item_.getHeat_CAPACITY(), (double)1.0E-6f);
        Assert.assertEquals((double)heat_PERIOD, (double)item_.getHeat_PERIOD(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_GAINFAC, (double)item_.getPid_GAINFAC(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KD, (double)item_.getPid_KD(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KI, (double)item_.getPid_KI(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KP, (double)item_.getPid_KP(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_TIME, (double)item_.getPurge_TIME(), (double)1.0E-6f);
        Assert.assertEquals((double)ramp_DEFAULT, (double)item_.getRamp_DEFAULT(), (double)1.0E-6f);
        Assert.assertEquals((double)refrig_OFF, (double)item_.getRefrig_OFF(), (double)1.0E-6f);
        Assert.assertEquals((double)setpt_SETTLE, (double)item_.getSetpt_SETTLE(), (double)1.0E-6f);
        Assert.assertEquals((double)setpt_TOL, (double)item_.getSetpt_TOL(), (double)1.0E-6f);
        Assert.assertEquals((double)tank_SETPOINT, (double)item_.getTank_SETPOINT(), (double)1.0E-6f);
        Assert.assertEquals((double)thermsl_MASS, (double)item_.getThermsl_MASS(), (double)1.0E-6f);
        Assert.assertEquals((double)t_CTRL_MODE, (double)item_.getT_CTRL_MODE(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_Maq20Telemetry() throws Exception {
        double ambientTemp = 0.9762369394302368;
        double cabinetTemp = 0.3991520404815674;
        double coldPlHeatXfer = 0.7609034776687622;
        double coolantHXOut = 0.3970431685447693;
        double coolantHeatXfer = 0.42832082509994507;
        double coolantPumpIn = 0.18198204040527344;
        double coolantPumpOut = 0.3077316880226135;
        double coolantReturn = 0.08432018756866455;
        double coolantSupply = 0.5854048132896423;
        double fan1Speed = 0.013805627822875977;
        double fan2Speed = 0.1874944567680359;
        double glycChillerIn = 0.9739436507225037;
        double glycChillerOut = 0.7984967827796936;
        double glycCondensOut = 0.3413194417953491;
        double glycDeSuHtrFlow = 0.20059436559677124;
        double glycDeSuHtrOut = 0.06889933347702026;
        double glycFanIn = 0.7616328597068787;
        double glycFanOut = 0.5727697610855103;
        double glycHeatXfer = 0.8800707459449768;
        double glycInputFlow = 0.21037834882736206;
        double glycSupplyP = 0.08199608325958252;
        double pBurstReturn = 0.010221540927886963;
        double pBurstSupply = 0.0031989216804504395;
        double stg1CondensOut = 0.5412513613700867;
        double stg1Discharge = 0.07252120971679688;
        double stg1Return = 0.5229958891868591;
        double stg1TXVBulb = 0.8749794960021973;
        double stg2DeSuHtrOut = 0.1531773805618286;
        double stg2Discharge = 0.2249404788017273;
        double stg2DischargeP = 0.32382726669311523;
        double stg2EvapIn = 0.32756322622299194;
        double stg2EvapOut = 0.9496131539344788;
        double stg2Return = 0.7465482354164124;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_Maq20Telemetry(ambientTemp, cabinetTemp, coldPlHeatXfer, coolantHXOut, coolantHeatXfer, coolantPumpIn, coolantPumpOut, coolantReturn, coolantSupply, fan1Speed, fan2Speed, glycChillerIn, glycChillerOut, glycCondensOut, glycDeSuHtrFlow, glycDeSuHtrOut, glycFanIn, glycFanOut, glycHeatXfer, glycInputFlow, glycSupplyP, pBurstReturn, pBurstSupply, stg1CondensOut, stg1Discharge, stg1Return, stg1TXVBulb, stg2DeSuHtrOut, stg2Discharge, stg2DischargeP, stg2EvapIn, stg2EvapOut, stg2Return));
        Assert.assertTrue((boolean)(item instanceof Chiller_Maq20Telemetry));
        Chiller_Maq20Telemetry item_ = (Chiller_Maq20Telemetry)item;
        Assert.assertEquals((double)ambientTemp, (double)item_.getAmbientTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTemp, (double)item_.getCabinetTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coldPlHeatXfer, (double)item_.getColdPlHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantHXOut, (double)item_.getCoolantHXOut(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantHeatXfer, (double)item_.getCoolantHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantPumpIn, (double)item_.getCoolantPumpIn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantPumpOut, (double)item_.getCoolantPumpOut(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantReturn, (double)item_.getCoolantReturn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantSupply, (double)item_.getCoolantSupply(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)glycChillerIn, (double)item_.getGlycChillerIn(), (double)1.0E-6f);
        Assert.assertEquals((double)glycChillerOut, (double)item_.getGlycChillerOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycCondensOut, (double)item_.getGlycCondensOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycDeSuHtrFlow, (double)item_.getGlycDeSuHtrFlow(), (double)1.0E-6f);
        Assert.assertEquals((double)glycDeSuHtrOut, (double)item_.getGlycDeSuHtrOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycFanIn, (double)item_.getGlycFanIn(), (double)1.0E-6f);
        Assert.assertEquals((double)glycFanOut, (double)item_.getGlycFanOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycHeatXfer, (double)item_.getGlycHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)glycInputFlow, (double)item_.getGlycInputFlow(), (double)1.0E-6f);
        Assert.assertEquals((double)glycSupplyP, (double)item_.getGlycSupplyP(), (double)1.0E-6f);
        Assert.assertEquals((double)pBurstReturn, (double)item_.getPBurstReturn(), (double)1.0E-6f);
        Assert.assertEquals((double)pBurstSupply, (double)item_.getPBurstSupply(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1CondensOut, (double)item_.getStg1CondensOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1Discharge, (double)item_.getStg1Discharge(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1Return, (double)item_.getStg1Return(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1TXVBulb, (double)item_.getStg1TXVBulb(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2DeSuHtrOut, (double)item_.getStg2DeSuHtrOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2Discharge, (double)item_.getStg2Discharge(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2DischargeP, (double)item_.getStg2DischargeP(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2EvapIn, (double)item_.getStg2EvapIn(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2EvapOut, (double)item_.getStg2EvapOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2Return, (double)item_.getStg2Return(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Cold_TempTelemetry() throws Exception {
        double avgColdTemp = 0.34145092964172363;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Cold_TempTelemetry(avgColdTemp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Cold_TempTelemetry));
        Thermal_Cold_TempTelemetry item_ = (Thermal_Cold_TempTelemetry)item;
        Assert.assertEquals((double)avgColdTemp, (double)item_.getAvgColdTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Cryo_TempTelemetry() throws Exception {
        double avgCryoTemp = 0.37691646814346313;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Cryo_TempTelemetry(avgCryoTemp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Cryo_TempTelemetry));
        Thermal_Cryo_TempTelemetry item_ = (Thermal_Cryo_TempTelemetry)item;
        Assert.assertEquals((double)avgCryoTemp, (double)item_.getAvgCryoTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_RtdTelemetry() throws Exception {
        double[] cold_TempCLP = TestHelper.generateDoubleArray((int)25, (int)-155088099);
        double[] cryo_TempCYP = TestHelper.generateDoubleArray((int)25, (int)1007132237);
        double[] grid_TempCFX = TestHelper.generateDoubleArray((int)25, (int)282592536);
        double[] grid_TempGFX = TestHelper.generateDoubleArray((int)25, (int)-1171235450);
        double[] grid_TempGRD = TestHelper.generateDoubleArray((int)25, (int)-1538809932);
        String location = "b";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_RtdTelemetry(cold_TempCLP, cryo_TempCYP, grid_TempCFX, grid_TempGFX, grid_TempGRD, location));
        Assert.assertTrue((boolean)(item instanceof Thermal_RtdTelemetry));
        Thermal_RtdTelemetry item_ = (Thermal_RtdTelemetry)item;
        Assert.assertArrayEquals((double[])cold_TempCLP, (double[])item_.getCold_TempCLP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_TempCYP, (double[])item_.getCryo_TempCYP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_TempCFX, (double[])item_.getGrid_TempCFX(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_TempGFX, (double[])item_.getGrid_TempGFX(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_TempGRD, (double[])item_.getGrid_TempGRD(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveThermal_TrimTelemetry() throws Exception {
        String location = "c";
        double[] trim_Htrs_ColdI = TestHelper.generateDoubleArray((int)6, (int)-1368611534);
        double[] trim_Htrs_ColdP = TestHelper.generateDoubleArray((int)6, (int)29438940);
        double[] trim_Htrs_ColdV = TestHelper.generateDoubleArray((int)6, (int)161855783);
        double[] trim_Htrs_CryoI = TestHelper.generateDoubleArray((int)6, (int)-2033186804);
        double[] trim_Htrs_CryoP = TestHelper.generateDoubleArray((int)6, (int)1494391757);
        double[] trim_Htrs_CryoV = TestHelper.generateDoubleArray((int)6, (int)-1494701003);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_TrimTelemetry(location, trim_Htrs_ColdI, trim_Htrs_ColdP, trim_Htrs_ColdV, trim_Htrs_CryoI, trim_Htrs_CryoP, trim_Htrs_CryoV));
        Assert.assertTrue((boolean)(item instanceof Thermal_TrimTelemetry));
        Thermal_TrimTelemetry item_ = (Thermal_TrimTelemetry)item;
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])trim_Htrs_ColdI, (double[])item_.getTrim_Htrs_ColdI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_ColdP, (double[])item_.getTrim_Htrs_ColdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_ColdV, (double[])item_.getTrim_Htrs_ColdV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_CryoI, (double[])item_.getTrim_Htrs_CryoI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_CryoP, (double[])item_.getTrim_Htrs_CryoP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_CryoV, (double[])item_.getTrim_Htrs_CryoV(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Trim_HtrsTelemetry() throws Exception {
        double coldtotal_P = 0.7564423680305481;
        double cryototal_P = 0.33132725954055786;
        double htrBulkTmp = 0.4313966f;
        double htrbulk_I = 0.21207916736602783;
        double htrbulk_P = 0.44064861536026;
        double htrbulk_V = 0.4272640347480774;
        double htrPsTmp = 0.8109055161476135;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Trim_HtrsTelemetry(coldtotal_P, cryototal_P, htrBulkTmp, htrbulk_I, htrbulk_P, htrbulk_V, htrPsTmp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Trim_HtrsTelemetry));
        Thermal_Trim_HtrsTelemetry item_ = (Thermal_Trim_HtrsTelemetry)item;
        Assert.assertEquals((double)coldtotal_P, (double)item_.getColdtotal_P(), (double)1.0E-6f);
        Assert.assertEquals((double)cryototal_P, (double)item_.getCryototal_P(), (double)1.0E-6f);
        Assert.assertEquals((double)htrBulkTmp, (double)item_.getHtrBulkTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_I, (double)item_.getHtrbulk_I(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_P, (double)item_.getHtrbulk_P(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_V, (double)item_.getHtrbulk_V(), (double)1.0E-6f);
        Assert.assertEquals((double)htrPsTmp, (double)item_.getHtrPsTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_BodyTelemetry() throws Exception {
        double ambAirtemp = 0.2599042057991028;
        double averageTemp = 0.9547948241233826;
        double backFlngXMinusTemp = 0.22887331247329712;
        double backFlngYMinusTemp = 0.687648f;
        double camBodyXPlusTemp = 0.45208728313446045;
        double camBodyYMinusTemp = 0.3467797636985779;
        double camBodyYPlusTemp = 0.3316415548324585;
        double camHousXMinusTemp = 0.8257326483726501;
        double camHousXPlusTemp = 0.6625066995620728;
        double camHousYMinusTemp = 0.8736305236816406;
        double camHousYPlusTemp = 0.1604672074317932;
        double chgrYMinusRtnAirTemp = 0.5103719234466553;
        double chgrYMinusRtnAirVel = 0.8269177675247192;
        double domeXMinusTemp = 0.8123723268508911;
        double domeYMinusTemp = 0.4813665747642517;
        double l1XMinusTemp = 0.020921528339385986;
        double l1YMinusTemp = 0.7771791815757751;
        double l2XMinusTemp = 0.22620874643325806;
        double l2XPlusTemp = 0.17614257335662842;
        double l2YPlusTemp = 0.6016849279403687;
        double shrdRngXMinusTemp = 0.5912918448448181;
        double shrdRngXPlusTemp = 0.61680006980896;
        double shrdRngYPlusTemp = 0.12476956844329834;
        double shtrEboxRtnAirTemp = 0.9761613607406616;
        double shtrEboxRtnAirVel = 0.2247957f;
        double shtrMtrRtnAirTemp = 0.69805508852005;
        double shtrMtrRtnAirVel = 0.8758060336112976;
        double vPPlenumInTemp = 0.2901118993759155;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_BodyTelemetry(ambAirtemp, averageTemp, backFlngXMinusTemp, backFlngYMinusTemp, camBodyXPlusTemp, camBodyYMinusTemp, camBodyYPlusTemp, camHousXMinusTemp, camHousXPlusTemp, camHousYMinusTemp, camHousYPlusTemp, chgrYMinusRtnAirTemp, chgrYMinusRtnAirVel, domeXMinusTemp, domeYMinusTemp, l1XMinusTemp, l1YMinusTemp, l2XMinusTemp, l2XPlusTemp, l2YPlusTemp, shrdRngXMinusTemp, shrdRngXPlusTemp, shrdRngYPlusTemp, shtrEboxRtnAirTemp, shtrEboxRtnAirVel, shtrMtrRtnAirTemp, shtrMtrRtnAirVel, vPPlenumInTemp));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_BodyTelemetry));
        Utiltrunk_BodyTelemetry item_ = (Utiltrunk_BodyTelemetry)item;
        Assert.assertEquals((double)ambAirtemp, (double)item_.getAmbAirtemp(), (double)1.0E-6f);
        Assert.assertEquals((double)averageTemp, (double)item_.getAverageTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngXMinusTemp, (double)item_.getBackFlngXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngYMinusTemp, (double)item_.getBackFlngYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyXPlusTemp, (double)item_.getCamBodyXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyYMinusTemp, (double)item_.getCamBodyYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyYPlusTemp, (double)item_.getCamBodyYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousXMinusTemp, (double)item_.getCamHousXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousXPlusTemp, (double)item_.getCamHousXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousYMinusTemp, (double)item_.getCamHousYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousYPlusTemp, (double)item_.getCamHousYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)chgrYMinusRtnAirTemp, (double)item_.getChgrYMinusRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)chgrYMinusRtnAirVel, (double)item_.getChgrYMinusRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)domeXMinusTemp, (double)item_.getDomeXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)domeYMinusTemp, (double)item_.getDomeYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l1XMinusTemp, (double)item_.getL1XMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l1YMinusTemp, (double)item_.getL1YMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2XMinusTemp, (double)item_.getL2XMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2XPlusTemp, (double)item_.getL2XPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2YPlusTemp, (double)item_.getL2YPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngXMinusTemp, (double)item_.getShrdRngXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngXPlusTemp, (double)item_.getShrdRngXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngYPlusTemp, (double)item_.getShrdRngYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrEboxRtnAirTemp, (double)item_.getShtrEboxRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrEboxRtnAirVel, (double)item_.getShtrEboxRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrMtrRtnAirTemp, (double)item_.getShtrMtrRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrMtrRtnAirVel, (double)item_.getShtrMtrRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)vPPlenumInTemp, (double)item_.getVPPlenumInTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_MPCTelemetry() throws Exception {
        double avgAirtempOut = 0.9560574889183044;
        double deltaPressFilt = 0.3139672875404358;
        double deltaPressTotal = 0.805095374584198;
        double deltaTempAct = 0.02546858787536621;
        double fanRunTime = 0.3368757963180542;
        double fanSpeed = 0.4967222213745117;
        double fanSpeedError = 0.9144179224967957;
        double humidity = 0.3313818573951721;
        double preFiltPress = 0.3330138921737671;
        double retnAirTemp = 0.541313f;
        double retnPress = 0.2548163f;
        double splyAirTemp = 0.4418790936470032;
        double splyPress = 0.4372493028640747;
        double valvePosn = 0.7445698380470276;
        double valvePosnError = 0.07734578847885132;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_MPCTelemetry(avgAirtempOut, deltaPressFilt, deltaPressTotal, deltaTempAct, fanRunTime, fanSpeed, fanSpeedError, humidity, preFiltPress, retnAirTemp, retnPress, splyAirTemp, splyPress, valvePosn, valvePosnError));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_MPCTelemetry));
        Utiltrunk_MPCTelemetry item_ = (Utiltrunk_MPCTelemetry)item;
        Assert.assertEquals((double)avgAirtempOut, (double)item_.getAvgAirtempOut(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressFilt, (double)item_.getDeltaPressFilt(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressTotal, (double)item_.getDeltaPressTotal(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaTempAct, (double)item_.getDeltaTempAct(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeedError, (double)item_.getFanSpeedError(), (double)1.0E-6f);
        Assert.assertEquals((double)humidity, (double)item_.getHumidity(), (double)1.0E-6f);
        Assert.assertEquals((double)preFiltPress, (double)item_.getPreFiltPress(), (double)1.0E-6f);
        Assert.assertEquals((double)retnAirTemp, (double)item_.getRetnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)retnPress, (double)item_.getRetnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirTemp, (double)item_.getSplyAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)splyPress, (double)item_.getSplyPress(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosnError, (double)item_.getValvePosnError(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_UTTelemetry() throws Exception {
        double averageTemp = 0.3536115884780884;
        double coolFlowRate = 0.08894175291061401;
        double coolHeatXfer = 0.6208242774009705;
        double coolPipeRetnTemp = 0.32345062494277954;
        double coolPipeSplyTemp = 0.8245266675949097;
        double domeXMinusTemp = 0.4157188f;
        double domeYMinusTemp = 0.2299739122390747;
        double fanInletTemp = 0.5276051163673401;
        double fanRunTime = 0.518195629119873;
        double fanSpeed = 0.379548f;
        double fanSpeedError = 0.01873844861984253;
        double midXMinusTemp = 0.8789803385734558;
        double midXPlusTemp = 0.8927275538444519;
        double suppXMinusTemp = 0.9442128539085388;
        double suppXPlusTemp = 0.8302292227745056;
        double topXMinusTemp = 0.2925226092338562;
        double topXPlusTemp = 0.2421368956565857;
        double valvePosn = 0.04516857862472534;
        double valvePosnError = 0.544092059135437;
        double w2Q1Temp = 0.29190772771835327;
        double w4Q3Temp = 0.30673056840896606;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_UTTelemetry(averageTemp, coolFlowRate, coolHeatXfer, coolPipeRetnTemp, coolPipeSplyTemp, domeXMinusTemp, domeYMinusTemp, fanInletTemp, fanRunTime, fanSpeed, fanSpeedError, midXMinusTemp, midXPlusTemp, suppXMinusTemp, suppXPlusTemp, topXMinusTemp, topXPlusTemp, valvePosn, valvePosnError, w2Q1Temp, w4Q3Temp));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_UTTelemetry));
        Utiltrunk_UTTelemetry item_ = (Utiltrunk_UTTelemetry)item;
        Assert.assertEquals((double)averageTemp, (double)item_.getAverageTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolHeatXfer, (double)item_.getCoolHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPipeRetnTemp, (double)item_.getCoolPipeRetnTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPipeSplyTemp, (double)item_.getCoolPipeSplyTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)domeXMinusTemp, (double)item_.getDomeXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)domeYMinusTemp, (double)item_.getDomeYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanInletTemp, (double)item_.getFanInletTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeedError, (double)item_.getFanSpeedError(), (double)1.0E-6f);
        Assert.assertEquals((double)midXMinusTemp, (double)item_.getMidXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)midXPlusTemp, (double)item_.getMidXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)suppXMinusTemp, (double)item_.getSuppXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)suppXPlusTemp, (double)item_.getSuppXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)topXMinusTemp, (double)item_.getTopXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)topXPlusTemp, (double)item_.getTopXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosnError, (double)item_.getValvePosnError(), (double)1.0E-6f);
        Assert.assertEquals((double)w2Q1Temp, (double)item_.getW2Q1Temp(), (double)1.0E-6f);
        Assert.assertEquals((double)w4Q3Temp, (double)item_.getW4Q3Temp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_VPCTelemetry() throws Exception {
        double deltaPressFilt = 0.4251835346221924;
        double deltaPressTotal = 0.9985090494155884;
        double deltaTempAct = 0.17942827939987183;
        double fanRunTime = 0.6332154870033264;
        double fanSpeed = 0.8674523234367371;
        double fanSpeedError = 0.2610008120536804;
        double htrCurrent = 0.9361855983734131;
        double humidity = 0.5810818076133728;
        double preFiltPress = 0.9075066447257996;
        double retnAirTemp = 0.06759816408157349;
        double retnPress = 0.0883021354675293;
        double splyAirTemp = 0.6263072490692139;
        double splyAirVel = 0.7098849415779114;
        double splyPress = 0.9655308723449707;
        double valvePosn = 0.12270039319992065;
        double valvePosnError = 0.6340906620025635;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_VPCTelemetry(deltaPressFilt, deltaPressTotal, deltaTempAct, fanRunTime, fanSpeed, fanSpeedError, htrCurrent, humidity, preFiltPress, retnAirTemp, retnPress, splyAirTemp, splyAirVel, splyPress, valvePosn, valvePosnError));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_VPCTelemetry));
        Utiltrunk_VPCTelemetry item_ = (Utiltrunk_VPCTelemetry)item;
        Assert.assertEquals((double)deltaPressFilt, (double)item_.getDeltaPressFilt(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressTotal, (double)item_.getDeltaPressTotal(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaTempAct, (double)item_.getDeltaTempAct(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeedError, (double)item_.getFanSpeedError(), (double)1.0E-6f);
        Assert.assertEquals((double)htrCurrent, (double)item_.getHtrCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)humidity, (double)item_.getHumidity(), (double)1.0E-6f);
        Assert.assertEquals((double)preFiltPress, (double)item_.getPreFiltPress(), (double)1.0E-6f);
        Assert.assertEquals((double)retnAirTemp, (double)item_.getRetnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)retnPress, (double)item_.getRetnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirTemp, (double)item_.getSplyAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirVel, (double)item_.getSplyAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)splyPress, (double)item_.getSplyPress(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosnError, (double)item_.getValvePosnError(), (double)1.0E-6f);
    }
}

