/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.Chiller_ChillerTelemetry;
import org.lsst.sal.camera.telemetry.Chiller_FParam_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Chiller_Maq20Telemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Reb_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Sum_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_Latches_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_OnlineClamps_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_Temperatures_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Accelerobf_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Ai814_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_CarouselController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ClampXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ClampXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Hyttc580_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_LatchXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_LatchXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Pt100_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_CarrierController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_HooksController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Brakes_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket1_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket2_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket3_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket4_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket5_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Counters_Autochanger_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Counters_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Counters_Loader_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Counters_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Autochanger_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Loader_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Fcs_Mcm_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Fcs_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_Carrier_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_Hooks_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebsAverageTemp6Telemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_03Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_05Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_50Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_55Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_12Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_14Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_31Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_43Telemetry;
import org.lsst.sal.camera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_REB_Bulk_PSTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Shutter_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Cold_TempTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Cryo_TempTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_RtdTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_TrimTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Trim_HtrsTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_BodyTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_MPCTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_UTTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_VPCTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CipTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_HXTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_HipTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_InstTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.47234803438186646;
        double dirty_24V_I = 0.8543391227722168;
        double dirty_28V_I = 0.46074116230010986;
        double dirty_48V_I = 0.6509405970573425;
        double protection_I = 0.6801722645759583;
        double rebps_0_2_I = 0.6408683657646179;
        double rebps_3_5_I = 0.5952237248420715;
        double rebps_6_8_I = 0.20269042253494263;
        double rebps_9_12_I = 0.8306482434272766;
        double rebps_Spr_I = 0.4728173017501831;
        double total_VA = 0.7134791612625122;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, protection_I, rebps_0_2_I, rebps_3_5_I, rebps_6_8_I, rebps_9_12_I, rebps_Spr_I, total_VA));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I, (double)item_.getRebps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I, (double)item_.getRebps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I, (double)item_.getRebps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I, (double)item_.getRebps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I, (double)item_.getRebps_Spr_I(), (double)1.0E-6f);
        Assert.assertEquals((double)total_VA, (double)item_.getTotal_VA(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double board_T = 0.18630146980285645;
        double body_Maq20_I = 0.7585159540176392;
        double body_Maq20_V = 0.23626983165740967;
        double cryo_Maq20_I = 0.9563217759132385;
        double cryo_Maq20_V = 0.6528642177581787;
        double fes_CarouselC_I = 0.691328763961792;
        double fes_CarouselC_V = 0.9558330774307251;
        double fes_ChangerC_I = 0.03462434f;
        double fes_ChangerC_V = 0.38666582107543945;
        double fes_LoaderC_I = 0.6155957579612732;
        double fes_LoaderC_V = 0.278786838054657;
        double fpga_T = 0.5909197330474854;
        double gauges_I = 0.6687962412834167;
        double gauges_V = 0.0849973f;
        double int_Valves_I = 0.600838f;
        double int_Valves_V = 0.6535108089447021;
        double ion_Pumps_I = 0.5135097503662109;
        double ion_Pumps_V = 0.2793514132499695;
        double main_I = 0.4285746216773987;
        double main_T = 0.8122632503509521;
        double main_V = 0.8002185225486755;
        double shtr_PLC1_I = 0.5693804621696472;
        double shtr_PLC1_V = 0.4447472095489502;
        double shtr_PLC2_I = 0.3190999f;
        double shtr_PLC2_V = 0.03634554147720337;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(board_T, body_Maq20_I, body_Maq20_V, cryo_Maq20_I, cryo_Maq20_V, fes_CarouselC_I, fes_CarouselC_V, fes_ChangerC_I, fes_ChangerC_V, fes_LoaderC_I, fes_LoaderC_V, fpga_T, gauges_I, gauges_V, int_Valves_I, int_Valves_V, ion_Pumps_I, ion_Pumps_V, main_I, main_T, main_V, shtr_PLC1_I, shtr_PLC1_V, shtr_PLC2_I, shtr_PLC2_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I, (double)item_.getBody_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V, (double)item_.getBody_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I, (double)item_.getCryo_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V, (double)item_.getCryo_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I, (double)item_.getFes_CarouselC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V, (double)item_.getFes_CarouselC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I, (double)item_.getFes_ChangerC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V, (double)item_.getFes_ChangerC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I, (double)item_.getFes_LoaderC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V, (double)item_.getFes_LoaderC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I, (double)item_.getInt_Valves_I(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V, (double)item_.getInt_Valves_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I, (double)item_.getShtr_PLC1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V, (double)item_.getShtr_PLC1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I, (double)item_.getShtr_PLC2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V, (double)item_.getShtr_PLC2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.1288432478904724;
        double cryo_Turbo_I = 0.15852785110473633;
        double cryo_Turbo_V = 0.8869417905807495;
        double fes_Brakes_I = 0.1780725121498108;
        double fes_Brakes_V = 0.1265236735343933;
        double fes_ChangerD_I = 0.68799889087677;
        double fes_ChangerD_V = 0.7755282521247864;
        double fes_Clamps_I = 0.43794262409210205;
        double fes_Clamps_V = 0.1682819128036499;
        double fes_LoaderD_I = 0.8560400605201721;
        double fes_LoaderD_V = 0.7613850831985474;
        double fpga_T = 0.39161497354507446;
        double hex_Turbo_I = 0.2143843173980713;
        double hex_Turbo_V = 0.36885833740234375;
        double main_I = 0.6955242156982422;
        double main_T = 0.922725f;
        double main_V = 0.5182716250419617;
        double shtr_Brakes_I = 0.8896235823631287;
        double shtr_Brakes_V = 0.6626859307289124;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, cryo_Turbo_I, cryo_Turbo_V, fes_Brakes_I, fes_Brakes_V, fes_ChangerD_I, fes_ChangerD_V, fes_Clamps_I, fes_Clamps_V, fes_LoaderD_I, fes_LoaderD_V, fpga_T, hex_Turbo_I, hex_Turbo_V, main_I, main_T, main_V, shtr_Brakes_I, shtr_Brakes_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I, (double)item_.getFes_Brakes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V, (double)item_.getFes_Brakes_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I, (double)item_.getFes_ChangerD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V, (double)item_.getFes_ChangerD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I, (double)item_.getFes_Clamps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V, (double)item_.getFes_Clamps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I, (double)item_.getFes_LoaderD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V, (double)item_.getFes_LoaderD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I, (double)item_.getHex_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V, (double)item_.getHex_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I, (double)item_.getShtr_Brakes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V, (double)item_.getShtr_Brakes_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.7173235416412354;
        double fes_CarouselD_I = 0.896554708480835;
        double fes_CarouselD_V = 0.5846288800239563;
        double fes_Heater_I = 0.8296563029289246;
        double fes_Heater_V = 0.6309148669242859;
        double fpga_T = 0.10122638940811157;
        double main_I = 0.4883200526237488;
        double main_T = 0.17009252309799194;
        double main_V = 0.43547284603118896;
        double purge_Fan_I = 0.30685955286026;
        double purge_Fan_V = 0.35428208112716675;
        double shtr_Motor1_I = 0.59520024061203;
        double shtr_Motor1_V = 0.23540490865707397;
        double shtr_Motor2_I = 0.9090507626533508;
        double shtr_Motor2_V = 0.5953091979026794;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, fes_CarouselD_I, fes_CarouselD_V, fes_Heater_I, fes_Heater_V, fpga_T, main_I, main_T, main_V, purge_Fan_I, purge_Fan_V, shtr_Motor1_I, shtr_Motor1_V, shtr_Motor2_I, shtr_Motor2_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I, (double)item_.getFes_CarouselD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V, (double)item_.getFes_CarouselD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I, (double)item_.getFes_Heater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V, (double)item_.getFes_Heater_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I, (double)item_.getPurge_Fan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V, (double)item_.getPurge_Fan_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I, (double)item_.getShtr_Motor1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V, (double)item_.getShtr_Motor1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I, (double)item_.getShtr_Motor2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V, (double)item_.getShtr_Motor2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_A_I = 0.022459805011749268;
        double otm_0_A_V = 0.3852902054786682;
        double otm_0_B_I = 0.44482892751693726;
        double otm_0_B_V = 0.2961214780807495;
        double otm_1_A_I = 0.4504796862602234;
        double otm_1_A_V = 0.6040089130401611;
        double otm_1_B_I = 0.558561f;
        double otm_1_B_V = 0.95185f;
        double otm_2_A_I = 0.7521445751190186;
        double otm_2_A_V = 0.35588985681533813;
        double otm_2_B_I = 0.44355857372283936;
        double otm_2_B_V = 0.654447f;
        double otm_3_A_I = 0.17885643243789673;
        double otm_3_A_V = 0.5466504693031311;
        double otm_3_B_I = 0.06375300884246826;
        double otm_3_B_V = 0.5436651706695557;
        double otm_4_A_I = 0.217274010181427;
        double otm_4_A_V = 0.3877224922180176;
        double otm_4_B_I = 0.0032235383987426758;
        double otm_4_B_V = 0.850786566734314;
        double otm_5_A_I = 0.6411176323890686;
        double otm_5_A_V = 0.5352170467376709;
        double otm_5_B_I = 0.8839085102081299;
        double otm_5_B_V = 0.19910532236099243;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_A_I, otm_0_A_V, otm_0_B_I, otm_0_B_V, otm_1_A_I, otm_1_A_V, otm_1_B_I, otm_1_B_V, otm_2_A_I, otm_2_A_V, otm_2_B_I, otm_2_B_V, otm_3_A_I, otm_3_A_V, otm_3_B_I, otm_3_B_V, otm_4_A_I, otm_4_A_V, otm_4_B_I, otm_4_B_V, otm_5_A_I, otm_5_A_V, otm_5_B_I, otm_5_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I, (double)item_.getOtm_1_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V, (double)item_.getOtm_1_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I, (double)item_.getOtm_1_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V, (double)item_.getOtm_1_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I, (double)item_.getOtm_2_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V, (double)item_.getOtm_2_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I, (double)item_.getOtm_2_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V, (double)item_.getOtm_2_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I, (double)item_.getOtm_3_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V, (double)item_.getOtm_3_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I, (double)item_.getOtm_4_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V, (double)item_.getOtm_4_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I, (double)item_.getOtm_4_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V, (double)item_.getOtm_4_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I, (double)item_.getOtm_5_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V, (double)item_.getOtm_5_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I, (double)item_.getOtm_5_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V, (double)item_.getOtm_5_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PSTelemetry() throws Exception {
        double rebbulkps_0_2_I = 0.2420135736465454;
        double rebbulkps_0_2_T = 0.5680676698684692;
        double rebbulkps_0_2_V = 0.6415224075317383;
        double rebbulkps_3_5_I = 0.6581142544746399;
        double rebbulkps_3_5_T = 0.6458249092102051;
        double rebbulkps_3_5_V = 0.6832186579704285;
        double rebbulkps_6_8_I = 0.3426624f;
        double rebbulkps_6_8_T = 0.5669072270393372;
        double rebbulkps_6_8_V = 0.868403434753418;
        double rebbulkps_9_12_I = 0.444133996963501;
        double rebbulkps_9_12_T = 0.7765841484069824;
        double rebbulkps_9_12_V = 0.3005765f;
        double rebbulkps_Brd_T = 0.33426398038864136;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_REB_Bulk_PSTelemetry(rebbulkps_0_2_I, rebbulkps_0_2_T, rebbulkps_0_2_V, rebbulkps_3_5_I, rebbulkps_3_5_T, rebbulkps_3_5_V, rebbulkps_6_8_I, rebbulkps_6_8_T, rebbulkps_6_8_V, rebbulkps_9_12_I, rebbulkps_9_12_T, rebbulkps_9_12_V, rebbulkps_Brd_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PSTelemetry));
        Quadbox_REB_Bulk_PSTelemetry item_ = (Quadbox_REB_Bulk_PSTelemetry)item;
        Assert.assertEquals((double)rebbulkps_0_2_I, (double)item_.getRebbulkps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T, (double)item_.getRebbulkps_0_2_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V, (double)item_.getRebbulkps_0_2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I, (double)item_.getRebbulkps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T, (double)item_.getRebbulkps_3_5_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V, (double)item_.getRebbulkps_3_5_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I, (double)item_.getRebbulkps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T, (double)item_.getRebbulkps_6_8_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V, (double)item_.getRebbulkps_6_8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I, (double)item_.getRebbulkps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T, (double)item_.getRebbulkps_9_12_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V, (double)item_.getRebbulkps_9_12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T, (double)item_.getRebbulkps_Brd_T(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)872114689);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)1956517409);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-338932378);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)745310400);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1079659711);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1839877489);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)1145029949);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-515606982);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)88517731);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)223699306);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1037144469);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)911605722);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1137545103);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)-2141308086);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1674355862);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)1555737256);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)945119074);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-714462402);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-856062816);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1753850140);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)234870464);
        double[] dphi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)836099640);
        double[] dphi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-857510001);
        double[] dphi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)1671876376);
        double[] dphi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-2078125942);
        double[] dphi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1421910779);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)221638207);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1563211497);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-990770085);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)315123870);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1386111918);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)71, (int)1795191463);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)71, (int)30189259);
        String location = "u";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1326094356);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-877444332);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1142597197);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)1481887567);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1089015963);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)203172600);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)-1374813576);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, dphi_IaftLDO, dphi_IbefLDO, dphi_VaftLDO, dphi_VaftSwch, dphi_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO, (double[])item_.getDphi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO, (double[])item_.getDphi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO, (double[])item_.getDphi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch, (double[])item_.getDphi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO, (double[])item_.getDphi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.008954644203186035;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTotalPowerTelemetry));
        Rebpower_RebTotalPowerTelemetry item_ = (Rebpower_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)13, (int)102511756);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)13, (int)-865859358);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)13, (int)-885406717);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)13, (int)627826616);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)13, (int)-690203432);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)13, (int)857088075);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)13, (int)133404892);
        double[] fPGATemp = TestHelper.generateDoubleArray((int)13, (int)692963599);
        String location = "b";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, fPGATemp, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fPGATemp, (double[])item_.getFPGATemp(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveHex_Cold1Telemetry() throws Exception {
        double returnTmp = 0.1466047167778015;
        double supplyTmp = 0.697310209274292;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold1Telemetry(returnTmp, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1Telemetry));
        Hex_Cold1Telemetry item_ = (Hex_Cold1Telemetry)item;
        Assert.assertEquals((double)returnTmp, (double)item_.getReturnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2Telemetry() throws Exception {
        double returnTmp = 0.9871083498001099;
        double supplyTmp = 0.8716533184051514;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold2Telemetry(returnTmp, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2Telemetry));
        Hex_Cold2Telemetry item_ = (Hex_Cold2Telemetry)item;
        Assert.assertEquals((double)returnTmp, (double)item_.getReturnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1Telemetry() throws Exception {
        double c3ExitTmp = 0.02343040704727173;
        double c4ExitTmp = 0.4510906934738159;
        double evapExitTmp = 0.6826828122138977;
        double hexRtrnTmp = 0.6598678231239319;
        double liquidPrs = 0.03727757930755615;
        double preC3Tmp = 0.5882796049118042;
        double preC4Tmp = 0.29798614978790283;
        double returnPrs = 0.42802155017852783;
        double vaporPrs = 0.8841565251350403;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo1Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1Telemetry));
        Hex_Cryo1Telemetry item_ = (Hex_Cryo1Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2Telemetry() throws Exception {
        double c3ExitTmp = 0.723391056060791;
        double c4ExitTmp = 0.012175381183624268;
        double evapExitTmp = 0.06291204690933228;
        double hexRtrnTmp = 0.5327414274215698;
        double liquidPrs = 0.32043081521987915;
        double preC3Tmp = 0.6729613542556763;
        double preC4Tmp = 0.27488642930984497;
        double returnPrs = 0.3728615641593933;
        double vaporPrs = 0.9913286566734314;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo2Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2Telemetry));
        Hex_Cryo2Telemetry item_ = (Hex_Cryo2Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3Telemetry() throws Exception {
        double c3ExitTmp = 0.8676349520683289;
        double c4ExitTmp = 0.17567843198776245;
        double evapExitTmp = 0.38904452323913574;
        double hexRtrnTmp = 0.296139f;
        double liquidPrs = 0.7261744737625122;
        double preC3Tmp = 0.6626887917518616;
        double preC4Tmp = 0.04965662956237793;
        double returnPrs = 0.0604214072227478;
        double vaporPrs = 0.25971394777297974;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo3Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3Telemetry));
        Hex_Cryo3Telemetry item_ = (Hex_Cryo3Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4Telemetry() throws Exception {
        double c3ExitTmp = 0.18166548013687134;
        double c4ExitTmp = 0.15060561895370483;
        double evapExitTmp = 0.969784677028656;
        double hexRtrnTmp = 0.5768238306045532;
        double liquidPrs = 0.723280131816864;
        double preC3Tmp = 0.748953f;
        double preC4Tmp = 0.8426942229270935;
        double returnPrs = 0.17643022537231445;
        double vaporPrs = 0.48615914583206177;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo4Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4Telemetry));
        Hex_Cryo4Telemetry item_ = (Hex_Cryo4Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5Telemetry() throws Exception {
        double c3ExitTmp = 0.5553824305534363;
        double c4ExitTmp = 0.8494077324867249;
        double evapExitTmp = 0.06183946132659912;
        double hexRtrnTmp = 0.5651716589927673;
        double liquidPrs = 0.2926744818687439;
        double preC3Tmp = 0.38204145431518555;
        double preC4Tmp = 0.7304448485374451;
        double returnPrs = 0.9954877495765686;
        double vaporPrs = 0.965650200843811;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo5Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5Telemetry));
        Hex_Cryo5Telemetry item_ = (Hex_Cryo5Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6Telemetry() throws Exception {
        double c3ExitTmp = 0.8986307978630066;
        double c4ExitTmp = 0.1965857744216919;
        double evapExitTmp = 0.08702284097671509;
        double hexRtrnTmp = 0.2001015f;
        double liquidPrs = 0.9886152744293213;
        double preC3Tmp = 0.33215343952178955;
        double preC4Tmp = 0.9479057192802429;
        double returnPrs = 0.5957809686660767;
        double vaporPrs = 0.03004467487335205;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo6Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6Telemetry));
        Hex_Cryo6Telemetry item_ = (Hex_Cryo6Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo1Telemetry() throws Exception {
        double afterCoolTmp = 0.6454641222953796;
        double compCurrent = 0.5377201437950134;
        double compPower = 0.7814640998840332;
        double compVoltage = 0.03719979524612427;
        double dischrgPrs = 0.5513439178466797;
        double dischrgtmp_M = 0.2702589f;
        double dischrgtmp_P = 0.766426146030426;
        double fanSpeed = 0.8041006922721863;
        double oilLevel = 0.5551072359085083;
        double oilSepTmp = 0.7508121132850647;
        double phaseSepTmp = 0.5385303497314453;
        double suctionPrs = 0.9230126142501831;
        double suctiontmp_M = 0.1241145133972168;
        double suctiontmp_P = 0.47461992502212524;
        double surgeTankTmp = 0.2787594199180603;
        double waterInTmp = 0.15165424346923828;
        double waterOutTmp = 0.3499273657798767;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo1Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1Telemetry));
        Refrig_Cryo1Telemetry item_ = (Refrig_Cryo1Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2Telemetry() throws Exception {
        double afterCoolTmp = 0.4117283225059509;
        double compCurrent = 0.23782312870025635;
        double compPower = 0.38809633255004883;
        double compVoltage = 0.5119433999061584;
        double dischrgPrs = 0.18037575483322144;
        double dischrgtmp_M = 0.27294737100601196;
        double dischrgtmp_P = 0.9236583113670349;
        double fanSpeed = 0.9931003451347351;
        double oilLevel = 0.6781256794929504;
        double oilSepTmp = 0.3707275986671448;
        double phaseSepTmp = 0.9324435591697693;
        double suctionPrs = 0.5262464880943298;
        double suctiontmp_M = 0.449784517288208;
        double suctiontmp_P = 0.6117709279060364;
        double surgeTankTmp = 0.33810514211654663;
        double waterInTmp = 0.7756381630897522;
        double waterOutTmp = 0.9668700695037842;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo2Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2Telemetry));
        Refrig_Cryo2Telemetry item_ = (Refrig_Cryo2Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3Telemetry() throws Exception {
        double afterCoolTmp = 0.9696370959281921;
        double ambientTmp = 0.3062235713005066;
        double cabinetTmp = 0.7944543957710266;
        double compCurrent = 0.25881046056747437;
        double compPower = 0.91333f;
        double compVoltage = 0.9421666860580444;
        double dischrgPrs = 0.9120232462882996;
        double dischrgtmp_M = 0.7455727458000183;
        double dischrgtmp_P = 0.9104164838790894;
        double fanSpeed = 0.1429547667503357;
        double oilLevel = 0.26258552074432373;
        double oilSepTmp = 0.590083f;
        double phaseSepTmp = 0.8460214138031006;
        double suctionPrs = 0.5365853905677795;
        double suctiontmp_M = 0.09294718503952026;
        double suctiontmp_P = 0.722268283367157;
        double surgeTankTmp = 0.8988456726074219;
        double waterInTmp = 0.6381955742835999;
        double waterOutTmp = 0.5044876337051392;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo3Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3Telemetry));
        Refrig_Cryo3Telemetry item_ = (Refrig_Cryo3Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4Telemetry() throws Exception {
        double afterCoolTmp = 0.8311173319816589;
        double compCurrent = 0.1944863200187683;
        double compPower = 0.6197198033332825;
        double compVoltage = 0.6740178465843201;
        double dischrgPrs = 0.9137324690818787;
        double dischrgtmp_M = 0.3123382329940796;
        double dischrgtmp_P = 0.8043011426925659;
        double fanSpeed = 0.3393649458885193;
        double oilLevel = 0.3884698152542114;
        double oilSepTmp = 0.506984293460846;
        double phaseSepTmp = 0.30024921894073486;
        double suctionPrs = 0.3638683557510376;
        double suctiontmp_M = 0.6911038160324097;
        double suctiontmp_P = 0.948113f;
        double surgeTankTmp = 0.2390207052230835;
        double waterInTmp = 0.14690375328063965;
        double waterOutTmp = 0.6872937083244324;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo4Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4Telemetry));
        Refrig_Cryo4Telemetry item_ = (Refrig_Cryo4Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5Telemetry() throws Exception {
        double afterCoolTmp = 0.8426553606987;
        double ambientTmp = 0.3003944754600525;
        double cabinetTmp = 0.11592239141464233;
        double compCurrent = 0.050885558128356934;
        double compPower = 0.515129804611206;
        double compVoltage = 0.5341867208480835;
        double dischrgPrs = 0.3132544159889221;
        double dischrgtmp_M = 0.015797853469848633;
        double dischrgtmp_P = 0.2513923f;
        double fanSpeed = 0.6256130337715149;
        double oilLevel = 0.4251399636268616;
        double oilSepTmp = 0.04007077217102051;
        double phaseSepTmp = 0.3994826078414917;
        double suctionPrs = 0.42047423124313354;
        double suctiontmp_M = 0.4413236379623413;
        double suctiontmp_P = 0.9954005479812622;
        double surgeTankTmp = 0.1395513415336609;
        double waterInTmp = 0.7120785713195801;
        double waterOutTmp = 0.3843892216682434;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo5Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5Telemetry));
        Refrig_Cryo5Telemetry item_ = (Refrig_Cryo5Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6Telemetry() throws Exception {
        double afterCoolTmp = 0.4760446548461914;
        double compCurrent = 0.8315765261650085;
        double compPower = 0.49518346786499023;
        double compVoltage = 0.3152748942375183;
        double dischrgPrs = 0.8099096417427063;
        double dischrgtmp_M = 0.6014875769615173;
        double dischrgtmp_P = 0.3798556327819824;
        double fanSpeed = 0.664657711982727;
        double oilLevel = 0.8450844883918762;
        double oilSepTmp = 0.08829832077026367;
        double phaseSepTmp = 0.912227988243103;
        double suctionPrs = 0.12183153629302979;
        double suctiontmp_M = 0.710850179195404;
        double suctiontmp_P = 0.12991058826446533;
        double surgeTankTmp = 0.7175328731536865;
        double waterInTmp = 0.0491408109664917;
        double waterOutTmp = 0.5376909375190735;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo6Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6Telemetry));
        Refrig_Cryo6Telemetry item_ = (Refrig_Cryo6Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CipTelemetry() throws Exception {
        double[] cryo_I = TestHelper.generateDoubleArray((int)6, (int)-968421639);
        double[] cryo_Life = TestHelper.generateDoubleArray((int)6, (int)-1172590970);
        double[] cryo_Usage = TestHelper.generateDoubleArray((int)6, (int)429161164);
        double[] cryo_V = TestHelper.generateDoubleArray((int)6, (int)-1154926906);
        String location = "a";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CipTelemetry(cryo_I, cryo_Life, cryo_Usage, cryo_V, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CipTelemetry));
        Vacuum_CipTelemetry item_ = (Vacuum_CipTelemetry)item;
        Assert.assertArrayEquals((double[])cryo_I, (double[])item_.getCryo_I(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life, (double[])item_.getCryo_Life(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage, (double[])item_.getCryo_Usage(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V, (double[])item_.getCryo_V(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double airPressure = 0.2733106017112732;
        double cryoVac = 0.3846477270126343;
        double flineCurrent = 0.5456730723381042;
        double flinePower = 0.6833916306495667;
        double flineVoltage = 0.615400493144989;
        double forelineVac = 0.985266387462616;
        double gaugeDose = 0.6262192130088806;
        double pumpCartPressure = 0.9268412590026855;
        double turboCurrent = 0.7013934254646301;
        double turboCycleNumber = 0.7946221232414246;
        double turboCycleTime = 0.8567145466804504;
        double turboGaugeDose = 0.10664993524551392;
        double turboHours = 0.6390265226364136;
        double turboPower = 0.4128406047821045;
        double turboPumpStatus = 0.7378131747245789;
        double turboPumpTemp = 0.22139078378677368;
        double turboSpeed = 0.8042507171630859;
        double turboVac = 0.6622820496559143;
        double turboVoltage = 0.4527856707572937;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(airPressure, cryoVac, flineCurrent, flinePower, flineVoltage, forelineVac, gaugeDose, pumpCartPressure, turboCurrent, turboCycleNumber, turboCycleTime, turboGaugeDose, turboHours, turboPower, turboPumpStatus, turboPumpTemp, turboSpeed, turboVac, turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)airPressure, (double)item_.getAirPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoVac, (double)item_.getCryoVac(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugeDose, (double)item_.getGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleNumber, (double)item_.getTurboCycleNumber(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleTime, (double)item_.getTurboCycleTime(), (double)1.0E-6f);
        Assert.assertEquals((double)turboGaugeDose, (double)item_.getTurboGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)turboHours, (double)item_.getTurboHours(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpStatus, (double)item_.getTurboPumpStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HXTelemetry() throws Exception {
        double airPressure = 0.2221236228942871;
        double flineCurrent = 0.7435727715492249;
        double flinePower = 0.32882362604141235;
        double flineVoltage = 0.18640172481536865;
        double forelineVac = 0.331407f;
        double gaugeDose = 0.49448084831237793;
        double hexVac = 0.6153187155723572;
        double pumpCartPressure = 0.3528764843940735;
        double turboCurrent = 0.6594946384429932;
        double turboCycleNumber = 0.029887735843658447;
        double turboCycleTime = 0.686722457408905;
        double turboGaugeDose = 0.5515662431716919;
        double turboHours = 0.9538493156433105;
        double turboPower = 0.1216285228729248;
        double turboPumpStatus = 0.0994305f;
        double turboPumpTemp = 0.02028787136077881;
        double turboSpeed = 0.12096691131591797;
        double turboVac = 0.8419254422187805;
        double turboVoltage = 0.5299714803695679;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_HXTelemetry(airPressure, flineCurrent, flinePower, flineVoltage, forelineVac, gaugeDose, hexVac, pumpCartPressure, turboCurrent, turboCycleNumber, turboCycleTime, turboGaugeDose, turboHours, turboPower, turboPumpStatus, turboPumpTemp, turboSpeed, turboVac, turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HXTelemetry));
        Vacuum_HXTelemetry item_ = (Vacuum_HXTelemetry)item;
        Assert.assertEquals((double)airPressure, (double)item_.getAirPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugeDose, (double)item_.getGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)hexVac, (double)item_.getHexVac(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleNumber, (double)item_.getTurboCycleNumber(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleTime, (double)item_.getTurboCycleTime(), (double)1.0E-6f);
        Assert.assertEquals((double)turboGaugeDose, (double)item_.getTurboGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)turboHours, (double)item_.getTurboHours(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpStatus, (double)item_.getTurboPumpStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HipTelemetry() throws Exception {
        double[] hx_I = TestHelper.generateDoubleArray((int)2, (int)2105617795);
        double[] hx_Life = TestHelper.generateDoubleArray((int)2, (int)1587636380);
        double[] hx_Usage = TestHelper.generateDoubleArray((int)2, (int)1433269604);
        double[] hx_V = TestHelper.generateDoubleArray((int)2, (int)1126288019);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_HipTelemetry(hx_I, hx_Life, hx_Usage, hx_V, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HipTelemetry));
        Vacuum_HipTelemetry item_ = (Vacuum_HipTelemetry)item;
        Assert.assertArrayEquals((double[])hx_I, (double[])item_.getHx_I(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life, (double[])item_.getHx_Life(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage, (double[])item_.getHx_Usage(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V, (double[])item_.getHx_V(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_InstTelemetry() throws Exception {
        double cryoFlineValveState = 0.19328594207763672;
        double flineCurrent = 0.7372046113014221;
        double flinePower = 0.7104390859603882;
        double flineVoltage = 0.9478601217269897;
        double hxFlineValveState = 0.4519529342651367;
        double instVac = 0.07082492113113403;
        double pumpCartCycling = 0.5902376770973206;
        double pumpCartPressure = 0.1561023f;
        double pumpCartTemperature = 0.06556594371795654;
        double pumpCartVenting = 0.941853404045105;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_InstTelemetry(cryoFlineValveState, flineCurrent, flinePower, flineVoltage, hxFlineValveState, instVac, pumpCartCycling, pumpCartPressure, pumpCartTemperature, pumpCartVenting));
        Assert.assertTrue((boolean)(item instanceof Vacuum_InstTelemetry));
        Vacuum_InstTelemetry item_ = (Vacuum_InstTelemetry)item;
        Assert.assertEquals((double)cryoFlineValveState, (double)item_.getCryoFlineValveState(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)hxFlineValveState, (double)item_.getHxFlineValveState(), (double)1.0E-6f);
        Assert.assertEquals((double)instVac, (double)item_.getInstVac(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartCycling, (double)item_.getPumpCartCycling(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartTemperature, (double)item_.getPumpCartTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartVenting, (double)item_.getPumpCartVenting(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Reb_TrendingTelemetry() throws Exception {
        long[] driver_errors = TestHelper.generateLongArray((int)71, (int)-1776180556);
        long[] driver_received = TestHelper.generateLongArray((int)71, (int)-900265061);
        long[] driver_rx0 = TestHelper.generateLongArray((int)71, (int)363200007);
        long[] driver_rx1 = TestHelper.generateLongArray((int)71, (int)-1406717675);
        long[] driver_rx2 = TestHelper.generateLongArray((int)71, (int)-955986388);
        long[] driver_rx3 = TestHelper.generateLongArray((int)71, (int)-171617307);
        long[] firmware_cell_errors = TestHelper.generateLongArray((int)71, (int)2054695355);
        long[] firmware_last_rx = TestHelper.generateLongArray((int)71, (int)1882664806);
        long[] firmware_last_tx = TestHelper.generateLongArray((int)71, (int)334147196);
        long[] firmware_link_down = TestHelper.generateLongArray((int)71, (int)-1937190408);
        long[] firmware_link_errors = TestHelper.generateLongArray((int)71, (int)-200554868);
        long[] firmware_link_status = TestHelper.generateLongArray((int)71, (int)1942228748);
        long[] firmware_overflow_local0 = TestHelper.generateLongArray((int)71, (int)1544526924);
        long[] firmware_overflow_local1 = TestHelper.generateLongArray((int)71, (int)-1997619362);
        long[] firmware_overflow_local2 = TestHelper.generateLongArray((int)71, (int)-1827846800);
        long[] firmware_overflow_local3 = TestHelper.generateLongArray((int)71, (int)-389983324);
        long[] firmware_overflow_remote0 = TestHelper.generateLongArray((int)71, (int)650717158);
        long[] firmware_overflow_remote1 = TestHelper.generateLongArray((int)71, (int)1561316152);
        long[] firmware_overflow_remote2 = TestHelper.generateLongArray((int)71, (int)1216692079);
        long[] firmware_overflow_remote3 = TestHelper.generateLongArray((int)71, (int)522555270);
        long[] firmware_rlink_data = TestHelper.generateLongArray((int)71, (int)1013041437);
        long[] firmware_rx_clock = TestHelper.generateLongArray((int)71, (int)1183897166);
        long[] firmware_rx_errors = TestHelper.generateLongArray((int)71, (int)1918009884);
        long[] firmware_rx_frames = TestHelper.generateLongArray((int)71, (int)-36679694);
        long[] firmware_rx_op = TestHelper.generateLongArray((int)71, (int)-1977276055);
        long[] firmware_tx_clock = TestHelper.generateLongArray((int)71, (int)61529191);
        long[] firmware_tx_errors = TestHelper.generateLongArray((int)71, (int)-57024414);
        long[] firmware_tx_frames = TestHelper.generateLongArray((int)71, (int)560339080);
        long[] firmware_tx_op = TestHelper.generateLongArray((int)71, (int)1357147222);
        String location = "v";
        long[] rds_bdi_firsts = TestHelper.generateLongArray((int)71, (int)-1356062211);
        long[] rds_bdi_frees = TestHelper.generateLongArray((int)71, (int)1070340639);
        long[] rds_bdi_lasts = TestHelper.generateLongArray((int)71, (int)591783012);
        long[] rds_bdi_nulls = TestHelper.generateLongArray((int)71, (int)-606341026);
        long[] rds_bdi_overflows = TestHelper.generateLongArray((int)71, (int)1414844427);
        long[] rds_bdi_seq_errors = TestHelper.generateLongArray((int)71, (int)786141334);
        long[] rds_bdi_waits = TestHelper.generateLongArray((int)71, (int)-57580996);
        long[] rds_discards = TestHelper.generateLongArray((int)71, (int)562533616);
        long[] rds_no_event = TestHelper.generateLongArray((int)71, (int)1271468713);
        long[] rds_wakes = TestHelper.generateLongArray((int)71, (int)921181766);
        long[] rms_in_reset = TestHelper.generateLongArray((int)71, (int)1449632356);
        long[] rms_inv_tids = TestHelper.generateLongArray((int)71, (int)-372583908);
        long[] rms_link_down = TestHelper.generateLongArray((int)71, (int)1552557692);
        long[] rms_lists_posted = TestHelper.generateLongArray((int)71, (int)-686543910);
        long[] rms_ops_posted = TestHelper.generateLongArray((int)71, (int)1883536194);
        long[] rms_orphans = TestHelper.generateLongArray((int)71, (int)1074709934);
        long[] rms_probes = TestHelper.generateLongArray((int)71, (int)76179596);
        long[] rms_responses = TestHelper.generateLongArray((int)71, (int)1128601536);
        long[] rms_rundowns = TestHelper.generateLongArray((int)71, (int)-335156113);
        long[] rms_tid_hwm = TestHelper.generateLongArray((int)71, (int)-1356535651);
        long[] rms_unopened = TestHelper.generateLongArray((int)71, (int)-694996677);
        long[] rms_waits = TestHelper.generateLongArray((int)71, (int)1386784777);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Reb_TrendingTelemetry(driver_errors, driver_received, driver_rx0, driver_rx1, driver_rx2, driver_rx3, firmware_cell_errors, firmware_last_rx, firmware_last_tx, firmware_link_down, firmware_link_errors, firmware_link_status, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_local3, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_overflow_remote3, firmware_rlink_data, firmware_rx_clock, firmware_rx_errors, firmware_rx_frames, firmware_rx_op, firmware_tx_clock, firmware_tx_errors, firmware_tx_frames, firmware_tx_op, location, rds_bdi_firsts, rds_bdi_frees, rds_bdi_lasts, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_bdi_waits, rds_discards, rds_no_event, rds_wakes, rms_in_reset, rms_inv_tids, rms_link_down, rms_lists_posted, rms_ops_posted, rms_orphans, rms_probes, rms_responses, rms_rundowns, rms_tid_hwm, rms_unopened, rms_waits));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Reb_TrendingTelemetry));
        Daq_monitor_Reb_TrendingTelemetry item_ = (Daq_monitor_Reb_TrendingTelemetry)item;
        Assert.assertArrayEquals((long[])driver_errors, (long[])item_.getDriver_errors());
        Assert.assertArrayEquals((long[])driver_received, (long[])item_.getDriver_received());
        Assert.assertArrayEquals((long[])driver_rx0, (long[])item_.getDriver_rx0());
        Assert.assertArrayEquals((long[])driver_rx1, (long[])item_.getDriver_rx1());
        Assert.assertArrayEquals((long[])driver_rx2, (long[])item_.getDriver_rx2());
        Assert.assertArrayEquals((long[])driver_rx3, (long[])item_.getDriver_rx3());
        Assert.assertArrayEquals((long[])firmware_cell_errors, (long[])item_.getFirmware_cell_errors());
        Assert.assertArrayEquals((long[])firmware_last_rx, (long[])item_.getFirmware_last_rx());
        Assert.assertArrayEquals((long[])firmware_last_tx, (long[])item_.getFirmware_last_tx());
        Assert.assertArrayEquals((long[])firmware_link_down, (long[])item_.getFirmware_link_down());
        Assert.assertArrayEquals((long[])firmware_link_errors, (long[])item_.getFirmware_link_errors());
        Assert.assertArrayEquals((long[])firmware_link_status, (long[])item_.getFirmware_link_status());
        Assert.assertArrayEquals((long[])firmware_overflow_local0, (long[])item_.getFirmware_overflow_local0());
        Assert.assertArrayEquals((long[])firmware_overflow_local1, (long[])item_.getFirmware_overflow_local1());
        Assert.assertArrayEquals((long[])firmware_overflow_local2, (long[])item_.getFirmware_overflow_local2());
        Assert.assertArrayEquals((long[])firmware_overflow_local3, (long[])item_.getFirmware_overflow_local3());
        Assert.assertArrayEquals((long[])firmware_overflow_remote0, (long[])item_.getFirmware_overflow_remote0());
        Assert.assertArrayEquals((long[])firmware_overflow_remote1, (long[])item_.getFirmware_overflow_remote1());
        Assert.assertArrayEquals((long[])firmware_overflow_remote2, (long[])item_.getFirmware_overflow_remote2());
        Assert.assertArrayEquals((long[])firmware_overflow_remote3, (long[])item_.getFirmware_overflow_remote3());
        Assert.assertArrayEquals((long[])firmware_rlink_data, (long[])item_.getFirmware_rlink_data());
        Assert.assertArrayEquals((long[])firmware_rx_clock, (long[])item_.getFirmware_rx_clock());
        Assert.assertArrayEquals((long[])firmware_rx_errors, (long[])item_.getFirmware_rx_errors());
        Assert.assertArrayEquals((long[])firmware_rx_frames, (long[])item_.getFirmware_rx_frames());
        Assert.assertArrayEquals((long[])firmware_rx_op, (long[])item_.getFirmware_rx_op());
        Assert.assertArrayEquals((long[])firmware_tx_clock, (long[])item_.getFirmware_tx_clock());
        Assert.assertArrayEquals((long[])firmware_tx_errors, (long[])item_.getFirmware_tx_errors());
        Assert.assertArrayEquals((long[])firmware_tx_frames, (long[])item_.getFirmware_tx_frames());
        Assert.assertArrayEquals((long[])firmware_tx_op, (long[])item_.getFirmware_tx_op());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])rds_bdi_firsts, (long[])item_.getRds_bdi_firsts());
        Assert.assertArrayEquals((long[])rds_bdi_frees, (long[])item_.getRds_bdi_frees());
        Assert.assertArrayEquals((long[])rds_bdi_lasts, (long[])item_.getRds_bdi_lasts());
        Assert.assertArrayEquals((long[])rds_bdi_nulls, (long[])item_.getRds_bdi_nulls());
        Assert.assertArrayEquals((long[])rds_bdi_overflows, (long[])item_.getRds_bdi_overflows());
        Assert.assertArrayEquals((long[])rds_bdi_seq_errors, (long[])item_.getRds_bdi_seq_errors());
        Assert.assertArrayEquals((long[])rds_bdi_waits, (long[])item_.getRds_bdi_waits());
        Assert.assertArrayEquals((long[])rds_discards, (long[])item_.getRds_discards());
        Assert.assertArrayEquals((long[])rds_no_event, (long[])item_.getRds_no_event());
        Assert.assertArrayEquals((long[])rds_wakes, (long[])item_.getRds_wakes());
        Assert.assertArrayEquals((long[])rms_in_reset, (long[])item_.getRms_in_reset());
        Assert.assertArrayEquals((long[])rms_inv_tids, (long[])item_.getRms_inv_tids());
        Assert.assertArrayEquals((long[])rms_link_down, (long[])item_.getRms_link_down());
        Assert.assertArrayEquals((long[])rms_lists_posted, (long[])item_.getRms_lists_posted());
        Assert.assertArrayEquals((long[])rms_ops_posted, (long[])item_.getRms_ops_posted());
        Assert.assertArrayEquals((long[])rms_orphans, (long[])item_.getRms_orphans());
        Assert.assertArrayEquals((long[])rms_probes, (long[])item_.getRms_probes());
        Assert.assertArrayEquals((long[])rms_responses, (long[])item_.getRms_responses());
        Assert.assertArrayEquals((long[])rms_rundowns, (long[])item_.getRms_rundowns());
        Assert.assertArrayEquals((long[])rms_tid_hwm, (long[])item_.getRms_tid_hwm());
        Assert.assertArrayEquals((long[])rms_unopened, (long[])item_.getRms_unopened());
        Assert.assertArrayEquals((long[])rms_waits, (long[])item_.getRms_waits());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.965827226638794;
        double freeFraction = 0.32015544176101685;
        double freeSpace = 0.06532156467437744;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Sum_TrendingTelemetry() throws Exception {
        long driver_errors = 881L;
        long firmware_cell_errors = 711L;
        long firmware_link_down = 681L;
        long firmware_link_errors = 94L;
        long firmware_overflow_local0 = 764L;
        long firmware_overflow_local1 = 890L;
        long firmware_overflow_local2 = 973L;
        long firmware_overflow_remote0 = 3L;
        long firmware_overflow_remote1 = 124L;
        long firmware_overflow_remote2 = 297L;
        long firmware_rx_errors = 730L;
        long firmware_tx_errors = 556L;
        long rds_bdi_nulls = 355L;
        long rds_bdi_overflows = 975L;
        long rds_bdi_seq_errors = 306L;
        long rds_discards = 440L;
        long rds_no_event = 672L;
        long rms_in_reset = 800L;
        long rms_inv_tids = 207L;
        long rms_link_down = 94L;
        long rms_orphans = 729L;
        long rms_unopened = 301L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Sum_TrendingTelemetry(driver_errors, firmware_cell_errors, firmware_link_down, firmware_link_errors, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_rx_errors, firmware_tx_errors, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_discards, rds_no_event, rms_in_reset, rms_inv_tids, rms_link_down, rms_orphans, rms_unopened));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Sum_TrendingTelemetry));
        Daq_monitor_Sum_TrendingTelemetry item_ = (Daq_monitor_Sum_TrendingTelemetry)item;
        Assert.assertEquals((long)driver_errors, (long)item_.getDriver_errors());
        Assert.assertEquals((long)firmware_cell_errors, (long)item_.getFirmware_cell_errors());
        Assert.assertEquals((long)firmware_link_down, (long)item_.getFirmware_link_down());
        Assert.assertEquals((long)firmware_link_errors, (long)item_.getFirmware_link_errors());
        Assert.assertEquals((long)firmware_overflow_local0, (long)item_.getFirmware_overflow_local0());
        Assert.assertEquals((long)firmware_overflow_local1, (long)item_.getFirmware_overflow_local1());
        Assert.assertEquals((long)firmware_overflow_local2, (long)item_.getFirmware_overflow_local2());
        Assert.assertEquals((long)firmware_overflow_remote0, (long)item_.getFirmware_overflow_remote0());
        Assert.assertEquals((long)firmware_overflow_remote1, (long)item_.getFirmware_overflow_remote1());
        Assert.assertEquals((long)firmware_overflow_remote2, (long)item_.getFirmware_overflow_remote2());
        Assert.assertEquals((long)firmware_rx_errors, (long)item_.getFirmware_rx_errors());
        Assert.assertEquals((long)firmware_tx_errors, (long)item_.getFirmware_tx_errors());
        Assert.assertEquals((long)rds_bdi_nulls, (long)item_.getRds_bdi_nulls());
        Assert.assertEquals((long)rds_bdi_overflows, (long)item_.getRds_bdi_overflows());
        Assert.assertEquals((long)rds_bdi_seq_errors, (long)item_.getRds_bdi_seq_errors());
        Assert.assertEquals((long)rds_discards, (long)item_.getRds_discards());
        Assert.assertEquals((long)rds_no_event, (long)item_.getRds_no_event());
        Assert.assertEquals((long)rms_in_reset, (long)item_.getRms_in_reset());
        Assert.assertEquals((long)rms_inv_tids, (long)item_.getRms_inv_tids());
        Assert.assertEquals((long)rms_link_down, (long)item_.getRms_link_down());
        Assert.assertEquals((long)rms_orphans, (long)item_.getRms_orphans());
        Assert.assertEquals((long)rms_unopened, (long)item_.getRms_unopened());
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)201, (int)1093303407);
        String location = "n";
        double[] oDI = TestHelper.generateDoubleArray((int)201, (int)1731170448);
        double[] oDV = TestHelper.generateDoubleArray((int)201, (int)1622381423);
        double[] oGV = TestHelper.generateDoubleArray((int)201, (int)1247587370);
        double[] rDV = TestHelper.generateDoubleArray((int)201, (int)1942854623);
        double[] temp = TestHelper.generateDoubleArray((int)201, (int)1348892812);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)71, (int)414623449);
        double[] anaV = TestHelper.generateDoubleArray((int)71, (int)1478722825);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)71, (int)1068004031);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)71, (int)994740027);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)71, (int)1847124729);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)71, (int)-175625868);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)71, (int)-1588806617);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)71, (int)-1735573081);
        double[] clkHI = TestHelper.generateDoubleArray((int)71, (int)1862059191);
        double[] clkHV = TestHelper.generateDoubleArray((int)71, (int)-755753229);
        double[] clkLI = TestHelper.generateDoubleArray((int)71, (int)-825086313);
        double[] clkLV = TestHelper.generateDoubleArray((int)71, (int)-534693503);
        double[] digI = TestHelper.generateDoubleArray((int)71, (int)-412441900);
        double[] digV = TestHelper.generateDoubleArray((int)71, (int)334860116);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)71, (int)1806792293);
        double[] htrPI = TestHelper.generateDoubleArray((int)71, (int)-433903052);
        double[] htrPV = TestHelper.generateDoubleArray((int)71, (int)522323828);
        double[] htrV = TestHelper.generateDoubleArray((int)71, (int)897514979);
        double[] htrW = TestHelper.generateDoubleArray((int)71, (int)-224324383);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)71, (int)-479683108);
        double[] oDV = TestHelper.generateDoubleArray((int)71, (int)1297128407);
        double[] pClk0 = TestHelper.generateDoubleArray((int)71, (int)-901870151);
        double[] pClk1 = TestHelper.generateDoubleArray((int)71, (int)-650009694);
        double[] pClkL = TestHelper.generateDoubleArray((int)71, (int)-239880069);
        double[] pClkU = TestHelper.generateDoubleArray((int)71, (int)-969019378);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)-1252882785);
        double[] rG0 = TestHelper.generateDoubleArray((int)71, (int)-460027132);
        double[] rG1 = TestHelper.generateDoubleArray((int)71, (int)-631917778);
        double[] rGL = TestHelper.generateDoubleArray((int)71, (int)955893244);
        double[] rGU = TestHelper.generateDoubleArray((int)71, (int)994360616);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)71, (int)1574667122);
        double[] ref05V = TestHelper.generateDoubleArray((int)71, (int)-450316865);
        double[] ref125V = TestHelper.generateDoubleArray((int)71, (int)-46295071);
        double[] ref15V = TestHelper.generateDoubleArray((int)71, (int)-549521673);
        double[] ref25V = TestHelper.generateDoubleArray((int)71, (int)1194567907);
        double[] refN12 = TestHelper.generateDoubleArray((int)71, (int)1774492334);
        double[] refP12 = TestHelper.generateDoubleArray((int)71, (int)-624891846);
        double[] sClk0 = TestHelper.generateDoubleArray((int)71, (int)-1026797542);
        double[] sClk1 = TestHelper.generateDoubleArray((int)71, (int)250999227);
        double[] sClkL = TestHelper.generateDoubleArray((int)71, (int)1902509620);
        double[] sClkU = TestHelper.generateDoubleArray((int)71, (int)-540524935);
        double[] temp1 = TestHelper.generateDoubleArray((int)71, (int)-2051765325);
        double[] temp10 = TestHelper.generateDoubleArray((int)71, (int)2042354853);
        double[] temp2 = TestHelper.generateDoubleArray((int)71, (int)-1500989052);
        double[] temp3 = TestHelper.generateDoubleArray((int)71, (int)-883246345);
        double[] temp4 = TestHelper.generateDoubleArray((int)71, (int)-1633072422);
        double[] temp5 = TestHelper.generateDoubleArray((int)71, (int)1436592037);
        double[] temp6 = TestHelper.generateDoubleArray((int)71, (int)1570262611);
        double[] temp7 = TestHelper.generateDoubleArray((int)71, (int)-693602775);
        double[] temp8 = TestHelper.generateDoubleArray((int)71, (int)-246067774);
        double[] temp9 = TestHelper.generateDoubleArray((int)71, (int)1484153964);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClk1, pClkL, pClkU, power, rG0, rG1, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClk0, sClk1, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk1, (double[])item_.getPClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG1, (double[])item_.getRG1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk1, (double[])item_.getSClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.4657749f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6Telemetry() throws Exception {
        double rebsAverageTemp6 = 0.6058825850486755;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebsAverageTemp6Telemetry(rebsAverageTemp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6Telemetry));
        Focal_plane_RebsAverageTemp6Telemetry item_ = (Focal_plane_RebsAverageTemp6Telemetry)item;
        Assert.assertEquals((double)rebsAverageTemp6, (double)item_.getRebsAverageTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)3024, (int)1555833626);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_03Telemetry() throws Exception {
        double clp_RTD_03 = 0.5935790538787842;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_03Telemetry(clp_RTD_03));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_03Telemetry));
        Mpm_CLP_RTD_03Telemetry item_ = (Mpm_CLP_RTD_03Telemetry)item;
        Assert.assertEquals((double)clp_RTD_03, (double)item_.getClp_RTD_03(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_05Telemetry() throws Exception {
        double clp_RTD_05 = 0.67257f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_05Telemetry(clp_RTD_05));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_05Telemetry));
        Mpm_CLP_RTD_05Telemetry item_ = (Mpm_CLP_RTD_05Telemetry)item;
        Assert.assertEquals((double)clp_RTD_05, (double)item_.getClp_RTD_05(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_50Telemetry() throws Exception {
        double clp_RTD_50 = 0.3236528f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_50Telemetry(clp_RTD_50));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_50Telemetry));
        Mpm_CLP_RTD_50Telemetry item_ = (Mpm_CLP_RTD_50Telemetry)item;
        Assert.assertEquals((double)clp_RTD_50, (double)item_.getClp_RTD_50(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_55Telemetry() throws Exception {
        double clp_RTD_55 = 0.8826066851615906;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_55Telemetry(clp_RTD_55));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_55Telemetry));
        Mpm_CLP_RTD_55Telemetry item_ = (Mpm_CLP_RTD_55Telemetry)item;
        Assert.assertEquals((double)clp_RTD_55, (double)item_.getClp_RTD_55(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_12Telemetry() throws Exception {
        double cyp_RTD_12 = 0.5549773573875427;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_12Telemetry(cyp_RTD_12));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_12Telemetry));
        Mpm_CYP_RTD_12Telemetry item_ = (Mpm_CYP_RTD_12Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_12, (double)item_.getCyp_RTD_12(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_14Telemetry() throws Exception {
        double cyp_RTD_14 = 0.5185275077819824;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_14Telemetry(cyp_RTD_14));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_14Telemetry));
        Mpm_CYP_RTD_14Telemetry item_ = (Mpm_CYP_RTD_14Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_14, (double)item_.getCyp_RTD_14(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_31Telemetry() throws Exception {
        double cyp_RTD_31 = 0.0874180793762207;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_31Telemetry(cyp_RTD_31));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_31Telemetry));
        Mpm_CYP_RTD_31Telemetry item_ = (Mpm_CYP_RTD_31Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_31, (double)item_.getCyp_RTD_31(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_43Telemetry() throws Exception {
        double cyp_RTD_43 = 0.9695937037467957;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_43Telemetry(cyp_RTD_43));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_43Telemetry));
        Mpm_CYP_RTD_43Telemetry item_ = (Mpm_CYP_RTD_43Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_43, (double)item_.getCyp_RTD_43(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Autochanger_AutochangerTrucks_TrendingTelemetry() throws Exception {
        boolean actruckxminus_handoffInError = false;
        boolean actruckxminus_handoffSensorValue = false;
        boolean actruckxminus_onlineInError = true;
        boolean actruckxminus_onlineSensorValue = false;
        boolean actruckxminus_standbyInError = true;
        boolean actruckxminus_standbySensorValue = true;
        boolean actruckxplus_handoffInError = false;
        boolean actruckxplus_handoffSensorValue = false;
        boolean actruckxplus_onlineInError = false;
        boolean actruckxplus_onlineSensorValue = false;
        boolean actruckxplus_standbyInError = true;
        boolean actruckxplus_standbySensorValue = true;
        boolean atHandoff = false;
        boolean atOnline = false;
        boolean atStandby = false;
        int driverPosition = 596;
        int followerPosition = 254;
        boolean homingDone = false;
        boolean inError = false;
        int proximityDistance = 733;
        double proximityVoltage = 0.8955610394477844;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry(actruckxminus_handoffInError, actruckxminus_handoffSensorValue, actruckxminus_onlineInError, actruckxminus_onlineSensorValue, actruckxminus_standbyInError, actruckxminus_standbySensorValue, actruckxplus_handoffInError, actruckxplus_handoffSensorValue, actruckxplus_onlineInError, actruckxplus_onlineSensorValue, actruckxplus_standbyInError, actruckxplus_standbySensorValue, atHandoff, atOnline, atStandby, driverPosition, followerPosition, homingDone, inError, proximityDistance, proximityVoltage));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry));
        Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry item_ = (Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry)item;
        Assert.assertEquals((Object)actruckxminus_handoffInError, (Object)item_.isActruckxminus_handoffInError());
        Assert.assertEquals((Object)actruckxminus_handoffSensorValue, (Object)item_.isActruckxminus_handoffSensorValue());
        Assert.assertEquals((Object)actruckxminus_onlineInError, (Object)item_.isActruckxminus_onlineInError());
        Assert.assertEquals((Object)actruckxminus_onlineSensorValue, (Object)item_.isActruckxminus_onlineSensorValue());
        Assert.assertEquals((Object)actruckxminus_standbyInError, (Object)item_.isActruckxminus_standbyInError());
        Assert.assertEquals((Object)actruckxminus_standbySensorValue, (Object)item_.isActruckxminus_standbySensorValue());
        Assert.assertEquals((Object)actruckxplus_handoffInError, (Object)item_.isActruckxplus_handoffInError());
        Assert.assertEquals((Object)actruckxplus_handoffSensorValue, (Object)item_.isActruckxplus_handoffSensorValue());
        Assert.assertEquals((Object)actruckxplus_onlineInError, (Object)item_.isActruckxplus_onlineInError());
        Assert.assertEquals((Object)actruckxplus_onlineSensorValue, (Object)item_.isActruckxplus_onlineSensorValue());
        Assert.assertEquals((Object)actruckxplus_standbyInError, (Object)item_.isActruckxplus_standbyInError());
        Assert.assertEquals((Object)actruckxplus_standbySensorValue, (Object)item_.isActruckxplus_standbySensorValue());
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atOnline, (Object)item_.isAtOnline());
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((long)driverPosition, (long)item_.getDriverPosition());
        Assert.assertEquals((long)followerPosition, (long)item_.getFollowerPosition());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)proximityDistance, (long)item_.getProximityDistance());
        Assert.assertEquals((double)proximityVoltage, (double)item_.getProximityVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Autochanger_Latches_TrendingTelemetry() throws Exception {
        boolean available = false;
        int filterID = 669;
        String filterName = "c";
        String filterPresenceStatus = "q";
        boolean latchxminus_filterEngagedSensorsInError = true;
        boolean latchxminus_filterPresenceSensorOn = false;
        boolean latchxminus_inError = false;
        boolean latchxminus_lockSensorOn = true;
        boolean latchxminus_lockSensorsInError = true;
        String latchxminus_lockStatus = "h";
        boolean latchxminus_unlockSensorOn = true;
        boolean latchxminus_unlockSensorsInError = true;
        boolean latchxplus_filterEngagedSensorsInError = true;
        boolean latchxplus_filterPresenceSensorOn = true;
        boolean latchxplus_inError = false;
        boolean latchxplus_lockSensorOn = false;
        boolean latchxplus_lockSensorsInError = true;
        String latchxplus_lockStatus = "g";
        boolean latchxplus_unlockSensorOn = true;
        boolean latchxplus_unlockSensorsInError = true;
        String lockStatus = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_Latches_TrendingTelemetry(available, filterID, filterName, filterPresenceStatus, latchxminus_filterEngagedSensorsInError, latchxminus_filterPresenceSensorOn, latchxminus_inError, latchxminus_lockSensorOn, latchxminus_lockSensorsInError, latchxminus_lockStatus, latchxminus_unlockSensorOn, latchxminus_unlockSensorsInError, latchxplus_filterEngagedSensorsInError, latchxplus_filterPresenceSensorOn, latchxplus_inError, latchxplus_lockSensorOn, latchxplus_lockSensorsInError, latchxplus_lockStatus, latchxplus_unlockSensorOn, latchxplus_unlockSensorsInError, lockStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_Latches_TrendingTelemetry));
        Fcs_Autochanger_Latches_TrendingTelemetry item_ = (Fcs_Autochanger_Latches_TrendingTelemetry)item;
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((Object)latchxminus_filterEngagedSensorsInError, (Object)item_.isLatchxminus_filterEngagedSensorsInError());
        Assert.assertEquals((Object)latchxminus_filterPresenceSensorOn, (Object)item_.isLatchxminus_filterPresenceSensorOn());
        Assert.assertEquals((Object)latchxminus_inError, (Object)item_.isLatchxminus_inError());
        Assert.assertEquals((Object)latchxminus_lockSensorOn, (Object)item_.isLatchxminus_lockSensorOn());
        Assert.assertEquals((Object)latchxminus_lockSensorsInError, (Object)item_.isLatchxminus_lockSensorsInError());
        Assert.assertEquals((Object)latchxminus_lockStatus, (Object)item_.getLatchxminus_lockStatus());
        Assert.assertEquals((Object)latchxminus_unlockSensorOn, (Object)item_.isLatchxminus_unlockSensorOn());
        Assert.assertEquals((Object)latchxminus_unlockSensorsInError, (Object)item_.isLatchxminus_unlockSensorsInError());
        Assert.assertEquals((Object)latchxplus_filterEngagedSensorsInError, (Object)item_.isLatchxplus_filterEngagedSensorsInError());
        Assert.assertEquals((Object)latchxplus_filterPresenceSensorOn, (Object)item_.isLatchxplus_filterPresenceSensorOn());
        Assert.assertEquals((Object)latchxplus_inError, (Object)item_.isLatchxplus_inError());
        Assert.assertEquals((Object)latchxplus_lockSensorOn, (Object)item_.isLatchxplus_lockSensorOn());
        Assert.assertEquals((Object)latchxplus_lockSensorsInError, (Object)item_.isLatchxplus_lockSensorsInError());
        Assert.assertEquals((Object)latchxplus_lockStatus, (Object)item_.getLatchxplus_lockStatus());
        Assert.assertEquals((Object)latchxplus_unlockSensorOn, (Object)item_.isLatchxplus_unlockSensorOn());
        Assert.assertEquals((Object)latchxplus_unlockSensorsInError, (Object)item_.isLatchxplus_unlockSensorsInError());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
    }

    @Test
    public void sendReceiveFcs_Autochanger_OnlineClamps_TrendingTelemetry() throws Exception {
        String lockStatus = "q";
        int onlineClampRawStrain = 170;
        int onlineClampStrain = 736;
        int onlineclampxminus_current = 801;
        boolean onlineclampxminus_inError = true;
        boolean onlineclampxminus_lockSensorInError = false;
        boolean onlineclampxminus_lockSensorOn = true;
        String onlineclampxminus_lockStatus = "j";
        int onlineclampxminus_position = 280;
        int onlineclampxminus_sentCurrent = 874;
        boolean onlineclampxminus_unlockSensorInError = false;
        boolean onlineclampxminus_unlockSensorOn = true;
        int onlineclampxplus_current = 8;
        boolean onlineclampxplus_inError = true;
        boolean onlineclampxplus_lockSensorInError = false;
        boolean onlineclampxplus_lockSensorOn = true;
        String onlineclampxplus_lockStatus = "z";
        int onlineclampxplus_position = 530;
        int onlineclampxplus_sentCurrent = 187;
        boolean onlineclampxplus_unlockSensorInError = true;
        boolean onlineclampxplus_unlockSensorOn = false;
        int onlineclampyminus_current = 775;
        boolean onlineclampyminus_inError = false;
        boolean onlineclampyminus_lockSensorInError = false;
        boolean onlineclampyminus_lockSensorOn = true;
        String onlineclampyminus_lockStatus = "h";
        int onlineclampyminus_position = 865;
        int onlineclampyminus_sentCurrent = 116;
        boolean onlineclampyminus_unlockSensorInError = false;
        boolean onlineclampyminus_unlockSensorOn = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_OnlineClamps_TrendingTelemetry(lockStatus, onlineClampRawStrain, onlineClampStrain, onlineclampxminus_current, onlineclampxminus_inError, onlineclampxminus_lockSensorInError, onlineclampxminus_lockSensorOn, onlineclampxminus_lockStatus, onlineclampxminus_position, onlineclampxminus_sentCurrent, onlineclampxminus_unlockSensorInError, onlineclampxminus_unlockSensorOn, onlineclampxplus_current, onlineclampxplus_inError, onlineclampxplus_lockSensorInError, onlineclampxplus_lockSensorOn, onlineclampxplus_lockStatus, onlineclampxplus_position, onlineclampxplus_sentCurrent, onlineclampxplus_unlockSensorInError, onlineclampxplus_unlockSensorOn, onlineclampyminus_current, onlineclampyminus_inError, onlineclampyminus_lockSensorInError, onlineclampyminus_lockSensorOn, onlineclampyminus_lockStatus, onlineclampyminus_position, onlineclampyminus_sentCurrent, onlineclampyminus_unlockSensorInError, onlineclampyminus_unlockSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_OnlineClamps_TrendingTelemetry));
        Fcs_Autochanger_OnlineClamps_TrendingTelemetry item_ = (Fcs_Autochanger_OnlineClamps_TrendingTelemetry)item;
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((long)onlineClampRawStrain, (long)item_.getOnlineClampRawStrain());
        Assert.assertEquals((long)onlineClampStrain, (long)item_.getOnlineClampStrain());
        Assert.assertEquals((long)onlineclampxminus_current, (long)item_.getOnlineclampxminus_current());
        Assert.assertEquals((Object)onlineclampxminus_inError, (Object)item_.isOnlineclampxminus_inError());
        Assert.assertEquals((Object)onlineclampxminus_lockSensorInError, (Object)item_.isOnlineclampxminus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampxminus_lockSensorOn, (Object)item_.isOnlineclampxminus_lockSensorOn());
        Assert.assertEquals((Object)onlineclampxminus_lockStatus, (Object)item_.getOnlineclampxminus_lockStatus());
        Assert.assertEquals((long)onlineclampxminus_position, (long)item_.getOnlineclampxminus_position());
        Assert.assertEquals((long)onlineclampxminus_sentCurrent, (long)item_.getOnlineclampxminus_sentCurrent());
        Assert.assertEquals((Object)onlineclampxminus_unlockSensorInError, (Object)item_.isOnlineclampxminus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampxminus_unlockSensorOn, (Object)item_.isOnlineclampxminus_unlockSensorOn());
        Assert.assertEquals((long)onlineclampxplus_current, (long)item_.getOnlineclampxplus_current());
        Assert.assertEquals((Object)onlineclampxplus_inError, (Object)item_.isOnlineclampxplus_inError());
        Assert.assertEquals((Object)onlineclampxplus_lockSensorInError, (Object)item_.isOnlineclampxplus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampxplus_lockSensorOn, (Object)item_.isOnlineclampxplus_lockSensorOn());
        Assert.assertEquals((Object)onlineclampxplus_lockStatus, (Object)item_.getOnlineclampxplus_lockStatus());
        Assert.assertEquals((long)onlineclampxplus_position, (long)item_.getOnlineclampxplus_position());
        Assert.assertEquals((long)onlineclampxplus_sentCurrent, (long)item_.getOnlineclampxplus_sentCurrent());
        Assert.assertEquals((Object)onlineclampxplus_unlockSensorInError, (Object)item_.isOnlineclampxplus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampxplus_unlockSensorOn, (Object)item_.isOnlineclampxplus_unlockSensorOn());
        Assert.assertEquals((long)onlineclampyminus_current, (long)item_.getOnlineclampyminus_current());
        Assert.assertEquals((Object)onlineclampyminus_inError, (Object)item_.isOnlineclampyminus_inError());
        Assert.assertEquals((Object)onlineclampyminus_lockSensorInError, (Object)item_.isOnlineclampyminus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampyminus_lockSensorOn, (Object)item_.isOnlineclampyminus_lockSensorOn());
        Assert.assertEquals((Object)onlineclampyminus_lockStatus, (Object)item_.getOnlineclampyminus_lockStatus());
        Assert.assertEquals((long)onlineclampyminus_position, (long)item_.getOnlineclampyminus_position());
        Assert.assertEquals((long)onlineclampyminus_sentCurrent, (long)item_.getOnlineclampyminus_sentCurrent());
        Assert.assertEquals((Object)onlineclampyminus_unlockSensorInError, (Object)item_.isOnlineclampyminus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampyminus_unlockSensorOn, (Object)item_.isOnlineclampyminus_unlockSensorOn());
    }

    @Test
    public void sendReceiveFcs_Autochanger_Temperatures_TrendingTelemetry() throws Exception {
        double cellXMinus = 0.1097666f;
        double clampMotorXMinus = 0.488522469997406;
        double clampMotorXPlus = 0.07095426321029663;
        double clampMotorYMinus = 0.6523668766021729;
        double frontBox = 0.8579456210136414;
        double linearRailMotorXMinus = 0.30720794200897217;
        double linearRailMotorXPlus = 0.44636887311935425;
        double rearBox = 0.4662301540374756;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_Temperatures_TrendingTelemetry(cellXMinus, clampMotorXMinus, clampMotorXPlus, clampMotorYMinus, frontBox, linearRailMotorXMinus, linearRailMotorXPlus, rearBox));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_Temperatures_TrendingTelemetry));
        Fcs_Autochanger_Temperatures_TrendingTelemetry item_ = (Fcs_Autochanger_Temperatures_TrendingTelemetry)item;
        Assert.assertEquals((double)cellXMinus, (double)item_.getCellXMinus(), (double)1.0E-6f);
        Assert.assertEquals((double)clampMotorXMinus, (double)item_.getClampMotorXMinus(), (double)1.0E-6f);
        Assert.assertEquals((double)clampMotorXPlus, (double)item_.getClampMotorXPlus(), (double)1.0E-6f);
        Assert.assertEquals((double)clampMotorYMinus, (double)item_.getClampMotorYMinus(), (double)1.0E-6f);
        Assert.assertEquals((double)frontBox, (double)item_.getFrontBox(), (double)1.0E-6f);
        Assert.assertEquals((double)linearRailMotorXMinus, (double)item_.getLinearRailMotorXMinus(), (double)1.0E-6f);
        Assert.assertEquals((double)linearRailMotorXPlus, (double)item_.getLinearRailMotorXPlus(), (double)1.0E-6f);
        Assert.assertEquals((double)rearBox, (double)item_.getRearBox(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Autochanger_TrendingTelemetry() throws Exception {
        String id = "m";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_TrendingTelemetry(id));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_TrendingTelemetry));
        Fcs_Autochanger_TrendingTelemetry item_ = (Fcs_Autochanger_TrendingTelemetry)item;
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcSensorsGateway_TrendingTelemetry() throws Exception {
        int carouselHoldingFilterSensor0 = 192;
        int carouselHoldingFilterSensor1 = 108;
        int carouselStoppedAtStandby = 264;
        int carouselStoppedAtStandbyC = 953;
        int carousel_CF0 = 99;
        int carousel_CF0_C = 482;
        int carousel_CF1 = 316;
        int carousel_CF1_C = 702;
        int closeSensorBLatchXminus = 565;
        int closeSensorBLatchXplus = 920;
        int closeSensorLatchXminus = 382;
        int closeSensorLatchXplus = 143;
        int engineeringKey = 114;
        int engineeringkey_C = 12;
        int filterEngagedSensorBLatchXminus = 646;
        int filterEngagedSensorBLatchXplus = 777;
        int filterEngagedSensorLatchXminus = 46;
        int filterEngagedSensorLatchXplus = 505;
        int filterIDSensor0 = 49;
        int filterIDSensor1 = 891;
        int filterIDSensor2 = 801;
        int filterIDSensor3 = 885;
        int filterIDSensor4 = 182;
        int filterIDSensor5 = 804;
        int handoffPositionSensorBXminus = 904;
        int handoffPositionSensorBXplus = 139;
        int handoffPositionSensorXminus = 949;
        int handoffPositionSensorXplus = 186;
        double inclinometerXminus = 0.6201863884925842;
        double inclinometerXplus = 0.4114183187484741;
        int loaderConnectedSensor = 58;
        int loaderConnectedSensorC = 732;
        int loaderHoldingFilterSensor0 = 142;
        int loaderHoldingFilterSensor1 = 944;
        int lockOut = 569;
        int lockOutShunt = 357;
        int lockout_C = 530;
        int lpmLatchesStatus = 427;
        int lpmLinearRail1Status = 540;
        int lpmLinearRail2Status = 214;
        int lpmOnlineClampsStatus = 146;
        int out_AF0 = 647;
        int out_AF0_C = 992;
        int out_AF1 = 46;
        int out_AF1_C = 699;
        int out_AF3 = 14;
        int out_AF3_C = 646;
        int out_AIN = 424;
        int out_AOL = 482;
        int out_AP1 = 927;
        int out_AP1_C = 205;
        int out_AP2 = 633;
        int out_AP2_C = 480;
        int out_AP3 = 53;
        int out_AP3_C = 252;
        int onlineClampXminusCloseSensor = 989;
        int onlineClampXminusCloseSensorC = 484;
        int onlineClampXminusOpenSensor = 498;
        int onlineClampXminusOpenSensorC = 981;
        int onlineClampXplusCloseSensor = 413;
        int onlineClampXplusCloseSensorC = 538;
        int onlineClampXplusOpenSensor = 721;
        int onlineClampXplusOpenSensorC = 13;
        int onlineClampYminusCloseSensor = 135;
        int onlineClampYminusCloseSensorC = 257;
        int onlineClampYminusOpenSensor = 13;
        int onlineClampYminusOpenSensorC = 409;
        int onlinePositionSensorBXminus = 531;
        int onlinePositionSensorBXplus = 514;
        int onlinePositionSensorXminus = 960;
        int onlinePositionSensorXplus = 738;
        int openSensorBLatchXminus = 45;
        int openSensorBLatchXplus = 317;
        int openSensorLatchXminus = 644;
        int openSensorLatchXplus = 281;
        int presenceLoader = 19;
        int presenceloader_C = 718;
        int standbyPositionSensorBXminus = 888;
        int standbyPositionSensorBXplus = 525;
        int standbyPositionSensorXminus = 556;
        int standbyPositionSensorXplus = 676;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry(carouselHoldingFilterSensor0, carouselHoldingFilterSensor1, carouselStoppedAtStandby, carouselStoppedAtStandbyC, carousel_CF0, carousel_CF0_C, carousel_CF1, carousel_CF1_C, closeSensorBLatchXminus, closeSensorBLatchXplus, closeSensorLatchXminus, closeSensorLatchXplus, engineeringKey, engineeringkey_C, filterEngagedSensorBLatchXminus, filterEngagedSensorBLatchXplus, filterEngagedSensorLatchXminus, filterEngagedSensorLatchXplus, filterIDSensor0, filterIDSensor1, filterIDSensor2, filterIDSensor3, filterIDSensor4, filterIDSensor5, handoffPositionSensorBXminus, handoffPositionSensorBXplus, handoffPositionSensorXminus, handoffPositionSensorXplus, inclinometerXminus, inclinometerXplus, loaderConnectedSensor, loaderConnectedSensorC, loaderHoldingFilterSensor0, loaderHoldingFilterSensor1, lockOut, lockOutShunt, lockout_C, lpmLatchesStatus, lpmLinearRail1Status, lpmLinearRail2Status, lpmOnlineClampsStatus, out_AF0, out_AF0_C, out_AF1, out_AF1_C, out_AF3, out_AF3_C, out_AIN, out_AOL, out_AP1, out_AP1_C, out_AP2, out_AP2_C, out_AP3, out_AP3_C, onlineClampXminusCloseSensor, onlineClampXminusCloseSensorC, onlineClampXminusOpenSensor, onlineClampXminusOpenSensorC, onlineClampXplusCloseSensor, onlineClampXplusCloseSensorC, onlineClampXplusOpenSensor, onlineClampXplusOpenSensorC, onlineClampYminusCloseSensor, onlineClampYminusCloseSensorC, onlineClampYminusOpenSensor, onlineClampYminusOpenSensorC, onlinePositionSensorBXminus, onlinePositionSensorBXplus, onlinePositionSensorXminus, onlinePositionSensorXplus, openSensorBLatchXminus, openSensorBLatchXplus, openSensorLatchXminus, openSensorLatchXplus, presenceLoader, presenceloader_C, standbyPositionSensorBXminus, standbyPositionSensorBXplus, standbyPositionSensorXminus, standbyPositionSensorXplus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry));
        Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry item_ = (Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)carouselHoldingFilterSensor0, (long)item_.getCarouselHoldingFilterSensor0());
        Assert.assertEquals((long)carouselHoldingFilterSensor1, (long)item_.getCarouselHoldingFilterSensor1());
        Assert.assertEquals((long)carouselStoppedAtStandby, (long)item_.getCarouselStoppedAtStandby());
        Assert.assertEquals((long)carouselStoppedAtStandbyC, (long)item_.getCarouselStoppedAtStandbyC());
        Assert.assertEquals((long)carousel_CF0, (long)item_.getCarousel_CF0());
        Assert.assertEquals((long)carousel_CF0_C, (long)item_.getCarousel_CF0_C());
        Assert.assertEquals((long)carousel_CF1, (long)item_.getCarousel_CF1());
        Assert.assertEquals((long)carousel_CF1_C, (long)item_.getCarousel_CF1_C());
        Assert.assertEquals((long)closeSensorBLatchXminus, (long)item_.getCloseSensorBLatchXminus());
        Assert.assertEquals((long)closeSensorBLatchXplus, (long)item_.getCloseSensorBLatchXplus());
        Assert.assertEquals((long)closeSensorLatchXminus, (long)item_.getCloseSensorLatchXminus());
        Assert.assertEquals((long)closeSensorLatchXplus, (long)item_.getCloseSensorLatchXplus());
        Assert.assertEquals((long)engineeringKey, (long)item_.getEngineeringKey());
        Assert.assertEquals((long)engineeringkey_C, (long)item_.getEngineeringkey_C());
        Assert.assertEquals((long)filterEngagedSensorBLatchXminus, (long)item_.getFilterEngagedSensorBLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorBLatchXplus, (long)item_.getFilterEngagedSensorBLatchXplus());
        Assert.assertEquals((long)filterEngagedSensorLatchXminus, (long)item_.getFilterEngagedSensorLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorLatchXplus, (long)item_.getFilterEngagedSensorLatchXplus());
        Assert.assertEquals((long)filterIDSensor0, (long)item_.getFilterIDSensor0());
        Assert.assertEquals((long)filterIDSensor1, (long)item_.getFilterIDSensor1());
        Assert.assertEquals((long)filterIDSensor2, (long)item_.getFilterIDSensor2());
        Assert.assertEquals((long)filterIDSensor3, (long)item_.getFilterIDSensor3());
        Assert.assertEquals((long)filterIDSensor4, (long)item_.getFilterIDSensor4());
        Assert.assertEquals((long)filterIDSensor5, (long)item_.getFilterIDSensor5());
        Assert.assertEquals((long)handoffPositionSensorBXminus, (long)item_.getHandoffPositionSensorBXminus());
        Assert.assertEquals((long)handoffPositionSensorBXplus, (long)item_.getHandoffPositionSensorBXplus());
        Assert.assertEquals((long)handoffPositionSensorXminus, (long)item_.getHandoffPositionSensorXminus());
        Assert.assertEquals((long)handoffPositionSensorXplus, (long)item_.getHandoffPositionSensorXplus());
        Assert.assertEquals((double)inclinometerXminus, (double)item_.getInclinometerXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinometerXplus, (double)item_.getInclinometerXplus(), (double)1.0E-6f);
        Assert.assertEquals((long)loaderConnectedSensor, (long)item_.getLoaderConnectedSensor());
        Assert.assertEquals((long)loaderConnectedSensorC, (long)item_.getLoaderConnectedSensorC());
        Assert.assertEquals((long)loaderHoldingFilterSensor0, (long)item_.getLoaderHoldingFilterSensor0());
        Assert.assertEquals((long)loaderHoldingFilterSensor1, (long)item_.getLoaderHoldingFilterSensor1());
        Assert.assertEquals((long)lockOut, (long)item_.getLockOut());
        Assert.assertEquals((long)lockOutShunt, (long)item_.getLockOutShunt());
        Assert.assertEquals((long)lockout_C, (long)item_.getLockout_C());
        Assert.assertEquals((long)lpmLatchesStatus, (long)item_.getLpmLatchesStatus());
        Assert.assertEquals((long)lpmLinearRail1Status, (long)item_.getLpmLinearRail1Status());
        Assert.assertEquals((long)lpmLinearRail2Status, (long)item_.getLpmLinearRail2Status());
        Assert.assertEquals((long)lpmOnlineClampsStatus, (long)item_.getLpmOnlineClampsStatus());
        Assert.assertEquals((long)out_AF0, (long)item_.getOut_AF0());
        Assert.assertEquals((long)out_AF0_C, (long)item_.getOut_AF0_C());
        Assert.assertEquals((long)out_AF1, (long)item_.getOut_AF1());
        Assert.assertEquals((long)out_AF1_C, (long)item_.getOut_AF1_C());
        Assert.assertEquals((long)out_AF3, (long)item_.getOut_AF3());
        Assert.assertEquals((long)out_AF3_C, (long)item_.getOut_AF3_C());
        Assert.assertEquals((long)out_AIN, (long)item_.getOut_AIN());
        Assert.assertEquals((long)out_AOL, (long)item_.getOut_AOL());
        Assert.assertEquals((long)out_AP1, (long)item_.getOut_AP1());
        Assert.assertEquals((long)out_AP1_C, (long)item_.getOut_AP1_C());
        Assert.assertEquals((long)out_AP2, (long)item_.getOut_AP2());
        Assert.assertEquals((long)out_AP2_C, (long)item_.getOut_AP2_C());
        Assert.assertEquals((long)out_AP3, (long)item_.getOut_AP3());
        Assert.assertEquals((long)out_AP3_C, (long)item_.getOut_AP3_C());
        Assert.assertEquals((long)onlineClampXminusCloseSensor, (long)item_.getOnlineClampXminusCloseSensor());
        Assert.assertEquals((long)onlineClampXminusCloseSensorC, (long)item_.getOnlineClampXminusCloseSensorC());
        Assert.assertEquals((long)onlineClampXminusOpenSensor, (long)item_.getOnlineClampXminusOpenSensor());
        Assert.assertEquals((long)onlineClampXminusOpenSensorC, (long)item_.getOnlineClampXminusOpenSensorC());
        Assert.assertEquals((long)onlineClampXplusCloseSensor, (long)item_.getOnlineClampXplusCloseSensor());
        Assert.assertEquals((long)onlineClampXplusCloseSensorC, (long)item_.getOnlineClampXplusCloseSensorC());
        Assert.assertEquals((long)onlineClampXplusOpenSensor, (long)item_.getOnlineClampXplusOpenSensor());
        Assert.assertEquals((long)onlineClampXplusOpenSensorC, (long)item_.getOnlineClampXplusOpenSensorC());
        Assert.assertEquals((long)onlineClampYminusCloseSensor, (long)item_.getOnlineClampYminusCloseSensor());
        Assert.assertEquals((long)onlineClampYminusCloseSensorC, (long)item_.getOnlineClampYminusCloseSensorC());
        Assert.assertEquals((long)onlineClampYminusOpenSensor, (long)item_.getOnlineClampYminusOpenSensor());
        Assert.assertEquals((long)onlineClampYminusOpenSensorC, (long)item_.getOnlineClampYminusOpenSensorC());
        Assert.assertEquals((long)onlinePositionSensorBXminus, (long)item_.getOnlinePositionSensorBXminus());
        Assert.assertEquals((long)onlinePositionSensorBXplus, (long)item_.getOnlinePositionSensorBXplus());
        Assert.assertEquals((long)onlinePositionSensorXminus, (long)item_.getOnlinePositionSensorXminus());
        Assert.assertEquals((long)onlinePositionSensorXplus, (long)item_.getOnlinePositionSensorXplus());
        Assert.assertEquals((long)openSensorBLatchXminus, (long)item_.getOpenSensorBLatchXminus());
        Assert.assertEquals((long)openSensorBLatchXplus, (long)item_.getOpenSensorBLatchXplus());
        Assert.assertEquals((long)openSensorLatchXminus, (long)item_.getOpenSensorLatchXminus());
        Assert.assertEquals((long)openSensorLatchXplus, (long)item_.getOpenSensorLatchXplus());
        Assert.assertEquals((long)presenceLoader, (long)item_.getPresenceLoader());
        Assert.assertEquals((long)presenceloader_C, (long)item_.getPresenceloader_C());
        Assert.assertEquals((long)standbyPositionSensorBXminus, (long)item_.getStandbyPositionSensorBXminus());
        Assert.assertEquals((long)standbyPositionSensorBXplus, (long)item_.getStandbyPositionSensorBXplus());
        Assert.assertEquals((long)standbyPositionSensorXminus, (long)item_.getStandbyPositionSensorXminus());
        Assert.assertEquals((long)standbyPositionSensorXplus, (long)item_.getStandbyPositionSensorXplus());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcTruckXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 416;
        boolean brakeActivated = false;
        int current = 411;
        int errorHistoryNB = 642;
        String errorRegister = "";
        int followingError = 747;
        boolean inError = false;
        int lastErrorCode = 79;
        String lastErrorName = "";
        String mode = "";
        int position = 465;
        long profileAcceleration = 472L;
        long profileDeceleration = 98L;
        long profileVelocity = 426L;
        String state = "";
        int velocity = 637;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry));
        Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcTruckXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 695;
        boolean brakeActivated = true;
        int current = 974;
        int errorHistoryNB = 536;
        String errorRegister = "";
        int followingError = 843;
        boolean inError = false;
        int lastErrorCode = 329;
        String lastErrorName = "w";
        String mode = "f";
        int position = 919;
        long profileAcceleration = 176L;
        long profileDeceleration = 722L;
        long profileVelocity = 770L;
        String state = "d";
        int velocity = 284;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry));
        Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Accelerobf_TrendingTelemetry() throws Exception {
        double accelerationX = 0.6775627136230469;
        double accelerationY = 0.8754173517227173;
        double accelerationZ = 0.16074371337890625;
        double airmass = 0.555881f;
        double angularVelocityX = 0.346576452255249;
        double angularVelocityY = 0.11497682332992554;
        double angularVelocityZ = 0.2686259150505066;
        double azimut = 0.4730901f;
        double elevation = 0.5016433000564575;
        int errorHistoryNB = 219;
        String errorRegister = "";
        double gravity = 0.6775134801864624;
        boolean inError = true;
        int lastErrorCode = 594;
        String lastErrorName = "";
        double normalizedAccelerationX = 0.2944047f;
        double normalizedAccelerationY = 0.17733114957809448;
        double normalizedAccelerationZ = 0.8883137702941895;
        double normalizedGravity = 0.46426987648010254;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Accelerobf_TrendingTelemetry(accelerationX, accelerationY, accelerationZ, airmass, angularVelocityX, angularVelocityY, angularVelocityZ, azimut, elevation, errorHistoryNB, errorRegister, gravity, inError, lastErrorCode, lastErrorName, normalizedAccelerationX, normalizedAccelerationY, normalizedAccelerationZ, normalizedGravity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Accelerobf_TrendingTelemetry));
        Fcs_Canbus0_Accelerobf_TrendingTelemetry item_ = (Fcs_Canbus0_Accelerobf_TrendingTelemetry)item;
        Assert.assertEquals((double)accelerationX, (double)item_.getAccelerationX(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationY, (double)item_.getAccelerationY(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationZ, (double)item_.getAccelerationZ(), (double)1.0E-6f);
        Assert.assertEquals((double)airmass, (double)item_.getAirmass(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityX, (double)item_.getAngularVelocityX(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityY, (double)item_.getAngularVelocityY(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityZ, (double)item_.getAngularVelocityZ(), (double)1.0E-6f);
        Assert.assertEquals((double)azimut, (double)item_.getAzimut(), (double)1.0E-6f);
        Assert.assertEquals((double)elevation, (double)item_.getElevation(), (double)1.0E-6f);
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((double)gravity, (double)item_.getGravity(), (double)1.0E-6f);
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((double)normalizedAccelerationX, (double)item_.getNormalizedAccelerationX(), (double)1.0E-6f);
        Assert.assertEquals((double)normalizedAccelerationY, (double)item_.getNormalizedAccelerationY(), (double)1.0E-6f);
        Assert.assertEquals((double)normalizedAccelerationZ, (double)item_.getNormalizedAccelerationZ(), (double)1.0E-6f);
        Assert.assertEquals((double)normalizedGravity, (double)item_.getNormalizedGravity(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Canbus0_Ai814_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 75;
        String errorRegister = "l";
        boolean inError = true;
        int lastErrorCode = 88;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Ai814_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Ai814_TrendingTelemetry));
        Fcs_Canbus0_Ai814_TrendingTelemetry item_ = (Fcs_Canbus0_Ai814_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_CarouselController_TrendingTelemetry() throws Exception {
        int averageCurrent = 374;
        boolean brakeActivated = false;
        int current = 596;
        int errorHistoryNB = 798;
        String errorRegister = "l";
        int followingError = 81;
        boolean inError = true;
        int lastErrorCode = 353;
        String lastErrorName = "";
        String mode = "y";
        int position = 170;
        int positionSensorType = 941;
        long profileAcceleration = 674L;
        long profileDeceleration = 896L;
        long profileVelocity = 766L;
        String state = "p";
        int velocity = 182;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_CarouselController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, positionSensorType, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_CarouselController_TrendingTelemetry));
        Fcs_Canbus0_CarouselController_TrendingTelemetry item_ = (Fcs_Canbus0_CarouselController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)positionSensorType, (long)item_.getPositionSensorType());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ClampXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 186;
        boolean brakeActivated = false;
        int current = 748;
        int errorHistoryNB = 499;
        String errorRegister = "q";
        int followingError = 994;
        boolean inError = true;
        int lastErrorCode = 856;
        String lastErrorName = "";
        String mode = "x";
        int position = 530;
        long profileAcceleration = 313L;
        long profileDeceleration = 519L;
        long profileVelocity = 853L;
        String state = "n";
        int velocity = 421;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ClampXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ClampXminusController_TrendingTelemetry));
        Fcs_Canbus0_ClampXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_ClampXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ClampXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 949;
        boolean brakeActivated = true;
        int current = 267;
        int errorHistoryNB = 763;
        String errorRegister = "";
        int followingError = 442;
        boolean inError = false;
        int lastErrorCode = 119;
        String lastErrorName = "o";
        String mode = "c";
        int position = 84;
        long profileAcceleration = 59L;
        long profileDeceleration = 890L;
        long profileVelocity = 255L;
        String state = "";
        int velocity = 377;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ClampXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ClampXplusController_TrendingTelemetry));
        Fcs_Canbus0_ClampXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_ClampXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Hyttc580_TrendingTelemetry() throws Exception {
        int plc_caAF3 = 68;
        int plc_caAF3b = 489;
        int plc_caAP1 = 962;
        int plc_caAP1b = 190;
        int plc_caAP2 = 321;
        int plc_caAP2b = 31;
        int plc_caAP3 = 210;
        int plc_caAP3b = 391;
        int plc_caBrakesActivated = 814;
        int plc_caCF0 = 823;
        int plc_caCF0b = 155;
        int plc_caCF1 = 875;
        int plc_caCF1b = 937;
        int plc_caCFC = 717;
        int plc_caCFCb = 13;
        int plc_caCS = 470;
        int plc_caCSb = 12;
        int plc_caEnableBrakes = 517;
        int plc_caEnableRotation = 161;
        int plc_caEnableShutter = 715;
        int plc_caEnableUnclamp = 303;
        int plc_caEng = 733;
        int plc_caEngb = 874;
        int plc_caLockout = 45;
        int plc_caLockoutb = 580;
        int plc_caShutterInactive = 240;
        int plc_caSleep = 211;
        int plc_enableShutterInterlock = 234;
        int plc_okDI = 636;
        int plc_okDIsafety = 184;
        int plc_powerSave = 963;
        int plc_tpCheckRotation = 917;
        int plc_tpStopRotation = 727;
        int plc_tpStopUnclamp = 907;
        double temperatures_averageClamps = 0.5221702456474304;
        double temperatures_internalHYTTC580 = 0.8500064611434937;
        double temperatures_socket1 = 0.6362707614898682;
        double temperatures_socket2 = 0.413291335105896;
        double temperatures_socket3 = 0.1438995f;
        double temperatures_socket4 = 0.4757162928581238;
        double temperatures_socket5 = 0.24312984943389893;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Hyttc580_TrendingTelemetry(plc_caAF3, plc_caAF3b, plc_caAP1, plc_caAP1b, plc_caAP2, plc_caAP2b, plc_caAP3, plc_caAP3b, plc_caBrakesActivated, plc_caCF0, plc_caCF0b, plc_caCF1, plc_caCF1b, plc_caCFC, plc_caCFCb, plc_caCS, plc_caCSb, plc_caEnableBrakes, plc_caEnableRotation, plc_caEnableShutter, plc_caEnableUnclamp, plc_caEng, plc_caEngb, plc_caLockout, plc_caLockoutb, plc_caShutterInactive, plc_caSleep, plc_enableShutterInterlock, plc_okDI, plc_okDIsafety, plc_powerSave, plc_tpCheckRotation, plc_tpStopRotation, plc_tpStopUnclamp, temperatures_averageClamps, temperatures_internalHYTTC580, temperatures_socket1, temperatures_socket2, temperatures_socket3, temperatures_socket4, temperatures_socket5));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Hyttc580_TrendingTelemetry));
        Fcs_Canbus0_Hyttc580_TrendingTelemetry item_ = (Fcs_Canbus0_Hyttc580_TrendingTelemetry)item;
        Assert.assertEquals((long)plc_caAF3, (long)item_.getPlc_caAF3());
        Assert.assertEquals((long)plc_caAF3b, (long)item_.getPlc_caAF3b());
        Assert.assertEquals((long)plc_caAP1, (long)item_.getPlc_caAP1());
        Assert.assertEquals((long)plc_caAP1b, (long)item_.getPlc_caAP1b());
        Assert.assertEquals((long)plc_caAP2, (long)item_.getPlc_caAP2());
        Assert.assertEquals((long)plc_caAP2b, (long)item_.getPlc_caAP2b());
        Assert.assertEquals((long)plc_caAP3, (long)item_.getPlc_caAP3());
        Assert.assertEquals((long)plc_caAP3b, (long)item_.getPlc_caAP3b());
        Assert.assertEquals((long)plc_caBrakesActivated, (long)item_.getPlc_caBrakesActivated());
        Assert.assertEquals((long)plc_caCF0, (long)item_.getPlc_caCF0());
        Assert.assertEquals((long)plc_caCF0b, (long)item_.getPlc_caCF0b());
        Assert.assertEquals((long)plc_caCF1, (long)item_.getPlc_caCF1());
        Assert.assertEquals((long)plc_caCF1b, (long)item_.getPlc_caCF1b());
        Assert.assertEquals((long)plc_caCFC, (long)item_.getPlc_caCFC());
        Assert.assertEquals((long)plc_caCFCb, (long)item_.getPlc_caCFCb());
        Assert.assertEquals((long)plc_caCS, (long)item_.getPlc_caCS());
        Assert.assertEquals((long)plc_caCSb, (long)item_.getPlc_caCSb());
        Assert.assertEquals((long)plc_caEnableBrakes, (long)item_.getPlc_caEnableBrakes());
        Assert.assertEquals((long)plc_caEnableRotation, (long)item_.getPlc_caEnableRotation());
        Assert.assertEquals((long)plc_caEnableShutter, (long)item_.getPlc_caEnableShutter());
        Assert.assertEquals((long)plc_caEnableUnclamp, (long)item_.getPlc_caEnableUnclamp());
        Assert.assertEquals((long)plc_caEng, (long)item_.getPlc_caEng());
        Assert.assertEquals((long)plc_caEngb, (long)item_.getPlc_caEngb());
        Assert.assertEquals((long)plc_caLockout, (long)item_.getPlc_caLockout());
        Assert.assertEquals((long)plc_caLockoutb, (long)item_.getPlc_caLockoutb());
        Assert.assertEquals((long)plc_caShutterInactive, (long)item_.getPlc_caShutterInactive());
        Assert.assertEquals((long)plc_caSleep, (long)item_.getPlc_caSleep());
        Assert.assertEquals((long)plc_enableShutterInterlock, (long)item_.getPlc_enableShutterInterlock());
        Assert.assertEquals((long)plc_okDI, (long)item_.getPlc_okDI());
        Assert.assertEquals((long)plc_okDIsafety, (long)item_.getPlc_okDIsafety());
        Assert.assertEquals((long)plc_powerSave, (long)item_.getPlc_powerSave());
        Assert.assertEquals((long)plc_tpCheckRotation, (long)item_.getPlc_tpCheckRotation());
        Assert.assertEquals((long)plc_tpStopRotation, (long)item_.getPlc_tpStopRotation());
        Assert.assertEquals((long)plc_tpStopUnclamp, (long)item_.getPlc_tpStopUnclamp());
        Assert.assertEquals((double)temperatures_averageClamps, (double)item_.getTemperatures_averageClamps(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_internalHYTTC580, (double)item_.getTemperatures_internalHYTTC580(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_socket1, (double)item_.getTemperatures_socket1(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_socket2, (double)item_.getTemperatures_socket2(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_socket3, (double)item_.getTemperatures_socket3(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_socket4, (double)item_.getTemperatures_socket4(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_socket5, (double)item_.getTemperatures_socket5(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Canbus0_LatchXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 367;
        boolean brakeActivated = true;
        int current = 735;
        int errorHistoryNB = 977;
        String errorRegister = "";
        int followingError = 628;
        boolean inError = true;
        int lastErrorCode = 706;
        String lastErrorName = "p";
        String mode = "";
        int position = 842;
        long profileAcceleration = 166L;
        long profileDeceleration = 161L;
        long profileVelocity = 16L;
        String state = "q";
        int velocity = 903;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_LatchXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_LatchXminusController_TrendingTelemetry));
        Fcs_Canbus0_LatchXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_LatchXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_LatchXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 186;
        boolean brakeActivated = true;
        int current = 186;
        int errorHistoryNB = 303;
        String errorRegister = "b";
        int followingError = 374;
        boolean inError = true;
        int lastErrorCode = 932;
        String lastErrorName = "m";
        String mode = "";
        int position = 338;
        long profileAcceleration = 648L;
        long profileDeceleration = 925L;
        long profileVelocity = 524L;
        String state = "";
        int velocity = 913;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_LatchXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_LatchXplusController_TrendingTelemetry));
        Fcs_Canbus0_LatchXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_LatchXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 62;
        boolean brakeActivated = false;
        int current = 105;
        int errorHistoryNB = 896;
        String errorRegister = "b";
        int followingError = 980;
        boolean inError = true;
        int lastErrorCode = 881;
        String lastErrorName = "o";
        String mode = "m";
        int position = 195;
        long profileAcceleration = 654L;
        long profileDeceleration = 581L;
        long profileVelocity = 969L;
        String state = "y";
        int velocity = 988;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 117;
        boolean brakeActivated = false;
        int current = 781;
        int errorHistoryNB = 641;
        String errorRegister = "";
        int followingError = 140;
        boolean inError = true;
        int lastErrorCode = 500;
        String lastErrorName = "k";
        String mode = "";
        int position = 781;
        long profileAcceleration = 247L;
        long profileDeceleration = 287L;
        long profileVelocity = 679L;
        String state = "";
        int velocity = 152;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampYminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 206;
        boolean brakeActivated = false;
        int current = 438;
        int errorHistoryNB = 143;
        String errorRegister = "s";
        int followingError = 614;
        boolean inError = true;
        int lastErrorCode = 92;
        String lastErrorName = "l";
        String mode = "";
        int position = 851;
        long profileAcceleration = 373L;
        long profileDeceleration = 159L;
        long profileVelocity = 363L;
        String state = "p";
        int velocity = 346;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineStrainGauge_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 2;
        String errorRegister = "";
        boolean inError = true;
        int lastErrorCode = 176;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry));
        Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 247;
        String errorRegister = "v";
        boolean inError = true;
        int lastErrorCode = 988;
        String lastErrorName = "u";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry));
        Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry item_ = (Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Pt100_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 481;
        String errorRegister = "";
        boolean inError = true;
        int lastErrorCode = 40;
        String lastErrorName = "b";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Pt100_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Pt100_TrendingTelemetry));
        Fcs_Canbus0_Pt100_TrendingTelemetry item_ = (Fcs_Canbus0_Pt100_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_TempSensorsDevice1_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 945;
        String errorRegister = "c";
        boolean inError = false;
        int lastErrorCode = 864;
        String lastErrorName = "s";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry));
        Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry item_ = (Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_TempSensorsDevice2_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 19;
        String errorRegister = "k";
        boolean inError = true;
        int lastErrorCode = 278;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry));
        Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry item_ = (Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus1_CarrierController_TrendingTelemetry() throws Exception {
        int averageCurrent = 102;
        boolean brakeActivated = false;
        int current = 214;
        int errorHistoryNB = 292;
        String errorRegister = "o";
        int followingError = 331;
        boolean inError = false;
        int lastErrorCode = 641;
        String lastErrorName = "c";
        String mode = "";
        int position = 421;
        long profileAcceleration = 129L;
        long profileDeceleration = 813L;
        long profileVelocity = 643L;
        String state = "";
        int velocity = 266;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_CarrierController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_CarrierController_TrendingTelemetry));
        Fcs_Canbus1_CarrierController_TrendingTelemetry item_ = (Fcs_Canbus1_CarrierController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus1_HooksController_TrendingTelemetry() throws Exception {
        int averageCurrent = 753;
        boolean brakeActivated = false;
        int current = 501;
        int errorHistoryNB = 993;
        String errorRegister = "";
        int followingError = 212;
        boolean inError = true;
        int lastErrorCode = 784;
        String lastErrorName = "m";
        String mode = "e";
        int position = 830;
        long profileAcceleration = 650L;
        long profileDeceleration = 905L;
        long profileVelocity = 38L;
        String state = "";
        int velocity = 529;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_HooksController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_HooksController_TrendingTelemetry));
        Fcs_Canbus1_HooksController_TrendingTelemetry item_ = (Fcs_Canbus1_HooksController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry() throws Exception {
        int acAF0b = 134;
        int acAF0s = 845;
        int acAF1b = 221;
        int acAF1s = 278;
        int acAF3b = 482;
        int acAF3s = 585;
        int acAP2b = 127;
        int acAP2s = 435;
        int clampedStatusSensor = 614;
        int forceSensor0 = 27;
        int forceSensor1 = 290;
        int keyEng = 528;
        int keyEngb = 127;
        int keyLock = 990;
        int keyLockb = 54;
        int lps_0 = 152;
        int lps_1 = 677;
        int lrh_0 = 604;
        int lrh_1 = 220;
        int loaderCarrierRelayStatus = 685;
        int loaderChainPresenceSensor = 968;
        int loaderCloseSensor1 = 5;
        int loaderCloseSensor2 = 618;
        int loaderCloseSensor3 = 513;
        int loaderCloseSensor4 = 261;
        int loaderDefaultStatus = 982;
        int loaderEngagedPositionSensor0 = 696;
        int loaderEngagedPositionSensor1 = 859;
        int loaderFilterDistanceSensor = 478;
        int loaderFilterGoodPositionStatus = 122;
        int loaderFilterPresenceSensor0 = 56;
        int loaderFilterPresenceSensor1 = 418;
        int loaderHandoffPositionSensor0 = 432;
        int loaderHandoffPositionSensor1 = 440;
        int loaderHooksRelayStatus = 307;
        int loaderOnCameraSensor0 = 153;
        int loaderOnCameraSensor1 = 478;
        int loaderOpenSensor1 = 800;
        int loaderOpenSensor2 = 29;
        int loaderOpenSensor3 = 495;
        int loaderOpenSensor4 = 755;
        int loaderStoragePositionSensor0 = 963;
        int loaderStoragePositionSensor1 = 346;
        int loader_LFD = 930;
        int loader_LFS = 468;
        int overClampedStatusSensor = 86;
        int unclampedStatusSensor = 219;
        int underClampedStatusSensor = 919;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry(acAF0b, acAF0s, acAF1b, acAF1s, acAF3b, acAF3s, acAP2b, acAP2s, clampedStatusSensor, forceSensor0, forceSensor1, keyEng, keyEngb, keyLock, keyLockb, lps_0, lps_1, lrh_0, lrh_1, loaderCarrierRelayStatus, loaderChainPresenceSensor, loaderCloseSensor1, loaderCloseSensor2, loaderCloseSensor3, loaderCloseSensor4, loaderDefaultStatus, loaderEngagedPositionSensor0, loaderEngagedPositionSensor1, loaderFilterDistanceSensor, loaderFilterGoodPositionStatus, loaderFilterPresenceSensor0, loaderFilterPresenceSensor1, loaderHandoffPositionSensor0, loaderHandoffPositionSensor1, loaderHooksRelayStatus, loaderOnCameraSensor0, loaderOnCameraSensor1, loaderOpenSensor1, loaderOpenSensor2, loaderOpenSensor3, loaderOpenSensor4, loaderStoragePositionSensor0, loaderStoragePositionSensor1, loader_LFD, loader_LFS, overClampedStatusSensor, unclampedStatusSensor, underClampedStatusSensor));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry));
        Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry item_ = (Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)acAF0b, (long)item_.getAcAF0b());
        Assert.assertEquals((long)acAF0s, (long)item_.getAcAF0s());
        Assert.assertEquals((long)acAF1b, (long)item_.getAcAF1b());
        Assert.assertEquals((long)acAF1s, (long)item_.getAcAF1s());
        Assert.assertEquals((long)acAF3b, (long)item_.getAcAF3b());
        Assert.assertEquals((long)acAF3s, (long)item_.getAcAF3s());
        Assert.assertEquals((long)acAP2b, (long)item_.getAcAP2b());
        Assert.assertEquals((long)acAP2s, (long)item_.getAcAP2s());
        Assert.assertEquals((long)clampedStatusSensor, (long)item_.getClampedStatusSensor());
        Assert.assertEquals((long)forceSensor0, (long)item_.getForceSensor0());
        Assert.assertEquals((long)forceSensor1, (long)item_.getForceSensor1());
        Assert.assertEquals((long)keyEng, (long)item_.getKeyEng());
        Assert.assertEquals((long)keyEngb, (long)item_.getKeyEngb());
        Assert.assertEquals((long)keyLock, (long)item_.getKeyLock());
        Assert.assertEquals((long)keyLockb, (long)item_.getKeyLockb());
        Assert.assertEquals((long)lps_0, (long)item_.getLps_0());
        Assert.assertEquals((long)lps_1, (long)item_.getLps_1());
        Assert.assertEquals((long)lrh_0, (long)item_.getLrh_0());
        Assert.assertEquals((long)lrh_1, (long)item_.getLrh_1());
        Assert.assertEquals((long)loaderCarrierRelayStatus, (long)item_.getLoaderCarrierRelayStatus());
        Assert.assertEquals((long)loaderChainPresenceSensor, (long)item_.getLoaderChainPresenceSensor());
        Assert.assertEquals((long)loaderCloseSensor1, (long)item_.getLoaderCloseSensor1());
        Assert.assertEquals((long)loaderCloseSensor2, (long)item_.getLoaderCloseSensor2());
        Assert.assertEquals((long)loaderCloseSensor3, (long)item_.getLoaderCloseSensor3());
        Assert.assertEquals((long)loaderCloseSensor4, (long)item_.getLoaderCloseSensor4());
        Assert.assertEquals((long)loaderDefaultStatus, (long)item_.getLoaderDefaultStatus());
        Assert.assertEquals((long)loaderEngagedPositionSensor0, (long)item_.getLoaderEngagedPositionSensor0());
        Assert.assertEquals((long)loaderEngagedPositionSensor1, (long)item_.getLoaderEngagedPositionSensor1());
        Assert.assertEquals((long)loaderFilterDistanceSensor, (long)item_.getLoaderFilterDistanceSensor());
        Assert.assertEquals((long)loaderFilterGoodPositionStatus, (long)item_.getLoaderFilterGoodPositionStatus());
        Assert.assertEquals((long)loaderFilterPresenceSensor0, (long)item_.getLoaderFilterPresenceSensor0());
        Assert.assertEquals((long)loaderFilterPresenceSensor1, (long)item_.getLoaderFilterPresenceSensor1());
        Assert.assertEquals((long)loaderHandoffPositionSensor0, (long)item_.getLoaderHandoffPositionSensor0());
        Assert.assertEquals((long)loaderHandoffPositionSensor1, (long)item_.getLoaderHandoffPositionSensor1());
        Assert.assertEquals((long)loaderHooksRelayStatus, (long)item_.getLoaderHooksRelayStatus());
        Assert.assertEquals((long)loaderOnCameraSensor0, (long)item_.getLoaderOnCameraSensor0());
        Assert.assertEquals((long)loaderOnCameraSensor1, (long)item_.getLoaderOnCameraSensor1());
        Assert.assertEquals((long)loaderOpenSensor1, (long)item_.getLoaderOpenSensor1());
        Assert.assertEquals((long)loaderOpenSensor2, (long)item_.getLoaderOpenSensor2());
        Assert.assertEquals((long)loaderOpenSensor3, (long)item_.getLoaderOpenSensor3());
        Assert.assertEquals((long)loaderOpenSensor4, (long)item_.getLoaderOpenSensor4());
        Assert.assertEquals((long)loaderStoragePositionSensor0, (long)item_.getLoaderStoragePositionSensor0());
        Assert.assertEquals((long)loaderStoragePositionSensor1, (long)item_.getLoaderStoragePositionSensor1());
        Assert.assertEquals((long)loader_LFD, (long)item_.getLoader_LFD());
        Assert.assertEquals((long)loader_LFS, (long)item_.getLoader_LFS());
        Assert.assertEquals((long)overClampedStatusSensor, (long)item_.getOverClampedStatusSensor());
        Assert.assertEquals((long)unclampedStatusSensor, (long)item_.getUnclampedStatusSensor());
        Assert.assertEquals((long)underClampedStatusSensor, (long)item_.getUnderClampedStatusSensor());
    }

    @Test
    public void sendReceiveFcs_Carousel_Brakes_TrendingTelemetry() throws Exception {
        String brakeState1 = "";
        String brakeState2 = "t";
        String brakeState3 = "";
        long sensor1 = 880L;
        long sensor2 = 740L;
        long sensor3 = 370L;
        double temperature1 = 0.7205448150634766;
        double temperature2 = 0.4025585651397705;
        double temperature3 = 0.4894410967826843;
        double temperature4 = 0.5134505033493042;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Brakes_TrendingTelemetry(brakeState1, brakeState2, brakeState3, sensor1, sensor2, sensor3, temperature1, temperature2, temperature3, temperature4));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Brakes_TrendingTelemetry));
        Fcs_Carousel_Brakes_TrendingTelemetry item_ = (Fcs_Carousel_Brakes_TrendingTelemetry)item;
        Assert.assertEquals((Object)brakeState1, (Object)item_.getBrakeState1());
        Assert.assertEquals((Object)brakeState2, (Object)item_.getBrakeState2());
        Assert.assertEquals((Object)brakeState3, (Object)item_.getBrakeState3());
        Assert.assertEquals((long)sensor1, (long)item_.getSensor1());
        Assert.assertEquals((long)sensor2, (long)item_.getSensor2());
        Assert.assertEquals((long)sensor3, (long)item_.getSensor3());
        Assert.assertEquals((double)temperature1, (double)item_.getTemperature1(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature2, (double)item_.getTemperature2(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature3, (double)item_.getTemperature3(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature4, (double)item_.getTemperature4(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket1_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        boolean available = false;
        String clampxminus1_clampState = "";
        int clampxminus1_filterPositionSensorValue = 223;
        int clampxminus1_filterPresenceOffset2 = 788;
        String clampxminus1_filterPresenceStatus = "";
        int clampxminus1_lockSensorOffset1 = 455;
        int clampxminus1_lockSensorValue = 495;
        String clampxminus1_lockStatus = "c";
        String clampxplus1_clampState = "";
        int clampxplus1_filterPositionSensorValue = 439;
        int clampxplus1_filterPresenceOffset2 = 177;
        String clampxplus1_filterPresenceStatus = "a";
        int clampxplus1_lockSensorOffset1 = 899;
        int clampxplus1_lockSensorValue = 563;
        String clampxplus1_lockStatus = "x";
        String clampsState = "";
        boolean empty = false;
        int filterID = 258;
        String filterName = "";
        String ioStatus = "c";
        int socketID = 626;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket1_TrendingTelemetry(atStandby, available, clampxminus1_clampState, clampxminus1_filterPositionSensorValue, clampxminus1_filterPresenceOffset2, clampxminus1_filterPresenceStatus, clampxminus1_lockSensorOffset1, clampxminus1_lockSensorValue, clampxminus1_lockStatus, clampxplus1_clampState, clampxplus1_filterPositionSensorValue, clampxplus1_filterPresenceOffset2, clampxplus1_filterPresenceStatus, clampxplus1_lockSensorOffset1, clampxplus1_lockSensorValue, clampxplus1_lockStatus, clampsState, empty, filterID, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket1_TrendingTelemetry));
        Fcs_Carousel_Socket1_TrendingTelemetry item_ = (Fcs_Carousel_Socket1_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampxminus1_clampState, (Object)item_.getClampxminus1_clampState());
        Assert.assertEquals((long)clampxminus1_filterPositionSensorValue, (long)item_.getClampxminus1_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus1_filterPresenceOffset2, (long)item_.getClampxminus1_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus1_filterPresenceStatus, (Object)item_.getClampxminus1_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus1_lockSensorOffset1, (long)item_.getClampxminus1_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus1_lockSensorValue, (long)item_.getClampxminus1_lockSensorValue());
        Assert.assertEquals((Object)clampxminus1_lockStatus, (Object)item_.getClampxminus1_lockStatus());
        Assert.assertEquals((Object)clampxplus1_clampState, (Object)item_.getClampxplus1_clampState());
        Assert.assertEquals((long)clampxplus1_filterPositionSensorValue, (long)item_.getClampxplus1_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus1_filterPresenceOffset2, (long)item_.getClampxplus1_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus1_filterPresenceStatus, (Object)item_.getClampxplus1_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus1_lockSensorOffset1, (long)item_.getClampxplus1_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus1_lockSensorValue, (long)item_.getClampxplus1_lockSensorValue());
        Assert.assertEquals((Object)clampxplus1_lockStatus, (Object)item_.getClampxplus1_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket2_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        boolean available = true;
        String clampxminus2_clampState = "j";
        int clampxminus2_filterPositionSensorValue = 950;
        int clampxminus2_filterPresenceOffset2 = 666;
        String clampxminus2_filterPresenceStatus = "";
        int clampxminus2_lockSensorOffset1 = 963;
        int clampxminus2_lockSensorValue = 936;
        String clampxminus2_lockStatus = "l";
        String clampxplus2_clampState = "";
        int clampxplus2_filterPositionSensorValue = 607;
        int clampxplus2_filterPresenceOffset2 = 806;
        String clampxplus2_filterPresenceStatus = "";
        int clampxplus2_lockSensorOffset1 = 314;
        int clampxplus2_lockSensorValue = 181;
        String clampxplus2_lockStatus = "";
        String clampsState = "s";
        boolean empty = false;
        int filterID = 239;
        String filterName = "";
        String ioStatus = "";
        int socketID = 132;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket2_TrendingTelemetry(atStandby, available, clampxminus2_clampState, clampxminus2_filterPositionSensorValue, clampxminus2_filterPresenceOffset2, clampxminus2_filterPresenceStatus, clampxminus2_lockSensorOffset1, clampxminus2_lockSensorValue, clampxminus2_lockStatus, clampxplus2_clampState, clampxplus2_filterPositionSensorValue, clampxplus2_filterPresenceOffset2, clampxplus2_filterPresenceStatus, clampxplus2_lockSensorOffset1, clampxplus2_lockSensorValue, clampxplus2_lockStatus, clampsState, empty, filterID, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket2_TrendingTelemetry));
        Fcs_Carousel_Socket2_TrendingTelemetry item_ = (Fcs_Carousel_Socket2_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampxminus2_clampState, (Object)item_.getClampxminus2_clampState());
        Assert.assertEquals((long)clampxminus2_filterPositionSensorValue, (long)item_.getClampxminus2_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus2_filterPresenceOffset2, (long)item_.getClampxminus2_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus2_filterPresenceStatus, (Object)item_.getClampxminus2_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus2_lockSensorOffset1, (long)item_.getClampxminus2_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus2_lockSensorValue, (long)item_.getClampxminus2_lockSensorValue());
        Assert.assertEquals((Object)clampxminus2_lockStatus, (Object)item_.getClampxminus2_lockStatus());
        Assert.assertEquals((Object)clampxplus2_clampState, (Object)item_.getClampxplus2_clampState());
        Assert.assertEquals((long)clampxplus2_filterPositionSensorValue, (long)item_.getClampxplus2_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus2_filterPresenceOffset2, (long)item_.getClampxplus2_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus2_filterPresenceStatus, (Object)item_.getClampxplus2_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus2_lockSensorOffset1, (long)item_.getClampxplus2_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus2_lockSensorValue, (long)item_.getClampxplus2_lockSensorValue());
        Assert.assertEquals((Object)clampxplus2_lockStatus, (Object)item_.getClampxplus2_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket3_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        boolean available = true;
        String clampxminus3_clampState = "";
        int clampxminus3_filterPositionSensorValue = 799;
        int clampxminus3_filterPresenceOffset2 = 912;
        String clampxminus3_filterPresenceStatus = "d";
        int clampxminus3_lockSensorOffset1 = 869;
        int clampxminus3_lockSensorValue = 573;
        String clampxminus3_lockStatus = "";
        String clampxplus3_clampState = "";
        int clampxplus3_filterPositionSensorValue = 592;
        int clampxplus3_filterPresenceOffset2 = 954;
        String clampxplus3_filterPresenceStatus = "w";
        int clampxplus3_lockSensorOffset1 = 851;
        int clampxplus3_lockSensorValue = 115;
        String clampxplus3_lockStatus = "";
        String clampsState = "";
        boolean empty = false;
        int filterID = 244;
        String filterName = "";
        String ioStatus = "";
        int socketID = 386;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket3_TrendingTelemetry(atStandby, available, clampxminus3_clampState, clampxminus3_filterPositionSensorValue, clampxminus3_filterPresenceOffset2, clampxminus3_filterPresenceStatus, clampxminus3_lockSensorOffset1, clampxminus3_lockSensorValue, clampxminus3_lockStatus, clampxplus3_clampState, clampxplus3_filterPositionSensorValue, clampxplus3_filterPresenceOffset2, clampxplus3_filterPresenceStatus, clampxplus3_lockSensorOffset1, clampxplus3_lockSensorValue, clampxplus3_lockStatus, clampsState, empty, filterID, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket3_TrendingTelemetry));
        Fcs_Carousel_Socket3_TrendingTelemetry item_ = (Fcs_Carousel_Socket3_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampxminus3_clampState, (Object)item_.getClampxminus3_clampState());
        Assert.assertEquals((long)clampxminus3_filterPositionSensorValue, (long)item_.getClampxminus3_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus3_filterPresenceOffset2, (long)item_.getClampxminus3_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus3_filterPresenceStatus, (Object)item_.getClampxminus3_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus3_lockSensorOffset1, (long)item_.getClampxminus3_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus3_lockSensorValue, (long)item_.getClampxminus3_lockSensorValue());
        Assert.assertEquals((Object)clampxminus3_lockStatus, (Object)item_.getClampxminus3_lockStatus());
        Assert.assertEquals((Object)clampxplus3_clampState, (Object)item_.getClampxplus3_clampState());
        Assert.assertEquals((long)clampxplus3_filterPositionSensorValue, (long)item_.getClampxplus3_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus3_filterPresenceOffset2, (long)item_.getClampxplus3_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus3_filterPresenceStatus, (Object)item_.getClampxplus3_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus3_lockSensorOffset1, (long)item_.getClampxplus3_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus3_lockSensorValue, (long)item_.getClampxplus3_lockSensorValue());
        Assert.assertEquals((Object)clampxplus3_lockStatus, (Object)item_.getClampxplus3_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket4_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        boolean available = true;
        String clampxminus4_clampState = "";
        int clampxminus4_filterPositionSensorValue = 173;
        int clampxminus4_filterPresenceOffset2 = 707;
        String clampxminus4_filterPresenceStatus = "";
        int clampxminus4_lockSensorOffset1 = 561;
        int clampxminus4_lockSensorValue = 393;
        String clampxminus4_lockStatus = "";
        String clampxplus4_clampState = "l";
        int clampxplus4_filterPositionSensorValue = 574;
        int clampxplus4_filterPresenceOffset2 = 850;
        String clampxplus4_filterPresenceStatus = "d";
        int clampxplus4_lockSensorOffset1 = 976;
        int clampxplus4_lockSensorValue = 592;
        String clampxplus4_lockStatus = "";
        String clampsState = "";
        boolean empty = false;
        int filterID = 835;
        String filterName = "c";
        String ioStatus = "u";
        int socketID = 150;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket4_TrendingTelemetry(atStandby, available, clampxminus4_clampState, clampxminus4_filterPositionSensorValue, clampxminus4_filterPresenceOffset2, clampxminus4_filterPresenceStatus, clampxminus4_lockSensorOffset1, clampxminus4_lockSensorValue, clampxminus4_lockStatus, clampxplus4_clampState, clampxplus4_filterPositionSensorValue, clampxplus4_filterPresenceOffset2, clampxplus4_filterPresenceStatus, clampxplus4_lockSensorOffset1, clampxplus4_lockSensorValue, clampxplus4_lockStatus, clampsState, empty, filterID, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket4_TrendingTelemetry));
        Fcs_Carousel_Socket4_TrendingTelemetry item_ = (Fcs_Carousel_Socket4_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampxminus4_clampState, (Object)item_.getClampxminus4_clampState());
        Assert.assertEquals((long)clampxminus4_filterPositionSensorValue, (long)item_.getClampxminus4_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus4_filterPresenceOffset2, (long)item_.getClampxminus4_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus4_filterPresenceStatus, (Object)item_.getClampxminus4_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus4_lockSensorOffset1, (long)item_.getClampxminus4_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus4_lockSensorValue, (long)item_.getClampxminus4_lockSensorValue());
        Assert.assertEquals((Object)clampxminus4_lockStatus, (Object)item_.getClampxminus4_lockStatus());
        Assert.assertEquals((Object)clampxplus4_clampState, (Object)item_.getClampxplus4_clampState());
        Assert.assertEquals((long)clampxplus4_filterPositionSensorValue, (long)item_.getClampxplus4_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus4_filterPresenceOffset2, (long)item_.getClampxplus4_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus4_filterPresenceStatus, (Object)item_.getClampxplus4_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus4_lockSensorOffset1, (long)item_.getClampxplus4_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus4_lockSensorValue, (long)item_.getClampxplus4_lockSensorValue());
        Assert.assertEquals((Object)clampxplus4_lockStatus, (Object)item_.getClampxplus4_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket5_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        boolean available = false;
        String clampxminus5_clampState = "";
        int clampxminus5_filterPositionSensorValue = 967;
        int clampxminus5_filterPresenceOffset2 = 271;
        String clampxminus5_filterPresenceStatus = "";
        int clampxminus5_lockSensorOffset1 = 248;
        int clampxminus5_lockSensorValue = 786;
        String clampxminus5_lockStatus = "";
        String clampxplus5_clampState = "t";
        int clampxplus5_filterPositionSensorValue = 305;
        int clampxplus5_filterPresenceOffset2 = 50;
        String clampxplus5_filterPresenceStatus = "";
        int clampxplus5_lockSensorOffset1 = 873;
        int clampxplus5_lockSensorValue = 86;
        String clampxplus5_lockStatus = "";
        String clampsState = "";
        boolean empty = true;
        int filterID = 254;
        String filterName = "";
        String ioStatus = "z";
        int socketID = 51;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket5_TrendingTelemetry(atStandby, available, clampxminus5_clampState, clampxminus5_filterPositionSensorValue, clampxminus5_filterPresenceOffset2, clampxminus5_filterPresenceStatus, clampxminus5_lockSensorOffset1, clampxminus5_lockSensorValue, clampxminus5_lockStatus, clampxplus5_clampState, clampxplus5_filterPositionSensorValue, clampxplus5_filterPresenceOffset2, clampxplus5_filterPresenceStatus, clampxplus5_lockSensorOffset1, clampxplus5_lockSensorValue, clampxplus5_lockStatus, clampsState, empty, filterID, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket5_TrendingTelemetry));
        Fcs_Carousel_Socket5_TrendingTelemetry item_ = (Fcs_Carousel_Socket5_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampxminus5_clampState, (Object)item_.getClampxminus5_clampState());
        Assert.assertEquals((long)clampxminus5_filterPositionSensorValue, (long)item_.getClampxminus5_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus5_filterPresenceOffset2, (long)item_.getClampxminus5_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus5_filterPresenceStatus, (Object)item_.getClampxminus5_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus5_lockSensorOffset1, (long)item_.getClampxminus5_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus5_lockSensorValue, (long)item_.getClampxminus5_lockSensorValue());
        Assert.assertEquals((Object)clampxminus5_lockStatus, (Object)item_.getClampxminus5_lockStatus());
        Assert.assertEquals((Object)clampxplus5_clampState, (Object)item_.getClampxplus5_clampState());
        Assert.assertEquals((long)clampxplus5_filterPositionSensorValue, (long)item_.getClampxplus5_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus5_filterPresenceOffset2, (long)item_.getClampxplus5_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus5_filterPresenceStatus, (Object)item_.getClampxplus5_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus5_lockSensorOffset1, (long)item_.getClampxplus5_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus5_lockSensorValue, (long)item_.getClampxplus5_lockSensorValue());
        Assert.assertEquals((Object)clampxplus5_lockStatus, (Object)item_.getClampxplus5_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        boolean available = true;
        String clampsStateAtStandby = "e";
        int deltaPositionAtStandby = 389;
        boolean emptyAtStandby = false;
        int estimatedPosition = 360;
        int filterAtStandbyID = 147;
        String filterOnAutochangerName = "c";
        long minLocked = 787L;
        int socketAtStandbyID = 154;
        String socketAtStandbyName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_TrendingTelemetry(atStandby, available, clampsStateAtStandby, deltaPositionAtStandby, emptyAtStandby, estimatedPosition, filterAtStandbyID, filterOnAutochangerName, minLocked, socketAtStandbyID, socketAtStandbyName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_TrendingTelemetry));
        Fcs_Carousel_TrendingTelemetry item_ = (Fcs_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampsStateAtStandby, (Object)item_.getClampsStateAtStandby());
        Assert.assertEquals((long)deltaPositionAtStandby, (long)item_.getDeltaPositionAtStandby());
        Assert.assertEquals((Object)emptyAtStandby, (Object)item_.isEmptyAtStandby());
        Assert.assertEquals((long)estimatedPosition, (long)item_.getEstimatedPosition());
        Assert.assertEquals((long)filterAtStandbyID, (long)item_.getFilterAtStandbyID());
        Assert.assertEquals((Object)filterOnAutochangerName, (Object)item_.getFilterOnAutochangerName());
        Assert.assertEquals((long)minLocked, (long)item_.getMinLocked());
        Assert.assertEquals((long)socketAtStandbyID, (long)item_.getSocketAtStandbyID());
        Assert.assertEquals((Object)socketAtStandbyName, (Object)item_.getSocketAtStandbyName());
    }

    @Test
    public void sendReceiveFcs_Counters_Autochanger_TrendingTelemetry() throws Exception {
        double autochangertrucks_ALIGN_FOLLOWER = 0.7235399484634399;
        double autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE = 0.009542524814605713;
        double autochangertrucks_MOVE_TO_ABSOLUTE_POSITION = 0.8124440908432007;
        double latches_latchXminus_CLOSE = 0.3113426f;
        double latches_latchXminus_OPEN = 0.7539498805999756;
        double latches_latchXplus_CLOSE = 0.4514995217323303;
        double latches_latchXplus_OPEN = 0.9094005227088928;
        double onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 0.5748766660690308;
        double onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 0.4865322709083557;
        double onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP = 0.8685975074768066;
        double onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT = 0.7790580987930298;
        double onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 0.25023216009140015;
        double onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 0.2657204270362854;
        double onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP = 0.8041464686393738;
        double onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT = 0.756621241569519;
        double onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 0.581931f;
        double onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP = 0.295981228351593;
        double onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT = 0.8983912467956543;
        double onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 0.6262786388397217;
        double onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT = 0.581102f;
        double onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP = 0.7957332730293274;
        double onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 0.9048423767089844;
        double onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 0.4520873427391052;
        double onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP = 0.16178607940673828;
        double onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT = 0.363275408744812;
        double onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 0.5430818200111389;
        double onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 0.13515949249267578;
        double onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP = 0.827580451965332;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Counters_Autochanger_TrendingTelemetry(autochangertrucks_ALIGN_FOLLOWER, autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, latches_latchXminus_CLOSE, latches_latchXminus_OPEN, latches_latchXplus_CLOSE, latches_latchXplus_OPEN, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP));
        Assert.assertTrue((boolean)(item instanceof Fcs_Counters_Autochanger_TrendingTelemetry));
        Fcs_Counters_Autochanger_TrendingTelemetry item_ = (Fcs_Counters_Autochanger_TrendingTelemetry)item;
        Assert.assertEquals((double)autochangertrucks_ALIGN_FOLLOWER, (double)item_.getAutochangertrucks_ALIGN_FOLLOWER(), (double)1.0E-6f);
        Assert.assertEquals((double)autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, (double)item_.getAutochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE(), (double)1.0E-6f);
        Assert.assertEquals((double)autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, (double)item_.getAutochangertrucks_MOVE_TO_ABSOLUTE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)latches_latchXminus_CLOSE, (double)item_.getLatches_latchXminus_CLOSE(), (double)1.0E-6f);
        Assert.assertEquals((double)latches_latchXminus_OPEN, (double)item_.getLatches_latchXminus_OPEN(), (double)1.0E-6f);
        Assert.assertEquals((double)latches_latchXplus_CLOSE, (double)item_.getLatches_latchXplus_CLOSE(), (double)1.0E-6f);
        Assert.assertEquals((double)latches_latchXplus_OPEN, (double)item_.getLatches_latchXplus_OPEN(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampXminus_LOCK_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampXplus_LOCK_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampYminus_LOCK_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Counters_Carousel_TrendingTelemetry() throws Exception {
        double rotate_CAROUSEL_TO_ABSOLUTE_POSITION = 0.4094271659851074;
        double rotate_CAROUSEL_TO_RELATIVE_POSITION = 0.0993850827217102;
        double socket1_RELEASE_CLAMPS = 0.9760653972625732;
        double socket1_UNLOCK_CLAMPS = 0.1322593092918396;
        double socket1_clampXminus1_RELEASE = 0.45944637060165405;
        double socket1_clampXminus1_UNLOCK = 0.2674063444137573;
        double socket1_clampXplus1_RELEASE = 0.5803442001342773;
        double socket1_clampXplus1_UNLOCK = 0.25226891040802;
        double socket2_RELEASE_CLAMPS = 0.30591654777526855;
        double socket2_UNLOCK_CLAMPS = 0.22841012477874756;
        double socket2_clampXminus2_RELEASE = 0.8177751302719116;
        double socket2_clampXminus2_UNLOCK = 0.7942166328430176;
        double socket2_clampXplus2_RELEASE = 0.40175676345825195;
        double socket2_clampXplus2_UNLOCK = 0.5847638845443726;
        double socket3_RELEASE_CLAMPS = 0.42498672008514404;
        double socket3_UNLOCK_CLAMPS = 0.8863813877105713;
        double socket3_clampXminus3_RELEASE = 0.2184915542602539;
        double socket3_clampXminus3_UNLOCK = 0.30292046070098877;
        double socket3_clampXplus3_RELEASE = 0.24658f;
        double socket3_clampXplus3_UNLOCK = 0.4052159786224365;
        double socket4_RELEASE_CLAMPS = 0.2127559781074524;
        double socket4_UNLOCK_CLAMPS = 0.004832923412322998;
        double socket4_clampXminus4_RELEASE = 0.14084428548812866;
        double socket4_clampXminus4_UNLOCK = 0.11677253246307373;
        double socket4_clampXplus4_RELEASE = 0.4001381993293762;
        double socket4_clampXplus4_UNLOCK = 0.6221920847892761;
        double socket5_RELEASE_CLAMPS = 0.6591092348098755;
        double socket5_UNLOCK_CLAMPS = 0.585555374622345;
        double socket5_clampXminus5_RELEASE = 0.6394550800323486;
        double socket5_clampXminus5_UNLOCK = 0.8392289280891418;
        double socket5_clampXplus5_RELEASE = 0.7476898431777954;
        double socket5_clampXplus5_UNLOCK = 0.951723575592041;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Counters_Carousel_TrendingTelemetry(rotate_CAROUSEL_TO_ABSOLUTE_POSITION, rotate_CAROUSEL_TO_RELATIVE_POSITION, socket1_RELEASE_CLAMPS, socket1_UNLOCK_CLAMPS, socket1_clampXminus1_RELEASE, socket1_clampXminus1_UNLOCK, socket1_clampXplus1_RELEASE, socket1_clampXplus1_UNLOCK, socket2_RELEASE_CLAMPS, socket2_UNLOCK_CLAMPS, socket2_clampXminus2_RELEASE, socket2_clampXminus2_UNLOCK, socket2_clampXplus2_RELEASE, socket2_clampXplus2_UNLOCK, socket3_RELEASE_CLAMPS, socket3_UNLOCK_CLAMPS, socket3_clampXminus3_RELEASE, socket3_clampXminus3_UNLOCK, socket3_clampXplus3_RELEASE, socket3_clampXplus3_UNLOCK, socket4_RELEASE_CLAMPS, socket4_UNLOCK_CLAMPS, socket4_clampXminus4_RELEASE, socket4_clampXminus4_UNLOCK, socket4_clampXplus4_RELEASE, socket4_clampXplus4_UNLOCK, socket5_RELEASE_CLAMPS, socket5_UNLOCK_CLAMPS, socket5_clampXminus5_RELEASE, socket5_clampXminus5_UNLOCK, socket5_clampXplus5_RELEASE, socket5_clampXplus5_UNLOCK));
        Assert.assertTrue((boolean)(item instanceof Fcs_Counters_Carousel_TrendingTelemetry));
        Fcs_Counters_Carousel_TrendingTelemetry item_ = (Fcs_Counters_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((double)rotate_CAROUSEL_TO_ABSOLUTE_POSITION, (double)item_.getRotate_CAROUSEL_TO_ABSOLUTE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)rotate_CAROUSEL_TO_RELATIVE_POSITION, (double)item_.getRotate_CAROUSEL_TO_RELATIVE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_RELEASE_CLAMPS, (double)item_.getSocket1_RELEASE_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_UNLOCK_CLAMPS, (double)item_.getSocket1_UNLOCK_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_clampXminus1_RELEASE, (double)item_.getSocket1_clampXminus1_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_clampXminus1_UNLOCK, (double)item_.getSocket1_clampXminus1_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_clampXplus1_RELEASE, (double)item_.getSocket1_clampXplus1_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_clampXplus1_UNLOCK, (double)item_.getSocket1_clampXplus1_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_RELEASE_CLAMPS, (double)item_.getSocket2_RELEASE_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_UNLOCK_CLAMPS, (double)item_.getSocket2_UNLOCK_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_clampXminus2_RELEASE, (double)item_.getSocket2_clampXminus2_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_clampXminus2_UNLOCK, (double)item_.getSocket2_clampXminus2_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_clampXplus2_RELEASE, (double)item_.getSocket2_clampXplus2_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_clampXplus2_UNLOCK, (double)item_.getSocket2_clampXplus2_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_RELEASE_CLAMPS, (double)item_.getSocket3_RELEASE_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_UNLOCK_CLAMPS, (double)item_.getSocket3_UNLOCK_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_clampXminus3_RELEASE, (double)item_.getSocket3_clampXminus3_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_clampXminus3_UNLOCK, (double)item_.getSocket3_clampXminus3_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_clampXplus3_RELEASE, (double)item_.getSocket3_clampXplus3_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_clampXplus3_UNLOCK, (double)item_.getSocket3_clampXplus3_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_RELEASE_CLAMPS, (double)item_.getSocket4_RELEASE_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_UNLOCK_CLAMPS, (double)item_.getSocket4_UNLOCK_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_clampXminus4_RELEASE, (double)item_.getSocket4_clampXminus4_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_clampXminus4_UNLOCK, (double)item_.getSocket4_clampXminus4_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_clampXplus4_RELEASE, (double)item_.getSocket4_clampXplus4_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_clampXplus4_UNLOCK, (double)item_.getSocket4_clampXplus4_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_RELEASE_CLAMPS, (double)item_.getSocket5_RELEASE_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_UNLOCK_CLAMPS, (double)item_.getSocket5_UNLOCK_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_clampXminus5_RELEASE, (double)item_.getSocket5_clampXminus5_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_clampXminus5_UNLOCK, (double)item_.getSocket5_clampXminus5_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_clampXplus5_RELEASE, (double)item_.getSocket5_clampXplus5_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_clampXplus5_UNLOCK, (double)item_.getSocket5_clampXplus5_UNLOCK(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Counters_Loader_TrendingTelemetry() throws Exception {
        double carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION = 0.5951078534126282;
        double carrier_MOVE_LOADERCARRIER_TO_ENGAGED = 0.780863344669342;
        double carrier_MOVE_LOADERCARRIER_TO_HANDOFF = 0.7512450814247131;
        double carrier_MOVE_LOADERCARRIER_TO_STORAGE = 0.3996758460998535;
        double hooks_CLAMP_LOADER_HOOKS = 0.9360947608947754;
        double hooks_CLOSE_LOADER_HOOKS = 0.828124463558197;
        double hooks_OPEN_HOMING_LOADER_HOOKS = 0.8273234367370605;
        double hooks_UNCLAMP_LOADER_HOOKS = 0.15033096075057983;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Counters_Loader_TrendingTelemetry(carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, carrier_MOVE_LOADERCARRIER_TO_ENGAGED, carrier_MOVE_LOADERCARRIER_TO_HANDOFF, carrier_MOVE_LOADERCARRIER_TO_STORAGE, hooks_CLAMP_LOADER_HOOKS, hooks_CLOSE_LOADER_HOOKS, hooks_OPEN_HOMING_LOADER_HOOKS, hooks_UNCLAMP_LOADER_HOOKS));
        Assert.assertTrue((boolean)(item instanceof Fcs_Counters_Loader_TrendingTelemetry));
        Fcs_Counters_Loader_TrendingTelemetry item_ = (Fcs_Counters_Loader_TrendingTelemetry)item;
        Assert.assertEquals((double)carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, (double)item_.getCarrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)carrier_MOVE_LOADERCARRIER_TO_ENGAGED, (double)item_.getCarrier_MOVE_LOADERCARRIER_TO_ENGAGED(), (double)1.0E-6f);
        Assert.assertEquals((double)carrier_MOVE_LOADERCARRIER_TO_HANDOFF, (double)item_.getCarrier_MOVE_LOADERCARRIER_TO_HANDOFF(), (double)1.0E-6f);
        Assert.assertEquals((double)carrier_MOVE_LOADERCARRIER_TO_STORAGE, (double)item_.getCarrier_MOVE_LOADERCARRIER_TO_STORAGE(), (double)1.0E-6f);
        Assert.assertEquals((double)hooks_CLAMP_LOADER_HOOKS, (double)item_.getHooks_CLAMP_LOADER_HOOKS(), (double)1.0E-6f);
        Assert.assertEquals((double)hooks_CLOSE_LOADER_HOOKS, (double)item_.getHooks_CLOSE_LOADER_HOOKS(), (double)1.0E-6f);
        Assert.assertEquals((double)hooks_OPEN_HOMING_LOADER_HOOKS, (double)item_.getHooks_OPEN_HOMING_LOADER_HOOKS(), (double)1.0E-6f);
        Assert.assertEquals((double)hooks_UNCLAMP_LOADER_HOOKS, (double)item_.getHooks_UNCLAMP_LOADER_HOOKS(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Counters_TrendingTelemetry() throws Exception {
        double connect_LOADER = 0.8165153861045837;
        double disconnect_LOADER = 0.1770561933517456;
        double disengage_FILTER_FROM_CAROUSEL = 0.7531639337539673;
        double grab_FILTER_AT_STANDBY = 0.6849716901779175;
        double load_FILTER = 0.6860493421554565;
        double move_AND_CLAMP_FILTER_ONLINE = 0.10641586780548096;
        double rotate_SOCKET_TO_STANDBY = 0.8348446488380432;
        double set_FILTER = 0.24506932497024536;
        double set_FILTER_AT_HANDOFF_FOR_LOADER = 0.3251359462738037;
        double set_NO_FILTER = 0.8296629190444946;
        double store_FILTER_ON_CAROUSEL = 0.8611286878585815;
        double unload_FILTER = 0.31041085720062256;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Counters_TrendingTelemetry(connect_LOADER, disconnect_LOADER, disengage_FILTER_FROM_CAROUSEL, grab_FILTER_AT_STANDBY, load_FILTER, move_AND_CLAMP_FILTER_ONLINE, rotate_SOCKET_TO_STANDBY, set_FILTER, set_FILTER_AT_HANDOFF_FOR_LOADER, set_NO_FILTER, store_FILTER_ON_CAROUSEL, unload_FILTER));
        Assert.assertTrue((boolean)(item instanceof Fcs_Counters_TrendingTelemetry));
        Fcs_Counters_TrendingTelemetry item_ = (Fcs_Counters_TrendingTelemetry)item;
        Assert.assertEquals((double)connect_LOADER, (double)item_.getConnect_LOADER(), (double)1.0E-6f);
        Assert.assertEquals((double)disconnect_LOADER, (double)item_.getDisconnect_LOADER(), (double)1.0E-6f);
        Assert.assertEquals((double)disengage_FILTER_FROM_CAROUSEL, (double)item_.getDisengage_FILTER_FROM_CAROUSEL(), (double)1.0E-6f);
        Assert.assertEquals((double)grab_FILTER_AT_STANDBY, (double)item_.getGrab_FILTER_AT_STANDBY(), (double)1.0E-6f);
        Assert.assertEquals((double)load_FILTER, (double)item_.getLoad_FILTER(), (double)1.0E-6f);
        Assert.assertEquals((double)move_AND_CLAMP_FILTER_ONLINE, (double)item_.getMove_AND_CLAMP_FILTER_ONLINE(), (double)1.0E-6f);
        Assert.assertEquals((double)rotate_SOCKET_TO_STANDBY, (double)item_.getRotate_SOCKET_TO_STANDBY(), (double)1.0E-6f);
        Assert.assertEquals((double)set_FILTER, (double)item_.getSet_FILTER(), (double)1.0E-6f);
        Assert.assertEquals((double)set_FILTER_AT_HANDOFF_FOR_LOADER, (double)item_.getSet_FILTER_AT_HANDOFF_FOR_LOADER(), (double)1.0E-6f);
        Assert.assertEquals((double)set_NO_FILTER, (double)item_.getSet_NO_FILTER(), (double)1.0E-6f);
        Assert.assertEquals((double)store_FILTER_ON_CAROUSEL, (double)item_.getStore_FILTER_ON_CAROUSEL(), (double)1.0E-6f);
        Assert.assertEquals((double)unload_FILTER, (double)item_.getUnload_FILTER(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Duration_Autochanger_TrendingTelemetry() throws Exception {
        long autochangertrucks_ALIGN_FOLLOWER = 865L;
        long autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE = 683L;
        long autochangertrucks_MOVE_TO_ABSOLUTE_POSITION = 639L;
        double grab_FILTER_AT_STANDBY = 0.1130760908126831;
        long latches_latchXminus_CLOSE = 12L;
        long latches_latchXminus_OPEN = 491L;
        long latches_latchXplus_CLOSE = 856L;
        long latches_latchXplus_OPEN = 315L;
        double move_AND_CLAMP_FILTER_ONLINE = 0.34592121839523315;
        long onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 717L;
        long onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 556L;
        long onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP = 194L;
        long onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT = 50L;
        long onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 570L;
        long onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 175L;
        long onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP = 857L;
        long onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT = 501L;
        long onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 472L;
        long onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP = 488L;
        long onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT = 76L;
        long onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 916L;
        long onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT = 152L;
        long onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP = 395L;
        long onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 368L;
        long onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 695L;
        long onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP = 21L;
        long onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT = 920L;
        long onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 678L;
        long onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 525L;
        long onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP = 791L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Autochanger_TrendingTelemetry(autochangertrucks_ALIGN_FOLLOWER, autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, grab_FILTER_AT_STANDBY, latches_latchXminus_CLOSE, latches_latchXminus_OPEN, latches_latchXplus_CLOSE, latches_latchXplus_OPEN, move_AND_CLAMP_FILTER_ONLINE, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Autochanger_TrendingTelemetry));
        Fcs_Duration_Autochanger_TrendingTelemetry item_ = (Fcs_Duration_Autochanger_TrendingTelemetry)item;
        Assert.assertEquals((long)autochangertrucks_ALIGN_FOLLOWER, (long)item_.getAutochangertrucks_ALIGN_FOLLOWER());
        Assert.assertEquals((long)autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, (long)item_.getAutochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE());
        Assert.assertEquals((long)autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, (long)item_.getAutochangertrucks_MOVE_TO_ABSOLUTE_POSITION());
        Assert.assertEquals((double)grab_FILTER_AT_STANDBY, (double)item_.getGrab_FILTER_AT_STANDBY(), (double)1.0E-6f);
        Assert.assertEquals((long)latches_latchXminus_CLOSE, (long)item_.getLatches_latchXminus_CLOSE());
        Assert.assertEquals((long)latches_latchXminus_OPEN, (long)item_.getLatches_latchXminus_OPEN());
        Assert.assertEquals((long)latches_latchXplus_CLOSE, (long)item_.getLatches_latchXplus_CLOSE());
        Assert.assertEquals((long)latches_latchXplus_OPEN, (long)item_.getLatches_latchXplus_OPEN());
        Assert.assertEquals((double)move_AND_CLAMP_FILTER_ONLINE, (double)item_.getMove_AND_CLAMP_FILTER_ONLINE(), (double)1.0E-6f);
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXminus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXplus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampYminus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP());
    }

    @Test
    public void sendReceiveFcs_Duration_Carousel_TrendingTelemetry() throws Exception {
        long rotate_CAROUSEL_TO_ABSOLUTE_POSITION = 639L;
        long rotate_CAROUSEL_TO_RELATIVE_POSITION = 47L;
        int socket1_RELEASE_CLAMPS = 98;
        int socket1_UNLOCK_CLAMPS = 781;
        long socket1_clampXminus1_RELEASE = 365L;
        long socket1_clampXminus1_UNLOCK = 545L;
        long socket1_clampXplus1_RELEASE = 921L;
        long socket1_clampXplus1_UNLOCK = 321L;
        int socket2_RELEASE_CLAMPS = 464;
        int socket2_UNLOCK_CLAMPS = 536;
        long socket2_clampXminus2_RELEASE = 794L;
        long socket2_clampXminus2_UNLOCK = 870L;
        long socket2_clampXplus2_RELEASE = 228L;
        long socket2_clampXplus2_UNLOCK = 392L;
        int socket3_RELEASE_CLAMPS = 945;
        int socket3_UNLOCK_CLAMPS = 508;
        long socket3_clampXminus3_RELEASE = 271L;
        long socket3_clampXminus3_UNLOCK = 342L;
        long socket3_clampXplus3_RELEASE = 515L;
        long socket3_clampXplus3_UNLOCK = 732L;
        int socket4_RELEASE_CLAMPS = 207;
        int socket4_UNLOCK_CLAMPS = 334;
        long socket4_clampXminus4_RELEASE = 285L;
        long socket4_clampXminus4_UNLOCK = 599L;
        long socket4_clampXplus4_RELEASE = 454L;
        long socket4_clampXplus4_UNLOCK = 670L;
        int socket5_RELEASE_CLAMPS = 931;
        int socket5_UNLOCK_CLAMPS = 832;
        long socket5_clampXminus5_RELEASE = 855L;
        long socket5_clampXminus5_UNLOCK = 106L;
        long socket5_clampXplus5_RELEASE = 169L;
        long socket5_clampXplus5_UNLOCK = 466L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Carousel_TrendingTelemetry(rotate_CAROUSEL_TO_ABSOLUTE_POSITION, rotate_CAROUSEL_TO_RELATIVE_POSITION, socket1_RELEASE_CLAMPS, socket1_UNLOCK_CLAMPS, socket1_clampXminus1_RELEASE, socket1_clampXminus1_UNLOCK, socket1_clampXplus1_RELEASE, socket1_clampXplus1_UNLOCK, socket2_RELEASE_CLAMPS, socket2_UNLOCK_CLAMPS, socket2_clampXminus2_RELEASE, socket2_clampXminus2_UNLOCK, socket2_clampXplus2_RELEASE, socket2_clampXplus2_UNLOCK, socket3_RELEASE_CLAMPS, socket3_UNLOCK_CLAMPS, socket3_clampXminus3_RELEASE, socket3_clampXminus3_UNLOCK, socket3_clampXplus3_RELEASE, socket3_clampXplus3_UNLOCK, socket4_RELEASE_CLAMPS, socket4_UNLOCK_CLAMPS, socket4_clampXminus4_RELEASE, socket4_clampXminus4_UNLOCK, socket4_clampXplus4_RELEASE, socket4_clampXplus4_UNLOCK, socket5_RELEASE_CLAMPS, socket5_UNLOCK_CLAMPS, socket5_clampXminus5_RELEASE, socket5_clampXminus5_UNLOCK, socket5_clampXplus5_RELEASE, socket5_clampXplus5_UNLOCK));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Carousel_TrendingTelemetry));
        Fcs_Duration_Carousel_TrendingTelemetry item_ = (Fcs_Duration_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((long)rotate_CAROUSEL_TO_ABSOLUTE_POSITION, (long)item_.getRotate_CAROUSEL_TO_ABSOLUTE_POSITION());
        Assert.assertEquals((long)rotate_CAROUSEL_TO_RELATIVE_POSITION, (long)item_.getRotate_CAROUSEL_TO_RELATIVE_POSITION());
        Assert.assertEquals((long)socket1_RELEASE_CLAMPS, (long)item_.getSocket1_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket1_UNLOCK_CLAMPS, (long)item_.getSocket1_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket1_clampXminus1_RELEASE, (long)item_.getSocket1_clampXminus1_RELEASE());
        Assert.assertEquals((long)socket1_clampXminus1_UNLOCK, (long)item_.getSocket1_clampXminus1_UNLOCK());
        Assert.assertEquals((long)socket1_clampXplus1_RELEASE, (long)item_.getSocket1_clampXplus1_RELEASE());
        Assert.assertEquals((long)socket1_clampXplus1_UNLOCK, (long)item_.getSocket1_clampXplus1_UNLOCK());
        Assert.assertEquals((long)socket2_RELEASE_CLAMPS, (long)item_.getSocket2_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket2_UNLOCK_CLAMPS, (long)item_.getSocket2_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket2_clampXminus2_RELEASE, (long)item_.getSocket2_clampXminus2_RELEASE());
        Assert.assertEquals((long)socket2_clampXminus2_UNLOCK, (long)item_.getSocket2_clampXminus2_UNLOCK());
        Assert.assertEquals((long)socket2_clampXplus2_RELEASE, (long)item_.getSocket2_clampXplus2_RELEASE());
        Assert.assertEquals((long)socket2_clampXplus2_UNLOCK, (long)item_.getSocket2_clampXplus2_UNLOCK());
        Assert.assertEquals((long)socket3_RELEASE_CLAMPS, (long)item_.getSocket3_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket3_UNLOCK_CLAMPS, (long)item_.getSocket3_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket3_clampXminus3_RELEASE, (long)item_.getSocket3_clampXminus3_RELEASE());
        Assert.assertEquals((long)socket3_clampXminus3_UNLOCK, (long)item_.getSocket3_clampXminus3_UNLOCK());
        Assert.assertEquals((long)socket3_clampXplus3_RELEASE, (long)item_.getSocket3_clampXplus3_RELEASE());
        Assert.assertEquals((long)socket3_clampXplus3_UNLOCK, (long)item_.getSocket3_clampXplus3_UNLOCK());
        Assert.assertEquals((long)socket4_RELEASE_CLAMPS, (long)item_.getSocket4_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket4_UNLOCK_CLAMPS, (long)item_.getSocket4_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket4_clampXminus4_RELEASE, (long)item_.getSocket4_clampXminus4_RELEASE());
        Assert.assertEquals((long)socket4_clampXminus4_UNLOCK, (long)item_.getSocket4_clampXminus4_UNLOCK());
        Assert.assertEquals((long)socket4_clampXplus4_RELEASE, (long)item_.getSocket4_clampXplus4_RELEASE());
        Assert.assertEquals((long)socket4_clampXplus4_UNLOCK, (long)item_.getSocket4_clampXplus4_UNLOCK());
        Assert.assertEquals((long)socket5_RELEASE_CLAMPS, (long)item_.getSocket5_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket5_UNLOCK_CLAMPS, (long)item_.getSocket5_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket5_clampXminus5_RELEASE, (long)item_.getSocket5_clampXminus5_RELEASE());
        Assert.assertEquals((long)socket5_clampXminus5_UNLOCK, (long)item_.getSocket5_clampXminus5_UNLOCK());
        Assert.assertEquals((long)socket5_clampXplus5_RELEASE, (long)item_.getSocket5_clampXplus5_RELEASE());
        Assert.assertEquals((long)socket5_clampXplus5_UNLOCK, (long)item_.getSocket5_clampXplus5_UNLOCK());
    }

    @Test
    public void sendReceiveFcs_Duration_Loader_TrendingTelemetry() throws Exception {
        long carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION = 192L;
        long carrier_MOVE_LOADERCARRIER_TO_ENGAGED = 105L;
        long carrier_MOVE_LOADERCARRIER_TO_HANDOFF = 705L;
        long carrier_MOVE_LOADERCARRIER_TO_STORAGE = 204L;
        long hooks_CLAMP_LOADER_HOOKS = 43L;
        long hooks_CLOSE_LOADER_HOOKS = 805L;
        long hooks_OPEN_HOMING_LOADER_HOOKS = 930L;
        long hooks_UNCLAMP_LOADER_HOOKS = 826L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Loader_TrendingTelemetry(carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, carrier_MOVE_LOADERCARRIER_TO_ENGAGED, carrier_MOVE_LOADERCARRIER_TO_HANDOFF, carrier_MOVE_LOADERCARRIER_TO_STORAGE, hooks_CLAMP_LOADER_HOOKS, hooks_CLOSE_LOADER_HOOKS, hooks_OPEN_HOMING_LOADER_HOOKS, hooks_UNCLAMP_LOADER_HOOKS));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Loader_TrendingTelemetry));
        Fcs_Duration_Loader_TrendingTelemetry item_ = (Fcs_Duration_Loader_TrendingTelemetry)item;
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_ENGAGED, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_ENGAGED());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_HANDOFF, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_HANDOFF());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_STORAGE, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_STORAGE());
        Assert.assertEquals((long)hooks_CLAMP_LOADER_HOOKS, (long)item_.getHooks_CLAMP_LOADER_HOOKS());
        Assert.assertEquals((long)hooks_CLOSE_LOADER_HOOKS, (long)item_.getHooks_CLOSE_LOADER_HOOKS());
        Assert.assertEquals((long)hooks_OPEN_HOMING_LOADER_HOOKS, (long)item_.getHooks_OPEN_HOMING_LOADER_HOOKS());
        Assert.assertEquals((long)hooks_UNCLAMP_LOADER_HOOKS, (long)item_.getHooks_UNCLAMP_LOADER_HOOKS());
    }

    @Test
    public void sendReceiveFcs_Duration_TrendingTelemetry() throws Exception {
        long connect_LOADER = 691L;
        long disconnect_LOADER = 40L;
        long disengage_FILTER_FROM_CAROUSEL = 34L;
        long load_FILTER = 677L;
        double rotate_SOCKET_TO_STANDBY = 0.6435844898223877;
        long set_FILTER = 425L;
        long set_FILTER_AT_HANDOFF_FOR_LOADER = 184L;
        long set_NO_FILTER = 378L;
        long store_FILTER_ON_CAROUSEL = 222L;
        long unload_FILTER = 398L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_TrendingTelemetry(connect_LOADER, disconnect_LOADER, disengage_FILTER_FROM_CAROUSEL, load_FILTER, rotate_SOCKET_TO_STANDBY, set_FILTER, set_FILTER_AT_HANDOFF_FOR_LOADER, set_NO_FILTER, store_FILTER_ON_CAROUSEL, unload_FILTER));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_TrendingTelemetry));
        Fcs_Duration_TrendingTelemetry item_ = (Fcs_Duration_TrendingTelemetry)item;
        Assert.assertEquals((long)connect_LOADER, (long)item_.getConnect_LOADER());
        Assert.assertEquals((long)disconnect_LOADER, (long)item_.getDisconnect_LOADER());
        Assert.assertEquals((long)disengage_FILTER_FROM_CAROUSEL, (long)item_.getDisengage_FILTER_FROM_CAROUSEL());
        Assert.assertEquals((long)load_FILTER, (long)item_.getLoad_FILTER());
        Assert.assertEquals((double)rotate_SOCKET_TO_STANDBY, (double)item_.getRotate_SOCKET_TO_STANDBY(), (double)1.0E-6f);
        Assert.assertEquals((long)set_FILTER, (long)item_.getSet_FILTER());
        Assert.assertEquals((long)set_FILTER_AT_HANDOFF_FOR_LOADER, (long)item_.getSet_FILTER_AT_HANDOFF_FOR_LOADER());
        Assert.assertEquals((long)set_NO_FILTER, (long)item_.getSet_NO_FILTER());
        Assert.assertEquals((long)store_FILTER_ON_CAROUSEL, (long)item_.getStore_FILTER_ON_CAROUSEL());
        Assert.assertEquals((long)unload_FILTER, (long)item_.getUnload_FILTER());
    }

    @Test
    public void sendReceiveFcs_Fcs_Mcm_TrendingTelemetry() throws Exception {
        int autochanger_trucks_position = 648;
        String autochanger_trucks_state = "";
        String filter_on_autochanger = "q";
        int filter_previous_socketID = 60;
        int proximity = 961;
        int setfilter_percentage = 189;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Fcs_Mcm_TrendingTelemetry(autochanger_trucks_position, autochanger_trucks_state, filter_on_autochanger, filter_previous_socketID, proximity, setfilter_percentage));
        Assert.assertTrue((boolean)(item instanceof Fcs_Fcs_Mcm_TrendingTelemetry));
        Fcs_Fcs_Mcm_TrendingTelemetry item_ = (Fcs_Fcs_Mcm_TrendingTelemetry)item;
        Assert.assertEquals((long)autochanger_trucks_position, (long)item_.getAutochanger_trucks_position());
        Assert.assertEquals((Object)autochanger_trucks_state, (Object)item_.getAutochanger_trucks_state());
        Assert.assertEquals((Object)filter_on_autochanger, (Object)item_.getFilter_on_autochanger());
        Assert.assertEquals((long)filter_previous_socketID, (long)item_.getFilter_previous_socketID());
        Assert.assertEquals((long)proximity, (long)item_.getProximity());
        Assert.assertEquals((long)setfilter_percentage, (long)item_.getSetfilter_percentage());
    }

    @Test
    public void sendReceiveFcs_Fcs_TrendingTelemetry() throws Exception {
        String version = "b";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Fcs_TrendingTelemetry(version));
        Assert.assertTrue((boolean)(item instanceof Fcs_Fcs_TrendingTelemetry));
        Fcs_Fcs_TrendingTelemetry item_ = (Fcs_Fcs_TrendingTelemetry)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
    }

    @Test
    public void sendReceiveFcs_Loader_Carrier_TrendingTelemetry() throws Exception {
        boolean atEngaged = true;
        boolean atHandoff = true;
        boolean atStorage = false;
        boolean controllerInError = false;
        boolean engagedSensorOn = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_Carrier_TrendingTelemetry(atEngaged, atHandoff, atStorage, controllerInError, engagedSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_Carrier_TrendingTelemetry));
        Fcs_Loader_Carrier_TrendingTelemetry item_ = (Fcs_Loader_Carrier_TrendingTelemetry)item;
        Assert.assertEquals((Object)atEngaged, (Object)item_.isAtEngaged());
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atStorage, (Object)item_.isAtStorage());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((Object)engagedSensorOn, (Object)item_.isEngagedSensorOn());
    }

    @Test
    public void sendReceiveFcs_Loader_Hooks_TrendingTelemetry() throws Exception {
        boolean allHooksInStateCLOSED = false;
        String clampState = "m";
        boolean controllerInError = true;
        boolean forceClampedStatus = true;
        boolean forceOverClampedStatus = false;
        int forceSensorVoltage0 = 267;
        int forceSensorVoltage1 = 775;
        String forceStatus = "d";
        boolean forceUnclampedStatus = false;
        boolean forceUnderClampedStatus = false;
        boolean statuspublishedbyhook1_inError = false;
        boolean statuspublishedbyhook1_lockSensorOn = true;
        String statuspublishedbyhook1_lockStatus = "";
        boolean statuspublishedbyhook1_unlockSensorOn = true;
        boolean statuspublishedbyhook2_inError = true;
        boolean statuspublishedbyhook2_lockSensorOn = true;
        String statuspublishedbyhook2_lockStatus = "";
        boolean statuspublishedbyhook2_unlockSensorOn = false;
        boolean statuspublishedbyhook3_inError = true;
        boolean statuspublishedbyhook3_lockSensorOn = false;
        String statuspublishedbyhook3_lockStatus = "";
        boolean statuspublishedbyhook3_unlockSensorOn = false;
        boolean statuspublishedbyhook4_inError = false;
        boolean statuspublishedbyhook4_lockSensorOn = false;
        String statuspublishedbyhook4_lockStatus = "g";
        boolean statuspublishedbyhook4_unlockSensorOn = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_Hooks_TrendingTelemetry(allHooksInStateCLOSED, clampState, controllerInError, forceClampedStatus, forceOverClampedStatus, forceSensorVoltage0, forceSensorVoltage1, forceStatus, forceUnclampedStatus, forceUnderClampedStatus, statuspublishedbyhook1_inError, statuspublishedbyhook1_lockSensorOn, statuspublishedbyhook1_lockStatus, statuspublishedbyhook1_unlockSensorOn, statuspublishedbyhook2_inError, statuspublishedbyhook2_lockSensorOn, statuspublishedbyhook2_lockStatus, statuspublishedbyhook2_unlockSensorOn, statuspublishedbyhook3_inError, statuspublishedbyhook3_lockSensorOn, statuspublishedbyhook3_lockStatus, statuspublishedbyhook3_unlockSensorOn, statuspublishedbyhook4_inError, statuspublishedbyhook4_lockSensorOn, statuspublishedbyhook4_lockStatus, statuspublishedbyhook4_unlockSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_Hooks_TrendingTelemetry));
        Fcs_Loader_Hooks_TrendingTelemetry item_ = (Fcs_Loader_Hooks_TrendingTelemetry)item;
        Assert.assertEquals((Object)allHooksInStateCLOSED, (Object)item_.isAllHooksInStateCLOSED());
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((Object)forceClampedStatus, (Object)item_.isForceClampedStatus());
        Assert.assertEquals((Object)forceOverClampedStatus, (Object)item_.isForceOverClampedStatus());
        Assert.assertEquals((long)forceSensorVoltage0, (long)item_.getForceSensorVoltage0());
        Assert.assertEquals((long)forceSensorVoltage1, (long)item_.getForceSensorVoltage1());
        Assert.assertEquals((Object)forceStatus, (Object)item_.getForceStatus());
        Assert.assertEquals((Object)forceUnclampedStatus, (Object)item_.isForceUnclampedStatus());
        Assert.assertEquals((Object)forceUnderClampedStatus, (Object)item_.isForceUnderClampedStatus());
        Assert.assertEquals((Object)statuspublishedbyhook1_inError, (Object)item_.isStatuspublishedbyhook1_inError());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockSensorOn, (Object)item_.isStatuspublishedbyhook1_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockStatus, (Object)item_.getStatuspublishedbyhook1_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook1_unlockSensorOn, (Object)item_.isStatuspublishedbyhook1_unlockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook2_inError, (Object)item_.isStatuspublishedbyhook2_inError());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockSensorOn, (Object)item_.isStatuspublishedbyhook2_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockStatus, (Object)item_.getStatuspublishedbyhook2_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook2_unlockSensorOn, (Object)item_.isStatuspublishedbyhook2_unlockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook3_inError, (Object)item_.isStatuspublishedbyhook3_inError());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockSensorOn, (Object)item_.isStatuspublishedbyhook3_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockStatus, (Object)item_.getStatuspublishedbyhook3_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook3_unlockSensorOn, (Object)item_.isStatuspublishedbyhook3_unlockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook4_inError, (Object)item_.isStatuspublishedbyhook4_inError());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockSensorOn, (Object)item_.isStatuspublishedbyhook4_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockStatus, (Object)item_.getStatuspublishedbyhook4_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook4_unlockSensorOn, (Object)item_.isStatuspublishedbyhook4_unlockSensorOn());
    }

    @Test
    public void sendReceiveFcs_Loader_TrendingTelemetry() throws Exception {
        String id = "b";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_TrendingTelemetry(id));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_TrendingTelemetry));
        Fcs_Loader_TrendingTelemetry item_ = (Fcs_Loader_TrendingTelemetry)item;
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }

    @Test
    public void sendReceiveFcs_TrendingTelemetry() throws Exception {
        int canbus0 = 771;
        int canbus1 = 705;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_TrendingTelemetry(canbus0, canbus1));
        Assert.assertTrue((boolean)(item instanceof Fcs_TrendingTelemetry));
        Fcs_TrendingTelemetry item_ = (Fcs_TrendingTelemetry)item;
        Assert.assertEquals((long)canbus0, (long)item_.getCanbus0());
        Assert.assertEquals((long)canbus1, (long)item_.getCanbus1());
    }

    @Test
    public void sendReceiveShutter_TrendingTelemetry() throws Exception {
        double minusx_strokeCount = 0.17478978633880615;
        double plusx_strokeCount = 0.3210238814353943;
        double shutterstatus_axstatus_MINUSX_actPos = 0.49725866317749023;
        double shutterstatus_axstatus_MINUSX_actVel = 0.3278064f;
        int shutterstatus_axstatus_MINUSX_brakeEngaged = 371;
        double shutterstatus_axstatus_MINUSX_ctrlTemp = 0.6906159520149231;
        int shutterstatus_axstatus_MINUSX_enabled = 527;
        int shutterstatus_axstatus_MINUSX_errorID = 550;
        int shutterstatus_axstatus_MINUSX_hasSafeTemp = 633;
        int shutterstatus_axstatus_MINUSX_highLimit = 536;
        int shutterstatus_axstatus_MINUSX_isHomed = 718;
        int shutterstatus_axstatus_MINUSX_lowLimit = 93;
        double shutterstatus_axstatus_MINUSX_setAcc = 0.9435044527053833;
        double shutterstatus_axstatus_PLUSX_actPos = 0.7157146334648132;
        double shutterstatus_axstatus_PLUSX_actVel = 0.8211161494255066;
        int shutterstatus_axstatus_PLUSX_brakeEngaged = 554;
        double shutterstatus_axstatus_PLUSX_ctrlTemp = 0.20266777276992798;
        int shutterstatus_axstatus_PLUSX_enabled = 537;
        int shutterstatus_axstatus_PLUSX_errorID = 196;
        int shutterstatus_axstatus_PLUSX_hasSafeTemp = 424;
        int shutterstatus_axstatus_PLUSX_highLimit = 765;
        int shutterstatus_axstatus_PLUSX_isHomed = 291;
        int shutterstatus_axstatus_PLUSX_lowLimit = 322;
        double shutterstatus_axstatus_PLUSX_setAcc = 0.9003398418426514;
        int shutterstatus_brakePowerIsOn = 927;
        double shutterstatus_creationTime = 0.8797598481178284;
        int shutterstatus_isCalibrated = 12;
        int shutterstatus_isSafetyOn = 68;
        int shutterstatus_leapIsValid = 485;
        int shutterstatus_leapSeconds = 640;
        int shutterstatus_motionProfile = 985;
        int shutterstatus_ptpState = 946;
        int shutterstatus_smState = 451;
        int shutterstatus_tempIsSafe_CONTROL_BOX = 431;
        int shutterstatus_tempIsSafe_MINUSX_MOTOR = 946;
        int shutterstatus_tempIsSafe_PLUSX_MOTOR = 635;
        double shutterstatus_temperature_CONTROL_BOX = 0.3349667191505432;
        double shutterstatus_temperature_MINUSX_MOTOR = 0.1378955841064453;
        double shutterstatus_temperature_PLUSX_MOTOR = 0.4372509f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Shutter_TrendingTelemetry(minusx_strokeCount, plusx_strokeCount, shutterstatus_axstatus_MINUSX_actPos, shutterstatus_axstatus_MINUSX_actVel, shutterstatus_axstatus_MINUSX_brakeEngaged, shutterstatus_axstatus_MINUSX_ctrlTemp, shutterstatus_axstatus_MINUSX_enabled, shutterstatus_axstatus_MINUSX_errorID, shutterstatus_axstatus_MINUSX_hasSafeTemp, shutterstatus_axstatus_MINUSX_highLimit, shutterstatus_axstatus_MINUSX_isHomed, shutterstatus_axstatus_MINUSX_lowLimit, shutterstatus_axstatus_MINUSX_setAcc, shutterstatus_axstatus_PLUSX_actPos, shutterstatus_axstatus_PLUSX_actVel, shutterstatus_axstatus_PLUSX_brakeEngaged, shutterstatus_axstatus_PLUSX_ctrlTemp, shutterstatus_axstatus_PLUSX_enabled, shutterstatus_axstatus_PLUSX_errorID, shutterstatus_axstatus_PLUSX_hasSafeTemp, shutterstatus_axstatus_PLUSX_highLimit, shutterstatus_axstatus_PLUSX_isHomed, shutterstatus_axstatus_PLUSX_lowLimit, shutterstatus_axstatus_PLUSX_setAcc, shutterstatus_brakePowerIsOn, shutterstatus_creationTime, shutterstatus_isCalibrated, shutterstatus_isSafetyOn, shutterstatus_leapIsValid, shutterstatus_leapSeconds, shutterstatus_motionProfile, shutterstatus_ptpState, shutterstatus_smState, shutterstatus_tempIsSafe_CONTROL_BOX, shutterstatus_tempIsSafe_MINUSX_MOTOR, shutterstatus_tempIsSafe_PLUSX_MOTOR, shutterstatus_temperature_CONTROL_BOX, shutterstatus_temperature_MINUSX_MOTOR, shutterstatus_temperature_PLUSX_MOTOR));
        Assert.assertTrue((boolean)(item instanceof Shutter_TrendingTelemetry));
        Shutter_TrendingTelemetry item_ = (Shutter_TrendingTelemetry)item;
        Assert.assertEquals((double)minusx_strokeCount, (double)item_.getMinusx_strokeCount(), (double)1.0E-6f);
        Assert.assertEquals((double)plusx_strokeCount, (double)item_.getPlusx_strokeCount(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_actPos, (double)item_.getShutterstatus_axstatus_MINUSX_actPos(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_actVel, (double)item_.getShutterstatus_axstatus_MINUSX_actVel(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_brakeEngaged, (long)item_.getShutterstatus_axstatus_MINUSX_brakeEngaged());
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_ctrlTemp, (double)item_.getShutterstatus_axstatus_MINUSX_ctrlTemp(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_enabled, (long)item_.getShutterstatus_axstatus_MINUSX_enabled());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_errorID, (long)item_.getShutterstatus_axstatus_MINUSX_errorID());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_hasSafeTemp, (long)item_.getShutterstatus_axstatus_MINUSX_hasSafeTemp());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_highLimit, (long)item_.getShutterstatus_axstatus_MINUSX_highLimit());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_isHomed, (long)item_.getShutterstatus_axstatus_MINUSX_isHomed());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_lowLimit, (long)item_.getShutterstatus_axstatus_MINUSX_lowLimit());
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_setAcc, (double)item_.getShutterstatus_axstatus_MINUSX_setAcc(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_actPos, (double)item_.getShutterstatus_axstatus_PLUSX_actPos(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_actVel, (double)item_.getShutterstatus_axstatus_PLUSX_actVel(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_brakeEngaged, (long)item_.getShutterstatus_axstatus_PLUSX_brakeEngaged());
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_ctrlTemp, (double)item_.getShutterstatus_axstatus_PLUSX_ctrlTemp(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_enabled, (long)item_.getShutterstatus_axstatus_PLUSX_enabled());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_errorID, (long)item_.getShutterstatus_axstatus_PLUSX_errorID());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_hasSafeTemp, (long)item_.getShutterstatus_axstatus_PLUSX_hasSafeTemp());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_highLimit, (long)item_.getShutterstatus_axstatus_PLUSX_highLimit());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_isHomed, (long)item_.getShutterstatus_axstatus_PLUSX_isHomed());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_lowLimit, (long)item_.getShutterstatus_axstatus_PLUSX_lowLimit());
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_setAcc, (double)item_.getShutterstatus_axstatus_PLUSX_setAcc(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_brakePowerIsOn, (long)item_.getShutterstatus_brakePowerIsOn());
        Assert.assertEquals((double)shutterstatus_creationTime, (double)item_.getShutterstatus_creationTime(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_isCalibrated, (long)item_.getShutterstatus_isCalibrated());
        Assert.assertEquals((long)shutterstatus_isSafetyOn, (long)item_.getShutterstatus_isSafetyOn());
        Assert.assertEquals((long)shutterstatus_leapIsValid, (long)item_.getShutterstatus_leapIsValid());
        Assert.assertEquals((long)shutterstatus_leapSeconds, (long)item_.getShutterstatus_leapSeconds());
        Assert.assertEquals((long)shutterstatus_motionProfile, (long)item_.getShutterstatus_motionProfile());
        Assert.assertEquals((long)shutterstatus_ptpState, (long)item_.getShutterstatus_ptpState());
        Assert.assertEquals((long)shutterstatus_smState, (long)item_.getShutterstatus_smState());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_CONTROL_BOX, (long)item_.getShutterstatus_tempIsSafe_CONTROL_BOX());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_MINUSX_MOTOR, (long)item_.getShutterstatus_tempIsSafe_MINUSX_MOTOR());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_PLUSX_MOTOR, (long)item_.getShutterstatus_tempIsSafe_PLUSX_MOTOR());
        Assert.assertEquals((double)shutterstatus_temperature_CONTROL_BOX, (double)item_.getShutterstatus_temperature_CONTROL_BOX(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_temperature_MINUSX_MOTOR, (double)item_.getShutterstatus_temperature_MINUSX_MOTOR(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_temperature_PLUSX_MOTOR, (double)item_.getShutterstatus_temperature_PLUSX_MOTOR(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_ChillerTelemetry() throws Exception {
        double cascadeSetPoint = 0.5971024036407471;
        double chillerPumpLife = 0.48422425985336304;
        double chillerValveAct = 0.23031479120254517;
        double compressorLife = 0.34547924995422363;
        double controllerLife = 0.5456147193908691;
        double coolPercentage = 0.38366132974624634;
        double flowRate = 0.7075849175453186;
        double flowSetPoint = 0.6024907827377319;
        double fluidTemperature = 0.325341f;
        double heatPercentage = 0.5572124719619751;
        double importedColdTemp = 0.41505998373031616;
        double pressureIn = 0.7670267224311829;
        double pressureOut = 0.3575679063796997;
        double pressureTank = 0.846003532409668;
        double tankLevel = 0.28513604402542114;
        double tankSetPoint = 0.7324286103248596;
        double tempCondenser = 0.7612669467926025;
        double tempDUTInput = 0.827907f;
        double tempDynamicSetPt = 0.5566155314445496;
        double tempSetPoint = 0.06641978025436401;
        double tempStage2Evap = 0.44267964363098145;
        double tempTXVBulb = 0.9191878437995911;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_ChillerTelemetry(cascadeSetPoint, chillerPumpLife, chillerValveAct, compressorLife, controllerLife, coolPercentage, flowRate, flowSetPoint, fluidTemperature, heatPercentage, importedColdTemp, pressureIn, pressureOut, pressureTank, tankLevel, tankSetPoint, tempCondenser, tempDUTInput, tempDynamicSetPt, tempSetPoint, tempStage2Evap, tempTXVBulb));
        Assert.assertTrue((boolean)(item instanceof Chiller_ChillerTelemetry));
        Chiller_ChillerTelemetry item_ = (Chiller_ChillerTelemetry)item;
        Assert.assertEquals((double)cascadeSetPoint, (double)item_.getCascadeSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)chillerPumpLife, (double)item_.getChillerPumpLife(), (double)1.0E-6f);
        Assert.assertEquals((double)chillerValveAct, (double)item_.getChillerValveAct(), (double)1.0E-6f);
        Assert.assertEquals((double)compressorLife, (double)item_.getCompressorLife(), (double)1.0E-6f);
        Assert.assertEquals((double)controllerLife, (double)item_.getControllerLife(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPercentage, (double)item_.getCoolPercentage(), (double)1.0E-6f);
        Assert.assertEquals((double)flowRate, (double)item_.getFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)flowSetPoint, (double)item_.getFlowSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)fluidTemperature, (double)item_.getFluidTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)heatPercentage, (double)item_.getHeatPercentage(), (double)1.0E-6f);
        Assert.assertEquals((double)importedColdTemp, (double)item_.getImportedColdTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureIn, (double)item_.getPressureIn(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureOut, (double)item_.getPressureOut(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureTank, (double)item_.getPressureTank(), (double)1.0E-6f);
        Assert.assertEquals((double)tankLevel, (double)item_.getTankLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)tankSetPoint, (double)item_.getTankSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCondenser, (double)item_.getTempCondenser(), (double)1.0E-6f);
        Assert.assertEquals((double)tempDUTInput, (double)item_.getTempDUTInput(), (double)1.0E-6f);
        Assert.assertEquals((double)tempDynamicSetPt, (double)item_.getTempDynamicSetPt(), (double)1.0E-6f);
        Assert.assertEquals((double)tempSetPoint, (double)item_.getTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempStage2Evap, (double)item_.getTempStage2Evap(), (double)1.0E-6f);
        Assert.assertEquals((double)tempTXVBulb, (double)item_.getTempTXVBulb(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_FParam_TrendingTelemetry() throws Exception {
        double bubblev_TIME = 0.17409104108810425;
        double clr_KI_SETPT = 0.2152794f;
        double cold_PERIOD = 0.15327203273773193;
        double cool_CAPACITY = 0.9256841540336609;
        double dut_DT_HI = 0.8590456247329712;
        double dut_DT_LO = 0.3129313588142395;
        double dut_KI = 0.3925696015357971;
        double dut_KP = 0.036313652992248535;
        double dut_TMAX = 0.2566499710083008;
        double dut_TMIN = 0.8815256357192993;
        double flowmeter_LO = 0.26134634017944336;
        double flow_ERR_MASK = 0.4878453016281128;
        double heat_CAPACITY = 0.7458181977272034;
        double heat_PERIOD = 0.04673302173614502;
        double pid_GAINFAC = 0.6174876093864441;
        double pid_KD = 0.28405314683914185;
        double pid_KI = 0.34266287088394165;
        double pid_KP = 0.7769942283630371;
        double purge_TIME = 0.3595815896987915;
        double ramp_DEFAULT = 0.5974315404891968;
        double refrig_OFF = 0.9698854684829712;
        double setpt_SETTLE = 0.7407770752906799;
        double setpt_TOL = 0.648055374622345;
        double tank_SETPOINT = 0.506066f;
        double thermsl_MASS = 0.7507975697517395;
        double t_CTRL_MODE = 0.4495378f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_FParam_TrendingTelemetry(bubblev_TIME, clr_KI_SETPT, cold_PERIOD, cool_CAPACITY, dut_DT_HI, dut_DT_LO, dut_KI, dut_KP, dut_TMAX, dut_TMIN, flowmeter_LO, flow_ERR_MASK, heat_CAPACITY, heat_PERIOD, pid_GAINFAC, pid_KD, pid_KI, pid_KP, purge_TIME, ramp_DEFAULT, refrig_OFF, setpt_SETTLE, setpt_TOL, tank_SETPOINT, thermsl_MASS, t_CTRL_MODE));
        Assert.assertTrue((boolean)(item instanceof Chiller_FParam_TrendingTelemetry));
        Chiller_FParam_TrendingTelemetry item_ = (Chiller_FParam_TrendingTelemetry)item;
        Assert.assertEquals((double)bubblev_TIME, (double)item_.getBubblev_TIME(), (double)1.0E-6f);
        Assert.assertEquals((double)clr_KI_SETPT, (double)item_.getClr_KI_SETPT(), (double)1.0E-6f);
        Assert.assertEquals((double)cold_PERIOD, (double)item_.getCold_PERIOD(), (double)1.0E-6f);
        Assert.assertEquals((double)cool_CAPACITY, (double)item_.getCool_CAPACITY(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_DT_HI, (double)item_.getDut_DT_HI(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_DT_LO, (double)item_.getDut_DT_LO(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_KI, (double)item_.getDut_KI(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_KP, (double)item_.getDut_KP(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_TMAX, (double)item_.getDut_TMAX(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_TMIN, (double)item_.getDut_TMIN(), (double)1.0E-6f);
        Assert.assertEquals((double)flowmeter_LO, (double)item_.getFlowmeter_LO(), (double)1.0E-6f);
        Assert.assertEquals((double)flow_ERR_MASK, (double)item_.getFlow_ERR_MASK(), (double)1.0E-6f);
        Assert.assertEquals((double)heat_CAPACITY, (double)item_.getHeat_CAPACITY(), (double)1.0E-6f);
        Assert.assertEquals((double)heat_PERIOD, (double)item_.getHeat_PERIOD(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_GAINFAC, (double)item_.getPid_GAINFAC(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KD, (double)item_.getPid_KD(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KI, (double)item_.getPid_KI(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KP, (double)item_.getPid_KP(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_TIME, (double)item_.getPurge_TIME(), (double)1.0E-6f);
        Assert.assertEquals((double)ramp_DEFAULT, (double)item_.getRamp_DEFAULT(), (double)1.0E-6f);
        Assert.assertEquals((double)refrig_OFF, (double)item_.getRefrig_OFF(), (double)1.0E-6f);
        Assert.assertEquals((double)setpt_SETTLE, (double)item_.getSetpt_SETTLE(), (double)1.0E-6f);
        Assert.assertEquals((double)setpt_TOL, (double)item_.getSetpt_TOL(), (double)1.0E-6f);
        Assert.assertEquals((double)tank_SETPOINT, (double)item_.getTank_SETPOINT(), (double)1.0E-6f);
        Assert.assertEquals((double)thermsl_MASS, (double)item_.getThermsl_MASS(), (double)1.0E-6f);
        Assert.assertEquals((double)t_CTRL_MODE, (double)item_.getT_CTRL_MODE(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_Maq20Telemetry() throws Exception {
        double ambientTemp = 0.9847127795219421;
        double cabinetTemp = 0.9761347770690918;
        double coldPlHeatXfer = 0.913657009601593;
        double coolantHXOut = 0.5972207188606262;
        double coolantHeatXfer = 0.5012385845184326;
        double coolantPumpIn = 0.961575f;
        double coolantPumpOut = 0.06002265214920044;
        double coolantReturn = 0.7410497069358826;
        double coolantSupply = 0.5761128664016724;
        double fan1Speed = 0.8920538425445557;
        double fan2Speed = 0.613198f;
        double glycChillerIn = 0.4049862027168274;
        double glycChillerOut = 0.10606098175048828;
        double glycCondensOut = 0.909494936466217;
        double glycDeSuHtrFlow = 0.0759924054145813;
        double glycDeSuHtrOut = 0.17908191680908203;
        double glycFanIn = 0.8294159173965454;
        double glycFanOut = 0.008644461631774902;
        double glycHeatXfer = 0.6005549430847168;
        double glycInputFlow = 0.6782124638557434;
        double glycSupplyP = 0.03945833444595337;
        double pBurstReturn = 0.7707338929176331;
        double pBurstSupply = 0.31961536407470703;
        double stg1CondensOut = 0.19612336158752441;
        double stg1Discharge = 0.6689494252204895;
        double stg1Return = 0.9490625262260437;
        double stg1TXVBulb = 0.8739323019981384;
        double stg2DeSuHtrOut = 0.3197711110115051;
        double stg2Discharge = 0.9838021397590637;
        double stg2DischargeP = 0.5847606062889099;
        double stg2EvapIn = 0.7640329599380493;
        double stg2EvapOut = 0.5696356296539307;
        double stg2Return = 0.2334162f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_Maq20Telemetry(ambientTemp, cabinetTemp, coldPlHeatXfer, coolantHXOut, coolantHeatXfer, coolantPumpIn, coolantPumpOut, coolantReturn, coolantSupply, fan1Speed, fan2Speed, glycChillerIn, glycChillerOut, glycCondensOut, glycDeSuHtrFlow, glycDeSuHtrOut, glycFanIn, glycFanOut, glycHeatXfer, glycInputFlow, glycSupplyP, pBurstReturn, pBurstSupply, stg1CondensOut, stg1Discharge, stg1Return, stg1TXVBulb, stg2DeSuHtrOut, stg2Discharge, stg2DischargeP, stg2EvapIn, stg2EvapOut, stg2Return));
        Assert.assertTrue((boolean)(item instanceof Chiller_Maq20Telemetry));
        Chiller_Maq20Telemetry item_ = (Chiller_Maq20Telemetry)item;
        Assert.assertEquals((double)ambientTemp, (double)item_.getAmbientTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTemp, (double)item_.getCabinetTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coldPlHeatXfer, (double)item_.getColdPlHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantHXOut, (double)item_.getCoolantHXOut(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantHeatXfer, (double)item_.getCoolantHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantPumpIn, (double)item_.getCoolantPumpIn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantPumpOut, (double)item_.getCoolantPumpOut(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantReturn, (double)item_.getCoolantReturn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantSupply, (double)item_.getCoolantSupply(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)glycChillerIn, (double)item_.getGlycChillerIn(), (double)1.0E-6f);
        Assert.assertEquals((double)glycChillerOut, (double)item_.getGlycChillerOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycCondensOut, (double)item_.getGlycCondensOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycDeSuHtrFlow, (double)item_.getGlycDeSuHtrFlow(), (double)1.0E-6f);
        Assert.assertEquals((double)glycDeSuHtrOut, (double)item_.getGlycDeSuHtrOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycFanIn, (double)item_.getGlycFanIn(), (double)1.0E-6f);
        Assert.assertEquals((double)glycFanOut, (double)item_.getGlycFanOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycHeatXfer, (double)item_.getGlycHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)glycInputFlow, (double)item_.getGlycInputFlow(), (double)1.0E-6f);
        Assert.assertEquals((double)glycSupplyP, (double)item_.getGlycSupplyP(), (double)1.0E-6f);
        Assert.assertEquals((double)pBurstReturn, (double)item_.getPBurstReturn(), (double)1.0E-6f);
        Assert.assertEquals((double)pBurstSupply, (double)item_.getPBurstSupply(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1CondensOut, (double)item_.getStg1CondensOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1Discharge, (double)item_.getStg1Discharge(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1Return, (double)item_.getStg1Return(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1TXVBulb, (double)item_.getStg1TXVBulb(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2DeSuHtrOut, (double)item_.getStg2DeSuHtrOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2Discharge, (double)item_.getStg2Discharge(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2DischargeP, (double)item_.getStg2DischargeP(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2EvapIn, (double)item_.getStg2EvapIn(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2EvapOut, (double)item_.getStg2EvapOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2Return, (double)item_.getStg2Return(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Cold_TempTelemetry() throws Exception {
        double avgColdTemp = 0.1792042851448059;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Cold_TempTelemetry(avgColdTemp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Cold_TempTelemetry));
        Thermal_Cold_TempTelemetry item_ = (Thermal_Cold_TempTelemetry)item;
        Assert.assertEquals((double)avgColdTemp, (double)item_.getAvgColdTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Cryo_TempTelemetry() throws Exception {
        double avgCryoTemp = 0.17751234769821167;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Cryo_TempTelemetry(avgCryoTemp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Cryo_TempTelemetry));
        Thermal_Cryo_TempTelemetry item_ = (Thermal_Cryo_TempTelemetry)item;
        Assert.assertEquals((double)avgCryoTemp, (double)item_.getAvgCryoTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_RtdTelemetry() throws Exception {
        double[] cold_TempCLP = TestHelper.generateDoubleArray((int)25, (int)-1676410162);
        double[] cryo_TempCYP = TestHelper.generateDoubleArray((int)25, (int)1653578850);
        double[] grid_TempCFX = TestHelper.generateDoubleArray((int)25, (int)1379801804);
        double[] grid_TempGFX = TestHelper.generateDoubleArray((int)25, (int)521540777);
        double[] grid_TempGRD = TestHelper.generateDoubleArray((int)25, (int)-1407749714);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_RtdTelemetry(cold_TempCLP, cryo_TempCYP, grid_TempCFX, grid_TempGFX, grid_TempGRD, location));
        Assert.assertTrue((boolean)(item instanceof Thermal_RtdTelemetry));
        Thermal_RtdTelemetry item_ = (Thermal_RtdTelemetry)item;
        Assert.assertArrayEquals((double[])cold_TempCLP, (double[])item_.getCold_TempCLP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_TempCYP, (double[])item_.getCryo_TempCYP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_TempCFX, (double[])item_.getGrid_TempCFX(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_TempGFX, (double[])item_.getGrid_TempGFX(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_TempGRD, (double[])item_.getGrid_TempGRD(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveThermal_TrimTelemetry() throws Exception {
        String location = "i";
        double[] trim_Htrs_ColdI = TestHelper.generateDoubleArray((int)6, (int)1740181677);
        double[] trim_Htrs_ColdP = TestHelper.generateDoubleArray((int)6, (int)-1014699857);
        double[] trim_Htrs_ColdV = TestHelper.generateDoubleArray((int)6, (int)1003631324);
        double[] trim_Htrs_CryoI = TestHelper.generateDoubleArray((int)6, (int)-1234594776);
        double[] trim_Htrs_CryoP = TestHelper.generateDoubleArray((int)6, (int)1498635536);
        double[] trim_Htrs_CryoV = TestHelper.generateDoubleArray((int)6, (int)-893295170);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_TrimTelemetry(location, trim_Htrs_ColdI, trim_Htrs_ColdP, trim_Htrs_ColdV, trim_Htrs_CryoI, trim_Htrs_CryoP, trim_Htrs_CryoV));
        Assert.assertTrue((boolean)(item instanceof Thermal_TrimTelemetry));
        Thermal_TrimTelemetry item_ = (Thermal_TrimTelemetry)item;
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])trim_Htrs_ColdI, (double[])item_.getTrim_Htrs_ColdI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_ColdP, (double[])item_.getTrim_Htrs_ColdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_ColdV, (double[])item_.getTrim_Htrs_ColdV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_CryoI, (double[])item_.getTrim_Htrs_CryoI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_CryoP, (double[])item_.getTrim_Htrs_CryoP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_CryoV, (double[])item_.getTrim_Htrs_CryoV(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Trim_HtrsTelemetry() throws Exception {
        double coldtotal_P = 0.2158851f;
        double cryototal_P = 0.29380446672439575;
        double htrBulkTmp = 0.057293057441711426;
        double htrbulk_I = 0.012272298336029053;
        double htrbulk_P = 0.848663866519928;
        double htrbulk_V = 0.8394546508789062;
        double htrPsTmp = 0.4971665143966675;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Trim_HtrsTelemetry(coldtotal_P, cryototal_P, htrBulkTmp, htrbulk_I, htrbulk_P, htrbulk_V, htrPsTmp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Trim_HtrsTelemetry));
        Thermal_Trim_HtrsTelemetry item_ = (Thermal_Trim_HtrsTelemetry)item;
        Assert.assertEquals((double)coldtotal_P, (double)item_.getColdtotal_P(), (double)1.0E-6f);
        Assert.assertEquals((double)cryototal_P, (double)item_.getCryototal_P(), (double)1.0E-6f);
        Assert.assertEquals((double)htrBulkTmp, (double)item_.getHtrBulkTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_I, (double)item_.getHtrbulk_I(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_P, (double)item_.getHtrbulk_P(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_V, (double)item_.getHtrbulk_V(), (double)1.0E-6f);
        Assert.assertEquals((double)htrPsTmp, (double)item_.getHtrPsTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_BodyTelemetry() throws Exception {
        double ambAirtemp = 0.5095604062080383;
        double averageTemp = 0.8725516200065613;
        double backFlngXMinusTemp = 0.32867681980133057;
        double backFlngXPlusTemp = 0.6984619498252869;
        double backFlngYMinusTemp = 0.7952814102172852;
        double camBodyXPlusTemp = 0.37395572662353516;
        double camBodyYMinusTemp = 0.6260892748832703;
        double camBodyYPlusTemp = 0.7153884172439575;
        double camHousXMinusTemp = 0.7642527222633362;
        double camHousXPlusTemp = 0.10452711582183838;
        double camHousYMinusTemp = 0.4485195279121399;
        double camHousYPlusTemp = 0.23581701517105103;
        double chgrYMinusRtnAirTemp = 0.865895688533783;
        double chgrYMinusRtnAirVel = 0.27686625719070435;
        double domeXMinusTemp = 0.49128222465515137;
        double domeYMinusTemp = 0.7071758508682251;
        double l1XMinusTemp = 0.5853912830352783;
        double l1YMinusTemp = 0.7518026232719421;
        double l2XMinusTemp = 0.581121563911438;
        double l2XPlusTemp = 0.5974168181419373;
        double l2YPlusTemp = 0.7062533497810364;
        double shrdRngXMinusTemp = 0.5366419553756714;
        double shrdRngXPlusTemp = 0.7753937244415283;
        double shrdRngYMinusTemp = 0.48055553436279297;
        double shrdRngYPlusTemp = 0.5190884470939636;
        double shtrEboxRtnAirTemp = 0.6146730780601501;
        double shtrEboxRtnAirVel = 0.017968297004699707;
        double shtrMtrRtnAirTemp = 0.5212689638137817;
        double shtrMtrRtnAirVel = 0.4072004556655884;
        double vPPlenumInTemp = 0.6060861349105835;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_BodyTelemetry(ambAirtemp, averageTemp, backFlngXMinusTemp, backFlngXPlusTemp, backFlngYMinusTemp, camBodyXPlusTemp, camBodyYMinusTemp, camBodyYPlusTemp, camHousXMinusTemp, camHousXPlusTemp, camHousYMinusTemp, camHousYPlusTemp, chgrYMinusRtnAirTemp, chgrYMinusRtnAirVel, domeXMinusTemp, domeYMinusTemp, l1XMinusTemp, l1YMinusTemp, l2XMinusTemp, l2XPlusTemp, l2YPlusTemp, shrdRngXMinusTemp, shrdRngXPlusTemp, shrdRngYMinusTemp, shrdRngYPlusTemp, shtrEboxRtnAirTemp, shtrEboxRtnAirVel, shtrMtrRtnAirTemp, shtrMtrRtnAirVel, vPPlenumInTemp));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_BodyTelemetry));
        Utiltrunk_BodyTelemetry item_ = (Utiltrunk_BodyTelemetry)item;
        Assert.assertEquals((double)ambAirtemp, (double)item_.getAmbAirtemp(), (double)1.0E-6f);
        Assert.assertEquals((double)averageTemp, (double)item_.getAverageTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngXMinusTemp, (double)item_.getBackFlngXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngXPlusTemp, (double)item_.getBackFlngXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngYMinusTemp, (double)item_.getBackFlngYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyXPlusTemp, (double)item_.getCamBodyXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyYMinusTemp, (double)item_.getCamBodyYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyYPlusTemp, (double)item_.getCamBodyYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousXMinusTemp, (double)item_.getCamHousXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousXPlusTemp, (double)item_.getCamHousXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousYMinusTemp, (double)item_.getCamHousYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousYPlusTemp, (double)item_.getCamHousYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)chgrYMinusRtnAirTemp, (double)item_.getChgrYMinusRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)chgrYMinusRtnAirVel, (double)item_.getChgrYMinusRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)domeXMinusTemp, (double)item_.getDomeXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)domeYMinusTemp, (double)item_.getDomeYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l1XMinusTemp, (double)item_.getL1XMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l1YMinusTemp, (double)item_.getL1YMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2XMinusTemp, (double)item_.getL2XMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2XPlusTemp, (double)item_.getL2XPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2YPlusTemp, (double)item_.getL2YPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngXMinusTemp, (double)item_.getShrdRngXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngXPlusTemp, (double)item_.getShrdRngXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngYMinusTemp, (double)item_.getShrdRngYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngYPlusTemp, (double)item_.getShrdRngYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrEboxRtnAirTemp, (double)item_.getShtrEboxRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrEboxRtnAirVel, (double)item_.getShtrEboxRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrMtrRtnAirTemp, (double)item_.getShtrMtrRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrMtrRtnAirVel, (double)item_.getShtrMtrRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)vPPlenumInTemp, (double)item_.getVPPlenumInTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_MPCTelemetry() throws Exception {
        double avgAirtempOut = 0.5544212460517883;
        double deltaPressFilt = 0.765832f;
        double deltaPressTotal = 0.16116386651992798;
        double deltaTempAct = 0.1671367883682251;
        double fanRunTime = 0.018184304237365723;
        double fanSpeed = 0.4517027735710144;
        double humidity = 0.11266881227493286;
        double preFiltPress = 0.431366503238678;
        double retnAirTemp = 0.344362735748291;
        double retnPress = 0.4903604984283447;
        double splyAirTemp = 0.22208797931671143;
        double splyPress = 0.013062715530395508;
        double valvePosn = 0.3209964f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_MPCTelemetry(avgAirtempOut, deltaPressFilt, deltaPressTotal, deltaTempAct, fanRunTime, fanSpeed, humidity, preFiltPress, retnAirTemp, retnPress, splyAirTemp, splyPress, valvePosn));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_MPCTelemetry));
        Utiltrunk_MPCTelemetry item_ = (Utiltrunk_MPCTelemetry)item;
        Assert.assertEquals((double)avgAirtempOut, (double)item_.getAvgAirtempOut(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressFilt, (double)item_.getDeltaPressFilt(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressTotal, (double)item_.getDeltaPressTotal(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaTempAct, (double)item_.getDeltaTempAct(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)humidity, (double)item_.getHumidity(), (double)1.0E-6f);
        Assert.assertEquals((double)preFiltPress, (double)item_.getPreFiltPress(), (double)1.0E-6f);
        Assert.assertEquals((double)retnAirTemp, (double)item_.getRetnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)retnPress, (double)item_.getRetnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirTemp, (double)item_.getSplyAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)splyPress, (double)item_.getSplyPress(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_UTTelemetry() throws Exception {
        double averageTemp = 0.913227915763855;
        double coolFlowRate = 0.6717151999473572;
        double coolHeatXfer = 0.9736396670341492;
        double coolPipeRetnTemp = 0.22381997108459473;
        double coolPipeSplyTemp = 0.5949568152427673;
        double domeXMinusTemp = 0.20298415422439575;
        double domeYMinusTemp = 0.806592583656311;
        double fanInletTemp = 0.12839365005493164;
        double fanRunTime = 0.06894189119338989;
        double fanSpeed = 0.3648301959037781;
        double midXMinusTemp = 0.5521025657653809;
        double midXPlusTemp = 0.8842726945877075;
        double suppXMinusTemp = 0.9541825652122498;
        double suppXPlusTemp = 0.3134564757347107;
        double topXMinusTemp = 0.9998443722724915;
        double topXPlusTemp = 0.5542306900024414;
        double valvePosn = 0.038711726665496826;
        double w2Q1Temp = 0.7010067105293274;
        double w4Q3Temp = 0.9853088855743408;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_UTTelemetry(averageTemp, coolFlowRate, coolHeatXfer, coolPipeRetnTemp, coolPipeSplyTemp, domeXMinusTemp, domeYMinusTemp, fanInletTemp, fanRunTime, fanSpeed, midXMinusTemp, midXPlusTemp, suppXMinusTemp, suppXPlusTemp, topXMinusTemp, topXPlusTemp, valvePosn, w2Q1Temp, w4Q3Temp));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_UTTelemetry));
        Utiltrunk_UTTelemetry item_ = (Utiltrunk_UTTelemetry)item;
        Assert.assertEquals((double)averageTemp, (double)item_.getAverageTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolHeatXfer, (double)item_.getCoolHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPipeRetnTemp, (double)item_.getCoolPipeRetnTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPipeSplyTemp, (double)item_.getCoolPipeSplyTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)domeXMinusTemp, (double)item_.getDomeXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)domeYMinusTemp, (double)item_.getDomeYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanInletTemp, (double)item_.getFanInletTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)midXMinusTemp, (double)item_.getMidXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)midXPlusTemp, (double)item_.getMidXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)suppXMinusTemp, (double)item_.getSuppXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)suppXPlusTemp, (double)item_.getSuppXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)topXMinusTemp, (double)item_.getTopXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)topXPlusTemp, (double)item_.getTopXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)w2Q1Temp, (double)item_.getW2Q1Temp(), (double)1.0E-6f);
        Assert.assertEquals((double)w4Q3Temp, (double)item_.getW4Q3Temp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_VPCTelemetry() throws Exception {
        double deltaPressFilt = 0.2551485300064087;
        double deltaPressTotal = 0.6715323328971863;
        double deltaTempAct = 0.2200194001197815;
        double fanRunTime = 0.703837513923645;
        double fanSpeed = 0.6268398761749268;
        double htrCurrent = 0.9517692923545837;
        double humidity = 0.3181915879249573;
        double preFiltPress = 0.9460634589195251;
        double retnAirTemp = 0.6447587609291077;
        double retnPress = 0.5605880618095398;
        double splyAirTemp = 0.5781629085540771;
        double splyAirVel = 0.1526598334312439;
        double splyPress = 0.6792912483215332;
        double valvePosn = 0.6390251517295837;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_VPCTelemetry(deltaPressFilt, deltaPressTotal, deltaTempAct, fanRunTime, fanSpeed, htrCurrent, humidity, preFiltPress, retnAirTemp, retnPress, splyAirTemp, splyAirVel, splyPress, valvePosn));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_VPCTelemetry));
        Utiltrunk_VPCTelemetry item_ = (Utiltrunk_VPCTelemetry)item;
        Assert.assertEquals((double)deltaPressFilt, (double)item_.getDeltaPressFilt(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressTotal, (double)item_.getDeltaPressTotal(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaTempAct, (double)item_.getDeltaTempAct(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)htrCurrent, (double)item_.getHtrCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)humidity, (double)item_.getHumidity(), (double)1.0E-6f);
        Assert.assertEquals((double)preFiltPress, (double)item_.getPreFiltPress(), (double)1.0E-6f);
        Assert.assertEquals((double)retnAirTemp, (double)item_.getRetnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)retnPress, (double)item_.getRetnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirTemp, (double)item_.getSplyAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirVel, (double)item_.getSplyAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)splyPress, (double)item_.getSplyPress(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
    }
}

