/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.event.AlertRaisedEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.CCSConfiguredEvent;
import org.lsst.sal.camera.event.Chiller_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Chiller_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Chiller_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Chiller_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Chiller_PicConfigurationEvent;
import org.lsst.sal.camera.event.Chiller_timersConfigurationEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_StatisticsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_StoreConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_StoreConfigurationEvent;
import org.lsst.sal.camera.event.EndInitializeGuiderEvent;
import org.lsst.sal.camera.event.EndInitializeImageEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.Fcs_Autochanger_autochangerConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Autochanger_readRateConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Autochanger_sensorConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus0_canbusConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus0_controllerConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus0_nodeIDConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus0_sensorConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus0_serialNBConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus1_canbusConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus1_controllerConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus1_nodeIDConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus1_serialNBConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Carousel_carouselConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Carousel_readRateConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Carousel_sensorConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_FilterIdentificator_sensorConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_FilterManager_filterConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Loader_loaderConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Loader_readRateConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Loader_sensorConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.FilterChangerPowerStatusEvent;
import org.lsst.sal.camera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageDatabaseService_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageNameService_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_InstrumentConfig_InstrumentConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_MonitoringConfig_MonitoringConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlStatusConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebTotalPower_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsPowerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_timersConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Segment_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_DAQConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_GuiderConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_SequencerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_WebHooksConfig_VisualizationConfigurationEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.Hex_Cold1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cold2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo3_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo4_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo5_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo6_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Maq20_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Maq20_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Hex_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Hex_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Hex_StatusAggregator_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.Image_handling_FitsService_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_CommandsConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_DAQConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_FitsHandlingConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_GuiderConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_StatusAggregator_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.Mpm_CLP_RTD_03_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_CLP_RTD_05_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_CLP_RTD_50_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_CLP_RTD_55_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_CYP_RTD_12_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_CYP_RTD_14_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_CYP_RTD_31_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_CYP_RTD_43_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_Pluto_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_Pluto_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_Maq20_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_Maq20_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.Rebpower_EmergencyResponseManager_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Power_timersConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_RebTotalPower_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Reb_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Reb_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_PowerConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_buildConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_PicConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_PicConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_CryoCompLimits_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_PeriodicTasks_PicConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Shutter_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Shutter_timersConfigurationEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.camera.event.SummaryStatusEvent;
import org.lsst.sal.camera.event.Thermal_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_PicConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_RefrigConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_ThermalLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_BFR_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_BFR_UtilConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_BodyMaq20_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_BodyMaq20_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_AmbAirtemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_AverageTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_BackFlngXMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_BackFlngXPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_BackFlngYMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_CamBodyXPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_CamBodyYMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_CamBodyYPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_CamHousXMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_CamHousXPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_CamHousYMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_CamHousYPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ChgrYMinusRtnAirTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ChgrYMinusRtnAirVel_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_DomeXMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_DomeYMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_L1XMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_L1YMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_L2XMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_L2XPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_L2YPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ShrdRngXMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ShrdRngXPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ShrdRngYMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ShrdRngYPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ShtrEboxRtnAirTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ShtrEboxRtnAirVel_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ShtrMtrRtnAirTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ShtrMtrRtnAirVel_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_VPPlenumInTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPCFan_PicConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_AvgAirtempOut_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_DeltaPressFilt_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_DeltaPressTotal_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_DeltaTempAct_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_FanRunTime_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_FanSpeed_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_Humidity_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_PreFiltPress_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_RetnAirTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_RetnPress_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_SplyAirTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_SplyPress_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_ValvePosn_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PDU_48V_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PDU_48V_UtilConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_AgentMonitorService_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_BodyMaq20_check_status_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Fan_loop_MPCFan_PicConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Fan_loop_UTFan_PicConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Fan_loop_VPCFan_PicConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Heartbeat_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Monitor_check_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Monitor_publish_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Monitor_update_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_RuntimeInfo_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Schedulers_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_UT_alarms_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_UT_state_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_UtMaq20_check_status_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Vpc_loop_VPCHtrs_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Telescope_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UTFan_PicConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_AverageTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_CoolFlowRate_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_CoolPipeRetnTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_CoolPipeSplyTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_DomeXMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_DomeYMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_FanInletTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_FanRunTime_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_FanSpeed_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_MidXMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_MidXPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_SuppXMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_SuppXPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_TopXMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_TopXPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_ValvePosn_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_W2Q1Temp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_W4Q3Temp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UtMaq20_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UtMaq20_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UtilConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPCFan_PicConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPCHtrs_VpcConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_DeltaPressFilt_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_DeltaPressTotal_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_DeltaTempAct_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_FanRunTime_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_FanSpeed_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_HtrCurrent_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_Humidity_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_PreFiltPress_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_RetnAirTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_RetnPress_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_SplyAirTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_SplyAirVel_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_SplyPress_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_ValvePosn_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Cip_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoFlineGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoFlineGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoTurboGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoTurboGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoTurboPump_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoTurboPump_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoVacGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoVacGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Cryo_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HX_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexFlineGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexFlineGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexTurboGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexTurboGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexTurboPump_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexTurboPump_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexVacGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexVacGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Hip_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_InstVacGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_InstVacGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Inst_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_IonPumps_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_IonPumps_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Maq20Cryo_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Maq20Cryo_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Maq20Ut_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Maq20Ut_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PDU_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PDU_VacuumConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PumpCart_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PumpCart_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_VacPluto_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_VacPluto_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_VacuumConfigurationEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 423;
        String imageName = "eicjgpqqzngepvkoozsxfdgn";
        int imageIndex = 983;
        String imageSource = "";
        String imageController = "x";
        String imageDate = "ortnj";
        int imageNumber = 16;
        double timestampAcquisitionStart = 0.1982351f;
        double requestedExposureTime = 0.4806622266769409;
        double timestampEndOfReadout = 0.02030092477798462;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, requestedExposureTime, timestampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampEndOfReadout, (double)item_.getTimestampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        double timestampTransition = 0.9029384851455688;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws Exception {
        String filterName = "";
        String filterType = "t";
        SALEvent item = this.testSendReceive((SALEvent)new StartSetFilterEvent(filterName, filterType));
        Assert.assertTrue((boolean)(item instanceof StartSetFilterEvent));
        StartSetFilterEvent item_ = (StartSetFilterEvent)item;
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws Exception {
        double timestampTransition = 0.2011834979057312;
        SALEvent item = this.testSendReceive((SALEvent)new StartUnloadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent item_ = (StartUnloadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        double timestampTransition = 0.6703230738639832;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        double timestampTransition = 0.06900107860565186;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeGuiderEvent() throws Exception {
        double timestampTransition = 0.6989688277244568;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeGuiderEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeGuiderEvent));
        EndInitializeGuiderEvent item_ = (EndInitializeGuiderEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        double timestampTransition = 0.115861f;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        String additionalKeys = "";
        String additionalValues = "n";
        int imagesInSequence = 725;
        String imageName = "iybbydygmabfrjuk";
        int imageIndex = 321;
        String imageSource = "fm";
        String imageController = "w";
        String imageDate = "oe";
        int imageNumber = 190;
        double timestampAcquisitionStart = 0.4420720338821411;
        double exposureTime = 0.039211273193359375;
        String imageTag = "crkmftcfudwlsjyvjxwjbmwlxormu";
        double timestampDateObs = 0.2913547158241272;
        double timestampDateEnd = 0.05296283960342407;
        double measuredShutterOpenTime = 0.07489949464797974;
        double darkTime = 0.7162687182426453;
        String emulatedImage = "a";
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime, emulatedImage));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)emulatedImage, (Object)item_.getEmulatedImage());
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws Exception {
        double timestampTransition = 0.38669872283935547;
        SALEvent item = this.testSendReceive((SALEvent)new EndUnloadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent item_ = (EndUnloadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws Exception {
        double timestampTransition = 0.7161986231803894;
        SALEvent item = this.testSendReceive((SALEvent)new EndRotateCarouselEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent item_ = (EndRotateCarouselEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws Exception {
        double timestampTransition = 0.3920171856880188;
        SALEvent item = this.testSendReceive((SALEvent)new StartLoadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartLoadFilterEvent));
        StartLoadFilterEvent item_ = (StartLoadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        double timestampTransition = 0.908560037612915;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        double timestampTransition = 0.7810500860214233;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveCCSConfiguredEvent() throws Exception {
        double timestampTransition = 0.668667733669281;
        SALEvent item = this.testSendReceive((SALEvent)new CCSConfiguredEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof CCSConfiguredEvent));
        CCSConfiguredEvent item_ = (CCSConfiguredEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws Exception {
        double timestampTransition = 0.6815060377120972;
        SALEvent item = this.testSendReceive((SALEvent)new EndLoadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndLoadFilterEvent));
        EndLoadFilterEvent item_ = (EndLoadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        double timestampTransition = 0.8702144026756287;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        String additionalKeys = "k";
        String additionalValues = "q";
        int imagesInSequence = 805;
        String imageName = "etslvdrdpyn";
        int imageIndex = 335;
        String imageSource = "e";
        String imageController = "";
        String imageDate = "hn";
        int imageNumber = 399;
        double timestampAcquisitionStart = 0.9397023916244507;
        double exposureTime = 0.6912664771080017;
        String mode = "v";
        double timeout = 0.5628124475479126;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, mode, timeout));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((double)timeout, (double)item_.getTimeout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeImageEvent() throws Exception {
        double timestampTransition = 0.5337963700294495;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeImageEvent));
        EndInitializeImageEvent item_ = (EndInitializeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws Exception {
        String filterName = "";
        String filterType = "";
        int filterSlot = 133;
        double filterPosition = 0.4290521740913391;
        SALEvent item = this.testSendReceive((SALEvent)new EndSetFilterEvent(filterName, filterType, filterSlot, filterPosition));
        Assert.assertTrue((boolean)(item instanceof EndSetFilterEvent));
        EndSetFilterEvent item_ = (EndSetFilterEvent)item;
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
        Assert.assertEquals((long)filterSlot, (long)item_.getFilterSlot());
        Assert.assertEquals((double)filterPosition, (double)item_.getFilterPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        double timestampTransition = 0.5368488430976868;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws Exception {
        String filterNames = "ytkjuyhyzwirzilycbyllrzadpaeuerhlvukfvlofeyceijpjijblghnyjpffbcksxwvwdpuhj";
        String filterTypes = "ouisgxhtrvwqnmenqiyjgsyfqdeelosixirsmhnddyrhmpolaatatguejjmwmfeoaclwuexojmhlpkystpmanwcangdisqfvxuqwqysiafomtyjrzxwfucnamoaezfanauhnnootuhjusprpmldiutxsqcaageunvdyvuwxmpzbhnnlfaodrmazjfkyewrpjmwrtkaigzuaqyzmyymnpodojhymuggilkxlhgpseuuibuyrlojdhzqovea";
        double maxChangeAngle = 0.18748044967651367;
        double maxFastChangeAngle = 0.15744614601135254;
        double[] maxSlowChangeTime = TestHelper.generateDoubleArray((int)6, (int)826183506);
        double[] maxFastChangeTime = TestHelper.generateDoubleArray((int)6, (int)-1182440019);
        SALEvent item = this.testSendReceive((SALEvent)new AvailableFiltersEvent(filterNames, filterTypes, maxChangeAngle, maxFastChangeAngle, maxSlowChangeTime, maxFastChangeTime));
        Assert.assertTrue((boolean)(item instanceof AvailableFiltersEvent));
        AvailableFiltersEvent item_ = (AvailableFiltersEvent)item;
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
        Assert.assertEquals((Object)filterTypes, (Object)item_.getFilterTypes());
        Assert.assertEquals((double)maxChangeAngle, (double)item_.getMaxChangeAngle(), (double)1.0E-6f);
        Assert.assertEquals((double)maxFastChangeAngle, (double)item_.getMaxFastChangeAngle(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxSlowChangeTime, (double[])item_.getMaxSlowChangeTime(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxFastChangeTime, (double[])item_.getMaxFastChangeTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        String additionalKeys = "w";
        String additionalValues = "n";
        int imagesInSequence = 672;
        String imageName = "oaorfjzvnqofqitxyuovvualrabk";
        int imageIndex = 985;
        String imageSource = "md";
        String imageController = "";
        String imageDate = "drmgb";
        int imageNumber = 894;
        double timestampAcquisitionStart = 0.13036507368087769;
        double exposureTime = 0.263749361038208;
        double timestampStartOfReadout = 0.8565203547477722;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampStartOfReadout, (double)item_.getTimestampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws Exception {
        double timestampTransition = 0.6208995580673218;
        SALEvent item = this.testSendReceive((SALEvent)new StartRotateCarouselEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent item_ = (StartRotateCarouselEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        String imageName = "t";
        String ccdLocation = "r";
        String raftBay = "a";
        String ccdSlot = "s";
        Object[] ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V};
        int[] overRows = TestHelper.generateIntArray((int)201, (int)540777305);
        int[] overCols = TestHelper.generateIntArray((int)201, (int)861964373);
        int[] readRows = TestHelper.generateIntArray((int)201, (int)1039945894);
        int[] readCols = TestHelper.generateIntArray((int)201, (int)1453464562);
        int[] readCols2 = TestHelper.generateIntArray((int)201, (int)-944841913);
        int[] preCols = TestHelper.generateIntArray((int)201, (int)-1414909128);
        int[] preRows = TestHelper.generateIntArray((int)201, (int)-1656959271);
        int[] postCols = TestHelper.generateIntArray((int)201, (int)-488729533);
        int[] underCols = TestHelper.generateIntArray((int)201, (int)679431821);
        String daqFolder = "b";
        String daqAnnotation = "v";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(imageName, ccdLocation, raftBay, ccdSlot, (ImageReadoutParametersEvent.CcdType[])ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((int[])overRows, (int[])item_.getOverRows());
        Assert.assertArrayEquals((int[])overCols, (int[])item_.getOverCols());
        Assert.assertArrayEquals((int[])readRows, (int[])item_.getReadRows());
        Assert.assertArrayEquals((int[])readCols, (int[])item_.getReadCols());
        Assert.assertArrayEquals((int[])readCols2, (int[])item_.getReadCols2());
        Assert.assertArrayEquals((int[])preCols, (int[])item_.getPreCols());
        Assert.assertArrayEquals((int[])preRows, (int[])item_.getPreRows());
        Assert.assertArrayEquals((int[])postCols, (int[])item_.getPostCols());
        Assert.assertArrayEquals((int[])underCols, (int[])item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        String ccdLocation = "q";
        String raftBay = "q";
        String ccdSlot = "w";
        String rebSerialNumber = "w";
        String rebLSSTName = "";
        String ccdLSSTName = "r";
        String raftLSSTName = "y";
        String ccdManSerNum = "z";
        String ccdManufacturer = "b";
        Object[] ccdType = new FocalPlaneSummaryInfoEvent.CcdType[]{FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL};
        double[] ccdTempSetPoint = TestHelper.generateDoubleArray((int)212, (int)997436211);
        String sequencerKey = "k";
        String sequencerChecksum = "";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, (FocalPlaneSummaryInfoEvent.CcdType[])ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((double[])ccdTempSetPoint, (double[])item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveQuadbox_BFR_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_DevicesConfigurationEvent));
        Quadbox_BFR_DevicesConfigurationEvent item_ = (Quadbox_BFR_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_BFR_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double clean_5_24V_I_warnHi = 0.14500826597213745;
        double clean_5_24V_I_warnLo = 0.10195744037628174;
        double clean_5_24V_I_limitHi = 0.7472650408744812;
        double clean_5_24V_I_limitLo = 0.7284701466560364;
        double dirty_24V_I_warnHi = 0.5455885529518127;
        double dirty_24V_I_warnLo = 0.8110129237174988;
        double dirty_24V_I_limitHi = 0.19291293621063232;
        double dirty_24V_I_limitLo = 0.7421621084213257;
        double dirty_28V_I_warnHi = 0.09804767370223999;
        double dirty_28V_I_warnLo = 0.4464316964149475;
        double dirty_28V_I_limitHi = 0.3112324f;
        double dirty_28V_I_limitLo = 0.15415281057357788;
        double dirty_48V_I_warnHi = 0.6058251857757568;
        double dirty_48V_I_warnLo = 0.10584050416946411;
        double dirty_48V_I_limitHi = 0.8688523173332214;
        double dirty_48V_I_limitLo = 0.05147433280944824;
        double protection_I_warnHi = 0.7004167437553406;
        double protection_I_warnLo = 0.6102726459503174;
        double protection_I_limitHi = 0.16373854875564575;
        double protection_I_limitLo = 0.2257222f;
        double rebps_0_2_I_warnHi = 0.6810241937637329;
        double rebps_0_2_I_warnLo = 0.1661999225616455;
        double rebps_0_2_I_limitHi = 0.9088693857192993;
        double rebps_0_2_I_limitLo = 0.11945706605911255;
        double rebps_3_5_I_warnHi = 0.2741441f;
        double rebps_3_5_I_warnLo = 0.766837f;
        double rebps_3_5_I_limitHi = 0.7217692732810974;
        double rebps_3_5_I_limitLo = 0.5272254347801208;
        double rebps_6_8_I_warnHi = 0.7229553461074829;
        double rebps_6_8_I_warnLo = 0.9956062436103821;
        double rebps_6_8_I_limitHi = 0.9965223670005798;
        double rebps_6_8_I_limitLo = 0.14721661806106567;
        double rebps_9_12_I_warnHi = 0.4042872190475464;
        double rebps_9_12_I_warnLo = 0.6199347376823425;
        double rebps_9_12_I_limitHi = 0.746765673160553;
        double rebps_9_12_I_limitLo = 0.9629706144332886;
        double rebps_Spr_I_warnHi = 0.8263643383979797;
        double rebps_Spr_I_warnLo = 0.6142929196357727;
        double rebps_Spr_I_limitHi = 0.6880226731300354;
        double rebps_Spr_I_limitLo = 0.6466214656829834;
        double total_VA_warnHi = 0.6851903200149536;
        double total_VA_warnLo = 0.41917216777801514;
        double total_VA_limitHi = 0.5601454377174377;
        double total_VA_limitLo = 0.33406996726989746;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_LimitsConfigurationEvent(version, clean_5_24V_I_warnHi, clean_5_24V_I_warnLo, clean_5_24V_I_limitHi, clean_5_24V_I_limitLo, dirty_24V_I_warnHi, dirty_24V_I_warnLo, dirty_24V_I_limitHi, dirty_24V_I_limitLo, dirty_28V_I_warnHi, dirty_28V_I_warnLo, dirty_28V_I_limitHi, dirty_28V_I_limitLo, dirty_48V_I_warnHi, dirty_48V_I_warnLo, dirty_48V_I_limitHi, dirty_48V_I_limitLo, protection_I_warnHi, protection_I_warnLo, protection_I_limitHi, protection_I_limitLo, rebps_0_2_I_warnHi, rebps_0_2_I_warnLo, rebps_0_2_I_limitHi, rebps_0_2_I_limitLo, rebps_3_5_I_warnHi, rebps_3_5_I_warnLo, rebps_3_5_I_limitHi, rebps_3_5_I_limitLo, rebps_6_8_I_warnHi, rebps_6_8_I_warnLo, rebps_6_8_I_limitHi, rebps_6_8_I_limitLo, rebps_9_12_I_warnHi, rebps_9_12_I_warnLo, rebps_9_12_I_limitHi, rebps_9_12_I_limitLo, rebps_Spr_I_warnHi, rebps_Spr_I_warnLo, rebps_Spr_I_limitHi, rebps_Spr_I_limitLo, total_VA_warnHi, total_VA_warnLo, total_VA_limitHi, total_VA_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_LimitsConfigurationEvent));
        Quadbox_BFR_LimitsConfigurationEvent item_ = (Quadbox_BFR_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)clean_5_24V_I_warnHi, (double)item_.getClean_5_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_warnLo, (double)item_.getClean_5_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitHi, (double)item_.getClean_5_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitLo, (double)item_.getClean_5_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnHi, (double)item_.getDirty_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnLo, (double)item_.getDirty_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitHi, (double)item_.getDirty_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitLo, (double)item_.getDirty_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnHi, (double)item_.getDirty_28V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnLo, (double)item_.getDirty_28V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitHi, (double)item_.getDirty_28V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitLo, (double)item_.getDirty_28V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnHi, (double)item_.getDirty_48V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnLo, (double)item_.getDirty_48V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitHi, (double)item_.getDirty_48V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitLo, (double)item_.getDirty_48V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnHi, (double)item_.getProtection_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnLo, (double)item_.getProtection_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitHi, (double)item_.getProtection_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitLo, (double)item_.getProtection_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_warnHi, (double)item_.getRebps_0_2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_warnLo, (double)item_.getRebps_0_2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_limitHi, (double)item_.getRebps_0_2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_limitLo, (double)item_.getRebps_0_2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_warnHi, (double)item_.getRebps_3_5_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_warnLo, (double)item_.getRebps_3_5_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_limitHi, (double)item_.getRebps_3_5_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_limitLo, (double)item_.getRebps_3_5_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_warnHi, (double)item_.getRebps_6_8_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_warnLo, (double)item_.getRebps_6_8_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_limitHi, (double)item_.getRebps_6_8_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_limitLo, (double)item_.getRebps_6_8_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_warnHi, (double)item_.getRebps_9_12_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_warnLo, (double)item_.getRebps_9_12_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_limitHi, (double)item_.getRebps_9_12_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_limitLo, (double)item_.getRebps_9_12_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_warnHi, (double)item_.getRebps_Spr_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_warnLo, (double)item_.getRebps_Spr_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_limitHi, (double)item_.getRebps_Spr_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_limitLo, (double)item_.getRebps_Spr_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)total_VA_warnHi, (double)item_.getTotal_VA_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)total_VA_warnLo, (double)item_.getTotal_VA_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)total_VA_limitHi, (double)item_.getTotal_VA_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)total_VA_limitLo, (double)item_.getTotal_VA_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFR_QuadboxConfigurationEvent() throws Exception {
        String version = "q";
        int node = 839;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_QuadboxConfigurationEvent));
        Quadbox_BFR_QuadboxConfigurationEvent item_ = (Quadbox_BFR_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_Maq20_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String node = "";
        String serials = "e";
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_Maq20_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Quadbox_Maq20_DeviceConfigurationEvent));
        Quadbox_Maq20_DeviceConfigurationEvent item_ = (Quadbox_Maq20_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveQuadbox_Maq20_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_Maq20_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_Maq20_DevicesConfigurationEvent));
        Quadbox_Maq20_DevicesConfigurationEvent item_ = (Quadbox_Maq20_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_DevicesConfigurationEvent));
        Quadbox_PDU_24VC_DevicesConfigurationEvent item_ = (Quadbox_PDU_24VC_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double board_T_warnHi = 0.2018665075302124;
        double board_T_warnLo = 0.8623965978622437;
        double board_T_limitHi = 0.2078021764755249;
        double board_T_limitLo = 0.027436554431915283;
        double body_Maq20_I_warnHi = 0.3213622570037842;
        double body_Maq20_I_warnLo = 0.8489788770675659;
        double body_Maq20_I_limitHi = 0.17418742179870605;
        double body_Maq20_I_limitLo = 0.08984065055847168;
        double body_Maq20_V_warnHi = 0.4241867661476135;
        double body_Maq20_V_warnLo = 0.9418308734893799;
        double body_Maq20_V_limitHi = 0.9684880375862122;
        double body_Maq20_V_limitLo = 0.9527187347412109;
        double cryo_Maq20_I_warnHi = 0.18455815315246582;
        double cryo_Maq20_I_warnLo = 0.6065274477005005;
        double cryo_Maq20_I_limitHi = 0.4981291890144348;
        double cryo_Maq20_I_limitLo = 0.8888053894042969;
        double cryo_Maq20_V_warnHi = 0.24716395139694214;
        double cryo_Maq20_V_warnLo = 0.18402493000030518;
        double cryo_Maq20_V_limitHi = 0.9244294762611389;
        double cryo_Maq20_V_limitLo = 0.7530982494354248;
        double fes_CarouselC_I_warnHi = 0.6354634165763855;
        double fes_CarouselC_I_warnLo = 0.11419862508773804;
        double fes_CarouselC_I_limitHi = 0.06763821840286255;
        double fes_CarouselC_I_limitLo = 0.15208107233047485;
        double fes_CarouselC_V_warnHi = 0.502015f;
        double fes_CarouselC_V_warnLo = 0.4687958359718323;
        double fes_CarouselC_V_limitHi = 0.2776569128036499;
        double fes_CarouselC_V_limitLo = 0.8017957806587219;
        double fes_ChangerC_I_warnHi = 0.646397590637207;
        double fes_ChangerC_I_warnLo = 0.11037266254425049;
        double fes_ChangerC_I_limitHi = 0.4113478f;
        double fes_ChangerC_I_limitLo = 0.2250347137451172;
        double fes_ChangerC_V_warnHi = 0.3065752387046814;
        double fes_ChangerC_V_warnLo = 0.4486308693885803;
        double fes_ChangerC_V_limitHi = 0.5043429136276245;
        double fes_ChangerC_V_limitLo = 0.11318850517272949;
        double fes_LoaderC_I_warnHi = 0.511311f;
        double fes_LoaderC_I_warnLo = 0.8501695990562439;
        double fes_LoaderC_I_limitHi = 0.10861527919769287;
        double fes_LoaderC_I_limitLo = 0.13340067863464355;
        double fes_LoaderC_V_warnHi = 0.909978985786438;
        double fes_LoaderC_V_warnLo = 0.632366418838501;
        double fes_LoaderC_V_limitHi = 0.8650884032249451;
        double fes_LoaderC_V_limitLo = 0.033549726009368896;
        double fpga_T_warnHi = 0.6954838037490845;
        double fpga_T_warnLo = 0.11287665367126465;
        double fpga_T_limitHi = 0.674673318862915;
        double fpga_T_limitLo = 0.06375402212142944;
        double gauges_I_warnHi = 0.5577300786972046;
        double gauges_I_warnLo = 0.0346936f;
        double gauges_I_limitHi = 0.25591927766799927;
        double gauges_I_limitLo = 0.861728f;
        double gauges_V_warnHi = 0.6790806651115417;
        double gauges_V_warnLo = 0.500071f;
        double gauges_V_limitHi = 0.0706256628036499;
        double gauges_V_limitLo = 0.5492081046104431;
        double int_Valves_I_warnHi = 0.5675011873245239;
        double int_Valves_I_warnLo = 0.2477231f;
        double int_Valves_I_limitHi = 0.6511227488517761;
        double int_Valves_I_limitLo = 0.25721925497055054;
        double int_Valves_V_warnHi = 0.053745925426483154;
        double int_Valves_V_warnLo = 0.13506555557250977;
        double int_Valves_V_limitHi = 0.5684199333190918;
        double int_Valves_V_limitLo = 0.1792144775390625;
        double ion_Pumps_I_warnHi = 0.420258f;
        double ion_Pumps_I_warnLo = 0.24494272470474243;
        double ion_Pumps_I_limitHi = 0.3861231803894043;
        double ion_Pumps_I_limitLo = 0.47374796867370605;
        double ion_Pumps_V_warnHi = 0.32380956411361694;
        double ion_Pumps_V_warnLo = 0.34402942657470703;
        double ion_Pumps_V_limitHi = 0.40112733840942383;
        double ion_Pumps_V_limitLo = 0.4736320972442627;
        double main_I_warnHi = 0.6918114423751831;
        double main_I_warnLo = 0.963251531124115;
        double main_I_limitHi = 0.18191653490066528;
        double main_I_limitLo = 0.16838771104812622;
        double main_T_warnHi = 0.9623038172721863;
        double main_T_warnLo = 0.15011334419250488;
        double main_T_limitHi = 0.48530107736587524;
        double main_T_limitLo = 0.4137721657752991;
        double main_V_warnHi = 0.0766598f;
        double main_V_warnLo = 0.7253578305244446;
        double main_V_limitHi = 0.1221545934677124;
        double main_V_limitLo = 0.779416024684906;
        double shtr_PLC1_I_warnHi = 0.2768756151199341;
        double shtr_PLC1_I_warnLo = 0.4441349506378174;
        double shtr_PLC1_I_limitHi = 0.5148841738700867;
        double shtr_PLC1_I_limitLo = 0.00691455602645874;
        double shtr_PLC1_V_warnHi = 0.5889905095100403;
        double shtr_PLC1_V_warnLo = 0.862678587436676;
        double shtr_PLC1_V_limitHi = 0.759788f;
        double shtr_PLC1_V_limitLo = 0.24051225185394287;
        double shtr_PLC2_I_warnHi = 0.5518115162849426;
        double shtr_PLC2_I_warnLo = 0.5088573098182678;
        double shtr_PLC2_I_limitHi = 0.8950796723365784;
        double shtr_PLC2_I_limitLo = 0.17582905292510986;
        double shtr_PLC2_V_warnHi = 0.26496803760528564;
        double shtr_PLC2_V_warnLo = 0.4779793620109558;
        double shtr_PLC2_V_limitHi = 0.15224981307983398;
        double shtr_PLC2_V_limitLo = 0.10457044839859009;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_LimitsConfigurationEvent(version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, body_Maq20_I_warnHi, body_Maq20_I_warnLo, body_Maq20_I_limitHi, body_Maq20_I_limitLo, body_Maq20_V_warnHi, body_Maq20_V_warnLo, body_Maq20_V_limitHi, body_Maq20_V_limitLo, cryo_Maq20_I_warnHi, cryo_Maq20_I_warnLo, cryo_Maq20_I_limitHi, cryo_Maq20_I_limitLo, cryo_Maq20_V_warnHi, cryo_Maq20_V_warnLo, cryo_Maq20_V_limitHi, cryo_Maq20_V_limitLo, fes_CarouselC_I_warnHi, fes_CarouselC_I_warnLo, fes_CarouselC_I_limitHi, fes_CarouselC_I_limitLo, fes_CarouselC_V_warnHi, fes_CarouselC_V_warnLo, fes_CarouselC_V_limitHi, fes_CarouselC_V_limitLo, fes_ChangerC_I_warnHi, fes_ChangerC_I_warnLo, fes_ChangerC_I_limitHi, fes_ChangerC_I_limitLo, fes_ChangerC_V_warnHi, fes_ChangerC_V_warnLo, fes_ChangerC_V_limitHi, fes_ChangerC_V_limitLo, fes_LoaderC_I_warnHi, fes_LoaderC_I_warnLo, fes_LoaderC_I_limitHi, fes_LoaderC_I_limitLo, fes_LoaderC_V_warnHi, fes_LoaderC_V_warnLo, fes_LoaderC_V_limitHi, fes_LoaderC_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, gauges_I_warnHi, gauges_I_warnLo, gauges_I_limitHi, gauges_I_limitLo, gauges_V_warnHi, gauges_V_warnLo, gauges_V_limitHi, gauges_V_limitLo, int_Valves_I_warnHi, int_Valves_I_warnLo, int_Valves_I_limitHi, int_Valves_I_limitLo, int_Valves_V_warnHi, int_Valves_V_warnLo, int_Valves_V_limitHi, int_Valves_V_limitLo, ion_Pumps_I_warnHi, ion_Pumps_I_warnLo, ion_Pumps_I_limitHi, ion_Pumps_I_limitLo, ion_Pumps_V_warnHi, ion_Pumps_V_warnLo, ion_Pumps_V_limitHi, ion_Pumps_V_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo, shtr_PLC1_I_warnHi, shtr_PLC1_I_warnLo, shtr_PLC1_I_limitHi, shtr_PLC1_I_limitLo, shtr_PLC1_V_warnHi, shtr_PLC1_V_warnLo, shtr_PLC1_V_limitHi, shtr_PLC1_V_limitLo, shtr_PLC2_I_warnHi, shtr_PLC2_I_warnLo, shtr_PLC2_I_limitHi, shtr_PLC2_I_limitLo, shtr_PLC2_V_warnHi, shtr_PLC2_V_warnLo, shtr_PLC2_V_limitHi, shtr_PLC2_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_LimitsConfigurationEvent));
        Quadbox_PDU_24VC_LimitsConfigurationEvent item_ = (Quadbox_PDU_24VC_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I_warnHi, (double)item_.getBody_Maq20_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I_warnLo, (double)item_.getBody_Maq20_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I_limitHi, (double)item_.getBody_Maq20_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I_limitLo, (double)item_.getBody_Maq20_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V_warnHi, (double)item_.getBody_Maq20_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V_warnLo, (double)item_.getBody_Maq20_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V_limitHi, (double)item_.getBody_Maq20_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V_limitLo, (double)item_.getBody_Maq20_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I_warnHi, (double)item_.getCryo_Maq20_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I_warnLo, (double)item_.getCryo_Maq20_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I_limitHi, (double)item_.getCryo_Maq20_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I_limitLo, (double)item_.getCryo_Maq20_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V_warnHi, (double)item_.getCryo_Maq20_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V_warnLo, (double)item_.getCryo_Maq20_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V_limitHi, (double)item_.getCryo_Maq20_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V_limitLo, (double)item_.getCryo_Maq20_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I_warnHi, (double)item_.getFes_CarouselC_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I_warnLo, (double)item_.getFes_CarouselC_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I_limitHi, (double)item_.getFes_CarouselC_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I_limitLo, (double)item_.getFes_CarouselC_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V_warnHi, (double)item_.getFes_CarouselC_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V_warnLo, (double)item_.getFes_CarouselC_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V_limitHi, (double)item_.getFes_CarouselC_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V_limitLo, (double)item_.getFes_CarouselC_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I_warnHi, (double)item_.getFes_ChangerC_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I_warnLo, (double)item_.getFes_ChangerC_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I_limitHi, (double)item_.getFes_ChangerC_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I_limitLo, (double)item_.getFes_ChangerC_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V_warnHi, (double)item_.getFes_ChangerC_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V_warnLo, (double)item_.getFes_ChangerC_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V_limitHi, (double)item_.getFes_ChangerC_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V_limitLo, (double)item_.getFes_ChangerC_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I_warnHi, (double)item_.getFes_LoaderC_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I_warnLo, (double)item_.getFes_LoaderC_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I_limitHi, (double)item_.getFes_LoaderC_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I_limitLo, (double)item_.getFes_LoaderC_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V_warnHi, (double)item_.getFes_LoaderC_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V_warnLo, (double)item_.getFes_LoaderC_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V_limitHi, (double)item_.getFes_LoaderC_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V_limitLo, (double)item_.getFes_LoaderC_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnHi, (double)item_.getGauges_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnLo, (double)item_.getGauges_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitHi, (double)item_.getGauges_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitLo, (double)item_.getGauges_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnHi, (double)item_.getGauges_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnLo, (double)item_.getGauges_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitHi, (double)item_.getGauges_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitLo, (double)item_.getGauges_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I_warnHi, (double)item_.getInt_Valves_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I_warnLo, (double)item_.getInt_Valves_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I_limitHi, (double)item_.getInt_Valves_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I_limitLo, (double)item_.getInt_Valves_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V_warnHi, (double)item_.getInt_Valves_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V_warnLo, (double)item_.getInt_Valves_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V_limitHi, (double)item_.getInt_Valves_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V_limitLo, (double)item_.getInt_Valves_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnHi, (double)item_.getIon_Pumps_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnLo, (double)item_.getIon_Pumps_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitHi, (double)item_.getIon_Pumps_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitLo, (double)item_.getIon_Pumps_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnHi, (double)item_.getIon_Pumps_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnLo, (double)item_.getIon_Pumps_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitHi, (double)item_.getIon_Pumps_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitLo, (double)item_.getIon_Pumps_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I_warnHi, (double)item_.getShtr_PLC1_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I_warnLo, (double)item_.getShtr_PLC1_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I_limitHi, (double)item_.getShtr_PLC1_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I_limitLo, (double)item_.getShtr_PLC1_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V_warnHi, (double)item_.getShtr_PLC1_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V_warnLo, (double)item_.getShtr_PLC1_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V_limitHi, (double)item_.getShtr_PLC1_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V_limitLo, (double)item_.getShtr_PLC1_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I_warnHi, (double)item_.getShtr_PLC2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I_warnLo, (double)item_.getShtr_PLC2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I_limitHi, (double)item_.getShtr_PLC2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I_limitLo, (double)item_.getShtr_PLC2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V_warnHi, (double)item_.getShtr_PLC2_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V_warnLo, (double)item_.getShtr_PLC2_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V_limitHi, (double)item_.getShtr_PLC2_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V_limitLo, (double)item_.getShtr_PLC2_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_QuadboxConfigurationEvent() throws Exception {
        String version = "o";
        int node = 554;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_QuadboxConfigurationEvent));
        Quadbox_PDU_24VC_QuadboxConfigurationEvent item_ = (Quadbox_PDU_24VC_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_DevicesConfigurationEvent));
        Quadbox_PDU_24VD_DevicesConfigurationEvent item_ = (Quadbox_PDU_24VD_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double board_T_warnHi = 0.9024807214736938;
        double board_T_warnLo = 0.9873150587081909;
        double board_T_limitHi = 0.7804882526397705;
        double board_T_limitLo = 0.21205365657806396;
        double cryo_Turbo_I_warnHi = 0.19770705699920654;
        double cryo_Turbo_I_warnLo = 0.0017998814582824707;
        double cryo_Turbo_I_limitHi = 0.893978476524353;
        double cryo_Turbo_I_limitLo = 0.5026865005493164;
        double cryo_Turbo_V_warnHi = 0.2176659107208252;
        double cryo_Turbo_V_warnLo = 0.6090694069862366;
        double cryo_Turbo_V_limitHi = 0.9734766483306885;
        double cryo_Turbo_V_limitLo = 0.8928537964820862;
        double fes_Brakes_I_warnHi = 0.0497211217880249;
        double fes_Brakes_I_warnLo = 0.2681116461753845;
        double fes_Brakes_I_limitHi = 0.529084324836731;
        double fes_Brakes_I_limitLo = 0.05878615379333496;
        double fes_Brakes_V_warnHi = 0.5883772969245911;
        double fes_Brakes_V_warnLo = 0.6124424338340759;
        double fes_Brakes_V_limitHi = 0.928119f;
        double fes_Brakes_V_limitLo = 0.25203055143356323;
        double fes_ChangerD_I_warnHi = 0.23448187112808228;
        double fes_ChangerD_I_warnLo = 0.06101113557815552;
        double fes_ChangerD_I_limitHi = 0.2818338871002197;
        double fes_ChangerD_I_limitLo = 0.35309863090515137;
        double fes_ChangerD_V_warnHi = 0.937881f;
        double fes_ChangerD_V_warnLo = 0.7643618583679199;
        double fes_ChangerD_V_limitHi = 0.35663992166519165;
        double fes_ChangerD_V_limitLo = 0.7248210906982422;
        double fes_Clamps_I_warnHi = 0.00886458158493042;
        double fes_Clamps_I_warnLo = 0.8635683059692383;
        double fes_Clamps_I_limitHi = 0.525514f;
        double fes_Clamps_I_limitLo = 0.4517327547073364;
        double fes_Clamps_V_warnHi = 0.9946938753128052;
        double fes_Clamps_V_warnLo = 0.11279827356338501;
        double fes_Clamps_V_limitHi = 0.8843053579330444;
        double fes_Clamps_V_limitLo = 0.9963942170143127;
        double fes_LoaderD_I_warnHi = 0.4767602f;
        double fes_LoaderD_I_warnLo = 0.7324386835098267;
        double fes_LoaderD_I_limitHi = 0.0687408447265625;
        double fes_LoaderD_I_limitLo = 0.14175671339035034;
        double fes_LoaderD_V_warnHi = 0.2010408f;
        double fes_LoaderD_V_warnLo = 0.16168522834777832;
        double fes_LoaderD_V_limitHi = 0.02596902847290039;
        double fes_LoaderD_V_limitLo = 0.35271936655044556;
        double fpga_T_warnHi = 0.522193193435669;
        double fpga_T_warnLo = 0.05116891860961914;
        double fpga_T_limitHi = 0.8524715900421143;
        double fpga_T_limitLo = 0.677761971950531;
        double hex_Turbo_I_warnHi = 0.6856864094734192;
        double hex_Turbo_I_warnLo = 0.15195822715759277;
        double hex_Turbo_I_limitHi = 0.7192482352256775;
        double hex_Turbo_I_limitLo = 0.8364443778991699;
        double hex_Turbo_V_warnHi = 0.161748468875885;
        double hex_Turbo_V_warnLo = 0.6321895122528076;
        double hex_Turbo_V_limitHi = 0.10460102558135986;
        double hex_Turbo_V_limitLo = 0.7797408103942871;
        double main_I_warnHi = 0.7016832828521729;
        double main_I_warnLo = 0.0922970175743103;
        double main_I_limitHi = 0.8619933128356934;
        double main_I_limitLo = 0.3623538017272949;
        double main_T_warnHi = 0.33647865056991577;
        double main_T_warnLo = 0.10063028335571289;
        double main_T_limitHi = 0.710841f;
        double main_T_limitLo = 0.6896804571151733;
        double main_V_warnHi = 0.4579014182090759;
        double main_V_warnLo = 0.2700703740119934;
        double main_V_limitHi = 0.27534347772598267;
        double main_V_limitLo = 0.5729556679725647;
        double shtr_Brakes_I_warnHi = 0.8949098587036133;
        double shtr_Brakes_I_warnLo = 0.7206348180770874;
        double shtr_Brakes_I_limitHi = 0.8623384237289429;
        double shtr_Brakes_I_limitLo = 0.4858793616294861;
        double shtr_Brakes_V_warnHi = 0.45777201652526855;
        double shtr_Brakes_V_warnLo = 0.5911467671394348;
        double shtr_Brakes_V_limitHi = 0.393549382686615;
        double shtr_Brakes_V_limitLo = 0.6219715476036072;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_LimitsConfigurationEvent(version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, cryo_Turbo_I_warnHi, cryo_Turbo_I_warnLo, cryo_Turbo_I_limitHi, cryo_Turbo_I_limitLo, cryo_Turbo_V_warnHi, cryo_Turbo_V_warnLo, cryo_Turbo_V_limitHi, cryo_Turbo_V_limitLo, fes_Brakes_I_warnHi, fes_Brakes_I_warnLo, fes_Brakes_I_limitHi, fes_Brakes_I_limitLo, fes_Brakes_V_warnHi, fes_Brakes_V_warnLo, fes_Brakes_V_limitHi, fes_Brakes_V_limitLo, fes_ChangerD_I_warnHi, fes_ChangerD_I_warnLo, fes_ChangerD_I_limitHi, fes_ChangerD_I_limitLo, fes_ChangerD_V_warnHi, fes_ChangerD_V_warnLo, fes_ChangerD_V_limitHi, fes_ChangerD_V_limitLo, fes_Clamps_I_warnHi, fes_Clamps_I_warnLo, fes_Clamps_I_limitHi, fes_Clamps_I_limitLo, fes_Clamps_V_warnHi, fes_Clamps_V_warnLo, fes_Clamps_V_limitHi, fes_Clamps_V_limitLo, fes_LoaderD_I_warnHi, fes_LoaderD_I_warnLo, fes_LoaderD_I_limitHi, fes_LoaderD_I_limitLo, fes_LoaderD_V_warnHi, fes_LoaderD_V_warnLo, fes_LoaderD_V_limitHi, fes_LoaderD_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, hex_Turbo_I_warnHi, hex_Turbo_I_warnLo, hex_Turbo_I_limitHi, hex_Turbo_I_limitLo, hex_Turbo_V_warnHi, hex_Turbo_V_warnLo, hex_Turbo_V_limitHi, hex_Turbo_V_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo, shtr_Brakes_I_warnHi, shtr_Brakes_I_warnLo, shtr_Brakes_I_limitHi, shtr_Brakes_I_limitLo, shtr_Brakes_V_warnHi, shtr_Brakes_V_warnLo, shtr_Brakes_V_limitHi, shtr_Brakes_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_LimitsConfigurationEvent));
        Quadbox_PDU_24VD_LimitsConfigurationEvent item_ = (Quadbox_PDU_24VD_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_warnHi, (double)item_.getCryo_Turbo_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_warnLo, (double)item_.getCryo_Turbo_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_limitHi, (double)item_.getCryo_Turbo_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_limitLo, (double)item_.getCryo_Turbo_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_warnHi, (double)item_.getCryo_Turbo_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_warnLo, (double)item_.getCryo_Turbo_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_limitHi, (double)item_.getCryo_Turbo_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_limitLo, (double)item_.getCryo_Turbo_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I_warnHi, (double)item_.getFes_Brakes_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I_warnLo, (double)item_.getFes_Brakes_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I_limitHi, (double)item_.getFes_Brakes_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I_limitLo, (double)item_.getFes_Brakes_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V_warnHi, (double)item_.getFes_Brakes_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V_warnLo, (double)item_.getFes_Brakes_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V_limitHi, (double)item_.getFes_Brakes_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V_limitLo, (double)item_.getFes_Brakes_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I_warnHi, (double)item_.getFes_ChangerD_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I_warnLo, (double)item_.getFes_ChangerD_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I_limitHi, (double)item_.getFes_ChangerD_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I_limitLo, (double)item_.getFes_ChangerD_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V_warnHi, (double)item_.getFes_ChangerD_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V_warnLo, (double)item_.getFes_ChangerD_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V_limitHi, (double)item_.getFes_ChangerD_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V_limitLo, (double)item_.getFes_ChangerD_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I_warnHi, (double)item_.getFes_Clamps_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I_warnLo, (double)item_.getFes_Clamps_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I_limitHi, (double)item_.getFes_Clamps_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I_limitLo, (double)item_.getFes_Clamps_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V_warnHi, (double)item_.getFes_Clamps_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V_warnLo, (double)item_.getFes_Clamps_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V_limitHi, (double)item_.getFes_Clamps_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V_limitLo, (double)item_.getFes_Clamps_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I_warnHi, (double)item_.getFes_LoaderD_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I_warnLo, (double)item_.getFes_LoaderD_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I_limitHi, (double)item_.getFes_LoaderD_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I_limitLo, (double)item_.getFes_LoaderD_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V_warnHi, (double)item_.getFes_LoaderD_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V_warnLo, (double)item_.getFes_LoaderD_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V_limitHi, (double)item_.getFes_LoaderD_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V_limitLo, (double)item_.getFes_LoaderD_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_warnHi, (double)item_.getHex_Turbo_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_warnLo, (double)item_.getHex_Turbo_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_limitHi, (double)item_.getHex_Turbo_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_limitLo, (double)item_.getHex_Turbo_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_warnHi, (double)item_.getHex_Turbo_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_warnLo, (double)item_.getHex_Turbo_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_limitHi, (double)item_.getHex_Turbo_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_limitLo, (double)item_.getHex_Turbo_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I_warnHi, (double)item_.getShtr_Brakes_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I_warnLo, (double)item_.getShtr_Brakes_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I_limitHi, (double)item_.getShtr_Brakes_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I_limitLo, (double)item_.getShtr_Brakes_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V_warnHi, (double)item_.getShtr_Brakes_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V_warnLo, (double)item_.getShtr_Brakes_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V_limitHi, (double)item_.getShtr_Brakes_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V_limitLo, (double)item_.getShtr_Brakes_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_QuadboxConfigurationEvent() throws Exception {
        String version = "";
        int node = 780;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_QuadboxConfigurationEvent));
        Quadbox_PDU_24VD_QuadboxConfigurationEvent item_ = (Quadbox_PDU_24VD_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_DevicesConfigurationEvent() throws Exception {
        String version = "g";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_DevicesConfigurationEvent));
        Quadbox_PDU_48V_DevicesConfigurationEvent item_ = (Quadbox_PDU_48V_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double board_T_warnHi = 0.767871618270874;
        double board_T_warnLo = 0.2619808316230774;
        double board_T_limitHi = 0.48851585388183594;
        double board_T_limitLo = 0.3681f;
        double fes_CarouselD_I_warnHi = 0.177703857421875;
        double fes_CarouselD_I_warnLo = 0.8507076501846313;
        double fes_CarouselD_I_limitHi = 0.3890703320503235;
        double fes_CarouselD_I_limitLo = 0.8853934407234192;
        double fes_CarouselD_V_warnHi = 0.16424894332885742;
        double fes_CarouselD_V_warnLo = 0.582197368144989;
        double fes_CarouselD_V_limitHi = 0.5306582450866699;
        double fes_CarouselD_V_limitLo = 0.2015218734741211;
        double fes_Heater_I_warnHi = 0.5292513370513916;
        double fes_Heater_I_warnLo = 0.5915347337722778;
        double fes_Heater_I_limitHi = 0.17069f;
        double fes_Heater_I_limitLo = 0.6826686859130859;
        double fes_Heater_V_warnHi = 0.6330636143684387;
        double fes_Heater_V_warnLo = 0.49333226680755615;
        double fes_Heater_V_limitHi = 0.05587393045425415;
        double fes_Heater_V_limitLo = 0.5080180764198303;
        double fpga_T_warnHi = 0.3663373f;
        double fpga_T_warnLo = 0.9903306365013123;
        double fpga_T_limitHi = 0.28888654708862305;
        double fpga_T_limitLo = 0.43917596340179443;
        double main_I_warnHi = 0.4342119097709656;
        double main_I_warnLo = 0.5887249112129211;
        double main_I_limitHi = 0.47140854597091675;
        double main_I_limitLo = 0.10862231254577637;
        double main_T_warnHi = 0.3732417821884155;
        double main_T_warnLo = 0.376612f;
        double main_T_limitHi = 0.562292f;
        double main_T_limitLo = 0.11836177110671997;
        double main_V_warnHi = 0.11182254552841187;
        double main_V_warnLo = 0.32439786195755005;
        double main_V_limitHi = 0.630763053894043;
        double main_V_limitLo = 0.2564527988433838;
        double purge_Fan_I_warnHi = 0.018869996070861816;
        double purge_Fan_I_warnLo = 0.5753469467163086;
        double purge_Fan_I_limitHi = 0.7712225317955017;
        double purge_Fan_I_limitLo = 0.03604203462600708;
        double purge_Fan_V_warnHi = 0.3303477168083191;
        double purge_Fan_V_warnLo = 0.5554215312004089;
        double purge_Fan_V_limitHi = 0.4535815119743347;
        double purge_Fan_V_limitLo = 0.7351964116096497;
        double shtr_Motor1_I_warnHi = 0.49444258213043213;
        double shtr_Motor1_I_warnLo = 0.5544989109039307;
        double shtr_Motor1_I_limitHi = 0.03947758674621582;
        double shtr_Motor1_I_limitLo = 0.2531300187110901;
        double shtr_Motor1_V_warnHi = 0.307384f;
        double shtr_Motor1_V_warnLo = 0.3419477939605713;
        double shtr_Motor1_V_limitHi = 0.8316075205802917;
        double shtr_Motor1_V_limitLo = 0.6268974542617798;
        double shtr_Motor2_I_warnHi = 0.02484762668609619;
        double shtr_Motor2_I_warnLo = 0.7699902057647705;
        double shtr_Motor2_I_limitHi = 0.025355935096740723;
        double shtr_Motor2_I_limitLo = 0.590442f;
        double shtr_Motor2_V_warnHi = 0.808464765548706;
        double shtr_Motor2_V_warnLo = 0.5955008864402771;
        double shtr_Motor2_V_limitHi = 0.18658453226089478;
        double shtr_Motor2_V_limitLo = 0.3638281226158142;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_LimitsConfigurationEvent(version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, fes_CarouselD_I_warnHi, fes_CarouselD_I_warnLo, fes_CarouselD_I_limitHi, fes_CarouselD_I_limitLo, fes_CarouselD_V_warnHi, fes_CarouselD_V_warnLo, fes_CarouselD_V_limitHi, fes_CarouselD_V_limitLo, fes_Heater_I_warnHi, fes_Heater_I_warnLo, fes_Heater_I_limitHi, fes_Heater_I_limitLo, fes_Heater_V_warnHi, fes_Heater_V_warnLo, fes_Heater_V_limitHi, fes_Heater_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo, purge_Fan_I_warnHi, purge_Fan_I_warnLo, purge_Fan_I_limitHi, purge_Fan_I_limitLo, purge_Fan_V_warnHi, purge_Fan_V_warnLo, purge_Fan_V_limitHi, purge_Fan_V_limitLo, shtr_Motor1_I_warnHi, shtr_Motor1_I_warnLo, shtr_Motor1_I_limitHi, shtr_Motor1_I_limitLo, shtr_Motor1_V_warnHi, shtr_Motor1_V_warnLo, shtr_Motor1_V_limitHi, shtr_Motor1_V_limitLo, shtr_Motor2_I_warnHi, shtr_Motor2_I_warnLo, shtr_Motor2_I_limitHi, shtr_Motor2_I_limitLo, shtr_Motor2_V_warnHi, shtr_Motor2_V_warnLo, shtr_Motor2_V_limitHi, shtr_Motor2_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_LimitsConfigurationEvent));
        Quadbox_PDU_48V_LimitsConfigurationEvent item_ = (Quadbox_PDU_48V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I_warnHi, (double)item_.getFes_CarouselD_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I_warnLo, (double)item_.getFes_CarouselD_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I_limitHi, (double)item_.getFes_CarouselD_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I_limitLo, (double)item_.getFes_CarouselD_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V_warnHi, (double)item_.getFes_CarouselD_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V_warnLo, (double)item_.getFes_CarouselD_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V_limitHi, (double)item_.getFes_CarouselD_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V_limitLo, (double)item_.getFes_CarouselD_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I_warnHi, (double)item_.getFes_Heater_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I_warnLo, (double)item_.getFes_Heater_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I_limitHi, (double)item_.getFes_Heater_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I_limitLo, (double)item_.getFes_Heater_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V_warnHi, (double)item_.getFes_Heater_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V_warnLo, (double)item_.getFes_Heater_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V_limitHi, (double)item_.getFes_Heater_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V_limitLo, (double)item_.getFes_Heater_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_warnHi, (double)item_.getPurge_Fan_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_warnLo, (double)item_.getPurge_Fan_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_limitHi, (double)item_.getPurge_Fan_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_limitLo, (double)item_.getPurge_Fan_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_warnHi, (double)item_.getPurge_Fan_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_warnLo, (double)item_.getPurge_Fan_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_limitHi, (double)item_.getPurge_Fan_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_limitLo, (double)item_.getPurge_Fan_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I_warnHi, (double)item_.getShtr_Motor1_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I_warnLo, (double)item_.getShtr_Motor1_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I_limitHi, (double)item_.getShtr_Motor1_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I_limitLo, (double)item_.getShtr_Motor1_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V_warnHi, (double)item_.getShtr_Motor1_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V_warnLo, (double)item_.getShtr_Motor1_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V_limitHi, (double)item_.getShtr_Motor1_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V_limitLo, (double)item_.getShtr_Motor1_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I_warnHi, (double)item_.getShtr_Motor2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I_warnLo, (double)item_.getShtr_Motor2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I_limitHi, (double)item_.getShtr_Motor2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I_limitLo, (double)item_.getShtr_Motor2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V_warnHi, (double)item_.getShtr_Motor2_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V_warnLo, (double)item_.getShtr_Motor2_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V_limitHi, (double)item_.getShtr_Motor2_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V_limitLo, (double)item_.getShtr_Motor2_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_QuadboxConfigurationEvent() throws Exception {
        String version = "n";
        int node = 100;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_QuadboxConfigurationEvent));
        Quadbox_PDU_48V_QuadboxConfigurationEvent item_ = (Quadbox_PDU_48V_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_DevicesConfigurationEvent));
        Quadbox_PDU_5V_DevicesConfigurationEvent item_ = (Quadbox_PDU_5V_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_LimitsConfigurationEvent() throws Exception {
        String version = "x";
        double otm_0_A_I_warnHi = 0.2192559838294983;
        double otm_0_A_I_warnLo = 0.6262549161911011;
        double otm_0_A_I_limitHi = 0.3666437268257141;
        double otm_0_A_I_limitLo = 0.45988816022872925;
        double otm_0_A_V_warnHi = 0.6296939253807068;
        double otm_0_A_V_warnLo = 0.040489912033081055;
        double otm_0_A_V_limitHi = 0.45842164754867554;
        double otm_0_A_V_limitLo = 0.8041380643844604;
        double otm_0_B_I_warnHi = 0.963213324546814;
        double otm_0_B_I_warnLo = 0.4553758502006531;
        double otm_0_B_I_limitHi = 0.2713279128074646;
        double otm_0_B_I_limitLo = 0.947884738445282;
        double otm_0_B_V_warnHi = 0.0288409f;
        double otm_0_B_V_warnLo = 0.39329564571380615;
        double otm_0_B_V_limitHi = 0.22851771116256714;
        double otm_0_B_V_limitLo = 0.21255344152450562;
        double otm_1_A_I_warnHi = 0.011912405490875244;
        double otm_1_A_I_warnLo = 0.5514242649078369;
        double otm_1_A_I_limitHi = 0.6508852243423462;
        double otm_1_A_I_limitLo = 0.568288266658783;
        double otm_1_A_V_warnHi = 0.637826144695282;
        double otm_1_A_V_warnLo = 0.09007900953292847;
        double otm_1_A_V_limitHi = 0.8701666593551636;
        double otm_1_A_V_limitLo = 0.36637115478515625;
        double otm_1_B_I_warnHi = 0.03323858976364136;
        double otm_1_B_I_warnLo = 0.8563101887702942;
        double otm_1_B_I_limitHi = 0.8666839003562927;
        double otm_1_B_I_limitLo = 0.45781224966049194;
        double otm_1_B_V_warnHi = 0.3513185381889343;
        double otm_1_B_V_warnLo = 0.4714767336845398;
        double otm_1_B_V_limitHi = 0.46924442052841187;
        double otm_1_B_V_limitLo = 0.2972654700279236;
        double otm_2_A_I_warnHi = 0.6357949376106262;
        double otm_2_A_I_warnLo = 0.5301083922386169;
        double otm_2_A_I_limitHi = 0.7822174429893494;
        double otm_2_A_I_limitLo = 0.5979655385017395;
        double otm_2_A_V_warnHi = 0.7027034163475037;
        double otm_2_A_V_warnLo = 0.9898995161056519;
        double otm_2_A_V_limitHi = 0.12456047534942627;
        double otm_2_A_V_limitLo = 0.8187646269798279;
        double otm_2_B_I_warnHi = 0.4652571678161621;
        double otm_2_B_I_warnLo = 0.3246997594833374;
        double otm_2_B_I_limitHi = 0.7379271984100342;
        double otm_2_B_I_limitLo = 0.006887316703796387;
        double otm_2_B_V_warnHi = 0.4530452489852905;
        double otm_2_B_V_warnLo = 0.3875085115432739;
        double otm_2_B_V_limitHi = 0.721917450428009;
        double otm_2_B_V_limitLo = 0.27117353677749634;
        double otm_3_A_I_warnHi = 0.7593408823013306;
        double otm_3_A_I_warnLo = 0.7404987812042236;
        double otm_3_A_I_limitHi = 0.7256408929824829;
        double otm_3_A_I_limitLo = 0.854900598526001;
        double otm_3_A_V_warnHi = 0.157843f;
        double otm_3_A_V_warnLo = 0.583867609500885;
        double otm_3_A_V_limitHi = 0.5232800841331482;
        double otm_3_A_V_limitLo = 0.5524739623069763;
        double otm_3_B_I_warnHi = 0.17146915197372437;
        double otm_3_B_I_warnLo = 0.312854528427124;
        double otm_3_B_I_limitHi = 0.6501095294952393;
        double otm_3_B_I_limitLo = 0.161163330078125;
        double otm_3_B_V_warnHi = 0.8502786159515381;
        double otm_3_B_V_warnLo = 0.1887073516845703;
        double otm_3_B_V_limitHi = 0.21293115615844727;
        double otm_3_B_V_limitLo = 0.07158505916595459;
        double otm_4_A_I_warnHi = 0.4632687568664551;
        double otm_4_A_I_warnLo = 0.9889718294143677;
        double otm_4_A_I_limitHi = 0.019225597381591797;
        double otm_4_A_I_limitLo = 0.7258667349815369;
        double otm_4_A_V_warnHi = 0.16032713651657104;
        double otm_4_A_V_warnLo = 0.747619f;
        double otm_4_A_V_limitHi = 0.5122162699699402;
        double otm_4_A_V_limitLo = 0.9605627059936523;
        double otm_4_B_I_warnHi = 0.487312376499176;
        double otm_4_B_I_warnLo = 0.576705813407898;
        double otm_4_B_I_limitHi = 0.13985759019851685;
        double otm_4_B_I_limitLo = 0.6057502627372742;
        double otm_4_B_V_warnHi = 0.9010071754455566;
        double otm_4_B_V_warnLo = 0.9271302223205566;
        double otm_4_B_V_limitHi = 0.7254574298858643;
        double otm_4_B_V_limitLo = 0.7387614846229553;
        double otm_5_A_I_warnHi = 0.7340636253356934;
        double otm_5_A_I_warnLo = 0.6733422875404358;
        double otm_5_A_I_limitHi = 0.912837028503418;
        double otm_5_A_I_limitLo = 0.7502734661102295;
        double otm_5_A_V_warnHi = 0.3962177038192749;
        double otm_5_A_V_warnLo = 0.8504967093467712;
        double otm_5_A_V_limitHi = 0.6118409037590027;
        double otm_5_A_V_limitLo = 0.6346777081489563;
        double otm_5_B_I_warnHi = 0.6007689237594604;
        double otm_5_B_I_warnLo = 0.3154820203781128;
        double otm_5_B_I_limitHi = 0.6184857487678528;
        double otm_5_B_I_limitLo = 0.3816053867340088;
        double otm_5_B_V_warnHi = 0.5990188121795654;
        double otm_5_B_V_warnLo = 0.7066761255264282;
        double otm_5_B_V_limitHi = 0.7915622591972351;
        double otm_5_B_V_limitLo = 0.9401387572288513;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_LimitsConfigurationEvent(version, otm_0_A_I_warnHi, otm_0_A_I_warnLo, otm_0_A_I_limitHi, otm_0_A_I_limitLo, otm_0_A_V_warnHi, otm_0_A_V_warnLo, otm_0_A_V_limitHi, otm_0_A_V_limitLo, otm_0_B_I_warnHi, otm_0_B_I_warnLo, otm_0_B_I_limitHi, otm_0_B_I_limitLo, otm_0_B_V_warnHi, otm_0_B_V_warnLo, otm_0_B_V_limitHi, otm_0_B_V_limitLo, otm_1_A_I_warnHi, otm_1_A_I_warnLo, otm_1_A_I_limitHi, otm_1_A_I_limitLo, otm_1_A_V_warnHi, otm_1_A_V_warnLo, otm_1_A_V_limitHi, otm_1_A_V_limitLo, otm_1_B_I_warnHi, otm_1_B_I_warnLo, otm_1_B_I_limitHi, otm_1_B_I_limitLo, otm_1_B_V_warnHi, otm_1_B_V_warnLo, otm_1_B_V_limitHi, otm_1_B_V_limitLo, otm_2_A_I_warnHi, otm_2_A_I_warnLo, otm_2_A_I_limitHi, otm_2_A_I_limitLo, otm_2_A_V_warnHi, otm_2_A_V_warnLo, otm_2_A_V_limitHi, otm_2_A_V_limitLo, otm_2_B_I_warnHi, otm_2_B_I_warnLo, otm_2_B_I_limitHi, otm_2_B_I_limitLo, otm_2_B_V_warnHi, otm_2_B_V_warnLo, otm_2_B_V_limitHi, otm_2_B_V_limitLo, otm_3_A_I_warnHi, otm_3_A_I_warnLo, otm_3_A_I_limitHi, otm_3_A_I_limitLo, otm_3_A_V_warnHi, otm_3_A_V_warnLo, otm_3_A_V_limitHi, otm_3_A_V_limitLo, otm_3_B_I_warnHi, otm_3_B_I_warnLo, otm_3_B_I_limitHi, otm_3_B_I_limitLo, otm_3_B_V_warnHi, otm_3_B_V_warnLo, otm_3_B_V_limitHi, otm_3_B_V_limitLo, otm_4_A_I_warnHi, otm_4_A_I_warnLo, otm_4_A_I_limitHi, otm_4_A_I_limitLo, otm_4_A_V_warnHi, otm_4_A_V_warnLo, otm_4_A_V_limitHi, otm_4_A_V_limitLo, otm_4_B_I_warnHi, otm_4_B_I_warnLo, otm_4_B_I_limitHi, otm_4_B_I_limitLo, otm_4_B_V_warnHi, otm_4_B_V_warnLo, otm_4_B_V_limitHi, otm_4_B_V_limitLo, otm_5_A_I_warnHi, otm_5_A_I_warnLo, otm_5_A_I_limitHi, otm_5_A_I_limitLo, otm_5_A_V_warnHi, otm_5_A_V_warnLo, otm_5_A_V_limitHi, otm_5_A_V_limitLo, otm_5_B_I_warnHi, otm_5_B_I_warnLo, otm_5_B_I_limitHi, otm_5_B_I_limitLo, otm_5_B_V_warnHi, otm_5_B_V_warnLo, otm_5_B_V_limitHi, otm_5_B_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_LimitsConfigurationEvent));
        Quadbox_PDU_5V_LimitsConfigurationEvent item_ = (Quadbox_PDU_5V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)otm_0_A_I_warnHi, (double)item_.getOtm_0_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_warnLo, (double)item_.getOtm_0_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_limitHi, (double)item_.getOtm_0_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_limitLo, (double)item_.getOtm_0_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_warnHi, (double)item_.getOtm_0_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_warnLo, (double)item_.getOtm_0_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_limitHi, (double)item_.getOtm_0_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_limitLo, (double)item_.getOtm_0_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_warnHi, (double)item_.getOtm_0_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_warnLo, (double)item_.getOtm_0_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_limitHi, (double)item_.getOtm_0_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_limitLo, (double)item_.getOtm_0_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_warnHi, (double)item_.getOtm_0_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_warnLo, (double)item_.getOtm_0_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_limitHi, (double)item_.getOtm_0_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_limitLo, (double)item_.getOtm_0_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_warnHi, (double)item_.getOtm_1_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_warnLo, (double)item_.getOtm_1_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_limitHi, (double)item_.getOtm_1_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_limitLo, (double)item_.getOtm_1_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_warnHi, (double)item_.getOtm_1_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_warnLo, (double)item_.getOtm_1_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_limitHi, (double)item_.getOtm_1_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_limitLo, (double)item_.getOtm_1_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_warnHi, (double)item_.getOtm_1_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_warnLo, (double)item_.getOtm_1_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_limitHi, (double)item_.getOtm_1_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_limitLo, (double)item_.getOtm_1_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_warnHi, (double)item_.getOtm_1_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_warnLo, (double)item_.getOtm_1_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_limitHi, (double)item_.getOtm_1_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_limitLo, (double)item_.getOtm_1_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_warnHi, (double)item_.getOtm_2_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_warnLo, (double)item_.getOtm_2_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_limitHi, (double)item_.getOtm_2_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_limitLo, (double)item_.getOtm_2_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_warnHi, (double)item_.getOtm_2_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_warnLo, (double)item_.getOtm_2_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_limitHi, (double)item_.getOtm_2_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_limitLo, (double)item_.getOtm_2_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_warnHi, (double)item_.getOtm_2_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_warnLo, (double)item_.getOtm_2_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_limitHi, (double)item_.getOtm_2_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_limitLo, (double)item_.getOtm_2_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_warnHi, (double)item_.getOtm_2_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_warnLo, (double)item_.getOtm_2_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_limitHi, (double)item_.getOtm_2_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_limitLo, (double)item_.getOtm_2_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_warnHi, (double)item_.getOtm_3_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_warnLo, (double)item_.getOtm_3_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_limitHi, (double)item_.getOtm_3_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_limitLo, (double)item_.getOtm_3_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_warnHi, (double)item_.getOtm_3_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_warnLo, (double)item_.getOtm_3_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_limitHi, (double)item_.getOtm_3_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_limitLo, (double)item_.getOtm_3_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnHi, (double)item_.getOtm_3_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnLo, (double)item_.getOtm_3_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitHi, (double)item_.getOtm_3_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitLo, (double)item_.getOtm_3_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnHi, (double)item_.getOtm_3_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnLo, (double)item_.getOtm_3_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitHi, (double)item_.getOtm_3_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitLo, (double)item_.getOtm_3_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_warnHi, (double)item_.getOtm_4_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_warnLo, (double)item_.getOtm_4_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_limitHi, (double)item_.getOtm_4_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_limitLo, (double)item_.getOtm_4_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_warnHi, (double)item_.getOtm_4_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_warnLo, (double)item_.getOtm_4_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_limitHi, (double)item_.getOtm_4_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_limitLo, (double)item_.getOtm_4_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_warnHi, (double)item_.getOtm_4_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_warnLo, (double)item_.getOtm_4_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_limitHi, (double)item_.getOtm_4_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_limitLo, (double)item_.getOtm_4_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_warnHi, (double)item_.getOtm_4_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_warnLo, (double)item_.getOtm_4_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_limitHi, (double)item_.getOtm_4_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_limitLo, (double)item_.getOtm_4_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_warnHi, (double)item_.getOtm_5_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_warnLo, (double)item_.getOtm_5_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_limitHi, (double)item_.getOtm_5_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_limitLo, (double)item_.getOtm_5_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_warnHi, (double)item_.getOtm_5_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_warnLo, (double)item_.getOtm_5_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_limitHi, (double)item_.getOtm_5_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_limitLo, (double)item_.getOtm_5_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_warnHi, (double)item_.getOtm_5_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_warnLo, (double)item_.getOtm_5_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_limitHi, (double)item_.getOtm_5_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_limitLo, (double)item_.getOtm_5_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_warnHi, (double)item_.getOtm_5_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_warnLo, (double)item_.getOtm_5_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_limitHi, (double)item_.getOtm_5_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_limitLo, (double)item_.getOtm_5_B_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_QuadboxConfigurationEvent() throws Exception {
        String version = "";
        int node = 98;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_QuadboxConfigurationEvent));
        Quadbox_PDU_5V_QuadboxConfigurationEvent item_ = (Quadbox_PDU_5V_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "k";
        int schedulers_default_nTasks = 647;
        int schedulers_default_nThreads = 925;
        int schedulers_monitor_check_scheduler_nTasks = 749;
        int schedulers_monitor_check_scheduler_nThreads = 249;
        int schedulers_monitor_update_publish_scheduler_nTasks = 687;
        int schedulers_monitor_update_publish_scheduler_nThreads = 193;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasks_GeneralConfigurationEvent));
        Quadbox_PeriodicTasks_GeneralConfigurationEvent item_ = (Quadbox_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 793L;
        long heartbeat_taskPeriodMillis = 168L;
        long maq20_check_status_taskPeriodMillis = 110L;
        long monitor_check_BFR_taskPeriodMillis = 704L;
        long monitor_check_Maq20_taskPeriodMillis = 865L;
        long monitor_check_PDU_24VC_taskPeriodMillis = 867L;
        long monitor_check_PDU_24VD_taskPeriodMillis = 607L;
        long monitor_check_PDU_48V_taskPeriodMillis = 806L;
        long monitor_check_PDU_5V_taskPeriodMillis = 867L;
        long monitor_check_REB_Bulk_PS_taskPeriodMillis = 799L;
        long monitor_publish_BFR_taskPeriodMillis = 531L;
        long monitor_publish_PDU_24VC_taskPeriodMillis = 406L;
        long monitor_publish_PDU_24VD_taskPeriodMillis = 98L;
        long monitor_publish_PDU_48V_taskPeriodMillis = 586L;
        long monitor_publish_PDU_5V_taskPeriodMillis = 539L;
        long monitor_publish_REB_Bulk_PS_taskPeriodMillis = 394L;
        long monitor_update_BFR_taskPeriodMillis = 599L;
        long monitor_update_PDU_24VC_taskPeriodMillis = 904L;
        long monitor_update_PDU_24VD_taskPeriodMillis = 27L;
        long monitor_update_PDU_48V_taskPeriodMillis = 219L;
        long monitor_update_PDU_5V_taskPeriodMillis = 591L;
        long monitor_update_REB_Bulk_PS_taskPeriodMillis = 121L;
        long quadbox_state_taskPeriodMillis = 374L;
        long runtimeinfo_taskPeriodMillis = 396L;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, maq20_check_status_taskPeriodMillis, monitor_check_BFR_taskPeriodMillis, monitor_check_Maq20_taskPeriodMillis, monitor_check_PDU_24VC_taskPeriodMillis, monitor_check_PDU_24VD_taskPeriodMillis, monitor_check_PDU_48V_taskPeriodMillis, monitor_check_PDU_5V_taskPeriodMillis, monitor_check_REB_Bulk_PS_taskPeriodMillis, monitor_publish_BFR_taskPeriodMillis, monitor_publish_PDU_24VC_taskPeriodMillis, monitor_publish_PDU_24VD_taskPeriodMillis, monitor_publish_PDU_48V_taskPeriodMillis, monitor_publish_PDU_5V_taskPeriodMillis, monitor_publish_REB_Bulk_PS_taskPeriodMillis, monitor_update_BFR_taskPeriodMillis, monitor_update_PDU_24VC_taskPeriodMillis, monitor_update_PDU_24VD_taskPeriodMillis, monitor_update_PDU_48V_taskPeriodMillis, monitor_update_PDU_5V_taskPeriodMillis, monitor_update_REB_Bulk_PS_taskPeriodMillis, quadbox_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasks_timersConfigurationEvent));
        Quadbox_PeriodicTasks_timersConfigurationEvent item_ = (Quadbox_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)maq20_check_status_taskPeriodMillis, (long)item_.getMaq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_BFR_taskPeriodMillis, (long)item_.getMonitor_check_BFR_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PDU_24VC_taskPeriodMillis, (long)item_.getMonitor_check_PDU_24VC_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PDU_24VD_taskPeriodMillis, (long)item_.getMonitor_check_PDU_24VD_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PDU_48V_taskPeriodMillis, (long)item_.getMonitor_check_PDU_48V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PDU_5V_taskPeriodMillis, (long)item_.getMonitor_check_PDU_5V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_REB_Bulk_PS_taskPeriodMillis, (long)item_.getMonitor_check_REB_Bulk_PS_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_BFR_taskPeriodMillis, (long)item_.getMonitor_publish_BFR_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PDU_24VC_taskPeriodMillis, (long)item_.getMonitor_publish_PDU_24VC_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PDU_24VD_taskPeriodMillis, (long)item_.getMonitor_publish_PDU_24VD_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PDU_48V_taskPeriodMillis, (long)item_.getMonitor_publish_PDU_48V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PDU_5V_taskPeriodMillis, (long)item_.getMonitor_publish_PDU_5V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_REB_Bulk_PS_taskPeriodMillis, (long)item_.getMonitor_publish_REB_Bulk_PS_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_BFR_taskPeriodMillis, (long)item_.getMonitor_update_BFR_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PDU_24VC_taskPeriodMillis, (long)item_.getMonitor_update_PDU_24VC_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PDU_24VD_taskPeriodMillis, (long)item_.getMonitor_update_PDU_24VD_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PDU_48V_taskPeriodMillis, (long)item_.getMonitor_update_PDU_48V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PDU_5V_taskPeriodMillis, (long)item_.getMonitor_update_PDU_5V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_REB_Bulk_PS_taskPeriodMillis, (long)item_.getMonitor_update_REB_Bulk_PS_taskPeriodMillis());
        Assert.assertEquals((long)quadbox_state_taskPeriodMillis, (long)item_.getQuadbox_state_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_DevicesConfigurationEvent() throws Exception {
        String version = "f";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_DevicesConfigurationEvent));
        Quadbox_REB_Bulk_PS_DevicesConfigurationEvent item_ = (Quadbox_REB_Bulk_PS_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double rebbulkps_0_2_I_warnHi = 0.6640772223472595;
        double rebbulkps_0_2_I_warnLo = 0.5545397996902466;
        double rebbulkps_0_2_I_limitHi = 0.3085957169532776;
        double rebbulkps_0_2_I_limitLo = 0.9116076231002808;
        double rebbulkps_0_2_T_warnHi = 0.2826339602470398;
        double rebbulkps_0_2_T_warnLo = 0.2424364686012268;
        double rebbulkps_0_2_T_limitHi = 0.8993031978607178;
        double rebbulkps_0_2_T_limitLo = 0.389864444732666;
        double rebbulkps_0_2_V_warnHi = 0.87402f;
        double rebbulkps_0_2_V_warnLo = 0.24330562353134155;
        double rebbulkps_0_2_V_limitHi = 0.5271173715591431;
        double rebbulkps_0_2_V_limitLo = 0.8121272325515747;
        double rebbulkps_3_5_I_warnHi = 0.7979332804679871;
        double rebbulkps_3_5_I_warnLo = 0.3415534496307373;
        double rebbulkps_3_5_I_limitHi = 0.3222883939743042;
        double rebbulkps_3_5_I_limitLo = 0.9028640389442444;
        double rebbulkps_3_5_T_warnHi = 0.17943823337554932;
        double rebbulkps_3_5_T_warnLo = 0.6503531336784363;
        double rebbulkps_3_5_T_limitHi = 0.00792855f;
        double rebbulkps_3_5_T_limitLo = 0.03374302387237549;
        double rebbulkps_3_5_V_warnHi = 0.9140632152557373;
        double rebbulkps_3_5_V_warnLo = 0.3034737f;
        double rebbulkps_3_5_V_limitHi = 0.5301044583320618;
        double rebbulkps_3_5_V_limitLo = 0.8447704315185547;
        double rebbulkps_6_8_I_warnHi = 0.5800148248672485;
        double rebbulkps_6_8_I_warnLo = 0.9197233319282532;
        double rebbulkps_6_8_I_limitHi = 0.3724360466003418;
        double rebbulkps_6_8_I_limitLo = 0.7258525490760803;
        double rebbulkps_6_8_T_warnHi = 0.5308462977409363;
        double rebbulkps_6_8_T_warnLo = 0.689347505569458;
        double rebbulkps_6_8_T_limitHi = 0.4999144673347473;
        double rebbulkps_6_8_T_limitLo = 0.15168523788452148;
        double rebbulkps_6_8_V_warnHi = 0.3233150839805603;
        double rebbulkps_6_8_V_warnLo = 0.6739442944526672;
        double rebbulkps_6_8_V_limitHi = 0.8003124594688416;
        double rebbulkps_6_8_V_limitLo = 0.8840603828430176;
        double rebbulkps_9_12_I_warnHi = 0.1999720335006714;
        double rebbulkps_9_12_I_warnLo = 0.3641918897628784;
        double rebbulkps_9_12_I_limitHi = 0.1045953f;
        double rebbulkps_9_12_I_limitLo = 0.586685299873352;
        double rebbulkps_9_12_T_warnHi = 0.07568937540054321;
        double rebbulkps_9_12_T_warnLo = 0.6804636716842651;
        double rebbulkps_9_12_T_limitHi = 0.4218956232070923;
        double rebbulkps_9_12_T_limitLo = 0.5800520777702332;
        double rebbulkps_9_12_V_warnHi = 0.306423f;
        double rebbulkps_9_12_V_warnLo = 0.7984023094177246;
        double rebbulkps_9_12_V_limitHi = 0.549782395362854;
        double rebbulkps_9_12_V_limitLo = 0.45498377084732056;
        double rebbulkps_Brd_T_warnHi = 0.08471924066543579;
        double rebbulkps_Brd_T_warnLo = 0.4435202479362488;
        double rebbulkps_Brd_T_limitHi = 0.1747344732284546;
        double rebbulkps_Brd_T_limitLo = 0.4860857129096985;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_LimitsConfigurationEvent(version, rebbulkps_0_2_I_warnHi, rebbulkps_0_2_I_warnLo, rebbulkps_0_2_I_limitHi, rebbulkps_0_2_I_limitLo, rebbulkps_0_2_T_warnHi, rebbulkps_0_2_T_warnLo, rebbulkps_0_2_T_limitHi, rebbulkps_0_2_T_limitLo, rebbulkps_0_2_V_warnHi, rebbulkps_0_2_V_warnLo, rebbulkps_0_2_V_limitHi, rebbulkps_0_2_V_limitLo, rebbulkps_3_5_I_warnHi, rebbulkps_3_5_I_warnLo, rebbulkps_3_5_I_limitHi, rebbulkps_3_5_I_limitLo, rebbulkps_3_5_T_warnHi, rebbulkps_3_5_T_warnLo, rebbulkps_3_5_T_limitHi, rebbulkps_3_5_T_limitLo, rebbulkps_3_5_V_warnHi, rebbulkps_3_5_V_warnLo, rebbulkps_3_5_V_limitHi, rebbulkps_3_5_V_limitLo, rebbulkps_6_8_I_warnHi, rebbulkps_6_8_I_warnLo, rebbulkps_6_8_I_limitHi, rebbulkps_6_8_I_limitLo, rebbulkps_6_8_T_warnHi, rebbulkps_6_8_T_warnLo, rebbulkps_6_8_T_limitHi, rebbulkps_6_8_T_limitLo, rebbulkps_6_8_V_warnHi, rebbulkps_6_8_V_warnLo, rebbulkps_6_8_V_limitHi, rebbulkps_6_8_V_limitLo, rebbulkps_9_12_I_warnHi, rebbulkps_9_12_I_warnLo, rebbulkps_9_12_I_limitHi, rebbulkps_9_12_I_limitLo, rebbulkps_9_12_T_warnHi, rebbulkps_9_12_T_warnLo, rebbulkps_9_12_T_limitHi, rebbulkps_9_12_T_limitLo, rebbulkps_9_12_V_warnHi, rebbulkps_9_12_V_warnLo, rebbulkps_9_12_V_limitHi, rebbulkps_9_12_V_limitLo, rebbulkps_Brd_T_warnHi, rebbulkps_Brd_T_warnLo, rebbulkps_Brd_T_limitHi, rebbulkps_Brd_T_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_LimitsConfigurationEvent));
        Quadbox_REB_Bulk_PS_LimitsConfigurationEvent item_ = (Quadbox_REB_Bulk_PS_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)rebbulkps_0_2_I_warnHi, (double)item_.getRebbulkps_0_2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_warnLo, (double)item_.getRebbulkps_0_2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_limitHi, (double)item_.getRebbulkps_0_2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_limitLo, (double)item_.getRebbulkps_0_2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_warnHi, (double)item_.getRebbulkps_0_2_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_warnLo, (double)item_.getRebbulkps_0_2_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_limitHi, (double)item_.getRebbulkps_0_2_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_limitLo, (double)item_.getRebbulkps_0_2_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_warnHi, (double)item_.getRebbulkps_0_2_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_warnLo, (double)item_.getRebbulkps_0_2_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_limitHi, (double)item_.getRebbulkps_0_2_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_limitLo, (double)item_.getRebbulkps_0_2_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_warnHi, (double)item_.getRebbulkps_3_5_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_warnLo, (double)item_.getRebbulkps_3_5_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_limitHi, (double)item_.getRebbulkps_3_5_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_limitLo, (double)item_.getRebbulkps_3_5_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_warnHi, (double)item_.getRebbulkps_3_5_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_warnLo, (double)item_.getRebbulkps_3_5_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_limitHi, (double)item_.getRebbulkps_3_5_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_limitLo, (double)item_.getRebbulkps_3_5_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_warnHi, (double)item_.getRebbulkps_3_5_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_warnLo, (double)item_.getRebbulkps_3_5_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_limitHi, (double)item_.getRebbulkps_3_5_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_limitLo, (double)item_.getRebbulkps_3_5_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_warnHi, (double)item_.getRebbulkps_6_8_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_warnLo, (double)item_.getRebbulkps_6_8_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_limitHi, (double)item_.getRebbulkps_6_8_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_limitLo, (double)item_.getRebbulkps_6_8_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_warnHi, (double)item_.getRebbulkps_6_8_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_warnLo, (double)item_.getRebbulkps_6_8_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_limitHi, (double)item_.getRebbulkps_6_8_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_limitLo, (double)item_.getRebbulkps_6_8_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_warnHi, (double)item_.getRebbulkps_6_8_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_warnLo, (double)item_.getRebbulkps_6_8_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_limitHi, (double)item_.getRebbulkps_6_8_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_limitLo, (double)item_.getRebbulkps_6_8_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_warnHi, (double)item_.getRebbulkps_9_12_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_warnLo, (double)item_.getRebbulkps_9_12_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_limitHi, (double)item_.getRebbulkps_9_12_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_limitLo, (double)item_.getRebbulkps_9_12_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_warnHi, (double)item_.getRebbulkps_9_12_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_warnLo, (double)item_.getRebbulkps_9_12_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_limitHi, (double)item_.getRebbulkps_9_12_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_limitLo, (double)item_.getRebbulkps_9_12_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_warnHi, (double)item_.getRebbulkps_9_12_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_warnLo, (double)item_.getRebbulkps_9_12_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_limitHi, (double)item_.getRebbulkps_9_12_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_limitLo, (double)item_.getRebbulkps_9_12_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_warnHi, (double)item_.getRebbulkps_Brd_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_warnLo, (double)item_.getRebbulkps_Brd_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_limitHi, (double)item_.getRebbulkps_Brd_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_limitLo, (double)item_.getRebbulkps_Brd_T_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_QuadboxConfigurationEvent() throws Exception {
        String version = "";
        int node = 297;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent));
        Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent item_ = (Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveRebpower_EmergencyResponseManager_GeneralConfigurationEvent() throws Exception {
        String version = "";
        boolean processOnlyClearedAlerts = false;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_EmergencyResponseManager_GeneralConfigurationEvent(version, processOnlyClearedAlerts));
        Assert.assertTrue((boolean)(item instanceof Rebpower_EmergencyResponseManager_GeneralConfigurationEvent));
        Rebpower_EmergencyResponseManager_GeneralConfigurationEvent item_ = (Rebpower_EmergencyResponseManager_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)processOnlyClearedAlerts, (Object)item_.isProcessOnlyClearedAlerts());
    }

    @Test
    public void sendReceiveRebpower_GeneralConfigurationEvent() throws Exception {
        String version = "o";
        long powerOffSleepMillis = 628L;
        int psDeviceExcepNumToOffline = 36;
        long psDeviceReadTimeout = 584L;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_GeneralConfigurationEvent(version, powerOffSleepMillis, psDeviceExcepNumToOffline, psDeviceReadTimeout));
        Assert.assertTrue((boolean)(item instanceof Rebpower_GeneralConfigurationEvent));
        Rebpower_GeneralConfigurationEvent item_ = (Rebpower_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)powerOffSleepMillis, (long)item_.getPowerOffSleepMillis());
        Assert.assertEquals((long)psDeviceExcepNumToOffline, (long)item_.getPsDeviceExcepNumToOffline());
        Assert.assertEquals((long)psDeviceReadTimeout, (long)item_.getPsDeviceReadTimeout());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 329;
        int schedulers_default_nThreads = 557;
        int schedulers_monitor_check_scheduler_nTasks = 393;
        int schedulers_monitor_check_scheduler_nThreads = 394;
        int schedulers_monitor_update_publish_scheduler_nTasks = 184;
        int schedulers_monitor_update_publish_scheduler_nThreads = 616;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasks_GeneralConfigurationEvent));
        Rebpower_PeriodicTasks_GeneralConfigurationEvent item_ = (Rebpower_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 448L;
        long heartbeat_taskPeriodMillis = 704L;
        long monitor_check_RebPS_P00_taskPeriodMillis = 347L;
        long monitor_check_RebPS_P01_taskPeriodMillis = 818L;
        long monitor_check_RebPS_P02_taskPeriodMillis = 319L;
        long monitor_check_RebPS_P03_taskPeriodMillis = 580L;
        long monitor_check_RebPS_P04_taskPeriodMillis = 336L;
        long monitor_check_RebPS_P05_taskPeriodMillis = 804L;
        long monitor_check_RebPS_P06_taskPeriodMillis = 184L;
        long monitor_check_RebPS_P07_taskPeriodMillis = 938L;
        long monitor_check_RebPS_P08_taskPeriodMillis = 61L;
        long monitor_check_RebPS_P09_taskPeriodMillis = 976L;
        long monitor_check_RebPS_P10_taskPeriodMillis = 711L;
        long monitor_check_RebPS_P11_taskPeriodMillis = 216L;
        long monitor_check_RebPS_P12_taskPeriodMillis = 327L;
        long monitor_publish_RebPS_P00_taskPeriodMillis = 892L;
        long monitor_publish_RebPS_P01_taskPeriodMillis = 616L;
        long monitor_publish_RebPS_P02_taskPeriodMillis = 11L;
        long monitor_publish_RebPS_P03_taskPeriodMillis = 698L;
        long monitor_publish_RebPS_P04_taskPeriodMillis = 388L;
        long monitor_publish_RebPS_P05_taskPeriodMillis = 960L;
        long monitor_publish_RebPS_P06_taskPeriodMillis = 205L;
        long monitor_publish_RebPS_P07_taskPeriodMillis = 411L;
        long monitor_publish_RebPS_P08_taskPeriodMillis = 692L;
        long monitor_publish_RebPS_P09_taskPeriodMillis = 368L;
        long monitor_publish_RebPS_P10_taskPeriodMillis = 562L;
        long monitor_publish_RebPS_P11_taskPeriodMillis = 46L;
        long monitor_publish_RebPS_P12_taskPeriodMillis = 226L;
        long monitor_publish_r00_taskPeriodMillis = 244L;
        long monitor_publish_r04_taskPeriodMillis = 48L;
        long monitor_publish_r40_taskPeriodMillis = 643L;
        long monitor_publish_r44_taskPeriodMillis = 574L;
        long monitor_publish_taskPeriodMillis = 154L;
        long monitor_update_RebPS_P00_taskPeriodMillis = 592L;
        long monitor_update_RebPS_P01_taskPeriodMillis = 67L;
        long monitor_update_RebPS_P02_taskPeriodMillis = 527L;
        long monitor_update_RebPS_P03_taskPeriodMillis = 502L;
        long monitor_update_RebPS_P04_taskPeriodMillis = 885L;
        long monitor_update_RebPS_P05_taskPeriodMillis = 217L;
        long monitor_update_RebPS_P06_taskPeriodMillis = 188L;
        long monitor_update_RebPS_P07_taskPeriodMillis = 723L;
        long monitor_update_RebPS_P08_taskPeriodMillis = 360L;
        long monitor_update_RebPS_P09_taskPeriodMillis = 964L;
        long monitor_update_RebPS_P10_taskPeriodMillis = 771L;
        long monitor_update_RebPS_P11_taskPeriodMillis = 195L;
        long monitor_update_RebPS_P12_taskPeriodMillis = 501L;
        long monitor_update_r00_taskPeriodMillis = 345L;
        long monitor_update_r04_taskPeriodMillis = 353L;
        long monitor_update_r40_taskPeriodMillis = 335L;
        long monitor_update_r44_taskPeriodMillis = 998L;
        long monitor_update_taskPeriodMillis = 981L;
        long reb_power_state_taskPeriodMillis = 431L;
        long runtimeinfo_taskPeriodMillis = 522L;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_RebPS_P00_taskPeriodMillis, monitor_check_RebPS_P01_taskPeriodMillis, monitor_check_RebPS_P02_taskPeriodMillis, monitor_check_RebPS_P03_taskPeriodMillis, monitor_check_RebPS_P04_taskPeriodMillis, monitor_check_RebPS_P05_taskPeriodMillis, monitor_check_RebPS_P06_taskPeriodMillis, monitor_check_RebPS_P07_taskPeriodMillis, monitor_check_RebPS_P08_taskPeriodMillis, monitor_check_RebPS_P09_taskPeriodMillis, monitor_check_RebPS_P10_taskPeriodMillis, monitor_check_RebPS_P11_taskPeriodMillis, monitor_check_RebPS_P12_taskPeriodMillis, monitor_publish_RebPS_P00_taskPeriodMillis, monitor_publish_RebPS_P01_taskPeriodMillis, monitor_publish_RebPS_P02_taskPeriodMillis, monitor_publish_RebPS_P03_taskPeriodMillis, monitor_publish_RebPS_P04_taskPeriodMillis, monitor_publish_RebPS_P05_taskPeriodMillis, monitor_publish_RebPS_P06_taskPeriodMillis, monitor_publish_RebPS_P07_taskPeriodMillis, monitor_publish_RebPS_P08_taskPeriodMillis, monitor_publish_RebPS_P09_taskPeriodMillis, monitor_publish_RebPS_P10_taskPeriodMillis, monitor_publish_RebPS_P11_taskPeriodMillis, monitor_publish_RebPS_P12_taskPeriodMillis, monitor_publish_r00_taskPeriodMillis, monitor_publish_r04_taskPeriodMillis, monitor_publish_r40_taskPeriodMillis, monitor_publish_r44_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_RebPS_P00_taskPeriodMillis, monitor_update_RebPS_P01_taskPeriodMillis, monitor_update_RebPS_P02_taskPeriodMillis, monitor_update_RebPS_P03_taskPeriodMillis, monitor_update_RebPS_P04_taskPeriodMillis, monitor_update_RebPS_P05_taskPeriodMillis, monitor_update_RebPS_P06_taskPeriodMillis, monitor_update_RebPS_P07_taskPeriodMillis, monitor_update_RebPS_P08_taskPeriodMillis, monitor_update_RebPS_P09_taskPeriodMillis, monitor_update_RebPS_P10_taskPeriodMillis, monitor_update_RebPS_P11_taskPeriodMillis, monitor_update_RebPS_P12_taskPeriodMillis, monitor_update_r00_taskPeriodMillis, monitor_update_r04_taskPeriodMillis, monitor_update_r40_taskPeriodMillis, monitor_update_r44_taskPeriodMillis, monitor_update_taskPeriodMillis, reb_power_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasks_timersConfigurationEvent));
        Rebpower_PeriodicTasks_timersConfigurationEvent item_ = (Rebpower_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_r00_taskPeriodMillis, (long)item_.getMonitor_publish_r00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_r04_taskPeriodMillis, (long)item_.getMonitor_publish_r04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_r40_taskPeriodMillis, (long)item_.getMonitor_publish_r40_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_r44_taskPeriodMillis, (long)item_.getMonitor_publish_r44_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_r00_taskPeriodMillis, (long)item_.getMonitor_update_r00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_r04_taskPeriodMillis, (long)item_.getMonitor_update_r04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_r40_taskPeriodMillis, (long)item_.getMonitor_update_r40_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_r44_taskPeriodMillis, (long)item_.getMonitor_update_r44_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)reb_power_state_taskPeriodMillis, (long)item_.getReb_power_state_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveRebpower_Power_timersConfigurationEvent() throws Exception {
        String version = "j";
        String location = "";
        long[] periodictasks_monitor_publish_taskPeriodMillis = TestHelper.generateLongArray((int)63, (int)2091892767);
        long[] periodictasks_monitor_update_taskPeriodMillis = TestHelper.generateLongArray((int)63, (int)-855600459);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Power_timersConfigurationEvent(version, location, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Power_timersConfigurationEvent));
        Rebpower_Power_timersConfigurationEvent item_ = (Rebpower_Power_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_taskPeriodMillis());
    }

    @Test
    public void sendReceiveRebpower_RebTotalPower_LimitsConfigurationEvent() throws Exception {
        String version = "w";
        double warnHi = 0.8761265277862549;
        double warnLo = 0.46057581901550293;
        double limitHi = 0.9353818297386169;
        double limitLo = 0.19551920890808105;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_RebTotalPower_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTotalPower_LimitsConfigurationEvent));
        Rebpower_RebTotalPower_LimitsConfigurationEvent item_ = (Rebpower_RebTotalPower_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_Reb_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int[] dphi = TestHelper.generateIntArray((int)71, (int)136639448);
        int[] hvBias = TestHelper.generateIntArray((int)71, (int)-1362807546);
        String location = "l";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Reb_GeneralConfigurationEvent(version, dphi, hvBias, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Reb_GeneralConfigurationEvent));
        Rebpower_Reb_GeneralConfigurationEvent item_ = (Rebpower_Reb_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((int[])dphi, (int[])item_.getDphi());
        Assert.assertArrayEquals((int[])hvBias, (int[])item_.getHvBias());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Reb_LimitsConfigurationEvent() throws Exception {
        String version = "c";
        double[] analog_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1311006219);
        double[] analog_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1077313887);
        double[] analog_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)925326478);
        double[] analog_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)2045514726);
        double[] analog_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)639418088);
        double[] analog_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)2013467549);
        double[] analog_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1307455252);
        double[] analog_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)328977206);
        double[] analog_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2100221899);
        double[] analog_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)56504754);
        double[] analog_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1673514815);
        double[] analog_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1393596098);
        double[] analog_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1545785992);
        double[] analog_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)2132543447);
        double[] analog_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1760192352);
        double[] analog_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-869769270);
        double[] analog_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-470155428);
        double[] analog_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1099478714);
        double[] analog_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)197809642);
        double[] analog_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-932422568);
        double[] clockhi_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1897436847);
        double[] clockhi_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1627716056);
        double[] clockhi_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-242333044);
        double[] clockhi_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)997141376);
        double[] clockhi_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2121076101);
        double[] clockhi_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)602451439);
        double[] clockhi_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)182509727);
        double[] clockhi_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1631187433);
        double[] clockhi_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1742445037);
        double[] clockhi_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1590532971);
        double[] clockhi_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-885857734);
        double[] clockhi_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)63978123);
        double[] clockhi_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-27745770);
        double[] clockhi_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)322789349);
        double[] clockhi_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-253594619);
        double[] clockhi_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-955605063);
        double[] clockhi_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)436019067);
        double[] clockhi_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)762945449);
        double[] clockhi_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)509846796);
        double[] clockhi_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1065648226);
        double[] clocklo_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)249118374);
        double[] clocklo_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1770003900);
        double[] clocklo_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1472309205);
        double[] clocklo_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1918453139);
        double[] clocklo_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1378519715);
        double[] clocklo_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1830137902);
        double[] clocklo_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1741818035);
        double[] clocklo_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-600703937);
        double[] clocklo_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)71, (int)911414039);
        double[] clocklo_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-345361523);
        double[] clocklo_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-63670948);
        double[] clocklo_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)71, (int)2129413954);
        double[] clocklo_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1218386773);
        double[] clocklo_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1657444494);
        double[] clocklo_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2050037319);
        double[] clocklo_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)842001827);
        double[] clocklo_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-605429942);
        double[] clocklo_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-395553245);
        double[] clocklo_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)1981765117);
        double[] clocklo_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1931966183);
        double[] clocklo_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1724971345);
        double[] clocklo_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1858320143);
        double[] clocklo_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1975063033);
        double[] clocklo_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-143845168);
        double[] digital_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1103297900);
        double[] digital_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1271621839);
        double[] digital_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1859498413);
        double[] digital_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1690862484);
        double[] digital_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1189013657);
        double[] digital_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)31329747);
        double[] digital_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1430654753);
        double[] digital_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-97903794);
        double[] digital_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1029147075);
        double[] digital_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1230720829);
        double[] digital_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)478780790);
        double[] digital_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1713226731);
        double[] digital_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-290449401);
        double[] digital_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-309794292);
        double[] digital_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)1251957047);
        double[] digital_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1543909273);
        double[] digital_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1128622077);
        double[] digital_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-107681155);
        double[] digital_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1685788172);
        double[] digital_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)130267376);
        double[] dphi_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-974864012);
        double[] dphi_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)989182381);
        double[] dphi_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1685206767);
        double[] dphi_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)565822890);
        double[] dphi_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)296273044);
        double[] dphi_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)587915650);
        double[] dphi_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1996849627);
        double[] dphi_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1402205791);
        double[] dphi_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1385478455);
        double[] dphi_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)313240268);
        double[] dphi_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1227710171);
        double[] dphi_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)829734763);
        double[] dphi_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)181191191);
        double[] dphi_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)897513894);
        double[] dphi_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)1423382639);
        double[] dphi_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-586262842);
        double[] dphi_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-915609642);
        double[] dphi_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)181013538);
        double[] dphi_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-85763947);
        double[] dphi_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)56708417);
        double[] heater_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1098185380);
        double[] heater_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)874118948);
        double[] heater_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1074014218);
        double[] heater_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1693775888);
        double[] heater_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-266775652);
        double[] heater_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-368689778);
        double[] heater_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-527394669);
        double[] heater_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1332637320);
        double[] heater_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-846100793);
        double[] heater_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1165476451);
        double[] heater_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2143797095);
        double[] heater_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1920147496);
        double[] heater_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)1208605394);
        double[] heater_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-985190254);
        double[] heater_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)2033867771);
        double[] heater_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1123006755);
        double[] heater_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-938997759);
        double[] heater_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1056737428);
        double[] heater_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1152230943);
        double[] heater_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1263486591);
        double[] hvbias_IbefSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)468218467);
        double[] hvbias_IbefSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)2013296852);
        double[] hvbias_VbefSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-660389558);
        double[] hvbias_VbefSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-12655963);
        String location = "";
        double[] od_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)828101618);
        double[] od_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1430241487);
        double[] od_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1347887217);
        double[] od_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1174108690);
        double[] od_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1716589409);
        double[] od_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)462331600);
        double[] od_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1831269499);
        double[] od_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-8655999);
        double[] od_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1642898302);
        double[] od_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-780151943);
        double[] od_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)71, (int)328563532);
        double[] od_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1581278651);
        double[] od_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1025037663);
        double[] od_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)933767471);
        double[] od_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-505598741);
        double[] od_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1185565708);
        double[] od_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1990500234);
        double[] od_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1126458828);
        double[] od_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-159256652);
        double[] od_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-738476050);
        double[] od_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-130830295);
        double[] od_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)961145312);
        double[] od_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1440069500);
        double[] od_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1424753465);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)71, (int)1307076576);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1002366797);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)71, (int)-942221751);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)71, (int)-688532059);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Reb_LimitsConfigurationEvent(version, analog_IaftLDO_warnHi, analog_IaftLDO_warnLo, analog_IaftLDO_limitHi, analog_IaftLDO_limitLo, analog_IbefLDO_warnHi, analog_IbefLDO_warnLo, analog_IbefLDO_limitHi, analog_IbefLDO_limitLo, analog_VaftLDO_warnHi, analog_VaftLDO_warnLo, analog_VaftLDO_limitHi, analog_VaftLDO_limitLo, analog_VaftSwch_warnHi, analog_VaftSwch_warnLo, analog_VaftSwch_limitHi, analog_VaftSwch_limitLo, analog_VbefLDO_warnHi, analog_VbefLDO_warnLo, analog_VbefLDO_limitHi, analog_VbefLDO_limitLo, clockhi_IaftLDO_warnHi, clockhi_IaftLDO_warnLo, clockhi_IaftLDO_limitHi, clockhi_IaftLDO_limitLo, clockhi_IbefLDO_warnHi, clockhi_IbefLDO_warnLo, clockhi_IbefLDO_limitHi, clockhi_IbefLDO_limitLo, clockhi_VaftLDO_warnHi, clockhi_VaftLDO_warnLo, clockhi_VaftLDO_limitHi, clockhi_VaftLDO_limitLo, clockhi_VaftSwch_warnHi, clockhi_VaftSwch_warnLo, clockhi_VaftSwch_limitHi, clockhi_VaftSwch_limitLo, clockhi_VbefLDO_warnHi, clockhi_VbefLDO_warnLo, clockhi_VbefLDO_limitHi, clockhi_VbefLDO_limitLo, clocklo_IaftLDO_warnHi, clocklo_IaftLDO_warnLo, clocklo_IaftLDO_limitHi, clocklo_IaftLDO_limitLo, clocklo_IbefLDO_warnHi, clocklo_IbefLDO_warnLo, clocklo_IbefLDO_limitHi, clocklo_IbefLDO_limitLo, clocklo_VaftLDO2_warnHi, clocklo_VaftLDO2_warnLo, clocklo_VaftLDO2_limitHi, clocklo_VaftLDO2_limitLo, clocklo_VaftLDO_warnHi, clocklo_VaftLDO_warnLo, clocklo_VaftLDO_limitHi, clocklo_VaftLDO_limitLo, clocklo_VaftSwch_warnHi, clocklo_VaftSwch_warnLo, clocklo_VaftSwch_limitHi, clocklo_VaftSwch_limitLo, clocklo_VbefLDO_warnHi, clocklo_VbefLDO_warnLo, clocklo_VbefLDO_limitHi, clocklo_VbefLDO_limitLo, digital_IaftLDO_warnHi, digital_IaftLDO_warnLo, digital_IaftLDO_limitHi, digital_IaftLDO_limitLo, digital_IbefLDO_warnHi, digital_IbefLDO_warnLo, digital_IbefLDO_limitHi, digital_IbefLDO_limitLo, digital_VaftLDO_warnHi, digital_VaftLDO_warnLo, digital_VaftLDO_limitHi, digital_VaftLDO_limitLo, digital_VaftSwch_warnHi, digital_VaftSwch_warnLo, digital_VaftSwch_limitHi, digital_VaftSwch_limitLo, digital_VbefLDO_warnHi, digital_VbefLDO_warnLo, digital_VbefLDO_limitHi, digital_VbefLDO_limitLo, dphi_IaftLDO_warnHi, dphi_IaftLDO_warnLo, dphi_IaftLDO_limitHi, dphi_IaftLDO_limitLo, dphi_IbefLDO_warnHi, dphi_IbefLDO_warnLo, dphi_IbefLDO_limitHi, dphi_IbefLDO_limitLo, dphi_VaftLDO_warnHi, dphi_VaftLDO_warnLo, dphi_VaftLDO_limitHi, dphi_VaftLDO_limitLo, dphi_VaftSwch_warnHi, dphi_VaftSwch_warnLo, dphi_VaftSwch_limitHi, dphi_VaftSwch_limitLo, dphi_VbefLDO_warnHi, dphi_VbefLDO_warnLo, dphi_VbefLDO_limitHi, dphi_VbefLDO_limitLo, heater_IaftLDO_warnHi, heater_IaftLDO_warnLo, heater_IaftLDO_limitHi, heater_IaftLDO_limitLo, heater_IbefLDO_warnHi, heater_IbefLDO_warnLo, heater_IbefLDO_limitHi, heater_IbefLDO_limitLo, heater_VaftLDO_warnHi, heater_VaftLDO_warnLo, heater_VaftLDO_limitHi, heater_VaftLDO_limitLo, heater_VaftSwch_warnHi, heater_VaftSwch_warnLo, heater_VaftSwch_limitHi, heater_VaftSwch_limitLo, heater_VbefLDO_warnHi, heater_VbefLDO_warnLo, heater_VbefLDO_limitHi, heater_VbefLDO_limitLo, hvbias_IbefSwch_warnHi, hvbias_IbefSwch_limitHi, hvbias_VbefSwch_warnHi, hvbias_VbefSwch_limitHi, location, od_IaftLDO_warnHi, od_IaftLDO_warnLo, od_IaftLDO_limitHi, od_IaftLDO_limitLo, od_IbefLDO_warnHi, od_IbefLDO_warnLo, od_IbefLDO_limitHi, od_IbefLDO_limitLo, od_VaftLDO2_warnHi, od_VaftLDO2_warnLo, od_VaftLDO2_limitHi, od_VaftLDO2_limitLo, od_VaftLDO_warnHi, od_VaftLDO_warnLo, od_VaftLDO_limitHi, od_VaftLDO_limitLo, od_VaftSwch_warnHi, od_VaftSwch_warnLo, od_VaftSwch_limitHi, od_VaftSwch_limitLo, od_VbefLDO_warnHi, od_VbefLDO_warnLo, od_VbefLDO_limitHi, od_VbefLDO_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Reb_LimitsConfigurationEvent));
        Rebpower_Reb_LimitsConfigurationEvent item_ = (Rebpower_Reb_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnHi, (double[])item_.getAnalog_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnLo, (double[])item_.getAnalog_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitHi, (double[])item_.getAnalog_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitLo, (double[])item_.getAnalog_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnHi, (double[])item_.getAnalog_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnLo, (double[])item_.getAnalog_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitHi, (double[])item_.getAnalog_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitLo, (double[])item_.getAnalog_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnHi, (double[])item_.getAnalog_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnLo, (double[])item_.getAnalog_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitHi, (double[])item_.getAnalog_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitLo, (double[])item_.getAnalog_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnHi, (double[])item_.getAnalog_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnLo, (double[])item_.getAnalog_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitHi, (double[])item_.getAnalog_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitLo, (double[])item_.getAnalog_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnHi, (double[])item_.getAnalog_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnLo, (double[])item_.getAnalog_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitHi, (double[])item_.getAnalog_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitLo, (double[])item_.getAnalog_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnHi, (double[])item_.getClockhi_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnLo, (double[])item_.getClockhi_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitHi, (double[])item_.getClockhi_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitLo, (double[])item_.getClockhi_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnHi, (double[])item_.getClockhi_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnLo, (double[])item_.getClockhi_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitHi, (double[])item_.getClockhi_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitLo, (double[])item_.getClockhi_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnHi, (double[])item_.getClockhi_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnLo, (double[])item_.getClockhi_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitHi, (double[])item_.getClockhi_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitLo, (double[])item_.getClockhi_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnHi, (double[])item_.getClockhi_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnLo, (double[])item_.getClockhi_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitHi, (double[])item_.getClockhi_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitLo, (double[])item_.getClockhi_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnHi, (double[])item_.getClockhi_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnLo, (double[])item_.getClockhi_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitHi, (double[])item_.getClockhi_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitLo, (double[])item_.getClockhi_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnHi, (double[])item_.getClocklo_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnLo, (double[])item_.getClocklo_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitHi, (double[])item_.getClocklo_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitLo, (double[])item_.getClocklo_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnHi, (double[])item_.getClocklo_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnLo, (double[])item_.getClocklo_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitHi, (double[])item_.getClocklo_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitLo, (double[])item_.getClocklo_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnHi, (double[])item_.getClocklo_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnLo, (double[])item_.getClocklo_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitHi, (double[])item_.getClocklo_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitLo, (double[])item_.getClocklo_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnHi, (double[])item_.getClocklo_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnLo, (double[])item_.getClocklo_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitHi, (double[])item_.getClocklo_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitLo, (double[])item_.getClocklo_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnHi, (double[])item_.getClocklo_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnLo, (double[])item_.getClocklo_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitHi, (double[])item_.getClocklo_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitLo, (double[])item_.getClocklo_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnHi, (double[])item_.getClocklo_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnLo, (double[])item_.getClocklo_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitHi, (double[])item_.getClocklo_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitLo, (double[])item_.getClocklo_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnHi, (double[])item_.getDigital_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnLo, (double[])item_.getDigital_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitHi, (double[])item_.getDigital_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitLo, (double[])item_.getDigital_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnHi, (double[])item_.getDigital_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnLo, (double[])item_.getDigital_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitHi, (double[])item_.getDigital_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitLo, (double[])item_.getDigital_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnHi, (double[])item_.getDigital_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnLo, (double[])item_.getDigital_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitHi, (double[])item_.getDigital_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitLo, (double[])item_.getDigital_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnHi, (double[])item_.getDigital_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnLo, (double[])item_.getDigital_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitHi, (double[])item_.getDigital_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitLo, (double[])item_.getDigital_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnHi, (double[])item_.getDigital_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnLo, (double[])item_.getDigital_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitHi, (double[])item_.getDigital_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitLo, (double[])item_.getDigital_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_warnHi, (double[])item_.getDphi_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_warnLo, (double[])item_.getDphi_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_limitHi, (double[])item_.getDphi_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_limitLo, (double[])item_.getDphi_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_warnHi, (double[])item_.getDphi_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_warnLo, (double[])item_.getDphi_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_limitHi, (double[])item_.getDphi_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_limitLo, (double[])item_.getDphi_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_warnHi, (double[])item_.getDphi_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_warnLo, (double[])item_.getDphi_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_limitHi, (double[])item_.getDphi_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_limitLo, (double[])item_.getDphi_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_warnHi, (double[])item_.getDphi_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_warnLo, (double[])item_.getDphi_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_limitHi, (double[])item_.getDphi_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_limitLo, (double[])item_.getDphi_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_warnHi, (double[])item_.getDphi_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_warnLo, (double[])item_.getDphi_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_limitHi, (double[])item_.getDphi_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_limitLo, (double[])item_.getDphi_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnHi, (double[])item_.getHeater_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnLo, (double[])item_.getHeater_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitHi, (double[])item_.getHeater_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitLo, (double[])item_.getHeater_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnHi, (double[])item_.getHeater_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnLo, (double[])item_.getHeater_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitHi, (double[])item_.getHeater_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitLo, (double[])item_.getHeater_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnHi, (double[])item_.getHeater_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnLo, (double[])item_.getHeater_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitHi, (double[])item_.getHeater_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitLo, (double[])item_.getHeater_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnHi, (double[])item_.getHeater_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnLo, (double[])item_.getHeater_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitHi, (double[])item_.getHeater_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitLo, (double[])item_.getHeater_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnHi, (double[])item_.getHeater_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnLo, (double[])item_.getHeater_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitHi, (double[])item_.getHeater_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitLo, (double[])item_.getHeater_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_warnHi, (double[])item_.getHvbias_IbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_limitHi, (double[])item_.getHvbias_IbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_warnHi, (double[])item_.getHvbias_VbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_limitHi, (double[])item_.getHvbias_VbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO_warnHi, (double[])item_.getOd_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_warnLo, (double[])item_.getOd_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitHi, (double[])item_.getOd_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitLo, (double[])item_.getOd_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnHi, (double[])item_.getOd_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnLo, (double[])item_.getOd_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitHi, (double[])item_.getOd_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitLo, (double[])item_.getOd_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnHi, (double[])item_.getOd_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnLo, (double[])item_.getOd_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitHi, (double[])item_.getOd_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitLo, (double[])item_.getOd_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnHi, (double[])item_.getOd_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnLo, (double[])item_.getOd_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitHi, (double[])item_.getOd_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitLo, (double[])item_.getOd_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnHi, (double[])item_.getOd_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnLo, (double[])item_.getOd_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitHi, (double[])item_.getOd_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitLo, (double[])item_.getOd_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnHi, (double[])item_.getOd_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnLo, (double[])item_.getOd_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitHi, (double[])item_.getOd_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitLo, (double[])item_.getOd_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_Rebps_DevicesConfigurationEvent() throws Exception {
        String version = "n";
        boolean[] disabled = new boolean[]{true, true, true, false, false, true, true, true, false, false, false, false, true};
        String location = "u";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_DevicesConfigurationEvent(version, disabled, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_DevicesConfigurationEvent));
        Rebpower_Rebps_DevicesConfigurationEvent item_ = (Rebpower_Rebps_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((boolean[])disabled, (boolean[])item_.getDisabled());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Rebps_GeneralConfigurationEvent() throws Exception {
        String version = "m";
        String location = "j";
        String rebs = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_GeneralConfigurationEvent(version, location, rebs));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_GeneralConfigurationEvent));
        Rebpower_Rebps_GeneralConfigurationEvent item_ = (Rebpower_Rebps_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)rebs, (Object)item_.getRebs());
    }

    @Test
    public void sendReceiveRebpower_Rebps_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double[] boardtemp0_warnHi = TestHelper.generateDoubleArray((int)13, (int)-1796951056);
        double[] boardtemp0_warnLo = TestHelper.generateDoubleArray((int)13, (int)-974143367);
        double[] boardtemp0_limitHi = TestHelper.generateDoubleArray((int)13, (int)-2051961306);
        double[] boardtemp0_limitLo = TestHelper.generateDoubleArray((int)13, (int)-253499929);
        double[] boardtemp1_warnHi = TestHelper.generateDoubleArray((int)13, (int)1743717347);
        double[] boardtemp1_warnLo = TestHelper.generateDoubleArray((int)13, (int)-47808529);
        double[] boardtemp1_limitHi = TestHelper.generateDoubleArray((int)13, (int)1108493183);
        double[] boardtemp1_limitLo = TestHelper.generateDoubleArray((int)13, (int)-383527811);
        double[] boardtemp2_warnHi = TestHelper.generateDoubleArray((int)13, (int)998502583);
        double[] boardtemp2_warnLo = TestHelper.generateDoubleArray((int)13, (int)-292996120);
        double[] boardtemp2_limitHi = TestHelper.generateDoubleArray((int)13, (int)1572424813);
        double[] boardtemp2_limitLo = TestHelper.generateDoubleArray((int)13, (int)1436697617);
        double[] boardtemp3_warnHi = TestHelper.generateDoubleArray((int)13, (int)222230861);
        double[] boardtemp3_warnLo = TestHelper.generateDoubleArray((int)13, (int)-425238777);
        double[] boardtemp3_limitHi = TestHelper.generateDoubleArray((int)13, (int)1054739547);
        double[] boardtemp3_limitLo = TestHelper.generateDoubleArray((int)13, (int)-1762536562);
        double[] boardtemp4_warnHi = TestHelper.generateDoubleArray((int)13, (int)-144604228);
        double[] boardtemp4_warnLo = TestHelper.generateDoubleArray((int)13, (int)1193988161);
        double[] boardtemp4_limitHi = TestHelper.generateDoubleArray((int)13, (int)1124318007);
        double[] boardtemp4_limitLo = TestHelper.generateDoubleArray((int)13, (int)842356254);
        double[] boardtemp5_warnHi = TestHelper.generateDoubleArray((int)13, (int)-611560128);
        double[] boardtemp5_warnLo = TestHelper.generateDoubleArray((int)13, (int)109395394);
        double[] boardtemp5_limitHi = TestHelper.generateDoubleArray((int)13, (int)-1891950454);
        double[] boardtemp5_limitLo = TestHelper.generateDoubleArray((int)13, (int)1503687335);
        double[] boardtemp6_warnHi = TestHelper.generateDoubleArray((int)13, (int)-1769728654);
        double[] boardtemp6_warnLo = TestHelper.generateDoubleArray((int)13, (int)1416409617);
        double[] boardtemp6_limitHi = TestHelper.generateDoubleArray((int)13, (int)-1134793784);
        double[] boardtemp6_limitLo = TestHelper.generateDoubleArray((int)13, (int)2128885655);
        double[] fpgatemp_warnHi = TestHelper.generateDoubleArray((int)13, (int)366891193);
        double[] fpgatemp_warnLo = TestHelper.generateDoubleArray((int)13, (int)531224433);
        double[] fpgatemp_limitHi = TestHelper.generateDoubleArray((int)13, (int)-124404247);
        double[] fpgatemp_limitLo = TestHelper.generateDoubleArray((int)13, (int)-655710492);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_LimitsConfigurationEvent(version, boardtemp0_warnHi, boardtemp0_warnLo, boardtemp0_limitHi, boardtemp0_limitLo, boardtemp1_warnHi, boardtemp1_warnLo, boardtemp1_limitHi, boardtemp1_limitLo, boardtemp2_warnHi, boardtemp2_warnLo, boardtemp2_limitHi, boardtemp2_limitLo, boardtemp3_warnHi, boardtemp3_warnLo, boardtemp3_limitHi, boardtemp3_limitLo, boardtemp4_warnHi, boardtemp4_warnLo, boardtemp4_limitHi, boardtemp4_limitLo, boardtemp5_warnHi, boardtemp5_warnLo, boardtemp5_limitHi, boardtemp5_limitLo, boardtemp6_warnHi, boardtemp6_warnLo, boardtemp6_limitHi, boardtemp6_limitLo, fpgatemp_warnHi, fpgatemp_warnLo, fpgatemp_limitHi, fpgatemp_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_LimitsConfigurationEvent));
        Rebpower_Rebps_LimitsConfigurationEvent item_ = (Rebpower_Rebps_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])boardtemp0_warnHi, (double[])item_.getBoardtemp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_warnLo, (double[])item_.getBoardtemp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitHi, (double[])item_.getBoardtemp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitLo, (double[])item_.getBoardtemp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnHi, (double[])item_.getBoardtemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnLo, (double[])item_.getBoardtemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitHi, (double[])item_.getBoardtemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitLo, (double[])item_.getBoardtemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnHi, (double[])item_.getBoardtemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnLo, (double[])item_.getBoardtemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitHi, (double[])item_.getBoardtemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitLo, (double[])item_.getBoardtemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnHi, (double[])item_.getBoardtemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnLo, (double[])item_.getBoardtemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitHi, (double[])item_.getBoardtemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitLo, (double[])item_.getBoardtemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnHi, (double[])item_.getBoardtemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnLo, (double[])item_.getBoardtemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitHi, (double[])item_.getBoardtemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitLo, (double[])item_.getBoardtemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnHi, (double[])item_.getBoardtemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnLo, (double[])item_.getBoardtemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitHi, (double[])item_.getBoardtemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitLo, (double[])item_.getBoardtemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnHi, (double[])item_.getBoardtemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnLo, (double[])item_.getBoardtemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitHi, (double[])item_.getBoardtemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitLo, (double[])item_.getBoardtemp6_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fpgatemp_warnHi, (double[])item_.getFpgatemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fpgatemp_warnLo, (double[])item_.getFpgatemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fpgatemp_limitHi, (double[])item_.getFpgatemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fpgatemp_limitLo, (double[])item_.getFpgatemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Rebps_PowerConfigurationEvent() throws Exception {
        String version = "g";
        String ipAddr = "k";
        String location = "";
        int[] nPowerOnPub = TestHelper.generateIntArray((int)13, (int)-1078549398);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_PowerConfigurationEvent(version, ipAddr, location, nPowerOnPub));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_PowerConfigurationEvent));
        Rebpower_Rebps_PowerConfigurationEvent item_ = (Rebpower_Rebps_PowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
    }

    @Test
    public void sendReceiveRebpower_Rebps_buildConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        String switchName = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_buildConfigurationEvent(version, location, switchName));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_buildConfigurationEvent));
        Rebpower_Rebps_buildConfigurationEvent item_ = (Rebpower_Rebps_buildConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)switchName, (Object)item_.getSwitchName());
    }

    @Test
    public void sendReceiveHex_Cold1_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double returntmp_warnHi = 0.5846213102340698;
        double returntmp_warnLo = 0.48808616399765015;
        double returntmp_limitHi = 0.1276019811630249;
        double returntmp_limitLo = 0.2578394412994385;
        double supplytmp_warnHi = 0.10613560676574707;
        double supplytmp_warnLo = 0.3082171082496643;
        double supplytmp_limitHi = 0.9318339228630066;
        double supplytmp_limitLo = 0.8321828842163086;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cold1_LimitsConfigurationEvent(version, returntmp_warnHi, returntmp_warnLo, returntmp_limitHi, returntmp_limitLo, supplytmp_warnHi, supplytmp_warnLo, supplytmp_limitHi, supplytmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1_LimitsConfigurationEvent));
        Hex_Cold1_LimitsConfigurationEvent item_ = (Hex_Cold1_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)returntmp_warnHi, (double)item_.getReturntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_warnLo, (double)item_.getReturntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_limitHi, (double)item_.getReturntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_limitLo, (double)item_.getReturntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnHi, (double)item_.getSupplytmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnLo, (double)item_.getSupplytmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitHi, (double)item_.getSupplytmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitLo, (double)item_.getSupplytmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2_LimitsConfigurationEvent() throws Exception {
        String version = "h";
        double returntmp_warnHi = 0.9507452249526978;
        double returntmp_warnLo = 0.3649328351020813;
        double returntmp_limitHi = 0.3665999174118042;
        double returntmp_limitLo = 0.38482964038848877;
        double supplytmp_warnHi = 0.8802147507667542;
        double supplytmp_warnLo = 0.2488483190536499;
        double supplytmp_limitHi = 0.4148409366607666;
        double supplytmp_limitLo = 0.4606884f;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cold2_LimitsConfigurationEvent(version, returntmp_warnHi, returntmp_warnLo, returntmp_limitHi, returntmp_limitLo, supplytmp_warnHi, supplytmp_warnLo, supplytmp_limitHi, supplytmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2_LimitsConfigurationEvent));
        Hex_Cold2_LimitsConfigurationEvent item_ = (Hex_Cold2_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)returntmp_warnHi, (double)item_.getReturntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_warnLo, (double)item_.getReturntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_limitHi, (double)item_.getReturntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_limitLo, (double)item_.getReturntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnHi, (double)item_.getSupplytmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnLo, (double)item_.getSupplytmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitHi, (double)item_.getSupplytmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitLo, (double)item_.getSupplytmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1_LimitsConfigurationEvent() throws Exception {
        String version = "f";
        double c3exittmp_warnHi = 0.8978352546691895;
        double c3exittmp_warnLo = 0.50284343957901;
        double c3exittmp_limitHi = 0.21597141027450562;
        double c3exittmp_limitLo = 0.002817809581756592;
        double c4exittmp_warnHi = 0.33124858140945435;
        double c4exittmp_warnLo = 0.1895303726196289;
        double c4exittmp_limitHi = 0.7303743362426758;
        double c4exittmp_limitLo = 0.34034425020217896;
        double evapexittmp_warnHi = 0.735842227935791;
        double evapexittmp_warnLo = 0.4493151903152466;
        double evapexittmp_limitHi = 0.931314f;
        double evapexittmp_limitLo = 0.1333240270614624;
        double hexrtrntmp_warnHi = 0.06915563344955444;
        double hexrtrntmp_warnLo = 0.8116698861122131;
        double hexrtrntmp_limitHi = 0.8750594854354858;
        double hexrtrntmp_limitLo = 0.38524436950683594;
        double liquidprs_warnHi = 0.9800442457199097;
        double liquidprs_warnLo = 0.28536665439605713;
        double liquidprs_limitHi = 0.2334151268005371;
        double liquidprs_limitLo = 0.1388377547264099;
        double prec3tmp_warnHi = 0.5651848912239075;
        double prec3tmp_warnLo = 0.5733909606933594;
        double prec3tmp_limitHi = 0.41720718145370483;
        double prec3tmp_limitLo = 0.26448744535446167;
        double prec4tmp_warnHi = 0.35695648193359375;
        double prec4tmp_warnLo = 0.8900324106216431;
        double prec4tmp_limitHi = 0.4097848f;
        double prec4tmp_limitLo = 0.2699854373931885;
        double returnprs_warnHi = 0.3449241f;
        double returnprs_warnLo = 0.6514145731925964;
        double returnprs_limitHi = 0.7461811900138855;
        double returnprs_limitLo = 0.5459582805633545;
        double vaporprs_warnHi = 0.5232203006744385;
        double vaporprs_warnLo = 0.690171480178833;
        double vaporprs_limitHi = 0.10290920734405518;
        double vaporprs_limitLo = 0.679862916469574;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo1_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1_LimitsConfigurationEvent));
        Hex_Cryo1_LimitsConfigurationEvent item_ = (Hex_Cryo1_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2_LimitsConfigurationEvent() throws Exception {
        String version = "w";
        double c3exittmp_warnHi = 0.7969587445259094;
        double c3exittmp_warnLo = 0.1981566f;
        double c3exittmp_limitHi = 0.2166767716407776;
        double c3exittmp_limitLo = 0.09368312358856201;
        double c4exittmp_warnHi = 0.6079548001289368;
        double c4exittmp_warnLo = 0.8828257322311401;
        double c4exittmp_limitHi = 0.8750627636909485;
        double c4exittmp_limitLo = 0.3472723364830017;
        double evapexittmp_warnHi = 0.6027861833572388;
        double evapexittmp_warnLo = 0.7847954034805298;
        double evapexittmp_limitHi = 0.2713779807090759;
        double evapexittmp_limitLo = 0.5309661030769348;
        double hexrtrntmp_warnHi = 0.566125750541687;
        double hexrtrntmp_warnLo = 0.18084394931793213;
        double hexrtrntmp_limitHi = 0.8151566982269287;
        double hexrtrntmp_limitLo = 0.10243260860443115;
        double liquidprs_warnHi = 0.6225319504737854;
        double liquidprs_warnLo = 0.02865135669708252;
        double liquidprs_limitHi = 0.20091331005096436;
        double liquidprs_limitLo = 0.5535042881965637;
        double prec3tmp_warnHi = 0.216303288936615;
        double prec3tmp_warnLo = 0.33076733350753784;
        double prec3tmp_limitHi = 0.21007037162780762;
        double prec3tmp_limitLo = 0.8211714029312134;
        double prec4tmp_warnHi = 0.724603533744812;
        double prec4tmp_warnLo = 0.1649855375289917;
        double prec4tmp_limitHi = 0.524152934551239;
        double prec4tmp_limitLo = 0.1386559009552002;
        double returnprs_warnHi = 0.18888407945632935;
        double returnprs_warnLo = 0.746355f;
        double returnprs_limitHi = 0.6425913572311401;
        double returnprs_limitLo = 0.16918432712554932;
        double vaporprs_warnHi = 0.4212082624435425;
        double vaporprs_warnLo = 0.6034871339797974;
        double vaporprs_limitHi = 0.25848788022994995;
        double vaporprs_limitLo = 0.20617163181304932;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo2_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2_LimitsConfigurationEvent));
        Hex_Cryo2_LimitsConfigurationEvent item_ = (Hex_Cryo2_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3_LimitsConfigurationEvent() throws Exception {
        String version = "t";
        double c3exittmp_warnHi = 0.3962072f;
        double c3exittmp_warnLo = 0.5218521356582642;
        double c3exittmp_limitHi = 0.1899036169052124;
        double c3exittmp_limitLo = 0.4225732088088989;
        double c4exittmp_warnHi = 0.03787273168563843;
        double c4exittmp_warnLo = 0.3646594285964966;
        double c4exittmp_limitHi = 0.7142853140830994;
        double c4exittmp_limitLo = 0.8675350546836853;
        double evapexittmp_warnHi = 0.9096395373344421;
        double evapexittmp_warnLo = 0.3596722483634949;
        double evapexittmp_limitHi = 0.4937942624092102;
        double evapexittmp_limitLo = 0.1310117244720459;
        double hexrtrntmp_warnHi = 0.12645351886749268;
        double hexrtrntmp_warnLo = 0.0751606822013855;
        double hexrtrntmp_limitHi = 0.1677112579345703;
        double hexrtrntmp_limitLo = 0.6396954655647278;
        double liquidprs_warnHi = 0.8349857330322266;
        double liquidprs_warnLo = 0.6537532806396484;
        double liquidprs_limitHi = 0.41739994287490845;
        double liquidprs_limitLo = 0.9492185115814209;
        double prec3tmp_warnHi = 0.1932897f;
        double prec3tmp_warnLo = 0.74419766664505;
        double prec3tmp_limitHi = 0.07167041301727295;
        double prec3tmp_limitLo = 0.5874601602554321;
        double prec4tmp_warnHi = 0.592810332775116;
        double prec4tmp_warnLo = 0.5374249219894409;
        double prec4tmp_limitHi = 0.67213f;
        double prec4tmp_limitLo = 0.5862097144126892;
        double returnprs_warnHi = 0.08965545892715454;
        double returnprs_warnLo = 0.7400966882705688;
        double returnprs_limitHi = 0.8178134560585022;
        double returnprs_limitLo = 0.6225771307945251;
        double vaporprs_warnHi = 0.4591280221939087;
        double vaporprs_warnLo = 0.4945831894874573;
        double vaporprs_limitHi = 0.09346562623977661;
        double vaporprs_limitLo = 0.11807596683502197;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo3_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3_LimitsConfigurationEvent));
        Hex_Cryo3_LimitsConfigurationEvent item_ = (Hex_Cryo3_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double c3exittmp_warnHi = 0.9640874862670898;
        double c3exittmp_warnLo = 0.7953070998191833;
        double c3exittmp_limitHi = 0.17072665691375732;
        double c3exittmp_limitLo = 0.6420723795890808;
        double c4exittmp_warnHi = 0.8862138390541077;
        double c4exittmp_warnLo = 0.6513652205467224;
        double c4exittmp_limitHi = 0.10997647047042847;
        double c4exittmp_limitLo = 0.4971882104873657;
        double evapexittmp_warnHi = 0.4016244411468506;
        double evapexittmp_warnLo = 0.08052986860275269;
        double evapexittmp_limitHi = 0.3799621f;
        double evapexittmp_limitLo = 0.5101470947265625;
        double hexrtrntmp_warnHi = 0.8836053609848022;
        double hexrtrntmp_warnLo = 0.426071f;
        double hexrtrntmp_limitHi = 0.5660336017608643;
        double hexrtrntmp_limitLo = 0.978637158870697;
        double liquidprs_warnHi = 0.0295704f;
        double liquidprs_warnLo = 0.8567120432853699;
        double liquidprs_limitHi = 0.703027f;
        double liquidprs_limitLo = 0.11930537223815918;
        double prec3tmp_warnHi = 0.7800835967063904;
        double prec3tmp_warnLo = 0.9634101986885071;
        double prec3tmp_limitHi = 0.6401426196098328;
        double prec3tmp_limitLo = 0.00840681791305542;
        double prec4tmp_warnHi = 0.5613293051719666;
        double prec4tmp_warnLo = 0.3452872633934021;
        double prec4tmp_limitHi = 0.6132214665412903;
        double prec4tmp_limitLo = 0.452708f;
        double returnprs_warnHi = 0.2126712203025818;
        double returnprs_warnLo = 0.9168487787246704;
        double returnprs_limitHi = 0.2955929f;
        double returnprs_limitLo = 0.4381973147392273;
        double vaporprs_warnHi = 0.7747090458869934;
        double vaporprs_warnLo = 0.1645141839981079;
        double vaporprs_limitHi = 0.296500027179718;
        double vaporprs_limitLo = 0.3348594903945923;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo4_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4_LimitsConfigurationEvent));
        Hex_Cryo4_LimitsConfigurationEvent item_ = (Hex_Cryo4_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double c3exittmp_warnHi = 0.9079667925834656;
        double c3exittmp_warnLo = 0.26252996921539307;
        double c3exittmp_limitHi = 0.7911467552185059;
        double c3exittmp_limitLo = 0.5862413048744202;
        double c4exittmp_warnHi = 0.19596493244171143;
        double c4exittmp_warnLo = 0.6517412066459656;
        double c4exittmp_limitHi = 0.8109247088432312;
        double c4exittmp_limitLo = 0.5020307898521423;
        double evapexittmp_warnHi = 0.09269309043884277;
        double evapexittmp_warnLo = 0.7096713781356812;
        double evapexittmp_limitHi = 0.4633186459541321;
        double evapexittmp_limitLo = 0.610880970954895;
        double hexrtrntmp_warnHi = 0.2357664704322815;
        double hexrtrntmp_warnLo = 0.8266355991363525;
        double hexrtrntmp_limitHi = 0.8923792243003845;
        double hexrtrntmp_limitLo = 0.7904093265533447;
        double liquidprs_warnHi = 0.007546544075012207;
        double liquidprs_warnLo = 0.02032071352005005;
        double liquidprs_limitHi = 0.1448100209236145;
        double liquidprs_limitLo = 0.6774519681930542;
        double prec3tmp_warnHi = 0.9350197315216064;
        double prec3tmp_warnLo = 0.8183979392051697;
        double prec3tmp_limitHi = 0.9617493748664856;
        double prec3tmp_limitLo = 0.3929516673088074;
        double prec4tmp_warnHi = 0.8882981538772583;
        double prec4tmp_warnLo = 0.9426085352897644;
        double prec4tmp_limitHi = 0.2420047f;
        double prec4tmp_limitLo = 0.6579023599624634;
        double returnprs_warnHi = 0.792611f;
        double returnprs_warnLo = 0.3765166401863098;
        double returnprs_limitHi = 0.8020473122596741;
        double returnprs_limitLo = 0.3539528250694275;
        double vaporprs_warnHi = 0.8028817176818848;
        double vaporprs_warnLo = 0.17002063989639282;
        double vaporprs_limitHi = 0.2709732f;
        double vaporprs_limitLo = 0.012377262115478516;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo5_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5_LimitsConfigurationEvent));
        Hex_Cryo5_LimitsConfigurationEvent item_ = (Hex_Cryo5_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double c3exittmp_warnHi = 0.5590114593505859;
        double c3exittmp_warnLo = 0.17061054706573486;
        double c3exittmp_limitHi = 0.13917946815490723;
        double c3exittmp_limitLo = 0.6210432052612305;
        double c4exittmp_warnHi = 0.10065692663192749;
        double c4exittmp_warnLo = 0.1617475152015686;
        double c4exittmp_limitHi = 0.6523122191429138;
        double c4exittmp_limitLo = 0.2882046699523926;
        double evapexittmp_warnHi = 0.8141778707504272;
        double evapexittmp_warnLo = 0.0724054f;
        double evapexittmp_limitHi = 0.9226796627044678;
        double evapexittmp_limitLo = 0.055135905742645264;
        double hexrtrntmp_warnHi = 0.12229812145233154;
        double hexrtrntmp_warnLo = 0.16417354345321655;
        double hexrtrntmp_limitHi = 0.0801962f;
        double hexrtrntmp_limitLo = 0.17703211307525635;
        double liquidprs_warnHi = 0.38655567169189453;
        double liquidprs_warnLo = 0.404455304145813;
        double liquidprs_limitHi = 0.9292687773704529;
        double liquidprs_limitLo = 0.7496299147605896;
        double prec3tmp_warnHi = 0.27523887157440186;
        double prec3tmp_warnLo = 0.5782743096351624;
        double prec3tmp_limitHi = 0.27734827995300293;
        double prec3tmp_limitLo = 0.6158115863800049;
        double prec4tmp_warnHi = 0.1788643f;
        double prec4tmp_warnLo = 0.4409077763557434;
        double prec4tmp_limitHi = 0.9314776659011841;
        double prec4tmp_limitLo = 0.6713199019432068;
        double returnprs_warnHi = 0.5559794902801514;
        double returnprs_warnLo = 0.8455294370651245;
        double returnprs_limitHi = 0.479996919631958;
        double returnprs_limitLo = 0.6631540656089783;
        double vaporprs_warnHi = 0.9409094452857971;
        double vaporprs_warnLo = 0.7073533535003662;
        double vaporprs_limitHi = 0.1218177080154419;
        double vaporprs_limitLo = 0.8578788042068481;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo6_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6_LimitsConfigurationEvent));
        Hex_Cryo6_LimitsConfigurationEvent item_ = (Hex_Cryo6_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_GeneralConfigurationEvent() throws Exception {
        String version = "";
        double lowCryoTempLimit = 0.6322062015533447;
        double rtnToEvapOffset = 0.8091465830802917;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_GeneralConfigurationEvent(version, lowCryoTempLimit, rtnToEvapOffset));
        Assert.assertTrue((boolean)(item instanceof Hex_GeneralConfigurationEvent));
        Hex_GeneralConfigurationEvent item_ = (Hex_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)lowCryoTempLimit, (double)item_.getLowCryoTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)rtnToEvapOffset, (double)item_.getRtnToEvapOffset(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Maq20_DeviceConfigurationEvent() throws Exception {
        String version = "j";
        String node = "";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Maq20_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Hex_Maq20_DeviceConfigurationEvent));
        Hex_Maq20_DeviceConfigurationEvent item_ = (Hex_Maq20_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveHex_Maq20_DevicesConfigurationEvent() throws Exception {
        String version = "r";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Maq20_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Hex_Maq20_DevicesConfigurationEvent));
        Hex_Maq20_DevicesConfigurationEvent item_ = (Hex_Maq20_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveHex_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "d";
        int schedulers_default_nTasks = 798;
        int schedulers_default_nThreads = 949;
        int schedulers_monitor_check_scheduler_nTasks = 961;
        int schedulers_monitor_check_scheduler_nThreads = 487;
        int schedulers_monitor_update_publish_scheduler_nTasks = 75;
        int schedulers_monitor_update_publish_scheduler_nThreads = 746;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Hex_PeriodicTasks_GeneralConfigurationEvent));
        Hex_PeriodicTasks_GeneralConfigurationEvent item_ = (Hex_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveHex_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 477L;
        long heartbeat_taskPeriodMillis = 521L;
        long hex_state_taskPeriodMillis = 202L;
        long maq20_check_status_taskPeriodMillis = 834L;
        long monitor_check_Maq20_taskPeriodMillis = 462L;
        long monitor_publish_Maq20_taskPeriodMillis = 550L;
        long monitor_update_Maq20_taskPeriodMillis = 659L;
        long runtimeinfo_taskPeriodMillis = 969L;
        long temp_check_taskPeriodMillis = 40L;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, hex_state_taskPeriodMillis, maq20_check_status_taskPeriodMillis, monitor_check_Maq20_taskPeriodMillis, monitor_publish_Maq20_taskPeriodMillis, monitor_update_Maq20_taskPeriodMillis, runtimeinfo_taskPeriodMillis, temp_check_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Hex_PeriodicTasks_timersConfigurationEvent));
        Hex_PeriodicTasks_timersConfigurationEvent item_ = (Hex_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)hex_state_taskPeriodMillis, (long)item_.getHex_state_taskPeriodMillis());
        Assert.assertEquals((long)maq20_check_status_taskPeriodMillis, (long)item_.getMaq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)temp_check_taskPeriodMillis, (long)item_.getTemp_check_taskPeriodMillis());
    }

    @Test
    public void sendReceiveHex_StatusAggregator_GeneralConfigurationEvent() throws Exception {
        String version = "";
        String patternConfigList = "x";
        SALEvent item = this.testSendReceive((SALEvent)new Hex_StatusAggregator_GeneralConfigurationEvent(version, patternConfigList));
        Assert.assertTrue((boolean)(item instanceof Hex_StatusAggregator_GeneralConfigurationEvent));
        Hex_StatusAggregator_GeneralConfigurationEvent item_ = (Hex_StatusAggregator_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)patternConfigList, (Object)item_.getPatternConfigList());
    }

    @Test
    public void sendReceiveRefrig_Cryo1_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "w";
        String maq20_serials = "";
        String plc_node = "e";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_DeviceConfigurationEvent));
        Refrig_Cryo1_DeviceConfigurationEvent item_ = (Refrig_Cryo1_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo1_DevicesConfigurationEvent() throws Exception {
        String version = "b";
        boolean maq20_disabled = false;
        boolean plc_disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_DevicesConfigurationEvent));
        Refrig_Cryo1_DevicesConfigurationEvent item_ = (Refrig_Cryo1_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo1_LimitsConfigurationEvent() throws Exception {
        String version = "c";
        double aftercooltmp_warnHi = 0.8505963683128357;
        double aftercooltmp_warnLo = 0.8351826071739197;
        double aftercooltmp_limitHi = 0.7829119563102722;
        double aftercooltmp_limitLo = 0.9551782011985779;
        double compcurrent_warnHi = 0.8803683519363403;
        double compcurrent_warnLo = 0.9467967748641968;
        double compcurrent_limitHi = 0.05507081747055054;
        double compcurrent_limitLo = 0.37750154733657837;
        double comppower_warnHi = 0.32929152250289917;
        double comppower_warnLo = 0.6068287491798401;
        double comppower_limitHi = 0.19070512056350708;
        double comppower_limitLo = 0.9657025337219238;
        double compvoltage_warnHi = 0.811535120010376;
        double compvoltage_warnLo = 0.839469f;
        double compvoltage_limitHi = 0.6548264026641846;
        double compvoltage_limitLo = 0.3849772810935974;
        double dischrgprs_warnHi = 0.2369445562362671;
        double dischrgprs_warnLo = 0.060768187046051025;
        double dischrgprs_limitHi = 0.947840690612793;
        double dischrgprs_limitLo = 0.9907975792884827;
        double dischrgtmp_M_warnHi = 0.3677181005477905;
        double dischrgtmp_M_warnLo = 0.1419163942337036;
        double dischrgtmp_M_limitHi = 0.23200958967208862;
        double dischrgtmp_M_limitLo = 0.621763288974762;
        double dischrgtmp_P_warnHi = 0.1554107666015625;
        double dischrgtmp_P_warnLo = 0.5610649585723877;
        double dischrgtmp_P_limitHi = 0.37559783458709717;
        double dischrgtmp_P_limitLo = 0.32896852493286133;
        double fanspeed_warnHi = 0.8055156469345093;
        double fanspeed_warnLo = 0.08459645509719849;
        double fanspeed_limitHi = 0.33248448371887207;
        double fanspeed_limitLo = 0.5507811307907104;
        double oillevel_warnHi = 0.9486668705940247;
        double oillevel_warnLo = 0.6936050653457642;
        double oillevel_limitHi = 0.5140964984893799;
        double oillevel_limitLo = 0.7448531985282898;
        double oilseptmp_warnHi = 0.941771388053894;
        double oilseptmp_warnLo = 0.7484720349311829;
        double oilseptmp_limitHi = 0.7645028829574585;
        double oilseptmp_limitLo = 0.010468602180480957;
        double phaseseptmp_warnHi = 0.6878884434700012;
        double phaseseptmp_warnLo = 0.6218031644821167;
        double phaseseptmp_limitHi = 0.6412501335144043;
        double phaseseptmp_limitLo = 0.8648171424865723;
        double suctionprs_warnHi = 0.8498541712760925;
        double suctionprs_warnLo = 0.26377958059310913;
        double suctionprs_limitHi = 0.3724910616874695;
        double suctionprs_limitLo = 0.37040263414382935;
        double suctiontmp_M_warnHi = 0.47953593730926514;
        double suctiontmp_M_warnLo = 0.7584148049354553;
        double suctiontmp_M_limitHi = 0.3092666268348694;
        double suctiontmp_M_limitLo = 0.9946192502975464;
        double suctiontmp_P_warnHi = 0.8228532075881958;
        double suctiontmp_P_warnLo = 0.8266887664794922;
        double suctiontmp_P_limitHi = 0.140167236328125;
        double suctiontmp_P_limitLo = 0.36675918102264404;
        double surgetanktmp_warnHi = 0.9616162776947021;
        double surgetanktmp_warnLo = 0.20355886220932007;
        double surgetanktmp_limitHi = 0.06938314437866211;
        double surgetanktmp_limitLo = 0.885668f;
        double waterintmp_warnHi = 0.4787197709083557;
        double waterintmp_warnLo = 0.7090548872947693;
        double waterintmp_limitHi = 0.5793200731277466;
        double waterintmp_limitLo = 0.5293838381767273;
        double waterouttmp_warnHi = 0.0858263373374939;
        double waterouttmp_warnLo = 0.8258102536201477;
        double waterouttmp_limitHi = 0.0721203088760376;
        double waterouttmp_limitLo = 0.2859575152397156;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_LimitsConfigurationEvent));
        Refrig_Cryo1_LimitsConfigurationEvent item_ = (Refrig_Cryo1_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "";
        String maq20_serials = "";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_DeviceConfigurationEvent));
        Refrig_Cryo2_DeviceConfigurationEvent item_ = (Refrig_Cryo2_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo2_DevicesConfigurationEvent() throws Exception {
        String version = "r";
        boolean maq20_disabled = false;
        boolean plc_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_DevicesConfigurationEvent));
        Refrig_Cryo2_DevicesConfigurationEvent item_ = (Refrig_Cryo2_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo2_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.25997406244277954;
        double aftercooltmp_warnLo = 0.21378272771835327;
        double aftercooltmp_limitHi = 0.7095667123794556;
        double aftercooltmp_limitLo = 0.2569117546081543;
        double compcurrent_warnHi = 0.8244872093200684;
        double compcurrent_warnLo = 0.5943259000778198;
        double compcurrent_limitHi = 0.4248991012573242;
        double compcurrent_limitLo = 0.5343916416168213;
        double comppower_warnHi = 0.7275944948196411;
        double comppower_warnLo = 0.8179831504821777;
        double comppower_limitHi = 0.7096013426780701;
        double comppower_limitLo = 0.2837026119232178;
        double compvoltage_warnHi = 0.7916221618652344;
        double compvoltage_warnLo = 0.10853838920593262;
        double compvoltage_limitHi = 0.6353712677955627;
        double compvoltage_limitLo = 0.8158840537071228;
        double dischrgprs_warnHi = 0.15866601467132568;
        double dischrgprs_warnLo = 0.58169f;
        double dischrgprs_limitHi = 0.9305132627487183;
        double dischrgprs_limitLo = 0.49988818168640137;
        double dischrgtmp_M_warnHi = 0.9259874224662781;
        double dischrgtmp_M_warnLo = 0.7411353588104248;
        double dischrgtmp_M_limitHi = 0.370410680770874;
        double dischrgtmp_M_limitLo = 0.4273747205734253;
        double dischrgtmp_P_warnHi = 0.11232644319534302;
        double dischrgtmp_P_warnLo = 0.11544859409332275;
        double dischrgtmp_P_limitHi = 0.531707f;
        double dischrgtmp_P_limitLo = 0.3855026960372925;
        double fanspeed_warnHi = 0.12662345170974731;
        double fanspeed_warnLo = 0.55040442943573;
        double fanspeed_limitHi = 0.4334644079208374;
        double fanspeed_limitLo = 0.18660622835159302;
        double oillevel_warnHi = 0.7508691549301147;
        double oillevel_warnLo = 0.941911518573761;
        double oillevel_limitHi = 0.798945963382721;
        double oillevel_limitLo = 0.3171289563179016;
        double oilseptmp_warnHi = 0.3028132915496826;
        double oilseptmp_warnLo = 0.6361914873123169;
        double oilseptmp_limitHi = 0.610375702381134;
        double oilseptmp_limitLo = 0.38867151737213135;
        double phaseseptmp_warnHi = 0.3044389f;
        double phaseseptmp_warnLo = 0.8059951663017273;
        double phaseseptmp_limitHi = 0.996269166469574;
        double phaseseptmp_limitLo = 0.8227730989456177;
        double suctionprs_warnHi = 0.6689545512199402;
        double suctionprs_warnLo = 0.5698431730270386;
        double suctionprs_limitHi = 0.9400115013122559;
        double suctionprs_limitLo = 0.2900077f;
        double suctiontmp_M_warnHi = 0.23121285438537598;
        double suctiontmp_M_warnLo = 0.706488f;
        double suctiontmp_M_limitHi = 0.685739f;
        double suctiontmp_M_limitLo = 0.5056788325309753;
        double suctiontmp_P_warnHi = 0.810676f;
        double suctiontmp_P_warnLo = 0.545616090297699;
        double suctiontmp_P_limitHi = 0.35282236337661743;
        double suctiontmp_P_limitLo = 0.30199337005615234;
        double surgetanktmp_warnHi = 0.9172133803367615;
        double surgetanktmp_warnLo = 0.02047944f;
        double surgetanktmp_limitHi = 0.1660524f;
        double surgetanktmp_limitLo = 0.3338874578475952;
        double waterintmp_warnHi = 0.521131f;
        double waterintmp_warnLo = 0.2465037703514099;
        double waterintmp_limitHi = 0.830807626247406;
        double waterintmp_limitLo = 0.10707056522369385;
        double waterouttmp_warnHi = 0.9210320711135864;
        double waterouttmp_warnLo = 0.1554531455039978;
        double waterouttmp_limitHi = 0.09999215602874756;
        double waterouttmp_limitLo = 0.1573919f;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_LimitsConfigurationEvent));
        Refrig_Cryo2_LimitsConfigurationEvent item_ = (Refrig_Cryo2_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3_DeviceConfigurationEvent() throws Exception {
        String version = "z";
        String maq20_node = "";
        String maq20_serials = "";
        String plc_node = "w";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_DeviceConfigurationEvent));
        Refrig_Cryo3_DeviceConfigurationEvent item_ = (Refrig_Cryo3_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo3_DevicesConfigurationEvent() throws Exception {
        String version = "u";
        boolean maq20_disabled = false;
        boolean plc_disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_DevicesConfigurationEvent));
        Refrig_Cryo3_DevicesConfigurationEvent item_ = (Refrig_Cryo3_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo3_LimitsConfigurationEvent() throws Exception {
        String version = "k";
        double aftercooltmp_warnHi = 0.8169936537742615;
        double aftercooltmp_warnLo = 0.1390208601951599;
        double aftercooltmp_limitHi = 0.779719f;
        double aftercooltmp_limitLo = 0.9887209534645081;
        double ambienttmp_warnHi = 0.277072012424469;
        double ambienttmp_warnLo = 0.915184736251831;
        double ambienttmp_limitHi = 0.538340151309967;
        double ambienttmp_limitLo = 0.42300945520401;
        double cabinettmp_warnHi = 0.6953703761100769;
        double cabinettmp_warnLo = 0.9652260541915894;
        double cabinettmp_limitHi = 0.14212846755981445;
        double cabinettmp_limitLo = 0.733724f;
        double compcurrent_warnHi = 0.6471393704414368;
        double compcurrent_warnLo = 0.9887987971305847;
        double compcurrent_limitHi = 0.9968788623809814;
        double compcurrent_limitLo = 0.8430869579315186;
        double comppower_warnHi = 0.3988179f;
        double comppower_warnLo = 0.4897953271865845;
        double comppower_limitHi = 0.26867908239364624;
        double comppower_limitLo = 0.8790637850761414;
        double compvoltage_warnHi = 0.2067958116531372;
        double compvoltage_warnLo = 0.8197957873344421;
        double compvoltage_limitHi = 0.5233194828033447;
        double compvoltage_limitLo = 0.4429087f;
        double dischrgprs_warnHi = 0.07633805274963379;
        double dischrgprs_warnLo = 0.021564245223999023;
        double dischrgprs_limitHi = 0.1617315411567688;
        double dischrgprs_limitLo = 0.0942736268043518;
        double dischrgtmp_M_warnHi = 0.15730106830596924;
        double dischrgtmp_M_warnLo = 0.3211820721626282;
        double dischrgtmp_M_limitHi = 0.87872f;
        double dischrgtmp_M_limitLo = 0.04913193f;
        double dischrgtmp_P_warnHi = 0.9343748688697815;
        double dischrgtmp_P_warnLo = 0.11765807867050171;
        double dischrgtmp_P_limitHi = 0.9988874793052673;
        double dischrgtmp_P_limitLo = 0.7465725541114807;
        double fanspeed_warnHi = 0.3558666706085205;
        double fanspeed_warnLo = 0.3533428907394409;
        double fanspeed_limitHi = 0.996278703212738;
        double fanspeed_limitLo = 0.8528434634208679;
        double oillevel_warnHi = 0.291401743888855;
        double oillevel_warnLo = 0.4994316101074219;
        double oillevel_limitHi = 0.04557693004608154;
        double oillevel_limitLo = 0.5686679482460022;
        double oilseptmp_warnHi = 0.2983502149581909;
        double oilseptmp_warnLo = 0.6061123609542847;
        double oilseptmp_limitHi = 0.2985035181045532;
        double oilseptmp_limitLo = 0.813226f;
        double phaseseptmp_warnHi = 0.7704379558563232;
        double phaseseptmp_warnLo = 0.009990692138671875;
        double phaseseptmp_limitHi = 0.14833104610443115;
        double phaseseptmp_limitLo = 0.14033353328704834;
        double suctionprs_warnHi = 0.6291144490242004;
        double suctionprs_warnLo = 0.19138479232788086;
        double suctionprs_limitHi = 0.910206f;
        double suctionprs_limitLo = 0.6549215912818909;
        double suctiontmp_M_warnHi = 0.8662184476852417;
        double suctiontmp_M_warnLo = 0.7756784558296204;
        double suctiontmp_M_limitHi = 0.6804755330085754;
        double suctiontmp_M_limitLo = 0.9372109174728394;
        double suctiontmp_P_warnHi = 0.3508124351501465;
        double suctiontmp_P_warnLo = 0.8864843845367432;
        double suctiontmp_P_limitHi = 0.1727469563484192;
        double suctiontmp_P_limitLo = 0.13490456342697144;
        double surgetanktmp_warnHi = 0.3473753333091736;
        double surgetanktmp_warnLo = 0.6098875999450684;
        double surgetanktmp_limitHi = 0.7934238314628601;
        double surgetanktmp_limitLo = 0.1778220534324646;
        double waterintmp_warnHi = 0.4586156f;
        double waterintmp_warnLo = 0.6101097464561462;
        double waterintmp_limitHi = 0.299530029296875;
        double waterintmp_limitLo = 0.12283968925476074;
        double waterouttmp_warnHi = 0.08387166261672974;
        double waterouttmp_warnLo = 0.35478538274765015;
        double waterouttmp_limitHi = 0.9644457697868347;
        double waterouttmp_limitLo = 0.20856934785842896;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_LimitsConfigurationEvent));
        Refrig_Cryo3_LimitsConfigurationEvent item_ = (Refrig_Cryo3_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3_PicConfigurationEvent() throws Exception {
        String version = "g";
        double fanctrl_awGain = 0.10355937480926514;
        double fanctrl_baseDuty = 0.4383151f;
        double fanctrl_gain = 0.9260600805282593;
        double fanctrl_maxInput = 0.295015811920166;
        double fanctrl_maxOutput = 0.12573248147964478;
        double fanctrl_minInput = 0.7065396308898926;
        double fanctrl_minOutput = 0.3767498731613159;
        double fanctrl_setTemp = 0.24975663423538208;
        double fanctrl_smoothTime = 0.4749488830566406;
        double fanctrl_timeConst = 0.3190044164657593;
        double fanctrl_tolerance = 0.20412278175354004;
        boolean fanctrl_useAbsTemp = true;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_PicConfigurationEvent(version, fanctrl_awGain, fanctrl_baseDuty, fanctrl_gain, fanctrl_maxInput, fanctrl_maxOutput, fanctrl_minInput, fanctrl_minOutput, fanctrl_setTemp, fanctrl_smoothTime, fanctrl_timeConst, fanctrl_tolerance, fanctrl_useAbsTemp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_PicConfigurationEvent));
        Refrig_Cryo3_PicConfigurationEvent item_ = (Refrig_Cryo3_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)fanctrl_awGain, (double)item_.getFanctrl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_baseDuty, (double)item_.getFanctrl_baseDuty(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_gain, (double)item_.getFanctrl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxInput, (double)item_.getFanctrl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxOutput, (double)item_.getFanctrl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minInput, (double)item_.getFanctrl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minOutput, (double)item_.getFanctrl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_setTemp, (double)item_.getFanctrl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_smoothTime, (double)item_.getFanctrl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_timeConst, (double)item_.getFanctrl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_tolerance, (double)item_.getFanctrl_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((Object)fanctrl_useAbsTemp, (Object)item_.isFanctrl_useAbsTemp());
    }

    @Test
    public void sendReceiveRefrig_Cryo4_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "i";
        String maq20_serials = "";
        String plc_node = "g";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_DeviceConfigurationEvent));
        Refrig_Cryo4_DeviceConfigurationEvent item_ = (Refrig_Cryo4_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo4_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean maq20_disabled = true;
        boolean plc_disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_DevicesConfigurationEvent));
        Refrig_Cryo4_DevicesConfigurationEvent item_ = (Refrig_Cryo4_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo4_LimitsConfigurationEvent() throws Exception {
        String version = "d";
        double aftercooltmp_warnHi = 0.8585658669471741;
        double aftercooltmp_warnLo = 0.6897554993629456;
        double aftercooltmp_limitHi = 0.7235310673713684;
        double aftercooltmp_limitLo = 0.2210521101951599;
        double compcurrent_warnHi = 8.614659309387207E-4;
        double compcurrent_warnLo = 0.758385f;
        double compcurrent_limitHi = 0.986163318157196;
        double compcurrent_limitLo = 0.8220734000205994;
        double comppower_warnHi = 0.2030126452445984;
        double comppower_warnLo = 0.1932382583618164;
        double comppower_limitHi = 0.062367022037506104;
        double comppower_limitLo = 0.7379392981529236;
        double compvoltage_warnHi = 0.7134362459182739;
        double compvoltage_warnLo = 0.3505188226699829;
        double compvoltage_limitHi = 0.09814947843551636;
        double compvoltage_limitLo = 0.16175276041030884;
        double dischrgprs_warnHi = 0.8024162650108337;
        double dischrgprs_warnLo = 0.8596912026405334;
        double dischrgprs_limitHi = 0.41652631759643555;
        double dischrgprs_limitLo = 0.27237361669540405;
        double dischrgtmp_M_warnHi = 0.9842463135719299;
        double dischrgtmp_M_warnLo = 0.8040790557861328;
        double dischrgtmp_M_limitHi = 0.344898521900177;
        double dischrgtmp_M_limitLo = 0.7289501428604126;
        double dischrgtmp_P_warnHi = 0.9045096039772034;
        double dischrgtmp_P_warnLo = 0.7711588144302368;
        double dischrgtmp_P_limitHi = 0.22900527715682983;
        double dischrgtmp_P_limitLo = 0.6242959499359131;
        double fanspeed_warnHi = 0.796847939491272;
        double fanspeed_warnLo = 0.19282597303390503;
        double fanspeed_limitHi = 0.22758746147155762;
        double fanspeed_limitLo = 0.4324553608894348;
        double oillevel_warnHi = 0.3753041625022888;
        double oillevel_warnLo = 0.16835826635360718;
        double oillevel_limitHi = 0.5050604343414307;
        double oillevel_limitLo = 0.06370240449905396;
        double oilseptmp_warnHi = 0.7674635052680969;
        double oilseptmp_warnLo = 0.06612330675125122;
        double oilseptmp_limitHi = 0.24641722440719604;
        double oilseptmp_limitLo = 0.4908837676048279;
        double phaseseptmp_warnHi = 0.5330145359039307;
        double phaseseptmp_warnLo = 0.7250893115997314;
        double phaseseptmp_limitHi = 0.9086655378341675;
        double phaseseptmp_limitLo = 0.5705804228782654;
        double suctionprs_warnHi = 0.3904784321784973;
        double suctionprs_warnLo = 0.3178486227989197;
        double suctionprs_limitHi = 0.8363955616950989;
        double suctionprs_limitLo = 0.01528573f;
        double suctiontmp_M_warnHi = 0.19582092761993408;
        double suctiontmp_M_warnLo = 0.6402224898338318;
        double suctiontmp_M_limitHi = 0.7362356781959534;
        double suctiontmp_M_limitLo = 0.9210574626922607;
        double suctiontmp_P_warnHi = 0.2001828f;
        double suctiontmp_P_warnLo = 0.2087729573249817;
        double suctiontmp_P_limitHi = 0.0972716212272644;
        double suctiontmp_P_limitLo = 0.5894113183021545;
        double surgetanktmp_warnHi = 0.14540356397628784;
        double surgetanktmp_warnLo = 0.48003554344177246;
        double surgetanktmp_limitHi = 0.9238985776901245;
        double surgetanktmp_limitLo = 0.4512117f;
        double waterintmp_warnHi = 0.33633846044540405;
        double waterintmp_warnLo = 0.3604347f;
        double waterintmp_limitHi = 0.716579020023346;
        double waterintmp_limitLo = 0.8807411193847656;
        double waterouttmp_warnHi = 0.22478598356246948;
        double waterouttmp_warnLo = 0.01323777437210083;
        double waterouttmp_limitHi = 0.48775774240493774;
        double waterouttmp_limitLo = 0.3348802924156189;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_LimitsConfigurationEvent));
        Refrig_Cryo4_LimitsConfigurationEvent item_ = (Refrig_Cryo4_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "j";
        String maq20_serials = "";
        String plc_node = "a";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_DeviceConfigurationEvent));
        Refrig_Cryo5_DeviceConfigurationEvent item_ = (Refrig_Cryo5_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo5_DevicesConfigurationEvent() throws Exception {
        String version = "f";
        boolean maq20_disabled = false;
        boolean plc_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_DevicesConfigurationEvent));
        Refrig_Cryo5_DevicesConfigurationEvent item_ = (Refrig_Cryo5_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo5_LimitsConfigurationEvent() throws Exception {
        String version = "m";
        double aftercooltmp_warnHi = 0.189189612865448;
        double aftercooltmp_warnLo = 0.4931233525276184;
        double aftercooltmp_limitHi = 0.5774151682853699;
        double aftercooltmp_limitLo = 0.10885119438171387;
        double ambienttmp_warnHi = 0.18275481462478638;
        double ambienttmp_warnLo = 0.6625542044639587;
        double ambienttmp_limitHi = 0.65358f;
        double ambienttmp_limitLo = 0.4216992259025574;
        double cabinettmp_warnHi = 0.49060964584350586;
        double cabinettmp_warnLo = 0.576188862323761;
        double cabinettmp_limitHi = 0.7076285481452942;
        double cabinettmp_limitLo = 0.8091249465942383;
        double compcurrent_warnHi = 0.5208961963653564;
        double compcurrent_warnLo = 0.745803952217102;
        double compcurrent_limitHi = 0.4315042495727539;
        double compcurrent_limitLo = 0.06382858753204346;
        double comppower_warnHi = 0.44760453701019287;
        double comppower_warnLo = 0.22132503986358643;
        double comppower_limitHi = 0.582874059677124;
        double comppower_limitLo = 0.47678375244140625;
        double compvoltage_warnHi = 0.9815229177474976;
        double compvoltage_warnLo = 0.8861351013183594;
        double compvoltage_limitHi = 0.26060914993286133;
        double compvoltage_limitLo = 0.40995967388153076;
        double dischrgprs_warnHi = 0.3302185535430908;
        double dischrgprs_warnLo = 0.2610187530517578;
        double dischrgprs_limitHi = 0.540095865726471;
        double dischrgprs_limitLo = 0.1026091f;
        double dischrgtmp_M_warnHi = 0.4469099f;
        double dischrgtmp_M_warnLo = 0.22739005088806152;
        double dischrgtmp_M_limitHi = 0.09896194934844971;
        double dischrgtmp_M_limitLo = 0.5870565176010132;
        double dischrgtmp_P_warnHi = 0.5822194218635559;
        double dischrgtmp_P_warnLo = 0.5386918187141418;
        double dischrgtmp_P_limitHi = 0.6131938695907593;
        double dischrgtmp_P_limitLo = 0.8008796572685242;
        double fanspeed_warnHi = 0.2701093554496765;
        double fanspeed_warnLo = 0.18812376260757446;
        double fanspeed_limitHi = 0.3437894f;
        double fanspeed_limitLo = 0.0325050950050354;
        double oillevel_warnHi = 0.9351528882980347;
        double oillevel_warnLo = 0.2944710850715637;
        double oillevel_limitHi = 0.17696022987365723;
        double oillevel_limitLo = 0.8251739144325256;
        double oilseptmp_warnHi = 0.5536596179008484;
        double oilseptmp_warnLo = 0.012217521667480469;
        double oilseptmp_limitHi = 0.2790037989616394;
        double oilseptmp_limitLo = 0.8167297840118408;
        double phaseseptmp_warnHi = 0.2526538372039795;
        double phaseseptmp_warnLo = 0.37689924240112305;
        double phaseseptmp_limitHi = 0.72347092628479;
        double phaseseptmp_limitLo = 0.7146243453025818;
        double suctionprs_warnHi = 0.4205285906791687;
        double suctionprs_warnLo = 0.9744883179664612;
        double suctionprs_limitHi = 0.8269518613815308;
        double suctionprs_limitLo = 0.5299327373504639;
        double suctiontmp_M_warnHi = 0.12921392917633057;
        double suctiontmp_M_warnLo = 0.8403084874153137;
        double suctiontmp_M_limitHi = 0.2651034f;
        double suctiontmp_M_limitLo = 0.2321536f;
        double suctiontmp_P_warnHi = 0.24338674545288086;
        double suctiontmp_P_warnLo = 0.2175209f;
        double suctiontmp_P_limitHi = 0.24748414754867554;
        double suctiontmp_P_limitLo = 0.3773950934410095;
        double surgetanktmp_warnHi = 0.0967077f;
        double surgetanktmp_warnLo = 0.3596503f;
        double surgetanktmp_limitHi = 0.41401517391204834;
        double surgetanktmp_limitLo = 0.8236048221588135;
        double waterintmp_warnHi = 0.64303f;
        double waterintmp_warnLo = 0.7711450457572937;
        double waterintmp_limitHi = 0.6237296462059021;
        double waterintmp_limitLo = 0.023287057876586914;
        double waterouttmp_warnHi = 0.40233057737350464;
        double waterouttmp_warnLo = 0.4228951930999756;
        double waterouttmp_limitHi = 0.2748332f;
        double waterouttmp_limitLo = 0.30031102895736694;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_LimitsConfigurationEvent));
        Refrig_Cryo5_LimitsConfigurationEvent item_ = (Refrig_Cryo5_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5_PicConfigurationEvent() throws Exception {
        String version = "y";
        double fanctrl_awGain = 0.2015022f;
        double fanctrl_baseDuty = 0.024693548679351807;
        double fanctrl_gain = 0.7132042646408081;
        double fanctrl_maxInput = 0.4456857442855835;
        double fanctrl_maxOutput = 0.9054670929908752;
        double fanctrl_minInput = 0.3275317f;
        double fanctrl_minOutput = 0.17269080877304077;
        double fanctrl_setTemp = 0.9117224216461182;
        double fanctrl_smoothTime = 0.9080513715744019;
        double fanctrl_timeConst = 0.40556687116622925;
        double fanctrl_tolerance = 0.7757561802864075;
        boolean fanctrl_useAbsTemp = true;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_PicConfigurationEvent(version, fanctrl_awGain, fanctrl_baseDuty, fanctrl_gain, fanctrl_maxInput, fanctrl_maxOutput, fanctrl_minInput, fanctrl_minOutput, fanctrl_setTemp, fanctrl_smoothTime, fanctrl_timeConst, fanctrl_tolerance, fanctrl_useAbsTemp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_PicConfigurationEvent));
        Refrig_Cryo5_PicConfigurationEvent item_ = (Refrig_Cryo5_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)fanctrl_awGain, (double)item_.getFanctrl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_baseDuty, (double)item_.getFanctrl_baseDuty(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_gain, (double)item_.getFanctrl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxInput, (double)item_.getFanctrl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxOutput, (double)item_.getFanctrl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minInput, (double)item_.getFanctrl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minOutput, (double)item_.getFanctrl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_setTemp, (double)item_.getFanctrl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_smoothTime, (double)item_.getFanctrl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_timeConst, (double)item_.getFanctrl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_tolerance, (double)item_.getFanctrl_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((Object)fanctrl_useAbsTemp, (Object)item_.isFanctrl_useAbsTemp());
    }

    @Test
    public void sendReceiveRefrig_Cryo6_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "";
        String maq20_serials = "p";
        String plc_node = "w";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_DeviceConfigurationEvent));
        Refrig_Cryo6_DeviceConfigurationEvent item_ = (Refrig_Cryo6_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo6_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean maq20_disabled = false;
        boolean plc_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_DevicesConfigurationEvent));
        Refrig_Cryo6_DevicesConfigurationEvent item_ = (Refrig_Cryo6_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo6_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.1836094856262207;
        double aftercooltmp_warnLo = 0.6274861693382263;
        double aftercooltmp_limitHi = 0.4388948678970337;
        double aftercooltmp_limitLo = 0.9913501739501953;
        double compcurrent_warnHi = 0.27084267139434814;
        double compcurrent_warnLo = 0.18169403076171875;
        double compcurrent_limitHi = 0.09214985370635986;
        double compcurrent_limitLo = 0.4011055827140808;
        double comppower_warnHi = 0.017182588577270508;
        double comppower_warnLo = 0.568577766418457;
        double comppower_limitHi = 0.2997971177101135;
        double comppower_limitLo = 0.03229391574859619;
        double compvoltage_warnHi = 0.46688413619995117;
        double compvoltage_warnLo = 0.9947351813316345;
        double compvoltage_limitHi = 0.6388403177261353;
        double compvoltage_limitLo = 0.6264894604682922;
        double dischrgprs_warnHi = 0.5283551812171936;
        double dischrgprs_warnLo = 0.18395566940307617;
        double dischrgprs_limitHi = 0.1932077407836914;
        double dischrgprs_limitLo = 0.6003178954124451;
        double dischrgtmp_M_warnHi = 0.6415472626686096;
        double dischrgtmp_M_warnLo = 0.8836649656295776;
        double dischrgtmp_M_limitHi = 0.6872890591621399;
        double dischrgtmp_M_limitLo = 0.26738274097442627;
        double dischrgtmp_P_warnHi = 0.05051279067993164;
        double dischrgtmp_P_warnLo = 0.5155674815177917;
        double dischrgtmp_P_limitHi = 0.4818124771118164;
        double dischrgtmp_P_limitLo = 0.5618872046470642;
        double fanspeed_warnHi = 0.05482828617095947;
        double fanspeed_warnLo = 0.8134623169898987;
        double fanspeed_limitHi = 0.8410322666168213;
        double fanspeed_limitLo = 0.3022293448448181;
        double oillevel_warnHi = 0.6503296494483948;
        double oillevel_warnLo = 0.9587438702583313;
        double oillevel_limitHi = 0.8108999133110046;
        double oillevel_limitLo = 4.579425E-4f;
        double oilseptmp_warnHi = 0.28082817792892456;
        double oilseptmp_warnLo = 0.4031602740287781;
        double oilseptmp_limitHi = 0.4547199010848999;
        double oilseptmp_limitLo = 0.9335781931877136;
        double phaseseptmp_warnHi = 0.6341502070426941;
        double phaseseptmp_warnLo = 0.9904511570930481;
        double phaseseptmp_limitHi = 0.30330485105514526;
        double phaseseptmp_limitLo = 0.9470493793487549;
        double suctionprs_warnHi = 0.9195677042007446;
        double suctionprs_warnLo = 0.3380838632583618;
        double suctionprs_limitHi = 0.3089866042137146;
        double suctionprs_limitLo = 0.1393022f;
        double suctiontmp_M_warnHi = 0.2666983f;
        double suctiontmp_M_warnLo = 0.605151891708374;
        double suctiontmp_M_limitHi = 0.6058160662651062;
        double suctiontmp_M_limitLo = 0.8867303133010864;
        double suctiontmp_P_warnHi = 0.4610862731933594;
        double suctiontmp_P_warnLo = 0.5934098958969116;
        double suctiontmp_P_limitHi = 0.12129944562911987;
        double suctiontmp_P_limitLo = 0.3975124955177307;
        double surgetanktmp_warnHi = 0.36742645502090454;
        double surgetanktmp_warnLo = 0.6493446826934814;
        double surgetanktmp_limitHi = 0.8481138944625854;
        double surgetanktmp_limitLo = 0.24405282735824585;
        double waterintmp_warnHi = 0.04184520244598389;
        double waterintmp_warnLo = 0.553186297416687;
        double waterintmp_limitHi = 0.04808610677719116;
        double waterintmp_limitLo = 0.8101748824119568;
        double waterouttmp_warnHi = 0.669546365737915;
        double waterouttmp_warnLo = 0.6960483193397522;
        double waterouttmp_limitHi = 0.14659267663955688;
        double waterouttmp_limitLo = 0.8209753632545471;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_LimitsConfigurationEvent));
        Refrig_Cryo6_LimitsConfigurationEvent item_ = (Refrig_Cryo6_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_CryoCompLimits_CompLimitsConfigurationEvent() throws Exception {
        String version = "";
        double cmprPowerDelayLimit = 0.5122677683830261;
        int cmprPowerDelayTime = 418;
        double cmprPowerImmedLimit = 0.699066162109375;
        double discPressDelayLimit = 0.8277574181556702;
        double discPressImmedLimit = 0.7069417238235474;
        double discTempDelayLimit = 0.8879616260528564;
        int discTempDelayTime = 546;
        double discTempImmedLimit = 0.4531694f;
        double discTempLowImmedLimit = 0.10819530487060547;
        double heaterTempLimit = 0.948234498500824;
        double oilLevelImmedLimit = 0.5025935769081116;
        double orificeOffPress = 0.7429161667823792;
        double orificeOnPress = 0.49256646633148193;
        double phaseSepTempDelayLimit = 0.6613069176673889;
        int phaseSepTempDelayTime = 665;
        double pressDiffImmedLimit = 0.24356502294540405;
        double suctTempImmedLimit = 0.945868f;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_CryoCompLimits_CompLimitsConfigurationEvent(version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, discPressDelayLimit, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, oilLevelImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_CryoCompLimits_CompLimitsConfigurationEvent));
        Refrig_CryoCompLimits_CompLimitsConfigurationEvent item_ = (Refrig_CryoCompLimits_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevelImmedLimit, (double)item_.getOilLevelImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "y";
        int schedulers_default_nTasks = 118;
        int schedulers_default_nThreads = 189;
        int schedulers_monitor_check_scheduler_nTasks = 10;
        int schedulers_monitor_check_scheduler_nThreads = 608;
        int schedulers_monitor_update_publish_scheduler_nTasks = 125;
        int schedulers_monitor_update_publish_scheduler_nThreads = 324;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Refrig_PeriodicTasks_GeneralConfigurationEvent));
        Refrig_PeriodicTasks_GeneralConfigurationEvent item_ = (Refrig_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveRefrig_PeriodicTasks_PicConfigurationEvent() throws Exception {
        String version = "b";
        long cryo3_FanCtrl_iterate_updateTime = 313L;
        long cryo5_FanCtrl_iterate_updateTime = 325L;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_PeriodicTasks_PicConfigurationEvent(version, cryo3_FanCtrl_iterate_updateTime, cryo5_FanCtrl_iterate_updateTime));
        Assert.assertTrue((boolean)(item instanceof Refrig_PeriodicTasks_PicConfigurationEvent));
        Refrig_PeriodicTasks_PicConfigurationEvent item_ = (Refrig_PeriodicTasks_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)cryo3_FanCtrl_iterate_updateTime, (long)item_.getCryo3_FanCtrl_iterate_updateTime());
        Assert.assertEquals((long)cryo5_FanCtrl_iterate_updateTime, (long)item_.getCryo5_FanCtrl_iterate_updateTime());
    }

    @Test
    public void sendReceiveRefrig_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "v";
        long agentmonitorservice_taskPeriodMillis = 68L;
        long compressor_state_taskPeriodMillis = 867L;
        long cryo1_Maq20_check_status_taskPeriodMillis = 132L;
        long cryo2_Maq20_check_status_taskPeriodMillis = 591L;
        long cryo3_Maq20_check_status_taskPeriodMillis = 161L;
        long cryo4_Maq20_check_status_taskPeriodMillis = 806L;
        long cryo5_Maq20_check_status_taskPeriodMillis = 645L;
        long cryo6_Maq20_check_status_taskPeriodMillis = 784L;
        long heartbeat_taskPeriodMillis = 374L;
        long monitor_check_Cryo1_Maq20_taskPeriodMillis = 239L;
        long monitor_check_Cryo1_Plc_taskPeriodMillis = 453L;
        long monitor_check_Cryo2_Maq20_taskPeriodMillis = 955L;
        long monitor_check_Cryo2_Plc_taskPeriodMillis = 258L;
        long monitor_check_Cryo3_Maq20_taskPeriodMillis = 104L;
        long monitor_check_Cryo3_Plc_taskPeriodMillis = 993L;
        long monitor_check_Cryo4_Maq20_taskPeriodMillis = 206L;
        long monitor_check_Cryo4_Plc_taskPeriodMillis = 421L;
        long monitor_check_Cryo5_Maq20_taskPeriodMillis = 246L;
        long monitor_check_Cryo5_Plc_taskPeriodMillis = 347L;
        long monitor_check_Cryo6_Maq20_taskPeriodMillis = 780L;
        long monitor_check_Cryo6_Plc_taskPeriodMillis = 735L;
        long monitor_publish_Cryo1_Maq20_taskPeriodMillis = 989L;
        long monitor_publish_Cryo1_Plc_taskPeriodMillis = 232L;
        long monitor_publish_Cryo2_Maq20_taskPeriodMillis = 975L;
        long monitor_publish_Cryo2_Plc_taskPeriodMillis = 88L;
        long monitor_publish_Cryo3_Maq20_taskPeriodMillis = 814L;
        long monitor_publish_Cryo3_Plc_taskPeriodMillis = 21L;
        long monitor_publish_Cryo4_Maq20_taskPeriodMillis = 609L;
        long monitor_publish_Cryo4_Plc_taskPeriodMillis = 703L;
        long monitor_publish_Cryo5_Maq20_taskPeriodMillis = 55L;
        long monitor_publish_Cryo5_Plc_taskPeriodMillis = 34L;
        long monitor_publish_Cryo6_Maq20_taskPeriodMillis = 167L;
        long monitor_publish_Cryo6_Plc_taskPeriodMillis = 991L;
        long monitor_update_Cryo1_Maq20_taskPeriodMillis = 639L;
        long monitor_update_Cryo1_Plc_taskPeriodMillis = 975L;
        long monitor_update_Cryo2_Maq20_taskPeriodMillis = 859L;
        long monitor_update_Cryo2_Plc_taskPeriodMillis = 307L;
        long monitor_update_Cryo3_Maq20_taskPeriodMillis = 372L;
        long monitor_update_Cryo3_Plc_taskPeriodMillis = 971L;
        long monitor_update_Cryo4_Maq20_taskPeriodMillis = 996L;
        long monitor_update_Cryo4_Plc_taskPeriodMillis = 505L;
        long monitor_update_Cryo5_Maq20_taskPeriodMillis = 419L;
        long monitor_update_Cryo5_Plc_taskPeriodMillis = 995L;
        long monitor_update_Cryo6_Maq20_taskPeriodMillis = 236L;
        long monitor_update_Cryo6_Plc_taskPeriodMillis = 548L;
        long runtimeinfo_taskPeriodMillis = 300L;
        long update_time_taskPeriodMillis = 287L;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, compressor_state_taskPeriodMillis, cryo1_Maq20_check_status_taskPeriodMillis, cryo2_Maq20_check_status_taskPeriodMillis, cryo3_Maq20_check_status_taskPeriodMillis, cryo4_Maq20_check_status_taskPeriodMillis, cryo5_Maq20_check_status_taskPeriodMillis, cryo6_Maq20_check_status_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_Cryo1_Maq20_taskPeriodMillis, monitor_check_Cryo1_Plc_taskPeriodMillis, monitor_check_Cryo2_Maq20_taskPeriodMillis, monitor_check_Cryo2_Plc_taskPeriodMillis, monitor_check_Cryo3_Maq20_taskPeriodMillis, monitor_check_Cryo3_Plc_taskPeriodMillis, monitor_check_Cryo4_Maq20_taskPeriodMillis, monitor_check_Cryo4_Plc_taskPeriodMillis, monitor_check_Cryo5_Maq20_taskPeriodMillis, monitor_check_Cryo5_Plc_taskPeriodMillis, monitor_check_Cryo6_Maq20_taskPeriodMillis, monitor_check_Cryo6_Plc_taskPeriodMillis, monitor_publish_Cryo1_Maq20_taskPeriodMillis, monitor_publish_Cryo1_Plc_taskPeriodMillis, monitor_publish_Cryo2_Maq20_taskPeriodMillis, monitor_publish_Cryo2_Plc_taskPeriodMillis, monitor_publish_Cryo3_Maq20_taskPeriodMillis, monitor_publish_Cryo3_Plc_taskPeriodMillis, monitor_publish_Cryo4_Maq20_taskPeriodMillis, monitor_publish_Cryo4_Plc_taskPeriodMillis, monitor_publish_Cryo5_Maq20_taskPeriodMillis, monitor_publish_Cryo5_Plc_taskPeriodMillis, monitor_publish_Cryo6_Maq20_taskPeriodMillis, monitor_publish_Cryo6_Plc_taskPeriodMillis, monitor_update_Cryo1_Maq20_taskPeriodMillis, monitor_update_Cryo1_Plc_taskPeriodMillis, monitor_update_Cryo2_Maq20_taskPeriodMillis, monitor_update_Cryo2_Plc_taskPeriodMillis, monitor_update_Cryo3_Maq20_taskPeriodMillis, monitor_update_Cryo3_Plc_taskPeriodMillis, monitor_update_Cryo4_Maq20_taskPeriodMillis, monitor_update_Cryo4_Plc_taskPeriodMillis, monitor_update_Cryo5_Maq20_taskPeriodMillis, monitor_update_Cryo5_Plc_taskPeriodMillis, monitor_update_Cryo6_Maq20_taskPeriodMillis, monitor_update_Cryo6_Plc_taskPeriodMillis, runtimeinfo_taskPeriodMillis, update_time_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Refrig_PeriodicTasks_timersConfigurationEvent));
        Refrig_PeriodicTasks_timersConfigurationEvent item_ = (Refrig_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)compressor_state_taskPeriodMillis, (long)item_.getCompressor_state_taskPeriodMillis());
        Assert.assertEquals((long)cryo1_Maq20_check_status_taskPeriodMillis, (long)item_.getCryo1_Maq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)cryo2_Maq20_check_status_taskPeriodMillis, (long)item_.getCryo2_Maq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)cryo3_Maq20_check_status_taskPeriodMillis, (long)item_.getCryo3_Maq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)cryo4_Maq20_check_status_taskPeriodMillis, (long)item_.getCryo4_Maq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)cryo5_Maq20_check_status_taskPeriodMillis, (long)item_.getCryo5_Maq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)cryo6_Maq20_check_status_taskPeriodMillis, (long)item_.getCryo6_Maq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo1_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo1_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo1_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo1_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo2_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo2_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo2_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo2_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo3_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo3_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo3_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo3_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo4_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo4_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo4_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo4_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo5_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo5_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo5_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo5_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo6_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo6_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo6_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo6_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo1_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo1_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo1_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo1_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo2_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo2_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo2_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo2_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo3_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo3_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo3_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo3_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo4_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo4_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo4_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo4_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo5_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo5_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo5_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo5_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo6_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo6_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo6_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo6_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo1_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo1_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo1_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo1_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo2_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo2_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo2_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo2_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo3_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo3_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo3_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo3_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo4_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo4_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo4_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo4_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo5_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo5_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo5_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo5_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo6_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo6_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo6_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo6_Plc_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)update_time_taskPeriodMillis, (long)item_.getUpdate_time_taskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_Cip_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double[] cryo_I_warnHi = TestHelper.generateDoubleArray((int)6, (int)2067130345);
        double[] cryo_I_warnLo = TestHelper.generateDoubleArray((int)6, (int)-1569038273);
        double[] cryo_I_limitHi = TestHelper.generateDoubleArray((int)6, (int)700828897);
        double[] cryo_I_limitLo = TestHelper.generateDoubleArray((int)6, (int)2037262307);
        double[] cryo_Life_warnHi = TestHelper.generateDoubleArray((int)6, (int)-1094079358);
        double[] cryo_Life_warnLo = TestHelper.generateDoubleArray((int)6, (int)-2121750515);
        double[] cryo_Life_limitHi = TestHelper.generateDoubleArray((int)6, (int)-616050836);
        double[] cryo_Life_limitLo = TestHelper.generateDoubleArray((int)6, (int)1253191756);
        double[] cryo_Usage_warnHi = TestHelper.generateDoubleArray((int)6, (int)-802871414);
        double[] cryo_Usage_warnLo = TestHelper.generateDoubleArray((int)6, (int)1682383139);
        double[] cryo_Usage_limitHi = TestHelper.generateDoubleArray((int)6, (int)847810333);
        double[] cryo_Usage_limitLo = TestHelper.generateDoubleArray((int)6, (int)1268508900);
        double[] cryo_V_warnHi = TestHelper.generateDoubleArray((int)6, (int)19006446);
        double[] cryo_V_warnLo = TestHelper.generateDoubleArray((int)6, (int)-471059455);
        double[] cryo_V_limitHi = TestHelper.generateDoubleArray((int)6, (int)-2110920366);
        double[] cryo_V_limitLo = TestHelper.generateDoubleArray((int)6, (int)186960465);
        String location = "r";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cip_LimitsConfigurationEvent(version, cryo_I_warnHi, cryo_I_warnLo, cryo_I_limitHi, cryo_I_limitLo, cryo_Life_warnHi, cryo_Life_warnLo, cryo_Life_limitHi, cryo_Life_limitLo, cryo_Usage_warnHi, cryo_Usage_warnLo, cryo_Usage_limitHi, cryo_Usage_limitLo, cryo_V_warnHi, cryo_V_warnLo, cryo_V_limitHi, cryo_V_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cip_LimitsConfigurationEvent));
        Vacuum_Cip_LimitsConfigurationEvent item_ = (Vacuum_Cip_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])cryo_I_warnHi, (double[])item_.getCryo_I_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_I_warnLo, (double[])item_.getCryo_I_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_I_limitHi, (double[])item_.getCryo_I_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_I_limitLo, (double[])item_.getCryo_I_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life_warnHi, (double[])item_.getCryo_Life_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life_warnLo, (double[])item_.getCryo_Life_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life_limitHi, (double[])item_.getCryo_Life_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life_limitLo, (double[])item_.getCryo_Life_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage_warnHi, (double[])item_.getCryo_Usage_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage_warnLo, (double[])item_.getCryo_Usage_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage_limitHi, (double[])item_.getCryo_Usage_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage_limitLo, (double[])item_.getCryo_Usage_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V_warnHi, (double[])item_.getCryo_V_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V_warnLo, (double[])item_.getCryo_V_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V_limitHi, (double[])item_.getCryo_V_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V_limitLo, (double[])item_.getCryo_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_CryoFlineGauge_CryoConfigurationEvent() throws Exception {
        String version = "";
        int busAddr = 678;
        String devcId = "q";
        double[] relayTrip = TestHelper.generateDoubleArray((int)3, (int)2131589317);
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoFlineGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoFlineGauge_CryoConfigurationEvent));
        Vacuum_CryoFlineGauge_CryoConfigurationEvent item_ = (Vacuum_CryoFlineGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertArrayEquals((double[])relayTrip, (double[])item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoFlineGauge_DevicesConfigurationEvent() throws Exception {
        String version = "u";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoFlineGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoFlineGauge_DevicesConfigurationEvent));
        Vacuum_CryoFlineGauge_DevicesConfigurationEvent item_ = (Vacuum_CryoFlineGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_CryoTurboGauge_CryoConfigurationEvent() throws Exception {
        String version = "";
        int busAddr = 642;
        String devcId = "";
        double[] relayTrip = TestHelper.generateDoubleArray((int)3, (int)130033760);
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoTurboGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTurboGauge_CryoConfigurationEvent));
        Vacuum_CryoTurboGauge_CryoConfigurationEvent item_ = (Vacuum_CryoTurboGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertArrayEquals((double[])relayTrip, (double[])item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoTurboGauge_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoTurboGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTurboGauge_DevicesConfigurationEvent));
        Vacuum_CryoTurboGauge_DevicesConfigurationEvent item_ = (Vacuum_CryoTurboGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_CryoTurboPump_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoTurboPump_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTurboPump_DevicesConfigurationEvent));
        Vacuum_CryoTurboPump_DevicesConfigurationEvent item_ = (Vacuum_CryoTurboPump_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_CryoTurboPump_GeneralConfigurationEvent() throws Exception {
        String version = "";
        boolean activeStopMode = true;
        int analogOutput = 935;
        int baudRate = 470;
        String devcId = "r";
        int extFanConfig = 815;
        int gasType = 0;
        boolean gasTypeArgon = true;
        boolean interlockType = true;
        boolean lowSpeedMode = false;
        int maxpower = 660;
        int rotfreqLow = 164;
        int rotfreqMax = 650;
        int rotfreqSet = 805;
        boolean setpointActive = false;
        int setpointDelay = 1;
        int setpointHyst = 606;
        int setpointThresh = 209;
        int setpointType = 600;
        boolean softStartMode = true;
        boolean speedReadActivate = false;
        int ventDelay = 213;
        int ventOpentime = 951;
        boolean ventvalveByCmnd = false;
        boolean ventvalveType = false;
        boolean waterCooling = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoTurboPump_GeneralConfigurationEvent(version, activeStopMode, analogOutput, baudRate, devcId, extFanConfig, gasType, gasTypeArgon, interlockType, lowSpeedMode, maxpower, rotfreqLow, rotfreqMax, rotfreqSet, setpointActive, setpointDelay, setpointHyst, setpointThresh, setpointType, softStartMode, speedReadActivate, ventDelay, ventOpentime, ventvalveByCmnd, ventvalveType, waterCooling));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTurboPump_GeneralConfigurationEvent));
        Vacuum_CryoTurboPump_GeneralConfigurationEvent item_ = (Vacuum_CryoTurboPump_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)activeStopMode, (Object)item_.isActiveStopMode());
        Assert.assertEquals((long)analogOutput, (long)item_.getAnalogOutput());
        Assert.assertEquals((long)baudRate, (long)item_.getBaudRate());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((long)extFanConfig, (long)item_.getExtFanConfig());
        Assert.assertEquals((long)gasType, (long)item_.getGasType());
        Assert.assertEquals((Object)gasTypeArgon, (Object)item_.isGasTypeArgon());
        Assert.assertEquals((Object)interlockType, (Object)item_.isInterlockType());
        Assert.assertEquals((Object)lowSpeedMode, (Object)item_.isLowSpeedMode());
        Assert.assertEquals((long)maxpower, (long)item_.getMaxpower());
        Assert.assertEquals((long)rotfreqLow, (long)item_.getRotfreqLow());
        Assert.assertEquals((long)rotfreqMax, (long)item_.getRotfreqMax());
        Assert.assertEquals((long)rotfreqSet, (long)item_.getRotfreqSet());
        Assert.assertEquals((Object)setpointActive, (Object)item_.isSetpointActive());
        Assert.assertEquals((long)setpointDelay, (long)item_.getSetpointDelay());
        Assert.assertEquals((long)setpointHyst, (long)item_.getSetpointHyst());
        Assert.assertEquals((long)setpointThresh, (long)item_.getSetpointThresh());
        Assert.assertEquals((long)setpointType, (long)item_.getSetpointType());
        Assert.assertEquals((Object)softStartMode, (Object)item_.isSoftStartMode());
        Assert.assertEquals((Object)speedReadActivate, (Object)item_.isSpeedReadActivate());
        Assert.assertEquals((long)ventDelay, (long)item_.getVentDelay());
        Assert.assertEquals((long)ventOpentime, (long)item_.getVentOpentime());
        Assert.assertEquals((Object)ventvalveByCmnd, (Object)item_.isVentvalveByCmnd());
        Assert.assertEquals((Object)ventvalveType, (Object)item_.isVentvalveType());
        Assert.assertEquals((Object)waterCooling, (Object)item_.isWaterCooling());
    }

    @Test
    public void sendReceiveVacuum_CryoVacGauge_CryoConfigurationEvent() throws Exception {
        String version = "d";
        int busAddr = 223;
        String devcId = "z";
        double[] relayTrip = TestHelper.generateDoubleArray((int)3, (int)-1930422326);
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoVacGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacGauge_CryoConfigurationEvent));
        Vacuum_CryoVacGauge_CryoConfigurationEvent item_ = (Vacuum_CryoVacGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertArrayEquals((double[])relayTrip, (double[])item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoVacGauge_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoVacGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacGauge_DevicesConfigurationEvent));
        Vacuum_CryoVacGauge_DevicesConfigurationEvent item_ = (Vacuum_CryoVacGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Cryo_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double airpressure_warnHi = 0.3495739698410034;
        double airpressure_warnLo = 0.7331953048706055;
        double airpressure_limitHi = 0.44190144538879395;
        double airpressure_limitLo = 0.8249333500862122;
        double cryovac_warnHi = 0.3438388705253601;
        double cryovac_warnLo = 0.6647447347640991;
        double cryovac_limitHi = 0.09924596548080444;
        double cryovac_limitLo = 0.388649046421051;
        double flinepower_warnHi = 0.192366361618042;
        double flinepower_limitHi = 0.3791356682777405;
        double forelinevac_warnHi = 0.6766318678855896;
        double forelinevac_warnLo = 0.4565402865409851;
        double forelinevac_limitHi = 0.5763600468635559;
        double forelinevac_limitLo = 0.8063295483589172;
        double gaugedose_warnHi = 0.20522820949554443;
        double gaugedose_warnLo = 0.04169929027557373;
        double gaugedose_limitHi = 0.5060730576515198;
        double gaugedose_limitLo = 0.4233966f;
        double pumpcartpressure_warnHi = 0.02714228630065918;
        double pumpcartpressure_warnLo = 0.20204466581344604;
        double pumpcartpressure_limitHi = 0.4414917230606079;
        double pumpcartpressure_limitLo = 0.8437589406967163;
        double turbogaugedose_warnHi = 0.8764467239379883;
        double turbogaugedose_warnLo = 0.4024495482444763;
        double turbogaugedose_limitHi = 0.42289382219314575;
        double turbogaugedose_limitLo = 0.9662340879440308;
        double turbohours_warnHi = 0.11944049596786499;
        double turbohours_warnLo = 0.7138491868972778;
        double turbohours_limitHi = 0.15329605340957642;
        double turbohours_limitLo = 0.3902401328086853;
        double turbopower_warnHi = 0.1239391f;
        double turbopower_limitHi = 0.8015385270118713;
        double turbopumpstatus_warnHi = 0.03770667314529419;
        double turbopumpstatus_limitHi = 0.2436668872833252;
        double turbopumptemp_warnHi = 0.35733717679977417;
        double turbopumptemp_warnLo = 0.6375284790992737;
        double turbopumptemp_limitHi = 0.9946182370185852;
        double turbopumptemp_limitLo = 0.3443509340286255;
        double turbospeed_warnHi = 0.8494451642036438;
        double turbospeed_warnLo = 0.7361348271369934;
        double turbospeed_limitHi = 0.4846060276031494;
        double turbospeed_limitLo = 0.9953231811523438;
        double turbovac_warnHi = 0.08402401208877563;
        double turbovac_warnLo = 0.3612545132637024;
        double turbovac_limitHi = 0.6111468076705933;
        double turbovac_limitLo = 0.046657443046569824;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cryo_LimitsConfigurationEvent(version, airpressure_warnHi, airpressure_warnLo, airpressure_limitHi, airpressure_limitLo, cryovac_warnHi, cryovac_warnLo, cryovac_limitHi, cryovac_limitLo, flinepower_warnHi, flinepower_limitHi, forelinevac_warnHi, forelinevac_warnLo, forelinevac_limitHi, forelinevac_limitLo, gaugedose_warnHi, gaugedose_warnLo, gaugedose_limitHi, gaugedose_limitLo, pumpcartpressure_warnHi, pumpcartpressure_warnLo, pumpcartpressure_limitHi, pumpcartpressure_limitLo, turbogaugedose_warnHi, turbogaugedose_warnLo, turbogaugedose_limitHi, turbogaugedose_limitLo, turbohours_warnHi, turbohours_warnLo, turbohours_limitHi, turbohours_limitLo, turbopower_warnHi, turbopower_limitHi, turbopumpstatus_warnHi, turbopumpstatus_limitHi, turbopumptemp_warnHi, turbopumptemp_warnLo, turbopumptemp_limitHi, turbopumptemp_limitLo, turbospeed_warnHi, turbospeed_warnLo, turbospeed_limitHi, turbospeed_limitLo, turbovac_warnHi, turbovac_warnLo, turbovac_limitHi, turbovac_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cryo_LimitsConfigurationEvent));
        Vacuum_Cryo_LimitsConfigurationEvent item_ = (Vacuum_Cryo_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)airpressure_warnHi, (double)item_.getAirpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_warnLo, (double)item_.getAirpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_limitHi, (double)item_.getAirpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_limitLo, (double)item_.getAirpressure_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryovac_warnHi, (double)item_.getCryovac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryovac_warnLo, (double)item_.getCryovac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryovac_limitHi, (double)item_.getCryovac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryovac_limitLo, (double)item_.getCryovac_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_warnHi, (double)item_.getFlinepower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_limitHi, (double)item_.getFlinepower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_warnHi, (double)item_.getForelinevac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_warnLo, (double)item_.getForelinevac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_limitHi, (double)item_.getForelinevac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_limitLo, (double)item_.getForelinevac_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_warnHi, (double)item_.getGaugedose_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_warnLo, (double)item_.getGaugedose_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_limitHi, (double)item_.getGaugedose_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_limitLo, (double)item_.getGaugedose_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnHi, (double)item_.getPumpcartpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnLo, (double)item_.getPumpcartpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitHi, (double)item_.getPumpcartpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitLo, (double)item_.getPumpcartpressure_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_warnHi, (double)item_.getTurbogaugedose_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_warnLo, (double)item_.getTurbogaugedose_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_limitHi, (double)item_.getTurbogaugedose_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_limitLo, (double)item_.getTurbogaugedose_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_warnHi, (double)item_.getTurbohours_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_warnLo, (double)item_.getTurbohours_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_limitHi, (double)item_.getTurbohours_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_limitLo, (double)item_.getTurbohours_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopower_warnHi, (double)item_.getTurbopower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopower_limitHi, (double)item_.getTurbopower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumpstatus_warnHi, (double)item_.getTurbopumpstatus_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumpstatus_limitHi, (double)item_.getTurbopumpstatus_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_warnHi, (double)item_.getTurbopumptemp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_warnLo, (double)item_.getTurbopumptemp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_limitHi, (double)item_.getTurbopumptemp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_limitLo, (double)item_.getTurbopumptemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_warnHi, (double)item_.getTurbospeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_warnLo, (double)item_.getTurbospeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_limitHi, (double)item_.getTurbospeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_limitLo, (double)item_.getTurbospeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_warnHi, (double)item_.getTurbovac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_warnLo, (double)item_.getTurbovac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_limitHi, (double)item_.getTurbovac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_limitLo, (double)item_.getTurbovac_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HX_LimitsConfigurationEvent() throws Exception {
        String version = "q";
        double airpressure_warnHi = 0.4423891305923462;
        double airpressure_warnLo = 0.8195973038673401;
        double airpressure_limitHi = 0.8911446928977966;
        double airpressure_limitLo = 0.9449220299720764;
        double flinepower_warnHi = 0.3727429509162903;
        double flinepower_limitHi = 0.3365599f;
        double forelinevac_warnHi = 0.2162773609161377;
        double forelinevac_warnLo = 0.08686792850494385;
        double forelinevac_limitHi = 0.5236115455627441;
        double forelinevac_limitLo = 0.11660957336425781;
        double gaugedose_warnHi = 0.6386212110519409;
        double gaugedose_warnLo = 0.5465096235275269;
        double gaugedose_limitHi = 0.8977733850479126;
        double gaugedose_limitLo = 0.7412078380584717;
        double hexvac_warnHi = 0.33134692907333374;
        double hexvac_warnLo = 0.14201372861862183;
        double hexvac_limitHi = 0.4168702960014343;
        double hexvac_limitLo = 0.9587225317955017;
        double pumpcartpressure_warnHi = 0.8275997042655945;
        double pumpcartpressure_warnLo = 0.7852810621261597;
        double pumpcartpressure_limitHi = 0.6418435573577881;
        double pumpcartpressure_limitLo = 0.3457095f;
        double turbogaugedose_warnHi = 0.5672187209129333;
        double turbogaugedose_warnLo = 0.45319098234176636;
        double turbogaugedose_limitHi = 0.09826427698135376;
        double turbogaugedose_limitLo = 0.37387335300445557;
        double turbohours_warnHi = 0.3292325735092163;
        double turbohours_warnLo = 0.2597543001174927;
        double turbohours_limitHi = 0.7892430424690247;
        double turbohours_limitLo = 0.11749368906021118;
        double turbopower_warnHi = 0.9075458645820618;
        double turbopower_limitHi = 0.839673f;
        double turbopumpstatus_warnHi = 0.905518651008606;
        double turbopumpstatus_limitHi = 0.07874f;
        double turbopumptemp_warnHi = 0.1136139f;
        double turbopumptemp_warnLo = 0.8729338049888611;
        double turbopumptemp_limitHi = 0.5535796880722046;
        double turbopumptemp_limitLo = 0.587564f;
        double turbospeed_warnHi = 0.17806684970855713;
        double turbospeed_warnLo = 0.32693952322006226;
        double turbospeed_limitHi = 0.7770497798919678;
        double turbospeed_limitLo = 0.6567665934562683;
        double turbovac_warnHi = 0.5460378527641296;
        double turbovac_warnLo = 0.7081224322319031;
        double turbovac_limitHi = 0.3934918f;
        double turbovac_limitLo = 0.8275190591812134;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HX_LimitsConfigurationEvent(version, airpressure_warnHi, airpressure_warnLo, airpressure_limitHi, airpressure_limitLo, flinepower_warnHi, flinepower_limitHi, forelinevac_warnHi, forelinevac_warnLo, forelinevac_limitHi, forelinevac_limitLo, gaugedose_warnHi, gaugedose_warnLo, gaugedose_limitHi, gaugedose_limitLo, hexvac_warnHi, hexvac_warnLo, hexvac_limitHi, hexvac_limitLo, pumpcartpressure_warnHi, pumpcartpressure_warnLo, pumpcartpressure_limitHi, pumpcartpressure_limitLo, turbogaugedose_warnHi, turbogaugedose_warnLo, turbogaugedose_limitHi, turbogaugedose_limitLo, turbohours_warnHi, turbohours_warnLo, turbohours_limitHi, turbohours_limitLo, turbopower_warnHi, turbopower_limitHi, turbopumpstatus_warnHi, turbopumpstatus_limitHi, turbopumptemp_warnHi, turbopumptemp_warnLo, turbopumptemp_limitHi, turbopumptemp_limitLo, turbospeed_warnHi, turbospeed_warnLo, turbospeed_limitHi, turbospeed_limitLo, turbovac_warnHi, turbovac_warnLo, turbovac_limitHi, turbovac_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HX_LimitsConfigurationEvent));
        Vacuum_HX_LimitsConfigurationEvent item_ = (Vacuum_HX_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)airpressure_warnHi, (double)item_.getAirpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_warnLo, (double)item_.getAirpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_limitHi, (double)item_.getAirpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_limitLo, (double)item_.getAirpressure_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_warnHi, (double)item_.getFlinepower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_limitHi, (double)item_.getFlinepower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_warnHi, (double)item_.getForelinevac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_warnLo, (double)item_.getForelinevac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_limitHi, (double)item_.getForelinevac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_limitLo, (double)item_.getForelinevac_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_warnHi, (double)item_.getGaugedose_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_warnLo, (double)item_.getGaugedose_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_limitHi, (double)item_.getGaugedose_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_limitLo, (double)item_.getGaugedose_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexvac_warnHi, (double)item_.getHexvac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexvac_warnLo, (double)item_.getHexvac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexvac_limitHi, (double)item_.getHexvac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexvac_limitLo, (double)item_.getHexvac_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnHi, (double)item_.getPumpcartpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnLo, (double)item_.getPumpcartpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitHi, (double)item_.getPumpcartpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitLo, (double)item_.getPumpcartpressure_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_warnHi, (double)item_.getTurbogaugedose_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_warnLo, (double)item_.getTurbogaugedose_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_limitHi, (double)item_.getTurbogaugedose_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_limitLo, (double)item_.getTurbogaugedose_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_warnHi, (double)item_.getTurbohours_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_warnLo, (double)item_.getTurbohours_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_limitHi, (double)item_.getTurbohours_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_limitLo, (double)item_.getTurbohours_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopower_warnHi, (double)item_.getTurbopower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopower_limitHi, (double)item_.getTurbopower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumpstatus_warnHi, (double)item_.getTurbopumpstatus_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumpstatus_limitHi, (double)item_.getTurbopumpstatus_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_warnHi, (double)item_.getTurbopumptemp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_warnLo, (double)item_.getTurbopumptemp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_limitHi, (double)item_.getTurbopumptemp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_limitLo, (double)item_.getTurbopumptemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_warnHi, (double)item_.getTurbospeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_warnLo, (double)item_.getTurbospeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_limitHi, (double)item_.getTurbospeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_limitLo, (double)item_.getTurbospeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_warnHi, (double)item_.getTurbovac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_warnLo, (double)item_.getTurbovac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_limitHi, (double)item_.getTurbovac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_limitLo, (double)item_.getTurbovac_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HexFlineGauge_CryoConfigurationEvent() throws Exception {
        String version = "";
        int busAddr = 335;
        String devcId = "";
        double[] relayTrip = TestHelper.generateDoubleArray((int)3, (int)-1974257828);
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexFlineGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexFlineGauge_CryoConfigurationEvent));
        Vacuum_HexFlineGauge_CryoConfigurationEvent item_ = (Vacuum_HexFlineGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertArrayEquals((double[])relayTrip, (double[])item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HexFlineGauge_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexFlineGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexFlineGauge_DevicesConfigurationEvent));
        Vacuum_HexFlineGauge_DevicesConfigurationEvent item_ = (Vacuum_HexFlineGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_HexTurboGauge_CryoConfigurationEvent() throws Exception {
        String version = "q";
        int busAddr = 336;
        String devcId = "g";
        double[] relayTrip = TestHelper.generateDoubleArray((int)3, (int)-314160468);
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexTurboGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexTurboGauge_CryoConfigurationEvent));
        Vacuum_HexTurboGauge_CryoConfigurationEvent item_ = (Vacuum_HexTurboGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertArrayEquals((double[])relayTrip, (double[])item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HexTurboGauge_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexTurboGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexTurboGauge_DevicesConfigurationEvent));
        Vacuum_HexTurboGauge_DevicesConfigurationEvent item_ = (Vacuum_HexTurboGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_HexTurboPump_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexTurboPump_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexTurboPump_DevicesConfigurationEvent));
        Vacuum_HexTurboPump_DevicesConfigurationEvent item_ = (Vacuum_HexTurboPump_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_HexTurboPump_GeneralConfigurationEvent() throws Exception {
        String version = "b";
        boolean activeStopMode = false;
        int analogOutput = 686;
        int baudRate = 258;
        String devcId = "s";
        int extFanConfig = 544;
        int gasType = 161;
        boolean gasTypeArgon = false;
        boolean interlockType = false;
        boolean lowSpeedMode = true;
        int maxpower = 878;
        int rotfreqLow = 92;
        int rotfreqMax = 398;
        int rotfreqSet = 752;
        boolean setpointActive = false;
        int setpointDelay = 640;
        int setpointHyst = 638;
        int setpointThresh = 857;
        int setpointType = 966;
        boolean softStartMode = false;
        boolean speedReadActivate = true;
        int ventDelay = 375;
        int ventOpentime = 165;
        boolean ventvalveByCmnd = true;
        boolean ventvalveType = true;
        boolean waterCooling = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexTurboPump_GeneralConfigurationEvent(version, activeStopMode, analogOutput, baudRate, devcId, extFanConfig, gasType, gasTypeArgon, interlockType, lowSpeedMode, maxpower, rotfreqLow, rotfreqMax, rotfreqSet, setpointActive, setpointDelay, setpointHyst, setpointThresh, setpointType, softStartMode, speedReadActivate, ventDelay, ventOpentime, ventvalveByCmnd, ventvalveType, waterCooling));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexTurboPump_GeneralConfigurationEvent));
        Vacuum_HexTurboPump_GeneralConfigurationEvent item_ = (Vacuum_HexTurboPump_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)activeStopMode, (Object)item_.isActiveStopMode());
        Assert.assertEquals((long)analogOutput, (long)item_.getAnalogOutput());
        Assert.assertEquals((long)baudRate, (long)item_.getBaudRate());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((long)extFanConfig, (long)item_.getExtFanConfig());
        Assert.assertEquals((long)gasType, (long)item_.getGasType());
        Assert.assertEquals((Object)gasTypeArgon, (Object)item_.isGasTypeArgon());
        Assert.assertEquals((Object)interlockType, (Object)item_.isInterlockType());
        Assert.assertEquals((Object)lowSpeedMode, (Object)item_.isLowSpeedMode());
        Assert.assertEquals((long)maxpower, (long)item_.getMaxpower());
        Assert.assertEquals((long)rotfreqLow, (long)item_.getRotfreqLow());
        Assert.assertEquals((long)rotfreqMax, (long)item_.getRotfreqMax());
        Assert.assertEquals((long)rotfreqSet, (long)item_.getRotfreqSet());
        Assert.assertEquals((Object)setpointActive, (Object)item_.isSetpointActive());
        Assert.assertEquals((long)setpointDelay, (long)item_.getSetpointDelay());
        Assert.assertEquals((long)setpointHyst, (long)item_.getSetpointHyst());
        Assert.assertEquals((long)setpointThresh, (long)item_.getSetpointThresh());
        Assert.assertEquals((long)setpointType, (long)item_.getSetpointType());
        Assert.assertEquals((Object)softStartMode, (Object)item_.isSoftStartMode());
        Assert.assertEquals((Object)speedReadActivate, (Object)item_.isSpeedReadActivate());
        Assert.assertEquals((long)ventDelay, (long)item_.getVentDelay());
        Assert.assertEquals((long)ventOpentime, (long)item_.getVentOpentime());
        Assert.assertEquals((Object)ventvalveByCmnd, (Object)item_.isVentvalveByCmnd());
        Assert.assertEquals((Object)ventvalveType, (Object)item_.isVentvalveType());
        Assert.assertEquals((Object)waterCooling, (Object)item_.isWaterCooling());
    }

    @Test
    public void sendReceiveVacuum_HexVacGauge_CryoConfigurationEvent() throws Exception {
        String version = "n";
        int busAddr = 650;
        String devcId = "w";
        double[] relayTrip = TestHelper.generateDoubleArray((int)3, (int)-1305319526);
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexVacGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexVacGauge_CryoConfigurationEvent));
        Vacuum_HexVacGauge_CryoConfigurationEvent item_ = (Vacuum_HexVacGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertArrayEquals((double[])relayTrip, (double[])item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HexVacGauge_DevicesConfigurationEvent() throws Exception {
        String version = "u";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexVacGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexVacGauge_DevicesConfigurationEvent));
        Vacuum_HexVacGauge_DevicesConfigurationEvent item_ = (Vacuum_HexVacGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Hip_LimitsConfigurationEvent() throws Exception {
        String version = "t";
        double[] hx_I_warnHi = TestHelper.generateDoubleArray((int)2, (int)-1422249684);
        double[] hx_I_warnLo = TestHelper.generateDoubleArray((int)2, (int)429953905);
        double[] hx_I_limitHi = TestHelper.generateDoubleArray((int)2, (int)-891183175);
        double[] hx_I_limitLo = TestHelper.generateDoubleArray((int)2, (int)1075619163);
        double[] hx_Life_warnHi = TestHelper.generateDoubleArray((int)2, (int)1479149962);
        double[] hx_Life_warnLo = TestHelper.generateDoubleArray((int)2, (int)1387441292);
        double[] hx_Life_limitHi = TestHelper.generateDoubleArray((int)2, (int)1318045753);
        double[] hx_Life_limitLo = TestHelper.generateDoubleArray((int)2, (int)-894140219);
        double[] hx_Usage_warnHi = TestHelper.generateDoubleArray((int)2, (int)56702987);
        double[] hx_Usage_warnLo = TestHelper.generateDoubleArray((int)2, (int)1473588603);
        double[] hx_Usage_limitHi = TestHelper.generateDoubleArray((int)2, (int)-342221297);
        double[] hx_Usage_limitLo = TestHelper.generateDoubleArray((int)2, (int)-1541119050);
        double[] hx_V_warnHi = TestHelper.generateDoubleArray((int)2, (int)-47608301);
        double[] hx_V_warnLo = TestHelper.generateDoubleArray((int)2, (int)2029972228);
        double[] hx_V_limitHi = TestHelper.generateDoubleArray((int)2, (int)1321526337);
        double[] hx_V_limitLo = TestHelper.generateDoubleArray((int)2, (int)2010295737);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Hip_LimitsConfigurationEvent(version, hx_I_warnHi, hx_I_warnLo, hx_I_limitHi, hx_I_limitLo, hx_Life_warnHi, hx_Life_warnLo, hx_Life_limitHi, hx_Life_limitLo, hx_Usage_warnHi, hx_Usage_warnLo, hx_Usage_limitHi, hx_Usage_limitLo, hx_V_warnHi, hx_V_warnLo, hx_V_limitHi, hx_V_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hip_LimitsConfigurationEvent));
        Vacuum_Hip_LimitsConfigurationEvent item_ = (Vacuum_Hip_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])hx_I_warnHi, (double[])item_.getHx_I_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_I_warnLo, (double[])item_.getHx_I_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_I_limitHi, (double[])item_.getHx_I_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_I_limitLo, (double[])item_.getHx_I_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life_warnHi, (double[])item_.getHx_Life_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life_warnLo, (double[])item_.getHx_Life_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life_limitHi, (double[])item_.getHx_Life_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life_limitLo, (double[])item_.getHx_Life_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage_warnHi, (double[])item_.getHx_Usage_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage_warnLo, (double[])item_.getHx_Usage_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage_limitHi, (double[])item_.getHx_Usage_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage_limitLo, (double[])item_.getHx_Usage_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V_warnHi, (double[])item_.getHx_V_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V_warnLo, (double[])item_.getHx_V_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V_limitHi, (double[])item_.getHx_V_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V_limitLo, (double[])item_.getHx_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_InstVacGauge_CryoConfigurationEvent() throws Exception {
        String version = "o";
        int busAddr = 245;
        String devcId = "d";
        double[] relayTrip = TestHelper.generateDoubleArray((int)3, (int)-863450962);
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_InstVacGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_InstVacGauge_CryoConfigurationEvent));
        Vacuum_InstVacGauge_CryoConfigurationEvent item_ = (Vacuum_InstVacGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertArrayEquals((double[])relayTrip, (double[])item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_InstVacGauge_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_InstVacGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_InstVacGauge_DevicesConfigurationEvent));
        Vacuum_InstVacGauge_DevicesConfigurationEvent item_ = (Vacuum_InstVacGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Inst_LimitsConfigurationEvent() throws Exception {
        String version = "o";
        double cryoflinevalvestate_warnHi = 0.12413114309310913;
        double cryoflinevalvestate_warnLo = 0.5145398378372192;
        double cryoflinevalvestate_limitHi = 0.6842864155769348;
        double cryoflinevalvestate_limitLo = 0.16013747453689575;
        double flinepower_warnHi = 0.7154470682144165;
        double flinepower_limitHi = 0.24681884050369263;
        double hxflinevalvestate_warnHi = 3.97861E-4f;
        double hxflinevalvestate_warnLo = 0.4978829026222229;
        double hxflinevalvestate_limitHi = 0.016645967960357666;
        double hxflinevalvestate_limitLo = 0.9987613558769226;
        double instvac_warnHi = 0.24865102767944336;
        double instvac_warnLo = 0.44293713569641113;
        double instvac_limitHi = 0.71945720911026;
        double instvac_limitLo = 0.1985260248184204;
        double pumpcartcycling_warnHi = 0.16791987419128418;
        double pumpcartcycling_warnLo = 0.03862518072128296;
        double pumpcartcycling_limitHi = 0.07557564973831177;
        double pumpcartcycling_limitLo = 0.26327353715896606;
        double pumpcartpressure_warnHi = 0.5822992920875549;
        double pumpcartpressure_warnLo = 0.7447644472122192;
        double pumpcartpressure_limitHi = 0.44467437267303467;
        double pumpcartpressure_limitLo = 0.525576114654541;
        double pumpcarttemperature_warnHi = 0.43829184770584106;
        double pumpcarttemperature_warnLo = 0.9741195440292358;
        double pumpcarttemperature_limitHi = 0.7157511115074158;
        double pumpcarttemperature_limitLo = 0.5872114896774292;
        double pumpcartventing_warnHi = 0.12102806568145752;
        double pumpcartventing_warnLo = 0.5752629637718201;
        double pumpcartventing_limitHi = 0.9463352560997009;
        double pumpcartventing_limitLo = 0.5632772445678711;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Inst_LimitsConfigurationEvent(version, cryoflinevalvestate_warnHi, cryoflinevalvestate_warnLo, cryoflinevalvestate_limitHi, cryoflinevalvestate_limitLo, flinepower_warnHi, flinepower_limitHi, hxflinevalvestate_warnHi, hxflinevalvestate_warnLo, hxflinevalvestate_limitHi, hxflinevalvestate_limitLo, instvac_warnHi, instvac_warnLo, instvac_limitHi, instvac_limitLo, pumpcartcycling_warnHi, pumpcartcycling_warnLo, pumpcartcycling_limitHi, pumpcartcycling_limitLo, pumpcartpressure_warnHi, pumpcartpressure_warnLo, pumpcartpressure_limitHi, pumpcartpressure_limitLo, pumpcarttemperature_warnHi, pumpcarttemperature_warnLo, pumpcarttemperature_limitHi, pumpcarttemperature_limitLo, pumpcartventing_warnHi, pumpcartventing_warnLo, pumpcartventing_limitHi, pumpcartventing_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Inst_LimitsConfigurationEvent));
        Vacuum_Inst_LimitsConfigurationEvent item_ = (Vacuum_Inst_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cryoflinevalvestate_warnHi, (double)item_.getCryoflinevalvestate_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoflinevalvestate_warnLo, (double)item_.getCryoflinevalvestate_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoflinevalvestate_limitHi, (double)item_.getCryoflinevalvestate_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoflinevalvestate_limitLo, (double)item_.getCryoflinevalvestate_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_warnHi, (double)item_.getFlinepower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_limitHi, (double)item_.getFlinepower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hxflinevalvestate_warnHi, (double)item_.getHxflinevalvestate_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hxflinevalvestate_warnLo, (double)item_.getHxflinevalvestate_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hxflinevalvestate_limitHi, (double)item_.getHxflinevalvestate_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hxflinevalvestate_limitLo, (double)item_.getHxflinevalvestate_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)instvac_warnHi, (double)item_.getInstvac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)instvac_warnLo, (double)item_.getInstvac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)instvac_limitHi, (double)item_.getInstvac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)instvac_limitLo, (double)item_.getInstvac_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartcycling_warnHi, (double)item_.getPumpcartcycling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartcycling_warnLo, (double)item_.getPumpcartcycling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartcycling_limitHi, (double)item_.getPumpcartcycling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartcycling_limitLo, (double)item_.getPumpcartcycling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnHi, (double)item_.getPumpcartpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnLo, (double)item_.getPumpcartpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitHi, (double)item_.getPumpcartpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitLo, (double)item_.getPumpcartpressure_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcarttemperature_warnHi, (double)item_.getPumpcarttemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcarttemperature_warnLo, (double)item_.getPumpcarttemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcarttemperature_limitHi, (double)item_.getPumpcarttemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcarttemperature_limitLo, (double)item_.getPumpcarttemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartventing_warnHi, (double)item_.getPumpcartventing_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartventing_warnLo, (double)item_.getPumpcartventing_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartventing_limitHi, (double)item_.getPumpcartventing_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartventing_limitLo, (double)item_.getPumpcartventing_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumps_CryoConfigurationEvent() throws Exception {
        String version = "g";
        double cip1c_current = 0.14919966459274292;
        double cip1c_power = 0.16633951663970947;
        double cip1c_voltage = 0.19426536560058594;
        double cip2c_current = 0.071639f;
        double cip2c_power = 0.1569261f;
        double cip2c_voltage = 0.20998424291610718;
        double cip3c_current = 0.47163963317871094;
        double cip3c_power = 0.5734783411026001;
        double cip3c_voltage = 0.6697577834129333;
        double cip4c_current = 0.0916903018951416;
        double cip4c_power = 0.7053773999214172;
        double cip4c_voltage = 0.5091942548751831;
        double cip5c_current = 0.591046f;
        double cip5c_power = 0.4325159788131714;
        double cip5c_voltage = 0.4223732352256775;
        double cip6c_current = 0.38127797842025757;
        double cip6c_power = 0.36730343103408813;
        double cip6c_voltage = 0.9199444651603699;
        double hip1c_current = 0.7487133145332336;
        double hip1c_power = 0.8005784153938293;
        double hip1c_voltage = 0.4570775032043457;
        double hip2c_current = 0.7127537727355957;
        double hip2c_power = 0.2898542284965515;
        double hip2c_voltage = 0.8685352206230164;
        String ipAddr = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_IonPumps_CryoConfigurationEvent(version, cip1c_current, cip1c_power, cip1c_voltage, cip2c_current, cip2c_power, cip2c_voltage, cip3c_current, cip3c_power, cip3c_voltage, cip4c_current, cip4c_power, cip4c_voltage, cip5c_current, cip5c_power, cip5c_voltage, cip6c_current, cip6c_power, cip6c_voltage, hip1c_current, hip1c_power, hip1c_voltage, hip2c_current, hip2c_power, hip2c_voltage, ipAddr));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumps_CryoConfigurationEvent));
        Vacuum_IonPumps_CryoConfigurationEvent item_ = (Vacuum_IonPumps_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cip1c_current, (double)item_.getCip1c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip1c_power, (double)item_.getCip1c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip1c_voltage, (double)item_.getCip1c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)cip2c_current, (double)item_.getCip2c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip2c_power, (double)item_.getCip2c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip2c_voltage, (double)item_.getCip2c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)cip3c_current, (double)item_.getCip3c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip3c_power, (double)item_.getCip3c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip3c_voltage, (double)item_.getCip3c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)cip4c_current, (double)item_.getCip4c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip4c_power, (double)item_.getCip4c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip4c_voltage, (double)item_.getCip4c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)cip5c_current, (double)item_.getCip5c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip5c_power, (double)item_.getCip5c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip5c_voltage, (double)item_.getCip5c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)cip6c_current, (double)item_.getCip6c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip6c_power, (double)item_.getCip6c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip6c_voltage, (double)item_.getCip6c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)hip1c_current, (double)item_.getHip1c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)hip1c_power, (double)item_.getHip1c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)hip1c_voltage, (double)item_.getHip1c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)hip2c_current, (double)item_.getHip2c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)hip2c_power, (double)item_.getHip2c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)hip2c_voltage, (double)item_.getHip2c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
    }

    @Test
    public void sendReceiveVacuum_IonPumps_DevicesConfigurationEvent() throws Exception {
        String version = "s";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_IonPumps_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumps_DevicesConfigurationEvent));
        Vacuum_IonPumps_DevicesConfigurationEvent item_ = (Vacuum_IonPumps_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Maq20Cryo_DeviceConfigurationEvent() throws Exception {
        String version = "u";
        String node = "";
        String serials = "k";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Maq20Cryo_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Maq20Cryo_DeviceConfigurationEvent));
        Vacuum_Maq20Cryo_DeviceConfigurationEvent item_ = (Vacuum_Maq20Cryo_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveVacuum_Maq20Cryo_DevicesConfigurationEvent() throws Exception {
        String version = "n";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Maq20Cryo_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Maq20Cryo_DevicesConfigurationEvent));
        Vacuum_Maq20Cryo_DevicesConfigurationEvent item_ = (Vacuum_Maq20Cryo_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Maq20Ut_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String node = "l";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Maq20Ut_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Maq20Ut_DeviceConfigurationEvent));
        Vacuum_Maq20Ut_DeviceConfigurationEvent item_ = (Vacuum_Maq20Ut_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveVacuum_Maq20Ut_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Maq20Ut_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Maq20Ut_DevicesConfigurationEvent));
        Vacuum_Maq20Ut_DevicesConfigurationEvent item_ = (Vacuum_Maq20Ut_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_PDU_DevicesConfigurationEvent() throws Exception {
        String version = "z";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PDU_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PDU_DevicesConfigurationEvent));
        Vacuum_PDU_DevicesConfigurationEvent item_ = (Vacuum_PDU_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_PDU_VacuumConfigurationEvent() throws Exception {
        String version = "";
        int node = 242;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PDU_VacuumConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PDU_VacuumConfigurationEvent));
        Vacuum_PDU_VacuumConfigurationEvent item_ = (Vacuum_PDU_VacuumConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveVacuum_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 679;
        int schedulers_default_nThreads = 626;
        int schedulers_monitor_check_scheduler_nTasks = 107;
        int schedulers_monitor_check_scheduler_nThreads = 419;
        int schedulers_monitor_update_publish_scheduler_nTasks = 2;
        int schedulers_monitor_update_publish_scheduler_nThreads = 821;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PeriodicTasks_GeneralConfigurationEvent));
        Vacuum_PeriodicTasks_GeneralConfigurationEvent item_ = (Vacuum_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveVacuum_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "x";
        long agentmonitorservice_taskPeriodMillis = 278L;
        long heartbeat_taskPeriodMillis = 389L;
        long maq20cryo_check_status_taskPeriodMillis = 111L;
        long maq20ut_check_status_taskPeriodMillis = 887L;
        long monitor_check_CryoFlineGauge_taskPeriodMillis = 136L;
        long monitor_check_CryoTurboGauge_taskPeriodMillis = 17L;
        long monitor_check_CryoTurboPump_taskPeriodMillis = 239L;
        long monitor_check_CryoVacGauge_taskPeriodMillis = 138L;
        long monitor_check_HexFlineGauge_taskPeriodMillis = 695L;
        long monitor_check_HexTurboGauge_taskPeriodMillis = 920L;
        long monitor_check_HexTurboPump_taskPeriodMillis = 344L;
        long monitor_check_HexVacGauge_taskPeriodMillis = 207L;
        long monitor_check_InstVacGauge_taskPeriodMillis = 942L;
        long monitor_check_IonPumps_taskPeriodMillis = 115L;
        long monitor_check_Maq20Cryo_taskPeriodMillis = 592L;
        long monitor_check_Maq20Ut_taskPeriodMillis = 820L;
        long monitor_check_PDU_taskPeriodMillis = 958L;
        long monitor_check_PumpCart_taskPeriodMillis = 980L;
        long monitor_check_VacPluto_taskPeriodMillis = 234L;
        long monitor_publish_CryoTurboPump_taskPeriodMillis = 569L;
        long monitor_publish_HexTurboPump_taskPeriodMillis = 436L;
        long monitor_publish_IonPumps_taskPeriodMillis = 90L;
        long monitor_publish_Maq20Cryo_taskPeriodMillis = 881L;
        long monitor_publish_PDU_taskPeriodMillis = 214L;
        long monitor_publish_PumpCart_taskPeriodMillis = 827L;
        long monitor_publish_slowMon_taskPeriodMillis = 74L;
        long monitor_publish_taskPeriodMillis = 811L;
        long monitor_publish_tts0_taskPeriodMillis = 331L;
        long monitor_publish_tts1_taskPeriodMillis = 610L;
        long monitor_update_CryoTurboPump_taskPeriodMillis = 827L;
        long monitor_update_HexTurboPump_taskPeriodMillis = 281L;
        long monitor_update_IonPumps_taskPeriodMillis = 654L;
        long monitor_update_Maq20Cryo_taskPeriodMillis = 422L;
        long monitor_update_PDU_taskPeriodMillis = 294L;
        long monitor_update_PumpCart_taskPeriodMillis = 922L;
        long monitor_update_slowMon_taskPeriodMillis = 964L;
        long monitor_update_taskPeriodMillis = 66L;
        long monitor_update_tts0_taskPeriodMillis = 537L;
        long monitor_update_tts1_taskPeriodMillis = 278L;
        long runtimeinfo_taskPeriodMillis = 631L;
        long vacuum_state_taskPeriodMillis = 514L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, maq20cryo_check_status_taskPeriodMillis, maq20ut_check_status_taskPeriodMillis, monitor_check_CryoFlineGauge_taskPeriodMillis, monitor_check_CryoTurboGauge_taskPeriodMillis, monitor_check_CryoTurboPump_taskPeriodMillis, monitor_check_CryoVacGauge_taskPeriodMillis, monitor_check_HexFlineGauge_taskPeriodMillis, monitor_check_HexTurboGauge_taskPeriodMillis, monitor_check_HexTurboPump_taskPeriodMillis, monitor_check_HexVacGauge_taskPeriodMillis, monitor_check_InstVacGauge_taskPeriodMillis, monitor_check_IonPumps_taskPeriodMillis, monitor_check_Maq20Cryo_taskPeriodMillis, monitor_check_Maq20Ut_taskPeriodMillis, monitor_check_PDU_taskPeriodMillis, monitor_check_PumpCart_taskPeriodMillis, monitor_check_VacPluto_taskPeriodMillis, monitor_publish_CryoTurboPump_taskPeriodMillis, monitor_publish_HexTurboPump_taskPeriodMillis, monitor_publish_IonPumps_taskPeriodMillis, monitor_publish_Maq20Cryo_taskPeriodMillis, monitor_publish_PDU_taskPeriodMillis, monitor_publish_PumpCart_taskPeriodMillis, monitor_publish_slowMon_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_publish_tts0_taskPeriodMillis, monitor_publish_tts1_taskPeriodMillis, monitor_update_CryoTurboPump_taskPeriodMillis, monitor_update_HexTurboPump_taskPeriodMillis, monitor_update_IonPumps_taskPeriodMillis, monitor_update_Maq20Cryo_taskPeriodMillis, monitor_update_PDU_taskPeriodMillis, monitor_update_PumpCart_taskPeriodMillis, monitor_update_slowMon_taskPeriodMillis, monitor_update_taskPeriodMillis, monitor_update_tts0_taskPeriodMillis, monitor_update_tts1_taskPeriodMillis, runtimeinfo_taskPeriodMillis, vacuum_state_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PeriodicTasks_timersConfigurationEvent));
        Vacuum_PeriodicTasks_timersConfigurationEvent item_ = (Vacuum_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)maq20cryo_check_status_taskPeriodMillis, (long)item_.getMaq20cryo_check_status_taskPeriodMillis());
        Assert.assertEquals((long)maq20ut_check_status_taskPeriodMillis, (long)item_.getMaq20ut_check_status_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_CryoFlineGauge_taskPeriodMillis, (long)item_.getMonitor_check_CryoFlineGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_CryoTurboGauge_taskPeriodMillis, (long)item_.getMonitor_check_CryoTurboGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_CryoTurboPump_taskPeriodMillis, (long)item_.getMonitor_check_CryoTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_CryoVacGauge_taskPeriodMillis, (long)item_.getMonitor_check_CryoVacGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_HexFlineGauge_taskPeriodMillis, (long)item_.getMonitor_check_HexFlineGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_HexTurboGauge_taskPeriodMillis, (long)item_.getMonitor_check_HexTurboGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_HexTurboPump_taskPeriodMillis, (long)item_.getMonitor_check_HexTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_HexVacGauge_taskPeriodMillis, (long)item_.getMonitor_check_HexVacGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_InstVacGauge_taskPeriodMillis, (long)item_.getMonitor_check_InstVacGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_IonPumps_taskPeriodMillis, (long)item_.getMonitor_check_IonPumps_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Maq20Cryo_taskPeriodMillis, (long)item_.getMonitor_check_Maq20Cryo_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Maq20Ut_taskPeriodMillis, (long)item_.getMonitor_check_Maq20Ut_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PDU_taskPeriodMillis, (long)item_.getMonitor_check_PDU_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PumpCart_taskPeriodMillis, (long)item_.getMonitor_check_PumpCart_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_VacPluto_taskPeriodMillis, (long)item_.getMonitor_check_VacPluto_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_CryoTurboPump_taskPeriodMillis, (long)item_.getMonitor_publish_CryoTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_HexTurboPump_taskPeriodMillis, (long)item_.getMonitor_publish_HexTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_IonPumps_taskPeriodMillis, (long)item_.getMonitor_publish_IonPumps_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Maq20Cryo_taskPeriodMillis, (long)item_.getMonitor_publish_Maq20Cryo_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PDU_taskPeriodMillis, (long)item_.getMonitor_publish_PDU_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PumpCart_taskPeriodMillis, (long)item_.getMonitor_publish_PumpCart_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_slowMon_taskPeriodMillis, (long)item_.getMonitor_publish_slowMon_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_tts0_taskPeriodMillis, (long)item_.getMonitor_publish_tts0_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_tts1_taskPeriodMillis, (long)item_.getMonitor_publish_tts1_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_CryoTurboPump_taskPeriodMillis, (long)item_.getMonitor_update_CryoTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_HexTurboPump_taskPeriodMillis, (long)item_.getMonitor_update_HexTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_IonPumps_taskPeriodMillis, (long)item_.getMonitor_update_IonPumps_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Maq20Cryo_taskPeriodMillis, (long)item_.getMonitor_update_Maq20Cryo_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PDU_taskPeriodMillis, (long)item_.getMonitor_update_PDU_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PumpCart_taskPeriodMillis, (long)item_.getMonitor_update_PumpCart_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_slowMon_taskPeriodMillis, (long)item_.getMonitor_update_slowMon_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_tts0_taskPeriodMillis, (long)item_.getMonitor_update_tts0_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_tts1_taskPeriodMillis, (long)item_.getMonitor_update_tts1_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)vacuum_state_taskPeriodMillis, (long)item_.getVacuum_state_taskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_PumpCart_CryoConfigurationEvent() throws Exception {
        String version = "a";
        String devcId = "";
        double maxVentPressure = 0.15658771991729736;
        double minPumpPressure = 0.20130383968353271;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PumpCart_CryoConfigurationEvent(version, devcId, maxVentPressure, minPumpPressure));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PumpCart_CryoConfigurationEvent));
        Vacuum_PumpCart_CryoConfigurationEvent item_ = (Vacuum_PumpCart_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((double)maxVentPressure, (double)item_.getMaxVentPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)minPumpPressure, (double)item_.getMinPumpPressure(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_PumpCart_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PumpCart_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PumpCart_DevicesConfigurationEvent));
        Vacuum_PumpCart_DevicesConfigurationEvent item_ = (Vacuum_PumpCart_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_VacPluto_DeviceConfigurationEvent() throws Exception {
        String version = "c";
        String node = "v";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacPluto_DeviceConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacPluto_DeviceConfigurationEvent));
        Vacuum_VacPluto_DeviceConfigurationEvent item_ = (Vacuum_VacPluto_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
    }

    @Test
    public void sendReceiveVacuum_VacPluto_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacPluto_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacPluto_DevicesConfigurationEvent));
        Vacuum_VacPluto_DevicesConfigurationEvent item_ = (Vacuum_VacPluto_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_VacuumConfigurationEvent() throws Exception {
        String version = "";
        double cryoPScale = 0.2256726f;
        double cryoPdiffFloor = 0.6835756301879883;
        double delayCCOff = 0.4971230626106262;
        double hxPScale = 0.46246641874313354;
        double hxPdiffFloor = 0.37017685174942017;
        double pChangeStateUpdate = 0.18240207433700562;
        double pFLChangeStateUpdate = 0.1282173991203308;
        double pPCChangeStateUpdate = 0.775881290435791;
        double pcPdiffFloor = 0.7670015096664429;
        double pcPdiffScaleFactor = 0.8115732073783875;
        double pressCCEnable = 0.9582842588424683;
        double pressCCOff = 0.728636f;
        double pressDiffHighMin = 0.19857323169708252;
        double pressDiffLow = 0.4796156883239746;
        double pressForelineLow = 0.25690704584121704;
        double pressIonEnable = 0.5727071166038513;
        double pressIonOff = 0.8387136459350586;
        double pressRefrigOk = 0.10003447532653809;
        double pressTurboLow = 0.02270621f;
        double pressVacuum = 0.18902206420898438;
        double speedFractTurboLow = 0.3390364f;
        long tranTimeCryoGate = 352L;
        long tranTimeHxGate = 498L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacuumConfigurationEvent(version, cryoPScale, cryoPdiffFloor, delayCCOff, hxPScale, hxPdiffFloor, pChangeStateUpdate, pFLChangeStateUpdate, pPCChangeStateUpdate, pcPdiffFloor, pcPdiffScaleFactor, pressCCEnable, pressCCOff, pressDiffHighMin, pressDiffLow, pressForelineLow, pressIonEnable, pressIonOff, pressRefrigOk, pressTurboLow, pressVacuum, speedFractTurboLow, tranTimeCryoGate, tranTimeHxGate));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacuumConfigurationEvent));
        Vacuum_VacuumConfigurationEvent item_ = (Vacuum_VacuumConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cryoPScale, (double)item_.getCryoPScale(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoPdiffFloor, (double)item_.getCryoPdiffFloor(), (double)1.0E-6f);
        Assert.assertEquals((double)delayCCOff, (double)item_.getDelayCCOff(), (double)1.0E-6f);
        Assert.assertEquals((double)hxPScale, (double)item_.getHxPScale(), (double)1.0E-6f);
        Assert.assertEquals((double)hxPdiffFloor, (double)item_.getHxPdiffFloor(), (double)1.0E-6f);
        Assert.assertEquals((double)pChangeStateUpdate, (double)item_.getPChangeStateUpdate(), (double)1.0E-6f);
        Assert.assertEquals((double)pFLChangeStateUpdate, (double)item_.getPFLChangeStateUpdate(), (double)1.0E-6f);
        Assert.assertEquals((double)pPCChangeStateUpdate, (double)item_.getPPCChangeStateUpdate(), (double)1.0E-6f);
        Assert.assertEquals((double)pcPdiffFloor, (double)item_.getPcPdiffFloor(), (double)1.0E-6f);
        Assert.assertEquals((double)pcPdiffScaleFactor, (double)item_.getPcPdiffScaleFactor(), (double)1.0E-6f);
        Assert.assertEquals((double)pressCCEnable, (double)item_.getPressCCEnable(), (double)1.0E-6f);
        Assert.assertEquals((double)pressCCOff, (double)item_.getPressCCOff(), (double)1.0E-6f);
        Assert.assertEquals((double)pressDiffHighMin, (double)item_.getPressDiffHighMin(), (double)1.0E-6f);
        Assert.assertEquals((double)pressDiffLow, (double)item_.getPressDiffLow(), (double)1.0E-6f);
        Assert.assertEquals((double)pressForelineLow, (double)item_.getPressForelineLow(), (double)1.0E-6f);
        Assert.assertEquals((double)pressIonEnable, (double)item_.getPressIonEnable(), (double)1.0E-6f);
        Assert.assertEquals((double)pressIonOff, (double)item_.getPressIonOff(), (double)1.0E-6f);
        Assert.assertEquals((double)pressRefrigOk, (double)item_.getPressRefrigOk(), (double)1.0E-6f);
        Assert.assertEquals((double)pressTurboLow, (double)item_.getPressTurboLow(), (double)1.0E-6f);
        Assert.assertEquals((double)pressVacuum, (double)item_.getPressVacuum(), (double)1.0E-6f);
        Assert.assertEquals((double)speedFractTurboLow, (double)item_.getSpeedFractTurboLow(), (double)1.0E-6f);
        Assert.assertEquals((long)tranTimeCryoGate, (long)item_.getTranTimeCryoGate());
        Assert.assertEquals((long)tranTimeHxGate, (long)item_.getTranTimeHxGate());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 41;
        int schedulers_default_nThreads = 7;
        int schedulers_monitor_update_publish_scheduler_nTasks = 295;
        int schedulers_monitor_update_publish_scheduler_nThreads = 109;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_GeneralConfigurationEvent));
        Daq_monitor_PeriodicTasks_GeneralConfigurationEvent item_ = (Daq_monitor_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "l";
        long agentmonitorservice_taskPeriodMillis = 334L;
        long heartbeat_taskPeriodMillis = 135L;
        long monitor_check_taskPeriodMillis = 421L;
        long monitor_publish_taskPeriodMillis = 766L;
        long monitor_update_taskPeriodMillis = 256L;
        long publishstats_taskPeriodMillis = 474L;
        long purgedaq_taskPeriodMillis = 814L;
        long runtimeinfo_taskPeriodMillis = 187L;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, publishstats_taskPeriodMillis, purgedaq_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_timersConfigurationEvent));
        Daq_monitor_PeriodicTasks_timersConfigurationEvent item_ = (Daq_monitor_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)publishstats_taskPeriodMillis, (long)item_.getPublishstats_taskPeriodMillis());
        Assert.assertEquals((long)purgedaq_taskPeriodMillis, (long)item_.getPurgedaq_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_StatisticsConfigurationEvent() throws Exception {
        String version = "u";
        int minDiffAlertWarning = 857;
        int minDiffLogWarning = 203;
        String sumDriverChecks = "z";
        String sumDriverStats = "";
        String sumFirmwareChecks = "t";
        String sumFirmwareStats = "r";
        String sumRdsChecks = "f";
        String sumRdsStats = "";
        String sumRmsChecks = "";
        String sumRmsStats = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_StatisticsConfigurationEvent(version, minDiffAlertWarning, minDiffLogWarning, sumDriverChecks, sumDriverStats, sumFirmwareChecks, sumFirmwareStats, sumRdsChecks, sumRdsStats, sumRmsChecks, sumRmsStats));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_StatisticsConfigurationEvent));
        Daq_monitor_Stats_StatisticsConfigurationEvent item_ = (Daq_monitor_Stats_StatisticsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)minDiffAlertWarning, (long)item_.getMinDiffAlertWarning());
        Assert.assertEquals((long)minDiffLogWarning, (long)item_.getMinDiffLogWarning());
        Assert.assertEquals((Object)sumDriverChecks, (Object)item_.getSumDriverChecks());
        Assert.assertEquals((Object)sumDriverStats, (Object)item_.getSumDriverStats());
        Assert.assertEquals((Object)sumFirmwareChecks, (Object)item_.getSumFirmwareChecks());
        Assert.assertEquals((Object)sumFirmwareStats, (Object)item_.getSumFirmwareStats());
        Assert.assertEquals((Object)sumRdsChecks, (Object)item_.getSumRdsChecks());
        Assert.assertEquals((Object)sumRdsStats, (Object)item_.getSumRdsStats());
        Assert.assertEquals((Object)sumRmsChecks, (Object)item_.getSumRmsChecks());
        Assert.assertEquals((Object)sumRmsStats, (Object)item_.getSumRmsStats());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreConfigurationEvent() throws Exception {
        String version = "";
        int alarmPurgeFailures = 861;
        String daqPartition = "s";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StoreConfigurationEvent(version, alarmPurgeFailures, daqPartition));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreConfigurationEvent));
        Daq_monitor_StoreConfigurationEvent item_ = (Daq_monitor_StoreConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)alarmPurgeFailures, (long)item_.getAlarmPurgeFailures());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_DevicesConfigurationEvent() throws Exception {
        String version = "e";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_DevicesConfigurationEvent));
        Daq_monitor_Store_DevicesConfigurationEvent item_ = (Daq_monitor_Store_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_LimitsConfigurationEvent() throws Exception {
        String version = "x";
        double freefraction_warnLo = 0.5156503915786743;
        double freefraction_limitLo = 0.6420605778694153;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_LimitsConfigurationEvent(version, freefraction_warnLo, freefraction_limitLo));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_LimitsConfigurationEvent));
        Daq_monitor_Store_LimitsConfigurationEvent item_ = (Daq_monitor_Store_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)freefraction_warnLo, (double)item_.getFreefraction_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitLo, (double)item_.getFreefraction_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Store_StoreConfigurationEvent() throws Exception {
        String version = "d";
        String daqFolder = "v";
        boolean enableAutoPurge = false;
        double purgeTarget = 0.047164082527160645;
        double purgeThreshold = 0.07853960990905762;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_StoreConfigurationEvent(version, daqFolder, enableAutoPurge, purgeTarget, purgeThreshold));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_StoreConfigurationEvent));
        Daq_monitor_Store_StoreConfigurationEvent item_ = (Daq_monitor_Store_StoreConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)enableAutoPurge, (Object)item_.isEnableAutoPurge());
        Assert.assertEquals((double)purgeTarget, (double)item_.getPurgeTarget(), (double)1.0E-6f);
        Assert.assertEquals((double)purgeThreshold, (double)item_.getPurgeThreshold(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_HardwareIdConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        String manSerNum = "";
        String name = "x";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_HardwareIdConfigurationEvent(version, location, manSerNum, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_HardwareIdConfigurationEvent));
        Focal_plane_Ccd_HardwareIdConfigurationEvent item_ = (Focal_plane_Ccd_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)manSerNum, (Object)item_.getManSerNum());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_LimitsConfigurationEvent() throws Exception {
        String version = "i";
        double[] gdv_warnHi = TestHelper.generateDoubleArray((int)201, (int)-2046484407);
        double[] gdv_warnLo = TestHelper.generateDoubleArray((int)201, (int)1674794956);
        double[] gdv_limitHi = TestHelper.generateDoubleArray((int)201, (int)1162635661);
        double[] gdv_limitLo = TestHelper.generateDoubleArray((int)201, (int)381272171);
        String location = "";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)201, (int)-1224151692);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)201, (int)-648725835);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)201, (int)1784038807);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)201, (int)884064738);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)201, (int)1278412372);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)201, (int)-577209992);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)201, (int)262869804);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)201, (int)1793337504);
        double[] ogv_warnHi = TestHelper.generateDoubleArray((int)201, (int)-703860519);
        double[] ogv_warnLo = TestHelper.generateDoubleArray((int)201, (int)-1676767081);
        double[] ogv_limitHi = TestHelper.generateDoubleArray((int)201, (int)-1210187630);
        double[] ogv_limitLo = TestHelper.generateDoubleArray((int)201, (int)-871873572);
        double[] rdv_warnHi = TestHelper.generateDoubleArray((int)201, (int)-2082831703);
        double[] rdv_warnLo = TestHelper.generateDoubleArray((int)201, (int)-198985073);
        double[] rdv_limitHi = TestHelper.generateDoubleArray((int)201, (int)104377596);
        double[] rdv_limitLo = TestHelper.generateDoubleArray((int)201, (int)-307729942);
        double[] temp_warnHi = TestHelper.generateDoubleArray((int)201, (int)2035845400);
        double[] temp_warnLo = TestHelper.generateDoubleArray((int)201, (int)-1278338309);
        double[] temp_limitHi = TestHelper.generateDoubleArray((int)201, (int)2039555838);
        double[] temp_limitLo = TestHelper.generateDoubleArray((int)201, (int)1330822405);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_LimitsConfigurationEvent(version, gdv_warnHi, gdv_warnLo, gdv_limitHi, gdv_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, ogv_warnHi, ogv_warnLo, ogv_limitHi, ogv_limitLo, rdv_warnHi, rdv_warnLo, rdv_limitHi, rdv_limitLo, temp_warnHi, temp_warnLo, temp_limitHi, temp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_LimitsConfigurationEvent));
        Focal_plane_Ccd_LimitsConfigurationEvent item_ = (Focal_plane_Ccd_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])gdv_warnHi, (double[])item_.getGdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_warnLo, (double[])item_.getGdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitHi, (double[])item_.getGdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitLo, (double[])item_.getGdv_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnHi, (double[])item_.getOgv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnLo, (double[])item_.getOgv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitHi, (double[])item_.getOgv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitLo, (double[])item_.getOgv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnHi, (double[])item_.getRdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnLo, (double[])item_.getRdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitHi, (double[])item_.getRdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitLo, (double[])item_.getRdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnHi, (double[])item_.getTemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnLo, (double[])item_.getTemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitHi, (double[])item_.getTemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitLo, (double[])item_.getTemp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_ImageDatabaseService_GeneralConfigurationEvent() throws Exception {
        String version = "f";
        String dbURL = "";
        boolean enabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageDatabaseService_GeneralConfigurationEvent(version, dbURL, enabled));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageDatabaseService_GeneralConfigurationEvent));
        Focal_plane_ImageDatabaseService_GeneralConfigurationEvent item_ = (Focal_plane_ImageDatabaseService_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)enabled, (Object)item_.isEnabled());
    }

    @Test
    public void sendReceiveFocal_plane_ImageNameService_GeneralConfigurationEvent() throws Exception {
        String version = "";
        String controller = "";
        String dbURL = "s";
        String offset = "";
        String source = "";
        String timeZoneId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageNameService_GeneralConfigurationEvent(version, controller, dbURL, offset, source, timeZoneId));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageNameService_GeneralConfigurationEvent));
        Focal_plane_ImageNameService_GeneralConfigurationEvent item_ = (Focal_plane_ImageNameService_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)controller, (Object)item_.getController());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)offset, (Object)item_.getOffset());
        Assert.assertEquals((Object)source, (Object)item_.getSource());
        Assert.assertEquals((Object)timeZoneId, (Object)item_.getTimeZoneId());
    }

    @Test
    public void sendReceiveFocal_plane_InstrumentConfig_InstrumentConfigurationEvent() throws Exception {
        String version = "";
        String instrument = "";
        String telescope = "";
        String testStand = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_InstrumentConfig_InstrumentConfigurationEvent(version, instrument, telescope, testStand));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_InstrumentConfig_InstrumentConfigurationEvent));
        Focal_plane_InstrumentConfig_InstrumentConfigurationEvent item_ = (Focal_plane_InstrumentConfig_InstrumentConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)instrument, (Object)item_.getInstrument());
        Assert.assertEquals((Object)telescope, (Object)item_.getTelescope());
        Assert.assertEquals((Object)testStand, (Object)item_.getTestStand());
    }

    @Test
    public void sendReceiveFocal_plane_MonitoringConfig_MonitoringConfigurationEvent() throws Exception {
        String version = "";
        String postReadoutTriggerTasks = "";
        String readoutPauseTasks = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_MonitoringConfig_MonitoringConfigurationEvent(version, postReadoutTriggerTasks, readoutPauseTasks));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_MonitoringConfig_MonitoringConfigurationEvent));
        Focal_plane_MonitoringConfig_MonitoringConfigurationEvent item_ = (Focal_plane_MonitoringConfig_MonitoringConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)postReadoutTriggerTasks, (Object)item_.getPostReadoutTriggerTasks());
        Assert.assertEquals((Object)readoutPauseTasks, (Object)item_.getReadoutPauseTasks());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "z";
        int schedulers_default_nTasks = 508;
        int schedulers_default_nThreads = 277;
        int schedulers_monitor_check_scheduler_nTasks = 817;
        int schedulers_monitor_check_scheduler_nThreads = 800;
        int schedulers_monitor_update_publish_scheduler_nTasks = 340;
        int schedulers_monitor_update_publish_scheduler_nThreads = 986;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_GeneralConfigurationEvent));
        Focal_plane_PeriodicTasks_GeneralConfigurationEvent item_ = (Focal_plane_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 66L;
        long heartbeat_taskPeriodMillis = 517L;
        long monitor_publish_taskPeriodMillis = 498L;
        long monitor_update_taskPeriodMillis = 202L;
        long runtimeinfo_taskPeriodMillis = 586L;
        long tempcontrol_R00_taskPeriodMillis = 528L;
        long tempcontrol_R01_taskPeriodMillis = 454L;
        long tempcontrol_R02_taskPeriodMillis = 804L;
        long tempcontrol_R03_taskPeriodMillis = 894L;
        long tempcontrol_R04_taskPeriodMillis = 897L;
        long tempcontrol_R10_taskPeriodMillis = 279L;
        long tempcontrol_R11_taskPeriodMillis = 675L;
        long tempcontrol_R12_taskPeriodMillis = 802L;
        long tempcontrol_R13_taskPeriodMillis = 891L;
        long tempcontrol_R14_taskPeriodMillis = 293L;
        long tempcontrol_R20_taskPeriodMillis = 141L;
        long tempcontrol_R21_taskPeriodMillis = 797L;
        long tempcontrol_R22_taskPeriodMillis = 825L;
        long tempcontrol_R23_taskPeriodMillis = 654L;
        long tempcontrol_R24_taskPeriodMillis = 343L;
        long tempcontrol_R30_taskPeriodMillis = 442L;
        long tempcontrol_R31_taskPeriodMillis = 398L;
        long tempcontrol_R32_taskPeriodMillis = 187L;
        long tempcontrol_R33_taskPeriodMillis = 2L;
        long tempcontrol_R34_taskPeriodMillis = 859L;
        long tempcontrol_R40_taskPeriodMillis = 906L;
        long tempcontrol_R41_taskPeriodMillis = 790L;
        long tempcontrol_R42_taskPeriodMillis = 994L;
        long tempcontrol_R43_taskPeriodMillis = 567L;
        long tempcontrol_R44_taskPeriodMillis = 218L;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, tempcontrol_R00_taskPeriodMillis, tempcontrol_R01_taskPeriodMillis, tempcontrol_R02_taskPeriodMillis, tempcontrol_R03_taskPeriodMillis, tempcontrol_R04_taskPeriodMillis, tempcontrol_R10_taskPeriodMillis, tempcontrol_R11_taskPeriodMillis, tempcontrol_R12_taskPeriodMillis, tempcontrol_R13_taskPeriodMillis, tempcontrol_R14_taskPeriodMillis, tempcontrol_R20_taskPeriodMillis, tempcontrol_R21_taskPeriodMillis, tempcontrol_R22_taskPeriodMillis, tempcontrol_R23_taskPeriodMillis, tempcontrol_R24_taskPeriodMillis, tempcontrol_R30_taskPeriodMillis, tempcontrol_R31_taskPeriodMillis, tempcontrol_R32_taskPeriodMillis, tempcontrol_R33_taskPeriodMillis, tempcontrol_R34_taskPeriodMillis, tempcontrol_R40_taskPeriodMillis, tempcontrol_R41_taskPeriodMillis, tempcontrol_R42_taskPeriodMillis, tempcontrol_R43_taskPeriodMillis, tempcontrol_R44_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_timersConfigurationEvent));
        Focal_plane_PeriodicTasks_timersConfigurationEvent item_ = (Focal_plane_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R00_taskPeriodMillis, (long)item_.getTempcontrol_R00_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R01_taskPeriodMillis, (long)item_.getTempcontrol_R01_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R02_taskPeriodMillis, (long)item_.getTempcontrol_R02_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R03_taskPeriodMillis, (long)item_.getTempcontrol_R03_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R04_taskPeriodMillis, (long)item_.getTempcontrol_R04_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R10_taskPeriodMillis, (long)item_.getTempcontrol_R10_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R11_taskPeriodMillis, (long)item_.getTempcontrol_R11_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R12_taskPeriodMillis, (long)item_.getTempcontrol_R12_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R13_taskPeriodMillis, (long)item_.getTempcontrol_R13_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R14_taskPeriodMillis, (long)item_.getTempcontrol_R14_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R20_taskPeriodMillis, (long)item_.getTempcontrol_R20_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R21_taskPeriodMillis, (long)item_.getTempcontrol_R21_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R22_taskPeriodMillis, (long)item_.getTempcontrol_R22_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R23_taskPeriodMillis, (long)item_.getTempcontrol_R23_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R24_taskPeriodMillis, (long)item_.getTempcontrol_R24_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R30_taskPeriodMillis, (long)item_.getTempcontrol_R30_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R31_taskPeriodMillis, (long)item_.getTempcontrol_R31_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R32_taskPeriodMillis, (long)item_.getTempcontrol_R32_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R33_taskPeriodMillis, (long)item_.getTempcontrol_R33_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R34_taskPeriodMillis, (long)item_.getTempcontrol_R34_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R40_taskPeriodMillis, (long)item_.getTempcontrol_R40_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R41_taskPeriodMillis, (long)item_.getTempcontrol_R41_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R42_taskPeriodMillis, (long)item_.getTempcontrol_R42_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R43_taskPeriodMillis, (long)item_.getTempcontrol_R43_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R44_taskPeriodMillis, (long)item_.getTempcontrol_R44_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_HardwareIdConfigurationEvent() throws Exception {
        String version = "y";
        String location = "h";
        String name = "y";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_HardwareIdConfigurationEvent(version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_HardwareIdConfigurationEvent));
        Focal_plane_Raft_HardwareIdConfigurationEvent item_ = (Focal_plane_Raft_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlConfigurationEvent() throws Exception {
        String version = "";
        String location = "o";
        double[] tempcontrol_basePower = TestHelper.generateDoubleArray((int)25, (int)-173864319);
        double[] tempcontrol_coefD = TestHelper.generateDoubleArray((int)25, (int)-402289837);
        double[] tempcontrol_coefI = TestHelper.generateDoubleArray((int)25, (int)1886526166);
        double[] tempcontrol_coefP = TestHelper.generateDoubleArray((int)25, (int)-1949141845);
        double[] tempcontrol_maxInput = TestHelper.generateDoubleArray((int)25, (int)-120131558);
        double[] tempcontrol_maxOutput = TestHelper.generateDoubleArray((int)25, (int)-1303269382);
        double[] tempcontrol_minInput = TestHelper.generateDoubleArray((int)25, (int)-1581721368);
        double[] tempcontrol_minOutput = TestHelper.generateDoubleArray((int)25, (int)49973773);
        String tempcontrol_rebs = "";
        double[] tempcontrol_setTemp = TestHelper.generateDoubleArray((int)25, (int)-74814473);
        double[] tempcontrol_smoothTime = TestHelper.generateDoubleArray((int)25, (int)918359194);
        String tempcontrol_tempChans = "g";
        double[] tempcontrol_timeConst = TestHelper.generateDoubleArray((int)25, (int)1254314993);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlConfigurationEvent(version, location, tempcontrol_basePower, tempcontrol_coefD, tempcontrol_coefI, tempcontrol_coefP, tempcontrol_maxInput, tempcontrol_maxOutput, tempcontrol_minInput, tempcontrol_minOutput, tempcontrol_rebs, tempcontrol_setTemp, tempcontrol_smoothTime, tempcontrol_tempChans, tempcontrol_timeConst));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlConfigurationEvent));
        Focal_plane_Raft_RaftTempControlConfigurationEvent item_ = (Focal_plane_Raft_RaftTempControlConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])tempcontrol_basePower, (double[])item_.getTempcontrol_basePower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefD, (double[])item_.getTempcontrol_coefD(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefI, (double[])item_.getTempcontrol_coefI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefP, (double[])item_.getTempcontrol_coefP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxInput, (double[])item_.getTempcontrol_maxInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxOutput, (double[])item_.getTempcontrol_maxOutput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minInput, (double[])item_.getTempcontrol_minInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minOutput, (double[])item_.getTempcontrol_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_rebs, (Object)item_.getTempcontrol_rebs());
        Assert.assertArrayEquals((double[])tempcontrol_setTemp, (double[])item_.getTempcontrol_setTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_smoothTime, (double[])item_.getTempcontrol_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_tempChans, (Object)item_.getTempcontrol_tempChans());
        Assert.assertArrayEquals((double[])tempcontrol_timeConst, (double[])item_.getTempcontrol_timeConst(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlStatusConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        boolean[] tempcontrol_active = new boolean[]{true, false, false, true, false, false, false, true, true, true, false, false, false, true, false, false, false, true, true, true, false, false, false, false, true};
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlStatusConfigurationEvent(version, location, tempcontrol_active));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlStatusConfigurationEvent));
        Focal_plane_Raft_RaftTempControlStatusConfigurationEvent item_ = (Focal_plane_Raft_RaftTempControlStatusConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((boolean[])tempcontrol_active, (boolean[])item_.getTempcontrol_active());
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPower_LimitsConfigurationEvent() throws Exception {
        String version = "m";
        double warnHi = 0.6570948958396912;
        double warnLo = 0.040240466594696045;
        double limitHi = 0.07590585947036743;
        double limitLo = 0.5725908875465393;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebTotalPower_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPower_LimitsConfigurationEvent));
        Focal_plane_RebTotalPower_LimitsConfigurationEvent item_ = (Focal_plane_RebTotalPower_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean[] disabled = new boolean[]{true, false, false, false, false, true, true, true, true, false, true, false, false, true, false, true, false, true, true, false, false, true, true, true, true, true, false, true, true, true, false, false, false, true, false, true, true, true, true, false, false, false, true, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, true, true, true, false, false};
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_DevicesConfigurationEvent(version, disabled, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_DevicesConfigurationEvent));
        Focal_plane_Reb_DevicesConfigurationEvent item_ = (Focal_plane_Reb_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((boolean[])disabled, (boolean[])item_.getDisabled());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_GeneralConfigurationEvent() throws Exception {
        String version = "p";
        String location = "i";
        String tempavg_temperatureNames = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_GeneralConfigurationEvent(version, location, tempavg_temperatureNames));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_GeneralConfigurationEvent));
        Focal_plane_Reb_GeneralConfigurationEvent item_ = (Focal_plane_Reb_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)tempavg_temperatureNames, (Object)item_.getTempavg_temperatureNames());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_HardwareIdConfigurationEvent() throws Exception {
        String version = "";
        String location = "s";
        String name = "j";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_HardwareIdConfigurationEvent(version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_HardwareIdConfigurationEvent));
        Focal_plane_Reb_HardwareIdConfigurationEvent item_ = (Focal_plane_Reb_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double[] anai_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1268841353);
        double[] anai_warnLo = TestHelper.generateDoubleArray((int)71, (int)880393939);
        double[] anai_limitHi = TestHelper.generateDoubleArray((int)71, (int)34920083);
        double[] anai_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1200798902);
        double[] anav_warnHi = TestHelper.generateDoubleArray((int)71, (int)724108399);
        double[] anav_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2002967109);
        double[] anav_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1819041484);
        double[] anav_limitLo = TestHelper.generateDoubleArray((int)71, (int)1371938517);
        double[] aspicl_Temp0_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1493923365);
        double[] aspicl_Temp0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-252282763);
        double[] aspicl_Temp0_limitHi = TestHelper.generateDoubleArray((int)71, (int)1680672856);
        double[] aspicl_Temp0_limitLo = TestHelper.generateDoubleArray((int)71, (int)1855738507);
        double[] aspicl_Temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-935368107);
        double[] aspicl_Temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)719119042);
        double[] aspicl_Temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-758962071);
        double[] aspicl_Temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)92663199);
        double[] aspicl_Temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1756559124);
        double[] aspicl_Temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-731903682);
        double[] aspicl_Temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1222786603);
        double[] aspicl_Temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)2146634971);
        double[] aspicu_Temp0_warnHi = TestHelper.generateDoubleArray((int)71, (int)1477513035);
        double[] aspicu_Temp0_warnLo = TestHelper.generateDoubleArray((int)71, (int)1858024884);
        double[] aspicu_Temp0_limitHi = TestHelper.generateDoubleArray((int)71, (int)904630476);
        double[] aspicu_Temp0_limitLo = TestHelper.generateDoubleArray((int)71, (int)340414747);
        double[] aspicu_Temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)1168774426);
        double[] aspicu_Temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)1815508141);
        double[] aspicu_Temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2045059768);
        double[] aspicu_Temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1716401921);
        double[] aspicu_Temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-892020317);
        double[] aspicu_Temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)436697162);
        double[] aspicu_Temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2049145011);
        double[] aspicu_Temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-32488997);
        double[] clkhi_warnHi = TestHelper.generateDoubleArray((int)71, (int)673641400);
        double[] clkhi_warnLo = TestHelper.generateDoubleArray((int)71, (int)-5417901);
        double[] clkhi_limitHi = TestHelper.generateDoubleArray((int)71, (int)2031424369);
        double[] clkhi_limitLo = TestHelper.generateDoubleArray((int)71, (int)-283233294);
        double[] clkhv_warnHi = TestHelper.generateDoubleArray((int)71, (int)2087328724);
        double[] clkhv_warnLo = TestHelper.generateDoubleArray((int)71, (int)59205519);
        double[] clkhv_limitHi = TestHelper.generateDoubleArray((int)71, (int)624130975);
        double[] clkhv_limitLo = TestHelper.generateDoubleArray((int)71, (int)555531748);
        double[] clkli_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1386253184);
        double[] clkli_warnLo = TestHelper.generateDoubleArray((int)71, (int)1832453717);
        double[] clkli_limitHi = TestHelper.generateDoubleArray((int)71, (int)1604175895);
        double[] clkli_limitLo = TestHelper.generateDoubleArray((int)71, (int)205284196);
        double[] clklv_warnHi = TestHelper.generateDoubleArray((int)71, (int)1103394040);
        double[] clklv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1413432733);
        double[] clklv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-127945544);
        double[] clklv_limitLo = TestHelper.generateDoubleArray((int)71, (int)337937197);
        double[] digi_warnHi = TestHelper.generateDoubleArray((int)71, (int)1055480334);
        double[] digi_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1574753299);
        double[] digi_limitHi = TestHelper.generateDoubleArray((int)71, (int)583526017);
        double[] digi_limitLo = TestHelper.generateDoubleArray((int)71, (int)514308150);
        double[] digv_warnHi = TestHelper.generateDoubleArray((int)71, (int)381894989);
        double[] digv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2035087367);
        double[] digv_limitHi = TestHelper.generateDoubleArray((int)71, (int)1298429269);
        double[] digv_limitLo = TestHelper.generateDoubleArray((int)71, (int)1723898404);
        double[] hvbiasswitch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1788718496);
        double[] hvbiasswitch_warnLo = TestHelper.generateDoubleArray((int)71, (int)130054121);
        double[] hvbiasswitch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-90714626);
        double[] hvbiasswitch_limitLo = TestHelper.generateDoubleArray((int)71, (int)1253413119);
        double[] htrpi_warnHi = TestHelper.generateDoubleArray((int)71, (int)408328885);
        double[] htrpi_warnLo = TestHelper.generateDoubleArray((int)71, (int)839908953);
        double[] htrpi_limitHi = TestHelper.generateDoubleArray((int)71, (int)386609267);
        double[] htrpi_limitLo = TestHelper.generateDoubleArray((int)71, (int)1459204136);
        double[] htrpv_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1508606115);
        double[] htrpv_warnLo = TestHelper.generateDoubleArray((int)71, (int)1528941866);
        double[] htrpv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2083238307);
        double[] htrpv_limitLo = TestHelper.generateDoubleArray((int)71, (int)2118896778);
        double[] htrv_warnHi = TestHelper.generateDoubleArray((int)71, (int)1360259381);
        double[] htrv_warnLo = TestHelper.generateDoubleArray((int)71, (int)1078978783);
        double[] htrv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-747123241);
        double[] htrv_limitLo = TestHelper.generateDoubleArray((int)71, (int)1509179920);
        double[] htrw_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1334603958);
        double[] htrw_warnLo = TestHelper.generateDoubleArray((int)71, (int)1700441383);
        double[] htrw_limitHi = TestHelper.generateDoubleArray((int)71, (int)1531622517);
        double[] htrw_limitLo = TestHelper.generateDoubleArray((int)71, (int)907353174);
        String location = "t";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1034879352);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)71, (int)1292342946);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1208720042);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)71, (int)-206113176);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1277696353);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-721606891);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-260776113);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1763167890);
        double[] pclk0_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1561419441);
        double[] pclk0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1010202339);
        double[] pclk0_limitHi = TestHelper.generateDoubleArray((int)71, (int)83972624);
        double[] pclk0_limitLo = TestHelper.generateDoubleArray((int)71, (int)1081733899);
        double[] pclk1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-188182217);
        double[] pclk1_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2128708819);
        double[] pclk1_limitHi = TestHelper.generateDoubleArray((int)71, (int)1530450471);
        double[] pclk1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-78163118);
        double[] pclkl_warnHi = TestHelper.generateDoubleArray((int)71, (int)255866686);
        double[] pclkl_warnLo = TestHelper.generateDoubleArray((int)71, (int)785982384);
        double[] pclkl_limitHi = TestHelper.generateDoubleArray((int)71, (int)504159211);
        double[] pclkl_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1241467071);
        double[] pclku_warnHi = TestHelper.generateDoubleArray((int)71, (int)-832412898);
        double[] pclku_warnLo = TestHelper.generateDoubleArray((int)71, (int)-192130758);
        double[] pclku_limitHi = TestHelper.generateDoubleArray((int)71, (int)-448962150);
        double[] pclku_limitLo = TestHelper.generateDoubleArray((int)71, (int)1212296723);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1403164634);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2039346688);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)71, (int)134551489);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1755197486);
        double[] rg0_warnHi = TestHelper.generateDoubleArray((int)71, (int)1520982587);
        double[] rg0_warnLo = TestHelper.generateDoubleArray((int)71, (int)1403133578);
        double[] rg0_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1475107872);
        double[] rg0_limitLo = TestHelper.generateDoubleArray((int)71, (int)1069347119);
        double[] rg1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-705521889);
        double[] rg1_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1156402266);
        double[] rg1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2086039219);
        double[] rg1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1562099563);
        double[] rgl_warnHi = TestHelper.generateDoubleArray((int)71, (int)-794025995);
        double[] rgl_warnLo = TestHelper.generateDoubleArray((int)71, (int)-440207457);
        double[] rgl_limitHi = TestHelper.generateDoubleArray((int)71, (int)1552167000);
        double[] rgl_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1850466181);
        double[] rgu_warnHi = TestHelper.generateDoubleArray((int)71, (int)503023364);
        double[] rgu_warnLo = TestHelper.generateDoubleArray((int)71, (int)1841264303);
        double[] rgu_limitHi = TestHelper.generateDoubleArray((int)71, (int)1803928495);
        double[] rgu_limitLo = TestHelper.generateDoubleArray((int)71, (int)870830841);
        double[] rtdtemp_warnHi = TestHelper.generateDoubleArray((int)71, (int)150894011);
        double[] rtdtemp_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2135768399);
        double[] rtdtemp_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1058496508);
        double[] rtdtemp_limitLo = TestHelper.generateDoubleArray((int)71, (int)1333480094);
        double[] ref05v_warnHi = TestHelper.generateDoubleArray((int)71, (int)-159510796);
        double[] ref05v_warnLo = TestHelper.generateDoubleArray((int)71, (int)1487692314);
        double[] ref05v_limitHi = TestHelper.generateDoubleArray((int)71, (int)1284645356);
        double[] ref05v_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1021791104);
        double[] ref125v_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1844399748);
        double[] ref125v_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1846330839);
        double[] ref125v_limitHi = TestHelper.generateDoubleArray((int)71, (int)1946459658);
        double[] ref125v_limitLo = TestHelper.generateDoubleArray((int)71, (int)1426853779);
        double[] ref15v_warnHi = TestHelper.generateDoubleArray((int)71, (int)523689683);
        double[] ref15v_warnLo = TestHelper.generateDoubleArray((int)71, (int)1616373853);
        double[] ref15v_limitHi = TestHelper.generateDoubleArray((int)71, (int)-776097940);
        double[] ref15v_limitLo = TestHelper.generateDoubleArray((int)71, (int)-452434626);
        double[] ref25v_warnHi = TestHelper.generateDoubleArray((int)71, (int)1536772655);
        double[] ref25v_warnLo = TestHelper.generateDoubleArray((int)71, (int)-187777241);
        double[] ref25v_limitHi = TestHelper.generateDoubleArray((int)71, (int)-557807564);
        double[] ref25v_limitLo = TestHelper.generateDoubleArray((int)71, (int)1873770283);
        double[] refn12_warnHi = TestHelper.generateDoubleArray((int)71, (int)-43363386);
        double[] refn12_warnLo = TestHelper.generateDoubleArray((int)71, (int)2086689249);
        double[] refn12_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1595791238);
        double[] refn12_limitLo = TestHelper.generateDoubleArray((int)71, (int)277214814);
        double[] refp12_warnHi = TestHelper.generateDoubleArray((int)71, (int)273511501);
        double[] refp12_warnLo = TestHelper.generateDoubleArray((int)71, (int)788200446);
        double[] refp12_limitHi = TestHelper.generateDoubleArray((int)71, (int)-244867215);
        double[] refp12_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2029283447);
        double[] sclk0_warnHi = TestHelper.generateDoubleArray((int)71, (int)-666149701);
        double[] sclk0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2036453503);
        double[] sclk0_limitHi = TestHelper.generateDoubleArray((int)71, (int)-706430264);
        double[] sclk0_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2024826723);
        double[] sclk1_warnHi = TestHelper.generateDoubleArray((int)71, (int)226610770);
        double[] sclk1_warnLo = TestHelper.generateDoubleArray((int)71, (int)1090344627);
        double[] sclk1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1421096878);
        double[] sclk1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-221279324);
        double[] sclkl_warnHi = TestHelper.generateDoubleArray((int)71, (int)279604959);
        double[] sclkl_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2041764593);
        double[] sclkl_limitHi = TestHelper.generateDoubleArray((int)71, (int)1594183144);
        double[] sclkl_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1258849587);
        double[] sclku_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2004607681);
        double[] sclku_warnLo = TestHelper.generateDoubleArray((int)71, (int)-222612607);
        double[] sclku_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1645159538);
        double[] sclku_limitLo = TestHelper.generateDoubleArray((int)71, (int)1954003400);
        double[] temp10_warnHi = TestHelper.generateDoubleArray((int)71, (int)-824276443);
        double[] temp10_warnLo = TestHelper.generateDoubleArray((int)71, (int)1011753935);
        double[] temp10_limitHi = TestHelper.generateDoubleArray((int)71, (int)463363028);
        double[] temp10_limitLo = TestHelper.generateDoubleArray((int)71, (int)957741140);
        double[] temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-641722085);
        double[] temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)1742735191);
        double[] temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-551451010);
        double[] temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)31746581);
        double[] temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)1310346694);
        double[] temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1932788486);
        double[] temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-992519834);
        double[] temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1692198998);
        double[] temp3_warnHi = TestHelper.generateDoubleArray((int)71, (int)369183085);
        double[] temp3_warnLo = TestHelper.generateDoubleArray((int)71, (int)-754763176);
        double[] temp3_limitHi = TestHelper.generateDoubleArray((int)71, (int)663731105);
        double[] temp3_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1430475521);
        double[] temp4_warnHi = TestHelper.generateDoubleArray((int)71, (int)-526443333);
        double[] temp4_warnLo = TestHelper.generateDoubleArray((int)71, (int)-506661827);
        double[] temp4_limitHi = TestHelper.generateDoubleArray((int)71, (int)1443606241);
        double[] temp4_limitLo = TestHelper.generateDoubleArray((int)71, (int)1469143262);
        double[] temp5_warnHi = TestHelper.generateDoubleArray((int)71, (int)375648708);
        double[] temp5_warnLo = TestHelper.generateDoubleArray((int)71, (int)1371003482);
        double[] temp5_limitHi = TestHelper.generateDoubleArray((int)71, (int)769831705);
        double[] temp5_limitLo = TestHelper.generateDoubleArray((int)71, (int)1742180812);
        double[] temp6_warnHi = TestHelper.generateDoubleArray((int)71, (int)75518533);
        double[] temp6_warnLo = TestHelper.generateDoubleArray((int)71, (int)-914679241);
        double[] temp6_limitHi = TestHelper.generateDoubleArray((int)71, (int)-521650074);
        double[] temp6_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1895574510);
        double[] temp7_warnHi = TestHelper.generateDoubleArray((int)71, (int)-809038289);
        double[] temp7_warnLo = TestHelper.generateDoubleArray((int)71, (int)1458576744);
        double[] temp7_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1470858451);
        double[] temp7_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1859801831);
        double[] temp8_warnHi = TestHelper.generateDoubleArray((int)71, (int)1692960358);
        double[] temp8_warnLo = TestHelper.generateDoubleArray((int)71, (int)-500336898);
        double[] temp8_limitHi = TestHelper.generateDoubleArray((int)71, (int)2004977280);
        double[] temp8_limitLo = TestHelper.generateDoubleArray((int)71, (int)565815291);
        double[] temp9_warnHi = TestHelper.generateDoubleArray((int)71, (int)1657888709);
        double[] temp9_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1939950528);
        double[] temp9_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1052698427);
        double[] temp9_limitLo = TestHelper.generateDoubleArray((int)71, (int)198504277);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_LimitsConfigurationEvent(version, anai_warnHi, anai_warnLo, anai_limitHi, anai_limitLo, anav_warnHi, anav_warnLo, anav_limitHi, anav_limitLo, aspicl_Temp0_warnHi, aspicl_Temp0_warnLo, aspicl_Temp0_limitHi, aspicl_Temp0_limitLo, aspicl_Temp1_warnHi, aspicl_Temp1_warnLo, aspicl_Temp1_limitHi, aspicl_Temp1_limitLo, aspicl_Temp2_warnHi, aspicl_Temp2_warnLo, aspicl_Temp2_limitHi, aspicl_Temp2_limitLo, aspicu_Temp0_warnHi, aspicu_Temp0_warnLo, aspicu_Temp0_limitHi, aspicu_Temp0_limitLo, aspicu_Temp1_warnHi, aspicu_Temp1_warnLo, aspicu_Temp1_limitHi, aspicu_Temp1_limitLo, aspicu_Temp2_warnHi, aspicu_Temp2_warnLo, aspicu_Temp2_limitHi, aspicu_Temp2_limitLo, clkhi_warnHi, clkhi_warnLo, clkhi_limitHi, clkhi_limitLo, clkhv_warnHi, clkhv_warnLo, clkhv_limitHi, clkhv_limitLo, clkli_warnHi, clkli_warnLo, clkli_limitHi, clkli_limitLo, clklv_warnHi, clklv_warnLo, clklv_limitHi, clklv_limitLo, digi_warnHi, digi_warnLo, digi_limitHi, digi_limitLo, digv_warnHi, digv_warnLo, digv_limitHi, digv_limitLo, hvbiasswitch_warnHi, hvbiasswitch_warnLo, hvbiasswitch_limitHi, hvbiasswitch_limitLo, htrpi_warnHi, htrpi_warnLo, htrpi_limitHi, htrpi_limitLo, htrpv_warnHi, htrpv_warnLo, htrpv_limitHi, htrpv_limitLo, htrv_warnHi, htrv_warnLo, htrv_limitHi, htrv_limitLo, htrw_warnHi, htrw_warnLo, htrw_limitHi, htrw_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, pclk0_warnHi, pclk0_warnLo, pclk0_limitHi, pclk0_limitLo, pclk1_warnHi, pclk1_warnLo, pclk1_limitHi, pclk1_limitLo, pclkl_warnHi, pclkl_warnLo, pclkl_limitHi, pclkl_limitLo, pclku_warnHi, pclku_warnLo, pclku_limitHi, pclku_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rg0_warnHi, rg0_warnLo, rg0_limitHi, rg0_limitLo, rg1_warnHi, rg1_warnLo, rg1_limitHi, rg1_limitLo, rgl_warnHi, rgl_warnLo, rgl_limitHi, rgl_limitLo, rgu_warnHi, rgu_warnLo, rgu_limitHi, rgu_limitLo, rtdtemp_warnHi, rtdtemp_warnLo, rtdtemp_limitHi, rtdtemp_limitLo, ref05v_warnHi, ref05v_warnLo, ref05v_limitHi, ref05v_limitLo, ref125v_warnHi, ref125v_warnLo, ref125v_limitHi, ref125v_limitLo, ref15v_warnHi, ref15v_warnLo, ref15v_limitHi, ref15v_limitLo, ref25v_warnHi, ref25v_warnLo, ref25v_limitHi, ref25v_limitLo, refn12_warnHi, refn12_warnLo, refn12_limitHi, refn12_limitLo, refp12_warnHi, refp12_warnLo, refp12_limitHi, refp12_limitLo, sclk0_warnHi, sclk0_warnLo, sclk0_limitHi, sclk0_limitLo, sclk1_warnHi, sclk1_warnLo, sclk1_limitHi, sclk1_limitLo, sclkl_warnHi, sclkl_warnLo, sclkl_limitHi, sclkl_limitLo, sclku_warnHi, sclku_warnLo, sclku_limitHi, sclku_limitLo, temp10_warnHi, temp10_warnLo, temp10_limitHi, temp10_limitLo, temp1_warnHi, temp1_warnLo, temp1_limitHi, temp1_limitLo, temp2_warnHi, temp2_warnLo, temp2_limitHi, temp2_limitLo, temp3_warnHi, temp3_warnLo, temp3_limitHi, temp3_limitLo, temp4_warnHi, temp4_warnLo, temp4_limitHi, temp4_limitLo, temp5_warnHi, temp5_warnLo, temp5_limitHi, temp5_limitLo, temp6_warnHi, temp6_warnLo, temp6_limitHi, temp6_limitLo, temp7_warnHi, temp7_warnLo, temp7_limitHi, temp7_limitLo, temp8_warnHi, temp8_warnLo, temp8_limitHi, temp8_limitLo, temp9_warnHi, temp9_warnLo, temp9_limitHi, temp9_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_LimitsConfigurationEvent));
        Focal_plane_Reb_LimitsConfigurationEvent item_ = (Focal_plane_Reb_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])anai_warnHi, (double[])item_.getAnai_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_warnLo, (double[])item_.getAnai_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitHi, (double[])item_.getAnai_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitLo, (double[])item_.getAnai_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnHi, (double[])item_.getAnav_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnLo, (double[])item_.getAnav_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitHi, (double[])item_.getAnav_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitLo, (double[])item_.getAnav_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnHi, (double[])item_.getAspicl_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnLo, (double[])item_.getAspicl_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitHi, (double[])item_.getAspicl_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitLo, (double[])item_.getAspicl_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnHi, (double[])item_.getAspicl_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnLo, (double[])item_.getAspicl_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitHi, (double[])item_.getAspicl_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitLo, (double[])item_.getAspicl_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnHi, (double[])item_.getAspicl_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnLo, (double[])item_.getAspicl_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitHi, (double[])item_.getAspicl_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitLo, (double[])item_.getAspicl_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnHi, (double[])item_.getAspicu_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnLo, (double[])item_.getAspicu_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitHi, (double[])item_.getAspicu_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitLo, (double[])item_.getAspicu_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnHi, (double[])item_.getAspicu_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnLo, (double[])item_.getAspicu_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitHi, (double[])item_.getAspicu_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitLo, (double[])item_.getAspicu_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnHi, (double[])item_.getAspicu_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnLo, (double[])item_.getAspicu_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitHi, (double[])item_.getAspicu_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitLo, (double[])item_.getAspicu_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnHi, (double[])item_.getClkhi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnLo, (double[])item_.getClkhi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitHi, (double[])item_.getClkhi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitLo, (double[])item_.getClkhi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnHi, (double[])item_.getClkhv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnLo, (double[])item_.getClkhv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitHi, (double[])item_.getClkhv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitLo, (double[])item_.getClkhv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnHi, (double[])item_.getClkli_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnLo, (double[])item_.getClkli_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitHi, (double[])item_.getClkli_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitLo, (double[])item_.getClkli_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnHi, (double[])item_.getClklv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnLo, (double[])item_.getClklv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitHi, (double[])item_.getClklv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitLo, (double[])item_.getClklv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnHi, (double[])item_.getDigi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnLo, (double[])item_.getDigi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitHi, (double[])item_.getDigi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitLo, (double[])item_.getDigi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnHi, (double[])item_.getDigv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnLo, (double[])item_.getDigv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitHi, (double[])item_.getDigv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitLo, (double[])item_.getDigv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnHi, (double[])item_.getHvbiasswitch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnLo, (double[])item_.getHvbiasswitch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitHi, (double[])item_.getHvbiasswitch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitLo, (double[])item_.getHvbiasswitch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnHi, (double[])item_.getHtrpi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnLo, (double[])item_.getHtrpi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitHi, (double[])item_.getHtrpi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitLo, (double[])item_.getHtrpi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnHi, (double[])item_.getHtrpv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnLo, (double[])item_.getHtrpv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitHi, (double[])item_.getHtrpv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitLo, (double[])item_.getHtrpv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnHi, (double[])item_.getHtrv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnLo, (double[])item_.getHtrv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitHi, (double[])item_.getHtrv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitLo, (double[])item_.getHtrv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnHi, (double[])item_.getHtrw_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnLo, (double[])item_.getHtrw_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitHi, (double[])item_.getHtrw_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitLo, (double[])item_.getHtrw_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnHi, (double[])item_.getPclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnLo, (double[])item_.getPclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitHi, (double[])item_.getPclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitLo, (double[])item_.getPclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_warnHi, (double[])item_.getPclk1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_warnLo, (double[])item_.getPclk1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_limitHi, (double[])item_.getPclk1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_limitLo, (double[])item_.getPclk1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnHi, (double[])item_.getPclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnLo, (double[])item_.getPclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitHi, (double[])item_.getPclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitLo, (double[])item_.getPclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnHi, (double[])item_.getPclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnLo, (double[])item_.getPclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitHi, (double[])item_.getPclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitLo, (double[])item_.getPclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnHi, (double[])item_.getRg0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnLo, (double[])item_.getRg0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitHi, (double[])item_.getRg0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitLo, (double[])item_.getRg0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_warnHi, (double[])item_.getRg1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_warnLo, (double[])item_.getRg1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_limitHi, (double[])item_.getRg1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_limitLo, (double[])item_.getRg1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnHi, (double[])item_.getRgl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnLo, (double[])item_.getRgl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitHi, (double[])item_.getRgl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitLo, (double[])item_.getRgl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnHi, (double[])item_.getRgu_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnLo, (double[])item_.getRgu_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitHi, (double[])item_.getRgu_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitLo, (double[])item_.getRgu_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnHi, (double[])item_.getRtdtemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnLo, (double[])item_.getRtdtemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitHi, (double[])item_.getRtdtemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitLo, (double[])item_.getRtdtemp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnHi, (double[])item_.getRef05v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnLo, (double[])item_.getRef05v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitHi, (double[])item_.getRef05v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitLo, (double[])item_.getRef05v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnHi, (double[])item_.getRef125v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnLo, (double[])item_.getRef125v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitHi, (double[])item_.getRef125v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitLo, (double[])item_.getRef125v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnHi, (double[])item_.getRef15v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnLo, (double[])item_.getRef15v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitHi, (double[])item_.getRef15v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitLo, (double[])item_.getRef15v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnHi, (double[])item_.getRef25v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnLo, (double[])item_.getRef25v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitHi, (double[])item_.getRef25v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitLo, (double[])item_.getRef25v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnHi, (double[])item_.getRefn12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnLo, (double[])item_.getRefn12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitHi, (double[])item_.getRefn12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitLo, (double[])item_.getRefn12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnHi, (double[])item_.getRefp12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnLo, (double[])item_.getRefp12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitHi, (double[])item_.getRefp12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitLo, (double[])item_.getRefp12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnHi, (double[])item_.getSclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnLo, (double[])item_.getSclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitHi, (double[])item_.getSclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitLo, (double[])item_.getSclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_warnHi, (double[])item_.getSclk1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_warnLo, (double[])item_.getSclk1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_limitHi, (double[])item_.getSclk1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_limitLo, (double[])item_.getSclk1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnHi, (double[])item_.getSclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnLo, (double[])item_.getSclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitHi, (double[])item_.getSclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitLo, (double[])item_.getSclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnHi, (double[])item_.getSclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnLo, (double[])item_.getSclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitHi, (double[])item_.getSclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitLo, (double[])item_.getSclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnHi, (double[])item_.getTemp10_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnLo, (double[])item_.getTemp10_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitHi, (double[])item_.getTemp10_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitLo, (double[])item_.getTemp10_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnHi, (double[])item_.getTemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnLo, (double[])item_.getTemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitHi, (double[])item_.getTemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitLo, (double[])item_.getTemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnHi, (double[])item_.getTemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnLo, (double[])item_.getTemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitHi, (double[])item_.getTemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitLo, (double[])item_.getTemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnHi, (double[])item_.getTemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnLo, (double[])item_.getTemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitHi, (double[])item_.getTemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitLo, (double[])item_.getTemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnHi, (double[])item_.getTemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnLo, (double[])item_.getTemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitHi, (double[])item_.getTemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitLo, (double[])item_.getTemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnHi, (double[])item_.getTemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnLo, (double[])item_.getTemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitHi, (double[])item_.getTemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitLo, (double[])item_.getTemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnHi, (double[])item_.getTemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnLo, (double[])item_.getTemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitHi, (double[])item_.getTemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitLo, (double[])item_.getTemp6_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnHi, (double[])item_.getTemp7_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnLo, (double[])item_.getTemp7_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitHi, (double[])item_.getTemp7_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitLo, (double[])item_.getTemp7_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnHi, (double[])item_.getTemp8_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnLo, (double[])item_.getTemp8_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitHi, (double[])item_.getTemp8_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitLo, (double[])item_.getTemp8_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnHi, (double[])item_.getTemp9_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnLo, (double[])item_.getTemp9_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitHi, (double[])item_.getTemp9_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitLo, (double[])item_.getTemp9_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsConfigurationEvent() throws Exception {
        String version = "";
        double[] bias0_csGateP = TestHelper.generateDoubleArray((int)71, (int)-1652816741);
        double[] bias0_gdP = TestHelper.generateDoubleArray((int)71, (int)484718233);
        double[] bias0_odP = TestHelper.generateDoubleArray((int)71, (int)1787344994);
        double[] bias0_ogP = TestHelper.generateDoubleArray((int)71, (int)-1646556897);
        double[] bias0_rdP = TestHelper.generateDoubleArray((int)71, (int)-1094718250);
        double[] bias1_csGateP = TestHelper.generateDoubleArray((int)71, (int)893990897);
        double[] bias1_gdP = TestHelper.generateDoubleArray((int)71, (int)-5715131);
        double[] bias1_odP = TestHelper.generateDoubleArray((int)71, (int)1047168334);
        double[] bias1_ogP = TestHelper.generateDoubleArray((int)71, (int)-2098693751);
        double[] bias1_rdP = TestHelper.generateDoubleArray((int)71, (int)2061663106);
        double[] bias2_csGateP = TestHelper.generateDoubleArray((int)71, (int)503430309);
        double[] bias2_gdP = TestHelper.generateDoubleArray((int)71, (int)-1034863911);
        double[] bias2_odP = TestHelper.generateDoubleArray((int)71, (int)1010083023);
        double[] bias2_ogP = TestHelper.generateDoubleArray((int)71, (int)-1008047005);
        double[] bias2_rdP = TestHelper.generateDoubleArray((int)71, (int)130067583);
        double[] dac_pclkHighP = TestHelper.generateDoubleArray((int)71, (int)-478021520);
        double[] dac_pclkLowP = TestHelper.generateDoubleArray((int)71, (int)1642455866);
        double[] dac_rgHighP = TestHelper.generateDoubleArray((int)71, (int)1914682863);
        double[] dac_rgLowP = TestHelper.generateDoubleArray((int)71, (int)194485814);
        double[] dac_sclkHighP = TestHelper.generateDoubleArray((int)71, (int)1062957077);
        double[] dac_sclkLowP = TestHelper.generateDoubleArray((int)71, (int)119081991);
        boolean[] disableRTDHardwareCheck = new boolean[]{false, false, true, false, false, true, true, false, true, true, true, false, false, false, false, true, true, false, true, false, true, false, false, true, true, true, false, false, true, true, true, false, false, true, false, true, true, true, false, true, true, true, false, false, true, false, false, false, false, true, true, false, true, false, false, false, true, true, true, false, false, true, true, true, false, true, false, true, true, true, true};
        String location = "";
        long[] serialNum = TestHelper.generateLongArray((int)71, (int)-470243363);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsConfigurationEvent(version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, bias1_csGateP, bias1_gdP, bias1_odP, bias1_ogP, bias1_rdP, bias2_csGateP, bias2_gdP, bias2_odP, bias2_ogP, bias2_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsConfigurationEvent));
        Focal_plane_Reb_RaftsConfigurationEvent item_ = (Focal_plane_Reb_RaftsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_csGateP, (double[])item_.getBias0_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdP, (double[])item_.getBias0_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odP, (double[])item_.getBias0_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogP, (double[])item_.getBias0_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdP, (double[])item_.getBias0_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_csGateP, (double[])item_.getBias1_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdP, (double[])item_.getBias1_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odP, (double[])item_.getBias1_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogP, (double[])item_.getBias1_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdP, (double[])item_.getBias1_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_csGateP, (double[])item_.getBias2_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdP, (double[])item_.getBias2_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odP, (double[])item_.getBias2_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogP, (double[])item_.getBias2_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdP, (double[])item_.getBias2_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighP, (double[])item_.getDac_pclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowP, (double[])item_.getDac_pclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighP, (double[])item_.getDac_rgHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowP, (double[])item_.getDac_rgLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighP, (double[])item_.getDac_sclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowP, (double[])item_.getDac_sclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])disableRTDHardwareCheck, (boolean[])item_.getDisableRTDHardwareCheck());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])serialNum, (long[])item_.getSerialNum());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsLimitsConfigurationEvent() throws Exception {
        String version = "a";
        double[] bias0_gdMax = TestHelper.generateDoubleArray((int)71, (int)1985793845);
        double[] bias0_gdMin = TestHelper.generateDoubleArray((int)71, (int)235793704);
        double[] bias0_odMax = TestHelper.generateDoubleArray((int)71, (int)-835941860);
        double[] bias0_odMin = TestHelper.generateDoubleArray((int)71, (int)1932240234);
        double[] bias0_ogMax = TestHelper.generateDoubleArray((int)71, (int)2087325367);
        double[] bias0_ogMin = TestHelper.generateDoubleArray((int)71, (int)1884096494);
        double[] bias0_rdMax = TestHelper.generateDoubleArray((int)71, (int)2088857353);
        double[] bias0_rdMin = TestHelper.generateDoubleArray((int)71, (int)-1624007357);
        double[] bias1_gdMax = TestHelper.generateDoubleArray((int)71, (int)1402627939);
        double[] bias1_gdMin = TestHelper.generateDoubleArray((int)71, (int)23749610);
        double[] bias1_odMax = TestHelper.generateDoubleArray((int)71, (int)-261094871);
        double[] bias1_odMin = TestHelper.generateDoubleArray((int)71, (int)325500859);
        double[] bias1_ogMax = TestHelper.generateDoubleArray((int)71, (int)-1122721646);
        double[] bias1_ogMin = TestHelper.generateDoubleArray((int)71, (int)199263127);
        double[] bias1_rdMax = TestHelper.generateDoubleArray((int)71, (int)-2038628892);
        double[] bias1_rdMin = TestHelper.generateDoubleArray((int)71, (int)925560920);
        double[] bias2_gdMax = TestHelper.generateDoubleArray((int)71, (int)-1420766733);
        double[] bias2_gdMin = TestHelper.generateDoubleArray((int)71, (int)-504987111);
        double[] bias2_odMax = TestHelper.generateDoubleArray((int)71, (int)2086828271);
        double[] bias2_odMin = TestHelper.generateDoubleArray((int)71, (int)529476946);
        double[] bias2_ogMax = TestHelper.generateDoubleArray((int)71, (int)-1581463101);
        double[] bias2_ogMin = TestHelper.generateDoubleArray((int)71, (int)-1707978915);
        double[] bias2_rdMax = TestHelper.generateDoubleArray((int)71, (int)2063325593);
        double[] bias2_rdMin = TestHelper.generateDoubleArray((int)71, (int)1859101270);
        double[] dac_pclkHighMax = TestHelper.generateDoubleArray((int)71, (int)-846978502);
        double[] dac_pclkHighMin = TestHelper.generateDoubleArray((int)71, (int)-1084224898);
        double[] dac_pclkLowMax = TestHelper.generateDoubleArray((int)71, (int)749546084);
        double[] dac_pclkLowMin = TestHelper.generateDoubleArray((int)71, (int)-2067684473);
        double[] dac_rgHighMax = TestHelper.generateDoubleArray((int)71, (int)-2034255288);
        double[] dac_rgHighMin = TestHelper.generateDoubleArray((int)71, (int)1435115114);
        double[] dac_rgLowMax = TestHelper.generateDoubleArray((int)71, (int)-401431594);
        double[] dac_rgLowMin = TestHelper.generateDoubleArray((int)71, (int)-925510460);
        double[] dac_sclkHighMax = TestHelper.generateDoubleArray((int)71, (int)-313031295);
        double[] dac_sclkHighMin = TestHelper.generateDoubleArray((int)71, (int)-734788411);
        double[] dac_sclkLowMax = TestHelper.generateDoubleArray((int)71, (int)1715371921);
        double[] dac_sclkLowMin = TestHelper.generateDoubleArray((int)71, (int)-1132527312);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsLimitsConfigurationEvent(version, bias0_gdMax, bias0_gdMin, bias0_odMax, bias0_odMin, bias0_ogMax, bias0_ogMin, bias0_rdMax, bias0_rdMin, bias1_gdMax, bias1_gdMin, bias1_odMax, bias1_odMin, bias1_ogMax, bias1_ogMin, bias1_rdMax, bias1_rdMin, bias2_gdMax, bias2_gdMin, bias2_odMax, bias2_odMin, bias2_ogMax, bias2_ogMin, bias2_rdMax, bias2_rdMin, dac_pclkHighMax, dac_pclkHighMin, dac_pclkLowMax, dac_pclkLowMin, dac_rgHighMax, dac_rgHighMin, dac_rgLowMax, dac_rgLowMin, dac_sclkHighMax, dac_sclkHighMin, dac_sclkLowMax, dac_sclkLowMin, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsLimitsConfigurationEvent));
        Focal_plane_Reb_RaftsLimitsConfigurationEvent item_ = (Focal_plane_Reb_RaftsLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdMax, (double[])item_.getBias0_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdMin, (double[])item_.getBias0_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMax, (double[])item_.getBias0_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMin, (double[])item_.getBias0_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMax, (double[])item_.getBias0_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMin, (double[])item_.getBias0_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMax, (double[])item_.getBias0_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMin, (double[])item_.getBias0_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMax, (double[])item_.getBias1_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMin, (double[])item_.getBias1_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMax, (double[])item_.getBias1_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMin, (double[])item_.getBias1_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMax, (double[])item_.getBias1_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMin, (double[])item_.getBias1_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMax, (double[])item_.getBias1_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMin, (double[])item_.getBias1_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMax, (double[])item_.getBias2_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMin, (double[])item_.getBias2_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMax, (double[])item_.getBias2_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMin, (double[])item_.getBias2_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMax, (double[])item_.getBias2_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMin, (double[])item_.getBias2_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMax, (double[])item_.getBias2_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMin, (double[])item_.getBias2_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMax, (double[])item_.getDac_pclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMin, (double[])item_.getDac_pclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMax, (double[])item_.getDac_pclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMin, (double[])item_.getDac_pclkLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMax, (double[])item_.getDac_rgHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMin, (double[])item_.getDac_rgHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMax, (double[])item_.getDac_rgLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMin, (double[])item_.getDac_rgLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMax, (double[])item_.getDac_sclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMin, (double[])item_.getDac_sclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMax, (double[])item_.getDac_sclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMin, (double[])item_.getDac_sclkLowMin(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsPowerConfigurationEvent() throws Exception {
        String version = "";
        double[] bias0_gdCal = TestHelper.generateDoubleArray((int)71, (int)1637378209);
        double[] bias0_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)-995072274);
        double[] bias0_gdTol = TestHelper.generateDoubleArray((int)71, (int)575868291);
        double[] bias0_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)1910830590);
        double[] bias0_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)1741888789);
        double[] bias0_odCal = TestHelper.generateDoubleArray((int)71, (int)-1961985236);
        double[] bias0_odIMax = TestHelper.generateDoubleArray((int)71, (int)-1791099442);
        double[] bias0_odTol = TestHelper.generateDoubleArray((int)71, (int)963690295);
        double[] bias0_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)-2086529840);
        double[] bias0_ogCal = TestHelper.generateDoubleArray((int)71, (int)395930211);
        double[] bias0_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)-1347925263);
        double[] bias0_ogTol = TestHelper.generateDoubleArray((int)71, (int)1780459804);
        double[] bias0_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)589447584);
        double[] bias0_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)1917376732);
        double[] bias0_rdCal = TestHelper.generateDoubleArray((int)71, (int)467313873);
        double[] bias0_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)-1051691778);
        double[] bias0_rdTol = TestHelper.generateDoubleArray((int)71, (int)-1819919217);
        double[] bias0_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)-1652250763);
        double[] bias0_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1535133711);
        double[] bias1_gdCal = TestHelper.generateDoubleArray((int)71, (int)190875513);
        double[] bias1_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)-221809543);
        double[] bias1_gdTol = TestHelper.generateDoubleArray((int)71, (int)-153173852);
        double[] bias1_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)-912125910);
        double[] bias1_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1016912099);
        double[] bias1_odCal = TestHelper.generateDoubleArray((int)71, (int)-903663138);
        double[] bias1_odIMax = TestHelper.generateDoubleArray((int)71, (int)-1355927108);
        double[] bias1_odTol = TestHelper.generateDoubleArray((int)71, (int)2140730011);
        double[] bias1_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1363443376);
        double[] bias1_ogCal = TestHelper.generateDoubleArray((int)71, (int)-381451271);
        double[] bias1_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)-965995409);
        double[] bias1_ogTol = TestHelper.generateDoubleArray((int)71, (int)-1550556451);
        double[] bias1_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)760715634);
        double[] bias1_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)794913553);
        double[] bias1_rdCal = TestHelper.generateDoubleArray((int)71, (int)1052183699);
        double[] bias1_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)-1077426309);
        double[] bias1_rdTol = TestHelper.generateDoubleArray((int)71, (int)1116243522);
        double[] bias1_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)-424750066);
        double[] bias1_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-2065015255);
        double[] bias2_gdCal = TestHelper.generateDoubleArray((int)71, (int)355852705);
        double[] bias2_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)1935057280);
        double[] bias2_gdTol = TestHelper.generateDoubleArray((int)71, (int)875313486);
        double[] bias2_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)411164570);
        double[] bias2_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)840436754);
        double[] bias2_odCal = TestHelper.generateDoubleArray((int)71, (int)871796178);
        double[] bias2_odIMax = TestHelper.generateDoubleArray((int)71, (int)-67699527);
        double[] bias2_odTol = TestHelper.generateDoubleArray((int)71, (int)-2007741374);
        double[] bias2_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)2097542495);
        double[] bias2_ogCal = TestHelper.generateDoubleArray((int)71, (int)-1729218837);
        double[] bias2_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)-447033582);
        double[] bias2_ogTol = TestHelper.generateDoubleArray((int)71, (int)-364790990);
        double[] bias2_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)1570916693);
        double[] bias2_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1748553751);
        double[] bias2_rdCal = TestHelper.generateDoubleArray((int)71, (int)-473843568);
        double[] bias2_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)294403633);
        double[] bias2_rdTol = TestHelper.generateDoubleArray((int)71, (int)249822647);
        double[] bias2_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)958272510);
        double[] bias2_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1488742739);
        double[] clkhiAmin = TestHelper.generateDoubleArray((int)71, (int)1047325956);
        double[] clkhiQmax = TestHelper.generateDoubleArray((int)71, (int)-1537526228);
        double[] clkliAmin = TestHelper.generateDoubleArray((int)71, (int)2025114962);
        double[] clkliQmax = TestHelper.generateDoubleArray((int)71, (int)-2108742852);
        double[] dac_clkhIMax = TestHelper.generateDoubleArray((int)71, (int)-1579687697);
        double[] dac_clklIMax = TestHelper.generateDoubleArray((int)71, (int)-1907625094);
        double[] dac_pclkHighCal = TestHelper.generateDoubleArray((int)71, (int)438822440);
        double[] dac_pclkHighTestV = TestHelper.generateDoubleArray((int)71, (int)-420226879);
        double[] dac_pclkHighTol = TestHelper.generateDoubleArray((int)71, (int)1854268539);
        double[] dac_pclkHighValueErr = TestHelper.generateDoubleArray((int)71, (int)-1889009164);
        double[] dac_pclkHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1069201345);
        double[] dac_pclkLowCal = TestHelper.generateDoubleArray((int)71, (int)1861568508);
        double[] dac_pclkLowTestV = TestHelper.generateDoubleArray((int)71, (int)-461186184);
        double[] dac_pclkLowTol = TestHelper.generateDoubleArray((int)71, (int)-174793935);
        double[] dac_pclkLowValueErr = TestHelper.generateDoubleArray((int)71, (int)201657978);
        double[] dac_pclkLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)323334855);
        double[] dac_rgHighCal = TestHelper.generateDoubleArray((int)71, (int)-1427364027);
        double[] dac_rgHighTestV = TestHelper.generateDoubleArray((int)71, (int)1153527550);
        double[] dac_rgHighTol = TestHelper.generateDoubleArray((int)71, (int)1158368450);
        double[] dac_rgHighValueErr = TestHelper.generateDoubleArray((int)71, (int)-2096168927);
        double[] dac_rgHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)1148881742);
        double[] dac_rgLowCal = TestHelper.generateDoubleArray((int)71, (int)-627374187);
        double[] dac_rgLowTestV = TestHelper.generateDoubleArray((int)71, (int)178516523);
        double[] dac_rgLowTol = TestHelper.generateDoubleArray((int)71, (int)2102287753);
        double[] dac_rgLowValueErr = TestHelper.generateDoubleArray((int)71, (int)-1691920938);
        double[] dac_rgLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)1395637518);
        double[] dac_sclkHighCal = TestHelper.generateDoubleArray((int)71, (int)664283477);
        double[] dac_sclkHighTestV = TestHelper.generateDoubleArray((int)71, (int)1266164112);
        double[] dac_sclkHighTol = TestHelper.generateDoubleArray((int)71, (int)-1376464650);
        double[] dac_sclkHighValueErr = TestHelper.generateDoubleArray((int)71, (int)1149250581);
        double[] dac_sclkHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)-548480236);
        double[] dac_sclkLowCal = TestHelper.generateDoubleArray((int)71, (int)1960756137);
        double[] dac_sclkLowTestV = TestHelper.generateDoubleArray((int)71, (int)-975290396);
        double[] dac_sclkLowTol = TestHelper.generateDoubleArray((int)71, (int)-655793188);
        double[] dac_sclkLowValueErr = TestHelper.generateDoubleArray((int)71, (int)-845138093);
        double[] dac_sclkLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)49347907);
        String location = "";
        double[] maxDelta = TestHelper.generateDoubleArray((int)71, (int)-1318371501);
        double[] maxStep = TestHelper.generateDoubleArray((int)71, (int)-958502859);
        double[] minTol = TestHelper.generateDoubleArray((int)71, (int)319842329);
        int[] nPowerOnPub = TestHelper.generateIntArray((int)71, (int)-471070484);
        double[] odiAmin = TestHelper.generateDoubleArray((int)71, (int)-2007065194);
        double[] odiQmax = TestHelper.generateDoubleArray((int)71, (int)2031342460);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsPowerConfigurationEvent(version, bias0_gdCal, bias0_gdTestVolts, bias0_gdTol, bias0_gdValueErr, bias0_gdZeroErr, bias0_odCal, bias0_odIMax, bias0_odTol, bias0_odZeroErr, bias0_ogCal, bias0_ogTestVolts, bias0_ogTol, bias0_ogValueErr, bias0_ogZeroErr, bias0_rdCal, bias0_rdTestVolts, bias0_rdTol, bias0_rdValueErr, bias0_rdZeroErr, bias1_gdCal, bias1_gdTestVolts, bias1_gdTol, bias1_gdValueErr, bias1_gdZeroErr, bias1_odCal, bias1_odIMax, bias1_odTol, bias1_odZeroErr, bias1_ogCal, bias1_ogTestVolts, bias1_ogTol, bias1_ogValueErr, bias1_ogZeroErr, bias1_rdCal, bias1_rdTestVolts, bias1_rdTol, bias1_rdValueErr, bias1_rdZeroErr, bias2_gdCal, bias2_gdTestVolts, bias2_gdTol, bias2_gdValueErr, bias2_gdZeroErr, bias2_odCal, bias2_odIMax, bias2_odTol, bias2_odZeroErr, bias2_ogCal, bias2_ogTestVolts, bias2_ogTol, bias2_ogValueErr, bias2_ogZeroErr, bias2_rdCal, bias2_rdTestVolts, bias2_rdTol, bias2_rdValueErr, bias2_rdZeroErr, clkhiAmin, clkhiQmax, clkliAmin, clkliQmax, dac_clkhIMax, dac_clklIMax, dac_pclkHighCal, dac_pclkHighTestV, dac_pclkHighTol, dac_pclkHighValueErr, dac_pclkHighZeroErr, dac_pclkLowCal, dac_pclkLowTestV, dac_pclkLowTol, dac_pclkLowValueErr, dac_pclkLowZeroErr, dac_rgHighCal, dac_rgHighTestV, dac_rgHighTol, dac_rgHighValueErr, dac_rgHighZeroErr, dac_rgLowCal, dac_rgLowTestV, dac_rgLowTol, dac_rgLowValueErr, dac_rgLowZeroErr, dac_sclkHighCal, dac_sclkHighTestV, dac_sclkHighTol, dac_sclkHighValueErr, dac_sclkHighZeroErr, dac_sclkLowCal, dac_sclkLowTestV, dac_sclkLowTol, dac_sclkLowValueErr, dac_sclkLowZeroErr, location, maxDelta, maxStep, minTol, nPowerOnPub, odiAmin, odiQmax));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsPowerConfigurationEvent));
        Focal_plane_Reb_RaftsPowerConfigurationEvent item_ = (Focal_plane_Reb_RaftsPowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdCal, (double[])item_.getBias0_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTestVolts, (double[])item_.getBias0_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTol, (double[])item_.getBias0_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdValueErr, (double[])item_.getBias0_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdZeroErr, (double[])item_.getBias0_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odCal, (double[])item_.getBias0_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odIMax, (double[])item_.getBias0_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odTol, (double[])item_.getBias0_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odZeroErr, (double[])item_.getBias0_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogCal, (double[])item_.getBias0_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTestVolts, (double[])item_.getBias0_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTol, (double[])item_.getBias0_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogValueErr, (double[])item_.getBias0_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogZeroErr, (double[])item_.getBias0_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdCal, (double[])item_.getBias0_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTestVolts, (double[])item_.getBias0_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTol, (double[])item_.getBias0_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdValueErr, (double[])item_.getBias0_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdZeroErr, (double[])item_.getBias0_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdCal, (double[])item_.getBias1_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTestVolts, (double[])item_.getBias1_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTol, (double[])item_.getBias1_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdValueErr, (double[])item_.getBias1_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdZeroErr, (double[])item_.getBias1_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odCal, (double[])item_.getBias1_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odIMax, (double[])item_.getBias1_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odTol, (double[])item_.getBias1_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odZeroErr, (double[])item_.getBias1_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogCal, (double[])item_.getBias1_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTestVolts, (double[])item_.getBias1_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTol, (double[])item_.getBias1_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogValueErr, (double[])item_.getBias1_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogZeroErr, (double[])item_.getBias1_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdCal, (double[])item_.getBias1_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTestVolts, (double[])item_.getBias1_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTol, (double[])item_.getBias1_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdValueErr, (double[])item_.getBias1_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdZeroErr, (double[])item_.getBias1_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdCal, (double[])item_.getBias2_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTestVolts, (double[])item_.getBias2_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTol, (double[])item_.getBias2_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdValueErr, (double[])item_.getBias2_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdZeroErr, (double[])item_.getBias2_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odCal, (double[])item_.getBias2_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odIMax, (double[])item_.getBias2_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odTol, (double[])item_.getBias2_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odZeroErr, (double[])item_.getBias2_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogCal, (double[])item_.getBias2_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTestVolts, (double[])item_.getBias2_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTol, (double[])item_.getBias2_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogValueErr, (double[])item_.getBias2_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogZeroErr, (double[])item_.getBias2_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdCal, (double[])item_.getBias2_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTestVolts, (double[])item_.getBias2_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTol, (double[])item_.getBias2_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdValueErr, (double[])item_.getBias2_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdZeroErr, (double[])item_.getBias2_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiAmin, (double[])item_.getClkhiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiQmax, (double[])item_.getClkhiQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliAmin, (double[])item_.getClkliAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliQmax, (double[])item_.getClkliQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clkhIMax, (double[])item_.getDac_clkhIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clklIMax, (double[])item_.getDac_clklIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighCal, (double[])item_.getDac_pclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTestV, (double[])item_.getDac_pclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTol, (double[])item_.getDac_pclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighValueErr, (double[])item_.getDac_pclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighZeroErr, (double[])item_.getDac_pclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowCal, (double[])item_.getDac_pclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTestV, (double[])item_.getDac_pclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTol, (double[])item_.getDac_pclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowValueErr, (double[])item_.getDac_pclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowZeroErr, (double[])item_.getDac_pclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighCal, (double[])item_.getDac_rgHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTestV, (double[])item_.getDac_rgHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTol, (double[])item_.getDac_rgHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighValueErr, (double[])item_.getDac_rgHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighZeroErr, (double[])item_.getDac_rgHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowCal, (double[])item_.getDac_rgLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTestV, (double[])item_.getDac_rgLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTol, (double[])item_.getDac_rgLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowValueErr, (double[])item_.getDac_rgLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowZeroErr, (double[])item_.getDac_rgLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighCal, (double[])item_.getDac_sclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTestV, (double[])item_.getDac_sclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTol, (double[])item_.getDac_sclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighValueErr, (double[])item_.getDac_sclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighZeroErr, (double[])item_.getDac_sclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowCal, (double[])item_.getDac_sclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTestV, (double[])item_.getDac_sclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTol, (double[])item_.getDac_sclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowValueErr, (double[])item_.getDac_sclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowZeroErr, (double[])item_.getDac_sclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])maxDelta, (double[])item_.getMaxDelta(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxStep, (double[])item_.getMaxStep(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])minTol, (double[])item_.getMinTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
        Assert.assertArrayEquals((double[])odiAmin, (double[])item_.getOdiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odiQmax, (double[])item_.getOdiQmax(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_timersConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        long[] periodictasks_monitor_check_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1047670183);
        long[] periodictasks_monitor_publish_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-191263186);
        long[] periodictasks_monitor_publish_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1441227615);
        long[] periodictasks_monitor_publish_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)2118474924);
        long[] periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)905691484);
        long[] periodictasks_monitor_publish_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1355880843);
        long[] periodictasks_monitor_publish_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-2109622848);
        long[] periodictasks_monitor_publish_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-226878009);
        long[] periodictasks_monitor_update_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1058495386);
        long[] periodictasks_monitor_update_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)602220487);
        long[] periodictasks_monitor_update_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1092876195);
        long[] periodictasks_monitor_update_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1163938905);
        long[] periodictasks_monitor_update_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1760325059);
        long[] periodictasks_monitor_update_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1640037702);
        long[] periodictasks_monitor_update_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1610509921);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_timersConfigurationEvent(version, location, periodictasks_monitor_check_taskPeriodMillis, periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, periodictasks_monitor_publish_biasVolt_taskPeriodMillis, periodictasks_monitor_publish_boardPower_taskPeriodMillis, periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, periodictasks_monitor_publish_crVolt_taskPeriodMillis, periodictasks_monitor_publish_rebTemp_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_aspicTemp_taskPeriodMillis, periodictasks_monitor_update_biasVolt_taskPeriodMillis, periodictasks_monitor_update_boardPower_taskPeriodMillis, periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, periodictasks_monitor_update_crVolt_taskPeriodMillis, periodictasks_monitor_update_rebTemp_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_timersConfigurationEvent));
        Focal_plane_Reb_timersConfigurationEvent item_ = (Focal_plane_Reb_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])periodictasks_monitor_check_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_check_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6_GeneralConfigurationEvent() throws Exception {
        String version = "k";
        String chanNames = "o";
        String chanWeights = "";
        boolean ignoreNaN = true;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent(version, chanNames, chanWeights, ignoreNaN));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent));
        Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent item_ = (Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)chanNames, (Object)item_.getChanNames());
        Assert.assertEquals((Object)chanWeights, (Object)item_.getChanWeights());
        Assert.assertEquals((Object)ignoreNaN, (Object)item_.isIgnoreNaN());
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.33909255266189575;
        double warnLo = 0.6457557678222656;
        double limitHi = 0.7653827667236328;
        double limitLo = 0.9860984086990356;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent));
        Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent item_ = (Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Segment_LimitsConfigurationEvent() throws Exception {
        String version = "j";
        double[] i_warnHi = TestHelper.generateDoubleArray((int)3024, (int)475787017);
        double[] i_warnLo = TestHelper.generateDoubleArray((int)3024, (int)-67689598);
        double[] i_limitHi = TestHelper.generateDoubleArray((int)3024, (int)1148833369);
        double[] i_limitLo = TestHelper.generateDoubleArray((int)3024, (int)-1181055952);
        String location = "c";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Segment_LimitsConfigurationEvent(version, i_warnHi, i_warnLo, i_limitHi, i_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Segment_LimitsConfigurationEvent));
        Focal_plane_Segment_LimitsConfigurationEvent item_ = (Focal_plane_Segment_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])i_warnHi, (double[])item_.getI_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_warnLo, (double[])item_.getI_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitHi, (double[])item_.getI_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitLo, (double[])item_.getI_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_DAQConfigurationEvent() throws Exception {
        String version = "z";
        int badPixelAlarmLimit = 387;
        String daqFolder = "l";
        String daqPartition = "";
        boolean emulatedDAQ = true;
        String scienceLocations = "";
        boolean simulatedDAQ = false;
        String simulatedDataFolder = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_DAQConfigurationEvent(version, badPixelAlarmLimit, daqFolder, daqPartition, emulatedDAQ, scienceLocations, simulatedDAQ, simulatedDataFolder));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_DAQConfigurationEvent));
        Focal_plane_SequencerConfig_DAQConfigurationEvent item_ = (Focal_plane_SequencerConfig_DAQConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)badPixelAlarmLimit, (long)item_.getBadPixelAlarmLimit());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
        Assert.assertEquals((Object)emulatedDAQ, (Object)item_.isEmulatedDAQ());
        Assert.assertEquals((Object)scienceLocations, (Object)item_.getScienceLocations());
        Assert.assertEquals((Object)simulatedDAQ, (Object)item_.isSimulatedDAQ());
        Assert.assertEquals((Object)simulatedDataFolder, (Object)item_.getSimulatedDataFolder());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_GuiderConfigurationEvent() throws Exception {
        String version = "";
        String commandedClearParameters = "e";
        String extendedROIParameters = "l";
        String guiderLocations = "";
        String guiderPartition = "";
        String idleClearParameters = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_GuiderConfigurationEvent(version, commandedClearParameters, extendedROIParameters, guiderLocations, guiderPartition, idleClearParameters));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_GuiderConfigurationEvent));
        Focal_plane_SequencerConfig_GuiderConfigurationEvent item_ = (Focal_plane_SequencerConfig_GuiderConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)commandedClearParameters, (Object)item_.getCommandedClearParameters());
        Assert.assertEquals((Object)extendedROIParameters, (Object)item_.getExtendedROIParameters());
        Assert.assertEquals((Object)guiderLocations, (Object)item_.getGuiderLocations());
        Assert.assertEquals((Object)guiderPartition, (Object)item_.getGuiderPartition());
        Assert.assertEquals((Object)idleClearParameters, (Object)item_.getIdleClearParameters());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_SequencerConfigurationEvent() throws Exception {
        String version = "m";
        String clearCountParameter = "g";
        String clearMain = "";
        String idleFlushMain = "h";
        long idleFlushTimeout = 14L;
        String integrateMain = "";
        String metaDataRegisters = "g";
        int overCols = 596;
        int overRows = 730;
        int postCols = 49;
        int postRows = 735;
        int preCols = 519;
        int preRows = 305;
        String pseudoReadMain = "";
        int readCols = 658;
        int readCols2 = 423;
        String readMain = "";
        int readRows = 256;
        String rowShiftForwardMain = "";
        String rowShiftReverseMain = "";
        boolean scanMode = true;
        String sequencer = "a";
        String sequencerChecksums = "t";
        String shiftCountParameter = "";
        boolean stepAfterIntegrate = false;
        int transparentMode = 186;
        int underCols = 842;
        boolean useParallelRegisters = true;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_SequencerConfigurationEvent(version, clearCountParameter, clearMain, idleFlushMain, idleFlushTimeout, integrateMain, metaDataRegisters, overCols, overRows, postCols, postRows, preCols, preRows, pseudoReadMain, readCols, readCols2, readMain, readRows, rowShiftForwardMain, rowShiftReverseMain, scanMode, sequencer, sequencerChecksums, shiftCountParameter, stepAfterIntegrate, transparentMode, underCols, useParallelRegisters));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_SequencerConfigurationEvent));
        Focal_plane_SequencerConfig_SequencerConfigurationEvent item_ = (Focal_plane_SequencerConfig_SequencerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)clearCountParameter, (Object)item_.getClearCountParameter());
        Assert.assertEquals((Object)clearMain, (Object)item_.getClearMain());
        Assert.assertEquals((Object)idleFlushMain, (Object)item_.getIdleFlushMain());
        Assert.assertEquals((long)idleFlushTimeout, (long)item_.getIdleFlushTimeout());
        Assert.assertEquals((Object)integrateMain, (Object)item_.getIntegrateMain());
        Assert.assertEquals((Object)metaDataRegisters, (Object)item_.getMetaDataRegisters());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)postRows, (long)item_.getPostRows());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((Object)pseudoReadMain, (Object)item_.getPseudoReadMain());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((Object)readMain, (Object)item_.getReadMain());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((Object)rowShiftForwardMain, (Object)item_.getRowShiftForwardMain());
        Assert.assertEquals((Object)rowShiftReverseMain, (Object)item_.getRowShiftReverseMain());
        Assert.assertEquals((Object)scanMode, (Object)item_.isScanMode());
        Assert.assertEquals((Object)sequencer, (Object)item_.getSequencer());
        Assert.assertEquals((Object)sequencerChecksums, (Object)item_.getSequencerChecksums());
        Assert.assertEquals((Object)shiftCountParameter, (Object)item_.getShiftCountParameter());
        Assert.assertEquals((Object)stepAfterIntegrate, (Object)item_.isStepAfterIntegrate());
        Assert.assertEquals((long)transparentMode, (long)item_.getTransparentMode());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)useParallelRegisters, (Object)item_.isUseParallelRegisters());
    }

    @Test
    public void sendReceiveFocal_plane_WebHooksConfig_VisualizationConfigurationEvent() throws Exception {
        String version = "l";
        String webHooks = "q";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_WebHooksConfig_VisualizationConfigurationEvent(version, webHooks));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_WebHooksConfig_VisualizationConfigurationEvent));
        Focal_plane_WebHooksConfig_VisualizationConfigurationEvent item_ = (Focal_plane_WebHooksConfig_VisualizationConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)webHooks, (Object)item_.getWebHooks());
    }

    @Test
    public void sendReceiveImage_handling_FitsService_GeneralConfigurationEvent() throws Exception {
        String version = "o";
        String guider_headerFilesList = "";
        String science_headerFilesList = "n";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_FitsService_GeneralConfigurationEvent(version, guider_headerFilesList, science_headerFilesList));
        Assert.assertTrue((boolean)(item instanceof Image_handling_FitsService_GeneralConfigurationEvent));
        Image_handling_FitsService_GeneralConfigurationEvent item_ = (Image_handling_FitsService_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)guider_headerFilesList, (Object)item_.getGuider_headerFilesList());
        Assert.assertEquals((Object)science_headerFilesList, (Object)item_.getScience_headerFilesList());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_CommandsConfigurationEvent() throws Exception {
        String version = "";
        String imagehandlingconfig_additionalFileCommands = "k";
        String imagehandlingconfig_additionalFileFilter = "";
        String imagehandlingconfig_commands = "w";
        String imagehandlingconfig_currentDirectory = "p";
        String imagehandlingconfig_environment = "x";
        String imagehandlingconfig_logDirectory = "";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_CommandsConfigurationEvent(version, imagehandlingconfig_additionalFileCommands, imagehandlingconfig_additionalFileFilter, imagehandlingconfig_commands, imagehandlingconfig_currentDirectory, imagehandlingconfig_environment, imagehandlingconfig_logDirectory));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_CommandsConfigurationEvent));
        Image_handling_ImageHandler_CommandsConfigurationEvent item_ = (Image_handling_ImageHandler_CommandsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_additionalFileCommands, (Object)item_.getImagehandlingconfig_additionalFileCommands());
        Assert.assertEquals((Object)imagehandlingconfig_additionalFileFilter, (Object)item_.getImagehandlingconfig_additionalFileFilter());
        Assert.assertEquals((Object)imagehandlingconfig_commands, (Object)item_.getImagehandlingconfig_commands());
        Assert.assertEquals((Object)imagehandlingconfig_currentDirectory, (Object)item_.getImagehandlingconfig_currentDirectory());
        Assert.assertEquals((Object)imagehandlingconfig_environment, (Object)item_.getImagehandlingconfig_environment());
        Assert.assertEquals((Object)imagehandlingconfig_logDirectory, (Object)item_.getImagehandlingconfig_logDirectory());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_DAQConfigurationEvent() throws Exception {
        String version = "";
        int imagehandlingconfig_badPixelAlarmLevel = 263;
        int imagehandlingconfig_badPixelHighThreshold = 752;
        int imagehandlingconfig_badPixelLowThreshold = 305;
        int imagehandlingconfig_badPixelWarningLevel = 783;
        boolean imagehandlingconfig_checkForBadPixels = true;
        String imagehandlingconfig_daqFolder = "u";
        String imagehandlingconfig_daqPartition = "";
        int imagehandlingconfig_daqThreads = 522;
        String imagehandlingconfig_locations = "";
        boolean imagehandlingconfig_useStreaming = false;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_DAQConfigurationEvent(version, imagehandlingconfig_badPixelAlarmLevel, imagehandlingconfig_badPixelHighThreshold, imagehandlingconfig_badPixelLowThreshold, imagehandlingconfig_badPixelWarningLevel, imagehandlingconfig_checkForBadPixels, imagehandlingconfig_daqFolder, imagehandlingconfig_daqPartition, imagehandlingconfig_daqThreads, imagehandlingconfig_locations, imagehandlingconfig_useStreaming));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_DAQConfigurationEvent));
        Image_handling_ImageHandler_DAQConfigurationEvent item_ = (Image_handling_ImageHandler_DAQConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)imagehandlingconfig_badPixelAlarmLevel, (long)item_.getImagehandlingconfig_badPixelAlarmLevel());
        Assert.assertEquals((long)imagehandlingconfig_badPixelHighThreshold, (long)item_.getImagehandlingconfig_badPixelHighThreshold());
        Assert.assertEquals((long)imagehandlingconfig_badPixelLowThreshold, (long)item_.getImagehandlingconfig_badPixelLowThreshold());
        Assert.assertEquals((long)imagehandlingconfig_badPixelWarningLevel, (long)item_.getImagehandlingconfig_badPixelWarningLevel());
        Assert.assertEquals((Object)imagehandlingconfig_checkForBadPixels, (Object)item_.isImagehandlingconfig_checkForBadPixels());
        Assert.assertEquals((Object)imagehandlingconfig_daqFolder, (Object)item_.getImagehandlingconfig_daqFolder());
        Assert.assertEquals((Object)imagehandlingconfig_daqPartition, (Object)item_.getImagehandlingconfig_daqPartition());
        Assert.assertEquals((long)imagehandlingconfig_daqThreads, (long)item_.getImagehandlingconfig_daqThreads());
        Assert.assertEquals((Object)imagehandlingconfig_locations, (Object)item_.getImagehandlingconfig_locations());
        Assert.assertEquals((Object)imagehandlingconfig_useStreaming, (Object)item_.isImagehandlingconfig_useStreaming());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_FitsHandlingConfigurationEvent() throws Exception {
        String version = "f";
        boolean imagehandlingconfig_FITSAutoSave = true;
        String imagehandlingconfig_FITSDirectoryPattern = "p";
        String imagehandlingconfig_FITSFilePattern = "d";
        String imagehandlingconfig_FITSRootDirectory = "";
        boolean imagehandlingconfig_raiseAlertOnMissingOrBadHeaderServiceData = true;
        String imagehandlingconfig_subsystemsToClearOnNewRun = "";
        String imagehandlingconfig_tempFileRelativeLocation = "j";
        boolean imagehandlingconfig_useTempFile = false;
        String imagehandlingconfig_waitForHeaderService = "f";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_FitsHandlingConfigurationEvent(version, imagehandlingconfig_FITSAutoSave, imagehandlingconfig_FITSDirectoryPattern, imagehandlingconfig_FITSFilePattern, imagehandlingconfig_FITSRootDirectory, imagehandlingconfig_raiseAlertOnMissingOrBadHeaderServiceData, imagehandlingconfig_subsystemsToClearOnNewRun, imagehandlingconfig_tempFileRelativeLocation, imagehandlingconfig_useTempFile, imagehandlingconfig_waitForHeaderService));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_FitsHandlingConfigurationEvent));
        Image_handling_ImageHandler_FitsHandlingConfigurationEvent item_ = (Image_handling_ImageHandler_FitsHandlingConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_FITSAutoSave, (Object)item_.isImagehandlingconfig_FITSAutoSave());
        Assert.assertEquals((Object)imagehandlingconfig_FITSDirectoryPattern, (Object)item_.getImagehandlingconfig_FITSDirectoryPattern());
        Assert.assertEquals((Object)imagehandlingconfig_FITSFilePattern, (Object)item_.getImagehandlingconfig_FITSFilePattern());
        Assert.assertEquals((Object)imagehandlingconfig_FITSRootDirectory, (Object)item_.getImagehandlingconfig_FITSRootDirectory());
        Assert.assertEquals((Object)imagehandlingconfig_raiseAlertOnMissingOrBadHeaderServiceData, (Object)item_.isImagehandlingconfig_raiseAlertOnMissingOrBadHeaderServiceData());
        Assert.assertEquals((Object)imagehandlingconfig_subsystemsToClearOnNewRun, (Object)item_.getImagehandlingconfig_subsystemsToClearOnNewRun());
        Assert.assertEquals((Object)imagehandlingconfig_tempFileRelativeLocation, (Object)item_.getImagehandlingconfig_tempFileRelativeLocation());
        Assert.assertEquals((Object)imagehandlingconfig_useTempFile, (Object)item_.isImagehandlingconfig_useTempFile());
        Assert.assertEquals((Object)imagehandlingconfig_waitForHeaderService, (Object)item_.getImagehandlingconfig_waitForHeaderService());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_GeneralConfigurationEvent() throws Exception {
        String version = "";
        String imagedatabaseservice_dbURL = "c";
        boolean imagedatabaseservice_enabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_GeneralConfigurationEvent(version, imagedatabaseservice_dbURL, imagedatabaseservice_enabled));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_GeneralConfigurationEvent));
        Image_handling_ImageHandler_GeneralConfigurationEvent item_ = (Image_handling_ImageHandler_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagedatabaseservice_dbURL, (Object)item_.getImagedatabaseservice_dbURL());
        Assert.assertEquals((Object)imagedatabaseservice_enabled, (Object)item_.isImagedatabaseservice_enabled());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_GuiderConfigurationEvent() throws Exception {
        String version = "n";
        String imagehandlingconfig_guiderFITSFilePattern = "";
        String imagehandlingconfig_guiderLocations = "";
        String imagehandlingconfig_guiderPartition = "e";
        boolean imagehandlingconfig_includeRawStamps = true;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_GuiderConfigurationEvent(version, imagehandlingconfig_guiderFITSFilePattern, imagehandlingconfig_guiderLocations, imagehandlingconfig_guiderPartition, imagehandlingconfig_includeRawStamps));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_GuiderConfigurationEvent));
        Image_handling_ImageHandler_GuiderConfigurationEvent item_ = (Image_handling_ImageHandler_GuiderConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_guiderFITSFilePattern, (Object)item_.getImagehandlingconfig_guiderFITSFilePattern());
        Assert.assertEquals((Object)imagehandlingconfig_guiderLocations, (Object)item_.getImagehandlingconfig_guiderLocations());
        Assert.assertEquals((Object)imagehandlingconfig_guiderPartition, (Object)item_.getImagehandlingconfig_guiderPartition());
        Assert.assertEquals((Object)imagehandlingconfig_includeRawStamps, (Object)item_.isImagehandlingconfig_includeRawStamps());
    }

    @Test
    public void sendReceiveImage_handling_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 183;
        int schedulers_default_nThreads = 59;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads));
        Assert.assertTrue((boolean)(item instanceof Image_handling_PeriodicTasks_GeneralConfigurationEvent));
        Image_handling_PeriodicTasks_GeneralConfigurationEvent item_ = (Image_handling_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
    }

    @Test
    public void sendReceiveImage_handling_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 633L;
        long heartbeat_taskPeriodMillis = 308L;
        long runtimeinfo_taskPeriodMillis = 447L;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Image_handling_PeriodicTasks_timersConfigurationEvent));
        Image_handling_PeriodicTasks_timersConfigurationEvent item_ = (Image_handling_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveImage_handling_StatusAggregator_GeneralConfigurationEvent() throws Exception {
        String version = "g";
        String patternConfigList = "";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_StatusAggregator_GeneralConfigurationEvent(version, patternConfigList));
        Assert.assertTrue((boolean)(item instanceof Image_handling_StatusAggregator_GeneralConfigurationEvent));
        Image_handling_StatusAggregator_GeneralConfigurationEvent item_ = (Image_handling_StatusAggregator_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)patternConfigList, (Object)item_.getPatternConfigList());
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_03_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.739416778087616;
        double warnLo = 0.3624539375305176;
        double limitHi = 0.693045f;
        double limitLo = 0.9182974100112915;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_CLP_RTD_03_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_03_LimitsConfigurationEvent));
        Mpm_CLP_RTD_03_LimitsConfigurationEvent item_ = (Mpm_CLP_RTD_03_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_05_LimitsConfigurationEvent() throws Exception {
        String version = "s";
        double warnHi = 0.3141111135482788;
        double warnLo = 0.3313976526260376;
        double limitHi = 0.1473794f;
        double limitLo = 8.808374404907227E-4;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_CLP_RTD_05_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_05_LimitsConfigurationEvent));
        Mpm_CLP_RTD_05_LimitsConfigurationEvent item_ = (Mpm_CLP_RTD_05_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_50_LimitsConfigurationEvent() throws Exception {
        String version = "v";
        double warnHi = 0.4579852223396301;
        double warnLo = 0.32413625717163086;
        double limitHi = 0.7355019450187683;
        double limitLo = 0.09186446666717529;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_CLP_RTD_50_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_50_LimitsConfigurationEvent));
        Mpm_CLP_RTD_50_LimitsConfigurationEvent item_ = (Mpm_CLP_RTD_50_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_55_LimitsConfigurationEvent() throws Exception {
        String version = "j";
        double warnHi = 0.8124096393585205;
        double warnLo = 0.4726234f;
        double limitHi = 0.5007706880569458;
        double limitLo = 0.14947772026062012;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_CLP_RTD_55_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_55_LimitsConfigurationEvent));
        Mpm_CLP_RTD_55_LimitsConfigurationEvent item_ = (Mpm_CLP_RTD_55_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_12_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.74300217628479;
        double warnLo = 0.05509376525878906;
        double limitHi = 0.9788369536399841;
        double limitLo = 0.9105919599533081;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_CYP_RTD_12_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_12_LimitsConfigurationEvent));
        Mpm_CYP_RTD_12_LimitsConfigurationEvent item_ = (Mpm_CYP_RTD_12_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_14_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.5323424935340881;
        double warnLo = 0.013417422771453857;
        double limitHi = 0.6976903676986694;
        double limitLo = 0.05334120988845825;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_CYP_RTD_14_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_14_LimitsConfigurationEvent));
        Mpm_CYP_RTD_14_LimitsConfigurationEvent item_ = (Mpm_CYP_RTD_14_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_31_LimitsConfigurationEvent() throws Exception {
        String version = "k";
        double warnHi = 0.35490357875823975;
        double warnLo = 0.7501116991043091;
        double limitHi = 0.5188309550285339;
        double limitLo = 0.22574901580810547;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_CYP_RTD_31_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_31_LimitsConfigurationEvent));
        Mpm_CYP_RTD_31_LimitsConfigurationEvent item_ = (Mpm_CYP_RTD_31_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_43_LimitsConfigurationEvent() throws Exception {
        String version = "d";
        double warnHi = 0.1245659f;
        double warnLo = 0.25287485122680664;
        double limitHi = 0.5429196357727051;
        double limitLo = 0.8264403343200684;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_CYP_RTD_43_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_43_LimitsConfigurationEvent));
        Mpm_CYP_RTD_43_LimitsConfigurationEvent item_ = (Mpm_CYP_RTD_43_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 12;
        int schedulers_default_nThreads = 488;
        int schedulers_monitor_update_publish_scheduler_nTasks = 562;
        int schedulers_monitor_update_publish_scheduler_nThreads = 955;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Mpm_PeriodicTasks_GeneralConfigurationEvent));
        Mpm_PeriodicTasks_GeneralConfigurationEvent item_ = (Mpm_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveMpm_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 397L;
        long heartbeat_taskPeriodMillis = 611L;
        long monitor_check_taskPeriodMillis = 52L;
        long monitor_publish_taskPeriodMillis = 989L;
        long monitor_update_taskPeriodMillis = 750L;
        long protection_state_taskPeriodMillis = 561L;
        long runtimeinfo_taskPeriodMillis = 891L;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, protection_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Mpm_PeriodicTasks_timersConfigurationEvent));
        Mpm_PeriodicTasks_timersConfigurationEvent item_ = (Mpm_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)protection_state_taskPeriodMillis, (long)item_.getProtection_state_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveMpm_Pluto_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_Pluto_DeviceConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Mpm_Pluto_DeviceConfigurationEvent));
        Mpm_Pluto_DeviceConfigurationEvent item_ = (Mpm_Pluto_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
    }

    @Test
    public void sendReceiveMpm_Pluto_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_Pluto_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Mpm_Pluto_DevicesConfigurationEvent));
        Mpm_Pluto_DevicesConfigurationEvent item_ = (Mpm_Pluto_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveFcs_Autochanger_autochangerConfigurationEvent() throws Exception {
        String version = "l";
        double autochangertrucks_adjustmentFactor = 0.452190637588501;
        int autochangertrucks_approachOnlinePosition = 439;
        int autochangertrucks_approachStandbyPosition = 725;
        int autochangertrucks_deltaPositionForAlignLenient = 317;
        int autochangertrucks_deltaPositionForAlignStrict = 599;
        int autochangertrucks_deltaPositionForAlignStrictLoader = 769;
        int autochangertrucks_deltaPreliminaryTargetPosition = 361;
        String autochangertrucks_driverSide = "s";
        int autochangertrucks_handoffPosition = 559;
        int autochangertrucks_highAcceleration = 536;
        int autochangertrucks_highDeceleration = 384;
        int autochangertrucks_highSpeed = 836;
        int autochangertrucks_lowAcceleration = 824;
        int autochangertrucks_lowDeceleration = 790;
        int autochangertrucks_lowSpeed = 622;
        int autochangertrucks_maxActualPositionValue = 879;
        int autochangertrucks_minActualPositionValue = 317;
        int autochangertrucks_minTargetPosition = 280;
        int autochangertrucks_naturalPosition = 853;
        int autochangertrucks_onlinePosition = 880;
        int autochangertrucks_positionRangeAtHandoff = 450;
        int autochangertrucks_positionRangeAtOnline = 371;
        int autochangertrucks_positionRangeAtStandby = 15;
        int autochangertrucks_positionRangeInTravel = 280;
        int autochangertrucks_prelimaryTargetPosition = 811;
        int autochangertrucks_proximitySensorInput = 185;
        int autochangertrucks_slowMotionPosition = 625;
        int autochangertrucks_standbyPosition = 336;
        int autochangertrucks_standbyPositionEmpty = 307;
        long autochangertrucks_timeoutForAlignFollower = 945L;
        long autochangertrucks_timeoutForTrucksMotion = 158L;
        double autochangertrucks_umax = 0.3649506f;
        double autochangertrucks_umin = 0.5733171105384827;
        double autochangertrucks_utarget = 0.8472592234611511;
        int latches_latchXminus_currentToOpen = 718;
        long latches_latchXminus_timeoutForLatchMotion = 883L;
        int latches_latchXplus_currentToOpen = 955;
        long latches_latchXplus_timeoutForLatchMotion = 500L;
        short onlineclamps_maxClosedStrain = 227;
        short onlineclamps_maxLockedStrain = 5;
        int onlineclamps_maxTimeToCloseClampsX = 995;
        int onlineclamps_maxTimeToLockAllClamps = 355;
        int onlineclamps_maxTimeToOpenClampsX = 364;
        int onlineclamps_maxTimeToUnlockAllClamps = 993;
        short onlineclamps_minLockedStrain = 777;
        int onlineclamps_minPeriod = 152;
        int onlineclamps_onlineClampXminus_currentToClamp = 514;
        int onlineclamps_onlineClampXminus_currentToOpen = 906;
        int onlineclamps_onlineClampXminus_deltaCurrent = 518;
        int onlineclamps_onlineClampXminus_finalCurrentToClose = 286;
        int onlineclamps_onlineClampXminus_incrementCurrentToClamp = 592;
        int onlineclamps_onlineClampXminus_incrementCurrentToClose = 710;
        int onlineclamps_onlineClampXminus_incrementCurrentToOpen = 128;
        int onlineclamps_onlineClampXminus_initialCurrentToClose = 230;
        int onlineclamps_onlineClampXminus_targetPositionToClose = 639;
        int onlineclamps_onlineClampXminus_targetPositionToOpen = 931;
        int onlineclamps_onlineClampXplus_currentToClamp = 507;
        int onlineclamps_onlineClampXplus_currentToOpen = 976;
        int onlineclamps_onlineClampXplus_deltaCurrent = 639;
        int onlineclamps_onlineClampXplus_finalCurrentToClose = 302;
        int onlineclamps_onlineClampXplus_incrementCurrentToClamp = 637;
        int onlineclamps_onlineClampXplus_incrementCurrentToClose = 814;
        int onlineclamps_onlineClampXplus_incrementCurrentToOpen = 2;
        int onlineclamps_onlineClampXplus_initialCurrentToClose = 873;
        int onlineclamps_onlineClampXplus_targetPositionToClose = 634;
        int onlineclamps_onlineClampXplus_targetPositionToOpen = 894;
        int onlineclamps_onlineClampYminus_currentToClamp = 387;
        int onlineclamps_onlineClampYminus_currentToOpen = 264;
        int onlineclamps_onlineClampYminus_deltaCurrent = 174;
        int onlineclamps_onlineClampYminus_finalCurrentToClose = 461;
        int onlineclamps_onlineClampYminus_incrementCurrentToClamp = 332;
        int onlineclamps_onlineClampYminus_incrementCurrentToClose = 881;
        int onlineclamps_onlineClampYminus_incrementCurrentToOpen = 177;
        int onlineclamps_onlineClampYminus_initialCurrentToClose = 586;
        int onlineclamps_onlineClampYminus_targetPositionToClose = 325;
        int onlineclamps_onlineClampYminus_targetPositionToOpen = 286;
        double onlineclamps_strainGain = 0.19408690929412842;
        int onlineclamps_timeoutForLockingClamps = 238;
        int onlineclamps_timeoutForUnlockingClamps = 624;
        long timeToUpdateProtectionSystem = 591L;
        int waitTimeForBrakeLR = 465;
        int waitTimeForBrakeOC = 334;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Autochanger_autochangerConfigurationEvent(version, autochangertrucks_adjustmentFactor, autochangertrucks_approachOnlinePosition, autochangertrucks_approachStandbyPosition, autochangertrucks_deltaPositionForAlignLenient, autochangertrucks_deltaPositionForAlignStrict, autochangertrucks_deltaPositionForAlignStrictLoader, autochangertrucks_deltaPreliminaryTargetPosition, autochangertrucks_driverSide, autochangertrucks_handoffPosition, autochangertrucks_highAcceleration, autochangertrucks_highDeceleration, autochangertrucks_highSpeed, autochangertrucks_lowAcceleration, autochangertrucks_lowDeceleration, autochangertrucks_lowSpeed, autochangertrucks_maxActualPositionValue, autochangertrucks_minActualPositionValue, autochangertrucks_minTargetPosition, autochangertrucks_naturalPosition, autochangertrucks_onlinePosition, autochangertrucks_positionRangeAtHandoff, autochangertrucks_positionRangeAtOnline, autochangertrucks_positionRangeAtStandby, autochangertrucks_positionRangeInTravel, autochangertrucks_prelimaryTargetPosition, autochangertrucks_proximitySensorInput, autochangertrucks_slowMotionPosition, autochangertrucks_standbyPosition, autochangertrucks_standbyPositionEmpty, autochangertrucks_timeoutForAlignFollower, autochangertrucks_timeoutForTrucksMotion, autochangertrucks_umax, autochangertrucks_umin, autochangertrucks_utarget, latches_latchXminus_currentToOpen, latches_latchXminus_timeoutForLatchMotion, latches_latchXplus_currentToOpen, latches_latchXplus_timeoutForLatchMotion, onlineclamps_maxClosedStrain, onlineclamps_maxLockedStrain, onlineclamps_maxTimeToCloseClampsX, onlineclamps_maxTimeToLockAllClamps, onlineclamps_maxTimeToOpenClampsX, onlineclamps_maxTimeToUnlockAllClamps, onlineclamps_minLockedStrain, onlineclamps_minPeriod, onlineclamps_onlineClampXminus_currentToClamp, onlineclamps_onlineClampXminus_currentToOpen, onlineclamps_onlineClampXminus_deltaCurrent, onlineclamps_onlineClampXminus_finalCurrentToClose, onlineclamps_onlineClampXminus_incrementCurrentToClamp, onlineclamps_onlineClampXminus_incrementCurrentToClose, onlineclamps_onlineClampXminus_incrementCurrentToOpen, onlineclamps_onlineClampXminus_initialCurrentToClose, onlineclamps_onlineClampXminus_targetPositionToClose, onlineclamps_onlineClampXminus_targetPositionToOpen, onlineclamps_onlineClampXplus_currentToClamp, onlineclamps_onlineClampXplus_currentToOpen, onlineclamps_onlineClampXplus_deltaCurrent, onlineclamps_onlineClampXplus_finalCurrentToClose, onlineclamps_onlineClampXplus_incrementCurrentToClamp, onlineclamps_onlineClampXplus_incrementCurrentToClose, onlineclamps_onlineClampXplus_incrementCurrentToOpen, onlineclamps_onlineClampXplus_initialCurrentToClose, onlineclamps_onlineClampXplus_targetPositionToClose, onlineclamps_onlineClampXplus_targetPositionToOpen, onlineclamps_onlineClampYminus_currentToClamp, onlineclamps_onlineClampYminus_currentToOpen, onlineclamps_onlineClampYminus_deltaCurrent, onlineclamps_onlineClampYminus_finalCurrentToClose, onlineclamps_onlineClampYminus_incrementCurrentToClamp, onlineclamps_onlineClampYminus_incrementCurrentToClose, onlineclamps_onlineClampYminus_incrementCurrentToOpen, onlineclamps_onlineClampYminus_initialCurrentToClose, onlineclamps_onlineClampYminus_targetPositionToClose, onlineclamps_onlineClampYminus_targetPositionToOpen, onlineclamps_strainGain, onlineclamps_timeoutForLockingClamps, onlineclamps_timeoutForUnlockingClamps, timeToUpdateProtectionSystem, waitTimeForBrakeLR, waitTimeForBrakeOC));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_autochangerConfigurationEvent));
        Fcs_Autochanger_autochangerConfigurationEvent item_ = (Fcs_Autochanger_autochangerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)autochangertrucks_adjustmentFactor, (double)item_.getAutochangertrucks_adjustmentFactor(), (double)1.0E-6f);
        Assert.assertEquals((long)autochangertrucks_approachOnlinePosition, (long)item_.getAutochangertrucks_approachOnlinePosition());
        Assert.assertEquals((long)autochangertrucks_approachStandbyPosition, (long)item_.getAutochangertrucks_approachStandbyPosition());
        Assert.assertEquals((long)autochangertrucks_deltaPositionForAlignLenient, (long)item_.getAutochangertrucks_deltaPositionForAlignLenient());
        Assert.assertEquals((long)autochangertrucks_deltaPositionForAlignStrict, (long)item_.getAutochangertrucks_deltaPositionForAlignStrict());
        Assert.assertEquals((long)autochangertrucks_deltaPositionForAlignStrictLoader, (long)item_.getAutochangertrucks_deltaPositionForAlignStrictLoader());
        Assert.assertEquals((long)autochangertrucks_deltaPreliminaryTargetPosition, (long)item_.getAutochangertrucks_deltaPreliminaryTargetPosition());
        Assert.assertEquals((Object)autochangertrucks_driverSide, (Object)item_.getAutochangertrucks_driverSide());
        Assert.assertEquals((long)autochangertrucks_handoffPosition, (long)item_.getAutochangertrucks_handoffPosition());
        Assert.assertEquals((long)autochangertrucks_highAcceleration, (long)item_.getAutochangertrucks_highAcceleration());
        Assert.assertEquals((long)autochangertrucks_highDeceleration, (long)item_.getAutochangertrucks_highDeceleration());
        Assert.assertEquals((long)autochangertrucks_highSpeed, (long)item_.getAutochangertrucks_highSpeed());
        Assert.assertEquals((long)autochangertrucks_lowAcceleration, (long)item_.getAutochangertrucks_lowAcceleration());
        Assert.assertEquals((long)autochangertrucks_lowDeceleration, (long)item_.getAutochangertrucks_lowDeceleration());
        Assert.assertEquals((long)autochangertrucks_lowSpeed, (long)item_.getAutochangertrucks_lowSpeed());
        Assert.assertEquals((long)autochangertrucks_maxActualPositionValue, (long)item_.getAutochangertrucks_maxActualPositionValue());
        Assert.assertEquals((long)autochangertrucks_minActualPositionValue, (long)item_.getAutochangertrucks_minActualPositionValue());
        Assert.assertEquals((long)autochangertrucks_minTargetPosition, (long)item_.getAutochangertrucks_minTargetPosition());
        Assert.assertEquals((long)autochangertrucks_naturalPosition, (long)item_.getAutochangertrucks_naturalPosition());
        Assert.assertEquals((long)autochangertrucks_onlinePosition, (long)item_.getAutochangertrucks_onlinePosition());
        Assert.assertEquals((long)autochangertrucks_positionRangeAtHandoff, (long)item_.getAutochangertrucks_positionRangeAtHandoff());
        Assert.assertEquals((long)autochangertrucks_positionRangeAtOnline, (long)item_.getAutochangertrucks_positionRangeAtOnline());
        Assert.assertEquals((long)autochangertrucks_positionRangeAtStandby, (long)item_.getAutochangertrucks_positionRangeAtStandby());
        Assert.assertEquals((long)autochangertrucks_positionRangeInTravel, (long)item_.getAutochangertrucks_positionRangeInTravel());
        Assert.assertEquals((long)autochangertrucks_prelimaryTargetPosition, (long)item_.getAutochangertrucks_prelimaryTargetPosition());
        Assert.assertEquals((long)autochangertrucks_proximitySensorInput, (long)item_.getAutochangertrucks_proximitySensorInput());
        Assert.assertEquals((long)autochangertrucks_slowMotionPosition, (long)item_.getAutochangertrucks_slowMotionPosition());
        Assert.assertEquals((long)autochangertrucks_standbyPosition, (long)item_.getAutochangertrucks_standbyPosition());
        Assert.assertEquals((long)autochangertrucks_standbyPositionEmpty, (long)item_.getAutochangertrucks_standbyPositionEmpty());
        Assert.assertEquals((long)autochangertrucks_timeoutForAlignFollower, (long)item_.getAutochangertrucks_timeoutForAlignFollower());
        Assert.assertEquals((long)autochangertrucks_timeoutForTrucksMotion, (long)item_.getAutochangertrucks_timeoutForTrucksMotion());
        Assert.assertEquals((double)autochangertrucks_umax, (double)item_.getAutochangertrucks_umax(), (double)1.0E-6f);
        Assert.assertEquals((double)autochangertrucks_umin, (double)item_.getAutochangertrucks_umin(), (double)1.0E-6f);
        Assert.assertEquals((double)autochangertrucks_utarget, (double)item_.getAutochangertrucks_utarget(), (double)1.0E-6f);
        Assert.assertEquals((long)latches_latchXminus_currentToOpen, (long)item_.getLatches_latchXminus_currentToOpen());
        Assert.assertEquals((long)latches_latchXminus_timeoutForLatchMotion, (long)item_.getLatches_latchXminus_timeoutForLatchMotion());
        Assert.assertEquals((long)latches_latchXplus_currentToOpen, (long)item_.getLatches_latchXplus_currentToOpen());
        Assert.assertEquals((long)latches_latchXplus_timeoutForLatchMotion, (long)item_.getLatches_latchXplus_timeoutForLatchMotion());
        Assert.assertEquals((long)onlineclamps_maxClosedStrain, (long)item_.getOnlineclamps_maxClosedStrain());
        Assert.assertEquals((long)onlineclamps_maxLockedStrain, (long)item_.getOnlineclamps_maxLockedStrain());
        Assert.assertEquals((long)onlineclamps_maxTimeToCloseClampsX, (long)item_.getOnlineclamps_maxTimeToCloseClampsX());
        Assert.assertEquals((long)onlineclamps_maxTimeToLockAllClamps, (long)item_.getOnlineclamps_maxTimeToLockAllClamps());
        Assert.assertEquals((long)onlineclamps_maxTimeToOpenClampsX, (long)item_.getOnlineclamps_maxTimeToOpenClampsX());
        Assert.assertEquals((long)onlineclamps_maxTimeToUnlockAllClamps, (long)item_.getOnlineclamps_maxTimeToUnlockAllClamps());
        Assert.assertEquals((long)onlineclamps_minLockedStrain, (long)item_.getOnlineclamps_minLockedStrain());
        Assert.assertEquals((long)onlineclamps_minPeriod, (long)item_.getOnlineclamps_minPeriod());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_currentToClamp, (long)item_.getOnlineclamps_onlineClampXminus_currentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_currentToOpen, (long)item_.getOnlineclamps_onlineClampXminus_currentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_deltaCurrent, (long)item_.getOnlineclamps_onlineClampXminus_deltaCurrent());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_finalCurrentToClose, (long)item_.getOnlineclamps_onlineClampXminus_finalCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_incrementCurrentToClamp, (long)item_.getOnlineclamps_onlineClampXminus_incrementCurrentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_incrementCurrentToClose, (long)item_.getOnlineclamps_onlineClampXminus_incrementCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_incrementCurrentToOpen, (long)item_.getOnlineclamps_onlineClampXminus_incrementCurrentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_initialCurrentToClose, (long)item_.getOnlineclamps_onlineClampXminus_initialCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_targetPositionToClose, (long)item_.getOnlineclamps_onlineClampXminus_targetPositionToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_targetPositionToOpen, (long)item_.getOnlineclamps_onlineClampXminus_targetPositionToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_currentToClamp, (long)item_.getOnlineclamps_onlineClampXplus_currentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_currentToOpen, (long)item_.getOnlineclamps_onlineClampXplus_currentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_deltaCurrent, (long)item_.getOnlineclamps_onlineClampXplus_deltaCurrent());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_finalCurrentToClose, (long)item_.getOnlineclamps_onlineClampXplus_finalCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_incrementCurrentToClamp, (long)item_.getOnlineclamps_onlineClampXplus_incrementCurrentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_incrementCurrentToClose, (long)item_.getOnlineclamps_onlineClampXplus_incrementCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_incrementCurrentToOpen, (long)item_.getOnlineclamps_onlineClampXplus_incrementCurrentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_initialCurrentToClose, (long)item_.getOnlineclamps_onlineClampXplus_initialCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_targetPositionToClose, (long)item_.getOnlineclamps_onlineClampXplus_targetPositionToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_targetPositionToOpen, (long)item_.getOnlineclamps_onlineClampXplus_targetPositionToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_currentToClamp, (long)item_.getOnlineclamps_onlineClampYminus_currentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_currentToOpen, (long)item_.getOnlineclamps_onlineClampYminus_currentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_deltaCurrent, (long)item_.getOnlineclamps_onlineClampYminus_deltaCurrent());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_finalCurrentToClose, (long)item_.getOnlineclamps_onlineClampYminus_finalCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_incrementCurrentToClamp, (long)item_.getOnlineclamps_onlineClampYminus_incrementCurrentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_incrementCurrentToClose, (long)item_.getOnlineclamps_onlineClampYminus_incrementCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_incrementCurrentToOpen, (long)item_.getOnlineclamps_onlineClampYminus_incrementCurrentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_initialCurrentToClose, (long)item_.getOnlineclamps_onlineClampYminus_initialCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_targetPositionToClose, (long)item_.getOnlineclamps_onlineClampYminus_targetPositionToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_targetPositionToOpen, (long)item_.getOnlineclamps_onlineClampYminus_targetPositionToOpen());
        Assert.assertEquals((double)onlineclamps_strainGain, (double)item_.getOnlineclamps_strainGain(), (double)1.0E-6f);
        Assert.assertEquals((long)onlineclamps_timeoutForLockingClamps, (long)item_.getOnlineclamps_timeoutForLockingClamps());
        Assert.assertEquals((long)onlineclamps_timeoutForUnlockingClamps, (long)item_.getOnlineclamps_timeoutForUnlockingClamps());
        Assert.assertEquals((long)timeToUpdateProtectionSystem, (long)item_.getTimeToUpdateProtectionSystem());
        Assert.assertEquals((long)waitTimeForBrakeLR, (long)item_.getWaitTimeForBrakeLR());
        Assert.assertEquals((long)waitTimeForBrakeOC, (long)item_.getWaitTimeForBrakeOC());
    }

    @Test
    public void sendReceiveFcs_Autochanger_readRateConfigurationEvent() throws Exception {
        String version = "";
        int autochangertrucks_readSensorsRate = 488;
        int latches_latchXminus_readSensorsRate = 513;
        int latches_latchXplus_readSensorsRate = 218;
        int onlineclamps_onlineClampXminus_readSensorsRate = 18;
        int onlineclamps_onlineClampXplus_readSensorsRate = 549;
        int onlineclamps_onlineClampYminus_readSensorsRate = 72;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Autochanger_readRateConfigurationEvent(version, autochangertrucks_readSensorsRate, latches_latchXminus_readSensorsRate, latches_latchXplus_readSensorsRate, onlineclamps_onlineClampXminus_readSensorsRate, onlineclamps_onlineClampXplus_readSensorsRate, onlineclamps_onlineClampYminus_readSensorsRate));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_readRateConfigurationEvent));
        Fcs_Autochanger_readRateConfigurationEvent item_ = (Fcs_Autochanger_readRateConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)autochangertrucks_readSensorsRate, (long)item_.getAutochangertrucks_readSensorsRate());
        Assert.assertEquals((long)latches_latchXminus_readSensorsRate, (long)item_.getLatches_latchXminus_readSensorsRate());
        Assert.assertEquals((long)latches_latchXplus_readSensorsRate, (long)item_.getLatches_latchXplus_readSensorsRate());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_readSensorsRate, (long)item_.getOnlineclamps_onlineClampXminus_readSensorsRate());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_readSensorsRate, (long)item_.getOnlineclamps_onlineClampXplus_readSensorsRate());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_readSensorsRate, (long)item_.getOnlineclamps_onlineClampYminus_readSensorsRate());
    }

    @Test
    public void sendReceiveFcs_Autochanger_sensorConfigurationEvent() throws Exception {
        String version = "k";
        int autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_byteNumero = 758;
        String autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_dioName = "k";
        int autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_inputNumero = 43;
        int autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_byteNumero = 659;
        String autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_dioName = "r";
        int autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_inputNumero = 272;
        int autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_byteNumero = 245;
        String autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_dioName = "";
        int autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_inputNumero = 649;
        int autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_byteNumero = 26;
        String autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_dioName = "";
        int autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_inputNumero = 573;
        int autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_byteNumero = 76;
        String autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_dioName = "";
        int autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_inputNumero = 262;
        int autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_byteNumero = 189;
        String autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_dioName = "r";
        int autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_inputNumero = 915;
        int autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_byteNumero = 924;
        String autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_dioName = "o";
        int autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_inputNumero = 372;
        int autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_byteNumero = 850;
        String autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_dioName = "";
        int autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_inputNumero = 900;
        int autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_byteNumero = 42;
        String autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_dioName = "";
        int autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_inputNumero = 775;
        int autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_byteNumero = 141;
        String autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_dioName = "";
        int autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_inputNumero = 265;
        int autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_byteNumero = 239;
        String autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_dioName = "b";
        int autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_inputNumero = 329;
        int autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_byteNumero = 369;
        String autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_dioName = "g";
        int autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_inputNumero = 856;
        int latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_byteNumero = 988;
        String latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_dioName = "";
        int latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_inputNumero = 320;
        int latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_byteNumero = 778;
        String latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_dioName = "";
        int latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_inputNumero = 886;
        int latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_byteNumero = 622;
        String latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_dioName = "";
        int latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_inputNumero = 454;
        int latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_byteNumero = 545;
        String latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_dioName = "";
        int latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_inputNumero = 994;
        int latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_byteNumero = 526;
        String latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_dioName = "q";
        int latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_inputNumero = 838;
        int latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_byteNumero = 189;
        String latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_dioName = "i";
        int latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_inputNumero = 708;
        int latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_byteNumero = 952;
        String latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_dioName = "";
        int latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_inputNumero = 467;
        int latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_byteNumero = 204;
        String latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_dioName = "";
        int latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_inputNumero = 79;
        int latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_byteNumero = 803;
        String latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_dioName = "";
        int latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_inputNumero = 63;
        int latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_byteNumero = 828;
        String latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_dioName = "u";
        int latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_inputNumero = 362;
        int latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_byteNumero = 748;
        String latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_dioName = "a";
        int latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_inputNumero = 771;
        int latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_byteNumero = 839;
        String latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_dioName = "c";
        int latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_inputNumero = 312;
        int onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_byteNumero = 372;
        String onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_dioName = "";
        int onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_inputNumero = 15;
        int onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_byteNumero = 958;
        String onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_dioName = "";
        int onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_inputNumero = 420;
        int onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_byteNumero = 18;
        String onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_dioName = "";
        int onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_inputNumero = 52;
        int onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_byteNumero = 998;
        String onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_dioName = "a";
        int onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_inputNumero = 231;
        int onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_byteNumero = 16;
        String onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_dioName = "i";
        int onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_inputNumero = 530;
        int onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_byteNumero = 881;
        String onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_dioName = "";
        int onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_inputNumero = 389;
        int onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_byteNumero = 219;
        String onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_dioName = "";
        int onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_inputNumero = 369;
        int onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_byteNumero = 630;
        String onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_dioName = "";
        int onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_inputNumero = 196;
        int onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_byteNumero = 284;
        String onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_dioName = "t";
        int onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_inputNumero = 156;
        int onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_byteNumero = 249;
        String onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_dioName = "";
        int onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_inputNumero = 809;
        int onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_byteNumero = 114;
        String onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_dioName = "q";
        int onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_inputNumero = 219;
        int onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_byteNumero = 146;
        String onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_dioName = "w";
        int onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_inputNumero = 226;
        int plc_OUT_AF0_Sensors_OUT_AF0_C_byteNumero = 732;
        String plc_OUT_AF0_Sensors_OUT_AF0_C_dioName = "g";
        int plc_OUT_AF0_Sensors_OUT_AF0_C_inputNumero = 409;
        int plc_OUT_AF0_Sensors_OUT_AF0_byteNumero = 726;
        String plc_OUT_AF0_Sensors_OUT_AF0_dioName = "";
        int plc_OUT_AF0_Sensors_OUT_AF0_inputNumero = 451;
        int plc_OUT_AF1_Sensors_OUT_AF1_C_byteNumero = 722;
        String plc_OUT_AF1_Sensors_OUT_AF1_C_dioName = "";
        int plc_OUT_AF1_Sensors_OUT_AF1_C_inputNumero = 399;
        int plc_OUT_AF1_Sensors_OUT_AF1_byteNumero = 168;
        String plc_OUT_AF1_Sensors_OUT_AF1_dioName = "";
        int plc_OUT_AF1_Sensors_OUT_AF1_inputNumero = 713;
        int plc_OUT_AF3_Sensors_OUT_AF3_C_byteNumero = 784;
        String plc_OUT_AF3_Sensors_OUT_AF3_C_dioName = "";
        int plc_OUT_AF3_Sensors_OUT_AF3_C_inputNumero = 801;
        int plc_OUT_AF3_Sensors_OUT_AF3_byteNumero = 61;
        String plc_OUT_AF3_Sensors_OUT_AF3_dioName = "";
        int plc_OUT_AF3_Sensors_OUT_AF3_inputNumero = 359;
        int plc_OUT_AIN_byteNumero = 813;
        String plc_OUT_AIN_dioName = "";
        int plc_OUT_AIN_inputNumero = 661;
        int plc_OUT_AOL_byteNumero = 219;
        String plc_OUT_AOL_dioName = "i";
        int plc_OUT_AOL_inputNumero = 743;
        int plc_OUT_AP1_Sensors_OUT_AP1_C_byteNumero = 808;
        String plc_OUT_AP1_Sensors_OUT_AP1_C_dioName = "";
        int plc_OUT_AP1_Sensors_OUT_AP1_C_inputNumero = 279;
        int plc_OUT_AP1_Sensors_OUT_AP1_byteNumero = 81;
        String plc_OUT_AP1_Sensors_OUT_AP1_dioName = "";
        int plc_OUT_AP1_Sensors_OUT_AP1_inputNumero = 127;
        int plc_OUT_AP2_Sensors_OUT_AP2_C_byteNumero = 950;
        String plc_OUT_AP2_Sensors_OUT_AP2_C_dioName = "f";
        int plc_OUT_AP2_Sensors_OUT_AP2_C_inputNumero = 87;
        int plc_OUT_AP2_Sensors_OUT_AP2_byteNumero = 602;
        String plc_OUT_AP2_Sensors_OUT_AP2_dioName = "o";
        int plc_OUT_AP2_Sensors_OUT_AP2_inputNumero = 705;
        int plc_OUT_AP3_Sensors_OUT_AP3_C_byteNumero = 78;
        String plc_OUT_AP3_Sensors_OUT_AP3_C_dioName = "";
        int plc_OUT_AP3_Sensors_OUT_AP3_C_inputNumero = 291;
        int plc_OUT_AP3_Sensors_OUT_AP3_byteNumero = 876;
        String plc_OUT_AP3_Sensors_OUT_AP3_dioName = "";
        int plc_OUT_AP3_Sensors_OUT_AP3_inputNumero = 528;
        int plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_byteNumero = 205;
        String plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_dioName = "";
        int plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_inputNumero = 164;
        int plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_byteNumero = 446;
        String plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_dioName = "r";
        int plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_inputNumero = 818;
        int plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_byteNumero = 659;
        String plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_dioName = "";
        int plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_inputNumero = 232;
        int plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_byteNumero = 660;
        String plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_dioName = "l";
        int plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_inputNumero = 594;
        int plc_carousel_CF0Sensors_carousel_CF0_C_byteNumero = 722;
        String plc_carousel_CF0Sensors_carousel_CF0_C_dioName = "w";
        int plc_carousel_CF0Sensors_carousel_CF0_C_inputNumero = 158;
        int plc_carousel_CF0Sensors_carousel_CF0_byteNumero = 558;
        String plc_carousel_CF0Sensors_carousel_CF0_dioName = "a";
        int plc_carousel_CF0Sensors_carousel_CF0_inputNumero = 692;
        int plc_carousel_CF1Sensors_carousel_CF1_C_byteNumero = 288;
        String plc_carousel_CF1Sensors_carousel_CF1_C_dioName = "";
        int plc_carousel_CF1Sensors_carousel_CF1_C_inputNumero = 827;
        int plc_carousel_CF1Sensors_carousel_CF1_byteNumero = 260;
        String plc_carousel_CF1Sensors_carousel_CF1_dioName = "k";
        int plc_carousel_CF1Sensors_carousel_CF1_inputNumero = 274;
        int plc_inclinometerXminus_byteNumero = 152;
        String plc_inclinometerXminus_deviceName = "";
        int plc_inclinometerXplus_byteNumero = 710;
        String plc_inclinometerXplus_deviceName = "h";
        int plc_loaderConnectedSensors_loaderConnectedSensorC_byteNumero = 428;
        String plc_loaderConnectedSensors_loaderConnectedSensorC_dioName = "";
        int plc_loaderConnectedSensors_loaderConnectedSensorC_inputNumero = 857;
        int plc_loaderConnectedSensors_loaderConnectedSensor_byteNumero = 991;
        String plc_loaderConnectedSensors_loaderConnectedSensor_dioName = "";
        int plc_loaderConnectedSensors_loaderConnectedSensor_inputNumero = 536;
        int plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_byteNumero = 221;
        String plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_dioName = "u";
        int plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_inputNumero = 402;
        int plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_byteNumero = 652;
        String plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_dioName = "d";
        int plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_inputNumero = 197;
        int plc_loaderPresenceSensors_presenceLoader_C_byteNumero = 504;
        String plc_loaderPresenceSensors_presenceLoader_C_dioName = "";
        int plc_loaderPresenceSensors_presenceLoader_C_inputNumero = 530;
        int plc_loaderPresenceSensors_presenceLoader_byteNumero = 975;
        String plc_loaderPresenceSensors_presenceLoader_dioName = "";
        int plc_loaderPresenceSensors_presenceLoader_inputNumero = 420;
        int plc_lockOutSensors_lockOut_C_byteNumero = 548;
        String plc_lockOutSensors_lockOut_C_dioName = "";
        int plc_lockOutSensors_lockOut_C_inputNumero = 967;
        int plc_lockOutSensors_lockOut_byteNumero = 934;
        String plc_lockOutSensors_lockOut_dioName = "";
        int plc_lockOutSensors_lockOut_inputNumero = 694;
        int plc_lockOutShunt_byteNumero = 458;
        String plc_lockOutShunt_dioName = "";
        int plc_lockOutShunt_inputNumero = 390;
        int plc_lpmEngineeringKeySensors_engineeringKey_C_byteNumero = 501;
        String plc_lpmEngineeringKeySensors_engineeringKey_C_dioName = "";
        int plc_lpmEngineeringKeySensors_engineeringKey_C_inputNumero = 737;
        int plc_lpmEngineeringKeySensors_engineeringKey_byteNumero = 249;
        String plc_lpmEngineeringKeySensors_engineeringKey_dioName = "u";
        int plc_lpmEngineeringKeySensors_engineeringKey_inputNumero = 314;
        int plc_lpmLatchesStatus_byteNumero = 774;
        String plc_lpmLatchesStatus_dioName = "";
        int plc_lpmLatchesStatus_inputNumero = 283;
        int plc_lpmLinearRail1Status_byteNumero = 711;
        String plc_lpmLinearRail1Status_dioName = "k";
        int plc_lpmLinearRail1Status_inputNumero = 136;
        int plc_lpmLinearRail2Status_byteNumero = 562;
        String plc_lpmLinearRail2Status_dioName = "d";
        int plc_lpmLinearRail2Status_inputNumero = 83;
        int plc_lpmOnlineClampsStatus_byteNumero = 78;
        String plc_lpmOnlineClampsStatus_dioName = "p";
        int plc_lpmOnlineClampsStatus_inputNumero = 913;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Autochanger_sensorConfigurationEvent(version, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_byteNumero, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_dioName, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_inputNumero, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_byteNumero, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_dioName, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_inputNumero, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_byteNumero, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_dioName, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_inputNumero, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_byteNumero, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_dioName, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_inputNumero, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_byteNumero, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_dioName, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_inputNumero, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_byteNumero, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_dioName, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_inputNumero, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_byteNumero, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_dioName, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_inputNumero, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_byteNumero, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_dioName, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_inputNumero, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_byteNumero, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_dioName, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_inputNumero, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_byteNumero, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_dioName, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_inputNumero, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_byteNumero, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_dioName, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_inputNumero, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_byteNumero, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_dioName, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_inputNumero, latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_byteNumero, latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_dioName, latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_inputNumero, latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_byteNumero, latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_dioName, latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_inputNumero, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_byteNumero, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_dioName, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_inputNumero, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_byteNumero, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_dioName, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_inputNumero, latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_byteNumero, latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_dioName, latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_inputNumero, latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_byteNumero, latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_dioName, latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_inputNumero, latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_byteNumero, latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_dioName, latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_inputNumero, latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_byteNumero, latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_dioName, latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_inputNumero, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_byteNumero, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_dioName, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_inputNumero, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_byteNumero, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_dioName, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_inputNumero, latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_byteNumero, latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_dioName, latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_inputNumero, latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_byteNumero, latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_dioName, latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_inputNumero, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_byteNumero, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_dioName, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_inputNumero, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_byteNumero, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_dioName, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_inputNumero, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_byteNumero, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_dioName, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_inputNumero, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_byteNumero, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_dioName, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_inputNumero, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_byteNumero, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_dioName, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_inputNumero, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_byteNumero, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_dioName, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_inputNumero, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_byteNumero, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_dioName, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_inputNumero, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_byteNumero, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_dioName, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_inputNumero, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_byteNumero, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_dioName, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_inputNumero, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_byteNumero, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_dioName, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_inputNumero, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_byteNumero, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_dioName, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_inputNumero, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_byteNumero, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_dioName, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_inputNumero, plc_OUT_AF0_Sensors_OUT_AF0_C_byteNumero, plc_OUT_AF0_Sensors_OUT_AF0_C_dioName, plc_OUT_AF0_Sensors_OUT_AF0_C_inputNumero, plc_OUT_AF0_Sensors_OUT_AF0_byteNumero, plc_OUT_AF0_Sensors_OUT_AF0_dioName, plc_OUT_AF0_Sensors_OUT_AF0_inputNumero, plc_OUT_AF1_Sensors_OUT_AF1_C_byteNumero, plc_OUT_AF1_Sensors_OUT_AF1_C_dioName, plc_OUT_AF1_Sensors_OUT_AF1_C_inputNumero, plc_OUT_AF1_Sensors_OUT_AF1_byteNumero, plc_OUT_AF1_Sensors_OUT_AF1_dioName, plc_OUT_AF1_Sensors_OUT_AF1_inputNumero, plc_OUT_AF3_Sensors_OUT_AF3_C_byteNumero, plc_OUT_AF3_Sensors_OUT_AF3_C_dioName, plc_OUT_AF3_Sensors_OUT_AF3_C_inputNumero, plc_OUT_AF3_Sensors_OUT_AF3_byteNumero, plc_OUT_AF3_Sensors_OUT_AF3_dioName, plc_OUT_AF3_Sensors_OUT_AF3_inputNumero, plc_OUT_AIN_byteNumero, plc_OUT_AIN_dioName, plc_OUT_AIN_inputNumero, plc_OUT_AOL_byteNumero, plc_OUT_AOL_dioName, plc_OUT_AOL_inputNumero, plc_OUT_AP1_Sensors_OUT_AP1_C_byteNumero, plc_OUT_AP1_Sensors_OUT_AP1_C_dioName, plc_OUT_AP1_Sensors_OUT_AP1_C_inputNumero, plc_OUT_AP1_Sensors_OUT_AP1_byteNumero, plc_OUT_AP1_Sensors_OUT_AP1_dioName, plc_OUT_AP1_Sensors_OUT_AP1_inputNumero, plc_OUT_AP2_Sensors_OUT_AP2_C_byteNumero, plc_OUT_AP2_Sensors_OUT_AP2_C_dioName, plc_OUT_AP2_Sensors_OUT_AP2_C_inputNumero, plc_OUT_AP2_Sensors_OUT_AP2_byteNumero, plc_OUT_AP2_Sensors_OUT_AP2_dioName, plc_OUT_AP2_Sensors_OUT_AP2_inputNumero, plc_OUT_AP3_Sensors_OUT_AP3_C_byteNumero, plc_OUT_AP3_Sensors_OUT_AP3_C_dioName, plc_OUT_AP3_Sensors_OUT_AP3_C_inputNumero, plc_OUT_AP3_Sensors_OUT_AP3_byteNumero, plc_OUT_AP3_Sensors_OUT_AP3_dioName, plc_OUT_AP3_Sensors_OUT_AP3_inputNumero, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_byteNumero, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_dioName, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_inputNumero, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_byteNumero, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_dioName, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_inputNumero, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_byteNumero, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_dioName, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_inputNumero, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_byteNumero, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_dioName, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_inputNumero, plc_carousel_CF0Sensors_carousel_CF0_C_byteNumero, plc_carousel_CF0Sensors_carousel_CF0_C_dioName, plc_carousel_CF0Sensors_carousel_CF0_C_inputNumero, plc_carousel_CF0Sensors_carousel_CF0_byteNumero, plc_carousel_CF0Sensors_carousel_CF0_dioName, plc_carousel_CF0Sensors_carousel_CF0_inputNumero, plc_carousel_CF1Sensors_carousel_CF1_C_byteNumero, plc_carousel_CF1Sensors_carousel_CF1_C_dioName, plc_carousel_CF1Sensors_carousel_CF1_C_inputNumero, plc_carousel_CF1Sensors_carousel_CF1_byteNumero, plc_carousel_CF1Sensors_carousel_CF1_dioName, plc_carousel_CF1Sensors_carousel_CF1_inputNumero, plc_inclinometerXminus_byteNumero, plc_inclinometerXminus_deviceName, plc_inclinometerXplus_byteNumero, plc_inclinometerXplus_deviceName, plc_loaderConnectedSensors_loaderConnectedSensorC_byteNumero, plc_loaderConnectedSensors_loaderConnectedSensorC_dioName, plc_loaderConnectedSensors_loaderConnectedSensorC_inputNumero, plc_loaderConnectedSensors_loaderConnectedSensor_byteNumero, plc_loaderConnectedSensors_loaderConnectedSensor_dioName, plc_loaderConnectedSensors_loaderConnectedSensor_inputNumero, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_byteNumero, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_dioName, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_inputNumero, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_byteNumero, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_dioName, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_inputNumero, plc_loaderPresenceSensors_presenceLoader_C_byteNumero, plc_loaderPresenceSensors_presenceLoader_C_dioName, plc_loaderPresenceSensors_presenceLoader_C_inputNumero, plc_loaderPresenceSensors_presenceLoader_byteNumero, plc_loaderPresenceSensors_presenceLoader_dioName, plc_loaderPresenceSensors_presenceLoader_inputNumero, plc_lockOutSensors_lockOut_C_byteNumero, plc_lockOutSensors_lockOut_C_dioName, plc_lockOutSensors_lockOut_C_inputNumero, plc_lockOutSensors_lockOut_byteNumero, plc_lockOutSensors_lockOut_dioName, plc_lockOutSensors_lockOut_inputNumero, plc_lockOutShunt_byteNumero, plc_lockOutShunt_dioName, plc_lockOutShunt_inputNumero, plc_lpmEngineeringKeySensors_engineeringKey_C_byteNumero, plc_lpmEngineeringKeySensors_engineeringKey_C_dioName, plc_lpmEngineeringKeySensors_engineeringKey_C_inputNumero, plc_lpmEngineeringKeySensors_engineeringKey_byteNumero, plc_lpmEngineeringKeySensors_engineeringKey_dioName, plc_lpmEngineeringKeySensors_engineeringKey_inputNumero, plc_lpmLatchesStatus_byteNumero, plc_lpmLatchesStatus_dioName, plc_lpmLatchesStatus_inputNumero, plc_lpmLinearRail1Status_byteNumero, plc_lpmLinearRail1Status_dioName, plc_lpmLinearRail1Status_inputNumero, plc_lpmLinearRail2Status_byteNumero, plc_lpmLinearRail2Status_dioName, plc_lpmLinearRail2Status_inputNumero, plc_lpmOnlineClampsStatus_byteNumero, plc_lpmOnlineClampsStatus_dioName, plc_lpmOnlineClampsStatus_inputNumero));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_sensorConfigurationEvent));
        Fcs_Autochanger_sensorConfigurationEvent item_ = (Fcs_Autochanger_sensorConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_dioName, (Object)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_dioName, (Object)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_dioName, (Object)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_dioName, (Object)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_dioName, (Object)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_dioName, (Object)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_dioName, (Object)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_dioName, (Object)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_dioName, (Object)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_dioName, (Object)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_dioName, (Object)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_dioName, (Object)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_dioName, (Object)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_dioName, (Object)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_dioName, (Object)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_dioName, (Object)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_dioName, (Object)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_dioName, (Object)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF0_Sensors_OUT_AF0_C_byteNumero, (long)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF0_Sensors_OUT_AF0_C_dioName, (Object)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_C_dioName());
        Assert.assertEquals((long)plc_OUT_AF0_Sensors_OUT_AF0_C_inputNumero, (long)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF0_Sensors_OUT_AF0_byteNumero, (long)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF0_Sensors_OUT_AF0_dioName, (Object)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_dioName());
        Assert.assertEquals((long)plc_OUT_AF0_Sensors_OUT_AF0_inputNumero, (long)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF1_Sensors_OUT_AF1_C_byteNumero, (long)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF1_Sensors_OUT_AF1_C_dioName, (Object)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_C_dioName());
        Assert.assertEquals((long)plc_OUT_AF1_Sensors_OUT_AF1_C_inputNumero, (long)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF1_Sensors_OUT_AF1_byteNumero, (long)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF1_Sensors_OUT_AF1_dioName, (Object)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_dioName());
        Assert.assertEquals((long)plc_OUT_AF1_Sensors_OUT_AF1_inputNumero, (long)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF3_Sensors_OUT_AF3_C_byteNumero, (long)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF3_Sensors_OUT_AF3_C_dioName, (Object)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_C_dioName());
        Assert.assertEquals((long)plc_OUT_AF3_Sensors_OUT_AF3_C_inputNumero, (long)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF3_Sensors_OUT_AF3_byteNumero, (long)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF3_Sensors_OUT_AF3_dioName, (Object)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_dioName());
        Assert.assertEquals((long)plc_OUT_AF3_Sensors_OUT_AF3_inputNumero, (long)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_inputNumero());
        Assert.assertEquals((long)plc_OUT_AIN_byteNumero, (long)item_.getPlc_OUT_AIN_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AIN_dioName, (Object)item_.getPlc_OUT_AIN_dioName());
        Assert.assertEquals((long)plc_OUT_AIN_inputNumero, (long)item_.getPlc_OUT_AIN_inputNumero());
        Assert.assertEquals((long)plc_OUT_AOL_byteNumero, (long)item_.getPlc_OUT_AOL_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AOL_dioName, (Object)item_.getPlc_OUT_AOL_dioName());
        Assert.assertEquals((long)plc_OUT_AOL_inputNumero, (long)item_.getPlc_OUT_AOL_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP1_Sensors_OUT_AP1_C_byteNumero, (long)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP1_Sensors_OUT_AP1_C_dioName, (Object)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_C_dioName());
        Assert.assertEquals((long)plc_OUT_AP1_Sensors_OUT_AP1_C_inputNumero, (long)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP1_Sensors_OUT_AP1_byteNumero, (long)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP1_Sensors_OUT_AP1_dioName, (Object)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_dioName());
        Assert.assertEquals((long)plc_OUT_AP1_Sensors_OUT_AP1_inputNumero, (long)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP2_Sensors_OUT_AP2_C_byteNumero, (long)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP2_Sensors_OUT_AP2_C_dioName, (Object)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_C_dioName());
        Assert.assertEquals((long)plc_OUT_AP2_Sensors_OUT_AP2_C_inputNumero, (long)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP2_Sensors_OUT_AP2_byteNumero, (long)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP2_Sensors_OUT_AP2_dioName, (Object)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_dioName());
        Assert.assertEquals((long)plc_OUT_AP2_Sensors_OUT_AP2_inputNumero, (long)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP3_Sensors_OUT_AP3_C_byteNumero, (long)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP3_Sensors_OUT_AP3_C_dioName, (Object)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_C_dioName());
        Assert.assertEquals((long)plc_OUT_AP3_Sensors_OUT_AP3_C_inputNumero, (long)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP3_Sensors_OUT_AP3_byteNumero, (long)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP3_Sensors_OUT_AP3_dioName, (Object)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_dioName());
        Assert.assertEquals((long)plc_OUT_AP3_Sensors_OUT_AP3_inputNumero, (long)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_inputNumero());
        Assert.assertEquals((long)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_byteNumero, (long)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_byteNumero());
        Assert.assertEquals((Object)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_dioName, (Object)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_dioName());
        Assert.assertEquals((long)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_inputNumero, (long)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_inputNumero());
        Assert.assertEquals((long)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_byteNumero, (long)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_byteNumero());
        Assert.assertEquals((Object)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_dioName, (Object)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_dioName());
        Assert.assertEquals((long)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_inputNumero, (long)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_inputNumero());
        Assert.assertEquals((long)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_byteNumero, (long)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_byteNumero());
        Assert.assertEquals((Object)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_dioName, (Object)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_dioName());
        Assert.assertEquals((long)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_inputNumero, (long)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_inputNumero());
        Assert.assertEquals((long)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_byteNumero, (long)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_byteNumero());
        Assert.assertEquals((Object)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_dioName, (Object)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_dioName());
        Assert.assertEquals((long)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_inputNumero, (long)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_inputNumero());
        Assert.assertEquals((long)plc_carousel_CF0Sensors_carousel_CF0_C_byteNumero, (long)item_.getPlc_carousel_CF0Sensors_carousel_CF0_C_byteNumero());
        Assert.assertEquals((Object)plc_carousel_CF0Sensors_carousel_CF0_C_dioName, (Object)item_.getPlc_carousel_CF0Sensors_carousel_CF0_C_dioName());
        Assert.assertEquals((long)plc_carousel_CF0Sensors_carousel_CF0_C_inputNumero, (long)item_.getPlc_carousel_CF0Sensors_carousel_CF0_C_inputNumero());
        Assert.assertEquals((long)plc_carousel_CF0Sensors_carousel_CF0_byteNumero, (long)item_.getPlc_carousel_CF0Sensors_carousel_CF0_byteNumero());
        Assert.assertEquals((Object)plc_carousel_CF0Sensors_carousel_CF0_dioName, (Object)item_.getPlc_carousel_CF0Sensors_carousel_CF0_dioName());
        Assert.assertEquals((long)plc_carousel_CF0Sensors_carousel_CF0_inputNumero, (long)item_.getPlc_carousel_CF0Sensors_carousel_CF0_inputNumero());
        Assert.assertEquals((long)plc_carousel_CF1Sensors_carousel_CF1_C_byteNumero, (long)item_.getPlc_carousel_CF1Sensors_carousel_CF1_C_byteNumero());
        Assert.assertEquals((Object)plc_carousel_CF1Sensors_carousel_CF1_C_dioName, (Object)item_.getPlc_carousel_CF1Sensors_carousel_CF1_C_dioName());
        Assert.assertEquals((long)plc_carousel_CF1Sensors_carousel_CF1_C_inputNumero, (long)item_.getPlc_carousel_CF1Sensors_carousel_CF1_C_inputNumero());
        Assert.assertEquals((long)plc_carousel_CF1Sensors_carousel_CF1_byteNumero, (long)item_.getPlc_carousel_CF1Sensors_carousel_CF1_byteNumero());
        Assert.assertEquals((Object)plc_carousel_CF1Sensors_carousel_CF1_dioName, (Object)item_.getPlc_carousel_CF1Sensors_carousel_CF1_dioName());
        Assert.assertEquals((long)plc_carousel_CF1Sensors_carousel_CF1_inputNumero, (long)item_.getPlc_carousel_CF1Sensors_carousel_CF1_inputNumero());
        Assert.assertEquals((long)plc_inclinometerXminus_byteNumero, (long)item_.getPlc_inclinometerXminus_byteNumero());
        Assert.assertEquals((Object)plc_inclinometerXminus_deviceName, (Object)item_.getPlc_inclinometerXminus_deviceName());
        Assert.assertEquals((long)plc_inclinometerXplus_byteNumero, (long)item_.getPlc_inclinometerXplus_byteNumero());
        Assert.assertEquals((Object)plc_inclinometerXplus_deviceName, (Object)item_.getPlc_inclinometerXplus_deviceName());
        Assert.assertEquals((long)plc_loaderConnectedSensors_loaderConnectedSensorC_byteNumero, (long)item_.getPlc_loaderConnectedSensors_loaderConnectedSensorC_byteNumero());
        Assert.assertEquals((Object)plc_loaderConnectedSensors_loaderConnectedSensorC_dioName, (Object)item_.getPlc_loaderConnectedSensors_loaderConnectedSensorC_dioName());
        Assert.assertEquals((long)plc_loaderConnectedSensors_loaderConnectedSensorC_inputNumero, (long)item_.getPlc_loaderConnectedSensors_loaderConnectedSensorC_inputNumero());
        Assert.assertEquals((long)plc_loaderConnectedSensors_loaderConnectedSensor_byteNumero, (long)item_.getPlc_loaderConnectedSensors_loaderConnectedSensor_byteNumero());
        Assert.assertEquals((Object)plc_loaderConnectedSensors_loaderConnectedSensor_dioName, (Object)item_.getPlc_loaderConnectedSensors_loaderConnectedSensor_dioName());
        Assert.assertEquals((long)plc_loaderConnectedSensors_loaderConnectedSensor_inputNumero, (long)item_.getPlc_loaderConnectedSensors_loaderConnectedSensor_inputNumero());
        Assert.assertEquals((long)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_byteNumero, (long)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_byteNumero());
        Assert.assertEquals((Object)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_dioName, (Object)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_dioName());
        Assert.assertEquals((long)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_inputNumero, (long)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_inputNumero());
        Assert.assertEquals((long)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_byteNumero, (long)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_byteNumero());
        Assert.assertEquals((Object)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_dioName, (Object)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_dioName());
        Assert.assertEquals((long)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_inputNumero, (long)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_inputNumero());
        Assert.assertEquals((long)plc_loaderPresenceSensors_presenceLoader_C_byteNumero, (long)item_.getPlc_loaderPresenceSensors_presenceLoader_C_byteNumero());
        Assert.assertEquals((Object)plc_loaderPresenceSensors_presenceLoader_C_dioName, (Object)item_.getPlc_loaderPresenceSensors_presenceLoader_C_dioName());
        Assert.assertEquals((long)plc_loaderPresenceSensors_presenceLoader_C_inputNumero, (long)item_.getPlc_loaderPresenceSensors_presenceLoader_C_inputNumero());
        Assert.assertEquals((long)plc_loaderPresenceSensors_presenceLoader_byteNumero, (long)item_.getPlc_loaderPresenceSensors_presenceLoader_byteNumero());
        Assert.assertEquals((Object)plc_loaderPresenceSensors_presenceLoader_dioName, (Object)item_.getPlc_loaderPresenceSensors_presenceLoader_dioName());
        Assert.assertEquals((long)plc_loaderPresenceSensors_presenceLoader_inputNumero, (long)item_.getPlc_loaderPresenceSensors_presenceLoader_inputNumero());
        Assert.assertEquals((long)plc_lockOutSensors_lockOut_C_byteNumero, (long)item_.getPlc_lockOutSensors_lockOut_C_byteNumero());
        Assert.assertEquals((Object)plc_lockOutSensors_lockOut_C_dioName, (Object)item_.getPlc_lockOutSensors_lockOut_C_dioName());
        Assert.assertEquals((long)plc_lockOutSensors_lockOut_C_inputNumero, (long)item_.getPlc_lockOutSensors_lockOut_C_inputNumero());
        Assert.assertEquals((long)plc_lockOutSensors_lockOut_byteNumero, (long)item_.getPlc_lockOutSensors_lockOut_byteNumero());
        Assert.assertEquals((Object)plc_lockOutSensors_lockOut_dioName, (Object)item_.getPlc_lockOutSensors_lockOut_dioName());
        Assert.assertEquals((long)plc_lockOutSensors_lockOut_inputNumero, (long)item_.getPlc_lockOutSensors_lockOut_inputNumero());
        Assert.assertEquals((long)plc_lockOutShunt_byteNumero, (long)item_.getPlc_lockOutShunt_byteNumero());
        Assert.assertEquals((Object)plc_lockOutShunt_dioName, (Object)item_.getPlc_lockOutShunt_dioName());
        Assert.assertEquals((long)plc_lockOutShunt_inputNumero, (long)item_.getPlc_lockOutShunt_inputNumero());
        Assert.assertEquals((long)plc_lpmEngineeringKeySensors_engineeringKey_C_byteNumero, (long)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_C_byteNumero());
        Assert.assertEquals((Object)plc_lpmEngineeringKeySensors_engineeringKey_C_dioName, (Object)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_C_dioName());
        Assert.assertEquals((long)plc_lpmEngineeringKeySensors_engineeringKey_C_inputNumero, (long)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_C_inputNumero());
        Assert.assertEquals((long)plc_lpmEngineeringKeySensors_engineeringKey_byteNumero, (long)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_byteNumero());
        Assert.assertEquals((Object)plc_lpmEngineeringKeySensors_engineeringKey_dioName, (Object)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_dioName());
        Assert.assertEquals((long)plc_lpmEngineeringKeySensors_engineeringKey_inputNumero, (long)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_inputNumero());
        Assert.assertEquals((long)plc_lpmLatchesStatus_byteNumero, (long)item_.getPlc_lpmLatchesStatus_byteNumero());
        Assert.assertEquals((Object)plc_lpmLatchesStatus_dioName, (Object)item_.getPlc_lpmLatchesStatus_dioName());
        Assert.assertEquals((long)plc_lpmLatchesStatus_inputNumero, (long)item_.getPlc_lpmLatchesStatus_inputNumero());
        Assert.assertEquals((long)plc_lpmLinearRail1Status_byteNumero, (long)item_.getPlc_lpmLinearRail1Status_byteNumero());
        Assert.assertEquals((Object)plc_lpmLinearRail1Status_dioName, (Object)item_.getPlc_lpmLinearRail1Status_dioName());
        Assert.assertEquals((long)plc_lpmLinearRail1Status_inputNumero, (long)item_.getPlc_lpmLinearRail1Status_inputNumero());
        Assert.assertEquals((long)plc_lpmLinearRail2Status_byteNumero, (long)item_.getPlc_lpmLinearRail2Status_byteNumero());
        Assert.assertEquals((Object)plc_lpmLinearRail2Status_dioName, (Object)item_.getPlc_lpmLinearRail2Status_dioName());
        Assert.assertEquals((long)plc_lpmLinearRail2Status_inputNumero, (long)item_.getPlc_lpmLinearRail2Status_inputNumero());
        Assert.assertEquals((long)plc_lpmOnlineClampsStatus_byteNumero, (long)item_.getPlc_lpmOnlineClampsStatus_byteNumero());
        Assert.assertEquals((Object)plc_lpmOnlineClampsStatus_dioName, (Object)item_.getPlc_lpmOnlineClampsStatus_dioName());
        Assert.assertEquals((long)plc_lpmOnlineClampsStatus_inputNumero, (long)item_.getPlc_lpmOnlineClampsStatus_inputNumero());
    }

    @Test
    public void sendReceiveFcs_Canbus0_canbusConfigurationEvent() throws Exception {
        String version = "x";
        String baud = "";
        String busName = "b";
        long hardwareBootTimeout = 751L;
        int masterNodeID = 94;
        boolean pdoRecoveryActive = false;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus0_canbusConfigurationEvent(version, baud, busName, hardwareBootTimeout, masterNodeID, pdoRecoveryActive));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_canbusConfigurationEvent));
        Fcs_Canbus0_canbusConfigurationEvent item_ = (Fcs_Canbus0_canbusConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)baud, (Object)item_.getBaud());
        Assert.assertEquals((Object)busName, (Object)item_.getBusName());
        Assert.assertEquals((long)hardwareBootTimeout, (long)item_.getHardwareBootTimeout());
        Assert.assertEquals((long)masterNodeID, (long)item_.getMasterNodeID());
        Assert.assertEquals((Object)pdoRecoveryActive, (Object)item_.isPdoRecoveryActive());
    }

    @Test
    public void sendReceiveFcs_Canbus0_controllerConfigurationEvent() throws Exception {
        String version = "s";
        int actruckxminuscontroller_encoderRibbonMinValue = 634;
        String actruckxminuscontroller_paramsForCurrent = "";
        String actruckxminuscontroller_paramsForHoming = "";
        String actruckxminuscontroller_paramsForProfilePosition = "s";
        int actruckxpluscontroller_encoderRibbonMinValue = 889;
        String actruckxpluscontroller_paramsForCurrent = "";
        String actruckxpluscontroller_paramsForHoming = "";
        String actruckxpluscontroller_paramsForProfilePosition = "m";
        String carouselcontroller_paramsForCurrent = "l";
        String carouselcontroller_paramsForHoming = "k";
        String carouselcontroller_paramsForProfilePosition = "";
        String clampxminuscontroller_paramsForCurrent = "a";
        String clampxminuscontroller_paramsForHoming = "c";
        String clampxminuscontroller_paramsForProfilePosition = "g";
        String clampxpluscontroller_paramsForCurrent = "q";
        String clampxpluscontroller_paramsForHoming = "d";
        String clampxpluscontroller_paramsForProfilePosition = "";
        String latchxminuscontroller_paramsForCurrent = "";
        String latchxminuscontroller_paramsForHoming = "q";
        String latchxminuscontroller_paramsForProfilePosition = "";
        String latchxpluscontroller_paramsForCurrent = "";
        String latchxpluscontroller_paramsForHoming = "v";
        String latchxpluscontroller_paramsForProfilePosition = "e";
        String onlineclampxminuscontroller_paramsForCurrent = "";
        String onlineclampxminuscontroller_paramsForHoming = "v";
        String onlineclampxminuscontroller_paramsForProfilePosition = "z";
        String onlineclampxpluscontroller_paramsForCurrent = "";
        String onlineclampxpluscontroller_paramsForHoming = "p";
        String onlineclampxpluscontroller_paramsForProfilePosition = "";
        String onlineclampyminuscontroller_paramsForCurrent = "";
        String onlineclampyminuscontroller_paramsForHoming = "x";
        String onlineclampyminuscontroller_paramsForProfilePosition = "x";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus0_controllerConfigurationEvent(version, actruckxminuscontroller_encoderRibbonMinValue, actruckxminuscontroller_paramsForCurrent, actruckxminuscontroller_paramsForHoming, actruckxminuscontroller_paramsForProfilePosition, actruckxpluscontroller_encoderRibbonMinValue, actruckxpluscontroller_paramsForCurrent, actruckxpluscontroller_paramsForHoming, actruckxpluscontroller_paramsForProfilePosition, carouselcontroller_paramsForCurrent, carouselcontroller_paramsForHoming, carouselcontroller_paramsForProfilePosition, clampxminuscontroller_paramsForCurrent, clampxminuscontroller_paramsForHoming, clampxminuscontroller_paramsForProfilePosition, clampxpluscontroller_paramsForCurrent, clampxpluscontroller_paramsForHoming, clampxpluscontroller_paramsForProfilePosition, latchxminuscontroller_paramsForCurrent, latchxminuscontroller_paramsForHoming, latchxminuscontroller_paramsForProfilePosition, latchxpluscontroller_paramsForCurrent, latchxpluscontroller_paramsForHoming, latchxpluscontroller_paramsForProfilePosition, onlineclampxminuscontroller_paramsForCurrent, onlineclampxminuscontroller_paramsForHoming, onlineclampxminuscontroller_paramsForProfilePosition, onlineclampxpluscontroller_paramsForCurrent, onlineclampxpluscontroller_paramsForHoming, onlineclampxpluscontroller_paramsForProfilePosition, onlineclampyminuscontroller_paramsForCurrent, onlineclampyminuscontroller_paramsForHoming, onlineclampyminuscontroller_paramsForProfilePosition));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_controllerConfigurationEvent));
        Fcs_Canbus0_controllerConfigurationEvent item_ = (Fcs_Canbus0_controllerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)actruckxminuscontroller_encoderRibbonMinValue, (long)item_.getActruckxminuscontroller_encoderRibbonMinValue());
        Assert.assertEquals((Object)actruckxminuscontroller_paramsForCurrent, (Object)item_.getActruckxminuscontroller_paramsForCurrent());
        Assert.assertEquals((Object)actruckxminuscontroller_paramsForHoming, (Object)item_.getActruckxminuscontroller_paramsForHoming());
        Assert.assertEquals((Object)actruckxminuscontroller_paramsForProfilePosition, (Object)item_.getActruckxminuscontroller_paramsForProfilePosition());
        Assert.assertEquals((long)actruckxpluscontroller_encoderRibbonMinValue, (long)item_.getActruckxpluscontroller_encoderRibbonMinValue());
        Assert.assertEquals((Object)actruckxpluscontroller_paramsForCurrent, (Object)item_.getActruckxpluscontroller_paramsForCurrent());
        Assert.assertEquals((Object)actruckxpluscontroller_paramsForHoming, (Object)item_.getActruckxpluscontroller_paramsForHoming());
        Assert.assertEquals((Object)actruckxpluscontroller_paramsForProfilePosition, (Object)item_.getActruckxpluscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)carouselcontroller_paramsForCurrent, (Object)item_.getCarouselcontroller_paramsForCurrent());
        Assert.assertEquals((Object)carouselcontroller_paramsForHoming, (Object)item_.getCarouselcontroller_paramsForHoming());
        Assert.assertEquals((Object)carouselcontroller_paramsForProfilePosition, (Object)item_.getCarouselcontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)clampxminuscontroller_paramsForCurrent, (Object)item_.getClampxminuscontroller_paramsForCurrent());
        Assert.assertEquals((Object)clampxminuscontroller_paramsForHoming, (Object)item_.getClampxminuscontroller_paramsForHoming());
        Assert.assertEquals((Object)clampxminuscontroller_paramsForProfilePosition, (Object)item_.getClampxminuscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)clampxpluscontroller_paramsForCurrent, (Object)item_.getClampxpluscontroller_paramsForCurrent());
        Assert.assertEquals((Object)clampxpluscontroller_paramsForHoming, (Object)item_.getClampxpluscontroller_paramsForHoming());
        Assert.assertEquals((Object)clampxpluscontroller_paramsForProfilePosition, (Object)item_.getClampxpluscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)latchxminuscontroller_paramsForCurrent, (Object)item_.getLatchxminuscontroller_paramsForCurrent());
        Assert.assertEquals((Object)latchxminuscontroller_paramsForHoming, (Object)item_.getLatchxminuscontroller_paramsForHoming());
        Assert.assertEquals((Object)latchxminuscontroller_paramsForProfilePosition, (Object)item_.getLatchxminuscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)latchxpluscontroller_paramsForCurrent, (Object)item_.getLatchxpluscontroller_paramsForCurrent());
        Assert.assertEquals((Object)latchxpluscontroller_paramsForHoming, (Object)item_.getLatchxpluscontroller_paramsForHoming());
        Assert.assertEquals((Object)latchxpluscontroller_paramsForProfilePosition, (Object)item_.getLatchxpluscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)onlineclampxminuscontroller_paramsForCurrent, (Object)item_.getOnlineclampxminuscontroller_paramsForCurrent());
        Assert.assertEquals((Object)onlineclampxminuscontroller_paramsForHoming, (Object)item_.getOnlineclampxminuscontroller_paramsForHoming());
        Assert.assertEquals((Object)onlineclampxminuscontroller_paramsForProfilePosition, (Object)item_.getOnlineclampxminuscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)onlineclampxpluscontroller_paramsForCurrent, (Object)item_.getOnlineclampxpluscontroller_paramsForCurrent());
        Assert.assertEquals((Object)onlineclampxpluscontroller_paramsForHoming, (Object)item_.getOnlineclampxpluscontroller_paramsForHoming());
        Assert.assertEquals((Object)onlineclampxpluscontroller_paramsForProfilePosition, (Object)item_.getOnlineclampxpluscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)onlineclampyminuscontroller_paramsForCurrent, (Object)item_.getOnlineclampyminuscontroller_paramsForCurrent());
        Assert.assertEquals((Object)onlineclampyminuscontroller_paramsForHoming, (Object)item_.getOnlineclampyminuscontroller_paramsForHoming());
        Assert.assertEquals((Object)onlineclampyminuscontroller_paramsForProfilePosition, (Object)item_.getOnlineclampyminuscontroller_paramsForProfilePosition());
    }

    @Test
    public void sendReceiveFcs_Canbus0_nodeIDConfigurationEvent() throws Exception {
        String version = "";
        int acsensorsgateway_nodeID = 233;
        int actruckxminuscontroller_nodeID = 65;
        int actruckxpluscontroller_nodeID = 649;
        int accelerobf_nodeID = 346;
        int ai814_nodeID = 384;
        int brakesystemgateway_nodeID = 280;
        int carouselcontroller_nodeID = 246;
        int clampxminuscontroller_nodeID = 361;
        int clampxpluscontroller_nodeID = 901;
        int hyttc580_nodeID = 34;
        int latchxminuscontroller_nodeID = 571;
        int latchxpluscontroller_nodeID = 557;
        int onlineclampxminuscontroller_nodeID = 143;
        int onlineclampxpluscontroller_nodeID = 463;
        int onlineclampyminuscontroller_nodeID = 197;
        int onlinestraingauge_nodeID = 417;
        int proximitysensorsdevice_nodeID = 603;
        int pt100_nodeID = 15;
        int tempsensorsdevice1_nodeID = 199;
        int tempsensorsdevice2_nodeID = 238;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus0_nodeIDConfigurationEvent(version, acsensorsgateway_nodeID, actruckxminuscontroller_nodeID, actruckxpluscontroller_nodeID, accelerobf_nodeID, ai814_nodeID, brakesystemgateway_nodeID, carouselcontroller_nodeID, clampxminuscontroller_nodeID, clampxpluscontroller_nodeID, hyttc580_nodeID, latchxminuscontroller_nodeID, latchxpluscontroller_nodeID, onlineclampxminuscontroller_nodeID, onlineclampxpluscontroller_nodeID, onlineclampyminuscontroller_nodeID, onlinestraingauge_nodeID, proximitysensorsdevice_nodeID, pt100_nodeID, tempsensorsdevice1_nodeID, tempsensorsdevice2_nodeID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_nodeIDConfigurationEvent));
        Fcs_Canbus0_nodeIDConfigurationEvent item_ = (Fcs_Canbus0_nodeIDConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)acsensorsgateway_nodeID, (long)item_.getAcsensorsgateway_nodeID());
        Assert.assertEquals((long)actruckxminuscontroller_nodeID, (long)item_.getActruckxminuscontroller_nodeID());
        Assert.assertEquals((long)actruckxpluscontroller_nodeID, (long)item_.getActruckxpluscontroller_nodeID());
        Assert.assertEquals((long)accelerobf_nodeID, (long)item_.getAccelerobf_nodeID());
        Assert.assertEquals((long)ai814_nodeID, (long)item_.getAi814_nodeID());
        Assert.assertEquals((long)brakesystemgateway_nodeID, (long)item_.getBrakesystemgateway_nodeID());
        Assert.assertEquals((long)carouselcontroller_nodeID, (long)item_.getCarouselcontroller_nodeID());
        Assert.assertEquals((long)clampxminuscontroller_nodeID, (long)item_.getClampxminuscontroller_nodeID());
        Assert.assertEquals((long)clampxpluscontroller_nodeID, (long)item_.getClampxpluscontroller_nodeID());
        Assert.assertEquals((long)hyttc580_nodeID, (long)item_.getHyttc580_nodeID());
        Assert.assertEquals((long)latchxminuscontroller_nodeID, (long)item_.getLatchxminuscontroller_nodeID());
        Assert.assertEquals((long)latchxpluscontroller_nodeID, (long)item_.getLatchxpluscontroller_nodeID());
        Assert.assertEquals((long)onlineclampxminuscontroller_nodeID, (long)item_.getOnlineclampxminuscontroller_nodeID());
        Assert.assertEquals((long)onlineclampxpluscontroller_nodeID, (long)item_.getOnlineclampxpluscontroller_nodeID());
        Assert.assertEquals((long)onlineclampyminuscontroller_nodeID, (long)item_.getOnlineclampyminuscontroller_nodeID());
        Assert.assertEquals((long)onlinestraingauge_nodeID, (long)item_.getOnlinestraingauge_nodeID());
        Assert.assertEquals((long)proximitysensorsdevice_nodeID, (long)item_.getProximitysensorsdevice_nodeID());
        Assert.assertEquals((long)pt100_nodeID, (long)item_.getPt100_nodeID());
        Assert.assertEquals((long)tempsensorsdevice1_nodeID, (long)item_.getTempsensorsdevice1_nodeID());
        Assert.assertEquals((long)tempsensorsdevice2_nodeID, (long)item_.getTempsensorsdevice2_nodeID());
    }

    @Test
    public void sendReceiveFcs_Canbus0_sensorConfigurationEvent() throws Exception {
        String version = "h";
        int ai814_transmissionType = 893;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus0_sensorConfigurationEvent(version, ai814_transmissionType));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_sensorConfigurationEvent));
        Fcs_Canbus0_sensorConfigurationEvent item_ = (Fcs_Canbus0_sensorConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)ai814_transmissionType, (long)item_.getAi814_transmissionType());
    }

    @Test
    public void sendReceiveFcs_Canbus0_serialNBConfigurationEvent() throws Exception {
        String version = "k";
        String acsensorsgateway_serialNB = "";
        String actruckxminuscontroller_serialNB = "";
        String actruckxpluscontroller_serialNB = "d";
        String accelerobf_serialNB = "";
        String ai814_serialNB = "z";
        String brakesystemgateway_serialNB = "";
        String carouselcontroller_serialNB = "n";
        String clampxminuscontroller_serialNB = "";
        String clampxpluscontroller_serialNB = "c";
        String hyttc580_serialNB = "";
        String latchxminuscontroller_serialNB = "x";
        String latchxpluscontroller_serialNB = "";
        String onlineclampxminuscontroller_serialNB = "";
        String onlineclampxpluscontroller_serialNB = "c";
        String onlineclampyminuscontroller_serialNB = "m";
        String onlinestraingauge_serialNB = "";
        String proximitysensorsdevice_serialNB = "d";
        String pt100_serialNB = "";
        String tempsensorsdevice1_serialNB = "a";
        String tempsensorsdevice2_serialNB = "";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus0_serialNBConfigurationEvent(version, acsensorsgateway_serialNB, actruckxminuscontroller_serialNB, actruckxpluscontroller_serialNB, accelerobf_serialNB, ai814_serialNB, brakesystemgateway_serialNB, carouselcontroller_serialNB, clampxminuscontroller_serialNB, clampxpluscontroller_serialNB, hyttc580_serialNB, latchxminuscontroller_serialNB, latchxpluscontroller_serialNB, onlineclampxminuscontroller_serialNB, onlineclampxpluscontroller_serialNB, onlineclampyminuscontroller_serialNB, onlinestraingauge_serialNB, proximitysensorsdevice_serialNB, pt100_serialNB, tempsensorsdevice1_serialNB, tempsensorsdevice2_serialNB));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_serialNBConfigurationEvent));
        Fcs_Canbus0_serialNBConfigurationEvent item_ = (Fcs_Canbus0_serialNBConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)acsensorsgateway_serialNB, (Object)item_.getAcsensorsgateway_serialNB());
        Assert.assertEquals((Object)actruckxminuscontroller_serialNB, (Object)item_.getActruckxminuscontroller_serialNB());
        Assert.assertEquals((Object)actruckxpluscontroller_serialNB, (Object)item_.getActruckxpluscontroller_serialNB());
        Assert.assertEquals((Object)accelerobf_serialNB, (Object)item_.getAccelerobf_serialNB());
        Assert.assertEquals((Object)ai814_serialNB, (Object)item_.getAi814_serialNB());
        Assert.assertEquals((Object)brakesystemgateway_serialNB, (Object)item_.getBrakesystemgateway_serialNB());
        Assert.assertEquals((Object)carouselcontroller_serialNB, (Object)item_.getCarouselcontroller_serialNB());
        Assert.assertEquals((Object)clampxminuscontroller_serialNB, (Object)item_.getClampxminuscontroller_serialNB());
        Assert.assertEquals((Object)clampxpluscontroller_serialNB, (Object)item_.getClampxpluscontroller_serialNB());
        Assert.assertEquals((Object)hyttc580_serialNB, (Object)item_.getHyttc580_serialNB());
        Assert.assertEquals((Object)latchxminuscontroller_serialNB, (Object)item_.getLatchxminuscontroller_serialNB());
        Assert.assertEquals((Object)latchxpluscontroller_serialNB, (Object)item_.getLatchxpluscontroller_serialNB());
        Assert.assertEquals((Object)onlineclampxminuscontroller_serialNB, (Object)item_.getOnlineclampxminuscontroller_serialNB());
        Assert.assertEquals((Object)onlineclampxpluscontroller_serialNB, (Object)item_.getOnlineclampxpluscontroller_serialNB());
        Assert.assertEquals((Object)onlineclampyminuscontroller_serialNB, (Object)item_.getOnlineclampyminuscontroller_serialNB());
        Assert.assertEquals((Object)onlinestraingauge_serialNB, (Object)item_.getOnlinestraingauge_serialNB());
        Assert.assertEquals((Object)proximitysensorsdevice_serialNB, (Object)item_.getProximitysensorsdevice_serialNB());
        Assert.assertEquals((Object)pt100_serialNB, (Object)item_.getPt100_serialNB());
        Assert.assertEquals((Object)tempsensorsdevice1_serialNB, (Object)item_.getTempsensorsdevice1_serialNB());
        Assert.assertEquals((Object)tempsensorsdevice2_serialNB, (Object)item_.getTempsensorsdevice2_serialNB());
    }

    @Test
    public void sendReceiveFcs_Canbus1_canbusConfigurationEvent() throws Exception {
        String version = "d";
        String baud = "m";
        String busName = "c";
        long hardwareBootTimeout = 949L;
        int masterNodeID = 387;
        boolean pdoRecoveryActive = true;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus1_canbusConfigurationEvent(version, baud, busName, hardwareBootTimeout, masterNodeID, pdoRecoveryActive));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_canbusConfigurationEvent));
        Fcs_Canbus1_canbusConfigurationEvent item_ = (Fcs_Canbus1_canbusConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)baud, (Object)item_.getBaud());
        Assert.assertEquals((Object)busName, (Object)item_.getBusName());
        Assert.assertEquals((long)hardwareBootTimeout, (long)item_.getHardwareBootTimeout());
        Assert.assertEquals((long)masterNodeID, (long)item_.getMasterNodeID());
        Assert.assertEquals((Object)pdoRecoveryActive, (Object)item_.isPdoRecoveryActive());
    }

    @Test
    public void sendReceiveFcs_Canbus1_controllerConfigurationEvent() throws Exception {
        String version = "z";
        String carriercontroller_paramsForCurrent = "";
        String carriercontroller_paramsForHoming = "v";
        String carriercontroller_paramsForProfilePosition = "";
        String hookscontroller_paramsForCurrent = "";
        String hookscontroller_paramsForHoming = "y";
        String hookscontroller_paramsForProfilePosition = "";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus1_controllerConfigurationEvent(version, carriercontroller_paramsForCurrent, carriercontroller_paramsForHoming, carriercontroller_paramsForProfilePosition, hookscontroller_paramsForCurrent, hookscontroller_paramsForHoming, hookscontroller_paramsForProfilePosition));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_controllerConfigurationEvent));
        Fcs_Canbus1_controllerConfigurationEvent item_ = (Fcs_Canbus1_controllerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)carriercontroller_paramsForCurrent, (Object)item_.getCarriercontroller_paramsForCurrent());
        Assert.assertEquals((Object)carriercontroller_paramsForHoming, (Object)item_.getCarriercontroller_paramsForHoming());
        Assert.assertEquals((Object)carriercontroller_paramsForProfilePosition, (Object)item_.getCarriercontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)hookscontroller_paramsForCurrent, (Object)item_.getHookscontroller_paramsForCurrent());
        Assert.assertEquals((Object)hookscontroller_paramsForHoming, (Object)item_.getHookscontroller_paramsForHoming());
        Assert.assertEquals((Object)hookscontroller_paramsForProfilePosition, (Object)item_.getHookscontroller_paramsForProfilePosition());
    }

    @Test
    public void sendReceiveFcs_Canbus1_nodeIDConfigurationEvent() throws Exception {
        String version = "";
        int carriercontroller_nodeID = 805;
        int hookscontroller_nodeID = 236;
        int loaderplutogateway_nodeID = 777;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus1_nodeIDConfigurationEvent(version, carriercontroller_nodeID, hookscontroller_nodeID, loaderplutogateway_nodeID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_nodeIDConfigurationEvent));
        Fcs_Canbus1_nodeIDConfigurationEvent item_ = (Fcs_Canbus1_nodeIDConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)carriercontroller_nodeID, (long)item_.getCarriercontroller_nodeID());
        Assert.assertEquals((long)hookscontroller_nodeID, (long)item_.getHookscontroller_nodeID());
        Assert.assertEquals((long)loaderplutogateway_nodeID, (long)item_.getLoaderplutogateway_nodeID());
    }

    @Test
    public void sendReceiveFcs_Canbus1_serialNBConfigurationEvent() throws Exception {
        String version = "";
        String carriercontroller_serialNB = "o";
        String hookscontroller_serialNB = "z";
        String loaderplutogateway_serialNB = "h";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus1_serialNBConfigurationEvent(version, carriercontroller_serialNB, hookscontroller_serialNB, loaderplutogateway_serialNB));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_serialNBConfigurationEvent));
        Fcs_Canbus1_serialNBConfigurationEvent item_ = (Fcs_Canbus1_serialNBConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)carriercontroller_serialNB, (Object)item_.getCarriercontroller_serialNB());
        Assert.assertEquals((Object)hookscontroller_serialNB, (Object)item_.getHookscontroller_serialNB());
        Assert.assertEquals((Object)loaderplutogateway_serialNB, (Object)item_.getLoaderplutogateway_serialNB());
    }

    @Test
    public void sendReceiveFcs_Carousel_carouselConfigurationEvent() throws Exception {
        String version = "w";
        int brake1Limit = 422;
        int brake2Limit = 267;
        int brake3Limit = 522;
        int currentToPrepareUnlock = 955;
        int fastAcceleration = 124;
        int fastDeceleration = 722;
        int fastRotationTimeout = 931;
        int fastVelocity = 998;
        int filterPresenceMinNoFilter = 912;
        int lockSensorMaxLimitXminus = 350;
        int lockSensorMaxLimitXplus = 50;
        int lockSensorMinLimitXminus = 196;
        int lockSensorMinLimitXplus = 483;
        int maxClampsOffsetDelta = 315;
        int maxStandbyDeltaPosition = 113;
        boolean powerSaveAllowed = false;
        int recoveryBackwardStep = 911;
        int recoveryForwardStep = 892;
        int recoveryLockingCurrent = 722;
        int recoveryMaxVelocity = 561;
        int recoveryStandbyDeltaPosition = 897;
        int slowAcceleration = 170;
        int slowDeceleration = 70;
        int slowRotationTimeout = 8;
        int slowVelocity = 906;
        int socket1_clampXminus1_currentToUnlock = 778;
        int socket1_clampXminus1_filterPresenceMaxValue = 365;
        int socket1_clampXminus1_filterPresenceOffset3 = 11;
        long socket1_clampXminus1_timeoutForReleasing = 167L;
        long socket1_clampXminus1_timeoutForUnlocking = 81L;
        int socket1_clampXplus1_currentToUnlock = 700;
        int socket1_clampXplus1_filterPresenceMaxValue = 26;
        int socket1_clampXplus1_filterPresenceOffset3 = 889;
        long socket1_clampXplus1_timeoutForReleasing = 572L;
        long socket1_clampXplus1_timeoutForUnlocking = 549L;
        int socket1_deltaAutochangerStandbyPosition = 715;
        int socket1_standbyPosition = 631;
        int socket2_clampXminus2_currentToUnlock = 416;
        int socket2_clampXminus2_filterPresenceMaxValue = 504;
        int socket2_clampXminus2_filterPresenceOffset3 = 558;
        long socket2_clampXminus2_timeoutForReleasing = 887L;
        long socket2_clampXminus2_timeoutForUnlocking = 930L;
        int socket2_clampXplus2_currentToUnlock = 216;
        int socket2_clampXplus2_filterPresenceMaxValue = 959;
        int socket2_clampXplus2_filterPresenceOffset3 = 83;
        long socket2_clampXplus2_timeoutForReleasing = 981L;
        long socket2_clampXplus2_timeoutForUnlocking = 240L;
        int socket2_deltaAutochangerStandbyPosition = 803;
        int socket2_standbyPosition = 128;
        int socket3_clampXminus3_currentToUnlock = 734;
        int socket3_clampXminus3_filterPresenceMaxValue = 379;
        int socket3_clampXminus3_filterPresenceOffset3 = 720;
        long socket3_clampXminus3_timeoutForReleasing = 138L;
        long socket3_clampXminus3_timeoutForUnlocking = 765L;
        int socket3_clampXplus3_currentToUnlock = 283;
        int socket3_clampXplus3_filterPresenceMaxValue = 886;
        int socket3_clampXplus3_filterPresenceOffset3 = 468;
        long socket3_clampXplus3_timeoutForReleasing = 938L;
        long socket3_clampXplus3_timeoutForUnlocking = 962L;
        int socket3_deltaAutochangerStandbyPosition = 636;
        int socket3_standbyPosition = 156;
        int socket4_clampXminus4_currentToUnlock = 418;
        int socket4_clampXminus4_filterPresenceMaxValue = 948;
        int socket4_clampXminus4_filterPresenceOffset3 = 809;
        long socket4_clampXminus4_timeoutForReleasing = 770L;
        long socket4_clampXminus4_timeoutForUnlocking = 45L;
        int socket4_clampXplus4_currentToUnlock = 974;
        int socket4_clampXplus4_filterPresenceMaxValue = 632;
        int socket4_clampXplus4_filterPresenceOffset3 = 776;
        long socket4_clampXplus4_timeoutForReleasing = 188L;
        long socket4_clampXplus4_timeoutForUnlocking = 847L;
        int socket4_deltaAutochangerStandbyPosition = 895;
        int socket4_standbyPosition = 837;
        int socket5_clampXminus5_currentToUnlock = 36;
        int socket5_clampXminus5_filterPresenceMaxValue = 764;
        int socket5_clampXminus5_filterPresenceOffset3 = 980;
        long socket5_clampXminus5_timeoutForReleasing = 68L;
        long socket5_clampXminus5_timeoutForUnlocking = 610L;
        int socket5_clampXplus5_currentToUnlock = 42;
        int socket5_clampXplus5_filterPresenceMaxValue = 963;
        int socket5_clampXplus5_filterPresenceOffset3 = 906;
        long socket5_clampXplus5_timeoutForReleasing = 906L;
        long socket5_clampXplus5_timeoutForUnlocking = 204L;
        int socket5_deltaAutochangerStandbyPosition = 377;
        int socket5_standbyPosition = 125;
        int timeToPrepareUnlock = 40;
        long timeToUpdateProtectionSystem = 237L;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Carousel_carouselConfigurationEvent(version, brake1Limit, brake2Limit, brake3Limit, currentToPrepareUnlock, fastAcceleration, fastDeceleration, fastRotationTimeout, fastVelocity, filterPresenceMinNoFilter, lockSensorMaxLimitXminus, lockSensorMaxLimitXplus, lockSensorMinLimitXminus, lockSensorMinLimitXplus, maxClampsOffsetDelta, maxStandbyDeltaPosition, powerSaveAllowed, recoveryBackwardStep, recoveryForwardStep, recoveryLockingCurrent, recoveryMaxVelocity, recoveryStandbyDeltaPosition, slowAcceleration, slowDeceleration, slowRotationTimeout, slowVelocity, socket1_clampXminus1_currentToUnlock, socket1_clampXminus1_filterPresenceMaxValue, socket1_clampXminus1_filterPresenceOffset3, socket1_clampXminus1_timeoutForReleasing, socket1_clampXminus1_timeoutForUnlocking, socket1_clampXplus1_currentToUnlock, socket1_clampXplus1_filterPresenceMaxValue, socket1_clampXplus1_filterPresenceOffset3, socket1_clampXplus1_timeoutForReleasing, socket1_clampXplus1_timeoutForUnlocking, socket1_deltaAutochangerStandbyPosition, socket1_standbyPosition, socket2_clampXminus2_currentToUnlock, socket2_clampXminus2_filterPresenceMaxValue, socket2_clampXminus2_filterPresenceOffset3, socket2_clampXminus2_timeoutForReleasing, socket2_clampXminus2_timeoutForUnlocking, socket2_clampXplus2_currentToUnlock, socket2_clampXplus2_filterPresenceMaxValue, socket2_clampXplus2_filterPresenceOffset3, socket2_clampXplus2_timeoutForReleasing, socket2_clampXplus2_timeoutForUnlocking, socket2_deltaAutochangerStandbyPosition, socket2_standbyPosition, socket3_clampXminus3_currentToUnlock, socket3_clampXminus3_filterPresenceMaxValue, socket3_clampXminus3_filterPresenceOffset3, socket3_clampXminus3_timeoutForReleasing, socket3_clampXminus3_timeoutForUnlocking, socket3_clampXplus3_currentToUnlock, socket3_clampXplus3_filterPresenceMaxValue, socket3_clampXplus3_filterPresenceOffset3, socket3_clampXplus3_timeoutForReleasing, socket3_clampXplus3_timeoutForUnlocking, socket3_deltaAutochangerStandbyPosition, socket3_standbyPosition, socket4_clampXminus4_currentToUnlock, socket4_clampXminus4_filterPresenceMaxValue, socket4_clampXminus4_filterPresenceOffset3, socket4_clampXminus4_timeoutForReleasing, socket4_clampXminus4_timeoutForUnlocking, socket4_clampXplus4_currentToUnlock, socket4_clampXplus4_filterPresenceMaxValue, socket4_clampXplus4_filterPresenceOffset3, socket4_clampXplus4_timeoutForReleasing, socket4_clampXplus4_timeoutForUnlocking, socket4_deltaAutochangerStandbyPosition, socket4_standbyPosition, socket5_clampXminus5_currentToUnlock, socket5_clampXminus5_filterPresenceMaxValue, socket5_clampXminus5_filterPresenceOffset3, socket5_clampXminus5_timeoutForReleasing, socket5_clampXminus5_timeoutForUnlocking, socket5_clampXplus5_currentToUnlock, socket5_clampXplus5_filterPresenceMaxValue, socket5_clampXplus5_filterPresenceOffset3, socket5_clampXplus5_timeoutForReleasing, socket5_clampXplus5_timeoutForUnlocking, socket5_deltaAutochangerStandbyPosition, socket5_standbyPosition, timeToPrepareUnlock, timeToUpdateProtectionSystem));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_carouselConfigurationEvent));
        Fcs_Carousel_carouselConfigurationEvent item_ = (Fcs_Carousel_carouselConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)brake1Limit, (long)item_.getBrake1Limit());
        Assert.assertEquals((long)brake2Limit, (long)item_.getBrake2Limit());
        Assert.assertEquals((long)brake3Limit, (long)item_.getBrake3Limit());
        Assert.assertEquals((long)currentToPrepareUnlock, (long)item_.getCurrentToPrepareUnlock());
        Assert.assertEquals((long)fastAcceleration, (long)item_.getFastAcceleration());
        Assert.assertEquals((long)fastDeceleration, (long)item_.getFastDeceleration());
        Assert.assertEquals((long)fastRotationTimeout, (long)item_.getFastRotationTimeout());
        Assert.assertEquals((long)fastVelocity, (long)item_.getFastVelocity());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)lockSensorMaxLimitXminus, (long)item_.getLockSensorMaxLimitXminus());
        Assert.assertEquals((long)lockSensorMaxLimitXplus, (long)item_.getLockSensorMaxLimitXplus());
        Assert.assertEquals((long)lockSensorMinLimitXminus, (long)item_.getLockSensorMinLimitXminus());
        Assert.assertEquals((long)lockSensorMinLimitXplus, (long)item_.getLockSensorMinLimitXplus());
        Assert.assertEquals((long)maxClampsOffsetDelta, (long)item_.getMaxClampsOffsetDelta());
        Assert.assertEquals((long)maxStandbyDeltaPosition, (long)item_.getMaxStandbyDeltaPosition());
        Assert.assertEquals((Object)powerSaveAllowed, (Object)item_.isPowerSaveAllowed());
        Assert.assertEquals((long)recoveryBackwardStep, (long)item_.getRecoveryBackwardStep());
        Assert.assertEquals((long)recoveryForwardStep, (long)item_.getRecoveryForwardStep());
        Assert.assertEquals((long)recoveryLockingCurrent, (long)item_.getRecoveryLockingCurrent());
        Assert.assertEquals((long)recoveryMaxVelocity, (long)item_.getRecoveryMaxVelocity());
        Assert.assertEquals((long)recoveryStandbyDeltaPosition, (long)item_.getRecoveryStandbyDeltaPosition());
        Assert.assertEquals((long)slowAcceleration, (long)item_.getSlowAcceleration());
        Assert.assertEquals((long)slowDeceleration, (long)item_.getSlowDeceleration());
        Assert.assertEquals((long)slowRotationTimeout, (long)item_.getSlowRotationTimeout());
        Assert.assertEquals((long)slowVelocity, (long)item_.getSlowVelocity());
        Assert.assertEquals((long)socket1_clampXminus1_currentToUnlock, (long)item_.getSocket1_clampXminus1_currentToUnlock());
        Assert.assertEquals((long)socket1_clampXminus1_filterPresenceMaxValue, (long)item_.getSocket1_clampXminus1_filterPresenceMaxValue());
        Assert.assertEquals((long)socket1_clampXminus1_filterPresenceOffset3, (long)item_.getSocket1_clampXminus1_filterPresenceOffset3());
        Assert.assertEquals((long)socket1_clampXminus1_timeoutForReleasing, (long)item_.getSocket1_clampXminus1_timeoutForReleasing());
        Assert.assertEquals((long)socket1_clampXminus1_timeoutForUnlocking, (long)item_.getSocket1_clampXminus1_timeoutForUnlocking());
        Assert.assertEquals((long)socket1_clampXplus1_currentToUnlock, (long)item_.getSocket1_clampXplus1_currentToUnlock());
        Assert.assertEquals((long)socket1_clampXplus1_filterPresenceMaxValue, (long)item_.getSocket1_clampXplus1_filterPresenceMaxValue());
        Assert.assertEquals((long)socket1_clampXplus1_filterPresenceOffset3, (long)item_.getSocket1_clampXplus1_filterPresenceOffset3());
        Assert.assertEquals((long)socket1_clampXplus1_timeoutForReleasing, (long)item_.getSocket1_clampXplus1_timeoutForReleasing());
        Assert.assertEquals((long)socket1_clampXplus1_timeoutForUnlocking, (long)item_.getSocket1_clampXplus1_timeoutForUnlocking());
        Assert.assertEquals((long)socket1_deltaAutochangerStandbyPosition, (long)item_.getSocket1_deltaAutochangerStandbyPosition());
        Assert.assertEquals((long)socket1_standbyPosition, (long)item_.getSocket1_standbyPosition());
        Assert.assertEquals((long)socket2_clampXminus2_currentToUnlock, (long)item_.getSocket2_clampXminus2_currentToUnlock());
        Assert.assertEquals((long)socket2_clampXminus2_filterPresenceMaxValue, (long)item_.getSocket2_clampXminus2_filterPresenceMaxValue());
        Assert.assertEquals((long)socket2_clampXminus2_filterPresenceOffset3, (long)item_.getSocket2_clampXminus2_filterPresenceOffset3());
        Assert.assertEquals((long)socket2_clampXminus2_timeoutForReleasing, (long)item_.getSocket2_clampXminus2_timeoutForReleasing());
        Assert.assertEquals((long)socket2_clampXminus2_timeoutForUnlocking, (long)item_.getSocket2_clampXminus2_timeoutForUnlocking());
        Assert.assertEquals((long)socket2_clampXplus2_currentToUnlock, (long)item_.getSocket2_clampXplus2_currentToUnlock());
        Assert.assertEquals((long)socket2_clampXplus2_filterPresenceMaxValue, (long)item_.getSocket2_clampXplus2_filterPresenceMaxValue());
        Assert.assertEquals((long)socket2_clampXplus2_filterPresenceOffset3, (long)item_.getSocket2_clampXplus2_filterPresenceOffset3());
        Assert.assertEquals((long)socket2_clampXplus2_timeoutForReleasing, (long)item_.getSocket2_clampXplus2_timeoutForReleasing());
        Assert.assertEquals((long)socket2_clampXplus2_timeoutForUnlocking, (long)item_.getSocket2_clampXplus2_timeoutForUnlocking());
        Assert.assertEquals((long)socket2_deltaAutochangerStandbyPosition, (long)item_.getSocket2_deltaAutochangerStandbyPosition());
        Assert.assertEquals((long)socket2_standbyPosition, (long)item_.getSocket2_standbyPosition());
        Assert.assertEquals((long)socket3_clampXminus3_currentToUnlock, (long)item_.getSocket3_clampXminus3_currentToUnlock());
        Assert.assertEquals((long)socket3_clampXminus3_filterPresenceMaxValue, (long)item_.getSocket3_clampXminus3_filterPresenceMaxValue());
        Assert.assertEquals((long)socket3_clampXminus3_filterPresenceOffset3, (long)item_.getSocket3_clampXminus3_filterPresenceOffset3());
        Assert.assertEquals((long)socket3_clampXminus3_timeoutForReleasing, (long)item_.getSocket3_clampXminus3_timeoutForReleasing());
        Assert.assertEquals((long)socket3_clampXminus3_timeoutForUnlocking, (long)item_.getSocket3_clampXminus3_timeoutForUnlocking());
        Assert.assertEquals((long)socket3_clampXplus3_currentToUnlock, (long)item_.getSocket3_clampXplus3_currentToUnlock());
        Assert.assertEquals((long)socket3_clampXplus3_filterPresenceMaxValue, (long)item_.getSocket3_clampXplus3_filterPresenceMaxValue());
        Assert.assertEquals((long)socket3_clampXplus3_filterPresenceOffset3, (long)item_.getSocket3_clampXplus3_filterPresenceOffset3());
        Assert.assertEquals((long)socket3_clampXplus3_timeoutForReleasing, (long)item_.getSocket3_clampXplus3_timeoutForReleasing());
        Assert.assertEquals((long)socket3_clampXplus3_timeoutForUnlocking, (long)item_.getSocket3_clampXplus3_timeoutForUnlocking());
        Assert.assertEquals((long)socket3_deltaAutochangerStandbyPosition, (long)item_.getSocket3_deltaAutochangerStandbyPosition());
        Assert.assertEquals((long)socket3_standbyPosition, (long)item_.getSocket3_standbyPosition());
        Assert.assertEquals((long)socket4_clampXminus4_currentToUnlock, (long)item_.getSocket4_clampXminus4_currentToUnlock());
        Assert.assertEquals((long)socket4_clampXminus4_filterPresenceMaxValue, (long)item_.getSocket4_clampXminus4_filterPresenceMaxValue());
        Assert.assertEquals((long)socket4_clampXminus4_filterPresenceOffset3, (long)item_.getSocket4_clampXminus4_filterPresenceOffset3());
        Assert.assertEquals((long)socket4_clampXminus4_timeoutForReleasing, (long)item_.getSocket4_clampXminus4_timeoutForReleasing());
        Assert.assertEquals((long)socket4_clampXminus4_timeoutForUnlocking, (long)item_.getSocket4_clampXminus4_timeoutForUnlocking());
        Assert.assertEquals((long)socket4_clampXplus4_currentToUnlock, (long)item_.getSocket4_clampXplus4_currentToUnlock());
        Assert.assertEquals((long)socket4_clampXplus4_filterPresenceMaxValue, (long)item_.getSocket4_clampXplus4_filterPresenceMaxValue());
        Assert.assertEquals((long)socket4_clampXplus4_filterPresenceOffset3, (long)item_.getSocket4_clampXplus4_filterPresenceOffset3());
        Assert.assertEquals((long)socket4_clampXplus4_timeoutForReleasing, (long)item_.getSocket4_clampXplus4_timeoutForReleasing());
        Assert.assertEquals((long)socket4_clampXplus4_timeoutForUnlocking, (long)item_.getSocket4_clampXplus4_timeoutForUnlocking());
        Assert.assertEquals((long)socket4_deltaAutochangerStandbyPosition, (long)item_.getSocket4_deltaAutochangerStandbyPosition());
        Assert.assertEquals((long)socket4_standbyPosition, (long)item_.getSocket4_standbyPosition());
        Assert.assertEquals((long)socket5_clampXminus5_currentToUnlock, (long)item_.getSocket5_clampXminus5_currentToUnlock());
        Assert.assertEquals((long)socket5_clampXminus5_filterPresenceMaxValue, (long)item_.getSocket5_clampXminus5_filterPresenceMaxValue());
        Assert.assertEquals((long)socket5_clampXminus5_filterPresenceOffset3, (long)item_.getSocket5_clampXminus5_filterPresenceOffset3());
        Assert.assertEquals((long)socket5_clampXminus5_timeoutForReleasing, (long)item_.getSocket5_clampXminus5_timeoutForReleasing());
        Assert.assertEquals((long)socket5_clampXminus5_timeoutForUnlocking, (long)item_.getSocket5_clampXminus5_timeoutForUnlocking());
        Assert.assertEquals((long)socket5_clampXplus5_currentToUnlock, (long)item_.getSocket5_clampXplus5_currentToUnlock());
        Assert.assertEquals((long)socket5_clampXplus5_filterPresenceMaxValue, (long)item_.getSocket5_clampXplus5_filterPresenceMaxValue());
        Assert.assertEquals((long)socket5_clampXplus5_filterPresenceOffset3, (long)item_.getSocket5_clampXplus5_filterPresenceOffset3());
        Assert.assertEquals((long)socket5_clampXplus5_timeoutForReleasing, (long)item_.getSocket5_clampXplus5_timeoutForReleasing());
        Assert.assertEquals((long)socket5_clampXplus5_timeoutForUnlocking, (long)item_.getSocket5_clampXplus5_timeoutForUnlocking());
        Assert.assertEquals((long)socket5_deltaAutochangerStandbyPosition, (long)item_.getSocket5_deltaAutochangerStandbyPosition());
        Assert.assertEquals((long)socket5_standbyPosition, (long)item_.getSocket5_standbyPosition());
        Assert.assertEquals((long)timeToPrepareUnlock, (long)item_.getTimeToPrepareUnlock());
        Assert.assertEquals((long)timeToUpdateProtectionSystem, (long)item_.getTimeToUpdateProtectionSystem());
    }

    @Test
    public void sendReceiveFcs_Carousel_readRateConfigurationEvent() throws Exception {
        String version = "";
        int readSensorsRate = 87;
        int socket1_clampXminus1_readSensorsRate = 698;
        int socket1_clampXplus1_readSensorsRate = 623;
        int socket2_clampXminus2_readSensorsRate = 787;
        int socket2_clampXplus2_readSensorsRate = 226;
        int socket3_clampXminus3_readSensorsRate = 384;
        int socket3_clampXplus3_readSensorsRate = 266;
        int socket4_clampXminus4_readSensorsRate = 344;
        int socket4_clampXplus4_readSensorsRate = 789;
        int socket5_clampXminus5_readSensorsRate = 49;
        int socket5_clampXplus5_readSensorsRate = 400;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Carousel_readRateConfigurationEvent(version, readSensorsRate, socket1_clampXminus1_readSensorsRate, socket1_clampXplus1_readSensorsRate, socket2_clampXminus2_readSensorsRate, socket2_clampXplus2_readSensorsRate, socket3_clampXminus3_readSensorsRate, socket3_clampXplus3_readSensorsRate, socket4_clampXminus4_readSensorsRate, socket4_clampXplus4_readSensorsRate, socket5_clampXminus5_readSensorsRate, socket5_clampXplus5_readSensorsRate));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_readRateConfigurationEvent));
        Fcs_Carousel_readRateConfigurationEvent item_ = (Fcs_Carousel_readRateConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)readSensorsRate, (long)item_.getReadSensorsRate());
        Assert.assertEquals((long)socket1_clampXminus1_readSensorsRate, (long)item_.getSocket1_clampXminus1_readSensorsRate());
        Assert.assertEquals((long)socket1_clampXplus1_readSensorsRate, (long)item_.getSocket1_clampXplus1_readSensorsRate());
        Assert.assertEquals((long)socket2_clampXminus2_readSensorsRate, (long)item_.getSocket2_clampXminus2_readSensorsRate());
        Assert.assertEquals((long)socket2_clampXplus2_readSensorsRate, (long)item_.getSocket2_clampXplus2_readSensorsRate());
        Assert.assertEquals((long)socket3_clampXminus3_readSensorsRate, (long)item_.getSocket3_clampXminus3_readSensorsRate());
        Assert.assertEquals((long)socket3_clampXplus3_readSensorsRate, (long)item_.getSocket3_clampXplus3_readSensorsRate());
        Assert.assertEquals((long)socket4_clampXminus4_readSensorsRate, (long)item_.getSocket4_clampXminus4_readSensorsRate());
        Assert.assertEquals((long)socket4_clampXplus4_readSensorsRate, (long)item_.getSocket4_clampXplus4_readSensorsRate());
        Assert.assertEquals((long)socket5_clampXminus5_readSensorsRate, (long)item_.getSocket5_clampXminus5_readSensorsRate());
        Assert.assertEquals((long)socket5_clampXplus5_readSensorsRate, (long)item_.getSocket5_clampXplus5_readSensorsRate());
    }

    @Test
    public void sendReceiveFcs_Carousel_sensorConfigurationEvent() throws Exception {
        String version = "";
        int plc_caAF3_bitNumero = 509;
        int plc_caAF3_byteNumero = 291;
        String plc_caAF3_deviceName = "e";
        int plc_caAF3b_bitNumero = 959;
        int plc_caAF3b_byteNumero = 687;
        String plc_caAF3b_deviceName = "";
        int plc_caAP1_bitNumero = 672;
        int plc_caAP1_byteNumero = 257;
        String plc_caAP1_deviceName = "";
        int plc_caAP1b_bitNumero = 524;
        int plc_caAP1b_byteNumero = 798;
        String plc_caAP1b_deviceName = "q";
        int plc_caAP2_bitNumero = 993;
        int plc_caAP2_byteNumero = 165;
        String plc_caAP2_deviceName = "c";
        int plc_caAP2b_bitNumero = 583;
        int plc_caAP2b_byteNumero = 581;
        String plc_caAP2b_deviceName = "z";
        int plc_caAP3_bitNumero = 10;
        int plc_caAP3_byteNumero = 994;
        String plc_caAP3_deviceName = "a";
        int plc_caAP3b_bitNumero = 601;
        int plc_caAP3b_byteNumero = 979;
        String plc_caAP3b_deviceName = "s";
        int plc_caBrakesActivated_bitNumero = 408;
        int plc_caBrakesActivated_byteNumero = 974;
        String plc_caBrakesActivated_deviceName = "";
        int plc_caCF0_bitNumero = 561;
        int plc_caCF0_byteNumero = 572;
        String plc_caCF0_deviceName = "s";
        int plc_caCF0b_bitNumero = 790;
        int plc_caCF0b_byteNumero = 466;
        String plc_caCF0b_deviceName = "m";
        int plc_caCF1_bitNumero = 999;
        int plc_caCF1_byteNumero = 753;
        String plc_caCF1_deviceName = "l";
        int plc_caCF1b_bitNumero = 176;
        int plc_caCF1b_byteNumero = 774;
        String plc_caCF1b_deviceName = "";
        int plc_caCFC_bitNumero = 965;
        int plc_caCFC_byteNumero = 920;
        String plc_caCFC_deviceName = "";
        int plc_caCFCb_bitNumero = 951;
        int plc_caCFCb_byteNumero = 91;
        String plc_caCFCb_deviceName = "t";
        int plc_caCS_bitNumero = 791;
        int plc_caCS_byteNumero = 221;
        String plc_caCS_deviceName = "";
        int plc_caCSb_bitNumero = 149;
        int plc_caCSb_byteNumero = 557;
        String plc_caCSb_deviceName = "";
        int plc_caEnableBrakes_bitNumero = 22;
        int plc_caEnableBrakes_byteNumero = 850;
        String plc_caEnableBrakes_deviceName = "x";
        int plc_caEnableRotation_bitNumero = 616;
        int plc_caEnableRotation_byteNumero = 330;
        String plc_caEnableRotation_deviceName = "";
        int plc_caEnableShutter_bitNumero = 853;
        int plc_caEnableShutter_byteNumero = 727;
        String plc_caEnableShutter_deviceName = "w";
        int plc_caEnableUnclamp_bitNumero = 871;
        int plc_caEnableUnclamp_byteNumero = 638;
        String plc_caEnableUnclamp_deviceName = "";
        int plc_caEng_bitNumero = 920;
        int plc_caEng_byteNumero = 83;
        String plc_caEng_deviceName = "m";
        int plc_caEngb_bitNumero = 738;
        int plc_caEngb_byteNumero = 18;
        String plc_caEngb_deviceName = "";
        int plc_caLockout_bitNumero = 644;
        int plc_caLockout_byteNumero = 943;
        String plc_caLockout_deviceName = "";
        int plc_caLockoutb_bitNumero = 306;
        int plc_caLockoutb_byteNumero = 45;
        String plc_caLockoutb_deviceName = "";
        int plc_caShutterInactive_bitNumero = 337;
        int plc_caShutterInactive_byteNumero = 452;
        String plc_caShutterInactive_deviceName = "";
        int plc_caSleep_bitNumero = 211;
        int plc_caSleep_byteNumero = 591;
        String plc_caSleep_deviceName = "q";
        int plc_enableShutterInterlock_bitNumero = 548;
        int plc_enableShutterInterlock_byteNumero = 748;
        String plc_enableShutterInterlock_deviceName = "h";
        int plc_okDI_bitNumero = 183;
        int plc_okDI_byteNumero = 850;
        String plc_okDI_deviceName = "";
        int plc_okDIsafety_bitNumero = 595;
        int plc_okDIsafety_byteNumero = 560;
        String plc_okDIsafety_deviceName = "d";
        int plc_powerSave_bitNumero = 260;
        int plc_powerSave_byteNumero = 575;
        String plc_powerSave_deviceName = "";
        int plc_tpCheckRotation_bitNumero = 661;
        int plc_tpCheckRotation_byteNumero = 422;
        String plc_tpCheckRotation_deviceName = "x";
        int plc_tpStopRotation_bitNumero = 417;
        int plc_tpStopRotation_byteNumero = 791;
        String plc_tpStopRotation_deviceName = "h";
        int plc_tpStopUnclamp_bitNumero = 590;
        int plc_tpStopUnclamp_byteNumero = 973;
        String plc_tpStopUnclamp_deviceName = "t";
        String socket1_clampXminus1_filterPresenceXminus1_deviceName = "e";
        String socket1_clampXminus1_lockSensorXminus1_deviceName = "";
        String socket1_clampXplus1_filterPresenceXplus1_deviceName = "";
        String socket1_clampXplus1_lockSensorXplus1_deviceName = "";
        String socket1_ioModuleSensor1_deviceName = "";
        String socket2_clampXminus2_filterPresenceXminus2_deviceName = "";
        String socket2_clampXminus2_lockSensorXminus2_deviceName = "h";
        String socket2_clampXplus2_filterPresenceXplus2_deviceName = "";
        String socket2_clampXplus2_lockSensorXplus2_deviceName = "";
        String socket2_ioModuleSensor2_deviceName = "";
        String socket3_clampXminus3_filterPresenceXminus3_deviceName = "";
        String socket3_clampXminus3_lockSensorXminus3_deviceName = "";
        String socket3_clampXplus3_filterPresenceXplus3_deviceName = "v";
        String socket3_clampXplus3_lockSensorXplus3_deviceName = "p";
        String socket3_ioModuleSensor3_deviceName = "";
        String socket4_clampXminus4_filterPresenceXminus4_deviceName = "";
        String socket4_clampXminus4_lockSensorXminus4_deviceName = "";
        String socket4_clampXplus4_filterPresenceXplus4_deviceName = "g";
        String socket4_clampXplus4_lockSensorXplus4_deviceName = "";
        String socket4_ioModuleSensor4_deviceName = "u";
        String socket5_clampXminus5_filterPresenceXminus5_deviceName = "g";
        String socket5_clampXminus5_lockSensorXminus5_deviceName = "";
        String socket5_clampXplus5_filterPresenceXplus5_deviceName = "o";
        String socket5_clampXplus5_lockSensorXplus5_deviceName = "b";
        String socket5_ioModuleSensor5_deviceName = "z";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Carousel_sensorConfigurationEvent(version, plc_caAF3_bitNumero, plc_caAF3_byteNumero, plc_caAF3_deviceName, plc_caAF3b_bitNumero, plc_caAF3b_byteNumero, plc_caAF3b_deviceName, plc_caAP1_bitNumero, plc_caAP1_byteNumero, plc_caAP1_deviceName, plc_caAP1b_bitNumero, plc_caAP1b_byteNumero, plc_caAP1b_deviceName, plc_caAP2_bitNumero, plc_caAP2_byteNumero, plc_caAP2_deviceName, plc_caAP2b_bitNumero, plc_caAP2b_byteNumero, plc_caAP2b_deviceName, plc_caAP3_bitNumero, plc_caAP3_byteNumero, plc_caAP3_deviceName, plc_caAP3b_bitNumero, plc_caAP3b_byteNumero, plc_caAP3b_deviceName, plc_caBrakesActivated_bitNumero, plc_caBrakesActivated_byteNumero, plc_caBrakesActivated_deviceName, plc_caCF0_bitNumero, plc_caCF0_byteNumero, plc_caCF0_deviceName, plc_caCF0b_bitNumero, plc_caCF0b_byteNumero, plc_caCF0b_deviceName, plc_caCF1_bitNumero, plc_caCF1_byteNumero, plc_caCF1_deviceName, plc_caCF1b_bitNumero, plc_caCF1b_byteNumero, plc_caCF1b_deviceName, plc_caCFC_bitNumero, plc_caCFC_byteNumero, plc_caCFC_deviceName, plc_caCFCb_bitNumero, plc_caCFCb_byteNumero, plc_caCFCb_deviceName, plc_caCS_bitNumero, plc_caCS_byteNumero, plc_caCS_deviceName, plc_caCSb_bitNumero, plc_caCSb_byteNumero, plc_caCSb_deviceName, plc_caEnableBrakes_bitNumero, plc_caEnableBrakes_byteNumero, plc_caEnableBrakes_deviceName, plc_caEnableRotation_bitNumero, plc_caEnableRotation_byteNumero, plc_caEnableRotation_deviceName, plc_caEnableShutter_bitNumero, plc_caEnableShutter_byteNumero, plc_caEnableShutter_deviceName, plc_caEnableUnclamp_bitNumero, plc_caEnableUnclamp_byteNumero, plc_caEnableUnclamp_deviceName, plc_caEng_bitNumero, plc_caEng_byteNumero, plc_caEng_deviceName, plc_caEngb_bitNumero, plc_caEngb_byteNumero, plc_caEngb_deviceName, plc_caLockout_bitNumero, plc_caLockout_byteNumero, plc_caLockout_deviceName, plc_caLockoutb_bitNumero, plc_caLockoutb_byteNumero, plc_caLockoutb_deviceName, plc_caShutterInactive_bitNumero, plc_caShutterInactive_byteNumero, plc_caShutterInactive_deviceName, plc_caSleep_bitNumero, plc_caSleep_byteNumero, plc_caSleep_deviceName, plc_enableShutterInterlock_bitNumero, plc_enableShutterInterlock_byteNumero, plc_enableShutterInterlock_deviceName, plc_okDI_bitNumero, plc_okDI_byteNumero, plc_okDI_deviceName, plc_okDIsafety_bitNumero, plc_okDIsafety_byteNumero, plc_okDIsafety_deviceName, plc_powerSave_bitNumero, plc_powerSave_byteNumero, plc_powerSave_deviceName, plc_tpCheckRotation_bitNumero, plc_tpCheckRotation_byteNumero, plc_tpCheckRotation_deviceName, plc_tpStopRotation_bitNumero, plc_tpStopRotation_byteNumero, plc_tpStopRotation_deviceName, plc_tpStopUnclamp_bitNumero, plc_tpStopUnclamp_byteNumero, plc_tpStopUnclamp_deviceName, socket1_clampXminus1_filterPresenceXminus1_deviceName, socket1_clampXminus1_lockSensorXminus1_deviceName, socket1_clampXplus1_filterPresenceXplus1_deviceName, socket1_clampXplus1_lockSensorXplus1_deviceName, socket1_ioModuleSensor1_deviceName, socket2_clampXminus2_filterPresenceXminus2_deviceName, socket2_clampXminus2_lockSensorXminus2_deviceName, socket2_clampXplus2_filterPresenceXplus2_deviceName, socket2_clampXplus2_lockSensorXplus2_deviceName, socket2_ioModuleSensor2_deviceName, socket3_clampXminus3_filterPresenceXminus3_deviceName, socket3_clampXminus3_lockSensorXminus3_deviceName, socket3_clampXplus3_filterPresenceXplus3_deviceName, socket3_clampXplus3_lockSensorXplus3_deviceName, socket3_ioModuleSensor3_deviceName, socket4_clampXminus4_filterPresenceXminus4_deviceName, socket4_clampXminus4_lockSensorXminus4_deviceName, socket4_clampXplus4_filterPresenceXplus4_deviceName, socket4_clampXplus4_lockSensorXplus4_deviceName, socket4_ioModuleSensor4_deviceName, socket5_clampXminus5_filterPresenceXminus5_deviceName, socket5_clampXminus5_lockSensorXminus5_deviceName, socket5_clampXplus5_filterPresenceXplus5_deviceName, socket5_clampXplus5_lockSensorXplus5_deviceName, socket5_ioModuleSensor5_deviceName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_sensorConfigurationEvent));
        Fcs_Carousel_sensorConfigurationEvent item_ = (Fcs_Carousel_sensorConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)plc_caAF3_bitNumero, (long)item_.getPlc_caAF3_bitNumero());
        Assert.assertEquals((long)plc_caAF3_byteNumero, (long)item_.getPlc_caAF3_byteNumero());
        Assert.assertEquals((Object)plc_caAF3_deviceName, (Object)item_.getPlc_caAF3_deviceName());
        Assert.assertEquals((long)plc_caAF3b_bitNumero, (long)item_.getPlc_caAF3b_bitNumero());
        Assert.assertEquals((long)plc_caAF3b_byteNumero, (long)item_.getPlc_caAF3b_byteNumero());
        Assert.assertEquals((Object)plc_caAF3b_deviceName, (Object)item_.getPlc_caAF3b_deviceName());
        Assert.assertEquals((long)plc_caAP1_bitNumero, (long)item_.getPlc_caAP1_bitNumero());
        Assert.assertEquals((long)plc_caAP1_byteNumero, (long)item_.getPlc_caAP1_byteNumero());
        Assert.assertEquals((Object)plc_caAP1_deviceName, (Object)item_.getPlc_caAP1_deviceName());
        Assert.assertEquals((long)plc_caAP1b_bitNumero, (long)item_.getPlc_caAP1b_bitNumero());
        Assert.assertEquals((long)plc_caAP1b_byteNumero, (long)item_.getPlc_caAP1b_byteNumero());
        Assert.assertEquals((Object)plc_caAP1b_deviceName, (Object)item_.getPlc_caAP1b_deviceName());
        Assert.assertEquals((long)plc_caAP2_bitNumero, (long)item_.getPlc_caAP2_bitNumero());
        Assert.assertEquals((long)plc_caAP2_byteNumero, (long)item_.getPlc_caAP2_byteNumero());
        Assert.assertEquals((Object)plc_caAP2_deviceName, (Object)item_.getPlc_caAP2_deviceName());
        Assert.assertEquals((long)plc_caAP2b_bitNumero, (long)item_.getPlc_caAP2b_bitNumero());
        Assert.assertEquals((long)plc_caAP2b_byteNumero, (long)item_.getPlc_caAP2b_byteNumero());
        Assert.assertEquals((Object)plc_caAP2b_deviceName, (Object)item_.getPlc_caAP2b_deviceName());
        Assert.assertEquals((long)plc_caAP3_bitNumero, (long)item_.getPlc_caAP3_bitNumero());
        Assert.assertEquals((long)plc_caAP3_byteNumero, (long)item_.getPlc_caAP3_byteNumero());
        Assert.assertEquals((Object)plc_caAP3_deviceName, (Object)item_.getPlc_caAP3_deviceName());
        Assert.assertEquals((long)plc_caAP3b_bitNumero, (long)item_.getPlc_caAP3b_bitNumero());
        Assert.assertEquals((long)plc_caAP3b_byteNumero, (long)item_.getPlc_caAP3b_byteNumero());
        Assert.assertEquals((Object)plc_caAP3b_deviceName, (Object)item_.getPlc_caAP3b_deviceName());
        Assert.assertEquals((long)plc_caBrakesActivated_bitNumero, (long)item_.getPlc_caBrakesActivated_bitNumero());
        Assert.assertEquals((long)plc_caBrakesActivated_byteNumero, (long)item_.getPlc_caBrakesActivated_byteNumero());
        Assert.assertEquals((Object)plc_caBrakesActivated_deviceName, (Object)item_.getPlc_caBrakesActivated_deviceName());
        Assert.assertEquals((long)plc_caCF0_bitNumero, (long)item_.getPlc_caCF0_bitNumero());
        Assert.assertEquals((long)plc_caCF0_byteNumero, (long)item_.getPlc_caCF0_byteNumero());
        Assert.assertEquals((Object)plc_caCF0_deviceName, (Object)item_.getPlc_caCF0_deviceName());
        Assert.assertEquals((long)plc_caCF0b_bitNumero, (long)item_.getPlc_caCF0b_bitNumero());
        Assert.assertEquals((long)plc_caCF0b_byteNumero, (long)item_.getPlc_caCF0b_byteNumero());
        Assert.assertEquals((Object)plc_caCF0b_deviceName, (Object)item_.getPlc_caCF0b_deviceName());
        Assert.assertEquals((long)plc_caCF1_bitNumero, (long)item_.getPlc_caCF1_bitNumero());
        Assert.assertEquals((long)plc_caCF1_byteNumero, (long)item_.getPlc_caCF1_byteNumero());
        Assert.assertEquals((Object)plc_caCF1_deviceName, (Object)item_.getPlc_caCF1_deviceName());
        Assert.assertEquals((long)plc_caCF1b_bitNumero, (long)item_.getPlc_caCF1b_bitNumero());
        Assert.assertEquals((long)plc_caCF1b_byteNumero, (long)item_.getPlc_caCF1b_byteNumero());
        Assert.assertEquals((Object)plc_caCF1b_deviceName, (Object)item_.getPlc_caCF1b_deviceName());
        Assert.assertEquals((long)plc_caCFC_bitNumero, (long)item_.getPlc_caCFC_bitNumero());
        Assert.assertEquals((long)plc_caCFC_byteNumero, (long)item_.getPlc_caCFC_byteNumero());
        Assert.assertEquals((Object)plc_caCFC_deviceName, (Object)item_.getPlc_caCFC_deviceName());
        Assert.assertEquals((long)plc_caCFCb_bitNumero, (long)item_.getPlc_caCFCb_bitNumero());
        Assert.assertEquals((long)plc_caCFCb_byteNumero, (long)item_.getPlc_caCFCb_byteNumero());
        Assert.assertEquals((Object)plc_caCFCb_deviceName, (Object)item_.getPlc_caCFCb_deviceName());
        Assert.assertEquals((long)plc_caCS_bitNumero, (long)item_.getPlc_caCS_bitNumero());
        Assert.assertEquals((long)plc_caCS_byteNumero, (long)item_.getPlc_caCS_byteNumero());
        Assert.assertEquals((Object)plc_caCS_deviceName, (Object)item_.getPlc_caCS_deviceName());
        Assert.assertEquals((long)plc_caCSb_bitNumero, (long)item_.getPlc_caCSb_bitNumero());
        Assert.assertEquals((long)plc_caCSb_byteNumero, (long)item_.getPlc_caCSb_byteNumero());
        Assert.assertEquals((Object)plc_caCSb_deviceName, (Object)item_.getPlc_caCSb_deviceName());
        Assert.assertEquals((long)plc_caEnableBrakes_bitNumero, (long)item_.getPlc_caEnableBrakes_bitNumero());
        Assert.assertEquals((long)plc_caEnableBrakes_byteNumero, (long)item_.getPlc_caEnableBrakes_byteNumero());
        Assert.assertEquals((Object)plc_caEnableBrakes_deviceName, (Object)item_.getPlc_caEnableBrakes_deviceName());
        Assert.assertEquals((long)plc_caEnableRotation_bitNumero, (long)item_.getPlc_caEnableRotation_bitNumero());
        Assert.assertEquals((long)plc_caEnableRotation_byteNumero, (long)item_.getPlc_caEnableRotation_byteNumero());
        Assert.assertEquals((Object)plc_caEnableRotation_deviceName, (Object)item_.getPlc_caEnableRotation_deviceName());
        Assert.assertEquals((long)plc_caEnableShutter_bitNumero, (long)item_.getPlc_caEnableShutter_bitNumero());
        Assert.assertEquals((long)plc_caEnableShutter_byteNumero, (long)item_.getPlc_caEnableShutter_byteNumero());
        Assert.assertEquals((Object)plc_caEnableShutter_deviceName, (Object)item_.getPlc_caEnableShutter_deviceName());
        Assert.assertEquals((long)plc_caEnableUnclamp_bitNumero, (long)item_.getPlc_caEnableUnclamp_bitNumero());
        Assert.assertEquals((long)plc_caEnableUnclamp_byteNumero, (long)item_.getPlc_caEnableUnclamp_byteNumero());
        Assert.assertEquals((Object)plc_caEnableUnclamp_deviceName, (Object)item_.getPlc_caEnableUnclamp_deviceName());
        Assert.assertEquals((long)plc_caEng_bitNumero, (long)item_.getPlc_caEng_bitNumero());
        Assert.assertEquals((long)plc_caEng_byteNumero, (long)item_.getPlc_caEng_byteNumero());
        Assert.assertEquals((Object)plc_caEng_deviceName, (Object)item_.getPlc_caEng_deviceName());
        Assert.assertEquals((long)plc_caEngb_bitNumero, (long)item_.getPlc_caEngb_bitNumero());
        Assert.assertEquals((long)plc_caEngb_byteNumero, (long)item_.getPlc_caEngb_byteNumero());
        Assert.assertEquals((Object)plc_caEngb_deviceName, (Object)item_.getPlc_caEngb_deviceName());
        Assert.assertEquals((long)plc_caLockout_bitNumero, (long)item_.getPlc_caLockout_bitNumero());
        Assert.assertEquals((long)plc_caLockout_byteNumero, (long)item_.getPlc_caLockout_byteNumero());
        Assert.assertEquals((Object)plc_caLockout_deviceName, (Object)item_.getPlc_caLockout_deviceName());
        Assert.assertEquals((long)plc_caLockoutb_bitNumero, (long)item_.getPlc_caLockoutb_bitNumero());
        Assert.assertEquals((long)plc_caLockoutb_byteNumero, (long)item_.getPlc_caLockoutb_byteNumero());
        Assert.assertEquals((Object)plc_caLockoutb_deviceName, (Object)item_.getPlc_caLockoutb_deviceName());
        Assert.assertEquals((long)plc_caShutterInactive_bitNumero, (long)item_.getPlc_caShutterInactive_bitNumero());
        Assert.assertEquals((long)plc_caShutterInactive_byteNumero, (long)item_.getPlc_caShutterInactive_byteNumero());
        Assert.assertEquals((Object)plc_caShutterInactive_deviceName, (Object)item_.getPlc_caShutterInactive_deviceName());
        Assert.assertEquals((long)plc_caSleep_bitNumero, (long)item_.getPlc_caSleep_bitNumero());
        Assert.assertEquals((long)plc_caSleep_byteNumero, (long)item_.getPlc_caSleep_byteNumero());
        Assert.assertEquals((Object)plc_caSleep_deviceName, (Object)item_.getPlc_caSleep_deviceName());
        Assert.assertEquals((long)plc_enableShutterInterlock_bitNumero, (long)item_.getPlc_enableShutterInterlock_bitNumero());
        Assert.assertEquals((long)plc_enableShutterInterlock_byteNumero, (long)item_.getPlc_enableShutterInterlock_byteNumero());
        Assert.assertEquals((Object)plc_enableShutterInterlock_deviceName, (Object)item_.getPlc_enableShutterInterlock_deviceName());
        Assert.assertEquals((long)plc_okDI_bitNumero, (long)item_.getPlc_okDI_bitNumero());
        Assert.assertEquals((long)plc_okDI_byteNumero, (long)item_.getPlc_okDI_byteNumero());
        Assert.assertEquals((Object)plc_okDI_deviceName, (Object)item_.getPlc_okDI_deviceName());
        Assert.assertEquals((long)plc_okDIsafety_bitNumero, (long)item_.getPlc_okDIsafety_bitNumero());
        Assert.assertEquals((long)plc_okDIsafety_byteNumero, (long)item_.getPlc_okDIsafety_byteNumero());
        Assert.assertEquals((Object)plc_okDIsafety_deviceName, (Object)item_.getPlc_okDIsafety_deviceName());
        Assert.assertEquals((long)plc_powerSave_bitNumero, (long)item_.getPlc_powerSave_bitNumero());
        Assert.assertEquals((long)plc_powerSave_byteNumero, (long)item_.getPlc_powerSave_byteNumero());
        Assert.assertEquals((Object)plc_powerSave_deviceName, (Object)item_.getPlc_powerSave_deviceName());
        Assert.assertEquals((long)plc_tpCheckRotation_bitNumero, (long)item_.getPlc_tpCheckRotation_bitNumero());
        Assert.assertEquals((long)plc_tpCheckRotation_byteNumero, (long)item_.getPlc_tpCheckRotation_byteNumero());
        Assert.assertEquals((Object)plc_tpCheckRotation_deviceName, (Object)item_.getPlc_tpCheckRotation_deviceName());
        Assert.assertEquals((long)plc_tpStopRotation_bitNumero, (long)item_.getPlc_tpStopRotation_bitNumero());
        Assert.assertEquals((long)plc_tpStopRotation_byteNumero, (long)item_.getPlc_tpStopRotation_byteNumero());
        Assert.assertEquals((Object)plc_tpStopRotation_deviceName, (Object)item_.getPlc_tpStopRotation_deviceName());
        Assert.assertEquals((long)plc_tpStopUnclamp_bitNumero, (long)item_.getPlc_tpStopUnclamp_bitNumero());
        Assert.assertEquals((long)plc_tpStopUnclamp_byteNumero, (long)item_.getPlc_tpStopUnclamp_byteNumero());
        Assert.assertEquals((Object)plc_tpStopUnclamp_deviceName, (Object)item_.getPlc_tpStopUnclamp_deviceName());
        Assert.assertEquals((Object)socket1_clampXminus1_filterPresenceXminus1_deviceName, (Object)item_.getSocket1_clampXminus1_filterPresenceXminus1_deviceName());
        Assert.assertEquals((Object)socket1_clampXminus1_lockSensorXminus1_deviceName, (Object)item_.getSocket1_clampXminus1_lockSensorXminus1_deviceName());
        Assert.assertEquals((Object)socket1_clampXplus1_filterPresenceXplus1_deviceName, (Object)item_.getSocket1_clampXplus1_filterPresenceXplus1_deviceName());
        Assert.assertEquals((Object)socket1_clampXplus1_lockSensorXplus1_deviceName, (Object)item_.getSocket1_clampXplus1_lockSensorXplus1_deviceName());
        Assert.assertEquals((Object)socket1_ioModuleSensor1_deviceName, (Object)item_.getSocket1_ioModuleSensor1_deviceName());
        Assert.assertEquals((Object)socket2_clampXminus2_filterPresenceXminus2_deviceName, (Object)item_.getSocket2_clampXminus2_filterPresenceXminus2_deviceName());
        Assert.assertEquals((Object)socket2_clampXminus2_lockSensorXminus2_deviceName, (Object)item_.getSocket2_clampXminus2_lockSensorXminus2_deviceName());
        Assert.assertEquals((Object)socket2_clampXplus2_filterPresenceXplus2_deviceName, (Object)item_.getSocket2_clampXplus2_filterPresenceXplus2_deviceName());
        Assert.assertEquals((Object)socket2_clampXplus2_lockSensorXplus2_deviceName, (Object)item_.getSocket2_clampXplus2_lockSensorXplus2_deviceName());
        Assert.assertEquals((Object)socket2_ioModuleSensor2_deviceName, (Object)item_.getSocket2_ioModuleSensor2_deviceName());
        Assert.assertEquals((Object)socket3_clampXminus3_filterPresenceXminus3_deviceName, (Object)item_.getSocket3_clampXminus3_filterPresenceXminus3_deviceName());
        Assert.assertEquals((Object)socket3_clampXminus3_lockSensorXminus3_deviceName, (Object)item_.getSocket3_clampXminus3_lockSensorXminus3_deviceName());
        Assert.assertEquals((Object)socket3_clampXplus3_filterPresenceXplus3_deviceName, (Object)item_.getSocket3_clampXplus3_filterPresenceXplus3_deviceName());
        Assert.assertEquals((Object)socket3_clampXplus3_lockSensorXplus3_deviceName, (Object)item_.getSocket3_clampXplus3_lockSensorXplus3_deviceName());
        Assert.assertEquals((Object)socket3_ioModuleSensor3_deviceName, (Object)item_.getSocket3_ioModuleSensor3_deviceName());
        Assert.assertEquals((Object)socket4_clampXminus4_filterPresenceXminus4_deviceName, (Object)item_.getSocket4_clampXminus4_filterPresenceXminus4_deviceName());
        Assert.assertEquals((Object)socket4_clampXminus4_lockSensorXminus4_deviceName, (Object)item_.getSocket4_clampXminus4_lockSensorXminus4_deviceName());
        Assert.assertEquals((Object)socket4_clampXplus4_filterPresenceXplus4_deviceName, (Object)item_.getSocket4_clampXplus4_filterPresenceXplus4_deviceName());
        Assert.assertEquals((Object)socket4_clampXplus4_lockSensorXplus4_deviceName, (Object)item_.getSocket4_clampXplus4_lockSensorXplus4_deviceName());
        Assert.assertEquals((Object)socket4_ioModuleSensor4_deviceName, (Object)item_.getSocket4_ioModuleSensor4_deviceName());
        Assert.assertEquals((Object)socket5_clampXminus5_filterPresenceXminus5_deviceName, (Object)item_.getSocket5_clampXminus5_filterPresenceXminus5_deviceName());
        Assert.assertEquals((Object)socket5_clampXminus5_lockSensorXminus5_deviceName, (Object)item_.getSocket5_clampXminus5_lockSensorXminus5_deviceName());
        Assert.assertEquals((Object)socket5_clampXplus5_filterPresenceXplus5_deviceName, (Object)item_.getSocket5_clampXplus5_filterPresenceXplus5_deviceName());
        Assert.assertEquals((Object)socket5_clampXplus5_lockSensorXplus5_deviceName, (Object)item_.getSocket5_clampXplus5_lockSensorXplus5_deviceName());
        Assert.assertEquals((Object)socket5_ioModuleSensor5_deviceName, (Object)item_.getSocket5_ioModuleSensor5_deviceName());
    }

    @Test
    public void sendReceiveFcs_FilterIdentificator_sensorConfigurationEvent() throws Exception {
        String version = "c";
        int filteridsensor0_byteNumero = 387;
        String filteridsensor0_dioName = "";
        int filteridsensor0_inputNumero = 4;
        int filteridsensor1_byteNumero = 118;
        String filteridsensor1_dioName = "r";
        int filteridsensor1_inputNumero = 457;
        int filteridsensor2_byteNumero = 157;
        String filteridsensor2_dioName = "h";
        int filteridsensor2_inputNumero = 706;
        int filteridsensor3_byteNumero = 345;
        String filteridsensor3_dioName = "d";
        int filteridsensor3_inputNumero = 672;
        int filteridsensor4_byteNumero = 186;
        String filteridsensor4_dioName = "l";
        int filteridsensor4_inputNumero = 457;
        int filteridsensor5_byteNumero = 876;
        String filteridsensor5_dioName = "";
        int filteridsensor5_inputNumero = 232;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_FilterIdentificator_sensorConfigurationEvent(version, filteridsensor0_byteNumero, filteridsensor0_dioName, filteridsensor0_inputNumero, filteridsensor1_byteNumero, filteridsensor1_dioName, filteridsensor1_inputNumero, filteridsensor2_byteNumero, filteridsensor2_dioName, filteridsensor2_inputNumero, filteridsensor3_byteNumero, filteridsensor3_dioName, filteridsensor3_inputNumero, filteridsensor4_byteNumero, filteridsensor4_dioName, filteridsensor4_inputNumero, filteridsensor5_byteNumero, filteridsensor5_dioName, filteridsensor5_inputNumero));
        Assert.assertTrue((boolean)(item instanceof Fcs_FilterIdentificator_sensorConfigurationEvent));
        Fcs_FilterIdentificator_sensorConfigurationEvent item_ = (Fcs_FilterIdentificator_sensorConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)filteridsensor0_byteNumero, (long)item_.getFilteridsensor0_byteNumero());
        Assert.assertEquals((Object)filteridsensor0_dioName, (Object)item_.getFilteridsensor0_dioName());
        Assert.assertEquals((long)filteridsensor0_inputNumero, (long)item_.getFilteridsensor0_inputNumero());
        Assert.assertEquals((long)filteridsensor1_byteNumero, (long)item_.getFilteridsensor1_byteNumero());
        Assert.assertEquals((Object)filteridsensor1_dioName, (Object)item_.getFilteridsensor1_dioName());
        Assert.assertEquals((long)filteridsensor1_inputNumero, (long)item_.getFilteridsensor1_inputNumero());
        Assert.assertEquals((long)filteridsensor2_byteNumero, (long)item_.getFilteridsensor2_byteNumero());
        Assert.assertEquals((Object)filteridsensor2_dioName, (Object)item_.getFilteridsensor2_dioName());
        Assert.assertEquals((long)filteridsensor2_inputNumero, (long)item_.getFilteridsensor2_inputNumero());
        Assert.assertEquals((long)filteridsensor3_byteNumero, (long)item_.getFilteridsensor3_byteNumero());
        Assert.assertEquals((Object)filteridsensor3_dioName, (Object)item_.getFilteridsensor3_dioName());
        Assert.assertEquals((long)filteridsensor3_inputNumero, (long)item_.getFilteridsensor3_inputNumero());
        Assert.assertEquals((long)filteridsensor4_byteNumero, (long)item_.getFilteridsensor4_byteNumero());
        Assert.assertEquals((Object)filteridsensor4_dioName, (Object)item_.getFilteridsensor4_dioName());
        Assert.assertEquals((long)filteridsensor4_inputNumero, (long)item_.getFilteridsensor4_inputNumero());
        Assert.assertEquals((long)filteridsensor5_byteNumero, (long)item_.getFilteridsensor5_byteNumero());
        Assert.assertEquals((Object)filteridsensor5_dioName, (Object)item_.getFilteridsensor5_dioName());
        Assert.assertEquals((long)filteridsensor5_inputNumero, (long)item_.getFilteridsensor5_inputNumero());
    }

    @Test
    public void sendReceiveFcs_FilterManager_filterConfigurationEvent() throws Exception {
        String version = "";
        String a_family = "";
        int a_filterID = 697;
        double a_weight = 0.9477828145027161;
        String da1_family = "s";
        int da1_filterID = 721;
        double da1_weight = 0.48485177755355835;
        String da2_family = "m";
        int da2_filterID = 804;
        double da2_weight = 0.2756111f;
        String dr1_family = "";
        int dr1_filterID = 231;
        double dr1_weight = 0.28822004795074463;
        String du1_family = "g";
        int du1_filterID = 113;
        double du1_weight = 0.014158666133880615;
        String du2_family = "p";
        int du2_filterID = 974;
        double du2_weight = 0.890504777431488;
        String dz1_family = "";
        int dz1_filterID = 182;
        double dz1_weight = 0.44235873222351074;
        String ef_family = "g";
        int ef_filterID = 859;
        double ef_weight = 0.366751492023468;
        String f15_family = "f";
        int f15_filterID = 563;
        double f15_weight = 0.8885076642036438;
        String f17_family = "t";
        int f17_filterID = 543;
        double f17_weight = 0.19636154174804688;
        String f29_family = "";
        int f29_filterID = 176;
        double f29_weight = 0.6686477661132812;
        String f34_family = "h";
        int f34_filterID = 762;
        double f34_weight = 0.9150266051292419;
        String f3_family = "";
        int f3_filterID = 994;
        double f3_weight = 0.04228156805038452;
        String f46_family = "e";
        int f46_filterID = 822;
        double f46_weight = 0.8637517094612122;
        String f48_family = "s";
        int f48_filterID = 315;
        double f48_weight = 0.8881232738494873;
        String f60_family = "x";
        int f60_filterID = 949;
        double f60_weight = 0.3216143250465393;
        String g_family = "u";
        int g_filterID = 285;
        double g_weight = 0.9373458623886108;
        String i_family = "";
        int i_filterID = 736;
        double i_weight = 0.1699813f;
        String none_family = "";
        int none_filterID = 757;
        double none_weight = 0.2650805711746216;
        String oa_family = "";
        int oa_filterID = 965;
        double oa_weight = 0.3219779133796692;
        String ob_family = "";
        int ob_filterID = 539;
        double ob_weight = 0.3784014f;
        String oc_family = "";
        int oc_filterID = 249;
        double oc_weight = 0.8519304394721985;
        String ph_family = "h";
        int ph_filterID = 620;
        double ph_weight = 0.050605833530426025;
        String r_family = "x";
        int r_filterID = 870;
        double r_weight = 0.998331f;
        String tu_family = "";
        int tu_filterID = 526;
        double tu_weight = 0.6904461979866028;
        String ty_family = "";
        int ty_filterID = 781;
        double ty_weight = 0.28806257247924805;
        String u_family = "";
        int u_filterID = 713;
        double u_weight = 0.05058586597442627;
        String y_family = "";
        int y_filterID = 433;
        double y_weight = 0.8834550380706787;
        String z_family = "";
        int z_filterID = 106;
        double z_weight = 0.7535895705223083;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_FilterManager_filterConfigurationEvent(version, a_family, a_filterID, a_weight, da1_family, da1_filterID, da1_weight, da2_family, da2_filterID, da2_weight, dr1_family, dr1_filterID, dr1_weight, du1_family, du1_filterID, du1_weight, du2_family, du2_filterID, du2_weight, dz1_family, dz1_filterID, dz1_weight, ef_family, ef_filterID, ef_weight, f15_family, f15_filterID, f15_weight, f17_family, f17_filterID, f17_weight, f29_family, f29_filterID, f29_weight, f34_family, f34_filterID, f34_weight, f3_family, f3_filterID, f3_weight, f46_family, f46_filterID, f46_weight, f48_family, f48_filterID, f48_weight, f60_family, f60_filterID, f60_weight, g_family, g_filterID, g_weight, i_family, i_filterID, i_weight, none_family, none_filterID, none_weight, oa_family, oa_filterID, oa_weight, ob_family, ob_filterID, ob_weight, oc_family, oc_filterID, oc_weight, ph_family, ph_filterID, ph_weight, r_family, r_filterID, r_weight, tu_family, tu_filterID, tu_weight, ty_family, ty_filterID, ty_weight, u_family, u_filterID, u_weight, y_family, y_filterID, y_weight, z_family, z_filterID, z_weight));
        Assert.assertTrue((boolean)(item instanceof Fcs_FilterManager_filterConfigurationEvent));
        Fcs_FilterManager_filterConfigurationEvent item_ = (Fcs_FilterManager_filterConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)a_family, (Object)item_.getA_family());
        Assert.assertEquals((long)a_filterID, (long)item_.getA_filterID());
        Assert.assertEquals((double)a_weight, (double)item_.getA_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)da1_family, (Object)item_.getDa1_family());
        Assert.assertEquals((long)da1_filterID, (long)item_.getDa1_filterID());
        Assert.assertEquals((double)da1_weight, (double)item_.getDa1_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)da2_family, (Object)item_.getDa2_family());
        Assert.assertEquals((long)da2_filterID, (long)item_.getDa2_filterID());
        Assert.assertEquals((double)da2_weight, (double)item_.getDa2_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)dr1_family, (Object)item_.getDr1_family());
        Assert.assertEquals((long)dr1_filterID, (long)item_.getDr1_filterID());
        Assert.assertEquals((double)dr1_weight, (double)item_.getDr1_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)du1_family, (Object)item_.getDu1_family());
        Assert.assertEquals((long)du1_filterID, (long)item_.getDu1_filterID());
        Assert.assertEquals((double)du1_weight, (double)item_.getDu1_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)du2_family, (Object)item_.getDu2_family());
        Assert.assertEquals((long)du2_filterID, (long)item_.getDu2_filterID());
        Assert.assertEquals((double)du2_weight, (double)item_.getDu2_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)dz1_family, (Object)item_.getDz1_family());
        Assert.assertEquals((long)dz1_filterID, (long)item_.getDz1_filterID());
        Assert.assertEquals((double)dz1_weight, (double)item_.getDz1_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)ef_family, (Object)item_.getEf_family());
        Assert.assertEquals((long)ef_filterID, (long)item_.getEf_filterID());
        Assert.assertEquals((double)ef_weight, (double)item_.getEf_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f15_family, (Object)item_.getF15_family());
        Assert.assertEquals((long)f15_filterID, (long)item_.getF15_filterID());
        Assert.assertEquals((double)f15_weight, (double)item_.getF15_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f17_family, (Object)item_.getF17_family());
        Assert.assertEquals((long)f17_filterID, (long)item_.getF17_filterID());
        Assert.assertEquals((double)f17_weight, (double)item_.getF17_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f29_family, (Object)item_.getF29_family());
        Assert.assertEquals((long)f29_filterID, (long)item_.getF29_filterID());
        Assert.assertEquals((double)f29_weight, (double)item_.getF29_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f34_family, (Object)item_.getF34_family());
        Assert.assertEquals((long)f34_filterID, (long)item_.getF34_filterID());
        Assert.assertEquals((double)f34_weight, (double)item_.getF34_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f3_family, (Object)item_.getF3_family());
        Assert.assertEquals((long)f3_filterID, (long)item_.getF3_filterID());
        Assert.assertEquals((double)f3_weight, (double)item_.getF3_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f46_family, (Object)item_.getF46_family());
        Assert.assertEquals((long)f46_filterID, (long)item_.getF46_filterID());
        Assert.assertEquals((double)f46_weight, (double)item_.getF46_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f48_family, (Object)item_.getF48_family());
        Assert.assertEquals((long)f48_filterID, (long)item_.getF48_filterID());
        Assert.assertEquals((double)f48_weight, (double)item_.getF48_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f60_family, (Object)item_.getF60_family());
        Assert.assertEquals((long)f60_filterID, (long)item_.getF60_filterID());
        Assert.assertEquals((double)f60_weight, (double)item_.getF60_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)g_family, (Object)item_.getG_family());
        Assert.assertEquals((long)g_filterID, (long)item_.getG_filterID());
        Assert.assertEquals((double)g_weight, (double)item_.getG_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)i_family, (Object)item_.getI_family());
        Assert.assertEquals((long)i_filterID, (long)item_.getI_filterID());
        Assert.assertEquals((double)i_weight, (double)item_.getI_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)none_family, (Object)item_.getNone_family());
        Assert.assertEquals((long)none_filterID, (long)item_.getNone_filterID());
        Assert.assertEquals((double)none_weight, (double)item_.getNone_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)oa_family, (Object)item_.getOa_family());
        Assert.assertEquals((long)oa_filterID, (long)item_.getOa_filterID());
        Assert.assertEquals((double)oa_weight, (double)item_.getOa_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)ob_family, (Object)item_.getOb_family());
        Assert.assertEquals((long)ob_filterID, (long)item_.getOb_filterID());
        Assert.assertEquals((double)ob_weight, (double)item_.getOb_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)oc_family, (Object)item_.getOc_family());
        Assert.assertEquals((long)oc_filterID, (long)item_.getOc_filterID());
        Assert.assertEquals((double)oc_weight, (double)item_.getOc_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)ph_family, (Object)item_.getPh_family());
        Assert.assertEquals((long)ph_filterID, (long)item_.getPh_filterID());
        Assert.assertEquals((double)ph_weight, (double)item_.getPh_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)r_family, (Object)item_.getR_family());
        Assert.assertEquals((long)r_filterID, (long)item_.getR_filterID());
        Assert.assertEquals((double)r_weight, (double)item_.getR_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)tu_family, (Object)item_.getTu_family());
        Assert.assertEquals((long)tu_filterID, (long)item_.getTu_filterID());
        Assert.assertEquals((double)tu_weight, (double)item_.getTu_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)ty_family, (Object)item_.getTy_family());
        Assert.assertEquals((long)ty_filterID, (long)item_.getTy_filterID());
        Assert.assertEquals((double)ty_weight, (double)item_.getTy_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)u_family, (Object)item_.getU_family());
        Assert.assertEquals((long)u_filterID, (long)item_.getU_filterID());
        Assert.assertEquals((double)u_weight, (double)item_.getU_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)y_family, (Object)item_.getY_family());
        Assert.assertEquals((long)y_filterID, (long)item_.getY_filterID());
        Assert.assertEquals((double)y_weight, (double)item_.getY_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)z_family, (Object)item_.getZ_family());
        Assert.assertEquals((long)z_filterID, (long)item_.getZ_filterID());
        Assert.assertEquals((double)z_weight, (double)item_.getZ_weight(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Loader_loaderConfigurationEvent() throws Exception {
        String version = "";
        int carrier_deltaPosition = 517;
        int carrier_engagedPosition = 708;
        int carrier_handoffPosition = 45;
        int carrier_highAcceleration = 666;
        int carrier_highDeceleration = 186;
        int carrier_highSpeed = 833;
        int carrier_lowAcceleration = 410;
        int carrier_lowDeceleration = 180;
        int carrier_lowSpeed = 111;
        int carrier_maxCurrent = 618;
        int carrier_maxSpeed = 275;
        int carrier_storagePosition = 792;
        long carrier_timeoutForGoingToEngaged = 733L;
        long carrier_timeoutForGoingToHandOff = 438L;
        long carrier_timeoutForGoingToStorage = 1L;
        int filterDistanceMin = 894;
        int hooks_absolutePositionToClose = 954;
        int hooks_currentThreshold = 561;
        int hooks_currentToClamp = 307;
        int hooks_currentToOpen = 874;
        int hooks_minClampedVoltage = 842;
        int hooks_relativePositionToUnclamp = 838;
        int hooks_timeoutForClampingHooks = 918;
        int hooks_timeoutForClosingHooks = 26;
        int hooks_timeoutForOpeningHooks = 987;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Loader_loaderConfigurationEvent(version, carrier_deltaPosition, carrier_engagedPosition, carrier_handoffPosition, carrier_highAcceleration, carrier_highDeceleration, carrier_highSpeed, carrier_lowAcceleration, carrier_lowDeceleration, carrier_lowSpeed, carrier_maxCurrent, carrier_maxSpeed, carrier_storagePosition, carrier_timeoutForGoingToEngaged, carrier_timeoutForGoingToHandOff, carrier_timeoutForGoingToStorage, filterDistanceMin, hooks_absolutePositionToClose, hooks_currentThreshold, hooks_currentToClamp, hooks_currentToOpen, hooks_minClampedVoltage, hooks_relativePositionToUnclamp, hooks_timeoutForClampingHooks, hooks_timeoutForClosingHooks, hooks_timeoutForOpeningHooks));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_loaderConfigurationEvent));
        Fcs_Loader_loaderConfigurationEvent item_ = (Fcs_Loader_loaderConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)carrier_deltaPosition, (long)item_.getCarrier_deltaPosition());
        Assert.assertEquals((long)carrier_engagedPosition, (long)item_.getCarrier_engagedPosition());
        Assert.assertEquals((long)carrier_handoffPosition, (long)item_.getCarrier_handoffPosition());
        Assert.assertEquals((long)carrier_highAcceleration, (long)item_.getCarrier_highAcceleration());
        Assert.assertEquals((long)carrier_highDeceleration, (long)item_.getCarrier_highDeceleration());
        Assert.assertEquals((long)carrier_highSpeed, (long)item_.getCarrier_highSpeed());
        Assert.assertEquals((long)carrier_lowAcceleration, (long)item_.getCarrier_lowAcceleration());
        Assert.assertEquals((long)carrier_lowDeceleration, (long)item_.getCarrier_lowDeceleration());
        Assert.assertEquals((long)carrier_lowSpeed, (long)item_.getCarrier_lowSpeed());
        Assert.assertEquals((long)carrier_maxCurrent, (long)item_.getCarrier_maxCurrent());
        Assert.assertEquals((long)carrier_maxSpeed, (long)item_.getCarrier_maxSpeed());
        Assert.assertEquals((long)carrier_storagePosition, (long)item_.getCarrier_storagePosition());
        Assert.assertEquals((long)carrier_timeoutForGoingToEngaged, (long)item_.getCarrier_timeoutForGoingToEngaged());
        Assert.assertEquals((long)carrier_timeoutForGoingToHandOff, (long)item_.getCarrier_timeoutForGoingToHandOff());
        Assert.assertEquals((long)carrier_timeoutForGoingToStorage, (long)item_.getCarrier_timeoutForGoingToStorage());
        Assert.assertEquals((long)filterDistanceMin, (long)item_.getFilterDistanceMin());
        Assert.assertEquals((long)hooks_absolutePositionToClose, (long)item_.getHooks_absolutePositionToClose());
        Assert.assertEquals((long)hooks_currentThreshold, (long)item_.getHooks_currentThreshold());
        Assert.assertEquals((long)hooks_currentToClamp, (long)item_.getHooks_currentToClamp());
        Assert.assertEquals((long)hooks_currentToOpen, (long)item_.getHooks_currentToOpen());
        Assert.assertEquals((long)hooks_minClampedVoltage, (long)item_.getHooks_minClampedVoltage());
        Assert.assertEquals((long)hooks_relativePositionToUnclamp, (long)item_.getHooks_relativePositionToUnclamp());
        Assert.assertEquals((long)hooks_timeoutForClampingHooks, (long)item_.getHooks_timeoutForClampingHooks());
        Assert.assertEquals((long)hooks_timeoutForClosingHooks, (long)item_.getHooks_timeoutForClosingHooks());
        Assert.assertEquals((long)hooks_timeoutForOpeningHooks, (long)item_.getHooks_timeoutForOpeningHooks());
    }

    @Test
    public void sendReceiveFcs_Loader_readRateConfigurationEvent() throws Exception {
        String version = "";
        int carrier_readSensorsRate = 138;
        int hooks_readSensorsRate = 546;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Loader_readRateConfigurationEvent(version, carrier_readSensorsRate, hooks_readSensorsRate));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_readRateConfigurationEvent));
        Fcs_Loader_readRateConfigurationEvent item_ = (Fcs_Loader_readRateConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)carrier_readSensorsRate, (long)item_.getCarrier_readSensorsRate());
        Assert.assertEquals((long)hooks_readSensorsRate, (long)item_.getHooks_readSensorsRate());
    }

    @Test
    public void sendReceiveFcs_Loader_sensorConfigurationEvent() throws Exception {
        String version = "";
        int carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_byteNumero = 473;
        String carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_dioName = "";
        int carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_inputNumero = 51;
        int carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_byteNumero = 452;
        String carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_dioName = "";
        int carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_inputNumero = 605;
        int carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_byteNumero = 978;
        String carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_dioName = "";
        int carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_inputNumero = 344;
        int carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_byteNumero = 732;
        String carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_dioName = "n";
        int carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_inputNumero = 988;
        int carrier_loaderStorageSensors_loaderStoragePositionSensor0_byteNumero = 602;
        String carrier_loaderStorageSensors_loaderStoragePositionSensor0_dioName = "z";
        int carrier_loaderStorageSensors_loaderStoragePositionSensor0_inputNumero = 15;
        int carrier_loaderStorageSensors_loaderStoragePositionSensor1_byteNumero = 44;
        String carrier_loaderStorageSensors_loaderStoragePositionSensor1_dioName = "";
        int carrier_loaderStorageSensors_loaderStoragePositionSensor1_inputNumero = 89;
        int hooks_clampedStatusSensor_byteNumero = 753;
        String hooks_clampedStatusSensor_dioName = "n";
        int hooks_clampedStatusSensor_inputNumero = 108;
        int hooks_forceSensor0_byteNumero = 972;
        String hooks_forceSensor0_deviceName = "t";
        int hooks_forceSensor1_byteNumero = 889;
        String hooks_forceSensor1_deviceName = "q";
        int hooks_hook1_loaderCloseSensor1_byteNumero = 496;
        String hooks_hook1_loaderCloseSensor1_dioName = "";
        int hooks_hook1_loaderCloseSensor1_inputNumero = 613;
        int hooks_hook1_loaderOpenSensor1_byteNumero = 507;
        String hooks_hook1_loaderOpenSensor1_dioName = "";
        int hooks_hook1_loaderOpenSensor1_inputNumero = 392;
        int hooks_hook2_loaderCloseSensor2_byteNumero = 804;
        String hooks_hook2_loaderCloseSensor2_dioName = "w";
        int hooks_hook2_loaderCloseSensor2_inputNumero = 963;
        int hooks_hook2_loaderOpenSensor2_byteNumero = 302;
        String hooks_hook2_loaderOpenSensor2_dioName = "h";
        int hooks_hook2_loaderOpenSensor2_inputNumero = 424;
        int hooks_hook3_loaderCloseSensor3_byteNumero = 188;
        String hooks_hook3_loaderCloseSensor3_dioName = "r";
        int hooks_hook3_loaderCloseSensor3_inputNumero = 40;
        int hooks_hook3_loaderOpenSensor3_byteNumero = 144;
        String hooks_hook3_loaderOpenSensor3_dioName = "u";
        int hooks_hook3_loaderOpenSensor3_inputNumero = 990;
        int hooks_hook4_loaderCloseSensor4_byteNumero = 257;
        String hooks_hook4_loaderCloseSensor4_dioName = "h";
        int hooks_hook4_loaderCloseSensor4_inputNumero = 982;
        int hooks_hook4_loaderOpenSensor4_byteNumero = 282;
        String hooks_hook4_loaderOpenSensor4_dioName = "a";
        int hooks_hook4_loaderOpenSensor4_inputNumero = 929;
        int hooks_overClampedStatusSensor_byteNumero = 306;
        String hooks_overClampedStatusSensor_dioName = "";
        int hooks_overClampedStatusSensor_inputNumero = 519;
        int hooks_unclampedStatusSensor_byteNumero = 496;
        String hooks_unclampedStatusSensor_dioName = "";
        int hooks_unclampedStatusSensor_inputNumero = 51;
        int hooks_underClampedStatusSensor_byteNumero = 895;
        String hooks_underClampedStatusSensor_dioName = "";
        int hooks_underClampedStatusSensor_inputNumero = 454;
        int plc_Loader_LPS_LPS_0_byteNumero = 376;
        String plc_Loader_LPS_LPS_0_dioName = "t";
        int plc_Loader_LPS_LPS_0_inputNumero = 102;
        int plc_Loader_LPS_LPS_1_byteNumero = 378;
        String plc_Loader_LPS_LPS_1_dioName = "";
        int plc_Loader_LPS_LPS_1_inputNumero = 125;
        int plc_Loader_LRH_LRH_0_byteNumero = 896;
        String plc_Loader_LRH_LRH_0_dioName = "s";
        int plc_Loader_LRH_LRH_0_inputNumero = 323;
        int plc_Loader_LRH_LRH_1_byteNumero = 693;
        String plc_Loader_LRH_LRH_1_dioName = "h";
        int plc_Loader_LRH_LRH_1_inputNumero = 212;
        int plc_acAF0_acAF0b_byteNumero = 654;
        String plc_acAF0_acAF0b_dioName = "";
        int plc_acAF0_acAF0b_inputNumero = 457;
        int plc_acAF0_acAF0s_byteNumero = 532;
        String plc_acAF0_acAF0s_dioName = "n";
        int plc_acAF0_acAF0s_inputNumero = 125;
        int plc_acAF1_acAF1b_byteNumero = 16;
        String plc_acAF1_acAF1b_dioName = "c";
        int plc_acAF1_acAF1b_inputNumero = 187;
        int plc_acAF1_acAF1s_byteNumero = 750;
        String plc_acAF1_acAF1s_dioName = "";
        int plc_acAF1_acAF1s_inputNumero = 227;
        int plc_acAF3_acAF3b_byteNumero = 309;
        String plc_acAF3_acAF3b_dioName = "";
        int plc_acAF3_acAF3b_inputNumero = 270;
        int plc_acAF3_acAF3s_byteNumero = 363;
        String plc_acAF3_acAF3s_dioName = "y";
        int plc_acAF3_acAF3s_inputNumero = 638;
        int plc_acAP2_acAP2b_byteNumero = 804;
        String plc_acAP2_acAP2b_dioName = "";
        int plc_acAP2_acAP2b_inputNumero = 810;
        int plc_acAP2_acAP2s_byteNumero = 588;
        String plc_acAP2_acAP2s_dioName = "q";
        int plc_acAP2_acAP2s_inputNumero = 936;
        int plc_keyEngSensors_keyEng_byteNumero = 202;
        String plc_keyEngSensors_keyEng_dioName = "";
        int plc_keyEngSensors_keyEng_inputNumero = 731;
        int plc_keyEngSensors_keyEngb_byteNumero = 976;
        String plc_keyEngSensors_keyEngb_dioName = "x";
        int plc_keyEngSensors_keyEngb_inputNumero = 683;
        int plc_keyLockSensors_keyLock_byteNumero = 51;
        String plc_keyLockSensors_keyLock_dioName = "z";
        int plc_keyLockSensors_keyLock_inputNumero = 647;
        int plc_keyLockSensors_keyLockb_byteNumero = 802;
        String plc_keyLockSensors_keyLockb_dioName = "w";
        int plc_keyLockSensors_keyLockb_inputNumero = 631;
        int plc_loaderCarrierRelayStatus_byteNumero = 280;
        String plc_loaderCarrierRelayStatus_dioName = "b";
        int plc_loaderCarrierRelayStatus_inputNumero = 625;
        int plc_loaderChainPresenceSensor_byteNumero = 295;
        String plc_loaderChainPresenceSensor_dioName = "";
        int plc_loaderChainPresenceSensor_inputNumero = 402;
        int plc_loaderDefaultStatus_byteNumero = 468;
        String plc_loaderDefaultStatus_dioName = "";
        int plc_loaderDefaultStatus_inputNumero = 209;
        int plc_loaderFilterDistanceSensor_byteNumero = 176;
        String plc_loaderFilterDistanceSensor_deviceName = "e";
        int plc_loaderFilterGoodPositionStatus_byteNumero = 755;
        String plc_loaderFilterGoodPositionStatus_dioName = "";
        int plc_loaderFilterGoodPositionStatus_inputNumero = 152;
        int plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_byteNumero = 525;
        String plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_dioName = "";
        int plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_inputNumero = 513;
        int plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_byteNumero = 318;
        String plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_dioName = "l";
        int plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_inputNumero = 203;
        int plc_loaderHooksRelayStatus_byteNumero = 489;
        String plc_loaderHooksRelayStatus_dioName = "r";
        int plc_loaderHooksRelayStatus_inputNumero = 121;
        int plc_loaderOnCameraSensors_loaderOnCameraSensor0_byteNumero = 441;
        String plc_loaderOnCameraSensors_loaderOnCameraSensor0_dioName = "";
        int plc_loaderOnCameraSensors_loaderOnCameraSensor0_inputNumero = 653;
        int plc_loaderOnCameraSensors_loaderOnCameraSensor1_byteNumero = 153;
        String plc_loaderOnCameraSensors_loaderOnCameraSensor1_dioName = "";
        int plc_loaderOnCameraSensors_loaderOnCameraSensor1_inputNumero = 444;
        int plc_loader_LFD_byteNumero = 436;
        String plc_loader_LFD_dioName = "z";
        int plc_loader_LFD_inputNumero = 121;
        int plc_loader_LFS_byteNumero = 355;
        String plc_loader_LFS_dioName = "";
        int plc_loader_LFS_inputNumero = 226;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Loader_sensorConfigurationEvent(version, carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_byteNumero, carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_dioName, carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_inputNumero, carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_byteNumero, carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_dioName, carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_inputNumero, carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_byteNumero, carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_dioName, carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_inputNumero, carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_byteNumero, carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_dioName, carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_inputNumero, carrier_loaderStorageSensors_loaderStoragePositionSensor0_byteNumero, carrier_loaderStorageSensors_loaderStoragePositionSensor0_dioName, carrier_loaderStorageSensors_loaderStoragePositionSensor0_inputNumero, carrier_loaderStorageSensors_loaderStoragePositionSensor1_byteNumero, carrier_loaderStorageSensors_loaderStoragePositionSensor1_dioName, carrier_loaderStorageSensors_loaderStoragePositionSensor1_inputNumero, hooks_clampedStatusSensor_byteNumero, hooks_clampedStatusSensor_dioName, hooks_clampedStatusSensor_inputNumero, hooks_forceSensor0_byteNumero, hooks_forceSensor0_deviceName, hooks_forceSensor1_byteNumero, hooks_forceSensor1_deviceName, hooks_hook1_loaderCloseSensor1_byteNumero, hooks_hook1_loaderCloseSensor1_dioName, hooks_hook1_loaderCloseSensor1_inputNumero, hooks_hook1_loaderOpenSensor1_byteNumero, hooks_hook1_loaderOpenSensor1_dioName, hooks_hook1_loaderOpenSensor1_inputNumero, hooks_hook2_loaderCloseSensor2_byteNumero, hooks_hook2_loaderCloseSensor2_dioName, hooks_hook2_loaderCloseSensor2_inputNumero, hooks_hook2_loaderOpenSensor2_byteNumero, hooks_hook2_loaderOpenSensor2_dioName, hooks_hook2_loaderOpenSensor2_inputNumero, hooks_hook3_loaderCloseSensor3_byteNumero, hooks_hook3_loaderCloseSensor3_dioName, hooks_hook3_loaderCloseSensor3_inputNumero, hooks_hook3_loaderOpenSensor3_byteNumero, hooks_hook3_loaderOpenSensor3_dioName, hooks_hook3_loaderOpenSensor3_inputNumero, hooks_hook4_loaderCloseSensor4_byteNumero, hooks_hook4_loaderCloseSensor4_dioName, hooks_hook4_loaderCloseSensor4_inputNumero, hooks_hook4_loaderOpenSensor4_byteNumero, hooks_hook4_loaderOpenSensor4_dioName, hooks_hook4_loaderOpenSensor4_inputNumero, hooks_overClampedStatusSensor_byteNumero, hooks_overClampedStatusSensor_dioName, hooks_overClampedStatusSensor_inputNumero, hooks_unclampedStatusSensor_byteNumero, hooks_unclampedStatusSensor_dioName, hooks_unclampedStatusSensor_inputNumero, hooks_underClampedStatusSensor_byteNumero, hooks_underClampedStatusSensor_dioName, hooks_underClampedStatusSensor_inputNumero, plc_Loader_LPS_LPS_0_byteNumero, plc_Loader_LPS_LPS_0_dioName, plc_Loader_LPS_LPS_0_inputNumero, plc_Loader_LPS_LPS_1_byteNumero, plc_Loader_LPS_LPS_1_dioName, plc_Loader_LPS_LPS_1_inputNumero, plc_Loader_LRH_LRH_0_byteNumero, plc_Loader_LRH_LRH_0_dioName, plc_Loader_LRH_LRH_0_inputNumero, plc_Loader_LRH_LRH_1_byteNumero, plc_Loader_LRH_LRH_1_dioName, plc_Loader_LRH_LRH_1_inputNumero, plc_acAF0_acAF0b_byteNumero, plc_acAF0_acAF0b_dioName, plc_acAF0_acAF0b_inputNumero, plc_acAF0_acAF0s_byteNumero, plc_acAF0_acAF0s_dioName, plc_acAF0_acAF0s_inputNumero, plc_acAF1_acAF1b_byteNumero, plc_acAF1_acAF1b_dioName, plc_acAF1_acAF1b_inputNumero, plc_acAF1_acAF1s_byteNumero, plc_acAF1_acAF1s_dioName, plc_acAF1_acAF1s_inputNumero, plc_acAF3_acAF3b_byteNumero, plc_acAF3_acAF3b_dioName, plc_acAF3_acAF3b_inputNumero, plc_acAF3_acAF3s_byteNumero, plc_acAF3_acAF3s_dioName, plc_acAF3_acAF3s_inputNumero, plc_acAP2_acAP2b_byteNumero, plc_acAP2_acAP2b_dioName, plc_acAP2_acAP2b_inputNumero, plc_acAP2_acAP2s_byteNumero, plc_acAP2_acAP2s_dioName, plc_acAP2_acAP2s_inputNumero, plc_keyEngSensors_keyEng_byteNumero, plc_keyEngSensors_keyEng_dioName, plc_keyEngSensors_keyEng_inputNumero, plc_keyEngSensors_keyEngb_byteNumero, plc_keyEngSensors_keyEngb_dioName, plc_keyEngSensors_keyEngb_inputNumero, plc_keyLockSensors_keyLock_byteNumero, plc_keyLockSensors_keyLock_dioName, plc_keyLockSensors_keyLock_inputNumero, plc_keyLockSensors_keyLockb_byteNumero, plc_keyLockSensors_keyLockb_dioName, plc_keyLockSensors_keyLockb_inputNumero, plc_loaderCarrierRelayStatus_byteNumero, plc_loaderCarrierRelayStatus_dioName, plc_loaderCarrierRelayStatus_inputNumero, plc_loaderChainPresenceSensor_byteNumero, plc_loaderChainPresenceSensor_dioName, plc_loaderChainPresenceSensor_inputNumero, plc_loaderDefaultStatus_byteNumero, plc_loaderDefaultStatus_dioName, plc_loaderDefaultStatus_inputNumero, plc_loaderFilterDistanceSensor_byteNumero, plc_loaderFilterDistanceSensor_deviceName, plc_loaderFilterGoodPositionStatus_byteNumero, plc_loaderFilterGoodPositionStatus_dioName, plc_loaderFilterGoodPositionStatus_inputNumero, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_byteNumero, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_dioName, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_inputNumero, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_byteNumero, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_dioName, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_inputNumero, plc_loaderHooksRelayStatus_byteNumero, plc_loaderHooksRelayStatus_dioName, plc_loaderHooksRelayStatus_inputNumero, plc_loaderOnCameraSensors_loaderOnCameraSensor0_byteNumero, plc_loaderOnCameraSensors_loaderOnCameraSensor0_dioName, plc_loaderOnCameraSensors_loaderOnCameraSensor0_inputNumero, plc_loaderOnCameraSensors_loaderOnCameraSensor1_byteNumero, plc_loaderOnCameraSensors_loaderOnCameraSensor1_dioName, plc_loaderOnCameraSensors_loaderOnCameraSensor1_inputNumero, plc_loader_LFD_byteNumero, plc_loader_LFD_dioName, plc_loader_LFD_inputNumero, plc_loader_LFS_byteNumero, plc_loader_LFS_dioName, plc_loader_LFS_inputNumero));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_sensorConfigurationEvent));
        Fcs_Loader_sensorConfigurationEvent item_ = (Fcs_Loader_sensorConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_byteNumero, (long)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor0_byteNumero());
        Assert.assertEquals((Object)carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_dioName, (Object)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor0_dioName());
        Assert.assertEquals((long)carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_inputNumero, (long)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor0_inputNumero());
        Assert.assertEquals((long)carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_byteNumero, (long)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor1_byteNumero());
        Assert.assertEquals((Object)carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_dioName, (Object)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor1_dioName());
        Assert.assertEquals((long)carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_inputNumero, (long)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor1_inputNumero());
        Assert.assertEquals((long)carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_byteNumero, (long)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor0_byteNumero());
        Assert.assertEquals((Object)carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_dioName, (Object)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor0_dioName());
        Assert.assertEquals((long)carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_inputNumero, (long)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor0_inputNumero());
        Assert.assertEquals((long)carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_byteNumero, (long)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor1_byteNumero());
        Assert.assertEquals((Object)carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_dioName, (Object)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor1_dioName());
        Assert.assertEquals((long)carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_inputNumero, (long)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor1_inputNumero());
        Assert.assertEquals((long)carrier_loaderStorageSensors_loaderStoragePositionSensor0_byteNumero, (long)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor0_byteNumero());
        Assert.assertEquals((Object)carrier_loaderStorageSensors_loaderStoragePositionSensor0_dioName, (Object)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor0_dioName());
        Assert.assertEquals((long)carrier_loaderStorageSensors_loaderStoragePositionSensor0_inputNumero, (long)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor0_inputNumero());
        Assert.assertEquals((long)carrier_loaderStorageSensors_loaderStoragePositionSensor1_byteNumero, (long)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor1_byteNumero());
        Assert.assertEquals((Object)carrier_loaderStorageSensors_loaderStoragePositionSensor1_dioName, (Object)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor1_dioName());
        Assert.assertEquals((long)carrier_loaderStorageSensors_loaderStoragePositionSensor1_inputNumero, (long)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor1_inputNumero());
        Assert.assertEquals((long)hooks_clampedStatusSensor_byteNumero, (long)item_.getHooks_clampedStatusSensor_byteNumero());
        Assert.assertEquals((Object)hooks_clampedStatusSensor_dioName, (Object)item_.getHooks_clampedStatusSensor_dioName());
        Assert.assertEquals((long)hooks_clampedStatusSensor_inputNumero, (long)item_.getHooks_clampedStatusSensor_inputNumero());
        Assert.assertEquals((long)hooks_forceSensor0_byteNumero, (long)item_.getHooks_forceSensor0_byteNumero());
        Assert.assertEquals((Object)hooks_forceSensor0_deviceName, (Object)item_.getHooks_forceSensor0_deviceName());
        Assert.assertEquals((long)hooks_forceSensor1_byteNumero, (long)item_.getHooks_forceSensor1_byteNumero());
        Assert.assertEquals((Object)hooks_forceSensor1_deviceName, (Object)item_.getHooks_forceSensor1_deviceName());
        Assert.assertEquals((long)hooks_hook1_loaderCloseSensor1_byteNumero, (long)item_.getHooks_hook1_loaderCloseSensor1_byteNumero());
        Assert.assertEquals((Object)hooks_hook1_loaderCloseSensor1_dioName, (Object)item_.getHooks_hook1_loaderCloseSensor1_dioName());
        Assert.assertEquals((long)hooks_hook1_loaderCloseSensor1_inputNumero, (long)item_.getHooks_hook1_loaderCloseSensor1_inputNumero());
        Assert.assertEquals((long)hooks_hook1_loaderOpenSensor1_byteNumero, (long)item_.getHooks_hook1_loaderOpenSensor1_byteNumero());
        Assert.assertEquals((Object)hooks_hook1_loaderOpenSensor1_dioName, (Object)item_.getHooks_hook1_loaderOpenSensor1_dioName());
        Assert.assertEquals((long)hooks_hook1_loaderOpenSensor1_inputNumero, (long)item_.getHooks_hook1_loaderOpenSensor1_inputNumero());
        Assert.assertEquals((long)hooks_hook2_loaderCloseSensor2_byteNumero, (long)item_.getHooks_hook2_loaderCloseSensor2_byteNumero());
        Assert.assertEquals((Object)hooks_hook2_loaderCloseSensor2_dioName, (Object)item_.getHooks_hook2_loaderCloseSensor2_dioName());
        Assert.assertEquals((long)hooks_hook2_loaderCloseSensor2_inputNumero, (long)item_.getHooks_hook2_loaderCloseSensor2_inputNumero());
        Assert.assertEquals((long)hooks_hook2_loaderOpenSensor2_byteNumero, (long)item_.getHooks_hook2_loaderOpenSensor2_byteNumero());
        Assert.assertEquals((Object)hooks_hook2_loaderOpenSensor2_dioName, (Object)item_.getHooks_hook2_loaderOpenSensor2_dioName());
        Assert.assertEquals((long)hooks_hook2_loaderOpenSensor2_inputNumero, (long)item_.getHooks_hook2_loaderOpenSensor2_inputNumero());
        Assert.assertEquals((long)hooks_hook3_loaderCloseSensor3_byteNumero, (long)item_.getHooks_hook3_loaderCloseSensor3_byteNumero());
        Assert.assertEquals((Object)hooks_hook3_loaderCloseSensor3_dioName, (Object)item_.getHooks_hook3_loaderCloseSensor3_dioName());
        Assert.assertEquals((long)hooks_hook3_loaderCloseSensor3_inputNumero, (long)item_.getHooks_hook3_loaderCloseSensor3_inputNumero());
        Assert.assertEquals((long)hooks_hook3_loaderOpenSensor3_byteNumero, (long)item_.getHooks_hook3_loaderOpenSensor3_byteNumero());
        Assert.assertEquals((Object)hooks_hook3_loaderOpenSensor3_dioName, (Object)item_.getHooks_hook3_loaderOpenSensor3_dioName());
        Assert.assertEquals((long)hooks_hook3_loaderOpenSensor3_inputNumero, (long)item_.getHooks_hook3_loaderOpenSensor3_inputNumero());
        Assert.assertEquals((long)hooks_hook4_loaderCloseSensor4_byteNumero, (long)item_.getHooks_hook4_loaderCloseSensor4_byteNumero());
        Assert.assertEquals((Object)hooks_hook4_loaderCloseSensor4_dioName, (Object)item_.getHooks_hook4_loaderCloseSensor4_dioName());
        Assert.assertEquals((long)hooks_hook4_loaderCloseSensor4_inputNumero, (long)item_.getHooks_hook4_loaderCloseSensor4_inputNumero());
        Assert.assertEquals((long)hooks_hook4_loaderOpenSensor4_byteNumero, (long)item_.getHooks_hook4_loaderOpenSensor4_byteNumero());
        Assert.assertEquals((Object)hooks_hook4_loaderOpenSensor4_dioName, (Object)item_.getHooks_hook4_loaderOpenSensor4_dioName());
        Assert.assertEquals((long)hooks_hook4_loaderOpenSensor4_inputNumero, (long)item_.getHooks_hook4_loaderOpenSensor4_inputNumero());
        Assert.assertEquals((long)hooks_overClampedStatusSensor_byteNumero, (long)item_.getHooks_overClampedStatusSensor_byteNumero());
        Assert.assertEquals((Object)hooks_overClampedStatusSensor_dioName, (Object)item_.getHooks_overClampedStatusSensor_dioName());
        Assert.assertEquals((long)hooks_overClampedStatusSensor_inputNumero, (long)item_.getHooks_overClampedStatusSensor_inputNumero());
        Assert.assertEquals((long)hooks_unclampedStatusSensor_byteNumero, (long)item_.getHooks_unclampedStatusSensor_byteNumero());
        Assert.assertEquals((Object)hooks_unclampedStatusSensor_dioName, (Object)item_.getHooks_unclampedStatusSensor_dioName());
        Assert.assertEquals((long)hooks_unclampedStatusSensor_inputNumero, (long)item_.getHooks_unclampedStatusSensor_inputNumero());
        Assert.assertEquals((long)hooks_underClampedStatusSensor_byteNumero, (long)item_.getHooks_underClampedStatusSensor_byteNumero());
        Assert.assertEquals((Object)hooks_underClampedStatusSensor_dioName, (Object)item_.getHooks_underClampedStatusSensor_dioName());
        Assert.assertEquals((long)hooks_underClampedStatusSensor_inputNumero, (long)item_.getHooks_underClampedStatusSensor_inputNumero());
        Assert.assertEquals((long)plc_Loader_LPS_LPS_0_byteNumero, (long)item_.getPlc_Loader_LPS_LPS_0_byteNumero());
        Assert.assertEquals((Object)plc_Loader_LPS_LPS_0_dioName, (Object)item_.getPlc_Loader_LPS_LPS_0_dioName());
        Assert.assertEquals((long)plc_Loader_LPS_LPS_0_inputNumero, (long)item_.getPlc_Loader_LPS_LPS_0_inputNumero());
        Assert.assertEquals((long)plc_Loader_LPS_LPS_1_byteNumero, (long)item_.getPlc_Loader_LPS_LPS_1_byteNumero());
        Assert.assertEquals((Object)plc_Loader_LPS_LPS_1_dioName, (Object)item_.getPlc_Loader_LPS_LPS_1_dioName());
        Assert.assertEquals((long)plc_Loader_LPS_LPS_1_inputNumero, (long)item_.getPlc_Loader_LPS_LPS_1_inputNumero());
        Assert.assertEquals((long)plc_Loader_LRH_LRH_0_byteNumero, (long)item_.getPlc_Loader_LRH_LRH_0_byteNumero());
        Assert.assertEquals((Object)plc_Loader_LRH_LRH_0_dioName, (Object)item_.getPlc_Loader_LRH_LRH_0_dioName());
        Assert.assertEquals((long)plc_Loader_LRH_LRH_0_inputNumero, (long)item_.getPlc_Loader_LRH_LRH_0_inputNumero());
        Assert.assertEquals((long)plc_Loader_LRH_LRH_1_byteNumero, (long)item_.getPlc_Loader_LRH_LRH_1_byteNumero());
        Assert.assertEquals((Object)plc_Loader_LRH_LRH_1_dioName, (Object)item_.getPlc_Loader_LRH_LRH_1_dioName());
        Assert.assertEquals((long)plc_Loader_LRH_LRH_1_inputNumero, (long)item_.getPlc_Loader_LRH_LRH_1_inputNumero());
        Assert.assertEquals((long)plc_acAF0_acAF0b_byteNumero, (long)item_.getPlc_acAF0_acAF0b_byteNumero());
        Assert.assertEquals((Object)plc_acAF0_acAF0b_dioName, (Object)item_.getPlc_acAF0_acAF0b_dioName());
        Assert.assertEquals((long)plc_acAF0_acAF0b_inputNumero, (long)item_.getPlc_acAF0_acAF0b_inputNumero());
        Assert.assertEquals((long)plc_acAF0_acAF0s_byteNumero, (long)item_.getPlc_acAF0_acAF0s_byteNumero());
        Assert.assertEquals((Object)plc_acAF0_acAF0s_dioName, (Object)item_.getPlc_acAF0_acAF0s_dioName());
        Assert.assertEquals((long)plc_acAF0_acAF0s_inputNumero, (long)item_.getPlc_acAF0_acAF0s_inputNumero());
        Assert.assertEquals((long)plc_acAF1_acAF1b_byteNumero, (long)item_.getPlc_acAF1_acAF1b_byteNumero());
        Assert.assertEquals((Object)plc_acAF1_acAF1b_dioName, (Object)item_.getPlc_acAF1_acAF1b_dioName());
        Assert.assertEquals((long)plc_acAF1_acAF1b_inputNumero, (long)item_.getPlc_acAF1_acAF1b_inputNumero());
        Assert.assertEquals((long)plc_acAF1_acAF1s_byteNumero, (long)item_.getPlc_acAF1_acAF1s_byteNumero());
        Assert.assertEquals((Object)plc_acAF1_acAF1s_dioName, (Object)item_.getPlc_acAF1_acAF1s_dioName());
        Assert.assertEquals((long)plc_acAF1_acAF1s_inputNumero, (long)item_.getPlc_acAF1_acAF1s_inputNumero());
        Assert.assertEquals((long)plc_acAF3_acAF3b_byteNumero, (long)item_.getPlc_acAF3_acAF3b_byteNumero());
        Assert.assertEquals((Object)plc_acAF3_acAF3b_dioName, (Object)item_.getPlc_acAF3_acAF3b_dioName());
        Assert.assertEquals((long)plc_acAF3_acAF3b_inputNumero, (long)item_.getPlc_acAF3_acAF3b_inputNumero());
        Assert.assertEquals((long)plc_acAF3_acAF3s_byteNumero, (long)item_.getPlc_acAF3_acAF3s_byteNumero());
        Assert.assertEquals((Object)plc_acAF3_acAF3s_dioName, (Object)item_.getPlc_acAF3_acAF3s_dioName());
        Assert.assertEquals((long)plc_acAF3_acAF3s_inputNumero, (long)item_.getPlc_acAF3_acAF3s_inputNumero());
        Assert.assertEquals((long)plc_acAP2_acAP2b_byteNumero, (long)item_.getPlc_acAP2_acAP2b_byteNumero());
        Assert.assertEquals((Object)plc_acAP2_acAP2b_dioName, (Object)item_.getPlc_acAP2_acAP2b_dioName());
        Assert.assertEquals((long)plc_acAP2_acAP2b_inputNumero, (long)item_.getPlc_acAP2_acAP2b_inputNumero());
        Assert.assertEquals((long)plc_acAP2_acAP2s_byteNumero, (long)item_.getPlc_acAP2_acAP2s_byteNumero());
        Assert.assertEquals((Object)plc_acAP2_acAP2s_dioName, (Object)item_.getPlc_acAP2_acAP2s_dioName());
        Assert.assertEquals((long)plc_acAP2_acAP2s_inputNumero, (long)item_.getPlc_acAP2_acAP2s_inputNumero());
        Assert.assertEquals((long)plc_keyEngSensors_keyEng_byteNumero, (long)item_.getPlc_keyEngSensors_keyEng_byteNumero());
        Assert.assertEquals((Object)plc_keyEngSensors_keyEng_dioName, (Object)item_.getPlc_keyEngSensors_keyEng_dioName());
        Assert.assertEquals((long)plc_keyEngSensors_keyEng_inputNumero, (long)item_.getPlc_keyEngSensors_keyEng_inputNumero());
        Assert.assertEquals((long)plc_keyEngSensors_keyEngb_byteNumero, (long)item_.getPlc_keyEngSensors_keyEngb_byteNumero());
        Assert.assertEquals((Object)plc_keyEngSensors_keyEngb_dioName, (Object)item_.getPlc_keyEngSensors_keyEngb_dioName());
        Assert.assertEquals((long)plc_keyEngSensors_keyEngb_inputNumero, (long)item_.getPlc_keyEngSensors_keyEngb_inputNumero());
        Assert.assertEquals((long)plc_keyLockSensors_keyLock_byteNumero, (long)item_.getPlc_keyLockSensors_keyLock_byteNumero());
        Assert.assertEquals((Object)plc_keyLockSensors_keyLock_dioName, (Object)item_.getPlc_keyLockSensors_keyLock_dioName());
        Assert.assertEquals((long)plc_keyLockSensors_keyLock_inputNumero, (long)item_.getPlc_keyLockSensors_keyLock_inputNumero());
        Assert.assertEquals((long)plc_keyLockSensors_keyLockb_byteNumero, (long)item_.getPlc_keyLockSensors_keyLockb_byteNumero());
        Assert.assertEquals((Object)plc_keyLockSensors_keyLockb_dioName, (Object)item_.getPlc_keyLockSensors_keyLockb_dioName());
        Assert.assertEquals((long)plc_keyLockSensors_keyLockb_inputNumero, (long)item_.getPlc_keyLockSensors_keyLockb_inputNumero());
        Assert.assertEquals((long)plc_loaderCarrierRelayStatus_byteNumero, (long)item_.getPlc_loaderCarrierRelayStatus_byteNumero());
        Assert.assertEquals((Object)plc_loaderCarrierRelayStatus_dioName, (Object)item_.getPlc_loaderCarrierRelayStatus_dioName());
        Assert.assertEquals((long)plc_loaderCarrierRelayStatus_inputNumero, (long)item_.getPlc_loaderCarrierRelayStatus_inputNumero());
        Assert.assertEquals((long)plc_loaderChainPresenceSensor_byteNumero, (long)item_.getPlc_loaderChainPresenceSensor_byteNumero());
        Assert.assertEquals((Object)plc_loaderChainPresenceSensor_dioName, (Object)item_.getPlc_loaderChainPresenceSensor_dioName());
        Assert.assertEquals((long)plc_loaderChainPresenceSensor_inputNumero, (long)item_.getPlc_loaderChainPresenceSensor_inputNumero());
        Assert.assertEquals((long)plc_loaderDefaultStatus_byteNumero, (long)item_.getPlc_loaderDefaultStatus_byteNumero());
        Assert.assertEquals((Object)plc_loaderDefaultStatus_dioName, (Object)item_.getPlc_loaderDefaultStatus_dioName());
        Assert.assertEquals((long)plc_loaderDefaultStatus_inputNumero, (long)item_.getPlc_loaderDefaultStatus_inputNumero());
        Assert.assertEquals((long)plc_loaderFilterDistanceSensor_byteNumero, (long)item_.getPlc_loaderFilterDistanceSensor_byteNumero());
        Assert.assertEquals((Object)plc_loaderFilterDistanceSensor_deviceName, (Object)item_.getPlc_loaderFilterDistanceSensor_deviceName());
        Assert.assertEquals((long)plc_loaderFilterGoodPositionStatus_byteNumero, (long)item_.getPlc_loaderFilterGoodPositionStatus_byteNumero());
        Assert.assertEquals((Object)plc_loaderFilterGoodPositionStatus_dioName, (Object)item_.getPlc_loaderFilterGoodPositionStatus_dioName());
        Assert.assertEquals((long)plc_loaderFilterGoodPositionStatus_inputNumero, (long)item_.getPlc_loaderFilterGoodPositionStatus_inputNumero());
        Assert.assertEquals((long)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_byteNumero, (long)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_byteNumero());
        Assert.assertEquals((Object)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_dioName, (Object)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_dioName());
        Assert.assertEquals((long)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_inputNumero, (long)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_inputNumero());
        Assert.assertEquals((long)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_byteNumero, (long)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_byteNumero());
        Assert.assertEquals((Object)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_dioName, (Object)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_dioName());
        Assert.assertEquals((long)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_inputNumero, (long)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_inputNumero());
        Assert.assertEquals((long)plc_loaderHooksRelayStatus_byteNumero, (long)item_.getPlc_loaderHooksRelayStatus_byteNumero());
        Assert.assertEquals((Object)plc_loaderHooksRelayStatus_dioName, (Object)item_.getPlc_loaderHooksRelayStatus_dioName());
        Assert.assertEquals((long)plc_loaderHooksRelayStatus_inputNumero, (long)item_.getPlc_loaderHooksRelayStatus_inputNumero());
        Assert.assertEquals((long)plc_loaderOnCameraSensors_loaderOnCameraSensor0_byteNumero, (long)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor0_byteNumero());
        Assert.assertEquals((Object)plc_loaderOnCameraSensors_loaderOnCameraSensor0_dioName, (Object)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor0_dioName());
        Assert.assertEquals((long)plc_loaderOnCameraSensors_loaderOnCameraSensor0_inputNumero, (long)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor0_inputNumero());
        Assert.assertEquals((long)plc_loaderOnCameraSensors_loaderOnCameraSensor1_byteNumero, (long)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor1_byteNumero());
        Assert.assertEquals((Object)plc_loaderOnCameraSensors_loaderOnCameraSensor1_dioName, (Object)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor1_dioName());
        Assert.assertEquals((long)plc_loaderOnCameraSensors_loaderOnCameraSensor1_inputNumero, (long)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor1_inputNumero());
        Assert.assertEquals((long)plc_loader_LFD_byteNumero, (long)item_.getPlc_loader_LFD_byteNumero());
        Assert.assertEquals((Object)plc_loader_LFD_dioName, (Object)item_.getPlc_loader_LFD_dioName());
        Assert.assertEquals((long)plc_loader_LFD_inputNumero, (long)item_.getPlc_loader_LFD_inputNumero());
        Assert.assertEquals((long)plc_loader_LFS_byteNumero, (long)item_.getPlc_loader_LFS_byteNumero());
        Assert.assertEquals((Object)plc_loader_LFS_dioName, (Object)item_.getPlc_loader_LFS_dioName());
        Assert.assertEquals((long)plc_loader_LFS_inputNumero, (long)item_.getPlc_loader_LFS_inputNumero());
    }

    @Test
    public void sendReceiveFcs_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 507;
        int schedulers_default_nThreads = 739;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads));
        Assert.assertTrue((boolean)(item instanceof Fcs_PeriodicTasks_GeneralConfigurationEvent));
        Fcs_PeriodicTasks_GeneralConfigurationEvent item_ = (Fcs_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
    }

    @Test
    public void sendReceiveFcs_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "p";
        long agentmonitorservice_taskPeriodMillis = 346L;
        long heartbeat_taskPeriodMillis = 618L;
        long main_checkControllers_taskPeriodMillis = 993L;
        long main_updateGui_taskPeriodMillis = 724L;
        long publishautochangertemperatures_taskPeriodMillis = 221L;
        long publishttc580temperatures_taskPeriodMillis = 132L;
        long runtimeinfo_taskPeriodMillis = 645L;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, main_checkControllers_taskPeriodMillis, main_updateGui_taskPeriodMillis, publishautochangertemperatures_taskPeriodMillis, publishttc580temperatures_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Fcs_PeriodicTasks_timersConfigurationEvent));
        Fcs_PeriodicTasks_timersConfigurationEvent item_ = (Fcs_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)main_checkControllers_taskPeriodMillis, (long)item_.getMain_checkControllers_taskPeriodMillis());
        Assert.assertEquals((long)main_updateGui_taskPeriodMillis, (long)item_.getMain_updateGui_taskPeriodMillis());
        Assert.assertEquals((long)publishautochangertemperatures_taskPeriodMillis, (long)item_.getPublishautochangertemperatures_taskPeriodMillis());
        Assert.assertEquals((long)publishttc580temperatures_taskPeriodMillis, (long)item_.getPublishttc580temperatures_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveShutter_GeneralConfigurationEvent() throws Exception {
        String version = "";
        double controller_centeringSpeed = 0.6014798283576965;
        String controller_localAMSaddr = "b";
        double controller_maxHallPositionError = 0.34356874227523804;
        double controller_maxStrokeSpeed = 0.4499297f;
        String controller_minExposureTime = "";
        String controller_noticeReaderRestartDelay = "o";
        String controller_noticeReaderStartupDelay = "r";
        String controller_plcAMSaddr = "r";
        String controller_plcAckTimeout = "c";
        String controller_plcIPaddr = "f";
        String controller_referenceMinusXpositions = "m";
        String controller_referencePlusXpositions = "";
        String controller_safeCtrlTempRange = "";
        String controller_safeRtdTempRange = "";
        int periodictasks_schedulers_default_nTasks = 353;
        int periodictasks_schedulers_default_nThreads = 737;
        String publisher_configurationName = "d";
        String publisher_maxStrokeTime = "";
        double publisher_minStrokeLength = 0.3075166344642639;
        String publisher_minusXStrokeCounterPath = "a";
        String publisher_plusXStrokeCounterPath = "";
        String publisher_publicationInterval = "c";
        String statemachine_brakepower_brakeVoltageKey = "";
        double statemachine_brakepower_powerOnThreshold = 0.5048176050186157;
        String statemachine_resetSyncTimeout = "b";
        String statemachine_taskRestartDelay = "";
        String watchdog_checkInterval = "";
        SALEvent item = this.testSendReceive((SALEvent)new Shutter_GeneralConfigurationEvent(version, controller_centeringSpeed, controller_localAMSaddr, controller_maxHallPositionError, controller_maxStrokeSpeed, controller_minExposureTime, controller_noticeReaderRestartDelay, controller_noticeReaderStartupDelay, controller_plcAMSaddr, controller_plcAckTimeout, controller_plcIPaddr, controller_referenceMinusXpositions, controller_referencePlusXpositions, controller_safeCtrlTempRange, controller_safeRtdTempRange, periodictasks_schedulers_default_nTasks, periodictasks_schedulers_default_nThreads, publisher_configurationName, publisher_maxStrokeTime, publisher_minStrokeLength, publisher_minusXStrokeCounterPath, publisher_plusXStrokeCounterPath, publisher_publicationInterval, statemachine_brakepower_brakeVoltageKey, statemachine_brakepower_powerOnThreshold, statemachine_resetSyncTimeout, statemachine_taskRestartDelay, watchdog_checkInterval));
        Assert.assertTrue((boolean)(item instanceof Shutter_GeneralConfigurationEvent));
        Shutter_GeneralConfigurationEvent item_ = (Shutter_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)controller_centeringSpeed, (double)item_.getController_centeringSpeed(), (double)1.0E-6f);
        Assert.assertEquals((Object)controller_localAMSaddr, (Object)item_.getController_localAMSaddr());
        Assert.assertEquals((double)controller_maxHallPositionError, (double)item_.getController_maxHallPositionError(), (double)1.0E-6f);
        Assert.assertEquals((double)controller_maxStrokeSpeed, (double)item_.getController_maxStrokeSpeed(), (double)1.0E-6f);
        Assert.assertEquals((Object)controller_minExposureTime, (Object)item_.getController_minExposureTime());
        Assert.assertEquals((Object)controller_noticeReaderRestartDelay, (Object)item_.getController_noticeReaderRestartDelay());
        Assert.assertEquals((Object)controller_noticeReaderStartupDelay, (Object)item_.getController_noticeReaderStartupDelay());
        Assert.assertEquals((Object)controller_plcAMSaddr, (Object)item_.getController_plcAMSaddr());
        Assert.assertEquals((Object)controller_plcAckTimeout, (Object)item_.getController_plcAckTimeout());
        Assert.assertEquals((Object)controller_plcIPaddr, (Object)item_.getController_plcIPaddr());
        Assert.assertEquals((Object)controller_referenceMinusXpositions, (Object)item_.getController_referenceMinusXpositions());
        Assert.assertEquals((Object)controller_referencePlusXpositions, (Object)item_.getController_referencePlusXpositions());
        Assert.assertEquals((Object)controller_safeCtrlTempRange, (Object)item_.getController_safeCtrlTempRange());
        Assert.assertEquals((Object)controller_safeRtdTempRange, (Object)item_.getController_safeRtdTempRange());
        Assert.assertEquals((long)periodictasks_schedulers_default_nTasks, (long)item_.getPeriodictasks_schedulers_default_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_default_nThreads, (long)item_.getPeriodictasks_schedulers_default_nThreads());
        Assert.assertEquals((Object)publisher_configurationName, (Object)item_.getPublisher_configurationName());
        Assert.assertEquals((Object)publisher_maxStrokeTime, (Object)item_.getPublisher_maxStrokeTime());
        Assert.assertEquals((double)publisher_minStrokeLength, (double)item_.getPublisher_minStrokeLength(), (double)1.0E-6f);
        Assert.assertEquals((Object)publisher_minusXStrokeCounterPath, (Object)item_.getPublisher_minusXStrokeCounterPath());
        Assert.assertEquals((Object)publisher_plusXStrokeCounterPath, (Object)item_.getPublisher_plusXStrokeCounterPath());
        Assert.assertEquals((Object)publisher_publicationInterval, (Object)item_.getPublisher_publicationInterval());
        Assert.assertEquals((Object)statemachine_brakepower_brakeVoltageKey, (Object)item_.getStatemachine_brakepower_brakeVoltageKey());
        Assert.assertEquals((double)statemachine_brakepower_powerOnThreshold, (double)item_.getStatemachine_brakepower_powerOnThreshold(), (double)1.0E-6f);
        Assert.assertEquals((Object)statemachine_resetSyncTimeout, (Object)item_.getStatemachine_resetSyncTimeout());
        Assert.assertEquals((Object)statemachine_taskRestartDelay, (Object)item_.getStatemachine_taskRestartDelay());
        Assert.assertEquals((Object)watchdog_checkInterval, (Object)item_.getWatchdog_checkInterval());
    }

    @Test
    public void sendReceiveShutter_timersConfigurationEvent() throws Exception {
        String version = "s";
        long periodictasks_agentMonitorService_taskPeriodMillis = 850L;
        long periodictasks_heartbeat_taskPeriodMillis = 128L;
        long periodictasks_runtimeInfo_taskPeriodMillis = 105L;
        SALEvent item = this.testSendReceive((SALEvent)new Shutter_timersConfigurationEvent(version, periodictasks_agentMonitorService_taskPeriodMillis, periodictasks_heartbeat_taskPeriodMillis, periodictasks_runtimeInfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Shutter_timersConfigurationEvent));
        Shutter_timersConfigurationEvent item_ = (Shutter_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)periodictasks_agentMonitorService_taskPeriodMillis, (long)item_.getPeriodictasks_agentMonitorService_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_heartbeat_taskPeriodMillis, (long)item_.getPeriodictasks_heartbeat_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_runtimeInfo_taskPeriodMillis, (long)item_.getPeriodictasks_runtimeInfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveChiller_DeviceConfigurationEvent() throws Exception {
        String version = "w";
        String chiller_chillerSerialNumber = "w";
        String maq20_node = "";
        String maq20_serials = "";
        String pluto_node = "n";
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_DeviceConfigurationEvent(version, chiller_chillerSerialNumber, maq20_node, maq20_serials, pluto_node));
        Assert.assertTrue((boolean)(item instanceof Chiller_DeviceConfigurationEvent));
        Chiller_DeviceConfigurationEvent item_ = (Chiller_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)chiller_chillerSerialNumber, (Object)item_.getChiller_chillerSerialNumber());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)pluto_node, (Object)item_.getPluto_node());
    }

    @Test
    public void sendReceiveChiller_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean chiller_disabled = false;
        boolean maq20_disabled = false;
        boolean pluto_disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_DevicesConfigurationEvent(version, chiller_disabled, maq20_disabled, pluto_disabled));
        Assert.assertTrue((boolean)(item instanceof Chiller_DevicesConfigurationEvent));
        Chiller_DevicesConfigurationEvent item_ = (Chiller_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)chiller_disabled, (Object)item_.isChiller_disabled());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)pluto_disabled, (Object)item_.isPluto_disabled());
    }

    @Test
    public void sendReceiveChiller_GeneralConfigurationEvent() throws Exception {
        String version = "l";
        String chilleralertlistener_thermalAlertSource = "";
        String chilleralertlistener_vacuumAlertSource = "d";
        String chiller_host = "";
        String coldInletChannelPath = "";
        String coldOutletChannelPath = "y";
        String coldplateChannelPath = "n";
        boolean connectedToCamera = false;
        boolean glycolCooling = false;
        String listenTo = "";
        String maq20_ColdPlHeatXfer_flowChanPath = "";
        String maq20_ColdPlHeatXfer_inletTChanPath = "q";
        String maq20_ColdPlHeatXfer_outletTChanPath = "";
        String maq20_CoolantHeatXfer_flowChanPath = "";
        String maq20_CoolantHeatXfer_inletTChanPath = "";
        String maq20_CoolantHeatXfer_outletTChanPath = "";
        String maq20_GlycHeatXfer_flowChanPath = "";
        String maq20_GlycHeatXfer_inletTChanPath = "";
        String maq20_GlycHeatXfer_outletTChanPath = "z";
        double maxPressure = 0.5212643146514893;
        int periodictasks_schedulers_default_nTasks = 790;
        int periodictasks_schedulers_default_nThreads = 940;
        int periodictasks_schedulers_monitor_check_scheduler_nTasks = 235;
        int periodictasks_schedulers_monitor_check_scheduler_nThreads = 523;
        int periodictasks_schedulers_monitor_update_publish_scheduler_nTasks = 339;
        int periodictasks_schedulers_monitor_update_publish_scheduler_nThreads = 880;
        double temperatureTimeoutFactor = 0.23631882667541504;
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_GeneralConfigurationEvent(version, chilleralertlistener_thermalAlertSource, chilleralertlistener_vacuumAlertSource, chiller_host, coldInletChannelPath, coldOutletChannelPath, coldplateChannelPath, connectedToCamera, glycolCooling, listenTo, maq20_ColdPlHeatXfer_flowChanPath, maq20_ColdPlHeatXfer_inletTChanPath, maq20_ColdPlHeatXfer_outletTChanPath, maq20_CoolantHeatXfer_flowChanPath, maq20_CoolantHeatXfer_inletTChanPath, maq20_CoolantHeatXfer_outletTChanPath, maq20_GlycHeatXfer_flowChanPath, maq20_GlycHeatXfer_inletTChanPath, maq20_GlycHeatXfer_outletTChanPath, maxPressure, periodictasks_schedulers_default_nTasks, periodictasks_schedulers_default_nThreads, periodictasks_schedulers_monitor_check_scheduler_nTasks, periodictasks_schedulers_monitor_check_scheduler_nThreads, periodictasks_schedulers_monitor_update_publish_scheduler_nTasks, periodictasks_schedulers_monitor_update_publish_scheduler_nThreads, temperatureTimeoutFactor));
        Assert.assertTrue((boolean)(item instanceof Chiller_GeneralConfigurationEvent));
        Chiller_GeneralConfigurationEvent item_ = (Chiller_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)chilleralertlistener_thermalAlertSource, (Object)item_.getChilleralertlistener_thermalAlertSource());
        Assert.assertEquals((Object)chilleralertlistener_vacuumAlertSource, (Object)item_.getChilleralertlistener_vacuumAlertSource());
        Assert.assertEquals((Object)chiller_host, (Object)item_.getChiller_host());
        Assert.assertEquals((Object)coldInletChannelPath, (Object)item_.getColdInletChannelPath());
        Assert.assertEquals((Object)coldOutletChannelPath, (Object)item_.getColdOutletChannelPath());
        Assert.assertEquals((Object)coldplateChannelPath, (Object)item_.getColdplateChannelPath());
        Assert.assertEquals((Object)connectedToCamera, (Object)item_.isConnectedToCamera());
        Assert.assertEquals((Object)glycolCooling, (Object)item_.isGlycolCooling());
        Assert.assertEquals((Object)listenTo, (Object)item_.getListenTo());
        Assert.assertEquals((Object)maq20_ColdPlHeatXfer_flowChanPath, (Object)item_.getMaq20_ColdPlHeatXfer_flowChanPath());
        Assert.assertEquals((Object)maq20_ColdPlHeatXfer_inletTChanPath, (Object)item_.getMaq20_ColdPlHeatXfer_inletTChanPath());
        Assert.assertEquals((Object)maq20_ColdPlHeatXfer_outletTChanPath, (Object)item_.getMaq20_ColdPlHeatXfer_outletTChanPath());
        Assert.assertEquals((Object)maq20_CoolantHeatXfer_flowChanPath, (Object)item_.getMaq20_CoolantHeatXfer_flowChanPath());
        Assert.assertEquals((Object)maq20_CoolantHeatXfer_inletTChanPath, (Object)item_.getMaq20_CoolantHeatXfer_inletTChanPath());
        Assert.assertEquals((Object)maq20_CoolantHeatXfer_outletTChanPath, (Object)item_.getMaq20_CoolantHeatXfer_outletTChanPath());
        Assert.assertEquals((Object)maq20_GlycHeatXfer_flowChanPath, (Object)item_.getMaq20_GlycHeatXfer_flowChanPath());
        Assert.assertEquals((Object)maq20_GlycHeatXfer_inletTChanPath, (Object)item_.getMaq20_GlycHeatXfer_inletTChanPath());
        Assert.assertEquals((Object)maq20_GlycHeatXfer_outletTChanPath, (Object)item_.getMaq20_GlycHeatXfer_outletTChanPath());
        Assert.assertEquals((double)maxPressure, (double)item_.getMaxPressure(), (double)1.0E-6f);
        Assert.assertEquals((long)periodictasks_schedulers_default_nTasks, (long)item_.getPeriodictasks_schedulers_default_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_default_nThreads, (long)item_.getPeriodictasks_schedulers_default_nThreads());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_check_scheduler_nTasks, (long)item_.getPeriodictasks_schedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_check_scheduler_nThreads, (long)item_.getPeriodictasks_schedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getPeriodictasks_schedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getPeriodictasks_schedulers_monitor_update_publish_scheduler_nThreads());
        Assert.assertEquals((double)temperatureTimeoutFactor, (double)item_.getTemperatureTimeoutFactor(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double chiller_TempDUTInput_warnHi = 0.9699575304985046;
        double chiller_TempDUTInput_limitHi = 0.3071577548980713;
        double maq20_GlycChillerIn_warnHi = 0.09066444635391235;
        double maq20_GlycChillerIn_warnLo = 0.4878164f;
        double maq20_GlycChillerIn_limitHi = 0.6894885897636414;
        double maq20_GlycChillerIn_limitLo = 0.04080832004547119;
        double maq20_GlycChillerOut_warnHi = 0.4690309762954712;
        double maq20_GlycChillerOut_limitHi = 0.9243154525756836;
        double maq20_GlycInputFlow_warnLo = 0.3648267388343811;
        double maq20_GlycInputFlow_limitLo = 0.3376834988594055;
        double maq20_PBurstReturn_warnHi = 0.37369292974472046;
        double maq20_PBurstReturn_limitHi = 0.45799845457077026;
        double maq20_PBurstSupply_warnHi = 0.7849602103233337;
        double maq20_PBurstSupply_limitHi = 0.5333129167556763;
        double maq20_Stg1TXVBulb_warnHi = 0.97985f;
        double maq20_Stg1TXVBulb_limitHi = 0.8697410821914673;
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_LimitsConfigurationEvent(version, chiller_TempDUTInput_warnHi, chiller_TempDUTInput_limitHi, maq20_GlycChillerIn_warnHi, maq20_GlycChillerIn_warnLo, maq20_GlycChillerIn_limitHi, maq20_GlycChillerIn_limitLo, maq20_GlycChillerOut_warnHi, maq20_GlycChillerOut_limitHi, maq20_GlycInputFlow_warnLo, maq20_GlycInputFlow_limitLo, maq20_PBurstReturn_warnHi, maq20_PBurstReturn_limitHi, maq20_PBurstSupply_warnHi, maq20_PBurstSupply_limitHi, maq20_Stg1TXVBulb_warnHi, maq20_Stg1TXVBulb_limitHi));
        Assert.assertTrue((boolean)(item instanceof Chiller_LimitsConfigurationEvent));
        Chiller_LimitsConfigurationEvent item_ = (Chiller_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)chiller_TempDUTInput_warnHi, (double)item_.getChiller_TempDUTInput_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)chiller_TempDUTInput_limitHi, (double)item_.getChiller_TempDUTInput_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_GlycChillerIn_warnHi, (double)item_.getMaq20_GlycChillerIn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_GlycChillerIn_warnLo, (double)item_.getMaq20_GlycChillerIn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_GlycChillerIn_limitHi, (double)item_.getMaq20_GlycChillerIn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_GlycChillerIn_limitLo, (double)item_.getMaq20_GlycChillerIn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_GlycChillerOut_warnHi, (double)item_.getMaq20_GlycChillerOut_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_GlycChillerOut_limitHi, (double)item_.getMaq20_GlycChillerOut_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_GlycInputFlow_warnLo, (double)item_.getMaq20_GlycInputFlow_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_GlycInputFlow_limitLo, (double)item_.getMaq20_GlycInputFlow_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_PBurstReturn_warnHi, (double)item_.getMaq20_PBurstReturn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_PBurstReturn_limitHi, (double)item_.getMaq20_PBurstReturn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_PBurstSupply_warnHi, (double)item_.getMaq20_PBurstSupply_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_PBurstSupply_limitHi, (double)item_.getMaq20_PBurstSupply_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_Stg1TXVBulb_warnHi, (double)item_.getMaq20_Stg1TXVBulb_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_Stg1TXVBulb_limitHi, (double)item_.getMaq20_Stg1TXVBulb_limitHi(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_PicConfigurationEvent() throws Exception {
        String version = "v";
        double fanctrl_awGain = 0.923492968082428;
        double fanctrl_baseDuty = 0.34092408418655396;
        double fanctrl_gain = 0.013272345066070557;
        double fanctrl_maxInput = 0.10649305582046509;
        double fanctrl_maxOutput = 0.8345610499382019;
        double fanctrl_minInput = 0.8406642079353333;
        double fanctrl_minOutput = 0.6731714010238647;
        double fanctrl_setTemp = 0.638889729976654;
        double fanctrl_smoothTime = 0.13770556449890137;
        double fanctrl_timeConst = 0.015667974948883057;
        double fanctrl_tolerance = 0.3332202434539795;
        boolean fanctrl_useAbsTemp = true;
        long periodictasks_FanCtrl_iterate_updateTime = 930L;
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_PicConfigurationEvent(version, fanctrl_awGain, fanctrl_baseDuty, fanctrl_gain, fanctrl_maxInput, fanctrl_maxOutput, fanctrl_minInput, fanctrl_minOutput, fanctrl_setTemp, fanctrl_smoothTime, fanctrl_timeConst, fanctrl_tolerance, fanctrl_useAbsTemp, periodictasks_FanCtrl_iterate_updateTime));
        Assert.assertTrue((boolean)(item instanceof Chiller_PicConfigurationEvent));
        Chiller_PicConfigurationEvent item_ = (Chiller_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)fanctrl_awGain, (double)item_.getFanctrl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_baseDuty, (double)item_.getFanctrl_baseDuty(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_gain, (double)item_.getFanctrl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxInput, (double)item_.getFanctrl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxOutput, (double)item_.getFanctrl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minInput, (double)item_.getFanctrl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minOutput, (double)item_.getFanctrl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_setTemp, (double)item_.getFanctrl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_smoothTime, (double)item_.getFanctrl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_timeConst, (double)item_.getFanctrl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_tolerance, (double)item_.getFanctrl_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((Object)fanctrl_useAbsTemp, (Object)item_.isFanctrl_useAbsTemp());
        Assert.assertEquals((long)periodictasks_FanCtrl_iterate_updateTime, (long)item_.getPeriodictasks_FanCtrl_iterate_updateTime());
    }

    @Test
    public void sendReceiveChiller_timersConfigurationEvent() throws Exception {
        String version = "";
        long periodictasks_Maq20_check_status_taskPeriodMillis = 540L;
        long periodictasks_agentMonitorService_taskPeriodMillis = 386L;
        long periodictasks_checkBurstDiscP_taskPeriodMillis = 259L;
        long periodictasks_checkDataArrival_taskPeriodMillis = 242L;
        long periodictasks_heartbeat_taskPeriodMillis = 645L;
        long periodictasks_monitor_check_Chiller_taskPeriodMillis = 769L;
        long periodictasks_monitor_check_Maq20_taskPeriodMillis = 39L;
        long periodictasks_monitor_check_Pluto_taskPeriodMillis = 230L;
        long periodictasks_monitor_publish_burstDiscs_taskPeriodMillis = 835L;
        long periodictasks_monitor_publish_taskPeriodMillis = 314L;
        long periodictasks_monitor_update_burstDiscs_taskPeriodMillis = 212L;
        long periodictasks_monitor_update_taskPeriodMillis = 78L;
        long periodictasks_publishParams_taskPeriodMillis = 573L;
        long periodictasks_runtimeInfo_taskPeriodMillis = 979L;
        long periodictasks_sendDutTemperature_taskPeriodMillis = 602L;
        long periodictasks_updateCtrlState_taskPeriodMillis = 808L;
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_timersConfigurationEvent(version, periodictasks_Maq20_check_status_taskPeriodMillis, periodictasks_agentMonitorService_taskPeriodMillis, periodictasks_checkBurstDiscP_taskPeriodMillis, periodictasks_checkDataArrival_taskPeriodMillis, periodictasks_heartbeat_taskPeriodMillis, periodictasks_monitor_check_Chiller_taskPeriodMillis, periodictasks_monitor_check_Maq20_taskPeriodMillis, periodictasks_monitor_check_Pluto_taskPeriodMillis, periodictasks_monitor_publish_burstDiscs_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_burstDiscs_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis, periodictasks_publishParams_taskPeriodMillis, periodictasks_runtimeInfo_taskPeriodMillis, periodictasks_sendDutTemperature_taskPeriodMillis, periodictasks_updateCtrlState_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Chiller_timersConfigurationEvent));
        Chiller_timersConfigurationEvent item_ = (Chiller_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)periodictasks_Maq20_check_status_taskPeriodMillis, (long)item_.getPeriodictasks_Maq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_agentMonitorService_taskPeriodMillis, (long)item_.getPeriodictasks_agentMonitorService_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_checkBurstDiscP_taskPeriodMillis, (long)item_.getPeriodictasks_checkBurstDiscP_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_checkDataArrival_taskPeriodMillis, (long)item_.getPeriodictasks_checkDataArrival_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_heartbeat_taskPeriodMillis, (long)item_.getPeriodictasks_heartbeat_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_Chiller_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_Chiller_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_Maq20_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_Pluto_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_Pluto_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_publish_burstDiscs_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_publish_burstDiscs_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_publish_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_update_burstDiscs_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_update_burstDiscs_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_update_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_update_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_publishParams_taskPeriodMillis, (long)item_.getPeriodictasks_publishParams_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_runtimeInfo_taskPeriodMillis, (long)item_.getPeriodictasks_runtimeInfo_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_sendDutTemperature_taskPeriodMillis, (long)item_.getPeriodictasks_sendDutTemperature_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_updateCtrlState_taskPeriodMillis, (long)item_.getPeriodictasks_updateCtrlState_taskPeriodMillis());
    }

    @Test
    public void sendReceiveThermal_DeviceConfigurationEvent() throws Exception {
        String version = "f";
        String protrtds_node = "q";
        String rtds_node = "";
        String rtds_serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_DeviceConfigurationEvent(version, protrtds_node, rtds_node, rtds_serials));
        Assert.assertTrue((boolean)(item instanceof Thermal_DeviceConfigurationEvent));
        Thermal_DeviceConfigurationEvent item_ = (Thermal_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)protrtds_node, (Object)item_.getProtrtds_node());
        Assert.assertEquals((Object)rtds_node, (Object)item_.getRtds_node());
        Assert.assertEquals((Object)rtds_serials, (Object)item_.getRtds_serials());
    }

    @Test
    public void sendReceiveThermal_DevicesConfigurationEvent() throws Exception {
        String version = "f";
        boolean protrtds_disabled = true;
        boolean rtds_disabled = false;
        boolean trimpower_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_DevicesConfigurationEvent(version, protrtds_disabled, rtds_disabled, trimpower_disabled));
        Assert.assertTrue((boolean)(item instanceof Thermal_DevicesConfigurationEvent));
        Thermal_DevicesConfigurationEvent item_ = (Thermal_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)protrtds_disabled, (Object)item_.isProtrtds_disabled());
        Assert.assertEquals((Object)rtds_disabled, (Object)item_.isRtds_disabled());
        Assert.assertEquals((Object)trimpower_disabled, (Object)item_.isTrimpower_disabled());
    }

    @Test
    public void sendReceiveThermal_GeneralConfigurationEvent() throws Exception {
        String version = "k";
        String cold_Temp_AvgColdTemp_chanNames = "";
        String cold_Temp_AvgColdTemp_chanWeights = "v";
        boolean cold_Temp_AvgColdTemp_ignoreNaN = false;
        String cryo_Temp_AvgCryoTemp_chanNames = "o";
        String cryo_Temp_AvgCryoTemp_chanWeights = "";
        boolean cryo_Temp_AvgCryoTemp_ignoreNaN = false;
        int periodictasks_schedulers_default_nTasks = 68;
        int periodictasks_schedulers_default_nThreads = 82;
        int periodictasks_schedulers_monitor_check_scheduler_nTasks = 687;
        int periodictasks_schedulers_monitor_check_scheduler_nThreads = 715;
        int periodictasks_schedulers_monitor_update_publish_scheduler_nTasks = 243;
        int periodictasks_schedulers_monitor_update_publish_scheduler_nThreads = 691;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_GeneralConfigurationEvent(version, cold_Temp_AvgColdTemp_chanNames, cold_Temp_AvgColdTemp_chanWeights, cold_Temp_AvgColdTemp_ignoreNaN, cryo_Temp_AvgCryoTemp_chanNames, cryo_Temp_AvgCryoTemp_chanWeights, cryo_Temp_AvgCryoTemp_ignoreNaN, periodictasks_schedulers_default_nTasks, periodictasks_schedulers_default_nThreads, periodictasks_schedulers_monitor_check_scheduler_nTasks, periodictasks_schedulers_monitor_check_scheduler_nThreads, periodictasks_schedulers_monitor_update_publish_scheduler_nTasks, periodictasks_schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Thermal_GeneralConfigurationEvent));
        Thermal_GeneralConfigurationEvent item_ = (Thermal_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)cold_Temp_AvgColdTemp_chanNames, (Object)item_.getCold_Temp_AvgColdTemp_chanNames());
        Assert.assertEquals((Object)cold_Temp_AvgColdTemp_chanWeights, (Object)item_.getCold_Temp_AvgColdTemp_chanWeights());
        Assert.assertEquals((Object)cold_Temp_AvgColdTemp_ignoreNaN, (Object)item_.isCold_Temp_AvgColdTemp_ignoreNaN());
        Assert.assertEquals((Object)cryo_Temp_AvgCryoTemp_chanNames, (Object)item_.getCryo_Temp_AvgCryoTemp_chanNames());
        Assert.assertEquals((Object)cryo_Temp_AvgCryoTemp_chanWeights, (Object)item_.getCryo_Temp_AvgCryoTemp_chanWeights());
        Assert.assertEquals((Object)cryo_Temp_AvgCryoTemp_ignoreNaN, (Object)item_.isCryo_Temp_AvgCryoTemp_ignoreNaN());
        Assert.assertEquals((long)periodictasks_schedulers_default_nTasks, (long)item_.getPeriodictasks_schedulers_default_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_default_nThreads, (long)item_.getPeriodictasks_schedulers_default_nThreads());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_check_scheduler_nTasks, (long)item_.getPeriodictasks_schedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_check_scheduler_nThreads, (long)item_.getPeriodictasks_schedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getPeriodictasks_schedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getPeriodictasks_schedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveThermal_LimitsConfigurationEvent() throws Exception {
        String version = "v";
        double cold_Temp_AvgColdTemp_warnHi = 0.378991f;
        double cold_Temp_AvgColdTemp_warnLo = 0.3403865098953247;
        double cold_Temp_AvgColdTemp_limitHi = 0.9576561450958252;
        double cold_Temp_AvgColdTemp_limitLo = 0.9184102416038513;
        double cryo_Temp_AvgCryoTemp_warnHi = 0.4528998136520386;
        double cryo_Temp_AvgCryoTemp_warnLo = 0.6180059313774109;
        double cryo_Temp_AvgCryoTemp_limitHi = 0.43196988105773926;
        double cryo_Temp_AvgCryoTemp_limitLo = 0.0030002593994140625;
        String rtdLocation = "g";
        double[] rtd_Cold_TempCLP_warnHi = TestHelper.generateDoubleArray((int)25, (int)1339162491);
        double[] rtd_Cold_TempCLP_warnLo = TestHelper.generateDoubleArray((int)25, (int)-932759132);
        double[] rtd_Cold_TempCLP_limitHi = TestHelper.generateDoubleArray((int)25, (int)1456550628);
        double[] rtd_Cold_TempCLP_limitLo = TestHelper.generateDoubleArray((int)25, (int)1279901360);
        double[] rtd_Cryo_TempCYP_warnHi = TestHelper.generateDoubleArray((int)25, (int)-381612731);
        double[] rtd_Cryo_TempCYP_warnLo = TestHelper.generateDoubleArray((int)25, (int)-1852834712);
        double[] rtd_Cryo_TempCYP_limitHi = TestHelper.generateDoubleArray((int)25, (int)-1827876662);
        double[] rtd_Cryo_TempCYP_limitLo = TestHelper.generateDoubleArray((int)25, (int)2001872223);
        double[] rtd_Grid_TempCFX_warnHi = TestHelper.generateDoubleArray((int)25, (int)1393968979);
        double[] rtd_Grid_TempCFX_warnLo = TestHelper.generateDoubleArray((int)25, (int)801501845);
        double[] rtd_Grid_TempCFX_limitHi = TestHelper.generateDoubleArray((int)25, (int)1605592046);
        double[] rtd_Grid_TempCFX_limitLo = TestHelper.generateDoubleArray((int)25, (int)-74909990);
        double[] rtd_Grid_TempGFX_warnHi = TestHelper.generateDoubleArray((int)25, (int)559960779);
        double[] rtd_Grid_TempGFX_warnLo = TestHelper.generateDoubleArray((int)25, (int)-636833355);
        double[] rtd_Grid_TempGFX_limitHi = TestHelper.generateDoubleArray((int)25, (int)-157052202);
        double[] rtd_Grid_TempGFX_limitLo = TestHelper.generateDoubleArray((int)25, (int)1465344471);
        double[] rtd_Grid_TempGRD_warnHi = TestHelper.generateDoubleArray((int)25, (int)1110985809);
        double[] rtd_Grid_TempGRD_warnLo = TestHelper.generateDoubleArray((int)25, (int)653060715);
        double[] rtd_Grid_TempGRD_limitHi = TestHelper.generateDoubleArray((int)25, (int)-439743962);
        double[] rtd_Grid_TempGRD_limitLo = TestHelper.generateDoubleArray((int)25, (int)273531830);
        String trimLocation = "";
        double trim_Htrs_ColdTotal_P_warnHi = 0.46033036708831787;
        double trim_Htrs_ColdTotal_P_warnLo = 0.5177094340324402;
        double trim_Htrs_ColdTotal_P_limitHi = 0.9938944578170776;
        double trim_Htrs_ColdTotal_P_limitLo = 0.3131089210510254;
        double trim_Htrs_CryoTotal_P_warnHi = 0.9489572048187256;
        double trim_Htrs_CryoTotal_P_warnLo = 0.8960791230201721;
        double trim_Htrs_CryoTotal_P_limitHi = 0.5843248963356018;
        double trim_Htrs_CryoTotal_P_limitLo = 0.6405413150787354;
        double trim_Htrs_HtrBulkTmp_warnHi = 0.6184304356575012;
        double trim_Htrs_HtrBulkTmp_warnLo = 0.665179431438446;
        double trim_Htrs_HtrBulkTmp_limitHi = 0.6012641191482544;
        double trim_Htrs_HtrBulkTmp_limitLo = 0.7447822093963623;
        double trim_Htrs_HtrBulk_I_warnHi = 0.8340408205986023;
        double trim_Htrs_HtrBulk_I_warnLo = 0.01802504062652588;
        double trim_Htrs_HtrBulk_I_limitHi = 0.5524716377258301;
        double trim_Htrs_HtrBulk_I_limitLo = 0.011943638324737549;
        double trim_Htrs_HtrBulk_P_warnHi = 0.7377426028251648;
        double trim_Htrs_HtrBulk_P_warnLo = 0.04702198505401611;
        double trim_Htrs_HtrBulk_P_limitHi = 0.1787082552909851;
        double trim_Htrs_HtrBulk_P_limitLo = 0.3087698817253113;
        double trim_Htrs_HtrBulk_V_warnHi = 0.19880056381225586;
        double trim_Htrs_HtrBulk_V_warnLo = 0.47124534845352173;
        double trim_Htrs_HtrBulk_V_limitHi = 0.0036298036575317383;
        double trim_Htrs_HtrBulk_V_limitLo = 0.48100972175598145;
        double trim_Htrs_HtrPsTmp_warnHi = 0.27893543243408203;
        double trim_Htrs_HtrPsTmp_warnLo = 0.5872438549995422;
        double trim_Htrs_HtrPsTmp_limitHi = 0.742646336555481;
        double trim_Htrs_HtrPsTmp_limitLo = 0.8933253288269043;
        double[] trim_Trim_Htrs_ColdI_warnHi = TestHelper.generateDoubleArray((int)6, (int)1328011578);
        double[] trim_Trim_Htrs_ColdI_warnLo = TestHelper.generateDoubleArray((int)6, (int)23255390);
        double[] trim_Trim_Htrs_ColdI_limitHi = TestHelper.generateDoubleArray((int)6, (int)834523230);
        double[] trim_Trim_Htrs_ColdI_limitLo = TestHelper.generateDoubleArray((int)6, (int)1541951715);
        double[] trim_Trim_Htrs_ColdP_warnHi = TestHelper.generateDoubleArray((int)6, (int)-627945997);
        double[] trim_Trim_Htrs_ColdP_warnLo = TestHelper.generateDoubleArray((int)6, (int)-714785770);
        double[] trim_Trim_Htrs_ColdP_limitHi = TestHelper.generateDoubleArray((int)6, (int)-2061670619);
        double[] trim_Trim_Htrs_ColdP_limitLo = TestHelper.generateDoubleArray((int)6, (int)840274609);
        double[] trim_Trim_Htrs_ColdV_warnHi = TestHelper.generateDoubleArray((int)6, (int)88513016);
        double[] trim_Trim_Htrs_ColdV_warnLo = TestHelper.generateDoubleArray((int)6, (int)-2092263202);
        double[] trim_Trim_Htrs_ColdV_limitHi = TestHelper.generateDoubleArray((int)6, (int)-731155514);
        double[] trim_Trim_Htrs_ColdV_limitLo = TestHelper.generateDoubleArray((int)6, (int)-1944854425);
        double[] trim_Trim_Htrs_CryoI_warnHi = TestHelper.generateDoubleArray((int)6, (int)-1404655361);
        double[] trim_Trim_Htrs_CryoI_warnLo = TestHelper.generateDoubleArray((int)6, (int)1977123394);
        double[] trim_Trim_Htrs_CryoI_limitHi = TestHelper.generateDoubleArray((int)6, (int)355619897);
        double[] trim_Trim_Htrs_CryoI_limitLo = TestHelper.generateDoubleArray((int)6, (int)151732710);
        double[] trim_Trim_Htrs_CryoP_warnHi = TestHelper.generateDoubleArray((int)6, (int)892753357);
        double[] trim_Trim_Htrs_CryoP_warnLo = TestHelper.generateDoubleArray((int)6, (int)560623125);
        double[] trim_Trim_Htrs_CryoP_limitHi = TestHelper.generateDoubleArray((int)6, (int)670425753);
        double[] trim_Trim_Htrs_CryoP_limitLo = TestHelper.generateDoubleArray((int)6, (int)-2108236033);
        double[] trim_Trim_Htrs_CryoV_warnHi = TestHelper.generateDoubleArray((int)6, (int)1088325540);
        double[] trim_Trim_Htrs_CryoV_warnLo = TestHelper.generateDoubleArray((int)6, (int)-1859422243);
        double[] trim_Trim_Htrs_CryoV_limitHi = TestHelper.generateDoubleArray((int)6, (int)-895413842);
        double[] trim_Trim_Htrs_CryoV_limitLo = TestHelper.generateDoubleArray((int)6, (int)1867358848);
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_LimitsConfigurationEvent(version, cold_Temp_AvgColdTemp_warnHi, cold_Temp_AvgColdTemp_warnLo, cold_Temp_AvgColdTemp_limitHi, cold_Temp_AvgColdTemp_limitLo, cryo_Temp_AvgCryoTemp_warnHi, cryo_Temp_AvgCryoTemp_warnLo, cryo_Temp_AvgCryoTemp_limitHi, cryo_Temp_AvgCryoTemp_limitLo, rtdLocation, rtd_Cold_TempCLP_warnHi, rtd_Cold_TempCLP_warnLo, rtd_Cold_TempCLP_limitHi, rtd_Cold_TempCLP_limitLo, rtd_Cryo_TempCYP_warnHi, rtd_Cryo_TempCYP_warnLo, rtd_Cryo_TempCYP_limitHi, rtd_Cryo_TempCYP_limitLo, rtd_Grid_TempCFX_warnHi, rtd_Grid_TempCFX_warnLo, rtd_Grid_TempCFX_limitHi, rtd_Grid_TempCFX_limitLo, rtd_Grid_TempGFX_warnHi, rtd_Grid_TempGFX_warnLo, rtd_Grid_TempGFX_limitHi, rtd_Grid_TempGFX_limitLo, rtd_Grid_TempGRD_warnHi, rtd_Grid_TempGRD_warnLo, rtd_Grid_TempGRD_limitHi, rtd_Grid_TempGRD_limitLo, trimLocation, trim_Htrs_ColdTotal_P_warnHi, trim_Htrs_ColdTotal_P_warnLo, trim_Htrs_ColdTotal_P_limitHi, trim_Htrs_ColdTotal_P_limitLo, trim_Htrs_CryoTotal_P_warnHi, trim_Htrs_CryoTotal_P_warnLo, trim_Htrs_CryoTotal_P_limitHi, trim_Htrs_CryoTotal_P_limitLo, trim_Htrs_HtrBulkTmp_warnHi, trim_Htrs_HtrBulkTmp_warnLo, trim_Htrs_HtrBulkTmp_limitHi, trim_Htrs_HtrBulkTmp_limitLo, trim_Htrs_HtrBulk_I_warnHi, trim_Htrs_HtrBulk_I_warnLo, trim_Htrs_HtrBulk_I_limitHi, trim_Htrs_HtrBulk_I_limitLo, trim_Htrs_HtrBulk_P_warnHi, trim_Htrs_HtrBulk_P_warnLo, trim_Htrs_HtrBulk_P_limitHi, trim_Htrs_HtrBulk_P_limitLo, trim_Htrs_HtrBulk_V_warnHi, trim_Htrs_HtrBulk_V_warnLo, trim_Htrs_HtrBulk_V_limitHi, trim_Htrs_HtrBulk_V_limitLo, trim_Htrs_HtrPsTmp_warnHi, trim_Htrs_HtrPsTmp_warnLo, trim_Htrs_HtrPsTmp_limitHi, trim_Htrs_HtrPsTmp_limitLo, trim_Trim_Htrs_ColdI_warnHi, trim_Trim_Htrs_ColdI_warnLo, trim_Trim_Htrs_ColdI_limitHi, trim_Trim_Htrs_ColdI_limitLo, trim_Trim_Htrs_ColdP_warnHi, trim_Trim_Htrs_ColdP_warnLo, trim_Trim_Htrs_ColdP_limitHi, trim_Trim_Htrs_ColdP_limitLo, trim_Trim_Htrs_ColdV_warnHi, trim_Trim_Htrs_ColdV_warnLo, trim_Trim_Htrs_ColdV_limitHi, trim_Trim_Htrs_ColdV_limitLo, trim_Trim_Htrs_CryoI_warnHi, trim_Trim_Htrs_CryoI_warnLo, trim_Trim_Htrs_CryoI_limitHi, trim_Trim_Htrs_CryoI_limitLo, trim_Trim_Htrs_CryoP_warnHi, trim_Trim_Htrs_CryoP_warnLo, trim_Trim_Htrs_CryoP_limitHi, trim_Trim_Htrs_CryoP_limitLo, trim_Trim_Htrs_CryoV_warnHi, trim_Trim_Htrs_CryoV_warnLo, trim_Trim_Htrs_CryoV_limitHi, trim_Trim_Htrs_CryoV_limitLo));
        Assert.assertTrue((boolean)(item instanceof Thermal_LimitsConfigurationEvent));
        Thermal_LimitsConfigurationEvent item_ = (Thermal_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cold_Temp_AvgColdTemp_warnHi, (double)item_.getCold_Temp_AvgColdTemp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cold_Temp_AvgColdTemp_warnLo, (double)item_.getCold_Temp_AvgColdTemp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cold_Temp_AvgColdTemp_limitHi, (double)item_.getCold_Temp_AvgColdTemp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cold_Temp_AvgColdTemp_limitLo, (double)item_.getCold_Temp_AvgColdTemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Temp_AvgCryoTemp_warnHi, (double)item_.getCryo_Temp_AvgCryoTemp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Temp_AvgCryoTemp_warnLo, (double)item_.getCryo_Temp_AvgCryoTemp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Temp_AvgCryoTemp_limitHi, (double)item_.getCryo_Temp_AvgCryoTemp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Temp_AvgCryoTemp_limitLo, (double)item_.getCryo_Temp_AvgCryoTemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)rtdLocation, (Object)item_.getRtdLocation());
        Assert.assertArrayEquals((double[])rtd_Cold_TempCLP_warnHi, (double[])item_.getRtd_Cold_TempCLP_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cold_TempCLP_warnLo, (double[])item_.getRtd_Cold_TempCLP_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cold_TempCLP_limitHi, (double[])item_.getRtd_Cold_TempCLP_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cold_TempCLP_limitLo, (double[])item_.getRtd_Cold_TempCLP_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cryo_TempCYP_warnHi, (double[])item_.getRtd_Cryo_TempCYP_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cryo_TempCYP_warnLo, (double[])item_.getRtd_Cryo_TempCYP_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cryo_TempCYP_limitHi, (double[])item_.getRtd_Cryo_TempCYP_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cryo_TempCYP_limitLo, (double[])item_.getRtd_Cryo_TempCYP_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempCFX_warnHi, (double[])item_.getRtd_Grid_TempCFX_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempCFX_warnLo, (double[])item_.getRtd_Grid_TempCFX_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempCFX_limitHi, (double[])item_.getRtd_Grid_TempCFX_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempCFX_limitLo, (double[])item_.getRtd_Grid_TempCFX_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempGFX_warnHi, (double[])item_.getRtd_Grid_TempGFX_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempGFX_warnLo, (double[])item_.getRtd_Grid_TempGFX_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempGFX_limitHi, (double[])item_.getRtd_Grid_TempGFX_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempGFX_limitLo, (double[])item_.getRtd_Grid_TempGFX_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempGRD_warnHi, (double[])item_.getRtd_Grid_TempGRD_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempGRD_warnLo, (double[])item_.getRtd_Grid_TempGRD_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempGRD_limitHi, (double[])item_.getRtd_Grid_TempGRD_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempGRD_limitLo, (double[])item_.getRtd_Grid_TempGRD_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)trimLocation, (Object)item_.getTrimLocation());
        Assert.assertEquals((double)trim_Htrs_ColdTotal_P_warnHi, (double)item_.getTrim_Htrs_ColdTotal_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_ColdTotal_P_warnLo, (double)item_.getTrim_Htrs_ColdTotal_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_ColdTotal_P_limitHi, (double)item_.getTrim_Htrs_ColdTotal_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_ColdTotal_P_limitLo, (double)item_.getTrim_Htrs_ColdTotal_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_CryoTotal_P_warnHi, (double)item_.getTrim_Htrs_CryoTotal_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_CryoTotal_P_warnLo, (double)item_.getTrim_Htrs_CryoTotal_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_CryoTotal_P_limitHi, (double)item_.getTrim_Htrs_CryoTotal_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_CryoTotal_P_limitLo, (double)item_.getTrim_Htrs_CryoTotal_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulkTmp_warnHi, (double)item_.getTrim_Htrs_HtrBulkTmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulkTmp_warnLo, (double)item_.getTrim_Htrs_HtrBulkTmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulkTmp_limitHi, (double)item_.getTrim_Htrs_HtrBulkTmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulkTmp_limitLo, (double)item_.getTrim_Htrs_HtrBulkTmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_I_warnHi, (double)item_.getTrim_Htrs_HtrBulk_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_I_warnLo, (double)item_.getTrim_Htrs_HtrBulk_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_I_limitHi, (double)item_.getTrim_Htrs_HtrBulk_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_I_limitLo, (double)item_.getTrim_Htrs_HtrBulk_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_P_warnHi, (double)item_.getTrim_Htrs_HtrBulk_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_P_warnLo, (double)item_.getTrim_Htrs_HtrBulk_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_P_limitHi, (double)item_.getTrim_Htrs_HtrBulk_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_P_limitLo, (double)item_.getTrim_Htrs_HtrBulk_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_V_warnHi, (double)item_.getTrim_Htrs_HtrBulk_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_V_warnLo, (double)item_.getTrim_Htrs_HtrBulk_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_V_limitHi, (double)item_.getTrim_Htrs_HtrBulk_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_V_limitLo, (double)item_.getTrim_Htrs_HtrBulk_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrPsTmp_warnHi, (double)item_.getTrim_Htrs_HtrPsTmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrPsTmp_warnLo, (double)item_.getTrim_Htrs_HtrPsTmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrPsTmp_limitHi, (double)item_.getTrim_Htrs_HtrPsTmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrPsTmp_limitLo, (double)item_.getTrim_Htrs_HtrPsTmp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdI_warnHi, (double[])item_.getTrim_Trim_Htrs_ColdI_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdI_warnLo, (double[])item_.getTrim_Trim_Htrs_ColdI_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdI_limitHi, (double[])item_.getTrim_Trim_Htrs_ColdI_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdI_limitLo, (double[])item_.getTrim_Trim_Htrs_ColdI_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdP_warnHi, (double[])item_.getTrim_Trim_Htrs_ColdP_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdP_warnLo, (double[])item_.getTrim_Trim_Htrs_ColdP_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdP_limitHi, (double[])item_.getTrim_Trim_Htrs_ColdP_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdP_limitLo, (double[])item_.getTrim_Trim_Htrs_ColdP_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdV_warnHi, (double[])item_.getTrim_Trim_Htrs_ColdV_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdV_warnLo, (double[])item_.getTrim_Trim_Htrs_ColdV_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdV_limitHi, (double[])item_.getTrim_Trim_Htrs_ColdV_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdV_limitLo, (double[])item_.getTrim_Trim_Htrs_ColdV_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoI_warnHi, (double[])item_.getTrim_Trim_Htrs_CryoI_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoI_warnLo, (double[])item_.getTrim_Trim_Htrs_CryoI_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoI_limitHi, (double[])item_.getTrim_Trim_Htrs_CryoI_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoI_limitLo, (double[])item_.getTrim_Trim_Htrs_CryoI_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoP_warnHi, (double[])item_.getTrim_Trim_Htrs_CryoP_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoP_warnLo, (double[])item_.getTrim_Trim_Htrs_CryoP_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoP_limitHi, (double[])item_.getTrim_Trim_Htrs_CryoP_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoP_limitLo, (double[])item_.getTrim_Trim_Htrs_CryoP_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoV_warnHi, (double[])item_.getTrim_Trim_Htrs_CryoV_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoV_warnLo, (double[])item_.getTrim_Trim_Htrs_CryoV_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoV_limitHi, (double[])item_.getTrim_Trim_Htrs_CryoV_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoV_limitLo, (double[])item_.getTrim_Trim_Htrs_CryoV_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_PicConfigurationEvent() throws Exception {
        String version = "";
        double coldtempctrlc_awGain = 0.11034232378005981;
        double coldtempctrlc_basePower = 0.07947146892547607;
        double coldtempctrlc_gain = 0.8545461297035217;
        double coldtempctrlc_maxInput = 0.765780508518219;
        double coldtempctrlc_maxOutput = 0.6812258362770081;
        double coldtempctrlc_minInput = 0.34079432487487793;
        double coldtempctrlc_minOutput = 0.9090901613235474;
        double coldtempctrlc_smoothTime = 0.8828146457672119;
        double coldtempctrlc_timeConst = 0.1399632692337036;
        double coldtempctrlc_tolerance = 0.21496367454528809;
        double coldtempctrlmye_awGain = 0.48869335651397705;
        double coldtempctrlmye_basePower = 0.5236793756484985;
        double coldtempctrlmye_gain = 0.1787287f;
        double coldtempctrlmye_maxInput = 0.5199159383773804;
        double coldtempctrlmye_maxOutput = 0.5029171705245972;
        double coldtempctrlmye_minInput = 0.9910563230514526;
        double coldtempctrlmye_minOutput = 0.2425785f;
        double coldtempctrlmye_smoothTime = 0.9126086831092834;
        double coldtempctrlmye_timeConst = 0.6433528661727905;
        double coldtempctrlmye_tolerance = 0.8951604962348938;
        double coldtempctrlpye_awGain = 0.17329078912734985;
        double coldtempctrlpye_basePower = 0.5230847001075745;
        double coldtempctrlpye_gain = 0.9876163005828857;
        double coldtempctrlpye_maxInput = 0.02663552761077881;
        double coldtempctrlpye_maxOutput = 0.8615723848342896;
        double coldtempctrlpye_minInput = 0.8602638244628906;
        double coldtempctrlpye_minOutput = 0.745669424533844;
        double coldtempctrlpye_smoothTime = 0.35171544551849365;
        double coldtempctrlpye_timeConst = 0.7934263944625854;
        double coldtempctrlpye_tolerance = 0.27476412057876587;
        double cryotempctrl_awGain = 0.28927671909332275;
        double cryotempctrl_basePower = 0.9605495929718018;
        double cryotempctrl_gain = 0.2449181079864502;
        double cryotempctrl_maxInput = 0.8207762837409973;
        double cryotempctrl_maxOutput = 0.004761755466461182;
        double cryotempctrl_minInput = 0.46034324169158936;
        double cryotempctrl_minOutput = 0.16555821895599365;
        double cryotempctrl_smoothTime = 0.27150875329971313;
        double cryotempctrl_timeConst = 0.656694f;
        double cryotempctrl_tolerance = 0.10323494672775269;
        long periodictasks_ColdTempCtrlC_iterate_updateTime = 90L;
        long periodictasks_ColdTempCtrlMYE_iterate_updateTime = 258L;
        long periodictasks_ColdTempCtrlPYE_iterate_updateTime = 509L;
        long periodictasks_CryoTempCtrl_iterate_updateTime = 824L;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_PicConfigurationEvent(version, coldtempctrlc_awGain, coldtempctrlc_basePower, coldtempctrlc_gain, coldtempctrlc_maxInput, coldtempctrlc_maxOutput, coldtempctrlc_minInput, coldtempctrlc_minOutput, coldtempctrlc_smoothTime, coldtempctrlc_timeConst, coldtempctrlc_tolerance, coldtempctrlmye_awGain, coldtempctrlmye_basePower, coldtempctrlmye_gain, coldtempctrlmye_maxInput, coldtempctrlmye_maxOutput, coldtempctrlmye_minInput, coldtempctrlmye_minOutput, coldtempctrlmye_smoothTime, coldtempctrlmye_timeConst, coldtempctrlmye_tolerance, coldtempctrlpye_awGain, coldtempctrlpye_basePower, coldtempctrlpye_gain, coldtempctrlpye_maxInput, coldtempctrlpye_maxOutput, coldtempctrlpye_minInput, coldtempctrlpye_minOutput, coldtempctrlpye_smoothTime, coldtempctrlpye_timeConst, coldtempctrlpye_tolerance, cryotempctrl_awGain, cryotempctrl_basePower, cryotempctrl_gain, cryotempctrl_maxInput, cryotempctrl_maxOutput, cryotempctrl_minInput, cryotempctrl_minOutput, cryotempctrl_smoothTime, cryotempctrl_timeConst, cryotempctrl_tolerance, periodictasks_ColdTempCtrlC_iterate_updateTime, periodictasks_ColdTempCtrlMYE_iterate_updateTime, periodictasks_ColdTempCtrlPYE_iterate_updateTime, periodictasks_CryoTempCtrl_iterate_updateTime));
        Assert.assertTrue((boolean)(item instanceof Thermal_PicConfigurationEvent));
        Thermal_PicConfigurationEvent item_ = (Thermal_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)coldtempctrlc_awGain, (double)item_.getColdtempctrlc_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_basePower, (double)item_.getColdtempctrlc_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_gain, (double)item_.getColdtempctrlc_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_maxInput, (double)item_.getColdtempctrlc_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_maxOutput, (double)item_.getColdtempctrlc_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_minInput, (double)item_.getColdtempctrlc_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_minOutput, (double)item_.getColdtempctrlc_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_smoothTime, (double)item_.getColdtempctrlc_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_timeConst, (double)item_.getColdtempctrlc_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_tolerance, (double)item_.getColdtempctrlc_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_awGain, (double)item_.getColdtempctrlmye_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_basePower, (double)item_.getColdtempctrlmye_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_gain, (double)item_.getColdtempctrlmye_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_maxInput, (double)item_.getColdtempctrlmye_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_maxOutput, (double)item_.getColdtempctrlmye_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_minInput, (double)item_.getColdtempctrlmye_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_minOutput, (double)item_.getColdtempctrlmye_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_smoothTime, (double)item_.getColdtempctrlmye_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_timeConst, (double)item_.getColdtempctrlmye_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_tolerance, (double)item_.getColdtempctrlmye_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_awGain, (double)item_.getColdtempctrlpye_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_basePower, (double)item_.getColdtempctrlpye_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_gain, (double)item_.getColdtempctrlpye_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_maxInput, (double)item_.getColdtempctrlpye_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_maxOutput, (double)item_.getColdtempctrlpye_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_minInput, (double)item_.getColdtempctrlpye_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_minOutput, (double)item_.getColdtempctrlpye_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_smoothTime, (double)item_.getColdtempctrlpye_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_timeConst, (double)item_.getColdtempctrlpye_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_tolerance, (double)item_.getColdtempctrlpye_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_awGain, (double)item_.getCryotempctrl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_basePower, (double)item_.getCryotempctrl_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_gain, (double)item_.getCryotempctrl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_maxInput, (double)item_.getCryotempctrl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_maxOutput, (double)item_.getCryotempctrl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_minInput, (double)item_.getCryotempctrl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_minOutput, (double)item_.getCryotempctrl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_smoothTime, (double)item_.getCryotempctrl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_timeConst, (double)item_.getCryotempctrl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_tolerance, (double)item_.getCryotempctrl_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((long)periodictasks_ColdTempCtrlC_iterate_updateTime, (long)item_.getPeriodictasks_ColdTempCtrlC_iterate_updateTime());
        Assert.assertEquals((long)periodictasks_ColdTempCtrlMYE_iterate_updateTime, (long)item_.getPeriodictasks_ColdTempCtrlMYE_iterate_updateTime());
        Assert.assertEquals((long)periodictasks_ColdTempCtrlPYE_iterate_updateTime, (long)item_.getPeriodictasks_ColdTempCtrlPYE_iterate_updateTime());
        Assert.assertEquals((long)periodictasks_CryoTempCtrl_iterate_updateTime, (long)item_.getPeriodictasks_CryoTempCtrl_iterate_updateTime());
    }

    @Test
    public void sendReceiveThermal_RefrigConfigurationEvent() throws Exception {
        String version = "";
        double coldtempctrlc_tempDeadband = 0.3840165138244629;
        double coldtempctrlc_tempLimit = 0.2980801f;
        String coldtempctrlc_tempWeights = "";
        double coldtempctrlmye_tempDeadband = 0.5336012840270996;
        double coldtempctrlmye_tempLimit = 0.7146857380867004;
        String coldtempctrlmye_tempWeights = "";
        double coldtempctrlpye_tempDeadband = 0.7603783011436462;
        double coldtempctrlpye_tempLimit = 0.9566890597343445;
        String coldtempctrlpye_tempWeights = "u";
        double cryotempctrl_tempDeadband = 0.6132370829582214;
        double cryotempctrl_tempLimit = 0.7398157119750977;
        String cryotempctrl_tempWeights = "";
        double[] trimpower_coldPowerWeights = TestHelper.generateDoubleArray((int)6, (int)-1618003822);
        String trimpower_connType = "";
        double[] trimpower_cryoPowerWeights = TestHelper.generateDoubleArray((int)6, (int)416958754);
        String trimpower_devcId = "j";
        int trimpower_devcParm = 466;
        int trimpower_node = 266;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_RefrigConfigurationEvent(version, coldtempctrlc_tempDeadband, coldtempctrlc_tempLimit, coldtempctrlc_tempWeights, coldtempctrlmye_tempDeadband, coldtempctrlmye_tempLimit, coldtempctrlmye_tempWeights, coldtempctrlpye_tempDeadband, coldtempctrlpye_tempLimit, coldtempctrlpye_tempWeights, cryotempctrl_tempDeadband, cryotempctrl_tempLimit, cryotempctrl_tempWeights, trimpower_coldPowerWeights, trimpower_connType, trimpower_cryoPowerWeights, trimpower_devcId, trimpower_devcParm, trimpower_node));
        Assert.assertTrue((boolean)(item instanceof Thermal_RefrigConfigurationEvent));
        Thermal_RefrigConfigurationEvent item_ = (Thermal_RefrigConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)coldtempctrlc_tempDeadband, (double)item_.getColdtempctrlc_tempDeadband(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_tempLimit, (double)item_.getColdtempctrlc_tempLimit(), (double)1.0E-6f);
        Assert.assertEquals((Object)coldtempctrlc_tempWeights, (Object)item_.getColdtempctrlc_tempWeights());
        Assert.assertEquals((double)coldtempctrlmye_tempDeadband, (double)item_.getColdtempctrlmye_tempDeadband(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_tempLimit, (double)item_.getColdtempctrlmye_tempLimit(), (double)1.0E-6f);
        Assert.assertEquals((Object)coldtempctrlmye_tempWeights, (Object)item_.getColdtempctrlmye_tempWeights());
        Assert.assertEquals((double)coldtempctrlpye_tempDeadband, (double)item_.getColdtempctrlpye_tempDeadband(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_tempLimit, (double)item_.getColdtempctrlpye_tempLimit(), (double)1.0E-6f);
        Assert.assertEquals((Object)coldtempctrlpye_tempWeights, (Object)item_.getColdtempctrlpye_tempWeights());
        Assert.assertEquals((double)cryotempctrl_tempDeadband, (double)item_.getCryotempctrl_tempDeadband(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_tempLimit, (double)item_.getCryotempctrl_tempLimit(), (double)1.0E-6f);
        Assert.assertEquals((Object)cryotempctrl_tempWeights, (Object)item_.getCryotempctrl_tempWeights());
        Assert.assertArrayEquals((double[])trimpower_coldPowerWeights, (double[])item_.getTrimpower_coldPowerWeights(), (double)1.0E-6f);
        Assert.assertEquals((Object)trimpower_connType, (Object)item_.getTrimpower_connType());
        Assert.assertArrayEquals((double[])trimpower_cryoPowerWeights, (double[])item_.getTrimpower_cryoPowerWeights(), (double)1.0E-6f);
        Assert.assertEquals((Object)trimpower_devcId, (Object)item_.getTrimpower_devcId());
        Assert.assertEquals((long)trimpower_devcParm, (long)item_.getTrimpower_devcParm());
        Assert.assertEquals((long)trimpower_node, (long)item_.getTrimpower_node());
    }

    @Test
    public void sendReceiveThermal_ThermalLimitsConfigurationEvent() throws Exception {
        String version = "i";
        double coldTempLimit = 0.9386687278747559;
        double coldTempLowLimit = 0.980285108089447;
        double cryoTempLowLimit = 0.6908504962921143;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_ThermalLimitsConfigurationEvent(version, coldTempLimit, coldTempLowLimit, cryoTempLowLimit));
        Assert.assertTrue((boolean)(item instanceof Thermal_ThermalLimitsConfigurationEvent));
        Thermal_ThermalLimitsConfigurationEvent item_ = (Thermal_ThermalLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)coldTempLimit, (double)item_.getColdTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempLowLimit, (double)item_.getColdTempLowLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoTempLowLimit, (double)item_.getCryoTempLowLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_timersConfigurationEvent() throws Exception {
        String version = "c";
        long periodictasks_ColdTempCtrlC_tempCheck_taskPeriodMillis = 657L;
        long periodictasks_ColdTempCtrlMYE_tempCheck_taskPeriodMillis = 27L;
        long periodictasks_ColdTempCtrlPYE_tempCheck_taskPeriodMillis = 662L;
        long periodictasks_CryoTempCtrl_tempCheck_taskPeriodMillis = 417L;
        long periodictasks_Rtds_check_status_taskPeriodMillis = 353L;
        long periodictasks_agentMonitorService_taskPeriodMillis = 99L;
        long periodictasks_heartbeat_taskPeriodMillis = 886L;
        long periodictasks_maintain_power_TrimPower_taskPeriodMillis = 569L;
        long periodictasks_monitor_check_ProtRtds_taskPeriodMillis = 722L;
        long periodictasks_monitor_check_Rtds_taskPeriodMillis = 696L;
        long periodictasks_monitor_check_TrimPower_taskPeriodMillis = 759L;
        long periodictasks_monitor_publish_avgTemp_taskPeriodMillis = 96L;
        long periodictasks_monitor_publish_coldTemp_taskPeriodMillis = 709L;
        long periodictasks_monitor_publish_taskPeriodMillis = 792L;
        long periodictasks_monitor_update_avgTemp_taskPeriodMillis = 315L;
        long periodictasks_monitor_update_coldTemp_taskPeriodMillis = 329L;
        long periodictasks_monitor_update_taskPeriodMillis = 703L;
        long periodictasks_runtimeInfo_taskPeriodMillis = 781L;
        long periodictasks_thermal_state_taskPeriodMillis = 32L;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_timersConfigurationEvent(version, periodictasks_ColdTempCtrlC_tempCheck_taskPeriodMillis, periodictasks_ColdTempCtrlMYE_tempCheck_taskPeriodMillis, periodictasks_ColdTempCtrlPYE_tempCheck_taskPeriodMillis, periodictasks_CryoTempCtrl_tempCheck_taskPeriodMillis, periodictasks_Rtds_check_status_taskPeriodMillis, periodictasks_agentMonitorService_taskPeriodMillis, periodictasks_heartbeat_taskPeriodMillis, periodictasks_maintain_power_TrimPower_taskPeriodMillis, periodictasks_monitor_check_ProtRtds_taskPeriodMillis, periodictasks_monitor_check_Rtds_taskPeriodMillis, periodictasks_monitor_check_TrimPower_taskPeriodMillis, periodictasks_monitor_publish_avgTemp_taskPeriodMillis, periodictasks_monitor_publish_coldTemp_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_avgTemp_taskPeriodMillis, periodictasks_monitor_update_coldTemp_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis, periodictasks_runtimeInfo_taskPeriodMillis, periodictasks_thermal_state_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Thermal_timersConfigurationEvent));
        Thermal_timersConfigurationEvent item_ = (Thermal_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)periodictasks_ColdTempCtrlC_tempCheck_taskPeriodMillis, (long)item_.getPeriodictasks_ColdTempCtrlC_tempCheck_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_ColdTempCtrlMYE_tempCheck_taskPeriodMillis, (long)item_.getPeriodictasks_ColdTempCtrlMYE_tempCheck_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_ColdTempCtrlPYE_tempCheck_taskPeriodMillis, (long)item_.getPeriodictasks_ColdTempCtrlPYE_tempCheck_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_CryoTempCtrl_tempCheck_taskPeriodMillis, (long)item_.getPeriodictasks_CryoTempCtrl_tempCheck_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_Rtds_check_status_taskPeriodMillis, (long)item_.getPeriodictasks_Rtds_check_status_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_agentMonitorService_taskPeriodMillis, (long)item_.getPeriodictasks_agentMonitorService_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_heartbeat_taskPeriodMillis, (long)item_.getPeriodictasks_heartbeat_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_maintain_power_TrimPower_taskPeriodMillis, (long)item_.getPeriodictasks_maintain_power_TrimPower_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_ProtRtds_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_ProtRtds_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_Rtds_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_Rtds_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_TrimPower_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_TrimPower_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_publish_avgTemp_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_publish_avgTemp_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_publish_coldTemp_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_publish_coldTemp_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_publish_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_update_avgTemp_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_update_avgTemp_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_update_coldTemp_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_update_coldTemp_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_update_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_update_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_runtimeInfo_taskPeriodMillis, (long)item_.getPeriodictasks_runtimeInfo_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_thermal_state_taskPeriodMillis, (long)item_.getPeriodictasks_thermal_state_taskPeriodMillis());
    }

    @Test
    public void sendReceiveUtiltrunk_BFR_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_BFR_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_BFR_DevicesConfigurationEvent));
        Utiltrunk_BFR_DevicesConfigurationEvent item_ = (Utiltrunk_BFR_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveUtiltrunk_BFR_UtilConfigurationEvent() throws Exception {
        String version = "w";
        int node = 784;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_BFR_UtilConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_BFR_UtilConfigurationEvent));
        Utiltrunk_BFR_UtilConfigurationEvent item_ = (Utiltrunk_BFR_UtilConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveUtiltrunk_BodyMaq20_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String node = "";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_BodyMaq20_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_BodyMaq20_DeviceConfigurationEvent));
        Utiltrunk_BodyMaq20_DeviceConfigurationEvent item_ = (Utiltrunk_BodyMaq20_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveUtiltrunk_BodyMaq20_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_BodyMaq20_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_BodyMaq20_DevicesConfigurationEvent));
        Utiltrunk_BodyMaq20_DevicesConfigurationEvent item_ = (Utiltrunk_BodyMaq20_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveUtiltrunk_Body_AmbAirtemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.2971833348274231;
        double warnLo = 0.17291676998138428;
        double limitHi = 0.3964492678642273;
        double limitLo = 0.28606903553009033;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_AmbAirtemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_AmbAirtemp_LimitsConfigurationEvent));
        Utiltrunk_Body_AmbAirtemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_AmbAirtemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_AverageTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.45358043909072876;
        double warnLo = 0.8229976892471313;
        double limitHi = 0.07878583669662476;
        double limitLo = 0.1583128571510315;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_AverageTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_AverageTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_AverageTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_AverageTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_BackFlngXMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.6138122081756592;
        double warnLo = 0.7616521120071411;
        double limitHi = 0.181441068649292;
        double limitLo = 0.3565155267715454;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_BackFlngXMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_BackFlngXMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_BackFlngXMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_BackFlngXMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_BackFlngXPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.24437177181243896;
        double warnLo = 0.55808025598526;
        double limitHi = 0.7784669399261475;
        double limitLo = 0.1747505f;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_BackFlngXPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_BackFlngXPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_BackFlngXPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_BackFlngXPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_BackFlngYMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "g";
        double warnHi = 0.19584494829177856;
        double warnLo = 0.04350852966308594;
        double limitHi = 0.3487668037414551;
        double limitLo = 0.5736426115036011;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_BackFlngYMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_BackFlngYMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_BackFlngYMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_BackFlngYMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_CamBodyXPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.8685665726661682;
        double warnLo = 0.18529528379440308;
        double limitHi = 0.8653779029846191;
        double limitLo = 0.7696412205696106;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_CamBodyXPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_CamBodyXPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_CamBodyXPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_CamBodyXPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_CamBodyYMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "z";
        double warnHi = 0.6559988260269165;
        double warnLo = 0.48620766401290894;
        double limitHi = 0.15396034717559814;
        double limitLo = 0.9419606328010559;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_CamBodyYMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_CamBodyYMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_CamBodyYMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_CamBodyYMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_CamBodyYPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "k";
        double warnHi = 0.0745890736579895;
        double warnLo = 0.5363178253173828;
        double limitHi = 0.12388885021209717;
        double limitLo = 0.93117f;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_CamBodyYPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_CamBodyYPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_CamBodyYPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_CamBodyYPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_CamHousXMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.7913951277732849;
        double warnLo = 0.7020647525787354;
        double limitHi = 0.027035772800445557;
        double limitLo = 0.87954181432724;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_CamHousXMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_CamHousXMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_CamHousXMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_CamHousXMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_CamHousXPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.06456923484802246;
        double warnLo = 0.7436206340789795;
        double limitHi = 0.5795066952705383;
        double limitLo = 0.4074091911315918;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_CamHousXPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_CamHousXPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_CamHousXPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_CamHousXPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_CamHousYMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.8240005373954773;
        double warnLo = 0.518421471118927;
        double limitHi = 0.3058089017868042;
        double limitLo = 0.4776777f;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_CamHousYMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_CamHousYMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_CamHousYMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_CamHousYMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_CamHousYPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "x";
        double warnHi = 0.2792188f;
        double warnLo = 0.5696732997894287;
        double limitHi = 0.7104860544204712;
        double limitLo = 0.304135262966156;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_CamHousYPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_CamHousYPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_CamHousYPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_CamHousYPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ChgrYMinusRtnAirTemp_LimitsConfigurationEvent() throws Exception {
        String version = "s";
        double warnHi = 0.3795526f;
        double warnLo = 0.03384626f;
        double limitHi = 0.6241716742515564;
        double limitLo = 0.5565491318702698;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ChgrYMinusRtnAirTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ChgrYMinusRtnAirTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_ChgrYMinusRtnAirTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ChgrYMinusRtnAirTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ChgrYMinusRtnAirVel_LimitsConfigurationEvent() throws Exception {
        String version = "a";
        double warnHi = 0.2004251480102539;
        double warnLo = 0.7636793851852417;
        double limitHi = 0.8251405954360962;
        double limitLo = 0.35672032833099365;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ChgrYMinusRtnAirVel_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ChgrYMinusRtnAirVel_LimitsConfigurationEvent));
        Utiltrunk_Body_ChgrYMinusRtnAirVel_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ChgrYMinusRtnAirVel_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_DomeXMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.4782752990722656;
        double warnLo = 0.7239797711372375;
        double limitHi = 0.7197815775871277;
        double limitLo = 0.9183598160743713;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_DomeXMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_DomeXMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_DomeXMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_DomeXMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_DomeYMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.24312078952789307;
        double warnLo = 0.5844906568527222;
        double limitHi = 0.4658542275428772;
        double limitLo = 0.35205912590026855;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_DomeYMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_DomeYMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_DomeYMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_DomeYMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_L1XMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.3365342f;
        double warnLo = 0.03115654f;
        double limitHi = 0.4191882014274597;
        double limitLo = 0.004744529724121094;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_L1XMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_L1XMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_L1XMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_L1XMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_L1YMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "o";
        double warnHi = 0.22007405757904053;
        double warnLo = 0.541482150554657;
        double limitHi = 0.5644496083259583;
        double limitLo = 0.9477417469024658;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_L1YMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_L1YMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_L1YMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_L1YMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_L2XMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.10220110416412354;
        double warnLo = 0.4452778100967407;
        double limitHi = 0.5164448618888855;
        double limitLo = 0.944242537021637;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_L2XMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_L2XMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_L2XMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_L2XMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_L2XPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "g";
        double warnHi = 0.5737094879150391;
        double warnLo = 0.0709908f;
        double limitHi = 0.05176180601119995;
        double limitLo = 0.25011515617370605;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_L2XPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_L2XPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_L2XPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_L2XPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_L2YPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.8028997182846069;
        double warnLo = 0.4242568016052246;
        double limitHi = 0.5157331228256226;
        double limitLo = 0.5582222938537598;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_L2YPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_L2YPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_L2YPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_L2YPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ShrdRngXMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.32102978229522705;
        double warnLo = 0.7797937989234924;
        double limitHi = 0.8791483640670776;
        double limitLo = 0.6195932626724243;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ShrdRngXMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ShrdRngXMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_ShrdRngXMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ShrdRngXMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ShrdRngXPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.7638687491416931;
        double warnLo = 0.9366223216056824;
        double limitHi = 0.04617792367935181;
        double limitLo = 0.3258591294288635;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ShrdRngXPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ShrdRngXPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_ShrdRngXPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ShrdRngXPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ShrdRngYMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "r";
        double warnHi = 0.8271254897117615;
        double warnLo = 0.06476038694381714;
        double limitHi = 0.9718087911605835;
        double limitLo = 0.4123146f;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ShrdRngYMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ShrdRngYMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_ShrdRngYMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ShrdRngYMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ShrdRngYPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "l";
        double warnHi = 0.525852f;
        double warnLo = 0.12419843673706055;
        double limitHi = 0.8240468502044678;
        double limitLo = 0.7583534717559814;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ShrdRngYPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ShrdRngYPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_ShrdRngYPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ShrdRngYPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ShtrEboxRtnAirTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.21386557817459106;
        double warnLo = 0.36055612564086914;
        double limitHi = 0.8323262333869934;
        double limitLo = 0.6992086172103882;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ShtrEboxRtnAirTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ShtrEboxRtnAirTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_ShtrEboxRtnAirTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ShtrEboxRtnAirTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ShtrEboxRtnAirVel_LimitsConfigurationEvent() throws Exception {
        String version = "h";
        double warnHi = 0.3641442656517029;
        double warnLo = 0.8141933679580688;
        double limitHi = 0.06189322471618652;
        double limitLo = 0.9578322172164917;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ShtrEboxRtnAirVel_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ShtrEboxRtnAirVel_LimitsConfigurationEvent));
        Utiltrunk_Body_ShtrEboxRtnAirVel_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ShtrEboxRtnAirVel_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ShtrMtrRtnAirTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.3699355125427246;
        double warnLo = 0.4264281392097473;
        double limitHi = 0.05219519f;
        double limitLo = 0.6109493970870972;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ShtrMtrRtnAirTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
 