/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.event.AlertRaisedEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.CCSConfiguredEvent;
import org.lsst.sal.camera.event.Chiller_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Chiller_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Chiller_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Chiller_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Chiller_PicConfigurationEvent;
import org.lsst.sal.camera.event.Chiller_timersConfigurationEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_StatisticsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_StoreConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_StoreConfigurationEvent;
import org.lsst.sal.camera.event.EndInitializeGuiderEvent;
import org.lsst.sal.camera.event.EndInitializeImageEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.Fcs_Autochanger_autochangerConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Autochanger_readRateConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Autochanger_sensorConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus0_canbusConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus0_controllerConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus0_nodeIDConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus0_sensorConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus0_serialNBConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus1_canbusConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus1_controllerConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus1_nodeIDConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus1_serialNBConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Carousel_carouselConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Carousel_readRateConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Carousel_sensorConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_FilterIdentificator_sensorConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_FilterManager_filterConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Loader_loaderConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Loader_readRateConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Loader_sensorConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.FilterChangerPowerStatusEvent;
import org.lsst.sal.camera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageDatabaseService_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageNameService_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_InstrumentConfig_InstrumentConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_MonitoringConfig_MonitoringConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlStatusConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebTotalPower_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsPowerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_timersConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Segment_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_DAQConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_GuiderConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_SequencerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_WebHooksConfig_VisualizationConfigurationEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.Hex_Cold1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cold2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo3_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo4_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo5_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo6_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Maq20_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Maq20_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Hex_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Hex_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Hex_StatusAggregator_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.Image_handling_FitsService_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_CommandsConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_DAQConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_FitsHandlingConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_GuiderConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_StatusAggregator_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.Mpm_CLP_RTD_03_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_CLP_RTD_05_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_CLP_RTD_50_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_CLP_RTD_55_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_CYP_RTD_12_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_CYP_RTD_14_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_CYP_RTD_31_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_CYP_RTD_43_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_Pluto_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_Pluto_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_Maq20_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_Maq20_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.Rebpower_EmergencyResponseManager_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Power_timersConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_RebTotalPower_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Reb_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Reb_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_PowerConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_buildConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_PicConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_PicConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_CryoCompLimits_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_PeriodicTasks_PicConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Shutter_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Shutter_timersConfigurationEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.camera.event.SummaryStatusEvent;
import org.lsst.sal.camera.event.Thermal_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_PicConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_RefrigConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_ThermalLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_BFR_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_BFR_UtilConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_BodyMaq20_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_BodyMaq20_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_AmbAirtemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_AverageTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_BackFlngXMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_BackFlngXPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_BackFlngYMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_CamBodyXPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_CamBodyYMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_CamBodyYPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_CamHousXMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_CamHousXPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_CamHousYMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_CamHousYPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ChgrYMinusRtnAirTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ChgrYMinusRtnAirVel_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_DomeXMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_DomeYMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_L1XMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_L1YMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_L2XMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_L2XPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_L2YPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ShrdRngXMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ShrdRngXPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ShrdRngYMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ShrdRngYPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ShtrEboxRtnAirTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ShtrEboxRtnAirVel_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ShtrMtrRtnAirTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_ShtrMtrRtnAirVel_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Body_VPPlenumInTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPCFan_PicConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_AvgAirtempOut_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_DeltaPressFilt_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_DeltaPressTotal_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_DeltaTempAct_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_FanRunTime_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_FanSpeed_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_Humidity_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_PreFiltPress_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_RetnAirTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_RetnPress_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_SplyAirTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_SplyPress_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_MPC_ValvePosn_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PDU_48V_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PDU_48V_UtilConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_AgentMonitorService_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_BodyMaq20_check_status_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Fan_loop_MPCFan_PicConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Fan_loop_UTFan_PicConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Fan_loop_VPCFan_PicConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Heartbeat_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Monitor_check_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Monitor_publish_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Monitor_update_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_RuntimeInfo_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Schedulers_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_UT_alarms_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_UT_state_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_UtMaq20_check_status_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_PeriodicTasks_Vpc_loop_VPCHtrs_timersConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_Telescope_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UTFan_PicConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_AverageTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_CoolFlowRate_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_CoolPipeRetnTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_CoolPipeSplyTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_DomeXMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_DomeYMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_FanInletTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_FanRunTime_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_FanSpeed_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_MidXMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_MidXPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_SuppXMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_SuppXPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_TopXMinusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_TopXPlusTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_ValvePosn_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_W2Q1Temp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UT_W4Q3Temp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UtMaq20_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UtMaq20_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_UtilConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPCFan_PicConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPCHtrs_VpcConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_DeltaPressFilt_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_DeltaPressTotal_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_DeltaTempAct_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_FanRunTime_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_FanSpeed_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_HtrCurrent_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_Humidity_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_PreFiltPress_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_RetnAirTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_RetnPress_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_SplyAirTemp_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_SplyAirVel_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_SplyPress_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Utiltrunk_VPC_ValvePosn_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Cip_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoFlineGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoFlineGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoTurboGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoTurboGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoTurboPump_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoTurboPump_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoVacGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoVacGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Cryo_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HX_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexFlineGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexFlineGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexTurboGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexTurboGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexTurboPump_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexTurboPump_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexVacGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexVacGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Hip_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_InstVacGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_InstVacGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Inst_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_IonPumps_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_IonPumps_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Maq20Cryo_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Maq20Cryo_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Maq20Ut_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Maq20Ut_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PDU_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PDU_VacuumConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PumpCart_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PumpCart_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_VacPluto_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_VacPluto_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_VacuumConfigurationEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 423;
        String imageName = "eicjgpqqzngepvkoozsxfdgn";
        int imageIndex = 983;
        String imageSource = "";
        String imageController = "x";
        String imageDate = "ortnj";
        int imageNumber = 16;
        double timestampAcquisitionStart = 0.1982351f;
        double requestedExposureTime = 0.4806622266769409;
        double timestampEndOfReadout = 0.02030092477798462;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, requestedExposureTime, timestampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampEndOfReadout, (double)item_.getTimestampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        double timestampTransition = 0.9029384851455688;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws Exception {
        String filterName = "";
        String filterType = "t";
        SALEvent item = this.testSendReceive((SALEvent)new StartSetFilterEvent(filterName, filterType));
        Assert.assertTrue((boolean)(item instanceof StartSetFilterEvent));
        StartSetFilterEvent item_ = (StartSetFilterEvent)item;
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws Exception {
        double timestampTransition = 0.2011834979057312;
        SALEvent item = this.testSendReceive((SALEvent)new StartUnloadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent item_ = (StartUnloadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        double timestampTransition = 0.6703230738639832;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        double timestampTransition = 0.06900107860565186;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeGuiderEvent() throws Exception {
        double timestampTransition = 0.6989688277244568;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeGuiderEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeGuiderEvent));
        EndInitializeGuiderEvent item_ = (EndInitializeGuiderEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        double timestampTransition = 0.115861f;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        String additionalKeys = "";
        String additionalValues = "n";
        int imagesInSequence = 725;
        String imageName = "iybbydygmabfrjuk";
        int imageIndex = 321;
        String imageSource = "fm";
        String imageController = "w";
        String imageDate = "oe";
        int imageNumber = 190;
        double timestampAcquisitionStart = 0.4420720338821411;
        double exposureTime = 0.039211273193359375;
        String imageTag = "crkmftcfudwlsjyvjxwjbmwlxormu";
        double timestampDateObs = 0.2913547158241272;
        double timestampDateEnd = 0.05296283960342407;
        double measuredShutterOpenTime = 0.07489949464797974;
        double darkTime = 0.7162687182426453;
        String emulatedImage = "a";
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime, emulatedImage));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)emulatedImage, (Object)item_.getEmulatedImage());
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws Exception {
        double timestampTransition = 0.38669872283935547;
        SALEvent item = this.testSendReceive((SALEvent)new EndUnloadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent item_ = (EndUnloadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws Exception {
        double timestampTransition = 0.7161986231803894;
        SALEvent item = this.testSendReceive((SALEvent)new EndRotateCarouselEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent item_ = (EndRotateCarouselEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws Exception {
        double timestampTransition = 0.3920171856880188;
        SALEvent item = this.testSendReceive((SALEvent)new StartLoadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartLoadFilterEvent));
        StartLoadFilterEvent item_ = (StartLoadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        double timestampTransition = 0.908560037612915;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        double timestampTransition = 0.7810500860214233;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveCCSConfiguredEvent() throws Exception {
        double timestampTransition = 0.668667733669281;
        SALEvent item = this.testSendReceive((SALEvent)new CCSConfiguredEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof CCSConfiguredEvent));
        CCSConfiguredEvent item_ = (CCSConfiguredEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws Exception {
        double timestampTransition = 0.6815060377120972;
        SALEvent item = this.testSendReceive((SALEvent)new EndLoadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndLoadFilterEvent));
        EndLoadFilterEvent item_ = (EndLoadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        double timestampTransition = 0.8702144026756287;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        String additionalKeys = "k";
        String additionalValues = "q";
        int imagesInSequence = 805;
        String imageName = "etslvdrdpyn";
        int imageIndex = 335;
        String imageSource = "e";
        String imageController = "";
        String imageDate = "hn";
        int imageNumber = 399;
        double timestampAcquisitionStart = 0.9397023916244507;
        double exposureTime = 0.6912664771080017;
        String mode = "v";
        double timeout = 0.5628124475479126;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, mode, timeout));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((double)timeout, (double)item_.getTimeout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeImageEvent() throws Exception {
        double timestampTransition = 0.5337963700294495;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeImageEvent));
        EndInitializeImageEvent item_ = (EndInitializeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws Exception {
        String filterName = "";
        String filterType = "";
        int filterSlot = 133;
        double filterPosition = 0.4290521740913391;
        SALEvent item = this.testSendReceive((SALEvent)new EndSetFilterEvent(filterName, filterType, filterSlot, filterPosition));
        Assert.assertTrue((boolean)(item instanceof EndSetFilterEvent));
        EndSetFilterEvent item_ = (EndSetFilterEvent)item;
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
        Assert.assertEquals((long)filterSlot, (long)item_.getFilterSlot());
        Assert.assertEquals((double)filterPosition, (double)item_.getFilterPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        double timestampTransition = 0.5368488430976868;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws Exception {
        String filterNames = "ytkjuyhyzwirzilycbyllrzadpaeuerhlvukfvlofeyceijpjijblghnyjpffbcksxwvwdpuhj";
        String filterTypes = "ouisgxhtrvwqnmenqiyjgsyfqdeelosixirsmhnddyrhmpolaatatguejjmwmfeoaclwuexojmhlpkystpmanwcangdisqfvxuqwqysiafomtyjrzxwfucnamoaezfanauhnnootuhjusprpmldiutxsqcaageunvdyvuwxmpzbhnnlfaodrmazjfkyewrpjmwrtkaigzuaqyzmyymnpodojhymuggilkxlhgpseuuibuyrlojdhzqovea";
        double maxChangeAngle = 0.18748044967651367;
        double maxFastChangeAngle = 0.15744614601135254;
        double[] maxSlowChangeTime = TestHelper.generateDoubleArray((int)6, (int)826183506);
        double[] maxFastChangeTime = TestHelper.generateDoubleArray((int)6, (int)-1182440019);
        SALEvent item = this.testSendReceive((SALEvent)new AvailableFiltersEvent(filterNames, filterTypes, maxChangeAngle, maxFastChangeAngle, maxSlowChangeTime, maxFastChangeTime));
        Assert.assertTrue((boolean)(item instanceof AvailableFiltersEvent));
        AvailableFiltersEvent item_ = (AvailableFiltersEvent)item;
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
        Assert.assertEquals((Object)filterTypes, (Object)item_.getFilterTypes());
        Assert.assertEquals((double)maxChangeAngle, (double)item_.getMaxChangeAngle(), (double)1.0E-6f);
        Assert.assertEquals((double)maxFastChangeAngle, (double)item_.getMaxFastChangeAngle(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxSlowChangeTime, (double[])item_.getMaxSlowChangeTime(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxFastChangeTime, (double[])item_.getMaxFastChangeTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        String additionalKeys = "w";
        String additionalValues = "n";
        int imagesInSequence = 672;
        String imageName = "oaorfjzvnqofqitxyuovvualrabk";
        int imageIndex = 985;
        String imageSource = "md";
        String imageController = "";
        String imageDate = "drmgb";
        int imageNumber = 894;
        double timestampAcquisitionStart = 0.13036507368087769;
        double exposureTime = 0.263749361038208;
        double timestampStartOfReadout = 0.8565203547477722;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampStartOfReadout, (double)item_.getTimestampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws Exception {
        double timestampTransition = 0.6208995580673218;
        SALEvent item = this.testSendReceive((SALEvent)new StartRotateCarouselEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent item_ = (StartRotateCarouselEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        String imageName = "t";
        String ccdLocation = "r";
        String raftBay = "a";
        String ccdSlot = "s";
        Object[] ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V};
        int[] overRows = TestHelper.generateIntArray((int)201, (int)540777305);
        int[] overCols = TestHelper.generateIntArray((int)201, (int)861964373);
        int[] readRows = TestHelper.generateIntArray((int)201, (int)1039945894);
        int[] readCols = TestHelper.generateIntArray((int)201, (int)1453464562);
        int[] readCols2 = TestHelper.generateIntArray((int)201, (int)-944841913);
        int[] preCols = TestHelper.generateIntArray((int)201, (int)-1414909128);
        int[] preRows = TestHelper.generateIntArray((int)201, (int)-1656959271);
        int[] postCols = TestHelper.generateIntArray((int)201, (int)-488729533);
        int[] underCols = TestHelper.generateIntArray((int)201, (int)679431821);
        String daqFolder = "b";
        String daqAnnotation = "v";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(imageName, ccdLocation, raftBay, ccdSlot, (ImageReadoutParametersEvent.CcdType[])ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((int[])overRows, (int[])item_.getOverRows());
        Assert.assertArrayEquals((int[])overCols, (int[])item_.getOverCols());
        Assert.assertArrayEquals((int[])readRows, (int[])item_.getReadRows());
        Assert.assertArrayEquals((int[])readCols, (int[])item_.getReadCols());
        Assert.assertArrayEquals((int[])readCols2, (int[])item_.getReadCols2());
        Assert.assertArrayEquals((int[])preCols, (int[])item_.getPreCols());
        Assert.assertArrayEquals((int[])preRows, (int[])item_.getPreRows());
        Assert.assertArrayEquals((int[])postCols, (int[])item_.getPostCols());
        Assert.assertArrayEquals((int[])underCols, (int[])item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        String ccdLocation = "q";
        String raftBay = "q";
        String ccdSlot = "w";
        String rebSerialNumber = "w";
        String rebLSSTName = "";
        String ccdLSSTName = "r";
        String raftLSSTName = "y";
        String ccdManSerNum = "z";
        String ccdManufacturer = "b";
        Object[] ccdType = new FocalPlaneSummaryInfoEvent.CcdType[]{FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL};
        double[] ccdTempSetPoint = TestHelper.generateDoubleArray((int)212, (int)997436211);
        String sequencerKey = "k";
        String sequencerChecksum = "";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, (FocalPlaneSummaryInfoEvent.CcdType[])ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((double[])ccdTempSetPoint, (double[])item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveQuadbox_BFR_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_DevicesConfigurationEvent));
        Quadbox_BFR_DevicesConfigurationEvent item_ = (Quadbox_BFR_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_BFR_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double clean_5_24V_I_warnHi = 0.14500826597213745;
        double clean_5_24V_I_warnLo = 0.10195744037628174;
        double clean_5_24V_I_limitHi = 0.7472650408744812;
        double clean_5_24V_I_limitLo = 0.7284701466560364;
        double dirty_24V_I_warnHi = 0.5455885529518127;
        double dirty_24V_I_warnLo = 0.8110129237174988;
        double dirty_24V_I_limitHi = 0.19291293621063232;
        double dirty_24V_I_limitLo = 0.7421621084213257;
        double dirty_28V_I_warnHi = 0.09804767370223999;
        double dirty_28V_I_warnLo = 0.4464316964149475;
        double dirty_28V_I_limitHi = 0.3112324f;
        double dirty_28V_I_limitLo = 0.15415281057357788;
        double dirty_48V_I_warnHi = 0.6058251857757568;
        double dirty_48V_I_warnLo = 0.10584050416946411;
        double dirty_48V_I_limitHi = 0.8688523173332214;
        double dirty_48V_I_limitLo = 0.05147433280944824;
        double protection_I_warnHi = 0.7004167437553406;
        double protection_I_warnLo = 0.6102726459503174;
        double protection_I_limitHi = 0.16373854875564575;
        double protection_I_limitLo = 0.2257222f;
        double rebps_0_2_I_warnHi = 0.6810241937637329;
        double rebps_0_2_I_warnLo = 0.1661999225616455;
        double rebps_0_2_I_limitHi = 0.9088693857192993;
        double rebps_0_2_I_limitLo = 0.11945706605911255;
        double rebps_3_5_I_warnHi = 0.2741441f;
        double rebps_3_5_I_warnLo = 0.766837f;
        double rebps_3_5_I_limitHi = 0.7217692732810974;
        double rebps_3_5_I_limitLo = 0.5272254347801208;
        double rebps_6_8_I_warnHi = 0.7229553461074829;
        double rebps_6_8_I_warnLo = 0.9956062436103821;
        double rebps_6_8_I_limitHi = 0.9965223670005798;
        double rebps_6_8_I_limitLo = 0.14721661806106567;
        double rebps_9_12_I_warnHi = 0.4042872190475464;
        double rebps_9_12_I_warnLo = 0.6199347376823425;
        double rebps_9_12_I_limitHi = 0.746765673160553;
        double rebps_9_12_I_limitLo = 0.9629706144332886;
        double rebps_Spr_I_warnHi = 0.8263643383979797;
        double rebps_Spr_I_warnLo = 0.6142929196357727;
        double rebps_Spr_I_limitHi = 0.6880226731300354;
        double rebps_Spr_I_limitLo = 0.6466214656829834;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_LimitsConfigurationEvent(version, clean_5_24V_I_warnHi, clean_5_24V_I_warnLo, clean_5_24V_I_limitHi, clean_5_24V_I_limitLo, dirty_24V_I_warnHi, dirty_24V_I_warnLo, dirty_24V_I_limitHi, dirty_24V_I_limitLo, dirty_28V_I_warnHi, dirty_28V_I_warnLo, dirty_28V_I_limitHi, dirty_28V_I_limitLo, dirty_48V_I_warnHi, dirty_48V_I_warnLo, dirty_48V_I_limitHi, dirty_48V_I_limitLo, protection_I_warnHi, protection_I_warnLo, protection_I_limitHi, protection_I_limitLo, rebps_0_2_I_warnHi, rebps_0_2_I_warnLo, rebps_0_2_I_limitHi, rebps_0_2_I_limitLo, rebps_3_5_I_warnHi, rebps_3_5_I_warnLo, rebps_3_5_I_limitHi, rebps_3_5_I_limitLo, rebps_6_8_I_warnHi, rebps_6_8_I_warnLo, rebps_6_8_I_limitHi, rebps_6_8_I_limitLo, rebps_9_12_I_warnHi, rebps_9_12_I_warnLo, rebps_9_12_I_limitHi, rebps_9_12_I_limitLo, rebps_Spr_I_warnHi, rebps_Spr_I_warnLo, rebps_Spr_I_limitHi, rebps_Spr_I_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_LimitsConfigurationEvent));
        Quadbox_BFR_LimitsConfigurationEvent item_ = (Quadbox_BFR_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)clean_5_24V_I_warnHi, (double)item_.getClean_5_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_warnLo, (double)item_.getClean_5_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitHi, (double)item_.getClean_5_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitLo, (double)item_.getClean_5_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnHi, (double)item_.getDirty_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnLo, (double)item_.getDirty_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitHi, (double)item_.getDirty_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitLo, (double)item_.getDirty_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnHi, (double)item_.getDirty_28V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnLo, (double)item_.getDirty_28V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitHi, (double)item_.getDirty_28V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitLo, (double)item_.getDirty_28V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnHi, (double)item_.getDirty_48V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnLo, (double)item_.getDirty_48V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitHi, (double)item_.getDirty_48V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitLo, (double)item_.getDirty_48V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnHi, (double)item_.getProtection_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnLo, (double)item_.getProtection_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitHi, (double)item_.getProtection_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitLo, (double)item_.getProtection_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_warnHi, (double)item_.getRebps_0_2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_warnLo, (double)item_.getRebps_0_2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_limitHi, (double)item_.getRebps_0_2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_limitLo, (double)item_.getRebps_0_2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_warnHi, (double)item_.getRebps_3_5_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_warnLo, (double)item_.getRebps_3_5_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_limitHi, (double)item_.getRebps_3_5_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_limitLo, (double)item_.getRebps_3_5_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_warnHi, (double)item_.getRebps_6_8_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_warnLo, (double)item_.getRebps_6_8_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_limitHi, (double)item_.getRebps_6_8_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_limitLo, (double)item_.getRebps_6_8_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_warnHi, (double)item_.getRebps_9_12_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_warnLo, (double)item_.getRebps_9_12_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_limitHi, (double)item_.getRebps_9_12_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_limitLo, (double)item_.getRebps_9_12_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_warnHi, (double)item_.getRebps_Spr_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_warnLo, (double)item_.getRebps_Spr_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_limitHi, (double)item_.getRebps_Spr_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_limitLo, (double)item_.getRebps_Spr_I_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFR_QuadboxConfigurationEvent() throws Exception {
        String version = "y";
        int node = 206;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_QuadboxConfigurationEvent));
        Quadbox_BFR_QuadboxConfigurationEvent item_ = (Quadbox_BFR_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_Maq20_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String node = "q";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_Maq20_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Quadbox_Maq20_DeviceConfigurationEvent));
        Quadbox_Maq20_DeviceConfigurationEvent item_ = (Quadbox_Maq20_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveQuadbox_Maq20_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_Maq20_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_Maq20_DevicesConfigurationEvent));
        Quadbox_Maq20_DevicesConfigurationEvent item_ = (Quadbox_Maq20_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_DevicesConfigurationEvent() throws Exception {
        String version = "e";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_DevicesConfigurationEvent));
        Quadbox_PDU_24VC_DevicesConfigurationEvent item_ = (Quadbox_PDU_24VC_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_LimitsConfigurationEvent() throws Exception {
        String version = "v";
        double board_T_warnHi = 0.17140984535217285;
        double board_T_warnLo = 0.2860983610153198;
        double board_T_limitHi = 0.2018665075302124;
        double board_T_limitLo = 0.8623965978622437;
        double body_Maq20_I_warnHi = 0.2078021764755249;
        double body_Maq20_I_warnLo = 0.027436554431915283;
        double body_Maq20_I_limitHi = 0.3213622570037842;
        double body_Maq20_I_limitLo = 0.8489788770675659;
        double body_Maq20_V_warnHi = 0.17418742179870605;
        double body_Maq20_V_warnLo = 0.08984065055847168;
        double body_Maq20_V_limitHi = 0.4241867661476135;
        double body_Maq20_V_limitLo = 0.9418308734893799;
        double cryo_Maq20_I_warnHi = 0.9684880375862122;
        double cryo_Maq20_I_warnLo = 0.9527187347412109;
        double cryo_Maq20_I_limitHi = 0.18455815315246582;
        double cryo_Maq20_I_limitLo = 0.6065274477005005;
        double cryo_Maq20_V_warnHi = 0.4981291890144348;
        double cryo_Maq20_V_warnLo = 0.8888053894042969;
        double cryo_Maq20_V_limitHi = 0.24716395139694214;
        double cryo_Maq20_V_limitLo = 0.18402493000030518;
        double fes_CarouselC_I_warnHi = 0.9244294762611389;
        double fes_CarouselC_I_warnLo = 0.7530982494354248;
        double fes_CarouselC_I_limitHi = 0.6354634165763855;
        double fes_CarouselC_I_limitLo = 0.11419862508773804;
        double fes_CarouselC_V_warnHi = 0.06763821840286255;
        double fes_CarouselC_V_warnLo = 0.15208107233047485;
        double fes_CarouselC_V_limitHi = 0.502015f;
        double fes_CarouselC_V_limitLo = 0.4687958359718323;
        double fes_ChangerC_I_warnHi = 0.2776569128036499;
        double fes_ChangerC_I_warnLo = 0.8017957806587219;
        double fes_ChangerC_I_limitHi = 0.646397590637207;
        double fes_ChangerC_I_limitLo = 0.11037266254425049;
        double fes_ChangerC_V_warnHi = 0.4113478f;
        double fes_ChangerC_V_warnLo = 0.2250347137451172;
        double fes_ChangerC_V_limitHi = 0.3065752387046814;
        double fes_ChangerC_V_limitLo = 0.4486308693885803;
        double fes_LoaderC_I_warnHi = 0.5043429136276245;
        double fes_LoaderC_I_warnLo = 0.11318850517272949;
        double fes_LoaderC_I_limitHi = 0.511311f;
        double fes_LoaderC_I_limitLo = 0.8501695990562439;
        double fes_LoaderC_V_warnHi = 0.10861527919769287;
        double fes_LoaderC_V_warnLo = 0.13340067863464355;
        double fes_LoaderC_V_limitHi = 0.909978985786438;
        double fes_LoaderC_V_limitLo = 0.632366418838501;
        double fpga_T_warnHi = 0.8650884032249451;
        double fpga_T_warnLo = 0.033549726009368896;
        double fpga_T_limitHi = 0.6954838037490845;
        double fpga_T_limitLo = 0.11287665367126465;
        double gauges_I_warnHi = 0.674673318862915;
        double gauges_I_warnLo = 0.06375402212142944;
        double gauges_I_limitHi = 0.5577300786972046;
        double gauges_I_limitLo = 0.0346936f;
        double gauges_V_warnHi = 0.25591927766799927;
        double gauges_V_warnLo = 0.861728f;
        double gauges_V_limitHi = 0.6790806651115417;
        double gauges_V_limitLo = 0.500071f;
        double int_Valves_I_warnHi = 0.0706256628036499;
        double int_Valves_I_warnLo = 0.5492081046104431;
        double int_Valves_I_limitHi = 0.5675011873245239;
        double int_Valves_I_limitLo = 0.2477231f;
        double int_Valves_V_warnHi = 0.6511227488517761;
        double int_Valves_V_warnLo = 0.25721925497055054;
        double int_Valves_V_limitHi = 0.053745925426483154;
        double int_Valves_V_limitLo = 0.13506555557250977;
        double ion_Pumps_I_warnHi = 0.5684199333190918;
        double ion_Pumps_I_warnLo = 0.1792144775390625;
        double ion_Pumps_I_limitHi = 0.420258f;
        double ion_Pumps_I_limitLo = 0.24494272470474243;
        double ion_Pumps_V_warnHi = 0.3861231803894043;
        double ion_Pumps_V_warnLo = 0.47374796867370605;
        double ion_Pumps_V_limitHi = 0.32380956411361694;
        double ion_Pumps_V_limitLo = 0.34402942657470703;
        double main_I_warnHi = 0.40112733840942383;
        double main_I_warnLo = 0.4736320972442627;
        double main_I_limitHi = 0.6918114423751831;
        double main_I_limitLo = 0.963251531124115;
        double main_T_warnHi = 0.18191653490066528;
        double main_T_warnLo = 0.16838771104812622;
        double main_T_limitHi = 0.9623038172721863;
        double main_T_limitLo = 0.15011334419250488;
        double main_V_warnHi = 0.48530107736587524;
        double main_V_warnLo = 0.4137721657752991;
        double main_V_limitHi = 0.0766598f;
        double main_V_limitLo = 0.7253578305244446;
        double shtr_PLC1_I_warnHi = 0.1221545934677124;
        double shtr_PLC1_I_warnLo = 0.779416024684906;
        double shtr_PLC1_I_limitHi = 0.2768756151199341;
        double shtr_PLC1_I_limitLo = 0.4441349506378174;
        double shtr_PLC1_V_warnHi = 0.5148841738700867;
        double shtr_PLC1_V_warnLo = 0.00691455602645874;
        double shtr_PLC1_V_limitHi = 0.5889905095100403;
        double shtr_PLC1_V_limitLo = 0.862678587436676;
        double shtr_PLC2_I_warnHi = 0.759788f;
        double shtr_PLC2_I_warnLo = 0.24051225185394287;
        double shtr_PLC2_I_limitHi = 0.5518115162849426;
        double shtr_PLC2_I_limitLo = 0.5088573098182678;
        double shtr_PLC2_V_warnHi = 0.8950796723365784;
        double shtr_PLC2_V_warnLo = 0.17582905292510986;
        double shtr_PLC2_V_limitHi = 0.26496803760528564;
        double shtr_PLC2_V_limitLo = 0.4779793620109558;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_LimitsConfigurationEvent(version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, body_Maq20_I_warnHi, body_Maq20_I_warnLo, body_Maq20_I_limitHi, body_Maq20_I_limitLo, body_Maq20_V_warnHi, body_Maq20_V_warnLo, body_Maq20_V_limitHi, body_Maq20_V_limitLo, cryo_Maq20_I_warnHi, cryo_Maq20_I_warnLo, cryo_Maq20_I_limitHi, cryo_Maq20_I_limitLo, cryo_Maq20_V_warnHi, cryo_Maq20_V_warnLo, cryo_Maq20_V_limitHi, cryo_Maq20_V_limitLo, fes_CarouselC_I_warnHi, fes_CarouselC_I_warnLo, fes_CarouselC_I_limitHi, fes_CarouselC_I_limitLo, fes_CarouselC_V_warnHi, fes_CarouselC_V_warnLo, fes_CarouselC_V_limitHi, fes_CarouselC_V_limitLo, fes_ChangerC_I_warnHi, fes_ChangerC_I_warnLo, fes_ChangerC_I_limitHi, fes_ChangerC_I_limitLo, fes_ChangerC_V_warnHi, fes_ChangerC_V_warnLo, fes_ChangerC_V_limitHi, fes_ChangerC_V_limitLo, fes_LoaderC_I_warnHi, fes_LoaderC_I_warnLo, fes_LoaderC_I_limitHi, fes_LoaderC_I_limitLo, fes_LoaderC_V_warnHi, fes_LoaderC_V_warnLo, fes_LoaderC_V_limitHi, fes_LoaderC_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, gauges_I_warnHi, gauges_I_warnLo, gauges_I_limitHi, gauges_I_limitLo, gauges_V_warnHi, gauges_V_warnLo, gauges_V_limitHi, gauges_V_limitLo, int_Valves_I_warnHi, int_Valves_I_warnLo, int_Valves_I_limitHi, int_Valves_I_limitLo, int_Valves_V_warnHi, int_Valves_V_warnLo, int_Valves_V_limitHi, int_Valves_V_limitLo, ion_Pumps_I_warnHi, ion_Pumps_I_warnLo, ion_Pumps_I_limitHi, ion_Pumps_I_limitLo, ion_Pumps_V_warnHi, ion_Pumps_V_warnLo, ion_Pumps_V_limitHi, ion_Pumps_V_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo, shtr_PLC1_I_warnHi, shtr_PLC1_I_warnLo, shtr_PLC1_I_limitHi, shtr_PLC1_I_limitLo, shtr_PLC1_V_warnHi, shtr_PLC1_V_warnLo, shtr_PLC1_V_limitHi, shtr_PLC1_V_limitLo, shtr_PLC2_I_warnHi, shtr_PLC2_I_warnLo, shtr_PLC2_I_limitHi, shtr_PLC2_I_limitLo, shtr_PLC2_V_warnHi, shtr_PLC2_V_warnLo, shtr_PLC2_V_limitHi, shtr_PLC2_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_LimitsConfigurationEvent));
        Quadbox_PDU_24VC_LimitsConfigurationEvent item_ = (Quadbox_PDU_24VC_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I_warnHi, (double)item_.getBody_Maq20_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I_warnLo, (double)item_.getBody_Maq20_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I_limitHi, (double)item_.getBody_Maq20_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I_limitLo, (double)item_.getBody_Maq20_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V_warnHi, (double)item_.getBody_Maq20_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V_warnLo, (double)item_.getBody_Maq20_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V_limitHi, (double)item_.getBody_Maq20_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V_limitLo, (double)item_.getBody_Maq20_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I_warnHi, (double)item_.getCryo_Maq20_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I_warnLo, (double)item_.getCryo_Maq20_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I_limitHi, (double)item_.getCryo_Maq20_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I_limitLo, (double)item_.getCryo_Maq20_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V_warnHi, (double)item_.getCryo_Maq20_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V_warnLo, (double)item_.getCryo_Maq20_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V_limitHi, (double)item_.getCryo_Maq20_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V_limitLo, (double)item_.getCryo_Maq20_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I_warnHi, (double)item_.getFes_CarouselC_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I_warnLo, (double)item_.getFes_CarouselC_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I_limitHi, (double)item_.getFes_CarouselC_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I_limitLo, (double)item_.getFes_CarouselC_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V_warnHi, (double)item_.getFes_CarouselC_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V_warnLo, (double)item_.getFes_CarouselC_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V_limitHi, (double)item_.getFes_CarouselC_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V_limitLo, (double)item_.getFes_CarouselC_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I_warnHi, (double)item_.getFes_ChangerC_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I_warnLo, (double)item_.getFes_ChangerC_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I_limitHi, (double)item_.getFes_ChangerC_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I_limitLo, (double)item_.getFes_ChangerC_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V_warnHi, (double)item_.getFes_ChangerC_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V_warnLo, (double)item_.getFes_ChangerC_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V_limitHi, (double)item_.getFes_ChangerC_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V_limitLo, (double)item_.getFes_ChangerC_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I_warnHi, (double)item_.getFes_LoaderC_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I_warnLo, (double)item_.getFes_LoaderC_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I_limitHi, (double)item_.getFes_LoaderC_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I_limitLo, (double)item_.getFes_LoaderC_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V_warnHi, (double)item_.getFes_LoaderC_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V_warnLo, (double)item_.getFes_LoaderC_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V_limitHi, (double)item_.getFes_LoaderC_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V_limitLo, (double)item_.getFes_LoaderC_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnHi, (double)item_.getGauges_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnLo, (double)item_.getGauges_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitHi, (double)item_.getGauges_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitLo, (double)item_.getGauges_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnHi, (double)item_.getGauges_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnLo, (double)item_.getGauges_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitHi, (double)item_.getGauges_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitLo, (double)item_.getGauges_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I_warnHi, (double)item_.getInt_Valves_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I_warnLo, (double)item_.getInt_Valves_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I_limitHi, (double)item_.getInt_Valves_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I_limitLo, (double)item_.getInt_Valves_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V_warnHi, (double)item_.getInt_Valves_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V_warnLo, (double)item_.getInt_Valves_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V_limitHi, (double)item_.getInt_Valves_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V_limitLo, (double)item_.getInt_Valves_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnHi, (double)item_.getIon_Pumps_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnLo, (double)item_.getIon_Pumps_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitHi, (double)item_.getIon_Pumps_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitLo, (double)item_.getIon_Pumps_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnHi, (double)item_.getIon_Pumps_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnLo, (double)item_.getIon_Pumps_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitHi, (double)item_.getIon_Pumps_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitLo, (double)item_.getIon_Pumps_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I_warnHi, (double)item_.getShtr_PLC1_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I_warnLo, (double)item_.getShtr_PLC1_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I_limitHi, (double)item_.getShtr_PLC1_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I_limitLo, (double)item_.getShtr_PLC1_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V_warnHi, (double)item_.getShtr_PLC1_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V_warnLo, (double)item_.getShtr_PLC1_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V_limitHi, (double)item_.getShtr_PLC1_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V_limitLo, (double)item_.getShtr_PLC1_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I_warnHi, (double)item_.getShtr_PLC2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I_warnLo, (double)item_.getShtr_PLC2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I_limitHi, (double)item_.getShtr_PLC2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I_limitLo, (double)item_.getShtr_PLC2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V_warnHi, (double)item_.getShtr_PLC2_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V_warnLo, (double)item_.getShtr_PLC2_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V_limitHi, (double)item_.getShtr_PLC2_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V_limitLo, (double)item_.getShtr_PLC2_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_QuadboxConfigurationEvent() throws Exception {
        String version = "";
        int node = 330;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_QuadboxConfigurationEvent));
        Quadbox_PDU_24VC_QuadboxConfigurationEvent item_ = (Quadbox_PDU_24VC_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_DevicesConfigurationEvent() throws Exception {
        String version = "o";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_DevicesConfigurationEvent));
        Quadbox_PDU_24VD_DevicesConfigurationEvent item_ = (Quadbox_PDU_24VD_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double board_T_warnHi = 0.3359434f;
        double board_T_warnLo = 0.147347092628479;
        double board_T_limitHi = 0.9024807214736938;
        double board_T_limitLo = 0.9873150587081909;
        double cryo_Turbo_I_warnHi = 0.7804882526397705;
        double cryo_Turbo_I_warnLo = 0.21205365657806396;
        double cryo_Turbo_I_limitHi = 0.19770705699920654;
        double cryo_Turbo_I_limitLo = 0.0017998814582824707;
        double cryo_Turbo_V_warnHi = 0.893978476524353;
        double cryo_Turbo_V_warnLo = 0.5026865005493164;
        double cryo_Turbo_V_limitHi = 0.2176659107208252;
        double cryo_Turbo_V_limitLo = 0.6090694069862366;
        double fes_Brakes_I_warnHi = 0.9734766483306885;
        double fes_Brakes_I_warnLo = 0.8928537964820862;
        double fes_Brakes_I_limitHi = 0.0497211217880249;
        double fes_Brakes_I_limitLo = 0.2681116461753845;
        double fes_Brakes_V_warnHi = 0.529084324836731;
        double fes_Brakes_V_warnLo = 0.05878615379333496;
        double fes_Brakes_V_limitHi = 0.5883772969245911;
        double fes_Brakes_V_limitLo = 0.6124424338340759;
        double fes_ChangerD_I_warnHi = 0.928119f;
        double fes_ChangerD_I_warnLo = 0.25203055143356323;
        double fes_ChangerD_I_limitHi = 0.23448187112808228;
        double fes_ChangerD_I_limitLo = 0.06101113557815552;
        double fes_ChangerD_V_warnHi = 0.2818338871002197;
        double fes_ChangerD_V_warnLo = 0.35309863090515137;
        double fes_ChangerD_V_limitHi = 0.937881f;
        double fes_ChangerD_V_limitLo = 0.7643618583679199;
        double fes_Clamps_I_warnHi = 0.35663992166519165;
        double fes_Clamps_I_warnLo = 0.7248210906982422;
        double fes_Clamps_I_limitHi = 0.00886458158493042;
        double fes_Clamps_I_limitLo = 0.8635683059692383;
        double fes_Clamps_V_warnHi = 0.525514f;
        double fes_Clamps_V_warnLo = 0.4517327547073364;
        double fes_Clamps_V_limitHi = 0.9946938753128052;
        double fes_Clamps_V_limitLo = 0.11279827356338501;
        double fes_LoaderD_I_warnHi = 0.8843053579330444;
        double fes_LoaderD_I_warnLo = 0.9963942170143127;
        double fes_LoaderD_I_limitHi = 0.4767602f;
        double fes_LoaderD_I_limitLo = 0.7324386835098267;
        double fes_LoaderD_V_warnHi = 0.0687408447265625;
        double fes_LoaderD_V_warnLo = 0.14175671339035034;
        double fes_LoaderD_V_limitHi = 0.2010408f;
        double fes_LoaderD_V_limitLo = 0.16168522834777832;
        double fpga_T_warnHi = 0.02596902847290039;
        double fpga_T_warnLo = 0.35271936655044556;
        double fpga_T_limitHi = 0.522193193435669;
        double fpga_T_limitLo = 0.05116891860961914;
        double hex_Turbo_I_warnHi = 0.8524715900421143;
        double hex_Turbo_I_warnLo = 0.677761971950531;
        double hex_Turbo_I_limitHi = 0.6856864094734192;
        double hex_Turbo_I_limitLo = 0.15195822715759277;
        double hex_Turbo_V_warnHi = 0.7192482352256775;
        double hex_Turbo_V_warnLo = 0.8364443778991699;
        double hex_Turbo_V_limitHi = 0.161748468875885;
        double hex_Turbo_V_limitLo = 0.6321895122528076;
        double main_I_warnHi = 0.10460102558135986;
        double main_I_warnLo = 0.7797408103942871;
        double main_I_limitHi = 0.7016832828521729;
        double main_I_limitLo = 0.0922970175743103;
        double main_T_warnHi = 0.8619933128356934;
        double main_T_warnLo = 0.3623538017272949;
        double main_T_limitHi = 0.33647865056991577;
        double main_T_limitLo = 0.10063028335571289;
        double main_V_warnHi = 0.710841f;
        double main_V_warnLo = 0.6896804571151733;
        double main_V_limitHi = 0.4579014182090759;
        double main_V_limitLo = 0.2700703740119934;
        double shtr_Brakes_I_warnHi = 0.27534347772598267;
        double shtr_Brakes_I_warnLo = 0.5729556679725647;
        double shtr_Brakes_I_limitHi = 0.8949098587036133;
        double shtr_Brakes_I_limitLo = 0.7206348180770874;
        double shtr_Brakes_V_warnHi = 0.8623384237289429;
        double shtr_Brakes_V_warnLo = 0.4858793616294861;
        double shtr_Brakes_V_limitHi = 0.45777201652526855;
        double shtr_Brakes_V_limitLo = 0.5911467671394348;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_LimitsConfigurationEvent(version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, cryo_Turbo_I_warnHi, cryo_Turbo_I_warnLo, cryo_Turbo_I_limitHi, cryo_Turbo_I_limitLo, cryo_Turbo_V_warnHi, cryo_Turbo_V_warnLo, cryo_Turbo_V_limitHi, cryo_Turbo_V_limitLo, fes_Brakes_I_warnHi, fes_Brakes_I_warnLo, fes_Brakes_I_limitHi, fes_Brakes_I_limitLo, fes_Brakes_V_warnHi, fes_Brakes_V_warnLo, fes_Brakes_V_limitHi, fes_Brakes_V_limitLo, fes_ChangerD_I_warnHi, fes_ChangerD_I_warnLo, fes_ChangerD_I_limitHi, fes_ChangerD_I_limitLo, fes_ChangerD_V_warnHi, fes_ChangerD_V_warnLo, fes_ChangerD_V_limitHi, fes_ChangerD_V_limitLo, fes_Clamps_I_warnHi, fes_Clamps_I_warnLo, fes_Clamps_I_limitHi, fes_Clamps_I_limitLo, fes_Clamps_V_warnHi, fes_Clamps_V_warnLo, fes_Clamps_V_limitHi, fes_Clamps_V_limitLo, fes_LoaderD_I_warnHi, fes_LoaderD_I_warnLo, fes_LoaderD_I_limitHi, fes_LoaderD_I_limitLo, fes_LoaderD_V_warnHi, fes_LoaderD_V_warnLo, fes_LoaderD_V_limitHi, fes_LoaderD_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, hex_Turbo_I_warnHi, hex_Turbo_I_warnLo, hex_Turbo_I_limitHi, hex_Turbo_I_limitLo, hex_Turbo_V_warnHi, hex_Turbo_V_warnLo, hex_Turbo_V_limitHi, hex_Turbo_V_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo, shtr_Brakes_I_warnHi, shtr_Brakes_I_warnLo, shtr_Brakes_I_limitHi, shtr_Brakes_I_limitLo, shtr_Brakes_V_warnHi, shtr_Brakes_V_warnLo, shtr_Brakes_V_limitHi, shtr_Brakes_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_LimitsConfigurationEvent));
        Quadbox_PDU_24VD_LimitsConfigurationEvent item_ = (Quadbox_PDU_24VD_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_warnHi, (double)item_.getCryo_Turbo_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_warnLo, (double)item_.getCryo_Turbo_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_limitHi, (double)item_.getCryo_Turbo_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_limitLo, (double)item_.getCryo_Turbo_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_warnHi, (double)item_.getCryo_Turbo_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_warnLo, (double)item_.getCryo_Turbo_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_limitHi, (double)item_.getCryo_Turbo_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_limitLo, (double)item_.getCryo_Turbo_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I_warnHi, (double)item_.getFes_Brakes_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I_warnLo, (double)item_.getFes_Brakes_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I_limitHi, (double)item_.getFes_Brakes_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I_limitLo, (double)item_.getFes_Brakes_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V_warnHi, (double)item_.getFes_Brakes_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V_warnLo, (double)item_.getFes_Brakes_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V_limitHi, (double)item_.getFes_Brakes_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V_limitLo, (double)item_.getFes_Brakes_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I_warnHi, (double)item_.getFes_ChangerD_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I_warnLo, (double)item_.getFes_ChangerD_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I_limitHi, (double)item_.getFes_ChangerD_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I_limitLo, (double)item_.getFes_ChangerD_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V_warnHi, (double)item_.getFes_ChangerD_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V_warnLo, (double)item_.getFes_ChangerD_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V_limitHi, (double)item_.getFes_ChangerD_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V_limitLo, (double)item_.getFes_ChangerD_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I_warnHi, (double)item_.getFes_Clamps_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I_warnLo, (double)item_.getFes_Clamps_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I_limitHi, (double)item_.getFes_Clamps_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I_limitLo, (double)item_.getFes_Clamps_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V_warnHi, (double)item_.getFes_Clamps_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V_warnLo, (double)item_.getFes_Clamps_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V_limitHi, (double)item_.getFes_Clamps_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V_limitLo, (double)item_.getFes_Clamps_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I_warnHi, (double)item_.getFes_LoaderD_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I_warnLo, (double)item_.getFes_LoaderD_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I_limitHi, (double)item_.getFes_LoaderD_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I_limitLo, (double)item_.getFes_LoaderD_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V_warnHi, (double)item_.getFes_LoaderD_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V_warnLo, (double)item_.getFes_LoaderD_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V_limitHi, (double)item_.getFes_LoaderD_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V_limitLo, (double)item_.getFes_LoaderD_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_warnHi, (double)item_.getHex_Turbo_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_warnLo, (double)item_.getHex_Turbo_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_limitHi, (double)item_.getHex_Turbo_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_limitLo, (double)item_.getHex_Turbo_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_warnHi, (double)item_.getHex_Turbo_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_warnLo, (double)item_.getHex_Turbo_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_limitHi, (double)item_.getHex_Turbo_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_limitLo, (double)item_.getHex_Turbo_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I_warnHi, (double)item_.getShtr_Brakes_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I_warnLo, (double)item_.getShtr_Brakes_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I_limitHi, (double)item_.getShtr_Brakes_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I_limitLo, (double)item_.getShtr_Brakes_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V_warnHi, (double)item_.getShtr_Brakes_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V_warnLo, (double)item_.getShtr_Brakes_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V_limitHi, (double)item_.getShtr_Brakes_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V_limitLo, (double)item_.getShtr_Brakes_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_QuadboxConfigurationEvent() throws Exception {
        String version = "";
        int node = 839;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_QuadboxConfigurationEvent));
        Quadbox_PDU_24VD_QuadboxConfigurationEvent item_ = (Quadbox_PDU_24VD_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_DevicesConfigurationEvent));
        Quadbox_PDU_48V_DevicesConfigurationEvent item_ = (Quadbox_PDU_48V_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_LimitsConfigurationEvent() throws Exception {
        String version = "g";
        double board_T_warnHi = 0.29950016736984253;
        double board_T_warnLo = 0.24664908647537231;
        double board_T_limitHi = 0.767871618270874;
        double board_T_limitLo = 0.2619808316230774;
        double fes_CarouselD_I_warnHi = 0.48851585388183594;
        double fes_CarouselD_I_warnLo = 0.3681f;
        double fes_CarouselD_I_limitHi = 0.177703857421875;
        double fes_CarouselD_I_limitLo = 0.8507076501846313;
        double fes_CarouselD_V_warnHi = 0.3890703320503235;
        double fes_CarouselD_V_warnLo = 0.8853934407234192;
        double fes_CarouselD_V_limitHi = 0.16424894332885742;
        double fes_CarouselD_V_limitLo = 0.582197368144989;
        double fes_Heater_I_warnHi = 0.5306582450866699;
        double fes_Heater_I_warnLo = 0.2015218734741211;
        double fes_Heater_I_limitHi = 0.5292513370513916;
        double fes_Heater_I_limitLo = 0.5915347337722778;
        double fes_Heater_V_warnHi = 0.17069f;
        double fes_Heater_V_warnLo = 0.6826686859130859;
        double fes_Heater_V_limitHi = 0.6330636143684387;
        double fes_Heater_V_limitLo = 0.49333226680755615;
        double fpga_T_warnHi = 0.05587393045425415;
        double fpga_T_warnLo = 0.5080180764198303;
        double fpga_T_limitHi = 0.3663373f;
        double fpga_T_limitLo = 0.9903306365013123;
        double main_I_warnHi = 0.28888654708862305;
        double main_I_warnLo = 0.43917596340179443;
        double main_I_limitHi = 0.4342119097709656;
        double main_I_limitLo = 0.5887249112129211;
        double main_T_warnHi = 0.47140854597091675;
        double main_T_warnLo = 0.10862231254577637;
        double main_T_limitHi = 0.3732417821884155;
        double main_T_limitLo = 0.376612f;
        double main_V_warnHi = 0.562292f;
        double main_V_warnLo = 0.11836177110671997;
        double main_V_limitHi = 0.11182254552841187;
        double main_V_limitLo = 0.32439786195755005;
        double purge_Fan_I_warnHi = 0.630763053894043;
        double purge_Fan_I_warnLo = 0.2564527988433838;
        double purge_Fan_I_limitHi = 0.018869996070861816;
        double purge_Fan_I_limitLo = 0.5753469467163086;
        double purge_Fan_V_warnHi = 0.7712225317955017;
        double purge_Fan_V_warnLo = 0.03604203462600708;
        double purge_Fan_V_limitHi = 0.3303477168083191;
        double purge_Fan_V_limitLo = 0.5554215312004089;
        double shtr_Motor1_I_warnHi = 0.4535815119743347;
        double shtr_Motor1_I_warnLo = 0.7351964116096497;
        double shtr_Motor1_I_limitHi = 0.49444258213043213;
        double shtr_Motor1_I_limitLo = 0.5544989109039307;
        double shtr_Motor1_V_warnHi = 0.03947758674621582;
        double shtr_Motor1_V_warnLo = 0.2531300187110901;
        double shtr_Motor1_V_limitHi = 0.307384f;
        double shtr_Motor1_V_limitLo = 0.3419477939605713;
        double shtr_Motor2_I_warnHi = 0.8316075205802917;
        double shtr_Motor2_I_warnLo = 0.6268974542617798;
        double shtr_Motor2_I_limitHi = 0.02484762668609619;
        double shtr_Motor2_I_limitLo = 0.7699902057647705;
        double shtr_Motor2_V_warnHi = 0.025355935096740723;
        double shtr_Motor2_V_warnLo = 0.590442f;
        double shtr_Motor2_V_limitHi = 0.808464765548706;
        double shtr_Motor2_V_limitLo = 0.5955008864402771;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_LimitsConfigurationEvent(version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, fes_CarouselD_I_warnHi, fes_CarouselD_I_warnLo, fes_CarouselD_I_limitHi, fes_CarouselD_I_limitLo, fes_CarouselD_V_warnHi, fes_CarouselD_V_warnLo, fes_CarouselD_V_limitHi, fes_CarouselD_V_limitLo, fes_Heater_I_warnHi, fes_Heater_I_warnLo, fes_Heater_I_limitHi, fes_Heater_I_limitLo, fes_Heater_V_warnHi, fes_Heater_V_warnLo, fes_Heater_V_limitHi, fes_Heater_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo, purge_Fan_I_warnHi, purge_Fan_I_warnLo, purge_Fan_I_limitHi, purge_Fan_I_limitLo, purge_Fan_V_warnHi, purge_Fan_V_warnLo, purge_Fan_V_limitHi, purge_Fan_V_limitLo, shtr_Motor1_I_warnHi, shtr_Motor1_I_warnLo, shtr_Motor1_I_limitHi, shtr_Motor1_I_limitLo, shtr_Motor1_V_warnHi, shtr_Motor1_V_warnLo, shtr_Motor1_V_limitHi, shtr_Motor1_V_limitLo, shtr_Motor2_I_warnHi, shtr_Motor2_I_warnLo, shtr_Motor2_I_limitHi, shtr_Motor2_I_limitLo, shtr_Motor2_V_warnHi, shtr_Motor2_V_warnLo, shtr_Motor2_V_limitHi, shtr_Motor2_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_LimitsConfigurationEvent));
        Quadbox_PDU_48V_LimitsConfigurationEvent item_ = (Quadbox_PDU_48V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I_warnHi, (double)item_.getFes_CarouselD_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I_warnLo, (double)item_.getFes_CarouselD_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I_limitHi, (double)item_.getFes_CarouselD_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I_limitLo, (double)item_.getFes_CarouselD_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V_warnHi, (double)item_.getFes_CarouselD_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V_warnLo, (double)item_.getFes_CarouselD_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V_limitHi, (double)item_.getFes_CarouselD_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V_limitLo, (double)item_.getFes_CarouselD_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I_warnHi, (double)item_.getFes_Heater_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I_warnLo, (double)item_.getFes_Heater_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I_limitHi, (double)item_.getFes_Heater_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I_limitLo, (double)item_.getFes_Heater_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V_warnHi, (double)item_.getFes_Heater_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V_warnLo, (double)item_.getFes_Heater_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V_limitHi, (double)item_.getFes_Heater_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V_limitLo, (double)item_.getFes_Heater_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_warnHi, (double)item_.getPurge_Fan_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_warnLo, (double)item_.getPurge_Fan_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_limitHi, (double)item_.getPurge_Fan_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_limitLo, (double)item_.getPurge_Fan_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_warnHi, (double)item_.getPurge_Fan_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_warnLo, (double)item_.getPurge_Fan_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_limitHi, (double)item_.getPurge_Fan_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_limitLo, (double)item_.getPurge_Fan_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I_warnHi, (double)item_.getShtr_Motor1_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I_warnLo, (double)item_.getShtr_Motor1_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I_limitHi, (double)item_.getShtr_Motor1_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I_limitLo, (double)item_.getShtr_Motor1_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V_warnHi, (double)item_.getShtr_Motor1_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V_warnLo, (double)item_.getShtr_Motor1_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V_limitHi, (double)item_.getShtr_Motor1_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V_limitLo, (double)item_.getShtr_Motor1_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I_warnHi, (double)item_.getShtr_Motor2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I_warnLo, (double)item_.getShtr_Motor2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I_limitHi, (double)item_.getShtr_Motor2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I_limitLo, (double)item_.getShtr_Motor2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V_warnHi, (double)item_.getShtr_Motor2_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V_warnLo, (double)item_.getShtr_Motor2_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V_limitHi, (double)item_.getShtr_Motor2_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V_limitLo, (double)item_.getShtr_Motor2_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_QuadboxConfigurationEvent() throws Exception {
        String version = "";
        int node = 973;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_QuadboxConfigurationEvent));
        Quadbox_PDU_48V_QuadboxConfigurationEvent item_ = (Quadbox_PDU_48V_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_DevicesConfigurationEvent() throws Exception {
        String version = "n";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_DevicesConfigurationEvent));
        Quadbox_PDU_5V_DevicesConfigurationEvent item_ = (Quadbox_PDU_5V_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double otm_0_A_I_warnHi = 0.705195426940918;
        double otm_0_A_I_warnLo = 0.5745881199836731;
        double otm_0_A_I_limitHi = 0.3399214f;
        double otm_0_A_I_limitLo = 0.2192559838294983;
        double otm_0_A_V_warnHi = 0.6262549161911011;
        double otm_0_A_V_warnLo = 0.3666437268257141;
        double otm_0_A_V_limitHi = 0.45988816022872925;
        double otm_0_A_V_limitLo = 0.6296939253807068;
        double otm_0_B_I_warnHi = 0.040489912033081055;
        double otm_0_B_I_warnLo = 0.45842164754867554;
        double otm_0_B_I_limitHi = 0.8041380643844604;
        double otm_0_B_I_limitLo = 0.963213324546814;
        double otm_0_B_V_warnHi = 0.4553758502006531;
        double otm_0_B_V_warnLo = 0.2713279128074646;
        double otm_0_B_V_limitHi = 0.947884738445282;
        double otm_0_B_V_limitLo = 0.0288409f;
        double otm_1_A_I_warnHi = 0.39329564571380615;
        double otm_1_A_I_warnLo = 0.22851771116256714;
        double otm_1_A_I_limitHi = 0.21255344152450562;
        double otm_1_A_I_limitLo = 0.011912405490875244;
        double otm_1_A_V_warnHi = 0.5514242649078369;
        double otm_1_A_V_warnLo = 0.6508852243423462;
        double otm_1_A_V_limitHi = 0.568288266658783;
        double otm_1_A_V_limitLo = 0.637826144695282;
        double otm_1_B_I_warnHi = 0.09007900953292847;
        double otm_1_B_I_warnLo = 0.8701666593551636;
        double otm_1_B_I_limitHi = 0.36637115478515625;
        double otm_1_B_I_limitLo = 0.03323858976364136;
        double otm_1_B_V_warnHi = 0.8563101887702942;
        double otm_1_B_V_warnLo = 0.8666839003562927;
        double otm_1_B_V_limitHi = 0.45781224966049194;
        double otm_1_B_V_limitLo = 0.3513185381889343;
        double otm_2_A_I_warnHi = 0.4714767336845398;
        double otm_2_A_I_warnLo = 0.46924442052841187;
        double otm_2_A_I_limitHi = 0.2972654700279236;
        double otm_2_A_I_limitLo = 0.6357949376106262;
        double otm_2_A_V_warnHi = 0.5301083922386169;
        double otm_2_A_V_warnLo = 0.7822174429893494;
        double otm_2_A_V_limitHi = 0.5979655385017395;
        double otm_2_A_V_limitLo = 0.7027034163475037;
        double otm_2_B_I_warnHi = 0.9898995161056519;
        double otm_2_B_I_warnLo = 0.12456047534942627;
        double otm_2_B_I_limitHi = 0.8187646269798279;
        double otm_2_B_I_limitLo = 0.4652571678161621;
        double otm_2_B_V_warnHi = 0.3246997594833374;
        double otm_2_B_V_warnLo = 0.7379271984100342;
        double otm_2_B_V_limitHi = 0.006887316703796387;
        double otm_2_B_V_limitLo = 0.4530452489852905;
        double otm_3_A_I_warnHi = 0.3875085115432739;
        double otm_3_A_I_warnLo = 0.721917450428009;
        double otm_3_A_I_limitHi = 0.27117353677749634;
        double otm_3_A_I_limitLo = 0.7593408823013306;
        double otm_3_A_V_warnHi = 0.7404987812042236;
        double otm_3_A_V_warnLo = 0.7256408929824829;
        double otm_3_A_V_limitHi = 0.854900598526001;
        double otm_3_A_V_limitLo = 0.157843f;
        double otm_3_B_I_warnHi = 0.583867609500885;
        double otm_3_B_I_warnLo = 0.5232800841331482;
        double otm_3_B_I_limitHi = 0.5524739623069763;
        double otm_3_B_I_limitLo = 0.17146915197372437;
        double otm_3_B_V_warnHi = 0.312854528427124;
        double otm_3_B_V_warnLo = 0.6501095294952393;
        double otm_3_B_V_limitHi = 0.161163330078125;
        double otm_3_B_V_limitLo = 0.8502786159515381;
        double otm_4_A_I_warnHi = 0.1887073516845703;
        double otm_4_A_I_warnLo = 0.21293115615844727;
        double otm_4_A_I_limitHi = 0.07158505916595459;
        double otm_4_A_I_limitLo = 0.4632687568664551;
        double otm_4_A_V_warnHi = 0.9889718294143677;
        double otm_4_A_V_warnLo = 0.019225597381591797;
        double otm_4_A_V_limitHi = 0.7258667349815369;
        double otm_4_A_V_limitLo = 0.16032713651657104;
        double otm_4_B_I_warnHi = 0.747619f;
        double otm_4_B_I_warnLo = 0.5122162699699402;
        double otm_4_B_I_limitHi = 0.9605627059936523;
        double otm_4_B_I_limitLo = 0.487312376499176;
        double otm_4_B_V_warnHi = 0.576705813407898;
        double otm_4_B_V_warnLo = 0.13985759019851685;
        double otm_4_B_V_limitHi = 0.6057502627372742;
        double otm_4_B_V_limitLo = 0.9010071754455566;
        double otm_5_A_I_warnHi = 0.9271302223205566;
        double otm_5_A_I_warnLo = 0.7254574298858643;
        double otm_5_A_I_limitHi = 0.7387614846229553;
        double otm_5_A_I_limitLo = 0.7340636253356934;
        double otm_5_A_V_warnHi = 0.6733422875404358;
        double otm_5_A_V_warnLo = 0.912837028503418;
        double otm_5_A_V_limitHi = 0.7502734661102295;
        double otm_5_A_V_limitLo = 0.3962177038192749;
        double otm_5_B_I_warnHi = 0.8504967093467712;
        double otm_5_B_I_warnLo = 0.6118409037590027;
        double otm_5_B_I_limitHi = 0.6346777081489563;
        double otm_5_B_I_limitLo = 0.6007689237594604;
        double otm_5_B_V_warnHi = 0.3154820203781128;
        double otm_5_B_V_warnLo = 0.6184857487678528;
        double otm_5_B_V_limitHi = 0.3816053867340088;
        double otm_5_B_V_limitLo = 0.5990188121795654;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_LimitsConfigurationEvent(version, otm_0_A_I_warnHi, otm_0_A_I_warnLo, otm_0_A_I_limitHi, otm_0_A_I_limitLo, otm_0_A_V_warnHi, otm_0_A_V_warnLo, otm_0_A_V_limitHi, otm_0_A_V_limitLo, otm_0_B_I_warnHi, otm_0_B_I_warnLo, otm_0_B_I_limitHi, otm_0_B_I_limitLo, otm_0_B_V_warnHi, otm_0_B_V_warnLo, otm_0_B_V_limitHi, otm_0_B_V_limitLo, otm_1_A_I_warnHi, otm_1_A_I_warnLo, otm_1_A_I_limitHi, otm_1_A_I_limitLo, otm_1_A_V_warnHi, otm_1_A_V_warnLo, otm_1_A_V_limitHi, otm_1_A_V_limitLo, otm_1_B_I_warnHi, otm_1_B_I_warnLo, otm_1_B_I_limitHi, otm_1_B_I_limitLo, otm_1_B_V_warnHi, otm_1_B_V_warnLo, otm_1_B_V_limitHi, otm_1_B_V_limitLo, otm_2_A_I_warnHi, otm_2_A_I_warnLo, otm_2_A_I_limitHi, otm_2_A_I_limitLo, otm_2_A_V_warnHi, otm_2_A_V_warnLo, otm_2_A_V_limitHi, otm_2_A_V_limitLo, otm_2_B_I_warnHi, otm_2_B_I_warnLo, otm_2_B_I_limitHi, otm_2_B_I_limitLo, otm_2_B_V_warnHi, otm_2_B_V_warnLo, otm_2_B_V_limitHi, otm_2_B_V_limitLo, otm_3_A_I_warnHi, otm_3_A_I_warnLo, otm_3_A_I_limitHi, otm_3_A_I_limitLo, otm_3_A_V_warnHi, otm_3_A_V_warnLo, otm_3_A_V_limitHi, otm_3_A_V_limitLo, otm_3_B_I_warnHi, otm_3_B_I_warnLo, otm_3_B_I_limitHi, otm_3_B_I_limitLo, otm_3_B_V_warnHi, otm_3_B_V_warnLo, otm_3_B_V_limitHi, otm_3_B_V_limitLo, otm_4_A_I_warnHi, otm_4_A_I_warnLo, otm_4_A_I_limitHi, otm_4_A_I_limitLo, otm_4_A_V_warnHi, otm_4_A_V_warnLo, otm_4_A_V_limitHi, otm_4_A_V_limitLo, otm_4_B_I_warnHi, otm_4_B_I_warnLo, otm_4_B_I_limitHi, otm_4_B_I_limitLo, otm_4_B_V_warnHi, otm_4_B_V_warnLo, otm_4_B_V_limitHi, otm_4_B_V_limitLo, otm_5_A_I_warnHi, otm_5_A_I_warnLo, otm_5_A_I_limitHi, otm_5_A_I_limitLo, otm_5_A_V_warnHi, otm_5_A_V_warnLo, otm_5_A_V_limitHi, otm_5_A_V_limitLo, otm_5_B_I_warnHi, otm_5_B_I_warnLo, otm_5_B_I_limitHi, otm_5_B_I_limitLo, otm_5_B_V_warnHi, otm_5_B_V_warnLo, otm_5_B_V_limitHi, otm_5_B_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_LimitsConfigurationEvent));
        Quadbox_PDU_5V_LimitsConfigurationEvent item_ = (Quadbox_PDU_5V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)otm_0_A_I_warnHi, (double)item_.getOtm_0_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_warnLo, (double)item_.getOtm_0_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_limitHi, (double)item_.getOtm_0_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_limitLo, (double)item_.getOtm_0_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_warnHi, (double)item_.getOtm_0_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_warnLo, (double)item_.getOtm_0_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_limitHi, (double)item_.getOtm_0_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_limitLo, (double)item_.getOtm_0_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_warnHi, (double)item_.getOtm_0_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_warnLo, (double)item_.getOtm_0_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_limitHi, (double)item_.getOtm_0_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_limitLo, (double)item_.getOtm_0_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_warnHi, (double)item_.getOtm_0_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_warnLo, (double)item_.getOtm_0_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_limitHi, (double)item_.getOtm_0_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_limitLo, (double)item_.getOtm_0_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_warnHi, (double)item_.getOtm_1_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_warnLo, (double)item_.getOtm_1_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_limitHi, (double)item_.getOtm_1_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_limitLo, (double)item_.getOtm_1_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_warnHi, (double)item_.getOtm_1_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_warnLo, (double)item_.getOtm_1_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_limitHi, (double)item_.getOtm_1_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_limitLo, (double)item_.getOtm_1_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_warnHi, (double)item_.getOtm_1_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_warnLo, (double)item_.getOtm_1_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_limitHi, (double)item_.getOtm_1_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_limitLo, (double)item_.getOtm_1_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_warnHi, (double)item_.getOtm_1_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_warnLo, (double)item_.getOtm_1_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_limitHi, (double)item_.getOtm_1_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_limitLo, (double)item_.getOtm_1_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_warnHi, (double)item_.getOtm_2_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_warnLo, (double)item_.getOtm_2_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_limitHi, (double)item_.getOtm_2_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_limitLo, (double)item_.getOtm_2_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_warnHi, (double)item_.getOtm_2_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_warnLo, (double)item_.getOtm_2_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_limitHi, (double)item_.getOtm_2_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_limitLo, (double)item_.getOtm_2_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_warnHi, (double)item_.getOtm_2_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_warnLo, (double)item_.getOtm_2_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_limitHi, (double)item_.getOtm_2_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_limitLo, (double)item_.getOtm_2_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_warnHi, (double)item_.getOtm_2_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_warnLo, (double)item_.getOtm_2_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_limitHi, (double)item_.getOtm_2_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_limitLo, (double)item_.getOtm_2_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_warnHi, (double)item_.getOtm_3_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_warnLo, (double)item_.getOtm_3_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_limitHi, (double)item_.getOtm_3_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_limitLo, (double)item_.getOtm_3_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_warnHi, (double)item_.getOtm_3_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_warnLo, (double)item_.getOtm_3_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_limitHi, (double)item_.getOtm_3_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_limitLo, (double)item_.getOtm_3_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnHi, (double)item_.getOtm_3_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnLo, (double)item_.getOtm_3_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitHi, (double)item_.getOtm_3_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitLo, (double)item_.getOtm_3_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnHi, (double)item_.getOtm_3_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnLo, (double)item_.getOtm_3_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitHi, (double)item_.getOtm_3_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitLo, (double)item_.getOtm_3_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_warnHi, (double)item_.getOtm_4_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_warnLo, (double)item_.getOtm_4_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_limitHi, (double)item_.getOtm_4_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_limitLo, (double)item_.getOtm_4_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_warnHi, (double)item_.getOtm_4_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_warnLo, (double)item_.getOtm_4_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_limitHi, (double)item_.getOtm_4_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_limitLo, (double)item_.getOtm_4_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_warnHi, (double)item_.getOtm_4_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_warnLo, (double)item_.getOtm_4_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_limitHi, (double)item_.getOtm_4_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_limitLo, (double)item_.getOtm_4_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_warnHi, (double)item_.getOtm_4_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_warnLo, (double)item_.getOtm_4_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_limitHi, (double)item_.getOtm_4_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_limitLo, (double)item_.getOtm_4_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_warnHi, (double)item_.getOtm_5_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_warnLo, (double)item_.getOtm_5_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_limitHi, (double)item_.getOtm_5_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_limitLo, (double)item_.getOtm_5_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_warnHi, (double)item_.getOtm_5_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_warnLo, (double)item_.getOtm_5_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_limitHi, (double)item_.getOtm_5_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_limitLo, (double)item_.getOtm_5_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_warnHi, (double)item_.getOtm_5_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_warnLo, (double)item_.getOtm_5_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_limitHi, (double)item_.getOtm_5_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_limitLo, (double)item_.getOtm_5_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_warnHi, (double)item_.getOtm_5_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_warnLo, (double)item_.getOtm_5_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_limitHi, (double)item_.getOtm_5_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_limitLo, (double)item_.getOtm_5_B_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_QuadboxConfigurationEvent() throws Exception {
        String version = "l";
        int node = 659;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_QuadboxConfigurationEvent));
        Quadbox_PDU_5V_QuadboxConfigurationEvent item_ = (Quadbox_PDU_5V_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 98;
        int schedulers_default_nThreads = 484;
        int schedulers_monitor_check_scheduler_nTasks = 102;
        int schedulers_monitor_check_scheduler_nThreads = 647;
        int schedulers_monitor_update_publish_scheduler_nTasks = 925;
        int schedulers_monitor_update_publish_scheduler_nThreads = 749;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasks_GeneralConfigurationEvent));
        Quadbox_PeriodicTasks_GeneralConfigurationEvent item_ = (Quadbox_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 687L;
        long heartbeat_taskPeriodMillis = 193L;
        long maq20_check_status_taskPeriodMillis = 730L;
        long monitor_check_BFR_taskPeriodMillis = 793L;
        long monitor_check_Maq20_taskPeriodMillis = 168L;
        long monitor_check_PDU_24VC_taskPeriodMillis = 110L;
        long monitor_check_PDU_24VD_taskPeriodMillis = 704L;
        long monitor_check_PDU_48V_taskPeriodMillis = 865L;
        long monitor_check_PDU_5V_taskPeriodMillis = 867L;
        long monitor_check_REB_Bulk_PS_taskPeriodMillis = 607L;
        long monitor_publish_BFR_taskPeriodMillis = 806L;
        long monitor_publish_PDU_24VC_taskPeriodMillis = 867L;
        long monitor_publish_PDU_24VD_taskPeriodMillis = 799L;
        long monitor_publish_PDU_48V_taskPeriodMillis = 531L;
        long monitor_publish_PDU_5V_taskPeriodMillis = 406L;
        long monitor_publish_REB_Bulk_PS_taskPeriodMillis = 98L;
        long monitor_update_BFR_taskPeriodMillis = 586L;
        long monitor_update_PDU_24VC_taskPeriodMillis = 539L;
        long monitor_update_PDU_24VD_taskPeriodMillis = 394L;
        long monitor_update_PDU_48V_taskPeriodMillis = 599L;
        long monitor_update_PDU_5V_taskPeriodMillis = 904L;
        long monitor_update_REB_Bulk_PS_taskPeriodMillis = 27L;
        long quadbox_state_taskPeriodMillis = 219L;
        long runtimeinfo_taskPeriodMillis = 591L;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, maq20_check_status_taskPeriodMillis, monitor_check_BFR_taskPeriodMillis, monitor_check_Maq20_taskPeriodMillis, monitor_check_PDU_24VC_taskPeriodMillis, monitor_check_PDU_24VD_taskPeriodMillis, monitor_check_PDU_48V_taskPeriodMillis, monitor_check_PDU_5V_taskPeriodMillis, monitor_check_REB_Bulk_PS_taskPeriodMillis, monitor_publish_BFR_taskPeriodMillis, monitor_publish_PDU_24VC_taskPeriodMillis, monitor_publish_PDU_24VD_taskPeriodMillis, monitor_publish_PDU_48V_taskPeriodMillis, monitor_publish_PDU_5V_taskPeriodMillis, monitor_publish_REB_Bulk_PS_taskPeriodMillis, monitor_update_BFR_taskPeriodMillis, monitor_update_PDU_24VC_taskPeriodMillis, monitor_update_PDU_24VD_taskPeriodMillis, monitor_update_PDU_48V_taskPeriodMillis, monitor_update_PDU_5V_taskPeriodMillis, monitor_update_REB_Bulk_PS_taskPeriodMillis, quadbox_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasks_timersConfigurationEvent));
        Quadbox_PeriodicTasks_timersConfigurationEvent item_ = (Quadbox_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)maq20_check_status_taskPeriodMillis, (long)item_.getMaq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_BFR_taskPeriodMillis, (long)item_.getMonitor_check_BFR_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PDU_24VC_taskPeriodMillis, (long)item_.getMonitor_check_PDU_24VC_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PDU_24VD_taskPeriodMillis, (long)item_.getMonitor_check_PDU_24VD_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PDU_48V_taskPeriodMillis, (long)item_.getMonitor_check_PDU_48V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PDU_5V_taskPeriodMillis, (long)item_.getMonitor_check_PDU_5V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_REB_Bulk_PS_taskPeriodMillis, (long)item_.getMonitor_check_REB_Bulk_PS_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_BFR_taskPeriodMillis, (long)item_.getMonitor_publish_BFR_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PDU_24VC_taskPeriodMillis, (long)item_.getMonitor_publish_PDU_24VC_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PDU_24VD_taskPeriodMillis, (long)item_.getMonitor_publish_PDU_24VD_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PDU_48V_taskPeriodMillis, (long)item_.getMonitor_publish_PDU_48V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PDU_5V_taskPeriodMillis, (long)item_.getMonitor_publish_PDU_5V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_REB_Bulk_PS_taskPeriodMillis, (long)item_.getMonitor_publish_REB_Bulk_PS_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_BFR_taskPeriodMillis, (long)item_.getMonitor_update_BFR_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PDU_24VC_taskPeriodMillis, (long)item_.getMonitor_update_PDU_24VC_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PDU_24VD_taskPeriodMillis, (long)item_.getMonitor_update_PDU_24VD_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PDU_48V_taskPeriodMillis, (long)item_.getMonitor_update_PDU_48V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PDU_5V_taskPeriodMillis, (long)item_.getMonitor_update_PDU_5V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_REB_Bulk_PS_taskPeriodMillis, (long)item_.getMonitor_update_REB_Bulk_PS_taskPeriodMillis());
        Assert.assertEquals((long)quadbox_state_taskPeriodMillis, (long)item_.getQuadbox_state_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_DevicesConfigurationEvent() throws Exception {
        String version = "a";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_DevicesConfigurationEvent));
        Quadbox_REB_Bulk_PS_DevicesConfigurationEvent item_ = (Quadbox_REB_Bulk_PS_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_LimitsConfigurationEvent() throws Exception {
        String version = "f";
        double rebbulkps_0_2_I_warnHi = 0.6852403879165649;
        double rebbulkps_0_2_I_warnLo = 0.43380147218704224;
        double rebbulkps_0_2_I_limitHi = 0.6640772223472595;
        double rebbulkps_0_2_I_limitLo = 0.5545397996902466;
        double rebbulkps_0_2_T_warnHi = 0.3085957169532776;
        double rebbulkps_0_2_T_warnLo = 0.9116076231002808;
        double rebbulkps_0_2_T_limitHi = 0.2826339602470398;
        double rebbulkps_0_2_T_limitLo = 0.2424364686012268;
        double rebbulkps_0_2_V_warnHi = 0.8993031978607178;
        double rebbulkps_0_2_V_warnLo = 0.389864444732666;
        double rebbulkps_0_2_V_limitHi = 0.87402f;
        double rebbulkps_0_2_V_limitLo = 0.24330562353134155;
        double rebbulkps_3_5_I_warnHi = 0.5271173715591431;
        double rebbulkps_3_5_I_warnLo = 0.8121272325515747;
        double rebbulkps_3_5_I_limitHi = 0.7979332804679871;
        double rebbulkps_3_5_I_limitLo = 0.3415534496307373;
        double rebbulkps_3_5_T_warnHi = 0.3222883939743042;
        double rebbulkps_3_5_T_warnLo = 0.9028640389442444;
        double rebbulkps_3_5_T_limitHi = 0.17943823337554932;
        double rebbulkps_3_5_T_limitLo = 0.6503531336784363;
        double rebbulkps_3_5_V_warnHi = 0.00792855f;
        double rebbulkps_3_5_V_warnLo = 0.03374302387237549;
        double rebbulkps_3_5_V_limitHi = 0.9140632152557373;
        double rebbulkps_3_5_V_limitLo = 0.3034737f;
        double rebbulkps_6_8_I_warnHi = 0.5301044583320618;
        double rebbulkps_6_8_I_warnLo = 0.8447704315185547;
        double rebbulkps_6_8_I_limitHi = 0.5800148248672485;
        double rebbulkps_6_8_I_limitLo = 0.9197233319282532;
        double rebbulkps_6_8_T_warnHi = 0.3724360466003418;
        double rebbulkps_6_8_T_warnLo = 0.7258525490760803;
        double rebbulkps_6_8_T_limitHi = 0.5308462977409363;
        double rebbulkps_6_8_T_limitLo = 0.689347505569458;
        double rebbulkps_6_8_V_warnHi = 0.4999144673347473;
        double rebbulkps_6_8_V_warnLo = 0.15168523788452148;
        double rebbulkps_6_8_V_limitHi = 0.3233150839805603;
        double rebbulkps_6_8_V_limitLo = 0.6739442944526672;
        double rebbulkps_9_12_I_warnHi = 0.8003124594688416;
        double rebbulkps_9_12_I_warnLo = 0.8840603828430176;
        double rebbulkps_9_12_I_limitHi = 0.1999720335006714;
        double rebbulkps_9_12_I_limitLo = 0.3641918897628784;
        double rebbulkps_9_12_T_warnHi = 0.1045953f;
        double rebbulkps_9_12_T_warnLo = 0.586685299873352;
        double rebbulkps_9_12_T_limitHi = 0.07568937540054321;
        double rebbulkps_9_12_T_limitLo = 0.6804636716842651;
        double rebbulkps_9_12_V_warnHi = 0.4218956232070923;
        double rebbulkps_9_12_V_warnLo = 0.5800520777702332;
        double rebbulkps_9_12_V_limitHi = 0.306423f;
        double rebbulkps_9_12_V_limitLo = 0.7984023094177246;
        double rebbulkps_Brd_T_warnHi = 0.549782395362854;
        double rebbulkps_Brd_T_warnLo = 0.45498377084732056;
        double rebbulkps_Brd_T_limitHi = 0.08471924066543579;
        double rebbulkps_Brd_T_limitLo = 0.4435202479362488;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_LimitsConfigurationEvent(version, rebbulkps_0_2_I_warnHi, rebbulkps_0_2_I_warnLo, rebbulkps_0_2_I_limitHi, rebbulkps_0_2_I_limitLo, rebbulkps_0_2_T_warnHi, rebbulkps_0_2_T_warnLo, rebbulkps_0_2_T_limitHi, rebbulkps_0_2_T_limitLo, rebbulkps_0_2_V_warnHi, rebbulkps_0_2_V_warnLo, rebbulkps_0_2_V_limitHi, rebbulkps_0_2_V_limitLo, rebbulkps_3_5_I_warnHi, rebbulkps_3_5_I_warnLo, rebbulkps_3_5_I_limitHi, rebbulkps_3_5_I_limitLo, rebbulkps_3_5_T_warnHi, rebbulkps_3_5_T_warnLo, rebbulkps_3_5_T_limitHi, rebbulkps_3_5_T_limitLo, rebbulkps_3_5_V_warnHi, rebbulkps_3_5_V_warnLo, rebbulkps_3_5_V_limitHi, rebbulkps_3_5_V_limitLo, rebbulkps_6_8_I_warnHi, rebbulkps_6_8_I_warnLo, rebbulkps_6_8_I_limitHi, rebbulkps_6_8_I_limitLo, rebbulkps_6_8_T_warnHi, rebbulkps_6_8_T_warnLo, rebbulkps_6_8_T_limitHi, rebbulkps_6_8_T_limitLo, rebbulkps_6_8_V_warnHi, rebbulkps_6_8_V_warnLo, rebbulkps_6_8_V_limitHi, rebbulkps_6_8_V_limitLo, rebbulkps_9_12_I_warnHi, rebbulkps_9_12_I_warnLo, rebbulkps_9_12_I_limitHi, rebbulkps_9_12_I_limitLo, rebbulkps_9_12_T_warnHi, rebbulkps_9_12_T_warnLo, rebbulkps_9_12_T_limitHi, rebbulkps_9_12_T_limitLo, rebbulkps_9_12_V_warnHi, rebbulkps_9_12_V_warnLo, rebbulkps_9_12_V_limitHi, rebbulkps_9_12_V_limitLo, rebbulkps_Brd_T_warnHi, rebbulkps_Brd_T_warnLo, rebbulkps_Brd_T_limitHi, rebbulkps_Brd_T_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_LimitsConfigurationEvent));
        Quadbox_REB_Bulk_PS_LimitsConfigurationEvent item_ = (Quadbox_REB_Bulk_PS_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)rebbulkps_0_2_I_warnHi, (double)item_.getRebbulkps_0_2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_warnLo, (double)item_.getRebbulkps_0_2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_limitHi, (double)item_.getRebbulkps_0_2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_limitLo, (double)item_.getRebbulkps_0_2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_warnHi, (double)item_.getRebbulkps_0_2_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_warnLo, (double)item_.getRebbulkps_0_2_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_limitHi, (double)item_.getRebbulkps_0_2_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_limitLo, (double)item_.getRebbulkps_0_2_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_warnHi, (double)item_.getRebbulkps_0_2_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_warnLo, (double)item_.getRebbulkps_0_2_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_limitHi, (double)item_.getRebbulkps_0_2_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_limitLo, (double)item_.getRebbulkps_0_2_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_warnHi, (double)item_.getRebbulkps_3_5_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_warnLo, (double)item_.getRebbulkps_3_5_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_limitHi, (double)item_.getRebbulkps_3_5_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_limitLo, (double)item_.getRebbulkps_3_5_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_warnHi, (double)item_.getRebbulkps_3_5_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_warnLo, (double)item_.getRebbulkps_3_5_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_limitHi, (double)item_.getRebbulkps_3_5_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_limitLo, (double)item_.getRebbulkps_3_5_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_warnHi, (double)item_.getRebbulkps_3_5_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_warnLo, (double)item_.getRebbulkps_3_5_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_limitHi, (double)item_.getRebbulkps_3_5_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_limitLo, (double)item_.getRebbulkps_3_5_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_warnHi, (double)item_.getRebbulkps_6_8_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_warnLo, (double)item_.getRebbulkps_6_8_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_limitHi, (double)item_.getRebbulkps_6_8_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_limitLo, (double)item_.getRebbulkps_6_8_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_warnHi, (double)item_.getRebbulkps_6_8_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_warnLo, (double)item_.getRebbulkps_6_8_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_limitHi, (double)item_.getRebbulkps_6_8_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_limitLo, (double)item_.getRebbulkps_6_8_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_warnHi, (double)item_.getRebbulkps_6_8_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_warnLo, (double)item_.getRebbulkps_6_8_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_limitHi, (double)item_.getRebbulkps_6_8_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_limitLo, (double)item_.getRebbulkps_6_8_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_warnHi, (double)item_.getRebbulkps_9_12_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_warnLo, (double)item_.getRebbulkps_9_12_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_limitHi, (double)item_.getRebbulkps_9_12_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_limitLo, (double)item_.getRebbulkps_9_12_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_warnHi, (double)item_.getRebbulkps_9_12_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_warnLo, (double)item_.getRebbulkps_9_12_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_limitHi, (double)item_.getRebbulkps_9_12_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_limitLo, (double)item_.getRebbulkps_9_12_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_warnHi, (double)item_.getRebbulkps_9_12_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_warnLo, (double)item_.getRebbulkps_9_12_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_limitHi, (double)item_.getRebbulkps_9_12_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_limitLo, (double)item_.getRebbulkps_9_12_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_warnHi, (double)item_.getRebbulkps_Brd_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_warnLo, (double)item_.getRebbulkps_Brd_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_limitHi, (double)item_.getRebbulkps_Brd_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_limitLo, (double)item_.getRebbulkps_Brd_T_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_QuadboxConfigurationEvent() throws Exception {
        String version = "";
        int node = 169;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent));
        Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent item_ = (Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveRebpower_EmergencyResponseManager_GeneralConfigurationEvent() throws Exception {
        String version = "";
        boolean processOnlyClearedAlerts = true;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_EmergencyResponseManager_GeneralConfigurationEvent(version, processOnlyClearedAlerts));
        Assert.assertTrue((boolean)(item instanceof Rebpower_EmergencyResponseManager_GeneralConfigurationEvent));
        Rebpower_EmergencyResponseManager_GeneralConfigurationEvent item_ = (Rebpower_EmergencyResponseManager_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)processOnlyClearedAlerts, (Object)item_.isProcessOnlyClearedAlerts());
    }

    @Test
    public void sendReceiveRebpower_GeneralConfigurationEvent() throws Exception {
        String version = "";
        long powerOffSleepMillis = 163L;
        int psDeviceExcepNumToOffline = 391;
        long psDeviceReadTimeout = 114L;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_GeneralConfigurationEvent(version, powerOffSleepMillis, psDeviceExcepNumToOffline, psDeviceReadTimeout));
        Assert.assertTrue((boolean)(item instanceof Rebpower_GeneralConfigurationEvent));
        Rebpower_GeneralConfigurationEvent item_ = (Rebpower_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)powerOffSleepMillis, (long)item_.getPowerOffSleepMillis());
        Assert.assertEquals((long)psDeviceExcepNumToOffline, (long)item_.getPsDeviceExcepNumToOffline());
        Assert.assertEquals((long)psDeviceReadTimeout, (long)item_.getPsDeviceReadTimeout());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 36;
        int schedulers_default_nThreads = 584;
        int schedulers_monitor_check_scheduler_nTasks = 554;
        int schedulers_monitor_check_scheduler_nThreads = 329;
        int schedulers_monitor_update_publish_scheduler_nTasks = 557;
        int schedulers_monitor_update_publish_scheduler_nThreads = 393;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasks_GeneralConfigurationEvent));
        Rebpower_PeriodicTasks_GeneralConfigurationEvent item_ = (Rebpower_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 184L;
        long heartbeat_taskPeriodMillis = 616L;
        long monitor_check_RebPS_P00_taskPeriodMillis = 679L;
        long monitor_check_RebPS_P01_taskPeriodMillis = 448L;
        long monitor_check_RebPS_P02_taskPeriodMillis = 704L;
        long monitor_check_RebPS_P03_taskPeriodMillis = 347L;
        long monitor_check_RebPS_P04_taskPeriodMillis = 818L;
        long monitor_check_RebPS_P05_taskPeriodMillis = 319L;
        long monitor_check_RebPS_P06_taskPeriodMillis = 580L;
        long monitor_check_RebPS_P07_taskPeriodMillis = 336L;
        long monitor_check_RebPS_P08_taskPeriodMillis = 804L;
        long monitor_check_RebPS_P09_taskPeriodMillis = 184L;
        long monitor_check_RebPS_P10_taskPeriodMillis = 938L;
        long monitor_check_RebPS_P11_taskPeriodMillis = 61L;
        long monitor_check_RebPS_P12_taskPeriodMillis = 976L;
        long monitor_publish_RebPS_P00_taskPeriodMillis = 711L;
        long monitor_publish_RebPS_P01_taskPeriodMillis = 216L;
        long monitor_publish_RebPS_P02_taskPeriodMillis = 327L;
        long monitor_publish_RebPS_P03_taskPeriodMillis = 892L;
        long monitor_publish_RebPS_P04_taskPeriodMillis = 616L;
        long monitor_publish_RebPS_P05_taskPeriodMillis = 11L;
        long monitor_publish_RebPS_P06_taskPeriodMillis = 698L;
        long monitor_publish_RebPS_P07_taskPeriodMillis = 388L;
        long monitor_publish_RebPS_P08_taskPeriodMillis = 960L;
        long monitor_publish_RebPS_P09_taskPeriodMillis = 205L;
        long monitor_publish_RebPS_P10_taskPeriodMillis = 411L;
        long monitor_publish_RebPS_P11_taskPeriodMillis = 692L;
        long monitor_publish_RebPS_P12_taskPeriodMillis = 368L;
        long monitor_publish_r00_taskPeriodMillis = 562L;
        long monitor_publish_r04_taskPeriodMillis = 46L;
        long monitor_publish_r40_taskPeriodMillis = 226L;
        long monitor_publish_r44_taskPeriodMillis = 244L;
        long monitor_publish_taskPeriodMillis = 48L;
        long monitor_update_RebPS_P00_taskPeriodMillis = 643L;
        long monitor_update_RebPS_P01_taskPeriodMillis = 574L;
        long monitor_update_RebPS_P02_taskPeriodMillis = 154L;
        long monitor_update_RebPS_P03_taskPeriodMillis = 592L;
        long monitor_update_RebPS_P04_taskPeriodMillis = 67L;
        long monitor_update_RebPS_P05_taskPeriodMillis = 527L;
        long monitor_update_RebPS_P06_taskPeriodMillis = 502L;
        long monitor_update_RebPS_P07_taskPeriodMillis = 885L;
        long monitor_update_RebPS_P08_taskPeriodMillis = 217L;
        long monitor_update_RebPS_P09_taskPeriodMillis = 188L;
        long monitor_update_RebPS_P10_taskPeriodMillis = 723L;
        long monitor_update_RebPS_P11_taskPeriodMillis = 360L;
        long monitor_update_RebPS_P12_taskPeriodMillis = 964L;
        long monitor_update_r00_taskPeriodMillis = 771L;
        long monitor_update_r04_taskPeriodMillis = 195L;
        long monitor_update_r40_taskPeriodMillis = 501L;
        long monitor_update_r44_taskPeriodMillis = 345L;
        long monitor_update_taskPeriodMillis = 353L;
        long reb_power_state_taskPeriodMillis = 335L;
        long runtimeinfo_taskPeriodMillis = 998L;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_RebPS_P00_taskPeriodMillis, monitor_check_RebPS_P01_taskPeriodMillis, monitor_check_RebPS_P02_taskPeriodMillis, monitor_check_RebPS_P03_taskPeriodMillis, monitor_check_RebPS_P04_taskPeriodMillis, monitor_check_RebPS_P05_taskPeriodMillis, monitor_check_RebPS_P06_taskPeriodMillis, monitor_check_RebPS_P07_taskPeriodMillis, monitor_check_RebPS_P08_taskPeriodMillis, monitor_check_RebPS_P09_taskPeriodMillis, monitor_check_RebPS_P10_taskPeriodMillis, monitor_check_RebPS_P11_taskPeriodMillis, monitor_check_RebPS_P12_taskPeriodMillis, monitor_publish_RebPS_P00_taskPeriodMillis, monitor_publish_RebPS_P01_taskPeriodMillis, monitor_publish_RebPS_P02_taskPeriodMillis, monitor_publish_RebPS_P03_taskPeriodMillis, monitor_publish_RebPS_P04_taskPeriodMillis, monitor_publish_RebPS_P05_taskPeriodMillis, monitor_publish_RebPS_P06_taskPeriodMillis, monitor_publish_RebPS_P07_taskPeriodMillis, monitor_publish_RebPS_P08_taskPeriodMillis, monitor_publish_RebPS_P09_taskPeriodMillis, monitor_publish_RebPS_P10_taskPeriodMillis, monitor_publish_RebPS_P11_taskPeriodMillis, monitor_publish_RebPS_P12_taskPeriodMillis, monitor_publish_r00_taskPeriodMillis, monitor_publish_r04_taskPeriodMillis, monitor_publish_r40_taskPeriodMillis, monitor_publish_r44_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_RebPS_P00_taskPeriodMillis, monitor_update_RebPS_P01_taskPeriodMillis, monitor_update_RebPS_P02_taskPeriodMillis, monitor_update_RebPS_P03_taskPeriodMillis, monitor_update_RebPS_P04_taskPeriodMillis, monitor_update_RebPS_P05_taskPeriodMillis, monitor_update_RebPS_P06_taskPeriodMillis, monitor_update_RebPS_P07_taskPeriodMillis, monitor_update_RebPS_P08_taskPeriodMillis, monitor_update_RebPS_P09_taskPeriodMillis, monitor_update_RebPS_P10_taskPeriodMillis, monitor_update_RebPS_P11_taskPeriodMillis, monitor_update_RebPS_P12_taskPeriodMillis, monitor_update_r00_taskPeriodMillis, monitor_update_r04_taskPeriodMillis, monitor_update_r40_taskPeriodMillis, monitor_update_r44_taskPeriodMillis, monitor_update_taskPeriodMillis, reb_power_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasks_timersConfigurationEvent));
        Rebpower_PeriodicTasks_timersConfigurationEvent item_ = (Rebpower_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_r00_taskPeriodMillis, (long)item_.getMonitor_publish_r00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_r04_taskPeriodMillis, (long)item_.getMonitor_publish_r04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_r40_taskPeriodMillis, (long)item_.getMonitor_publish_r40_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_r44_taskPeriodMillis, (long)item_.getMonitor_publish_r44_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_r00_taskPeriodMillis, (long)item_.getMonitor_update_r00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_r04_taskPeriodMillis, (long)item_.getMonitor_update_r04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_r40_taskPeriodMillis, (long)item_.getMonitor_update_r40_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_r44_taskPeriodMillis, (long)item_.getMonitor_update_r44_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)reb_power_state_taskPeriodMillis, (long)item_.getReb_power_state_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveRebpower_Power_timersConfigurationEvent() throws Exception {
        String version = "b";
        String location = "a";
        long[] periodictasks_monitor_publish_taskPeriodMillis = TestHelper.generateLongArray((int)63, (int)1436232895);
        long[] periodictasks_monitor_update_taskPeriodMillis = TestHelper.generateLongArray((int)63, (int)703977514);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Power_timersConfigurationEvent(version, location, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Power_timersConfigurationEvent));
        Rebpower_Power_timersConfigurationEvent item_ = (Rebpower_Power_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_taskPeriodMillis());
    }

    @Test
    public void sendReceiveRebpower_RebTotalPower_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.8007899522781372;
        double warnLo = 0.5389488339424133;
        double limitHi = 0.21893548965454102;
        double limitLo = 0.8761265277862549;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_RebTotalPower_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTotalPower_LimitsConfigurationEvent));
        Rebpower_RebTotalPower_LimitsConfigurationEvent item_ = (Rebpower_RebTotalPower_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_Reb_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int[] dphi = TestHelper.generateIntArray((int)71, (int)-277532678);
        int[] hvBias = TestHelper.generateIntArray((int)71, (int)839748735);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Reb_GeneralConfigurationEvent(version, dphi, hvBias, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Reb_GeneralConfigurationEvent));
        Rebpower_Reb_GeneralConfigurationEvent item_ = (Rebpower_Reb_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((int[])dphi, (int[])item_.getDphi());
        Assert.assertArrayEquals((int[])hvBias, (int[])item_.getHvBias());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Reb_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double[] analog_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1362807546);
        double[] analog_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-899277734);
        double[] analog_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)880320087);
        double[] analog_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1036408008);
        double[] analog_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1414777772);
        double[] analog_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1311006219);
        double[] analog_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1077313887);
        double[] analog_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)925326478);
        double[] analog_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)2045514726);
        double[] analog_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)639418088);
        double[] analog_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)2013467549);
        double[] analog_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1307455252);
        double[] analog_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)328977206);
        double[] analog_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2100221899);
        double[] analog_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)56504754);
        double[] analog_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)1673514815);
        double[] analog_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1393596098);
        double[] analog_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1545785992);
        double[] analog_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)2132543447);
        double[] analog_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1760192352);
        double[] clockhi_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-869769270);
        double[] clockhi_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-470155428);
        double[] clockhi_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1099478714);
        double[] clockhi_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)197809642);
        double[] clockhi_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-932422568);
        double[] clockhi_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1897436847);
        double[] clockhi_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1627716056);
        double[] clockhi_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-242333044);
        double[] clockhi_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)997141376);
        double[] clockhi_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2121076101);
        double[] clockhi_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)602451439);
        double[] clockhi_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)182509727);
        double[] clockhi_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)1631187433);
        double[] clockhi_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)1742445037);
        double[] clockhi_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1590532971);
        double[] clockhi_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-885857734);
        double[] clockhi_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)63978123);
        double[] clockhi_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-27745770);
        double[] clockhi_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)322789349);
        double[] clockhi_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-253594619);
        double[] clocklo_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-955605063);
        double[] clocklo_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)436019067);
        double[] clocklo_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)762945449);
        double[] clocklo_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)509846796);
        double[] clocklo_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1065648226);
        double[] clocklo_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)249118374);
        double[] clocklo_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1770003900);
        double[] clocklo_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1472309205);
        double[] clocklo_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)71, (int)1918453139);
        double[] clocklo_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1378519715);
        double[] clocklo_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1830137902);
        double[] clocklo_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)71, (int)1741818035);
        double[] clocklo_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-600703937);
        double[] clocklo_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)911414039);
        double[] clocklo_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-345361523);
        double[] clocklo_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-63670948);
        double[] clocklo_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)2129413954);
        double[] clocklo_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1218386773);
        double[] clocklo_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1657444494);
        double[] clocklo_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2050037319);
        double[] clocklo_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)842001827);
        double[] clocklo_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-605429942);
        double[] clocklo_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-395553245);
        double[] clocklo_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1981765117);
        double[] digital_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1931966183);
        double[] digital_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1724971345);
        double[] digital_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1858320143);
        double[] digital_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1975063033);
        double[] digital_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-143845168);
        double[] digital_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1103297900);
        double[] digital_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1271621839);
        double[] digital_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1859498413);
        double[] digital_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1690862484);
        double[] digital_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1189013657);
        double[] digital_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)31329747);
        double[] digital_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1430654753);
        double[] digital_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-97903794);
        double[] digital_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1029147075);
        double[] digital_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)1230720829);
        double[] digital_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)478780790);
        double[] digital_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1713226731);
        double[] digital_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-290449401);
        double[] digital_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-309794292);
        double[] digital_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1251957047);
        double[] dphi_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1543909273);
        double[] dphi_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1128622077);
        double[] dphi_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-107681155);
        double[] dphi_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1685788172);
        double[] dphi_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)130267376);
        double[] dphi_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-974864012);
        double[] dphi_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)989182381);
        double[] dphi_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1685206767);
        double[] dphi_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)565822890);
        double[] dphi_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)296273044);
        double[] dphi_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)587915650);
        double[] dphi_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1996849627);
        double[] dphi_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)1402205791);
        double[] dphi_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1385478455);
        double[] dphi_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)313240268);
        double[] dphi_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)1227710171);
        double[] dphi_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)829734763);
        double[] dphi_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)181191191);
        double[] dphi_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)897513894);
        double[] dphi_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1423382639);
        double[] heater_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-586262842);
        double[] heater_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-915609642);
        double[] heater_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)181013538);
        double[] heater_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-85763947);
        double[] heater_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)56708417);
        double[] heater_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1098185380);
        double[] heater_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)874118948);
        double[] heater_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1074014218);
        double[] heater_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1693775888);
        double[] heater_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-266775652);
        double[] heater_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-368689778);
        double[] heater_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-527394669);
        double[] heater_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)1332637320);
        double[] heater_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-846100793);
        double[] heater_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1165476451);
        double[] heater_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2143797095);
        double[] heater_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1920147496);
        double[] heater_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1208605394);
        double[] heater_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-985190254);
        double[] heater_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)2033867771);
        double[] hvbias_IbefSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1123006755);
        double[] hvbias_IbefSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-938997759);
        double[] hvbias_VbefSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)1056737428);
        double[] hvbias_VbefSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)1152230943);
        String location = "h";
        double[] od_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)2013296852);
        double[] od_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-660389558);
        double[] od_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-12655963);
        double[] od_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1085821767);
        double[] od_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)828101618);
        double[] od_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1430241487);
        double[] od_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1347887217);
        double[] od_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1174108690);
        double[] od_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1716589409);
        double[] od_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)71, (int)462331600);
        double[] od_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1831269499);
        double[] od_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-8655999);
        double[] od_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1642898302);
        double[] od_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-780151943);
        double[] od_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)328563532);
        double[] od_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1581278651);
        double[] od_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)1025037663);
        double[] od_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)933767471);
        double[] od_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-505598741);
        double[] od_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)1185565708);
        double[] od_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1990500234);
        double[] od_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1126458828);
        double[] od_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-159256652);
        double[] od_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-738476050);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)71, (int)-130830295);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)71, (int)961145312);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1440069500);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)71, (int)1424753465);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Reb_LimitsConfigurationEvent(version, analog_IaftLDO_warnHi, analog_IaftLDO_warnLo, analog_IaftLDO_limitHi, analog_IaftLDO_limitLo, analog_IbefLDO_warnHi, analog_IbefLDO_warnLo, analog_IbefLDO_limitHi, analog_IbefLDO_limitLo, analog_VaftLDO_warnHi, analog_VaftLDO_warnLo, analog_VaftLDO_limitHi, analog_VaftLDO_limitLo, analog_VaftSwch_warnHi, analog_VaftSwch_warnLo, analog_VaftSwch_limitHi, analog_VaftSwch_limitLo, analog_VbefLDO_warnHi, analog_VbefLDO_warnLo, analog_VbefLDO_limitHi, analog_VbefLDO_limitLo, clockhi_IaftLDO_warnHi, clockhi_IaftLDO_warnLo, clockhi_IaftLDO_limitHi, clockhi_IaftLDO_limitLo, clockhi_IbefLDO_warnHi, clockhi_IbefLDO_warnLo, clockhi_IbefLDO_limitHi, clockhi_IbefLDO_limitLo, clockhi_VaftLDO_warnHi, clockhi_VaftLDO_warnLo, clockhi_VaftLDO_limitHi, clockhi_VaftLDO_limitLo, clockhi_VaftSwch_warnHi, clockhi_VaftSwch_warnLo, clockhi_VaftSwch_limitHi, clockhi_VaftSwch_limitLo, clockhi_VbefLDO_warnHi, clockhi_VbefLDO_warnLo, clockhi_VbefLDO_limitHi, clockhi_VbefLDO_limitLo, clocklo_IaftLDO_warnHi, clocklo_IaftLDO_warnLo, clocklo_IaftLDO_limitHi, clocklo_IaftLDO_limitLo, clocklo_IbefLDO_warnHi, clocklo_IbefLDO_warnLo, clocklo_IbefLDO_limitHi, clocklo_IbefLDO_limitLo, clocklo_VaftLDO2_warnHi, clocklo_VaftLDO2_warnLo, clocklo_VaftLDO2_limitHi, clocklo_VaftLDO2_limitLo, clocklo_VaftLDO_warnHi, clocklo_VaftLDO_warnLo, clocklo_VaftLDO_limitHi, clocklo_VaftLDO_limitLo, clocklo_VaftSwch_warnHi, clocklo_VaftSwch_warnLo, clocklo_VaftSwch_limitHi, clocklo_VaftSwch_limitLo, clocklo_VbefLDO_warnHi, clocklo_VbefLDO_warnLo, clocklo_VbefLDO_limitHi, clocklo_VbefLDO_limitLo, digital_IaftLDO_warnHi, digital_IaftLDO_warnLo, digital_IaftLDO_limitHi, digital_IaftLDO_limitLo, digital_IbefLDO_warnHi, digital_IbefLDO_warnLo, digital_IbefLDO_limitHi, digital_IbefLDO_limitLo, digital_VaftLDO_warnHi, digital_VaftLDO_warnLo, digital_VaftLDO_limitHi, digital_VaftLDO_limitLo, digital_VaftSwch_warnHi, digital_VaftSwch_warnLo, digital_VaftSwch_limitHi, digital_VaftSwch_limitLo, digital_VbefLDO_warnHi, digital_VbefLDO_warnLo, digital_VbefLDO_limitHi, digital_VbefLDO_limitLo, dphi_IaftLDO_warnHi, dphi_IaftLDO_warnLo, dphi_IaftLDO_limitHi, dphi_IaftLDO_limitLo, dphi_IbefLDO_warnHi, dphi_IbefLDO_warnLo, dphi_IbefLDO_limitHi, dphi_IbefLDO_limitLo, dphi_VaftLDO_warnHi, dphi_VaftLDO_warnLo, dphi_VaftLDO_limitHi, dphi_VaftLDO_limitLo, dphi_VaftSwch_warnHi, dphi_VaftSwch_warnLo, dphi_VaftSwch_limitHi, dphi_VaftSwch_limitLo, dphi_VbefLDO_warnHi, dphi_VbefLDO_warnLo, dphi_VbefLDO_limitHi, dphi_VbefLDO_limitLo, heater_IaftLDO_warnHi, heater_IaftLDO_warnLo, heater_IaftLDO_limitHi, heater_IaftLDO_limitLo, heater_IbefLDO_warnHi, heater_IbefLDO_warnLo, heater_IbefLDO_limitHi, heater_IbefLDO_limitLo, heater_VaftLDO_warnHi, heater_VaftLDO_warnLo, heater_VaftLDO_limitHi, heater_VaftLDO_limitLo, heater_VaftSwch_warnHi, heater_VaftSwch_warnLo, heater_VaftSwch_limitHi, heater_VaftSwch_limitLo, heater_VbefLDO_warnHi, heater_VbefLDO_warnLo, heater_VbefLDO_limitHi, heater_VbefLDO_limitLo, hvbias_IbefSwch_warnHi, hvbias_IbefSwch_limitHi, hvbias_VbefSwch_warnHi, hvbias_VbefSwch_limitHi, location, od_IaftLDO_warnHi, od_IaftLDO_warnLo, od_IaftLDO_limitHi, od_IaftLDO_limitLo, od_IbefLDO_warnHi, od_IbefLDO_warnLo, od_IbefLDO_limitHi, od_IbefLDO_limitLo, od_VaftLDO2_warnHi, od_VaftLDO2_warnLo, od_VaftLDO2_limitHi, od_VaftLDO2_limitLo, od_VaftLDO_warnHi, od_VaftLDO_warnLo, od_VaftLDO_limitHi, od_VaftLDO_limitLo, od_VaftSwch_warnHi, od_VaftSwch_warnLo, od_VaftSwch_limitHi, od_VaftSwch_limitLo, od_VbefLDO_warnHi, od_VbefLDO_warnLo, od_VbefLDO_limitHi, od_VbefLDO_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Reb_LimitsConfigurationEvent));
        Rebpower_Reb_LimitsConfigurationEvent item_ = (Rebpower_Reb_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnHi, (double[])item_.getAnalog_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnLo, (double[])item_.getAnalog_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitHi, (double[])item_.getAnalog_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitLo, (double[])item_.getAnalog_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnHi, (double[])item_.getAnalog_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnLo, (double[])item_.getAnalog_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitHi, (double[])item_.getAnalog_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitLo, (double[])item_.getAnalog_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnHi, (double[])item_.getAnalog_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnLo, (double[])item_.getAnalog_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitHi, (double[])item_.getAnalog_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitLo, (double[])item_.getAnalog_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnHi, (double[])item_.getAnalog_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnLo, (double[])item_.getAnalog_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitHi, (double[])item_.getAnalog_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitLo, (double[])item_.getAnalog_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnHi, (double[])item_.getAnalog_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnLo, (double[])item_.getAnalog_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitHi, (double[])item_.getAnalog_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitLo, (double[])item_.getAnalog_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnHi, (double[])item_.getClockhi_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnLo, (double[])item_.getClockhi_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitHi, (double[])item_.getClockhi_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitLo, (double[])item_.getClockhi_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnHi, (double[])item_.getClockhi_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnLo, (double[])item_.getClockhi_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitHi, (double[])item_.getClockhi_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitLo, (double[])item_.getClockhi_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnHi, (double[])item_.getClockhi_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnLo, (double[])item_.getClockhi_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitHi, (double[])item_.getClockhi_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitLo, (double[])item_.getClockhi_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnHi, (double[])item_.getClockhi_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnLo, (double[])item_.getClockhi_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitHi, (double[])item_.getClockhi_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitLo, (double[])item_.getClockhi_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnHi, (double[])item_.getClockhi_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnLo, (double[])item_.getClockhi_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitHi, (double[])item_.getClockhi_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitLo, (double[])item_.getClockhi_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnHi, (double[])item_.getClocklo_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnLo, (double[])item_.getClocklo_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitHi, (double[])item_.getClocklo_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitLo, (double[])item_.getClocklo_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnHi, (double[])item_.getClocklo_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnLo, (double[])item_.getClocklo_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitHi, (double[])item_.getClocklo_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitLo, (double[])item_.getClocklo_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnHi, (double[])item_.getClocklo_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnLo, (double[])item_.getClocklo_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitHi, (double[])item_.getClocklo_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitLo, (double[])item_.getClocklo_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnHi, (double[])item_.getClocklo_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnLo, (double[])item_.getClocklo_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitHi, (double[])item_.getClocklo_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitLo, (double[])item_.getClocklo_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnHi, (double[])item_.getClocklo_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnLo, (double[])item_.getClocklo_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitHi, (double[])item_.getClocklo_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitLo, (double[])item_.getClocklo_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnHi, (double[])item_.getClocklo_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnLo, (double[])item_.getClocklo_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitHi, (double[])item_.getClocklo_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitLo, (double[])item_.getClocklo_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnHi, (double[])item_.getDigital_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnLo, (double[])item_.getDigital_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitHi, (double[])item_.getDigital_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitLo, (double[])item_.getDigital_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnHi, (double[])item_.getDigital_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnLo, (double[])item_.getDigital_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitHi, (double[])item_.getDigital_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitLo, (double[])item_.getDigital_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnHi, (double[])item_.getDigital_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnLo, (double[])item_.getDigital_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitHi, (double[])item_.getDigital_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitLo, (double[])item_.getDigital_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnHi, (double[])item_.getDigital_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnLo, (double[])item_.getDigital_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitHi, (double[])item_.getDigital_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitLo, (double[])item_.getDigital_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnHi, (double[])item_.getDigital_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnLo, (double[])item_.getDigital_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitHi, (double[])item_.getDigital_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitLo, (double[])item_.getDigital_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_warnHi, (double[])item_.getDphi_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_warnLo, (double[])item_.getDphi_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_limitHi, (double[])item_.getDphi_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_limitLo, (double[])item_.getDphi_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_warnHi, (double[])item_.getDphi_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_warnLo, (double[])item_.getDphi_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_limitHi, (double[])item_.getDphi_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_limitLo, (double[])item_.getDphi_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_warnHi, (double[])item_.getDphi_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_warnLo, (double[])item_.getDphi_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_limitHi, (double[])item_.getDphi_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_limitLo, (double[])item_.getDphi_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_warnHi, (double[])item_.getDphi_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_warnLo, (double[])item_.getDphi_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_limitHi, (double[])item_.getDphi_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_limitLo, (double[])item_.getDphi_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_warnHi, (double[])item_.getDphi_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_warnLo, (double[])item_.getDphi_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_limitHi, (double[])item_.getDphi_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_limitLo, (double[])item_.getDphi_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnHi, (double[])item_.getHeater_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnLo, (double[])item_.getHeater_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitHi, (double[])item_.getHeater_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitLo, (double[])item_.getHeater_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnHi, (double[])item_.getHeater_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnLo, (double[])item_.getHeater_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitHi, (double[])item_.getHeater_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitLo, (double[])item_.getHeater_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnHi, (double[])item_.getHeater_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnLo, (double[])item_.getHeater_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitHi, (double[])item_.getHeater_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitLo, (double[])item_.getHeater_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnHi, (double[])item_.getHeater_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnLo, (double[])item_.getHeater_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitHi, (double[])item_.getHeater_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitLo, (double[])item_.getHeater_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnHi, (double[])item_.getHeater_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnLo, (double[])item_.getHeater_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitHi, (double[])item_.getHeater_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitLo, (double[])item_.getHeater_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_warnHi, (double[])item_.getHvbias_IbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_limitHi, (double[])item_.getHvbias_IbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_warnHi, (double[])item_.getHvbias_VbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_limitHi, (double[])item_.getHvbias_VbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO_warnHi, (double[])item_.getOd_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_warnLo, (double[])item_.getOd_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitHi, (double[])item_.getOd_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitLo, (double[])item_.getOd_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnHi, (double[])item_.getOd_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnLo, (double[])item_.getOd_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitHi, (double[])item_.getOd_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitLo, (double[])item_.getOd_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnHi, (double[])item_.getOd_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnLo, (double[])item_.getOd_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitHi, (double[])item_.getOd_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitLo, (double[])item_.getOd_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnHi, (double[])item_.getOd_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnLo, (double[])item_.getOd_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitHi, (double[])item_.getOd_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitLo, (double[])item_.getOd_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnHi, (double[])item_.getOd_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnLo, (double[])item_.getOd_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitHi, (double[])item_.getOd_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitLo, (double[])item_.getOd_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnHi, (double[])item_.getOd_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnLo, (double[])item_.getOd_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitHi, (double[])item_.getOd_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitLo, (double[])item_.getOd_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_Rebps_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean[] disabled = new boolean[]{true, true, true, true, false, true, true, true, false, false, true, true, true};
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_DevicesConfigurationEvent(version, disabled, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_DevicesConfigurationEvent));
        Rebpower_Rebps_DevicesConfigurationEvent item_ = (Rebpower_Rebps_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((boolean[])disabled, (boolean[])item_.getDisabled());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Rebps_GeneralConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        String rebs = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_GeneralConfigurationEvent(version, location, rebs));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_GeneralConfigurationEvent));
        Rebpower_Rebps_GeneralConfigurationEvent item_ = (Rebpower_Rebps_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)rebs, (Object)item_.getRebs());
    }

    @Test
    public void sendReceiveRebpower_Rebps_LimitsConfigurationEvent() throws Exception {
        String version = "u";
        double[] boardtemp0_warnHi = TestHelper.generateDoubleArray((int)13, (int)1073832072);
        double[] boardtemp0_warnLo = TestHelper.generateDoubleArray((int)13, (int)-1190018701);
        double[] boardtemp0_limitHi = TestHelper.generateDoubleArray((int)13, (int)-1062984232);
        double[] boardtemp0_limitLo = TestHelper.generateDoubleArray((int)13, (int)-2028812166);
        double[] boardtemp1_warnHi = TestHelper.generateDoubleArray((int)13, (int)565045903);
        double[] boardtemp1_warnLo = TestHelper.generateDoubleArray((int)13, (int)937864108);
        double[] boardtemp1_limitHi = TestHelper.generateDoubleArray((int)13, (int)928030298);
        double[] boardtemp1_limitLo = TestHelper.generateDoubleArray((int)13, (int)-1796951056);
        double[] boardtemp2_warnHi = TestHelper.generateDoubleArray((int)13, (int)-974143367);
        double[] boardtemp2_warnLo = TestHelper.generateDoubleArray((int)13, (int)-2051961306);
        double[] boardtemp2_limitHi = TestHelper.generateDoubleArray((int)13, (int)-253499929);
        double[] boardtemp2_limitLo = TestHelper.generateDoubleArray((int)13, (int)1743717347);
        double[] boardtemp3_warnHi = TestHelper.generateDoubleArray((int)13, (int)-47808529);
        double[] boardtemp3_warnLo = TestHelper.generateDoubleArray((int)13, (int)1108493183);
        double[] boardtemp3_limitHi = TestHelper.generateDoubleArray((int)13, (int)-383527811);
        double[] boardtemp3_limitLo = TestHelper.generateDoubleArray((int)13, (int)998502583);
        double[] boardtemp4_warnHi = TestHelper.generateDoubleArray((int)13, (int)-292996120);
        double[] boardtemp4_warnLo = TestHelper.generateDoubleArray((int)13, (int)1572424813);
        double[] boardtemp4_limitHi = TestHelper.generateDoubleArray((int)13, (int)1436697617);
        double[] boardtemp4_limitLo = TestHelper.generateDoubleArray((int)13, (int)222230861);
        double[] boardtemp5_warnHi = TestHelper.generateDoubleArray((int)13, (int)-425238777);
        double[] boardtemp5_warnLo = TestHelper.generateDoubleArray((int)13, (int)1054739547);
        double[] boardtemp5_limitHi = TestHelper.generateDoubleArray((int)13, (int)-1762536562);
        double[] boardtemp5_limitLo = TestHelper.generateDoubleArray((int)13, (int)-144604228);
        double[] boardtemp6_warnHi = TestHelper.generateDoubleArray((int)13, (int)1193988161);
        double[] boardtemp6_warnLo = TestHelper.generateDoubleArray((int)13, (int)1124318007);
        double[] boardtemp6_limitHi = TestHelper.generateDoubleArray((int)13, (int)842356254);
        double[] boardtemp6_limitLo = TestHelper.generateDoubleArray((int)13, (int)-611560128);
        double[] fpgatemp_warnHi = TestHelper.generateDoubleArray((int)13, (int)109395394);
        double[] fpgatemp_warnLo = TestHelper.generateDoubleArray((int)13, (int)-1891950454);
        double[] fpgatemp_limitHi = TestHelper.generateDoubleArray((int)13, (int)1503687335);
        double[] fpgatemp_limitLo = TestHelper.generateDoubleArray((int)13, (int)-1769728654);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_LimitsConfigurationEvent(version, boardtemp0_warnHi, boardtemp0_warnLo, boardtemp0_limitHi, boardtemp0_limitLo, boardtemp1_warnHi, boardtemp1_warnLo, boardtemp1_limitHi, boardtemp1_limitLo, boardtemp2_warnHi, boardtemp2_warnLo, boardtemp2_limitHi, boardtemp2_limitLo, boardtemp3_warnHi, boardtemp3_warnLo, boardtemp3_limitHi, boardtemp3_limitLo, boardtemp4_warnHi, boardtemp4_warnLo, boardtemp4_limitHi, boardtemp4_limitLo, boardtemp5_warnHi, boardtemp5_warnLo, boardtemp5_limitHi, boardtemp5_limitLo, boardtemp6_warnHi, boardtemp6_warnLo, boardtemp6_limitHi, boardtemp6_limitLo, fpgatemp_warnHi, fpgatemp_warnLo, fpgatemp_limitHi, fpgatemp_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_LimitsConfigurationEvent));
        Rebpower_Rebps_LimitsConfigurationEvent item_ = (Rebpower_Rebps_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])boardtemp0_warnHi, (double[])item_.getBoardtemp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_warnLo, (double[])item_.getBoardtemp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitHi, (double[])item_.getBoardtemp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitLo, (double[])item_.getBoardtemp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnHi, (double[])item_.getBoardtemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnLo, (double[])item_.getBoardtemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitHi, (double[])item_.getBoardtemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitLo, (double[])item_.getBoardtemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnHi, (double[])item_.getBoardtemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnLo, (double[])item_.getBoardtemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitHi, (double[])item_.getBoardtemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitLo, (double[])item_.getBoardtemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnHi, (double[])item_.getBoardtemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnLo, (double[])item_.getBoardtemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitHi, (double[])item_.getBoardtemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitLo, (double[])item_.getBoardtemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnHi, (double[])item_.getBoardtemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnLo, (double[])item_.getBoardtemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitHi, (double[])item_.getBoardtemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitLo, (double[])item_.getBoardtemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnHi, (double[])item_.getBoardtemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnLo, (double[])item_.getBoardtemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitHi, (double[])item_.getBoardtemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitLo, (double[])item_.getBoardtemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnHi, (double[])item_.getBoardtemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnLo, (double[])item_.getBoardtemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitHi, (double[])item_.getBoardtemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitLo, (double[])item_.getBoardtemp6_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fpgatemp_warnHi, (double[])item_.getFpgatemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fpgatemp_warnLo, (double[])item_.getFpgatemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fpgatemp_limitHi, (double[])item_.getFpgatemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fpgatemp_limitLo, (double[])item_.getFpgatemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Rebps_PowerConfigurationEvent() throws Exception {
        String version = "t";
        String ipAddr = "";
        String location = "";
        int[] nPowerOnPub = TestHelper.generateIntArray((int)13, (int)-124404247);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_PowerConfigurationEvent(version, ipAddr, location, nPowerOnPub));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_PowerConfigurationEvent));
        Rebpower_Rebps_PowerConfigurationEvent item_ = (Rebpower_Rebps_PowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
    }

    @Test
    public void sendReceiveRebpower_Rebps_buildConfigurationEvent() throws Exception {
        String version = "a";
        String location = "g";
        String switchName = "k";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_buildConfigurationEvent(version, location, switchName));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_buildConfigurationEvent));
        Rebpower_Rebps_buildConfigurationEvent item_ = (Rebpower_Rebps_buildConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)switchName, (Object)item_.getSwitchName());
    }

    @Test
    public void sendReceiveHex_Cold1_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double returntmp_warnHi = 0.7488806247711182;
        double returntmp_warnLo = 0.3368644118309021;
        double returntmp_limitHi = 0.11643165349960327;
        double returntmp_limitLo = 0.25121062994003296;
        double supplytmp_warnHi = 0.08798271417617798;
        double supplytmp_warnLo = 0.5846213102340698;
        double supplytmp_limitHi = 0.48808616399765015;
        double supplytmp_limitLo = 0.1276019811630249;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cold1_LimitsConfigurationEvent(version, returntmp_warnHi, returntmp_warnLo, returntmp_limitHi, returntmp_limitLo, supplytmp_warnHi, supplytmp_warnLo, supplytmp_limitHi, supplytmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1_LimitsConfigurationEvent));
        Hex_Cold1_LimitsConfigurationEvent item_ = (Hex_Cold1_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)returntmp_warnHi, (double)item_.getReturntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_warnLo, (double)item_.getReturntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_limitHi, (double)item_.getReturntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_limitLo, (double)item_.getReturntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnHi, (double)item_.getSupplytmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnLo, (double)item_.getSupplytmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitHi, (double)item_.getSupplytmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitLo, (double)item_.getSupplytmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double returntmp_warnHi = 0.10613560676574707;
        double returntmp_warnLo = 0.3082171082496643;
        double returntmp_limitHi = 0.9318339228630066;
        double returntmp_limitLo = 0.8321828842163086;
        double supplytmp_warnHi = 0.5614796280860901;
        double supplytmp_warnLo = 0.24628931283950806;
        double supplytmp_limitHi = 0.9507452249526978;
        double supplytmp_limitLo = 0.3649328351020813;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cold2_LimitsConfigurationEvent(version, returntmp_warnHi, returntmp_warnLo, returntmp_limitHi, returntmp_limitLo, supplytmp_warnHi, supplytmp_warnLo, supplytmp_limitHi, supplytmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2_LimitsConfigurationEvent));
        Hex_Cold2_LimitsConfigurationEvent item_ = (Hex_Cold2_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)returntmp_warnHi, (double)item_.getReturntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_warnLo, (double)item_.getReturntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_limitHi, (double)item_.getReturntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_limitLo, (double)item_.getReturntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnHi, (double)item_.getSupplytmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnLo, (double)item_.getSupplytmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitHi, (double)item_.getSupplytmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitLo, (double)item_.getSupplytmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double c3exittmp_warnHi = 0.38482964038848877;
        double c3exittmp_warnLo = 0.8802147507667542;
        double c3exittmp_limitHi = 0.2488483190536499;
        double c3exittmp_limitLo = 0.4148409366607666;
        double c4exittmp_warnHi = 0.4606884f;
        double c4exittmp_warnLo = 0.6602405309677124;
        double c4exittmp_limitHi = 0.9092357754707336;
        double c4exittmp_limitLo = 0.8978352546691895;
        double evapexittmp_warnHi = 0.50284343957901;
        double evapexittmp_warnLo = 0.21597141027450562;
        double evapexittmp_limitHi = 0.002817809581756592;
        double evapexittmp_limitLo = 0.33124858140945435;
        double hexrtrntmp_warnHi = 0.1895303726196289;
        double hexrtrntmp_warnLo = 0.7303743362426758;
        double hexrtrntmp_limitHi = 0.34034425020217896;
        double hexrtrntmp_limitLo = 0.735842227935791;
        double liquidprs_warnHi = 0.4493151903152466;
        double liquidprs_warnLo = 0.931314f;
        double liquidprs_limitHi = 0.1333240270614624;
        double liquidprs_limitLo = 0.06915563344955444;
        double prec3tmp_warnHi = 0.8116698861122131;
        double prec3tmp_warnLo = 0.8750594854354858;
        double prec3tmp_limitHi = 0.38524436950683594;
        double prec3tmp_limitLo = 0.9800442457199097;
        double prec4tmp_warnHi = 0.28536665439605713;
        double prec4tmp_warnLo = 0.2334151268005371;
        double prec4tmp_limitHi = 0.1388377547264099;
        double prec4tmp_limitLo = 0.5651848912239075;
        double returnprs_warnHi = 0.5733909606933594;
        double returnprs_warnLo = 0.41720718145370483;
        double returnprs_limitHi = 0.26448744535446167;
        double returnprs_limitLo = 0.35695648193359375;
        double vaporprs_warnHi = 0.8900324106216431;
        double vaporprs_warnLo = 0.4097848f;
        double vaporprs_limitHi = 0.2699854373931885;
        double vaporprs_limitLo = 0.3449241f;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo1_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1_LimitsConfigurationEvent));
        Hex_Cryo1_LimitsConfigurationEvent item_ = (Hex_Cryo1_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2_LimitsConfigurationEvent() throws Exception {
        String version = "l";
        double c3exittmp_warnHi = 0.5459582805633545;
        double c3exittmp_warnLo = 0.5232203006744385;
        double c3exittmp_limitHi = 0.690171480178833;
        double c3exittmp_limitLo = 0.10290920734405518;
        double c4exittmp_warnHi = 0.679862916469574;
        double c4exittmp_warnLo = 0.6237860321998596;
        double c4exittmp_limitHi = 0.17658203840255737;
        double c4exittmp_limitLo = 0.7969587445259094;
        double evapexittmp_warnHi = 0.1981566f;
        double evapexittmp_warnLo = 0.2166767716407776;
        double evapexittmp_limitHi = 0.09368312358856201;
        double evapexittmp_limitLo = 0.6079548001289368;
        double hexrtrntmp_warnHi = 0.8828257322311401;
        double hexrtrntmp_warnLo = 0.8750627636909485;
        double hexrtrntmp_limitHi = 0.3472723364830017;
        double hexrtrntmp_limitLo = 0.6027861833572388;
        double liquidprs_warnHi = 0.7847954034805298;
        double liquidprs_warnLo = 0.2713779807090759;
        double liquidprs_limitHi = 0.5309661030769348;
        double liquidprs_limitLo = 0.566125750541687;
        double prec3tmp_warnHi = 0.18084394931793213;
        double prec3tmp_warnLo = 0.8151566982269287;
        double prec3tmp_limitHi = 0.10243260860443115;
        double prec3tmp_limitLo = 0.6225319504737854;
        double prec4tmp_warnHi = 0.02865135669708252;
        double prec4tmp_warnLo = 0.20091331005096436;
        double prec4tmp_limitHi = 0.5535042881965637;
        double prec4tmp_limitLo = 0.216303288936615;
        double returnprs_warnHi = 0.33076733350753784;
        double returnprs_warnLo = 0.21007037162780762;
        double returnprs_limitHi = 0.8211714029312134;
        double returnprs_limitLo = 0.724603533744812;
        double vaporprs_warnHi = 0.1649855375289917;
        double vaporprs_warnLo = 0.524152934551239;
        double vaporprs_limitHi = 0.1386559009552002;
        double vaporprs_limitLo = 0.18888407945632935;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo2_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2_LimitsConfigurationEvent));
        Hex_Cryo2_LimitsConfigurationEvent item_ = (Hex_Cryo2_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3_LimitsConfigurationEvent() throws Exception {
        String version = "o";
        double c3exittmp_warnHi = 0.16918432712554932;
        double c3exittmp_warnLo = 0.4212082624435425;
        double c3exittmp_limitHi = 0.6034871339797974;
        double c3exittmp_limitLo = 0.25848788022994995;
        double c4exittmp_warnHi = 0.20617163181304932;
        double c4exittmp_warnLo = 0.6782745122909546;
        double c4exittmp_limitHi = 0.955681f;
        double c4exittmp_limitLo = 0.3962072f;
        double evapexittmp_warnHi = 0.5218521356582642;
        double evapexittmp_warnLo = 0.1899036169052124;
        double evapexittmp_limitHi = 0.4225732088088989;
        double evapexittmp_limitLo = 0.03787273168563843;
        double hexrtrntmp_warnHi = 0.3646594285964966;
        double hexrtrntmp_warnLo = 0.7142853140830994;
        double hexrtrntmp_limitHi = 0.8675350546836853;
        double hexrtrntmp_limitLo = 0.9096395373344421;
        double liquidprs_warnHi = 0.3596722483634949;
        double liquidprs_warnLo = 0.4937942624092102;
        double liquidprs_limitHi = 0.1310117244720459;
        double liquidprs_limitLo = 0.12645351886749268;
        double prec3tmp_warnHi = 0.0751606822013855;
        double prec3tmp_warnLo = 0.1677112579345703;
        double prec3tmp_limitHi = 0.6396954655647278;
        double prec3tmp_limitLo = 0.8349857330322266;
        double prec4tmp_warnHi = 0.6537532806396484;
        double prec4tmp_warnLo = 0.41739994287490845;
        double prec4tmp_limitHi = 0.9492185115814209;
        double prec4tmp_limitLo = 0.1932897f;
        double returnprs_warnHi = 0.74419766664505;
        double returnprs_warnLo = 0.07167041301727295;
        double returnprs_limitHi = 0.5874601602554321;
        double returnprs_limitLo = 0.592810332775116;
        double vaporprs_warnHi = 0.5374249219894409;
        double vaporprs_warnLo = 0.67213f;
        double vaporprs_limitHi = 0.5862097144126892;
        double vaporprs_limitLo = 0.08965545892715454;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo3_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3_LimitsConfigurationEvent));
        Hex_Cryo3_LimitsConfigurationEvent item_ = (Hex_Cryo3_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4_LimitsConfigurationEvent() throws Exception {
        String version = "k";
        double c3exittmp_warnHi = 0.6225771307945251;
        double c3exittmp_warnLo = 0.4591280221939087;
        double c3exittmp_limitHi = 0.4945831894874573;
        double c3exittmp_limitLo = 0.09346562623977661;
        double c4exittmp_warnHi = 0.11807596683502197;
        double c4exittmp_warnLo = 0.02763331f;
        double c4exittmp_limitHi = 0.9640874862670898;
        double c4exittmp_limitLo = 0.7953070998191833;
        double evapexittmp_warnHi = 0.17072665691375732;
        double evapexittmp_warnLo = 0.6420723795890808;
        double evapexittmp_limitHi = 0.8862138390541077;
        double evapexittmp_limitLo = 0.6513652205467224;
        double hexrtrntmp_warnHi = 0.10997647047042847;
        double hexrtrntmp_warnLo = 0.4971882104873657;
        double hexrtrntmp_limitHi = 0.4016244411468506;
        double hexrtrntmp_limitLo = 0.08052986860275269;
        double liquidprs_warnHi = 0.3799621f;
        double liquidprs_warnLo = 0.5101470947265625;
        double liquidprs_limitHi = 0.8836053609848022;
        double liquidprs_limitLo = 0.426071f;
        double prec3tmp_warnHi = 0.5660336017608643;
        double prec3tmp_warnLo = 0.978637158870697;
        double prec3tmp_limitHi = 0.0295704f;
        double prec3tmp_limitLo = 0.8567120432853699;
        double prec4tmp_warnHi = 0.703027f;
        double prec4tmp_warnLo = 0.11930537223815918;
        double prec4tmp_limitHi = 0.7800835967063904;
        double prec4tmp_limitLo = 0.9634101986885071;
        double returnprs_warnHi = 0.6401426196098328;
        double returnprs_warnLo = 0.00840681791305542;
        double returnprs_limitHi = 0.5613293051719666;
        double returnprs_limitLo = 0.3452872633934021;
        double vaporprs_warnHi = 0.6132214665412903;
        double vaporprs_warnLo = 0.452708f;
        double vaporprs_limitHi = 0.2126712203025818;
        double vaporprs_limitLo = 0.9168487787246704;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo4_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4_LimitsConfigurationEvent));
        Hex_Cryo4_LimitsConfigurationEvent item_ = (Hex_Cryo4_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double c3exittmp_warnHi = 0.4381973147392273;
        double c3exittmp_warnLo = 0.7747090458869934;
        double c3exittmp_limitHi = 0.1645141839981079;
        double c3exittmp_limitLo = 0.296500027179718;
        double c4exittmp_warnHi = 0.3348594903945923;
        double c4exittmp_warnLo = 0.04089456796646118;
        double c4exittmp_limitHi = 0.9079667925834656;
        double c4exittmp_limitLo = 0.26252996921539307;
        double evapexittmp_warnHi = 0.7911467552185059;
        double evapexittmp_warnLo = 0.5862413048744202;
        double evapexittmp_limitHi = 0.19596493244171143;
        double evapexittmp_limitLo = 0.6517412066459656;
        double hexrtrntmp_warnHi = 0.8109247088432312;
        double hexrtrntmp_warnLo = 0.5020307898521423;
        double hexrtrntmp_limitHi = 0.09269309043884277;
        double hexrtrntmp_limitLo = 0.7096713781356812;
        double liquidprs_warnHi = 0.4633186459541321;
        double liquidprs_warnLo = 0.610880970954895;
        double liquidprs_limitHi = 0.2357664704322815;
        double liquidprs_limitLo = 0.8266355991363525;
        double prec3tmp_warnHi = 0.8923792243003845;
        double prec3tmp_warnLo = 0.7904093265533447;
        double prec3tmp_limitHi = 0.007546544075012207;
        double prec3tmp_limitLo = 0.02032071352005005;
        double prec4tmp_warnHi = 0.1448100209236145;
        double prec4tmp_warnLo = 0.6774519681930542;
        double prec4tmp_limitHi = 0.9350197315216064;
        double prec4tmp_limitLo = 0.8183979392051697;
        double returnprs_warnHi = 0.9617493748664856;
        double returnprs_warnLo = 0.3929516673088074;
        double returnprs_limitHi = 0.8882981538772583;
        double returnprs_limitLo = 0.9426085352897644;
        double vaporprs_warnHi = 0.2420047f;
        double vaporprs_warnLo = 0.6579023599624634;
        double vaporprs_limitHi = 0.792611f;
        double vaporprs_limitLo = 0.3765166401863098;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo5_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5_LimitsConfigurationEvent));
        Hex_Cryo5_LimitsConfigurationEvent item_ = (Hex_Cryo5_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6_LimitsConfigurationEvent() throws Exception {
        String version = "p";
        double c3exittmp_warnHi = 0.8028817176818848;
        double c3exittmp_warnLo = 0.17002063989639282;
        double c3exittmp_limitHi = 0.2709732f;
        double c3exittmp_limitLo = 0.012377262115478516;
        double c4exittmp_warnHi = 0.2536681294441223;
        double c4exittmp_warnLo = 0.5590114593505859;
        double c4exittmp_limitHi = 0.17061054706573486;
        double c4exittmp_limitLo = 0.13917946815490723;
        double evapexittmp_warnHi = 0.6210432052612305;
        double evapexittmp_warnLo = 0.10065692663192749;
        double evapexittmp_limitHi = 0.1617475152015686;
        double evapexittmp_limitLo = 0.6523122191429138;
        double hexrtrntmp_warnHi = 0.2882046699523926;
        double hexrtrntmp_warnLo = 0.8141778707504272;
        double hexrtrntmp_limitHi = 0.0724054f;
        double hexrtrntmp_limitLo = 0.9226796627044678;
        double liquidprs_warnHi = 0.055135905742645264;
        double liquidprs_warnLo = 0.12229812145233154;
        double liquidprs_limitHi = 0.16417354345321655;
        double liquidprs_limitLo = 0.0801962f;
        double prec3tmp_warnHi = 0.17703211307525635;
        double prec3tmp_warnLo = 0.38655567169189453;
        double prec3tmp_limitHi = 0.404455304145813;
        double prec3tmp_limitLo = 0.9292687773704529;
        double prec4tmp_warnHi = 0.7496299147605896;
        double prec4tmp_warnLo = 0.27523887157440186;
        double prec4tmp_limitHi = 0.5782743096351624;
        double prec4tmp_limitLo = 0.27734827995300293;
        double returnprs_warnHi = 0.6158115863800049;
        double returnprs_warnLo = 0.1788643f;
        double returnprs_limitHi = 0.4409077763557434;
        double returnprs_limitLo = 0.9314776659011841;
        double vaporprs_warnHi = 0.6713199019432068;
        double vaporprs_warnLo = 0.5559794902801514;
        double vaporprs_limitHi = 0.8455294370651245;
        double vaporprs_limitLo = 0.479996919631958;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo6_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6_LimitsConfigurationEvent));
        Hex_Cryo6_LimitsConfigurationEvent item_ = (Hex_Cryo6_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_GeneralConfigurationEvent() throws Exception {
        String version = "w";
        double lowCryoTempLimit = 0.7073533535003662;
        double rtnToEvapOffset = 0.1218177080154419;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_GeneralConfigurationEvent(version, lowCryoTempLimit, rtnToEvapOffset));
        Assert.assertTrue((boolean)(item instanceof Hex_GeneralConfigurationEvent));
        Hex_GeneralConfigurationEvent item_ = (Hex_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)lowCryoTempLimit, (double)item_.getLowCryoTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)rtnToEvapOffset, (double)item_.getRtnToEvapOffset(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Maq20_DeviceConfigurationEvent() throws Exception {
        String version = "a";
        String node = "r";
        String serials = "j";
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Maq20_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Hex_Maq20_DeviceConfigurationEvent));
        Hex_Maq20_DeviceConfigurationEvent item_ = (Hex_Maq20_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveHex_Maq20_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Maq20_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Hex_Maq20_DevicesConfigurationEvent));
        Hex_Maq20_DevicesConfigurationEvent item_ = (Hex_Maq20_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveHex_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "r";
        int schedulers_default_nTasks = 749;
        int schedulers_default_nThreads = 842;
        int schedulers_monitor_check_scheduler_nTasks = 895;
        int schedulers_monitor_check_scheduler_nThreads = 798;
        int schedulers_monitor_update_publish_scheduler_nTasks = 949;
        int schedulers_monitor_update_publish_scheduler_nThreads = 961;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Hex_PeriodicTasks_GeneralConfigurationEvent));
        Hex_PeriodicTasks_GeneralConfigurationEvent item_ = (Hex_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveHex_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "z";
        long agentmonitorservice_taskPeriodMillis = 746L;
        long heartbeat_taskPeriodMillis = 600L;
        long hex_state_taskPeriodMillis = 477L;
        long maq20_check_status_taskPeriodMillis = 521L;
        long monitor_check_Maq20_taskPeriodMillis = 202L;
        long monitor_publish_Maq20_taskPeriodMillis = 834L;
        long monitor_update_Maq20_taskPeriodMillis = 462L;
        long runtimeinfo_taskPeriodMillis = 550L;
        long temp_check_taskPeriodMillis = 659L;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, hex_state_taskPeriodMillis, maq20_check_status_taskPeriodMillis, monitor_check_Maq20_taskPeriodMillis, monitor_publish_Maq20_taskPeriodMillis, monitor_update_Maq20_taskPeriodMillis, runtimeinfo_taskPeriodMillis, temp_check_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Hex_PeriodicTasks_timersConfigurationEvent));
        Hex_PeriodicTasks_timersConfigurationEvent item_ = (Hex_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)hex_state_taskPeriodMillis, (long)item_.getHex_state_taskPeriodMillis());
        Assert.assertEquals((long)maq20_check_status_taskPeriodMillis, (long)item_.getMaq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)temp_check_taskPeriodMillis, (long)item_.getTemp_check_taskPeriodMillis());
    }

    @Test
    public void sendReceiveHex_StatusAggregator_GeneralConfigurationEvent() throws Exception {
        String version = "k";
        String patternConfigList = "";
        SALEvent item = this.testSendReceive((SALEvent)new Hex_StatusAggregator_GeneralConfigurationEvent(version, patternConfigList));
        Assert.assertTrue((boolean)(item instanceof Hex_StatusAggregator_GeneralConfigurationEvent));
        Hex_StatusAggregator_GeneralConfigurationEvent item_ = (Hex_StatusAggregator_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)patternConfigList, (Object)item_.getPatternConfigList());
    }

    @Test
    public void sendReceiveRefrig_Cryo1_DeviceConfigurationEvent() throws Exception {
        String version = "x";
        String maq20_node = "";
        String maq20_serials = "w";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_DeviceConfigurationEvent));
        Refrig_Cryo1_DeviceConfigurationEvent item_ = (Refrig_Cryo1_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo1_DevicesConfigurationEvent() throws Exception {
        String version = "e";
        boolean maq20_disabled = true;
        boolean plc_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_DevicesConfigurationEvent));
        Refrig_Cryo1_DevicesConfigurationEvent item_ = (Refrig_Cryo1_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo1_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.626501202583313;
        double aftercooltmp_warnLo = 0.999459f;
        double aftercooltmp_limitHi = 0.9808174967765808;
        double aftercooltmp_limitLo = 0.8505963683128357;
        double compcurrent_warnHi = 0.8351826071739197;
        double compcurrent_warnLo = 0.7829119563102722;
        double compcurrent_limitHi = 0.9551782011985779;
        double compcurrent_limitLo = 0.8803683519363403;
        double comppower_warnHi = 0.9467967748641968;
        double comppower_warnLo = 0.05507081747055054;
        double comppower_limitHi = 0.37750154733657837;
        double comppower_limitLo = 0.32929152250289917;
        double compvoltage_warnHi = 0.6068287491798401;
        double compvoltage_warnLo = 0.19070512056350708;
        double compvoltage_limitHi = 0.9657025337219238;
        double compvoltage_limitLo = 0.811535120010376;
        double dischrgprs_warnHi = 0.839469f;
        double dischrgprs_warnLo = 0.6548264026641846;
        double dischrgprs_limitHi = 0.3849772810935974;
        double dischrgprs_limitLo = 0.2369445562362671;
        double dischrgtmp_M_warnHi = 0.060768187046051025;
        double dischrgtmp_M_warnLo = 0.947840690612793;
        double dischrgtmp_M_limitHi = 0.9907975792884827;
        double dischrgtmp_M_limitLo = 0.3677181005477905;
        double dischrgtmp_P_warnHi = 0.1419163942337036;
        double dischrgtmp_P_warnLo = 0.23200958967208862;
        double dischrgtmp_P_limitHi = 0.621763288974762;
        double dischrgtmp_P_limitLo = 0.1554107666015625;
        double fanspeed_warnHi = 0.5610649585723877;
        double fanspeed_warnLo = 0.37559783458709717;
        double fanspeed_limitHi = 0.32896852493286133;
        double fanspeed_limitLo = 0.8055156469345093;
        double oillevel_warnHi = 0.08459645509719849;
        double oillevel_warnLo = 0.33248448371887207;
        double oillevel_limitHi = 0.5507811307907104;
        double oillevel_limitLo = 0.9486668705940247;
        double oilseptmp_warnHi = 0.6936050653457642;
        double oilseptmp_warnLo = 0.5140964984893799;
        double oilseptmp_limitHi = 0.7448531985282898;
        double oilseptmp_limitLo = 0.941771388053894;
        double phaseseptmp_warnHi = 0.7484720349311829;
        double phaseseptmp_warnLo = 0.7645028829574585;
        double phaseseptmp_limitHi = 0.010468602180480957;
        double phaseseptmp_limitLo = 0.6878884434700012;
        double suctionprs_warnHi = 0.6218031644821167;
        double suctionprs_warnLo = 0.6412501335144043;
        double suctionprs_limitHi = 0.8648171424865723;
        double suctionprs_limitLo = 0.8498541712760925;
        double suctiontmp_M_warnHi = 0.26377958059310913;
        double suctiontmp_M_warnLo = 0.3724910616874695;
        double suctiontmp_M_limitHi = 0.37040263414382935;
        double suctiontmp_M_limitLo = 0.47953593730926514;
        double suctiontmp_P_warnHi = 0.7584148049354553;
        double suctiontmp_P_warnLo = 0.3092666268348694;
        double suctiontmp_P_limitHi = 0.9946192502975464;
        double suctiontmp_P_limitLo = 0.8228532075881958;
        double surgetanktmp_warnHi = 0.8266887664794922;
        double surgetanktmp_warnLo = 0.140167236328125;
        double surgetanktmp_limitHi = 0.36675918102264404;
        double surgetanktmp_limitLo = 0.9616162776947021;
        double waterintmp_warnHi = 0.20355886220932007;
        double waterintmp_warnLo = 0.06938314437866211;
        double waterintmp_limitHi = 0.885668f;
        double waterintmp_limitLo = 0.4787197709083557;
        double waterouttmp_warnHi = 0.7090548872947693;
        double waterouttmp_warnLo = 0.5793200731277466;
        double waterouttmp_limitHi = 0.5293838381767273;
        double waterouttmp_limitLo = 0.0858263373374939;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_LimitsConfigurationEvent));
        Refrig_Cryo1_LimitsConfigurationEvent item_ = (Refrig_Cryo1_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2_DeviceConfigurationEvent() throws Exception {
        String version = "h";
        String maq20_node = "";
        String maq20_serials = "";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_DeviceConfigurationEvent));
        Refrig_Cryo2_DeviceConfigurationEvent item_ = (Refrig_Cryo2_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo2_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean maq20_disabled = false;
        boolean plc_disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_DevicesConfigurationEvent));
        Refrig_Cryo2_DevicesConfigurationEvent item_ = (Refrig_Cryo2_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo2_LimitsConfigurationEvent() throws Exception {
        String version = "p";
        double aftercooltmp_warnHi = 0.07759493589401245;
        double aftercooltmp_warnLo = 0.2796071767807007;
        double aftercooltmp_limitHi = 0.25997406244277954;
        double aftercooltmp_limitLo = 0.21378272771835327;
        double compcurrent_warnHi = 0.7095667123794556;
        double compcurrent_warnLo = 0.2569117546081543;
        double compcurrent_limitHi = 0.8244872093200684;
        double compcurrent_limitLo = 0.5943259000778198;
        double comppower_warnHi = 0.4248991012573242;
        double comppower_warnLo = 0.5343916416168213;
        double comppower_limitHi = 0.7275944948196411;
        double comppower_limitLo = 0.8179831504821777;
        double compvoltage_warnHi = 0.7096013426780701;
        double compvoltage_warnLo = 0.2837026119232178;
        double compvoltage_limitHi = 0.7916221618652344;
        double compvoltage_limitLo = 0.10853838920593262;
        double dischrgprs_warnHi = 0.6353712677955627;
        double dischrgprs_warnLo = 0.8158840537071228;
        double dischrgprs_limitHi = 0.15866601467132568;
        double dischrgprs_limitLo = 0.58169f;
        double dischrgtmp_M_warnHi = 0.9305132627487183;
        double dischrgtmp_M_warnLo = 0.49988818168640137;
        double dischrgtmp_M_limitHi = 0.9259874224662781;
        double dischrgtmp_M_limitLo = 0.7411353588104248;
        double dischrgtmp_P_warnHi = 0.370410680770874;
        double dischrgtmp_P_warnLo = 0.4273747205734253;
        double dischrgtmp_P_limitHi = 0.11232644319534302;
        double dischrgtmp_P_limitLo = 0.11544859409332275;
        double fanspeed_warnHi = 0.531707f;
        double fanspeed_warnLo = 0.3855026960372925;
        double fanspeed_limitHi = 0.12662345170974731;
        double fanspeed_limitLo = 0.55040442943573;
        double oillevel_warnHi = 0.4334644079208374;
        double oillevel_warnLo = 0.18660622835159302;
        double oillevel_limitHi = 0.7508691549301147;
        double oillevel_limitLo = 0.941911518573761;
        double oilseptmp_warnHi = 0.798945963382721;
        double oilseptmp_warnLo = 0.3171289563179016;
        double oilseptmp_limitHi = 0.3028132915496826;
        double oilseptmp_limitLo = 0.6361914873123169;
        double phaseseptmp_warnHi = 0.610375702381134;
        double phaseseptmp_warnLo = 0.38867151737213135;
        double phaseseptmp_limitHi = 0.3044389f;
        double phaseseptmp_limitLo = 0.8059951663017273;
        double suctionprs_warnHi = 0.996269166469574;
        double suctionprs_warnLo = 0.8227730989456177;
        double suctionprs_limitHi = 0.6689545512199402;
        double suctionprs_limitLo = 0.5698431730270386;
        double suctiontmp_M_warnHi = 0.9400115013122559;
        double suctiontmp_M_warnLo = 0.2900077f;
        double suctiontmp_M_limitHi = 0.23121285438537598;
        double suctiontmp_M_limitLo = 0.706488f;
        double suctiontmp_P_warnHi = 0.685739f;
        double suctiontmp_P_warnLo = 0.5056788325309753;
        double suctiontmp_P_limitHi = 0.810676f;
        double suctiontmp_P_limitLo = 0.545616090297699;
        double surgetanktmp_warnHi = 0.35282236337661743;
        double surgetanktmp_warnLo = 0.30199337005615234;
        double surgetanktmp_limitHi = 0.9172133803367615;
        double surgetanktmp_limitLo = 0.02047944f;
        double waterintmp_warnHi = 0.1660524f;
        double waterintmp_warnLo = 0.3338874578475952;
        double waterintmp_limitHi = 0.521131f;
        double waterintmp_limitLo = 0.2465037703514099;
        double waterouttmp_warnHi = 0.830807626247406;
        double waterouttmp_warnLo = 0.10707056522369385;
        double waterouttmp_limitHi = 0.9210320711135864;
        double waterouttmp_limitLo = 0.1554531455039978;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_LimitsConfigurationEvent));
        Refrig_Cryo2_LimitsConfigurationEvent item_ = (Refrig_Cryo2_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "";
        String maq20_serials = "z";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_DeviceConfigurationEvent));
        Refrig_Cryo3_DeviceConfigurationEvent item_ = (Refrig_Cryo3_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo3_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean maq20_disabled = true;
        boolean plc_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_DevicesConfigurationEvent));
        Refrig_Cryo3_DevicesConfigurationEvent item_ = (Refrig_Cryo3_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo3_LimitsConfigurationEvent() throws Exception {
        String version = "u";
        double aftercooltmp_warnHi = 0.06850481033325195;
        double aftercooltmp_warnLo = 0.8819335699081421;
        double aftercooltmp_limitHi = 0.5103369355201721;
        double aftercooltmp_limitLo = 0.5715826153755188;
        double ambienttmp_warnHi = 0.8169936537742615;
        double ambienttmp_warnLo = 0.1390208601951599;
        double ambienttmp_limitHi = 0.779719f;
        double ambienttmp_limitLo = 0.9887209534645081;
        double cabinettmp_warnHi = 0.277072012424469;
        double cabinettmp_warnLo = 0.915184736251831;
        double cabinettmp_limitHi = 0.538340151309967;
        double cabinettmp_limitLo = 0.42300945520401;
        double compcurrent_warnHi = 0.6953703761100769;
        double compcurrent_warnLo = 0.9652260541915894;
        double compcurrent_limitHi = 0.14212846755981445;
        double compcurrent_limitLo = 0.733724f;
        double comppower_warnHi = 0.6471393704414368;
        double comppower_warnLo = 0.9887987971305847;
        double comppower_limitHi = 0.9968788623809814;
        double comppower_limitLo = 0.8430869579315186;
        double compvoltage_warnHi = 0.3988179f;
        double compvoltage_warnLo = 0.4897953271865845;
        double compvoltage_limitHi = 0.26867908239364624;
        double compvoltage_limitLo = 0.8790637850761414;
        double dischrgprs_warnHi = 0.2067958116531372;
        double dischrgprs_warnLo = 0.8197957873344421;
        double dischrgprs_limitHi = 0.5233194828033447;
        double dischrgprs_limitLo = 0.4429087f;
        double dischrgtmp_M_warnHi = 0.07633805274963379;
        double dischrgtmp_M_warnLo = 0.021564245223999023;
        double dischrgtmp_M_limitHi = 0.1617315411567688;
        double dischrgtmp_M_limitLo = 0.0942736268043518;
        double dischrgtmp_P_warnHi = 0.15730106830596924;
        double dischrgtmp_P_warnLo = 0.3211820721626282;
        double dischrgtmp_P_limitHi = 0.87872f;
        double dischrgtmp_P_limitLo = 0.04913193f;
        double fanspeed_warnHi = 0.9343748688697815;
        double fanspeed_warnLo = 0.11765807867050171;
        double fanspeed_limitHi = 0.9988874793052673;
        double fanspeed_limitLo = 0.7465725541114807;
        double oillevel_warnHi = 0.3558666706085205;
        double oillevel_warnLo = 0.3533428907394409;
        double oillevel_limitHi = 0.996278703212738;
        double oillevel_limitLo = 0.8528434634208679;
        double oilseptmp_warnHi = 0.291401743888855;
        double oilseptmp_warnLo = 0.4994316101074219;
        double oilseptmp_limitHi = 0.04557693004608154;
        double oilseptmp_limitLo = 0.5686679482460022;
        double phaseseptmp_warnHi = 0.2983502149581909;
        double phaseseptmp_warnLo = 0.6061123609542847;
        double phaseseptmp_limitHi = 0.2985035181045532;
        double phaseseptmp_limitLo = 0.813226f;
        double suctionprs_warnHi = 0.7704379558563232;
        double suctionprs_warnLo = 0.009990692138671875;
        double suctionprs_limitHi = 0.14833104610443115;
        double suctionprs_limitLo = 0.14033353328704834;
        double suctiontmp_M_warnHi = 0.6291144490242004;
        double suctiontmp_M_warnLo = 0.19138479232788086;
        double suctiontmp_M_limitHi = 0.910206f;
        double suctiontmp_M_limitLo = 0.6549215912818909;
        double suctiontmp_P_warnHi = 0.8662184476852417;
        double suctiontmp_P_warnLo = 0.7756784558296204;
        double suctiontmp_P_limitHi = 0.6804755330085754;
        double suctiontmp_P_limitLo = 0.9372109174728394;
        double surgetanktmp_warnHi = 0.3508124351501465;
        double surgetanktmp_warnLo = 0.8864843845367432;
        double surgetanktmp_limitHi = 0.1727469563484192;
        double surgetanktmp_limitLo = 0.13490456342697144;
        double waterintmp_warnHi = 0.3473753333091736;
        double waterintmp_warnLo = 0.6098875999450684;
        double waterintmp_limitHi = 0.7934238314628601;
        double waterintmp_limitLo = 0.1778220534324646;
        double waterouttmp_warnHi = 0.4586156f;
        double waterouttmp_warnLo = 0.6101097464561462;
        double waterouttmp_limitHi = 0.299530029296875;
        double waterouttmp_limitLo = 0.12283968925476074;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_LimitsConfigurationEvent));
        Refrig_Cryo3_LimitsConfigurationEvent item_ = (Refrig_Cryo3_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3_PicConfigurationEvent() throws Exception {
        String version = "";
        double fanctrl_awGain = 0.35478538274765015;
        double fanctrl_baseDuty = 0.9644457697868347;
        double fanctrl_gain = 0.20856934785842896;
        double fanctrl_maxInput = 0.6814109086990356;
        double fanctrl_maxOutput = 0.6355234384536743;
        double fanctrl_minInput = 0.10355937480926514;
        double fanctrl_minOutput = 0.4383151f;
        double fanctrl_setTemp = 0.9260600805282593;
        double fanctrl_smoothTime = 0.295015811920166;
        double fanctrl_timeConst = 0.12573248147964478;
        double fanctrl_tolerance = 0.7065396308898926;
        boolean fanctrl_useAbsTemp = false;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_PicConfigurationEvent(version, fanctrl_awGain, fanctrl_baseDuty, fanctrl_gain, fanctrl_maxInput, fanctrl_maxOutput, fanctrl_minInput, fanctrl_minOutput, fanctrl_setTemp, fanctrl_smoothTime, fanctrl_timeConst, fanctrl_tolerance, fanctrl_useAbsTemp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_PicConfigurationEvent));
        Refrig_Cryo3_PicConfigurationEvent item_ = (Refrig_Cryo3_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)fanctrl_awGain, (double)item_.getFanctrl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_baseDuty, (double)item_.getFanctrl_baseDuty(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_gain, (double)item_.getFanctrl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxInput, (double)item_.getFanctrl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxOutput, (double)item_.getFanctrl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minInput, (double)item_.getFanctrl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minOutput, (double)item_.getFanctrl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_setTemp, (double)item_.getFanctrl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_smoothTime, (double)item_.getFanctrl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_timeConst, (double)item_.getFanctrl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_tolerance, (double)item_.getFanctrl_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((Object)fanctrl_useAbsTemp, (Object)item_.isFanctrl_useAbsTemp());
    }

    @Test
    public void sendReceiveRefrig_Cryo4_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "";
        String maq20_serials = "";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_DeviceConfigurationEvent));
        Refrig_Cryo4_DeviceConfigurationEvent item_ = (Refrig_Cryo4_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo4_DevicesConfigurationEvent() throws Exception {
        String version = "s";
        boolean maq20_disabled = true;
        boolean plc_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_DevicesConfigurationEvent));
        Refrig_Cryo4_DevicesConfigurationEvent item_ = (Refrig_Cryo4_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo4_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.6895899176597595;
        double aftercooltmp_warnLo = 0.855726f;
        double aftercooltmp_limitHi = 0.2652818560600281;
        double aftercooltmp_limitLo = 0.9297782182693481;
        double compcurrent_warnHi = 0.7525027394294739;
        double compcurrent_warnLo = 0.8187400698661804;
        double compcurrent_limitHi = 0.9196393489837646;
        double compcurrent_limitLo = 0.8585658669471741;
        double comppower_warnHi = 0.6897554993629456;
        double comppower_warnLo = 0.7235310673713684;
        double comppower_limitHi = 0.2210521101951599;
        double comppower_limitLo = 8.614659309387207E-4;
        double compvoltage_warnHi = 0.758385f;
        double compvoltage_warnLo = 0.986163318157196;
        double compvoltage_limitHi = 0.8220734000205994;
        double compvoltage_limitLo = 0.2030126452445984;
        double dischrgprs_warnHi = 0.1932382583618164;
        double dischrgprs_warnLo = 0.062367022037506104;
        double dischrgprs_limitHi = 0.7379392981529236;
        double dischrgprs_limitLo = 0.7134362459182739;
        double dischrgtmp_M_warnHi = 0.3505188226699829;
        double dischrgtmp_M_warnLo = 0.09814947843551636;
        double dischrgtmp_M_limitHi = 0.16175276041030884;
        double dischrgtmp_M_limitLo = 0.8024162650108337;
        double dischrgtmp_P_warnHi = 0.8596912026405334;
        double dischrgtmp_P_warnLo = 0.41652631759643555;
        double dischrgtmp_P_limitHi = 0.27237361669540405;
        double dischrgtmp_P_limitLo = 0.9842463135719299;
        double fanspeed_warnHi = 0.8040790557861328;
        double fanspeed_warnLo = 0.344898521900177;
        double fanspeed_limitHi = 0.7289501428604126;
        double fanspeed_limitLo = 0.9045096039772034;
        double oillevel_warnHi = 0.7711588144302368;
        double oillevel_warnLo = 0.22900527715682983;
        double oillevel_limitHi = 0.6242959499359131;
        double oillevel_limitLo = 0.796847939491272;
        double oilseptmp_warnHi = 0.19282597303390503;
        double oilseptmp_warnLo = 0.22758746147155762;
        double oilseptmp_limitHi = 0.4324553608894348;
        double oilseptmp_limitLo = 0.3753041625022888;
        double phaseseptmp_warnHi = 0.16835826635360718;
        double phaseseptmp_warnLo = 0.5050604343414307;
        double phaseseptmp_limitHi = 0.06370240449905396;
        double phaseseptmp_limitLo = 0.7674635052680969;
        double suctionprs_warnHi = 0.06612330675125122;
        double suctionprs_warnLo = 0.24641722440719604;
        double suctionprs_limitHi = 0.4908837676048279;
        double suctionprs_limitLo = 0.5330145359039307;
        double suctiontmp_M_warnHi = 0.7250893115997314;
        double suctiontmp_M_warnLo = 0.9086655378341675;
        double suctiontmp_M_limitHi = 0.5705804228782654;
        double suctiontmp_M_limitLo = 0.3904784321784973;
        double suctiontmp_P_warnHi = 0.3178486227989197;
        double suctiontmp_P_warnLo = 0.8363955616950989;
        double suctiontmp_P_limitHi = 0.01528573f;
        double suctiontmp_P_limitLo = 0.19582092761993408;
        double surgetanktmp_warnHi = 0.6402224898338318;
        double surgetanktmp_warnLo = 0.7362356781959534;
        double surgetanktmp_limitHi = 0.9210574626922607;
        double surgetanktmp_limitLo = 0.2001828f;
        double waterintmp_warnHi = 0.2087729573249817;
        double waterintmp_warnLo = 0.0972716212272644;
        double waterintmp_limitHi = 0.5894113183021545;
        double waterintmp_limitLo = 0.14540356397628784;
        double waterouttmp_warnHi = 0.48003554344177246;
        double waterouttmp_warnLo = 0.9238985776901245;
        double waterouttmp_limitHi = 0.4512117f;
        double waterouttmp_limitLo = 0.33633846044540405;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_LimitsConfigurationEvent));
        Refrig_Cryo4_LimitsConfigurationEvent item_ = (Refrig_Cryo4_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "t";
        String maq20_serials = "";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_DeviceConfigurationEvent));
        Refrig_Cryo5_DeviceConfigurationEvent item_ = (Refrig_Cryo5_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo5_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean maq20_disabled = false;
        boolean plc_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_DevicesConfigurationEvent));
        Refrig_Cryo5_DevicesConfigurationEvent item_ = (Refrig_Cryo5_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo5_LimitsConfigurationEvent() throws Exception {
        String version = "j";
        double aftercooltmp_warnHi = 0.14840304851531982;
        double aftercooltmp_warnLo = 0.5868754982948303;
        double aftercooltmp_limitHi = 0.2468433380126953;
        double aftercooltmp_limitLo = 0.5710065364837646;
        double ambienttmp_warnHi = 0.1229315996170044;
        double ambienttmp_warnLo = 0.36650723218917847;
        double ambienttmp_limitHi = 0.3143569827079773;
        double ambienttmp_limitLo = 0.7865678668022156;
        double cabinettmp_warnHi = 0.7533522248268127;
        double cabinettmp_warnLo = 0.189189612865448;
        double cabinettmp_limitHi = 0.4931233525276184;
        double cabinettmp_limitLo = 0.5774151682853699;
        double compcurrent_warnHi = 0.10885119438171387;
        double compcurrent_warnLo = 0.18275481462478638;
        double compcurrent_limitHi = 0.6625542044639587;
        double compcurrent_limitLo = 0.65358f;
        double comppower_warnHi = 0.4216992259025574;
        double comppower_warnLo = 0.49060964584350586;
        double comppower_limitHi = 0.576188862323761;
        double comppower_limitLo = 0.7076285481452942;
        double compvoltage_warnHi = 0.8091249465942383;
        double compvoltage_warnLo = 0.5208961963653564;
        double compvoltage_limitHi = 0.745803952217102;
        double compvoltage_limitLo = 0.4315042495727539;
        double dischrgprs_warnHi = 0.06382858753204346;
        double dischrgprs_warnLo = 0.44760453701019287;
        double dischrgprs_limitHi = 0.22132503986358643;
        double dischrgprs_limitLo = 0.582874059677124;
        double dischrgtmp_M_warnHi = 0.47678375244140625;
        double dischrgtmp_M_warnLo = 0.9815229177474976;
        double dischrgtmp_M_limitHi = 0.8861351013183594;
        double dischrgtmp_M_limitLo = 0.26060914993286133;
        double dischrgtmp_P_warnHi = 0.40995967388153076;
        double dischrgtmp_P_warnLo = 0.3302185535430908;
        double dischrgtmp_P_limitHi = 0.2610187530517578;
        double dischrgtmp_P_limitLo = 0.540095865726471;
        double fanspeed_warnHi = 0.1026091f;
        double fanspeed_warnLo = 0.4469099f;
        double fanspeed_limitHi = 0.22739005088806152;
        double fanspeed_limitLo = 0.09896194934844971;
        double oillevel_warnHi = 0.5870565176010132;
        double oillevel_warnLo = 0.5822194218635559;
        double oillevel_limitHi = 0.5386918187141418;
        double oillevel_limitLo = 0.6131938695907593;
        double oilseptmp_warnHi = 0.8008796572685242;
        double oilseptmp_warnLo = 0.2701093554496765;
        double oilseptmp_limitHi = 0.18812376260757446;
        double oilseptmp_limitLo = 0.3437894f;
        double phaseseptmp_warnHi = 0.0325050950050354;
        double phaseseptmp_warnLo = 0.9351528882980347;
        double phaseseptmp_limitHi = 0.2944710850715637;
        double phaseseptmp_limitLo = 0.17696022987365723;
        double suctionprs_warnHi = 0.8251739144325256;
        double suctionprs_warnLo = 0.5536596179008484;
        double suctionprs_limitHi = 0.012217521667480469;
        double suctionprs_limitLo = 0.2790037989616394;
        double suctiontmp_M_warnHi = 0.8167297840118408;
        double suctiontmp_M_warnLo = 0.2526538372039795;
        double suctiontmp_M_limitHi = 0.37689924240112305;
        double suctiontmp_M_limitLo = 0.72347092628479;
        double suctiontmp_P_warnHi = 0.7146243453025818;
        double suctiontmp_P_warnLo = 0.4205285906791687;
        double suctiontmp_P_limitHi = 0.9744883179664612;
        double suctiontmp_P_limitLo = 0.8269518613815308;
        double surgetanktmp_warnHi = 0.5299327373504639;
        double surgetanktmp_warnLo = 0.12921392917633057;
        double surgetanktmp_limitHi = 0.8403084874153137;
        double surgetanktmp_limitLo = 0.2651034f;
        double waterintmp_warnHi = 0.2321536f;
        double waterintmp_warnLo = 0.24338674545288086;
        double waterintmp_limitHi = 0.2175209f;
        double waterintmp_limitLo = 0.24748414754867554;
        double waterouttmp_warnHi = 0.3773950934410095;
        double waterouttmp_warnLo = 0.0967077f;
        double waterouttmp_limitHi = 0.3596503f;
        double waterouttmp_limitLo = 0.41401517391204834;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_LimitsConfigurationEvent));
        Refrig_Cryo5_LimitsConfigurationEvent item_ = (Refrig_Cryo5_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5_PicConfigurationEvent() throws Exception {
        String version = "f";
        double fanctrl_awGain = 0.7711450457572937;
        double fanctrl_baseDuty = 0.6237296462059021;
        double fanctrl_gain = 0.023287057876586914;
        double fanctrl_maxInput = 0.40233057737350464;
        double fanctrl_maxOutput = 0.4228951930999756;
        double fanctrl_minInput = 0.2748332f;
        double fanctrl_minOutput = 0.30031102895736694;
        double fanctrl_setTemp = 0.6927521824836731;
        double fanctrl_smoothTime = 0.037424683570861816;
        double fanctrl_timeConst = 0.2015022f;
        double fanctrl_tolerance = 0.024693548679351807;
        boolean fanctrl_useAbsTemp = true;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_PicConfigurationEvent(version, fanctrl_awGain, fanctrl_baseDuty, fanctrl_gain, fanctrl_maxInput, fanctrl_maxOutput, fanctrl_minInput, fanctrl_minOutput, fanctrl_setTemp, fanctrl_smoothTime, fanctrl_timeConst, fanctrl_tolerance, fanctrl_useAbsTemp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_PicConfigurationEvent));
        Refrig_Cryo5_PicConfigurationEvent item_ = (Refrig_Cryo5_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)fanctrl_awGain, (double)item_.getFanctrl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_baseDuty, (double)item_.getFanctrl_baseDuty(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_gain, (double)item_.getFanctrl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxInput, (double)item_.getFanctrl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxOutput, (double)item_.getFanctrl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minInput, (double)item_.getFanctrl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minOutput, (double)item_.getFanctrl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_setTemp, (double)item_.getFanctrl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_smoothTime, (double)item_.getFanctrl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_timeConst, (double)item_.getFanctrl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_tolerance, (double)item_.getFanctrl_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((Object)fanctrl_useAbsTemp, (Object)item_.isFanctrl_useAbsTemp());
    }

    @Test
    public void sendReceiveRefrig_Cryo6_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "p";
        String maq20_serials = "";
        String plc_node = "y";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_DeviceConfigurationEvent));
        Refrig_Cryo6_DeviceConfigurationEvent item_ = (Refrig_Cryo6_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo6_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean maq20_disabled = true;
        boolean plc_disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_DevicesConfigurationEvent));
        Refrig_Cryo6_DevicesConfigurationEvent item_ = (Refrig_Cryo6_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo6_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.08731728792190552;
        double aftercooltmp_warnLo = 0.9066471457481384;
        double aftercooltmp_limitHi = 0.7543467879295349;
        double aftercooltmp_limitLo = 0.6659121513366699;
        double compcurrent_warnHi = 0.03457885980606079;
        double compcurrent_warnLo = 0.012080729007720947;
        double compcurrent_limitHi = 0.1956343650817871;
        double compcurrent_limitLo = 0.1312609314918518;
        double comppower_warnHi = 0.17674553394317627;
        double comppower_warnLo = 0.1836094856262207;
        double comppower_limitHi = 0.6274861693382263;
        double comppower_limitLo = 0.4388948678970337;
        double compvoltage_warnHi = 0.9913501739501953;
        double compvoltage_warnLo = 0.27084267139434814;
        double compvoltage_limitHi = 0.18169403076171875;
        double compvoltage_limitLo = 0.09214985370635986;
        double dischrgprs_warnHi = 0.4011055827140808;
        double dischrgprs_warnLo = 0.017182588577270508;
        double dischrgprs_limitHi = 0.568577766418457;
        double dischrgprs_limitLo = 0.2997971177101135;
        double dischrgtmp_M_warnHi = 0.03229391574859619;
        double dischrgtmp_M_warnLo = 0.46688413619995117;
        double dischrgtmp_M_limitHi = 0.9947351813316345;
        double dischrgtmp_M_limitLo = 0.6388403177261353;
        double dischrgtmp_P_warnHi = 0.6264894604682922;
        double dischrgtmp_P_warnLo = 0.5283551812171936;
        double dischrgtmp_P_limitHi = 0.18395566940307617;
        double dischrgtmp_P_limitLo = 0.1932077407836914;
        double fanspeed_warnHi = 0.6003178954124451;
        double fanspeed_warnLo = 0.6415472626686096;
        double fanspeed_limitHi = 0.8836649656295776;
        double fanspeed_limitLo = 0.6872890591621399;
        double oillevel_warnHi = 0.26738274097442627;
        double oillevel_warnLo = 0.05051279067993164;
        double oillevel_limitHi = 0.5155674815177917;
        double oillevel_limitLo = 0.4818124771118164;
        double oilseptmp_warnHi = 0.5618872046470642;
        double oilseptmp_warnLo = 0.05482828617095947;
        double oilseptmp_limitHi = 0.8134623169898987;
        double oilseptmp_limitLo = 0.8410322666168213;
        double phaseseptmp_warnHi = 0.3022293448448181;
        double phaseseptmp_warnLo = 0.6503296494483948;
        double phaseseptmp_limitHi = 0.9587438702583313;
        double phaseseptmp_limitLo = 0.8108999133110046;
        double suctionprs_warnHi = 4.579425E-4f;
        double suctionprs_warnLo = 0.28082817792892456;
        double suctionprs_limitHi = 0.4031602740287781;
        double suctionprs_limitLo = 0.4547199010848999;
        double suctiontmp_M_warnHi = 0.9335781931877136;
        double suctiontmp_M_warnLo = 0.6341502070426941;
        double suctiontmp_M_limitHi = 0.9904511570930481;
        double suctiontmp_M_limitLo = 0.30330485105514526;
        double suctiontmp_P_warnHi = 0.9470493793487549;
        double suctiontmp_P_warnLo = 0.9195677042007446;
        double suctiontmp_P_limitHi = 0.3380838632583618;
        double suctiontmp_P_limitLo = 0.3089866042137146;
        double surgetanktmp_warnHi = 0.1393022f;
        double surgetanktmp_warnLo = 0.2666983f;
        double surgetanktmp_limitHi = 0.605151891708374;
        double surgetanktmp_limitLo = 0.6058160662651062;
        double waterintmp_warnHi = 0.8867303133010864;
        double waterintmp_warnLo = 0.4610862731933594;
        double waterintmp_limitHi = 0.5934098958969116;
        double waterintmp_limitLo = 0.12129944562911987;
        double waterouttmp_warnHi = 0.3975124955177307;
        double waterouttmp_warnLo = 0.36742645502090454;
        double waterouttmp_limitHi = 0.6493446826934814;
        double waterouttmp_limitLo = 0.8481138944625854;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_LimitsConfigurationEvent));
        Refrig_Cryo6_LimitsConfigurationEvent item_ = (Refrig_Cryo6_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_CryoCompLimits_CompLimitsConfigurationEvent() throws Exception {
        String version = "";
        double cmprPowerDelayLimit = 0.04184520244598389;
        int cmprPowerDelayTime = 590;
        double cmprPowerImmedLimit = 0.04808610677719116;
        double discPressDelayLimit = 0.8101748824119568;
        double discPressImmedLimit = 0.669546365737915;
        double discTempDelayLimit = 0.6960483193397522;
        int discTempDelayTime = 427;
        double discTempImmedLimit = 0.8209753632545471;
        double discTempLowImmedLimit = 0.3188077211380005;
        double heaterTempLimit = 0.5122677683830261;
        double oilLevelImmedLimit = 0.7953612804412842;
        double orificeOffPress = 0.699066162109375;
        double orificeOnPress = 0.8277574181556702;
        double phaseSepTempDelayLimit = 0.7069417238235474;
        int phaseSepTempDelayTime = 133;
        double pressDiffImmedLimit = 0.33757346868515015;
        double suctTempImmedLimit = 0.4531694f;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_CryoCompLimits_CompLimitsConfigurationEvent(version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, discPressDelayLimit, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, oilLevelImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_CryoCompLimits_CompLimitsConfigurationEvent));
        Refrig_CryoCompLimits_CompLimitsConfigurationEvent item_ = (Refrig_CryoCompLimits_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevelImmedLimit, (double)item_.getOilLevelImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 201;
        int schedulers_default_nThreads = 610;
        int schedulers_monitor_check_scheduler_nTasks = 391;
        int schedulers_monitor_check_scheduler_nThreads = 466;
        int schedulers_monitor_update_publish_scheduler_nTasks = 842;
        int schedulers_monitor_update_publish_scheduler_nThreads = 665;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Refrig_PeriodicTasks_GeneralConfigurationEvent));
        Refrig_PeriodicTasks_GeneralConfigurationEvent item_ = (Refrig_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveRefrig_PeriodicTasks_PicConfigurationEvent() throws Exception {
        String version = "";
        long cryo3_FanCtrl_iterate_updateTime = 161L;
        long cryo5_FanCtrl_iterate_updateTime = 345L;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_PeriodicTasks_PicConfigurationEvent(version, cryo3_FanCtrl_iterate_updateTime, cryo5_FanCtrl_iterate_updateTime));
        Assert.assertTrue((boolean)(item instanceof Refrig_PeriodicTasks_PicConfigurationEvent));
        Refrig_PeriodicTasks_PicConfigurationEvent item_ = (Refrig_PeriodicTasks_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)cryo3_FanCtrl_iterate_updateTime, (long)item_.getCryo3_FanCtrl_iterate_updateTime());
        Assert.assertEquals((long)cryo5_FanCtrl_iterate_updateTime, (long)item_.getCryo5_FanCtrl_iterate_updateTime());
    }

    @Test
    public void sendReceiveRefrig_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 118L;
        long compressor_state_taskPeriodMillis = 189L;
        long cryo1_Maq20_check_status_taskPeriodMillis = 10L;
        long cryo2_Maq20_check_status_taskPeriodMillis = 608L;
        long cryo3_Maq20_check_status_taskPeriodMillis = 125L;
        long cryo4_Maq20_check_status_taskPeriodMillis = 324L;
        long cryo5_Maq20_check_status_taskPeriodMillis = 753L;
        long cryo6_Maq20_check_status_taskPeriodMillis = 435L;
        long heartbeat_taskPeriodMillis = 313L;
        long monitor_check_Cryo1_Maq20_taskPeriodMillis = 325L;
        long monitor_check_Cryo1_Plc_taskPeriodMillis = 604L;
        long monitor_check_Cryo2_Maq20_taskPeriodMillis = 67L;
        long monitor_check_Cryo2_Plc_taskPeriodMillis = 68L;
        long monitor_check_Cryo3_Maq20_taskPeriodMillis = 867L;
        long monitor_check_Cryo3_Plc_taskPeriodMillis = 132L;
        long monitor_check_Cryo4_Maq20_taskPeriodMillis = 591L;
        long monitor_check_Cryo4_Plc_taskPeriodMillis = 161L;
        long monitor_check_Cryo5_Maq20_taskPeriodMillis = 806L;
        long monitor_check_Cryo5_Plc_taskPeriodMillis = 645L;
        long monitor_check_Cryo6_Maq20_taskPeriodMillis = 784L;
        long monitor_check_Cryo6_Plc_taskPeriodMillis = 374L;
        long monitor_publish_Cryo1_Maq20_taskPeriodMillis = 239L;
        long monitor_publish_Cryo1_Plc_taskPeriodMillis = 453L;
        long monitor_publish_Cryo2_Maq20_taskPeriodMillis = 955L;
        long monitor_publish_Cryo2_Plc_taskPeriodMillis = 258L;
        long monitor_publish_Cryo3_Maq20_taskPeriodMillis = 104L;
        long monitor_publish_Cryo3_Plc_taskPeriodMillis = 993L;
        long monitor_publish_Cryo4_Maq20_taskPeriodMillis = 206L;
        long monitor_publish_Cryo4_Plc_taskPeriodMillis = 421L;
        long monitor_publish_Cryo5_Maq20_taskPeriodMillis = 246L;
        long monitor_publish_Cryo5_Plc_taskPeriodMillis = 347L;
        long monitor_publish_Cryo6_Maq20_taskPeriodMillis = 780L;
        long monitor_publish_Cryo6_Plc_taskPeriodMillis = 735L;
        long monitor_update_Cryo1_Maq20_taskPeriodMillis = 989L;
        long monitor_update_Cryo1_Plc_taskPeriodMillis = 232L;
        long monitor_update_Cryo2_Maq20_taskPeriodMillis = 975L;
        long monitor_update_Cryo2_Plc_taskPeriodMillis = 88L;
        long monitor_update_Cryo3_Maq20_taskPeriodMillis = 814L;
        long monitor_update_Cryo3_Plc_taskPeriodMillis = 21L;
        long monitor_update_Cryo4_Maq20_taskPeriodMillis = 609L;
        long monitor_update_Cryo4_Plc_taskPeriodMillis = 703L;
        long monitor_update_Cryo5_Maq20_taskPeriodMillis = 55L;
        long monitor_update_Cryo5_Plc_taskPeriodMillis = 34L;
        long monitor_update_Cryo6_Maq20_taskPeriodMillis = 167L;
        long monitor_update_Cryo6_Plc_taskPeriodMillis = 991L;
        long runtimeinfo_taskPeriodMillis = 639L;
        long update_time_taskPeriodMillis = 975L;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, compressor_state_taskPeriodMillis, cryo1_Maq20_check_status_taskPeriodMillis, cryo2_Maq20_check_status_taskPeriodMillis, cryo3_Maq20_check_status_taskPeriodMillis, cryo4_Maq20_check_status_taskPeriodMillis, cryo5_Maq20_check_status_taskPeriodMillis, cryo6_Maq20_check_status_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_Cryo1_Maq20_taskPeriodMillis, monitor_check_Cryo1_Plc_taskPeriodMillis, monitor_check_Cryo2_Maq20_taskPeriodMillis, monitor_check_Cryo2_Plc_taskPeriodMillis, monitor_check_Cryo3_Maq20_taskPeriodMillis, monitor_check_Cryo3_Plc_taskPeriodMillis, monitor_check_Cryo4_Maq20_taskPeriodMillis, monitor_check_Cryo4_Plc_taskPeriodMillis, monitor_check_Cryo5_Maq20_taskPeriodMillis, monitor_check_Cryo5_Plc_taskPeriodMillis, monitor_check_Cryo6_Maq20_taskPeriodMillis, monitor_check_Cryo6_Plc_taskPeriodMillis, monitor_publish_Cryo1_Maq20_taskPeriodMillis, monitor_publish_Cryo1_Plc_taskPeriodMillis, monitor_publish_Cryo2_Maq20_taskPeriodMillis, monitor_publish_Cryo2_Plc_taskPeriodMillis, monitor_publish_Cryo3_Maq20_taskPeriodMillis, monitor_publish_Cryo3_Plc_taskPeriodMillis, monitor_publish_Cryo4_Maq20_taskPeriodMillis, monitor_publish_Cryo4_Plc_taskPeriodMillis, monitor_publish_Cryo5_Maq20_taskPeriodMillis, monitor_publish_Cryo5_Plc_taskPeriodMillis, monitor_publish_Cryo6_Maq20_taskPeriodMillis, monitor_publish_Cryo6_Plc_taskPeriodMillis, monitor_update_Cryo1_Maq20_taskPeriodMillis, monitor_update_Cryo1_Plc_taskPeriodMillis, monitor_update_Cryo2_Maq20_taskPeriodMillis, monitor_update_Cryo2_Plc_taskPeriodMillis, monitor_update_Cryo3_Maq20_taskPeriodMillis, monitor_update_Cryo3_Plc_taskPeriodMillis, monitor_update_Cryo4_Maq20_taskPeriodMillis, monitor_update_Cryo4_Plc_taskPeriodMillis, monitor_update_Cryo5_Maq20_taskPeriodMillis, monitor_update_Cryo5_Plc_taskPeriodMillis, monitor_update_Cryo6_Maq20_taskPeriodMillis, monitor_update_Cryo6_Plc_taskPeriodMillis, runtimeinfo_taskPeriodMillis, update_time_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Refrig_PeriodicTasks_timersConfigurationEvent));
        Refrig_PeriodicTasks_timersConfigurationEvent item_ = (Refrig_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)compressor_state_taskPeriodMillis, (long)item_.getCompressor_state_taskPeriodMillis());
        Assert.assertEquals((long)cryo1_Maq20_check_status_taskPeriodMillis, (long)item_.getCryo1_Maq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)cryo2_Maq20_check_status_taskPeriodMillis, (long)item_.getCryo2_Maq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)cryo3_Maq20_check_status_taskPeriodMillis, (long)item_.getCryo3_Maq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)cryo4_Maq20_check_status_taskPeriodMillis, (long)item_.getCryo4_Maq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)cryo5_Maq20_check_status_taskPeriodMillis, (long)item_.getCryo5_Maq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)cryo6_Maq20_check_status_taskPeriodMillis, (long)item_.getCryo6_Maq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo1_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo1_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo1_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo1_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo2_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo2_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo2_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo2_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo3_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo3_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo3_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo3_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo4_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo4_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo4_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo4_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo5_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo5_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo5_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo5_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo6_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo6_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo6_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo6_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo1_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo1_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo1_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo1_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo2_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo2_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo2_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo2_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo3_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo3_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo3_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo3_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo4_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo4_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo4_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo4_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo5_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo5_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo5_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo5_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo6_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo6_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo6_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo6_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo1_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo1_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo1_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo1_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo2_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo2_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo2_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo2_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo3_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo3_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo3_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo3_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo4_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo4_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo4_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo4_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo5_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo5_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo5_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo5_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo6_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo6_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo6_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo6_Plc_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)update_time_taskPeriodMillis, (long)item_.getUpdate_time_taskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_Cip_LimitsConfigurationEvent() throws Exception {
        String version = "d";
        double[] cryo_I_warnHi = TestHelper.generateDoubleArray((int)6, (int)1361262745);
        double[] cryo_I_warnLo = TestHelper.generateDoubleArray((int)6, (int)335313942);
        double[] cryo_I_limitHi = TestHelper.generateDoubleArray((int)6, (int)328477993);
        double[] cryo_I_limitLo = TestHelper.generateDoubleArray((int)6, (int)1911665011);
        double[] cryo_Life_warnHi = TestHelper.generateDoubleArray((int)6, (int)1974896839);
        double[] cryo_Life_warnLo = TestHelper.generateDoubleArray((int)6, (int)-7741305);
        double[] cryo_Life_limitHi = TestHelper.generateDoubleArray((int)6, (int)740506472);
        double[] cryo_Life_limitLo = TestHelper.generateDoubleArray((int)6, (int)849691097);
        double[] cryo_Usage_warnHi = TestHelper.generateDoubleArray((int)6, (int)739468600);
        double[] cryo_Usage_warnLo = TestHelper.generateDoubleArray((int)6, (int)-1378366722);
        double[] cryo_Usage_limitHi = TestHelper.generateDoubleArray((int)6, (int)450993372);
        double[] cryo_Usage_limitLo = TestHelper.generateDoubleArray((int)6, (int)2067130345);
        double[] cryo_V_warnHi = TestHelper.generateDoubleArray((int)6, (int)-1569038273);
        double[] cryo_V_warnLo = TestHelper.generateDoubleArray((int)6, (int)700828897);
        double[] cryo_V_limitHi = TestHelper.generateDoubleArray((int)6, (int)2037262307);
        double[] cryo_V_limitLo = TestHelper.generateDoubleArray((int)6, (int)-1094079358);
        String location = "m";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cip_LimitsConfigurationEvent(version, cryo_I_warnHi, cryo_I_warnLo, cryo_I_limitHi, cryo_I_limitLo, cryo_Life_warnHi, cryo_Life_warnLo, cryo_Life_limitHi, cryo_Life_limitLo, cryo_Usage_warnHi, cryo_Usage_warnLo, cryo_Usage_limitHi, cryo_Usage_limitLo, cryo_V_warnHi, cryo_V_warnLo, cryo_V_limitHi, cryo_V_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cip_LimitsConfigurationEvent));
        Vacuum_Cip_LimitsConfigurationEvent item_ = (Vacuum_Cip_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])cryo_I_warnHi, (double[])item_.getCryo_I_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_I_warnLo, (double[])item_.getCryo_I_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_I_limitHi, (double[])item_.getCryo_I_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_I_limitLo, (double[])item_.getCryo_I_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life_warnHi, (double[])item_.getCryo_Life_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life_warnLo, (double[])item_.getCryo_Life_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life_limitHi, (double[])item_.getCryo_Life_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life_limitLo, (double[])item_.getCryo_Life_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage_warnHi, (double[])item_.getCryo_Usage_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage_warnLo, (double[])item_.getCryo_Usage_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage_limitHi, (double[])item_.getCryo_Usage_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage_limitLo, (double[])item_.getCryo_Usage_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V_warnHi, (double[])item_.getCryo_V_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V_warnLo, (double[])item_.getCryo_V_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V_limitHi, (double[])item_.getCryo_V_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V_limitLo, (double[])item_.getCryo_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_CryoFlineGauge_CryoConfigurationEvent() throws Exception {
        String version = "";
        int busAddr = 941;
        String devcId = "";
        double[] relayTrip = TestHelper.generateDoubleArray((int)3, (int)847810333);
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoFlineGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoFlineGauge_CryoConfigurationEvent));
        Vacuum_CryoFlineGauge_CryoConfigurationEvent item_ = (Vacuum_CryoFlineGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertArrayEquals((double[])relayTrip, (double[])item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoFlineGauge_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoFlineGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoFlineGauge_DevicesConfigurationEvent));
        Vacuum_CryoFlineGauge_DevicesConfigurationEvent item_ = (Vacuum_CryoFlineGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_CryoTurboGauge_CryoConfigurationEvent() throws Exception {
        String version = "n";
        int busAddr = 232;
        String devcId = "r";
        double[] relayTrip = TestHelper.generateDoubleArray((int)3, (int)1793187887);
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoTurboGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTurboGauge_CryoConfigurationEvent));
        Vacuum_CryoTurboGauge_CryoConfigurationEvent item_ = (Vacuum_CryoTurboGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertArrayEquals((double[])relayTrip, (double[])item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoTurboGauge_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoTurboGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTurboGauge_DevicesConfigurationEvent));
        Vacuum_CryoTurboGauge_DevicesConfigurationEvent item_ = (Vacuum_CryoTurboGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_CryoTurboPump_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoTurboPump_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTurboPump_DevicesConfigurationEvent));
        Vacuum_CryoTurboPump_DevicesConfigurationEvent item_ = (Vacuum_CryoTurboPump_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_CryoTurboPump_GeneralConfigurationEvent() throws Exception {
        String version = "u";
        boolean activeStopMode = false;
        int analogOutput = 408;
        int baudRate = 642;
        String devcId = "";
        int extFanConfig = 880;
        int gasType = 160;
        boolean gasTypeArgon = true;
        boolean interlockType = false;
        boolean lowSpeedMode = true;
        int maxpower = 405;
        int rotfreqLow = 152;
        int rotfreqMax = 935;
        int rotfreqSet = 470;
        boolean setpointActive = true;
        int setpointDelay = 17;
        int setpointHyst = 815;
        int setpointThresh = 0;
        int setpointType = 135;
        boolean softStartMode = true;
        boolean speedReadActivate = false;
        int ventDelay = 660;
        int ventOpentime = 164;
        boolean ventvalveByCmnd = false;
        boolean ventvalveType = false;
        boolean waterCooling = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoTurboPump_GeneralConfigurationEvent(version, activeStopMode, analogOutput, baudRate, devcId, extFanConfig, gasType, gasTypeArgon, interlockType, lowSpeedMode, maxpower, rotfreqLow, rotfreqMax, rotfreqSet, setpointActive, setpointDelay, setpointHyst, setpointThresh, setpointType, softStartMode, speedReadActivate, ventDelay, ventOpentime, ventvalveByCmnd, ventvalveType, waterCooling));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTurboPump_GeneralConfigurationEvent));
        Vacuum_CryoTurboPump_GeneralConfigurationEvent item_ = (Vacuum_CryoTurboPump_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)activeStopMode, (Object)item_.isActiveStopMode());
        Assert.assertEquals((long)analogOutput, (long)item_.getAnalogOutput());
        Assert.assertEquals((long)baudRate, (long)item_.getBaudRate());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((long)extFanConfig, (long)item_.getExtFanConfig());
        Assert.assertEquals((long)gasType, (long)item_.getGasType());
        Assert.assertEquals((Object)gasTypeArgon, (Object)item_.isGasTypeArgon());
        Assert.assertEquals((Object)interlockType, (Object)item_.isInterlockType());
        Assert.assertEquals((Object)lowSpeedMode, (Object)item_.isLowSpeedMode());
        Assert.assertEquals((long)maxpower, (long)item_.getMaxpower());
        Assert.assertEquals((long)rotfreqLow, (long)item_.getRotfreqLow());
        Assert.assertEquals((long)rotfreqMax, (long)item_.getRotfreqMax());
        Assert.assertEquals((long)rotfreqSet, (long)item_.getRotfreqSet());
        Assert.assertEquals((Object)setpointActive, (Object)item_.isSetpointActive());
        Assert.assertEquals((long)setpointDelay, (long)item_.getSetpointDelay());
        Assert.assertEquals((long)setpointHyst, (long)item_.getSetpointHyst());
        Assert.assertEquals((long)setpointThresh, (long)item_.getSetpointThresh());
        Assert.assertEquals((long)setpointType, (long)item_.getSetpointType());
        Assert.assertEquals((Object)softStartMode, (Object)item_.isSoftStartMode());
        Assert.assertEquals((Object)speedReadActivate, (Object)item_.isSpeedReadActivate());
        Assert.assertEquals((long)ventDelay, (long)item_.getVentDelay());
        Assert.assertEquals((long)ventOpentime, (long)item_.getVentOpentime());
        Assert.assertEquals((Object)ventvalveByCmnd, (Object)item_.isVentvalveByCmnd());
        Assert.assertEquals((Object)ventvalveType, (Object)item_.isVentvalveType());
        Assert.assertEquals((Object)waterCooling, (Object)item_.isWaterCooling());
    }

    @Test
    public void sendReceiveVacuum_CryoVacGauge_CryoConfigurationEvent() throws Exception {
        String version = "m";
        int busAddr = 209;
        String devcId = "";
        double[] relayTrip = TestHelper.generateDoubleArray((int)3, (int)-1328762689);
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoVacGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacGauge_CryoConfigurationEvent));
        Vacuum_CryoVacGauge_CryoConfigurationEvent item_ = (Vacuum_CryoVacGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertArrayEquals((double[])relayTrip, (double[])item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoVacGauge_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoVacGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacGauge_DevicesConfigurationEvent));
        Vacuum_CryoVacGauge_DevicesConfigurationEvent item_ = (Vacuum_CryoVacGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Cryo_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double airpressure_warnHi = 0.14342546463012695;
        double airpressure_warnLo = 0.3442254662513733;
        double airpressure_limitHi = 0.7518329620361328;
        double airpressure_limitLo = 0.5052889585494995;
        double cryovac_warnHi = 0.08975344896316528;
        double cryovac_warnLo = 0.8730581998825073;
        double cryovac_limitHi = 0.6952483654022217;
        double cryovac_limitLo = 0.22655218839645386;
        double flinepower_warnHi = 0.5505384802818298;
        double flinepower_limitHi = 0.014067888259887695;
        double forelinevac_warnHi = 0.03614205f;
        double forelinevac_warnLo = 0.37096112966537476;
        double forelinevac_limitHi = 0.3495739698410034;
        double forelinevac_limitLo = 0.7331953048706055;
        double gaugedose_warnHi = 0.44190144538879395;
        double gaugedose_warnLo = 0.8249333500862122;
        double gaugedose_limitHi = 0.3438388705253601;
        double gaugedose_limitLo = 0.6647447347640991;
        double pumpcartpressure_warnHi = 0.09924596548080444;
        double pumpcartpressure_warnLo = 0.388649046421051;
        double pumpcartpressure_limitHi = 0.192366361618042;
        double pumpcartpressure_limitLo = 0.3791356682777405;
        double turbogaugedose_warnHi = 0.6766318678855896;
        double turbogaugedose_warnLo = 0.4565402865409851;
        double turbogaugedose_limitHi = 0.5763600468635559;
        double turbogaugedose_limitLo = 0.8063295483589172;
        double turbohours_warnHi = 0.20522820949554443;
        double turbohours_warnLo = 0.04169929027557373;
        double turbohours_limitHi = 0.5060730576515198;
        double turbohours_limitLo = 0.4233966f;
        double turbopower_warnHi = 0.02714228630065918;
        double turbopower_limitHi = 0.20204466581344604;
        double turbopumpstatus_warnHi = 0.4414917230606079;
        double turbopumpstatus_limitHi = 0.8437589406967163;
        double turbopumptemp_warnHi = 0.8764467239379883;
        double turbopumptemp_warnLo = 0.4024495482444763;
        double turbopumptemp_limitHi = 0.42289382219314575;
        double turbopumptemp_limitLo = 0.9662340879440308;
        double turbospeed_warnHi = 0.11944049596786499;
        double turbospeed_warnLo = 0.7138491868972778;
        double turbospeed_limitHi = 0.15329605340957642;
        double turbospeed_limitLo = 0.3902401328086853;
        double turbovac_warnHi = 0.1239391f;
        double turbovac_warnLo = 0.8015385270118713;
        double turbovac_limitHi = 0.03770667314529419;
        double turbovac_limitLo = 0.2436668872833252;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cryo_LimitsConfigurationEvent(version, airpressure_warnHi, airpressure_warnLo, airpressure_limitHi, airpressure_limitLo, cryovac_warnHi, cryovac_warnLo, cryovac_limitHi, cryovac_limitLo, flinepower_warnHi, flinepower_limitHi, forelinevac_warnHi, forelinevac_warnLo, forelinevac_limitHi, forelinevac_limitLo, gaugedose_warnHi, gaugedose_warnLo, gaugedose_limitHi, gaugedose_limitLo, pumpcartpressure_warnHi, pumpcartpressure_warnLo, pumpcartpressure_limitHi, pumpcartpressure_limitLo, turbogaugedose_warnHi, turbogaugedose_warnLo, turbogaugedose_limitHi, turbogaugedose_limitLo, turbohours_warnHi, turbohours_warnLo, turbohours_limitHi, turbohours_limitLo, turbopower_warnHi, turbopower_limitHi, turbopumpstatus_warnHi, turbopumpstatus_limitHi, turbopumptemp_warnHi, turbopumptemp_warnLo, turbopumptemp_limitHi, turbopumptemp_limitLo, turbospeed_warnHi, turbospeed_warnLo, turbospeed_limitHi, turbospeed_limitLo, turbovac_warnHi, turbovac_warnLo, turbovac_limitHi, turbovac_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cryo_LimitsConfigurationEvent));
        Vacuum_Cryo_LimitsConfigurationEvent item_ = (Vacuum_Cryo_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)airpressure_warnHi, (double)item_.getAirpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_warnLo, (double)item_.getAirpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_limitHi, (double)item_.getAirpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_limitLo, (double)item_.getAirpressure_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryovac_warnHi, (double)item_.getCryovac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryovac_warnLo, (double)item_.getCryovac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryovac_limitHi, (double)item_.getCryovac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryovac_limitLo, (double)item_.getCryovac_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_warnHi, (double)item_.getFlinepower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_limitHi, (double)item_.getFlinepower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_warnHi, (double)item_.getForelinevac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_warnLo, (double)item_.getForelinevac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_limitHi, (double)item_.getForelinevac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_limitLo, (double)item_.getForelinevac_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_warnHi, (double)item_.getGaugedose_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_warnLo, (double)item_.getGaugedose_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_limitHi, (double)item_.getGaugedose_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_limitLo, (double)item_.getGaugedose_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnHi, (double)item_.getPumpcartpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnLo, (double)item_.getPumpcartpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitHi, (double)item_.getPumpcartpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitLo, (double)item_.getPumpcartpressure_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_warnHi, (double)item_.getTurbogaugedose_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_warnLo, (double)item_.getTurbogaugedose_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_limitHi, (double)item_.getTurbogaugedose_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_limitLo, (double)item_.getTurbogaugedose_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_warnHi, (double)item_.getTurbohours_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_warnLo, (double)item_.getTurbohours_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_limitHi, (double)item_.getTurbohours_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_limitLo, (double)item_.getTurbohours_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopower_warnHi, (double)item_.getTurbopower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopower_limitHi, (double)item_.getTurbopower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumpstatus_warnHi, (double)item_.getTurbopumpstatus_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumpstatus_limitHi, (double)item_.getTurbopumpstatus_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_warnHi, (double)item_.getTurbopumptemp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_warnLo, (double)item_.getTurbopumptemp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_limitHi, (double)item_.getTurbopumptemp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_limitLo, (double)item_.getTurbopumptemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_warnHi, (double)item_.getTurbospeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_warnLo, (double)item_.getTurbospeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_limitHi, (double)item_.getTurbospeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_limitLo, (double)item_.getTurbospeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_warnHi, (double)item_.getTurbovac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_warnLo, (double)item_.getTurbovac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_limitHi, (double)item_.getTurbovac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_limitLo, (double)item_.getTurbovac_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HX_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double airpressure_warnHi = 0.6375284790992737;
        double airpressure_warnLo = 0.9946182370185852;
        double airpressure_limitHi = 0.3443509340286255;
        double airpressure_limitLo = 0.8494451642036438;
        double flinepower_warnHi = 0.7361348271369934;
        double flinepower_limitHi = 0.4846060276031494;
        double forelinevac_warnHi = 0.9953231811523438;
        double forelinevac_warnLo = 0.08402401208877563;
        double forelinevac_limitHi = 0.3612545132637024;
        double forelinevac_limitLo = 0.6111468076705933;
        double gaugedose_warnHi = 0.046657443046569824;
        double gaugedose_warnLo = 0.7034997344017029;
        double gaugedose_limitHi = 0.6944841146469116;
        double gaugedose_limitLo = 0.4423891305923462;
        double hexvac_warnHi = 0.8195973038673401;
        double hexvac_warnLo = 0.8911446928977966;
        double hexvac_limitHi = 0.9449220299720764;
        double hexvac_limitLo = 0.3727429509162903;
        double pumpcartpressure_warnHi = 0.3365599f;
        double pumpcartpressure_warnLo = 0.2162773609161377;
        double pumpcartpressure_limitHi = 0.08686792850494385;
        double pumpcartpressure_limitLo = 0.5236115455627441;
        double turbogaugedose_warnHi = 0.11660957336425781;
        double turbogaugedose_warnLo = 0.6386212110519409;
        double turbogaugedose_limitHi = 0.5465096235275269;
        double turbogaugedose_limitLo = 0.8977733850479126;
        double turbohours_warnHi = 0.7412078380584717;
        double turbohours_warnLo = 0.33134692907333374;
        double turbohours_limitHi = 0.14201372861862183;
        double turbohours_limitLo = 0.4168702960014343;
        double turbopower_warnHi = 0.9587225317955017;
        double turbopower_limitHi = 0.8275997042655945;
        double turbopumpstatus_warnHi = 0.7852810621261597;
        double turbopumpstatus_limitHi = 0.6418435573577881;
        double turbopumptemp_warnHi = 0.3457095f;
        double turbopumptemp_warnLo = 0.5672187209129333;
        double turbopumptemp_limitHi = 0.45319098234176636;
        double turbopumptemp_limitLo = 0.09826427698135376;
        double turbospeed_warnHi = 0.37387335300445557;
        double turbospeed_warnLo = 0.3292325735092163;
        double turbospeed_limitHi = 0.2597543001174927;
        double turbospeed_limitLo = 0.7892430424690247;
        double turbovac_warnHi = 0.11749368906021118;
        double turbovac_warnLo = 0.9075458645820618;
        double turbovac_limitHi = 0.839673f;
        double turbovac_limitLo = 0.905518651008606;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HX_LimitsConfigurationEvent(version, airpressure_warnHi, airpressure_warnLo, airpressure_limitHi, airpressure_limitLo, flinepower_warnHi, flinepower_limitHi, forelinevac_warnHi, forelinevac_warnLo, forelinevac_limitHi, forelinevac_limitLo, gaugedose_warnHi, gaugedose_warnLo, gaugedose_limitHi, gaugedose_limitLo, hexvac_warnHi, hexvac_warnLo, hexvac_limitHi, hexvac_limitLo, pumpcartpressure_warnHi, pumpcartpressure_warnLo, pumpcartpressure_limitHi, pumpcartpressure_limitLo, turbogaugedose_warnHi, turbogaugedose_warnLo, turbogaugedose_limitHi, turbogaugedose_limitLo, turbohours_warnHi, turbohours_warnLo, turbohours_limitHi, turbohours_limitLo, turbopower_warnHi, turbopower_limitHi, turbopumpstatus_warnHi, turbopumpstatus_limitHi, turbopumptemp_warnHi, turbopumptemp_warnLo, turbopumptemp_limitHi, turbopumptemp_limitLo, turbospeed_warnHi, turbospeed_warnLo, turbospeed_limitHi, turbospeed_limitLo, turbovac_warnHi, turbovac_warnLo, turbovac_limitHi, turbovac_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HX_LimitsConfigurationEvent));
        Vacuum_HX_LimitsConfigurationEvent item_ = (Vacuum_HX_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)airpressure_warnHi, (double)item_.getAirpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_warnLo, (double)item_.getAirpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_limitHi, (double)item_.getAirpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_limitLo, (double)item_.getAirpressure_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_warnHi, (double)item_.getFlinepower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_limitHi, (double)item_.getFlinepower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_warnHi, (double)item_.getForelinevac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_warnLo, (double)item_.getForelinevac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_limitHi, (double)item_.getForelinevac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_limitLo, (double)item_.getForelinevac_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_warnHi, (double)item_.getGaugedose_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_warnLo, (double)item_.getGaugedose_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_limitHi, (double)item_.getGaugedose_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_limitLo, (double)item_.getGaugedose_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexvac_warnHi, (double)item_.getHexvac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexvac_warnLo, (double)item_.getHexvac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexvac_limitHi, (double)item_.getHexvac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexvac_limitLo, (double)item_.getHexvac_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnHi, (double)item_.getPumpcartpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnLo, (double)item_.getPumpcartpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitHi, (double)item_.getPumpcartpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitLo, (double)item_.getPumpcartpressure_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_warnHi, (double)item_.getTurbogaugedose_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_warnLo, (double)item_.getTurbogaugedose_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_limitHi, (double)item_.getTurbogaugedose_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_limitLo, (double)item_.getTurbogaugedose_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_warnHi, (double)item_.getTurbohours_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_warnLo, (double)item_.getTurbohours_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_limitHi, (double)item_.getTurbohours_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_limitLo, (double)item_.getTurbohours_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopower_warnHi, (double)item_.getTurbopower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopower_limitHi, (double)item_.getTurbopower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumpstatus_warnHi, (double)item_.getTurbopumpstatus_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumpstatus_limitHi, (double)item_.getTurbopumpstatus_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_warnHi, (double)item_.getTurbopumptemp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_warnLo, (double)item_.getTurbopumptemp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_limitHi, (double)item_.getTurbopumptemp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_limitLo, (double)item_.getTurbopumptemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_warnHi, (double)item_.getTurbospeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_warnLo, (double)item_.getTurbospeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_limitHi, (double)item_.getTurbospeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_limitLo, (double)item_.getTurbospeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_warnHi, (double)item_.getTurbovac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_warnLo, (double)item_.getTurbovac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_limitHi, (double)item_.getTurbovac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_limitLo, (double)item_.getTurbovac_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HexFlineGauge_CryoConfigurationEvent() throws Exception {
        String version = "";
        int busAddr = 96;
        String devcId = "o";
        double[] relayTrip = TestHelper.generateDoubleArray((int)3, (int)-1771399009);
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexFlineGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexFlineGauge_CryoConfigurationEvent));
        Vacuum_HexFlineGauge_CryoConfigurationEvent item_ = (Vacuum_HexFlineGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertArrayEquals((double[])relayTrip, (double[])item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HexFlineGauge_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexFlineGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexFlineGauge_DevicesConfigurationEvent));
        Vacuum_HexFlineGauge_DevicesConfigurationEvent item_ = (Vacuum_HexFlineGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_HexTurboGauge_CryoConfigurationEvent() throws Exception {
        String version = "k";
        int busAddr = 379;
        String devcId = "v";
        double[] relayTrip = TestHelper.generateDoubleArray((int)3, (int)-740799749);
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexTurboGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexTurboGauge_CryoConfigurationEvent));
        Vacuum_HexTurboGauge_CryoConfigurationEvent item_ = (Vacuum_HexTurboGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertArrayEquals((double[])relayTrip, (double[])item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HexTurboGauge_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexTurboGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexTurboGauge_DevicesConfigurationEvent));
        Vacuum_HexTurboGauge_DevicesConfigurationEvent item_ = (Vacuum_HexTurboGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_HexTurboPump_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexTurboPump_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexTurboPump_DevicesConfigurationEvent));
        Vacuum_HexTurboPump_DevicesConfigurationEvent item_ = (Vacuum_HexTurboPump_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_HexTurboPump_GeneralConfigurationEvent() throws Exception {
        String version = "";
        boolean activeStopMode = true;
        int analogOutput = 727;
        int baudRate = 866;
        String devcId = "";
        int extFanConfig = 970;
        int gasType = 834;
        boolean gasTypeArgon = true;
        boolean interlockType = false;
        boolean lowSpeedMode = true;
        int maxpower = 637;
        int rotfreqLow = 192;
        int rotfreqMax = 587;
        int rotfreqSet = 127;
        boolean setpointActive = false;
        int setpointDelay = 686;
        int setpointHyst = 258;
        int setpointThresh = 90;
        int setpointType = 544;
        boolean softStartMode = false;
        boolean speedReadActivate = true;
        int ventDelay = 150;
        int ventOpentime = 536;
        boolean ventvalveByCmnd = true;
        boolean ventvalveType = false;
        boolean waterCooling = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexTurboPump_GeneralConfigurationEvent(version, activeStopMode, analogOutput, baudRate, devcId, extFanConfig, gasType, gasTypeArgon, interlockType, lowSpeedMode, maxpower, rotfreqLow, rotfreqMax, rotfreqSet, setpointActive, setpointDelay, setpointHyst, setpointThresh, setpointType, softStartMode, speedReadActivate, ventDelay, ventOpentime, ventvalveByCmnd, ventvalveType, waterCooling));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexTurboPump_GeneralConfigurationEvent));
        Vacuum_HexTurboPump_GeneralConfigurationEvent item_ = (Vacuum_HexTurboPump_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)activeStopMode, (Object)item_.isActiveStopMode());
        Assert.assertEquals((long)analogOutput, (long)item_.getAnalogOutput());
        Assert.assertEquals((long)baudRate, (long)item_.getBaudRate());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((long)extFanConfig, (long)item_.getExtFanConfig());
        Assert.assertEquals((long)gasType, (long)item_.getGasType());
        Assert.assertEquals((Object)gasTypeArgon, (Object)item_.isGasTypeArgon());
        Assert.assertEquals((Object)interlockType, (Object)item_.isInterlockType());
        Assert.assertEquals((Object)lowSpeedMode, (Object)item_.isLowSpeedMode());
        Assert.assertEquals((long)maxpower, (long)item_.getMaxpower());
        Assert.assertEquals((long)rotfreqLow, (long)item_.getRotfreqLow());
        Assert.assertEquals((long)rotfreqMax, (long)item_.getRotfreqMax());
        Assert.assertEquals((long)rotfreqSet, (long)item_.getRotfreqSet());
        Assert.assertEquals((Object)setpointActive, (Object)item_.isSetpointActive());
        Assert.assertEquals((long)setpointDelay, (long)item_.getSetpointDelay());
        Assert.assertEquals((long)setpointHyst, (long)item_.getSetpointHyst());
        Assert.assertEquals((long)setpointThresh, (long)item_.getSetpointThresh());
        Assert.assertEquals((long)setpointType, (long)item_.getSetpointType());
        Assert.assertEquals((Object)softStartMode, (Object)item_.isSoftStartMode());
        Assert.assertEquals((Object)speedReadActivate, (Object)item_.isSpeedReadActivate());
        Assert.assertEquals((long)ventDelay, (long)item_.getVentDelay());
        Assert.assertEquals((long)ventOpentime, (long)item_.getVentOpentime());
        Assert.assertEquals((Object)ventvalveByCmnd, (Object)item_.isVentvalveByCmnd());
        Assert.assertEquals((Object)ventvalveType, (Object)item_.isVentvalveType());
        Assert.assertEquals((Object)waterCooling, (Object)item_.isWaterCooling());
    }

    @Test
    public void sendReceiveVacuum_HexVacGauge_CryoConfigurationEvent() throws Exception {
        String version = "m";
        int busAddr = 320;
        String devcId = "";
        double[] relayTrip = TestHelper.generateDoubleArray((int)3, (int)-1300368019);
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexVacGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexVacGauge_CryoConfigurationEvent));
        Vacuum_HexVacGauge_CryoConfigurationEvent item_ = (Vacuum_HexVacGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertArrayEquals((double[])relayTrip, (double[])item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HexVacGauge_DevicesConfigurationEvent() throws Exception {
        String version = "w";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexVacGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexVacGauge_DevicesConfigurationEvent));
        Vacuum_HexVacGauge_DevicesConfigurationEvent item_ = (Vacuum_HexVacGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Hip_LimitsConfigurationEvent() throws Exception {
        String version = "r";
        double[] hx_I_warnHi = TestHelper.generateDoubleArray((int)2, (int)-595518965);
        double[] hx_I_warnLo = TestHelper.generateDoubleArray((int)2, (int)-236441134);
        double[] hx_I_limitHi = TestHelper.generateDoubleArray((int)2, (int)-778788125);
        double[] hx_I_limitLo = TestHelper.generateDoubleArray((int)2, (int)271120468);
        double[] hx_Life_warnHi = TestHelper.generateDoubleArray((int)2, (int)-1152004463);
        double[] hx_Life_warnLo = TestHelper.generateDoubleArray((int)2, (int)1038118094);
        double[] hx_Life_limitHi = TestHelper.generateDoubleArray((int)2, (int)-101509996);
        double[] hx_Life_limitLo = TestHelper.generateDoubleArray((int)2, (int)-793203460);
        double[] hx_Usage_warnHi = TestHelper.generateDoubleArray((int)2, (int)-436314012);
        double[] hx_Usage_warnLo = TestHelper.generateDoubleArray((int)2, (int)-1305319526);
        double[] hx_Usage_limitHi = TestHelper.generateDoubleArray((int)2, (int)-2106235350);
        double[] hx_Usage_limitLo = TestHelper.generateDoubleArray((int)2, (int)525690972);
        double[] hx_V_warnHi = TestHelper.generateDoubleArray((int)2, (int)-1227387314);
        double[] hx_V_warnLo = TestHelper.generateDoubleArray((int)2, (int)-910339017);
        double[] hx_V_limitHi = TestHelper.generateDoubleArray((int)2, (int)68368910);
        double[] hx_V_limitLo = TestHelper.generateDoubleArray((int)2, (int)-1422249684);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Hip_LimitsConfigurationEvent(version, hx_I_warnHi, hx_I_warnLo, hx_I_limitHi, hx_I_limitLo, hx_Life_warnHi, hx_Life_warnLo, hx_Life_limitHi, hx_Life_limitLo, hx_Usage_warnHi, hx_Usage_warnLo, hx_Usage_limitHi, hx_Usage_limitLo, hx_V_warnHi, hx_V_warnLo, hx_V_limitHi, hx_V_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hip_LimitsConfigurationEvent));
        Vacuum_Hip_LimitsConfigurationEvent item_ = (Vacuum_Hip_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])hx_I_warnHi, (double[])item_.getHx_I_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_I_warnLo, (double[])item_.getHx_I_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_I_limitHi, (double[])item_.getHx_I_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_I_limitLo, (double[])item_.getHx_I_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life_warnHi, (double[])item_.getHx_Life_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life_warnLo, (double[])item_.getHx_Life_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life_limitHi, (double[])item_.getHx_Life_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life_limitLo, (double[])item_.getHx_Life_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage_warnHi, (double[])item_.getHx_Usage_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage_warnLo, (double[])item_.getHx_Usage_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage_limitHi, (double[])item_.getHx_Usage_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage_limitLo, (double[])item_.getHx_Usage_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V_warnHi, (double[])item_.getHx_V_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V_warnLo, (double[])item_.getHx_V_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V_limitHi, (double[])item_.getHx_V_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V_limitLo, (double[])item_.getHx_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_InstVacGauge_CryoConfigurationEvent() throws Exception {
        String version = "x";
        int busAddr = 981;
        String devcId = "";
        double[] relayTrip = TestHelper.generateDoubleArray((int)3, (int)1318045753);
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_InstVacGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_InstVacGauge_CryoConfigurationEvent));
        Vacuum_InstVacGauge_CryoConfigurationEvent item_ = (Vacuum_InstVacGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertArrayEquals((double[])relayTrip, (double[])item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_InstVacGauge_DevicesConfigurationEvent() throws Exception {
        String version = "b";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_InstVacGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_InstVacGauge_DevicesConfigurationEvent));
        Vacuum_InstVacGauge_DevicesConfigurationEvent item_ = (Vacuum_InstVacGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Inst_LimitsConfigurationEvent() throws Exception {
        String version = "d";
        double cryoflinevalvestate_warnHi = 0.9889153242111206;
        double cryoflinevalvestate_warnLo = 0.4726397395133972;
        double cryoflinevalvestate_limitHi = 0.3076918125152588;
        double cryoflinevalvestate_limitLo = 0.4680584f;
        double flinepower_warnHi = 0.26654428243637085;
        double flinepower_limitHi = 0.6449887752532959;
        double hxflinevalvestate_warnHi = 0.31182122230529785;
        double hxflinevalvestate_warnLo = 0.19246304035186768;
        double hxflinevalvestate_limitHi = 0.6237963438034058;
        double hxflinevalvestate_limitLo = 0.3165757f;
        double instvac_warnHi = 0.7989621162414551;
        double instvac_warnLo = 0.37942272424697876;
        double instvac_limitHi = 0.12457782030105591;
        double instvac_limitLo = 0.9272174835205078;
        double pumpcartcycling_warnHi = 0.8417255282402039;
        double pumpcartcycling_warnLo = 0.12413114309310913;
        double pumpcartcycling_limitHi = 0.5145398378372192;
        double pumpcartcycling_limitLo = 0.6842864155769348;
        double pumpcartpressure_warnHi = 0.16013747453689575;
        double pumpcartpressure_warnLo = 0.7154470682144165;
        double pumpcartpressure_limitHi = 0.24681884050369263;
        double pumpcartpressure_limitLo = 3.97861E-4f;
        double pumpcarttemperature_warnHi = 0.4978829026222229;
        double pumpcarttemperature_warnLo = 0.016645967960357666;
        double pumpcarttemperature_limitHi = 0.9987613558769226;
        double pumpcarttemperature_limitLo = 0.24865102767944336;
        double pumpcartventing_warnHi = 0.44293713569641113;
        double pumpcartventing_warnLo = 0.71945720911026;
        double pumpcartventing_limitHi = 0.1985260248184204;
        double pumpcartventing_limitLo = 0.16791987419128418;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Inst_LimitsConfigurationEvent(version, cryoflinevalvestate_warnHi, cryoflinevalvestate_warnLo, cryoflinevalvestate_limitHi, cryoflinevalvestate_limitLo, flinepower_warnHi, flinepower_limitHi, hxflinevalvestate_warnHi, hxflinevalvestate_warnLo, hxflinevalvestate_limitHi, hxflinevalvestate_limitLo, instvac_warnHi, instvac_warnLo, instvac_limitHi, instvac_limitLo, pumpcartcycling_warnHi, pumpcartcycling_warnLo, pumpcartcycling_limitHi, pumpcartcycling_limitLo, pumpcartpressure_warnHi, pumpcartpressure_warnLo, pumpcartpressure_limitHi, pumpcartpressure_limitLo, pumpcarttemperature_warnHi, pumpcarttemperature_warnLo, pumpcarttemperature_limitHi, pumpcarttemperature_limitLo, pumpcartventing_warnHi, pumpcartventing_warnLo, pumpcartventing_limitHi, pumpcartventing_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Inst_LimitsConfigurationEvent));
        Vacuum_Inst_LimitsConfigurationEvent item_ = (Vacuum_Inst_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cryoflinevalvestate_warnHi, (double)item_.getCryoflinevalvestate_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoflinevalvestate_warnLo, (double)item_.getCryoflinevalvestate_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoflinevalvestate_limitHi, (double)item_.getCryoflinevalvestate_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoflinevalvestate_limitLo, (double)item_.getCryoflinevalvestate_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_warnHi, (double)item_.getFlinepower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_limitHi, (double)item_.getFlinepower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hxflinevalvestate_warnHi, (double)item_.getHxflinevalvestate_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hxflinevalvestate_warnLo, (double)item_.getHxflinevalvestate_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hxflinevalvestate_limitHi, (double)item_.getHxflinevalvestate_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hxflinevalvestate_limitLo, (double)item_.getHxflinevalvestate_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)instvac_warnHi, (double)item_.getInstvac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)instvac_warnLo, (double)item_.getInstvac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)instvac_limitHi, (double)item_.getInstvac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)instvac_limitLo, (double)item_.getInstvac_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartcycling_warnHi, (double)item_.getPumpcartcycling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartcycling_warnLo, (double)item_.getPumpcartcycling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartcycling_limitHi, (double)item_.getPumpcartcycling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartcycling_limitLo, (double)item_.getPumpcartcycling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnHi, (double)item_.getPumpcartpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnLo, (double)item_.getPumpcartpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitHi, (double)item_.getPumpcartpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitLo, (double)item_.getPumpcartpressure_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcarttemperature_warnHi, (double)item_.getPumpcarttemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcarttemperature_warnLo, (double)item_.getPumpcarttemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcarttemperature_limitHi, (double)item_.getPumpcarttemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcarttemperature_limitLo, (double)item_.getPumpcarttemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartventing_warnHi, (double)item_.getPumpcartventing_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartventing_warnLo, (double)item_.getPumpcartventing_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartventing_limitHi, (double)item_.getPumpcartventing_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartventing_limitLo, (double)item_.getPumpcartventing_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumps_CryoConfigurationEvent() throws Exception {
        String version = "";
        double cip1c_current = 0.07557564973831177;
        double cip1c_power = 0.26327353715896606;
        double cip1c_voltage = 0.5822992920875549;
        double cip2c_current = 0.7447644472122192;
        double cip2c_power = 0.44467437267303467;
        double cip2c_voltage = 0.525576114654541;
        double cip3c_current = 0.43829184770584106;
        double cip3c_power = 0.9741195440292358;
        double cip3c_voltage = 0.7157511115074158;
        double cip4c_current = 0.5872114896774292;
        double cip4c_power = 0.12102806568145752;
        double cip4c_voltage = 0.5752629637718201;
        double cip5c_current = 0.9463352560997009;
        double cip5c_power = 0.5632772445678711;
        double cip5c_voltage = 0.7127206921577454;
        double cip6c_current = 0.4905286431312561;
        double cip6c_power = 0.14919966459274292;
        double cip6c_voltage = 0.16633951663970947;
        double hip1c_current = 0.19426536560058594;
        double hip1c_power = 0.071639f;
        double hip1c_voltage = 0.1569261f;
        double hip2c_current = 0.20998424291610718;
        double hip2c_power = 0.47163963317871094;
        double hip2c_voltage = 0.5734783411026001;
        String ipAddr = "i";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_IonPumps_CryoConfigurationEvent(version, cip1c_current, cip1c_power, cip1c_voltage, cip2c_current, cip2c_power, cip2c_voltage, cip3c_current, cip3c_power, cip3c_voltage, cip4c_current, cip4c_power, cip4c_voltage, cip5c_current, cip5c_power, cip5c_voltage, cip6c_current, cip6c_power, cip6c_voltage, hip1c_current, hip1c_power, hip1c_voltage, hip2c_current, hip2c_power, hip2c_voltage, ipAddr));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumps_CryoConfigurationEvent));
        Vacuum_IonPumps_CryoConfigurationEvent item_ = (Vacuum_IonPumps_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cip1c_current, (double)item_.getCip1c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip1c_power, (double)item_.getCip1c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip1c_voltage, (double)item_.getCip1c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)cip2c_current, (double)item_.getCip2c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip2c_power, (double)item_.getCip2c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip2c_voltage, (double)item_.getCip2c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)cip3c_current, (double)item_.getCip3c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip3c_power, (double)item_.getCip3c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip3c_voltage, (double)item_.getCip3c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)cip4c_current, (double)item_.getCip4c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip4c_power, (double)item_.getCip4c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip4c_voltage, (double)item_.getCip4c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)cip5c_current, (double)item_.getCip5c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip5c_power, (double)item_.getCip5c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip5c_voltage, (double)item_.getCip5c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)cip6c_current, (double)item_.getCip6c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip6c_power, (double)item_.getCip6c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip6c_voltage, (double)item_.getCip6c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)hip1c_current, (double)item_.getHip1c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)hip1c_power, (double)item_.getHip1c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)hip1c_voltage, (double)item_.getHip1c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)hip2c_current, (double)item_.getHip2c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)hip2c_power, (double)item_.getHip2c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)hip2c_voltage, (double)item_.getHip2c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
    }

    @Test
    public void sendReceiveVacuum_IonPumps_DevicesConfigurationEvent() throws Exception {
        String version = "y";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_IonPumps_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumps_DevicesConfigurationEvent));
        Vacuum_IonPumps_DevicesConfigurationEvent item_ = (Vacuum_IonPumps_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Maq20Cryo_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String node = "";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Maq20Cryo_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Maq20Cryo_DeviceConfigurationEvent));
        Vacuum_Maq20Cryo_DeviceConfigurationEvent item_ = (Vacuum_Maq20Cryo_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveVacuum_Maq20Cryo_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Maq20Cryo_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Maq20Cryo_DevicesConfigurationEvent));
        Vacuum_Maq20Cryo_DevicesConfigurationEvent item_ = (Vacuum_Maq20Cryo_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Maq20Ut_DeviceConfigurationEvent() throws Exception {
        String version = "x";
        String node = "";
        String serials = "z";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Maq20Ut_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Maq20Ut_DeviceConfigurationEvent));
        Vacuum_Maq20Ut_DeviceConfigurationEvent item_ = (Vacuum_Maq20Ut_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveVacuum_Maq20Ut_DevicesConfigurationEvent() throws Exception {
        String version = "s";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Maq20Ut_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Maq20Ut_DevicesConfigurationEvent));
        Vacuum_Maq20Ut_DevicesConfigurationEvent item_ = (Vacuum_Maq20Ut_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_PDU_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PDU_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PDU_DevicesConfigurationEvent));
        Vacuum_PDU_DevicesConfigurationEvent item_ = (Vacuum_PDU_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_PDU_VacuumConfigurationEvent() throws Exception {
        String version = "u";
        int node = 878;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PDU_VacuumConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PDU_VacuumConfigurationEvent));
        Vacuum_PDU_VacuumConfigurationEvent item_ = (Vacuum_PDU_VacuumConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveVacuum_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "k";
        int schedulers_default_nTasks = 704;
        int schedulers_default_nThreads = 719;
        int schedulers_monitor_check_scheduler_nTasks = 941;
        int schedulers_monitor_check_scheduler_nThreads = 15;
        int schedulers_monitor_update_publish_scheduler_nTasks = 603;
        int schedulers_monitor_update_publish_scheduler_nThreads = 491;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PeriodicTasks_GeneralConfigurationEvent));
        Vacuum_PeriodicTasks_GeneralConfigurationEvent item_ = (Vacuum_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveVacuum_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 78L;
        long heartbeat_taskPeriodMillis = 538L;
        long maq20cryo_check_status_taskPeriodMillis = 659L;
        long maq20ut_check_status_taskPeriodMillis = 939L;
        long monitor_check_CryoFlineGauge_taskPeriodMillis = 291L;
        long monitor_check_CryoTurboGauge_taskPeriodMillis = 614L;
        long monitor_check_CryoTurboPump_taskPeriodMillis = 242L;
        long monitor_check_CryoVacGauge_taskPeriodMillis = 400L;
        long monitor_check_HexFlineGauge_taskPeriodMillis = 679L;
        long monitor_check_HexTurboGauge_taskPeriodMillis = 626L;
        long monitor_check_HexTurboPump_taskPeriodMillis = 107L;
        long monitor_check_HexVacGauge_taskPeriodMillis = 419L;
        long monitor_check_InstVacGauge_taskPeriodMillis = 2L;
        long monitor_check_IonPumps_taskPeriodMillis = 821L;
        long monitor_check_Maq20Cryo_taskPeriodMillis = 432L;
        long monitor_check_Maq20Ut_taskPeriodMillis = 281L;
        long monitor_check_PDU_taskPeriodMillis = 278L;
        long monitor_check_PumpCart_taskPeriodMillis = 389L;
        long monitor_check_VacPluto_taskPeriodMillis = 111L;
        long monitor_publish_CryoTurboPump_taskPeriodMillis = 887L;
        long monitor_publish_HexTurboPump_taskPeriodMillis = 136L;
        long monitor_publish_IonPumps_taskPeriodMillis = 17L;
        long monitor_publish_Maq20Cryo_taskPeriodMillis = 239L;
        long monitor_publish_PDU_taskPeriodMillis = 138L;
        long monitor_publish_PumpCart_taskPeriodMillis = 695L;
        long monitor_publish_slowMon_taskPeriodMillis = 920L;
        long monitor_publish_taskPeriodMillis = 344L;
        long monitor_publish_tts0_taskPeriodMillis = 207L;
        long monitor_publish_tts1_taskPeriodMillis = 942L;
        long monitor_update_CryoTurboPump_taskPeriodMillis = 115L;
        long monitor_update_HexTurboPump_taskPeriodMillis = 592L;
        long monitor_update_IonPumps_taskPeriodMillis = 820L;
        long monitor_update_Maq20Cryo_taskPeriodMillis = 958L;
        long monitor_update_PDU_taskPeriodMillis = 980L;
        long monitor_update_PumpCart_taskPeriodMillis = 234L;
        long monitor_update_slowMon_taskPeriodMillis = 569L;
        long monitor_update_taskPeriodMillis = 436L;
        long monitor_update_tts0_taskPeriodMillis = 90L;
        long monitor_update_tts1_taskPeriodMillis = 881L;
        long runtimeinfo_taskPeriodMillis = 214L;
        long vacuum_state_taskPeriodMillis = 827L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, maq20cryo_check_status_taskPeriodMillis, maq20ut_check_status_taskPeriodMillis, monitor_check_CryoFlineGauge_taskPeriodMillis, monitor_check_CryoTurboGauge_taskPeriodMillis, monitor_check_CryoTurboPump_taskPeriodMillis, monitor_check_CryoVacGauge_taskPeriodMillis, monitor_check_HexFlineGauge_taskPeriodMillis, monitor_check_HexTurboGauge_taskPeriodMillis, monitor_check_HexTurboPump_taskPeriodMillis, monitor_check_HexVacGauge_taskPeriodMillis, monitor_check_InstVacGauge_taskPeriodMillis, monitor_check_IonPumps_taskPeriodMillis, monitor_check_Maq20Cryo_taskPeriodMillis, monitor_check_Maq20Ut_taskPeriodMillis, monitor_check_PDU_taskPeriodMillis, monitor_check_PumpCart_taskPeriodMillis, monitor_check_VacPluto_taskPeriodMillis, monitor_publish_CryoTurboPump_taskPeriodMillis, monitor_publish_HexTurboPump_taskPeriodMillis, monitor_publish_IonPumps_taskPeriodMillis, monitor_publish_Maq20Cryo_taskPeriodMillis, monitor_publish_PDU_taskPeriodMillis, monitor_publish_PumpCart_taskPeriodMillis, monitor_publish_slowMon_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_publish_tts0_taskPeriodMillis, monitor_publish_tts1_taskPeriodMillis, monitor_update_CryoTurboPump_taskPeriodMillis, monitor_update_HexTurboPump_taskPeriodMillis, monitor_update_IonPumps_taskPeriodMillis, monitor_update_Maq20Cryo_taskPeriodMillis, monitor_update_PDU_taskPeriodMillis, monitor_update_PumpCart_taskPeriodMillis, monitor_update_slowMon_taskPeriodMillis, monitor_update_taskPeriodMillis, monitor_update_tts0_taskPeriodMillis, monitor_update_tts1_taskPeriodMillis, runtimeinfo_taskPeriodMillis, vacuum_state_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PeriodicTasks_timersConfigurationEvent));
        Vacuum_PeriodicTasks_timersConfigurationEvent item_ = (Vacuum_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)maq20cryo_check_status_taskPeriodMillis, (long)item_.getMaq20cryo_check_status_taskPeriodMillis());
        Assert.assertEquals((long)maq20ut_check_status_taskPeriodMillis, (long)item_.getMaq20ut_check_status_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_CryoFlineGauge_taskPeriodMillis, (long)item_.getMonitor_check_CryoFlineGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_CryoTurboGauge_taskPeriodMillis, (long)item_.getMonitor_check_CryoTurboGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_CryoTurboPump_taskPeriodMillis, (long)item_.getMonitor_check_CryoTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_CryoVacGauge_taskPeriodMillis, (long)item_.getMonitor_check_CryoVacGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_HexFlineGauge_taskPeriodMillis, (long)item_.getMonitor_check_HexFlineGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_HexTurboGauge_taskPeriodMillis, (long)item_.getMonitor_check_HexTurboGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_HexTurboPump_taskPeriodMillis, (long)item_.getMonitor_check_HexTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_HexVacGauge_taskPeriodMillis, (long)item_.getMonitor_check_HexVacGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_InstVacGauge_taskPeriodMillis, (long)item_.getMonitor_check_InstVacGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_IonPumps_taskPeriodMillis, (long)item_.getMonitor_check_IonPumps_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Maq20Cryo_taskPeriodMillis, (long)item_.getMonitor_check_Maq20Cryo_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Maq20Ut_taskPeriodMillis, (long)item_.getMonitor_check_Maq20Ut_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PDU_taskPeriodMillis, (long)item_.getMonitor_check_PDU_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PumpCart_taskPeriodMillis, (long)item_.getMonitor_check_PumpCart_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_VacPluto_taskPeriodMillis, (long)item_.getMonitor_check_VacPluto_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_CryoTurboPump_taskPeriodMillis, (long)item_.getMonitor_publish_CryoTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_HexTurboPump_taskPeriodMillis, (long)item_.getMonitor_publish_HexTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_IonPumps_taskPeriodMillis, (long)item_.getMonitor_publish_IonPumps_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Maq20Cryo_taskPeriodMillis, (long)item_.getMonitor_publish_Maq20Cryo_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PDU_taskPeriodMillis, (long)item_.getMonitor_publish_PDU_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PumpCart_taskPeriodMillis, (long)item_.getMonitor_publish_PumpCart_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_slowMon_taskPeriodMillis, (long)item_.getMonitor_publish_slowMon_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_tts0_taskPeriodMillis, (long)item_.getMonitor_publish_tts0_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_tts1_taskPeriodMillis, (long)item_.getMonitor_publish_tts1_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_CryoTurboPump_taskPeriodMillis, (long)item_.getMonitor_update_CryoTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_HexTurboPump_taskPeriodMillis, (long)item_.getMonitor_update_HexTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_IonPumps_taskPeriodMillis, (long)item_.getMonitor_update_IonPumps_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Maq20Cryo_taskPeriodMillis, (long)item_.getMonitor_update_Maq20Cryo_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PDU_taskPeriodMillis, (long)item_.getMonitor_update_PDU_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PumpCart_taskPeriodMillis, (long)item_.getMonitor_update_PumpCart_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_slowMon_taskPeriodMillis, (long)item_.getMonitor_update_slowMon_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_tts0_taskPeriodMillis, (long)item_.getMonitor_update_tts0_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_tts1_taskPeriodMillis, (long)item_.getMonitor_update_tts1_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)vacuum_state_taskPeriodMillis, (long)item_.getVacuum_state_taskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_PumpCart_CryoConfigurationEvent() throws Exception {
        String version = "n";
        String devcId = "";
        double maxVentPressure = 0.11591315269470215;
        double minPumpPressure = 0.4327585f;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PumpCart_CryoConfigurationEvent(version, devcId, maxVentPressure, minPumpPressure));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PumpCart_CryoConfigurationEvent));
        Vacuum_PumpCart_CryoConfigurationEvent item_ = (Vacuum_PumpCart_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((double)maxVentPressure, (double)item_.getMaxVentPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)minPumpPressure, (double)item_.getMinPumpPressure(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_PumpCart_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PumpCart_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PumpCart_DevicesConfigurationEvent));
        Vacuum_PumpCart_DevicesConfigurationEvent item_ = (Vacuum_PumpCart_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_VacPluto_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacPluto_DeviceConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacPluto_DeviceConfigurationEvent));
        Vacuum_VacPluto_DeviceConfigurationEvent item_ = (Vacuum_VacPluto_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
    }

    @Test
    public void sendReceiveVacuum_VacPluto_DevicesConfigurationEvent() throws Exception {
        String version = "a";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacPluto_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacPluto_DevicesConfigurationEvent));
        Vacuum_VacPluto_DevicesConfigurationEvent item_ = (Vacuum_VacPluto_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_VacuumConfigurationEvent() throws Exception {
        String version = "";
        double cryoPScale = 0.6120885610580444;
        double cryoPdiffFloor = 0.6070190668106079;
        double delayCCOff = 0.726321f;
        double hxPScale = 0.7670446038246155;
        double hxPdiffFloor = 0.6325418949127197;
        double pChangeStateUpdate = 0.14544326066970825;
        double pFLChangeStateUpdate = 0.15658771991729736;
        double pPCChangeStateUpdate = 0.20130383968353271;
        double pcPdiffFloor = 0.4904070496559143;
        double pcPdiffScaleFactor = 0.6301425099372864;
        double pressCCEnable = 0.5715990662574768;
        double pressCCOff = 0.9308252334594727;
        double pressDiffHighMin = 0.8303444981575012;
        double pressDiffLow = 0.08115541934967041;
        double pressForelineLow = 0.4171072840690613;
        double pressIonEnable = 0.516190230846405;
        double pressIonOff = 0.37397074699401855;
        double pressRefrigOk = 0.2256726f;
        double pressTurboLow = 0.6835756301879883;
        double pressVacuum = 0.4971230626106262;
        double speedFractTurboLow = 0.46246641874313354;
        long tranTimeCryoGate = 754L;
        long tranTimeHxGate = 591L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacuumConfigurationEvent(version, cryoPScale, cryoPdiffFloor, delayCCOff, hxPScale, hxPdiffFloor, pChangeStateUpdate, pFLChangeStateUpdate, pPCChangeStateUpdate, pcPdiffFloor, pcPdiffScaleFactor, pressCCEnable, pressCCOff, pressDiffHighMin, pressDiffLow, pressForelineLow, pressIonEnable, pressIonOff, pressRefrigOk, pressTurboLow, pressVacuum, speedFractTurboLow, tranTimeCryoGate, tranTimeHxGate));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacuumConfigurationEvent));
        Vacuum_VacuumConfigurationEvent item_ = (Vacuum_VacuumConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cryoPScale, (double)item_.getCryoPScale(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoPdiffFloor, (double)item_.getCryoPdiffFloor(), (double)1.0E-6f);
        Assert.assertEquals((double)delayCCOff, (double)item_.getDelayCCOff(), (double)1.0E-6f);
        Assert.assertEquals((double)hxPScale, (double)item_.getHxPScale(), (double)1.0E-6f);
        Assert.assertEquals((double)hxPdiffFloor, (double)item_.getHxPdiffFloor(), (double)1.0E-6f);
        Assert.assertEquals((double)pChangeStateUpdate, (double)item_.getPChangeStateUpdate(), (double)1.0E-6f);
        Assert.assertEquals((double)pFLChangeStateUpdate, (double)item_.getPFLChangeStateUpdate(), (double)1.0E-6f);
        Assert.assertEquals((double)pPCChangeStateUpdate, (double)item_.getPPCChangeStateUpdate(), (double)1.0E-6f);
        Assert.assertEquals((double)pcPdiffFloor, (double)item_.getPcPdiffFloor(), (double)1.0E-6f);
        Assert.assertEquals((double)pcPdiffScaleFactor, (double)item_.getPcPdiffScaleFactor(), (double)1.0E-6f);
        Assert.assertEquals((double)pressCCEnable, (double)item_.getPressCCEnable(), (double)1.0E-6f);
        Assert.assertEquals((double)pressCCOff, (double)item_.getPressCCOff(), (double)1.0E-6f);
        Assert.assertEquals((double)pressDiffHighMin, (double)item_.getPressDiffHighMin(), (double)1.0E-6f);
        Assert.assertEquals((double)pressDiffLow, (double)item_.getPressDiffLow(), (double)1.0E-6f);
        Assert.assertEquals((double)pressForelineLow, (double)item_.getPressForelineLow(), (double)1.0E-6f);
        Assert.assertEquals((double)pressIonEnable, (double)item_.getPressIonEnable(), (double)1.0E-6f);
        Assert.assertEquals((double)pressIonOff, (double)item_.getPressIonOff(), (double)1.0E-6f);
        Assert.assertEquals((double)pressRefrigOk, (double)item_.getPressRefrigOk(), (double)1.0E-6f);
        Assert.assertEquals((double)pressTurboLow, (double)item_.getPressTurboLow(), (double)1.0E-6f);
        Assert.assertEquals((double)pressVacuum, (double)item_.getPressVacuum(), (double)1.0E-6f);
        Assert.assertEquals((double)speedFractTurboLow, (double)item_.getSpeedFractTurboLow(), (double)1.0E-6f);
        Assert.assertEquals((long)tranTimeCryoGate, (long)item_.getTranTimeCryoGate());
        Assert.assertEquals((long)tranTimeHxGate, (long)item_.getTranTimeHxGate());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 443;
        int schedulers_default_nThreads = 258;
        int schedulers_monitor_update_publish_scheduler_nTasks = 198;
        int schedulers_monitor_update_publish_scheduler_nThreads = 861;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_GeneralConfigurationEvent));
        Daq_monitor_PeriodicTasks_GeneralConfigurationEvent item_ = (Daq_monitor_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "x";
        long agentmonitorservice_taskPeriodMillis = 954L;
        long heartbeat_taskPeriodMillis = 696L;
        long monitor_check_taskPeriodMillis = 184L;
        long monitor_publish_taskPeriodMillis = 936L;
        long monitor_update_taskPeriodMillis = 519L;
        long publishstats_taskPeriodMillis = 231L;
        long purgedaq_taskPeriodMillis = 827L;
        long runtimeinfo_taskPeriodMillis = 148L;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, publishstats_taskPeriodMillis, purgedaq_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_timersConfigurationEvent));
        Daq_monitor_PeriodicTasks_timersConfigurationEvent item_ = (Daq_monitor_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)publishstats_taskPeriodMillis, (long)item_.getPublishstats_taskPeriodMillis());
        Assert.assertEquals((long)purgedaq_taskPeriodMillis, (long)item_.getPurgedaq_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_StatisticsConfigurationEvent() throws Exception {
        String version = "";
        int minDiffAlertWarning = 498;
        int minDiffLogWarning = 118;
        String sumDriverChecks = "";
        String sumDriverStats = "";
        String sumFirmwareChecks = "";
        String sumFirmwareStats = "";
        String sumRdsChecks = "l";
        String sumRdsStats = "d";
        String sumRmsChecks = "a";
        String sumRmsStats = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_StatisticsConfigurationEvent(version, minDiffAlertWarning, minDiffLogWarning, sumDriverChecks, sumDriverStats, sumFirmwareChecks, sumFirmwareStats, sumRdsChecks, sumRdsStats, sumRmsChecks, sumRmsStats));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_StatisticsConfigurationEvent));
        Daq_monitor_Stats_StatisticsConfigurationEvent item_ = (Daq_monitor_Stats_StatisticsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)minDiffAlertWarning, (long)item_.getMinDiffAlertWarning());
        Assert.assertEquals((long)minDiffLogWarning, (long)item_.getMinDiffLogWarning());
        Assert.assertEquals((Object)sumDriverChecks, (Object)item_.getSumDriverChecks());
        Assert.assertEquals((Object)sumDriverStats, (Object)item_.getSumDriverStats());
        Assert.assertEquals((Object)sumFirmwareChecks, (Object)item_.getSumFirmwareChecks());
        Assert.assertEquals((Object)sumFirmwareStats, (Object)item_.getSumFirmwareStats());
        Assert.assertEquals((Object)sumRdsChecks, (Object)item_.getSumRdsChecks());
        Assert.assertEquals((Object)sumRdsStats, (Object)item_.getSumRdsStats());
        Assert.assertEquals((Object)sumRmsChecks, (Object)item_.getSumRmsChecks());
        Assert.assertEquals((Object)sumRmsStats, (Object)item_.getSumRmsStats());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreConfigurationEvent() throws Exception {
        String version = "e";
        int alarmPurgeFailures = 187;
        String daqPartition = "u";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StoreConfigurationEvent(version, alarmPurgeFailures, daqPartition));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreConfigurationEvent));
        Daq_monitor_StoreConfigurationEvent item_ = (Daq_monitor_StoreConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)alarmPurgeFailures, (long)item_.getAlarmPurgeFailures());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_DevicesConfigurationEvent));
        Daq_monitor_Store_DevicesConfigurationEvent item_ = (Daq_monitor_Store_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_LimitsConfigurationEvent() throws Exception {
        String version = "z";
        double freefraction_warnLo = 0.1350204348564148;
        double freefraction_limitLo = 0.9766664505004883;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_LimitsConfigurationEvent(version, freefraction_warnLo, freefraction_limitLo));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_LimitsConfigurationEvent));
        Daq_monitor_Store_LimitsConfigurationEvent item_ = (Daq_monitor_Store_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)freefraction_warnLo, (double)item_.getFreefraction_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitLo, (double)item_.getFreefraction_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Store_StoreConfigurationEvent() throws Exception {
        String version = "";
        String daqFolder = "r";
        boolean enableAutoPurge = true;
        double purgeTarget = 0.45492905378341675;
        double purgeThreshold = 0.37919121980667114;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_StoreConfigurationEvent(version, daqFolder, enableAutoPurge, purgeTarget, purgeThreshold));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_StoreConfigurationEvent));
        Daq_monitor_Store_StoreConfigurationEvent item_ = (Daq_monitor_Store_StoreConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)enableAutoPurge, (Object)item_.isEnableAutoPurge());
        Assert.assertEquals((double)purgeTarget, (double)item_.getPurgeTarget(), (double)1.0E-6f);
        Assert.assertEquals((double)purgeThreshold, (double)item_.getPurgeThreshold(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_HardwareIdConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        String manSerNum = "";
        String name = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_HardwareIdConfigurationEvent(version, location, manSerNum, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_HardwareIdConfigurationEvent));
        Focal_plane_Ccd_HardwareIdConfigurationEvent item_ = (Focal_plane_Ccd_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)manSerNum, (Object)item_.getManSerNum());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_LimitsConfigurationEvent() throws Exception {
        String version = "s";
        double[] gdv_warnHi = TestHelper.generateDoubleArray((int)201, (int)-1276219746);
        double[] gdv_warnLo = TestHelper.generateDoubleArray((int)201, (int)-286721487);
        double[] gdv_limitHi = TestHelper.generateDoubleArray((int)201, (int)-1250949407);
        double[] gdv_limitLo = TestHelper.generateDoubleArray((int)201, (int)-478378614);
        String location = "s";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)201, (int)-1537337908);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)201, (int)-131609750);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)201, (int)-264802918);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)201, (int)-297955630);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)201, (int)-1005758474);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)201, (int)1919295961);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)201, (int)202568268);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)201, (int)337325127);
        double[] ogv_warnHi = TestHelper.generateDoubleArray((int)201, (int)109094063);
        double[] ogv_warnLo = TestHelper.generateDoubleArray((int)201, (int)730061585);
        double[] ogv_limitHi = TestHelper.generateDoubleArray((int)201, (int)361795589);
        double[] ogv_limitLo = TestHelper.generateDoubleArray((int)201, (int)-1569978515);
        double[] rdv_warnHi = TestHelper.generateDoubleArray((int)201, (int)1593928955);
        double[] rdv_warnLo = TestHelper.generateDoubleArray((int)201, (int)-731488300);
        double[] rdv_limitHi = TestHelper.generateDoubleArray((int)201, (int)-972726851);
        double[] rdv_limitLo = TestHelper.generateDoubleArray((int)201, (int)-2046484407);
        double[] temp_warnHi = TestHelper.generateDoubleArray((int)201, (int)1674794956);
        double[] temp_warnLo = TestHelper.generateDoubleArray((int)201, (int)1162635661);
        double[] temp_limitHi = TestHelper.generateDoubleArray((int)201, (int)381272171);
        double[] temp_limitLo = TestHelper.generateDoubleArray((int)201, (int)1096561460);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_LimitsConfigurationEvent(version, gdv_warnHi, gdv_warnLo, gdv_limitHi, gdv_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, ogv_warnHi, ogv_warnLo, ogv_limitHi, ogv_limitLo, rdv_warnHi, rdv_warnLo, rdv_limitHi, rdv_limitLo, temp_warnHi, temp_warnLo, temp_limitHi, temp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_LimitsConfigurationEvent));
        Focal_plane_Ccd_LimitsConfigurationEvent item_ = (Focal_plane_Ccd_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])gdv_warnHi, (double[])item_.getGdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_warnLo, (double[])item_.getGdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitHi, (double[])item_.getGdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitLo, (double[])item_.getGdv_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnHi, (double[])item_.getOgv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnLo, (double[])item_.getOgv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitHi, (double[])item_.getOgv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitLo, (double[])item_.getOgv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnHi, (double[])item_.getRdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnLo, (double[])item_.getRdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitHi, (double[])item_.getRdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitLo, (double[])item_.getRdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnHi, (double[])item_.getTemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnLo, (double[])item_.getTemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitHi, (double[])item_.getTemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitLo, (double[])item_.getTemp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_ImageDatabaseService_GeneralConfigurationEvent() throws Exception {
        String version = "c";
        String dbURL = "";
        boolean enabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageDatabaseService_GeneralConfigurationEvent(version, dbURL, enabled));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageDatabaseService_GeneralConfigurationEvent));
        Focal_plane_ImageDatabaseService_GeneralConfigurationEvent item_ = (Focal_plane_ImageDatabaseService_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)enabled, (Object)item_.isEnabled());
    }

    @Test
    public void sendReceiveFocal_plane_ImageNameService_GeneralConfigurationEvent() throws Exception {
        String version = "";
        String controller = "o";
        String dbURL = "";
        String offset = "d";
        String source = "m";
        String timeZoneId = "x";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageNameService_GeneralConfigurationEvent(version, controller, dbURL, offset, source, timeZoneId));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageNameService_GeneralConfigurationEvent));
        Focal_plane_ImageNameService_GeneralConfigurationEvent item_ = (Focal_plane_ImageNameService_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)controller, (Object)item_.getController());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)offset, (Object)item_.getOffset());
        Assert.assertEquals((Object)source, (Object)item_.getSource());
        Assert.assertEquals((Object)timeZoneId, (Object)item_.getTimeZoneId());
    }

    @Test
    public void sendReceiveFocal_plane_InstrumentConfig_InstrumentConfigurationEvent() throws Exception {
        String version = "";
        String instrument = "c";
        String telescope = "r";
        String testStand = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_InstrumentConfig_InstrumentConfigurationEvent(version, instrument, telescope, testStand));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_InstrumentConfig_InstrumentConfigurationEvent));
        Focal_plane_InstrumentConfig_InstrumentConfigurationEvent item_ = (Focal_plane_InstrumentConfig_InstrumentConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)instrument, (Object)item_.getInstrument());
        Assert.assertEquals((Object)telescope, (Object)item_.getTelescope());
        Assert.assertEquals((Object)testStand, (Object)item_.getTestStand());
    }

    @Test
    public void sendReceiveFocal_plane_MonitoringConfig_MonitoringConfigurationEvent() throws Exception {
        String version = "f";
        String postReadoutTriggerTasks = "";
        String readoutPauseTasks = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_MonitoringConfig_MonitoringConfigurationEvent(version, postReadoutTriggerTasks, readoutPauseTasks));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_MonitoringConfig_MonitoringConfigurationEvent));
        Focal_plane_MonitoringConfig_MonitoringConfigurationEvent item_ = (Focal_plane_MonitoringConfig_MonitoringConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)postReadoutTriggerTasks, (Object)item_.getPostReadoutTriggerTasks());
        Assert.assertEquals((Object)readoutPauseTasks, (Object)item_.getReadoutPauseTasks());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 258;
        int schedulers_default_nThreads = 461;
        int schedulers_monitor_check_scheduler_nTasks = 934;
        int schedulers_monitor_check_scheduler_nThreads = 443;
        int schedulers_monitor_update_publish_scheduler_nTasks = 793;
        int schedulers_monitor_update_publish_scheduler_nThreads = 884;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_GeneralConfigurationEvent));
        Focal_plane_PeriodicTasks_GeneralConfigurationEvent item_ = (Focal_plane_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 236L;
        long heartbeat_taskPeriodMillis = 501L;
        long monitor_publish_taskPeriodMillis = 839L;
        long monitor_update_taskPeriodMillis = 164L;
        long runtimeinfo_taskPeriodMillis = 140L;
        long tempcontrol_R00_taskPeriodMillis = 326L;
        long tempcontrol_R01_taskPeriodMillis = 704L;
        long tempcontrol_R02_taskPeriodMillis = 55L;
        long tempcontrol_R03_taskPeriodMillis = 508L;
        long tempcontrol_R04_taskPeriodMillis = 277L;
        long tempcontrol_R10_taskPeriodMillis = 817L;
        long tempcontrol_R11_taskPeriodMillis = 800L;
        long tempcontrol_R12_taskPeriodMillis = 340L;
        long tempcontrol_R13_taskPeriodMillis = 986L;
        long tempcontrol_R14_taskPeriodMillis = 815L;
        long tempcontrol_R20_taskPeriodMillis = 66L;
        long tempcontrol_R21_taskPeriodMillis = 517L;
        long tempcontrol_R22_taskPeriodMillis = 498L;
        long tempcontrol_R23_taskPeriodMillis = 202L;
        long tempcontrol_R24_taskPeriodMillis = 586L;
        long tempcontrol_R30_taskPeriodMillis = 528L;
        long tempcontrol_R31_taskPeriodMillis = 454L;
        long tempcontrol_R32_taskPeriodMillis = 804L;
        long tempcontrol_R33_taskPeriodMillis = 894L;
        long tempcontrol_R34_taskPeriodMillis = 897L;
        long tempcontrol_R40_taskPeriodMillis = 279L;
        long tempcontrol_R41_taskPeriodMillis = 675L;
        long tempcontrol_R42_taskPeriodMillis = 802L;
        long tempcontrol_R43_taskPeriodMillis = 891L;
        long tempcontrol_R44_taskPeriodMillis = 293L;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, tempcontrol_R00_taskPeriodMillis, tempcontrol_R01_taskPeriodMillis, tempcontrol_R02_taskPeriodMillis, tempcontrol_R03_taskPeriodMillis, tempcontrol_R04_taskPeriodMillis, tempcontrol_R10_taskPeriodMillis, tempcontrol_R11_taskPeriodMillis, tempcontrol_R12_taskPeriodMillis, tempcontrol_R13_taskPeriodMillis, tempcontrol_R14_taskPeriodMillis, tempcontrol_R20_taskPeriodMillis, tempcontrol_R21_taskPeriodMillis, tempcontrol_R22_taskPeriodMillis, tempcontrol_R23_taskPeriodMillis, tempcontrol_R24_taskPeriodMillis, tempcontrol_R30_taskPeriodMillis, tempcontrol_R31_taskPeriodMillis, tempcontrol_R32_taskPeriodMillis, tempcontrol_R33_taskPeriodMillis, tempcontrol_R34_taskPeriodMillis, tempcontrol_R40_taskPeriodMillis, tempcontrol_R41_taskPeriodMillis, tempcontrol_R42_taskPeriodMillis, tempcontrol_R43_taskPeriodMillis, tempcontrol_R44_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_timersConfigurationEvent));
        Focal_plane_PeriodicTasks_timersConfigurationEvent item_ = (Focal_plane_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R00_taskPeriodMillis, (long)item_.getTempcontrol_R00_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R01_taskPeriodMillis, (long)item_.getTempcontrol_R01_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R02_taskPeriodMillis, (long)item_.getTempcontrol_R02_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R03_taskPeriodMillis, (long)item_.getTempcontrol_R03_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R04_taskPeriodMillis, (long)item_.getTempcontrol_R04_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R10_taskPeriodMillis, (long)item_.getTempcontrol_R10_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R11_taskPeriodMillis, (long)item_.getTempcontrol_R11_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R12_taskPeriodMillis, (long)item_.getTempcontrol_R12_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R13_taskPeriodMillis, (long)item_.getTempcontrol_R13_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R14_taskPeriodMillis, (long)item_.getTempcontrol_R14_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R20_taskPeriodMillis, (long)item_.getTempcontrol_R20_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R21_taskPeriodMillis, (long)item_.getTempcontrol_R21_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R22_taskPeriodMillis, (long)item_.getTempcontrol_R22_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R23_taskPeriodMillis, (long)item_.getTempcontrol_R23_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R24_taskPeriodMillis, (long)item_.getTempcontrol_R24_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R30_taskPeriodMillis, (long)item_.getTempcontrol_R30_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R31_taskPeriodMillis, (long)item_.getTempcontrol_R31_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R32_taskPeriodMillis, (long)item_.getTempcontrol_R32_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R33_taskPeriodMillis, (long)item_.getTempcontrol_R33_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R34_taskPeriodMillis, (long)item_.getTempcontrol_R34_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R40_taskPeriodMillis, (long)item_.getTempcontrol_R40_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R41_taskPeriodMillis, (long)item_.getTempcontrol_R41_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R42_taskPeriodMillis, (long)item_.getTempcontrol_R42_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R43_taskPeriodMillis, (long)item_.getTempcontrol_R43_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R44_taskPeriodMillis, (long)item_.getTempcontrol_R44_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_HardwareIdConfigurationEvent() throws Exception {
        String version = "r";
        String location = "";
        String name = "l";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_HardwareIdConfigurationEvent(version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_HardwareIdConfigurationEvent));
        Focal_plane_Raft_HardwareIdConfigurationEvent item_ = (Focal_plane_Raft_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlConfigurationEvent() throws Exception {
        String version = "q";
        String location = "";
        double[] tempcontrol_basePower = TestHelper.generateDoubleArray((int)25, (int)2140394004);
        double[] tempcontrol_coefD = TestHelper.generateDoubleArray((int)25, (int)1364803718);
        double[] tempcontrol_coefI = TestHelper.generateDoubleArray((int)25, (int)-194051483);
        double[] tempcontrol_coefP = TestHelper.generateDoubleArray((int)25, (int)-1219645715);
        double[] tempcontrol_maxInput = TestHelper.generateDoubleArray((int)25, (int)192553989);
        double[] tempcontrol_maxOutput = TestHelper.generateDoubleArray((int)25, (int)1033907135);
        double[] tempcontrol_minInput = TestHelper.generateDoubleArray((int)25, (int)495108437);
        double[] tempcontrol_minOutput = TestHelper.generateDoubleArray((int)25, (int)-116946143);
        String tempcontrol_rebs = "a";
        double[] tempcontrol_setTemp = TestHelper.generateDoubleArray((int)25, (int)-755878378);
        double[] tempcontrol_smoothTime = TestHelper.generateDoubleArray((int)25, (int)-1322803391);
        String tempcontrol_tempChans = "u";
        double[] tempcontrol_timeConst = TestHelper.generateDoubleArray((int)25, (int)-150011083);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlConfigurationEvent(version, location, tempcontrol_basePower, tempcontrol_coefD, tempcontrol_coefI, tempcontrol_coefP, tempcontrol_maxInput, tempcontrol_maxOutput, tempcontrol_minInput, tempcontrol_minOutput, tempcontrol_rebs, tempcontrol_setTemp, tempcontrol_smoothTime, tempcontrol_tempChans, tempcontrol_timeConst));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlConfigurationEvent));
        Focal_plane_Raft_RaftTempControlConfigurationEvent item_ = (Focal_plane_Raft_RaftTempControlConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])tempcontrol_basePower, (double[])item_.getTempcontrol_basePower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefD, (double[])item_.getTempcontrol_coefD(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefI, (double[])item_.getTempcontrol_coefI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefP, (double[])item_.getTempcontrol_coefP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxInput, (double[])item_.getTempcontrol_maxInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxOutput, (double[])item_.getTempcontrol_maxOutput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minInput, (double[])item_.getTempcontrol_minInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minOutput, (double[])item_.getTempcontrol_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_rebs, (Object)item_.getTempcontrol_rebs());
        Assert.assertArrayEquals((double[])tempcontrol_setTemp, (double[])item_.getTempcontrol_setTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_smoothTime, (double[])item_.getTempcontrol_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_tempChans, (Object)item_.getTempcontrol_tempChans());
        Assert.assertArrayEquals((double[])tempcontrol_timeConst, (double[])item_.getTempcontrol_timeConst(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlStatusConfigurationEvent() throws Exception {
        String version = "i";
        String location = "j";
        boolean[] tempcontrol_active = new boolean[]{true, true, true, true, false, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, true, true, true, false, false};
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlStatusConfigurationEvent(version, location, tempcontrol_active));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlStatusConfigurationEvent));
        Focal_plane_Raft_RaftTempControlStatusConfigurationEvent item_ = (Focal_plane_Raft_RaftTempControlStatusConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((boolean[])tempcontrol_active, (boolean[])item_.getTempcontrol_active());
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPower_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.8502306342124939;
        double warnLo = 0.378143f;
        double limitHi = 0.1214962f;
        double limitLo = 0.11793404817581177;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebTotalPower_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPower_LimitsConfigurationEvent));
        Focal_plane_RebTotalPower_LimitsConfigurationEvent item_ = (Focal_plane_RebTotalPower_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_DevicesConfigurationEvent() throws Exception {
        String version = "c";
        boolean[] disabled = new boolean[]{true, false, false, false, false, true, true, true, true, false, false, true, false, true, false, false, false, false, true, true, true, true, false, true, false, false, true, false, true, false, true, true, false, false, true, true, true, true, true, false, true, true, true, false, false, false, true, false, true, true, true, true, false, false, false, true, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false};
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_DevicesConfigurationEvent(version, disabled, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_DevicesConfigurationEvent));
        Focal_plane_Reb_DevicesConfigurationEvent item_ = (Focal_plane_Reb_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((boolean[])disabled, (boolean[])item_.getDisabled());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_GeneralConfigurationEvent() throws Exception {
        String version = "t";
        String location = "";
        String tempavg_temperatureNames = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_GeneralConfigurationEvent(version, location, tempavg_temperatureNames));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_GeneralConfigurationEvent));
        Focal_plane_Reb_GeneralConfigurationEvent item_ = (Focal_plane_Reb_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)tempavg_temperatureNames, (Object)item_.getTempavg_temperatureNames());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_HardwareIdConfigurationEvent() throws Exception {
        String version = "h";
        String location = "";
        String name = "w";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_HardwareIdConfigurationEvent(version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_HardwareIdConfigurationEvent));
        Focal_plane_Reb_HardwareIdConfigurationEvent item_ = (Focal_plane_Reb_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_LimitsConfigurationEvent() throws Exception {
        String version = "l";
        double[] anai_warnHi = TestHelper.generateDoubleArray((int)71, (int)85441244);
        double[] anai_warnLo = TestHelper.generateDoubleArray((int)71, (int)842409536);
        double[] anai_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1726177224);
        double[] anai_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1515240082);
        double[] anav_warnHi = TestHelper.generateDoubleArray((int)71, (int)-991704740);
        double[] anav_warnLo = TestHelper.generateDoubleArray((int)71, (int)-825340236);
        double[] anav_limitHi = TestHelper.generateDoubleArray((int)71, (int)1564315758);
        double[] anav_limitLo = TestHelper.generateDoubleArray((int)71, (int)438662221);
        double[] aspicl_Temp0_warnHi = TestHelper.generateDoubleArray((int)71, (int)-156787708);
        double[] aspicl_Temp0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1247997204);
        double[] aspicl_Temp0_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1243889219);
        double[] aspicl_Temp0_limitLo = TestHelper.generateDoubleArray((int)71, (int)-912061309);
        double[] aspicl_Temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)2079393570);
        double[] aspicl_Temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1268841353);
        double[] aspicl_Temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)880393939);
        double[] aspicl_Temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)34920083);
        double[] aspicl_Temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1200798902);
        double[] aspicl_Temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)724108399);
        double[] aspicl_Temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2002967109);
        double[] aspicl_Temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1819041484);
        double[] aspicu_Temp0_warnHi = TestHelper.generateDoubleArray((int)71, (int)1371938517);
        double[] aspicu_Temp0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1493923365);
        double[] aspicu_Temp0_limitHi = TestHelper.generateDoubleArray((int)71, (int)-252282763);
        double[] aspicu_Temp0_limitLo = TestHelper.generateDoubleArray((int)71, (int)1680672856);
        double[] aspicu_Temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)1855738507);
        double[] aspicu_Temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)-935368107);
        double[] aspicu_Temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)719119042);
        double[] aspicu_Temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-758962071);
        double[] aspicu_Temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)92663199);
        double[] aspicu_Temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1756559124);
        double[] aspicu_Temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-731903682);
        double[] aspicu_Temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1222786603);
        double[] clkhi_warnHi = TestHelper.generateDoubleArray((int)71, (int)2146634971);
        double[] clkhi_warnLo = TestHelper.generateDoubleArray((int)71, (int)1477513035);
        double[] clkhi_limitHi = TestHelper.generateDoubleArray((int)71, (int)1858024884);
        double[] clkhi_limitLo = TestHelper.generateDoubleArray((int)71, (int)904630476);
        double[] clkhv_warnHi = TestHelper.generateDoubleArray((int)71, (int)340414747);
        double[] clkhv_warnLo = TestHelper.generateDoubleArray((int)71, (int)1168774426);
        double[] clkhv_limitHi = TestHelper.generateDoubleArray((int)71, (int)1815508141);
        double[] clkhv_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2045059768);
        double[] clkli_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1716401921);
        double[] clkli_warnLo = TestHelper.generateDoubleArray((int)71, (int)-892020317);
        double[] clkli_limitHi = TestHelper.generateDoubleArray((int)71, (int)436697162);
        double[] clkli_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2049145011);
        double[] clklv_warnHi = TestHelper.generateDoubleArray((int)71, (int)-32488997);
        double[] clklv_warnLo = TestHelper.generateDoubleArray((int)71, (int)673641400);
        double[] clklv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-5417901);
        double[] clklv_limitLo = TestHelper.generateDoubleArray((int)71, (int)2031424369);
        double[] digi_warnHi = TestHelper.generateDoubleArray((int)71, (int)-283233294);
        double[] digi_warnLo = TestHelper.generateDoubleArray((int)71, (int)2087328724);
        double[] digi_limitHi = TestHelper.generateDoubleArray((int)71, (int)59205519);
        double[] digi_limitLo = TestHelper.generateDoubleArray((int)71, (int)624130975);
        double[] digv_warnHi = TestHelper.generateDoubleArray((int)71, (int)555531748);
        double[] digv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1386253184);
        double[] digv_limitHi = TestHelper.generateDoubleArray((int)71, (int)1832453717);
        double[] digv_limitLo = TestHelper.generateDoubleArray((int)71, (int)1604175895);
        double[] hvbiasswitch_warnHi = TestHelper.generateDoubleArray((int)71, (int)205284196);
        double[] hvbiasswitch_warnLo = TestHelper.generateDoubleArray((int)71, (int)1103394040);
        double[] hvbiasswitch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1413432733);
        double[] hvbiasswitch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-127945544);
        double[] htrpi_warnHi = TestHelper.generateDoubleArray((int)71, (int)337937197);
        double[] htrpi_warnLo = TestHelper.generateDoubleArray((int)71, (int)1055480334);
        double[] htrpi_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1574753299);
        double[] htrpi_limitLo = TestHelper.generateDoubleArray((int)71, (int)583526017);
        double[] htrpv_warnHi = TestHelper.generateDoubleArray((int)71, (int)514308150);
        double[] htrpv_warnLo = TestHelper.generateDoubleArray((int)71, (int)381894989);
        double[] htrpv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2035087367);
        double[] htrpv_limitLo = TestHelper.generateDoubleArray((int)71, (int)1298429269);
        double[] htrv_warnHi = TestHelper.generateDoubleArray((int)71, (int)1723898404);
        double[] htrv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1788718496);
        double[] htrv_limitHi = TestHelper.generateDoubleArray((int)71, (int)130054121);
        double[] htrv_limitLo = TestHelper.generateDoubleArray((int)71, (int)-90714626);
        double[] htrw_warnHi = TestHelper.generateDoubleArray((int)71, (int)1253413119);
        double[] htrw_warnLo = TestHelper.generateDoubleArray((int)71, (int)408328885);
        double[] htrw_limitHi = TestHelper.generateDoubleArray((int)71, (int)839908953);
        double[] htrw_limitLo = TestHelper.generateDoubleArray((int)71, (int)386609267);
        String location = "";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1508606115);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)71, (int)1528941866);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2083238307);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)71, (int)2118896778);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)71, (int)1360259381);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)71, (int)1078978783);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-747123241);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)71, (int)1509179920);
        double[] pclk0_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1334603958);
        double[] pclk0_warnLo = TestHelper.generateDoubleArray((int)71, (int)1700441383);
        double[] pclk0_limitHi = TestHelper.generateDoubleArray((int)71, (int)1531622517);
        double[] pclk0_limitLo = TestHelper.generateDoubleArray((int)71, (int)907353174);
        double[] pclk1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1063517319);
        double[] pclk1_warnLo = TestHelper.generateDoubleArray((int)71, (int)375424698);
        double[] pclk1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1034879352);
        double[] pclk1_limitLo = TestHelper.generateDoubleArray((int)71, (int)1292342946);
        double[] pclkl_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1208720042);
        double[] pclkl_warnLo = TestHelper.generateDoubleArray((int)71, (int)-206113176);
        double[] pclkl_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1277696353);
        double[] pclkl_limitLo = TestHelper.generateDoubleArray((int)71, (int)-721606891);
        double[] pclku_warnHi = TestHelper.generateDoubleArray((int)71, (int)-260776113);
        double[] pclku_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1763167890);
        double[] pclku_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1561419441);
        double[] pclku_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1010202339);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)71, (int)83972624);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)71, (int)1081733899);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)71, (int)-188182217);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2128708819);
        double[] rg0_warnHi = TestHelper.generateDoubleArray((int)71, (int)1530450471);
        double[] rg0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-78163118);
        double[] rg0_limitHi = TestHelper.generateDoubleArray((int)71, (int)255866686);
        double[] rg0_limitLo = TestHelper.generateDoubleArray((int)71, (int)785982384);
        double[] rg1_warnHi = TestHelper.generateDoubleArray((int)71, (int)504159211);
        double[] rg1_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1241467071);
        double[] rg1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-832412898);
        double[] rg1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-192130758);
        double[] rgl_warnHi = TestHelper.generateDoubleArray((int)71, (int)-448962150);
        double[] rgl_warnLo = TestHelper.generateDoubleArray((int)71, (int)1212296723);
        double[] rgl_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1403164634);
        double[] rgl_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2039346688);
        double[] rgu_warnHi = TestHelper.generateDoubleArray((int)71, (int)134551489);
        double[] rgu_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1755197486);
        double[] rgu_limitHi = TestHelper.generateDoubleArray((int)71, (int)1520982587);
        double[] rgu_limitLo = TestHelper.generateDoubleArray((int)71, (int)1403133578);
        double[] rtdtemp_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1475107872);
        double[] rtdtemp_warnLo = TestHelper.generateDoubleArray((int)71, (int)1069347119);
        double[] rtdtemp_limitHi = TestHelper.generateDoubleArray((int)71, (int)-705521889);
        double[] rtdtemp_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1156402266);
        double[] ref05v_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2086039219);
        double[] ref05v_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1562099563);
        double[] ref05v_limitHi = TestHelper.generateDoubleArray((int)71, (int)-794025995);
        double[] ref05v_limitLo = TestHelper.generateDoubleArray((int)71, (int)-440207457);
        double[] ref125v_warnHi = TestHelper.generateDoubleArray((int)71, (int)1552167000);
        double[] ref125v_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1850466181);
        double[] ref125v_limitHi = TestHelper.generateDoubleArray((int)71, (int)503023364);
        double[] ref125v_limitLo = TestHelper.generateDoubleArray((int)71, (int)1841264303);
        double[] ref15v_warnHi = TestHelper.generateDoubleArray((int)71, (int)1803928495);
        double[] ref15v_warnLo = TestHelper.generateDoubleArray((int)71, (int)870830841);
        double[] ref15v_limitHi = TestHelper.generateDoubleArray((int)71, (int)150894011);
        double[] ref15v_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2135768399);
        double[] ref25v_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1058496508);
        double[] ref25v_warnLo = TestHelper.generateDoubleArray((int)71, (int)1333480094);
        double[] ref25v_limitHi = TestHelper.generateDoubleArray((int)71, (int)-159510796);
        double[] ref25v_limitLo = TestHelper.generateDoubleArray((int)71, (int)1487692314);
        double[] refn12_warnHi = TestHelper.generateDoubleArray((int)71, (int)1284645356);
        double[] refn12_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1021791104);
        double[] refn12_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1844399748);
        double[] refn12_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1846330839);
        double[] refp12_warnHi = TestHelper.generateDoubleArray((int)71, (int)1946459658);
        double[] refp12_warnLo = TestHelper.generateDoubleArray((int)71, (int)1426853779);
        double[] refp12_limitHi = TestHelper.generateDoubleArray((int)71, (int)523689683);
        double[] refp12_limitLo = TestHelper.generateDoubleArray((int)71, (int)1616373853);
        double[] sclk0_warnHi = TestHelper.generateDoubleArray((int)71, (int)-776097940);
        double[] sclk0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-452434626);
        double[] sclk0_limitHi = TestHelper.generateDoubleArray((int)71, (int)1536772655);
        double[] sclk0_limitLo = TestHelper.generateDoubleArray((int)71, (int)-187777241);
        double[] sclk1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-557807564);
        double[] sclk1_warnLo = TestHelper.generateDoubleArray((int)71, (int)1873770283);
        double[] sclk1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-43363386);
        double[] sclk1_limitLo = TestHelper.generateDoubleArray((int)71, (int)2086689249);
        double[] sclkl_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1595791238);
        double[] sclkl_warnLo = TestHelper.generateDoubleArray((int)71, (int)277214814);
        double[] sclkl_limitHi = TestHelper.generateDoubleArray((int)71, (int)273511501);
        double[] sclkl_limitLo = TestHelper.generateDoubleArray((int)71, (int)788200446);
        double[] sclku_warnHi = TestHelper.generateDoubleArray((int)71, (int)-244867215);
        double[] sclku_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2029283447);
        double[] sclku_limitHi = TestHelper.generateDoubleArray((int)71, (int)-666149701);
        double[] sclku_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2036453503);
        double[] temp10_warnHi = TestHelper.generateDoubleArray((int)71, (int)-706430264);
        double[] temp10_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2024826723);
        double[] temp10_limitHi = TestHelper.generateDoubleArray((int)71, (int)226610770);
        double[] temp10_limitLo = TestHelper.generateDoubleArray((int)71, (int)1090344627);
        double[] temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1421096878);
        double[] temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)-221279324);
        double[] temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)279604959);
        double[] temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2041764593);
        double[] temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)1594183144);
        double[] temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1258849587);
        double[] temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2004607681);
        double[] temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-222612607);
        double[] temp3_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1645159538);
        double[] temp3_warnLo = TestHelper.generateDoubleArray((int)71, (int)1954003400);
        double[] temp3_limitHi = TestHelper.generateDoubleArray((int)71, (int)-824276443);
        double[] temp3_limitLo = TestHelper.generateDoubleArray((int)71, (int)1011753935);
        double[] temp4_warnHi = TestHelper.generateDoubleArray((int)71, (int)463363028);
        double[] temp4_warnLo = TestHelper.generateDoubleArray((int)71, (int)957741140);
        double[] temp4_limitHi = TestHelper.generateDoubleArray((int)71, (int)-641722085);
        double[] temp4_limitLo = TestHelper.generateDoubleArray((int)71, (int)1742735191);
        double[] temp5_warnHi = TestHelper.generateDoubleArray((int)71, (int)-551451010);
        double[] temp5_warnLo = TestHelper.generateDoubleArray((int)71, (int)31746581);
        double[] temp5_limitHi = TestHelper.generateDoubleArray((int)71, (int)1310346694);
        double[] temp5_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1932788486);
        double[] temp6_warnHi = TestHelper.generateDoubleArray((int)71, (int)-992519834);
        double[] temp6_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1692198998);
        double[] temp6_limitHi = TestHelper.generateDoubleArray((int)71, (int)369183085);
        double[] temp6_limitLo = TestHelper.generateDoubleArray((int)71, (int)-754763176);
        double[] temp7_warnHi = TestHelper.generateDoubleArray((int)71, (int)663731105);
        double[] temp7_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1430475521);
        double[] temp7_limitHi = TestHelper.generateDoubleArray((int)71, (int)-526443333);
        double[] temp7_limitLo = TestHelper.generateDoubleArray((int)71, (int)-506661827);
        double[] temp8_warnHi = TestHelper.generateDoubleArray((int)71, (int)1443606241);
        double[] temp8_warnLo = TestHelper.generateDoubleArray((int)71, (int)1469143262);
        double[] temp8_limitHi = TestHelper.generateDoubleArray((int)71, (int)375648708);
        double[] temp8_limitLo = TestHelper.generateDoubleArray((int)71, (int)1371003482);
        double[] temp9_warnHi = TestHelper.generateDoubleArray((int)71, (int)769831705);
        double[] temp9_warnLo = TestHelper.generateDoubleArray((int)71, (int)1742180812);
        double[] temp9_limitHi = TestHelper.generateDoubleArray((int)71, (int)75518533);
        double[] temp9_limitLo = TestHelper.generateDoubleArray((int)71, (int)-914679241);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_LimitsConfigurationEvent(version, anai_warnHi, anai_warnLo, anai_limitHi, anai_limitLo, anav_warnHi, anav_warnLo, anav_limitHi, anav_limitLo, aspicl_Temp0_warnHi, aspicl_Temp0_warnLo, aspicl_Temp0_limitHi, aspicl_Temp0_limitLo, aspicl_Temp1_warnHi, aspicl_Temp1_warnLo, aspicl_Temp1_limitHi, aspicl_Temp1_limitLo, aspicl_Temp2_warnHi, aspicl_Temp2_warnLo, aspicl_Temp2_limitHi, aspicl_Temp2_limitLo, aspicu_Temp0_warnHi, aspicu_Temp0_warnLo, aspicu_Temp0_limitHi, aspicu_Temp0_limitLo, aspicu_Temp1_warnHi, aspicu_Temp1_warnLo, aspicu_Temp1_limitHi, aspicu_Temp1_limitLo, aspicu_Temp2_warnHi, aspicu_Temp2_warnLo, aspicu_Temp2_limitHi, aspicu_Temp2_limitLo, clkhi_warnHi, clkhi_warnLo, clkhi_limitHi, clkhi_limitLo, clkhv_warnHi, clkhv_warnLo, clkhv_limitHi, clkhv_limitLo, clkli_warnHi, clkli_warnLo, clkli_limitHi, clkli_limitLo, clklv_warnHi, clklv_warnLo, clklv_limitHi, clklv_limitLo, digi_warnHi, digi_warnLo, digi_limitHi, digi_limitLo, digv_warnHi, digv_warnLo, digv_limitHi, digv_limitLo, hvbiasswitch_warnHi, hvbiasswitch_warnLo, hvbiasswitch_limitHi, hvbiasswitch_limitLo, htrpi_warnHi, htrpi_warnLo, htrpi_limitHi, htrpi_limitLo, htrpv_warnHi, htrpv_warnLo, htrpv_limitHi, htrpv_limitLo, htrv_warnHi, htrv_warnLo, htrv_limitHi, htrv_limitLo, htrw_warnHi, htrw_warnLo, htrw_limitHi, htrw_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, pclk0_warnHi, pclk0_warnLo, pclk0_limitHi, pclk0_limitLo, pclk1_warnHi, pclk1_warnLo, pclk1_limitHi, pclk1_limitLo, pclkl_warnHi, pclkl_warnLo, pclkl_limitHi, pclkl_limitLo, pclku_warnHi, pclku_warnLo, pclku_limitHi, pclku_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rg0_warnHi, rg0_warnLo, rg0_limitHi, rg0_limitLo, rg1_warnHi, rg1_warnLo, rg1_limitHi, rg1_limitLo, rgl_warnHi, rgl_warnLo, rgl_limitHi, rgl_limitLo, rgu_warnHi, rgu_warnLo, rgu_limitHi, rgu_limitLo, rtdtemp_warnHi, rtdtemp_warnLo, rtdtemp_limitHi, rtdtemp_limitLo, ref05v_warnHi, ref05v_warnLo, ref05v_limitHi, ref05v_limitLo, ref125v_warnHi, ref125v_warnLo, ref125v_limitHi, ref125v_limitLo, ref15v_warnHi, ref15v_warnLo, ref15v_limitHi, ref15v_limitLo, ref25v_warnHi, ref25v_warnLo, ref25v_limitHi, ref25v_limitLo, refn12_warnHi, refn12_warnLo, refn12_limitHi, refn12_limitLo, refp12_warnHi, refp12_warnLo, refp12_limitHi, refp12_limitLo, sclk0_warnHi, sclk0_warnLo, sclk0_limitHi, sclk0_limitLo, sclk1_warnHi, sclk1_warnLo, sclk1_limitHi, sclk1_limitLo, sclkl_warnHi, sclkl_warnLo, sclkl_limitHi, sclkl_limitLo, sclku_warnHi, sclku_warnLo, sclku_limitHi, sclku_limitLo, temp10_warnHi, temp10_warnLo, temp10_limitHi, temp10_limitLo, temp1_warnHi, temp1_warnLo, temp1_limitHi, temp1_limitLo, temp2_warnHi, temp2_warnLo, temp2_limitHi, temp2_limitLo, temp3_warnHi, temp3_warnLo, temp3_limitHi, temp3_limitLo, temp4_warnHi, temp4_warnLo, temp4_limitHi, temp4_limitLo, temp5_warnHi, temp5_warnLo, temp5_limitHi, temp5_limitLo, temp6_warnHi, temp6_warnLo, temp6_limitHi, temp6_limitLo, temp7_warnHi, temp7_warnLo, temp7_limitHi, temp7_limitLo, temp8_warnHi, temp8_warnLo, temp8_limitHi, temp8_limitLo, temp9_warnHi, temp9_warnLo, temp9_limitHi, temp9_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_LimitsConfigurationEvent));
        Focal_plane_Reb_LimitsConfigurationEvent item_ = (Focal_plane_Reb_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])anai_warnHi, (double[])item_.getAnai_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_warnLo, (double[])item_.getAnai_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitHi, (double[])item_.getAnai_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitLo, (double[])item_.getAnai_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnHi, (double[])item_.getAnav_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnLo, (double[])item_.getAnav_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitHi, (double[])item_.getAnav_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitLo, (double[])item_.getAnav_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnHi, (double[])item_.getAspicl_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnLo, (double[])item_.getAspicl_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitHi, (double[])item_.getAspicl_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitLo, (double[])item_.getAspicl_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnHi, (double[])item_.getAspicl_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnLo, (double[])item_.getAspicl_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitHi, (double[])item_.getAspicl_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitLo, (double[])item_.getAspicl_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnHi, (double[])item_.getAspicl_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnLo, (double[])item_.getAspicl_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitHi, (double[])item_.getAspicl_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitLo, (double[])item_.getAspicl_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnHi, (double[])item_.getAspicu_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnLo, (double[])item_.getAspicu_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitHi, (double[])item_.getAspicu_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitLo, (double[])item_.getAspicu_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnHi, (double[])item_.getAspicu_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnLo, (double[])item_.getAspicu_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitHi, (double[])item_.getAspicu_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitLo, (double[])item_.getAspicu_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnHi, (double[])item_.getAspicu_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnLo, (double[])item_.getAspicu_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitHi, (double[])item_.getAspicu_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitLo, (double[])item_.getAspicu_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnHi, (double[])item_.getClkhi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnLo, (double[])item_.getClkhi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitHi, (double[])item_.getClkhi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitLo, (double[])item_.getClkhi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnHi, (double[])item_.getClkhv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnLo, (double[])item_.getClkhv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitHi, (double[])item_.getClkhv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitLo, (double[])item_.getClkhv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnHi, (double[])item_.getClkli_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnLo, (double[])item_.getClkli_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitHi, (double[])item_.getClkli_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitLo, (double[])item_.getClkli_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnHi, (double[])item_.getClklv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnLo, (double[])item_.getClklv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitHi, (double[])item_.getClklv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitLo, (double[])item_.getClklv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnHi, (double[])item_.getDigi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnLo, (double[])item_.getDigi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitHi, (double[])item_.getDigi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitLo, (double[])item_.getDigi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnHi, (double[])item_.getDigv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnLo, (double[])item_.getDigv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitHi, (double[])item_.getDigv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitLo, (double[])item_.getDigv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnHi, (double[])item_.getHvbiasswitch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnLo, (double[])item_.getHvbiasswitch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitHi, (double[])item_.getHvbiasswitch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitLo, (double[])item_.getHvbiasswitch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnHi, (double[])item_.getHtrpi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnLo, (double[])item_.getHtrpi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitHi, (double[])item_.getHtrpi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitLo, (double[])item_.getHtrpi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnHi, (double[])item_.getHtrpv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnLo, (double[])item_.getHtrpv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitHi, (double[])item_.getHtrpv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitLo, (double[])item_.getHtrpv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnHi, (double[])item_.getHtrv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnLo, (double[])item_.getHtrv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitHi, (double[])item_.getHtrv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitLo, (double[])item_.getHtrv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnHi, (double[])item_.getHtrw_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnLo, (double[])item_.getHtrw_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitHi, (double[])item_.getHtrw_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitLo, (double[])item_.getHtrw_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnHi, (double[])item_.getPclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnLo, (double[])item_.getPclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitHi, (double[])item_.getPclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitLo, (double[])item_.getPclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_warnHi, (double[])item_.getPclk1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_warnLo, (double[])item_.getPclk1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_limitHi, (double[])item_.getPclk1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_limitLo, (double[])item_.getPclk1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnHi, (double[])item_.getPclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnLo, (double[])item_.getPclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitHi, (double[])item_.getPclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitLo, (double[])item_.getPclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnHi, (double[])item_.getPclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnLo, (double[])item_.getPclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitHi, (double[])item_.getPclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitLo, (double[])item_.getPclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnHi, (double[])item_.getRg0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnLo, (double[])item_.getRg0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitHi, (double[])item_.getRg0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitLo, (double[])item_.getRg0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_warnHi, (double[])item_.getRg1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_warnLo, (double[])item_.getRg1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_limitHi, (double[])item_.getRg1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_limitLo, (double[])item_.getRg1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnHi, (double[])item_.getRgl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnLo, (double[])item_.getRgl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitHi, (double[])item_.getRgl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitLo, (double[])item_.getRgl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnHi, (double[])item_.getRgu_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnLo, (double[])item_.getRgu_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitHi, (double[])item_.getRgu_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitLo, (double[])item_.getRgu_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnHi, (double[])item_.getRtdtemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnLo, (double[])item_.getRtdtemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitHi, (double[])item_.getRtdtemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitLo, (double[])item_.getRtdtemp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnHi, (double[])item_.getRef05v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnLo, (double[])item_.getRef05v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitHi, (double[])item_.getRef05v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitLo, (double[])item_.getRef05v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnHi, (double[])item_.getRef125v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnLo, (double[])item_.getRef125v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitHi, (double[])item_.getRef125v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitLo, (double[])item_.getRef125v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnHi, (double[])item_.getRef15v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnLo, (double[])item_.getRef15v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitHi, (double[])item_.getRef15v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitLo, (double[])item_.getRef15v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnHi, (double[])item_.getRef25v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnLo, (double[])item_.getRef25v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitHi, (double[])item_.getRef25v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitLo, (double[])item_.getRef25v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnHi, (double[])item_.getRefn12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnLo, (double[])item_.getRefn12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitHi, (double[])item_.getRefn12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitLo, (double[])item_.getRefn12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnHi, (double[])item_.getRefp12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnLo, (double[])item_.getRefp12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitHi, (double[])item_.getRefp12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitLo, (double[])item_.getRefp12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnHi, (double[])item_.getSclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnLo, (double[])item_.getSclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitHi, (double[])item_.getSclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitLo, (double[])item_.getSclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_warnHi, (double[])item_.getSclk1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_warnLo, (double[])item_.getSclk1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_limitHi, (double[])item_.getSclk1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_limitLo, (double[])item_.getSclk1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnHi, (double[])item_.getSclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnLo, (double[])item_.getSclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitHi, (double[])item_.getSclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitLo, (double[])item_.getSclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnHi, (double[])item_.getSclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnLo, (double[])item_.getSclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitHi, (double[])item_.getSclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitLo, (double[])item_.getSclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnHi, (double[])item_.getTemp10_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnLo, (double[])item_.getTemp10_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitHi, (double[])item_.getTemp10_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitLo, (double[])item_.getTemp10_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnHi, (double[])item_.getTemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnLo, (double[])item_.getTemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitHi, (double[])item_.getTemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitLo, (double[])item_.getTemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnHi, (double[])item_.getTemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnLo, (double[])item_.getTemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitHi, (double[])item_.getTemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitLo, (double[])item_.getTemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnHi, (double[])item_.getTemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnLo, (double[])item_.getTemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitHi, (double[])item_.getTemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitLo, (double[])item_.getTemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnHi, (double[])item_.getTemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnLo, (double[])item_.getTemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitHi, (double[])item_.getTemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitLo, (double[])item_.getTemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnHi, (double[])item_.getTemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnLo, (double[])item_.getTemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitHi, (double[])item_.getTemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitLo, (double[])item_.getTemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnHi, (double[])item_.getTemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnLo, (double[])item_.getTemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitHi, (double[])item_.getTemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitLo, (double[])item_.getTemp6_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnHi, (double[])item_.getTemp7_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnLo, (double[])item_.getTemp7_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitHi, (double[])item_.getTemp7_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitLo, (double[])item_.getTemp7_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnHi, (double[])item_.getTemp8_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnLo, (double[])item_.getTemp8_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitHi, (double[])item_.getTemp8_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitLo, (double[])item_.getTemp8_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnHi, (double[])item_.getTemp9_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnLo, (double[])item_.getTemp9_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitHi, (double[])item_.getTemp9_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitLo, (double[])item_.getTemp9_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsConfigurationEvent() throws Exception {
        String version = "z";
        double[] bias0_csGateP = TestHelper.generateDoubleArray((int)71, (int)-809038289);
        double[] bias0_gdP = TestHelper.generateDoubleArray((int)71, (int)1458576744);
        double[] bias0_odP = TestHelper.generateDoubleArray((int)71, (int)-1470858451);
        double[] bias0_ogP = TestHelper.generateDoubleArray((int)71, (int)-1859801831);
        double[] bias0_rdP = TestHelper.generateDoubleArray((int)71, (int)1692960358);
        double[] bias1_csGateP = TestHelper.generateDoubleArray((int)71, (int)-500336898);
        double[] bias1_gdP = TestHelper.generateDoubleArray((int)71, (int)2004977280);
        double[] bias1_odP = TestHelper.generateDoubleArray((int)71, (int)565815291);
        double[] bias1_ogP = TestHelper.generateDoubleArray((int)71, (int)1657888709);
        double[] bias1_rdP = TestHelper.generateDoubleArray((int)71, (int)-1939950528);
        double[] bias2_csGateP = TestHelper.generateDoubleArray((int)71, (int)-1052698427);
        double[] bias2_gdP = TestHelper.generateDoubleArray((int)71, (int)198504277);
        double[] bias2_odP = TestHelper.generateDoubleArray((int)71, (int)1880285797);
        double[] bias2_ogP = TestHelper.generateDoubleArray((int)71, (int)-1652816741);
        double[] bias2_rdP = TestHelper.generateDoubleArray((int)71, (int)484718233);
        double[] dac_pclkHighP = TestHelper.generateDoubleArray((int)71, (int)1787344994);
        double[] dac_pclkLowP = TestHelper.generateDoubleArray((int)71, (int)-1646556897);
        double[] dac_rgHighP = TestHelper.generateDoubleArray((int)71, (int)-1094718250);
        double[] dac_rgLowP = TestHelper.generateDoubleArray((int)71, (int)893990897);
        double[] dac_sclkHighP = TestHelper.generateDoubleArray((int)71, (int)-5715131);
        double[] dac_sclkLowP = TestHelper.generateDoubleArray((int)71, (int)1047168334);
        boolean[] disableRTDHardwareCheck = new boolean[]{true, false, false, true, false, true, false, true, false, false, false, false, false, false, false, true, false, false, true, true, false, true, true, true, false, false, false, false, true, true, false, true, false, true, false, false, true, true, true, false, false, true, true, true, false, false, true, false, true, true, true, false, true, true, true, false, false, true, false, false, false, false, true, true, false, true, false, false, false, true, true};
        String location = "s";
        long[] serialNum = TestHelper.generateLongArray((int)71, (int)1822023745);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsConfigurationEvent(version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, bias1_csGateP, bias1_gdP, bias1_odP, bias1_ogP, bias1_rdP, bias2_csGateP, bias2_gdP, bias2_odP, bias2_ogP, bias2_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsConfigurationEvent));
        Focal_plane_Reb_RaftsConfigurationEvent item_ = (Focal_plane_Reb_RaftsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_csGateP, (double[])item_.getBias0_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdP, (double[])item_.getBias0_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odP, (double[])item_.getBias0_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogP, (double[])item_.getBias0_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdP, (double[])item_.getBias0_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_csGateP, (double[])item_.getBias1_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdP, (double[])item_.getBias1_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odP, (double[])item_.getBias1_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogP, (double[])item_.getBias1_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdP, (double[])item_.getBias1_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_csGateP, (double[])item_.getBias2_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdP, (double[])item_.getBias2_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odP, (double[])item_.getBias2_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogP, (double[])item_.getBias2_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdP, (double[])item_.getBias2_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighP, (double[])item_.getDac_pclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowP, (double[])item_.getDac_pclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighP, (double[])item_.getDac_rgHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowP, (double[])item_.getDac_rgLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighP, (double[])item_.getDac_sclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowP, (double[])item_.getDac_sclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])disableRTDHardwareCheck, (boolean[])item_.getDisableRTDHardwareCheck());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])serialNum, (long[])item_.getSerialNum());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsLimitsConfigurationEvent() throws Exception {
        String version = "p";
        double[] bias0_gdMax = TestHelper.generateDoubleArray((int)71, (int)-1094235124);
        double[] bias0_gdMin = TestHelper.generateDoubleArray((int)71, (int)1450478848);
        double[] bias0_odMax = TestHelper.generateDoubleArray((int)71, (int)-1261228602);
        double[] bias0_odMin = TestHelper.generateDoubleArray((int)71, (int)18478989);
        double[] bias0_ogMax = TestHelper.generateDoubleArray((int)71, (int)-945678968);
        double[] bias0_ogMin = TestHelper.generateDoubleArray((int)71, (int)-114755728);
        double[] bias0_rdMax = TestHelper.generateDoubleArray((int)71, (int)-311147673);
        double[] bias0_rdMin = TestHelper.generateDoubleArray((int)71, (int)-564513264);
        double[] bias1_gdMax = TestHelper.generateDoubleArray((int)71, (int)1508640487);
        double[] bias1_gdMin = TestHelper.generateDoubleArray((int)71, (int)-470243363);
        double[] bias1_odMax = TestHelper.generateDoubleArray((int)71, (int)-615919827);
        double[] bias1_odMin = TestHelper.generateDoubleArray((int)71, (int)1591992533);
        double[] bias1_ogMax = TestHelper.generateDoubleArray((int)71, (int)1985793845);
        double[] bias1_ogMin = TestHelper.generateDoubleArray((int)71, (int)235793704);
        double[] bias1_rdMax = TestHelper.generateDoubleArray((int)71, (int)-835941860);
        double[] bias1_rdMin = TestHelper.generateDoubleArray((int)71, (int)1932240234);
        double[] bias2_gdMax = TestHelper.generateDoubleArray((int)71, (int)2087325367);
        double[] bias2_gdMin = TestHelper.generateDoubleArray((int)71, (int)1884096494);
        double[] bias2_odMax = TestHelper.generateDoubleArray((int)71, (int)2088857353);
        double[] bias2_odMin = TestHelper.generateDoubleArray((int)71, (int)-1624007357);
        double[] bias2_ogMax = TestHelper.generateDoubleArray((int)71, (int)1402627939);
        double[] bias2_ogMin = TestHelper.generateDoubleArray((int)71, (int)23749610);
        double[] bias2_rdMax = TestHelper.generateDoubleArray((int)71, (int)-261094871);
        double[] bias2_rdMin = TestHelper.generateDoubleArray((int)71, (int)325500859);
        double[] dac_pclkHighMax = TestHelper.generateDoubleArray((int)71, (int)-1122721646);
        double[] dac_pclkHighMin = TestHelper.generateDoubleArray((int)71, (int)199263127);
        double[] dac_pclkLowMax = TestHelper.generateDoubleArray((int)71, (int)-2038628892);
        double[] dac_pclkLowMin = TestHelper.generateDoubleArray((int)71, (int)925560920);
        double[] dac_rgHighMax = TestHelper.generateDoubleArray((int)71, (int)-1420766733);
        double[] dac_rgHighMin = TestHelper.generateDoubleArray((int)71, (int)-504987111);
        double[] dac_rgLowMax = TestHelper.generateDoubleArray((int)71, (int)2086828271);
        double[] dac_rgLowMin = TestHelper.generateDoubleArray((int)71, (int)529476946);
        double[] dac_sclkHighMax = TestHelper.generateDoubleArray((int)71, (int)-1581463101);
        double[] dac_sclkHighMin = TestHelper.generateDoubleArray((int)71, (int)-1707978915);
        double[] dac_sclkLowMax = TestHelper.generateDoubleArray((int)71, (int)2063325593);
        double[] dac_sclkLowMin = TestHelper.generateDoubleArray((int)71, (int)1859101270);
        String location = "d";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsLimitsConfigurationEvent(version, bias0_gdMax, bias0_gdMin, bias0_odMax, bias0_odMin, bias0_ogMax, bias0_ogMin, bias0_rdMax, bias0_rdMin, bias1_gdMax, bias1_gdMin, bias1_odMax, bias1_odMin, bias1_ogMax, bias1_ogMin, bias1_rdMax, bias1_rdMin, bias2_gdMax, bias2_gdMin, bias2_odMax, bias2_odMin, bias2_ogMax, bias2_ogMin, bias2_rdMax, bias2_rdMin, dac_pclkHighMax, dac_pclkHighMin, dac_pclkLowMax, dac_pclkLowMin, dac_rgHighMax, dac_rgHighMin, dac_rgLowMax, dac_rgLowMin, dac_sclkHighMax, dac_sclkHighMin, dac_sclkLowMax, dac_sclkLowMin, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsLimitsConfigurationEvent));
        Focal_plane_Reb_RaftsLimitsConfigurationEvent item_ = (Focal_plane_Reb_RaftsLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdMax, (double[])item_.getBias0_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdMin, (double[])item_.getBias0_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMax, (double[])item_.getBias0_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMin, (double[])item_.getBias0_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMax, (double[])item_.getBias0_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMin, (double[])item_.getBias0_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMax, (double[])item_.getBias0_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMin, (double[])item_.getBias0_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMax, (double[])item_.getBias1_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMin, (double[])item_.getBias1_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMax, (double[])item_.getBias1_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMin, (double[])item_.getBias1_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMax, (double[])item_.getBias1_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMin, (double[])item_.getBias1_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMax, (double[])item_.getBias1_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMin, (double[])item_.getBias1_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMax, (double[])item_.getBias2_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMin, (double[])item_.getBias2_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMax, (double[])item_.getBias2_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMin, (double[])item_.getBias2_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMax, (double[])item_.getBias2_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMin, (double[])item_.getBias2_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMax, (double[])item_.getBias2_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMin, (double[])item_.getBias2_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMax, (double[])item_.getDac_pclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMin, (double[])item_.getDac_pclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMax, (double[])item_.getDac_pclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMin, (double[])item_.getDac_pclkLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMax, (double[])item_.getDac_rgHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMin, (double[])item_.getDac_rgHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMax, (double[])item_.getDac_rgLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMin, (double[])item_.getDac_rgLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMax, (double[])item_.getDac_sclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMin, (double[])item_.getDac_sclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMax, (double[])item_.getDac_sclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMin, (double[])item_.getDac_sclkLowMin(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsPowerConfigurationEvent() throws Exception {
        String version = "";
        double[] bias0_gdCal = TestHelper.generateDoubleArray((int)71, (int)-2067684473);
        double[] bias0_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)-2034255288);
        double[] bias0_gdTol = TestHelper.generateDoubleArray((int)71, (int)1435115114);
        double[] bias0_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)-401431594);
        double[] bias0_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-925510460);
        double[] bias0_odCal = TestHelper.generateDoubleArray((int)71, (int)-313031295);
        double[] bias0_odIMax = TestHelper.generateDoubleArray((int)71, (int)-734788411);
        double[] bias0_odTol = TestHelper.generateDoubleArray((int)71, (int)1715371921);
        double[] bias0_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1132527312);
        double[] bias0_ogCal = TestHelper.generateDoubleArray((int)71, (int)1243408212);
        double[] bias0_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)1482937101);
        double[] bias0_ogTol = TestHelper.generateDoubleArray((int)71, (int)1637378209);
        double[] bias0_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)-995072274);
        double[] bias0_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)575868291);
        double[] bias0_rdCal = TestHelper.generateDoubleArray((int)71, (int)1910830590);
        double[] bias0_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)1741888789);
        double[] bias0_rdTol = TestHelper.generateDoubleArray((int)71, (int)-1961985236);
        double[] bias0_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)-1791099442);
        double[] bias0_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)963690295);
        double[] bias1_gdCal = TestHelper.generateDoubleArray((int)71, (int)-2086529840);
        double[] bias1_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)395930211);
        double[] bias1_gdTol = TestHelper.generateDoubleArray((int)71, (int)-1347925263);
        double[] bias1_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)1780459804);
        double[] bias1_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)589447584);
        double[] bias1_odCal = TestHelper.generateDoubleArray((int)71, (int)1917376732);
        double[] bias1_odIMax = TestHelper.generateDoubleArray((int)71, (int)467313873);
        double[] bias1_odTol = TestHelper.generateDoubleArray((int)71, (int)-1051691778);
        double[] bias1_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1819919217);
        double[] bias1_ogCal = TestHelper.generateDoubleArray((int)71, (int)-1652250763);
        double[] bias1_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)-1535133711);
        double[] bias1_ogTol = TestHelper.generateDoubleArray((int)71, (int)190875513);
        double[] bias1_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)-221809543);
        double[] bias1_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)-153173852);
        double[] bias1_rdCal = TestHelper.generateDoubleArray((int)71, (int)-912125910);
        double[] bias1_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)-1016912099);
        double[] bias1_rdTol = TestHelper.generateDoubleArray((int)71, (int)-903663138);
        double[] bias1_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)-1355927108);
        double[] bias1_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)2140730011);
        double[] bias2_gdCal = TestHelper.generateDoubleArray((int)71, (int)-1363443376);
        double[] bias2_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)-381451271);
        double[] bias2_gdTol = TestHelper.generateDoubleArray((int)71, (int)-965995409);
        double[] bias2_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)-1550556451);
        double[] bias2_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)760715634);
        double[] bias2_odCal = TestHelper.generateDoubleArray((int)71, (int)794913553);
        double[] bias2_odIMax = TestHelper.generateDoubleArray((int)71, (int)1052183699);
        double[] bias2_odTol = TestHelper.generateDoubleArray((int)71, (int)-1077426309);
        double[] bias2_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)1116243522);
        double[] bias2_ogCal = TestHelper.generateDoubleArray((int)71, (int)-424750066);
        double[] bias2_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)-2065015255);
        double[] bias2_ogTol = TestHelper.generateDoubleArray((int)71, (int)355852705);
        double[] bias2_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)1935057280);
        double[] bias2_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)875313486);
        double[] bias2_rdCal = TestHelper.generateDoubleArray((int)71, (int)411164570);
        double[] bias2_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)840436754);
        double[] bias2_rdTol = TestHelper.generateDoubleArray((int)71, (int)871796178);
        double[] bias2_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)-67699527);
        double[] bias2_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-2007741374);
        double[] clkhiAmin = TestHelper.generateDoubleArray((int)71, (int)2097542495);
        double[] clkhiQmax = TestHelper.generateDoubleArray((int)71, (int)-1729218837);
        double[] clkliAmin = TestHelper.generateDoubleArray((int)71, (int)-447033582);
        double[] clkliQmax = TestHelper.generateDoubleArray((int)71, (int)-364790990);
        double[] dac_clkhIMax = TestHelper.generateDoubleArray((int)71, (int)1570916693);
        double[] dac_clklIMax = TestHelper.generateDoubleArray((int)71, (int)-1748553751);
        double[] dac_pclkHighCal = TestHelper.generateDoubleArray((int)71, (int)-473843568);
        double[] dac_pclkHighTestV = TestHelper.generateDoubleArray((int)71, (int)294403633);
        double[] dac_pclkHighTol = TestHelper.generateDoubleArray((int)71, (int)249822647);
        double[] dac_pclkHighValueErr = TestHelper.generateDoubleArray((int)71, (int)958272510);
        double[] dac_pclkHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1488742739);
        double[] dac_pclkLowCal = TestHelper.generateDoubleArray((int)71, (int)1047325956);
        double[] dac_pclkLowTestV = TestHelper.generateDoubleArray((int)71, (int)-1537526228);
        double[] dac_pclkLowTol = TestHelper.generateDoubleArray((int)71, (int)2025114962);
        double[] dac_pclkLowValueErr = TestHelper.generateDoubleArray((int)71, (int)-2108742852);
        double[] dac_pclkLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1579687697);
        double[] dac_rgHighCal = TestHelper.generateDoubleArray((int)71, (int)-1907625094);
        double[] dac_rgHighTestV = TestHelper.generateDoubleArray((int)71, (int)438822440);
        double[] dac_rgHighTol = TestHelper.generateDoubleArray((int)71, (int)-420226879);
        double[] dac_rgHighValueErr = TestHelper.generateDoubleArray((int)71, (int)1854268539);
        double[] dac_rgHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1889009164);
        double[] dac_rgLowCal = TestHelper.generateDoubleArray((int)71, (int)-1069201345);
        double[] dac_rgLowTestV = TestHelper.generateDoubleArray((int)71, (int)1861568508);
        double[] dac_rgLowTol = TestHelper.generateDoubleArray((int)71, (int)-461186184);
        double[] dac_rgLowValueErr = TestHelper.generateDoubleArray((int)71, (int)-174793935);
        double[] dac_rgLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)201657978);
        double[] dac_sclkHighCal = TestHelper.generateDoubleArray((int)71, (int)323334855);
        double[] dac_sclkHighTestV = TestHelper.generateDoubleArray((int)71, (int)-1427364027);
        double[] dac_sclkHighTol = TestHelper.generateDoubleArray((int)71, (int)1153527550);
        double[] dac_sclkHighValueErr = TestHelper.generateDoubleArray((int)71, (int)1158368450);
        double[] dac_sclkHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)-2096168927);
        double[] dac_sclkLowCal = TestHelper.generateDoubleArray((int)71, (int)1148881742);
        double[] dac_sclkLowTestV = TestHelper.generateDoubleArray((int)71, (int)-627374187);
        double[] dac_sclkLowTol = TestHelper.generateDoubleArray((int)71, (int)178516523);
        double[] dac_sclkLowValueErr = TestHelper.generateDoubleArray((int)71, (int)2102287753);
        double[] dac_sclkLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1691920938);
        String location = "";
        double[] maxDelta = TestHelper.generateDoubleArray((int)71, (int)664283477);
        double[] maxStep = TestHelper.generateDoubleArray((int)71, (int)1266164112);
        double[] minTol = TestHelper.generateDoubleArray((int)71, (int)-1376464650);
        int[] nPowerOnPub = TestHelper.generateIntArray((int)71, (int)1149250581);
        double[] odiAmin = TestHelper.generateDoubleArray((int)71, (int)-548480236);
        double[] odiQmax = TestHelper.generateDoubleArray((int)71, (int)1960756137);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsPowerConfigurationEvent(version, bias0_gdCal, bias0_gdTestVolts, bias0_gdTol, bias0_gdValueErr, bias0_gdZeroErr, bias0_odCal, bias0_odIMax, bias0_odTol, bias0_odZeroErr, bias0_ogCal, bias0_ogTestVolts, bias0_ogTol, bias0_ogValueErr, bias0_ogZeroErr, bias0_rdCal, bias0_rdTestVolts, bias0_rdTol, bias0_rdValueErr, bias0_rdZeroErr, bias1_gdCal, bias1_gdTestVolts, bias1_gdTol, bias1_gdValueErr, bias1_gdZeroErr, bias1_odCal, bias1_odIMax, bias1_odTol, bias1_odZeroErr, bias1_ogCal, bias1_ogTestVolts, bias1_ogTol, bias1_ogValueErr, bias1_ogZeroErr, bias1_rdCal, bias1_rdTestVolts, bias1_rdTol, bias1_rdValueErr, bias1_rdZeroErr, bias2_gdCal, bias2_gdTestVolts, bias2_gdTol, bias2_gdValueErr, bias2_gdZeroErr, bias2_odCal, bias2_odIMax, bias2_odTol, bias2_odZeroErr, bias2_ogCal, bias2_ogTestVolts, bias2_ogTol, bias2_ogValueErr, bias2_ogZeroErr, bias2_rdCal, bias2_rdTestVolts, bias2_rdTol, bias2_rdValueErr, bias2_rdZeroErr, clkhiAmin, clkhiQmax, clkliAmin, clkliQmax, dac_clkhIMax, dac_clklIMax, dac_pclkHighCal, dac_pclkHighTestV, dac_pclkHighTol, dac_pclkHighValueErr, dac_pclkHighZeroErr, dac_pclkLowCal, dac_pclkLowTestV, dac_pclkLowTol, dac_pclkLowValueErr, dac_pclkLowZeroErr, dac_rgHighCal, dac_rgHighTestV, dac_rgHighTol, dac_rgHighValueErr, dac_rgHighZeroErr, dac_rgLowCal, dac_rgLowTestV, dac_rgLowTol, dac_rgLowValueErr, dac_rgLowZeroErr, dac_sclkHighCal, dac_sclkHighTestV, dac_sclkHighTol, dac_sclkHighValueErr, dac_sclkHighZeroErr, dac_sclkLowCal, dac_sclkLowTestV, dac_sclkLowTol, dac_sclkLowValueErr, dac_sclkLowZeroErr, location, maxDelta, maxStep, minTol, nPowerOnPub, odiAmin, odiQmax));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsPowerConfigurationEvent));
        Focal_plane_Reb_RaftsPowerConfigurationEvent item_ = (Focal_plane_Reb_RaftsPowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdCal, (double[])item_.getBias0_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTestVolts, (double[])item_.getBias0_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTol, (double[])item_.getBias0_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdValueErr, (double[])item_.getBias0_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdZeroErr, (double[])item_.getBias0_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odCal, (double[])item_.getBias0_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odIMax, (double[])item_.getBias0_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odTol, (double[])item_.getBias0_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odZeroErr, (double[])item_.getBias0_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogCal, (double[])item_.getBias0_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTestVolts, (double[])item_.getBias0_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTol, (double[])item_.getBias0_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogValueErr, (double[])item_.getBias0_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogZeroErr, (double[])item_.getBias0_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdCal, (double[])item_.getBias0_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTestVolts, (double[])item_.getBias0_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTol, (double[])item_.getBias0_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdValueErr, (double[])item_.getBias0_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdZeroErr, (double[])item_.getBias0_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdCal, (double[])item_.getBias1_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTestVolts, (double[])item_.getBias1_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTol, (double[])item_.getBias1_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdValueErr, (double[])item_.getBias1_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdZeroErr, (double[])item_.getBias1_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odCal, (double[])item_.getBias1_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odIMax, (double[])item_.getBias1_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odTol, (double[])item_.getBias1_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odZeroErr, (double[])item_.getBias1_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogCal, (double[])item_.getBias1_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTestVolts, (double[])item_.getBias1_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTol, (double[])item_.getBias1_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogValueErr, (double[])item_.getBias1_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogZeroErr, (double[])item_.getBias1_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdCal, (double[])item_.getBias1_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTestVolts, (double[])item_.getBias1_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTol, (double[])item_.getBias1_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdValueErr, (double[])item_.getBias1_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdZeroErr, (double[])item_.getBias1_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdCal, (double[])item_.getBias2_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTestVolts, (double[])item_.getBias2_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTol, (double[])item_.getBias2_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdValueErr, (double[])item_.getBias2_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdZeroErr, (double[])item_.getBias2_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odCal, (double[])item_.getBias2_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odIMax, (double[])item_.getBias2_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odTol, (double[])item_.getBias2_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odZeroErr, (double[])item_.getBias2_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogCal, (double[])item_.getBias2_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTestVolts, (double[])item_.getBias2_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTol, (double[])item_.getBias2_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogValueErr, (double[])item_.getBias2_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogZeroErr, (double[])item_.getBias2_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdCal, (double[])item_.getBias2_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTestVolts, (double[])item_.getBias2_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTol, (double[])item_.getBias2_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdValueErr, (double[])item_.getBias2_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdZeroErr, (double[])item_.getBias2_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiAmin, (double[])item_.getClkhiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiQmax, (double[])item_.getClkhiQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliAmin, (double[])item_.getClkliAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliQmax, (double[])item_.getClkliQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clkhIMax, (double[])item_.getDac_clkhIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clklIMax, (double[])item_.getDac_clklIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighCal, (double[])item_.getDac_pclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTestV, (double[])item_.getDac_pclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTol, (double[])item_.getDac_pclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighValueErr, (double[])item_.getDac_pclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighZeroErr, (double[])item_.getDac_pclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowCal, (double[])item_.getDac_pclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTestV, (double[])item_.getDac_pclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTol, (double[])item_.getDac_pclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowValueErr, (double[])item_.getDac_pclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowZeroErr, (double[])item_.getDac_pclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighCal, (double[])item_.getDac_rgHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTestV, (double[])item_.getDac_rgHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTol, (double[])item_.getDac_rgHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighValueErr, (double[])item_.getDac_rgHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighZeroErr, (double[])item_.getDac_rgHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowCal, (double[])item_.getDac_rgLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTestV, (double[])item_.getDac_rgLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTol, (double[])item_.getDac_rgLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowValueErr, (double[])item_.getDac_rgLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowZeroErr, (double[])item_.getDac_rgLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighCal, (double[])item_.getDac_sclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTestV, (double[])item_.getDac_sclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTol, (double[])item_.getDac_sclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighValueErr, (double[])item_.getDac_sclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighZeroErr, (double[])item_.getDac_sclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowCal, (double[])item_.getDac_sclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTestV, (double[])item_.getDac_sclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTol, (double[])item_.getDac_sclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowValueErr, (double[])item_.getDac_sclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowZeroErr, (double[])item_.getDac_sclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])maxDelta, (double[])item_.getMaxDelta(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxStep, (double[])item_.getMaxStep(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])minTol, (double[])item_.getMinTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
        Assert.assertArrayEquals((double[])odiAmin, (double[])item_.getOdiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odiQmax, (double[])item_.getOdiQmax(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_timersConfigurationEvent() throws Exception {
        String version = "m";
        String location = "f";
        long[] periodictasks_monitor_check_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)745794680);
        long[] periodictasks_monitor_publish_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1318371501);
        long[] periodictasks_monitor_publish_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-958502859);
        long[] periodictasks_monitor_publish_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)319842329);
        long[] periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-471070484);
        long[] periodictasks_monitor_publish_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-2007065194);
        long[] periodictasks_monitor_publish_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)2031342460);
        long[] periodictasks_monitor_publish_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1828924872);
        long[] periodictasks_monitor_update_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)230255075);
        long[] periodictasks_monitor_update_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1047670183);
        long[] periodictasks_monitor_update_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-191263186);
        long[] periodictasks_monitor_update_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1441227615);
        long[] periodictasks_monitor_update_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)2118474924);
        long[] periodictasks_monitor_update_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)905691484);
        long[] periodictasks_monitor_update_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1355880843);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_timersConfigurationEvent(version, location, periodictasks_monitor_check_taskPeriodMillis, periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, periodictasks_monitor_publish_biasVolt_taskPeriodMillis, periodictasks_monitor_publish_boardPower_taskPeriodMillis, periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, periodictasks_monitor_publish_crVolt_taskPeriodMillis, periodictasks_monitor_publish_rebTemp_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_aspicTemp_taskPeriodMillis, periodictasks_monitor_update_biasVolt_taskPeriodMillis, periodictasks_monitor_update_boardPower_taskPeriodMillis, periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, periodictasks_monitor_update_crVolt_taskPeriodMillis, periodictasks_monitor_update_rebTemp_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_timersConfigurationEvent));
        Focal_plane_Reb_timersConfigurationEvent item_ = (Focal_plane_Reb_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])periodictasks_monitor_check_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_check_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6_GeneralConfigurationEvent() throws Exception {
        String version = "h";
        String chanNames = "";
        String chanWeights = "";
        boolean ignoreNaN = true;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent(version, chanNames, chanWeights, ignoreNaN));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent));
        Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent item_ = (Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)chanNames, (Object)item_.getChanNames());
        Assert.assertEquals((Object)chanWeights, (Object)item_.getChanWeights());
        Assert.assertEquals((Object)ignoreNaN, (Object)item_.isIgnoreNaN());
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6_LimitsConfigurationEvent() throws Exception {
        String version = "z";
        double warnHi = 0.3818510174751282;
        double warnLo = 0.3749760389328003;
        double limitHi = 0.7417784333229065;
        double limitLo = 0.0821070671081543;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent));
        Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent item_ = (Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Segment_LimitsConfigurationEvent() throws Exception {
        String version = "o";
        double[] i_warnHi = TestHelper.generateDoubleArray((int)3024, (int)118269860);
        double[] i_warnLo = TestHelper.generateDoubleArray((int)3024, (int)-534150317);
        double[] i_limitHi = TestHelper.generateDoubleArray((int)3024, (int)321909210);
        double[] i_limitLo = TestHelper.generateDoubleArray((int)3024, (int)1456391669);
        String location = "e";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Segment_LimitsConfigurationEvent(version, i_warnHi, i_warnLo, i_limitHi, i_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Segment_LimitsConfigurationEvent));
        Focal_plane_Segment_LimitsConfigurationEvent item_ = (Focal_plane_Segment_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])i_warnHi, (double[])item_.getI_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_warnLo, (double[])item_.getI_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitHi, (double[])item_.getI_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitLo, (double[])item_.getI_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_DAQConfigurationEvent() throws Exception {
        String version = "b";
        int badPixelAlarmLimit = 287;
        String daqFolder = "";
        String daqPartition = "k";
        boolean emulatedDAQ = true;
        String scienceLocations = "c";
        boolean simulatedDAQ = true;
        String simulatedDataFolder = "d";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_DAQConfigurationEvent(version, badPixelAlarmLimit, daqFolder, daqPartition, emulatedDAQ, scienceLocations, simulatedDAQ, simulatedDataFolder));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_DAQConfigurationEvent));
        Focal_plane_SequencerConfig_DAQConfigurationEvent item_ = (Focal_plane_SequencerConfig_DAQConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)badPixelAlarmLimit, (long)item_.getBadPixelAlarmLimit());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
        Assert.assertEquals((Object)emulatedDAQ, (Object)item_.isEmulatedDAQ());
        Assert.assertEquals((Object)scienceLocations, (Object)item_.getScienceLocations());
        Assert.assertEquals((Object)simulatedDAQ, (Object)item_.isSimulatedDAQ());
        Assert.assertEquals((Object)simulatedDataFolder, (Object)item_.getSimulatedDataFolder());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_GuiderConfigurationEvent() throws Exception {
        String version = "l";
        String guiderLocations = "";
        String guiderPartition = "f";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_GuiderConfigurationEvent(version, guiderLocations, guiderPartition));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_GuiderConfigurationEvent));
        Focal_plane_SequencerConfig_GuiderConfigurationEvent item_ = (Focal_plane_SequencerConfig_GuiderConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)guiderLocations, (Object)item_.getGuiderLocations());
        Assert.assertEquals((Object)guiderPartition, (Object)item_.getGuiderPartition());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_SequencerConfigurationEvent() throws Exception {
        String version = "";
        String clearCountParameter = "";
        String clearMain = "";
        String idleFlushMain = "e";
        long idleFlushTimeout = 177L;
        String integrateMain = "";
        String metaDataRegisters = "";
        int overCols = 814;
        int overRows = 886;
        int postCols = 588;
        int postRows = 288;
        int preCols = 509;
        int preRows = 642;
        String pseudoReadMain = "";
        int readCols = 914;
        int readCols2 = 225;
        String readMain = "a";
        int readRows = 852;
        String rowShiftForwardMain = "";
        String rowShiftReverseMain = "a";
        boolean scanMode = false;
        String sequencer = "j";
        String sequencerChecksums = "";
        String shiftCountParameter = "";
        boolean stepAfterIntegrate = true;
        int transparentMode = 423;
        int underCols = 322;
        boolean useParallelRegisters = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_SequencerConfigurationEvent(version, clearCountParameter, clearMain, idleFlushMain, idleFlushTimeout, integrateMain, metaDataRegisters, overCols, overRows, postCols, postRows, preCols, preRows, pseudoReadMain, readCols, readCols2, readMain, readRows, rowShiftForwardMain, rowShiftReverseMain, scanMode, sequencer, sequencerChecksums, shiftCountParameter, stepAfterIntegrate, transparentMode, underCols, useParallelRegisters));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_SequencerConfigurationEvent));
        Focal_plane_SequencerConfig_SequencerConfigurationEvent item_ = (Focal_plane_SequencerConfig_SequencerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)clearCountParameter, (Object)item_.getClearCountParameter());
        Assert.assertEquals((Object)clearMain, (Object)item_.getClearMain());
        Assert.assertEquals((Object)idleFlushMain, (Object)item_.getIdleFlushMain());
        Assert.assertEquals((long)idleFlushTimeout, (long)item_.getIdleFlushTimeout());
        Assert.assertEquals((Object)integrateMain, (Object)item_.getIntegrateMain());
        Assert.assertEquals((Object)metaDataRegisters, (Object)item_.getMetaDataRegisters());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)postRows, (long)item_.getPostRows());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((Object)pseudoReadMain, (Object)item_.getPseudoReadMain());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((Object)readMain, (Object)item_.getReadMain());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((Object)rowShiftForwardMain, (Object)item_.getRowShiftForwardMain());
        Assert.assertEquals((Object)rowShiftReverseMain, (Object)item_.getRowShiftReverseMain());
        Assert.assertEquals((Object)scanMode, (Object)item_.isScanMode());
        Assert.assertEquals((Object)sequencer, (Object)item_.getSequencer());
        Assert.assertEquals((Object)sequencerChecksums, (Object)item_.getSequencerChecksums());
        Assert.assertEquals((Object)shiftCountParameter, (Object)item_.getShiftCountParameter());
        Assert.assertEquals((Object)stepAfterIntegrate, (Object)item_.isStepAfterIntegrate());
        Assert.assertEquals((long)transparentMode, (long)item_.getTransparentMode());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)useParallelRegisters, (Object)item_.isUseParallelRegisters());
    }

    @Test
    public void sendReceiveFocal_plane_WebHooksConfig_VisualizationConfigurationEvent() throws Exception {
        String version = "";
        String webHooks = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_WebHooksConfig_VisualizationConfigurationEvent(version, webHooks));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_WebHooksConfig_VisualizationConfigurationEvent));
        Focal_plane_WebHooksConfig_VisualizationConfigurationEvent item_ = (Focal_plane_WebHooksConfig_VisualizationConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)webHooks, (Object)item_.getWebHooks());
    }

    @Test
    public void sendReceiveImage_handling_FitsService_GeneralConfigurationEvent() throws Exception {
        String version = "m";
        String guider_headerFilesList = "";
        String science_headerFilesList = "t";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_FitsService_GeneralConfigurationEvent(version, guider_headerFilesList, science_headerFilesList));
        Assert.assertTrue((boolean)(item instanceof Image_handling_FitsService_GeneralConfigurationEvent));
        Image_handling_FitsService_GeneralConfigurationEvent item_ = (Image_handling_FitsService_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)guider_headerFilesList, (Object)item_.getGuider_headerFilesList());
        Assert.assertEquals((Object)science_headerFilesList, (Object)item_.getScience_headerFilesList());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_CommandsConfigurationEvent() throws Exception {
        String version = "";
        String imagehandlingconfig_additionalFileCommands = "";
        String imagehandlingconfig_additionalFileFilter = "s";
        String imagehandlingconfig_commands = "z";
        String imagehandlingconfig_currentDirectory = "";
        String imagehandlingconfig_environment = "q";
        String imagehandlingconfig_logDirectory = "o";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_CommandsConfigurationEvent(version, imagehandlingconfig_additionalFileCommands, imagehandlingconfig_additionalFileFilter, imagehandlingconfig_commands, imagehandlingconfig_currentDirectory, imagehandlingconfig_environment, imagehandlingconfig_logDirectory));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_CommandsConfigurationEvent));
        Image_handling_ImageHandler_CommandsConfigurationEvent item_ = (Image_handling_ImageHandler_CommandsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_additionalFileCommands, (Object)item_.getImagehandlingconfig_additionalFileCommands());
        Assert.assertEquals((Object)imagehandlingconfig_additionalFileFilter, (Object)item_.getImagehandlingconfig_additionalFileFilter());
        Assert.assertEquals((Object)imagehandlingconfig_commands, (Object)item_.getImagehandlingconfig_commands());
        Assert.assertEquals((Object)imagehandlingconfig_currentDirectory, (Object)item_.getImagehandlingconfig_currentDirectory());
        Assert.assertEquals((Object)imagehandlingconfig_environment, (Object)item_.getImagehandlingconfig_environment());
        Assert.assertEquals((Object)imagehandlingconfig_logDirectory, (Object)item_.getImagehandlingconfig_logDirectory());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_DAQConfigurationEvent() throws Exception {
        String version = "";
        int imagehandlingconfig_badPixelAlarmLevel = 500;
        int imagehandlingconfig_badPixelHighThreshold = 53;
        int imagehandlingconfig_badPixelLowThreshold = 258;
        int imagehandlingconfig_badPixelWarningLevel = 998;
        boolean imagehandlingconfig_checkForBadPixels = false;
        String imagehandlingconfig_daqFolder = "";
        String imagehandlingconfig_daqPartition = "w";
        int imagehandlingconfig_daqThreads = 630;
        String imagehandlingconfig_locations = "";
        boolean imagehandlingconfig_useStreaming = true;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_DAQConfigurationEvent(version, imagehandlingconfig_badPixelAlarmLevel, imagehandlingconfig_badPixelHighThreshold, imagehandlingconfig_badPixelLowThreshold, imagehandlingconfig_badPixelWarningLevel, imagehandlingconfig_checkForBadPixels, imagehandlingconfig_daqFolder, imagehandlingconfig_daqPartition, imagehandlingconfig_daqThreads, imagehandlingconfig_locations, imagehandlingconfig_useStreaming));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_DAQConfigurationEvent));
        Image_handling_ImageHandler_DAQConfigurationEvent item_ = (Image_handling_ImageHandler_DAQConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)imagehandlingconfig_badPixelAlarmLevel, (long)item_.getImagehandlingconfig_badPixelAlarmLevel());
        Assert.assertEquals((long)imagehandlingconfig_badPixelHighThreshold, (long)item_.getImagehandlingconfig_badPixelHighThreshold());
        Assert.assertEquals((long)imagehandlingconfig_badPixelLowThreshold, (long)item_.getImagehandlingconfig_badPixelLowThreshold());
        Assert.assertEquals((long)imagehandlingconfig_badPixelWarningLevel, (long)item_.getImagehandlingconfig_badPixelWarningLevel());
        Assert.assertEquals((Object)imagehandlingconfig_checkForBadPixels, (Object)item_.isImagehandlingconfig_checkForBadPixels());
        Assert.assertEquals((Object)imagehandlingconfig_daqFolder, (Object)item_.getImagehandlingconfig_daqFolder());
        Assert.assertEquals((Object)imagehandlingconfig_daqPartition, (Object)item_.getImagehandlingconfig_daqPartition());
        Assert.assertEquals((long)imagehandlingconfig_daqThreads, (long)item_.getImagehandlingconfig_daqThreads());
        Assert.assertEquals((Object)imagehandlingconfig_locations, (Object)item_.getImagehandlingconfig_locations());
        Assert.assertEquals((Object)imagehandlingconfig_useStreaming, (Object)item_.isImagehandlingconfig_useStreaming());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_FitsHandlingConfigurationEvent() throws Exception {
        String version = "";
        boolean imagehandlingconfig_FITSAutoSave = false;
        String imagehandlingconfig_FITSDirectoryPattern = "";
        String imagehandlingconfig_FITSFilePattern = "e";
        String imagehandlingconfig_FITSRootDirectory = "";
        boolean imagehandlingconfig_raiseAlertOnMissingOrBadHeaderServiceData = true;
        String imagehandlingconfig_subsystemsToClearOnNewRun = "j";
        String imagehandlingconfig_tempFileRelativeLocation = "v";
        boolean imagehandlingconfig_useTempFile = true;
        String imagehandlingconfig_waitForHeaderService = "";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_FitsHandlingConfigurationEvent(version, imagehandlingconfig_FITSAutoSave, imagehandlingconfig_FITSDirectoryPattern, imagehandlingconfig_FITSFilePattern, imagehandlingconfig_FITSRootDirectory, imagehandlingconfig_raiseAlertOnMissingOrBadHeaderServiceData, imagehandlingconfig_subsystemsToClearOnNewRun, imagehandlingconfig_tempFileRelativeLocation, imagehandlingconfig_useTempFile, imagehandlingconfig_waitForHeaderService));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_FitsHandlingConfigurationEvent));
        Image_handling_ImageHandler_FitsHandlingConfigurationEvent item_ = (Image_handling_ImageHandler_FitsHandlingConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_FITSAutoSave, (Object)item_.isImagehandlingconfig_FITSAutoSave());
        Assert.assertEquals((Object)imagehandlingconfig_FITSDirectoryPattern, (Object)item_.getImagehandlingconfig_FITSDirectoryPattern());
        Assert.assertEquals((Object)imagehandlingconfig_FITSFilePattern, (Object)item_.getImagehandlingconfig_FITSFilePattern());
        Assert.assertEquals((Object)imagehandlingconfig_FITSRootDirectory, (Object)item_.getImagehandlingconfig_FITSRootDirectory());
        Assert.assertEquals((Object)imagehandlingconfig_raiseAlertOnMissingOrBadHeaderServiceData, (Object)item_.isImagehandlingconfig_raiseAlertOnMissingOrBadHeaderServiceData());
        Assert.assertEquals((Object)imagehandlingconfig_subsystemsToClearOnNewRun, (Object)item_.getImagehandlingconfig_subsystemsToClearOnNewRun());
        Assert.assertEquals((Object)imagehandlingconfig_tempFileRelativeLocation, (Object)item_.getImagehandlingconfig_tempFileRelativeLocation());
        Assert.assertEquals((Object)imagehandlingconfig_useTempFile, (Object)item_.isImagehandlingconfig_useTempFile());
        Assert.assertEquals((Object)imagehandlingconfig_waitForHeaderService, (Object)item_.getImagehandlingconfig_waitForHeaderService());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_GeneralConfigurationEvent() throws Exception {
        String version = "";
        String imagedatabaseservice_dbURL = "f";
        boolean imagedatabaseservice_enabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_GeneralConfigurationEvent(version, imagedatabaseservice_dbURL, imagedatabaseservice_enabled));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_GeneralConfigurationEvent));
        Image_handling_ImageHandler_GeneralConfigurationEvent item_ = (Image_handling_ImageHandler_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagedatabaseservice_dbURL, (Object)item_.getImagedatabaseservice_dbURL());
        Assert.assertEquals((Object)imagedatabaseservice_enabled, (Object)item_.isImagedatabaseservice_enabled());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_GuiderConfigurationEvent() throws Exception {
        String version = "p";
        String imagehandlingconfig_guiderFITSFilePattern = "d";
        String imagehandlingconfig_guiderLocations = "";
        String imagehandlingconfig_guiderPartition = "y";
        boolean imagehandlingconfig_includeRawStamps = true;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_GuiderConfigurationEvent(version, imagehandlingconfig_guiderFITSFilePattern, imagehandlingconfig_guiderLocations, imagehandlingconfig_guiderPartition, imagehandlingconfig_includeRawStamps));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_GuiderConfigurationEvent));
        Image_handling_ImageHandler_GuiderConfigurationEvent item_ = (Image_handling_ImageHandler_GuiderConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_guiderFITSFilePattern, (Object)item_.getImagehandlingconfig_guiderFITSFilePattern());
        Assert.assertEquals((Object)imagehandlingconfig_guiderLocations, (Object)item_.getImagehandlingconfig_guiderLocations());
        Assert.assertEquals((Object)imagehandlingconfig_guiderPartition, (Object)item_.getImagehandlingconfig_guiderPartition());
        Assert.assertEquals((Object)imagehandlingconfig_includeRawStamps, (Object)item_.isImagehandlingconfig_includeRawStamps());
    }

    @Test
    public void sendReceiveImage_handling_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 978;
        int schedulers_default_nThreads = 352;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads));
        Assert.assertTrue((boolean)(item instanceof Image_handling_PeriodicTasks_GeneralConfigurationEvent));
        Image_handling_PeriodicTasks_GeneralConfigurationEvent item_ = (Image_handling_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
    }

    @Test
    public void sendReceiveImage_handling_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 61L;
        long heartbeat_taskPeriodMillis = 395L;
        long runtimeinfo_taskPeriodMillis = 990L;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Image_handling_PeriodicTasks_timersConfigurationEvent));
        Image_handling_PeriodicTasks_timersConfigurationEvent item_ = (Image_handling_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveImage_handling_StatusAggregator_GeneralConfigurationEvent() throws Exception {
        String version = "";
        String patternConfigList = "n";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_StatusAggregator_GeneralConfigurationEvent(version, patternConfigList));
        Assert.assertTrue((boolean)(item instanceof Image_handling_StatusAggregator_GeneralConfigurationEvent));
        Image_handling_StatusAggregator_GeneralConfigurationEvent item_ = (Image_handling_StatusAggregator_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)patternConfigList, (Object)item_.getPatternConfigList());
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_03_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.4289323687553406;
        double warnLo = 0.6161231994628906;
        double limitHi = 0.5978191494941711;
        double limitLo = 0.5353047847747803;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_CLP_RTD_03_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_03_LimitsConfigurationEvent));
        Mpm_CLP_RTD_03_LimitsConfigurationEvent item_ = (Mpm_CLP_RTD_03_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_05_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.31011974811553955;
        double warnLo = 0.9112753868103027;
        double limitHi = 0.2477748990058899;
        double limitLo = 0.12679147720336914;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_CLP_RTD_05_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_05_LimitsConfigurationEvent));
        Mpm_CLP_RTD_05_LimitsConfigurationEvent item_ = (Mpm_CLP_RTD_05_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_50_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.05572539567947388;
        double warnLo = 0.6577335596084595;
        double limitHi = 0.4815922975540161;
        double limitLo = 0.4228644371032715;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_CLP_RTD_50_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_50_LimitsConfigurationEvent));
        Mpm_CLP_RTD_50_LimitsConfigurationEvent item_ = (Mpm_CLP_RTD_50_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_55_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.739416778087616;
        double warnLo = 0.3624539375305176;
        double limitHi = 0.693045f;
        double limitLo = 0.9182974100112915;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_CLP_RTD_55_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_55_LimitsConfigurationEvent));
        Mpm_CLP_RTD_55_LimitsConfigurationEvent item_ = (Mpm_CLP_RTD_55_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_12_LimitsConfigurationEvent() throws Exception {
        String version = "s";
        double warnHi = 0.3141111135482788;
        double warnLo = 0.3313976526260376;
        double limitHi = 0.1473794f;
        double limitLo = 8.808374404907227E-4;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_CYP_RTD_12_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_12_LimitsConfigurationEvent));
        Mpm_CYP_RTD_12_LimitsConfigurationEvent item_ = (Mpm_CYP_RTD_12_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_14_LimitsConfigurationEvent() throws Exception {
        String version = "v";
        double warnHi = 0.4579852223396301;
        double warnLo = 0.32413625717163086;
        double limitHi = 0.7355019450187683;
        double limitLo = 0.09186446666717529;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_CYP_RTD_14_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_14_LimitsConfigurationEvent));
        Mpm_CYP_RTD_14_LimitsConfigurationEvent item_ = (Mpm_CYP_RTD_14_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_31_LimitsConfigurationEvent() throws Exception {
        String version = "j";
        double warnHi = 0.8124096393585205;
        double warnLo = 0.4726234f;
        double limitHi = 0.5007706880569458;
        double limitLo = 0.14947772026062012;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_CYP_RTD_31_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_31_LimitsConfigurationEvent));
        Mpm_CYP_RTD_31_LimitsConfigurationEvent item_ = (Mpm_CYP_RTD_31_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_43_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.74300217628479;
        double warnLo = 0.05509376525878906;
        double limitHi = 0.9788369536399841;
        double limitLo = 0.9105919599533081;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_CYP_RTD_43_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_43_LimitsConfigurationEvent));
        Mpm_CYP_RTD_43_LimitsConfigurationEvent item_ = (Mpm_CYP_RTD_43_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 822;
        int schedulers_default_nThreads = 704;
        int schedulers_monitor_update_publish_scheduler_nTasks = 712;
        int schedulers_monitor_update_publish_scheduler_nThreads = 469;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Mpm_PeriodicTasks_GeneralConfigurationEvent));
        Mpm_PeriodicTasks_GeneralConfigurationEvent item_ = (Mpm_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveMpm_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "k";
        long agentmonitorservice_taskPeriodMillis = 756L;
        long heartbeat_taskPeriodMillis = 667L;
        long monitor_check_taskPeriodMillis = 37L;
        long monitor_publish_taskPeriodMillis = 322L;
        long monitor_update_taskPeriodMillis = 111L;
        long protection_state_taskPeriodMillis = 961L;
        long runtimeinfo_taskPeriodMillis = 265L;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, protection_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Mpm_PeriodicTasks_timersConfigurationEvent));
        Mpm_PeriodicTasks_timersConfigurationEvent item_ = (Mpm_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)protection_state_taskPeriodMillis, (long)item_.getProtection_state_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveMpm_Pluto_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String node = "b";
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_Pluto_DeviceConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Mpm_Pluto_DeviceConfigurationEvent));
        Mpm_Pluto_DeviceConfigurationEvent item_ = (Mpm_Pluto_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
    }

    @Test
    public void sendReceiveMpm_Pluto_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_Pluto_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Mpm_Pluto_DevicesConfigurationEvent));
        Mpm_Pluto_DevicesConfigurationEvent item_ = (Mpm_Pluto_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveFcs_Autochanger_autochangerConfigurationEvent() throws Exception {
        String version = "y";
        double autochangertrucks_adjustmentFactor = 9.699463844299316E-4;
        int autochangertrucks_approachOnlinePosition = 680;
        int autochangertrucks_approachStandbyPosition = 397;
        int autochangertrucks_deltaPositionForAlignLenient = 611;
        int autochangertrucks_deltaPositionForAlignStrict = 52;
        int autochangertrucks_deltaPositionForAlignStrictLoader = 989;
        int autochangertrucks_deltaPreliminaryTargetPosition = 750;
        String autochangertrucks_driverSide = "v";
        int autochangertrucks_handoffPosition = 358;
        int autochangertrucks_highAcceleration = 871;
        int autochangertrucks_highDeceleration = 791;
        int autochangertrucks_highSpeed = 810;
        int autochangertrucks_lowAcceleration = 309;
        int autochangertrucks_lowDeceleration = 673;
        int autochangertrucks_lowSpeed = 6;
        int autochangertrucks_maxActualPositionValue = 439;
        int autochangertrucks_minActualPositionValue = 725;
        int autochangertrucks_minTargetPosition = 317;
        int autochangertrucks_naturalPosition = 599;
        int autochangertrucks_onlinePosition = 769;
        int autochangertrucks_positionRangeAtHandoff = 361;
        int autochangertrucks_positionRangeAtOnline = 683;
        int autochangertrucks_positionRangeAtStandby = 54;
        int autochangertrucks_positionRangeInTravel = 559;
        int autochangertrucks_prelimaryTargetPosition = 536;
        int autochangertrucks_proximitySensorInput = 384;
        int autochangertrucks_slowMotionPosition = 836;
        int autochangertrucks_standbyPosition = 824;
        int autochangertrucks_standbyPositionEmpty = 790;
        long autochangertrucks_timeoutForAlignFollower = 622L;
        long autochangertrucks_timeoutForTrucksMotion = 879L;
        double autochangertrucks_umax = 0.3069179654121399;
        double autochangertrucks_umin = 0.49842578172683716;
        double autochangertrucks_utarget = 0.4628271460533142;
        int latches_latchXminus_currentToOpen = 880;
        long latches_latchXminus_timeoutForLatchMotion = 450L;
        int latches_latchXplus_currentToOpen = 371;
        long latches_latchXplus_timeoutForLatchMotion = 15L;
        short onlineclamps_maxClosedStrain = 280;
        short onlineclamps_maxLockedStrain = 811;
        int onlineclamps_maxTimeToCloseClampsX = 185;
        int onlineclamps_maxTimeToLockAllClamps = 625;
        int onlineclamps_maxTimeToOpenClampsX = 336;
        int onlineclamps_maxTimeToUnlockAllClamps = 307;
        short onlineclamps_minLockedStrain = 945;
        int onlineclamps_minPeriod = 158;
        int onlineclamps_onlineClampXminus_currentToClamp = 476;
        int onlineclamps_onlineClampXminus_currentToOpen = 200;
        int onlineclamps_onlineClampXminus_deltaCurrent = 346;
        int onlineclamps_onlineClampXminus_finalCurrentToClose = 718;
        int onlineclamps_onlineClampXminus_incrementCurrentToClamp = 883;
        int onlineclamps_onlineClampXminus_incrementCurrentToClose = 955;
        int onlineclamps_onlineClampXminus_incrementCurrentToOpen = 500;
        int onlineclamps_onlineClampXminus_initialCurrentToClose = 227;
        int onlineclamps_onlineClampXminus_targetPositionToClose = 5;
        int onlineclamps_onlineClampXminus_targetPositionToOpen = 995;
        int onlineclamps_onlineClampXplus_currentToClamp = 355;
        int onlineclamps_onlineClampXplus_currentToOpen = 364;
        int onlineclamps_onlineClampXplus_deltaCurrent = 993;
        int onlineclamps_onlineClampXplus_finalCurrentToClose = 777;
        int onlineclamps_onlineClampXplus_incrementCurrentToClamp = 152;
        int onlineclamps_onlineClampXplus_incrementCurrentToClose = 514;
        int onlineclamps_onlineClampXplus_incrementCurrentToOpen = 906;
        int onlineclamps_onlineClampXplus_initialCurrentToClose = 518;
        int onlineclamps_onlineClampXplus_targetPositionToClose = 286;
        int onlineclamps_onlineClampXplus_targetPositionToOpen = 592;
        int onlineclamps_onlineClampYminus_currentToClamp = 710;
        int onlineclamps_onlineClampYminus_currentToOpen = 128;
        int onlineclamps_onlineClampYminus_deltaCurrent = 230;
        int onlineclamps_onlineClampYminus_finalCurrentToClose = 639;
        int onlineclamps_onlineClampYminus_incrementCurrentToClamp = 931;
        int onlineclamps_onlineClampYminus_incrementCurrentToClose = 507;
        int onlineclamps_onlineClampYminus_incrementCurrentToOpen = 976;
        int onlineclamps_onlineClampYminus_initialCurrentToClose = 639;
        int onlineclamps_onlineClampYminus_targetPositionToClose = 302;
        int onlineclamps_onlineClampYminus_targetPositionToOpen = 637;
        double onlineclamps_strainGain = 0.41182655096054077;
        int onlineclamps_timeoutForLockingClamps = 2;
        int onlineclamps_timeoutForUnlockingClamps = 873;
        long timeToUpdateProtectionSystem = 634L;
        int waitTimeForBrakeLR = 894;
        int waitTimeForBrakeOC = 387;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Autochanger_autochangerConfigurationEvent(version, autochangertrucks_adjustmentFactor, autochangertrucks_approachOnlinePosition, autochangertrucks_approachStandbyPosition, autochangertrucks_deltaPositionForAlignLenient, autochangertrucks_deltaPositionForAlignStrict, autochangertrucks_deltaPositionForAlignStrictLoader, autochangertrucks_deltaPreliminaryTargetPosition, autochangertrucks_driverSide, autochangertrucks_handoffPosition, autochangertrucks_highAcceleration, autochangertrucks_highDeceleration, autochangertrucks_highSpeed, autochangertrucks_lowAcceleration, autochangertrucks_lowDeceleration, autochangertrucks_lowSpeed, autochangertrucks_maxActualPositionValue, autochangertrucks_minActualPositionValue, autochangertrucks_minTargetPosition, autochangertrucks_naturalPosition, autochangertrucks_onlinePosition, autochangertrucks_positionRangeAtHandoff, autochangertrucks_positionRangeAtOnline, autochangertrucks_positionRangeAtStandby, autochangertrucks_positionRangeInTravel, autochangertrucks_prelimaryTargetPosition, autochangertrucks_proximitySensorInput, autochangertrucks_slowMotionPosition, autochangertrucks_standbyPosition, autochangertrucks_standbyPositionEmpty, autochangertrucks_timeoutForAlignFollower, autochangertrucks_timeoutForTrucksMotion, autochangertrucks_umax, autochangertrucks_umin, autochangertrucks_utarget, latches_latchXminus_currentToOpen, latches_latchXminus_timeoutForLatchMotion, latches_latchXplus_currentToOpen, latches_latchXplus_timeoutForLatchMotion, onlineclamps_maxClosedStrain, onlineclamps_maxLockedStrain, onlineclamps_maxTimeToCloseClampsX, onlineclamps_maxTimeToLockAllClamps, onlineclamps_maxTimeToOpenClampsX, onlineclamps_maxTimeToUnlockAllClamps, onlineclamps_minLockedStrain, onlineclamps_minPeriod, onlineclamps_onlineClampXminus_currentToClamp, onlineclamps_onlineClampXminus_currentToOpen, onlineclamps_onlineClampXminus_deltaCurrent, onlineclamps_onlineClampXminus_finalCurrentToClose, onlineclamps_onlineClampXminus_incrementCurrentToClamp, onlineclamps_onlineClampXminus_incrementCurrentToClose, onlineclamps_onlineClampXminus_incrementCurrentToOpen, onlineclamps_onlineClampXminus_initialCurrentToClose, onlineclamps_onlineClampXminus_targetPositionToClose, onlineclamps_onlineClampXminus_targetPositionToOpen, onlineclamps_onlineClampXplus_currentToClamp, onlineclamps_onlineClampXplus_currentToOpen, onlineclamps_onlineClampXplus_deltaCurrent, onlineclamps_onlineClampXplus_finalCurrentToClose, onlineclamps_onlineClampXplus_incrementCurrentToClamp, onlineclamps_onlineClampXplus_incrementCurrentToClose, onlineclamps_onlineClampXplus_incrementCurrentToOpen, onlineclamps_onlineClampXplus_initialCurrentToClose, onlineclamps_onlineClampXplus_targetPositionToClose, onlineclamps_onlineClampXplus_targetPositionToOpen, onlineclamps_onlineClampYminus_currentToClamp, onlineclamps_onlineClampYminus_currentToOpen, onlineclamps_onlineClampYminus_deltaCurrent, onlineclamps_onlineClampYminus_finalCurrentToClose, onlineclamps_onlineClampYminus_incrementCurrentToClamp, onlineclamps_onlineClampYminus_incrementCurrentToClose, onlineclamps_onlineClampYminus_incrementCurrentToOpen, onlineclamps_onlineClampYminus_initialCurrentToClose, onlineclamps_onlineClampYminus_targetPositionToClose, onlineclamps_onlineClampYminus_targetPositionToOpen, onlineclamps_strainGain, onlineclamps_timeoutForLockingClamps, onlineclamps_timeoutForUnlockingClamps, timeToUpdateProtectionSystem, waitTimeForBrakeLR, waitTimeForBrakeOC));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_autochangerConfigurationEvent));
        Fcs_Autochanger_autochangerConfigurationEvent item_ = (Fcs_Autochanger_autochangerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)autochangertrucks_adjustmentFactor, (double)item_.getAutochangertrucks_adjustmentFactor(), (double)1.0E-6f);
        Assert.assertEquals((long)autochangertrucks_approachOnlinePosition, (long)item_.getAutochangertrucks_approachOnlinePosition());
        Assert.assertEquals((long)autochangertrucks_approachStandbyPosition, (long)item_.getAutochangertrucks_approachStandbyPosition());
        Assert.assertEquals((long)autochangertrucks_deltaPositionForAlignLenient, (long)item_.getAutochangertrucks_deltaPositionForAlignLenient());
        Assert.assertEquals((long)autochangertrucks_deltaPositionForAlignStrict, (long)item_.getAutochangertrucks_deltaPositionForAlignStrict());
        Assert.assertEquals((long)autochangertrucks_deltaPositionForAlignStrictLoader, (long)item_.getAutochangertrucks_deltaPositionForAlignStrictLoader());
        Assert.assertEquals((long)autochangertrucks_deltaPreliminaryTargetPosition, (long)item_.getAutochangertrucks_deltaPreliminaryTargetPosition());
        Assert.assertEquals((Object)autochangertrucks_driverSide, (Object)item_.getAutochangertrucks_driverSide());
        Assert.assertEquals((long)autochangertrucks_handoffPosition, (long)item_.getAutochangertrucks_handoffPosition());
        Assert.assertEquals((long)autochangertrucks_highAcceleration, (long)item_.getAutochangertrucks_highAcceleration());
        Assert.assertEquals((long)autochangertrucks_highDeceleration, (long)item_.getAutochangertrucks_highDeceleration());
        Assert.assertEquals((long)autochangertrucks_highSpeed, (long)item_.getAutochangertrucks_highSpeed());
        Assert.assertEquals((long)autochangertrucks_lowAcceleration, (long)item_.getAutochangertrucks_lowAcceleration());
        Assert.assertEquals((long)autochangertrucks_lowDeceleration, (long)item_.getAutochangertrucks_lowDeceleration());
        Assert.assertEquals((long)autochangertrucks_lowSpeed, (long)item_.getAutochangertrucks_lowSpeed());
        Assert.assertEquals((long)autochangertrucks_maxActualPositionValue, (long)item_.getAutochangertrucks_maxActualPositionValue());
        Assert.assertEquals((long)autochangertrucks_minActualPositionValue, (long)item_.getAutochangertrucks_minActualPositionValue());
        Assert.assertEquals((long)autochangertrucks_minTargetPosition, (long)item_.getAutochangertrucks_minTargetPosition());
        Assert.assertEquals((long)autochangertrucks_naturalPosition, (long)item_.getAutochangertrucks_naturalPosition());
        Assert.assertEquals((long)autochangertrucks_onlinePosition, (long)item_.getAutochangertrucks_onlinePosition());
        Assert.assertEquals((long)autochangertrucks_positionRangeAtHandoff, (long)item_.getAutochangertrucks_positionRangeAtHandoff());
        Assert.assertEquals((long)autochangertrucks_positionRangeAtOnline, (long)item_.getAutochangertrucks_positionRangeAtOnline());
        Assert.assertEquals((long)autochangertrucks_positionRangeAtStandby, (long)item_.getAutochangertrucks_positionRangeAtStandby());
        Assert.assertEquals((long)autochangertrucks_positionRangeInTravel, (long)item_.getAutochangertrucks_positionRangeInTravel());
        Assert.assertEquals((long)autochangertrucks_prelimaryTargetPosition, (long)item_.getAutochangertrucks_prelimaryTargetPosition());
        Assert.assertEquals((long)autochangertrucks_proximitySensorInput, (long)item_.getAutochangertrucks_proximitySensorInput());
        Assert.assertEquals((long)autochangertrucks_slowMotionPosition, (long)item_.getAutochangertrucks_slowMotionPosition());
        Assert.assertEquals((long)autochangertrucks_standbyPosition, (long)item_.getAutochangertrucks_standbyPosition());
        Assert.assertEquals((long)autochangertrucks_standbyPositionEmpty, (long)item_.getAutochangertrucks_standbyPositionEmpty());
        Assert.assertEquals((long)autochangertrucks_timeoutForAlignFollower, (long)item_.getAutochangertrucks_timeoutForAlignFollower());
        Assert.assertEquals((long)autochangertrucks_timeoutForTrucksMotion, (long)item_.getAutochangertrucks_timeoutForTrucksMotion());
        Assert.assertEquals((double)autochangertrucks_umax, (double)item_.getAutochangertrucks_umax(), (double)1.0E-6f);
        Assert.assertEquals((double)autochangertrucks_umin, (double)item_.getAutochangertrucks_umin(), (double)1.0E-6f);
        Assert.assertEquals((double)autochangertrucks_utarget, (double)item_.getAutochangertrucks_utarget(), (double)1.0E-6f);
        Assert.assertEquals((long)latches_latchXminus_currentToOpen, (long)item_.getLatches_latchXminus_currentToOpen());
        Assert.assertEquals((long)latches_latchXminus_timeoutForLatchMotion, (long)item_.getLatches_latchXminus_timeoutForLatchMotion());
        Assert.assertEquals((long)latches_latchXplus_currentToOpen, (long)item_.getLatches_latchXplus_currentToOpen());
        Assert.assertEquals((long)latches_latchXplus_timeoutForLatchMotion, (long)item_.getLatches_latchXplus_timeoutForLatchMotion());
        Assert.assertEquals((long)onlineclamps_maxClosedStrain, (long)item_.getOnlineclamps_maxClosedStrain());
        Assert.assertEquals((long)onlineclamps_maxLockedStrain, (long)item_.getOnlineclamps_maxLockedStrain());
        Assert.assertEquals((long)onlineclamps_maxTimeToCloseClampsX, (long)item_.getOnlineclamps_maxTimeToCloseClampsX());
        Assert.assertEquals((long)onlineclamps_maxTimeToLockAllClamps, (long)item_.getOnlineclamps_maxTimeToLockAllClamps());
        Assert.assertEquals((long)onlineclamps_maxTimeToOpenClampsX, (long)item_.getOnlineclamps_maxTimeToOpenClampsX());
        Assert.assertEquals((long)onlineclamps_maxTimeToUnlockAllClamps, (long)item_.getOnlineclamps_maxTimeToUnlockAllClamps());
        Assert.assertEquals((long)onlineclamps_minLockedStrain, (long)item_.getOnlineclamps_minLockedStrain());
        Assert.assertEquals((long)onlineclamps_minPeriod, (long)item_.getOnlineclamps_minPeriod());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_currentToClamp, (long)item_.getOnlineclamps_onlineClampXminus_currentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_currentToOpen, (long)item_.getOnlineclamps_onlineClampXminus_currentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_deltaCurrent, (long)item_.getOnlineclamps_onlineClampXminus_deltaCurrent());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_finalCurrentToClose, (long)item_.getOnlineclamps_onlineClampXminus_finalCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_incrementCurrentToClamp, (long)item_.getOnlineclamps_onlineClampXminus_incrementCurrentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_incrementCurrentToClose, (long)item_.getOnlineclamps_onlineClampXminus_incrementCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_incrementCurrentToOpen, (long)item_.getOnlineclamps_onlineClampXminus_incrementCurrentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_initialCurrentToClose, (long)item_.getOnlineclamps_onlineClampXminus_initialCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_targetPositionToClose, (long)item_.getOnlineclamps_onlineClampXminus_targetPositionToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_targetPositionToOpen, (long)item_.getOnlineclamps_onlineClampXminus_targetPositionToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_currentToClamp, (long)item_.getOnlineclamps_onlineClampXplus_currentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_currentToOpen, (long)item_.getOnlineclamps_onlineClampXplus_currentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_deltaCurrent, (long)item_.getOnlineclamps_onlineClampXplus_deltaCurrent());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_finalCurrentToClose, (long)item_.getOnlineclamps_onlineClampXplus_finalCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_incrementCurrentToClamp, (long)item_.getOnlineclamps_onlineClampXplus_incrementCurrentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_incrementCurrentToClose, (long)item_.getOnlineclamps_onlineClampXplus_incrementCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_incrementCurrentToOpen, (long)item_.getOnlineclamps_onlineClampXplus_incrementCurrentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_initialCurrentToClose, (long)item_.getOnlineclamps_onlineClampXplus_initialCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_targetPositionToClose, (long)item_.getOnlineclamps_onlineClampXplus_targetPositionToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_targetPositionToOpen, (long)item_.getOnlineclamps_onlineClampXplus_targetPositionToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_currentToClamp, (long)item_.getOnlineclamps_onlineClampYminus_currentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_currentToOpen, (long)item_.getOnlineclamps_onlineClampYminus_currentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_deltaCurrent, (long)item_.getOnlineclamps_onlineClampYminus_deltaCurrent());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_finalCurrentToClose, (long)item_.getOnlineclamps_onlineClampYminus_finalCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_incrementCurrentToClamp, (long)item_.getOnlineclamps_onlineClampYminus_incrementCurrentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_incrementCurrentToClose, (long)item_.getOnlineclamps_onlineClampYminus_incrementCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_incrementCurrentToOpen, (long)item_.getOnlineclamps_onlineClampYminus_incrementCurrentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_initialCurrentToClose, (long)item_.getOnlineclamps_onlineClampYminus_initialCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_targetPositionToClose, (long)item_.getOnlineclamps_onlineClampYminus_targetPositionToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_targetPositionToOpen, (long)item_.getOnlineclamps_onlineClampYminus_targetPositionToOpen());
        Assert.assertEquals((double)onlineclamps_strainGain, (double)item_.getOnlineclamps_strainGain(), (double)1.0E-6f);
        Assert.assertEquals((long)onlineclamps_timeoutForLockingClamps, (long)item_.getOnlineclamps_timeoutForLockingClamps());
        Assert.assertEquals((long)onlineclamps_timeoutForUnlockingClamps, (long)item_.getOnlineclamps_timeoutForUnlockingClamps());
        Assert.assertEquals((long)timeToUpdateProtectionSystem, (long)item_.getTimeToUpdateProtectionSystem());
        Assert.assertEquals((long)waitTimeForBrakeLR, (long)item_.getWaitTimeForBrakeLR());
        Assert.assertEquals((long)waitTimeForBrakeOC, (long)item_.getWaitTimeForBrakeOC());
    }

    @Test
    public void sendReceiveFcs_Autochanger_readRateConfigurationEvent() throws Exception {
        String version = "";
        int autochangertrucks_readSensorsRate = 174;
        int latches_latchXminus_readSensorsRate = 461;
        int latches_latchXplus_readSensorsRate = 332;
        int onlineclamps_onlineClampXminus_readSensorsRate = 881;
        int onlineclamps_onlineClampXplus_readSensorsRate = 177;
        int onlineclamps_onlineClampYminus_readSensorsRate = 586;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Autochanger_readRateConfigurationEvent(version, autochangertrucks_readSensorsRate, latches_latchXminus_readSensorsRate, latches_latchXplus_readSensorsRate, onlineclamps_onlineClampXminus_readSensorsRate, onlineclamps_onlineClampXplus_readSensorsRate, onlineclamps_onlineClampYminus_readSensorsRate));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_readRateConfigurationEvent));
        Fcs_Autochanger_readRateConfigurationEvent item_ = (Fcs_Autochanger_readRateConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)autochangertrucks_readSensorsRate, (long)item_.getAutochangertrucks_readSensorsRate());
        Assert.assertEquals((long)latches_latchXminus_readSensorsRate, (long)item_.getLatches_latchXminus_readSensorsRate());
        Assert.assertEquals((long)latches_latchXplus_readSensorsRate, (long)item_.getLatches_latchXplus_readSensorsRate());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_readSensorsRate, (long)item_.getOnlineclamps_onlineClampXminus_readSensorsRate());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_readSensorsRate, (long)item_.getOnlineclamps_onlineClampXplus_readSensorsRate());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_readSensorsRate, (long)item_.getOnlineclamps_onlineClampYminus_readSensorsRate());
    }

    @Test
    public void sendReceiveFcs_Autochanger_sensorConfigurationEvent() throws Exception {
        String version = "g";
        int autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_byteNumero = 476;
        String autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_dioName = "k";
        int autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_inputNumero = 591;
        int autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_byteNumero = 465;
        String autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_dioName = "k";
        int autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_inputNumero = 488;
        int autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_byteNumero = 513;
        String autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_dioName = "i";
        int autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_inputNumero = 549;
        int autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_byteNumero = 72;
        String autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_dioName = "k";
        int autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_inputNumero = 758;
        int autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_byteNumero = 882;
        String autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_dioName = "h";
        int autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_inputNumero = 659;
        int autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_byteNumero = 233;
        String autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_dioName = "o";
        int autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_inputNumero = 245;
        int autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_byteNumero = 182;
        String autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_dioName = "";
        int autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_inputNumero = 26;
        int autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_byteNumero = 358;
        String autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_dioName = "u";
        int autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_inputNumero = 839;
        int autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_byteNumero = 262;
        String autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_dioName = "c";
        int autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_inputNumero = 67;
        int autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_byteNumero = 915;
        String autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_dioName = "v";
        int autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_inputNumero = 140;
        int autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_byteNumero = 372;
        String autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_dioName = "d";
        int autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_inputNumero = 900;
        int autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_byteNumero = 42;
        String autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_dioName = "";
        int autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_inputNumero = 775;
        int latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_byteNumero = 141;
        String latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_dioName = "";
        int latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_inputNumero = 265;
        int latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_byteNumero = 239;
        String latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_dioName = "b";
        int latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_inputNumero = 329;
        int latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_byteNumero = 369;
        String latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_dioName = "g";
        int latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_inputNumero = 856;
        int latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_byteNumero = 988;
        String latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_dioName = "";
        int latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_inputNumero = 320;
        int latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_byteNumero = 778;
        String latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_dioName = "";
        int latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_inputNumero = 886;
        int latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_byteNumero = 622;
        String latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_dioName = "";
        int latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_inputNumero = 454;
        int latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_byteNumero = 545;
        String latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_dioName = "";
        int latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_inputNumero = 994;
        int latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_byteNumero = 526;
        String latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_dioName = "q";
        int latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_inputNumero = 838;
        int latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_byteNumero = 189;
        String latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_dioName = "i";
        int latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_inputNumero = 708;
        int latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_byteNumero = 952;
        String latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_dioName = "";
        int latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_inputNumero = 467;
        int latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_byteNumero = 204;
        String latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_dioName = "";
        int latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_inputNumero = 79;
        int latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_byteNumero = 803;
        String latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_dioName = "";
        int latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_inputNumero = 63;
        int onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_byteNumero = 828;
        String onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_dioName = "u";
        int onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_inputNumero = 362;
        int onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_byteNumero = 748;
        String onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_dioName = "a";
        int onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_inputNumero = 771;
        int onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_byteNumero = 839;
        String onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_dioName = "c";
        int onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_inputNumero = 312;
        int onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_byteNumero = 372;
        String onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_dioName = "";
        int onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_inputNumero = 15;
        int onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_byteNumero = 958;
        String onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_dioName = "";
        int onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_inputNumero = 420;
        int onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_byteNumero = 18;
        String onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_dioName = "";
        int onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_inputNumero = 52;
        int onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_byteNumero = 998;
        String onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_dioName = "a";
        int onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_inputNumero = 231;
        int onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_byteNumero = 16;
        String onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_dioName = "i";
        int onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_inputNumero = 530;
        int onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_byteNumero = 881;
        String onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_dioName = "";
        int onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_inputNumero = 389;
        int onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_byteNumero = 219;
        String onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_dioName = "";
        int onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_inputNumero = 369;
        int onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_byteNumero = 630;
        String onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_dioName = "";
        int onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_inputNumero = 196;
        int onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_byteNumero = 284;
        String onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_dioName = "t";
        int onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_inputNumero = 156;
        int plc_OUT_AF0_Sensors_OUT_AF0_C_byteNumero = 249;
        String plc_OUT_AF0_Sensors_OUT_AF0_C_dioName = "";
        int plc_OUT_AF0_Sensors_OUT_AF0_C_inputNumero = 809;
        int plc_OUT_AF0_Sensors_OUT_AF0_byteNumero = 114;
        String plc_OUT_AF0_Sensors_OUT_AF0_dioName = "q";
        int plc_OUT_AF0_Sensors_OUT_AF0_inputNumero = 219;
        int plc_OUT_AF1_Sensors_OUT_AF1_C_byteNumero = 146;
        String plc_OUT_AF1_Sensors_OUT_AF1_C_dioName = "w";
        int plc_OUT_AF1_Sensors_OUT_AF1_C_inputNumero = 226;
        int plc_OUT_AF1_Sensors_OUT_AF1_byteNumero = 732;
        String plc_OUT_AF1_Sensors_OUT_AF1_dioName = "g";
        int plc_OUT_AF1_Sensors_OUT_AF1_inputNumero = 409;
        int plc_OUT_AF3_Sensors_OUT_AF3_C_byteNumero = 726;
        String plc_OUT_AF3_Sensors_OUT_AF3_C_dioName = "";
        int plc_OUT_AF3_Sensors_OUT_AF3_C_inputNumero = 451;
        int plc_OUT_AF3_Sensors_OUT_AF3_byteNumero = 722;
        String plc_OUT_AF3_Sensors_OUT_AF3_dioName = "";
        int plc_OUT_AF3_Sensors_OUT_AF3_inputNumero = 399;
        int plc_OUT_AIN_byteNumero = 168;
        String plc_OUT_AIN_dioName = "";
        int plc_OUT_AIN_inputNumero = 713;
        int plc_OUT_AOL_byteNumero = 784;
        String plc_OUT_AOL_dioName = "";
        int plc_OUT_AOL_inputNumero = 801;
        int plc_OUT_AP1_Sensors_OUT_AP1_C_byteNumero = 61;
        String plc_OUT_AP1_Sensors_OUT_AP1_C_dioName = "";
        int plc_OUT_AP1_Sensors_OUT_AP1_C_inputNumero = 359;
        int plc_OUT_AP1_Sensors_OUT_AP1_byteNumero = 813;
        String plc_OUT_AP1_Sensors_OUT_AP1_dioName = "";
        int plc_OUT_AP1_Sensors_OUT_AP1_inputNumero = 661;
        int plc_OUT_AP2_Sensors_OUT_AP2_C_byteNumero = 219;
        String plc_OUT_AP2_Sensors_OUT_AP2_C_dioName = "i";
        int plc_OUT_AP2_Sensors_OUT_AP2_C_inputNumero = 743;
        int plc_OUT_AP2_Sensors_OUT_AP2_byteNumero = 808;
        String plc_OUT_AP2_Sensors_OUT_AP2_dioName = "";
        int plc_OUT_AP2_Sensors_OUT_AP2_inputNumero = 279;
        int plc_OUT_AP3_Sensors_OUT_AP3_C_byteNumero = 81;
        String plc_OUT_AP3_Sensors_OUT_AP3_C_dioName = "";
        int plc_OUT_AP3_Sensors_OUT_AP3_C_inputNumero = 127;
        int plc_OUT_AP3_Sensors_OUT_AP3_byteNumero = 950;
        String plc_OUT_AP3_Sensors_OUT_AP3_dioName = "f";
        int plc_OUT_AP3_Sensors_OUT_AP3_inputNumero = 87;
        int plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_byteNumero = 602;
        String plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_dioName = "o";
        int plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_inputNumero = 705;
        int plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_byteNumero = 78;
        String plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_dioName = "";
        int plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_inputNumero = 291;
        int plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_byteNumero = 876;
        String plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_dioName = "";
        int plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_inputNumero = 528;
        int plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_byteNumero = 205;
        String plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_dioName = "";
        int plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_inputNumero = 164;
        int plc_carousel_CF0Sensors_carousel_CF0_C_byteNumero = 446;
        String plc_carousel_CF0Sensors_carousel_CF0_C_dioName = "r";
        int plc_carousel_CF0Sensors_carousel_CF0_C_inputNumero = 818;
        int plc_carousel_CF0Sensors_carousel_CF0_byteNumero = 659;
        String plc_carousel_CF0Sensors_carousel_CF0_dioName = "";
        int plc_carousel_CF0Sensors_carousel_CF0_inputNumero = 232;
        int plc_carousel_CF1Sensors_carousel_CF1_C_byteNumero = 660;
        String plc_carousel_CF1Sensors_carousel_CF1_C_dioName = "l";
        int plc_carousel_CF1Sensors_carousel_CF1_C_inputNumero = 594;
        int plc_carousel_CF1Sensors_carousel_CF1_byteNumero = 722;
        String plc_carousel_CF1Sensors_carousel_CF1_dioName = "w";
        int plc_carousel_CF1Sensors_carousel_CF1_inputNumero = 158;
        int plc_inclinometerXminus_byteNumero = 558;
        String plc_inclinometerXminus_deviceName = "a";
        int plc_inclinometerXplus_byteNumero = 692;
        String plc_inclinometerXplus_deviceName = "";
        int plc_loaderConnectedSensors_loaderConnectedSensorC_byteNumero = 549;
        String plc_loaderConnectedSensors_loaderConnectedSensorC_dioName = "";
        int plc_loaderConnectedSensors_loaderConnectedSensorC_inputNumero = 260;
        int plc_loaderConnectedSensors_loaderConnectedSensor_byteNumero = 949;
        String plc_loaderConnectedSensors_loaderConnectedSensor_dioName = "";
        int plc_loaderConnectedSensors_loaderConnectedSensor_inputNumero = 274;
        int plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_byteNumero = 152;
        String plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_dioName = "";
        int plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_inputNumero = 710;
        int plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_byteNumero = 430;
        String plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_dioName = "w";
        int plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_inputNumero = 514;
        int plc_loaderPresenceSensors_presenceLoader_C_byteNumero = 857;
        String plc_loaderPresenceSensors_presenceLoader_C_dioName = "";
        int plc_loaderPresenceSensors_presenceLoader_C_inputNumero = 348;
        int plc_loaderPresenceSensors_presenceLoader_byteNumero = 536;
        String plc_loaderPresenceSensors_presenceLoader_dioName = "d";
        int plc_loaderPresenceSensors_presenceLoader_inputNumero = 944;
        int plc_lockOutSensors_lockOut_C_byteNumero = 402;
        String plc_lockOutSensors_lockOut_C_dioName = "q";
        int plc_lockOutSensors_lockOut_C_inputNumero = 229;
        int plc_lockOutSensors_lockOut_byteNumero = 197;
        String plc_lockOutSensors_lockOut_dioName = "";
        int plc_lockOutSensors_lockOut_inputNumero = 621;
        int plc_lockOutShunt_byteNumero = 530;
        String plc_lockOutShunt_dioName = "c";
        int plc_lockOutShunt_inputNumero = 420;
        int plc_lpmEngineeringKeySensors_engineeringKey_C_byteNumero = 548;
        String plc_lpmEngineeringKeySensors_engineeringKey_C_dioName = "";
        int plc_lpmEngineeringKeySensors_engineeringKey_C_inputNumero = 967;
        int plc_lpmEngineeringKeySensors_engineeringKey_byteNumero = 934;
        String plc_lpmEngineeringKeySensors_engineeringKey_dioName = "";
        int plc_lpmEngineeringKeySensors_engineeringKey_inputNumero = 694;
        int plc_lpmLatchesStatus_byteNumero = 458;
        String plc_lpmLatchesStatus_dioName = "";
        int plc_lpmLatchesStatus_inputNumero = 390;
        int plc_lpmLinearRail1Status_byteNumero = 501;
        String plc_lpmLinearRail1Status_dioName = "";
        int plc_lpmLinearRail1Status_inputNumero = 737;
        int plc_lpmLinearRail2Status_byteNumero = 249;
        String plc_lpmLinearRail2Status_dioName = "u";
        int plc_lpmLinearRail2Status_inputNumero = 314;
        int plc_lpmOnlineClampsStatus_byteNumero = 774;
        String plc_lpmOnlineClampsStatus_dioName = "";
        int plc_lpmOnlineClampsStatus_inputNumero = 283;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Autochanger_sensorConfigurationEvent(version, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_byteNumero, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_dioName, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_inputNumero, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_byteNumero, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_dioName, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_inputNumero, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_byteNumero, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_dioName, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_inputNumero, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_byteNumero, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_dioName, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_inputNumero, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_byteNumero, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_dioName, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_inputNumero, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_byteNumero, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_dioName, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_inputNumero, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_byteNumero, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_dioName, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_inputNumero, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_byteNumero, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_dioName, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_inputNumero, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_byteNumero, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_dioName, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_inputNumero, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_byteNumero, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_dioName, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_inputNumero, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_byteNumero, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_dioName, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_inputNumero, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_byteNumero, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_dioName, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_inputNumero, latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_byteNumero, latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_dioName, latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_inputNumero, latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_byteNumero, latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_dioName, latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_inputNumero, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_byteNumero, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_dioName, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_inputNumero, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_byteNumero, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_dioName, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_inputNumero, latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_byteNumero, latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_dioName, latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_inputNumero, latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_byteNumero, latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_dioName, latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_inputNumero, latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_byteNumero, latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_dioName, latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_inputNumero, latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_byteNumero, latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_dioName, latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_inputNumero, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_byteNumero, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_dioName, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_inputNumero, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_byteNumero, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_dioName, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_inputNumero, latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_byteNumero, latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_dioName, latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_inputNumero, latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_byteNumero, latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_dioName, latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_inputNumero, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_byteNumero, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_dioName, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_inputNumero, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_byteNumero, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_dioName, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_inputNumero, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_byteNumero, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_dioName, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_inputNumero, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_byteNumero, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_dioName, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_inputNumero, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_byteNumero, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_dioName, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_inputNumero, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_byteNumero, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_dioName, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_inputNumero, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_byteNumero, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_dioName, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_inputNumero, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_byteNumero, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_dioName, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_inputNumero, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_byteNumero, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_dioName, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_inputNumero, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_byteNumero, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_dioName, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_inputNumero, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_byteNumero, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_dioName, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_inputNumero, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_byteNumero, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_dioName, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_inputNumero, plc_OUT_AF0_Sensors_OUT_AF0_C_byteNumero, plc_OUT_AF0_Sensors_OUT_AF0_C_dioName, plc_OUT_AF0_Sensors_OUT_AF0_C_inputNumero, plc_OUT_AF0_Sensors_OUT_AF0_byteNumero, plc_OUT_AF0_Sensors_OUT_AF0_dioName, plc_OUT_AF0_Sensors_OUT_AF0_inputNumero, plc_OUT_AF1_Sensors_OUT_AF1_C_byteNumero, plc_OUT_AF1_Sensors_OUT_AF1_C_dioName, plc_OUT_AF1_Sensors_OUT_AF1_C_inputNumero, plc_OUT_AF1_Sensors_OUT_AF1_byteNumero, plc_OUT_AF1_Sensors_OUT_AF1_dioName, plc_OUT_AF1_Sensors_OUT_AF1_inputNumero, plc_OUT_AF3_Sensors_OUT_AF3_C_byteNumero, plc_OUT_AF3_Sensors_OUT_AF3_C_dioName, plc_OUT_AF3_Sensors_OUT_AF3_C_inputNumero, plc_OUT_AF3_Sensors_OUT_AF3_byteNumero, plc_OUT_AF3_Sensors_OUT_AF3_dioName, plc_OUT_AF3_Sensors_OUT_AF3_inputNumero, plc_OUT_AIN_byteNumero, plc_OUT_AIN_dioName, plc_OUT_AIN_inputNumero, plc_OUT_AOL_byteNumero, plc_OUT_AOL_dioName, plc_OUT_AOL_inputNumero, plc_OUT_AP1_Sensors_OUT_AP1_C_byteNumero, plc_OUT_AP1_Sensors_OUT_AP1_C_dioName, plc_OUT_AP1_Sensors_OUT_AP1_C_inputNumero, plc_OUT_AP1_Sensors_OUT_AP1_byteNumero, plc_OUT_AP1_Sensors_OUT_AP1_dioName, plc_OUT_AP1_Sensors_OUT_AP1_inputNumero, plc_OUT_AP2_Sensors_OUT_AP2_C_byteNumero, plc_OUT_AP2_Sensors_OUT_AP2_C_dioName, plc_OUT_AP2_Sensors_OUT_AP2_C_inputNumero, plc_OUT_AP2_Sensors_OUT_AP2_byteNumero, plc_OUT_AP2_Sensors_OUT_AP2_dioName, plc_OUT_AP2_Sensors_OUT_AP2_inputNumero, plc_OUT_AP3_Sensors_OUT_AP3_C_byteNumero, plc_OUT_AP3_Sensors_OUT_AP3_C_dioName, plc_OUT_AP3_Sensors_OUT_AP3_C_inputNumero, plc_OUT_AP3_Sensors_OUT_AP3_byteNumero, plc_OUT_AP3_Sensors_OUT_AP3_dioName, plc_OUT_AP3_Sensors_OUT_AP3_inputNumero, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_byteNumero, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_dioName, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_inputNumero, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_byteNumero, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_dioName, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_inputNumero, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_byteNumero, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_dioName, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_inputNumero, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_byteNumero, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_dioName, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_inputNumero, plc_carousel_CF0Sensors_carousel_CF0_C_byteNumero, plc_carousel_CF0Sensors_carousel_CF0_C_dioName, plc_carousel_CF0Sensors_carousel_CF0_C_inputNumero, plc_carousel_CF0Sensors_carousel_CF0_byteNumero, plc_carousel_CF0Sensors_carousel_CF0_dioName, plc_carousel_CF0Sensors_carousel_CF0_inputNumero, plc_carousel_CF1Sensors_carousel_CF1_C_byteNumero, plc_carousel_CF1Sensors_carousel_CF1_C_dioName, plc_carousel_CF1Sensors_carousel_CF1_C_inputNumero, plc_carousel_CF1Sensors_carousel_CF1_byteNumero, plc_carousel_CF1Sensors_carousel_CF1_dioName, plc_carousel_CF1Sensors_carousel_CF1_inputNumero, plc_inclinometerXminus_byteNumero, plc_inclinometerXminus_deviceName, plc_inclinometerXplus_byteNumero, plc_inclinometerXplus_deviceName, plc_loaderConnectedSensors_loaderConnectedSensorC_byteNumero, plc_loaderConnectedSensors_loaderConnectedSensorC_dioName, plc_loaderConnectedSensors_loaderConnectedSensorC_inputNumero, plc_loaderConnectedSensors_loaderConnectedSensor_byteNumero, plc_loaderConnectedSensors_loaderConnectedSensor_dioName, plc_loaderConnectedSensors_loaderConnectedSensor_inputNumero, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_byteNumero, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_dioName, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_inputNumero, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_byteNumero, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_dioName, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_inputNumero, plc_loaderPresenceSensors_presenceLoader_C_byteNumero, plc_loaderPresenceSensors_presenceLoader_C_dioName, plc_loaderPresenceSensors_presenceLoader_C_inputNumero, plc_loaderPresenceSensors_presenceLoader_byteNumero, plc_loaderPresenceSensors_presenceLoader_dioName, plc_loaderPresenceSensors_presenceLoader_inputNumero, plc_lockOutSensors_lockOut_C_byteNumero, plc_lockOutSensors_lockOut_C_dioName, plc_lockOutSensors_lockOut_C_inputNumero, plc_lockOutSensors_lockOut_byteNumero, plc_lockOutSensors_lockOut_dioName, plc_lockOutSensors_lockOut_inputNumero, plc_lockOutShunt_byteNumero, plc_lockOutShunt_dioName, plc_lockOutShunt_inputNumero, plc_lpmEngineeringKeySensors_engineeringKey_C_byteNumero, plc_lpmEngineeringKeySensors_engineeringKey_C_dioName, plc_lpmEngineeringKeySensors_engineeringKey_C_inputNumero, plc_lpmEngineeringKeySensors_engineeringKey_byteNumero, plc_lpmEngineeringKeySensors_engineeringKey_dioName, plc_lpmEngineeringKeySensors_engineeringKey_inputNumero, plc_lpmLatchesStatus_byteNumero, plc_lpmLatchesStatus_dioName, plc_lpmLatchesStatus_inputNumero, plc_lpmLinearRail1Status_byteNumero, plc_lpmLinearRail1Status_dioName, plc_lpmLinearRail1Status_inputNumero, plc_lpmLinearRail2Status_byteNumero, plc_lpmLinearRail2Status_dioName, plc_lpmLinearRail2Status_inputNumero, plc_lpmOnlineClampsStatus_byteNumero, plc_lpmOnlineClampsStatus_dioName, plc_lpmOnlineClampsStatus_inputNumero));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_sensorConfigurationEvent));
        Fcs_Autochanger_sensorConfigurationEvent item_ = (Fcs_Autochanger_sensorConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_dioName, (Object)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_dioName, (Object)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_dioName, (Object)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_dioName, (Object)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_dioName, (Object)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_dioName, (Object)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_dioName, (Object)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_dioName, (Object)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_dioName, (Object)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_dioName, (Object)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_dioName, (Object)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_dioName, (Object)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_dioName, (Object)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_dioName, (Object)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_dioName, (Object)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_dioName, (Object)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_dioName, (Object)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_dioName, (Object)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF0_Sensors_OUT_AF0_C_byteNumero, (long)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF0_Sensors_OUT_AF0_C_dioName, (Object)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_C_dioName());
        Assert.assertEquals((long)plc_OUT_AF0_Sensors_OUT_AF0_C_inputNumero, (long)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF0_Sensors_OUT_AF0_byteNumero, (long)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF0_Sensors_OUT_AF0_dioName, (Object)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_dioName());
        Assert.assertEquals((long)plc_OUT_AF0_Sensors_OUT_AF0_inputNumero, (long)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF1_Sensors_OUT_AF1_C_byteNumero, (long)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF1_Sensors_OUT_AF1_C_dioName, (Object)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_C_dioName());
        Assert.assertEquals((long)plc_OUT_AF1_Sensors_OUT_AF1_C_inputNumero, (long)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF1_Sensors_OUT_AF1_byteNumero, (long)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF1_Sensors_OUT_AF1_dioName, (Object)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_dioName());
        Assert.assertEquals((long)plc_OUT_AF1_Sensors_OUT_AF1_inputNumero, (long)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF3_Sensors_OUT_AF3_C_byteNumero, (long)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF3_Sensors_OUT_AF3_C_dioName, (Object)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_C_dioName());
        Assert.assertEquals((long)plc_OUT_AF3_Sensors_OUT_AF3_C_inputNumero, (long)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF3_Sensors_OUT_AF3_byteNumero, (long)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF3_Sensors_OUT_AF3_dioName, (Object)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_dioName());
        Assert.assertEquals((long)plc_OUT_AF3_Sensors_OUT_AF3_inputNumero, (long)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_inputNumero());
        Assert.assertEquals((long)plc_OUT_AIN_byteNumero, (long)item_.getPlc_OUT_AIN_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AIN_dioName, (Object)item_.getPlc_OUT_AIN_dioName());
        Assert.assertEquals((long)plc_OUT_AIN_inputNumero, (long)item_.getPlc_OUT_AIN_inputNumero());
        Assert.assertEquals((long)plc_OUT_AOL_byteNumero, (long)item_.getPlc_OUT_AOL_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AOL_dioName, (Object)item_.getPlc_OUT_AOL_dioName());
        Assert.assertEquals((long)plc_OUT_AOL_inputNumero, (long)item_.getPlc_OUT_AOL_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP1_Sensors_OUT_AP1_C_byteNumero, (long)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP1_Sensors_OUT_AP1_C_dioName, (Object)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_C_dioName());
        Assert.assertEquals((long)plc_OUT_AP1_Sensors_OUT_AP1_C_inputNumero, (long)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP1_Sensors_OUT_AP1_byteNumero, (long)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP1_Sensors_OUT_AP1_dioName, (Object)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_dioName());
        Assert.assertEquals((long)plc_OUT_AP1_Sensors_OUT_AP1_inputNumero, (long)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP2_Sensors_OUT_AP2_C_byteNumero, (long)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP2_Sensors_OUT_AP2_C_dioName, (Object)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_C_dioName());
        Assert.assertEquals((long)plc_OUT_AP2_Sensors_OUT_AP2_C_inputNumero, (long)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP2_Sensors_OUT_AP2_byteNumero, (long)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP2_Sensors_OUT_AP2_dioName, (Object)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_dioName());
        Assert.assertEquals((long)plc_OUT_AP2_Sensors_OUT_AP2_inputNumero, (long)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP3_Sensors_OUT_AP3_C_byteNumero, (long)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP3_Sensors_OUT_AP3_C_dioName, (Object)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_C_dioName());
        Assert.assertEquals((long)plc_OUT_AP3_Sensors_OUT_AP3_C_inputNumero, (long)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP3_Sensors_OUT_AP3_byteNumero, (long)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP3_Sensors_OUT_AP3_dioName, (Object)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_dioName());
        Assert.assertEquals((long)plc_OUT_AP3_Sensors_OUT_AP3_inputNumero, (long)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_inputNumero());
        Assert.assertEquals((long)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_byteNumero, (long)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_byteNumero());
        Assert.assertEquals((Object)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_dioName, (Object)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_dioName());
        Assert.assertEquals((long)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_inputNumero, (long)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_inputNumero());
        Assert.assertEquals((long)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_byteNumero, (long)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_byteNumero());
        Assert.assertEquals((Object)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_dioName, (Object)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_dioName());
        Assert.assertEquals((long)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_inputNumero, (long)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_inputNumero());
        Assert.assertEquals((long)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_byteNumero, (long)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_byteNumero());
        Assert.assertEquals((Object)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_dioName, (Object)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_dioName());
        Assert.assertEquals((long)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_inputNumero, (long)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_inputNumero());
        Assert.assertEquals((long)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_byteNumero, (long)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_byteNumero());
        Assert.assertEquals((Object)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_dioName, (Object)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_dioName());
        Assert.assertEquals((long)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_inputNumero, (long)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_inputNumero());
        Assert.assertEquals((long)plc_carousel_CF0Sensors_carousel_CF0_C_byteNumero, (long)item_.getPlc_carousel_CF0Sensors_carousel_CF0_C_byteNumero());
        Assert.assertEquals((Object)plc_carousel_CF0Sensors_carousel_CF0_C_dioName, (Object)item_.getPlc_carousel_CF0Sensors_carousel_CF0_C_dioName());
        Assert.assertEquals((long)plc_carousel_CF0Sensors_carousel_CF0_C_inputNumero, (long)item_.getPlc_carousel_CF0Sensors_carousel_CF0_C_inputNumero());
        Assert.assertEquals((long)plc_carousel_CF0Sensors_carousel_CF0_byteNumero, (long)item_.getPlc_carousel_CF0Sensors_carousel_CF0_byteNumero());
        Assert.assertEquals((Object)plc_carousel_CF0Sensors_carousel_CF0_dioName, (Object)item_.getPlc_carousel_CF0Sensors_carousel_CF0_dioName());
        Assert.assertEquals((long)plc_carousel_CF0Sensors_carousel_CF0_inputNumero, (long)item_.getPlc_carousel_CF0Sensors_carousel_CF0_inputNumero());
        Assert.assertEquals((long)plc_carousel_CF1Sensors_carousel_CF1_C_byteNumero, (long)item_.getPlc_carousel_CF1Sensors_carousel_CF1_C_byteNumero());
        Assert.assertEquals((Object)plc_carousel_CF1Sensors_carousel_CF1_C_dioName, (Object)item_.getPlc_carousel_CF1Sensors_carousel_CF1_C_dioName());
        Assert.assertEquals((long)plc_carousel_CF1Sensors_carousel_CF1_C_inputNumero, (long)item_.getPlc_carousel_CF1Sensors_carousel_CF1_C_inputNumero());
        Assert.assertEquals((long)plc_carousel_CF1Sensors_carousel_CF1_byteNumero, (long)item_.getPlc_carousel_CF1Sensors_carousel_CF1_byteNumero());
        Assert.assertEquals((Object)plc_carousel_CF1Sensors_carousel_CF1_dioName, (Object)item_.getPlc_carousel_CF1Sensors_carousel_CF1_dioName());
        Assert.assertEquals((long)plc_carousel_CF1Sensors_carousel_CF1_inputNumero, (long)item_.getPlc_carousel_CF1Sensors_carousel_CF1_inputNumero());
        Assert.assertEquals((long)plc_inclinometerXminus_byteNumero, (long)item_.getPlc_inclinometerXminus_byteNumero());
        Assert.assertEquals((Object)plc_inclinometerXminus_deviceName, (Object)item_.getPlc_inclinometerXminus_deviceName());
        Assert.assertEquals((long)plc_inclinometerXplus_byteNumero, (long)item_.getPlc_inclinometerXplus_byteNumero());
        Assert.assertEquals((Object)plc_inclinometerXplus_deviceName, (Object)item_.getPlc_inclinometerXplus_deviceName());
        Assert.assertEquals((long)plc_loaderConnectedSensors_loaderConnectedSensorC_byteNumero, (long)item_.getPlc_loaderConnectedSensors_loaderConnectedSensorC_byteNumero());
        Assert.assertEquals((Object)plc_loaderConnectedSensors_loaderConnectedSensorC_dioName, (Object)item_.getPlc_loaderConnectedSensors_loaderConnectedSensorC_dioName());
        Assert.assertEquals((long)plc_loaderConnectedSensors_loaderConnectedSensorC_inputNumero, (long)item_.getPlc_loaderConnectedSensors_loaderConnectedSensorC_inputNumero());
        Assert.assertEquals((long)plc_loaderConnectedSensors_loaderConnectedSensor_byteNumero, (long)item_.getPlc_loaderConnectedSensors_loaderConnectedSensor_byteNumero());
        Assert.assertEquals((Object)plc_loaderConnectedSensors_loaderConnectedSensor_dioName, (Object)item_.getPlc_loaderConnectedSensors_loaderConnectedSensor_dioName());
        Assert.assertEquals((long)plc_loaderConnectedSensors_loaderConnectedSensor_inputNumero, (long)item_.getPlc_loaderConnectedSensors_loaderConnectedSensor_inputNumero());
        Assert.assertEquals((long)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_byteNumero, (long)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_byteNumero());
        Assert.assertEquals((Object)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_dioName, (Object)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_dioName());
        Assert.assertEquals((long)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_inputNumero, (long)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_inputNumero());
        Assert.assertEquals((long)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_byteNumero, (long)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_byteNumero());
        Assert.assertEquals((Object)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_dioName, (Object)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_dioName());
        Assert.assertEquals((long)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_inputNumero, (long)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_inputNumero());
        Assert.assertEquals((long)plc_loaderPresenceSensors_presenceLoader_C_byteNumero, (long)item_.getPlc_loaderPresenceSensors_presenceLoader_C_byteNumero());
        Assert.assertEquals((Object)plc_loaderPresenceSensors_presenceLoader_C_dioName, (Object)item_.getPlc_loaderPresenceSensors_presenceLoader_C_dioName());
        Assert.assertEquals((long)plc_loaderPresenceSensors_presenceLoader_C_inputNumero, (long)item_.getPlc_loaderPresenceSensors_presenceLoader_C_inputNumero());
        Assert.assertEquals((long)plc_loaderPresenceSensors_presenceLoader_byteNumero, (long)item_.getPlc_loaderPresenceSensors_presenceLoader_byteNumero());
        Assert.assertEquals((Object)plc_loaderPresenceSensors_presenceLoader_dioName, (Object)item_.getPlc_loaderPresenceSensors_presenceLoader_dioName());
        Assert.assertEquals((long)plc_loaderPresenceSensors_presenceLoader_inputNumero, (long)item_.getPlc_loaderPresenceSensors_presenceLoader_inputNumero());
        Assert.assertEquals((long)plc_lockOutSensors_lockOut_C_byteNumero, (long)item_.getPlc_lockOutSensors_lockOut_C_byteNumero());
        Assert.assertEquals((Object)plc_lockOutSensors_lockOut_C_dioName, (Object)item_.getPlc_lockOutSensors_lockOut_C_dioName());
        Assert.assertEquals((long)plc_lockOutSensors_lockOut_C_inputNumero, (long)item_.getPlc_lockOutSensors_lockOut_C_inputNumero());
        Assert.assertEquals((long)plc_lockOutSensors_lockOut_byteNumero, (long)item_.getPlc_lockOutSensors_lockOut_byteNumero());
        Assert.assertEquals((Object)plc_lockOutSensors_lockOut_dioName, (Object)item_.getPlc_lockOutSensors_lockOut_dioName());
        Assert.assertEquals((long)plc_lockOutSensors_lockOut_inputNumero, (long)item_.getPlc_lockOutSensors_lockOut_inputNumero());
        Assert.assertEquals((long)plc_lockOutShunt_byteNumero, (long)item_.getPlc_lockOutShunt_byteNumero());
        Assert.assertEquals((Object)plc_lockOutShunt_dioName, (Object)item_.getPlc_lockOutShunt_dioName());
        Assert.assertEquals((long)plc_lockOutShunt_inputNumero, (long)item_.getPlc_lockOutShunt_inputNumero());
        Assert.assertEquals((long)plc_lpmEngineeringKeySensors_engineeringKey_C_byteNumero, (long)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_C_byteNumero());
        Assert.assertEquals((Object)plc_lpmEngineeringKeySensors_engineeringKey_C_dioName, (Object)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_C_dioName());
        Assert.assertEquals((long)plc_lpmEngineeringKeySensors_engineeringKey_C_inputNumero, (long)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_C_inputNumero());
        Assert.assertEquals((long)plc_lpmEngineeringKeySensors_engineeringKey_byteNumero, (long)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_byteNumero());
        Assert.assertEquals((Object)plc_lpmEngineeringKeySensors_engineeringKey_dioName, (Object)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_dioName());
        Assert.assertEquals((long)plc_lpmEngineeringKeySensors_engineeringKey_inputNumero, (long)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_inputNumero());
        Assert.assertEquals((long)plc_lpmLatchesStatus_byteNumero, (long)item_.getPlc_lpmLatchesStatus_byteNumero());
        Assert.assertEquals((Object)plc_lpmLatchesStatus_dioName, (Object)item_.getPlc_lpmLatchesStatus_dioName());
        Assert.assertEquals((long)plc_lpmLatchesStatus_inputNumero, (long)item_.getPlc_lpmLatchesStatus_inputNumero());
        Assert.assertEquals((long)plc_lpmLinearRail1Status_byteNumero, (long)item_.getPlc_lpmLinearRail1Status_byteNumero());
        Assert.assertEquals((Object)plc_lpmLinearRail1Status_dioName, (Object)item_.getPlc_lpmLinearRail1Status_dioName());
        Assert.assertEquals((long)plc_lpmLinearRail1Status_inputNumero, (long)item_.getPlc_lpmLinearRail1Status_inputNumero());
        Assert.assertEquals((long)plc_lpmLinearRail2Status_byteNumero, (long)item_.getPlc_lpmLinearRail2Status_byteNumero());
        Assert.assertEquals((Object)plc_lpmLinearRail2Status_dioName, (Object)item_.getPlc_lpmLinearRail2Status_dioName());
        Assert.assertEquals((long)plc_lpmLinearRail2Status_inputNumero, (long)item_.getPlc_lpmLinearRail2Status_inputNumero());
        Assert.assertEquals((long)plc_lpmOnlineClampsStatus_byteNumero, (long)item_.getPlc_lpmOnlineClampsStatus_byteNumero());
        Assert.assertEquals((Object)plc_lpmOnlineClampsStatus_dioName, (Object)item_.getPlc_lpmOnlineClampsStatus_dioName());
        Assert.assertEquals((long)plc_lpmOnlineClampsStatus_inputNumero, (long)item_.getPlc_lpmOnlineClampsStatus_inputNumero());
    }

    @Test
    public void sendReceiveFcs_Canbus0_canbusConfigurationEvent() throws Exception {
        String version = "x";
        String baud = "k";
        String busName = "";
        long hardwareBootTimeout = 877L;
        int masterNodeID = 611;
        boolean pdoRecoveryActive = true;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus0_canbusConfigurationEvent(version, baud, busName, hardwareBootTimeout, masterNodeID, pdoRecoveryActive));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_canbusConfigurationEvent));
        Fcs_Canbus0_canbusConfigurationEvent item_ = (Fcs_Canbus0_canbusConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)baud, (Object)item_.getBaud());
        Assert.assertEquals((Object)busName, (Object)item_.getBusName());
        Assert.assertEquals((long)hardwareBootTimeout, (long)item_.getHardwareBootTimeout());
        Assert.assertEquals((long)masterNodeID, (long)item_.getMasterNodeID());
        Assert.assertEquals((Object)pdoRecoveryActive, (Object)item_.isPdoRecoveryActive());
    }

    @Test
    public void sendReceiveFcs_Canbus0_controllerConfigurationEvent() throws Exception {
        String version = "u";
        int actruckxminuscontroller_encoderRibbonMinValue = 187;
        String actruckxminuscontroller_paramsForCurrent = "";
        String actruckxminuscontroller_paramsForHoming = "x";
        String actruckxminuscontroller_paramsForProfilePosition = "";
        int actruckxpluscontroller_encoderRibbonMinValue = 234;
        String actruckxpluscontroller_paramsForCurrent = "v";
        String actruckxpluscontroller_paramsForHoming = "n";
        String actruckxpluscontroller_paramsForProfilePosition = "s";
        String carouselcontroller_paramsForCurrent = "u";
        String carouselcontroller_paramsForHoming = "";
        String carouselcontroller_paramsForProfilePosition = "s";
        String clampxminuscontroller_paramsForCurrent = "z";
        String clampxminuscontroller_paramsForHoming = "";
        String clampxminuscontroller_paramsForProfilePosition = "m";
        String clampxpluscontroller_paramsForCurrent = "l";
        String clampxpluscontroller_paramsForHoming = "k";
        String clampxpluscontroller_paramsForProfilePosition = "";
        String latchxminuscontroller_paramsForCurrent = "a";
        String latchxminuscontroller_paramsForHoming = "c";
        String latchxminuscontroller_paramsForProfilePosition = "g";
        String latchxpluscontroller_paramsForCurrent = "q";
        String latchxpluscontroller_paramsForHoming = "d";
        String latchxpluscontroller_paramsForProfilePosition = "";
        String onlineclampxminuscontroller_paramsForCurrent = "";
        String onlineclampxminuscontroller_paramsForHoming = "q";
        String onlineclampxminuscontroller_paramsForProfilePosition = "";
        String onlineclampxpluscontroller_paramsForCurrent = "";
        String onlineclampxpluscontroller_paramsForHoming = "v";
        String onlineclampxpluscontroller_paramsForProfilePosition = "e";
        String onlineclampyminuscontroller_paramsForCurrent = "";
        String onlineclampyminuscontroller_paramsForHoming = "v";
        String onlineclampyminuscontroller_paramsForProfilePosition = "z";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus0_controllerConfigurationEvent(version, actruckxminuscontroller_encoderRibbonMinValue, actruckxminuscontroller_paramsForCurrent, actruckxminuscontroller_paramsForHoming, actruckxminuscontroller_paramsForProfilePosition, actruckxpluscontroller_encoderRibbonMinValue, actruckxpluscontroller_paramsForCurrent, actruckxpluscontroller_paramsForHoming, actruckxpluscontroller_paramsForProfilePosition, carouselcontroller_paramsForCurrent, carouselcontroller_paramsForHoming, carouselcontroller_paramsForProfilePosition, clampxminuscontroller_paramsForCurrent, clampxminuscontroller_paramsForHoming, clampxminuscontroller_paramsForProfilePosition, clampxpluscontroller_paramsForCurrent, clampxpluscontroller_paramsForHoming, clampxpluscontroller_paramsForProfilePosition, latchxminuscontroller_paramsForCurrent, latchxminuscontroller_paramsForHoming, latchxminuscontroller_paramsForProfilePosition, latchxpluscontroller_paramsForCurrent, latchxpluscontroller_paramsForHoming, latchxpluscontroller_paramsForProfilePosition, onlineclampxminuscontroller_paramsForCurrent, onlineclampxminuscontroller_paramsForHoming, onlineclampxminuscontroller_paramsForProfilePosition, onlineclampxpluscontroller_paramsForCurrent, onlineclampxpluscontroller_paramsForHoming, onlineclampxpluscontroller_paramsForProfilePosition, onlineclampyminuscontroller_paramsForCurrent, onlineclampyminuscontroller_paramsForHoming, onlineclampyminuscontroller_paramsForProfilePosition));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_controllerConfigurationEvent));
        Fcs_Canbus0_controllerConfigurationEvent item_ = (Fcs_Canbus0_controllerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)actruckxminuscontroller_encoderRibbonMinValue, (long)item_.getActruckxminuscontroller_encoderRibbonMinValue());
        Assert.assertEquals((Object)actruckxminuscontroller_paramsForCurrent, (Object)item_.getActruckxminuscontroller_paramsForCurrent());
        Assert.assertEquals((Object)actruckxminuscontroller_paramsForHoming, (Object)item_.getActruckxminuscontroller_paramsForHoming());
        Assert.assertEquals((Object)actruckxminuscontroller_paramsForProfilePosition, (Object)item_.getActruckxminuscontroller_paramsForProfilePosition());
        Assert.assertEquals((long)actruckxpluscontroller_encoderRibbonMinValue, (long)item_.getActruckxpluscontroller_encoderRibbonMinValue());
        Assert.assertEquals((Object)actruckxpluscontroller_paramsForCurrent, (Object)item_.getActruckxpluscontroller_paramsForCurrent());
        Assert.assertEquals((Object)actruckxpluscontroller_paramsForHoming, (Object)item_.getActruckxpluscontroller_paramsForHoming());
        Assert.assertEquals((Object)actruckxpluscontroller_paramsForProfilePosition, (Object)item_.getActruckxpluscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)carouselcontroller_paramsForCurrent, (Object)item_.getCarouselcontroller_paramsForCurrent());
        Assert.assertEquals((Object)carouselcontroller_paramsForHoming, (Object)item_.getCarouselcontroller_paramsForHoming());
        Assert.assertEquals((Object)carouselcontroller_paramsForProfilePosition, (Object)item_.getCarouselcontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)clampxminuscontroller_paramsForCurrent, (Object)item_.getClampxminuscontroller_paramsForCurrent());
        Assert.assertEquals((Object)clampxminuscontroller_paramsForHoming, (Object)item_.getClampxminuscontroller_paramsForHoming());
        Assert.assertEquals((Object)clampxminuscontroller_paramsForProfilePosition, (Object)item_.getClampxminuscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)clampxpluscontroller_paramsForCurrent, (Object)item_.getClampxpluscontroller_paramsForCurrent());
        Assert.assertEquals((Object)clampxpluscontroller_paramsForHoming, (Object)item_.getClampxpluscontroller_paramsForHoming());
        Assert.assertEquals((Object)clampxpluscontroller_paramsForProfilePosition, (Object)item_.getClampxpluscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)latchxminuscontroller_paramsForCurrent, (Object)item_.getLatchxminuscontroller_paramsForCurrent());
        Assert.assertEquals((Object)latchxminuscontroller_paramsForHoming, (Object)item_.getLatchxminuscontroller_paramsForHoming());
        Assert.assertEquals((Object)latchxminuscontroller_paramsForProfilePosition, (Object)item_.getLatchxminuscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)latchxpluscontroller_paramsForCurrent, (Object)item_.getLatchxpluscontroller_paramsForCurrent());
        Assert.assertEquals((Object)latchxpluscontroller_paramsForHoming, (Object)item_.getLatchxpluscontroller_paramsForHoming());
        Assert.assertEquals((Object)latchxpluscontroller_paramsForProfilePosition, (Object)item_.getLatchxpluscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)onlineclampxminuscontroller_paramsForCurrent, (Object)item_.getOnlineclampxminuscontroller_paramsForCurrent());
        Assert.assertEquals((Object)onlineclampxminuscontroller_paramsForHoming, (Object)item_.getOnlineclampxminuscontroller_paramsForHoming());
        Assert.assertEquals((Object)onlineclampxminuscontroller_paramsForProfilePosition, (Object)item_.getOnlineclampxminuscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)onlineclampxpluscontroller_paramsForCurrent, (Object)item_.getOnlineclampxpluscontroller_paramsForCurrent());
        Assert.assertEquals((Object)onlineclampxpluscontroller_paramsForHoming, (Object)item_.getOnlineclampxpluscontroller_paramsForHoming());
        Assert.assertEquals((Object)onlineclampxpluscontroller_paramsForProfilePosition, (Object)item_.getOnlineclampxpluscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)onlineclampyminuscontroller_paramsForCurrent, (Object)item_.getOnlineclampyminuscontroller_paramsForCurrent());
        Assert.assertEquals((Object)onlineclampyminuscontroller_paramsForHoming, (Object)item_.getOnlineclampyminuscontroller_paramsForHoming());
        Assert.assertEquals((Object)onlineclampyminuscontroller_paramsForProfilePosition, (Object)item_.getOnlineclampyminuscontroller_paramsForProfilePosition());
    }

    @Test
    public void sendReceiveFcs_Canbus0_nodeIDConfigurationEvent() throws Exception {
        String version = "";
        int acsensorsgateway_nodeID = 97;
        int actruckxminuscontroller_nodeID = 357;
        int actruckxpluscontroller_nodeID = 330;
        int accelerobf_nodeID = 464;
        int ai814_nodeID = 590;
        int brakesystemgateway_nodeID = 403;
        int carouselcontroller_nodeID = 331;
        int clampxminuscontroller_nodeID = 97;
        int clampxpluscontroller_nodeID = 341;
        int hyttc580_nodeID = 233;
        int latchxminuscontroller_nodeID = 65;
        int latchxpluscontroller_nodeID = 649;
        int onlineclampxminuscontroller_nodeID = 346;
        int onlineclampxpluscontroller_nodeID = 384;
        int onlineclampyminuscontroller_nodeID = 280;
        int onlinestraingauge_nodeID = 246;
        int proximitysensorsdevice_nodeID = 361;
        int pt100_nodeID = 901;
        int tempsensorsdevice1_nodeID = 34;
        int tempsensorsdevice2_nodeID = 571;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus0_nodeIDConfigurationEvent(version, acsensorsgateway_nodeID, actruckxminuscontroller_nodeID, actruckxpluscontroller_nodeID, accelerobf_nodeID, ai814_nodeID, brakesystemgateway_nodeID, carouselcontroller_nodeID, clampxminuscontroller_nodeID, clampxpluscontroller_nodeID, hyttc580_nodeID, latchxminuscontroller_nodeID, latchxpluscontroller_nodeID, onlineclampxminuscontroller_nodeID, onlineclampxpluscontroller_nodeID, onlineclampyminuscontroller_nodeID, onlinestraingauge_nodeID, proximitysensorsdevice_nodeID, pt100_nodeID, tempsensorsdevice1_nodeID, tempsensorsdevice2_nodeID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_nodeIDConfigurationEvent));
        Fcs_Canbus0_nodeIDConfigurationEvent item_ = (Fcs_Canbus0_nodeIDConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)acsensorsgateway_nodeID, (long)item_.getAcsensorsgateway_nodeID());
        Assert.assertEquals((long)actruckxminuscontroller_nodeID, (long)item_.getActruckxminuscontroller_nodeID());
        Assert.assertEquals((long)actruckxpluscontroller_nodeID, (long)item_.getActruckxpluscontroller_nodeID());
        Assert.assertEquals((long)accelerobf_nodeID, (long)item_.getAccelerobf_nodeID());
        Assert.assertEquals((long)ai814_nodeID, (long)item_.getAi814_nodeID());
        Assert.assertEquals((long)brakesystemgateway_nodeID, (long)item_.getBrakesystemgateway_nodeID());
        Assert.assertEquals((long)carouselcontroller_nodeID, (long)item_.getCarouselcontroller_nodeID());
        Assert.assertEquals((long)clampxminuscontroller_nodeID, (long)item_.getClampxminuscontroller_nodeID());
        Assert.assertEquals((long)clampxpluscontroller_nodeID, (long)item_.getClampxpluscontroller_nodeID());
        Assert.assertEquals((long)hyttc580_nodeID, (long)item_.getHyttc580_nodeID());
        Assert.assertEquals((long)latchxminuscontroller_nodeID, (long)item_.getLatchxminuscontroller_nodeID());
        Assert.assertEquals((long)latchxpluscontroller_nodeID, (long)item_.getLatchxpluscontroller_nodeID());
        Assert.assertEquals((long)onlineclampxminuscontroller_nodeID, (long)item_.getOnlineclampxminuscontroller_nodeID());
        Assert.assertEquals((long)onlineclampxpluscontroller_nodeID, (long)item_.getOnlineclampxpluscontroller_nodeID());
        Assert.assertEquals((long)onlineclampyminuscontroller_nodeID, (long)item_.getOnlineclampyminuscontroller_nodeID());
        Assert.assertEquals((long)onlinestraingauge_nodeID, (long)item_.getOnlinestraingauge_nodeID());
        Assert.assertEquals((long)proximitysensorsdevice_nodeID, (long)item_.getProximitysensorsdevice_nodeID());
        Assert.assertEquals((long)pt100_nodeID, (long)item_.getPt100_nodeID());
        Assert.assertEquals((long)tempsensorsdevice1_nodeID, (long)item_.getTempsensorsdevice1_nodeID());
        Assert.assertEquals((long)tempsensorsdevice2_nodeID, (long)item_.getTempsensorsdevice2_nodeID());
    }

    @Test
    public void sendReceiveFcs_Canbus0_sensorConfigurationEvent() throws Exception {
        String version = "";
        int ai814_transmissionType = 143;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus0_sensorConfigurationEvent(version, ai814_transmissionType));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_sensorConfigurationEvent));
        Fcs_Canbus0_sensorConfigurationEvent item_ = (Fcs_Canbus0_sensorConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)ai814_transmissionType, (long)item_.getAi814_transmissionType());
    }

    @Test
    public void sendReceiveFcs_Canbus0_serialNBConfigurationEvent() throws Exception {
        String version = "";
        String acsensorsgateway_serialNB = "t";
        String actruckxminuscontroller_serialNB = "";
        String actruckxpluscontroller_serialNB = "";
        String accelerobf_serialNB = "u";
        String ai814_serialNB = "h";
        String brakesystemgateway_serialNB = "";
        String carouselcontroller_serialNB = "k";
        String clampxminuscontroller_serialNB = "";
        String clampxpluscontroller_serialNB = "";
        String hyttc580_serialNB = "d";
        String latchxminuscontroller_serialNB = "";
        String latchxpluscontroller_serialNB = "z";
        String onlineclampxminuscontroller_serialNB = "";
        String onlineclampxpluscontroller_serialNB = "n";
        String onlineclampyminuscontroller_serialNB = "";
        String onlinestraingauge_serialNB = "c";
        String proximitysensorsdevice_serialNB = "";
        String pt100_serialNB = "x";
        String tempsensorsdevice1_serialNB = "";
        String tempsensorsdevice2_serialNB = "";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus0_serialNBConfigurationEvent(version, acsensorsgateway_serialNB, actruckxminuscontroller_serialNB, actruckxpluscontroller_serialNB, accelerobf_serialNB, ai814_serialNB, brakesystemgateway_serialNB, carouselcontroller_serialNB, clampxminuscontroller_serialNB, clampxpluscontroller_serialNB, hyttc580_serialNB, latchxminuscontroller_serialNB, latchxpluscontroller_serialNB, onlineclampxminuscontroller_serialNB, onlineclampxpluscontroller_serialNB, onlineclampyminuscontroller_serialNB, onlinestraingauge_serialNB, proximitysensorsdevice_serialNB, pt100_serialNB, tempsensorsdevice1_serialNB, tempsensorsdevice2_serialNB));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_serialNBConfigurationEvent));
        Fcs_Canbus0_serialNBConfigurationEvent item_ = (Fcs_Canbus0_serialNBConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)acsensorsgateway_serialNB, (Object)item_.getAcsensorsgateway_serialNB());
        Assert.assertEquals((Object)actruckxminuscontroller_serialNB, (Object)item_.getActruckxminuscontroller_serialNB());
        Assert.assertEquals((Object)actruckxpluscontroller_serialNB, (Object)item_.getActruckxpluscontroller_serialNB());
        Assert.assertEquals((Object)accelerobf_serialNB, (Object)item_.getAccelerobf_serialNB());
        Assert.assertEquals((Object)ai814_serialNB, (Object)item_.getAi814_serialNB());
        Assert.assertEquals((Object)brakesystemgateway_serialNB, (Object)item_.getBrakesystemgateway_serialNB());
        Assert.assertEquals((Object)carouselcontroller_serialNB, (Object)item_.getCarouselcontroller_serialNB());
        Assert.assertEquals((Object)clampxminuscontroller_serialNB, (Object)item_.getClampxminuscontroller_serialNB());
        Assert.assertEquals((Object)clampxpluscontroller_serialNB, (Object)item_.getClampxpluscontroller_serialNB());
        Assert.assertEquals((Object)hyttc580_serialNB, (Object)item_.getHyttc580_serialNB());
        Assert.assertEquals((Object)latchxminuscontroller_serialNB, (Object)item_.getLatchxminuscontroller_serialNB());
        Assert.assertEquals((Object)latchxpluscontroller_serialNB, (Object)item_.getLatchxpluscontroller_serialNB());
        Assert.assertEquals((Object)onlineclampxminuscontroller_serialNB, (Object)item_.getOnlineclampxminuscontroller_serialNB());
        Assert.assertEquals((Object)onlineclampxpluscontroller_serialNB, (Object)item_.getOnlineclampxpluscontroller_serialNB());
        Assert.assertEquals((Object)onlineclampyminuscontroller_serialNB, (Object)item_.getOnlineclampyminuscontroller_serialNB());
        Assert.assertEquals((Object)onlinestraingauge_serialNB, (Object)item_.getOnlinestraingauge_serialNB());
        Assert.assertEquals((Object)proximitysensorsdevice_serialNB, (Object)item_.getProximitysensorsdevice_serialNB());
        Assert.assertEquals((Object)pt100_serialNB, (Object)item_.getPt100_serialNB());
        Assert.assertEquals((Object)tempsensorsdevice1_serialNB, (Object)item_.getTempsensorsdevice1_serialNB());
        Assert.assertEquals((Object)tempsensorsdevice2_serialNB, (Object)item_.getTempsensorsdevice2_serialNB());
    }

    @Test
    public void sendReceiveFcs_Canbus1_canbusConfigurationEvent() throws Exception {
        String version = "c";
        String baud = "m";
        String busName = "";
        long hardwareBootTimeout = 758L;
        int masterNodeID = 385;
        boolean pdoRecoveryActive = false;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus1_canbusConfigurationEvent(version, baud, busName, hardwareBootTimeout, masterNodeID, pdoRecoveryActive));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_canbusConfigurationEvent));
        Fcs_Canbus1_canbusConfigurationEvent item_ = (Fcs_Canbus1_canbusConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)baud, (Object)item_.getBaud());
        Assert.assertEquals((Object)busName, (Object)item_.getBusName());
        Assert.assertEquals((long)hardwareBootTimeout, (long)item_.getHardwareBootTimeout());
        Assert.assertEquals((long)masterNodeID, (long)item_.getMasterNodeID());
        Assert.assertEquals((Object)pdoRecoveryActive, (Object)item_.isPdoRecoveryActive());
    }

    @Test
    public void sendReceiveFcs_Canbus1_controllerConfigurationEvent() throws Exception {
        String version = "a";
        String carriercontroller_paramsForCurrent = "";
        String carriercontroller_paramsForHoming = "d";
        String carriercontroller_paramsForProfilePosition = "m";
        String hookscontroller_paramsForCurrent = "c";
        String hookscontroller_paramsForHoming = "";
        String hookscontroller_paramsForProfilePosition = "";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus1_controllerConfigurationEvent(version, carriercontroller_paramsForCurrent, carriercontroller_paramsForHoming, carriercontroller_paramsForProfilePosition, hookscontroller_paramsForCurrent, hookscontroller_paramsForHoming, hookscontroller_paramsForProfilePosition));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_controllerConfigurationEvent));
        Fcs_Canbus1_controllerConfigurationEvent item_ = (Fcs_Canbus1_controllerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)carriercontroller_paramsForCurrent, (Object)item_.getCarriercontroller_paramsForCurrent());
        Assert.assertEquals((Object)carriercontroller_paramsForHoming, (Object)item_.getCarriercontroller_paramsForHoming());
        Assert.assertEquals((Object)carriercontroller_paramsForProfilePosition, (Object)item_.getCarriercontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)hookscontroller_paramsForCurrent, (Object)item_.getHookscontroller_paramsForCurrent());
        Assert.assertEquals((Object)hookscontroller_paramsForHoming, (Object)item_.getHookscontroller_paramsForHoming());
        Assert.assertEquals((Object)hookscontroller_paramsForProfilePosition, (Object)item_.getHookscontroller_paramsForProfilePosition());
    }

    @Test
    public void sendReceiveFcs_Canbus1_nodeIDConfigurationEvent() throws Exception {
        String version = "s";
        int carriercontroller_nodeID = 15;
        int hookscontroller_nodeID = 658;
        int loaderplutogateway_nodeID = 254;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus1_nodeIDConfigurationEvent(version, carriercontroller_nodeID, hookscontroller_nodeID, loaderplutogateway_nodeID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_nodeIDConfigurationEvent));
        Fcs_Canbus1_nodeIDConfigurationEvent item_ = (Fcs_Canbus1_nodeIDConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)carriercontroller_nodeID, (long)item_.getCarriercontroller_nodeID());
        Assert.assertEquals((long)hookscontroller_nodeID, (long)item_.getHookscontroller_nodeID());
        Assert.assertEquals((long)loaderplutogateway_nodeID, (long)item_.getLoaderplutogateway_nodeID());
    }

    @Test
    public void sendReceiveFcs_Canbus1_serialNBConfigurationEvent() throws Exception {
        String version = "";
        String carriercontroller_serialNB = "";
        String hookscontroller_serialNB = "";
        String loaderplutogateway_serialNB = "y";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus1_serialNBConfigurationEvent(version, carriercontroller_serialNB, hookscontroller_serialNB, loaderplutogateway_serialNB));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_serialNBConfigurationEvent));
        Fcs_Canbus1_serialNBConfigurationEvent item_ = (Fcs_Canbus1_serialNBConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)carriercontroller_serialNB, (Object)item_.getCarriercontroller_serialNB());
        Assert.assertEquals((Object)hookscontroller_serialNB, (Object)item_.getHookscontroller_serialNB());
        Assert.assertEquals((Object)loaderplutogateway_serialNB, (Object)item_.getLoaderplutogateway_serialNB());
    }

    @Test
    public void sendReceiveFcs_Carousel_carouselConfigurationEvent() throws Exception {
        String version = "";
        int brake1Limit = 277;
        int brake2Limit = 805;
        int brake3Limit = 236;
        int currentToPrepareUnlock = 777;
        int fastAcceleration = 145;
        int fastDeceleration = 693;
        int fastRotationTimeout = 452;
        int fastVelocity = 213;
        int filterPresenceMinNoFilter = 787;
        int lockSensorMaxLimitXminus = 785;
        int lockSensorMaxLimitXplus = 129;
        int lockSensorMinLimitXminus = 725;
        int lockSensorMinLimitXplus = 158;
        int maxClampsOffsetDelta = 422;
        int maxStandbyDeltaPosition = 267;
        boolean powerSaveAllowed = true;
        int recoveryBackwardStep = 955;
        int recoveryForwardStep = 124;
        int recoveryLockingCurrent = 722;
        int recoveryMaxVelocity = 931;
        int recoveryStandbyDeltaPosition = 998;
        int slowAcceleration = 912;
        int slowDeceleration = 350;
        int slowRotationTimeout = 50;
        int slowVelocity = 196;
        int socket1_clampXminus1_currentToUnlock = 483;
        int socket1_clampXminus1_filterPresenceMaxValue = 315;
        int socket1_clampXminus1_filterPresenceOffset3 = 113;
        long socket1_clampXminus1_timeoutForReleasing = 976L;
        long socket1_clampXminus1_timeoutForUnlocking = 911L;
        int socket1_clampXplus1_currentToUnlock = 892;
        int socket1_clampXplus1_filterPresenceMaxValue = 722;
        int socket1_clampXplus1_filterPresenceOffset3 = 561;
        long socket1_clampXplus1_timeoutForReleasing = 897L;
        long socket1_clampXplus1_timeoutForUnlocking = 170L;
        int socket1_deltaAutochangerStandbyPosition = 70;
        int socket1_standbyPosition = 8;
        int socket2_clampXminus2_currentToUnlock = 906;
        int socket2_clampXminus2_filterPresenceMaxValue = 778;
        int socket2_clampXminus2_filterPresenceOffset3 = 365;
        long socket2_clampXminus2_timeoutForReleasing = 11L;
        long socket2_clampXminus2_timeoutForUnlocking = 167L;
        int socket2_clampXplus2_currentToUnlock = 81;
        int socket2_clampXplus2_filterPresenceMaxValue = 700;
        int socket2_clampXplus2_filterPresenceOffset3 = 26;
        long socket2_clampXplus2_timeoutForReleasing = 889L;
        long socket2_clampXplus2_timeoutForUnlocking = 572L;
        int socket2_deltaAutochangerStandbyPosition = 549;
        int socket2_standbyPosition = 715;
        int socket3_clampXminus3_currentToUnlock = 631;
        int socket3_clampXminus3_filterPresenceMaxValue = 416;
        int socket3_clampXminus3_filterPresenceOffset3 = 504;
        long socket3_clampXminus3_timeoutForReleasing = 558L;
        long socket3_clampXminus3_timeoutForUnlocking = 887L;
        int socket3_clampXplus3_currentToUnlock = 930;
        int socket3_clampXplus3_filterPresenceMaxValue = 216;
        int socket3_clampXplus3_filterPresenceOffset3 = 959;
        long socket3_clampXplus3_timeoutForReleasing = 83L;
        long socket3_clampXplus3_timeoutForUnlocking = 981L;
        int socket3_deltaAutochangerStandbyPosition = 240;
        int socket3_standbyPosition = 803;
        int socket4_clampXminus4_currentToUnlock = 128;
        int socket4_clampXminus4_filterPresenceMaxValue = 734;
        int socket4_clampXminus4_filterPresenceOffset3 = 379;
        long socket4_clampXminus4_timeoutForReleasing = 720L;
        long socket4_clampXminus4_timeoutForUnlocking = 138L;
        int socket4_clampXplus4_currentToUnlock = 765;
        int socket4_clampXplus4_filterPresenceMaxValue = 283;
        int socket4_clampXplus4_filterPresenceOffset3 = 886;
        long socket4_clampXplus4_timeoutForReleasing = 468L;
        long socket4_clampXplus4_timeoutForUnlocking = 938L;
        int socket4_deltaAutochangerStandbyPosition = 962;
        int socket4_standbyPosition = 636;
        int socket5_clampXminus5_currentToUnlock = 156;
        int socket5_clampXminus5_filterPresenceMaxValue = 418;
        int socket5_clampXminus5_filterPresenceOffset3 = 948;
        long socket5_clampXminus5_timeoutForReleasing = 809L;
        long socket5_clampXminus5_timeoutForUnlocking = 770L;
        int socket5_clampXplus5_currentToUnlock = 45;
        int socket5_clampXplus5_filterPresenceMaxValue = 974;
        int socket5_clampXplus5_filterPresenceOffset3 = 632;
        long socket5_clampXplus5_timeoutForReleasing = 776L;
        long socket5_clampXplus5_timeoutForUnlocking = 188L;
        int socket5_deltaAutochangerStandbyPosition = 847;
        int socket5_standbyPosition = 895;
        int timeToPrepareUnlock = 837;
        long timeToUpdateProtectionSystem = 36L;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Carousel_carouselConfigurationEvent(version, brake1Limit, brake2Limit, brake3Limit, currentToPrepareUnlock, fastAcceleration, fastDeceleration, fastRotationTimeout, fastVelocity, filterPresenceMinNoFilter, lockSensorMaxLimitXminus, lockSensorMaxLimitXplus, lockSensorMinLimitXminus, lockSensorMinLimitXplus, maxClampsOffsetDelta, maxStandbyDeltaPosition, powerSaveAllowed, recoveryBackwardStep, recoveryForwardStep, recoveryLockingCurrent, recoveryMaxVelocity, recoveryStandbyDeltaPosition, slowAcceleration, slowDeceleration, slowRotationTimeout, slowVelocity, socket1_clampXminus1_currentToUnlock, socket1_clampXminus1_filterPresenceMaxValue, socket1_clampXminus1_filterPresenceOffset3, socket1_clampXminus1_timeoutForReleasing, socket1_clampXminus1_timeoutForUnlocking, socket1_clampXplus1_currentToUnlock, socket1_clampXplus1_filterPresenceMaxValue, socket1_clampXplus1_filterPresenceOffset3, socket1_clampXplus1_timeoutForReleasing, socket1_clampXplus1_timeoutForUnlocking, socket1_deltaAutochangerStandbyPosition, socket1_standbyPosition, socket2_clampXminus2_currentToUnlock, socket2_clampXminus2_filterPresenceMaxValue, socket2_clampXminus2_filterPresenceOffset3, socket2_clampXminus2_timeoutForReleasing, socket2_clampXminus2_timeoutForUnlocking, socket2_clampXplus2_currentToUnlock, socket2_clampXplus2_filterPresenceMaxValue, socket2_clampXplus2_filterPresenceOffset3, socket2_clampXplus2_timeoutForReleasing, socket2_clampXplus2_timeoutForUnlocking, socket2_deltaAutochangerStandbyPosition, socket2_standbyPosition, socket3_clampXminus3_currentToUnlock, socket3_clampXminus3_filterPresenceMaxValue, socket3_clampXminus3_filterPresenceOffset3, socket3_clampXminus3_timeoutForReleasing, socket3_clampXminus3_timeoutForUnlocking, socket3_clampXplus3_currentToUnlock, socket3_clampXplus3_filterPresenceMaxValue, socket3_clampXplus3_filterPresenceOffset3, socket3_clampXplus3_timeoutForReleasing, socket3_clampXplus3_timeoutForUnlocking, socket3_deltaAutochangerStandbyPosition, socket3_standbyPosition, socket4_clampXminus4_currentToUnlock, socket4_clampXminus4_filterPresenceMaxValue, socket4_clampXminus4_filterPresenceOffset3, socket4_clampXminus4_timeoutForReleasing, socket4_clampXminus4_timeoutForUnlocking, socket4_clampXplus4_currentToUnlock, socket4_clampXplus4_filterPresenceMaxValue, socket4_clampXplus4_filterPresenceOffset3, socket4_clampXplus4_timeoutForReleasing, socket4_clampXplus4_timeoutForUnlocking, socket4_deltaAutochangerStandbyPosition, socket4_standbyPosition, socket5_clampXminus5_currentToUnlock, socket5_clampXminus5_filterPresenceMaxValue, socket5_clampXminus5_filterPresenceOffset3, socket5_clampXminus5_timeoutForReleasing, socket5_clampXminus5_timeoutForUnlocking, socket5_clampXplus5_currentToUnlock, socket5_clampXplus5_filterPresenceMaxValue, socket5_clampXplus5_filterPresenceOffset3, socket5_clampXplus5_timeoutForReleasing, socket5_clampXplus5_timeoutForUnlocking, socket5_deltaAutochangerStandbyPosition, socket5_standbyPosition, timeToPrepareUnlock, timeToUpdateProtectionSystem));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_carouselConfigurationEvent));
        Fcs_Carousel_carouselConfigurationEvent item_ = (Fcs_Carousel_carouselConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)brake1Limit, (long)item_.getBrake1Limit());
        Assert.assertEquals((long)brake2Limit, (long)item_.getBrake2Limit());
        Assert.assertEquals((long)brake3Limit, (long)item_.getBrake3Limit());
        Assert.assertEquals((long)currentToPrepareUnlock, (long)item_.getCurrentToPrepareUnlock());
        Assert.assertEquals((long)fastAcceleration, (long)item_.getFastAcceleration());
        Assert.assertEquals((long)fastDeceleration, (long)item_.getFastDeceleration());
        Assert.assertEquals((long)fastRotationTimeout, (long)item_.getFastRotationTimeout());
        Assert.assertEquals((long)fastVelocity, (long)item_.getFastVelocity());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)lockSensorMaxLimitXminus, (long)item_.getLockSensorMaxLimitXminus());
        Assert.assertEquals((long)lockSensorMaxLimitXplus, (long)item_.getLockSensorMaxLimitXplus());
        Assert.assertEquals((long)lockSensorMinLimitXminus, (long)item_.getLockSensorMinLimitXminus());
        Assert.assertEquals((long)lockSensorMinLimitXplus, (long)item_.getLockSensorMinLimitXplus());
        Assert.assertEquals((long)maxClampsOffsetDelta, (long)item_.getMaxClampsOffsetDelta());
        Assert.assertEquals((long)maxStandbyDeltaPosition, (long)item_.getMaxStandbyDeltaPosition());
        Assert.assertEquals((Object)powerSaveAllowed, (Object)item_.isPowerSaveAllowed());
        Assert.assertEquals((long)recoveryBackwardStep, (long)item_.getRecoveryBackwardStep());
        Assert.assertEquals((long)recoveryForwardStep, (long)item_.getRecoveryForwardStep());
        Assert.assertEquals((long)recoveryLockingCurrent, (long)item_.getRecoveryLockingCurrent());
        Assert.assertEquals((long)recoveryMaxVelocity, (long)item_.getRecoveryMaxVelocity());
        Assert.assertEquals((long)recoveryStandbyDeltaPosition, (long)item_.getRecoveryStandbyDeltaPosition());
        Assert.assertEquals((long)slowAcceleration, (long)item_.getSlowAcceleration());
        Assert.assertEquals((long)slowDeceleration, (long)item_.getSlowDeceleration());
        Assert.assertEquals((long)slowRotationTimeout, (long)item_.getSlowRotationTimeout());
        Assert.assertEquals((long)slowVelocity, (long)item_.getSlowVelocity());
        Assert.assertEquals((long)socket1_clampXminus1_currentToUnlock, (long)item_.getSocket1_clampXminus1_currentToUnlock());
        Assert.assertEquals((long)socket1_clampXminus1_filterPresenceMaxValue, (long)item_.getSocket1_clampXminus1_filterPresenceMaxValue());
        Assert.assertEquals((long)socket1_clampXminus1_filterPresenceOffset3, (long)item_.getSocket1_clampXminus1_filterPresenceOffset3());
        Assert.assertEquals((long)socket1_clampXminus1_timeoutForReleasing, (long)item_.getSocket1_clampXminus1_timeoutForReleasing());
        Assert.assertEquals((long)socket1_clampXminus1_timeoutForUnlocking, (long)item_.getSocket1_clampXminus1_timeoutForUnlocking());
        Assert.assertEquals((long)socket1_clampXplus1_currentToUnlock, (long)item_.getSocket1_clampXplus1_currentToUnlock());
        Assert.assertEquals((long)socket1_clampXplus1_filterPresenceMaxValue, (long)item_.getSocket1_clampXplus1_filterPresenceMaxValue());
        Assert.assertEquals((long)socket1_clampXplus1_filterPresenceOffset3, (long)item_.getSocket1_clampXplus1_filterPresenceOffset3());
        Assert.assertEquals((long)socket1_clampXplus1_timeoutForReleasing, (long)item_.getSocket1_clampXplus1_timeoutForReleasing());
        Assert.assertEquals((long)socket1_clampXplus1_timeoutForUnlocking, (long)item_.getSocket1_clampXplus1_timeoutForUnlocking());
        Assert.assertEquals((long)socket1_deltaAutochangerStandbyPosition, (long)item_.getSocket1_deltaAutochangerStandbyPosition());
        Assert.assertEquals((long)socket1_standbyPosition, (long)item_.getSocket1_standbyPosition());
        Assert.assertEquals((long)socket2_clampXminus2_currentToUnlock, (long)item_.getSocket2_clampXminus2_currentToUnlock());
        Assert.assertEquals((long)socket2_clampXminus2_filterPresenceMaxValue, (long)item_.getSocket2_clampXminus2_filterPresenceMaxValue());
        Assert.assertEquals((long)socket2_clampXminus2_filterPresenceOffset3, (long)item_.getSocket2_clampXminus2_filterPresenceOffset3());
        Assert.assertEquals((long)socket2_clampXminus2_timeoutForReleasing, (long)item_.getSocket2_clampXminus2_timeoutForReleasing());
        Assert.assertEquals((long)socket2_clampXminus2_timeoutForUnlocking, (long)item_.getSocket2_clampXminus2_timeoutForUnlocking());
        Assert.assertEquals((long)socket2_clampXplus2_currentToUnlock, (long)item_.getSocket2_clampXplus2_currentToUnlock());
        Assert.assertEquals((long)socket2_clampXplus2_filterPresenceMaxValue, (long)item_.getSocket2_clampXplus2_filterPresenceMaxValue());
        Assert.assertEquals((long)socket2_clampXplus2_filterPresenceOffset3, (long)item_.getSocket2_clampXplus2_filterPresenceOffset3());
        Assert.assertEquals((long)socket2_clampXplus2_timeoutForReleasing, (long)item_.getSocket2_clampXplus2_timeoutForReleasing());
        Assert.assertEquals((long)socket2_clampXplus2_timeoutForUnlocking, (long)item_.getSocket2_clampXplus2_timeoutForUnlocking());
        Assert.assertEquals((long)socket2_deltaAutochangerStandbyPosition, (long)item_.getSocket2_deltaAutochangerStandbyPosition());
        Assert.assertEquals((long)socket2_standbyPosition, (long)item_.getSocket2_standbyPosition());
        Assert.assertEquals((long)socket3_clampXminus3_currentToUnlock, (long)item_.getSocket3_clampXminus3_currentToUnlock());
        Assert.assertEquals((long)socket3_clampXminus3_filterPresenceMaxValue, (long)item_.getSocket3_clampXminus3_filterPresenceMaxValue());
        Assert.assertEquals((long)socket3_clampXminus3_filterPresenceOffset3, (long)item_.getSocket3_clampXminus3_filterPresenceOffset3());
        Assert.assertEquals((long)socket3_clampXminus3_timeoutForReleasing, (long)item_.getSocket3_clampXminus3_timeoutForReleasing());
        Assert.assertEquals((long)socket3_clampXminus3_timeoutForUnlocking, (long)item_.getSocket3_clampXminus3_timeoutForUnlocking());
        Assert.assertEquals((long)socket3_clampXplus3_currentToUnlock, (long)item_.getSocket3_clampXplus3_currentToUnlock());
        Assert.assertEquals((long)socket3_clampXplus3_filterPresenceMaxValue, (long)item_.getSocket3_clampXplus3_filterPresenceMaxValue());
        Assert.assertEquals((long)socket3_clampXplus3_filterPresenceOffset3, (long)item_.getSocket3_clampXplus3_filterPresenceOffset3());
        Assert.assertEquals((long)socket3_clampXplus3_timeoutForReleasing, (long)item_.getSocket3_clampXplus3_timeoutForReleasing());
        Assert.assertEquals((long)socket3_clampXplus3_timeoutForUnlocking, (long)item_.getSocket3_clampXplus3_timeoutForUnlocking());
        Assert.assertEquals((long)socket3_deltaAutochangerStandbyPosition, (long)item_.getSocket3_deltaAutochangerStandbyPosition());
        Assert.assertEquals((long)socket3_standbyPosition, (long)item_.getSocket3_standbyPosition());
        Assert.assertEquals((long)socket4_clampXminus4_currentToUnlock, (long)item_.getSocket4_clampXminus4_currentToUnlock());
        Assert.assertEquals((long)socket4_clampXminus4_filterPresenceMaxValue, (long)item_.getSocket4_clampXminus4_filterPresenceMaxValue());
        Assert.assertEquals((long)socket4_clampXminus4_filterPresenceOffset3, (long)item_.getSocket4_clampXminus4_filterPresenceOffset3());
        Assert.assertEquals((long)socket4_clampXminus4_timeoutForReleasing, (long)item_.getSocket4_clampXminus4_timeoutForReleasing());
        Assert.assertEquals((long)socket4_clampXminus4_timeoutForUnlocking, (long)item_.getSocket4_clampXminus4_timeoutForUnlocking());
        Assert.assertEquals((long)socket4_clampXplus4_currentToUnlock, (long)item_.getSocket4_clampXplus4_currentToUnlock());
        Assert.assertEquals((long)socket4_clampXplus4_filterPresenceMaxValue, (long)item_.getSocket4_clampXplus4_filterPresenceMaxValue());
        Assert.assertEquals((long)socket4_clampXplus4_filterPresenceOffset3, (long)item_.getSocket4_clampXplus4_filterPresenceOffset3());
        Assert.assertEquals((long)socket4_clampXplus4_timeoutForReleasing, (long)item_.getSocket4_clampXplus4_timeoutForReleasing());
        Assert.assertEquals((long)socket4_clampXplus4_timeoutForUnlocking, (long)item_.getSocket4_clampXplus4_timeoutForUnlocking());
        Assert.assertEquals((long)socket4_deltaAutochangerStandbyPosition, (long)item_.getSocket4_deltaAutochangerStandbyPosition());
        Assert.assertEquals((long)socket4_standbyPosition, (long)item_.getSocket4_standbyPosition());
        Assert.assertEquals((long)socket5_clampXminus5_currentToUnlock, (long)item_.getSocket5_clampXminus5_currentToUnlock());
        Assert.assertEquals((long)socket5_clampXminus5_filterPresenceMaxValue, (long)item_.getSocket5_clampXminus5_filterPresenceMaxValue());
        Assert.assertEquals((long)socket5_clampXminus5_filterPresenceOffset3, (long)item_.getSocket5_clampXminus5_filterPresenceOffset3());
        Assert.assertEquals((long)socket5_clampXminus5_timeoutForReleasing, (long)item_.getSocket5_clampXminus5_timeoutForReleasing());
        Assert.assertEquals((long)socket5_clampXminus5_timeoutForUnlocking, (long)item_.getSocket5_clampXminus5_timeoutForUnlocking());
        Assert.assertEquals((long)socket5_clampXplus5_currentToUnlock, (long)item_.getSocket5_clampXplus5_currentToUnlock());
        Assert.assertEquals((long)socket5_clampXplus5_filterPresenceMaxValue, (long)item_.getSocket5_clampXplus5_filterPresenceMaxValue());
        Assert.assertEquals((long)socket5_clampXplus5_filterPresenceOffset3, (long)item_.getSocket5_clampXplus5_filterPresenceOffset3());
        Assert.assertEquals((long)socket5_clampXplus5_timeoutForReleasing, (long)item_.getSocket5_clampXplus5_timeoutForReleasing());
        Assert.assertEquals((long)socket5_clampXplus5_timeoutForUnlocking, (long)item_.getSocket5_clampXplus5_timeoutForUnlocking());
        Assert.assertEquals((long)socket5_deltaAutochangerStandbyPosition, (long)item_.getSocket5_deltaAutochangerStandbyPosition());
        Assert.assertEquals((long)socket5_standbyPosition, (long)item_.getSocket5_standbyPosition());
        Assert.assertEquals((long)timeToPrepareUnlock, (long)item_.getTimeToPrepareUnlock());
        Assert.assertEquals((long)timeToUpdateProtectionSystem, (long)item_.getTimeToUpdateProtectionSystem());
    }

    @Test
    public void sendReceiveFcs_Carousel_readRateConfigurationEvent() throws Exception {
        String version = "o";
        int readSensorsRate = 68;
        int socket1_clampXminus1_readSensorsRate = 610;
        int socket1_clampXplus1_readSensorsRate = 42;
        int socket2_clampXminus2_readSensorsRate = 963;
        int socket2_clampXplus2_readSensorsRate = 906;
        int socket3_clampXminus3_readSensorsRate = 906;
        int socket3_clampXplus3_readSensorsRate = 204;
        int socket4_clampXminus4_readSensorsRate = 377;
        int socket4_clampXplus4_readSensorsRate = 125;
        int socket5_clampXminus5_readSensorsRate = 40;
        int socket5_clampXplus5_readSensorsRate = 237;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Carousel_readRateConfigurationEvent(version, readSensorsRate, socket1_clampXminus1_readSensorsRate, socket1_clampXplus1_readSensorsRate, socket2_clampXminus2_readSensorsRate, socket2_clampXplus2_readSensorsRate, socket3_clampXminus3_readSensorsRate, socket3_clampXplus3_readSensorsRate, socket4_clampXminus4_readSensorsRate, socket4_clampXplus4_readSensorsRate, socket5_clampXminus5_readSensorsRate, socket5_clampXplus5_readSensorsRate));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_readRateConfigurationEvent));
        Fcs_Carousel_readRateConfigurationEvent item_ = (Fcs_Carousel_readRateConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)readSensorsRate, (long)item_.getReadSensorsRate());
        Assert.assertEquals((long)socket1_clampXminus1_readSensorsRate, (long)item_.getSocket1_clampXminus1_readSensorsRate());
        Assert.assertEquals((long)socket1_clampXplus1_readSensorsRate, (long)item_.getSocket1_clampXplus1_readSensorsRate());
        Assert.assertEquals((long)socket2_clampXminus2_readSensorsRate, (long)item_.getSocket2_clampXminus2_readSensorsRate());
        Assert.assertEquals((long)socket2_clampXplus2_readSensorsRate, (long)item_.getSocket2_clampXplus2_readSensorsRate());
        Assert.assertEquals((long)socket3_clampXminus3_readSensorsRate, (long)item_.getSocket3_clampXminus3_readSensorsRate());
        Assert.assertEquals((long)socket3_clampXplus3_readSensorsRate, (long)item_.getSocket3_clampXplus3_readSensorsRate());
        Assert.assertEquals((long)socket4_clampXminus4_readSensorsRate, (long)item_.getSocket4_clampXminus4_readSensorsRate());
        Assert.assertEquals((long)socket4_clampXplus4_readSensorsRate, (long)item_.getSocket4_clampXplus4_readSensorsRate());
        Assert.assertEquals((long)socket5_clampXminus5_readSensorsRate, (long)item_.getSocket5_clampXminus5_readSensorsRate());
        Assert.assertEquals((long)socket5_clampXplus5_readSensorsRate, (long)item_.getSocket5_clampXplus5_readSensorsRate());
    }

    @Test
    public void sendReceiveFcs_Carousel_sensorConfigurationEvent() throws Exception {
        String version = "";
        int plc_caAF3_bitNumero = 87;
        int plc_caAF3_byteNumero = 698;
        String plc_caAF3_deviceName = "b";
        int plc_caAF3b_bitNumero = 226;
        int plc_caAF3b_byteNumero = 384;
        String plc_caAF3b_deviceName = "";
        int plc_caAP1_bitNumero = 344;
        int plc_caAP1_byteNumero = 789;
        String plc_caAP1_deviceName = "u";
        int plc_caAP1b_bitNumero = 592;
        int plc_caAP1b_byteNumero = 509;
        String plc_caAP1b_deviceName = "h";
        int plc_caAP2_bitNumero = 396;
        int plc_caAP2_byteNumero = 959;
        String plc_caAP2_deviceName = "";
        int plc_caAP2b_bitNumero = 788;
        int plc_caAP2b_byteNumero = 672;
        String plc_caAP2b_deviceName = "";
        int plc_caAP3_bitNumero = 279;
        int plc_caAP3_byteNumero = 524;
        String plc_caAP3_deviceName = "g";
        int plc_caAP3b_bitNumero = 52;
        int plc_caAP3b_byteNumero = 993;
        String plc_caAP3b_deviceName = "";
        int plc_caBrakesActivated_bitNumero = 628;
        int plc_caBrakesActivated_byteNumero = 744;
        String plc_caBrakesActivated_deviceName = "";
        int plc_caCF0_bitNumero = 581;
        int plc_caCF0_byteNumero = 160;
        String plc_caCF0_deviceName = "";
        int plc_caCF0b_bitNumero = 10;
        int plc_caCF0b_byteNumero = 994;
        String plc_caCF0b_deviceName = "a";
        int plc_caCF1_bitNumero = 601;
        int plc_caCF1_byteNumero = 979;
        String plc_caCF1_deviceName = "s";
        int plc_caCF1b_bitNumero = 408;
        int plc_caCF1b_byteNumero = 974;
        String plc_caCF1b_deviceName = "";
        int plc_caCFC_bitNumero = 561;
        int plc_caCFC_byteNumero = 572;
        String plc_caCFC_deviceName = "s";
        int plc_caCFCb_bitNumero = 790;
        int plc_caCFCb_byteNumero = 466;
        String plc_caCFCb_deviceName = "m";
        int plc_caCS_bitNumero = 999;
        int plc_caCS_byteNumero = 753;
        String plc_caCS_deviceName = "l";
        int plc_caCSb_bitNumero = 176;
        int plc_caCSb_byteNumero = 774;
        String plc_caCSb_deviceName = "";
        int plc_caEnableBrakes_bitNumero = 965;
        int plc_caEnableBrakes_byteNumero = 920;
        String plc_caEnableBrakes_deviceName = "";
        int plc_caEnableRotation_bitNumero = 951;
        int plc_caEnableRotation_byteNumero = 91;
        String plc_caEnableRotation_deviceName = "t";
        int plc_caEnableShutter_bitNumero = 791;
        int plc_caEnableShutter_byteNumero = 221;
        String plc_caEnableShutter_deviceName = "";
        int plc_caEnableUnclamp_bitNumero = 149;
        int plc_caEnableUnclamp_byteNumero = 557;
        String plc_caEnableUnclamp_deviceName = "";
        int plc_caEng_bitNumero = 22;
        int plc_caEng_byteNumero = 850;
        String plc_caEng_deviceName = "x";
        int plc_caEngb_bitNumero = 616;
        int plc_caEngb_byteNumero = 330;
        String plc_caEngb_deviceName = "";
        int plc_caLockout_bitNumero = 853;
        int plc_caLockout_byteNumero = 727;
        String plc_caLockout_deviceName = "w";
        int plc_caLockoutb_bitNumero = 871;
        int plc_caLockoutb_byteNumero = 638;
        String plc_caLockoutb_deviceName = "";
        int plc_caShutterInactive_bitNumero = 920;
        int plc_caShutterInactive_byteNumero = 83;
        String plc_caShutterInactive_deviceName = "m";
        int plc_caSleep_bitNumero = 738;
        int plc_caSleep_byteNumero = 18;
        String plc_caSleep_deviceName = "";
        int plc_enableShutterInterlock_bitNumero = 644;
        int plc_enableShutterInterlock_byteNumero = 943;
        String plc_enableShutterInterlock_deviceName = "";
        int plc_okDI_bitNumero = 306;
        int plc_okDI_byteNumero = 45;
        String plc_okDI_deviceName = "";
        int plc_okDIsafety_bitNumero = 337;
        int plc_okDIsafety_byteNumero = 452;
        String plc_okDIsafety_deviceName = "";
        int plc_powerSave_bitNumero = 211;
        int plc_powerSave_byteNumero = 591;
        String plc_powerSave_deviceName = "q";
        int plc_tpCheckRotation_bitNumero = 548;
        int plc_tpCheckRotation_byteNumero = 748;
        String plc_tpCheckRotation_deviceName = "h";
        int plc_tpStopRotation_bitNumero = 183;
        int plc_tpStopRotation_byteNumero = 850;
        String plc_tpStopRotation_deviceName = "";
        int plc_tpStopUnclamp_bitNumero = 595;
        int plc_tpStopUnclamp_byteNumero = 560;
        String plc_tpStopUnclamp_deviceName = "d";
        String socket1_clampXminus1_filterPresenceXminus1_deviceName = "p";
        String socket1_clampXminus1_lockSensorXminus1_deviceName = "";
        String socket1_clampXplus1_filterPresenceXplus1_deviceName = "u";
        String socket1_clampXplus1_lockSensorXplus1_deviceName = "x";
        String socket1_ioModuleSensor1_deviceName = "";
        String socket2_clampXminus2_filterPresenceXminus2_deviceName = "y";
        String socket2_clampXminus2_lockSensorXminus2_deviceName = "e";
        String socket2_clampXplus2_filterPresenceXplus2_deviceName = "";
        String socket2_clampXplus2_lockSensorXplus2_deviceName = "t";
        String socket2_ioModuleSensor2_deviceName = "e";
        String socket3_clampXminus3_filterPresenceXminus3_deviceName = "";
        String socket3_clampXminus3_lockSensorXminus3_deviceName = "";
        String socket3_clampXplus3_filterPresenceXplus3_deviceName = "";
        String socket3_clampXplus3_lockSensorXplus3_deviceName = "";
        String socket3_ioModuleSensor3_deviceName = "";
        String socket4_clampXminus4_filterPresenceXminus4_deviceName = "h";
        String socket4_clampXminus4_lockSensorXminus4_deviceName = "";
        String socket4_clampXplus4_filterPresenceXplus4_deviceName = "";
        String socket4_clampXplus4_lockSensorXplus4_deviceName = "";
        String socket4_ioModuleSensor4_deviceName = "";
        String socket5_clampXminus5_filterPresenceXminus5_deviceName = "";
        String socket5_clampXminus5_lockSensorXminus5_deviceName = "v";
        String socket5_clampXplus5_filterPresenceXplus5_deviceName = "p";
        String socket5_clampXplus5_lockSensorXplus5_deviceName = "";
        String socket5_ioModuleSensor5_deviceName = "";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Carousel_sensorConfigurationEvent(version, plc_caAF3_bitNumero, plc_caAF3_byteNumero, plc_caAF3_deviceName, plc_caAF3b_bitNumero, plc_caAF3b_byteNumero, plc_caAF3b_deviceName, plc_caAP1_bitNumero, plc_caAP1_byteNumero, plc_caAP1_deviceName, plc_caAP1b_bitNumero, plc_caAP1b_byteNumero, plc_caAP1b_deviceName, plc_caAP2_bitNumero, plc_caAP2_byteNumero, plc_caAP2_deviceName, plc_caAP2b_bitNumero, plc_caAP2b_byteNumero, plc_caAP2b_deviceName, plc_caAP3_bitNumero, plc_caAP3_byteNumero, plc_caAP3_deviceName, plc_caAP3b_bitNumero, plc_caAP3b_byteNumero, plc_caAP3b_deviceName, plc_caBrakesActivated_bitNumero, plc_caBrakesActivated_byteNumero, plc_caBrakesActivated_deviceName, plc_caCF0_bitNumero, plc_caCF0_byteNumero, plc_caCF0_deviceName, plc_caCF0b_bitNumero, plc_caCF0b_byteNumero, plc_caCF0b_deviceName, plc_caCF1_bitNumero, plc_caCF1_byteNumero, plc_caCF1_deviceName, plc_caCF1b_bitNumero, plc_caCF1b_byteNumero, plc_caCF1b_deviceName, plc_caCFC_bitNumero, plc_caCFC_byteNumero, plc_caCFC_deviceName, plc_caCFCb_bitNumero, plc_caCFCb_byteNumero, plc_caCFCb_deviceName, plc_caCS_bitNumero, plc_caCS_byteNumero, plc_caCS_deviceName, plc_caCSb_bitNumero, plc_caCSb_byteNumero, plc_caCSb_deviceName, plc_caEnableBrakes_bitNumero, plc_caEnableBrakes_byteNumero, plc_caEnableBrakes_deviceName, plc_caEnableRotation_bitNumero, plc_caEnableRotation_byteNumero, plc_caEnableRotation_deviceName, plc_caEnableShutter_bitNumero, plc_caEnableShutter_byteNumero, plc_caEnableShutter_deviceName, plc_caEnableUnclamp_bitNumero, plc_caEnableUnclamp_byteNumero, plc_caEnableUnclamp_deviceName, plc_caEng_bitNumero, plc_caEng_byteNumero, plc_caEng_deviceName, plc_caEngb_bitNumero, plc_caEngb_byteNumero, plc_caEngb_deviceName, plc_caLockout_bitNumero, plc_caLockout_byteNumero, plc_caLockout_deviceName, plc_caLockoutb_bitNumero, plc_caLockoutb_byteNumero, plc_caLockoutb_deviceName, plc_caShutterInactive_bitNumero, plc_caShutterInactive_byteNumero, plc_caShutterInactive_deviceName, plc_caSleep_bitNumero, plc_caSleep_byteNumero, plc_caSleep_deviceName, plc_enableShutterInterlock_bitNumero, plc_enableShutterInterlock_byteNumero, plc_enableShutterInterlock_deviceName, plc_okDI_bitNumero, plc_okDI_byteNumero, plc_okDI_deviceName, plc_okDIsafety_bitNumero, plc_okDIsafety_byteNumero, plc_okDIsafety_deviceName, plc_powerSave_bitNumero, plc_powerSave_byteNumero, plc_powerSave_deviceName, plc_tpCheckRotation_bitNumero, plc_tpCheckRotation_byteNumero, plc_tpCheckRotation_deviceName, plc_tpStopRotation_bitNumero, plc_tpStopRotation_byteNumero, plc_tpStopRotation_deviceName, plc_tpStopUnclamp_bitNumero, plc_tpStopUnclamp_byteNumero, plc_tpStopUnclamp_deviceName, socket1_clampXminus1_filterPresenceXminus1_deviceName, socket1_clampXminus1_lockSensorXminus1_deviceName, socket1_clampXplus1_filterPresenceXplus1_deviceName, socket1_clampXplus1_lockSensorXplus1_deviceName, socket1_ioModuleSensor1_deviceName, socket2_clampXminus2_filterPresenceXminus2_deviceName, socket2_clampXminus2_lockSensorXminus2_deviceName, socket2_clampXplus2_filterPresenceXplus2_deviceName, socket2_clampXplus2_lockSensorXplus2_deviceName, socket2_ioModuleSensor2_deviceName, socket3_clampXminus3_filterPresenceXminus3_deviceName, socket3_clampXminus3_lockSensorXminus3_deviceName, socket3_clampXplus3_filterPresenceXplus3_deviceName, socket3_clampXplus3_lockSensorXplus3_deviceName, socket3_ioModuleSensor3_deviceName, socket4_clampXminus4_filterPresenceXminus4_deviceName, socket4_clampXminus4_lockSensorXminus4_deviceName, socket4_clampXplus4_filterPresenceXplus4_deviceName, socket4_clampXplus4_lockSensorXplus4_deviceName, socket4_ioModuleSensor4_deviceName, socket5_clampXminus5_filterPresenceXminus5_deviceName, socket5_clampXminus5_lockSensorXminus5_deviceName, socket5_clampXplus5_filterPresenceXplus5_deviceName, socket5_clampXplus5_lockSensorXplus5_deviceName, socket5_ioModuleSensor5_deviceName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_sensorConfigurationEvent));
        Fcs_Carousel_sensorConfigurationEvent item_ = (Fcs_Carousel_sensorConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)plc_caAF3_bitNumero, (long)item_.getPlc_caAF3_bitNumero());
        Assert.assertEquals((long)plc_caAF3_byteNumero, (long)item_.getPlc_caAF3_byteNumero());
        Assert.assertEquals((Object)plc_caAF3_deviceName, (Object)item_.getPlc_caAF3_deviceName());
        Assert.assertEquals((long)plc_caAF3b_bitNumero, (long)item_.getPlc_caAF3b_bitNumero());
        Assert.assertEquals((long)plc_caAF3b_byteNumero, (long)item_.getPlc_caAF3b_byteNumero());
        Assert.assertEquals((Object)plc_caAF3b_deviceName, (Object)item_.getPlc_caAF3b_deviceName());
        Assert.assertEquals((long)plc_caAP1_bitNumero, (long)item_.getPlc_caAP1_bitNumero());
        Assert.assertEquals((long)plc_caAP1_byteNumero, (long)item_.getPlc_caAP1_byteNumero());
        Assert.assertEquals((Object)plc_caAP1_deviceName, (Object)item_.getPlc_caAP1_deviceName());
        Assert.assertEquals((long)plc_caAP1b_bitNumero, (long)item_.getPlc_caAP1b_bitNumero());
        Assert.assertEquals((long)plc_caAP1b_byteNumero, (long)item_.getPlc_caAP1b_byteNumero());
        Assert.assertEquals((Object)plc_caAP1b_deviceName, (Object)item_.getPlc_caAP1b_deviceName());
        Assert.assertEquals((long)plc_caAP2_bitNumero, (long)item_.getPlc_caAP2_bitNumero());
        Assert.assertEquals((long)plc_caAP2_byteNumero, (long)item_.getPlc_caAP2_byteNumero());
        Assert.assertEquals((Object)plc_caAP2_deviceName, (Object)item_.getPlc_caAP2_deviceName());
        Assert.assertEquals((long)plc_caAP2b_bitNumero, (long)item_.getPlc_caAP2b_bitNumero());
        Assert.assertEquals((long)plc_caAP2b_byteNumero, (long)item_.getPlc_caAP2b_byteNumero());
        Assert.assertEquals((Object)plc_caAP2b_deviceName, (Object)item_.getPlc_caAP2b_deviceName());
        Assert.assertEquals((long)plc_caAP3_bitNumero, (long)item_.getPlc_caAP3_bitNumero());
        Assert.assertEquals((long)plc_caAP3_byteNumero, (long)item_.getPlc_caAP3_byteNumero());
        Assert.assertEquals((Object)plc_caAP3_deviceName, (Object)item_.getPlc_caAP3_deviceName());
        Assert.assertEquals((long)plc_caAP3b_bitNumero, (long)item_.getPlc_caAP3b_bitNumero());
        Assert.assertEquals((long)plc_caAP3b_byteNumero, (long)item_.getPlc_caAP3b_byteNumero());
        Assert.assertEquals((Object)plc_caAP3b_deviceName, (Object)item_.getPlc_caAP3b_deviceName());
        Assert.assertEquals((long)plc_caBrakesActivated_bitNumero, (long)item_.getPlc_caBrakesActivated_bitNumero());
        Assert.assertEquals((long)plc_caBrakesActivated_byteNumero, (long)item_.getPlc_caBrakesActivated_byteNumero());
        Assert.assertEquals((Object)plc_caBrakesActivated_deviceName, (Object)item_.getPlc_caBrakesActivated_deviceName());
        Assert.assertEquals((long)plc_caCF0_bitNumero, (long)item_.getPlc_caCF0_bitNumero());
        Assert.assertEquals((long)plc_caCF0_byteNumero, (long)item_.getPlc_caCF0_byteNumero());
        Assert.assertEquals((Object)plc_caCF0_deviceName, (Object)item_.getPlc_caCF0_deviceName());
        Assert.assertEquals((long)plc_caCF0b_bitNumero, (long)item_.getPlc_caCF0b_bitNumero());
        Assert.assertEquals((long)plc_caCF0b_byteNumero, (long)item_.getPlc_caCF0b_byteNumero());
        Assert.assertEquals((Object)plc_caCF0b_deviceName, (Object)item_.getPlc_caCF0b_deviceName());
        Assert.assertEquals((long)plc_caCF1_bitNumero, (long)item_.getPlc_caCF1_bitNumero());
        Assert.assertEquals((long)plc_caCF1_byteNumero, (long)item_.getPlc_caCF1_byteNumero());
        Assert.assertEquals((Object)plc_caCF1_deviceName, (Object)item_.getPlc_caCF1_deviceName());
        Assert.assertEquals((long)plc_caCF1b_bitNumero, (long)item_.getPlc_caCF1b_bitNumero());
        Assert.assertEquals((long)plc_caCF1b_byteNumero, (long)item_.getPlc_caCF1b_byteNumero());
        Assert.assertEquals((Object)plc_caCF1b_deviceName, (Object)item_.getPlc_caCF1b_deviceName());
        Assert.assertEquals((long)plc_caCFC_bitNumero, (long)item_.getPlc_caCFC_bitNumero());
        Assert.assertEquals((long)plc_caCFC_byteNumero, (long)item_.getPlc_caCFC_byteNumero());
        Assert.assertEquals((Object)plc_caCFC_deviceName, (Object)item_.getPlc_caCFC_deviceName());
        Assert.assertEquals((long)plc_caCFCb_bitNumero, (long)item_.getPlc_caCFCb_bitNumero());
        Assert.assertEquals((long)plc_caCFCb_byteNumero, (long)item_.getPlc_caCFCb_byteNumero());
        Assert.assertEquals((Object)plc_caCFCb_deviceName, (Object)item_.getPlc_caCFCb_deviceName());
        Assert.assertEquals((long)plc_caCS_bitNumero, (long)item_.getPlc_caCS_bitNumero());
        Assert.assertEquals((long)plc_caCS_byteNumero, (long)item_.getPlc_caCS_byteNumero());
        Assert.assertEquals((Object)plc_caCS_deviceName, (Object)item_.getPlc_caCS_deviceName());
        Assert.assertEquals((long)plc_caCSb_bitNumero, (long)item_.getPlc_caCSb_bitNumero());
        Assert.assertEquals((long)plc_caCSb_byteNumero, (long)item_.getPlc_caCSb_byteNumero());
        Assert.assertEquals((Object)plc_caCSb_deviceName, (Object)item_.getPlc_caCSb_deviceName());
        Assert.assertEquals((long)plc_caEnableBrakes_bitNumero, (long)item_.getPlc_caEnableBrakes_bitNumero());
        Assert.assertEquals((long)plc_caEnableBrakes_byteNumero, (long)item_.getPlc_caEnableBrakes_byteNumero());
        Assert.assertEquals((Object)plc_caEnableBrakes_deviceName, (Object)item_.getPlc_caEnableBrakes_deviceName());
        Assert.assertEquals((long)plc_caEnableRotation_bitNumero, (long)item_.getPlc_caEnableRotation_bitNumero());
        Assert.assertEquals((long)plc_caEnableRotation_byteNumero, (long)item_.getPlc_caEnableRotation_byteNumero());
        Assert.assertEquals((Object)plc_caEnableRotation_deviceName, (Object)item_.getPlc_caEnableRotation_deviceName());
        Assert.assertEquals((long)plc_caEnableShutter_bitNumero, (long)item_.getPlc_caEnableShutter_bitNumero());
        Assert.assertEquals((long)plc_caEnableShutter_byteNumero, (long)item_.getPlc_caEnableShutter_byteNumero());
        Assert.assertEquals((Object)plc_caEnableShutter_deviceName, (Object)item_.getPlc_caEnableShutter_deviceName());
        Assert.assertEquals((long)plc_caEnableUnclamp_bitNumero, (long)item_.getPlc_caEnableUnclamp_bitNumero());
        Assert.assertEquals((long)plc_caEnableUnclamp_byteNumero, (long)item_.getPlc_caEnableUnclamp_byteNumero());
        Assert.assertEquals((Object)plc_caEnableUnclamp_deviceName, (Object)item_.getPlc_caEnableUnclamp_deviceName());
        Assert.assertEquals((long)plc_caEng_bitNumero, (long)item_.getPlc_caEng_bitNumero());
        Assert.assertEquals((long)plc_caEng_byteNumero, (long)item_.getPlc_caEng_byteNumero());
        Assert.assertEquals((Object)plc_caEng_deviceName, (Object)item_.getPlc_caEng_deviceName());
        Assert.assertEquals((long)plc_caEngb_bitNumero, (long)item_.getPlc_caEngb_bitNumero());
        Assert.assertEquals((long)plc_caEngb_byteNumero, (long)item_.getPlc_caEngb_byteNumero());
        Assert.assertEquals((Object)plc_caEngb_deviceName, (Object)item_.getPlc_caEngb_deviceName());
        Assert.assertEquals((long)plc_caLockout_bitNumero, (long)item_.getPlc_caLockout_bitNumero());
        Assert.assertEquals((long)plc_caLockout_byteNumero, (long)item_.getPlc_caLockout_byteNumero());
        Assert.assertEquals((Object)plc_caLockout_deviceName, (Object)item_.getPlc_caLockout_deviceName());
        Assert.assertEquals((long)plc_caLockoutb_bitNumero, (long)item_.getPlc_caLockoutb_bitNumero());
        Assert.assertEquals((long)plc_caLockoutb_byteNumero, (long)item_.getPlc_caLockoutb_byteNumero());
        Assert.assertEquals((Object)plc_caLockoutb_deviceName, (Object)item_.getPlc_caLockoutb_deviceName());
        Assert.assertEquals((long)plc_caShutterInactive_bitNumero, (long)item_.getPlc_caShutterInactive_bitNumero());
        Assert.assertEquals((long)plc_caShutterInactive_byteNumero, (long)item_.getPlc_caShutterInactive_byteNumero());
        Assert.assertEquals((Object)plc_caShutterInactive_deviceName, (Object)item_.getPlc_caShutterInactive_deviceName());
        Assert.assertEquals((long)plc_caSleep_bitNumero, (long)item_.getPlc_caSleep_bitNumero());
        Assert.assertEquals((long)plc_caSleep_byteNumero, (long)item_.getPlc_caSleep_byteNumero());
        Assert.assertEquals((Object)plc_caSleep_deviceName, (Object)item_.getPlc_caSleep_deviceName());
        Assert.assertEquals((long)plc_enableShutterInterlock_bitNumero, (long)item_.getPlc_enableShutterInterlock_bitNumero());
        Assert.assertEquals((long)plc_enableShutterInterlock_byteNumero, (long)item_.getPlc_enableShutterInterlock_byteNumero());
        Assert.assertEquals((Object)plc_enableShutterInterlock_deviceName, (Object)item_.getPlc_enableShutterInterlock_deviceName());
        Assert.assertEquals((long)plc_okDI_bitNumero, (long)item_.getPlc_okDI_bitNumero());
        Assert.assertEquals((long)plc_okDI_byteNumero, (long)item_.getPlc_okDI_byteNumero());
        Assert.assertEquals((Object)plc_okDI_deviceName, (Object)item_.getPlc_okDI_deviceName());
        Assert.assertEquals((long)plc_okDIsafety_bitNumero, (long)item_.getPlc_okDIsafety_bitNumero());
        Assert.assertEquals((long)plc_okDIsafety_byteNumero, (long)item_.getPlc_okDIsafety_byteNumero());
        Assert.assertEquals((Object)plc_okDIsafety_deviceName, (Object)item_.getPlc_okDIsafety_deviceName());
        Assert.assertEquals((long)plc_powerSave_bitNumero, (long)item_.getPlc_powerSave_bitNumero());
        Assert.assertEquals((long)plc_powerSave_byteNumero, (long)item_.getPlc_powerSave_byteNumero());
        Assert.assertEquals((Object)plc_powerSave_deviceName, (Object)item_.getPlc_powerSave_deviceName());
        Assert.assertEquals((long)plc_tpCheckRotation_bitNumero, (long)item_.getPlc_tpCheckRotation_bitNumero());
        Assert.assertEquals((long)plc_tpCheckRotation_byteNumero, (long)item_.getPlc_tpCheckRotation_byteNumero());
        Assert.assertEquals((Object)plc_tpCheckRotation_deviceName, (Object)item_.getPlc_tpCheckRotation_deviceName());
        Assert.assertEquals((long)plc_tpStopRotation_bitNumero, (long)item_.getPlc_tpStopRotation_bitNumero());
        Assert.assertEquals((long)plc_tpStopRotation_byteNumero, (long)item_.getPlc_tpStopRotation_byteNumero());
        Assert.assertEquals((Object)plc_tpStopRotation_deviceName, (Object)item_.getPlc_tpStopRotation_deviceName());
        Assert.assertEquals((long)plc_tpStopUnclamp_bitNumero, (long)item_.getPlc_tpStopUnclamp_bitNumero());
        Assert.assertEquals((long)plc_tpStopUnclamp_byteNumero, (long)item_.getPlc_tpStopUnclamp_byteNumero());
        Assert.assertEquals((Object)plc_tpStopUnclamp_deviceName, (Object)item_.getPlc_tpStopUnclamp_deviceName());
        Assert.assertEquals((Object)socket1_clampXminus1_filterPresenceXminus1_deviceName, (Object)item_.getSocket1_clampXminus1_filterPresenceXminus1_deviceName());
        Assert.assertEquals((Object)socket1_clampXminus1_lockSensorXminus1_deviceName, (Object)item_.getSocket1_clampXminus1_lockSensorXminus1_deviceName());
        Assert.assertEquals((Object)socket1_clampXplus1_filterPresenceXplus1_deviceName, (Object)item_.getSocket1_clampXplus1_filterPresenceXplus1_deviceName());
        Assert.assertEquals((Object)socket1_clampXplus1_lockSensorXplus1_deviceName, (Object)item_.getSocket1_clampXplus1_lockSensorXplus1_deviceName());
        Assert.assertEquals((Object)socket1_ioModuleSensor1_deviceName, (Object)item_.getSocket1_ioModuleSensor1_deviceName());
        Assert.assertEquals((Object)socket2_clampXminus2_filterPresenceXminus2_deviceName, (Object)item_.getSocket2_clampXminus2_filterPresenceXminus2_deviceName());
        Assert.assertEquals((Object)socket2_clampXminus2_lockSensorXminus2_deviceName, (Object)item_.getSocket2_clampXminus2_lockSensorXminus2_deviceName());
        Assert.assertEquals((Object)socket2_clampXplus2_filterPresenceXplus2_deviceName, (Object)item_.getSocket2_clampXplus2_filterPresenceXplus2_deviceName());
        Assert.assertEquals((Object)socket2_clampXplus2_lockSensorXplus2_deviceName, (Object)item_.getSocket2_clampXplus2_lockSensorXplus2_deviceName());
        Assert.assertEquals((Object)socket2_ioModuleSensor2_deviceName, (Object)item_.getSocket2_ioModuleSensor2_deviceName());
        Assert.assertEquals((Object)socket3_clampXminus3_filterPresenceXminus3_deviceName, (Object)item_.getSocket3_clampXminus3_filterPresenceXminus3_deviceName());
        Assert.assertEquals((Object)socket3_clampXminus3_lockSensorXminus3_deviceName, (Object)item_.getSocket3_clampXminus3_lockSensorXminus3_deviceName());
        Assert.assertEquals((Object)socket3_clampXplus3_filterPresenceXplus3_deviceName, (Object)item_.getSocket3_clampXplus3_filterPresenceXplus3_deviceName());
        Assert.assertEquals((Object)socket3_clampXplus3_lockSensorXplus3_deviceName, (Object)item_.getSocket3_clampXplus3_lockSensorXplus3_deviceName());
        Assert.assertEquals((Object)socket3_ioModuleSensor3_deviceName, (Object)item_.getSocket3_ioModuleSensor3_deviceName());
        Assert.assertEquals((Object)socket4_clampXminus4_filterPresenceXminus4_deviceName, (Object)item_.getSocket4_clampXminus4_filterPresenceXminus4_deviceName());
        Assert.assertEquals((Object)socket4_clampXminus4_lockSensorXminus4_deviceName, (Object)item_.getSocket4_clampXminus4_lockSensorXminus4_deviceName());
        Assert.assertEquals((Object)socket4_clampXplus4_filterPresenceXplus4_deviceName, (Object)item_.getSocket4_clampXplus4_filterPresenceXplus4_deviceName());
        Assert.assertEquals((Object)socket4_clampXplus4_lockSensorXplus4_deviceName, (Object)item_.getSocket4_clampXplus4_lockSensorXplus4_deviceName());
        Assert.assertEquals((Object)socket4_ioModuleSensor4_deviceName, (Object)item_.getSocket4_ioModuleSensor4_deviceName());
        Assert.assertEquals((Object)socket5_clampXminus5_filterPresenceXminus5_deviceName, (Object)item_.getSocket5_clampXminus5_filterPresenceXminus5_deviceName());
        Assert.assertEquals((Object)socket5_clampXminus5_lockSensorXminus5_deviceName, (Object)item_.getSocket5_clampXminus5_lockSensorXminus5_deviceName());
        Assert.assertEquals((Object)socket5_clampXplus5_filterPresenceXplus5_deviceName, (Object)item_.getSocket5_clampXplus5_filterPresenceXplus5_deviceName());
        Assert.assertEquals((Object)socket5_clampXplus5_lockSensorXplus5_deviceName, (Object)item_.getSocket5_clampXplus5_lockSensorXplus5_deviceName());
        Assert.assertEquals((Object)socket5_ioModuleSensor5_deviceName, (Object)item_.getSocket5_ioModuleSensor5_deviceName());
    }

    @Test
    public void sendReceiveFcs_FilterIdentificator_sensorConfigurationEvent() throws Exception {
        String version = "";
        int filteridsensor0_byteNumero = 762;
        String filteridsensor0_dioName = "";
        int filteridsensor0_inputNumero = 980;
        int filteridsensor1_byteNumero = 74;
        String filteridsensor1_dioName = "";
        int filteridsensor1_inputNumero = 612;
        int filteridsensor2_byteNumero = 956;
        String filteridsensor2_dioName = "";
        int filteridsensor2_inputNumero = 715;
        int filteridsensor3_byteNumero = 100;
        String filteridsensor3_dioName = "b";
        int filteridsensor3_inputNumero = 296;
        int filteridsensor4_byteNumero = 995;
        String filteridsensor4_dioName = "c";
        int filteridsensor4_inputNumero = 387;
        int filteridsensor5_byteNumero = 307;
        String filteridsensor5_dioName = "q";
        int filteridsensor5_inputNumero = 866;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_FilterIdentificator_sensorConfigurationEvent(version, filteridsensor0_byteNumero, filteridsensor0_dioName, filteridsensor0_inputNumero, filteridsensor1_byteNumero, filteridsensor1_dioName, filteridsensor1_inputNumero, filteridsensor2_byteNumero, filteridsensor2_dioName, filteridsensor2_inputNumero, filteridsensor3_byteNumero, filteridsensor3_dioName, filteridsensor3_inputNumero, filteridsensor4_byteNumero, filteridsensor4_dioName, filteridsensor4_inputNumero, filteridsensor5_byteNumero, filteridsensor5_dioName, filteridsensor5_inputNumero));
        Assert.assertTrue((boolean)(item instanceof Fcs_FilterIdentificator_sensorConfigurationEvent));
        Fcs_FilterIdentificator_sensorConfigurationEvent item_ = (Fcs_FilterIdentificator_sensorConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)filteridsensor0_byteNumero, (long)item_.getFilteridsensor0_byteNumero());
        Assert.assertEquals((Object)filteridsensor0_dioName, (Object)item_.getFilteridsensor0_dioName());
        Assert.assertEquals((long)filteridsensor0_inputNumero, (long)item_.getFilteridsensor0_inputNumero());
        Assert.assertEquals((long)filteridsensor1_byteNumero, (long)item_.getFilteridsensor1_byteNumero());
        Assert.assertEquals((Object)filteridsensor1_dioName, (Object)item_.getFilteridsensor1_dioName());
        Assert.assertEquals((long)filteridsensor1_inputNumero, (long)item_.getFilteridsensor1_inputNumero());
        Assert.assertEquals((long)filteridsensor2_byteNumero, (long)item_.getFilteridsensor2_byteNumero());
        Assert.assertEquals((Object)filteridsensor2_dioName, (Object)item_.getFilteridsensor2_dioName());
        Assert.assertEquals((long)filteridsensor2_inputNumero, (long)item_.getFilteridsensor2_inputNumero());
        Assert.assertEquals((long)filteridsensor3_byteNumero, (long)item_.getFilteridsensor3_byteNumero());
        Assert.assertEquals((Object)filteridsensor3_dioName, (Object)item_.getFilteridsensor3_dioName());
        Assert.assertEquals((long)filteridsensor3_inputNumero, (long)item_.getFilteridsensor3_inputNumero());
        Assert.assertEquals((long)filteridsensor4_byteNumero, (long)item_.getFilteridsensor4_byteNumero());
        Assert.assertEquals((Object)filteridsensor4_dioName, (Object)item_.getFilteridsensor4_dioName());
        Assert.assertEquals((long)filteridsensor4_inputNumero, (long)item_.getFilteridsensor4_inputNumero());
        Assert.assertEquals((long)filteridsensor5_byteNumero, (long)item_.getFilteridsensor5_byteNumero());
        Assert.assertEquals((Object)filteridsensor5_dioName, (Object)item_.getFilteridsensor5_dioName());
        Assert.assertEquals((long)filteridsensor5_inputNumero, (long)item_.getFilteridsensor5_inputNumero());
    }

    @Test
    public void sendReceiveFcs_FilterManager_filterConfigurationEvent() throws Exception {
        String version = "";
        String a_family = "";
        int a_filterID = 157;
        double a_weight = 0.5160966515541077;
        String da1_family = "";
        int da1_filterID = 706;
        double da1_weight = 0.6460506916046143;
        String da2_family = "d";
        int da2_filterID = 672;
        double da2_weight = 0.6867908239364624;
        String dr1_family = "l";
        int dr1_filterID = 457;
        double dr1_weight = 0.4088412f;
        String du1_family = "";
        int du1_filterID = 232;
        double du1_weight = 0.4539481997489929;
        String du2_family = "";
        int du2_filterID = 697;
        double du2_weight = 0.9477828145027161;
        String dz1_family = "s";
        int dz1_filterID = 721;
        double dz1_weight = 0.48485177755355835;
        String ef_family = "m";
        int ef_filterID = 804;
        double ef_weight = 0.2756111f;
        String f15_family = "";
        int f15_filterID = 231;
        double f15_weight = 0.28822004795074463;
        String f17_family = "g";
        int f17_filterID = 113;
        double f17_weight = 0.014158666133880615;
        String f29_family = "p";
        int f29_filterID = 974;
        double f29_weight = 0.890504777431488;
        String f34_family = "";
        int f34_filterID = 182;
        double f34_weight = 0.44235873222351074;
        String f3_family = "g";
        int f3_filterID = 859;
        double f3_weight = 0.366751492023468;
        String f46_family = "f";
        int f46_filterID = 563;
        double f46_weight = 0.8885076642036438;
        String f48_family = "t";
        int f48_filterID = 543;
        double f48_weight = 0.19636154174804688;
        String f60_family = "";
        int f60_filterID = 176;
        double f60_weight = 0.6686477661132812;
        String g_family = "h";
        int g_filterID = 762;
        double g_weight = 0.9150266051292419;
        String i_family = "";
        int i_filterID = 994;
        double i_weight = 0.04228156805038452;
        String none_family = "e";
        int none_filterID = 822;
        double none_weight = 0.8637517094612122;
        String oa_family = "s";
        int oa_filterID = 315;
        double oa_weight = 0.8881232738494873;
        String ob_family = "x";
        int ob_filterID = 949;
        double ob_weight = 0.3216143250465393;
        String oc_family = "u";
        int oc_filterID = 285;
        double oc_weight = 0.9373458623886108;
        String ph_family = "";
        int ph_filterID = 736;
        double ph_weight = 0.1699813f;
        String r_family = "";
        int r_filterID = 757;
        double r_weight = 0.2650805711746216;
        String tu_family = "";
        int tu_filterID = 965;
        double tu_weight = 0.3219779133796692;
        String ty_family = "";
        int ty_filterID = 539;
        double ty_weight = 0.3784014f;
        String u_family = "";
        int u_filterID = 249;
        double u_weight = 0.8519304394721985;
        String y_family = "h";
        int y_filterID = 620;
        double y_weight = 0.050605833530426025;
        String z_family = "x";
        int z_filterID = 870;
        double z_weight = 0.998331f;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_FilterManager_filterConfigurationEvent(version, a_family, a_filterID, a_weight, da1_family, da1_filterID, da1_weight, da2_family, da2_filterID, da2_weight, dr1_family, dr1_filterID, dr1_weight, du1_family, du1_filterID, du1_weight, du2_family, du2_filterID, du2_weight, dz1_family, dz1_filterID, dz1_weight, ef_family, ef_filterID, ef_weight, f15_family, f15_filterID, f15_weight, f17_family, f17_filterID, f17_weight, f29_family, f29_filterID, f29_weight, f34_family, f34_filterID, f34_weight, f3_family, f3_filterID, f3_weight, f46_family, f46_filterID, f46_weight, f48_family, f48_filterID, f48_weight, f60_family, f60_filterID, f60_weight, g_family, g_filterID, g_weight, i_family, i_filterID, i_weight, none_family, none_filterID, none_weight, oa_family, oa_filterID, oa_weight, ob_family, ob_filterID, ob_weight, oc_family, oc_filterID, oc_weight, ph_family, ph_filterID, ph_weight, r_family, r_filterID, r_weight, tu_family, tu_filterID, tu_weight, ty_family, ty_filterID, ty_weight, u_family, u_filterID, u_weight, y_family, y_filterID, y_weight, z_family, z_filterID, z_weight));
        Assert.assertTrue((boolean)(item instanceof Fcs_FilterManager_filterConfigurationEvent));
        Fcs_FilterManager_filterConfigurationEvent item_ = (Fcs_FilterManager_filterConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)a_family, (Object)item_.getA_family());
        Assert.assertEquals((long)a_filterID, (long)item_.getA_filterID());
        Assert.assertEquals((double)a_weight, (double)item_.getA_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)da1_family, (Object)item_.getDa1_family());
        Assert.assertEquals((long)da1_filterID, (long)item_.getDa1_filterID());
        Assert.assertEquals((double)da1_weight, (double)item_.getDa1_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)da2_family, (Object)item_.getDa2_family());
        Assert.assertEquals((long)da2_filterID, (long)item_.getDa2_filterID());
        Assert.assertEquals((double)da2_weight, (double)item_.getDa2_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)dr1_family, (Object)item_.getDr1_family());
        Assert.assertEquals((long)dr1_filterID, (long)item_.getDr1_filterID());
        Assert.assertEquals((double)dr1_weight, (double)item_.getDr1_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)du1_family, (Object)item_.getDu1_family());
        Assert.assertEquals((long)du1_filterID, (long)item_.getDu1_filterID());
        Assert.assertEquals((double)du1_weight, (double)item_.getDu1_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)du2_family, (Object)item_.getDu2_family());
        Assert.assertEquals((long)du2_filterID, (long)item_.getDu2_filterID());
        Assert.assertEquals((double)du2_weight, (double)item_.getDu2_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)dz1_family, (Object)item_.getDz1_family());
        Assert.assertEquals((long)dz1_filterID, (long)item_.getDz1_filterID());
        Assert.assertEquals((double)dz1_weight, (double)item_.getDz1_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)ef_family, (Object)item_.getEf_family());
        Assert.assertEquals((long)ef_filterID, (long)item_.getEf_filterID());
        Assert.assertEquals((double)ef_weight, (double)item_.getEf_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f15_family, (Object)item_.getF15_family());
        Assert.assertEquals((long)f15_filterID, (long)item_.getF15_filterID());
        Assert.assertEquals((double)f15_weight, (double)item_.getF15_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f17_family, (Object)item_.getF17_family());
        Assert.assertEquals((long)f17_filterID, (long)item_.getF17_filterID());
        Assert.assertEquals((double)f17_weight, (double)item_.getF17_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f29_family, (Object)item_.getF29_family());
        Assert.assertEquals((long)f29_filterID, (long)item_.getF29_filterID());
        Assert.assertEquals((double)f29_weight, (double)item_.getF29_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f34_family, (Object)item_.getF34_family());
        Assert.assertEquals((long)f34_filterID, (long)item_.getF34_filterID());
        Assert.assertEquals((double)f34_weight, (double)item_.getF34_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f3_family, (Object)item_.getF3_family());
        Assert.assertEquals((long)f3_filterID, (long)item_.getF3_filterID());
        Assert.assertEquals((double)f3_weight, (double)item_.getF3_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f46_family, (Object)item_.getF46_family());
        Assert.assertEquals((long)f46_filterID, (long)item_.getF46_filterID());
        Assert.assertEquals((double)f46_weight, (double)item_.getF46_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f48_family, (Object)item_.getF48_family());
        Assert.assertEquals((long)f48_filterID, (long)item_.getF48_filterID());
        Assert.assertEquals((double)f48_weight, (double)item_.getF48_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f60_family, (Object)item_.getF60_family());
        Assert.assertEquals((long)f60_filterID, (long)item_.getF60_filterID());
        Assert.assertEquals((double)f60_weight, (double)item_.getF60_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)g_family, (Object)item_.getG_family());
        Assert.assertEquals((long)g_filterID, (long)item_.getG_filterID());
        Assert.assertEquals((double)g_weight, (double)item_.getG_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)i_family, (Object)item_.getI_family());
        Assert.assertEquals((long)i_filterID, (long)item_.getI_filterID());
        Assert.assertEquals((double)i_weight, (double)item_.getI_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)none_family, (Object)item_.getNone_family());
        Assert.assertEquals((long)none_filterID, (long)item_.getNone_filterID());
        Assert.assertEquals((double)none_weight, (double)item_.getNone_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)oa_family, (Object)item_.getOa_family());
        Assert.assertEquals((long)oa_filterID, (long)item_.getOa_filterID());
        Assert.assertEquals((double)oa_weight, (double)item_.getOa_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)ob_family, (Object)item_.getOb_family());
        Assert.assertEquals((long)ob_filterID, (long)item_.getOb_filterID());
        Assert.assertEquals((double)ob_weight, (double)item_.getOb_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)oc_family, (Object)item_.getOc_family());
        Assert.assertEquals((long)oc_filterID, (long)item_.getOc_filterID());
        Assert.assertEquals((double)oc_weight, (double)item_.getOc_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)ph_family, (Object)item_.getPh_family());
        Assert.assertEquals((long)ph_filterID, (long)item_.getPh_filterID());
        Assert.assertEquals((double)ph_weight, (double)item_.getPh_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)r_family, (Object)item_.getR_family());
        Assert.assertEquals((long)r_filterID, (long)item_.getR_filterID());
        Assert.assertEquals((double)r_weight, (double)item_.getR_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)tu_family, (Object)item_.getTu_family());
        Assert.assertEquals((long)tu_filterID, (long)item_.getTu_filterID());
        Assert.assertEquals((double)tu_weight, (double)item_.getTu_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)ty_family, (Object)item_.getTy_family());
        Assert.assertEquals((long)ty_filterID, (long)item_.getTy_filterID());
        Assert.assertEquals((double)ty_weight, (double)item_.getTy_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)u_family, (Object)item_.getU_family());
        Assert.assertEquals((long)u_filterID, (long)item_.getU_filterID());
        Assert.assertEquals((double)u_weight, (double)item_.getU_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)y_family, (Object)item_.getY_family());
        Assert.assertEquals((long)y_filterID, (long)item_.getY_filterID());
        Assert.assertEquals((double)y_weight, (double)item_.getY_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)z_family, (Object)item_.getZ_family());
        Assert.assertEquals((long)z_filterID, (long)item_.getZ_filterID());
        Assert.assertEquals((double)z_weight, (double)item_.getZ_weight(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Loader_loaderConfigurationEvent() throws Exception {
        String version = "";
        int carrier_deltaPosition = 526;
        int carrier_engagedPosition = 16;
        int carrier_handoffPosition = 744;
        int carrier_highAcceleration = 781;
        int carrier_highDeceleration = 789;
        int carrier_highSpeed = 523;
        int carrier_lowAcceleration = 713;
        int carrier_lowDeceleration = 429;
        int carrier_lowSpeed = 144;
        int carrier_maxCurrent = 433;
        int carrier_maxSpeed = 313;
        int carrier_storagePosition = 655;
        long carrier_timeoutForGoingToEngaged = 106L;
        long carrier_timeoutForGoingToHandOff = 329L;
        long carrier_timeoutForGoingToStorage = 860L;
        int filterDistanceMin = 517;
        int hooks_absolutePositionToClose = 708;
        int hooks_currentThreshold = 45;
        int hooks_currentToClamp = 666;
        int hooks_currentToOpen = 186;
        int hooks_minClampedVoltage = 833;
        int hooks_relativePositionToUnclamp = 410;
        int hooks_timeoutForClampingHooks = 180;
        int hooks_timeoutForClosingHooks = 111;
        int hooks_timeoutForOpeningHooks = 618;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Loader_loaderConfigurationEvent(version, carrier_deltaPosition, carrier_engagedPosition, carrier_handoffPosition, carrier_highAcceleration, carrier_highDeceleration, carrier_highSpeed, carrier_lowAcceleration, carrier_lowDeceleration, carrier_lowSpeed, carrier_maxCurrent, carrier_maxSpeed, carrier_storagePosition, carrier_timeoutForGoingToEngaged, carrier_timeoutForGoingToHandOff, carrier_timeoutForGoingToStorage, filterDistanceMin, hooks_absolutePositionToClose, hooks_currentThreshold, hooks_currentToClamp, hooks_currentToOpen, hooks_minClampedVoltage, hooks_relativePositionToUnclamp, hooks_timeoutForClampingHooks, hooks_timeoutForClosingHooks, hooks_timeoutForOpeningHooks));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_loaderConfigurationEvent));
        Fcs_Loader_loaderConfigurationEvent item_ = (Fcs_Loader_loaderConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)carrier_deltaPosition, (long)item_.getCarrier_deltaPosition());
        Assert.assertEquals((long)carrier_engagedPosition, (long)item_.getCarrier_engagedPosition());
        Assert.assertEquals((long)carrier_handoffPosition, (long)item_.getCarrier_handoffPosition());
        Assert.assertEquals((long)carrier_highAcceleration, (long)item_.getCarrier_highAcceleration());
        Assert.assertEquals((long)carrier_highDeceleration, (long)item_.getCarrier_highDeceleration());
        Assert.assertEquals((long)carrier_highSpeed, (long)item_.getCarrier_highSpeed());
        Assert.assertEquals((long)carrier_lowAcceleration, (long)item_.getCarrier_lowAcceleration());
        Assert.assertEquals((long)carrier_lowDeceleration, (long)item_.getCarrier_lowDeceleration());
        Assert.assertEquals((long)carrier_lowSpeed, (long)item_.getCarrier_lowSpeed());
        Assert.assertEquals((long)carrier_maxCurrent, (long)item_.getCarrier_maxCurrent());
        Assert.assertEquals((long)carrier_maxSpeed, (long)item_.getCarrier_maxSpeed());
        Assert.assertEquals((long)carrier_storagePosition, (long)item_.getCarrier_storagePosition());
        Assert.assertEquals((long)carrier_timeoutForGoingToEngaged, (long)item_.getCarrier_timeoutForGoingToEngaged());
        Assert.assertEquals((long)carrier_timeoutForGoingToHandOff, (long)item_.getCarrier_timeoutForGoingToHandOff());
        Assert.assertEquals((long)carrier_timeoutForGoingToStorage, (long)item_.getCarrier_timeoutForGoingToStorage());
        Assert.assertEquals((long)filterDistanceMin, (long)item_.getFilterDistanceMin());
        Assert.assertEquals((long)hooks_absolutePositionToClose, (long)item_.getHooks_absolutePositionToClose());
        Assert.assertEquals((long)hooks_currentThreshold, (long)item_.getHooks_currentThreshold());
        Assert.assertEquals((long)hooks_currentToClamp, (long)item_.getHooks_currentToClamp());
        Assert.assertEquals((long)hooks_currentToOpen, (long)item_.getHooks_currentToOpen());
        Assert.assertEquals((long)hooks_minClampedVoltage, (long)item_.getHooks_minClampedVoltage());
        Assert.assertEquals((long)hooks_relativePositionToUnclamp, (long)item_.getHooks_relativePositionToUnclamp());
        Assert.assertEquals((long)hooks_timeoutForClampingHooks, (long)item_.getHooks_timeoutForClampingHooks());
        Assert.assertEquals((long)hooks_timeoutForClosingHooks, (long)item_.getHooks_timeoutForClosingHooks());
        Assert.assertEquals((long)hooks_timeoutForOpeningHooks, (long)item_.getHooks_timeoutForOpeningHooks());
    }

    @Test
    public void sendReceiveFcs_Loader_readRateConfigurationEvent() throws Exception {
        String version = "c";
        int carrier_readSensorsRate = 733;
        int hooks_readSensorsRate = 438;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Loader_readRateConfigurationEvent(version, carrier_readSensorsRate, hooks_readSensorsRate));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_readRateConfigurationEvent));
        Fcs_Loader_readRateConfigurationEvent item_ = (Fcs_Loader_readRateConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)carrier_readSensorsRate, (long)item_.getCarrier_readSensorsRate());
        Assert.assertEquals((long)hooks_readSensorsRate, (long)item_.getHooks_readSensorsRate());
    }

    @Test
    public void sendReceiveFcs_Loader_sensorConfigurationEvent() throws Exception {
        String version = "u";
        int carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_byteNumero = 954;
        String carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_dioName = "";
        int carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_inputNumero = 307;
        int carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_byteNumero = 874;
        String carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_dioName = "";
        int carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_inputNumero = 838;
        int carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_byteNumero = 918;
        String carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_dioName = "t";
        int carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_inputNumero = 751;
        int carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_byteNumero = 138;
        String carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_dioName = "";
        int carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_inputNumero = 605;
        int carrier_loaderStorageSensors_loaderStoragePositionSensor0_byteNumero = 473;
        String carrier_loaderStorageSensors_loaderStoragePositionSensor0_dioName = "";
        int carrier_loaderStorageSensors_loaderStoragePositionSensor0_inputNumero = 51;
        int carrier_loaderStorageSensors_loaderStoragePositionSensor1_byteNumero = 452;
        String carrier_loaderStorageSensors_loaderStoragePositionSensor1_dioName = "";
        int carrier_loaderStorageSensors_loaderStoragePositionSensor1_inputNumero = 605;
        int hooks_clampedStatusSensor_byteNumero = 978;
        String hooks_clampedStatusSensor_dioName = "";
        int hooks_clampedStatusSensor_inputNumero = 344;
        int hooks_forceSensor0_byteNumero = 732;
        String hooks_forceSensor0_deviceName = "n";
        int hooks_forceSensor1_byteNumero = 988;
        String hooks_forceSensor1_deviceName = "p";
        int hooks_hook1_loaderCloseSensor1_byteNumero = 957;
        String hooks_hook1_loaderCloseSensor1_dioName = "e";
        int hooks_hook1_loaderCloseSensor1_inputNumero = 700;
        int hooks_hook1_loaderOpenSensor1_byteNumero = 89;
        String hooks_hook1_loaderOpenSensor1_dioName = "";
        int hooks_hook1_loaderOpenSensor1_inputNumero = 756;
        int hooks_hook2_loaderCloseSensor2_byteNumero = 1;
        String hooks_hook2_loaderCloseSensor2_dioName = "";
        int hooks_hook2_loaderCloseSensor2_inputNumero = 972;
        int hooks_hook2_loaderOpenSensor2_byteNumero = 518;
        String hooks_hook2_loaderOpenSensor2_dioName = "d";
        int hooks_hook2_loaderOpenSensor2_inputNumero = 428;
        int hooks_hook3_loaderCloseSensor3_byteNumero = 102;
        String hooks_hook3_loaderCloseSensor3_dioName = "";
        int hooks_hook3_loaderCloseSensor3_inputNumero = 420;
        int hooks_hook3_loaderOpenSensor3_byteNumero = 613;
        String hooks_hook3_loaderOpenSensor3_dioName = "q";
        int hooks_hook3_loaderOpenSensor3_inputNumero = 392;
        int hooks_hook4_loaderCloseSensor4_byteNumero = 804;
        String hooks_hook4_loaderCloseSensor4_dioName = "w";
        int hooks_hook4_loaderCloseSensor4_inputNumero = 963;
        int hooks_hook4_loaderOpenSensor4_byteNumero = 302;
        String hooks_hook4_loaderOpenSensor4_dioName = "h";
        int hooks_hook4_loaderOpenSensor4_inputNumero = 424;
        int hooks_overClampedStatusSensor_byteNumero = 188;
        String hooks_overClampedStatusSensor_dioName = "r";
        int hooks_overClampedStatusSensor_inputNumero = 40;
        int hooks_unclampedStatusSensor_byteNumero = 144;
        String hooks_unclampedStatusSensor_dioName = "u";
        int hooks_unclampedStatusSensor_inputNumero = 990;
        int hooks_underClampedStatusSensor_byteNumero = 257;
        String hooks_underClampedStatusSensor_dioName = "h";
        int hooks_underClampedStatusSensor_inputNumero = 982;
        int plc_Loader_LPS_LPS_0_byteNumero = 282;
        String plc_Loader_LPS_LPS_0_dioName = "a";
        int plc_Loader_LPS_LPS_0_inputNumero = 929;
        int plc_Loader_LPS_LPS_1_byteNumero = 306;
        String plc_Loader_LPS_LPS_1_dioName = "";
        int plc_Loader_LPS_LPS_1_inputNumero = 519;
        int plc_Loader_LRH_LRH_0_byteNumero = 496;
        String plc_Loader_LRH_LRH_0_dioName = "";
        int plc_Loader_LRH_LRH_0_inputNumero = 51;
        int plc_Loader_LRH_LRH_1_byteNumero = 895;
        String plc_Loader_LRH_LRH_1_dioName = "";
        int plc_Loader_LRH_LRH_1_inputNumero = 454;
        int plc_acAF0_acAF0b_byteNumero = 376;
        String plc_acAF0_acAF0b_dioName = "t";
        int plc_acAF0_acAF0b_inputNumero = 102;
        int plc_acAF0_acAF0s_byteNumero = 378;
        String plc_acAF0_acAF0s_dioName = "";
        int plc_acAF0_acAF0s_inputNumero = 125;
        int plc_acAF1_acAF1b_byteNumero = 896;
        String plc_acAF1_acAF1b_dioName = "s";
        int plc_acAF1_acAF1b_inputNumero = 323;
        int plc_acAF1_acAF1s_byteNumero = 693;
        String plc_acAF1_acAF1s_dioName = "h";
        int plc_acAF1_acAF1s_inputNumero = 212;
        int plc_acAF3_acAF3b_byteNumero = 654;
        String plc_acAF3_acAF3b_dioName = "";
        int plc_acAF3_acAF3b_inputNumero = 457;
        int plc_acAF3_acAF3s_byteNumero = 532;
        String plc_acAF3_acAF3s_dioName = "n";
        int plc_acAF3_acAF3s_inputNumero = 125;
        int plc_acAP2_acAP2b_byteNumero = 16;
        String plc_acAP2_acAP2b_dioName = "c";
        int plc_acAP2_acAP2b_inputNumero = 187;
        int plc_acAP2_acAP2s_byteNumero = 750;
        String plc_acAP2_acAP2s_dioName = "";
        int plc_acAP2_acAP2s_inputNumero = 227;
        int plc_keyEngSensors_keyEng_byteNumero = 309;
        String plc_keyEngSensors_keyEng_dioName = "";
        int plc_keyEngSensors_keyEng_inputNumero = 270;
        int plc_keyEngSensors_keyEngb_byteNumero = 363;
        String plc_keyEngSensors_keyEngb_dioName = "y";
        int plc_keyEngSensors_keyEngb_inputNumero = 638;
        int plc_keyLockSensors_keyLock_byteNumero = 804;
        String plc_keyLockSensors_keyLock_dioName = "";
        int plc_keyLockSensors_keyLock_inputNumero = 810;
        int plc_keyLockSensors_keyLockb_byteNumero = 588;
        String plc_keyLockSensors_keyLockb_dioName = "q";
        int plc_keyLockSensors_keyLockb_inputNumero = 936;
        int plc_loaderCarrierRelayStatus_byteNumero = 202;
        String plc_loaderCarrierRelayStatus_dioName = "";
        int plc_loaderCarrierRelayStatus_inputNumero = 731;
        int plc_loaderChainPresenceSensor_byteNumero = 976;
        String plc_loaderChainPresenceSensor_dioName = "x";
        int plc_loaderChainPresenceSensor_inputNumero = 683;
        int plc_loaderDefaultStatus_byteNumero = 51;
        String plc_loaderDefaultStatus_dioName = "z";
        int plc_loaderDefaultStatus_inputNumero = 647;
        int plc_loaderFilterDistanceSensor_byteNumero = 802;
        String plc_loaderFilterDistanceSensor_deviceName = "w";
        int plc_loaderFilterGoodPositionStatus_byteNumero = 631;
        String plc_loaderFilterGoodPositionStatus_dioName = "";
        int plc_loaderFilterGoodPositionStatus_inputNumero = 407;
        int plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_byteNumero = 625;
        String plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_dioName = "";
        int plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_inputNumero = 295;
        int plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_byteNumero = 617;
        String plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_dioName = "c";
        int plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_inputNumero = 534;
        int plc_loaderHooksRelayStatus_byteNumero = 209;
        String plc_loaderHooksRelayStatus_dioName = "o";
        int plc_loaderHooksRelayStatus_inputNumero = 44;
        int plc_loaderOnCameraSensors_loaderOnCameraSensor0_byteNumero = 755;
        String plc_loaderOnCameraSensors_loaderOnCameraSensor0_dioName = "";
        int plc_loaderOnCameraSensors_loaderOnCameraSensor0_inputNumero = 152;
        int plc_loaderOnCameraSensors_loaderOnCameraSensor1_byteNumero = 525;
        String plc_loaderOnCameraSensors_loaderOnCameraSensor1_dioName = "";
        int plc_loaderOnCameraSensors_loaderOnCameraSensor1_inputNumero = 513;
        int plc_loader_LFD_byteNumero = 318;
        String plc_loader_LFD_dioName = "l";
        int plc_loader_LFD_inputNumero = 203;
        int plc_loader_LFS_byteNumero = 489;
        String plc_loader_LFS_dioName = "r";
        int plc_loader_LFS_inputNumero = 121;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Loader_sensorConfigurationEvent(version, carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_byteNumero, carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_dioName, carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_inputNumero, carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_byteNumero, carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_dioName, carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_inputNumero, carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_byteNumero, carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_dioName, carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_inputNumero, carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_byteNumero, carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_dioName, carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_inputNumero, carrier_loaderStorageSensors_loaderStoragePositionSensor0_byteNumero, carrier_loaderStorageSensors_loaderStoragePositionSensor0_dioName, carrier_loaderStorageSensors_loaderStoragePositionSensor0_inputNumero, carrier_loaderStorageSensors_loaderStoragePositionSensor1_byteNumero, carrier_loaderStorageSensors_loaderStoragePositionSensor1_dioName, carrier_loaderStorageSensors_loaderStoragePositionSensor1_inputNumero, hooks_clampedStatusSensor_byteNumero, hooks_clampedStatusSensor_dioName, hooks_clampedStatusSensor_inputNumero, hooks_forceSensor0_byteNumero, hooks_forceSensor0_deviceName, hooks_forceSensor1_byteNumero, hooks_forceSensor1_deviceName, hooks_hook1_loaderCloseSensor1_byteNumero, hooks_hook1_loaderCloseSensor1_dioName, hooks_hook1_loaderCloseSensor1_inputNumero, hooks_hook1_loaderOpenSensor1_byteNumero, hooks_hook1_loaderOpenSensor1_dioName, hooks_hook1_loaderOpenSensor1_inputNumero, hooks_hook2_loaderCloseSensor2_byteNumero, hooks_hook2_loaderCloseSensor2_dioName, hooks_hook2_loaderCloseSensor2_inputNumero, hooks_hook2_loaderOpenSensor2_byteNumero, hooks_hook2_loaderOpenSensor2_dioName, hooks_hook2_loaderOpenSensor2_inputNumero, hooks_hook3_loaderCloseSensor3_byteNumero, hooks_hook3_loaderCloseSensor3_dioName, hooks_hook3_loaderCloseSensor3_inputNumero, hooks_hook3_loaderOpenSensor3_byteNumero, hooks_hook3_loaderOpenSensor3_dioName, hooks_hook3_loaderOpenSensor3_inputNumero, hooks_hook4_loaderCloseSensor4_byteNumero, hooks_hook4_loaderCloseSensor4_dioName, hooks_hook4_loaderCloseSensor4_inputNumero, hooks_hook4_loaderOpenSensor4_byteNumero, hooks_hook4_loaderOpenSensor4_dioName, hooks_hook4_loaderOpenSensor4_inputNumero, hooks_overClampedStatusSensor_byteNumero, hooks_overClampedStatusSensor_dioName, hooks_overClampedStatusSensor_inputNumero, hooks_unclampedStatusSensor_byteNumero, hooks_unclampedStatusSensor_dioName, hooks_unclampedStatusSensor_inputNumero, hooks_underClampedStatusSensor_byteNumero, hooks_underClampedStatusSensor_dioName, hooks_underClampedStatusSensor_inputNumero, plc_Loader_LPS_LPS_0_byteNumero, plc_Loader_LPS_LPS_0_dioName, plc_Loader_LPS_LPS_0_inputNumero, plc_Loader_LPS_LPS_1_byteNumero, plc_Loader_LPS_LPS_1_dioName, plc_Loader_LPS_LPS_1_inputNumero, plc_Loader_LRH_LRH_0_byteNumero, plc_Loader_LRH_LRH_0_dioName, plc_Loader_LRH_LRH_0_inputNumero, plc_Loader_LRH_LRH_1_byteNumero, plc_Loader_LRH_LRH_1_dioName, plc_Loader_LRH_LRH_1_inputNumero, plc_acAF0_acAF0b_byteNumero, plc_acAF0_acAF0b_dioName, plc_acAF0_acAF0b_inputNumero, plc_acAF0_acAF0s_byteNumero, plc_acAF0_acAF0s_dioName, plc_acAF0_acAF0s_inputNumero, plc_acAF1_acAF1b_byteNumero, plc_acAF1_acAF1b_dioName, plc_acAF1_acAF1b_inputNumero, plc_acAF1_acAF1s_byteNumero, plc_acAF1_acAF1s_dioName, plc_acAF1_acAF1s_inputNumero, plc_acAF3_acAF3b_byteNumero, plc_acAF3_acAF3b_dioName, plc_acAF3_acAF3b_inputNumero, plc_acAF3_acAF3s_byteNumero, plc_acAF3_acAF3s_dioName, plc_acAF3_acAF3s_inputNumero, plc_acAP2_acAP2b_byteNumero, plc_acAP2_acAP2b_dioName, plc_acAP2_acAP2b_inputNumero, plc_acAP2_acAP2s_byteNumero, plc_acAP2_acAP2s_dioName, plc_acAP2_acAP2s_inputNumero, plc_keyEngSensors_keyEng_byteNumero, plc_keyEngSensors_keyEng_dioName, plc_keyEngSensors_keyEng_inputNumero, plc_keyEngSensors_keyEngb_byteNumero, plc_keyEngSensors_keyEngb_dioName, plc_keyEngSensors_keyEngb_inputNumero, plc_keyLockSensors_keyLock_byteNumero, plc_keyLockSensors_keyLock_dioName, plc_keyLockSensors_keyLock_inputNumero, plc_keyLockSensors_keyLockb_byteNumero, plc_keyLockSensors_keyLockb_dioName, plc_keyLockSensors_keyLockb_inputNumero, plc_loaderCarrierRelayStatus_byteNumero, plc_loaderCarrierRelayStatus_dioName, plc_loaderCarrierRelayStatus_inputNumero, plc_loaderChainPresenceSensor_byteNumero, plc_loaderChainPresenceSensor_dioName, plc_loaderChainPresenceSensor_inputNumero, plc_loaderDefaultStatus_byteNumero, plc_loaderDefaultStatus_dioName, plc_loaderDefaultStatus_inputNumero, plc_loaderFilterDistanceSensor_byteNumero, plc_loaderFilterDistanceSensor_deviceName, plc_loaderFilterGoodPositionStatus_byteNumero, plc_loaderFilterGoodPositionStatus_dioName, plc_loaderFilterGoodPositionStatus_inputNumero, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_byteNumero, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_dioName, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_inputNumero, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_byteNumero, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_dioName, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_inputNumero, plc_loaderHooksRelayStatus_byteNumero, plc_loaderHooksRelayStatus_dioName, plc_loaderHooksRelayStatus_inputNumero, plc_loaderOnCameraSensors_loaderOnCameraSensor0_byteNumero, plc_loaderOnCameraSensors_loaderOnCameraSensor0_dioName, plc_loaderOnCameraSensors_loaderOnCameraSensor0_inputNumero, plc_loaderOnCameraSensors_loaderOnCameraSensor1_byteNumero, plc_loaderOnCameraSensors_loaderOnCameraSensor1_dioName, plc_loaderOnCameraSensors_loaderOnCameraSensor1_inputNumero, plc_loader_LFD_byteNumero, plc_loader_LFD_dioName, plc_loader_LFD_inputNumero, plc_loader_LFS_byteNumero, plc_loader_LFS_dioName, plc_loader_LFS_inputNumero));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_sensorConfigurationEvent));
        Fcs_Loader_sensorConfigurationEvent item_ = (Fcs_Loader_sensorConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_byteNumero, (long)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor0_byteNumero());
        Assert.assertEquals((Object)carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_dioName, (Object)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor0_dioName());
        Assert.assertEquals((long)carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_inputNumero, (long)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor0_inputNumero());
        Assert.assertEquals((long)carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_byteNumero, (long)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor1_byteNumero());
        Assert.assertEquals((Object)carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_dioName, (Object)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor1_dioName());
        Assert.assertEquals((long)carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_inputNumero, (long)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor1_inputNumero());
        Assert.assertEquals((long)carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_byteNumero, (long)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor0_byteNumero());
        Assert.assertEquals((Object)carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_dioName, (Object)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor0_dioName());
        Assert.assertEquals((long)carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_inputNumero, (long)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor0_inputNumero());
        Assert.assertEquals((long)carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_byteNumero, (long)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor1_byteNumero());
        Assert.assertEquals((Object)carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_dioName, (Object)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor1_dioName());
        Assert.assertEquals((long)carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_inputNumero, (long)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor1_inputNumero());
        Assert.assertEquals((long)carrier_loaderStorageSensors_loaderStoragePositionSensor0_byteNumero, (long)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor0_byteNumero());
        Assert.assertEquals((Object)carrier_loaderStorageSensors_loaderStoragePositionSensor0_dioName, (Object)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor0_dioName());
        Assert.assertEquals((long)carrier_loaderStorageSensors_loaderStoragePositionSensor0_inputNumero, (long)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor0_inputNumero());
        Assert.assertEquals((long)carrier_loaderStorageSensors_loaderStoragePositionSensor1_byteNumero, (long)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor1_byteNumero());
        Assert.assertEquals((Object)carrier_loaderStorageSensors_loaderStoragePositionSensor1_dioName, (Object)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor1_dioName());
        Assert.assertEquals((long)carrier_loaderStorageSensors_loaderStoragePositionSensor1_inputNumero, (long)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor1_inputNumero());
        Assert.assertEquals((long)hooks_clampedStatusSensor_byteNumero, (long)item_.getHooks_clampedStatusSensor_byteNumero());
        Assert.assertEquals((Object)hooks_clampedStatusSensor_dioName, (Object)item_.getHooks_clampedStatusSensor_dioName());
        Assert.assertEquals((long)hooks_clampedStatusSensor_inputNumero, (long)item_.getHooks_clampedStatusSensor_inputNumero());
        Assert.assertEquals((long)hooks_forceSensor0_byteNumero, (long)item_.getHooks_forceSensor0_byteNumero());
        Assert.assertEquals((Object)hooks_forceSensor0_deviceName, (Object)item_.getHooks_forceSensor0_deviceName());
        Assert.assertEquals((long)hooks_forceSensor1_byteNumero, (long)item_.getHooks_forceSensor1_byteNumero());
        Assert.assertEquals((Object)hooks_forceSensor1_deviceName, (Object)item_.getHooks_forceSensor1_deviceName());
        Assert.assertEquals((long)hooks_hook1_loaderCloseSensor1_byteNumero, (long)item_.getHooks_hook1_loaderCloseSensor1_byteNumero());
        Assert.assertEquals((Object)hooks_hook1_loaderCloseSensor1_dioName, (Object)item_.getHooks_hook1_loaderCloseSensor1_dioName());
        Assert.assertEquals((long)hooks_hook1_loaderCloseSensor1_inputNumero, (long)item_.getHooks_hook1_loaderCloseSensor1_inputNumero());
        Assert.assertEquals((long)hooks_hook1_loaderOpenSensor1_byteNumero, (long)item_.getHooks_hook1_loaderOpenSensor1_byteNumero());
        Assert.assertEquals((Object)hooks_hook1_loaderOpenSensor1_dioName, (Object)item_.getHooks_hook1_loaderOpenSensor1_dioName());
        Assert.assertEquals((long)hooks_hook1_loaderOpenSensor1_inputNumero, (long)item_.getHooks_hook1_loaderOpenSensor1_inputNumero());
        Assert.assertEquals((long)hooks_hook2_loaderCloseSensor2_byteNumero, (long)item_.getHooks_hook2_loaderCloseSensor2_byteNumero());
        Assert.assertEquals((Object)hooks_hook2_loaderCloseSensor2_dioName, (Object)item_.getHooks_hook2_loaderCloseSensor2_dioName());
        Assert.assertEquals((long)hooks_hook2_loaderCloseSensor2_inputNumero, (long)item_.getHooks_hook2_loaderCloseSensor2_inputNumero());
        Assert.assertEquals((long)hooks_hook2_loaderOpenSensor2_byteNumero, (long)item_.getHooks_hook2_loaderOpenSensor2_byteNumero());
        Assert.assertEquals((Object)hooks_hook2_loaderOpenSensor2_dioName, (Object)item_.getHooks_hook2_loaderOpenSensor2_dioName());
        Assert.assertEquals((long)hooks_hook2_loaderOpenSensor2_inputNumero, (long)item_.getHooks_hook2_loaderOpenSensor2_inputNumero());
        Assert.assertEquals((long)hooks_hook3_loaderCloseSensor3_byteNumero, (long)item_.getHooks_hook3_loaderCloseSensor3_byteNumero());
        Assert.assertEquals((Object)hooks_hook3_loaderCloseSensor3_dioName, (Object)item_.getHooks_hook3_loaderCloseSensor3_dioName());
        Assert.assertEquals((long)hooks_hook3_loaderCloseSensor3_inputNumero, (long)item_.getHooks_hook3_loaderCloseSensor3_inputNumero());
        Assert.assertEquals((long)hooks_hook3_loaderOpenSensor3_byteNumero, (long)item_.getHooks_hook3_loaderOpenSensor3_byteNumero());
        Assert.assertEquals((Object)hooks_hook3_loaderOpenSensor3_dioName, (Object)item_.getHooks_hook3_loaderOpenSensor3_dioName());
        Assert.assertEquals((long)hooks_hook3_loaderOpenSensor3_inputNumero, (long)item_.getHooks_hook3_loaderOpenSensor3_inputNumero());
        Assert.assertEquals((long)hooks_hook4_loaderCloseSensor4_byteNumero, (long)item_.getHooks_hook4_loaderCloseSensor4_byteNumero());
        Assert.assertEquals((Object)hooks_hook4_loaderCloseSensor4_dioName, (Object)item_.getHooks_hook4_loaderCloseSensor4_dioName());
        Assert.assertEquals((long)hooks_hook4_loaderCloseSensor4_inputNumero, (long)item_.getHooks_hook4_loaderCloseSensor4_inputNumero());
        Assert.assertEquals((long)hooks_hook4_loaderOpenSensor4_byteNumero, (long)item_.getHooks_hook4_loaderOpenSensor4_byteNumero());
        Assert.assertEquals((Object)hooks_hook4_loaderOpenSensor4_dioName, (Object)item_.getHooks_hook4_loaderOpenSensor4_dioName());
        Assert.assertEquals((long)hooks_hook4_loaderOpenSensor4_inputNumero, (long)item_.getHooks_hook4_loaderOpenSensor4_inputNumero());
        Assert.assertEquals((long)hooks_overClampedStatusSensor_byteNumero, (long)item_.getHooks_overClampedStatusSensor_byteNumero());
        Assert.assertEquals((Object)hooks_overClampedStatusSensor_dioName, (Object)item_.getHooks_overClampedStatusSensor_dioName());
        Assert.assertEquals((long)hooks_overClampedStatusSensor_inputNumero, (long)item_.getHooks_overClampedStatusSensor_inputNumero());
        Assert.assertEquals((long)hooks_unclampedStatusSensor_byteNumero, (long)item_.getHooks_unclampedStatusSensor_byteNumero());
        Assert.assertEquals((Object)hooks_unclampedStatusSensor_dioName, (Object)item_.getHooks_unclampedStatusSensor_dioName());
        Assert.assertEquals((long)hooks_unclampedStatusSensor_inputNumero, (long)item_.getHooks_unclampedStatusSensor_inputNumero());
        Assert.assertEquals((long)hooks_underClampedStatusSensor_byteNumero, (long)item_.getHooks_underClampedStatusSensor_byteNumero());
        Assert.assertEquals((Object)hooks_underClampedStatusSensor_dioName, (Object)item_.getHooks_underClampedStatusSensor_dioName());
        Assert.assertEquals((long)hooks_underClampedStatusSensor_inputNumero, (long)item_.getHooks_underClampedStatusSensor_inputNumero());
        Assert.assertEquals((long)plc_Loader_LPS_LPS_0_byteNumero, (long)item_.getPlc_Loader_LPS_LPS_0_byteNumero());
        Assert.assertEquals((Object)plc_Loader_LPS_LPS_0_dioName, (Object)item_.getPlc_Loader_LPS_LPS_0_dioName());
        Assert.assertEquals((long)plc_Loader_LPS_LPS_0_inputNumero, (long)item_.getPlc_Loader_LPS_LPS_0_inputNumero());
        Assert.assertEquals((long)plc_Loader_LPS_LPS_1_byteNumero, (long)item_.getPlc_Loader_LPS_LPS_1_byteNumero());
        Assert.assertEquals((Object)plc_Loader_LPS_LPS_1_dioName, (Object)item_.getPlc_Loader_LPS_LPS_1_dioName());
        Assert.assertEquals((long)plc_Loader_LPS_LPS_1_inputNumero, (long)item_.getPlc_Loader_LPS_LPS_1_inputNumero());
        Assert.assertEquals((long)plc_Loader_LRH_LRH_0_byteNumero, (long)item_.getPlc_Loader_LRH_LRH_0_byteNumero());
        Assert.assertEquals((Object)plc_Loader_LRH_LRH_0_dioName, (Object)item_.getPlc_Loader_LRH_LRH_0_dioName());
        Assert.assertEquals((long)plc_Loader_LRH_LRH_0_inputNumero, (long)item_.getPlc_Loader_LRH_LRH_0_inputNumero());
        Assert.assertEquals((long)plc_Loader_LRH_LRH_1_byteNumero, (long)item_.getPlc_Loader_LRH_LRH_1_byteNumero());
        Assert.assertEquals((Object)plc_Loader_LRH_LRH_1_dioName, (Object)item_.getPlc_Loader_LRH_LRH_1_dioName());
        Assert.assertEquals((long)plc_Loader_LRH_LRH_1_inputNumero, (long)item_.getPlc_Loader_LRH_LRH_1_inputNumero());
        Assert.assertEquals((long)plc_acAF0_acAF0b_byteNumero, (long)item_.getPlc_acAF0_acAF0b_byteNumero());
        Assert.assertEquals((Object)plc_acAF0_acAF0b_dioName, (Object)item_.getPlc_acAF0_acAF0b_dioName());
        Assert.assertEquals((long)plc_acAF0_acAF0b_inputNumero, (long)item_.getPlc_acAF0_acAF0b_inputNumero());
        Assert.assertEquals((long)plc_acAF0_acAF0s_byteNumero, (long)item_.getPlc_acAF0_acAF0s_byteNumero());
        Assert.assertEquals((Object)plc_acAF0_acAF0s_dioName, (Object)item_.getPlc_acAF0_acAF0s_dioName());
        Assert.assertEquals((long)plc_acAF0_acAF0s_inputNumero, (long)item_.getPlc_acAF0_acAF0s_inputNumero());
        Assert.assertEquals((long)plc_acAF1_acAF1b_byteNumero, (long)item_.getPlc_acAF1_acAF1b_byteNumero());
        Assert.assertEquals((Object)plc_acAF1_acAF1b_dioName, (Object)item_.getPlc_acAF1_acAF1b_dioName());
        Assert.assertEquals((long)plc_acAF1_acAF1b_inputNumero, (long)item_.getPlc_acAF1_acAF1b_inputNumero());
        Assert.assertEquals((long)plc_acAF1_acAF1s_byteNumero, (long)item_.getPlc_acAF1_acAF1s_byteNumero());
        Assert.assertEquals((Object)plc_acAF1_acAF1s_dioName, (Object)item_.getPlc_acAF1_acAF1s_dioName());
        Assert.assertEquals((long)plc_acAF1_acAF1s_inputNumero, (long)item_.getPlc_acAF1_acAF1s_inputNumero());
        Assert.assertEquals((long)plc_acAF3_acAF3b_byteNumero, (long)item_.getPlc_acAF3_acAF3b_byteNumero());
        Assert.assertEquals((Object)plc_acAF3_acAF3b_dioName, (Object)item_.getPlc_acAF3_acAF3b_dioName());
        Assert.assertEquals((long)plc_acAF3_acAF3b_inputNumero, (long)item_.getPlc_acAF3_acAF3b_inputNumero());
        Assert.assertEquals((long)plc_acAF3_acAF3s_byteNumero, (long)item_.getPlc_acAF3_acAF3s_byteNumero());
        Assert.assertEquals((Object)plc_acAF3_acAF3s_dioName, (Object)item_.getPlc_acAF3_acAF3s_dioName());
        Assert.assertEquals((long)plc_acAF3_acAF3s_inputNumero, (long)item_.getPlc_acAF3_acAF3s_inputNumero());
        Assert.assertEquals((long)plc_acAP2_acAP2b_byteNumero, (long)item_.getPlc_acAP2_acAP2b_byteNumero());
        Assert.assertEquals((Object)plc_acAP2_acAP2b_dioName, (Object)item_.getPlc_acAP2_acAP2b_dioName());
        Assert.assertEquals((long)plc_acAP2_acAP2b_inputNumero, (long)item_.getPlc_acAP2_acAP2b_inputNumero());
        Assert.assertEquals((long)plc_acAP2_acAP2s_byteNumero, (long)item_.getPlc_acAP2_acAP2s_byteNumero());
        Assert.assertEquals((Object)plc_acAP2_acAP2s_dioName, (Object)item_.getPlc_acAP2_acAP2s_dioName());
        Assert.assertEquals((long)plc_acAP2_acAP2s_inputNumero, (long)item_.getPlc_acAP2_acAP2s_inputNumero());
        Assert.assertEquals((long)plc_keyEngSensors_keyEng_byteNumero, (long)item_.getPlc_keyEngSensors_keyEng_byteNumero());
        Assert.assertEquals((Object)plc_keyEngSensors_keyEng_dioName, (Object)item_.getPlc_keyEngSensors_keyEng_dioName());
        Assert.assertEquals((long)plc_keyEngSensors_keyEng_inputNumero, (long)item_.getPlc_keyEngSensors_keyEng_inputNumero());
        Assert.assertEquals((long)plc_keyEngSensors_keyEngb_byteNumero, (long)item_.getPlc_keyEngSensors_keyEngb_byteNumero());
        Assert.assertEquals((Object)plc_keyEngSensors_keyEngb_dioName, (Object)item_.getPlc_keyEngSensors_keyEngb_dioName());
        Assert.assertEquals((long)plc_keyEngSensors_keyEngb_inputNumero, (long)item_.getPlc_keyEngSensors_keyEngb_inputNumero());
        Assert.assertEquals((long)plc_keyLockSensors_keyLock_byteNumero, (long)item_.getPlc_keyLockSensors_keyLock_byteNumero());
        Assert.assertEquals((Object)plc_keyLockSensors_keyLock_dioName, (Object)item_.getPlc_keyLockSensors_keyLock_dioName());
        Assert.assertEquals((long)plc_keyLockSensors_keyLock_inputNumero, (long)item_.getPlc_keyLockSensors_keyLock_inputNumero());
        Assert.assertEquals((long)plc_keyLockSensors_keyLockb_byteNumero, (long)item_.getPlc_keyLockSensors_keyLockb_byteNumero());
        Assert.assertEquals((Object)plc_keyLockSensors_keyLockb_dioName, (Object)item_.getPlc_keyLockSensors_keyLockb_dioName());
        Assert.assertEquals((long)plc_keyLockSensors_keyLockb_inputNumero, (long)item_.getPlc_keyLockSensors_keyLockb_inputNumero());
        Assert.assertEquals((long)plc_loaderCarrierRelayStatus_byteNumero, (long)item_.getPlc_loaderCarrierRelayStatus_byteNumero());
        Assert.assertEquals((Object)plc_loaderCarrierRelayStatus_dioName, (Object)item_.getPlc_loaderCarrierRelayStatus_dioName());
        Assert.assertEquals((long)plc_loaderCarrierRelayStatus_inputNumero, (long)item_.getPlc_loaderCarrierRelayStatus_inputNumero());
        Assert.assertEquals((long)plc_loaderChainPresenceSensor_byteNumero, (long)item_.getPlc_loaderChainPresenceSensor_byteNumero());
        Assert.assertEquals((Object)plc_loaderChainPresenceSensor_dioName, (Object)item_.getPlc_loaderChainPresenceSensor_dioName());
        Assert.assertEquals((long)plc_loaderChainPresenceSensor_inputNumero, (long)item_.getPlc_loaderChainPresenceSensor_inputNumero());
        Assert.assertEquals((long)plc_loaderDefaultStatus_byteNumero, (long)item_.getPlc_loaderDefaultStatus_byteNumero());
        Assert.assertEquals((Object)plc_loaderDefaultStatus_dioName, (Object)item_.getPlc_loaderDefaultStatus_dioName());
        Assert.assertEquals((long)plc_loaderDefaultStatus_inputNumero, (long)item_.getPlc_loaderDefaultStatus_inputNumero());
        Assert.assertEquals((long)plc_loaderFilterDistanceSensor_byteNumero, (long)item_.getPlc_loaderFilterDistanceSensor_byteNumero());
        Assert.assertEquals((Object)plc_loaderFilterDistanceSensor_deviceName, (Object)item_.getPlc_loaderFilterDistanceSensor_deviceName());
        Assert.assertEquals((long)plc_loaderFilterGoodPositionStatus_byteNumero, (long)item_.getPlc_loaderFilterGoodPositionStatus_byteNumero());
        Assert.assertEquals((Object)plc_loaderFilterGoodPositionStatus_dioName, (Object)item_.getPlc_loaderFilterGoodPositionStatus_dioName());
        Assert.assertEquals((long)plc_loaderFilterGoodPositionStatus_inputNumero, (long)item_.getPlc_loaderFilterGoodPositionStatus_inputNumero());
        Assert.assertEquals((long)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_byteNumero, (long)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_byteNumero());
        Assert.assertEquals((Object)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_dioName, (Object)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_dioName());
        Assert.assertEquals((long)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_inputNumero, (long)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_inputNumero());
        Assert.assertEquals((long)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_byteNumero, (long)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_byteNumero());
        Assert.assertEquals((Object)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_dioName, (Object)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_dioName());
        Assert.assertEquals((long)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_inputNumero, (long)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_inputNumero());
        Assert.assertEquals((long)plc_loaderHooksRelayStatus_byteNumero, (long)item_.getPlc_loaderHooksRelayStatus_byteNumero());
        Assert.assertEquals((Object)plc_loaderHooksRelayStatus_dioName, (Object)item_.getPlc_loaderHooksRelayStatus_dioName());
        Assert.assertEquals((long)plc_loaderHooksRelayStatus_inputNumero, (long)item_.getPlc_loaderHooksRelayStatus_inputNumero());
        Assert.assertEquals((long)plc_loaderOnCameraSensors_loaderOnCameraSensor0_byteNumero, (long)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor0_byteNumero());
        Assert.assertEquals((Object)plc_loaderOnCameraSensors_loaderOnCameraSensor0_dioName, (Object)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor0_dioName());
        Assert.assertEquals((long)plc_loaderOnCameraSensors_loaderOnCameraSensor0_inputNumero, (long)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor0_inputNumero());
        Assert.assertEquals((long)plc_loaderOnCameraSensors_loaderOnCameraSensor1_byteNumero, (long)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor1_byteNumero());
        Assert.assertEquals((Object)plc_loaderOnCameraSensors_loaderOnCameraSensor1_dioName, (Object)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor1_dioName());
        Assert.assertEquals((long)plc_loaderOnCameraSensors_loaderOnCameraSensor1_inputNumero, (long)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor1_inputNumero());
        Assert.assertEquals((long)plc_loader_LFD_byteNumero, (long)item_.getPlc_loader_LFD_byteNumero());
        Assert.assertEquals((Object)plc_loader_LFD_dioName, (Object)item_.getPlc_loader_LFD_dioName());
        Assert.assertEquals((long)plc_loader_LFD_inputNumero, (long)item_.getPlc_loader_LFD_inputNumero());
        Assert.assertEquals((long)plc_loader_LFS_byteNumero, (long)item_.getPlc_loader_LFS_byteNumero());
        Assert.assertEquals((Object)plc_loader_LFS_dioName, (Object)item_.getPlc_loader_LFS_dioName());
        Assert.assertEquals((long)plc_loader_LFS_inputNumero, (long)item_.getPlc_loader_LFS_inputNumero());
    }

    @Test
    public void sendReceiveFcs_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "w";
        int schedulers_default_nTasks = 653;
        int schedulers_default_nThreads = 153;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads));
        Assert.assertTrue((boolean)(item instanceof Fcs_PeriodicTasks_GeneralConfigurationEvent));
        Fcs_PeriodicTasks_GeneralConfigurationEvent item_ = (Fcs_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
    }

    @Test
    public void sendReceiveFcs_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 444L;
        long heartbeat_taskPeriodMillis = 436L;
        long main_checkControllers_taskPeriodMillis = 393L;
        long main_updateGui_taskPeriodMillis = 317L;
        long publishautochangertemperatures_taskPeriodMillis = 121L;
        long publishttc580temperatures_taskPeriodMillis = 355L;
        long runtimeinfo_taskPeriodMillis = 441L;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, main_checkControllers_taskPeriodMillis, main_updateGui_taskPeriodMillis, publishautochangertemperatures_taskPeriodMillis, publishttc580temperatures_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Fcs_PeriodicTasks_timersConfigurationEvent));
        Fcs_PeriodicTasks_timersConfigurationEvent item_ = (Fcs_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)main_checkControllers_taskPeriodMillis, (long)item_.getMain_checkControllers_taskPeriodMillis());
        Assert.assertEquals((long)main_updateGui_taskPeriodMillis, (long)item_.getMain_updateGui_taskPeriodMillis());
        Assert.assertEquals((long)publishautochangertemperatures_taskPeriodMillis, (long)item_.getPublishautochangertemperatures_taskPeriodMillis());
        Assert.assertEquals((long)publishttc580temperatures_taskPeriodMillis, (long)item_.getPublishttc580temperatures_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveShutter_GeneralConfigurationEvent() throws Exception {
        String version = "q";
        double controller_centeringSpeed = 0.6667261123657227;
        String controller_localAMSaddr = "";
        double controller_maxHallPositionError = 0.6512831449508667;
        double controller_maxStrokeSpeed = 0.04921752214431763;
        String controller_minExposureTime = "";
        String controller_noticeReaderRestartDelay = "";
        String controller_noticeReaderStartupDelay = "i";
        String controller_plcAMSaddr = "";
        String controller_plcAckTimeout = "";
        String controller_plcIPaddr = "p";
        String controller_referenceMinusXpositions = "y";
        String controller_referencePlusXpositions = "";
        String controller_safeCtrlTempRange = "";
        String controller_safeRtdTempRange = "";
        int periodictasks_schedulers_default_nTasks = 362;
        int periodictasks_schedulers_default_nThreads = 343;
        String publisher_configurationName = "l";
        String publisher_maxStrokeTime = "";
        double publisher_minStrokeLength = 0.5372181534767151;
        String publisher_minusXStrokeCounterPath = "n";
        String publisher_plusXStrokeCounterPath = "t";
        String publisher_publicationInterval = "d";
        String statemachine_brakepower_brakeVoltageKey = "u";
        double statemachine_brakepower_powerOnThreshold = 0.3661847f;
        String statemachine_resetSyncTimeout = "";
        String statemachine_taskRestartDelay = "f";
        String watchdog_checkInterval = "d";
        SALEvent item = this.testSendReceive((SALEvent)new Shutter_GeneralConfigurationEvent(version, controller_centeringSpeed, controller_localAMSaddr, controller_maxHallPositionError, controller_maxStrokeSpeed, controller_minExposureTime, controller_noticeReaderRestartDelay, controller_noticeReaderStartupDelay, controller_plcAMSaddr, controller_plcAckTimeout, controller_plcIPaddr, controller_referenceMinusXpositions, controller_referencePlusXpositions, controller_safeCtrlTempRange, controller_safeRtdTempRange, periodictasks_schedulers_default_nTasks, periodictasks_schedulers_default_nThreads, publisher_configurationName, publisher_maxStrokeTime, publisher_minStrokeLength, publisher_minusXStrokeCounterPath, publisher_plusXStrokeCounterPath, publisher_publicationInterval, statemachine_brakepower_brakeVoltageKey, statemachine_brakepower_powerOnThreshold, statemachine_resetSyncTimeout, statemachine_taskRestartDelay, watchdog_checkInterval));
        Assert.assertTrue((boolean)(item instanceof Shutter_GeneralConfigurationEvent));
        Shutter_GeneralConfigurationEvent item_ = (Shutter_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)controller_centeringSpeed, (double)item_.getController_centeringSpeed(), (double)1.0E-6f);
        Assert.assertEquals((Object)controller_localAMSaddr, (Object)item_.getController_localAMSaddr());
        Assert.assertEquals((double)controller_maxHallPositionError, (double)item_.getController_maxHallPositionError(), (double)1.0E-6f);
        Assert.assertEquals((double)controller_maxStrokeSpeed, (double)item_.getController_maxStrokeSpeed(), (double)1.0E-6f);
        Assert.assertEquals((Object)controller_minExposureTime, (Object)item_.getController_minExposureTime());
        Assert.assertEquals((Object)controller_noticeReaderRestartDelay, (Object)item_.getController_noticeReaderRestartDelay());
        Assert.assertEquals((Object)controller_noticeReaderStartupDelay, (Object)item_.getController_noticeReaderStartupDelay());
        Assert.assertEquals((Object)controller_plcAMSaddr, (Object)item_.getController_plcAMSaddr());
        Assert.assertEquals((Object)controller_plcAckTimeout, (Object)item_.getController_plcAckTimeout());
        Assert.assertEquals((Object)controller_plcIPaddr, (Object)item_.getController_plcIPaddr());
        Assert.assertEquals((Object)controller_referenceMinusXpositions, (Object)item_.getController_referenceMinusXpositions());
        Assert.assertEquals((Object)controller_referencePlusXpositions, (Object)item_.getController_referencePlusXpositions());
        Assert.assertEquals((Object)controller_safeCtrlTempRange, (Object)item_.getController_safeCtrlTempRange());
        Assert.assertEquals((Object)controller_safeRtdTempRange, (Object)item_.getController_safeRtdTempRange());
        Assert.assertEquals((long)periodictasks_schedulers_default_nTasks, (long)item_.getPeriodictasks_schedulers_default_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_default_nThreads, (long)item_.getPeriodictasks_schedulers_default_nThreads());
        Assert.assertEquals((Object)publisher_configurationName, (Object)item_.getPublisher_configurationName());
        Assert.assertEquals((Object)publisher_maxStrokeTime, (Object)item_.getPublisher_maxStrokeTime());
        Assert.assertEquals((double)publisher_minStrokeLength, (double)item_.getPublisher_minStrokeLength(), (double)1.0E-6f);
        Assert.assertEquals((Object)publisher_minusXStrokeCounterPath, (Object)item_.getPublisher_minusXStrokeCounterPath());
        Assert.assertEquals((Object)publisher_plusXStrokeCounterPath, (Object)item_.getPublisher_plusXStrokeCounterPath());
        Assert.assertEquals((Object)publisher_publicationInterval, (Object)item_.getPublisher_publicationInterval());
        Assert.assertEquals((Object)statemachine_brakepower_brakeVoltageKey, (Object)item_.getStatemachine_brakepower_brakeVoltageKey());
        Assert.assertEquals((double)statemachine_brakepower_powerOnThreshold, (double)item_.getStatemachine_brakepower_powerOnThreshold(), (double)1.0E-6f);
        Assert.assertEquals((Object)statemachine_resetSyncTimeout, (Object)item_.getStatemachine_resetSyncTimeout());
        Assert.assertEquals((Object)statemachine_taskRestartDelay, (Object)item_.getStatemachine_taskRestartDelay());
        Assert.assertEquals((Object)watchdog_checkInterval, (Object)item_.getWatchdog_checkInterval());
    }

    @Test
    public void sendReceiveShutter_timersConfigurationEvent() throws Exception {
        String version = "";
        long periodictasks_agentMonitorService_taskPeriodMillis = 13L;
        long periodictasks_heartbeat_taskPeriodMillis = 379L;
        long periodictasks_runtimeInfo_taskPeriodMillis = 482L;
        SALEvent item = this.testSendReceive((SALEvent)new Shutter_timersConfigurationEvent(version, periodictasks_agentMonitorService_taskPeriodMillis, periodictasks_heartbeat_taskPeriodMillis, periodictasks_runtimeInfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Shutter_timersConfigurationEvent));
        Shutter_timersConfigurationEvent item_ = (Shutter_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)periodictasks_agentMonitorService_taskPeriodMillis, (long)item_.getPeriodictasks_agentMonitorService_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_heartbeat_taskPeriodMillis, (long)item_.getPeriodictasks_heartbeat_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_runtimeInfo_taskPeriodMillis, (long)item_.getPeriodictasks_runtimeInfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveChiller_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "c";
        String maq20_serials = "";
        String pluto_node = "g";
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_DeviceConfigurationEvent(version, maq20_node, maq20_serials, pluto_node));
        Assert.assertTrue((boolean)(item instanceof Chiller_DeviceConfigurationEvent));
        Chiller_DeviceConfigurationEvent item_ = (Chiller_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)pluto_node, (Object)item_.getPluto_node());
    }

    @Test
    public void sendReceiveChiller_DevicesConfigurationEvent() throws Exception {
        String version = "u";
        boolean chiller_disabled = false;
        boolean maq20_disabled = true;
        boolean pluto_disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_DevicesConfigurationEvent(version, chiller_disabled, maq20_disabled, pluto_disabled));
        Assert.assertTrue((boolean)(item instanceof Chiller_DevicesConfigurationEvent));
        Chiller_DevicesConfigurationEvent item_ = (Chiller_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)chiller_disabled, (Object)item_.isChiller_disabled());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)pluto_disabled, (Object)item_.isPluto_disabled());
    }

    @Test
    public void sendReceiveChiller_GeneralConfigurationEvent() throws Exception {
        String version = "q";
        String chilleralertlistener_thermalAlertSource = "";
        String chilleralertlistener_vacuumAlertSource = "w";
        String chiller_host = "w";
        String coldInletChannelPath = "";
        String coldOutletChannelPath = "";
        String coldplateChannelPath = "n";
        boolean connectedToCamera = false;
        boolean glycolCooling = false;
        String listenTo = "";
        String maq20_ColdPlHeatXfer_flowChanPath = "t";
        String maq20_ColdPlHeatXfer_inletTChanPath = "";
        String maq20_ColdPlHeatXfer_outletTChanPath = "";
        String maq20_CoolantHeatXfer_flowChanPath = "d";
        String maq20_CoolantHeatXfer_inletTChanPath = "";
        String maq20_CoolantHeatXfer_outletTChanPath = "";
        String maq20_GlycHeatXfer_flowChanPath = "y";
        String maq20_GlycHeatXfer_inletTChanPath = "n";
        String maq20_GlycHeatXfer_outletTChanPath = "";
        double maxPressure = 0.44182825088500977;
        int periodictasks_schedulers_default_nTasks = 273;
        int periodictasks_schedulers_default_nThreads = 359;
        int periodictasks_schedulers_monitor_check_scheduler_nTasks = 625;
        int periodictasks_schedulers_monitor_check_scheduler_nThreads = 234;
        int periodictasks_schedulers_monitor_update_publish_scheduler_nTasks = 566;
        int periodictasks_schedulers_monitor_update_publish_scheduler_nThreads = 608;
        double temperatureTimeoutFactor = 0.005169034004211426;
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_GeneralConfigurationEvent(version, chilleralertlistener_thermalAlertSource, chilleralertlistener_vacuumAlertSource, chiller_host, coldInletChannelPath, coldOutletChannelPath, coldplateChannelPath, connectedToCamera, glycolCooling, listenTo, maq20_ColdPlHeatXfer_flowChanPath, maq20_ColdPlHeatXfer_inletTChanPath, maq20_ColdPlHeatXfer_outletTChanPath, maq20_CoolantHeatXfer_flowChanPath, maq20_CoolantHeatXfer_inletTChanPath, maq20_CoolantHeatXfer_outletTChanPath, maq20_GlycHeatXfer_flowChanPath, maq20_GlycHeatXfer_inletTChanPath, maq20_GlycHeatXfer_outletTChanPath, maxPressure, periodictasks_schedulers_default_nTasks, periodictasks_schedulers_default_nThreads, periodictasks_schedulers_monitor_check_scheduler_nTasks, periodictasks_schedulers_monitor_check_scheduler_nThreads, periodictasks_schedulers_monitor_update_publish_scheduler_nTasks, periodictasks_schedulers_monitor_update_publish_scheduler_nThreads, temperatureTimeoutFactor));
        Assert.assertTrue((boolean)(item instanceof Chiller_GeneralConfigurationEvent));
        Chiller_GeneralConfigurationEvent item_ = (Chiller_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)chilleralertlistener_thermalAlertSource, (Object)item_.getChilleralertlistener_thermalAlertSource());
        Assert.assertEquals((Object)chilleralertlistener_vacuumAlertSource, (Object)item_.getChilleralertlistener_vacuumAlertSource());
        Assert.assertEquals((Object)chiller_host, (Object)item_.getChiller_host());
        Assert.assertEquals((Object)coldInletChannelPath, (Object)item_.getColdInletChannelPath());
        Assert.assertEquals((Object)coldOutletChannelPath, (Object)item_.getColdOutletChannelPath());
        Assert.assertEquals((Object)coldplateChannelPath, (Object)item_.getColdplateChannelPath());
        Assert.assertEquals((Object)connectedToCamera, (Object)item_.isConnectedToCamera());
        Assert.assertEquals((Object)glycolCooling, (Object)item_.isGlycolCooling());
        Assert.assertEquals((Object)listenTo, (Object)item_.getListenTo());
        Assert.assertEquals((Object)maq20_ColdPlHeatXfer_flowChanPath, (Object)item_.getMaq20_ColdPlHeatXfer_flowChanPath());
        Assert.assertEquals((Object)maq20_ColdPlHeatXfer_inletTChanPath, (Object)item_.getMaq20_ColdPlHeatXfer_inletTChanPath());
        Assert.assertEquals((Object)maq20_ColdPlHeatXfer_outletTChanPath, (Object)item_.getMaq20_ColdPlHeatXfer_outletTChanPath());
        Assert.assertEquals((Object)maq20_CoolantHeatXfer_flowChanPath, (Object)item_.getMaq20_CoolantHeatXfer_flowChanPath());
        Assert.assertEquals((Object)maq20_CoolantHeatXfer_inletTChanPath, (Object)item_.getMaq20_CoolantHeatXfer_inletTChanPath());
        Assert.assertEquals((Object)maq20_CoolantHeatXfer_outletTChanPath, (Object)item_.getMaq20_CoolantHeatXfer_outletTChanPath());
        Assert.assertEquals((Object)maq20_GlycHeatXfer_flowChanPath, (Object)item_.getMaq20_GlycHeatXfer_flowChanPath());
        Assert.assertEquals((Object)maq20_GlycHeatXfer_inletTChanPath, (Object)item_.getMaq20_GlycHeatXfer_inletTChanPath());
        Assert.assertEquals((Object)maq20_GlycHeatXfer_outletTChanPath, (Object)item_.getMaq20_GlycHeatXfer_outletTChanPath());
        Assert.assertEquals((double)maxPressure, (double)item_.getMaxPressure(), (double)1.0E-6f);
        Assert.assertEquals((long)periodictasks_schedulers_default_nTasks, (long)item_.getPeriodictasks_schedulers_default_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_default_nThreads, (long)item_.getPeriodictasks_schedulers_default_nThreads());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_check_scheduler_nTasks, (long)item_.getPeriodictasks_schedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_check_scheduler_nThreads, (long)item_.getPeriodictasks_schedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getPeriodictasks_schedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getPeriodictasks_schedulers_monitor_update_publish_scheduler_nThreads());
        Assert.assertEquals((double)temperatureTimeoutFactor, (double)item_.getTemperatureTimeoutFactor(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double chiller_TempDUTInput_warnHi = 0.30284178256988525;
        double chiller_TempDUTInput_limitHi = 0.3750242590904236;
        double maq20_GlycChillerIn_warnHi = 0.6544218063354492;
        double maq20_GlycChillerIn_warnLo = 0.58131343126297;
        double maq20_GlycChillerIn_limitHi = 0.5212643146514893;
        double maq20_GlycChillerIn_limitLo = 0.786777913570404;
        double maq20_GlycChillerOut_warnHi = 0.49979186058044434;
        double maq20_GlycChillerOut_limitHi = 0.8632792830467224;
        double maq20_GlycInputFlow_warnLo = 0.8847594261169434;
        double maq20_GlycInputFlow_limitLo = 0.8851886987686157;
        double maq20_PBurstReturn_warnHi = 0.7348409295082092;
        double maq20_PBurstReturn_limitHi = 0.23631882667541504;
        double maq20_PBurstSupply_warnHi = 0.20344233512878418;
        double maq20_PBurstSupply_limitHi = 0.9699575304985046;
        double maq20_Stg1TXVBulb_warnHi = 0.3071577548980713;
        double maq20_Stg1TXVBulb_limitHi = 0.09066444635391235;
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_LimitsConfigurationEvent(version, chiller_TempDUTInput_warnHi, chiller_TempDUTInput_limitHi, maq20_GlycChillerIn_warnHi, maq20_GlycChillerIn_warnLo, maq20_GlycChillerIn_limitHi, maq20_GlycChillerIn_limitLo, maq20_GlycChillerOut_warnHi, maq20_GlycChillerOut_limitHi, maq20_GlycInputFlow_warnLo, maq20_GlycInputFlow_limitLo, maq20_PBurstReturn_warnHi, maq20_PBurstReturn_limitHi, maq20_PBurstSupply_warnHi, maq20_PBurstSupply_limitHi, maq20_Stg1TXVBulb_warnHi, maq20_Stg1TXVBulb_limitHi));
        Assert.assertTrue((boolean)(item instanceof Chiller_LimitsConfigurationEvent));
        Chiller_LimitsConfigurationEvent item_ = (Chiller_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)chiller_TempDUTInput_warnHi, (double)item_.getChiller_TempDUTInput_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)chiller_TempDUTInput_limitHi, (double)item_.getChiller_TempDUTInput_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_GlycChillerIn_warnHi, (double)item_.getMaq20_GlycChillerIn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_GlycChillerIn_warnLo, (double)item_.getMaq20_GlycChillerIn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_GlycChillerIn_limitHi, (double)item_.getMaq20_GlycChillerIn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_GlycChillerIn_limitLo, (double)item_.getMaq20_GlycChillerIn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_GlycChillerOut_warnHi, (double)item_.getMaq20_GlycChillerOut_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_GlycChillerOut_limitHi, (double)item_.getMaq20_GlycChillerOut_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_GlycInputFlow_warnLo, (double)item_.getMaq20_GlycInputFlow_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_GlycInputFlow_limitLo, (double)item_.getMaq20_GlycInputFlow_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_PBurstReturn_warnHi, (double)item_.getMaq20_PBurstReturn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_PBurstReturn_limitHi, (double)item_.getMaq20_PBurstReturn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_PBurstSupply_warnHi, (double)item_.getMaq20_PBurstSupply_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_PBurstSupply_limitHi, (double)item_.getMaq20_PBurstSupply_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_Stg1TXVBulb_warnHi, (double)item_.getMaq20_Stg1TXVBulb_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_Stg1TXVBulb_limitHi, (double)item_.getMaq20_Stg1TXVBulb_limitHi(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_PicConfigurationEvent() throws Exception {
        String version = "";
        double fanctrl_awGain = 0.6894885897636414;
        double fanctrl_baseDuty = 0.04080832004547119;
        double fanctrl_gain = 0.4690309762954712;
        double fanctrl_maxInput = 0.9243154525756836;
        double fanctrl_maxOutput = 0.3648267388343811;
        double fanctrl_minInput = 0.3376834988594055;
        double fanctrl_minOutput = 0.37369292974472046;
        double fanctrl_setTemp = 0.45799845457077026;
        double fanctrl_smoothTime = 0.7849602103233337;
        double fanctrl_timeConst = 0.5333129167556763;
        double fanctrl_tolerance = 0.97985f;
        boolean fanctrl_useAbsTemp = true;
        long periodictasks_FanCtrl_iterate_updateTime = 643L;
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_PicConfigurationEvent(version, fanctrl_awGain, fanctrl_baseDuty, fanctrl_gain, fanctrl_maxInput, fanctrl_maxOutput, fanctrl_minInput, fanctrl_minOutput, fanctrl_setTemp, fanctrl_smoothTime, fanctrl_timeConst, fanctrl_tolerance, fanctrl_useAbsTemp, periodictasks_FanCtrl_iterate_updateTime));
        Assert.assertTrue((boolean)(item instanceof Chiller_PicConfigurationEvent));
        Chiller_PicConfigurationEvent item_ = (Chiller_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)fanctrl_awGain, (double)item_.getFanctrl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_baseDuty, (double)item_.getFanctrl_baseDuty(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_gain, (double)item_.getFanctrl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxInput, (double)item_.getFanctrl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxOutput, (double)item_.getFanctrl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minInput, (double)item_.getFanctrl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minOutput, (double)item_.getFanctrl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_setTemp, (double)item_.getFanctrl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_smoothTime, (double)item_.getFanctrl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_timeConst, (double)item_.getFanctrl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_tolerance, (double)item_.getFanctrl_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((Object)fanctrl_useAbsTemp, (Object)item_.isFanctrl_useAbsTemp());
        Assert.assertEquals((long)periodictasks_FanCtrl_iterate_updateTime, (long)item_.getPeriodictasks_FanCtrl_iterate_updateTime());
    }

    @Test
    public void sendReceiveChiller_timersConfigurationEvent() throws Exception {
        String version = "";
        long periodictasks_Maq20_check_status_taskPeriodMillis = 86L;
        long periodictasks_agentMonitorService_taskPeriodMillis = 900L;
        long periodictasks_checkBurstDiscP_taskPeriodMillis = 205L;
        long periodictasks_checkDataArrival_taskPeriodMillis = 221L;
        long periodictasks_heartbeat_taskPeriodMillis = 326L;
        long periodictasks_monitor_check_Chiller_taskPeriodMillis = 722L;
        long periodictasks_monitor_check_Maq20_taskPeriodMillis = 588L;
        long periodictasks_monitor_check_Pluto_taskPeriodMillis = 248L;
        long periodictasks_monitor_publish_burstDiscs_taskPeriodMillis = 524L;
        long periodictasks_monitor_publish_taskPeriodMillis = 737L;
        long periodictasks_monitor_update_burstDiscs_taskPeriodMillis = 87L;
        long periodictasks_monitor_update_taskPeriodMillis = 421L;
        long periodictasks_publishParams_taskPeriodMillis = 930L;
        long periodictasks_runtimeInfo_taskPeriodMillis = 793L;
        long periodictasks_sendDutTemperature_taskPeriodMillis = 540L;
        long periodictasks_updateCtrlState_taskPeriodMillis = 386L;
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_timersConfigurationEvent(version, periodictasks_Maq20_check_status_taskPeriodMillis, periodictasks_agentMonitorService_taskPeriodMillis, periodictasks_checkBurstDiscP_taskPeriodMillis, periodictasks_checkDataArrival_taskPeriodMillis, periodictasks_heartbeat_taskPeriodMillis, periodictasks_monitor_check_Chiller_taskPeriodMillis, periodictasks_monitor_check_Maq20_taskPeriodMillis, periodictasks_monitor_check_Pluto_taskPeriodMillis, periodictasks_monitor_publish_burstDiscs_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_burstDiscs_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis, periodictasks_publishParams_taskPeriodMillis, periodictasks_runtimeInfo_taskPeriodMillis, periodictasks_sendDutTemperature_taskPeriodMillis, periodictasks_updateCtrlState_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Chiller_timersConfigurationEvent));
        Chiller_timersConfigurationEvent item_ = (Chiller_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)periodictasks_Maq20_check_status_taskPeriodMillis, (long)item_.getPeriodictasks_Maq20_check_status_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_agentMonitorService_taskPeriodMillis, (long)item_.getPeriodictasks_agentMonitorService_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_checkBurstDiscP_taskPeriodMillis, (long)item_.getPeriodictasks_checkBurstDiscP_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_checkDataArrival_taskPeriodMillis, (long)item_.getPeriodictasks_checkDataArrival_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_heartbeat_taskPeriodMillis, (long)item_.getPeriodictasks_heartbeat_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_Chiller_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_Chiller_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_Maq20_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_Pluto_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_Pluto_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_publish_burstDiscs_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_publish_burstDiscs_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_publish_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_update_burstDiscs_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_update_burstDiscs_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_update_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_update_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_publishParams_taskPeriodMillis, (long)item_.getPeriodictasks_publishParams_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_runtimeInfo_taskPeriodMillis, (long)item_.getPeriodictasks_runtimeInfo_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_sendDutTemperature_taskPeriodMillis, (long)item_.getPeriodictasks_sendDutTemperature_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_updateCtrlState_taskPeriodMillis, (long)item_.getPeriodictasks_updateCtrlState_taskPeriodMillis());
    }

    @Test
    public void sendReceiveThermal_DeviceConfigurationEvent() throws Exception {
        String version = "e";
        String protrtds_node = "";
        String rtds_node = "";
        String rtds_serials = "e";
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_DeviceConfigurationEvent(version, protrtds_node, rtds_node, rtds_serials));
        Assert.assertTrue((boolean)(item instanceof Thermal_DeviceConfigurationEvent));
        Thermal_DeviceConfigurationEvent item_ = (Thermal_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)protrtds_node, (Object)item_.getProtrtds_node());
        Assert.assertEquals((Object)rtds_node, (Object)item_.getRtds_node());
        Assert.assertEquals((Object)rtds_serials, (Object)item_.getRtds_serials());
    }

    @Test
    public void sendReceiveThermal_DevicesConfigurationEvent() throws Exception {
        String version = "o";
        boolean protrtds_disabled = true;
        boolean rtds_disabled = false;
        boolean trimpower_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_DevicesConfigurationEvent(version, protrtds_disabled, rtds_disabled, trimpower_disabled));
        Assert.assertTrue((boolean)(item instanceof Thermal_DevicesConfigurationEvent));
        Thermal_DevicesConfigurationEvent item_ = (Thermal_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)protrtds_disabled, (Object)item_.isProtrtds_disabled());
        Assert.assertEquals((Object)rtds_disabled, (Object)item_.isRtds_disabled());
        Assert.assertEquals((Object)trimpower_disabled, (Object)item_.isTrimpower_disabled());
    }

    @Test
    public void sendReceiveThermal_GeneralConfigurationEvent() throws Exception {
        String version = "a";
        String cold_Temp_AvgColdTemp_chanNames = "d";
        String cold_Temp_AvgColdTemp_chanWeights = "n";
        boolean cold_Temp_AvgColdTemp_ignoreNaN = false;
        String cryo_Temp_AvgCryoTemp_chanNames = "";
        String cryo_Temp_AvgCryoTemp_chanWeights = "";
        boolean cryo_Temp_AvgCryoTemp_ignoreNaN = true;
        int periodictasks_schedulers_default_nTasks = 305;
        int periodictasks_schedulers_default_nThreads = 55;
        int periodictasks_schedulers_monitor_check_scheduler_nTasks = 942;
        int periodictasks_schedulers_monitor_check_scheduler_nThreads = 791;
        int periodictasks_schedulers_monitor_update_publish_scheduler_nTasks = 818;
        int periodictasks_schedulers_monitor_update_publish_scheduler_nThreads = 886;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_GeneralConfigurationEvent(version, cold_Temp_AvgColdTemp_chanNames, cold_Temp_AvgColdTemp_chanWeights, cold_Temp_AvgColdTemp_ignoreNaN, cryo_Temp_AvgCryoTemp_chanNames, cryo_Temp_AvgCryoTemp_chanWeights, cryo_Temp_AvgCryoTemp_ignoreNaN, periodictasks_schedulers_default_nTasks, periodictasks_schedulers_default_nThreads, periodictasks_schedulers_monitor_check_scheduler_nTasks, periodictasks_schedulers_monitor_check_scheduler_nThreads, periodictasks_schedulers_monitor_update_publish_scheduler_nTasks, periodictasks_schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Thermal_GeneralConfigurationEvent));
        Thermal_GeneralConfigurationEvent item_ = (Thermal_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)cold_Temp_AvgColdTemp_chanNames, (Object)item_.getCold_Temp_AvgColdTemp_chanNames());
        Assert.assertEquals((Object)cold_Temp_AvgColdTemp_chanWeights, (Object)item_.getCold_Temp_AvgColdTemp_chanWeights());
        Assert.assertEquals((Object)cold_Temp_AvgColdTemp_ignoreNaN, (Object)item_.isCold_Temp_AvgColdTemp_ignoreNaN());
        Assert.assertEquals((Object)cryo_Temp_AvgCryoTemp_chanNames, (Object)item_.getCryo_Temp_AvgCryoTemp_chanNames());
        Assert.assertEquals((Object)cryo_Temp_AvgCryoTemp_chanWeights, (Object)item_.getCryo_Temp_AvgCryoTemp_chanWeights());
        Assert.assertEquals((Object)cryo_Temp_AvgCryoTemp_ignoreNaN, (Object)item_.isCryo_Temp_AvgCryoTemp_ignoreNaN());
        Assert.assertEquals((long)periodictasks_schedulers_default_nTasks, (long)item_.getPeriodictasks_schedulers_default_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_default_nThreads, (long)item_.getPeriodictasks_schedulers_default_nThreads());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_check_scheduler_nTasks, (long)item_.getPeriodictasks_schedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_check_scheduler_nThreads, (long)item_.getPeriodictasks_schedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getPeriodictasks_schedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getPeriodictasks_schedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveThermal_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double cold_Temp_AvgColdTemp_warnHi = 0.9117512106895447;
        double cold_Temp_AvgColdTemp_warnLo = 0.2600153684616089;
        double cold_Temp_AvgColdTemp_limitHi = 0.1531394124031067;
        double cold_Temp_AvgColdTemp_limitLo = 0.9253020882606506;
        double cryo_Temp_AvgCryoTemp_warnHi = 0.872222363948822;
        double cryo_Temp_AvgCryoTemp_warnLo = 0.11161643266677856;
        double cryo_Temp_AvgCryoTemp_limitHi = 0.4767692f;
        double cryo_Temp_AvgCryoTemp_limitLo = 0.6135520339012146;
        String rtdLocation = "";
        double[] rtd_Cold_TempCLP_warnHi = TestHelper.generateDoubleArray((int)25, (int)1909937374);
        double[] rtd_Cold_TempCLP_warnLo = TestHelper.generateDoubleArray((int)25, (int)1496825431);
        double[] rtd_Cold_TempCLP_limitHi = TestHelper.generateDoubleArray((int)25, (int)-174218810);
        double[] rtd_Cold_TempCLP_limitLo = TestHelper.generateDoubleArray((int)25, (int)1577315383);
        double[] rtd_Cryo_TempCYP_warnHi = TestHelper.generateDoubleArray((int)25, (int)-1564346172);
        double[] rtd_Cryo_TempCYP_warnLo = TestHelper.generateDoubleArray((int)25, (int)1832616074);
        double[] rtd_Cryo_TempCYP_limitHi = TestHelper.generateDoubleArray((int)25, (int)1627754150);
        double[] rtd_Cryo_TempCYP_limitLo = TestHelper.generateDoubleArray((int)25, (int)1461949037);
        double[] rtd_Grid_TempCFX_warnHi = TestHelper.generateDoubleArray((int)25, (int)-181865263);
        double[] rtd_Grid_TempCFX_warnLo = TestHelper.generateDoubleArray((int)25, (int)-350425148);
        double[] rtd_Grid_TempCFX_limitHi = TestHelper.generateDoubleArray((int)25, (int)1945190042);
        double[] rtd_Grid_TempCFX_limitLo = TestHelper.generateDoubleArray((int)25, (int)-1640651884);
        double[] rtd_Grid_TempGFX_warnHi = TestHelper.generateDoubleArray((int)25, (int)1855296719);
        double[] rtd_Grid_TempGFX_warnLo = TestHelper.generateDoubleArray((int)25, (int)12886183);
        double[] rtd_Grid_TempGFX_limitHi = TestHelper.generateDoubleArray((int)25, (int)-1464846167);
        double[] rtd_Grid_TempGFX_limitLo = TestHelper.generateDoubleArray((int)25, (int)-1569128844);
        double[] rtd_Grid_TempGRD_warnHi = TestHelper.generateDoubleArray((int)25, (int)1339162491);
        double[] rtd_Grid_TempGRD_warnLo = TestHelper.generateDoubleArray((int)25, (int)-932759132);
        double[] rtd_Grid_TempGRD_limitHi = TestHelper.generateDoubleArray((int)25, (int)1456550628);
        double[] rtd_Grid_TempGRD_limitLo = TestHelper.generateDoubleArray((int)25, (int)1279901360);
        String trimLocation = "e";
        double trim_Htrs_ColdTotal_P_warnHi = 0.5744142532348633;
        double trim_Htrs_ColdTotal_P_warnLo = 0.4660971760749817;
        double trim_Htrs_ColdTotal_P_limitHi = 0.32455867528915405;
        double trim_Htrs_ColdTotal_P_limitLo = 0.18661415576934814;
        double trim_Htrs_CryoTotal_P_warnHi = 0.37383097410202026;
        double trim_Htrs_CryoTotal_P_warnLo = 0.9825586080551147;
        double trim_Htrs_CryoTotal_P_limitHi = 0.13037598133087158;
        double trim_Htrs_CryoTotal_P_limitLo = 0.8517256379127502;
        double trim_Htrs_HtrBulkTmp_warnHi = 0.9634333848953247;
        double trim_Htrs_HtrBulkTmp_warnLo = 0.3411770462989807;
        double trim_Htrs_HtrBulkTmp_limitHi = 0.25867152214050293;
        double trim_Htrs_HtrBulkTmp_limitLo = 0.15205252170562744;
        double trim_Htrs_HtrBulk_I_warnHi = 0.8976141214370728;
        double trim_Htrs_HtrBulk_I_warnLo = 0.0636865496635437;
        double trim_Htrs_HtrBulk_I_limitHi = 0.4083990454673767;
        double trim_Htrs_HtrBulk_I_limitLo = 0.46033036708831787;
        double trim_Htrs_HtrBulk_P_warnHi = 0.5177094340324402;
        double trim_Htrs_HtrBulk_P_warnLo = 0.9938944578170776;
        double trim_Htrs_HtrBulk_P_limitHi = 0.3131089210510254;
        double trim_Htrs_HtrBulk_P_limitLo = 0.9489572048187256;
        double trim_Htrs_HtrBulk_V_warnHi = 0.8960791230201721;
        double trim_Htrs_HtrBulk_V_warnLo = 0.5843248963356018;
        double trim_Htrs_HtrBulk_V_limitHi = 0.6405413150787354;
        double trim_Htrs_HtrBulk_V_limitLo = 0.6184304356575012;
        double trim_Htrs_HtrPsTmp_warnHi = 0.665179431438446;
        double trim_Htrs_HtrPsTmp_warnLo = 0.6012641191482544;
        double trim_Htrs_HtrPsTmp_limitHi = 0.7447822093963623;
        double trim_Htrs_HtrPsTmp_limitLo = 0.8340408205986023;
        double[] trim_Trim_Htrs_ColdI_warnHi = TestHelper.generateDoubleArray((int)6, (int)77417103);
        double[] trim_Trim_Htrs_ColdI_warnLo = TestHelper.generateDoubleArray((int)6, (int)-1922119498);
        double[] trim_Trim_Htrs_ColdI_limitHi = TestHelper.generateDoubleArray((int)6, (int)51297739);
        double[] trim_Trim_Htrs_ColdI_limitLo = TestHelper.generateDoubleArray((int)6, (int)-1126386745);
        double[] trim_Trim_Htrs_ColdP_warnHi = TestHelper.generateDoubleArray((int)6, (int)201957969);
        double[] trim_Trim_Htrs_ColdP_warnLo = TestHelper.generateDoubleArray((int)6, (int)767546334);
        double[] trim_Trim_Htrs_ColdP_limitHi = TestHelper.generateDoubleArray((int)6, (int)1326156586);
        double[] trim_Trim_Htrs_ColdP_limitLo = TestHelper.generateDoubleArray((int)6, (int)853841930);
        double[] trim_Trim_Htrs_ColdV_warnHi = TestHelper.generateDoubleArray((int)6, (int)2023983567);
        double[] trim_Trim_Htrs_ColdV_warnLo = TestHelper.generateDoubleArray((int)6, (int)15589958);
        double[] trim_Trim_Htrs_ColdV_limitHi = TestHelper.generateDoubleArray((int)6, (int)2065921262);
        double[] trim_Trim_Htrs_ColdV_limitLo = TestHelper.generateDoubleArray((int)6, (int)1198018796);
        double[] trim_Trim_Htrs_CryoI_warnHi = TestHelper.generateDoubleArray((int)6, (int)-1772774062);
        double[] trim_Trim_Htrs_CryoI_warnLo = TestHelper.generateDoubleArray((int)6, (int)-1105325507);
        double[] trim_Trim_Htrs_CryoI_limitHi = TestHelper.generateDoubleArray((int)6, (int)-458164146);
        double[] trim_Trim_Htrs_CryoI_limitLo = TestHelper.generateDoubleArray((int)6, (int)1328011578);
        double[] trim_Trim_Htrs_CryoP_warnHi = TestHelper.generateDoubleArray((int)6, (int)23255390);
        double[] trim_Trim_Htrs_CryoP_warnLo = TestHelper.generateDoubleArray((int)6, (int)834523230);
        double[] trim_Trim_Htrs_CryoP_limitHi = TestHelper.generateDoubleArray((int)6, (int)1541951715);
        double[] trim_Trim_Htrs_CryoP_limitLo = TestHelper.generateDoubleArray((int)6, (int)-627945997);
        double[] trim_Trim_Htrs_CryoV_warnHi = TestHelper.generateDoubleArray((int)6, (int)-714785770);
        double[] trim_Trim_Htrs_CryoV_warnLo = TestHelper.generateDoubleArray((int)6, (int)-2061670619);
        double[] trim_Trim_Htrs_CryoV_limitHi = TestHelper.generateDoubleArray((int)6, (int)840274609);
        double[] trim_Trim_Htrs_CryoV_limitLo = TestHelper.generateDoubleArray((int)6, (int)88513016);
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_LimitsConfigurationEvent(version, cold_Temp_AvgColdTemp_warnHi, cold_Temp_AvgColdTemp_warnLo, cold_Temp_AvgColdTemp_limitHi, cold_Temp_AvgColdTemp_limitLo, cryo_Temp_AvgCryoTemp_warnHi, cryo_Temp_AvgCryoTemp_warnLo, cryo_Temp_AvgCryoTemp_limitHi, cryo_Temp_AvgCryoTemp_limitLo, rtdLocation, rtd_Cold_TempCLP_warnHi, rtd_Cold_TempCLP_warnLo, rtd_Cold_TempCLP_limitHi, rtd_Cold_TempCLP_limitLo, rtd_Cryo_TempCYP_warnHi, rtd_Cryo_TempCYP_warnLo, rtd_Cryo_TempCYP_limitHi, rtd_Cryo_TempCYP_limitLo, rtd_Grid_TempCFX_warnHi, rtd_Grid_TempCFX_warnLo, rtd_Grid_TempCFX_limitHi, rtd_Grid_TempCFX_limitLo, rtd_Grid_TempGFX_warnHi, rtd_Grid_TempGFX_warnLo, rtd_Grid_TempGFX_limitHi, rtd_Grid_TempGFX_limitLo, rtd_Grid_TempGRD_warnHi, rtd_Grid_TempGRD_warnLo, rtd_Grid_TempGRD_limitHi, rtd_Grid_TempGRD_limitLo, trimLocation, trim_Htrs_ColdTotal_P_warnHi, trim_Htrs_ColdTotal_P_warnLo, trim_Htrs_ColdTotal_P_limitHi, trim_Htrs_ColdTotal_P_limitLo, trim_Htrs_CryoTotal_P_warnHi, trim_Htrs_CryoTotal_P_warnLo, trim_Htrs_CryoTotal_P_limitHi, trim_Htrs_CryoTotal_P_limitLo, trim_Htrs_HtrBulkTmp_warnHi, trim_Htrs_HtrBulkTmp_warnLo, trim_Htrs_HtrBulkTmp_limitHi, trim_Htrs_HtrBulkTmp_limitLo, trim_Htrs_HtrBulk_I_warnHi, trim_Htrs_HtrBulk_I_warnLo, trim_Htrs_HtrBulk_I_limitHi, trim_Htrs_HtrBulk_I_limitLo, trim_Htrs_HtrBulk_P_warnHi, trim_Htrs_HtrBulk_P_warnLo, trim_Htrs_HtrBulk_P_limitHi, trim_Htrs_HtrBulk_P_limitLo, trim_Htrs_HtrBulk_V_warnHi, trim_Htrs_HtrBulk_V_warnLo, trim_Htrs_HtrBulk_V_limitHi, trim_Htrs_HtrBulk_V_limitLo, trim_Htrs_HtrPsTmp_warnHi, trim_Htrs_HtrPsTmp_warnLo, trim_Htrs_HtrPsTmp_limitHi, trim_Htrs_HtrPsTmp_limitLo, trim_Trim_Htrs_ColdI_warnHi, trim_Trim_Htrs_ColdI_warnLo, trim_Trim_Htrs_ColdI_limitHi, trim_Trim_Htrs_ColdI_limitLo, trim_Trim_Htrs_ColdP_warnHi, trim_Trim_Htrs_ColdP_warnLo, trim_Trim_Htrs_ColdP_limitHi, trim_Trim_Htrs_ColdP_limitLo, trim_Trim_Htrs_ColdV_warnHi, trim_Trim_Htrs_ColdV_warnLo, trim_Trim_Htrs_ColdV_limitHi, trim_Trim_Htrs_ColdV_limitLo, trim_Trim_Htrs_CryoI_warnHi, trim_Trim_Htrs_CryoI_warnLo, trim_Trim_Htrs_CryoI_limitHi, trim_Trim_Htrs_CryoI_limitLo, trim_Trim_Htrs_CryoP_warnHi, trim_Trim_Htrs_CryoP_warnLo, trim_Trim_Htrs_CryoP_limitHi, trim_Trim_Htrs_CryoP_limitLo, trim_Trim_Htrs_CryoV_warnHi, trim_Trim_Htrs_CryoV_warnLo, trim_Trim_Htrs_CryoV_limitHi, trim_Trim_Htrs_CryoV_limitLo));
        Assert.assertTrue((boolean)(item instanceof Thermal_LimitsConfigurationEvent));
        Thermal_LimitsConfigurationEvent item_ = (Thermal_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cold_Temp_AvgColdTemp_warnHi, (double)item_.getCold_Temp_AvgColdTemp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cold_Temp_AvgColdTemp_warnLo, (double)item_.getCold_Temp_AvgColdTemp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cold_Temp_AvgColdTemp_limitHi, (double)item_.getCold_Temp_AvgColdTemp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cold_Temp_AvgColdTemp_limitLo, (double)item_.getCold_Temp_AvgColdTemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Temp_AvgCryoTemp_warnHi, (double)item_.getCryo_Temp_AvgCryoTemp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Temp_AvgCryoTemp_warnLo, (double)item_.getCryo_Temp_AvgCryoTemp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Temp_AvgCryoTemp_limitHi, (double)item_.getCryo_Temp_AvgCryoTemp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Temp_AvgCryoTemp_limitLo, (double)item_.getCryo_Temp_AvgCryoTemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)rtdLocation, (Object)item_.getRtdLocation());
        Assert.assertArrayEquals((double[])rtd_Cold_TempCLP_warnHi, (double[])item_.getRtd_Cold_TempCLP_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cold_TempCLP_warnLo, (double[])item_.getRtd_Cold_TempCLP_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cold_TempCLP_limitHi, (double[])item_.getRtd_Cold_TempCLP_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cold_TempCLP_limitLo, (double[])item_.getRtd_Cold_TempCLP_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cryo_TempCYP_warnHi, (double[])item_.getRtd_Cryo_TempCYP_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cryo_TempCYP_warnLo, (double[])item_.getRtd_Cryo_TempCYP_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cryo_TempCYP_limitHi, (double[])item_.getRtd_Cryo_TempCYP_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cryo_TempCYP_limitLo, (double[])item_.getRtd_Cryo_TempCYP_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempCFX_warnHi, (double[])item_.getRtd_Grid_TempCFX_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempCFX_warnLo, (double[])item_.getRtd_Grid_TempCFX_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempCFX_limitHi, (double[])item_.getRtd_Grid_TempCFX_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempCFX_limitLo, (double[])item_.getRtd_Grid_TempCFX_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempGFX_warnHi, (double[])item_.getRtd_Grid_TempGFX_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempGFX_warnLo, (double[])item_.getRtd_Grid_TempGFX_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempGFX_limitHi, (double[])item_.getRtd_Grid_TempGFX_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempGFX_limitLo, (double[])item_.getRtd_Grid_TempGFX_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempGRD_warnHi, (double[])item_.getRtd_Grid_TempGRD_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempGRD_warnLo, (double[])item_.getRtd_Grid_TempGRD_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempGRD_limitHi, (double[])item_.getRtd_Grid_TempGRD_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_TempGRD_limitLo, (double[])item_.getRtd_Grid_TempGRD_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)trimLocation, (Object)item_.getTrimLocation());
        Assert.assertEquals((double)trim_Htrs_ColdTotal_P_warnHi, (double)item_.getTrim_Htrs_ColdTotal_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_ColdTotal_P_warnLo, (double)item_.getTrim_Htrs_ColdTotal_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_ColdTotal_P_limitHi, (double)item_.getTrim_Htrs_ColdTotal_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_ColdTotal_P_limitLo, (double)item_.getTrim_Htrs_ColdTotal_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_CryoTotal_P_warnHi, (double)item_.getTrim_Htrs_CryoTotal_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_CryoTotal_P_warnLo, (double)item_.getTrim_Htrs_CryoTotal_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_CryoTotal_P_limitHi, (double)item_.getTrim_Htrs_CryoTotal_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_CryoTotal_P_limitLo, (double)item_.getTrim_Htrs_CryoTotal_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulkTmp_warnHi, (double)item_.getTrim_Htrs_HtrBulkTmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulkTmp_warnLo, (double)item_.getTrim_Htrs_HtrBulkTmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulkTmp_limitHi, (double)item_.getTrim_Htrs_HtrBulkTmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulkTmp_limitLo, (double)item_.getTrim_Htrs_HtrBulkTmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_I_warnHi, (double)item_.getTrim_Htrs_HtrBulk_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_I_warnLo, (double)item_.getTrim_Htrs_HtrBulk_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_I_limitHi, (double)item_.getTrim_Htrs_HtrBulk_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_I_limitLo, (double)item_.getTrim_Htrs_HtrBulk_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_P_warnHi, (double)item_.getTrim_Htrs_HtrBulk_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_P_warnLo, (double)item_.getTrim_Htrs_HtrBulk_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_P_limitHi, (double)item_.getTrim_Htrs_HtrBulk_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_P_limitLo, (double)item_.getTrim_Htrs_HtrBulk_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_V_warnHi, (double)item_.getTrim_Htrs_HtrBulk_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_V_warnLo, (double)item_.getTrim_Htrs_HtrBulk_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_V_limitHi, (double)item_.getTrim_Htrs_HtrBulk_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_V_limitLo, (double)item_.getTrim_Htrs_HtrBulk_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrPsTmp_warnHi, (double)item_.getTrim_Htrs_HtrPsTmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrPsTmp_warnLo, (double)item_.getTrim_Htrs_HtrPsTmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrPsTmp_limitHi, (double)item_.getTrim_Htrs_HtrPsTmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrPsTmp_limitLo, (double)item_.getTrim_Htrs_HtrPsTmp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdI_warnHi, (double[])item_.getTrim_Trim_Htrs_ColdI_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdI_warnLo, (double[])item_.getTrim_Trim_Htrs_ColdI_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdI_limitHi, (double[])item_.getTrim_Trim_Htrs_ColdI_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdI_limitLo, (double[])item_.getTrim_Trim_Htrs_ColdI_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdP_warnHi, (double[])item_.getTrim_Trim_Htrs_ColdP_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdP_warnLo, (double[])item_.getTrim_Trim_Htrs_ColdP_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdP_limitHi, (double[])item_.getTrim_Trim_Htrs_ColdP_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdP_limitLo, (double[])item_.getTrim_Trim_Htrs_ColdP_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdV_warnHi, (double[])item_.getTrim_Trim_Htrs_ColdV_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdV_warnLo, (double[])item_.getTrim_Trim_Htrs_ColdV_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdV_limitHi, (double[])item_.getTrim_Trim_Htrs_ColdV_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_ColdV_limitLo, (double[])item_.getTrim_Trim_Htrs_ColdV_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoI_warnHi, (double[])item_.getTrim_Trim_Htrs_CryoI_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoI_warnLo, (double[])item_.getTrim_Trim_Htrs_CryoI_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoI_limitHi, (double[])item_.getTrim_Trim_Htrs_CryoI_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoI_limitLo, (double[])item_.getTrim_Trim_Htrs_CryoI_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoP_warnHi, (double[])item_.getTrim_Trim_Htrs_CryoP_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoP_warnLo, (double[])item_.getTrim_Trim_Htrs_CryoP_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoP_limitHi, (double[])item_.getTrim_Trim_Htrs_CryoP_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoP_limitLo, (double[])item_.getTrim_Trim_Htrs_CryoP_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoV_warnHi, (double[])item_.getTrim_Trim_Htrs_CryoV_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoV_warnLo, (double[])item_.getTrim_Trim_Htrs_CryoV_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoV_limitHi, (double[])item_.getTrim_Trim_Htrs_CryoV_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_CryoV_limitLo, (double[])item_.getTrim_Trim_Htrs_CryoV_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_PicConfigurationEvent() throws Exception {
        String version = "z";
        double coldtempctrlc_awGain = 0.5471782684326172;
        double coldtempctrlc_basePower = 0.6729531288146973;
        double coldtempctrlc_gain = 0.4603348970413208;
        double coldtempctrlc_maxInput = 0.08279919624328613;
        double coldtempctrlc_maxOutput = 0.0353279709815979;
        double coldtempctrlc_minInput = 0.2078602910041809;
        double coldtempctrlc_minOutput = 0.1305302381515503;
        double coldtempctrlc_smoothTime = 0.15609562397003174;
        double coldtempctrlc_timeConst = 0.509138f;
        double coldtempctrlc_tolerance = 0.2533954977989197;
        double coldtempctrlmye_awGain = 0.5670694708824158;
        double coldtempctrlmye_basePower = 0.7915201783180237;
        double coldtempctrlmye_gain = 0.4347783327102661;
        double coldtempctrlmye_maxInput = 0.16308891773223877;
        double coldtempctrlmye_maxOutput = 0.11034232378005981;
        double coldtempctrlmye_minInput = 0.07947146892547607;
        double coldtempctrlmye_minOutput = 0.8545461297035217;
        double coldtempctrlmye_smoothTime = 0.765780508518219;
        double coldtempctrlmye_timeConst = 0.6812258362770081;
        double coldtempctrlmye_tolerance = 0.34079432487487793;
        double coldtempctrlpye_awGain = 0.9090901613235474;
        double coldtempctrlpye_basePower = 0.8828146457672119;
        double coldtempctrlpye_gain = 0.1399632692337036;
        double coldtempctrlpye_maxInput = 0.21496367454528809;
        double coldtempctrlpye_maxOutput = 0.48869335651397705;
        double coldtempctrlpye_minInput = 0.5236793756484985;
        double coldtempctrlpye_minOutput = 0.1787287f;
        double coldtempctrlpye_smoothTime = 0.5199159383773804;
        double coldtempctrlpye_timeConst = 0.5029171705245972;
        double coldtempctrlpye_tolerance = 0.9910563230514526;
        double cryotempctrl_awGain = 0.2425785f;
        double cryotempctrl_basePower = 0.9126086831092834;
        double cryotempctrl_gain = 0.6433528661727905;
        double cryotempctrl_maxInput = 0.8951604962348938;
        double cryotempctrl_maxOutput = 0.17329078912734985;
        double cryotempctrl_minInput = 0.5230847001075745;
        double cryotempctrl_minOutput = 0.9876163005828857;
        double cryotempctrl_smoothTime = 0.02663552761077881;
        double cryotempctrl_timeConst = 0.8615723848342896;
        double cryotempctrl_tolerance = 0.8602638244628906;
        long periodictasks_ColdTempCtrlC_iterate_updateTime = 917L;
        long periodictasks_ColdTempCtrlMYE_iterate_updateTime = 250L;
        long periodictasks_ColdTempCtrlPYE_iterate_updateTime = 330L;
        long periodictasks_CryoTempCtrl_iterate_updateTime = 548L;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_PicConfigurationEvent(version, coldtempctrlc_awGain, coldtempctrlc_basePower, coldtempctrlc_gain, coldtempctrlc_maxInput, coldtempctrlc_maxOutput, coldtempctrlc_minInput, coldtempctrlc_minOutput, coldtempctrlc_smoothTime, coldtempctrlc_timeConst, coldtempctrlc_tolerance, coldtempctrlmye_awGain, coldtempctrlmye_basePower, coldtempctrlmye_gain, coldtempctrlmye_maxInput, coldtempctrlmye_maxOutput, coldtempctrlmye_minInput, coldtempctrlmye_minOutput, coldtempctrlmye_smoothTime, coldtempctrlmye_timeConst, coldtempctrlmye_tolerance, coldtempctrlpye_awGain, coldtempctrlpye_basePower, coldtempctrlpye_gain, coldtempctrlpye_maxInput, coldtempctrlpye_maxOutput, coldtempctrlpye_minInput, coldtempctrlpye_minOutput, coldtempctrlpye_smoothTime, coldtempctrlpye_timeConst, coldtempctrlpye_tolerance, cryotempctrl_awGain, cryotempctrl_basePower, cryotempctrl_gain, cryotempctrl_maxInput, cryotempctrl_maxOutput, cryotempctrl_minInput, cryotempctrl_minOutput, cryotempctrl_smoothTime, cryotempctrl_timeConst, cryotempctrl_tolerance, periodictasks_ColdTempCtrlC_iterate_updateTime, periodictasks_ColdTempCtrlMYE_iterate_updateTime, periodictasks_ColdTempCtrlPYE_iterate_updateTime, periodictasks_CryoTempCtrl_iterate_updateTime));
        Assert.assertTrue((boolean)(item instanceof Thermal_PicConfigurationEvent));
        Thermal_PicConfigurationEvent item_ = (Thermal_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)coldtempctrlc_awGain, (double)item_.getColdtempctrlc_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_basePower, (double)item_.getColdtempctrlc_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_gain, (double)item_.getColdtempctrlc_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_maxInput, (double)item_.getColdtempctrlc_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_maxOutput, (double)item_.getColdtempctrlc_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_minInput, (double)item_.getColdtempctrlc_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_minOutput, (double)item_.getColdtempctrlc_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_smoothTime, (double)item_.getColdtempctrlc_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_timeConst, (double)item_.getColdtempctrlc_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_tolerance, (double)item_.getColdtempctrlc_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_awGain, (double)item_.getColdtempctrlmye_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_basePower, (double)item_.getColdtempctrlmye_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_gain, (double)item_.getColdtempctrlmye_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_maxInput, (double)item_.getColdtempctrlmye_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_maxOutput, (double)item_.getColdtempctrlmye_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_minInput, (double)item_.getColdtempctrlmye_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_minOutput, (double)item_.getColdtempctrlmye_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_smoothTime, (double)item_.getColdtempctrlmye_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_timeConst, (double)item_.getColdtempctrlmye_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_tolerance, (double)item_.getColdtempctrlmye_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_awGain, (double)item_.getColdtempctrlpye_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_basePower, (double)item_.getColdtempctrlpye_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_gain, (double)item_.getColdtempctrlpye_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_maxInput, (double)item_.getColdtempctrlpye_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_maxOutput, (double)item_.getColdtempctrlpye_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_minInput, (double)item_.getColdtempctrlpye_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_minOutput, (double)item_.getColdtempctrlpye_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_smoothTime, (double)item_.getColdtempctrlpye_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_timeConst, (double)item_.getColdtempctrlpye_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_tolerance, (double)item_.getColdtempctrlpye_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_awGain, (double)item_.getCryotempctrl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_basePower, (double)item_.getCryotempctrl_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_gain, (double)item_.getCryotempctrl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_maxInput, (double)item_.getCryotempctrl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_maxOutput, (double)item_.getCryotempctrl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_minInput, (double)item_.getCryotempctrl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_minOutput, (double)item_.getCryotempctrl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_smoothTime, (double)item_.getCryotempctrl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_timeConst, (double)item_.getCryotempctrl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_tolerance, (double)item_.getCryotempctrl_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((long)periodictasks_ColdTempCtrlC_iterate_updateTime, (long)item_.getPeriodictasks_ColdTempCtrlC_iterate_updateTime());
        Assert.assertEquals((long)periodictasks_ColdTempCtrlMYE_iterate_updateTime, (long)item_.getPeriodictasks_ColdTempCtrlMYE_iterate_updateTime());
        Assert.assertEquals((long)periodictasks_ColdTempCtrlPYE_iterate_updateTime, (long)item_.getPeriodictasks_ColdTempCtrlPYE_iterate_updateTime());
        Assert.assertEquals((long)periodictasks_CryoTempCtrl_iterate_updateTime, (long)item_.getPeriodictasks_CryoTempCtrl_iterate_updateTime());
    }

    @Test
    public void sendReceiveThermal_RefrigConfigurationEvent() throws Exception {
        String version = "";
        double coldtempctrlc_tempDeadband = 0.9605495929718018;
        double coldtempctrlc_tempLimit = 0.2449181079864502;
        String coldtempctrlc_tempWeights = "s";
        double coldtempctrlmye_tempDeadband = 0.46034324169158936;
        double coldtempctrlmye_tempLimit = 0.16555821895599365;
        String coldtempctrlmye_tempWeights = "";
        double coldtempctrlpye_tempDeadband = 0.656694f;
        double coldtempctrlpye_tempLimit = 0.10323494672775269;
        String coldtempctrlpye_tempWeights = "k";
        double cryotempctrl_tempDeadband = 0.7998093366622925;
        double cryotempctrl_tempLimit = 0.37167954444885254;
        String cryotempctrl_tempWeights = "";
        double[] trimpower_coldPowerWeights = TestHelper.generateDoubleArray((int)6, (int)1649338611);
        String trimpower_connType = "";
        double[] trimpower_cryoPowerWeights = TestHelper.generateDoubleArray((int)6, (int)50402915);
        String trimpower_devcId = "i";
        int trimpower_devcParm = 24;
        int trimpower_node = 65;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_RefrigConfigurationEvent(version, coldtempctrlc_tempDeadband, coldtempctrlc_tempLimit, coldtempctrlc_tempWeights, coldtempctrlmye_tempDeadband, coldtempctrlmye_tempLimit, coldtempctrlmye_tempWeights, coldtempctrlpye_tempDeadband, coldtempctrlpye_tempLimit, coldtempctrlpye_tempWeights, cryotempctrl_tempDeadband, cryotempctrl_tempLimit, cryotempctrl_tempWeights, trimpower_coldPowerWeights, trimpower_connType, trimpower_cryoPowerWeights, trimpower_devcId, trimpower_devcParm, trimpower_node));
        Assert.assertTrue((boolean)(item instanceof Thermal_RefrigConfigurationEvent));
        Thermal_RefrigConfigurationEvent item_ = (Thermal_RefrigConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)coldtempctrlc_tempDeadband, (double)item_.getColdtempctrlc_tempDeadband(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_tempLimit, (double)item_.getColdtempctrlc_tempLimit(), (double)1.0E-6f);
        Assert.assertEquals((Object)coldtempctrlc_tempWeights, (Object)item_.getColdtempctrlc_tempWeights());
        Assert.assertEquals((double)coldtempctrlmye_tempDeadband, (double)item_.getColdtempctrlmye_tempDeadband(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_tempLimit, (double)item_.getColdtempctrlmye_tempLimit(), (double)1.0E-6f);
        Assert.assertEquals((Object)coldtempctrlmye_tempWeights, (Object)item_.getColdtempctrlmye_tempWeights());
        Assert.assertEquals((double)coldtempctrlpye_tempDeadband, (double)item_.getColdtempctrlpye_tempDeadband(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_tempLimit, (double)item_.getColdtempctrlpye_tempLimit(), (double)1.0E-6f);
        Assert.assertEquals((Object)coldtempctrlpye_tempWeights, (Object)item_.getColdtempctrlpye_tempWeights());
        Assert.assertEquals((double)cryotempctrl_tempDeadband, (double)item_.getCryotempctrl_tempDeadband(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_tempLimit, (double)item_.getCryotempctrl_tempLimit(), (double)1.0E-6f);
        Assert.assertEquals((Object)cryotempctrl_tempWeights, (Object)item_.getCryotempctrl_tempWeights());
        Assert.assertArrayEquals((double[])trimpower_coldPowerWeights, (double[])item_.getTrimpower_coldPowerWeights(), (double)1.0E-6f);
        Assert.assertEquals((Object)trimpower_connType, (Object)item_.getTrimpower_connType());
        Assert.assertArrayEquals((double[])trimpower_cryoPowerWeights, (double[])item_.getTrimpower_cryoPowerWeights(), (double)1.0E-6f);
        Assert.assertEquals((Object)trimpower_devcId, (Object)item_.getTrimpower_devcId());
        Assert.assertEquals((long)trimpower_devcParm, (long)item_.getTrimpower_devcParm());
        Assert.assertEquals((long)trimpower_node, (long)item_.getTrimpower_node());
    }

    @Test
    public void sendReceiveThermal_ThermalLimitsConfigurationEvent() throws Exception {
        String version = "g";
        double coldTempLimit = 0.2162758708000183;
        double coldTempLowLimit = 0.6132370829582214;
        double cryoTempLowLimit = 0.7398157119750977;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_ThermalLimitsConfigurationEvent(version, coldTempLimit, coldTempLowLimit, cryoTempLowLimit));
        Assert.assertTrue((boolean)(item instanceof Thermal_ThermalLimitsConfigurationEvent));
        Thermal_ThermalLimitsConfigurationEvent item_ = (Thermal_ThermalLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)coldTempLimit, (double)item_.getColdTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempLowLimit, (double)item_.getColdTempLowLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoTempLowLimit, (double)item_.getCryoTempLowLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_timersConfigurationEvent() throws Exception {
        String version = "";
        long periodictasks_ColdTempCtrlC_tempCheck_taskPeriodMillis = 737L;
        long periodictasks_ColdTempCtrlMYE_tempCheck_taskPeriodMillis = 57L;
        long periodictasks_ColdTempCtrlPYE_tempCheck_taskPeriodMillis = 377L;
        long periodictasks_CryoTempCtrl_tempCheck_taskPeriodMillis = 113L;
        long periodictasks_Rtds_check_status_taskPeriodMillis = 541L;
        long periodictasks_agentMonitorService_taskPeriodMillis = 466L;
        long periodictasks_heartbeat_taskPeriodMillis = 266L;
        long periodictasks_maintain_power_TrimPower_taskPeriodMillis = 559L;
        long periodictasks_monitor_check_ProtRtds_taskPeriodMillis = 972L;
        long periodictasks_monitor_check_Rtds_taskPeriodMillis = 853L;
        long periodictasks_monitor_check_TrimPower_taskPeriodMillis = 246L;
        long periodictasks_monitor_publish_avgTemp_taskPeriodMillis = 153L;
        long periodictasks_monitor_publish_coldTemp_taskPeriodMillis = 420L;
        long periodictasks_monitor_publish_taskPeriodMillis = 440L;
        long periodictasks_monitor_update_avgTemp_taskPeriodMillis = 657L;
        long periodictasks_monitor_update_coldTemp_taskPeriodMillis = 27L;
        long periodictasks_monitor_update_taskPeriodMillis = 662L;
        long periodictasks_runtimeInfo_taskPeriodMillis = 417L;
        long periodictasks_thermal_state_taskPeriodMillis = 353L;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_timersConfigurationEvent(version, periodictasks_ColdTempCtrlC_tempCheck_taskPeriodMillis, periodictasks_ColdTempCtrlMYE_tempCheck_taskPeriodMillis, periodictasks_ColdTempCtrlPYE_tempCheck_taskPeriodMillis, periodictasks_CryoTempCtrl_tempCheck_taskPeriodMillis, periodictasks_Rtds_check_status_taskPeriodMillis, periodictasks_agentMonitorService_taskPeriodMillis, periodictasks_heartbeat_taskPeriodMillis, periodictasks_maintain_power_TrimPower_taskPeriodMillis, periodictasks_monitor_check_ProtRtds_taskPeriodMillis, periodictasks_monitor_check_Rtds_taskPeriodMillis, periodictasks_monitor_check_TrimPower_taskPeriodMillis, periodictasks_monitor_publish_avgTemp_taskPeriodMillis, periodictasks_monitor_publish_coldTemp_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_avgTemp_taskPeriodMillis, periodictasks_monitor_update_coldTemp_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis, periodictasks_runtimeInfo_taskPeriodMillis, periodictasks_thermal_state_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Thermal_timersConfigurationEvent));
        Thermal_timersConfigurationEvent item_ = (Thermal_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)periodictasks_ColdTempCtrlC_tempCheck_taskPeriodMillis, (long)item_.getPeriodictasks_ColdTempCtrlC_tempCheck_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_ColdTempCtrlMYE_tempCheck_taskPeriodMillis, (long)item_.getPeriodictasks_ColdTempCtrlMYE_tempCheck_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_ColdTempCtrlPYE_tempCheck_taskPeriodMillis, (long)item_.getPeriodictasks_ColdTempCtrlPYE_tempCheck_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_CryoTempCtrl_tempCheck_taskPeriodMillis, (long)item_.getPeriodictasks_CryoTempCtrl_tempCheck_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_Rtds_check_status_taskPeriodMillis, (long)item_.getPeriodictasks_Rtds_check_status_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_agentMonitorService_taskPeriodMillis, (long)item_.getPeriodictasks_agentMonitorService_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_heartbeat_taskPeriodMillis, (long)item_.getPeriodictasks_heartbeat_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_maintain_power_TrimPower_taskPeriodMillis, (long)item_.getPeriodictasks_maintain_power_TrimPower_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_ProtRtds_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_ProtRtds_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_Rtds_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_Rtds_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_TrimPower_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_TrimPower_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_publish_avgTemp_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_publish_avgTemp_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_publish_coldTemp_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_publish_coldTemp_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_publish_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_update_avgTemp_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_update_avgTemp_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_update_coldTemp_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_update_coldTemp_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_update_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_update_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_runtimeInfo_taskPeriodMillis, (long)item_.getPeriodictasks_runtimeInfo_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_thermal_state_taskPeriodMillis, (long)item_.getPeriodictasks_thermal_state_taskPeriodMillis());
    }

    @Test
    public void sendReceiveUtiltrunk_BFR_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_BFR_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_BFR_DevicesConfigurationEvent));
        Utiltrunk_BFR_DevicesConfigurationEvent item_ = (Utiltrunk_BFR_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveUtiltrunk_BFR_UtilConfigurationEvent() throws Exception {
        String version = "w";
        int node = 696;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_BFR_UtilConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_BFR_UtilConfigurationEvent));
        Utiltrunk_BFR_UtilConfigurationEvent item_ = (Utiltrunk_BFR_UtilConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveUtiltrunk_BodyMaq20_DeviceConfigurationEvent() throws Exception {
        String version = "q";
        String node = "i";
        String serials = "d";
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_BodyMaq20_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_BodyMaq20_DeviceConfigurationEvent));
        Utiltrunk_BodyMaq20_DeviceConfigurationEvent item_ = (Utiltrunk_BodyMaq20_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveUtiltrunk_BodyMaq20_DevicesConfigurationEvent() throws Exception {
        String version = "h";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_BodyMaq20_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_BodyMaq20_DevicesConfigurationEvent));
        Utiltrunk_BodyMaq20_DevicesConfigurationEvent item_ = (Utiltrunk_BodyMaq20_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveUtiltrunk_Body_AmbAirtemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.3365599513053894;
        double warnLo = 0.7464718818664551;
        double limitHi = 0.5053682923316956;
        double limitLo = 0.721122f;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_AmbAirtemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_AmbAirtemp_LimitsConfigurationEvent));
        Utiltrunk_Body_AmbAirtemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_AmbAirtemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_AverageTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.28231215476989746;
        double warnLo = 0.12685906887054443;
        double limitHi = 0.04280775785446167;
        double limitLo = 0.4164009094238281;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_AverageTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_AverageTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_AverageTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_AverageTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_BackFlngXMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.2971833348274231;
        double warnLo = 0.17291676998138428;
        double limitHi = 0.3964492678642273;
        double limitLo = 0.28606903553009033;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_BackFlngXMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_BackFlngXMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_BackFlngXMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_BackFlngXMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_BackFlngXPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.45358043909072876;
        double warnLo = 0.8229976892471313;
        double limitHi = 0.07878583669662476;
        double limitLo = 0.1583128571510315;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_BackFlngXPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_BackFlngXPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_BackFlngXPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_BackFlngXPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_BackFlngYMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.6138122081756592;
        double warnLo = 0.7616521120071411;
        double limitHi = 0.181441068649292;
        double limitLo = 0.3565155267715454;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_BackFlngYMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_BackFlngYMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_BackFlngYMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_BackFlngYMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_CamBodyXPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.24437177181243896;
        double warnLo = 0.55808025598526;
        double limitHi = 0.7784669399261475;
        double limitLo = 0.1747505f;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_CamBodyXPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_CamBodyXPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_CamBodyXPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_CamBodyXPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_CamBodyYMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "g";
        double warnHi = 0.19584494829177856;
        double warnLo = 0.04350852966308594;
        double limitHi = 0.3487668037414551;
        double limitLo = 0.5736426115036011;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_CamBodyYMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_CamBodyYMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_CamBodyYMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_CamBodyYMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_CamBodyYPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.8685665726661682;
        double warnLo = 0.18529528379440308;
        double limitHi = 0.8653779029846191;
        double limitLo = 0.7696412205696106;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_CamBodyYPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_CamBodyYPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_CamBodyYPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_CamBodyYPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_CamHousXMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "z";
        double warnHi = 0.6559988260269165;
        double warnLo = 0.48620766401290894;
        double limitHi = 0.15396034717559814;
        double limitLo = 0.9419606328010559;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_CamHousXMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_CamHousXMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_CamHousXMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_CamHousXMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_CamHousXPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "k";
        double warnHi = 0.0745890736579895;
        double warnLo = 0.5363178253173828;
        double limitHi = 0.12388885021209717;
        double limitLo = 0.93117f;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_CamHousXPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_CamHousXPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_CamHousXPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_CamHousXPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_CamHousYMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.7913951277732849;
        double warnLo = 0.7020647525787354;
        double limitHi = 0.027035772800445557;
        double limitLo = 0.87954181432724;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_CamHousYMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_CamHousYMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_CamHousYMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_CamHousYMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_CamHousYPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.06456923484802246;
        double warnLo = 0.7436206340789795;
        double limitHi = 0.5795066952705383;
        double limitLo = 0.4074091911315918;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_CamHousYPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_CamHousYPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_CamHousYPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_CamHousYPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ChgrYMinusRtnAirTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.8240005373954773;
        double warnLo = 0.518421471118927;
        double limitHi = 0.3058089017868042;
        double limitLo = 0.4776777f;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ChgrYMinusRtnAirTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ChgrYMinusRtnAirTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_ChgrYMinusRtnAirTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ChgrYMinusRtnAirTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ChgrYMinusRtnAirVel_LimitsConfigurationEvent() throws Exception {
        String version = "x";
        double warnHi = 0.2792188f;
        double warnLo = 0.5696732997894287;
        double limitHi = 0.7104860544204712;
        double limitLo = 0.304135262966156;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ChgrYMinusRtnAirVel_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ChgrYMinusRtnAirVel_LimitsConfigurationEvent));
        Utiltrunk_Body_ChgrYMinusRtnAirVel_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ChgrYMinusRtnAirVel_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_DomeXMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "s";
        double warnHi = 0.3795526f;
        double warnLo = 0.03384626f;
        double limitHi = 0.6241716742515564;
        double limitLo = 0.5565491318702698;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_DomeXMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_DomeXMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_DomeXMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_DomeXMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_DomeYMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "a";
        double warnHi = 0.2004251480102539;
        double warnLo = 0.7636793851852417;
        double limitHi = 0.8251405954360962;
        double limitLo = 0.35672032833099365;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_DomeYMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_DomeYMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_DomeYMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_DomeYMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_L1XMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.4782752990722656;
        double warnLo = 0.7239797711372375;
        double limitHi = 0.7197815775871277;
        double limitLo = 0.9183598160743713;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_L1XMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_L1XMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_L1XMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_L1XMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_L1YMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.24312078952789307;
        double warnLo = 0.5844906568527222;
        double limitHi = 0.4658542275428772;
        double limitLo = 0.35205912590026855;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_L1YMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_L1YMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_L1YMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_L1YMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_L2XMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.3365342f;
        double warnLo = 0.03115654f;
        double limitHi = 0.4191882014274597;
        double limitLo = 0.004744529724121094;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_L2XMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_L2XMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_L2XMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_L2XMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_L2XPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "o";
        double warnHi = 0.22007405757904053;
        double warnLo = 0.541482150554657;
        double limitHi = 0.5644496083259583;
        double limitLo = 0.9477417469024658;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_L2XPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_L2XPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_L2XPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_L2XPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_L2YPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.10220110416412354;
        double warnLo = 0.4452778100967407;
        double limitHi = 0.5164448618888855;
        double limitLo = 0.944242537021637;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_L2YPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_L2YPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_L2YPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_L2YPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ShrdRngXMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "g";
        double warnHi = 0.5737094879150391;
        double warnLo = 0.0709908f;
        double limitHi = 0.05176180601119995;
        double limitLo = 0.25011515617370605;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ShrdRngXMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ShrdRngXMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_ShrdRngXMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ShrdRngXMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ShrdRngXPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.8028997182846069;
        double warnLo = 0.4242568016052246;
        double limitHi = 0.5157331228256226;
        double limitLo = 0.5582222938537598;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ShrdRngXPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ShrdRngXPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_ShrdRngXPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ShrdRngXPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ShrdRngYMinusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.32102978229522705;
        double warnLo = 0.7797937989234924;
        double limitHi = 0.8791483640670776;
        double limitLo = 0.6195932626724243;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ShrdRngYMinusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ShrdRngYMinusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_ShrdRngYMinusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ShrdRngYMinusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ShrdRngYPlusTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.7638687491416931;
        double warnLo = 0.9366223216056824;
        double limitHi = 0.04617792367935181;
        double limitLo = 0.3258591294288635;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ShrdRngYPlusTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ShrdRngYPlusTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_ShrdRngYPlusTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ShrdRngYPlusTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ShtrEboxRtnAirTemp_LimitsConfigurationEvent() throws Exception {
        String version = "r";
        double warnHi = 0.8271254897117615;
        double warnLo = 0.06476038694381714;
        double limitHi = 0.9718087911605835;
        double limitLo = 0.4123146f;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ShtrEboxRtnAirTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ShtrEboxRtnAirTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_ShtrEboxRtnAirTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ShtrEboxRtnAirTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ShtrEboxRtnAirVel_LimitsConfigurationEvent() throws Exception {
        String version = "l";
        double warnHi = 0.525852f;
        double warnLo = 0.12419843673706055;
        double limitHi = 0.8240468502044678;
        double limitLo = 0.7583534717559814;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ShtrEboxRtnAirVel_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ShtrEboxRtnAirVel_LimitsConfigurationEvent));
        Utiltrunk_Body_ShtrEboxRtnAirVel_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ShtrEboxRtnAirVel_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ShtrMtrRtnAirTemp_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.21386557817459106;
        double warnLo = 0.36055612564086914;
        double limitHi = 0.8323262333869934;
        double limitLo = 0.6992086172103882;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ShtrMtrRtnAirTemp_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ShtrMtrRtnAirTemp_LimitsConfigurationEvent));
        Utiltrunk_Body_ShtrMtrRtnAirTemp_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ShtrMtrRtnAirTemp_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_Body_ShtrMtrRtnAirVel_LimitsConfigurationEvent() throws Exception {
        String version = "h";
        double warnHi = 0.3641442656517029;
        double warnLo = 0.8141933679580688;
        double limitHi = 0.06189322471618652;
        double limitLo = 0.9578322172164917;
        SALEvent item = this.testSendReceive((SALEvent)new Utiltrunk_Body_ShtrMtrRtnAirVel_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_Body_ShtrMtrRtnAirVel_LimitsConfigurationEvent));
        Utiltrunk_Body_ShtrMtrRtnAirVel_LimitsConfigurationEvent item_ = (Utiltrunk_Body_ShtrMtrRtnAirV