/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.Chiller_ChillerTelemetry;
import org.lsst.sal.camera.telemetry.Chiller_FParam_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Chiller_Maq20Telemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Reb_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Sum_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_Latches_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_OnlineClamps_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_Temperatures_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Accelerobf_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Ai814_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_CarouselController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ClampXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ClampXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Hyttc580_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_LatchXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_LatchXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Pt100_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_CarrierController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_HooksController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Brakes_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket1_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket2_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket3_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket4_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket5_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Counters_Autochanger_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Counters_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Counters_Loader_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Counters_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Autochanger_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Loader_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Fcs_Mcm_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Fcs_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_Carrier_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_Hooks_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebsAverageTemp6Telemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_03Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_05Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_50Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_55Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_12Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_14Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_31Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_43Telemetry;
import org.lsst.sal.camera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_REB_Bulk_PSTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Shutter_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Cold_TempTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Cryo_TempTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_RtdTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_TrimTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Trim_HtrsTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_BodyTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_MPCTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_UTTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_VPCTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CipTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_HXTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_HipTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_InstTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.8755069375038147;
        double dirty_24V_I = 0.9039708375930786;
        double dirty_28V_I = 0.07796567678451538;
        double dirty_48V_I = 0.420676589012146;
        double protection_I = 0.8989740610122681;
        double rebps_0_2_I = 0.12161296606063843;
        double rebps_3_5_I = 0.20896893739700317;
        double rebps_6_8_I = 0.947770357131958;
        double rebps_9_12_I = 0.2951557f;
        double rebps_Spr_I = 0.888315f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, protection_I, rebps_0_2_I, rebps_3_5_I, rebps_6_8_I, rebps_9_12_I, rebps_Spr_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I, (double)item_.getRebps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I, (double)item_.getRebps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I, (double)item_.getRebps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I, (double)item_.getRebps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I, (double)item_.getRebps_Spr_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double board_T = 0.3020111918449402;
        double body_Maq20_I = 0.7900169491767883;
        double body_Maq20_V = 0.8486577868461609;
        double cryo_Maq20_I = 0.9441485404968262;
        double cryo_Maq20_V = 0.7743825912475586;
        double fes_CarouselC_I = 0.7082904577255249;
        double fes_CarouselC_V = 0.8928915858268738;
        double fes_ChangerC_I = 0.8528701663017273;
        double fes_ChangerC_V = 0.22256118059158325;
        double fes_LoaderC_I = 0.23151761293411255;
        double fes_LoaderC_V = 0.3666307330131531;
        double fpga_T = 0.8951523900032043;
        double gauges_I = 0.9892210364341736;
        double gauges_V = 0.8720544576644897;
        double int_Valves_I = 0.27813196182250977;
        double int_Valves_V = 0.4131561517715454;
        double ion_Pumps_I = 0.854506f;
        double ion_Pumps_V = 0.760930061340332;
        double main_I = 0.05844026803970337;
        double main_T = 0.44296252727508545;
        double main_V = 0.8741492033004761;
        double shtr_PLC1_I = 0.5222861170768738;
        double shtr_PLC1_V = 0.4755227565765381;
        double shtr_PLC2_I = 0.6505237221717834;
        double shtr_PLC2_V = 0.7943531274795532;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(board_T, body_Maq20_I, body_Maq20_V, cryo_Maq20_I, cryo_Maq20_V, fes_CarouselC_I, fes_CarouselC_V, fes_ChangerC_I, fes_ChangerC_V, fes_LoaderC_I, fes_LoaderC_V, fpga_T, gauges_I, gauges_V, int_Valves_I, int_Valves_V, ion_Pumps_I, ion_Pumps_V, main_I, main_T, main_V, shtr_PLC1_I, shtr_PLC1_V, shtr_PLC2_I, shtr_PLC2_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I, (double)item_.getBody_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V, (double)item_.getBody_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I, (double)item_.getCryo_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V, (double)item_.getCryo_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I, (double)item_.getFes_CarouselC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V, (double)item_.getFes_CarouselC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I, (double)item_.getFes_ChangerC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V, (double)item_.getFes_ChangerC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I, (double)item_.getFes_LoaderC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V, (double)item_.getFes_LoaderC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I, (double)item_.getInt_Valves_I(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V, (double)item_.getInt_Valves_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I, (double)item_.getShtr_PLC1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V, (double)item_.getShtr_PLC1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I, (double)item_.getShtr_PLC2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V, (double)item_.getShtr_PLC2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.6197706460952759;
        double cryo_Turbo_I = 0.3344826102256775;
        double cryo_Turbo_V = 0.3656052350997925;
        double fes_Brakes_I = 0.838508f;
        double fes_Brakes_V = 0.9427078366279602;
        double fes_ChangerD_I = 0.3455565f;
        double fes_ChangerD_V = 0.4657749f;
        double fes_Clamps_I = 0.6058825850486755;
        double fes_Clamps_V = 0.36224573850631714;
        double fes_LoaderD_I = 0.11827832460403442;
        double fes_LoaderD_V = 0.5935790538787842;
        double fpga_T = 0.67257f;
        double hex_Turbo_I = 0.3236528f;
        double hex_Turbo_V = 0.8826066851615906;
        double main_I = 0.5549773573875427;
        double main_T = 0.5185275077819824;
        double main_V = 0.0874180793762207;
        double shtr_Brakes_I = 0.9695937037467957;
        double shtr_Brakes_V = 0.12186849117279053;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, cryo_Turbo_I, cryo_Turbo_V, fes_Brakes_I, fes_Brakes_V, fes_ChangerD_I, fes_ChangerD_V, fes_Clamps_I, fes_Clamps_V, fes_LoaderD_I, fes_LoaderD_V, fpga_T, hex_Turbo_I, hex_Turbo_V, main_I, main_T, main_V, shtr_Brakes_I, shtr_Brakes_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I, (double)item_.getFes_Brakes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V, (double)item_.getFes_Brakes_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I, (double)item_.getFes_ChangerD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V, (double)item_.getFes_ChangerD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I, (double)item_.getFes_Clamps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V, (double)item_.getFes_Clamps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I, (double)item_.getFes_LoaderD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V, (double)item_.getFes_LoaderD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I, (double)item_.getHex_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V, (double)item_.getHex_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I, (double)item_.getShtr_Brakes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V, (double)item_.getShtr_Brakes_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.102963387966156;
        double fes_CarouselD_I = 0.966339111328125;
        double fes_CarouselD_V = 0.3570827841758728;
        double fes_Heater_I = 0.9877268671989441;
        double fes_Heater_V = 0.7081656455993652;
        double fpga_T = 0.19652915000915527;
        double main_I = 0.32983511686325073;
        double main_T = 0.4602123498916626;
        double main_V = 0.20682674646377563;
        double purge_Fan_I = 0.9360202550888062;
        double purge_Fan_V = 0.9764194488525391;
        double shtr_Motor1_I = 0.04096514f;
        double shtr_Motor1_V = 0.2708238959312439;
        double shtr_Motor2_I = 0.20480328798294067;
        double shtr_Motor2_V = 0.38327813148498535;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, fes_CarouselD_I, fes_CarouselD_V, fes_Heater_I, fes_Heater_V, fpga_T, main_I, main_T, main_V, purge_Fan_I, purge_Fan_V, shtr_Motor1_I, shtr_Motor1_V, shtr_Motor2_I, shtr_Motor2_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I, (double)item_.getFes_CarouselD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V, (double)item_.getFes_CarouselD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I, (double)item_.getFes_Heater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V, (double)item_.getFes_Heater_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I, (double)item_.getPurge_Fan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V, (double)item_.getPurge_Fan_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I, (double)item_.getShtr_Motor1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V, (double)item_.getShtr_Motor1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I, (double)item_.getShtr_Motor2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V, (double)item_.getShtr_Motor2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_A_I = 0.2791286110877991;
        double otm_0_A_V = 0.024204015731811523;
        double otm_0_B_I = 0.4047655463218689;
        double otm_0_B_V = 0.8538708686828613;
        double otm_1_A_I = 0.8955610394477844;
        double otm_1_A_V = 0.49687206745147705;
        double otm_1_B_I = 0.8177257180213928;
        double otm_1_B_V = 0.7200740575790405;
        double otm_2_A_I = 0.8789224028587341;
        double otm_2_A_V = 0.9083812832832336;
        double otm_2_B_I = 0.24591177701950073;
        double otm_2_B_V = 0.5945885181427002;
        double otm_3_A_I = 0.038214802742004395;
        double otm_3_A_V = 0.20659923553466797;
        double otm_3_B_I = 0.6937006711959839;
        double otm_3_B_V = 0.585611f;
        double otm_4_A_I = 0.8598822951316833;
        double otm_4_A_V = 0.5103155374526978;
        double otm_4_B_I = 0.7947682738304138;
        double otm_4_B_V = 0.7352200746536255;
        double otm_5_A_I = 0.7278470993041992;
        double otm_5_A_V = 0.717639148235321;
        double otm_5_B_I = 0.05815762281417847;
        double otm_5_B_V = 0.005688011646270752;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_A_I, otm_0_A_V, otm_0_B_I, otm_0_B_V, otm_1_A_I, otm_1_A_V, otm_1_B_I, otm_1_B_V, otm_2_A_I, otm_2_A_V, otm_2_B_I, otm_2_B_V, otm_3_A_I, otm_3_A_V, otm_3_B_I, otm_3_B_V, otm_4_A_I, otm_4_A_V, otm_4_B_I, otm_4_B_V, otm_5_A_I, otm_5_A_V, otm_5_B_I, otm_5_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I, (double)item_.getOtm_1_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V, (double)item_.getOtm_1_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I, (double)item_.getOtm_1_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V, (double)item_.getOtm_1_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I, (double)item_.getOtm_2_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V, (double)item_.getOtm_2_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I, (double)item_.getOtm_2_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V, (double)item_.getOtm_2_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I, (double)item_.getOtm_3_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V, (double)item_.getOtm_3_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I, (double)item_.getOtm_4_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V, (double)item_.getOtm_4_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I, (double)item_.getOtm_4_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V, (double)item_.getOtm_4_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I, (double)item_.getOtm_5_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V, (double)item_.getOtm_5_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I, (double)item_.getOtm_5_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V, (double)item_.getOtm_5_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PSTelemetry() throws Exception {
        double rebbulkps_0_2_I = 0.9040957689285278;
        double rebbulkps_0_2_T = 0.8059986233711243;
        double rebbulkps_0_2_V = 0.07394558191299438;
        double rebbulkps_3_5_I = 0.6062723994255066;
        double rebbulkps_3_5_T = 0.6834855079650879;
        double rebbulkps_3_5_V = 0.4805285930633545;
        double rebbulkps_6_8_I = 0.608591f;
        double rebbulkps_6_8_T = 0.4880955219268799;
        double rebbulkps_6_8_V = 0.8927910327911377;
        double rebbulkps_9_12_I = 0.244545578956604;
        double rebbulkps_9_12_T = 0.1967166f;
        double rebbulkps_9_12_V = 0.9257416725158691;
        double rebbulkps_Brd_T = 0.22976309061050415;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_REB_Bulk_PSTelemetry(rebbulkps_0_2_I, rebbulkps_0_2_T, rebbulkps_0_2_V, rebbulkps_3_5_I, rebbulkps_3_5_T, rebbulkps_3_5_V, rebbulkps_6_8_I, rebbulkps_6_8_T, rebbulkps_6_8_V, rebbulkps_9_12_I, rebbulkps_9_12_T, rebbulkps_9_12_V, rebbulkps_Brd_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PSTelemetry));
        Quadbox_REB_Bulk_PSTelemetry item_ = (Quadbox_REB_Bulk_PSTelemetry)item;
        Assert.assertEquals((double)rebbulkps_0_2_I, (double)item_.getRebbulkps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T, (double)item_.getRebbulkps_0_2_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V, (double)item_.getRebbulkps_0_2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I, (double)item_.getRebbulkps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T, (double)item_.getRebbulkps_3_5_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V, (double)item_.getRebbulkps_3_5_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I, (double)item_.getRebbulkps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T, (double)item_.getRebbulkps_6_8_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V, (double)item_.getRebbulkps_6_8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I, (double)item_.getRebbulkps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T, (double)item_.getRebbulkps_9_12_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V, (double)item_.getRebbulkps_9_12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T, (double)item_.getRebbulkps_Brd_T(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1972438551);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-190354332);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)1368270662);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1383670735);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-343627547);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)464326486);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1812386212);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)2132430017);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1013722796);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)784040707);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1319547359);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1279783441);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1497931914);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)1292651061);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1787342922);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-384824623);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)840214950);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-118543745);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)238992272);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1374135188);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-33379563);
        double[] dphi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1490296087);
        double[] dphi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)966784326);
        double[] dphi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)600833731);
        double[] dphi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)73250232);
        double[] dphi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)662055122);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)240631979);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)471444168);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)2098188163);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)304746258);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1493072865);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)71, (int)-610118733);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)71, (int)1319448279);
        String location = "";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)2002443298);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1348366022);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-230192584);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)854822384);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)318002217);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)744886528);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)955395906);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, dphi_IaftLDO, dphi_IbefLDO, dphi_VaftLDO, dphi_VaftSwch, dphi_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO, (double[])item_.getDphi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO, (double[])item_.getDphi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO, (double[])item_.getDphi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch, (double[])item_.getDphi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO, (double[])item_.getDphi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.641786515712738;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTotalPowerTelemetry));
        Rebpower_RebTotalPowerTelemetry item_ = (Rebpower_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)13, (int)1140086965);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)13, (int)-2042322663);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)13, (int)375133405);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)13, (int)222673131);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)13, (int)-850479456);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)13, (int)1494146765);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)13, (int)1144282287);
        double[] fPGATemp = TestHelper.generateDoubleArray((int)13, (int)2008558228);
        String location = "y";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, fPGATemp, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fPGATemp, (double[])item_.getFPGATemp(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveHex_Cold1Telemetry() throws Exception {
        double returnTmp = 0.7231592535972595;
        double supplyTmp = 0.06521821022033691;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold1Telemetry(returnTmp, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1Telemetry));
        Hex_Cold1Telemetry item_ = (Hex_Cold1Telemetry)item;
        Assert.assertEquals((double)returnTmp, (double)item_.getReturnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2Telemetry() throws Exception {
        double returnTmp = 0.01225733757019043;
        double supplyTmp = 0.4625069f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold2Telemetry(returnTmp, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2Telemetry));
        Hex_Cold2Telemetry item_ = (Hex_Cold2Telemetry)item;
        Assert.assertEquals((double)returnTmp, (double)item_.getReturnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1Telemetry() throws Exception {
        double c3ExitTmp = 0.03793919086456299;
        double c4ExitTmp = 0.8818580508232117;
        double evapExitTmp = 0.9179002642631531;
        double hexRtrnTmp = 0.13771146535873413;
        double liquidPrs = 0.5062663555145264;
        double preC3Tmp = 0.7237213850021362;
        double preC4Tmp = 0.06841546297073364;
        double returnPrs = 0.02939576f;
        double vaporPrs = 0.2166326642036438;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo1Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1Telemetry));
        Hex_Cryo1Telemetry item_ = (Hex_Cryo1Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2Telemetry() throws Exception {
        double c3ExitTmp = 0.6201863884925842;
        double c4ExitTmp = 0.4114183187484741;
        double evapExitTmp = 0.35027414560317993;
        double hexRtrnTmp = 0.3845224380493164;
        double liquidPrs = 0.6199628710746765;
        double preC3Tmp = 0.6504114270210266;
        double preC4Tmp = 0.1511920690536499;
        double returnPrs = 0.5748035907745361;
        double vaporPrs = 0.3971366286277771;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo2Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2Telemetry));
        Hex_Cryo2Telemetry item_ = (Hex_Cryo2Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3Telemetry() throws Exception {
        double c3ExitTmp = 0.8372153639793396;
        double c4ExitTmp = 0.7019031047821045;
        double evapExitTmp = 0.1216988f;
        double hexRtrnTmp = 0.5281376838684082;
        double liquidPrs = 0.7339946627616882;
        double preC3Tmp = 0.7250988483428955;
        double preC4Tmp = 0.48813456296920776;
        double returnPrs = 0.2808075547218323;
        double vaporPrs = 0.3357105851173401;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo3Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3Telemetry));
        Hex_Cryo3Telemetry item_ = (Hex_Cryo3Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4Telemetry() throws Exception {
        double c3ExitTmp = 0.7209962010383606;
        double c4ExitTmp = 0.6322429180145264;
        double evapExitTmp = 0.83319491147995;
        double hexRtrnTmp = 0.6734057664871216;
        double liquidPrs = 0.3599646f;
        double preC3Tmp = 0.7589601874351501;
        double preC4Tmp = 0.4118230938911438;
        double returnPrs = 0.6196964383125305;
        double vaporPrs = 0.6120848655700684;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo4Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4Telemetry));
        Hex_Cryo4Telemetry item_ = (Hex_Cryo4Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5Telemetry() throws Exception {
        double c3ExitTmp = 0.4229731559753418;
        double c4ExitTmp = 0.44699686765670776;
        double evapExitTmp = 0.2544752359390259;
        double hexRtrnTmp = 0.1292764f;
        double liquidPrs = 0.5627778768539429;
        double preC3Tmp = 0.4169063f;
        double preC4Tmp = 0.36349642276763916;
        double returnPrs = 0.6174356341362;
        double vaporPrs = 0.1345319151878357;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo5Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5Telemetry));
        Hex_Cryo5Telemetry item_ = (Hex_Cryo5Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6Telemetry() throws Exception {
        double c3ExitTmp = 0.16413915157318115;
        double c4ExitTmp = 0.6057294011116028;
        double evapExitTmp = 0.01824522f;
        double hexRtrnTmp = 0.9820212125778198;
        double liquidPrs = 0.5796330571174622;
        double preC3Tmp = 0.6457613110542297;
        double preC4Tmp = 0.2639222f;
        double returnPrs = 0.03187215328216553;
        double vaporPrs = 0.26263678073883057;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo6Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6Telemetry));
        Hex_Cryo6Telemetry item_ = (Hex_Cryo6Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo1Telemetry() throws Exception {
        double afterCoolTmp = 0.28186362981796265;
        double compCurrent = 0.9397711753845215;
        double compPower = 0.9006848335266113;
        double compVoltage = 0.07406091690063477;
        double dischrgPrs = 0.06348955631256104;
        double dischrgtmp_M = 0.17122292518615723;
        double dischrgtmp_P = 0.30574554204940796;
        double fanSpeed = 0.03847181797027588;
        double oilLevel = 0.6669538021087646;
        double oilSepTmp = 0.49192488193511963;
        double phaseSepTmp = 0.999212920665741;
        double suctionPrs = 0.3413416f;
        double suctiontmp_M = 0.04598820209503174;
        double suctiontmp_P = 0.9108771085739136;
        double surgeTankTmp = 0.21610617637634277;
        double waterInTmp = 0.8780374526977539;
        double waterOutTmp = 0.08403146266937256;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo1Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1Telemetry));
        Refrig_Cryo1Telemetry item_ = (Refrig_Cryo1Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2Telemetry() throws Exception {
        double afterCoolTmp = 0.2086862325668335;
        double compCurrent = 0.2111300826072693;
        double compPower = 0.995089054107666;
        double compVoltage = 0.7148743867874146;
        double dischrgPrs = 4.5883655548095703E-4;
        double dischrgtmp_M = 0.43354111909866333;
        double dischrgtmp_P = 0.4188016f;
        double fanSpeed = 0.6431595683097839;
        double oilLevel = 0.9160302877426147;
        double oilSepTmp = 0.28121745586395264;
        double phaseSepTmp = 0.4781906008720398;
        double suctionPrs = 0.3598499298095703;
        double suctiontmp_M = 0.4931039810180664;
        double suctiontmp_P = 0.4162802f;
        double surgeTankTmp = 0.3260529041290283;
        double waterInTmp = 0.9118999242782593;
        double waterOutTmp = 0.9470535516738892;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo2Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2Telemetry));
        Refrig_Cryo2Telemetry item_ = (Refrig_Cryo2Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3Telemetry() throws Exception {
        double afterCoolTmp = 0.9996038675308228;
        double ambientTmp = 0.0619124174118042;
        double cabinetTmp = 0.22986477613449097;
        double compCurrent = 0.7798523306846619;
        double compPower = 0.29803794622421265;
        double compVoltage = 0.2223801612854004;
        double dischrgPrs = 0.9500743746757507;
        double dischrgtmp_M = 0.3926847577095032;
        double dischrgtmp_P = 0.2769647240638733;
        double fanSpeed = 0.6775627136230469;
        double oilLevel = 0.8754173517227173;
        double oilSepTmp = 0.16074371337890625;
        double phaseSepTmp = 0.555881f;
        double suctionPrs = 0.346576452255249;
        double suctiontmp_M = 0.11497682332992554;
        double suctiontmp_P = 0.2686259150505066;
        double surgeTankTmp = 0.4730901f;
        double waterInTmp = 0.5016433000564575;
        double waterOutTmp = 0.7201228737831116;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo3Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3Telemetry));
        Refrig_Cryo3Telemetry item_ = (Refrig_Cryo3Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4Telemetry() throws Exception {
        double afterCoolTmp = 0.4603336453437805;
        double compCurrent = 0.6775134801864624;
        double compPower = 0.5899475812911987;
        double compVoltage = 0.31370365619659424;
        double dischrgPrs = 0.4645206928253174;
        double dischrgtmp_M = 0.2944047f;
        double dischrgtmp_P = 0.17733114957809448;
        double fanSpeed = 0.8883137702941895;
        double oilLevel = 0.46426987648010254;
        double oilSepTmp = 0.1538153886795044;
        double phaseSepTmp = 0.6605433225631714;
        double suctionPrs = 0.05602604150772095;
        double suctiontmp_M = 0.6079491972923279;
        double suctiontmp_P = 0.1355912685394287;
        double surgeTankTmp = 0.048298f;
        double waterInTmp = 0.5703188180923462;
        double waterOutTmp = 0.23579871654510498;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo4Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4Telemetry));
        Refrig_Cryo4Telemetry item_ = (Refrig_Cryo4Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5Telemetry() throws Exception {
        double afterCoolTmp = 0.3851664066314697;
        double ambientTmp = 0.2596195340156555;
        double cabinetTmp = 0.7442353367805481;
        double compCurrent = 0.523699939250946;
        double compPower = 0.9562922716140747;
        double compVoltage = 0.8052888512611389;
        double dischrgPrs = 0.3682003617286682;
        double dischrgtmp_M = 0.43454545736312866;
        double dischrgtmp_P = 0.5090310573577881;
        double fanSpeed = 0.3196784257888794;
        double oilLevel = 0.12565267086029053;
        double oilSepTmp = 0.7978700399398804;
        double phaseSepTmp = 0.655930757522583;
        double suctionPrs = 0.5015441179275513;
        double suctiontmp_M = 0.13211262226104736;
        double suctiontmp_P = 0.604641318321228;
        double surgeTankTmp = 0.731478214263916;
        double waterInTmp = 0.5497220754623413;
        double waterOutTmp = 0.7289993166923523;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo5Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5Telemetry));
        Refrig_Cryo5Telemetry item_ = (Refrig_Cryo5Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6Telemetry() throws Exception {
        double afterCoolTmp = 0.06669849157333374;
        double compCurrent = 0.43801575899124146;
        double compPower = 0.9800654053688049;
        double compVoltage = 0.7710750699043274;
        double dischrgPrs = 0.02524423599243164;
        double dischrgtmp_M = 0.476751446723938;
        double dischrgtmp_P = 0.7608950734138489;
        double fanSpeed = 0.407583f;
        double oilLevel = 0.04163634777069092;
        double oilSepTmp = 0.83986496925354;
        double phaseSepTmp = 0.3738877773284912;
        double suctionPrs = 0.4018402695655823;
        double suctiontmp_M = 0.12372863292694092;
        double suctiontmp_P = 0.5567038655281067;
        double surgeTankTmp = 0.7044802308082581;
        double waterInTmp = 0.8202640414237976;
        double waterOutTmp = 0.9550115466117859;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo6Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6Telemetry));
        Refrig_Cryo6Telemetry item_ = (Refrig_Cryo6Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CipTelemetry() throws Exception {
        double[] cryo_I = TestHelper.generateDoubleArray((int)6, (int)-238372453);
        double[] cryo_Life = TestHelper.generateDoubleArray((int)6, (int)2104259899);
        double[] cryo_Usage = TestHelper.generateDoubleArray((int)6, (int)-61565070);
        double[] cryo_V = TestHelper.generateDoubleArray((int)6, (int)-1544920761);
        String location = "j";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CipTelemetry(cryo_I, cryo_Life, cryo_Usage, cryo_V, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CipTelemetry));
        Vacuum_CipTelemetry item_ = (Vacuum_CipTelemetry)item;
        Assert.assertArrayEquals((double[])cryo_I, (double[])item_.getCryo_I(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life, (double[])item_.getCryo_Life(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage, (double[])item_.getCryo_Usage(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V, (double[])item_.getCryo_V(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double airPressure = 0.795421838760376;
        double cryoVac = 0.06474602222442627;
        double flineCurrent = 0.788535f;
        double flinePower = 0.5677070617675781;
        double flineVoltage = 0.2951841950416565;
        double forelineVac = 0.7024776339530945;
        double gaugeDose = 0.22802305221557617;
        double pumpCartPressure = 0.6064674854278564;
        double turboCurrent = 0.04365015f;
        double turboCycleNumber = 0.09193497896194458;
        double turboCycleTime = 0.13321322202682495;
        double turboGaugeDose = 0.11593139171600342;
        double turboHours = 0.6521983742713928;
        double turboPower = 0.7190038561820984;
        double turboPumpStatus = 0.6569314002990723;
        double turboPumpTemp = 0.20336401462554932;
        double turboSpeed = 0.6116685271263123;
        double turboVac = 0.9817002415657043;
        double turboVoltage = 0.5752905011177063;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(airPressure, cryoVac, flineCurrent, flinePower, flineVoltage, forelineVac, gaugeDose, pumpCartPressure, turboCurrent, turboCycleNumber, turboCycleTime, turboGaugeDose, turboHours, turboPower, turboPumpStatus, turboPumpTemp, turboSpeed, turboVac, turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)airPressure, (double)item_.getAirPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoVac, (double)item_.getCryoVac(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugeDose, (double)item_.getGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleNumber, (double)item_.getTurboCycleNumber(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleTime, (double)item_.getTurboCycleTime(), (double)1.0E-6f);
        Assert.assertEquals((double)turboGaugeDose, (double)item_.getTurboGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)turboHours, (double)item_.getTurboHours(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpStatus, (double)item_.getTurboPumpStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HXTelemetry() throws Exception {
        double airPressure = 0.27353787422180176;
        double flineCurrent = 0.3821097f;
        double flinePower = 0.5346871018409729;
        double flineVoltage = 0.24588346481323242;
        double forelineVac = 0.10972100496292114;
        double gaugeDose = 0.8029434084892273;
        double hexVac = 0.17557984590530396;
        double pumpCartPressure = 0.4403175115585327;
        double turboCurrent = 0.4156506657600403;
        double turboCycleNumber = 0.3418225646018982;
        double turboCycleTime = 0.6015100479125977;
        double turboGaugeDose = 0.7705448269844055;
        double turboHours = 0.6872080564498901;
        double turboPower = 0.029771864414215088;
        double turboPumpStatus = 0.6628186702728271;
        double turboPumpTemp = 0.02291596f;
        double turboSpeed = 0.5310186147689819;
        double turboVac = 0.1953495740890503;
        double turboVoltage = 0.015782415866851807;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_HXTelemetry(airPressure, flineCurrent, flinePower, flineVoltage, forelineVac, gaugeDose, hexVac, pumpCartPressure, turboCurrent, turboCycleNumber, turboCycleTime, turboGaugeDose, turboHours, turboPower, turboPumpStatus, turboPumpTemp, turboSpeed, turboVac, turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HXTelemetry));
        Vacuum_HXTelemetry item_ = (Vacuum_HXTelemetry)item;
        Assert.assertEquals((double)airPressure, (double)item_.getAirPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugeDose, (double)item_.getGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)hexVac, (double)item_.getHexVac(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleNumber, (double)item_.getTurboCycleNumber(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleTime, (double)item_.getTurboCycleTime(), (double)1.0E-6f);
        Assert.assertEquals((double)turboGaugeDose, (double)item_.getTurboGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)turboHours, (double)item_.getTurboHours(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpStatus, (double)item_.getTurboPumpStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HipTelemetry() throws Exception {
        double[] hx_I = TestHelper.generateDoubleArray((int)2, (int)1520708480);
        double[] hx_Life = TestHelper.generateDoubleArray((int)2, (int)2136446423);
        double[] hx_Usage = TestHelper.generateDoubleArray((int)2, (int)889434468);
        double[] hx_V = TestHelper.generateDoubleArray((int)2, (int)1882383272);
        String location = "d";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_HipTelemetry(hx_I, hx_Life, hx_Usage, hx_V, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HipTelemetry));
        Vacuum_HipTelemetry item_ = (Vacuum_HipTelemetry)item;
        Assert.assertArrayEquals((double[])hx_I, (double[])item_.getHx_I(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life, (double[])item_.getHx_Life(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage, (double[])item_.getHx_Usage(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V, (double[])item_.getHx_V(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_InstTelemetry() throws Exception {
        double cryoFlineValveState = 0.3349747657775879;
        double flineCurrent = 0.1472340226173401;
        double flinePower = 0.8052363395690918;
        double flineVoltage = 0.5221702456474304;
        double hxFlineValveState = 0.8500064611434937;
        double instVac = 0.6362707614898682;
        double pumpCartCycling = 0.413291335105896;
        double pumpCartPressure = 0.1438995f;
        double pumpCartTemperature = 0.4757162928581238;
        double pumpCartVenting = 0.24312984943389893;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_InstTelemetry(cryoFlineValveState, flineCurrent, flinePower, flineVoltage, hxFlineValveState, instVac, pumpCartCycling, pumpCartPressure, pumpCartTemperature, pumpCartVenting));
        Assert.assertTrue((boolean)(item instanceof Vacuum_InstTelemetry));
        Vacuum_InstTelemetry item_ = (Vacuum_InstTelemetry)item;
        Assert.assertEquals((double)cryoFlineValveState, (double)item_.getCryoFlineValveState(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)hxFlineValveState, (double)item_.getHxFlineValveState(), (double)1.0E-6f);
        Assert.assertEquals((double)instVac, (double)item_.getInstVac(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartCycling, (double)item_.getPumpCartCycling(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartTemperature, (double)item_.getPumpCartTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartVenting, (double)item_.getPumpCartVenting(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Reb_TrendingTelemetry() throws Exception {
        long[] driver_errors = TestHelper.generateLongArray((int)71, (int)1279954735);
        long[] driver_received = TestHelper.generateLongArray((int)71, (int)-781238247);
        long[] driver_rx0 = TestHelper.generateLongArray((int)71, (int)-20877825);
        long[] driver_rx1 = TestHelper.generateLongArray((int)71, (int)-2007797342);
        long[] driver_rx2 = TestHelper.generateLongArray((int)71, (int)1000232135);
        long[] driver_rx3 = TestHelper.generateLongArray((int)71, (int)-1036886040);
        long[] firmware_cell_errors = TestHelper.generateLongArray((int)71, (int)-56003911);
        long[] firmware_last_rx = TestHelper.generateLongArray((int)71, (int)-734561884);
        long[] firmware_last_tx = TestHelper.generateLongArray((int)71, (int)-1654439301);
        long[] firmware_link_down = TestHelper.generateLongArray((int)71, (int)314826334);
        long[] firmware_link_errors = TestHelper.generateLongArray((int)71, (int)1846623743);
        long[] firmware_link_status = TestHelper.generateLongArray((int)71, (int)-813975612);
        long[] firmware_overflow_local0 = TestHelper.generateLongArray((int)71, (int)908462333);
        long[] firmware_overflow_local1 = TestHelper.generateLongArray((int)71, (int)-470198973);
        long[] firmware_overflow_local2 = TestHelper.generateLongArray((int)71, (int)-139479264);
        long[] firmware_overflow_local3 = TestHelper.generateLongArray((int)71, (int)-227312054);
        long[] firmware_overflow_remote0 = TestHelper.generateLongArray((int)71, (int)-1606668767);
        long[] firmware_overflow_remote1 = TestHelper.generateLongArray((int)71, (int)447203806);
        long[] firmware_overflow_remote2 = TestHelper.generateLongArray((int)71, (int)2082902372);
        long[] firmware_overflow_remote3 = TestHelper.generateLongArray((int)71, (int)-113226136);
        long[] firmware_rlink_data = TestHelper.generateLongArray((int)71, (int)-197626924);
        long[] firmware_rx_clock = TestHelper.generateLongArray((int)71, (int)782416607);
        long[] firmware_rx_errors = TestHelper.generateLongArray((int)71, (int)-347730408);
        long[] firmware_rx_frames = TestHelper.generateLongArray((int)71, (int)1182364354);
        long[] firmware_rx_op = TestHelper.generateLongArray((int)71, (int)1221212748);
        long[] firmware_tx_clock = TestHelper.generateLongArray((int)71, (int)-284972930);
        long[] firmware_tx_errors = TestHelper.generateLongArray((int)71, (int)-771601431);
        long[] firmware_tx_frames = TestHelper.generateLongArray((int)71, (int)-1923858897);
        long[] firmware_tx_op = TestHelper.generateLongArray((int)71, (int)586436993);
        String location = "";
        long[] rds_bdi_firsts = TestHelper.generateLongArray((int)71, (int)-1600276619);
        long[] rds_bdi_frees = TestHelper.generateLongArray((int)71, (int)-213191999);
        long[] rds_bdi_lasts = TestHelper.generateLongArray((int)71, (int)760933851);
        long[] rds_bdi_nulls = TestHelper.generateLongArray((int)71, (int)-1174312248);
        long[] rds_bdi_overflows = TestHelper.generateLongArray((int)71, (int)951152927);
        long[] rds_bdi_seq_errors = TestHelper.generateLongArray((int)71, (int)-862153470);
        long[] rds_bdi_waits = TestHelper.generateLongArray((int)71, (int)221230124);
        long[] rds_discards = TestHelper.generateLongArray((int)71, (int)1268338780);
        long[] rds_no_event = TestHelper.generateLongArray((int)71, (int)-2047493086);
        long[] rds_wakes = TestHelper.generateLongArray((int)71, (int)2078289792);
        long[] rms_in_reset = TestHelper.generateLongArray((int)71, (int)-1740762912);
        long[] rms_inv_tids = TestHelper.generateLongArray((int)71, (int)-2059043734);
        long[] rms_link_down = TestHelper.generateLongArray((int)71, (int)1748617960);
        long[] rms_lists_posted = TestHelper.generateLongArray((int)71, (int)-410367348);
        long[] rms_ops_posted = TestHelper.generateLongArray((int)71, (int)688475762);
        long[] rms_orphans = TestHelper.generateLongArray((int)71, (int)-499220550);
        long[] rms_probes = TestHelper.generateLongArray((int)71, (int)1545305244);
        long[] rms_responses = TestHelper.generateLongArray((int)71, (int)-2132042691);
        long[] rms_rundowns = TestHelper.generateLongArray((int)71, (int)655433505);
        long[] rms_tid_hwm = TestHelper.generateLongArray((int)71, (int)1676510391);
        long[] rms_unopened = TestHelper.generateLongArray((int)71, (int)1074061309);
        long[] rms_waits = TestHelper.generateLongArray((int)71, (int)1528575163);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Reb_TrendingTelemetry(driver_errors, driver_received, driver_rx0, driver_rx1, driver_rx2, driver_rx3, firmware_cell_errors, firmware_last_rx, firmware_last_tx, firmware_link_down, firmware_link_errors, firmware_link_status, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_local3, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_overflow_remote3, firmware_rlink_data, firmware_rx_clock, firmware_rx_errors, firmware_rx_frames, firmware_rx_op, firmware_tx_clock, firmware_tx_errors, firmware_tx_frames, firmware_tx_op, location, rds_bdi_firsts, rds_bdi_frees, rds_bdi_lasts, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_bdi_waits, rds_discards, rds_no_event, rds_wakes, rms_in_reset, rms_inv_tids, rms_link_down, rms_lists_posted, rms_ops_posted, rms_orphans, rms_probes, rms_responses, rms_rundowns, rms_tid_hwm, rms_unopened, rms_waits));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Reb_TrendingTelemetry));
        Daq_monitor_Reb_TrendingTelemetry item_ = (Daq_monitor_Reb_TrendingTelemetry)item;
        Assert.assertArrayEquals((long[])driver_errors, (long[])item_.getDriver_errors());
        Assert.assertArrayEquals((long[])driver_received, (long[])item_.getDriver_received());
        Assert.assertArrayEquals((long[])driver_rx0, (long[])item_.getDriver_rx0());
        Assert.assertArrayEquals((long[])driver_rx1, (long[])item_.getDriver_rx1());
        Assert.assertArrayEquals((long[])driver_rx2, (long[])item_.getDriver_rx2());
        Assert.assertArrayEquals((long[])driver_rx3, (long[])item_.getDriver_rx3());
        Assert.assertArrayEquals((long[])firmware_cell_errors, (long[])item_.getFirmware_cell_errors());
        Assert.assertArrayEquals((long[])firmware_last_rx, (long[])item_.getFirmware_last_rx());
        Assert.assertArrayEquals((long[])firmware_last_tx, (long[])item_.getFirmware_last_tx());
        Assert.assertArrayEquals((long[])firmware_link_down, (long[])item_.getFirmware_link_down());
        Assert.assertArrayEquals((long[])firmware_link_errors, (long[])item_.getFirmware_link_errors());
        Assert.assertArrayEquals((long[])firmware_link_status, (long[])item_.getFirmware_link_status());
        Assert.assertArrayEquals((long[])firmware_overflow_local0, (long[])item_.getFirmware_overflow_local0());
        Assert.assertArrayEquals((long[])firmware_overflow_local1, (long[])item_.getFirmware_overflow_local1());
        Assert.assertArrayEquals((long[])firmware_overflow_local2, (long[])item_.getFirmware_overflow_local2());
        Assert.assertArrayEquals((long[])firmware_overflow_local3, (long[])item_.getFirmware_overflow_local3());
        Assert.assertArrayEquals((long[])firmware_overflow_remote0, (long[])item_.getFirmware_overflow_remote0());
        Assert.assertArrayEquals((long[])firmware_overflow_remote1, (long[])item_.getFirmware_overflow_remote1());
        Assert.assertArrayEquals((long[])firmware_overflow_remote2, (long[])item_.getFirmware_overflow_remote2());
        Assert.assertArrayEquals((long[])firmware_overflow_remote3, (long[])item_.getFirmware_overflow_remote3());
        Assert.assertArrayEquals((long[])firmware_rlink_data, (long[])item_.getFirmware_rlink_data());
        Assert.assertArrayEquals((long[])firmware_rx_clock, (long[])item_.getFirmware_rx_clock());
        Assert.assertArrayEquals((long[])firmware_rx_errors, (long[])item_.getFirmware_rx_errors());
        Assert.assertArrayEquals((long[])firmware_rx_frames, (long[])item_.getFirmware_rx_frames());
        Assert.assertArrayEquals((long[])firmware_rx_op, (long[])item_.getFirmware_rx_op());
        Assert.assertArrayEquals((long[])firmware_tx_clock, (long[])item_.getFirmware_tx_clock());
        Assert.assertArrayEquals((long[])firmware_tx_errors, (long[])item_.getFirmware_tx_errors());
        Assert.assertArrayEquals((long[])firmware_tx_frames, (long[])item_.getFirmware_tx_frames());
        Assert.assertArrayEquals((long[])firmware_tx_op, (long[])item_.getFirmware_tx_op());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])rds_bdi_firsts, (long[])item_.getRds_bdi_firsts());
        Assert.assertArrayEquals((long[])rds_bdi_frees, (long[])item_.getRds_bdi_frees());
        Assert.assertArrayEquals((long[])rds_bdi_lasts, (long[])item_.getRds_bdi_lasts());
        Assert.assertArrayEquals((long[])rds_bdi_nulls, (long[])item_.getRds_bdi_nulls());
        Assert.assertArrayEquals((long[])rds_bdi_overflows, (long[])item_.getRds_bdi_overflows());
        Assert.assertArrayEquals((long[])rds_bdi_seq_errors, (long[])item_.getRds_bdi_seq_errors());
        Assert.assertArrayEquals((long[])rds_bdi_waits, (long[])item_.getRds_bdi_waits());
        Assert.assertArrayEquals((long[])rds_discards, (long[])item_.getRds_discards());
        Assert.assertArrayEquals((long[])rds_no_event, (long[])item_.getRds_no_event());
        Assert.assertArrayEquals((long[])rds_wakes, (long[])item_.getRds_wakes());
        Assert.assertArrayEquals((long[])rms_in_reset, (long[])item_.getRms_in_reset());
        Assert.assertArrayEquals((long[])rms_inv_tids, (long[])item_.getRms_inv_tids());
        Assert.assertArrayEquals((long[])rms_link_down, (long[])item_.getRms_link_down());
        Assert.assertArrayEquals((long[])rms_lists_posted, (long[])item_.getRms_lists_posted());
        Assert.assertArrayEquals((long[])rms_ops_posted, (long[])item_.getRms_ops_posted());
        Assert.assertArrayEquals((long[])rms_orphans, (long[])item_.getRms_orphans());
        Assert.assertArrayEquals((long[])rms_probes, (long[])item_.getRms_probes());
        Assert.assertArrayEquals((long[])rms_responses, (long[])item_.getRms_responses());
        Assert.assertArrayEquals((long[])rms_rundowns, (long[])item_.getRms_rundowns());
        Assert.assertArrayEquals((long[])rms_tid_hwm, (long[])item_.getRms_tid_hwm());
        Assert.assertArrayEquals((long[])rms_unopened, (long[])item_.getRms_unopened());
        Assert.assertArrayEquals((long[])rms_waits, (long[])item_.getRms_waits());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.8492515683174133;
        double freeFraction = 0.568788468837738;
        double freeSpace = 0.5195092558860779;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Sum_TrendingTelemetry() throws Exception {
        long driver_errors = 988L;
        long firmware_cell_errors = 117L;
        long firmware_link_down = 298L;
        long firmware_link_errors = 781L;
        long firmware_overflow_local0 = 641L;
        long firmware_overflow_local1 = 58L;
        long firmware_overflow_local2 = 140L;
        long firmware_overflow_remote0 = 193L;
        long firmware_overflow_remote1 = 500L;
        long firmware_overflow_remote2 = 716L;
        long firmware_rx_errors = 894L;
        long firmware_tx_errors = 78L;
        long rds_bdi_nulls = 781L;
        long rds_bdi_overflows = 247L;
        long rds_bdi_seq_errors = 287L;
        long rds_discards = 679L;
        long rds_no_event = 459L;
        long rms_in_reset = 152L;
        long rms_inv_tids = 206L;
        long rms_link_down = 853L;
        long rms_orphans = 438L;
        long rms_unopened = 143L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Sum_TrendingTelemetry(driver_errors, firmware_cell_errors, firmware_link_down, firmware_link_errors, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_rx_errors, firmware_tx_errors, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_discards, rds_no_event, rms_in_reset, rms_inv_tids, rms_link_down, rms_orphans, rms_unopened));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Sum_TrendingTelemetry));
        Daq_monitor_Sum_TrendingTelemetry item_ = (Daq_monitor_Sum_TrendingTelemetry)item;
        Assert.assertEquals((long)driver_errors, (long)item_.getDriver_errors());
        Assert.assertEquals((long)firmware_cell_errors, (long)item_.getFirmware_cell_errors());
        Assert.assertEquals((long)firmware_link_down, (long)item_.getFirmware_link_down());
        Assert.assertEquals((long)firmware_link_errors, (long)item_.getFirmware_link_errors());
        Assert.assertEquals((long)firmware_overflow_local0, (long)item_.getFirmware_overflow_local0());
        Assert.assertEquals((long)firmware_overflow_local1, (long)item_.getFirmware_overflow_local1());
        Assert.assertEquals((long)firmware_overflow_local2, (long)item_.getFirmware_overflow_local2());
        Assert.assertEquals((long)firmware_overflow_remote0, (long)item_.getFirmware_overflow_remote0());
        Assert.assertEquals((long)firmware_overflow_remote1, (long)item_.getFirmware_overflow_remote1());
        Assert.assertEquals((long)firmware_overflow_remote2, (long)item_.getFirmware_overflow_remote2());
        Assert.assertEquals((long)firmware_rx_errors, (long)item_.getFirmware_rx_errors());
        Assert.assertEquals((long)firmware_tx_errors, (long)item_.getFirmware_tx_errors());
        Assert.assertEquals((long)rds_bdi_nulls, (long)item_.getRds_bdi_nulls());
        Assert.assertEquals((long)rds_bdi_overflows, (long)item_.getRds_bdi_overflows());
        Assert.assertEquals((long)rds_bdi_seq_errors, (long)item_.getRds_bdi_seq_errors());
        Assert.assertEquals((long)rds_discards, (long)item_.getRds_discards());
        Assert.assertEquals((long)rds_no_event, (long)item_.getRds_no_event());
        Assert.assertEquals((long)rms_in_reset, (long)item_.getRms_in_reset());
        Assert.assertEquals((long)rms_inv_tids, (long)item_.getRms_inv_tids());
        Assert.assertEquals((long)rms_link_down, (long)item_.getRms_link_down());
        Assert.assertEquals((long)rms_orphans, (long)item_.getRms_orphans());
        Assert.assertEquals((long)rms_unopened, (long)item_.getRms_unopened());
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)201, (int)-1214218862);
        String location = "o";
        double[] oDI = TestHelper.generateDoubleArray((int)201, (int)-483192410);
        double[] oDV = TestHelper.generateDoubleArray((int)201, (int)269934185);
        double[] oGV = TestHelper.generateDoubleArray((int)201, (int)-1963587431);
        double[] rDV = TestHelper.generateDoubleArray((int)201, (int)-1151417878);
        double[] temp = TestHelper.generateDoubleArray((int)201, (int)1123428869);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)71, (int)-1661301594);
        double[] anaV = TestHelper.generateDoubleArray((int)71, (int)292824746);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)71, (int)-1158454978);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)71, (int)-1228326570);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)71, (int)-1765003194);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)71, (int)-144751898);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)71, (int)1111382692);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)71, (int)-2051523291);
        double[] clkHI = TestHelper.generateDoubleArray((int)71, (int)330043764);
        double[] clkHV = TestHelper.generateDoubleArray((int)71, (int)-972733535);
        double[] clkLI = TestHelper.generateDoubleArray((int)71, (int)-1176208944);
        double[] clkLV = TestHelper.generateDoubleArray((int)71, (int)1180523695);
        double[] digI = TestHelper.generateDoubleArray((int)71, (int)-445102802);
        double[] digV = TestHelper.generateDoubleArray((int)71, (int)-505664975);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)71, (int)-1724136653);
        double[] htrPI = TestHelper.generateDoubleArray((int)71, (int)-691271463);
        double[] htrPV = TestHelper.generateDoubleArray((int)71, (int)1955495976);
        double[] htrV = TestHelper.generateDoubleArray((int)71, (int)-189680123);
        double[] htrW = TestHelper.generateDoubleArray((int)71, (int)394779516);
        String location = "e";
        double[] oDI = TestHelper.generateDoubleArray((int)71, (int)-70671108);
        double[] oDV = TestHelper.generateDoubleArray((int)71, (int)-2112429215);
        double[] pClk0 = TestHelper.generateDoubleArray((int)71, (int)-1809236643);
        double[] pClk1 = TestHelper.generateDoubleArray((int)71, (int)1964104274);
        double[] pClkL = TestHelper.generateDoubleArray((int)71, (int)-1943067405);
        double[] pClkU = TestHelper.generateDoubleArray((int)71, (int)-1956000866);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)1581436121);
        double[] rG0 = TestHelper.generateDoubleArray((int)71, (int)1952879357);
        double[] rG1 = TestHelper.generateDoubleArray((int)71, (int)-424457568);
        double[] rGL = TestHelper.generateDoubleArray((int)71, (int)-792763075);
        double[] rGU = TestHelper.generateDoubleArray((int)71, (int)-782870047);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)71, (int)-950831258);
        double[] ref05V = TestHelper.generateDoubleArray((int)71, (int)-1302617698);
        double[] ref125V = TestHelper.generateDoubleArray((int)71, (int)-1156992488);
        double[] ref15V = TestHelper.generateDoubleArray((int)71, (int)-216675669);
        double[] ref25V = TestHelper.generateDoubleArray((int)71, (int)261048556);
        double[] refN12 = TestHelper.generateDoubleArray((int)71, (int)1956719048);
        double[] refP12 = TestHelper.generateDoubleArray((int)71, (int)-1429653092);
        double[] sClk0 = TestHelper.generateDoubleArray((int)71, (int)823138059);
        double[] sClk1 = TestHelper.generateDoubleArray((int)71, (int)1578458428);
        double[] sClkL = TestHelper.generateDoubleArray((int)71, (int)-2079238711);
        double[] sClkU = TestHelper.generateDoubleArray((int)71, (int)-205363761);
        double[] temp1 = TestHelper.generateDoubleArray((int)71, (int)-1238664408);
        double[] temp10 = TestHelper.generateDoubleArray((int)71, (int)933948662);
        double[] temp2 = TestHelper.generateDoubleArray((int)71, (int)1894244083);
        double[] temp3 = TestHelper.generateDoubleArray((int)71, (int)-1170396013);
        double[] temp4 = TestHelper.generateDoubleArray((int)71, (int)-746348174);
        double[] temp5 = TestHelper.generateDoubleArray((int)71, (int)437790864);
        double[] temp6 = TestHelper.generateDoubleArray((int)71, (int)22118992);
        double[] temp7 = TestHelper.generateDoubleArray((int)71, (int)-138442453);
        double[] temp8 = TestHelper.generateDoubleArray((int)71, (int)179042259);
        double[] temp9 = TestHelper.generateDoubleArray((int)71, (int)383989626);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClk1, pClkL, pClkU, power, rG0, rG1, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClk0, sClk1, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk1, (double[])item_.getPClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG1, (double[])item_.getRG1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk1, (double[])item_.getSClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.5056911706924438;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6Telemetry() throws Exception {
        double rebsAverageTemp6 = 0.23912864923477173;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebsAverageTemp6Telemetry(rebsAverageTemp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6Telemetry));
        Focal_plane_RebsAverageTemp6Telemetry item_ = (Focal_plane_RebsAverageTemp6Telemetry)item;
        Assert.assertEquals((double)rebsAverageTemp6, (double)item_.getRebsAverageTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)3024, (int)715498532);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_03Telemetry() throws Exception {
        double clp_RTD_03 = 0.4819458f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_03Telemetry(clp_RTD_03));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_03Telemetry));
        Mpm_CLP_RTD_03Telemetry item_ = (Mpm_CLP_RTD_03Telemetry)item;
        Assert.assertEquals((double)clp_RTD_03, (double)item_.getClp_RTD_03(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_05Telemetry() throws Exception {
        double clp_RTD_05 = 0.6741021871566772;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_05Telemetry(clp_RTD_05));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_05Telemetry));
        Mpm_CLP_RTD_05Telemetry item_ = (Mpm_CLP_RTD_05Telemetry)item;
        Assert.assertEquals((double)clp_RTD_05, (double)item_.getClp_RTD_05(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_50Telemetry() throws Exception {
        double clp_RTD_50 = 0.4447600245475769;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_50Telemetry(clp_RTD_50));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_50Telemetry));
        Mpm_CLP_RTD_50Telemetry item_ = (Mpm_CLP_RTD_50Telemetry)item;
        Assert.assertEquals((double)clp_RTD_50, (double)item_.getClp_RTD_50(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_55Telemetry() throws Exception {
        double clp_RTD_55 = 0.13119518756866455;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_55Telemetry(clp_RTD_55));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_55Telemetry));
        Mpm_CLP_RTD_55Telemetry item_ = (Mpm_CLP_RTD_55Telemetry)item;
        Assert.assertEquals((double)clp_RTD_55, (double)item_.getClp_RTD_55(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_12Telemetry() throws Exception {
        double cyp_RTD_12 = 0.960231363773346;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_12Telemetry(cyp_RTD_12));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_12Telemetry));
        Mpm_CYP_RTD_12Telemetry item_ = (Mpm_CYP_RTD_12Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_12, (double)item_.getCyp_RTD_12(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_14Telemetry() throws Exception {
        double cyp_RTD_14 = 0.843854f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_14Telemetry(cyp_RTD_14));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_14Telemetry));
        Mpm_CYP_RTD_14Telemetry item_ = (Mpm_CYP_RTD_14Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_14, (double)item_.getCyp_RTD_14(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_31Telemetry() throws Exception {
        double cyp_RTD_31 = 0.42749232053756714;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_31Telemetry(cyp_RTD_31));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_31Telemetry));
        Mpm_CYP_RTD_31Telemetry item_ = (Mpm_CYP_RTD_31Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_31, (double)item_.getCyp_RTD_31(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_43Telemetry() throws Exception {
        double cyp_RTD_43 = 0.6913027763366699;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_43Telemetry(cyp_RTD_43));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_43Telemetry));
        Mpm_CYP_RTD_43Telemetry item_ = (Mpm_CYP_RTD_43Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_43, (double)item_.getCyp_RTD_43(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Autochanger_AutochangerTrucks_TrendingTelemetry() throws Exception {
        boolean actruckxminus_handoffInError = false;
        boolean actruckxminus_handoffSensorValue = true;
        boolean actruckxminus_onlineInError = false;
        boolean actruckxminus_onlineSensorValue = false;
        boolean actruckxminus_standbyInError = false;
        boolean actruckxminus_standbySensorValue = false;
        boolean actruckxplus_handoffInError = true;
        boolean actruckxplus_handoffSensorValue = false;
        boolean actruckxplus_onlineInError = false;
        boolean actruckxplus_onlineSensorValue = false;
        boolean actruckxplus_standbyInError = false;
        boolean actruckxplus_standbySensorValue = false;
        boolean atHandoff = false;
        boolean atOnline = true;
        boolean atStandby = true;
        int driverPosition = 127;
        int followerPosition = 435;
        boolean homingDone = false;
        boolean inError = true;
        int proximityDistance = 290;
        double proximityVoltage = 0.1907169222831726;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry(actruckxminus_handoffInError, actruckxminus_handoffSensorValue, actruckxminus_onlineInError, actruckxminus_onlineSensorValue, actruckxminus_standbyInError, actruckxminus_standbySensorValue, actruckxplus_handoffInError, actruckxplus_handoffSensorValue, actruckxplus_onlineInError, actruckxplus_onlineSensorValue, actruckxplus_standbyInError, actruckxplus_standbySensorValue, atHandoff, atOnline, atStandby, driverPosition, followerPosition, homingDone, inError, proximityDistance, proximityVoltage));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry));
        Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry item_ = (Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry)item;
        Assert.assertEquals((Object)actruckxminus_handoffInError, (Object)item_.isActruckxminus_handoffInError());
        Assert.assertEquals((Object)actruckxminus_handoffSensorValue, (Object)item_.isActruckxminus_handoffSensorValue());
        Assert.assertEquals((Object)actruckxminus_onlineInError, (Object)item_.isActruckxminus_onlineInError());
        Assert.assertEquals((Object)actruckxminus_onlineSensorValue, (Object)item_.isActruckxminus_onlineSensorValue());
        Assert.assertEquals((Object)actruckxminus_standbyInError, (Object)item_.isActruckxminus_standbyInError());
        Assert.assertEquals((Object)actruckxminus_standbySensorValue, (Object)item_.isActruckxminus_standbySensorValue());
        Assert.assertEquals((Object)actruckxplus_handoffInError, (Object)item_.isActruckxplus_handoffInError());
        Assert.assertEquals((Object)actruckxplus_handoffSensorValue, (Object)item_.isActruckxplus_handoffSensorValue());
        Assert.assertEquals((Object)actruckxplus_onlineInError, (Object)item_.isActruckxplus_onlineInError());
        Assert.assertEquals((Object)actruckxplus_onlineSensorValue, (Object)item_.isActruckxplus_onlineSensorValue());
        Assert.assertEquals((Object)actruckxplus_standbyInError, (Object)item_.isActruckxplus_standbyInError());
        Assert.assertEquals((Object)actruckxplus_standbySensorValue, (Object)item_.isActruckxplus_standbySensorValue());
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atOnline, (Object)item_.isAtOnline());
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((long)driverPosition, (long)item_.getDriverPosition());
        Assert.assertEquals((long)followerPosition, (long)item_.getFollowerPosition());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)proximityDistance, (long)item_.getProximityDistance());
        Assert.assertEquals((double)proximityVoltage, (double)item_.getProximityVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Autochanger_Latches_TrendingTelemetry() throws Exception {
        int filterId = 127;
        String filterName = "e";
        String filterPresenceStatus = "d";
        boolean latchxminus_filterEngagedSensorsInError = false;
        boolean latchxminus_filterPresenceSensorOn = true;
        boolean latchxminus_inError = false;
        boolean latchxminus_lockSensorOn = true;
        boolean latchxminus_lockSensorsInError = false;
        String latchxminus_lockStatus = "l";
        boolean latchxminus_unlockSensorOn = true;
        boolean latchxminus_unlockSensorsInError = true;
        boolean latchxplus_filterEngagedSensorsInError = true;
        boolean latchxplus_filterPresenceSensorOn = false;
        boolean latchxplus_inError = true;
        boolean latchxplus_lockSensorOn = true;
        boolean latchxplus_lockSensorsInError = false;
        String latchxplus_lockStatus = "";
        boolean latchxplus_unlockSensorOn = true;
        boolean latchxplus_unlockSensorsInError = true;
        String lockStatus = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_Latches_TrendingTelemetry(filterId, filterName, filterPresenceStatus, latchxminus_filterEngagedSensorsInError, latchxminus_filterPresenceSensorOn, latchxminus_inError, latchxminus_lockSensorOn, latchxminus_lockSensorsInError, latchxminus_lockStatus, latchxminus_unlockSensorOn, latchxminus_unlockSensorsInError, latchxplus_filterEngagedSensorsInError, latchxplus_filterPresenceSensorOn, latchxplus_inError, latchxplus_lockSensorOn, latchxplus_lockSensorsInError, latchxplus_lockStatus, latchxplus_unlockSensorOn, latchxplus_unlockSensorsInError, lockStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_Latches_TrendingTelemetry));
        Fcs_Autochanger_Latches_TrendingTelemetry item_ = (Fcs_Autochanger_Latches_TrendingTelemetry)item;
        Assert.assertEquals((long)filterId, (long)item_.getFilterId());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((Object)latchxminus_filterEngagedSensorsInError, (Object)item_.isLatchxminus_filterEngagedSensorsInError());
        Assert.assertEquals((Object)latchxminus_filterPresenceSensorOn, (Object)item_.isLatchxminus_filterPresenceSensorOn());
        Assert.assertEquals((Object)latchxminus_inError, (Object)item_.isLatchxminus_inError());
        Assert.assertEquals((Object)latchxminus_lockSensorOn, (Object)item_.isLatchxminus_lockSensorOn());
        Assert.assertEquals((Object)latchxminus_lockSensorsInError, (Object)item_.isLatchxminus_lockSensorsInError());
        Assert.assertEquals((Object)latchxminus_lockStatus, (Object)item_.getLatchxminus_lockStatus());
        Assert.assertEquals((Object)latchxminus_unlockSensorOn, (Object)item_.isLatchxminus_unlockSensorOn());
        Assert.assertEquals((Object)latchxminus_unlockSensorsInError, (Object)item_.isLatchxminus_unlockSensorsInError());
        Assert.assertEquals((Object)latchxplus_filterEngagedSensorsInError, (Object)item_.isLatchxplus_filterEngagedSensorsInError());
        Assert.assertEquals((Object)latchxplus_filterPresenceSensorOn, (Object)item_.isLatchxplus_filterPresenceSensorOn());
        Assert.assertEquals((Object)latchxplus_inError, (Object)item_.isLatchxplus_inError());
        Assert.assertEquals((Object)latchxplus_lockSensorOn, (Object)item_.isLatchxplus_lockSensorOn());
        Assert.assertEquals((Object)latchxplus_lockSensorsInError, (Object)item_.isLatchxplus_lockSensorsInError());
        Assert.assertEquals((Object)latchxplus_lockStatus, (Object)item_.getLatchxplus_lockStatus());
        Assert.assertEquals((Object)latchxplus_unlockSensorOn, (Object)item_.isLatchxplus_unlockSensorOn());
        Assert.assertEquals((Object)latchxplus_unlockSensorsInError, (Object)item_.isLatchxplus_unlockSensorsInError());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
    }

    @Test
    public void sendReceiveFcs_Autochanger_OnlineClamps_TrendingTelemetry() throws Exception {
        String lockStatus = "m";
        int onlineClampRawStrain = 800;
        int onlineClampStrain = 29;
        int onlineclampxminus_current = 495;
        boolean onlineclampxminus_inError = true;
        boolean onlineclampxminus_lockSensorInError = true;
        boolean onlineclampxminus_lockSensorOn = false;
        String onlineclampxminus_lockStatus = "c";
        int onlineclampxminus_position = 86;
        int onlineclampxminus_sentCurrent = 219;
        boolean onlineclampxminus_unlockSensorInError = false;
        boolean onlineclampxminus_unlockSensorOn = false;
        int onlineclampxplus_current = 202;
        boolean onlineclampxplus_inError = false;
        boolean onlineclampxplus_lockSensorInError = false;
        boolean onlineclampxplus_lockSensorOn = false;
        String onlineclampxplus_lockStatus = "u";
        int onlineclampxplus_position = 210;
        int onlineclampxplus_sentCurrent = 994;
        boolean onlineclampxplus_unlockSensorInError = false;
        boolean onlineclampxplus_unlockSensorOn = true;
        int onlineclampyminus_current = 546;
        boolean onlineclampyminus_inError = false;
        boolean onlineclampyminus_lockSensorInError = false;
        boolean onlineclampyminus_lockSensorOn = false;
        String onlineclampyminus_lockStatus = "";
        int onlineclampyminus_position = 386;
        int onlineclampyminus_sentCurrent = 455;
        boolean onlineclampyminus_unlockSensorInError = false;
        boolean onlineclampyminus_unlockSensorOn = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_OnlineClamps_TrendingTelemetry(lockStatus, onlineClampRawStrain, onlineClampStrain, onlineclampxminus_current, onlineclampxminus_inError, onlineclampxminus_lockSensorInError, onlineclampxminus_lockSensorOn, onlineclampxminus_lockStatus, onlineclampxminus_position, onlineclampxminus_sentCurrent, onlineclampxminus_unlockSensorInError, onlineclampxminus_unlockSensorOn, onlineclampxplus_current, onlineclampxplus_inError, onlineclampxplus_lockSensorInError, onlineclampxplus_lockSensorOn, onlineclampxplus_lockStatus, onlineclampxplus_position, onlineclampxplus_sentCurrent, onlineclampxplus_unlockSensorInError, onlineclampxplus_unlockSensorOn, onlineclampyminus_current, onlineclampyminus_inError, onlineclampyminus_lockSensorInError, onlineclampyminus_lockSensorOn, onlineclampyminus_lockStatus, onlineclampyminus_position, onlineclampyminus_sentCurrent, onlineclampyminus_unlockSensorInError, onlineclampyminus_unlockSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_OnlineClamps_TrendingTelemetry));
        Fcs_Autochanger_OnlineClamps_TrendingTelemetry item_ = (Fcs_Autochanger_OnlineClamps_TrendingTelemetry)item;
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((long)onlineClampRawStrain, (long)item_.getOnlineClampRawStrain());
        Assert.assertEquals((long)onlineClampStrain, (long)item_.getOnlineClampStrain());
        Assert.assertEquals((long)onlineclampxminus_current, (long)item_.getOnlineclampxminus_current());
        Assert.assertEquals((Object)onlineclampxminus_inError, (Object)item_.isOnlineclampxminus_inError());
        Assert.assertEquals((Object)onlineclampxminus_lockSensorInError, (Object)item_.isOnlineclampxminus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampxminus_lockSensorOn, (Object)item_.isOnlineclampxminus_lockSensorOn());
        Assert.assertEquals((Object)onlineclampxminus_lockStatus, (Object)item_.getOnlineclampxminus_lockStatus());
        Assert.assertEquals((long)onlineclampxminus_position, (long)item_.getOnlineclampxminus_position());
        Assert.assertEquals((long)onlineclampxminus_sentCurrent, (long)item_.getOnlineclampxminus_sentCurrent());
        Assert.assertEquals((Object)onlineclampxminus_unlockSensorInError, (Object)item_.isOnlineclampxminus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampxminus_unlockSensorOn, (Object)item_.isOnlineclampxminus_unlockSensorOn());
        Assert.assertEquals((long)onlineclampxplus_current, (long)item_.getOnlineclampxplus_current());
        Assert.assertEquals((Object)onlineclampxplus_inError, (Object)item_.isOnlineclampxplus_inError());
        Assert.assertEquals((Object)onlineclampxplus_lockSensorInError, (Object)item_.isOnlineclampxplus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampxplus_lockSensorOn, (Object)item_.isOnlineclampxplus_lockSensorOn());
        Assert.assertEquals((Object)onlineclampxplus_lockStatus, (Object)item_.getOnlineclampxplus_lockStatus());
        Assert.assertEquals((long)onlineclampxplus_position, (long)item_.getOnlineclampxplus_position());
        Assert.assertEquals((long)onlineclampxplus_sentCurrent, (long)item_.getOnlineclampxplus_sentCurrent());
        Assert.assertEquals((Object)onlineclampxplus_unlockSensorInError, (Object)item_.isOnlineclampxplus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampxplus_unlockSensorOn, (Object)item_.isOnlineclampxplus_unlockSensorOn());
        Assert.assertEquals((long)onlineclampyminus_current, (long)item_.getOnlineclampyminus_current());
        Assert.assertEquals((Object)onlineclampyminus_inError, (Object)item_.isOnlineclampyminus_inError());
        Assert.assertEquals((Object)onlineclampyminus_lockSensorInError, (Object)item_.isOnlineclampyminus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampyminus_lockSensorOn, (Object)item_.isOnlineclampyminus_lockSensorOn());
        Assert.assertEquals((Object)onlineclampyminus_lockStatus, (Object)item_.getOnlineclampyminus_lockStatus());
        Assert.assertEquals((long)onlineclampyminus_position, (long)item_.getOnlineclampyminus_position());
        Assert.assertEquals((long)onlineclampyminus_sentCurrent, (long)item_.getOnlineclampyminus_sentCurrent());
        Assert.assertEquals((Object)onlineclampyminus_unlockSensorInError, (Object)item_.isOnlineclampyminus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampyminus_unlockSensorOn, (Object)item_.isOnlineclampyminus_unlockSensorOn());
    }

    @Test
    public void sendReceiveFcs_Autochanger_Temperatures_TrendingTelemetry() throws Exception {
        double cellXMinus = 0.2588575482368469;
        double clampMotorXMinus = 0.4140317440032959;
        double clampMotorXPlus = 0.2945793867111206;
        double clampMotorYMinus = 0.257636f;
        double frontBox = 0.5191508531570435;
        double linearRailMotorXMinus = 0.6298286318778992;
        double linearRailMotorXPlus = 0.11642175912857056;
        double rearBox = 0.007060587406158447;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_Temperatures_TrendingTelemetry(cellXMinus, clampMotorXMinus, clampMotorXPlus, clampMotorYMinus, frontBox, linearRailMotorXMinus, linearRailMotorXPlus, rearBox));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_Temperatures_TrendingTelemetry));
        Fcs_Autochanger_Temperatures_TrendingTelemetry item_ = (Fcs_Autochanger_Temperatures_TrendingTelemetry)item;
        Assert.assertEquals((double)cellXMinus, (double)item_.getCellXMinus(), (double)1.0E-6f);
        Assert.assertEquals((double)clampMotorXMinus, (double)item_.getClampMotorXMinus(), (double)1.0E-6f);
        Assert.assertEquals((double)clampMotorXPlus, (double)item_.getClampMotorXPlus(), (double)1.0E-6f);
        Assert.assertEquals((double)clampMotorYMinus, (double)item_.getClampMotorYMinus(), (double)1.0E-6f);
        Assert.assertEquals((double)frontBox, (double)item_.getFrontBox(), (double)1.0E-6f);
        Assert.assertEquals((double)linearRailMotorXMinus, (double)item_.getLinearRailMotorXMinus(), (double)1.0E-6f);
        Assert.assertEquals((double)linearRailMotorXPlus, (double)item_.getLinearRailMotorXPlus(), (double)1.0E-6f);
        Assert.assertEquals((double)rearBox, (double)item_.getRearBox(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Autochanger_TrendingTelemetry() throws Exception {
        String id = "x";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_TrendingTelemetry(id));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_TrendingTelemetry));
        Fcs_Autochanger_TrendingTelemetry item_ = (Fcs_Autochanger_TrendingTelemetry)item;
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcSensorsGateway_TrendingTelemetry() throws Exception {
        int carouselHoldingFilterSensor0 = 548;
        int carouselHoldingFilterSensor1 = 609;
        int carouselStoppedAtStandby = 258;
        int carouselStoppedAtStandbyC = 767;
        int carousel_CF0 = 254;
        int carousel_CF0_C = 960;
        int carousel_CF1 = 626;
        int carousel_CF1_C = 72;
        int closeSensorBLatchXminus = 991;
        int closeSensorBLatchXplus = 235;
        int closeSensorLatchXminus = 97;
        int closeSensorLatchXplus = 950;
        int engineeringKey = 666;
        int engineeringkey_C = 75;
        int filterEngagedSensorBLatchXminus = 963;
        int filterEngagedSensorBLatchXplus = 936;
        int filterEngagedSensorLatchXminus = 899;
        int filterEngagedSensorLatchXplus = 907;
        int filterIDSensor0 = 255;
        int filterIDSensor1 = 607;
        int filterIDSensor2 = 806;
        int filterIDSensor3 = 94;
        int filterIDSensor4 = 314;
        int filterIDSensor5 = 181;
        int handoffPositionSensorBXminus = 56;
        int handoffPositionSensorBXplus = 165;
        int handoffPositionSensorXminus = 802;
        int handoffPositionSensorXplus = 756;
        double inclinometerXminus = 0.30402427911758423;
        double inclinometerXplus = 0.3182897f;
        int loaderConnectedSensor = 813;
        int loaderConnectedSensorC = 132;
        int loaderHoldingFilterSensor0 = 854;
        int loaderHoldingFilterSensor1 = 273;
        int lockOut = 63;
        int lockOutShunt = 799;
        int lockout_C = 912;
        int lpmLatchesStatus = 145;
        int lpmLinearRail1Status = 977;
        int lpmLinearRail2Status = 869;
        int lpmOnlineClampsStatus = 573;
        int out_AF0 = 63;
        int out_AF0_C = 663;
        int out_AF1 = 592;
        int out_AF1_C = 954;
        int out_AF3 = 355;
        int out_AF3_C = 722;
        int out_AIN = 851;
        int out_AOL = 115;
        int out_AP1 = 378;
        int out_AP1_C = 252;
        int out_AP2 = 76;
        int out_AP2_C = 244;
        int out_AP3 = 847;
        int out_AP3_C = 675;
        int onlineClampXminusCloseSensor = 386;
        int onlineClampXminusCloseSensorC = 757;
        int onlineClampXminusOpenSensor = 783;
        int onlineClampXminusOpenSensorC = 540;
        int onlineClampXplusCloseSensor = 173;
        int onlineClampXplusCloseSensorC = 707;
        int onlineClampXplusOpenSensor = 535;
        int onlineClampXplusOpenSensorC = 561;
        int onlineClampYminusCloseSensor = 393;
        int onlineClampYminusCloseSensorC = 827;
        int onlineClampYminusOpenSensor = 556;
        int onlineClampYminusOpenSensorC = 85;
        int onlinePositionSensorBXminus = 574;
        int onlinePositionSensorBXplus = 850;
        int onlinePositionSensorXminus = 935;
        int onlinePositionSensorXplus = 491;
        int openSensorBLatchXminus = 976;
        int openSensorBLatchXplus = 592;
        int openSensorLatchXminus = 731;
        int openSensorLatchXplus = 23;
        int presenceLoader = 77;
        int presenceloader_C = 835;
        int standbyPositionSensorBXminus = 292;
        int standbyPositionSensorBXplus = 756;
        int standbyPositionSensorXminus = 992;
        int standbyPositionSensorXplus = 760;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry(carouselHoldingFilterSensor0, carouselHoldingFilterSensor1, carouselStoppedAtStandby, carouselStoppedAtStandbyC, carousel_CF0, carousel_CF0_C, carousel_CF1, carousel_CF1_C, closeSensorBLatchXminus, closeSensorBLatchXplus, closeSensorLatchXminus, closeSensorLatchXplus, engineeringKey, engineeringkey_C, filterEngagedSensorBLatchXminus, filterEngagedSensorBLatchXplus, filterEngagedSensorLatchXminus, filterEngagedSensorLatchXplus, filterIDSensor0, filterIDSensor1, filterIDSensor2, filterIDSensor3, filterIDSensor4, filterIDSensor5, handoffPositionSensorBXminus, handoffPositionSensorBXplus, handoffPositionSensorXminus, handoffPositionSensorXplus, inclinometerXminus, inclinometerXplus, loaderConnectedSensor, loaderConnectedSensorC, loaderHoldingFilterSensor0, loaderHoldingFilterSensor1, lockOut, lockOutShunt, lockout_C, lpmLatchesStatus, lpmLinearRail1Status, lpmLinearRail2Status, lpmOnlineClampsStatus, out_AF0, out_AF0_C, out_AF1, out_AF1_C, out_AF3, out_AF3_C, out_AIN, out_AOL, out_AP1, out_AP1_C, out_AP2, out_AP2_C, out_AP3, out_AP3_C, onlineClampXminusCloseSensor, onlineClampXminusCloseSensorC, onlineClampXminusOpenSensor, onlineClampXminusOpenSensorC, onlineClampXplusCloseSensor, onlineClampXplusCloseSensorC, onlineClampXplusOpenSensor, onlineClampXplusOpenSensorC, onlineClampYminusCloseSensor, onlineClampYminusCloseSensorC, onlineClampYminusOpenSensor, onlineClampYminusOpenSensorC, onlinePositionSensorBXminus, onlinePositionSensorBXplus, onlinePositionSensorXminus, onlinePositionSensorXplus, openSensorBLatchXminus, openSensorBLatchXplus, openSensorLatchXminus, openSensorLatchXplus, presenceLoader, presenceloader_C, standbyPositionSensorBXminus, standbyPositionSensorBXplus, standbyPositionSensorXminus, standbyPositionSensorXplus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry));
        Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry item_ = (Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)carouselHoldingFilterSensor0, (long)item_.getCarouselHoldingFilterSensor0());
        Assert.assertEquals((long)carouselHoldingFilterSensor1, (long)item_.getCarouselHoldingFilterSensor1());
        Assert.assertEquals((long)carouselStoppedAtStandby, (long)item_.getCarouselStoppedAtStandby());
        Assert.assertEquals((long)carouselStoppedAtStandbyC, (long)item_.getCarouselStoppedAtStandbyC());
        Assert.assertEquals((long)carousel_CF0, (long)item_.getCarousel_CF0());
        Assert.assertEquals((long)carousel_CF0_C, (long)item_.getCarousel_CF0_C());
        Assert.assertEquals((long)carousel_CF1, (long)item_.getCarousel_CF1());
        Assert.assertEquals((long)carousel_CF1_C, (long)item_.getCarousel_CF1_C());
        Assert.assertEquals((long)closeSensorBLatchXminus, (long)item_.getCloseSensorBLatchXminus());
        Assert.assertEquals((long)closeSensorBLatchXplus, (long)item_.getCloseSensorBLatchXplus());
        Assert.assertEquals((long)closeSensorLatchXminus, (long)item_.getCloseSensorLatchXminus());
        Assert.assertEquals((long)closeSensorLatchXplus, (long)item_.getCloseSensorLatchXplus());
        Assert.assertEquals((long)engineeringKey, (long)item_.getEngineeringKey());
        Assert.assertEquals((long)engineeringkey_C, (long)item_.getEngineeringkey_C());
        Assert.assertEquals((long)filterEngagedSensorBLatchXminus, (long)item_.getFilterEngagedSensorBLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorBLatchXplus, (long)item_.getFilterEngagedSensorBLatchXplus());
        Assert.assertEquals((long)filterEngagedSensorLatchXminus, (long)item_.getFilterEngagedSensorLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorLatchXplus, (long)item_.getFilterEngagedSensorLatchXplus());
        Assert.assertEquals((long)filterIDSensor0, (long)item_.getFilterIDSensor0());
        Assert.assertEquals((long)filterIDSensor1, (long)item_.getFilterIDSensor1());
        Assert.assertEquals((long)filterIDSensor2, (long)item_.getFilterIDSensor2());
        Assert.assertEquals((long)filterIDSensor3, (long)item_.getFilterIDSensor3());
        Assert.assertEquals((long)filterIDSensor4, (long)item_.getFilterIDSensor4());
        Assert.assertEquals((long)filterIDSensor5, (long)item_.getFilterIDSensor5());
        Assert.assertEquals((long)handoffPositionSensorBXminus, (long)item_.getHandoffPositionSensorBXminus());
        Assert.assertEquals((long)handoffPositionSensorBXplus, (long)item_.getHandoffPositionSensorBXplus());
        Assert.assertEquals((long)handoffPositionSensorXminus, (long)item_.getHandoffPositionSensorXminus());
        Assert.assertEquals((long)handoffPositionSensorXplus, (long)item_.getHandoffPositionSensorXplus());
        Assert.assertEquals((double)inclinometerXminus, (double)item_.getInclinometerXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinometerXplus, (double)item_.getInclinometerXplus(), (double)1.0E-6f);
        Assert.assertEquals((long)loaderConnectedSensor, (long)item_.getLoaderConnectedSensor());
        Assert.assertEquals((long)loaderConnectedSensorC, (long)item_.getLoaderConnectedSensorC());
        Assert.assertEquals((long)loaderHoldingFilterSensor0, (long)item_.getLoaderHoldingFilterSensor0());
        Assert.assertEquals((long)loaderHoldingFilterSensor1, (long)item_.getLoaderHoldingFilterSensor1());
        Assert.assertEquals((long)lockOut, (long)item_.getLockOut());
        Assert.assertEquals((long)lockOutShunt, (long)item_.getLockOutShunt());
        Assert.assertEquals((long)lockout_C, (long)item_.getLockout_C());
        Assert.assertEquals((long)lpmLatchesStatus, (long)item_.getLpmLatchesStatus());
        Assert.assertEquals((long)lpmLinearRail1Status, (long)item_.getLpmLinearRail1Status());
        Assert.assertEquals((long)lpmLinearRail2Status, (long)item_.getLpmLinearRail2Status());
        Assert.assertEquals((long)lpmOnlineClampsStatus, (long)item_.getLpmOnlineClampsStatus());
        Assert.assertEquals((long)out_AF0, (long)item_.getOut_AF0());
        Assert.assertEquals((long)out_AF0_C, (long)item_.getOut_AF0_C());
        Assert.assertEquals((long)out_AF1, (long)item_.getOut_AF1());
        Assert.assertEquals((long)out_AF1_C, (long)item_.getOut_AF1_C());
        Assert.assertEquals((long)out_AF3, (long)item_.getOut_AF3());
        Assert.assertEquals((long)out_AF3_C, (long)item_.getOut_AF3_C());
        Assert.assertEquals((long)out_AIN, (long)item_.getOut_AIN());
        Assert.assertEquals((long)out_AOL, (long)item_.getOut_AOL());
        Assert.assertEquals((long)out_AP1, (long)item_.getOut_AP1());
        Assert.assertEquals((long)out_AP1_C, (long)item_.getOut_AP1_C());
        Assert.assertEquals((long)out_AP2, (long)item_.getOut_AP2());
        Assert.assertEquals((long)out_AP2_C, (long)item_.getOut_AP2_C());
        Assert.assertEquals((long)out_AP3, (long)item_.getOut_AP3());
        Assert.assertEquals((long)out_AP3_C, (long)item_.getOut_AP3_C());
        Assert.assertEquals((long)onlineClampXminusCloseSensor, (long)item_.getOnlineClampXminusCloseSensor());
        Assert.assertEquals((long)onlineClampXminusCloseSensorC, (long)item_.getOnlineClampXminusCloseSensorC());
        Assert.assertEquals((long)onlineClampXminusOpenSensor, (long)item_.getOnlineClampXminusOpenSensor());
        Assert.assertEquals((long)onlineClampXminusOpenSensorC, (long)item_.getOnlineClampXminusOpenSensorC());
        Assert.assertEquals((long)onlineClampXplusCloseSensor, (long)item_.getOnlineClampXplusCloseSensor());
        Assert.assertEquals((long)onlineClampXplusCloseSensorC, (long)item_.getOnlineClampXplusCloseSensorC());
        Assert.assertEquals((long)onlineClampXplusOpenSensor, (long)item_.getOnlineClampXplusOpenSensor());
        Assert.assertEquals((long)onlineClampXplusOpenSensorC, (long)item_.getOnlineClampXplusOpenSensorC());
        Assert.assertEquals((long)onlineClampYminusCloseSensor, (long)item_.getOnlineClampYminusCloseSensor());
        Assert.assertEquals((long)onlineClampYminusCloseSensorC, (long)item_.getOnlineClampYminusCloseSensorC());
        Assert.assertEquals((long)onlineClampYminusOpenSensor, (long)item_.getOnlineClampYminusOpenSensor());
        Assert.assertEquals((long)onlineClampYminusOpenSensorC, (long)item_.getOnlineClampYminusOpenSensorC());
        Assert.assertEquals((long)onlinePositionSensorBXminus, (long)item_.getOnlinePositionSensorBXminus());
        Assert.assertEquals((long)onlinePositionSensorBXplus, (long)item_.getOnlinePositionSensorBXplus());
        Assert.assertEquals((long)onlinePositionSensorXminus, (long)item_.getOnlinePositionSensorXminus());
        Assert.assertEquals((long)onlinePositionSensorXplus, (long)item_.getOnlinePositionSensorXplus());
        Assert.assertEquals((long)openSensorBLatchXminus, (long)item_.getOpenSensorBLatchXminus());
        Assert.assertEquals((long)openSensorBLatchXplus, (long)item_.getOpenSensorBLatchXplus());
        Assert.assertEquals((long)openSensorLatchXminus, (long)item_.getOpenSensorLatchXminus());
        Assert.assertEquals((long)openSensorLatchXplus, (long)item_.getOpenSensorLatchXplus());
        Assert.assertEquals((long)presenceLoader, (long)item_.getPresenceLoader());
        Assert.assertEquals((long)presenceloader_C, (long)item_.getPresenceloader_C());
        Assert.assertEquals((long)standbyPositionSensorBXminus, (long)item_.getStandbyPositionSensorBXminus());
        Assert.assertEquals((long)standbyPositionSensorBXplus, (long)item_.getStandbyPositionSensorBXplus());
        Assert.assertEquals((long)standbyPositionSensorXminus, (long)item_.getStandbyPositionSensorXminus());
        Assert.assertEquals((long)standbyPositionSensorXplus, (long)item_.getStandbyPositionSensorXplus());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcTruckXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 150;
        boolean brakeActivated = true;
        int current = 322;
        int errorHistoryNB = 348;
        String errorRegister = "";
        int followingError = 271;
        boolean inError = false;
        int lastErrorCode = 248;
        String lastErrorName = "x";
        String mode = "t";
        int position = 305;
        long profileAcceleration = 50L;
        long profileDeceleration = 867L;
        long profileVelocity = 873L;
        String state = "k";
        int velocity = 872;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry));
        Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcTruckXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 906;
        boolean brakeActivated = false;
        int current = 747;
        int errorHistoryNB = 116;
        String errorRegister = "t";
        int followingError = 733;
        boolean inError = true;
        int lastErrorCode = 427;
        String lastErrorName = "p";
        String mode = "";
        int position = 360;
        long profileAcceleration = 147L;
        long profileDeceleration = 101L;
        long profileVelocity = 708L;
        String state = "";
        int velocity = 154;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry));
        Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Accelerobf_TrendingTelemetry() throws Exception {
        double accelerationX = 0.069516f;
        double accelerationY = 0.7235399484634399;
        double accelerationZ = 0.009542524814605713;
        double airmass = 0.8124440908432007;
        double angularVelocityX = 0.3113426f;
        double angularVelocityY = 0.7539498805999756;
        double angularVelocityZ = 0.4514995217323303;
        double azimut = 0.9094005227088928;
        double elevation = 0.5748766660690308;
        int errorHistoryNB = 149;
        String errorRegister = "b";
        double gravity = 0.25023216009140015;
        boolean inError = false;
        int lastErrorCode = 402;
        String lastErrorName = "h";
        double normalizedAccelerationX = 0.295981228351593;
        double normalizedAccelerationY = 0.8983912467956543;
        double normalizedAccelerationZ = 0.6262786388397217;
        double normalizedGravity = 0.581102f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Accelerobf_TrendingTelemetry(accelerationX, accelerationY, accelerationZ, airmass, angularVelocityX, angularVelocityY, angularVelocityZ, azimut, elevation, errorHistoryNB, errorRegister, gravity, inError, lastErrorCode, lastErrorName, normalizedAccelerationX, normalizedAccelerationY, normalizedAccelerationZ, normalizedGravity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Accelerobf_TrendingTelemetry));
        Fcs_Canbus0_Accelerobf_TrendingTelemetry item_ = (Fcs_Canbus0_Accelerobf_TrendingTelemetry)item;
        Assert.assertEquals((double)accelerationX, (double)item_.getAccelerationX(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationY, (double)item_.getAccelerationY(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationZ, (double)item_.getAccelerationZ(), (double)1.0E-6f);
        Assert.assertEquals((double)airmass, (double)item_.getAirmass(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityX, (double)item_.getAngularVelocityX(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityY, (double)item_.getAngularVelocityY(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityZ, (double)item_.getAngularVelocityZ(), (double)1.0E-6f);
        Assert.assertEquals((double)azimut, (double)item_.getAzimut(), (double)1.0E-6f);
        Assert.assertEquals((double)elevation, (double)item_.getElevation(), (double)1.0E-6f);
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((double)gravity, (double)item_.getGravity(), (double)1.0E-6f);
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((double)normalizedAccelerationX, (double)item_.getNormalizedAccelerationX(), (double)1.0E-6f);
        Assert.assertEquals((double)normalizedAccelerationY, (double)item_.getNormalizedAccelerationY(), (double)1.0E-6f);
        Assert.assertEquals((double)normalizedAccelerationZ, (double)item_.getNormalizedAccelerationZ(), (double)1.0E-6f);
        Assert.assertEquals((double)normalizedGravity, (double)item_.getNormalizedGravity(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Canbus0_Ai814_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 245;
        String errorRegister = "s";
        boolean inError = false;
        int lastErrorCode = 82;
        String lastErrorName = "y";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Ai814_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Ai814_TrendingTelemetry));
        Fcs_Canbus0_Ai814_TrendingTelemetry item_ = (Fcs_Canbus0_Ai814_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_CarouselController_TrendingTelemetry() throws Exception {
        int averageCurrent = 488;
        boolean brakeActivated = false;
        int current = 869;
        int errorHistoryNB = 485;
        String errorRegister = "";
        int followingError = 575;
        boolean inError = false;
        int lastErrorCode = 758;
        String lastErrorName = "";
        String mode = "";
        int position = 86;
        int positionSensorType = 842;
        long profileAcceleration = 339L;
        long profileDeceleration = 156L;
        long profileVelocity = 958L;
        String state = "";
        int velocity = 640;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_CarouselController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, positionSensorType, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_CarouselController_TrendingTelemetry));
        Fcs_Canbus0_CarouselController_TrendingTelemetry item_ = (Fcs_Canbus0_CarouselController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)positionSensorType, (long)item_.getPositionSensorType());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ClampXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 165;
        boolean brakeActivated = false;
        int current = 600;
        int errorHistoryNB = 805;
        String errorRegister = "";
        int followingError = 691;
        boolean inError = false;
        int lastErrorCode = 182;
        String lastErrorName = "";
        String mode = "a";
        int position = 604;
        long profileAcceleration = 390L;
        long profileDeceleration = 494L;
        long profileVelocity = 766L;
        String state = "v";
        int velocity = 390;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ClampXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ClampXminusController_TrendingTelemetry));
        Fcs_Canbus0_ClampXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_ClampXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ClampXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 611;
        boolean brakeActivated = false;
        int current = 282;
        int errorHistoryNB = 751;
        String errorRegister = "l";
        int followingError = 469;
        boolean inError = false;
        int lastErrorCode = 240;
        String lastErrorName = "j";
        String mode = "";
        int position = 331;
        long profileAcceleration = 381L;
        long profileDeceleration = 199L;
        long profileVelocity = 565L;
        String state = "h";
        int velocity = 865;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ClampXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ClampXplusController_TrendingTelemetry));
        Fcs_Canbus0_ClampXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_ClampXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Hyttc580_TrendingTelemetry() throws Exception {
        int plc_caAF3 = 683;
        int plc_caAF3b = 639;
        int plc_caAP1 = 153;
        int plc_caAP1b = 12;
        int plc_caAP2 = 491;
        int plc_caAP2b = 856;
        int plc_caAP3 = 315;
        int plc_caAP3b = 181;
        int plc_caBrakesActivated = 717;
        int plc_caCF0 = 556;
        int plc_caCF0b = 194;
        int plc_caCF1 = 50;
        int plc_caCF1b = 570;
        int plc_caCFC = 175;
        int plc_caCFCb = 857;
        int plc_caCS = 501;
        int plc_caCSb = 472;
        int plc_caEnableBrakes = 488;
        int plc_caEnableRotation = 76;
        int plc_caEnableShutter = 916;
        int plc_caEnableUnclamp = 152;
        int plc_caEng = 395;
        int plc_caEngb = 368;
        int plc_caLockout = 695;
        int plc_caLockoutb = 21;
        int plc_caShutterInactive = 920;
        int plc_caSleep = 678;
        int plc_enableShutterInterlock = 525;
        int plc_okDI = 791;
        int plc_okDIsafety = 639;
        int plc_powerSave = 47;
        int plc_tpCheckRotation = 98;
        int plc_tpStopRotation = 781;
        int plc_tpStopUnclamp = 365;
        double temperatures_averageClamps = 0.8352833986282349;
        double temperatures_internalHYTTC580 = 0.06735879182815552;
        double temperatures_socket1 = 0.1490703821182251;
        double temperatures_socket2 = 0.07591694593429565;
        double temperatures_socket3 = 0.9211373925209045;
        double temperatures_socket4 = 0.4429643750190735;
        double temperatures_socket5 = 0.9094047546386719;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Hyttc580_TrendingTelemetry(plc_caAF3, plc_caAF3b, plc_caAP1, plc_caAP1b, plc_caAP2, plc_caAP2b, plc_caAP3, plc_caAP3b, plc_caBrakesActivated, plc_caCF0, plc_caCF0b, plc_caCF1, plc_caCF1b, plc_caCFC, plc_caCFCb, plc_caCS, plc_caCSb, plc_caEnableBrakes, plc_caEnableRotation, plc_caEnableShutter, plc_caEnableUnclamp, plc_caEng, plc_caEngb, plc_caLockout, plc_caLockoutb, plc_caShutterInactive, plc_caSleep, plc_enableShutterInterlock, plc_okDI, plc_okDIsafety, plc_powerSave, plc_tpCheckRotation, plc_tpStopRotation, plc_tpStopUnclamp, temperatures_averageClamps, temperatures_internalHYTTC580, temperatures_socket1, temperatures_socket2, temperatures_socket3, temperatures_socket4, temperatures_socket5));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Hyttc580_TrendingTelemetry));
        Fcs_Canbus0_Hyttc580_TrendingTelemetry item_ = (Fcs_Canbus0_Hyttc580_TrendingTelemetry)item;
        Assert.assertEquals((long)plc_caAF3, (long)item_.getPlc_caAF3());
        Assert.assertEquals((long)plc_caAF3b, (long)item_.getPlc_caAF3b());
        Assert.assertEquals((long)plc_caAP1, (long)item_.getPlc_caAP1());
        Assert.assertEquals((long)plc_caAP1b, (long)item_.getPlc_caAP1b());
        Assert.assertEquals((long)plc_caAP2, (long)item_.getPlc_caAP2());
        Assert.assertEquals((long)plc_caAP2b, (long)item_.getPlc_caAP2b());
        Assert.assertEquals((long)plc_caAP3, (long)item_.getPlc_caAP3());
        Assert.assertEquals((long)plc_caAP3b, (long)item_.getPlc_caAP3b());
        Assert.assertEquals((long)plc_caBrakesActivated, (long)item_.getPlc_caBrakesActivated());
        Assert.assertEquals((long)plc_caCF0, (long)item_.getPlc_caCF0());
        Assert.assertEquals((long)plc_caCF0b, (long)item_.getPlc_caCF0b());
        Assert.assertEquals((long)plc_caCF1, (long)item_.getPlc_caCF1());
        Assert.assertEquals((long)plc_caCF1b, (long)item_.getPlc_caCF1b());
        Assert.assertEquals((long)plc_caCFC, (long)item_.getPlc_caCFC());
        Assert.assertEquals((long)plc_caCFCb, (long)item_.getPlc_caCFCb());
        Assert.assertEquals((long)plc_caCS, (long)item_.getPlc_caCS());
        Assert.assertEquals((long)plc_caCSb, (long)item_.getPlc_caCSb());
        Assert.assertEquals((long)plc_caEnableBrakes, (long)item_.getPlc_caEnableBrakes());
        Assert.assertEquals((long)plc_caEnableRotation, (long)item_.getPlc_caEnableRotation());
        Assert.assertEquals((long)plc_caEnableShutter, (long)item_.getPlc_caEnableShutter());
        Assert.assertEquals((long)plc_caEnableUnclamp, (long)item_.getPlc_caEnableUnclamp());
        Assert.assertEquals((long)plc_caEng, (long)item_.getPlc_caEng());
        Assert.assertEquals((long)plc_caEngb, (long)item_.getPlc_caEngb());
        Assert.assertEquals((long)plc_caLockout, (long)item_.getPlc_caLockout());
        Assert.assertEquals((long)plc_caLockoutb, (long)item_.getPlc_caLockoutb());
        Assert.assertEquals((long)plc_caShutterInactive, (long)item_.getPlc_caShutterInactive());
        Assert.assertEquals((long)plc_caSleep, (long)item_.getPlc_caSleep());
        Assert.assertEquals((long)plc_enableShutterInterlock, (long)item_.getPlc_enableShutterInterlock());
        Assert.assertEquals((long)plc_okDI, (long)item_.getPlc_okDI());
        Assert.assertEquals((long)plc_okDIsafety, (long)item_.getPlc_okDIsafety());
        Assert.assertEquals((long)plc_powerSave, (long)item_.getPlc_powerSave());
        Assert.assertEquals((long)plc_tpCheckRotation, (long)item_.getPlc_tpCheckRotation());
        Assert.assertEquals((long)plc_tpStopRotation, (long)item_.getPlc_tpStopRotation());
        Assert.assertEquals((long)plc_tpStopUnclamp, (long)item_.getPlc_tpStopUnclamp());
        Assert.assertEquals((double)temperatures_averageClamps, (double)item_.getTemperatures_averageClamps(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_internalHYTTC580, (double)item_.getTemperatures_internalHYTTC580(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_socket1, (double)item_.getTemperatures_socket1(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_socket2, (double)item_.getTemperatures_socket2(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_socket3, (double)item_.getTemperatures_socket3(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_socket4, (double)item_.getTemperatures_socket4(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_socket5, (double)item_.getTemperatures_socket5(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Canbus0_LatchXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 228;
        boolean brakeActivated = true;
        int current = 945;
        int errorHistoryNB = 508;
        String errorRegister = "m";
        int followingError = 515;
        boolean inError = true;
        int lastErrorCode = 207;
        String lastErrorName = "";
        String mode = "";
        int position = 599;
        long profileAcceleration = 454L;
        long profileDeceleration = 670L;
        long profileVelocity = 931L;
        String state = "";
        int velocity = 855;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_LatchXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_LatchXminusController_TrendingTelemetry));
        Fcs_Canbus0_LatchXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_LatchXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_LatchXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 106;
        boolean brakeActivated = false;
        int current = 466;
        int errorHistoryNB = 192;
        String errorRegister = "";
        int followingError = 705;
        boolean inError = true;
        int lastErrorCode = 43;
        String lastErrorName = "";
        String mode = "";
        int position = 826;
        long profileAcceleration = 691L;
        long profileDeceleration = 40L;
        long profileVelocity = 34L;
        String state = "m";
        int velocity = 425;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_LatchXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_LatchXplusController_TrendingTelemetry));
        Fcs_Canbus0_LatchXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_LatchXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 184;
        boolean brakeActivated = false;
        int current = 222;
        int errorHistoryNB = 398;
        String errorRegister = "r";
        int followingError = 544;
        boolean inError = false;
        int lastErrorCode = 60;
        String lastErrorName = "n";
        String mode = "b";
        int position = 996;
        long profileAcceleration = 388L;
        long profileDeceleration = 667L;
        long profileVelocity = 376L;
        String state = "i";
        int velocity = 641;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 402;
        boolean brakeActivated = true;
        int current = 925;
        int errorHistoryNB = 551;
        String errorRegister = "";
        int followingError = 775;
        boolean inError = true;
        int lastErrorCode = 743;
        String lastErrorName = "";
        String mode = "";
        int position = 252;
        long profileAcceleration = 906L;
        long profileDeceleration = 948L;
        long profileVelocity = 302L;
        String state = "x";
        int velocity = 9;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampYminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 358;
        boolean brakeActivated = true;
        int current = 866;
        int errorHistoryNB = 524;
        String errorRegister = "";
        int followingError = 868;
        boolean inError = false;
        int lastErrorCode = 236;
        String lastErrorName = "l";
        String mode = "b";
        int position = 771;
        long profileAcceleration = 705L;
        long profileDeceleration = 219L;
        long profileVelocity = 544L;
        String state = "";
        int velocity = 30;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineStrainGauge_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 371;
        String errorRegister = "d";
        boolean inError = false;
        int lastErrorCode = 633;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry));
        Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 718;
        String errorRegister = "l";
        boolean inError = true;
        int lastErrorCode = 508;
        String lastErrorName = "n";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry));
        Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry item_ = (Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Pt100_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 537;
        String errorRegister = "";
        boolean inError = false;
        int lastErrorCode = 765;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Pt100_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Pt100_TrendingTelemetry));
        Fcs_Canbus0_Pt100_TrendingTelemetry item_ = (Fcs_Canbus0_Pt100_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_TempSensorsDevice1_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 322;
        String errorRegister = "h";
        boolean inError = true;
        int lastErrorCode = 12;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry));
        Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry item_ = (Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_TempSensorsDevice2_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 485;
        String errorRegister = "x";
        boolean inError = true;
        int lastErrorCode = 451;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry));
        Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry item_ = (Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus1_CarrierController_TrendingTelemetry() throws Exception {
        int averageCurrent = 946;
        boolean brakeActivated = false;
        int current = 678;
        int errorHistoryNB = 517;
        String errorRegister = "";
        int followingError = 679;
        boolean inError = false;
        int lastErrorCode = 375;
        String lastErrorName = "";
        String mode = "h";
        int position = 83;
        long profileAcceleration = 170L;
        long profileDeceleration = 551L;
        long profileVelocity = 704L;
        String state = "";
        int velocity = 437;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_CarrierController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_CarrierController_TrendingTelemetry));
        Fcs_Canbus1_CarrierController_TrendingTelemetry item_ = (Fcs_Canbus1_CarrierController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus1_HooksController_TrendingTelemetry() throws Exception {
        int averageCurrent = 358;
        boolean brakeActivated = true;
        int current = 11;
        int errorHistoryNB = 512;
        String errorRegister = "v";
        int followingError = 838;
        boolean inError = false;
        int lastErrorCode = 318;
        String lastErrorName = "g";
        String mode = "";
        int position = 311;
        long profileAcceleration = 598L;
        long profileDeceleration = 484L;
        long profileVelocity = 38L;
        String state = "";
        int velocity = 27;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_HooksController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_HooksController_TrendingTelemetry));
        Fcs_Canbus1_HooksController_TrendingTelemetry item_ = (Fcs_Canbus1_HooksController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry() throws Exception {
        int acAF0b = 630;
        int acAF0s = 972;
        int acAF1b = 74;
        int acAF1s = 847;
        int acAF3b = 440;
        int acAF3s = 512;
        int acAP2b = 574;
        int acAP2s = 611;
        int clampedStatusSensor = 934;
        int forceSensor0 = 514;
        int forceSensor1 = 674;
        int keyEng = 513;
        int keyEngb = 232;
        int keyLock = 693;
        int keyLockb = 414;
        int lps_0 = 633;
        int lps_1 = 577;
        int lrh_0 = 185;
        int lrh_1 = 595;
        int loaderCarrierRelayStatus = 496;
        int loaderChainPresenceSensor = 520;
        int loaderCloseSensor1 = 838;
        int loaderCloseSensor2 = 782;
        int loaderCloseSensor3 = 629;
        int loaderCloseSensor4 = 731;
        int loaderDefaultStatus = 243;
        int loaderEngagedPositionSensor0 = 990;
        int loaderEngagedPositionSensor1 = 150;
        int loaderFilterDistanceSensor = 650;
        int loaderFilterGoodPositionStatus = 323;
        int loaderFilterPresenceSensor0 = 263;
        int loaderFilterPresenceSensor1 = 559;
        int loaderHandoffPositionSensor0 = 503;
        int loaderHandoffPositionSensor1 = 593;
        int loaderHooksRelayStatus = 163;
        int loaderOnCameraSensor0 = 874;
        int loaderOnCameraSensor1 = 960;
        int loaderOpenSensor1 = 291;
        int loaderOpenSensor2 = 253;
        int loaderOpenSensor3 = 538;
        int loaderOpenSensor4 = 822;
        int loaderStoragePositionSensor0 = 737;
        int loaderStoragePositionSensor1 = 969;
        int loader_LFD = 329;
        int loader_LFS = 374;
        int overClampedStatusSensor = 241;
        int unclampedStatusSensor = 19;
        int underClampedStatusSensor = 898;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry(acAF0b, acAF0s, acAF1b, acAF1s, acAF3b, acAF3s, acAP2b, acAP2s, clampedStatusSensor, forceSensor0, forceSensor1, keyEng, keyEngb, keyLock, keyLockb, lps_0, lps_1, lrh_0, lrh_1, loaderCarrierRelayStatus, loaderChainPresenceSensor, loaderCloseSensor1, loaderCloseSensor2, loaderCloseSensor3, loaderCloseSensor4, loaderDefaultStatus, loaderEngagedPositionSensor0, loaderEngagedPositionSensor1, loaderFilterDistanceSensor, loaderFilterGoodPositionStatus, loaderFilterPresenceSensor0, loaderFilterPresenceSensor1, loaderHandoffPositionSensor0, loaderHandoffPositionSensor1, loaderHooksRelayStatus, loaderOnCameraSensor0, loaderOnCameraSensor1, loaderOpenSensor1, loaderOpenSensor2, loaderOpenSensor3, loaderOpenSensor4, loaderStoragePositionSensor0, loaderStoragePositionSensor1, loader_LFD, loader_LFS, overClampedStatusSensor, unclampedStatusSensor, underClampedStatusSensor));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry));
        Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry item_ = (Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)acAF0b, (long)item_.getAcAF0b());
        Assert.assertEquals((long)acAF0s, (long)item_.getAcAF0s());
        Assert.assertEquals((long)acAF1b, (long)item_.getAcAF1b());
        Assert.assertEquals((long)acAF1s, (long)item_.getAcAF1s());
        Assert.assertEquals((long)acAF3b, (long)item_.getAcAF3b());
        Assert.assertEquals((long)acAF3s, (long)item_.getAcAF3s());
        Assert.assertEquals((long)acAP2b, (long)item_.getAcAP2b());
        Assert.assertEquals((long)acAP2s, (long)item_.getAcAP2s());
        Assert.assertEquals((long)clampedStatusSensor, (long)item_.getClampedStatusSensor());
        Assert.assertEquals((long)forceSensor0, (long)item_.getForceSensor0());
        Assert.assertEquals((long)forceSensor1, (long)item_.getForceSensor1());
        Assert.assertEquals((long)keyEng, (long)item_.getKeyEng());
        Assert.assertEquals((long)keyEngb, (long)item_.getKeyEngb());
        Assert.assertEquals((long)keyLock, (long)item_.getKeyLock());
        Assert.assertEquals((long)keyLockb, (long)item_.getKeyLockb());
        Assert.assertEquals((long)lps_0, (long)item_.getLps_0());
        Assert.assertEquals((long)lps_1, (long)item_.getLps_1());
        Assert.assertEquals((long)lrh_0, (long)item_.getLrh_0());
        Assert.assertEquals((long)lrh_1, (long)item_.getLrh_1());
        Assert.assertEquals((long)loaderCarrierRelayStatus, (long)item_.getLoaderCarrierRelayStatus());
        Assert.assertEquals((long)loaderChainPresenceSensor, (long)item_.getLoaderChainPresenceSensor());
        Assert.assertEquals((long)loaderCloseSensor1, (long)item_.getLoaderCloseSensor1());
        Assert.assertEquals((long)loaderCloseSensor2, (long)item_.getLoaderCloseSensor2());
        Assert.assertEquals((long)loaderCloseSensor3, (long)item_.getLoaderCloseSensor3());
        Assert.assertEquals((long)loaderCloseSensor4, (long)item_.getLoaderCloseSensor4());
        Assert.assertEquals((long)loaderDefaultStatus, (long)item_.getLoaderDefaultStatus());
        Assert.assertEquals((long)loaderEngagedPositionSensor0, (long)item_.getLoaderEngagedPositionSensor0());
        Assert.assertEquals((long)loaderEngagedPositionSensor1, (long)item_.getLoaderEngagedPositionSensor1());
        Assert.assertEquals((long)loaderFilterDistanceSensor, (long)item_.getLoaderFilterDistanceSensor());
        Assert.assertEquals((long)loaderFilterGoodPositionStatus, (long)item_.getLoaderFilterGoodPositionStatus());
        Assert.assertEquals((long)loaderFilterPresenceSensor0, (long)item_.getLoaderFilterPresenceSensor0());
        Assert.assertEquals((long)loaderFilterPresenceSensor1, (long)item_.getLoaderFilterPresenceSensor1());
        Assert.assertEquals((long)loaderHandoffPositionSensor0, (long)item_.getLoaderHandoffPositionSensor0());
        Assert.assertEquals((long)loaderHandoffPositionSensor1, (long)item_.getLoaderHandoffPositionSensor1());
        Assert.assertEquals((long)loaderHooksRelayStatus, (long)item_.getLoaderHooksRelayStatus());
        Assert.assertEquals((long)loaderOnCameraSensor0, (long)item_.getLoaderOnCameraSensor0());
        Assert.assertEquals((long)loaderOnCameraSensor1, (long)item_.getLoaderOnCameraSensor1());
        Assert.assertEquals((long)loaderOpenSensor1, (long)item_.getLoaderOpenSensor1());
        Assert.assertEquals((long)loaderOpenSensor2, (long)item_.getLoaderOpenSensor2());
        Assert.assertEquals((long)loaderOpenSensor3, (long)item_.getLoaderOpenSensor3());
        Assert.assertEquals((long)loaderOpenSensor4, (long)item_.getLoaderOpenSensor4());
        Assert.assertEquals((long)loaderStoragePositionSensor0, (long)item_.getLoaderStoragePositionSensor0());
        Assert.assertEquals((long)loaderStoragePositionSensor1, (long)item_.getLoaderStoragePositionSensor1());
        Assert.assertEquals((long)loader_LFD, (long)item_.getLoader_LFD());
        Assert.assertEquals((long)loader_LFS, (long)item_.getLoader_LFS());
        Assert.assertEquals((long)overClampedStatusSensor, (long)item_.getOverClampedStatusSensor());
        Assert.assertEquals((long)unclampedStatusSensor, (long)item_.getUnclampedStatusSensor());
        Assert.assertEquals((long)underClampedStatusSensor, (long)item_.getUnderClampedStatusSensor());
    }

    @Test
    public void sendReceiveFcs_Carousel_Brakes_TrendingTelemetry() throws Exception {
        String brakeState1 = "p";
        String brakeState2 = "";
        String brakeState3 = "";
        long sensor1 = 875L;
        long sensor2 = 567L;
        long sensor3 = 425L;
        double temperature1 = 0.3212601f;
        double temperature2 = 0.12143063545227051;
        double temperature3 = 0.6722326874732971;
        double temperature4 = 0.16477346420288086;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Brakes_TrendingTelemetry(brakeState1, brakeState2, brakeState3, sensor1, sensor2, sensor3, temperature1, temperature2, temperature3, temperature4));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Brakes_TrendingTelemetry));
        Fcs_Carousel_Brakes_TrendingTelemetry item_ = (Fcs_Carousel_Brakes_TrendingTelemetry)item;
        Assert.assertEquals((Object)brakeState1, (Object)item_.getBrakeState1());
        Assert.assertEquals((Object)brakeState2, (Object)item_.getBrakeState2());
        Assert.assertEquals((Object)brakeState3, (Object)item_.getBrakeState3());
        Assert.assertEquals((long)sensor1, (long)item_.getSensor1());
        Assert.assertEquals((long)sensor2, (long)item_.getSensor2());
        Assert.assertEquals((long)sensor3, (long)item_.getSensor3());
        Assert.assertEquals((double)temperature1, (double)item_.getTemperature1(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature2, (double)item_.getTemperature2(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature3, (double)item_.getTemperature3(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature4, (double)item_.getTemperature4(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket1_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        boolean available = false;
        String clampxminus1_clampState = "";
        int clampxminus1_filterPositionSensorValue = 719;
        int clampxminus1_filterPresenceOffset2 = 662;
        String clampxminus1_filterPresenceStatus = "e";
        int clampxminus1_lockSensorOffset1 = 63;
        int clampxminus1_lockSensorValue = 841;
        String clampxminus1_lockStatus = "";
        String clampxplus1_clampState = "";
        int clampxplus1_filterPositionSensorValue = 609;
        int clampxplus1_filterPresenceOffset2 = 861;
        String clampxplus1_filterPresenceStatus = "n";
        int clampxplus1_lockSensorOffset1 = 703;
        int clampxplus1_lockSensorValue = 350;
        String clampxplus1_lockStatus = "";
        String clampsState = "g";
        boolean empty = false;
        String filterName = "s";
        String ioStatus = "k";
        int socketID = 457;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket1_TrendingTelemetry(atStandby, available, clampxminus1_clampState, clampxminus1_filterPositionSensorValue, clampxminus1_filterPresenceOffset2, clampxminus1_filterPresenceStatus, clampxminus1_lockSensorOffset1, clampxminus1_lockSensorValue, clampxminus1_lockStatus, clampxplus1_clampState, clampxplus1_filterPositionSensorValue, clampxplus1_filterPresenceOffset2, clampxplus1_filterPresenceStatus, clampxplus1_lockSensorOffset1, clampxplus1_lockSensorValue, clampxplus1_lockStatus, clampsState, empty, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket1_TrendingTelemetry));
        Fcs_Carousel_Socket1_TrendingTelemetry item_ = (Fcs_Carousel_Socket1_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampxminus1_clampState, (Object)item_.getClampxminus1_clampState());
        Assert.assertEquals((long)clampxminus1_filterPositionSensorValue, (long)item_.getClampxminus1_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus1_filterPresenceOffset2, (long)item_.getClampxminus1_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus1_filterPresenceStatus, (Object)item_.getClampxminus1_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus1_lockSensorOffset1, (long)item_.getClampxminus1_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus1_lockSensorValue, (long)item_.getClampxminus1_lockSensorValue());
        Assert.assertEquals((Object)clampxminus1_lockStatus, (Object)item_.getClampxminus1_lockStatus());
        Assert.assertEquals((Object)clampxplus1_clampState, (Object)item_.getClampxplus1_clampState());
        Assert.assertEquals((long)clampxplus1_filterPositionSensorValue, (long)item_.getClampxplus1_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus1_filterPresenceOffset2, (long)item_.getClampxplus1_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus1_filterPresenceStatus, (Object)item_.getClampxplus1_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus1_lockSensorOffset1, (long)item_.getClampxplus1_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus1_lockSensorValue, (long)item_.getClampxplus1_lockSensorValue());
        Assert.assertEquals((Object)clampxplus1_lockStatus, (Object)item_.getClampxplus1_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket2_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        boolean available = true;
        String clampxminus2_clampState = "";
        int clampxminus2_filterPositionSensorValue = 601;
        int clampxminus2_filterPresenceOffset2 = 695;
        String clampxminus2_filterPresenceStatus = "o";
        int clampxminus2_lockSensorOffset1 = 147;
        int clampxminus2_lockSensorValue = 882;
        String clampxminus2_lockStatus = "h";
        String clampxplus2_clampState = "q";
        int clampxplus2_filterPositionSensorValue = 984;
        int clampxplus2_filterPresenceOffset2 = 438;
        String clampxplus2_filterPresenceStatus = "";
        int clampxplus2_lockSensorOffset1 = 662;
        int clampxplus2_lockSensorValue = 365;
        String clampxplus2_lockStatus = "t";
        String clampsState = "d";
        boolean empty = false;
        String filterName = "";
        String ioStatus = "";
        int socketID = 463;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket2_TrendingTelemetry(atStandby, available, clampxminus2_clampState, clampxminus2_filterPositionSensorValue, clampxminus2_filterPresenceOffset2, clampxminus2_filterPresenceStatus, clampxminus2_lockSensorOffset1, clampxminus2_lockSensorValue, clampxminus2_lockStatus, clampxplus2_clampState, clampxplus2_filterPositionSensorValue, clampxplus2_filterPresenceOffset2, clampxplus2_filterPresenceStatus, clampxplus2_lockSensorOffset1, clampxplus2_lockSensorValue, clampxplus2_lockStatus, clampsState, empty, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket2_TrendingTelemetry));
        Fcs_Carousel_Socket2_TrendingTelemetry item_ = (Fcs_Carousel_Socket2_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampxminus2_clampState, (Object)item_.getClampxminus2_clampState());
        Assert.assertEquals((long)clampxminus2_filterPositionSensorValue, (long)item_.getClampxminus2_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus2_filterPresenceOffset2, (long)item_.getClampxminus2_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus2_filterPresenceStatus, (Object)item_.getClampxminus2_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus2_lockSensorOffset1, (long)item_.getClampxminus2_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus2_lockSensorValue, (long)item_.getClampxminus2_lockSensorValue());
        Assert.assertEquals((Object)clampxminus2_lockStatus, (Object)item_.getClampxminus2_lockStatus());
        Assert.assertEquals((Object)clampxplus2_clampState, (Object)item_.getClampxplus2_clampState());
        Assert.assertEquals((long)clampxplus2_filterPositionSensorValue, (long)item_.getClampxplus2_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus2_filterPresenceOffset2, (long)item_.getClampxplus2_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus2_filterPresenceStatus, (Object)item_.getClampxplus2_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus2_lockSensorOffset1, (long)item_.getClampxplus2_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus2_lockSensorValue, (long)item_.getClampxplus2_lockSensorValue());
        Assert.assertEquals((Object)clampxplus2_lockStatus, (Object)item_.getClampxplus2_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket3_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        boolean available = false;
        String clampxminus3_clampState = "";
        int clampxminus3_filterPositionSensorValue = 419;
        int clampxminus3_filterPresenceOffset2 = 77;
        String clampxminus3_filterPresenceStatus = "";
        int clampxminus3_lockSensorOffset1 = 46;
        int clampxminus3_lockSensorValue = 415;
        String clampxminus3_lockStatus = "f";
        String clampxplus3_clampState = "m";
        int clampxplus3_filterPositionSensorValue = 443;
        int clampxplus3_filterPresenceOffset2 = 389;
        String clampxplus3_filterPresenceStatus = "";
        int clampxplus3_lockSensorOffset1 = 910;
        int clampxplus3_lockSensorValue = 235;
        String clampxplus3_lockStatus = "h";
        String clampsState = "";
        boolean empty = true;
        String filterName = "w";
        String ioStatus = "j";
        int socketID = 323;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket3_TrendingTelemetry(atStandby, available, clampxminus3_clampState, clampxminus3_filterPositionSensorValue, clampxminus3_filterPresenceOffset2, clampxminus3_filterPresenceStatus, clampxminus3_lockSensorOffset1, clampxminus3_lockSensorValue, clampxminus3_lockStatus, clampxplus3_clampState, clampxplus3_filterPositionSensorValue, clampxplus3_filterPresenceOffset2, clampxplus3_filterPresenceStatus, clampxplus3_lockSensorOffset1, clampxplus3_lockSensorValue, clampxplus3_lockStatus, clampsState, empty, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket3_TrendingTelemetry));
        Fcs_Carousel_Socket3_TrendingTelemetry item_ = (Fcs_Carousel_Socket3_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampxminus3_clampState, (Object)item_.getClampxminus3_clampState());
        Assert.assertEquals((long)clampxminus3_filterPositionSensorValue, (long)item_.getClampxminus3_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus3_filterPresenceOffset2, (long)item_.getClampxminus3_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus3_filterPresenceStatus, (Object)item_.getClampxminus3_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus3_lockSensorOffset1, (long)item_.getClampxminus3_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus3_lockSensorValue, (long)item_.getClampxminus3_lockSensorValue());
        Assert.assertEquals((Object)clampxminus3_lockStatus, (Object)item_.getClampxminus3_lockStatus());
        Assert.assertEquals((Object)clampxplus3_clampState, (Object)item_.getClampxplus3_clampState());
        Assert.assertEquals((long)clampxplus3_filterPositionSensorValue, (long)item_.getClampxplus3_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus3_filterPresenceOffset2, (long)item_.getClampxplus3_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus3_filterPresenceStatus, (Object)item_.getClampxplus3_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus3_lockSensorOffset1, (long)item_.getClampxplus3_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus3_lockSensorValue, (long)item_.getClampxplus3_lockSensorValue());
        Assert.assertEquals((Object)clampxplus3_lockStatus, (Object)item_.getClampxplus3_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket4_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        boolean available = false;
        String clampxminus4_clampState = "m";
        int clampxminus4_filterPositionSensorValue = 992;
        int clampxminus4_filterPresenceOffset2 = 341;
        String clampxminus4_filterPresenceStatus = "w";
        int clampxminus4_lockSensorOffset1 = 774;
        int clampxminus4_lockSensorValue = 403;
        String clampxminus4_lockStatus = "";
        String clampxplus4_clampState = "s";
        int clampxplus4_filterPositionSensorValue = 410;
        int clampxplus4_filterPresenceOffset2 = 721;
        String clampxplus4_filterPresenceStatus = "p";
        int clampxplus4_lockSensorOffset1 = 477;
        int clampxplus4_lockSensorValue = 507;
        String clampxplus4_lockStatus = "";
        String clampsState = "";
        boolean empty = false;
        String filterName = "";
        String ioStatus = "z";
        int socketID = 662;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket4_TrendingTelemetry(atStandby, available, clampxminus4_clampState, clampxminus4_filterPositionSensorValue, clampxminus4_filterPresenceOffset2, clampxminus4_filterPresenceStatus, clampxminus4_lockSensorOffset1, clampxminus4_lockSensorValue, clampxminus4_lockStatus, clampxplus4_clampState, clampxplus4_filterPositionSensorValue, clampxplus4_filterPresenceOffset2, clampxplus4_filterPresenceStatus, clampxplus4_lockSensorOffset1, clampxplus4_lockSensorValue, clampxplus4_lockStatus, clampsState, empty, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket4_TrendingTelemetry));
        Fcs_Carousel_Socket4_TrendingTelemetry item_ = (Fcs_Carousel_Socket4_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampxminus4_clampState, (Object)item_.getClampxminus4_clampState());
        Assert.assertEquals((long)clampxminus4_filterPositionSensorValue, (long)item_.getClampxminus4_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus4_filterPresenceOffset2, (long)item_.getClampxminus4_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus4_filterPresenceStatus, (Object)item_.getClampxminus4_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus4_lockSensorOffset1, (long)item_.getClampxminus4_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus4_lockSensorValue, (long)item_.getClampxminus4_lockSensorValue());
        Assert.assertEquals((Object)clampxminus4_lockStatus, (Object)item_.getClampxminus4_lockStatus());
        Assert.assertEquals((Object)clampxplus4_clampState, (Object)item_.getClampxplus4_clampState());
        Assert.assertEquals((long)clampxplus4_filterPositionSensorValue, (long)item_.getClampxplus4_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus4_filterPresenceOffset2, (long)item_.getClampxplus4_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus4_filterPresenceStatus, (Object)item_.getClampxplus4_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus4_lockSensorOffset1, (long)item_.getClampxplus4_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus4_lockSensorValue, (long)item_.getClampxplus4_lockSensorValue());
        Assert.assertEquals((Object)clampxplus4_lockStatus, (Object)item_.getClampxplus4_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket5_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        boolean available = true;
        String clampxminus5_clampState = "o";
        int clampxminus5_filterPositionSensorValue = 899;
        int clampxminus5_filterPresenceOffset2 = 759;
        String clampxminus5_filterPresenceStatus = "z";
        int clampxminus5_lockSensorOffset1 = 565;
        int clampxminus5_lockSensorValue = 98;
        String clampxminus5_lockStatus = "";
        String clampxplus5_clampState = "";
        int clampxplus5_filterPositionSensorValue = 11;
        int clampxplus5_filterPresenceOffset2 = 542;
        String clampxplus5_filterPresenceStatus = "b";
        int clampxplus5_lockSensorOffset1 = 517;
        int clampxplus5_lockSensorValue = 792;
        String clampxplus5_lockStatus = "h";
        String clampsState = "";
        boolean empty = false;
        String filterName = "e";
        String ioStatus = "";
        int socketID = 266;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket5_TrendingTelemetry(atStandby, available, clampxminus5_clampState, clampxminus5_filterPositionSensorValue, clampxminus5_filterPresenceOffset2, clampxminus5_filterPresenceStatus, clampxminus5_lockSensorOffset1, clampxminus5_lockSensorValue, clampxminus5_lockStatus, clampxplus5_clampState, clampxplus5_filterPositionSensorValue, clampxplus5_filterPresenceOffset2, clampxplus5_filterPresenceStatus, clampxplus5_lockSensorOffset1, clampxplus5_lockSensorValue, clampxplus5_lockStatus, clampsState, empty, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket5_TrendingTelemetry));
        Fcs_Carousel_Socket5_TrendingTelemetry item_ = (Fcs_Carousel_Socket5_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)available, (Object)item_.isAvailable());
        Assert.assertEquals((Object)clampxminus5_clampState, (Object)item_.getClampxminus5_clampState());
        Assert.assertEquals((long)clampxminus5_filterPositionSensorValue, (long)item_.getClampxminus5_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus5_filterPresenceOffset2, (long)item_.getClampxminus5_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus5_filterPresenceStatus, (Object)item_.getClampxminus5_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus5_lockSensorOffset1, (long)item_.getClampxminus5_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus5_lockSensorValue, (long)item_.getClampxminus5_lockSensorValue());
        Assert.assertEquals((Object)clampxminus5_lockStatus, (Object)item_.getClampxminus5_lockStatus());
        Assert.assertEquals((Object)clampxplus5_clampState, (Object)item_.getClampxplus5_clampState());
        Assert.assertEquals((long)clampxplus5_filterPositionSensorValue, (long)item_.getClampxplus5_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus5_filterPresenceOffset2, (long)item_.getClampxplus5_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus5_filterPresenceStatus, (Object)item_.getClampxplus5_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus5_lockSensorOffset1, (long)item_.getClampxplus5_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus5_lockSensorValue, (long)item_.getClampxplus5_lockSensorValue());
        Assert.assertEquals((Object)clampxplus5_lockStatus, (Object)item_.getClampxplus5_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        String clampsStateAtStandby = "";
        int deltaPositionAtStandby = 697;
        boolean emptyAtStandby = true;
        int estimatedPosition = 149;
        int filterAtStandbyId = 882;
        String filterOnAutochangerName = "o";
        long minLocked = 805L;
        int socketAtStandbyID = 54;
        String socketAtStandbyName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_TrendingTelemetry(atStandby, clampsStateAtStandby, deltaPositionAtStandby, emptyAtStandby, estimatedPosition, filterAtStandbyId, filterOnAutochangerName, minLocked, socketAtStandbyID, socketAtStandbyName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_TrendingTelemetry));
        Fcs_Carousel_TrendingTelemetry item_ = (Fcs_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampsStateAtStandby, (Object)item_.getClampsStateAtStandby());
        Assert.assertEquals((long)deltaPositionAtStandby, (long)item_.getDeltaPositionAtStandby());
        Assert.assertEquals((Object)emptyAtStandby, (Object)item_.isEmptyAtStandby());
        Assert.assertEquals((long)estimatedPosition, (long)item_.getEstimatedPosition());
        Assert.assertEquals((long)filterAtStandbyId, (long)item_.getFilterAtStandbyId());
        Assert.assertEquals((Object)filterOnAutochangerName, (Object)item_.getFilterOnAutochangerName());
        Assert.assertEquals((long)minLocked, (long)item_.getMinLocked());
        Assert.assertEquals((long)socketAtStandbyID, (long)item_.getSocketAtStandbyID());
        Assert.assertEquals((Object)socketAtStandbyName, (Object)item_.getSocketAtStandbyName());
    }

    @Test
    public void sendReceiveFcs_Counters_Autochanger_TrendingTelemetry() throws Exception {
        double autochangertrucks_ALIGN_FOLLOWER = 0.759335994720459;
        double autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE = 0.1105089783668518;
        double autochangertrucks_MOVE_TO_ABSOLUTE_POSITION = 0.9210597276687622;
        double latches_latchXminus_CLOSE = 0.9468511343002319;
        double latches_latchXminus_OPEN = 0.3025868535041809;
        double latches_latchXplus_CLOSE = 0.41682547330856323;
        double latches_latchXplus_OPEN = 0.02113097906112671;
        double onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 0.2932738661766052;
        double onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 0.10521078109741211;
        double onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP = 0.2363465428352356;
        double onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT = 0.14390015602111816;
        double onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 0.6882686614990234;
        double onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 0.8476573824882507;
        double onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP = 0.6665184497833252;
        double onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT = 0.8498090505599976;
        double onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 0.24881380796432495;
        double onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP = 0.24697858095169067;
        double onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT = 0.9270090460777283;
        double onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 0.5507165193557739;
        double onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT = 0.4291202425956726;
        double onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP = 0.31646376848220825;
        double onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 0.14046591520309448;
        double onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 0.10621833801269531;
        double onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP = 0.7622305154800415;
        double onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT = 0.8990662097930908;
        double onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 0.949695885181427;
        double onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 0.2943531274795532;
        double onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP = 0.5089951753616333;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Counters_Autochanger_TrendingTelemetry(autochangertrucks_ALIGN_FOLLOWER, autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, latches_latchXminus_CLOSE, latches_latchXminus_OPEN, latches_latchXplus_CLOSE, latches_latchXplus_OPEN, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP));
        Assert.assertTrue((boolean)(item instanceof Fcs_Counters_Autochanger_TrendingTelemetry));
        Fcs_Counters_Autochanger_TrendingTelemetry item_ = (Fcs_Counters_Autochanger_TrendingTelemetry)item;
        Assert.assertEquals((double)autochangertrucks_ALIGN_FOLLOWER, (double)item_.getAutochangertrucks_ALIGN_FOLLOWER(), (double)1.0E-6f);
        Assert.assertEquals((double)autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, (double)item_.getAutochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE(), (double)1.0E-6f);
        Assert.assertEquals((double)autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, (double)item_.getAutochangertrucks_MOVE_TO_ABSOLUTE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)latches_latchXminus_CLOSE, (double)item_.getLatches_latchXminus_CLOSE(), (double)1.0E-6f);
        Assert.assertEquals((double)latches_latchXminus_OPEN, (double)item_.getLatches_latchXminus_OPEN(), (double)1.0E-6f);
        Assert.assertEquals((double)latches_latchXplus_CLOSE, (double)item_.getLatches_latchXplus_CLOSE(), (double)1.0E-6f);
        Assert.assertEquals((double)latches_latchXplus_OPEN, (double)item_.getLatches_latchXplus_OPEN(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampXminus_LOCK_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampXplus_LOCK_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampYminus_LOCK_ONLINECLAMP(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (double)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (double)item_.getOnlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT(), (double)1.0E-6f);
        Assert.assertEquals((double)onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP, (double)item_.getOnlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Counters_Carousel_TrendingTelemetry() throws Exception {
        double rotate_CAROUSEL_TO_ABSOLUTE_POSITION = 0.4099313020706177;
        double rotate_CAROUSEL_TO_RELATIVE_POSITION = 0.8896225690841675;
        double socket1_RELEASE_CLAMPS = 0.256908655166626;
        double socket1_UNLOCK_CLAMPS = 0.1336471438407898;
        double socket1_clampXminus1_RELEASE = 0.3564424514770508;
        double socket1_clampXminus1_UNLOCK = 0.7358787655830383;
        double socket1_clampXplus1_RELEASE = 0.2476483f;
        double socket1_clampXplus1_UNLOCK = 0.35570287704467773;
        double socket2_RELEASE_CLAMPS = 0.11056089401245117;
        double socket2_UNLOCK_CLAMPS = 0.3588717579841614;
        double socket2_clampXminus2_RELEASE = 0.462848424911499;
        double socket2_clampXminus2_UNLOCK = 0.6299748420715332;
        double socket2_clampXplus2_RELEASE = 0.5067963600158691;
        double socket2_clampXplus2_UNLOCK = 0.5876566171646118;
        double socket3_RELEASE_CLAMPS = 0.3968232274055481;
        double socket3_UNLOCK_CLAMPS = 0.6091803908348083;
        double socket3_clampXminus3_RELEASE = 0.5019757747650146;
        double socket3_clampXminus3_UNLOCK = 0.2876335382461548;
        double socket3_clampXplus3_RELEASE = 0.6080055236816406;
        double socket3_clampXplus3_UNLOCK = 0.7917084097862244;
        double socket4_RELEASE_CLAMPS = 0.43527287244796753;
        double socket4_UNLOCK_CLAMPS = 0.9762369394302368;
        double socket4_clampXminus4_RELEASE = 0.3991520404815674;
        double socket4_clampXminus4_UNLOCK = 0.7609034776687622;
        double socket4_clampXplus4_RELEASE = 0.3970431685447693;
        double socket4_clampXplus4_UNLOCK = 0.42832082509994507;
        double socket5_RELEASE_CLAMPS = 0.18198204040527344;
        double socket5_UNLOCK_CLAMPS = 0.3077316880226135;
        double socket5_clampXminus5_RELEASE = 0.08432018756866455;
        double socket5_clampXminus5_UNLOCK = 0.5854048132896423;
        double socket5_clampXplus5_RELEASE = 0.013805627822875977;
        double socket5_clampXplus5_UNLOCK = 0.1874944567680359;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Counters_Carousel_TrendingTelemetry(rotate_CAROUSEL_TO_ABSOLUTE_POSITION, rotate_CAROUSEL_TO_RELATIVE_POSITION, socket1_RELEASE_CLAMPS, socket1_UNLOCK_CLAMPS, socket1_clampXminus1_RELEASE, socket1_clampXminus1_UNLOCK, socket1_clampXplus1_RELEASE, socket1_clampXplus1_UNLOCK, socket2_RELEASE_CLAMPS, socket2_UNLOCK_CLAMPS, socket2_clampXminus2_RELEASE, socket2_clampXminus2_UNLOCK, socket2_clampXplus2_RELEASE, socket2_clampXplus2_UNLOCK, socket3_RELEASE_CLAMPS, socket3_UNLOCK_CLAMPS, socket3_clampXminus3_RELEASE, socket3_clampXminus3_UNLOCK, socket3_clampXplus3_RELEASE, socket3_clampXplus3_UNLOCK, socket4_RELEASE_CLAMPS, socket4_UNLOCK_CLAMPS, socket4_clampXminus4_RELEASE, socket4_clampXminus4_UNLOCK, socket4_clampXplus4_RELEASE, socket4_clampXplus4_UNLOCK, socket5_RELEASE_CLAMPS, socket5_UNLOCK_CLAMPS, socket5_clampXminus5_RELEASE, socket5_clampXminus5_UNLOCK, socket5_clampXplus5_RELEASE, socket5_clampXplus5_UNLOCK));
        Assert.assertTrue((boolean)(item instanceof Fcs_Counters_Carousel_TrendingTelemetry));
        Fcs_Counters_Carousel_TrendingTelemetry item_ = (Fcs_Counters_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((double)rotate_CAROUSEL_TO_ABSOLUTE_POSITION, (double)item_.getRotate_CAROUSEL_TO_ABSOLUTE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)rotate_CAROUSEL_TO_RELATIVE_POSITION, (double)item_.getRotate_CAROUSEL_TO_RELATIVE_POSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_RELEASE_CLAMPS, (double)item_.getSocket1_RELEASE_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_UNLOCK_CLAMPS, (double)item_.getSocket1_UNLOCK_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_clampXminus1_RELEASE, (double)item_.getSocket1_clampXminus1_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_clampXminus1_UNLOCK, (double)item_.getSocket1_clampXminus1_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_clampXplus1_RELEASE, (double)item_.getSocket1_clampXplus1_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket1_clampXplus1_UNLOCK, (double)item_.getSocket1_clampXplus1_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_RELEASE_CLAMPS, (double)item_.getSocket2_RELEASE_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_UNLOCK_CLAMPS, (double)item_.getSocket2_UNLOCK_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_clampXminus2_RELEASE, (double)item_.getSocket2_clampXminus2_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_clampXminus2_UNLOCK, (double)item_.getSocket2_clampXminus2_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_clampXplus2_RELEASE, (double)item_.getSocket2_clampXplus2_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket2_clampXplus2_UNLOCK, (double)item_.getSocket2_clampXplus2_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_RELEASE_CLAMPS, (double)item_.getSocket3_RELEASE_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_UNLOCK_CLAMPS, (double)item_.getSocket3_UNLOCK_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_clampXminus3_RELEASE, (double)item_.getSocket3_clampXminus3_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_clampXminus3_UNLOCK, (double)item_.getSocket3_clampXminus3_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_clampXplus3_RELEASE, (double)item_.getSocket3_clampXplus3_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket3_clampXplus3_UNLOCK, (double)item_.getSocket3_clampXplus3_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_RELEASE_CLAMPS, (double)item_.getSocket4_RELEASE_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_UNLOCK_CLAMPS, (double)item_.getSocket4_UNLOCK_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_clampXminus4_RELEASE, (double)item_.getSocket4_clampXminus4_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_clampXminus4_UNLOCK, (double)item_.getSocket4_clampXminus4_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_clampXplus4_RELEASE, (double)item_.getSocket4_clampXplus4_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket4_clampXplus4_UNLOCK, (double)item_.getSocket4_clampXplus4_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_RELEASE_CLAMPS, (double)item_.getSocket5_RELEASE_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_UNLOCK_CLAMPS, (double)item_.getSocket5_UNLOCK_CLAMPS(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_clampXminus5_RELEASE, (double)item_.getSocket5_clampXminus5_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_clampXminus5_UNLOCK, (double)item_.getSocket5_clampXminus5_UNLOCK(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_clampXplus5_RELEASE, (double)item_.getSocket5_clampXplus5_RELEASE(), (double)1.0E-6f);
        Assert.assertEquals((double)socket5_clampXplus5_UNLOCK, (double)item_.getSocket5_clampXplus5_UNLOCK(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Counters_Loader_TrendingTelemetry() throws Exception {
        double carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION = 0.9739436507225037;
        double carrier_MOVE_LOADERCARRIER_TO_ENGAGED = 0.7984967827796936;
        double carrier_MOVE_LOADERCARRIER_TO_HANDOFF = 0.3413194417953491;
        double carrier_MOVE_LOADERCARRIER_TO_STORAGE = 0.20059436559677124;
        double hooks_CLAMP_LOADER_HOOKS = 0.06889933347702026;
        double hooks_CLOSE_LOADER_HOOKS = 0.7616328597068787;
        double hooks_OPEN_HOMING_LOADER_HOOKS = 0.5727697610855103;
        double hooks_UNCLAMP_LOADER_HOOKS = 0.8800707459449768;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Counters_Loader_TrendingTelemetry(carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, carrier_MOVE_LOADERCARRIER_TO_ENGAGED, carrier_MOVE_LOADERCARRIER_TO_HANDOFF, carrier_MOVE_LOADERCARRIER_TO_STORAGE, hooks_CLAMP_LOADER_HOOKS, hooks_CLOSE_LOADER_HOOKS, hooks_OPEN_HOMING_LOADER_HOOKS, hooks_UNCLAMP_LOADER_HOOKS));
        Assert.assertTrue((boolean)(item instanceof Fcs_Counters_Loader_TrendingTelemetry));
        Fcs_Counters_Loader_TrendingTelemetry item_ = (Fcs_Counters_Loader_TrendingTelemetry)item;
        Assert.assertEquals((double)carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, (double)item_.getCarrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION(), (double)1.0E-6f);
        Assert.assertEquals((double)carrier_MOVE_LOADERCARRIER_TO_ENGAGED, (double)item_.getCarrier_MOVE_LOADERCARRIER_TO_ENGAGED(), (double)1.0E-6f);
        Assert.assertEquals((double)carrier_MOVE_LOADERCARRIER_TO_HANDOFF, (double)item_.getCarrier_MOVE_LOADERCARRIER_TO_HANDOFF(), (double)1.0E-6f);
        Assert.assertEquals((double)carrier_MOVE_LOADERCARRIER_TO_STORAGE, (double)item_.getCarrier_MOVE_LOADERCARRIER_TO_STORAGE(), (double)1.0E-6f);
        Assert.assertEquals((double)hooks_CLAMP_LOADER_HOOKS, (double)item_.getHooks_CLAMP_LOADER_HOOKS(), (double)1.0E-6f);
        Assert.assertEquals((double)hooks_CLOSE_LOADER_HOOKS, (double)item_.getHooks_CLOSE_LOADER_HOOKS(), (double)1.0E-6f);
        Assert.assertEquals((double)hooks_OPEN_HOMING_LOADER_HOOKS, (double)item_.getHooks_OPEN_HOMING_LOADER_HOOKS(), (double)1.0E-6f);
        Assert.assertEquals((double)hooks_UNCLAMP_LOADER_HOOKS, (double)item_.getHooks_UNCLAMP_LOADER_HOOKS(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Counters_TrendingTelemetry() throws Exception {
        double connect_LOADER = 0.21037834882736206;
        double disconnect_LOADER = 0.08199608325958252;
        double disengage_FILTER_FROM_CAROUSEL = 0.010221540927886963;
        double grab_FILTER_AT_STANDBY = 0.0031989216804504395;
        double load_FILTER = 0.5412513613700867;
        double move_AND_CLAMP_FILTER_ONLINE = 0.07252120971679688;
        double rotate_SOCKET_TO_STANDBY = 0.5229958891868591;
        double set_FILTER = 0.8749794960021973;
        double set_FILTER_AT_HANDOFF_FOR_LOADER = 0.1531773805618286;
        double set_NO_FILTER = 0.2249404788017273;
        double store_FILTER_ON_CAROUSEL = 0.32382726669311523;
        double unload_FILTER = 0.32756322622299194;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Counters_TrendingTelemetry(connect_LOADER, disconnect_LOADER, disengage_FILTER_FROM_CAROUSEL, grab_FILTER_AT_STANDBY, load_FILTER, move_AND_CLAMP_FILTER_ONLINE, rotate_SOCKET_TO_STANDBY, set_FILTER, set_FILTER_AT_HANDOFF_FOR_LOADER, set_NO_FILTER, store_FILTER_ON_CAROUSEL, unload_FILTER));
        Assert.assertTrue((boolean)(item instanceof Fcs_Counters_TrendingTelemetry));
        Fcs_Counters_TrendingTelemetry item_ = (Fcs_Counters_TrendingTelemetry)item;
        Assert.assertEquals((double)connect_LOADER, (double)item_.getConnect_LOADER(), (double)1.0E-6f);
        Assert.assertEquals((double)disconnect_LOADER, (double)item_.getDisconnect_LOADER(), (double)1.0E-6f);
        Assert.assertEquals((double)disengage_FILTER_FROM_CAROUSEL, (double)item_.getDisengage_FILTER_FROM_CAROUSEL(), (double)1.0E-6f);
        Assert.assertEquals((double)grab_FILTER_AT_STANDBY, (double)item_.getGrab_FILTER_AT_STANDBY(), (double)1.0E-6f);
        Assert.assertEquals((double)load_FILTER, (double)item_.getLoad_FILTER(), (double)1.0E-6f);
        Assert.assertEquals((double)move_AND_CLAMP_FILTER_ONLINE, (double)item_.getMove_AND_CLAMP_FILTER_ONLINE(), (double)1.0E-6f);
        Assert.assertEquals((double)rotate_SOCKET_TO_STANDBY, (double)item_.getRotate_SOCKET_TO_STANDBY(), (double)1.0E-6f);
        Assert.assertEquals((double)set_FILTER, (double)item_.getSet_FILTER(), (double)1.0E-6f);
        Assert.assertEquals((double)set_FILTER_AT_HANDOFF_FOR_LOADER, (double)item_.getSet_FILTER_AT_HANDOFF_FOR_LOADER(), (double)1.0E-6f);
        Assert.assertEquals((double)set_NO_FILTER, (double)item_.getSet_NO_FILTER(), (double)1.0E-6f);
        Assert.assertEquals((double)store_FILTER_ON_CAROUSEL, (double)item_.getStore_FILTER_ON_CAROUSEL(), (double)1.0E-6f);
        Assert.assertEquals((double)unload_FILTER, (double)item_.getUnload_FILTER(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Duration_Autochanger_TrendingTelemetry() throws Exception {
        long autochangertrucks_ALIGN_FOLLOWER = 786L;
        long autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE = 152L;
        long autochangertrucks_MOVE_TO_ABSOLUTE_POSITION = 350L;
        double grab_FILTER_AT_STANDBY = 0.37691646814346313;
        long latches_latchXminus_CLOSE = 598L;
        long latches_latchXminus_OPEN = 118L;
        long latches_latchXplus_CLOSE = 268L;
        long latches_latchXplus_OPEN = 923L;
        double move_AND_CLAMP_FILTER_ONLINE = 0.6417178511619568;
        long onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 385L;
        long onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 275L;
        long onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP = 434L;
        long onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT = 676L;
        long onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 881L;
        long onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 470L;
        long onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP = 891L;
        long onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT = 246L;
        long onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 878L;
        long onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP = 146L;
        long onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT = 632L;
        long onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 964L;
        long onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT = 245L;
        long onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP = 610L;
        long onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 747L;
        long onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 576L;
        long onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP = 398L;
        long onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT = 103L;
        long onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 369L;
        long onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 772L;
        long onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP = 842L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Autochanger_TrendingTelemetry(autochangertrucks_ALIGN_FOLLOWER, autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, grab_FILTER_AT_STANDBY, latches_latchXminus_CLOSE, latches_latchXminus_OPEN, latches_latchXplus_CLOSE, latches_latchXplus_OPEN, move_AND_CLAMP_FILTER_ONLINE, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Autochanger_TrendingTelemetry));
        Fcs_Duration_Autochanger_TrendingTelemetry item_ = (Fcs_Duration_Autochanger_TrendingTelemetry)item;
        Assert.assertEquals((long)autochangertrucks_ALIGN_FOLLOWER, (long)item_.getAutochangertrucks_ALIGN_FOLLOWER());
        Assert.assertEquals((long)autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, (long)item_.getAutochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE());
        Assert.assertEquals((long)autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, (long)item_.getAutochangertrucks_MOVE_TO_ABSOLUTE_POSITION());
        Assert.assertEquals((double)grab_FILTER_AT_STANDBY, (double)item_.getGrab_FILTER_AT_STANDBY(), (double)1.0E-6f);
        Assert.assertEquals((long)latches_latchXminus_CLOSE, (long)item_.getLatches_latchXminus_CLOSE());
        Assert.assertEquals((long)latches_latchXminus_OPEN, (long)item_.getLatches_latchXminus_OPEN());
        Assert.assertEquals((long)latches_latchXplus_CLOSE, (long)item_.getLatches_latchXplus_CLOSE());
        Assert.assertEquals((long)latches_latchXplus_OPEN, (long)item_.getLatches_latchXplus_OPEN());
        Assert.assertEquals((double)move_AND_CLAMP_FILTER_ONLINE, (double)item_.getMove_AND_CLAMP_FILTER_ONLINE(), (double)1.0E-6f);
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXminus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXplus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampYminus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP());
    }

    @Test
    public void sendReceiveFcs_Duration_Carousel_TrendingTelemetry() throws Exception {
        long rotate_CAROUSEL_TO_ABSOLUTE_POSITION = 88L;
        long rotate_CAROUSEL_TO_RELATIVE_POSITION = 905L;
        int socket1_RELEASE_CLAMPS = 844;
        int socket1_UNLOCK_CLAMPS = 443;
        long socket1_clampXminus1_RELEASE = 420L;
        long socket1_clampXminus1_UNLOCK = 331L;
        long socket1_clampXplus1_RELEASE = 741L;
        long socket1_clampXplus1_UNLOCK = 403L;
        int socket2_RELEASE_CLAMPS = 457;
        int socket2_UNLOCK_CLAMPS = 317;
        long socket2_clampXminus2_RELEASE = 886L;
        long socket2_clampXminus2_UNLOCK = 702L;
        long socket2_clampXplus2_RELEASE = 591L;
        long socket2_clampXplus2_UNLOCK = 697L;
        int socket3_RELEASE_CLAMPS = 369;
        int socket3_UNLOCK_CLAMPS = 668;
        long socket3_clampXminus3_RELEASE = 591L;
        long socket3_clampXminus3_UNLOCK = 170L;
        long socket3_clampXplus3_RELEASE = 614L;
        long socket3_clampXplus3_UNLOCK = 670L;
        int socket4_RELEASE_CLAMPS = 169;
        int socket4_UNLOCK_CLAMPS = 957;
        long socket4_clampXminus4_RELEASE = 157L;
        long socket4_clampXminus4_UNLOCK = 602L;
        long socket4_clampXplus4_RELEASE = 839L;
        long socket4_clampXplus4_UNLOCK = 629L;
        int socket5_RELEASE_CLAMPS = 165;
        int socket5_UNLOCK_CLAMPS = 474;
        long socket5_clampXminus5_RELEASE = 340L;
        long socket5_clampXminus5_UNLOCK = 974L;
        long socket5_clampXplus5_RELEASE = 566L;
        long socket5_clampXplus5_UNLOCK = 142L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Carousel_TrendingTelemetry(rotate_CAROUSEL_TO_ABSOLUTE_POSITION, rotate_CAROUSEL_TO_RELATIVE_POSITION, socket1_RELEASE_CLAMPS, socket1_UNLOCK_CLAMPS, socket1_clampXminus1_RELEASE, socket1_clampXminus1_UNLOCK, socket1_clampXplus1_RELEASE, socket1_clampXplus1_UNLOCK, socket2_RELEASE_CLAMPS, socket2_UNLOCK_CLAMPS, socket2_clampXminus2_RELEASE, socket2_clampXminus2_UNLOCK, socket2_clampXplus2_RELEASE, socket2_clampXplus2_UNLOCK, socket3_RELEASE_CLAMPS, socket3_UNLOCK_CLAMPS, socket3_clampXminus3_RELEASE, socket3_clampXminus3_UNLOCK, socket3_clampXplus3_RELEASE, socket3_clampXplus3_UNLOCK, socket4_RELEASE_CLAMPS, socket4_UNLOCK_CLAMPS, socket4_clampXminus4_RELEASE, socket4_clampXminus4_UNLOCK, socket4_clampXplus4_RELEASE, socket4_clampXplus4_UNLOCK, socket5_RELEASE_CLAMPS, socket5_UNLOCK_CLAMPS, socket5_clampXminus5_RELEASE, socket5_clampXminus5_UNLOCK, socket5_clampXplus5_RELEASE, socket5_clampXplus5_UNLOCK));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Carousel_TrendingTelemetry));
        Fcs_Duration_Carousel_TrendingTelemetry item_ = (Fcs_Duration_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((long)rotate_CAROUSEL_TO_ABSOLUTE_POSITION, (long)item_.getRotate_CAROUSEL_TO_ABSOLUTE_POSITION());
        Assert.assertEquals((long)rotate_CAROUSEL_TO_RELATIVE_POSITION, (long)item_.getRotate_CAROUSEL_TO_RELATIVE_POSITION());
        Assert.assertEquals((long)socket1_RELEASE_CLAMPS, (long)item_.getSocket1_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket1_UNLOCK_CLAMPS, (long)item_.getSocket1_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket1_clampXminus1_RELEASE, (long)item_.getSocket1_clampXminus1_RELEASE());
        Assert.assertEquals((long)socket1_clampXminus1_UNLOCK, (long)item_.getSocket1_clampXminus1_UNLOCK());
        Assert.assertEquals((long)socket1_clampXplus1_RELEASE, (long)item_.getSocket1_clampXplus1_RELEASE());
        Assert.assertEquals((long)socket1_clampXplus1_UNLOCK, (long)item_.getSocket1_clampXplus1_UNLOCK());
        Assert.assertEquals((long)socket2_RELEASE_CLAMPS, (long)item_.getSocket2_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket2_UNLOCK_CLAMPS, (long)item_.getSocket2_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket2_clampXminus2_RELEASE, (long)item_.getSocket2_clampXminus2_RELEASE());
        Assert.assertEquals((long)socket2_clampXminus2_UNLOCK, (long)item_.getSocket2_clampXminus2_UNLOCK());
        Assert.assertEquals((long)socket2_clampXplus2_RELEASE, (long)item_.getSocket2_clampXplus2_RELEASE());
        Assert.assertEquals((long)socket2_clampXplus2_UNLOCK, (long)item_.getSocket2_clampXplus2_UNLOCK());
        Assert.assertEquals((long)socket3_RELEASE_CLAMPS, (long)item_.getSocket3_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket3_UNLOCK_CLAMPS, (long)item_.getSocket3_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket3_clampXminus3_RELEASE, (long)item_.getSocket3_clampXminus3_RELEASE());
        Assert.assertEquals((long)socket3_clampXminus3_UNLOCK, (long)item_.getSocket3_clampXminus3_UNLOCK());
        Assert.assertEquals((long)socket3_clampXplus3_RELEASE, (long)item_.getSocket3_clampXplus3_RELEASE());
        Assert.assertEquals((long)socket3_clampXplus3_UNLOCK, (long)item_.getSocket3_clampXplus3_UNLOCK());
        Assert.assertEquals((long)socket4_RELEASE_CLAMPS, (long)item_.getSocket4_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket4_UNLOCK_CLAMPS, (long)item_.getSocket4_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket4_clampXminus4_RELEASE, (long)item_.getSocket4_clampXminus4_RELEASE());
        Assert.assertEquals((long)socket4_clampXminus4_UNLOCK, (long)item_.getSocket4_clampXminus4_UNLOCK());
        Assert.assertEquals((long)socket4_clampXplus4_RELEASE, (long)item_.getSocket4_clampXplus4_RELEASE());
        Assert.assertEquals((long)socket4_clampXplus4_UNLOCK, (long)item_.getSocket4_clampXplus4_UNLOCK());
        Assert.assertEquals((long)socket5_RELEASE_CLAMPS, (long)item_.getSocket5_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket5_UNLOCK_CLAMPS, (long)item_.getSocket5_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket5_clampXminus5_RELEASE, (long)item_.getSocket5_clampXminus5_RELEASE());
        Assert.assertEquals((long)socket5_clampXminus5_UNLOCK, (long)item_.getSocket5_clampXminus5_UNLOCK());
        Assert.assertEquals((long)socket5_clampXplus5_RELEASE, (long)item_.getSocket5_clampXplus5_RELEASE());
        Assert.assertEquals((long)socket5_clampXplus5_UNLOCK, (long)item_.getSocket5_clampXplus5_UNLOCK());
    }

    @Test
    public void sendReceiveFcs_Duration_Loader_TrendingTelemetry() throws Exception {
        long carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION = 7L;
        long carrier_MOVE_LOADERCARRIER_TO_ENGAGED = 811L;
        long carrier_MOVE_LOADERCARRIER_TO_HANDOFF = 927L;
        long carrier_MOVE_LOADERCARRIER_TO_STORAGE = 234L;
        long hooks_CLAMP_LOADER_HOOKS = 818L;
        long hooks_CLOSE_LOADER_HOOKS = 676L;
        long hooks_OPEN_HOMING_LOADER_HOOKS = 933L;
        long hooks_UNCLAMP_LOADER_HOOKS = 122L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Loader_TrendingTelemetry(carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, carrier_MOVE_LOADERCARRIER_TO_ENGAGED, carrier_MOVE_LOADERCARRIER_TO_HANDOFF, carrier_MOVE_LOADERCARRIER_TO_STORAGE, hooks_CLAMP_LOADER_HOOKS, hooks_CLOSE_LOADER_HOOKS, hooks_OPEN_HOMING_LOADER_HOOKS, hooks_UNCLAMP_LOADER_HOOKS));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Loader_TrendingTelemetry));
        Fcs_Duration_Loader_TrendingTelemetry item_ = (Fcs_Duration_Loader_TrendingTelemetry)item;
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_ENGAGED, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_ENGAGED());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_HANDOFF, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_HANDOFF());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_STORAGE, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_STORAGE());
        Assert.assertEquals((long)hooks_CLAMP_LOADER_HOOKS, (long)item_.getHooks_CLAMP_LOADER_HOOKS());
        Assert.assertEquals((long)hooks_CLOSE_LOADER_HOOKS, (long)item_.getHooks_CLOSE_LOADER_HOOKS());
        Assert.assertEquals((long)hooks_OPEN_HOMING_LOADER_HOOKS, (long)item_.getHooks_OPEN_HOMING_LOADER_HOOKS());
        Assert.assertEquals((long)hooks_UNCLAMP_LOADER_HOOKS, (long)item_.getHooks_UNCLAMP_LOADER_HOOKS());
    }

    @Test
    public void sendReceiveFcs_Duration_TrendingTelemetry() throws Exception {
        long connect_LOADER = 994L;
        long disconnect_LOADER = 31L;
        long disengage_FILTER_FROM_CAROUSEL = 18L;
        long load_FILTER = 641L;
        double rotate_SOCKET_TO_STANDBY = 0.4157188f;
        long set_FILTER = 342L;
        long set_FILTER_AT_HANDOFF_FOR_LOADER = 461L;
        long set_NO_FILTER = 673L;
        long store_FILTER_ON_CAROUSEL = 192L;
        long unload_FILTER = 577L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_TrendingTelemetry(connect_LOADER, disconnect_LOADER, disengage_FILTER_FROM_CAROUSEL, load_FILTER, rotate_SOCKET_TO_STANDBY, set_FILTER, set_FILTER_AT_HANDOFF_FOR_LOADER, set_NO_FILTER, store_FILTER_ON_CAROUSEL, unload_FILTER));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_TrendingTelemetry));
        Fcs_Duration_TrendingTelemetry item_ = (Fcs_Duration_TrendingTelemetry)item;
        Assert.assertEquals((long)connect_LOADER, (long)item_.getConnect_LOADER());
        Assert.assertEquals((long)disconnect_LOADER, (long)item_.getDisconnect_LOADER());
        Assert.assertEquals((long)disengage_FILTER_FROM_CAROUSEL, (long)item_.getDisengage_FILTER_FROM_CAROUSEL());
        Assert.assertEquals((long)load_FILTER, (long)item_.getLoad_FILTER());
        Assert.assertEquals((double)rotate_SOCKET_TO_STANDBY, (double)item_.getRotate_SOCKET_TO_STANDBY(), (double)1.0E-6f);
        Assert.assertEquals((long)set_FILTER, (long)item_.getSet_FILTER());
        Assert.assertEquals((long)set_FILTER_AT_HANDOFF_FOR_LOADER, (long)item_.getSet_FILTER_AT_HANDOFF_FOR_LOADER());
        Assert.assertEquals((long)set_NO_FILTER, (long)item_.getSet_NO_FILTER());
        Assert.assertEquals((long)store_FILTER_ON_CAROUSEL, (long)item_.getStore_FILTER_ON_CAROUSEL());
        Assert.assertEquals((long)unload_FILTER, (long)item_.getUnload_FILTER());
    }

    @Test
    public void sendReceiveFcs_Fcs_Mcm_TrendingTelemetry() throws Exception {
        int autochanger_trucks_position = 907;
        String autochanger_trucks_state = "o";
        String filter_on_autochanger = "j";
        int filter_previous_socketID = 83;
        int proximity = 833;
        int setfilter_percentage = 879;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Fcs_Mcm_TrendingTelemetry(autochanger_trucks_position, autochanger_trucks_state, filter_on_autochanger, filter_previous_socketID, proximity, setfilter_percentage));
        Assert.assertTrue((boolean)(item instanceof Fcs_Fcs_Mcm_TrendingTelemetry));
        Fcs_Fcs_Mcm_TrendingTelemetry item_ = (Fcs_Fcs_Mcm_TrendingTelemetry)item;
        Assert.assertEquals((long)autochanger_trucks_position, (long)item_.getAutochanger_trucks_position());
        Assert.assertEquals((Object)autochanger_trucks_state, (Object)item_.getAutochanger_trucks_state());
        Assert.assertEquals((Object)filter_on_autochanger, (Object)item_.getFilter_on_autochanger());
        Assert.assertEquals((long)filter_previous_socketID, (long)item_.getFilter_previous_socketID());
        Assert.assertEquals((long)proximity, (long)item_.getProximity());
        Assert.assertEquals((long)setfilter_percentage, (long)item_.getSetfilter_percentage());
    }

    @Test
    public void sendReceiveFcs_Fcs_TrendingTelemetry() throws Exception {
        String version = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Fcs_TrendingTelemetry(version));
        Assert.assertTrue((boolean)(item instanceof Fcs_Fcs_TrendingTelemetry));
        Fcs_Fcs_TrendingTelemetry item_ = (Fcs_Fcs_TrendingTelemetry)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
    }

    @Test
    public void sendReceiveFcs_Loader_Carrier_TrendingTelemetry() throws Exception {
        boolean atEngaged = false;
        boolean atHandoff = false;
        boolean atStorage = true;
        boolean controllerInError = false;
        boolean engagedSensorOn = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_Carrier_TrendingTelemetry(atEngaged, atHandoff, atStorage, controllerInError, engagedSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_Carrier_TrendingTelemetry));
        Fcs_Loader_Carrier_TrendingTelemetry item_ = (Fcs_Loader_Carrier_TrendingTelemetry)item;
        Assert.assertEquals((Object)atEngaged, (Object)item_.isAtEngaged());
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atStorage, (Object)item_.isAtStorage());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((Object)engagedSensorOn, (Object)item_.isEngagedSensorOn());
    }

    @Test
    public void sendReceiveFcs_Loader_Hooks_TrendingTelemetry() throws Exception {
        boolean allHooksInStateCLOSED = true;
        String clampState = "";
        boolean controllerInError = true;
        boolean forceClampedStatus = true;
        boolean forceOverClampedStatus = true;
        int forceSensorVoltage0 = 6;
        int forceSensorVoltage1 = 475;
        String forceStatus = "u";
        boolean forceUnclampedStatus = true;
        boolean forceUnderClampedStatus = false;
        boolean statuspublishedbyhook1_inError = true;
        boolean statuspublishedbyhook1_lockSensorOn = true;
        String statuspublishedbyhook1_lockStatus = "j";
        boolean statuspublishedbyhook1_unlockSensorOn = true;
        boolean statuspublishedbyhook2_inError = false;
        boolean statuspublishedbyhook2_lockSensorOn = true;
        String statuspublishedbyhook2_lockStatus = "";
        boolean statuspublishedbyhook2_unlockSensorOn = false;
        boolean statuspublishedbyhook3_inError = true;
        boolean statuspublishedbyhook3_lockSensorOn = false;
        String statuspublishedbyhook3_lockStatus = "";
        boolean statuspublishedbyhook3_unlockSensorOn = false;
        boolean statuspublishedbyhook4_inError = true;
        boolean statuspublishedbyhook4_lockSensorOn = false;
        String statuspublishedbyhook4_lockStatus = "";
        boolean statuspublishedbyhook4_unlockSensorOn = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_Hooks_TrendingTelemetry(allHooksInStateCLOSED, clampState, controllerInError, forceClampedStatus, forceOverClampedStatus, forceSensorVoltage0, forceSensorVoltage1, forceStatus, forceUnclampedStatus, forceUnderClampedStatus, statuspublishedbyhook1_inError, statuspublishedbyhook1_lockSensorOn, statuspublishedbyhook1_lockStatus, statuspublishedbyhook1_unlockSensorOn, statuspublishedbyhook2_inError, statuspublishedbyhook2_lockSensorOn, statuspublishedbyhook2_lockStatus, statuspublishedbyhook2_unlockSensorOn, statuspublishedbyhook3_inError, statuspublishedbyhook3_lockSensorOn, statuspublishedbyhook3_lockStatus, statuspublishedbyhook3_unlockSensorOn, statuspublishedbyhook4_inError, statuspublishedbyhook4_lockSensorOn, statuspublishedbyhook4_lockStatus, statuspublishedbyhook4_unlockSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_Hooks_TrendingTelemetry));
        Fcs_Loader_Hooks_TrendingTelemetry item_ = (Fcs_Loader_Hooks_TrendingTelemetry)item;
        Assert.assertEquals((Object)allHooksInStateCLOSED, (Object)item_.isAllHooksInStateCLOSED());
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((Object)forceClampedStatus, (Object)item_.isForceClampedStatus());
        Assert.assertEquals((Object)forceOverClampedStatus, (Object)item_.isForceOverClampedStatus());
        Assert.assertEquals((long)forceSensorVoltage0, (long)item_.getForceSensorVoltage0());
        Assert.assertEquals((long)forceSensorVoltage1, (long)item_.getForceSensorVoltage1());
        Assert.assertEquals((Object)forceStatus, (Object)item_.getForceStatus());
        Assert.assertEquals((Object)forceUnclampedStatus, (Object)item_.isForceUnclampedStatus());
        Assert.assertEquals((Object)forceUnderClampedStatus, (Object)item_.isForceUnderClampedStatus());
        Assert.assertEquals((Object)statuspublishedbyhook1_inError, (Object)item_.isStatuspublishedbyhook1_inError());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockSensorOn, (Object)item_.isStatuspublishedbyhook1_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockStatus, (Object)item_.getStatuspublishedbyhook1_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook1_unlockSensorOn, (Object)item_.isStatuspublishedbyhook1_unlockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook2_inError, (Object)item_.isStatuspublishedbyhook2_inError());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockSensorOn, (Object)item_.isStatuspublishedbyhook2_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockStatus, (Object)item_.getStatuspublishedbyhook2_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook2_unlockSensorOn, (Object)item_.isStatuspublishedbyhook2_unlockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook3_inError, (Object)item_.isStatuspublishedbyhook3_inError());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockSensorOn, (Object)item_.isStatuspublishedbyhook3_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockStatus, (Object)item_.getStatuspublishedbyhook3_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook3_unlockSensorOn, (Object)item_.isStatuspublishedbyhook3_unlockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook4_inError, (Object)item_.isStatuspublishedbyhook4_inError());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockSensorOn, (Object)item_.isStatuspublishedbyhook4_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockStatus, (Object)item_.getStatuspublishedbyhook4_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook4_unlockSensorOn, (Object)item_.isStatuspublishedbyhook4_unlockSensorOn());
    }

    @Test
    public void sendReceiveFcs_Loader_TrendingTelemetry() throws Exception {
        String id = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_TrendingTelemetry(id));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_TrendingTelemetry));
        Fcs_Loader_TrendingTelemetry item_ = (Fcs_Loader_TrendingTelemetry)item;
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }

    @Test
    public void sendReceiveFcs_TrendingTelemetry() throws Exception {
        int canbus0 = 897;
        int canbus1 = 775;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_TrendingTelemetry(canbus0, canbus1));
        Assert.assertTrue((boolean)(item instanceof Fcs_TrendingTelemetry));
        Fcs_TrendingTelemetry item_ = (Fcs_TrendingTelemetry)item;
        Assert.assertEquals((long)canbus0, (long)item_.getCanbus0());
        Assert.assertEquals((long)canbus1, (long)item_.getCanbus1());
    }

    @Test
    public void sendReceiveShutter_TrendingTelemetry() throws Exception {
        double minusx_strokeCount = 0.4268566370010376;
        double plusx_strokeCount = 0.6490969657897949;
        double shutterstatus_axstatus_MINUSX_actPos = 0.7862998247146606;
        double shutterstatus_axstatus_MINUSX_actVel = 0.5364422798156738;
        int shutterstatus_axstatus_MINUSX_brakeEngaged = 374;
        double shutterstatus_axstatus_MINUSX_ctrlTemp = 0.6283974647521973;
        int shutterstatus_axstatus_MINUSX_enabled = 911;
        int shutterstatus_axstatus_MINUSX_errorID = 818;
        int shutterstatus_axstatus_MINUSX_hasSafeTemp = 827;
        int shutterstatus_axstatus_MINUSX_highLimit = 838;
        int shutterstatus_axstatus_MINUSX_isHomed = 93;
        int shutterstatus_axstatus_MINUSX_lowLimit = 761;
        double shutterstatus_axstatus_MINUSX_setAcc = 0.22070544958114624;
        double shutterstatus_axstatus_PLUSX_actPos = 0.009875476360321045;
        double shutterstatus_axstatus_PLUSX_actVel = 0.8023363351821899;
        int shutterstatus_axstatus_PLUSX_brakeEngaged = 984;
        double shutterstatus_axstatus_PLUSX_ctrlTemp = 0.4160711169242859;
        int shutterstatus_axstatus_PLUSX_enabled = 870;
        int shutterstatus_axstatus_PLUSX_errorID = 949;
        int shutterstatus_axstatus_PLUSX_hasSafeTemp = 275;
        int shutterstatus_axstatus_PLUSX_highLimit = 879;
        int shutterstatus_axstatus_PLUSX_isHomed = 410;
        int shutterstatus_axstatus_PLUSX_lowLimit = 613;
        double shutterstatus_axstatus_PLUSX_setAcc = 0.3637155294418335;
        int shutterstatus_brakePowerIsOn = 518;
        double shutterstatus_creationTime = 0.8313478231430054;
        int shutterstatus_isCalibrated = 197;
        int shutterstatus_isSafetyOn = 745;
        int shutterstatus_leapIsValid = 419;
        int shutterstatus_leapSeconds = 644;
        int shutterstatus_motionProfile = 14;
        int shutterstatus_ptpState = 319;
        int shutterstatus_smState = 59;
        int shutterstatus_tempIsSafe_CONTROL_BOX = 492;
        int shutterstatus_tempIsSafe_MINUSX_MOTOR = 980;
        int shutterstatus_tempIsSafe_PLUSX_MOTOR = 957;
        double shutterstatus_temperature_CONTROL_BOX = 0.42789143323898315;
        double shutterstatus_temperature_MINUSX_MOTOR = 0.8842554092407227;
        double shutterstatus_temperature_PLUSX_MOTOR = 0.07913511991500854;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Shutter_TrendingTelemetry(minusx_strokeCount, plusx_strokeCount, shutterstatus_axstatus_MINUSX_actPos, shutterstatus_axstatus_MINUSX_actVel, shutterstatus_axstatus_MINUSX_brakeEngaged, shutterstatus_axstatus_MINUSX_ctrlTemp, shutterstatus_axstatus_MINUSX_enabled, shutterstatus_axstatus_MINUSX_errorID, shutterstatus_axstatus_MINUSX_hasSafeTemp, shutterstatus_axstatus_MINUSX_highLimit, shutterstatus_axstatus_MINUSX_isHomed, shutterstatus_axstatus_MINUSX_lowLimit, shutterstatus_axstatus_MINUSX_setAcc, shutterstatus_axstatus_PLUSX_actPos, shutterstatus_axstatus_PLUSX_actVel, shutterstatus_axstatus_PLUSX_brakeEngaged, shutterstatus_axstatus_PLUSX_ctrlTemp, shutterstatus_axstatus_PLUSX_enabled, shutterstatus_axstatus_PLUSX_errorID, shutterstatus_axstatus_PLUSX_hasSafeTemp, shutterstatus_axstatus_PLUSX_highLimit, shutterstatus_axstatus_PLUSX_isHomed, shutterstatus_axstatus_PLUSX_lowLimit, shutterstatus_axstatus_PLUSX_setAcc, shutterstatus_brakePowerIsOn, shutterstatus_creationTime, shutterstatus_isCalibrated, shutterstatus_isSafetyOn, shutterstatus_leapIsValid, shutterstatus_leapSeconds, shutterstatus_motionProfile, shutterstatus_ptpState, shutterstatus_smState, shutterstatus_tempIsSafe_CONTROL_BOX, shutterstatus_tempIsSafe_MINUSX_MOTOR, shutterstatus_tempIsSafe_PLUSX_MOTOR, shutterstatus_temperature_CONTROL_BOX, shutterstatus_temperature_MINUSX_MOTOR, shutterstatus_temperature_PLUSX_MOTOR));
        Assert.assertTrue((boolean)(item instanceof Shutter_TrendingTelemetry));
        Shutter_TrendingTelemetry item_ = (Shutter_TrendingTelemetry)item;
        Assert.assertEquals((double)minusx_strokeCount, (double)item_.getMinusx_strokeCount(), (double)1.0E-6f);
        Assert.assertEquals((double)plusx_strokeCount, (double)item_.getPlusx_strokeCount(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_actPos, (double)item_.getShutterstatus_axstatus_MINUSX_actPos(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_actVel, (double)item_.getShutterstatus_axstatus_MINUSX_actVel(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_brakeEngaged, (long)item_.getShutterstatus_axstatus_MINUSX_brakeEngaged());
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_ctrlTemp, (double)item_.getShutterstatus_axstatus_MINUSX_ctrlTemp(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_enabled, (long)item_.getShutterstatus_axstatus_MINUSX_enabled());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_errorID, (long)item_.getShutterstatus_axstatus_MINUSX_errorID());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_hasSafeTemp, (long)item_.getShutterstatus_axstatus_MINUSX_hasSafeTemp());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_highLimit, (long)item_.getShutterstatus_axstatus_MINUSX_highLimit());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_isHomed, (long)item_.getShutterstatus_axstatus_MINUSX_isHomed());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_lowLimit, (long)item_.getShutterstatus_axstatus_MINUSX_lowLimit());
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_setAcc, (double)item_.getShutterstatus_axstatus_MINUSX_setAcc(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_actPos, (double)item_.getShutterstatus_axstatus_PLUSX_actPos(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_actVel, (double)item_.getShutterstatus_axstatus_PLUSX_actVel(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_brakeEngaged, (long)item_.getShutterstatus_axstatus_PLUSX_brakeEngaged());
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_ctrlTemp, (double)item_.getShutterstatus_axstatus_PLUSX_ctrlTemp(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_enabled, (long)item_.getShutterstatus_axstatus_PLUSX_enabled());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_errorID, (long)item_.getShutterstatus_axstatus_PLUSX_errorID());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_hasSafeTemp, (long)item_.getShutterstatus_axstatus_PLUSX_hasSafeTemp());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_highLimit, (long)item_.getShutterstatus_axstatus_PLUSX_highLimit());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_isHomed, (long)item_.getShutterstatus_axstatus_PLUSX_isHomed());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_lowLimit, (long)item_.getShutterstatus_axstatus_PLUSX_lowLimit());
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_setAcc, (double)item_.getShutterstatus_axstatus_PLUSX_setAcc(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_brakePowerIsOn, (long)item_.getShutterstatus_brakePowerIsOn());
        Assert.assertEquals((double)shutterstatus_creationTime, (double)item_.getShutterstatus_creationTime(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_isCalibrated, (long)item_.getShutterstatus_isCalibrated());
        Assert.assertEquals((long)shutterstatus_isSafetyOn, (long)item_.getShutterstatus_isSafetyOn());
        Assert.assertEquals((long)shutterstatus_leapIsValid, (long)item_.getShutterstatus_leapIsValid());
        Assert.assertEquals((long)shutterstatus_leapSeconds, (long)item_.getShutterstatus_leapSeconds());
        Assert.assertEquals((long)shutterstatus_motionProfile, (long)item_.getShutterstatus_motionProfile());
        Assert.assertEquals((long)shutterstatus_ptpState, (long)item_.getShutterstatus_ptpState());
        Assert.assertEquals((long)shutterstatus_smState, (long)item_.getShutterstatus_smState());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_CONTROL_BOX, (long)item_.getShutterstatus_tempIsSafe_CONTROL_BOX());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_MINUSX_MOTOR, (long)item_.getShutterstatus_tempIsSafe_MINUSX_MOTOR());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_PLUSX_MOTOR, (long)item_.getShutterstatus_tempIsSafe_PLUSX_MOTOR());
        Assert.assertEquals((double)shutterstatus_temperature_CONTROL_BOX, (double)item_.getShutterstatus_temperature_CONTROL_BOX(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_temperature_MINUSX_MOTOR, (double)item_.getShutterstatus_temperature_MINUSX_MOTOR(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_temperature_PLUSX_MOTOR, (double)item_.getShutterstatus_temperature_PLUSX_MOTOR(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_ChillerTelemetry() throws Exception {
        double cascadeSetPoint = 0.42557162046432495;
        double chillerPumpLife = 0.9359580874443054;
        double chillerValveAct = 0.7874302268028259;
        double compressorLife = 0.31137293577194214;
        double controllerLife = 0.924130380153656;
        double coolPercentage = 0.9697383046150208;
        double flowRate = 0.05205410718917847;
        double flowSetPoint = 0.8581818342208862;
        double fluidTemperature = 0.06957560777664185;
        double heatPercentage = 0.874868631362915;
        double importedColdTemp = 0.8882201313972473;
        double pressureIn = 0.9107673764228821;
        double pressureOut = 0.16994398832321167;
        double pressureTank = 0.868675172328949;
        double tankLevel = 0.2835896f;
        double tankSetPoint = 0.05593979358673096;
        double tempCondenser = 0.2168892f;
        double tempDUTInput = 0.9221897721290588;
        double tempDynamicSetPt = 0.5488749146461487;
        double tempSetPoint = 0.4958648085594177;
        double tempStage2Evap = 0.06514471769332886;
        double tempTXVBulb = 0.27671295404434204;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_ChillerTelemetry(cascadeSetPoint, chillerPumpLife, chillerValveAct, compressorLife, controllerLife, coolPercentage, flowRate, flowSetPoint, fluidTemperature, heatPercentage, importedColdTemp, pressureIn, pressureOut, pressureTank, tankLevel, tankSetPoint, tempCondenser, tempDUTInput, tempDynamicSetPt, tempSetPoint, tempStage2Evap, tempTXVBulb));
        Assert.assertTrue((boolean)(item instanceof Chiller_ChillerTelemetry));
        Chiller_ChillerTelemetry item_ = (Chiller_ChillerTelemetry)item;
        Assert.assertEquals((double)cascadeSetPoint, (double)item_.getCascadeSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)chillerPumpLife, (double)item_.getChillerPumpLife(), (double)1.0E-6f);
        Assert.assertEquals((double)chillerValveAct, (double)item_.getChillerValveAct(), (double)1.0E-6f);
        Assert.assertEquals((double)compressorLife, (double)item_.getCompressorLife(), (double)1.0E-6f);
        Assert.assertEquals((double)controllerLife, (double)item_.getControllerLife(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPercentage, (double)item_.getCoolPercentage(), (double)1.0E-6f);
        Assert.assertEquals((double)flowRate, (double)item_.getFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)flowSetPoint, (double)item_.getFlowSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)fluidTemperature, (double)item_.getFluidTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)heatPercentage, (double)item_.getHeatPercentage(), (double)1.0E-6f);
        Assert.assertEquals((double)importedColdTemp, (double)item_.getImportedColdTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureIn, (double)item_.getPressureIn(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureOut, (double)item_.getPressureOut(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureTank, (double)item_.getPressureTank(), (double)1.0E-6f);
        Assert.assertEquals((double)tankLevel, (double)item_.getTankLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)tankSetPoint, (double)item_.getTankSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCondenser, (double)item_.getTempCondenser(), (double)1.0E-6f);
        Assert.assertEquals((double)tempDUTInput, (double)item_.getTempDUTInput(), (double)1.0E-6f);
        Assert.assertEquals((double)tempDynamicSetPt, (double)item_.getTempDynamicSetPt(), (double)1.0E-6f);
        Assert.assertEquals((double)tempSetPoint, (double)item_.getTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempStage2Evap, (double)item_.getTempStage2Evap(), (double)1.0E-6f);
        Assert.assertEquals((double)tempTXVBulb, (double)item_.getTempTXVBulb(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_FParam_TrendingTelemetry() throws Exception {
        double bubblev_TIME = 0.599086344242096;
        double clr_KI_SETPT = 0.17902839183807373;
        double cold_PERIOD = 0.3901596f;
        double cool_CAPACITY = 0.9397789239883423;
        double dut_DT_HI = 0.7856447696685791;
        double dut_DT_LO = 0.37990695238113403;
        double dut_KI = 0.17291146516799927;
        double dut_KP = 0.07425785064697266;
        double dut_TMAX = 0.8740844130516052;
        double dut_TMIN = 0.33533287048339844;
        double flowmeter_LO = 0.15119624137878418;
        double flow_ERR_MASK = 0.07528811693191528;
        double heat_CAPACITY = 0.40137147903442383;
        double heat_PERIOD = 0.28993552923202515;
        double pid_GAINFAC = 0.41465938091278076;
        double pid_KD = 0.9252957105636597;
        double pid_KI = 0.322601854801178;
        double pid_KP = 0.48791468143463135;
        double purge_TIME = 0.16603630781173706;
        double ramp_DEFAULT = 0.12070101499557495;
        double refrig_OFF = 0.3239043951034546;
        double setpt_SETTLE = 0.05600255727767944;
        double setpt_TOL = 0.38620704412460327;
        double tank_SETPOINT = 0.7088211178779602;
        double thermsl_MASS = 0.01976090669631958;
        double t_CTRL_MODE = 0.4006343483924866;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_FParam_TrendingTelemetry(bubblev_TIME, clr_KI_SETPT, cold_PERIOD, cool_CAPACITY, dut_DT_HI, dut_DT_LO, dut_KI, dut_KP, dut_TMAX, dut_TMIN, flowmeter_LO, flow_ERR_MASK, heat_CAPACITY, heat_PERIOD, pid_GAINFAC, pid_KD, pid_KI, pid_KP, purge_TIME, ramp_DEFAULT, refrig_OFF, setpt_SETTLE, setpt_TOL, tank_SETPOINT, thermsl_MASS, t_CTRL_MODE));
        Assert.assertTrue((boolean)(item instanceof Chiller_FParam_TrendingTelemetry));
        Chiller_FParam_TrendingTelemetry item_ = (Chiller_FParam_TrendingTelemetry)item;
        Assert.assertEquals((double)bubblev_TIME, (double)item_.getBubblev_TIME(), (double)1.0E-6f);
        Assert.assertEquals((double)clr_KI_SETPT, (double)item_.getClr_KI_SETPT(), (double)1.0E-6f);
        Assert.assertEquals((double)cold_PERIOD, (double)item_.getCold_PERIOD(), (double)1.0E-6f);
        Assert.assertEquals((double)cool_CAPACITY, (double)item_.getCool_CAPACITY(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_DT_HI, (double)item_.getDut_DT_HI(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_DT_LO, (double)item_.getDut_DT_LO(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_KI, (double)item_.getDut_KI(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_KP, (double)item_.getDut_KP(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_TMAX, (double)item_.getDut_TMAX(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_TMIN, (double)item_.getDut_TMIN(), (double)1.0E-6f);
        Assert.assertEquals((double)flowmeter_LO, (double)item_.getFlowmeter_LO(), (double)1.0E-6f);
        Assert.assertEquals((double)flow_ERR_MASK, (double)item_.getFlow_ERR_MASK(), (double)1.0E-6f);
        Assert.assertEquals((double)heat_CAPACITY, (double)item_.getHeat_CAPACITY(), (double)1.0E-6f);
        Assert.assertEquals((double)heat_PERIOD, (double)item_.getHeat_PERIOD(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_GAINFAC, (double)item_.getPid_GAINFAC(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KD, (double)item_.getPid_KD(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KI, (double)item_.getPid_KI(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KP, (double)item_.getPid_KP(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_TIME, (double)item_.getPurge_TIME(), (double)1.0E-6f);
        Assert.assertEquals((double)ramp_DEFAULT, (double)item_.getRamp_DEFAULT(), (double)1.0E-6f);
        Assert.assertEquals((double)refrig_OFF, (double)item_.getRefrig_OFF(), (double)1.0E-6f);
        Assert.assertEquals((double)setpt_SETTLE, (double)item_.getSetpt_SETTLE(), (double)1.0E-6f);
        Assert.assertEquals((double)setpt_TOL, (double)item_.getSetpt_TOL(), (double)1.0E-6f);
        Assert.assertEquals((double)tank_SETPOINT, (double)item_.getTank_SETPOINT(), (double)1.0E-6f);
        Assert.assertEquals((double)thermsl_MASS, (double)item_.getThermsl_MASS(), (double)1.0E-6f);
        Assert.assertEquals((double)t_CTRL_MODE, (double)item_.getT_CTRL_MODE(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_Maq20Telemetry() throws Exception {
        double ambientTemp = 0.4415629506111145;
        double cabinetTemp = 0.28436142206192017;
        double coldPlHeatXfer = 0.1298086f;
        double coolantHXOut = 0.2545584440231323;
        double coolantHeatXfer = 0.4777735471725464;
        double coolantPumpIn = 0.8367952108383179;
        double coolantPumpOut = 0.631755530834198;
        double coolantReturn = 0.18347585201263428;
        double coolantSupply = 0.12640488147735596;
        double fan1Speed = 0.16851598024368286;
        double fan2Speed = 0.38071537017822266;
        double glycChillerIn = 0.5465285181999207;
        double glycChillerOut = 0.6851654052734375;
        double glycCondensOut = 0.915206f;
        double glycDeSuHtrFlow = 0.16654521226882935;
        double glycDeSuHtrOut = 0.20591431856155396;
        double glycFanIn = 0.5471704602241516;
        double glycFanOut = 0.5813068151473999;
        double glycHeatXfer = 0.12329727411270142;
        double glycInputFlow = 0.8265628218650818;
        double glycSupplyP = 0.4809582829475403;
        double pBurstReturn = 0.1823439f;
        double pBurstSupply = 0.6104175448417664;
        double stg1CondensOut = 0.2882691025733948;
        double stg1Discharge = 0.08563566207885742;
        double stg1Return = 0.1803167462348938;
        double stg1TXVBulb = 0.5337334275245667;
        double stg2DeSuHtrOut = 0.4571717381477356;
        double stg2Discharge = 0.7521734833717346;
        double stg2DischargeP = 0.16719353199005127;
        double stg2EvapIn = 0.7735707759857178;
        double stg2EvapOut = 0.5038366317749023;
        double stg2Return = 0.09332907199859619;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_Maq20Telemetry(ambientTemp, cabinetTemp, coldPlHeatXfer, coolantHXOut, coolantHeatXfer, coolantPumpIn, coolantPumpOut, coolantReturn, coolantSupply, fan1Speed, fan2Speed, glycChillerIn, glycChillerOut, glycCondensOut, glycDeSuHtrFlow, glycDeSuHtrOut, glycFanIn, glycFanOut, glycHeatXfer, glycInputFlow, glycSupplyP, pBurstReturn, pBurstSupply, stg1CondensOut, stg1Discharge, stg1Return, stg1TXVBulb, stg2DeSuHtrOut, stg2Discharge, stg2DischargeP, stg2EvapIn, stg2EvapOut, stg2Return));
        Assert.assertTrue((boolean)(item instanceof Chiller_Maq20Telemetry));
        Chiller_Maq20Telemetry item_ = (Chiller_Maq20Telemetry)item;
        Assert.assertEquals((double)ambientTemp, (double)item_.getAmbientTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTemp, (double)item_.getCabinetTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coldPlHeatXfer, (double)item_.getColdPlHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantHXOut, (double)item_.getCoolantHXOut(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantHeatXfer, (double)item_.getCoolantHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantPumpIn, (double)item_.getCoolantPumpIn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantPumpOut, (double)item_.getCoolantPumpOut(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantReturn, (double)item_.getCoolantReturn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantSupply, (double)item_.getCoolantSupply(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)glycChillerIn, (double)item_.getGlycChillerIn(), (double)1.0E-6f);
        Assert.assertEquals((double)glycChillerOut, (double)item_.getGlycChillerOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycCondensOut, (double)item_.getGlycCondensOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycDeSuHtrFlow, (double)item_.getGlycDeSuHtrFlow(), (double)1.0E-6f);
        Assert.assertEquals((double)glycDeSuHtrOut, (double)item_.getGlycDeSuHtrOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycFanIn, (double)item_.getGlycFanIn(), (double)1.0E-6f);
        Assert.assertEquals((double)glycFanOut, (double)item_.getGlycFanOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycHeatXfer, (double)item_.getGlycHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)glycInputFlow, (double)item_.getGlycInputFlow(), (double)1.0E-6f);
        Assert.assertEquals((double)glycSupplyP, (double)item_.getGlycSupplyP(), (double)1.0E-6f);
        Assert.assertEquals((double)pBurstReturn, (double)item_.getPBurstReturn(), (double)1.0E-6f);
        Assert.assertEquals((double)pBurstSupply, (double)item_.getPBurstSupply(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1CondensOut, (double)item_.getStg1CondensOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1Discharge, (double)item_.getStg1Discharge(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1Return, (double)item_.getStg1Return(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1TXVBulb, (double)item_.getStg1TXVBulb(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2DeSuHtrOut, (double)item_.getStg2DeSuHtrOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2Discharge, (double)item_.getStg2Discharge(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2DischargeP, (double)item_.getStg2DischargeP(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2EvapIn, (double)item_.getStg2EvapIn(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2EvapOut, (double)item_.getStg2EvapOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2Return, (double)item_.getStg2Return(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Cold_TempTelemetry() throws Exception {
        double avgColdTemp = 0.8441801071166992;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Cold_TempTelemetry(avgColdTemp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Cold_TempTelemetry));
        Thermal_Cold_TempTelemetry item_ = (Thermal_Cold_TempTelemetry)item;
        Assert.assertEquals((double)avgColdTemp, (double)item_.getAvgColdTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Cryo_TempTelemetry() throws Exception {
        double avgCryoTemp = 0.2236635684967041;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Cryo_TempTelemetry(avgCryoTemp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Cryo_TempTelemetry));
        Thermal_Cryo_TempTelemetry item_ = (Thermal_Cryo_TempTelemetry)item;
        Assert.assertEquals((double)avgCryoTemp, (double)item_.getAvgCryoTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_RtdTelemetry() throws Exception {
        double[] cold_TempCLP = TestHelper.generateDoubleArray((int)25, (int)-859271221);
        double[] cryo_TempCYP = TestHelper.generateDoubleArray((int)25, (int)-1696962780);
        double[] grid_TempCFX = TestHelper.generateDoubleArray((int)25, (int)218540892);
        double[] grid_TempGFX = TestHelper.generateDoubleArray((int)25, (int)-2009511067);
        double[] grid_TempGRD = TestHelper.generateDoubleArray((int)25, (int)-1594726284);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_RtdTelemetry(cold_TempCLP, cryo_TempCYP, grid_TempCFX, grid_TempGFX, grid_TempGRD, location));
        Assert.assertTrue((boolean)(item instanceof Thermal_RtdTelemetry));
        Thermal_RtdTelemetry item_ = (Thermal_RtdTelemetry)item;
        Assert.assertArrayEquals((double[])cold_TempCLP, (double[])item_.getCold_TempCLP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_TempCYP, (double[])item_.getCryo_TempCYP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_TempCFX, (double[])item_.getGrid_TempCFX(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_TempGFX, (double[])item_.getGrid_TempGFX(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_TempGRD, (double[])item_.getGrid_TempGRD(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveThermal_TrimTelemetry() throws Exception {
        String location = "";
        double[] trim_Htrs_ColdI = TestHelper.generateDoubleArray((int)6, (int)717308297);
        double[] trim_Htrs_ColdP = TestHelper.generateDoubleArray((int)6, (int)-104354805);
        double[] trim_Htrs_ColdV = TestHelper.generateDoubleArray((int)6, (int)-917111559);
        double[] trim_Htrs_CryoI = TestHelper.generateDoubleArray((int)6, (int)1225871073);
        double[] trim_Htrs_CryoP = TestHelper.generateDoubleArray((int)6, (int)-324385454);
        double[] trim_Htrs_CryoV = TestHelper.generateDoubleArray((int)6, (int)1122937803);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_TrimTelemetry(location, trim_Htrs_ColdI, trim_Htrs_ColdP, trim_Htrs_ColdV, trim_Htrs_CryoI, trim_Htrs_CryoP, trim_Htrs_CryoV));
        Assert.assertTrue((boolean)(item instanceof Thermal_TrimTelemetry));
        Thermal_TrimTelemetry item_ = (Thermal_TrimTelemetry)item;
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])trim_Htrs_ColdI, (double[])item_.getTrim_Htrs_ColdI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_ColdP, (double[])item_.getTrim_Htrs_ColdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_ColdV, (double[])item_.getTrim_Htrs_ColdV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_CryoI, (double[])item_.getTrim_Htrs_CryoI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_CryoP, (double[])item_.getTrim_Htrs_CryoP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_CryoV, (double[])item_.getTrim_Htrs_CryoV(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Trim_HtrsTelemetry() throws Exception {
        double coldtotal_P = 0.9719770550727844;
        double cryototal_P = 0.891740620136261;
        double htrBulkTmp = 0.5556915402412415;
        double htrbulk_I = 0.2866741418838501;
        double htrbulk_P = 0.5823656916618347;
        double htrbulk_V = 0.12648552656173706;
        double htrPsTmp = 0.23666197061538696;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Trim_HtrsTelemetry(coldtotal_P, cryototal_P, htrBulkTmp, htrbulk_I, htrbulk_P, htrbulk_V, htrPsTmp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Trim_HtrsTelemetry));
        Thermal_Trim_HtrsTelemetry item_ = (Thermal_Trim_HtrsTelemetry)item;
        Assert.assertEquals((double)coldtotal_P, (double)item_.getColdtotal_P(), (double)1.0E-6f);
        Assert.assertEquals((double)cryototal_P, (double)item_.getCryototal_P(), (double)1.0E-6f);
        Assert.assertEquals((double)htrBulkTmp, (double)item_.getHtrBulkTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_I, (double)item_.getHtrbulk_I(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_P, (double)item_.getHtrbulk_P(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_V, (double)item_.getHtrbulk_V(), (double)1.0E-6f);
        Assert.assertEquals((double)htrPsTmp, (double)item_.getHtrPsTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_BodyTelemetry() throws Exception {
        double ambAirtemp = 0.9017212986946106;
        double averageTemp = 0.9992961287498474;
        double backFlngXMinusTemp = 0.4836227297782898;
        double backFlngXPlusTemp = 0.14709758758544922;
        double backFlngYMinusTemp = 0.015478968620300293;
        double camBodyXPlusTemp = 0.30750203132629395;
        double camBodyYMinusTemp = 0.8708362579345703;
        double camBodyYPlusTemp = 0.294458270072937;
        double camHousXMinusTemp = 0.8241126537322998;
        double camHousXPlusTemp = 0.579692542552948;
        double camHousYMinusTemp = 0.28557586669921875;
        double camHousYPlusTemp = 0.8273983001708984;
        double chgrYMinusRtnAirTemp = 0.3798535466194153;
        double chgrYMinusRtnAirVel = 0.930725f;
        double domeXMinusTemp = 0.753924548625946;
        double domeYMinusTemp = 0.6690660715103149;
        double l1XMinusTemp = 0.4134852886199951;
        double l1YMinusTemp = 0.947879433631897;
        double l2XMinusTemp = 0.9826995730400085;
        double l2XPlusTemp = 0.1820578f;
        double l2YPlusTemp = 0.26623213291168213;
        double shrdRngXMinusTemp = 0.9464045166969299;
        double shrdRngXPlusTemp = 0.6596095561981201;
        double shrdRngYMinusTemp = 0.3989271f;
        double shrdRngYPlusTemp = 0.737616777420044;
        double shtrEboxRtnAirTemp = 0.40024787187576294;
        double shtrEboxRtnAirVel = 0.40621328353881836;
        double shtrMtrRtnAirTemp = 0.8386217355728149;
        double shtrMtrRtnAirVel = 0.9915530681610107;
        double vPPlenumInTemp = 0.33848655223846436;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_BodyTelemetry(ambAirtemp, averageTemp, backFlngXMinusTemp, backFlngXPlusTemp, backFlngYMinusTemp, camBodyXPlusTemp, camBodyYMinusTemp, camBodyYPlusTemp, camHousXMinusTemp, camHousXPlusTemp, camHousYMinusTemp, camHousYPlusTemp, chgrYMinusRtnAirTemp, chgrYMinusRtnAirVel, domeXMinusTemp, domeYMinusTemp, l1XMinusTemp, l1YMinusTemp, l2XMinusTemp, l2XPlusTemp, l2YPlusTemp, shrdRngXMinusTemp, shrdRngXPlusTemp, shrdRngYMinusTemp, shrdRngYPlusTemp, shtrEboxRtnAirTemp, shtrEboxRtnAirVel, shtrMtrRtnAirTemp, shtrMtrRtnAirVel, vPPlenumInTemp));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_BodyTelemetry));
        Utiltrunk_BodyTelemetry item_ = (Utiltrunk_BodyTelemetry)item;
        Assert.assertEquals((double)ambAirtemp, (double)item_.getAmbAirtemp(), (double)1.0E-6f);
        Assert.assertEquals((double)averageTemp, (double)item_.getAverageTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngXMinusTemp, (double)item_.getBackFlngXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngXPlusTemp, (double)item_.getBackFlngXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngYMinusTemp, (double)item_.getBackFlngYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyXPlusTemp, (double)item_.getCamBodyXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyYMinusTemp, (double)item_.getCamBodyYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyYPlusTemp, (double)item_.getCamBodyYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousXMinusTemp, (double)item_.getCamHousXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousXPlusTemp, (double)item_.getCamHousXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousYMinusTemp, (double)item_.getCamHousYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousYPlusTemp, (double)item_.getCamHousYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)chgrYMinusRtnAirTemp, (double)item_.getChgrYMinusRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)chgrYMinusRtnAirVel, (double)item_.getChgrYMinusRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)domeXMinusTemp, (double)item_.getDomeXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)domeYMinusTemp, (double)item_.getDomeYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l1XMinusTemp, (double)item_.getL1XMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l1YMinusTemp, (double)item_.getL1YMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2XMinusTemp, (double)item_.getL2XMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2XPlusTemp, (double)item_.getL2XPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2YPlusTemp, (double)item_.getL2YPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngXMinusTemp, (double)item_.getShrdRngXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngXPlusTemp, (double)item_.getShrdRngXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngYMinusTemp, (double)item_.getShrdRngYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngYPlusTemp, (double)item_.getShrdRngYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrEboxRtnAirTemp, (double)item_.getShtrEboxRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrEboxRtnAirVel, (double)item_.getShtrEboxRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrMtrRtnAirTemp, (double)item_.getShtrMtrRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrMtrRtnAirVel, (double)item_.getShtrMtrRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)vPPlenumInTemp, (double)item_.getVPPlenumInTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_MPCTelemetry() throws Exception {
        double avgAirtempOut = 0.021392107009887695;
        double deltaPressFilt = 0.1318148970603943;
        double deltaPressTotal = 0.5250653624534607;
        double deltaTempAct = 0.41299957036972046;
        double fanRunTime = 0.21723055839538574;
        double fanSpeed = 0.22669953107833862;
        double humidity = 0.7498044371604919;
        double preFiltPress = 0.3700758218765259;
        double retnAirTemp = 0.5533856153488159;
        double retnPress = 0.29943495988845825;
        double splyAirTemp = 0.38881915807724;
        double splyPress = 0.3887394070625305;
        double valvePosn = 0.619625449180603;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_MPCTelemetry(avgAirtempOut, deltaPressFilt, deltaPressTotal, deltaTempAct, fanRunTime, fanSpeed, humidity, preFiltPress, retnAirTemp, retnPress, splyAirTemp, splyPress, valvePosn));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_MPCTelemetry));
        Utiltrunk_MPCTelemetry item_ = (Utiltrunk_MPCTelemetry)item;
        Assert.assertEquals((double)avgAirtempOut, (double)item_.getAvgAirtempOut(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressFilt, (double)item_.getDeltaPressFilt(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressTotal, (double)item_.getDeltaPressTotal(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaTempAct, (double)item_.getDeltaTempAct(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)humidity, (double)item_.getHumidity(), (double)1.0E-6f);
        Assert.assertEquals((double)preFiltPress, (double)item_.getPreFiltPress(), (double)1.0E-6f);
        Assert.assertEquals((double)retnAirTemp, (double)item_.getRetnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)retnPress, (double)item_.getRetnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirTemp, (double)item_.getSplyAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)splyPress, (double)item_.getSplyPress(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_UTTelemetry() throws Exception {
        double averageTemp = 0.1862025260925293;
        double coolFlowRate = 0.5883095860481262;
        double coolHeatXfer = 0.9755542278289795;
        double coolPipeRetnTemp = 0.7392749190330505;
        double coolPipeSplyTemp = 0.05100148916244507;
        double domeXMinusTemp = 0.09044337272644043;
        double domeYMinusTemp = 0.07660460472106934;
        double fanInletTemp = 0.999482274055481;
        double fanRunTime = 0.5472816824913025;
        double fanSpeed = 0.728481113910675;
        double midXMinusTemp = 0.7324390411376953;
        double midXPlusTemp = 0.32880693674087524;
        double suppXMinusTemp = 0.19277018308639526;
        double suppXPlusTemp = 0.874784529209137;
        double topXMinusTemp = 0.86432284116745;
        double topXPlusTemp = 0.6005339026451111;
        double valvePosn = 0.4040418267250061;
        double w2Q1Temp = 0.796747f;
        double w4Q3Temp = 0.7466294765472412;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_UTTelemetry(averageTemp, coolFlowRate, coolHeatXfer, coolPipeRetnTemp, coolPipeSplyTemp, domeXMinusTemp, domeYMinusTemp, fanInletTemp, fanRunTime, fanSpeed, midXMinusTemp, midXPlusTemp, suppXMinusTemp, suppXPlusTemp, topXMinusTemp, topXPlusTemp, valvePosn, w2Q1Temp, w4Q3Temp));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_UTTelemetry));
        Utiltrunk_UTTelemetry item_ = (Utiltrunk_UTTelemetry)item;
        Assert.assertEquals((double)averageTemp, (double)item_.getAverageTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolHeatXfer, (double)item_.getCoolHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPipeRetnTemp, (double)item_.getCoolPipeRetnTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPipeSplyTemp, (double)item_.getCoolPipeSplyTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)domeXMinusTemp, (double)item_.getDomeXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)domeYMinusTemp, (double)item_.getDomeYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanInletTemp, (double)item_.getFanInletTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)midXMinusTemp, (double)item_.getMidXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)midXPlusTemp, (double)item_.getMidXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)suppXMinusTemp, (double)item_.getSuppXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)suppXPlusTemp, (double)item_.getSuppXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)topXMinusTemp, (double)item_.getTopXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)topXPlusTemp, (double)item_.getTopXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)w2Q1Temp, (double)item_.getW2Q1Temp(), (double)1.0E-6f);
        Assert.assertEquals((double)w4Q3Temp, (double)item_.getW4Q3Temp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_VPCTelemetry() throws Exception {
        double deltaPressFilt = 0.4438938f;
        double deltaPressTotal = 0.3072632f;
        double deltaTempAct = 0.4218948f;
        double fanRunTime = 0.9501662850379944;
        double fanSpeed = 0.08815860748291016;
        double htrCurrent = 0.3089906f;
        double humidity = 0.06358063220977783;
        double preFiltPress = 0.29738521575927734;
        double retnAirTemp = 0.28019845485687256;
        double retnPress = 0.5589306950569153;
        double splyAirTemp = 0.7606868147850037;
        double splyAirVel = 0.868586003780365;
        double splyPress = 0.1289190649986267;
        double valvePosn = 0.02631556987762451;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_VPCTelemetry(deltaPressFilt, deltaPressTotal, deltaTempAct, fanRunTime, fanSpeed, htrCurrent, humidity, preFiltPress, retnAirTemp, retnPress, splyAirTemp, splyAirVel, splyPress, valvePosn));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_VPCTelemetry));
        Utiltrunk_VPCTelemetry item_ = (Utiltrunk_VPCTelemetry)item;
        Assert.assertEquals((double)deltaPressFilt, (double)item_.getDeltaPressFilt(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressTotal, (double)item_.getDeltaPressTotal(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaTempAct, (double)item_.getDeltaTempAct(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)htrCurrent, (double)item_.getHtrCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)humidity, (double)item_.getHumidity(), (double)1.0E-6f);
        Assert.assertEquals((double)preFiltPress, (double)item_.getPreFiltPress(), (double)1.0E-6f);
        Assert.assertEquals((double)retnAirTemp, (double)item_.getRetnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)retnPress, (double)item_.getRetnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirTemp, (double)item_.getSplyAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirVel, (double)item_.getSplyAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)splyPress, (double)item_.getSplyPress(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
    }
}

