/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.Chiller_ChillerTelemetry;
import org.lsst.sal.camera.telemetry.Chiller_FParam_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Chiller_Maq20Telemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Reb_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Sum_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_Latches_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_OnlineClamps_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_TemperaturesTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Accelerobf_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Ai814_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_CarouselController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ClampXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ClampXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Hyttc580_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_LatchXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_LatchXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Pt100_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_CarrierController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_HooksController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket1_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket2_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket3_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket4_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket5_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Autochanger_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Loader_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Fcs_Mcm_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_Carrier_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_Hooks_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebsAverageTemp6Telemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_03Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_05Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_50Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_55Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_12Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_14Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_31Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_43Telemetry;
import org.lsst.sal.camera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_REB_Bulk_PSTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Shutter_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Cold_TempTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Cryo_TempTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_RtdTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_TrimTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Trim_HtrsTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_BodyTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_MPCTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_UTTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_VPCTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CipTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_HXTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_HipTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_InstTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.06375300884246826;
        double dirty_24V_I = 0.5436651706695557;
        double dirty_28V_I = 0.217274010181427;
        double dirty_48V_I = 0.3877224922180176;
        double protection_I = 0.0032235383987426758;
        double rebps_0_2_I = 0.850786566734314;
        double rebps_3_5_I = 0.6411176323890686;
        double rebps_6_8_I = 0.5352170467376709;
        double rebps_9_12_I = 0.8839085102081299;
        double rebps_Spr_I = 0.19910532236099243;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, protection_I, rebps_0_2_I, rebps_3_5_I, rebps_6_8_I, rebps_9_12_I, rebps_Spr_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I, (double)item_.getRebps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I, (double)item_.getRebps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I, (double)item_.getRebps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I, (double)item_.getRebps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I, (double)item_.getRebps_Spr_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double board_T = 0.2420135736465454;
        double body_Maq20_I = 0.5680676698684692;
        double body_Maq20_V = 0.6415224075317383;
        double cryo_Maq20_I = 0.6581142544746399;
        double cryo_Maq20_V = 0.6458249092102051;
        double fes_CarouselC_I = 0.6832186579704285;
        double fes_CarouselC_V = 0.3426624f;
        double fes_ChangerC_I = 0.5669072270393372;
        double fes_ChangerC_V = 0.868403434753418;
        double fes_LoaderC_I = 0.444133996963501;
        double fes_LoaderC_V = 0.7765841484069824;
        double fpga_T = 0.3005765f;
        double gauges_I = 0.33426398038864136;
        double gauges_V = 0.2030550241470337;
        double int_Valves_I = 0.4555372f;
        double int_Valves_V = 0.9210861325263977;
        double ion_Pumps_I = 0.17353105545043945;
        double ion_Pumps_V = 0.7486221194267273;
        double main_I = 0.4283798336982727;
        double main_T = 0.26659804582595825;
        double main_V = 0.8799508810043335;
        double shtr_PLC1_I = 0.020609617233276367;
        double shtr_PLC1_V = 0.05208402872085571;
        double shtr_PLC2_I = 0.24147897958755493;
        double shtr_PLC2_V = 0.2122497f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(board_T, body_Maq20_I, body_Maq20_V, cryo_Maq20_I, cryo_Maq20_V, fes_CarouselC_I, fes_CarouselC_V, fes_ChangerC_I, fes_ChangerC_V, fes_LoaderC_I, fes_LoaderC_V, fpga_T, gauges_I, gauges_V, int_Valves_I, int_Valves_V, ion_Pumps_I, ion_Pumps_V, main_I, main_T, main_V, shtr_PLC1_I, shtr_PLC1_V, shtr_PLC2_I, shtr_PLC2_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I, (double)item_.getBody_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V, (double)item_.getBody_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I, (double)item_.getCryo_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V, (double)item_.getCryo_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I, (double)item_.getFes_CarouselC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V, (double)item_.getFes_CarouselC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I, (double)item_.getFes_ChangerC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V, (double)item_.getFes_ChangerC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I, (double)item_.getFes_LoaderC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V, (double)item_.getFes_LoaderC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I, (double)item_.getInt_Valves_I(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V, (double)item_.getInt_Valves_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I, (double)item_.getShtr_PLC1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V, (double)item_.getShtr_PLC1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I, (double)item_.getShtr_PLC2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V, (double)item_.getShtr_PLC2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.7351446151733398;
        double cryo_Turbo_I = 0.5014378428459167;
        double cryo_Turbo_V = 0.38984131813049316;
        double fes_Brakes_I = 0.3622232675552368;
        double fes_Brakes_V = 0.22005265951156616;
        double fes_ChangerD_I = 0.8336512446403503;
        double fes_ChangerD_V = 0.8006823062896729;
        double fes_Clamps_I = 0.40835005044937134;
        double fes_Clamps_V = 0.054684996604919434;
        double fes_LoaderD_I = 0.1946696f;
        double fes_LoaderD_V = 0.8003453612327576;
        double fpga_T = 0.3892640471458435;
        double hex_Turbo_I = 0.516148567199707;
        double hex_Turbo_V = 0.6689355969429016;
        double main_I = 0.05160415172576904;
        double main_T = 0.6360364556312561;
        double main_V = 0.7693183422088623;
        double shtr_Brakes_I = 0.07337045669555664;
        double shtr_Brakes_V = 0.6772706508636475;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, cryo_Turbo_I, cryo_Turbo_V, fes_Brakes_I, fes_Brakes_V, fes_ChangerD_I, fes_ChangerD_V, fes_Clamps_I, fes_Clamps_V, fes_LoaderD_I, fes_LoaderD_V, fpga_T, hex_Turbo_I, hex_Turbo_V, main_I, main_T, main_V, shtr_Brakes_I, shtr_Brakes_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I, (double)item_.getFes_Brakes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V, (double)item_.getFes_Brakes_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I, (double)item_.getFes_ChangerD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V, (double)item_.getFes_ChangerD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I, (double)item_.getFes_Clamps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V, (double)item_.getFes_Clamps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I, (double)item_.getFes_LoaderD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V, (double)item_.getFes_LoaderD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I, (double)item_.getHex_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V, (double)item_.getHex_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I, (double)item_.getShtr_Brakes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V, (double)item_.getShtr_Brakes_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.4179755449295044;
        double fes_CarouselD_I = 0.007028937339782715;
        double fes_CarouselD_V = 0.9968532919883728;
        double fes_Heater_I = 0.9545769691467285;
        double fes_Heater_V = 0.3087554f;
        double fpga_T = 0.7957040667533875;
        double main_I = 0.7339683175086975;
        double main_T = 0.345028817653656;
        double main_V = 0.7464436888694763;
        double purge_Fan_I = 0.04730475f;
        double purge_Fan_V = 0.6799012422561646;
        double shtr_Motor1_I = 0.008954644203186035;
        double shtr_Motor1_V = 0.02386784553527832;
        double shtr_Motor2_I = 0.7984013557434082;
        double shtr_Motor2_V = 0.7938501834869385;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, fes_CarouselD_I, fes_CarouselD_V, fes_Heater_I, fes_Heater_V, fpga_T, main_I, main_T, main_V, purge_Fan_I, purge_Fan_V, shtr_Motor1_I, shtr_Motor1_V, shtr_Motor2_I, shtr_Motor2_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I, (double)item_.getFes_CarouselD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V, (double)item_.getFes_CarouselD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I, (double)item_.getFes_Heater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V, (double)item_.getFes_Heater_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I, (double)item_.getPurge_Fan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V, (double)item_.getPurge_Fan_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I, (double)item_.getShtr_Motor1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V, (double)item_.getShtr_Motor1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I, (double)item_.getShtr_Motor2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V, (double)item_.getShtr_Motor2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_A_I = 0.1461772322654724;
        double otm_0_A_V = 0.8392994403839111;
        double otm_0_B_I = 0.1995563507080078;
        double otm_0_B_V = 0.03106069564819336;
        double otm_1_A_I = 0.16134315729141235;
        double otm_1_A_V = 0.699354f;
        double otm_1_B_I = 0.3118462562561035;
        double otm_1_B_V = 0.1466047167778015;
        double otm_2_A_I = 0.697310209274292;
        double otm_2_A_V = 0.9871083498001099;
        double otm_2_B_I = 0.8716533184051514;
        double otm_2_B_V = 0.02343040704727173;
        double otm_3_A_I = 0.4510906934738159;
        double otm_3_A_V = 0.6826828122138977;
        double otm_3_B_I = 0.6598678231239319;
        double otm_3_B_V = 0.03727757930755615;
        double otm_4_A_I = 0.5882796049118042;
        double otm_4_A_V = 0.29798614978790283;
        double otm_4_B_I = 0.42802155017852783;
        double otm_4_B_V = 0.8841565251350403;
        double otm_5_A_I = 0.723391056060791;
        double otm_5_A_V = 0.012175381183624268;
        double otm_5_B_I = 0.06291204690933228;
        double otm_5_B_V = 0.5327414274215698;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_A_I, otm_0_A_V, otm_0_B_I, otm_0_B_V, otm_1_A_I, otm_1_A_V, otm_1_B_I, otm_1_B_V, otm_2_A_I, otm_2_A_V, otm_2_B_I, otm_2_B_V, otm_3_A_I, otm_3_A_V, otm_3_B_I, otm_3_B_V, otm_4_A_I, otm_4_A_V, otm_4_B_I, otm_4_B_V, otm_5_A_I, otm_5_A_V, otm_5_B_I, otm_5_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I, (double)item_.getOtm_1_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V, (double)item_.getOtm_1_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I, (double)item_.getOtm_1_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V, (double)item_.getOtm_1_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I, (double)item_.getOtm_2_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V, (double)item_.getOtm_2_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I, (double)item_.getOtm_2_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V, (double)item_.getOtm_2_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I, (double)item_.getOtm_3_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V, (double)item_.getOtm_3_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I, (double)item_.getOtm_4_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V, (double)item_.getOtm_4_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I, (double)item_.getOtm_4_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V, (double)item_.getOtm_4_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I, (double)item_.getOtm_5_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V, (double)item_.getOtm_5_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I, (double)item_.getOtm_5_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V, (double)item_.getOtm_5_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PSTelemetry() throws Exception {
        double rebbulkps_0_2_I = 0.32043081521987915;
        double rebbulkps_0_2_T = 0.6729613542556763;
        double rebbulkps_0_2_V = 0.27488642930984497;
        double rebbulkps_3_5_I = 0.3728615641593933;
        double rebbulkps_3_5_T = 0.9913286566734314;
        double rebbulkps_3_5_V = 0.8676349520683289;
        double rebbulkps_6_8_I = 0.17567843198776245;
        double rebbulkps_6_8_T = 0.38904452323913574;
        double rebbulkps_6_8_V = 0.296139f;
        double rebbulkps_9_12_I = 0.7261744737625122;
        double rebbulkps_9_12_T = 0.6626887917518616;
        double rebbulkps_9_12_V = 0.04965662956237793;
        double rebbulkps_Brd_T = 0.0604214072227478;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_REB_Bulk_PSTelemetry(rebbulkps_0_2_I, rebbulkps_0_2_T, rebbulkps_0_2_V, rebbulkps_3_5_I, rebbulkps_3_5_T, rebbulkps_3_5_V, rebbulkps_6_8_I, rebbulkps_6_8_T, rebbulkps_6_8_V, rebbulkps_9_12_I, rebbulkps_9_12_T, rebbulkps_9_12_V, rebbulkps_Brd_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PSTelemetry));
        Quadbox_REB_Bulk_PSTelemetry item_ = (Quadbox_REB_Bulk_PSTelemetry)item;
        Assert.assertEquals((double)rebbulkps_0_2_I, (double)item_.getRebbulkps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T, (double)item_.getRebbulkps_0_2_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V, (double)item_.getRebbulkps_0_2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I, (double)item_.getRebbulkps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T, (double)item_.getRebbulkps_3_5_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V, (double)item_.getRebbulkps_3_5_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I, (double)item_.getRebbulkps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T, (double)item_.getRebbulkps_6_8_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V, (double)item_.getRebbulkps_6_8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I, (double)item_.getRebbulkps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T, (double)item_.getRebbulkps_9_12_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V, (double)item_.getRebbulkps_9_12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T, (double)item_.getRebbulkps_Brd_T(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1115462937);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)780247451);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)646846235);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-129773636);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1817527682);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1188502757);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1078238519);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-675623160);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)757762276);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)2088037878);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1909617758);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-646788668);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)265598571);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)-1867573304);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1257027349);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)1640855806);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1157730507);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-19379953);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-147531162);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-435377394);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)844329564);
        double[] dphi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)373760274);
        double[] dphi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)859429570);
        double[] dphi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-48896993);
        double[] dphi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1426588198);
        double[] dphi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-223742977);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1736107374);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)129041134);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1522719881);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1985476781);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-938604525);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)71, (int)159772113);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)71, (int)-1926963066);
        String location = "";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1003192026);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-841380869);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1910799660);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)-1070253627);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1981996956);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-330658050);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)533067864);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, dphi_IaftLDO, dphi_IbefLDO, dphi_VaftLDO, dphi_VaftSwch, dphi_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO, (double[])item_.getDphi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO, (double[])item_.getDphi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO, (double[])item_.getDphi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch, (double[])item_.getDphi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO, (double[])item_.getDphi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.47461992502212524;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTotalPowerTelemetry));
        Rebpower_RebTotalPowerTelemetry item_ = (Rebpower_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)13, (int)1197262709);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)13, (int)651350160);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)13, (int)1502926846);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)13, (int)1768359691);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)13, (int)1021442721);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)13, (int)1666861201);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)13, (int)-2096187054);
        double[] fPGATemp = TestHelper.generateDoubleArray((int)13, (int)774708039);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, fPGATemp, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fPGATemp, (double[])item_.getFPGATemp(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveHex_Cold1Telemetry() throws Exception {
        double returnTmp = 0.9236583113670349;
        double supplyTmp = 0.9931003451347351;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold1Telemetry(returnTmp, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1Telemetry));
        Hex_Cold1Telemetry item_ = (Hex_Cold1Telemetry)item;
        Assert.assertEquals((double)returnTmp, (double)item_.getReturnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2Telemetry() throws Exception {
        double returnTmp = 0.6781256794929504;
        double supplyTmp = 0.3707275986671448;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold2Telemetry(returnTmp, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2Telemetry));
        Hex_Cold2Telemetry item_ = (Hex_Cold2Telemetry)item;
        Assert.assertEquals((double)returnTmp, (double)item_.getReturnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1Telemetry() throws Exception {
        double c3ExitTmp = 0.9324435591697693;
        double c4ExitTmp = 0.5262464880943298;
        double evapExitTmp = 0.449784517288208;
        double hexRtrnTmp = 0.6117709279060364;
        double liquidPrs = 0.33810514211654663;
        double preC3Tmp = 0.7756381630897522;
        double preC4Tmp = 0.9668700695037842;
        double returnPrs = 0.9696370959281921;
        double vaporPrs = 0.3062235713005066;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo1Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1Telemetry));
        Hex_Cryo1Telemetry item_ = (Hex_Cryo1Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2Telemetry() throws Exception {
        double c3ExitTmp = 0.7944543957710266;
        double c4ExitTmp = 0.25881046056747437;
        double evapExitTmp = 0.91333f;
        double hexRtrnTmp = 0.9421666860580444;
        double liquidPrs = 0.9120232462882996;
        double preC3Tmp = 0.7455727458000183;
        double preC4Tmp = 0.9104164838790894;
        double returnPrs = 0.1429547667503357;
        double vaporPrs = 0.26258552074432373;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo2Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2Telemetry));
        Hex_Cryo2Telemetry item_ = (Hex_Cryo2Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3Telemetry() throws Exception {
        double c3ExitTmp = 0.590083f;
        double c4ExitTmp = 0.8460214138031006;
        double evapExitTmp = 0.5365853905677795;
        double hexRtrnTmp = 0.09294718503952026;
        double liquidPrs = 0.722268283367157;
        double preC3Tmp = 0.8988456726074219;
        double preC4Tmp = 0.6381955742835999;
        double returnPrs = 0.5044876337051392;
        double vaporPrs = 0.8311173319816589;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo3Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3Telemetry));
        Hex_Cryo3Telemetry item_ = (Hex_Cryo3Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4Telemetry() throws Exception {
        double c3ExitTmp = 0.1944863200187683;
        double c4ExitTmp = 0.6197198033332825;
        double evapExitTmp = 0.6740178465843201;
        double hexRtrnTmp = 0.9137324690818787;
        double liquidPrs = 0.3123382329940796;
        double preC3Tmp = 0.8043011426925659;
        double preC4Tmp = 0.3393649458885193;
        double returnPrs = 0.3884698152542114;
        double vaporPrs = 0.506984293460846;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo4Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4Telemetry));
        Hex_Cryo4Telemetry item_ = (Hex_Cryo4Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5Telemetry() throws Exception {
        double c3ExitTmp = 0.30024921894073486;
        double c4ExitTmp = 0.3638683557510376;
        double evapExitTmp = 0.6911038160324097;
        double hexRtrnTmp = 0.948113f;
        double liquidPrs = 0.2390207052230835;
        double preC3Tmp = 0.14690375328063965;
        double preC4Tmp = 0.6872937083244324;
        double returnPrs = 0.8426553606987;
        double vaporPrs = 0.3003944754600525;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo5Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5Telemetry));
        Hex_Cryo5Telemetry item_ = (Hex_Cryo5Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6Telemetry() throws Exception {
        double c3ExitTmp = 0.11592239141464233;
        double c4ExitTmp = 0.050885558128356934;
        double evapExitTmp = 0.515129804611206;
        double hexRtrnTmp = 0.5341867208480835;
        double liquidPrs = 0.3132544159889221;
        double preC3Tmp = 0.015797853469848633;
        double preC4Tmp = 0.2513923f;
        double returnPrs = 0.6256130337715149;
        double vaporPrs = 0.4251399636268616;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo6Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6Telemetry));
        Hex_Cryo6Telemetry item_ = (Hex_Cryo6Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo1Telemetry() throws Exception {
        double afterCoolTmp = 0.04007077217102051;
        double compCurrent = 0.3994826078414917;
        double compPower = 0.42047423124313354;
        double compVoltage = 0.4413236379623413;
        double dischrgPrs = 0.9954005479812622;
        double dischrgtmp_M = 0.1395513415336609;
        double dischrgtmp_P = 0.7120785713195801;
        double fanSpeed = 0.3843892216682434;
        double oilLevel = 0.4760446548461914;
        double oilSepTmp = 0.8315765261650085;
        double phaseSepTmp = 0.49518346786499023;
        double suctionPrs = 0.3152748942375183;
        double suctiontmp_M = 0.8099096417427063;
        double suctiontmp_P = 0.6014875769615173;
        double surgeTankTmp = 0.3798556327819824;
        double waterInTmp = 0.664657711982727;
        double waterOutTmp = 0.8450844883918762;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo1Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1Telemetry));
        Refrig_Cryo1Telemetry item_ = (Refrig_Cryo1Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2Telemetry() throws Exception {
        double afterCoolTmp = 0.08829832077026367;
        double compCurrent = 0.912227988243103;
        double compPower = 0.12183153629302979;
        double compVoltage = 0.710850179195404;
        double dischrgPrs = 0.12991058826446533;
        double dischrgtmp_M = 0.7175328731536865;
        double dischrgtmp_P = 0.0491408109664917;
        double fanSpeed = 0.5376909375190735;
        double oilLevel = 0.7745217084884644;
        double oilSepTmp = 0.7269848585128784;
        double phaseSepTmp = 0.0999218225479126;
        double suctionPrs = 0.7310975790023804;
        double suctiontmp_M = 0.8573110699653625;
        double suctiontmp_P = 0.1031796932220459;
        double surgeTankTmp = 0.2733106017112732;
        double waterInTmp = 0.3846477270126343;
        double waterOutTmp = 0.5456730723381042;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo2Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2Telemetry));
        Refrig_Cryo2Telemetry item_ = (Refrig_Cryo2Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3Telemetry() throws Exception {
        double afterCoolTmp = 0.6833916306495667;
        double ambientTmp = 0.615400493144989;
        double cabinetTmp = 0.985266387462616;
        double compCurrent = 0.6262192130088806;
        double compPower = 0.9268412590026855;
        double compVoltage = 0.7013934254646301;
        double dischrgPrs = 0.7946221232414246;
        double dischrgtmp_M = 0.8567145466804504;
        double dischrgtmp_P = 0.10664993524551392;
        double fanSpeed = 0.6390265226364136;
        double oilLevel = 0.4128406047821045;
        double oilSepTmp = 0.7378131747245789;
        double phaseSepTmp = 0.22139078378677368;
        double suctionPrs = 0.8042507171630859;
        double suctiontmp_M = 0.6622820496559143;
        double suctiontmp_P = 0.4527856707572937;
        double surgeTankTmp = 0.2221236228942871;
        double waterInTmp = 0.7435727715492249;
        double waterOutTmp = 0.32882362604141235;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo3Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3Telemetry));
        Refrig_Cryo3Telemetry item_ = (Refrig_Cryo3Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4Telemetry() throws Exception {
        double afterCoolTmp = 0.18640172481536865;
        double compCurrent = 0.331407f;
        double compPower = 0.49448084831237793;
        double compVoltage = 0.6153187155723572;
        double dischrgPrs = 0.3528764843940735;
        double dischrgtmp_M = 0.6594946384429932;
        double dischrgtmp_P = 0.029887735843658447;
        double fanSpeed = 0.686722457408905;
        double oilLevel = 0.5515662431716919;
        double oilSepTmp = 0.9538493156433105;
        double phaseSepTmp = 0.1216285228729248;
        double suctionPrs = 0.0994305f;
        double suctiontmp_M = 0.02028787136077881;
        double suctiontmp_P = 0.12096691131591797;
        double surgeTankTmp = 0.8419254422187805;
        double waterInTmp = 0.5299714803695679;
        double waterOutTmp = 0.4902523159980774;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo4Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4Telemetry));
        Refrig_Cryo4Telemetry item_ = (Refrig_Cryo4Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5Telemetry() throws Exception {
        double afterCoolTmp = 0.36965036392211914;
        double ambientTmp = 0.33370906114578247;
        double cabinetTmp = 0.26223433017730713;
        double compCurrent = 0.26226896047592163;
        double compPower = 0.19328594207763672;
        double compVoltage = 0.7372046113014221;
        double dischrgPrs = 0.7104390859603882;
        double dischrgtmp_M = 0.9478601217269897;
        double dischrgtmp_P = 0.4519529342651367;
        double fanSpeed = 0.07082492113113403;
        double oilLevel = 0.5902376770973206;
        double oilSepTmp = 0.1561023f;
        double phaseSepTmp = 0.06556594371795654;
        double suctionPrs = 0.941853404045105;
        double suctiontmp_M = 0.5864506959915161;
        double suctiontmp_P = 0.79039067029953;
        double surgeTankTmp = 0.08456408977508545;
        double waterInTmp = 0.672473f;
        double waterOutTmp = 0.7774170637130737;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo5Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5Telemetry));
        Refrig_Cryo5Telemetry item_ = (Refrig_Cryo5Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6Telemetry() throws Exception {
        double afterCoolTmp = 0.9600421786308289;
        double compCurrent = 0.478396f;
        double compPower = 0.43834203481674194;
        double compVoltage = 0.07779967784881592;
        double dischrgPrs = 0.5489626526832581;
        double dischrgtmp_M = 0.953304648399353;
        double dischrgtmp_P = 0.45221036672592163;
        double fanSpeed = 0.35961318016052246;
        double oilLevel = 0.534893f;
        double oilSepTmp = 0.574421226978302;
        double phaseSepTmp = 0.9091998934745789;
        double suctionPrs = 0.15150684118270874;
        double suctiontmp_M = 0.3635222315788269;
        double suctiontmp_P = 0.28328317403793335;
        double surgeTankTmp = 0.12166684865951538;
        double waterInTmp = 0.23586708307266235;
        double waterOutTmp = 0.27564752101898193;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo6Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6Telemetry));
        Refrig_Cryo6Telemetry item_ = (Refrig_Cryo6Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CipTelemetry() throws Exception {
        double[] cryo_I = TestHelper.generateDoubleArray((int)6, (int)1918009884);
        double[] cryo_Life = TestHelper.generateDoubleArray((int)6, (int)-36679694);
        double[] cryo_Usage = TestHelper.generateDoubleArray((int)6, (int)-1977276055);
        double[] cryo_V = TestHelper.generateDoubleArray((int)6, (int)61529191);
        String location = "o";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CipTelemetry(cryo_I, cryo_Life, cryo_Usage, cryo_V, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CipTelemetry));
        Vacuum_CipTelemetry item_ = (Vacuum_CipTelemetry)item;
        Assert.assertArrayEquals((double[])cryo_I, (double[])item_.getCryo_I(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life, (double[])item_.getCryo_Life(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage, (double[])item_.getCryo_Usage(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V, (double[])item_.getCryo_V(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double airPressure = 0.31598544120788574;
        double cryoVac = 0.932489275932312;
        double flineCurrent = 0.0873381495475769;
        double flinePower = 0.6842671036720276;
        double flineVoltage = 0.2492081f;
        double forelineVac = 0.1377851963043213;
        double gaugeDose = 0.8588252067565918;
        double pumpCartPressure = 0.3294191360473633;
        double turboCurrent = 0.18303775787353516;
        double turboCycleNumber = 0.9865933656692505;
        double turboCycleTime = 0.13097500801086426;
        double turboGaugeDose = 0.29603683948516846;
        double turboHours = 0.21447932720184326;
        double turboPower = 0.3375188112258911;
        double turboPumpStatus = 0.9132510423660278;
        double turboPumpTemp = 0.36148297786712646;
        double turboSpeed = 0.8401514887809753;
        double turboVac = 0.4385449290275574;
        double turboVoltage = 0.25022536516189575;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(airPressure, cryoVac, flineCurrent, flinePower, flineVoltage, forelineVac, gaugeDose, pumpCartPressure, turboCurrent, turboCycleNumber, turboCycleTime, turboGaugeDose, turboHours, turboPower, turboPumpStatus, turboPumpTemp, turboSpeed, turboVac, turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)airPressure, (double)item_.getAirPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoVac, (double)item_.getCryoVac(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugeDose, (double)item_.getGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleNumber, (double)item_.getTurboCycleNumber(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleTime, (double)item_.getTurboCycleTime(), (double)1.0E-6f);
        Assert.assertEquals((double)turboGaugeDose, (double)item_.getTurboGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)turboHours, (double)item_.getTurboHours(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpStatus, (double)item_.getTurboPumpStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HXTelemetry() throws Exception {
        double airPressure = 0.01773691177368164;
        double flineCurrent = 0.26277297735214233;
        double flinePower = 0.9219653606414795;
        double flineVoltage = 0.6841568946838379;
        double forelineVac = 0.8381834626197815;
        double gaugeDose = 0.322886f;
        double hexVac = 0.965827226638794;
        double pumpCartPressure = 0.32015544176101685;
        double turboCurrent = 0.06532156467437744;
        double turboCycleNumber = 0.41804826259613037;
        double turboCycleTime = 0.4266694188117981;
        double turboGaugeDose = 0.33832043409347534;
        double turboHours = 0.6689122319221497;
        double turboPower = 0.20162934064865112;
        double turboPumpStatus = 0.41071271896362305;
        double turboPumpTemp = 0.4938998818397522;
        double turboSpeed = 0.3470335602760315;
        double turboVac = 0.4498153328895569;
        double turboVoltage = 0.9123595356941223;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_HXTelemetry(airPressure, flineCurrent, flinePower, flineVoltage, forelineVac, gaugeDose, hexVac, pumpCartPressure, turboCurrent, turboCycleNumber, turboCycleTime, turboGaugeDose, turboHours, turboPower, turboPumpStatus, turboPumpTemp, turboSpeed, turboVac, turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HXTelemetry));
        Vacuum_HXTelemetry item_ = (Vacuum_HXTelemetry)item;
        Assert.assertEquals((double)airPressure, (double)item_.getAirPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugeDose, (double)item_.getGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)hexVac, (double)item_.getHexVac(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleNumber, (double)item_.getTurboCycleNumber(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleTime, (double)item_.getTurboCycleTime(), (double)1.0E-6f);
        Assert.assertEquals((double)turboGaugeDose, (double)item_.getTurboGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)turboHours, (double)item_.getTurboHours(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpStatus, (double)item_.getTurboPumpStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HipTelemetry() throws Exception {
        double[] hx_I = TestHelper.generateDoubleArray((int)2, (int)-1122085835);
        double[] hx_Life = TestHelper.generateDoubleArray((int)2, (int)-531644184);
        double[] hx_Usage = TestHelper.generateDoubleArray((int)2, (int)-975482586);
        double[] hx_V = TestHelper.generateDoubleArray((int)2, (int)2023033950);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_HipTelemetry(hx_I, hx_Life, hx_Usage, hx_V, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HipTelemetry));
        Vacuum_HipTelemetry item_ = (Vacuum_HipTelemetry)item;
        Assert.assertArrayEquals((double[])hx_I, (double[])item_.getHx_I(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life, (double[])item_.getHx_Life(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage, (double[])item_.getHx_Usage(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V, (double[])item_.getHx_V(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_InstTelemetry() throws Exception {
        double cryoFlineValveState = 0.7802398800849915;
        double flineCurrent = 0.4902266263961792;
        double flinePower = 0.26919543743133545;
        double flineVoltage = 0.1802259087562561;
        double hxFlineValveState = 0.8523287177085876;
        double instVac = 0.0439186692237854;
        double pumpCartCycling = 0.2836172f;
        double pumpCartPressure = 0.2545545f;
        double pumpCartTemperature = 0.707659900188446;
        double pumpCartVenting = 0.488411009311676;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_InstTelemetry(cryoFlineValveState, flineCurrent, flinePower, flineVoltage, hxFlineValveState, instVac, pumpCartCycling, pumpCartPressure, pumpCartTemperature, pumpCartVenting));
        Assert.assertTrue((boolean)(item instanceof Vacuum_InstTelemetry));
        Vacuum_InstTelemetry item_ = (Vacuum_InstTelemetry)item;
        Assert.assertEquals((double)cryoFlineValveState, (double)item_.getCryoFlineValveState(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)hxFlineValveState, (double)item_.getHxFlineValveState(), (double)1.0E-6f);
        Assert.assertEquals((double)instVac, (double)item_.getInstVac(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartCycling, (double)item_.getPumpCartCycling(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartTemperature, (double)item_.getPumpCartTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartVenting, (double)item_.getPumpCartVenting(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Reb_TrendingTelemetry() throws Exception {
        long[] driver_errors = TestHelper.generateLongArray((int)71, (int)1731170448);
        long[] driver_received = TestHelper.generateLongArray((int)71, (int)1622381423);
        long[] driver_rx0 = TestHelper.generateLongArray((int)71, (int)1247587370);
        long[] driver_rx1 = TestHelper.generateLongArray((int)71, (int)1942854623);
        long[] driver_rx2 = TestHelper.generateLongArray((int)71, (int)1348892812);
        long[] driver_rx3 = TestHelper.generateLongArray((int)71, (int)414623449);
        long[] firmware_cell_errors = TestHelper.generateLongArray((int)71, (int)1478722825);
        long[] firmware_last_rx = TestHelper.generateLongArray((int)71, (int)1068004031);
        long[] firmware_last_tx = TestHelper.generateLongArray((int)71, (int)994740027);
        long[] firmware_link_down = TestHelper.generateLongArray((int)71, (int)1847124729);
        long[] firmware_link_errors = TestHelper.generateLongArray((int)71, (int)-175625868);
        long[] firmware_link_status = TestHelper.generateLongArray((int)71, (int)-1588806617);
        long[] firmware_overflow_local0 = TestHelper.generateLongArray((int)71, (int)-1735573081);
        long[] firmware_overflow_local1 = TestHelper.generateLongArray((int)71, (int)1862059191);
        long[] firmware_overflow_local2 = TestHelper.generateLongArray((int)71, (int)-755753229);
        long[] firmware_overflow_local3 = TestHelper.generateLongArray((int)71, (int)-825086313);
        long[] firmware_overflow_remote0 = TestHelper.generateLongArray((int)71, (int)-534693503);
        long[] firmware_overflow_remote1 = TestHelper.generateLongArray((int)71, (int)-412441900);
        long[] firmware_overflow_remote2 = TestHelper.generateLongArray((int)71, (int)334860116);
        long[] firmware_overflow_remote3 = TestHelper.generateLongArray((int)71, (int)1806792293);
        long[] firmware_rlink_data = TestHelper.generateLongArray((int)71, (int)-433903052);
        long[] firmware_rx_clock = TestHelper.generateLongArray((int)71, (int)522323828);
        long[] firmware_rx_errors = TestHelper.generateLongArray((int)71, (int)897514979);
        long[] firmware_rx_frames = TestHelper.generateLongArray((int)71, (int)-224324383);
        long[] firmware_rx_op = TestHelper.generateLongArray((int)71, (int)1267684151);
        long[] firmware_tx_clock = TestHelper.generateLongArray((int)71, (int)-479683108);
        long[] firmware_tx_errors = TestHelper.generateLongArray((int)71, (int)1297128407);
        long[] firmware_tx_frames = TestHelper.generateLongArray((int)71, (int)-901870151);
        long[] firmware_tx_op = TestHelper.generateLongArray((int)71, (int)-650009694);
        String location = "x";
        long[] rds_bdi_firsts = TestHelper.generateLongArray((int)71, (int)-1252882785);
        long[] rds_bdi_frees = TestHelper.generateLongArray((int)71, (int)-460027132);
        long[] rds_bdi_lasts = TestHelper.generateLongArray((int)71, (int)-631917778);
        long[] rds_bdi_nulls = TestHelper.generateLongArray((int)71, (int)955893244);
        long[] rds_bdi_overflows = TestHelper.generateLongArray((int)71, (int)994360616);
        long[] rds_bdi_seq_errors = TestHelper.generateLongArray((int)71, (int)1574667122);
        long[] rds_bdi_waits = TestHelper.generateLongArray((int)71, (int)-450316865);
        long[] rds_discards = TestHelper.generateLongArray((int)71, (int)-46295071);
        long[] rds_no_event = TestHelper.generateLongArray((int)71, (int)-549521673);
        long[] rds_wakes = TestHelper.generateLongArray((int)71, (int)1194567907);
        long[] rms_in_reset = TestHelper.generateLongArray((int)71, (int)1774492334);
        long[] rms_inv_tids = TestHelper.generateLongArray((int)71, (int)-624891846);
        long[] rms_link_down = TestHelper.generateLongArray((int)71, (int)-1026797542);
        long[] rms_lists_posted = TestHelper.generateLongArray((int)71, (int)250999227);
        long[] rms_ops_posted = TestHelper.generateLongArray((int)71, (int)1902509620);
        long[] rms_orphans = TestHelper.generateLongArray((int)71, (int)-540524935);
        long[] rms_probes = TestHelper.generateLongArray((int)71, (int)-2051765325);
        long[] rms_responses = TestHelper.generateLongArray((int)71, (int)2042354853);
        long[] rms_rundowns = TestHelper.generateLongArray((int)71, (int)-1500989052);
        long[] rms_tid_hwm = TestHelper.generateLongArray((int)71, (int)-883246345);
        long[] rms_unopened = TestHelper.generateLongArray((int)71, (int)-1633072422);
        long[] rms_waits = TestHelper.generateLongArray((int)71, (int)1436592037);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Reb_TrendingTelemetry(driver_errors, driver_received, driver_rx0, driver_rx1, driver_rx2, driver_rx3, firmware_cell_errors, firmware_last_rx, firmware_last_tx, firmware_link_down, firmware_link_errors, firmware_link_status, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_local3, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_overflow_remote3, firmware_rlink_data, firmware_rx_clock, firmware_rx_errors, firmware_rx_frames, firmware_rx_op, firmware_tx_clock, firmware_tx_errors, firmware_tx_frames, firmware_tx_op, location, rds_bdi_firsts, rds_bdi_frees, rds_bdi_lasts, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_bdi_waits, rds_discards, rds_no_event, rds_wakes, rms_in_reset, rms_inv_tids, rms_link_down, rms_lists_posted, rms_ops_posted, rms_orphans, rms_probes, rms_responses, rms_rundowns, rms_tid_hwm, rms_unopened, rms_waits));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Reb_TrendingTelemetry));
        Daq_monitor_Reb_TrendingTelemetry item_ = (Daq_monitor_Reb_TrendingTelemetry)item;
        Assert.assertArrayEquals((long[])driver_errors, (long[])item_.getDriver_errors());
        Assert.assertArrayEquals((long[])driver_received, (long[])item_.getDriver_received());
        Assert.assertArrayEquals((long[])driver_rx0, (long[])item_.getDriver_rx0());
        Assert.assertArrayEquals((long[])driver_rx1, (long[])item_.getDriver_rx1());
        Assert.assertArrayEquals((long[])driver_rx2, (long[])item_.getDriver_rx2());
        Assert.assertArrayEquals((long[])driver_rx3, (long[])item_.getDriver_rx3());
        Assert.assertArrayEquals((long[])firmware_cell_errors, (long[])item_.getFirmware_cell_errors());
        Assert.assertArrayEquals((long[])firmware_last_rx, (long[])item_.getFirmware_last_rx());
        Assert.assertArrayEquals((long[])firmware_last_tx, (long[])item_.getFirmware_last_tx());
        Assert.assertArrayEquals((long[])firmware_link_down, (long[])item_.getFirmware_link_down());
        Assert.assertArrayEquals((long[])firmware_link_errors, (long[])item_.getFirmware_link_errors());
        Assert.assertArrayEquals((long[])firmware_link_status, (long[])item_.getFirmware_link_status());
        Assert.assertArrayEquals((long[])firmware_overflow_local0, (long[])item_.getFirmware_overflow_local0());
        Assert.assertArrayEquals((long[])firmware_overflow_local1, (long[])item_.getFirmware_overflow_local1());
        Assert.assertArrayEquals((long[])firmware_overflow_local2, (long[])item_.getFirmware_overflow_local2());
        Assert.assertArrayEquals((long[])firmware_overflow_local3, (long[])item_.getFirmware_overflow_local3());
        Assert.assertArrayEquals((long[])firmware_overflow_remote0, (long[])item_.getFirmware_overflow_remote0());
        Assert.assertArrayEquals((long[])firmware_overflow_remote1, (long[])item_.getFirmware_overflow_remote1());
        Assert.assertArrayEquals((long[])firmware_overflow_remote2, (long[])item_.getFirmware_overflow_remote2());
        Assert.assertArrayEquals((long[])firmware_overflow_remote3, (long[])item_.getFirmware_overflow_remote3());
        Assert.assertArrayEquals((long[])firmware_rlink_data, (long[])item_.getFirmware_rlink_data());
        Assert.assertArrayEquals((long[])firmware_rx_clock, (long[])item_.getFirmware_rx_clock());
        Assert.assertArrayEquals((long[])firmware_rx_errors, (long[])item_.getFirmware_rx_errors());
        Assert.assertArrayEquals((long[])firmware_rx_frames, (long[])item_.getFirmware_rx_frames());
        Assert.assertArrayEquals((long[])firmware_rx_op, (long[])item_.getFirmware_rx_op());
        Assert.assertArrayEquals((long[])firmware_tx_clock, (long[])item_.getFirmware_tx_clock());
        Assert.assertArrayEquals((long[])firmware_tx_errors, (long[])item_.getFirmware_tx_errors());
        Assert.assertArrayEquals((long[])firmware_tx_frames, (long[])item_.getFirmware_tx_frames());
        Assert.assertArrayEquals((long[])firmware_tx_op, (long[])item_.getFirmware_tx_op());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])rds_bdi_firsts, (long[])item_.getRds_bdi_firsts());
        Assert.assertArrayEquals((long[])rds_bdi_frees, (long[])item_.getRds_bdi_frees());
        Assert.assertArrayEquals((long[])rds_bdi_lasts, (long[])item_.getRds_bdi_lasts());
        Assert.assertArrayEquals((long[])rds_bdi_nulls, (long[])item_.getRds_bdi_nulls());
        Assert.assertArrayEquals((long[])rds_bdi_overflows, (long[])item_.getRds_bdi_overflows());
        Assert.assertArrayEquals((long[])rds_bdi_seq_errors, (long[])item_.getRds_bdi_seq_errors());
        Assert.assertArrayEquals((long[])rds_bdi_waits, (long[])item_.getRds_bdi_waits());
        Assert.assertArrayEquals((long[])rds_discards, (long[])item_.getRds_discards());
        Assert.assertArrayEquals((long[])rds_no_event, (long[])item_.getRds_no_event());
        Assert.assertArrayEquals((long[])rds_wakes, (long[])item_.getRds_wakes());
        Assert.assertArrayEquals((long[])rms_in_reset, (long[])item_.getRms_in_reset());
        Assert.assertArrayEquals((long[])rms_inv_tids, (long[])item_.getRms_inv_tids());
        Assert.assertArrayEquals((long[])rms_link_down, (long[])item_.getRms_link_down());
        Assert.assertArrayEquals((long[])rms_lists_posted, (long[])item_.getRms_lists_posted());
        Assert.assertArrayEquals((long[])rms_ops_posted, (long[])item_.getRms_ops_posted());
        Assert.assertArrayEquals((long[])rms_orphans, (long[])item_.getRms_orphans());
        Assert.assertArrayEquals((long[])rms_probes, (long[])item_.getRms_probes());
        Assert.assertArrayEquals((long[])rms_responses, (long[])item_.getRms_responses());
        Assert.assertArrayEquals((long[])rms_rundowns, (long[])item_.getRms_rundowns());
        Assert.assertArrayEquals((long[])rms_tid_hwm, (long[])item_.getRms_tid_hwm());
        Assert.assertArrayEquals((long[])rms_unopened, (long[])item_.getRms_unopened());
        Assert.assertArrayEquals((long[])rms_waits, (long[])item_.getRms_waits());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.3656052350997925;
        double freeFraction = 0.838508f;
        double freeSpace = 0.9427078366279602;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Sum_TrendingTelemetry() throws Exception {
        long driver_errors = 982L;
        long firmware_cell_errors = 45L;
        long firmware_link_down = 953L;
        long firmware_link_errors = 813L;
        long firmware_overflow_local0 = 887L;
        long firmware_overflow_local1 = 389L;
        long firmware_overflow_local2 = 180L;
        long firmware_overflow_remote0 = 194L;
        long firmware_overflow_remote1 = 449L;
        long firmware_overflow_remote2 = 816L;
        long firmware_rx_errors = 389L;
        long firmware_tx_errors = 950L;
        long rds_bdi_nulls = 676L;
        long rds_bdi_overflows = 597L;
        long rds_bdi_seq_errors = 208L;
        long rds_discards = 473L;
        long rds_no_event = 472L;
        long rms_in_reset = 300L;
        long rms_inv_tids = 154L;
        long rms_link_down = 237L;
        long rms_orphans = 580L;
        long rms_unopened = 579L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Sum_TrendingTelemetry(driver_errors, firmware_cell_errors, firmware_link_down, firmware_link_errors, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_rx_errors, firmware_tx_errors, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_discards, rds_no_event, rms_in_reset, rms_inv_tids, rms_link_down, rms_orphans, rms_unopened));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Sum_TrendingTelemetry));
        Daq_monitor_Sum_TrendingTelemetry item_ = (Daq_monitor_Sum_TrendingTelemetry)item;
        Assert.assertEquals((long)driver_errors, (long)item_.getDriver_errors());
        Assert.assertEquals((long)firmware_cell_errors, (long)item_.getFirmware_cell_errors());
        Assert.assertEquals((long)firmware_link_down, (long)item_.getFirmware_link_down());
        Assert.assertEquals((long)firmware_link_errors, (long)item_.getFirmware_link_errors());
        Assert.assertEquals((long)firmware_overflow_local0, (long)item_.getFirmware_overflow_local0());
        Assert.assertEquals((long)firmware_overflow_local1, (long)item_.getFirmware_overflow_local1());
        Assert.assertEquals((long)firmware_overflow_local2, (long)item_.getFirmware_overflow_local2());
        Assert.assertEquals((long)firmware_overflow_remote0, (long)item_.getFirmware_overflow_remote0());
        Assert.assertEquals((long)firmware_overflow_remote1, (long)item_.getFirmware_overflow_remote1());
        Assert.assertEquals((long)firmware_overflow_remote2, (long)item_.getFirmware_overflow_remote2());
        Assert.assertEquals((long)firmware_rx_errors, (long)item_.getFirmware_rx_errors());
        Assert.assertEquals((long)firmware_tx_errors, (long)item_.getFirmware_tx_errors());
        Assert.assertEquals((long)rds_bdi_nulls, (long)item_.getRds_bdi_nulls());
        Assert.assertEquals((long)rds_bdi_overflows, (long)item_.getRds_bdi_overflows());
        Assert.assertEquals((long)rds_bdi_seq_errors, (long)item_.getRds_bdi_seq_errors());
        Assert.assertEquals((long)rds_discards, (long)item_.getRds_discards());
        Assert.assertEquals((long)rds_no_event, (long)item_.getRds_no_event());
        Assert.assertEquals((long)rms_in_reset, (long)item_.getRms_in_reset());
        Assert.assertEquals((long)rms_inv_tids, (long)item_.getRms_inv_tids());
        Assert.assertEquals((long)rms_link_down, (long)item_.getRms_link_down());
        Assert.assertEquals((long)rms_orphans, (long)item_.getRms_orphans());
        Assert.assertEquals((long)rms_unopened, (long)item_.getRms_unopened());
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)201, (int)888314256);
        String location = "l";
        double[] oDI = TestHelper.generateDoubleArray((int)201, (int)175944075);
        double[] oDV = TestHelper.generateDoubleArray((int)201, (int)1163179897);
        double[] oGV = TestHelper.generateDoubleArray((int)201, (int)879623438);
        double[] rDV = TestHelper.generateDoubleArray((int)201, (int)1646167193);
        double[] temp = TestHelper.generateDoubleArray((int)201, (int)1198848508);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)71, (int)103955563);
        double[] anaV = TestHelper.generateDoubleArray((int)71, (int)1738454970);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)71, (int)-627619830);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)71, (int)-448561757);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)71, (int)2134049333);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)71, (int)-782861957);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)71, (int)-1202272553);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)71, (int)-520024172);
        double[] clkHI = TestHelper.generateDoubleArray((int)71, (int)-393499257);
        double[] clkHV = TestHelper.generateDoubleArray((int)71, (int)1056183108);
        double[] clkLI = TestHelper.generateDoubleArray((int)71, (int)-1741228926);
        double[] clkLV = TestHelper.generateDoubleArray((int)71, (int)164131471);
        double[] digI = TestHelper.generateDoubleArray((int)71, (int)887337194);
        double[] digV = TestHelper.generateDoubleArray((int)71, (int)-1315545550);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)71, (int)-1779787179);
        double[] htrPI = TestHelper.generateDoubleArray((int)71, (int)-601800830);
        double[] htrPV = TestHelper.generateDoubleArray((int)71, (int)-2103178513);
        double[] htrV = TestHelper.generateDoubleArray((int)71, (int)-881463382);
        double[] htrW = TestHelper.generateDoubleArray((int)71, (int)-1137220935);
        String location = "l";
        double[] oDI = TestHelper.generateDoubleArray((int)71, (int)249785278);
        double[] oDV = TestHelper.generateDoubleArray((int)71, (int)24430023);
        double[] pClk0 = TestHelper.generateDoubleArray((int)71, (int)-411905318);
        double[] pClk1 = TestHelper.generateDoubleArray((int)71, (int)-833229470);
        double[] pClkL = TestHelper.generateDoubleArray((int)71, (int)317594068);
        double[] pClkU = TestHelper.generateDoubleArray((int)71, (int)-1691047137);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)-1359419341);
        double[] rG0 = TestHelper.generateDoubleArray((int)71, (int)2063854721);
        double[] rG1 = TestHelper.generateDoubleArray((int)71, (int)-1681088631);
        double[] rGL = TestHelper.generateDoubleArray((int)71, (int)2096354553);
        double[] rGU = TestHelper.generateDoubleArray((int)71, (int)-460458955);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)71, (int)1050315473);
        double[] ref05V = TestHelper.generateDoubleArray((int)71, (int)844891602);
        double[] ref125V = TestHelper.generateDoubleArray((int)71, (int)-318936967);
        double[] ref15V = TestHelper.generateDoubleArray((int)71, (int)986825022);
        double[] ref25V = TestHelper.generateDoubleArray((int)71, (int)-1972438551);
        double[] refN12 = TestHelper.generateDoubleArray((int)71, (int)-190354332);
        double[] refP12 = TestHelper.generateDoubleArray((int)71, (int)1368270662);
        double[] sClk0 = TestHelper.generateDoubleArray((int)71, (int)-1383670735);
        double[] sClk1 = TestHelper.generateDoubleArray((int)71, (int)-343627547);
        double[] sClkL = TestHelper.generateDoubleArray((int)71, (int)464326486);
        double[] sClkU = TestHelper.generateDoubleArray((int)71, (int)-1812386212);
        double[] temp1 = TestHelper.generateDoubleArray((int)71, (int)2132430017);
        double[] temp10 = TestHelper.generateDoubleArray((int)71, (int)-1013722796);
        double[] temp2 = TestHelper.generateDoubleArray((int)71, (int)784040707);
        double[] temp3 = TestHelper.generateDoubleArray((int)71, (int)-1319547359);
        double[] temp4 = TestHelper.generateDoubleArray((int)71, (int)-1279783441);
        double[] temp5 = TestHelper.generateDoubleArray((int)71, (int)-1497931914);
        double[] temp6 = TestHelper.generateDoubleArray((int)71, (int)1292651061);
        double[] temp7 = TestHelper.generateDoubleArray((int)71, (int)-1787342922);
        double[] temp8 = TestHelper.generateDoubleArray((int)71, (int)-384824623);
        double[] temp9 = TestHelper.generateDoubleArray((int)71, (int)840214950);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClk1, pClkL, pClkU, power, rG0, rG1, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClk0, sClk1, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk1, (double[])item_.getPClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG1, (double[])item_.getRG1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk1, (double[])item_.getSClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.9723993539810181;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6Telemetry() throws Exception {
        double rebsAverageTemp6 = 0.055644690990448;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebsAverageTemp6Telemetry(rebsAverageTemp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6Telemetry));
        Focal_plane_RebsAverageTemp6Telemetry item_ = (Focal_plane_RebsAverageTemp6Telemetry)item;
        Assert.assertEquals((double)rebsAverageTemp6, (double)item_.getRebsAverageTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)3024, (int)1374135188);
        String location = "u";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_03Telemetry() throws Exception {
        double clp_RTD_03 = 0.225097f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_03Telemetry(clp_RTD_03));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_03Telemetry));
        Mpm_CLP_RTD_03Telemetry item_ = (Mpm_CLP_RTD_03Telemetry)item;
        Assert.assertEquals((double)clp_RTD_03, (double)item_.getClp_RTD_03(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_05Telemetry() throws Exception {
        double clp_RTD_05 = 0.13989245891571045;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_05Telemetry(clp_RTD_05));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_05Telemetry));
        Mpm_CLP_RTD_05Telemetry item_ = (Mpm_CLP_RTD_05Telemetry)item;
        Assert.assertEquals((double)clp_RTD_05, (double)item_.getClp_RTD_05(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_50Telemetry() throws Exception {
        double clp_RTD_50 = 0.017054855823516846;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_50Telemetry(clp_RTD_50));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_50Telemetry));
        Mpm_CLP_RTD_50Telemetry item_ = (Mpm_CLP_RTD_50Telemetry)item;
        Assert.assertEquals((double)clp_RTD_50, (double)item_.getClp_RTD_50(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_55Telemetry() throws Exception {
        double clp_RTD_55 = 0.15414667129516602;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_55Telemetry(clp_RTD_55));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_55Telemetry));
        Mpm_CLP_RTD_55Telemetry item_ = (Mpm_CLP_RTD_55Telemetry)item;
        Assert.assertEquals((double)clp_RTD_55, (double)item_.getClp_RTD_55(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_12Telemetry() throws Exception {
        double cyp_RTD_12 = 0.05602646f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_12Telemetry(cyp_RTD_12));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_12Telemetry));
        Mpm_CYP_RTD_12Telemetry item_ = (Mpm_CYP_RTD_12Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_12, (double)item_.getCyp_RTD_12(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_14Telemetry() throws Exception {
        double cyp_RTD_14 = 0.1097666f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_14Telemetry(cyp_RTD_14));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_14Telemetry));
        Mpm_CYP_RTD_14Telemetry item_ = (Mpm_CYP_RTD_14Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_14, (double)item_.getCyp_RTD_14(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_31Telemetry() throws Exception {
        double cyp_RTD_31 = 0.488522469997406;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_31Telemetry(cyp_RTD_31));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_31Telemetry));
        Mpm_CYP_RTD_31Telemetry item_ = (Mpm_CYP_RTD_31Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_31, (double)item_.getCyp_RTD_31(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_43Telemetry() throws Exception {
        double cyp_RTD_43 = 0.07095426321029663;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_43Telemetry(cyp_RTD_43));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_43Telemetry));
        Mpm_CYP_RTD_43Telemetry item_ = (Mpm_CYP_RTD_43Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_43, (double)item_.getCyp_RTD_43(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Autochanger_AutochangerTrucks_TrendingTelemetry() throws Exception {
        boolean actruckxminus_handoffInError = true;
        boolean actruckxminus_handoffSensorValue = true;
        boolean actruckxminus_onlineInError = false;
        boolean actruckxminus_onlineSensorValue = false;
        boolean actruckxminus_standbyInError = false;
        boolean actruckxminus_standbySensorValue = true;
        boolean actruckxplus_handoffInError = true;
        boolean actruckxplus_handoffSensorValue = false;
        boolean actruckxplus_onlineInError = false;
        boolean actruckxplus_onlineSensorValue = false;
        boolean actruckxplus_standbyInError = false;
        boolean actruckxplus_standbySensorValue = true;
        boolean atHandoff = false;
        boolean atOnline = true;
        boolean atStandby = false;
        int driverPosition = 565;
        int followerPosition = 920;
        boolean homingDone = false;
        boolean inError = false;
        int proximityDistance = 114;
        double proximityVoltage = 0.8403965830802917;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry(actruckxminus_handoffInError, actruckxminus_handoffSensorValue, actruckxminus_onlineInError, actruckxminus_onlineSensorValue, actruckxminus_standbyInError, actruckxminus_standbySensorValue, actruckxplus_handoffInError, actruckxplus_handoffSensorValue, actruckxplus_onlineInError, actruckxplus_onlineSensorValue, actruckxplus_standbyInError, actruckxplus_standbySensorValue, atHandoff, atOnline, atStandby, driverPosition, followerPosition, homingDone, inError, proximityDistance, proximityVoltage));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry));
        Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry item_ = (Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry)item;
        Assert.assertEquals((Object)actruckxminus_handoffInError, (Object)item_.isActruckxminus_handoffInError());
        Assert.assertEquals((Object)actruckxminus_handoffSensorValue, (Object)item_.isActruckxminus_handoffSensorValue());
        Assert.assertEquals((Object)actruckxminus_onlineInError, (Object)item_.isActruckxminus_onlineInError());
        Assert.assertEquals((Object)actruckxminus_onlineSensorValue, (Object)item_.isActruckxminus_onlineSensorValue());
        Assert.assertEquals((Object)actruckxminus_standbyInError, (Object)item_.isActruckxminus_standbyInError());
        Assert.assertEquals((Object)actruckxminus_standbySensorValue, (Object)item_.isActruckxminus_standbySensorValue());
        Assert.assertEquals((Object)actruckxplus_handoffInError, (Object)item_.isActruckxplus_handoffInError());
        Assert.assertEquals((Object)actruckxplus_handoffSensorValue, (Object)item_.isActruckxplus_handoffSensorValue());
        Assert.assertEquals((Object)actruckxplus_onlineInError, (Object)item_.isActruckxplus_onlineInError());
        Assert.assertEquals((Object)actruckxplus_onlineSensorValue, (Object)item_.isActruckxplus_onlineSensorValue());
        Assert.assertEquals((Object)actruckxplus_standbyInError, (Object)item_.isActruckxplus_standbyInError());
        Assert.assertEquals((Object)actruckxplus_standbySensorValue, (Object)item_.isActruckxplus_standbySensorValue());
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atOnline, (Object)item_.isAtOnline());
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((long)driverPosition, (long)item_.getDriverPosition());
        Assert.assertEquals((long)followerPosition, (long)item_.getFollowerPosition());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)proximityDistance, (long)item_.getProximityDistance());
        Assert.assertEquals((double)proximityVoltage, (double)item_.getProximityVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Autochanger_Latches_TrendingTelemetry() throws Exception {
        int filterId = 646;
        String filterName = "o";
        String filterPresenceStatus = "";
        boolean latchxminus_filterEngagedSensorsInError = false;
        boolean latchxminus_filterPresenceSensorOn = false;
        boolean latchxminus_inError = true;
        boolean latchxminus_lockSensorOn = true;
        boolean latchxminus_lockSensorsInError = false;
        String latchxminus_lockStatus = "e";
        boolean latchxminus_unlockSensorOn = false;
        boolean latchxminus_unlockSensorsInError = false;
        boolean latchxplus_filterEngagedSensorsInError = false;
        boolean latchxplus_filterPresenceSensorOn = true;
        boolean latchxplus_inError = false;
        boolean latchxplus_lockSensorOn = false;
        boolean latchxplus_lockSensorsInError = false;
        String latchxplus_lockStatus = "u";
        boolean latchxplus_unlockSensorOn = false;
        boolean latchxplus_unlockSensorsInError = true;
        String lockStatus = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_Latches_TrendingTelemetry(filterId, filterName, filterPresenceStatus, latchxminus_filterEngagedSensorsInError, latchxminus_filterPresenceSensorOn, latchxminus_inError, latchxminus_lockSensorOn, latchxminus_lockSensorsInError, latchxminus_lockStatus, latchxminus_unlockSensorOn, latchxminus_unlockSensorsInError, latchxplus_filterEngagedSensorsInError, latchxplus_filterPresenceSensorOn, latchxplus_inError, latchxplus_lockSensorOn, latchxplus_lockSensorsInError, latchxplus_lockStatus, latchxplus_unlockSensorOn, latchxplus_unlockSensorsInError, lockStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_Latches_TrendingTelemetry));
        Fcs_Autochanger_Latches_TrendingTelemetry item_ = (Fcs_Autochanger_Latches_TrendingTelemetry)item;
        Assert.assertEquals((long)filterId, (long)item_.getFilterId());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((Object)latchxminus_filterEngagedSensorsInError, (Object)item_.isLatchxminus_filterEngagedSensorsInError());
        Assert.assertEquals((Object)latchxminus_filterPresenceSensorOn, (Object)item_.isLatchxminus_filterPresenceSensorOn());
        Assert.assertEquals((Object)latchxminus_inError, (Object)item_.isLatchxminus_inError());
        Assert.assertEquals((Object)latchxminus_lockSensorOn, (Object)item_.isLatchxminus_lockSensorOn());
        Assert.assertEquals((Object)latchxminus_lockSensorsInError, (Object)item_.isLatchxminus_lockSensorsInError());
        Assert.assertEquals((Object)latchxminus_lockStatus, (Object)item_.getLatchxminus_lockStatus());
        Assert.assertEquals((Object)latchxminus_unlockSensorOn, (Object)item_.isLatchxminus_unlockSensorOn());
        Assert.assertEquals((Object)latchxminus_unlockSensorsInError, (Object)item_.isLatchxminus_unlockSensorsInError());
        Assert.assertEquals((Object)latchxplus_filterEngagedSensorsInError, (Object)item_.isLatchxplus_filterEngagedSensorsInError());
        Assert.assertEquals((Object)latchxplus_filterPresenceSensorOn, (Object)item_.isLatchxplus_filterPresenceSensorOn());
        Assert.assertEquals((Object)latchxplus_inError, (Object)item_.isLatchxplus_inError());
        Assert.assertEquals((Object)latchxplus_lockSensorOn, (Object)item_.isLatchxplus_lockSensorOn());
        Assert.assertEquals((Object)latchxplus_lockSensorsInError, (Object)item_.isLatchxplus_lockSensorsInError());
        Assert.assertEquals((Object)latchxplus_lockStatus, (Object)item_.getLatchxplus_lockStatus());
        Assert.assertEquals((Object)latchxplus_unlockSensorOn, (Object)item_.isLatchxplus_unlockSensorOn());
        Assert.assertEquals((Object)latchxplus_unlockSensorsInError, (Object)item_.isLatchxplus_unlockSensorsInError());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
    }

    @Test
    public void sendReceiveFcs_Autochanger_OnlineClamps_TrendingTelemetry() throws Exception {
        String lockStatus = "g";
        int onlineClampRawStrain = 214;
        int onlineClampStrain = 146;
        int onlineclampxminus_current = 647;
        boolean onlineclampxminus_inError = true;
        boolean onlineclampxminus_lockSensorInError = false;
        boolean onlineclampxminus_lockSensorOn = false;
        String onlineclampxminus_lockStatus = "";
        int onlineclampxminus_position = 646;
        int onlineclampxminus_sentCurrent = 424;
        boolean onlineclampxminus_unlockSensorInError = true;
        boolean onlineclampxminus_unlockSensorOn = true;
        int onlineclampxplus_current = 205;
        boolean onlineclampxplus_inError = true;
        boolean onlineclampxplus_lockSensorInError = false;
        boolean onlineclampxplus_lockSensorOn = true;
        String onlineclampxplus_lockStatus = "x";
        int onlineclampxplus_position = 484;
        int onlineclampxplus_sentCurrent = 498;
        boolean onlineclampxplus_unlockSensorInError = false;
        boolean onlineclampxplus_unlockSensorOn = true;
        int onlineclampyminus_current = 538;
        boolean onlineclampyminus_inError = false;
        boolean onlineclampyminus_lockSensorInError = true;
        boolean onlineclampyminus_lockSensorOn = false;
        String onlineclampyminus_lockStatus = "";
        int onlineclampyminus_position = 13;
        int onlineclampyminus_sentCurrent = 409;
        boolean onlineclampyminus_unlockSensorInError = true;
        boolean onlineclampyminus_unlockSensorOn = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_OnlineClamps_TrendingTelemetry(lockStatus, onlineClampRawStrain, onlineClampStrain, onlineclampxminus_current, onlineclampxminus_inError, onlineclampxminus_lockSensorInError, onlineclampxminus_lockSensorOn, onlineclampxminus_lockStatus, onlineclampxminus_position, onlineclampxminus_sentCurrent, onlineclampxminus_unlockSensorInError, onlineclampxminus_unlockSensorOn, onlineclampxplus_current, onlineclampxplus_inError, onlineclampxplus_lockSensorInError, onlineclampxplus_lockSensorOn, onlineclampxplus_lockStatus, onlineclampxplus_position, onlineclampxplus_sentCurrent, onlineclampxplus_unlockSensorInError, onlineclampxplus_unlockSensorOn, onlineclampyminus_current, onlineclampyminus_inError, onlineclampyminus_lockSensorInError, onlineclampyminus_lockSensorOn, onlineclampyminus_lockStatus, onlineclampyminus_position, onlineclampyminus_sentCurrent, onlineclampyminus_unlockSensorInError, onlineclampyminus_unlockSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_OnlineClamps_TrendingTelemetry));
        Fcs_Autochanger_OnlineClamps_TrendingTelemetry item_ = (Fcs_Autochanger_OnlineClamps_TrendingTelemetry)item;
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((long)onlineClampRawStrain, (long)item_.getOnlineClampRawStrain());
        Assert.assertEquals((long)onlineClampStrain, (long)item_.getOnlineClampStrain());
        Assert.assertEquals((long)onlineclampxminus_current, (long)item_.getOnlineclampxminus_current());
        Assert.assertEquals((Object)onlineclampxminus_inError, (Object)item_.isOnlineclampxminus_inError());
        Assert.assertEquals((Object)onlineclampxminus_lockSensorInError, (Object)item_.isOnlineclampxminus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampxminus_lockSensorOn, (Object)item_.isOnlineclampxminus_lockSensorOn());
        Assert.assertEquals((Object)onlineclampxminus_lockStatus, (Object)item_.getOnlineclampxminus_lockStatus());
        Assert.assertEquals((long)onlineclampxminus_position, (long)item_.getOnlineclampxminus_position());
        Assert.assertEquals((long)onlineclampxminus_sentCurrent, (long)item_.getOnlineclampxminus_sentCurrent());
        Assert.assertEquals((Object)onlineclampxminus_unlockSensorInError, (Object)item_.isOnlineclampxminus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampxminus_unlockSensorOn, (Object)item_.isOnlineclampxminus_unlockSensorOn());
        Assert.assertEquals((long)onlineclampxplus_current, (long)item_.getOnlineclampxplus_current());
        Assert.assertEquals((Object)onlineclampxplus_inError, (Object)item_.isOnlineclampxplus_inError());
        Assert.assertEquals((Object)onlineclampxplus_lockSensorInError, (Object)item_.isOnlineclampxplus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampxplus_lockSensorOn, (Object)item_.isOnlineclampxplus_lockSensorOn());
        Assert.assertEquals((Object)onlineclampxplus_lockStatus, (Object)item_.getOnlineclampxplus_lockStatus());
        Assert.assertEquals((long)onlineclampxplus_position, (long)item_.getOnlineclampxplus_position());
        Assert.assertEquals((long)onlineclampxplus_sentCurrent, (long)item_.getOnlineclampxplus_sentCurrent());
        Assert.assertEquals((Object)onlineclampxplus_unlockSensorInError, (Object)item_.isOnlineclampxplus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampxplus_unlockSensorOn, (Object)item_.isOnlineclampxplus_unlockSensorOn());
        Assert.assertEquals((long)onlineclampyminus_current, (long)item_.getOnlineclampyminus_current());
        Assert.assertEquals((Object)onlineclampyminus_inError, (Object)item_.isOnlineclampyminus_inError());
        Assert.assertEquals((Object)onlineclampyminus_lockSensorInError, (Object)item_.isOnlineclampyminus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampyminus_lockSensorOn, (Object)item_.isOnlineclampyminus_lockSensorOn());
        Assert.assertEquals((Object)onlineclampyminus_lockStatus, (Object)item_.getOnlineclampyminus_lockStatus());
        Assert.assertEquals((long)onlineclampyminus_position, (long)item_.getOnlineclampyminus_position());
        Assert.assertEquals((long)onlineclampyminus_sentCurrent, (long)item_.getOnlineclampyminus_sentCurrent());
        Assert.assertEquals((Object)onlineclampyminus_unlockSensorInError, (Object)item_.isOnlineclampyminus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampyminus_unlockSensorOn, (Object)item_.isOnlineclampyminus_unlockSensorOn());
    }

    @Test
    public void sendReceiveFcs_Autochanger_TemperaturesTelemetry() throws Exception {
        double tempCellXminus = 0.6457613110542297;
        double tempClampMotorXminus = 0.2639222f;
        double tempClampMotorXplus = 0.03187215328216553;
        double tempClampMotorYminus = 0.26263678073883057;
        double tempFrontBox = 0.28186362981796265;
        double tempLinearRailMotorXminus = 0.9397711753845215;
        double tempLinearRailMotorXplus = 0.9006848335266113;
        double tempRearBox = 0.07406091690063477;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_TemperaturesTelemetry(tempCellXminus, tempClampMotorXminus, tempClampMotorXplus, tempClampMotorYminus, tempFrontBox, tempLinearRailMotorXminus, tempLinearRailMotorXplus, tempRearBox));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_TemperaturesTelemetry));
        Fcs_Autochanger_TemperaturesTelemetry item_ = (Fcs_Autochanger_TemperaturesTelemetry)item;
        Assert.assertEquals((double)tempCellXminus, (double)item_.getTempCellXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempClampMotorXminus, (double)item_.getTempClampMotorXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempClampMotorXplus, (double)item_.getTempClampMotorXplus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempClampMotorYminus, (double)item_.getTempClampMotorYminus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempFrontBox, (double)item_.getTempFrontBox(), (double)1.0E-6f);
        Assert.assertEquals((double)tempLinearRailMotorXminus, (double)item_.getTempLinearRailMotorXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempLinearRailMotorXplus, (double)item_.getTempLinearRailMotorXplus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempRearBox, (double)item_.getTempRearBox(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcSensorsGateway_TrendingTelemetry() throws Exception {
        int acAF0b = 888;
        int acAF0s = 525;
        int acAF1b = 556;
        int acAF1s = 676;
        int acAF3b = 416;
        int acAF3s = 729;
        int acAP2b = 411;
        int acAP2s = 642;
        int carouselHoldingFilterSensor0 = 12;
        int carouselHoldingFilterSensor1 = 747;
        int carouselStoppedAtStandby = 600;
        int carouselStoppedAtStandbyC = 79;
        int carousel_CF0 = 250;
        int carousel_CF0_C = 399;
        int carousel_CF1 = 465;
        int carousel_CF1_C = 472;
        int clampedStatusSensor = 98;
        int closeSensorBLatchXminus = 426;
        int closeSensorBLatchXplus = 530;
        int closeSensorLatchXminus = 637;
        int closeSensorLatchXplus = 695;
        int engineeringKey = 170;
        int engineeringkey_C = 974;
        int filterEngagedSensorBLatchXminus = 536;
        int filterEngagedSensorBLatchXplus = 861;
        int filterEngagedSensorLatchXminus = 843;
        int filterEngagedSensorLatchXplus = 56;
        int filterIDSensor0 = 329;
        int filterIDSensor1 = 299;
        int filterIDSensor2 = 84;
        int filterIDSensor3 = 43;
        int filterIDSensor4 = 919;
        int filterIDSensor5 = 919;
        int forceSensor0 = 176;
        int forceSensor1 = 722;
        int handoffPositionSensorBXminus = 770;
        int handoffPositionSensorBXplus = 240;
        int handoffPositionSensorXminus = 185;
        int handoffPositionSensorXplus = 284;
        double inclinometerXminus = 0.6775627136230469;
        double inclinometerXplus = 0.8754173517227173;
        int keyEng = 519;
        int keyEngb = 456;
        int keyLock = 294;
        int keyLockb = 854;
        int lps_0 = 845;
        int lps_1 = 393;
        int lrh_0 = 854;
        int lrh_1 = 219;
        int loaderCarrierRelayStatus = 996;
        int loaderChainPresenceSensor = 151;
        int loaderCloseSensor1 = 829;
        int loaderCloseSensor2 = 594;
        int loaderCloseSensor3 = 601;
        int loaderCloseSensor4 = 274;
        int loaderConnectedSensor = 783;
        int loaderConnectedSensorC = 414;
        int loaderDefaultStatus = 66;
        int loaderEngagedPositionSensor0 = 75;
        int loaderEngagedPositionSensor1 = 996;
        int loaderFilterDistanceSensor = 89;
        int loaderFilterGoodPositionStatus = 999;
        int loaderFilterPresenceSensor0 = 88;
        int loaderFilterPresenceSensor1 = 275;
        int loaderHandoffPositionSensor0 = 374;
        int loaderHandoffPositionSensor1 = 947;
        int loaderHoldingFilterSensor0 = 596;
        int loaderHoldingFilterSensor1 = 798;
        int loaderHooksRelayStatus = 267;
        int loaderOnCameraSensor0 = 57;
        int loaderOnCameraSensor1 = 81;
        int loaderOpenSensor1 = 761;
        int loaderOpenSensor2 = 353;
        int loaderOpenSensor3 = 291;
        int loaderOpenSensor4 = 987;
        int loaderStoragePositionSensor0 = 284;
        int loaderStoragePositionSensor1 = 170;
        int loader_LFD = 941;
        int loader_LFS = 674;
        int lockOut = 896;
        int lockOutShunt = 766;
        int lockout_C = 344;
        int lpmLatchesStatus = 595;
        int lpmLinearRail1Status = 182;
        int lpmLinearRail2Status = 186;
        int lpmOnlineClampsStatus = 19;
        int out_AF0 = 748;
        int out_AF0_C = 499;
        int out_AF1 = 230;
        int out_AF1_C = 628;
        int out_AF3 = 994;
        int out_AF3_C = 744;
        int out_AIN = 856;
        int out_AOL = 500;
        int out_AP1 = 361;
        int out_AP1_C = 957;
        int out_AP2 = 530;
        int out_AP2_C = 313;
        int out_AP3 = 519;
        int out_AP3_C = 853;
        int onlineClampXminusCloseSensor = 685;
        int onlineClampXminusCloseSensorC = 797;
        int onlineClampXminusOpenSensor = 421;
        int onlineClampXminusOpenSensorC = 949;
        int onlineClampXplusCloseSensor = 113;
        int onlineClampXplusCloseSensorC = 267;
        int onlineClampXplusOpenSensor = 763;
        int onlineClampXplusOpenSensorC = 167;
        int onlineClampYminusCloseSensor = 442;
        int onlineClampYminusCloseSensorC = 33;
        int onlineClampYminusOpenSensor = 119;
        int onlineClampYminusOpenSensorC = 675;
        int onlinePositionSensorBXminus = 232;
        int onlinePositionSensorBXplus = 353;
        int onlinePositionSensorXminus = 786;
        int onlinePositionSensorXplus = 84;
        int openSensorBLatchXminus = 59;
        int openSensorBLatchXplus = 890;
        int openSensorLatchXminus = 255;
        int openSensorLatchXplus = 832;
        int overClampedStatusSensor = 377;
        int presenceLoader = 68;
        int presenceloader_C = 489;
        int standbyPositionSensorBXminus = 962;
        int standbyPositionSensorBXplus = 190;
        int standbyPositionSensorXminus = 321;
        int standbyPositionSensorXplus = 31;
        int unclampedStatusSensor = 210;
        int underClampedStatusSensor = 391;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry(acAF0b, acAF0s, acAF1b, acAF1s, acAF3b, acAF3s, acAP2b, acAP2s, carouselHoldingFilterSensor0, carouselHoldingFilterSensor1, carouselStoppedAtStandby, carouselStoppedAtStandbyC, carousel_CF0, carousel_CF0_C, carousel_CF1, carousel_CF1_C, clampedStatusSensor, closeSensorBLatchXminus, closeSensorBLatchXplus, closeSensorLatchXminus, closeSensorLatchXplus, engineeringKey, engineeringkey_C, filterEngagedSensorBLatchXminus, filterEngagedSensorBLatchXplus, filterEngagedSensorLatchXminus, filterEngagedSensorLatchXplus, filterIDSensor0, filterIDSensor1, filterIDSensor2, filterIDSensor3, filterIDSensor4, filterIDSensor5, forceSensor0, forceSensor1, handoffPositionSensorBXminus, handoffPositionSensorBXplus, handoffPositionSensorXminus, handoffPositionSensorXplus, inclinometerXminus, inclinometerXplus, keyEng, keyEngb, keyLock, keyLockb, lps_0, lps_1, lrh_0, lrh_1, loaderCarrierRelayStatus, loaderChainPresenceSensor, loaderCloseSensor1, loaderCloseSensor2, loaderCloseSensor3, loaderCloseSensor4, loaderConnectedSensor, loaderConnectedSensorC, loaderDefaultStatus, loaderEngagedPositionSensor0, loaderEngagedPositionSensor1, loaderFilterDistanceSensor, loaderFilterGoodPositionStatus, loaderFilterPresenceSensor0, loaderFilterPresenceSensor1, loaderHandoffPositionSensor0, loaderHandoffPositionSensor1, loaderHoldingFilterSensor0, loaderHoldingFilterSensor1, loaderHooksRelayStatus, loaderOnCameraSensor0, loaderOnCameraSensor1, loaderOpenSensor1, loaderOpenSensor2, loaderOpenSensor3, loaderOpenSensor4, loaderStoragePositionSensor0, loaderStoragePositionSensor1, loader_LFD, loader_LFS, lockOut, lockOutShunt, lockout_C, lpmLatchesStatus, lpmLinearRail1Status, lpmLinearRail2Status, lpmOnlineClampsStatus, out_AF0, out_AF0_C, out_AF1, out_AF1_C, out_AF3, out_AF3_C, out_AIN, out_AOL, out_AP1, out_AP1_C, out_AP2, out_AP2_C, out_AP3, out_AP3_C, onlineClampXminusCloseSensor, onlineClampXminusCloseSensorC, onlineClampXminusOpenSensor, onlineClampXminusOpenSensorC, onlineClampXplusCloseSensor, onlineClampXplusCloseSensorC, onlineClampXplusOpenSensor, onlineClampXplusOpenSensorC, onlineClampYminusCloseSensor, onlineClampYminusCloseSensorC, onlineClampYminusOpenSensor, onlineClampYminusOpenSensorC, onlinePositionSensorBXminus, onlinePositionSensorBXplus, onlinePositionSensorXminus, onlinePositionSensorXplus, openSensorBLatchXminus, openSensorBLatchXplus, openSensorLatchXminus, openSensorLatchXplus, overClampedStatusSensor, presenceLoader, presenceloader_C, standbyPositionSensorBXminus, standbyPositionSensorBXplus, standbyPositionSensorXminus, standbyPositionSensorXplus, unclampedStatusSensor, underClampedStatusSensor));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry));
        Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry item_ = (Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)acAF0b, (long)item_.getAcAF0b());
        Assert.assertEquals((long)acAF0s, (long)item_.getAcAF0s());
        Assert.assertEquals((long)acAF1b, (long)item_.getAcAF1b());
        Assert.assertEquals((long)acAF1s, (long)item_.getAcAF1s());
        Assert.assertEquals((long)acAF3b, (long)item_.getAcAF3b());
        Assert.assertEquals((long)acAF3s, (long)item_.getAcAF3s());
        Assert.assertEquals((long)acAP2b, (long)item_.getAcAP2b());
        Assert.assertEquals((long)acAP2s, (long)item_.getAcAP2s());
        Assert.assertEquals((long)carouselHoldingFilterSensor0, (long)item_.getCarouselHoldingFilterSensor0());
        Assert.assertEquals((long)carouselHoldingFilterSensor1, (long)item_.getCarouselHoldingFilterSensor1());
        Assert.assertEquals((long)carouselStoppedAtStandby, (long)item_.getCarouselStoppedAtStandby());
        Assert.assertEquals((long)carouselStoppedAtStandbyC, (long)item_.getCarouselStoppedAtStandbyC());
        Assert.assertEquals((long)carousel_CF0, (long)item_.getCarousel_CF0());
        Assert.assertEquals((long)carousel_CF0_C, (long)item_.getCarousel_CF0_C());
        Assert.assertEquals((long)carousel_CF1, (long)item_.getCarousel_CF1());
        Assert.assertEquals((long)carousel_CF1_C, (long)item_.getCarousel_CF1_C());
        Assert.assertEquals((long)clampedStatusSensor, (long)item_.getClampedStatusSensor());
        Assert.assertEquals((long)closeSensorBLatchXminus, (long)item_.getCloseSensorBLatchXminus());
        Assert.assertEquals((long)closeSensorBLatchXplus, (long)item_.getCloseSensorBLatchXplus());
        Assert.assertEquals((long)closeSensorLatchXminus, (long)item_.getCloseSensorLatchXminus());
        Assert.assertEquals((long)closeSensorLatchXplus, (long)item_.getCloseSensorLatchXplus());
        Assert.assertEquals((long)engineeringKey, (long)item_.getEngineeringKey());
        Assert.assertEquals((long)engineeringkey_C, (long)item_.getEngineeringkey_C());
        Assert.assertEquals((long)filterEngagedSensorBLatchXminus, (long)item_.getFilterEngagedSensorBLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorBLatchXplus, (long)item_.getFilterEngagedSensorBLatchXplus());
        Assert.assertEquals((long)filterEngagedSensorLatchXminus, (long)item_.getFilterEngagedSensorLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorLatchXplus, (long)item_.getFilterEngagedSensorLatchXplus());
        Assert.assertEquals((long)filterIDSensor0, (long)item_.getFilterIDSensor0());
        Assert.assertEquals((long)filterIDSensor1, (long)item_.getFilterIDSensor1());
        Assert.assertEquals((long)filterIDSensor2, (long)item_.getFilterIDSensor2());
        Assert.assertEquals((long)filterIDSensor3, (long)item_.getFilterIDSensor3());
        Assert.assertEquals((long)filterIDSensor4, (long)item_.getFilterIDSensor4());
        Assert.assertEquals((long)filterIDSensor5, (long)item_.getFilterIDSensor5());
        Assert.assertEquals((long)forceSensor0, (long)item_.getForceSensor0());
        Assert.assertEquals((long)forceSensor1, (long)item_.getForceSensor1());
        Assert.assertEquals((long)handoffPositionSensorBXminus, (long)item_.getHandoffPositionSensorBXminus());
        Assert.assertEquals((long)handoffPositionSensorBXplus, (long)item_.getHandoffPositionSensorBXplus());
        Assert.assertEquals((long)handoffPositionSensorXminus, (long)item_.getHandoffPositionSensorXminus());
        Assert.assertEquals((long)handoffPositionSensorXplus, (long)item_.getHandoffPositionSensorXplus());
        Assert.assertEquals((double)inclinometerXminus, (double)item_.getInclinometerXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinometerXplus, (double)item_.getInclinometerXplus(), (double)1.0E-6f);
        Assert.assertEquals((long)keyEng, (long)item_.getKeyEng());
        Assert.assertEquals((long)keyEngb, (long)item_.getKeyEngb());
        Assert.assertEquals((long)keyLock, (long)item_.getKeyLock());
        Assert.assertEquals((long)keyLockb, (long)item_.getKeyLockb());
        Assert.assertEquals((long)lps_0, (long)item_.getLps_0());
        Assert.assertEquals((long)lps_1, (long)item_.getLps_1());
        Assert.assertEquals((long)lrh_0, (long)item_.getLrh_0());
        Assert.assertEquals((long)lrh_1, (long)item_.getLrh_1());
        Assert.assertEquals((long)loaderCarrierRelayStatus, (long)item_.getLoaderCarrierRelayStatus());
        Assert.assertEquals((long)loaderChainPresenceSensor, (long)item_.getLoaderChainPresenceSensor());
        Assert.assertEquals((long)loaderCloseSensor1, (long)item_.getLoaderCloseSensor1());
        Assert.assertEquals((long)loaderCloseSensor2, (long)item_.getLoaderCloseSensor2());
        Assert.assertEquals((long)loaderCloseSensor3, (long)item_.getLoaderCloseSensor3());
        Assert.assertEquals((long)loaderCloseSensor4, (long)item_.getLoaderCloseSensor4());
        Assert.assertEquals((long)loaderConnectedSensor, (long)item_.getLoaderConnectedSensor());
        Assert.assertEquals((long)loaderConnectedSensorC, (long)item_.getLoaderConnectedSensorC());
        Assert.assertEquals((long)loaderDefaultStatus, (long)item_.getLoaderDefaultStatus());
        Assert.assertEquals((long)loaderEngagedPositionSensor0, (long)item_.getLoaderEngagedPositionSensor0());
        Assert.assertEquals((long)loaderEngagedPositionSensor1, (long)item_.getLoaderEngagedPositionSensor1());
        Assert.assertEquals((long)loaderFilterDistanceSensor, (long)item_.getLoaderFilterDistanceSensor());
        Assert.assertEquals((long)loaderFilterGoodPositionStatus, (long)item_.getLoaderFilterGoodPositionStatus());
        Assert.assertEquals((long)loaderFilterPresenceSensor0, (long)item_.getLoaderFilterPresenceSensor0());
        Assert.assertEquals((long)loaderFilterPresenceSensor1, (long)item_.getLoaderFilterPresenceSensor1());
        Assert.assertEquals((long)loaderHandoffPositionSensor0, (long)item_.getLoaderHandoffPositionSensor0());
        Assert.assertEquals((long)loaderHandoffPositionSensor1, (long)item_.getLoaderHandoffPositionSensor1());
        Assert.assertEquals((long)loaderHoldingFilterSensor0, (long)item_.getLoaderHoldingFilterSensor0());
        Assert.assertEquals((long)loaderHoldingFilterSensor1, (long)item_.getLoaderHoldingFilterSensor1());
        Assert.assertEquals((long)loaderHooksRelayStatus, (long)item_.getLoaderHooksRelayStatus());
        Assert.assertEquals((long)loaderOnCameraSensor0, (long)item_.getLoaderOnCameraSensor0());
        Assert.assertEquals((long)loaderOnCameraSensor1, (long)item_.getLoaderOnCameraSensor1());
        Assert.assertEquals((long)loaderOpenSensor1, (long)item_.getLoaderOpenSensor1());
        Assert.assertEquals((long)loaderOpenSensor2, (long)item_.getLoaderOpenSensor2());
        Assert.assertEquals((long)loaderOpenSensor3, (long)item_.getLoaderOpenSensor3());
        Assert.assertEquals((long)loaderOpenSensor4, (long)item_.getLoaderOpenSensor4());
        Assert.assertEquals((long)loaderStoragePositionSensor0, (long)item_.getLoaderStoragePositionSensor0());
        Assert.assertEquals((long)loaderStoragePositionSensor1, (long)item_.getLoaderStoragePositionSensor1());
        Assert.assertEquals((long)loader_LFD, (long)item_.getLoader_LFD());
        Assert.assertEquals((long)loader_LFS, (long)item_.getLoader_LFS());
        Assert.assertEquals((long)lockOut, (long)item_.getLockOut());
        Assert.assertEquals((long)lockOutShunt, (long)item_.getLockOutShunt());
        Assert.assertEquals((long)lockout_C, (long)item_.getLockout_C());
        Assert.assertEquals((long)lpmLatchesStatus, (long)item_.getLpmLatchesStatus());
        Assert.assertEquals((long)lpmLinearRail1Status, (long)item_.getLpmLinearRail1Status());
        Assert.assertEquals((long)lpmLinearRail2Status, (long)item_.getLpmLinearRail2Status());
        Assert.assertEquals((long)lpmOnlineClampsStatus, (long)item_.getLpmOnlineClampsStatus());
        Assert.assertEquals((long)out_AF0, (long)item_.getOut_AF0());
        Assert.assertEquals((long)out_AF0_C, (long)item_.getOut_AF0_C());
        Assert.assertEquals((long)out_AF1, (long)item_.getOut_AF1());
        Assert.assertEquals((long)out_AF1_C, (long)item_.getOut_AF1_C());
        Assert.assertEquals((long)out_AF3, (long)item_.getOut_AF3());
        Assert.assertEquals((long)out_AF3_C, (long)item_.getOut_AF3_C());
        Assert.assertEquals((long)out_AIN, (long)item_.getOut_AIN());
        Assert.assertEquals((long)out_AOL, (long)item_.getOut_AOL());
        Assert.assertEquals((long)out_AP1, (long)item_.getOut_AP1());
        Assert.assertEquals((long)out_AP1_C, (long)item_.getOut_AP1_C());
        Assert.assertEquals((long)out_AP2, (long)item_.getOut_AP2());
        Assert.assertEquals((long)out_AP2_C, (long)item_.getOut_AP2_C());
        Assert.assertEquals((long)out_AP3, (long)item_.getOut_AP3());
        Assert.assertEquals((long)out_AP3_C, (long)item_.getOut_AP3_C());
        Assert.assertEquals((long)onlineClampXminusCloseSensor, (long)item_.getOnlineClampXminusCloseSensor());
        Assert.assertEquals((long)onlineClampXminusCloseSensorC, (long)item_.getOnlineClampXminusCloseSensorC());
        Assert.assertEquals((long)onlineClampXminusOpenSensor, (long)item_.getOnlineClampXminusOpenSensor());
        Assert.assertEquals((long)onlineClampXminusOpenSensorC, (long)item_.getOnlineClampXminusOpenSensorC());
        Assert.assertEquals((long)onlineClampXplusCloseSensor, (long)item_.getOnlineClampXplusCloseSensor());
        Assert.assertEquals((long)onlineClampXplusCloseSensorC, (long)item_.getOnlineClampXplusCloseSensorC());
        Assert.assertEquals((long)onlineClampXplusOpenSensor, (long)item_.getOnlineClampXplusOpenSensor());
        Assert.assertEquals((long)onlineClampXplusOpenSensorC, (long)item_.getOnlineClampXplusOpenSensorC());
        Assert.assertEquals((long)onlineClampYminusCloseSensor, (long)item_.getOnlineClampYminusCloseSensor());
        Assert.assertEquals((long)onlineClampYminusCloseSensorC, (long)item_.getOnlineClampYminusCloseSensorC());
        Assert.assertEquals((long)onlineClampYminusOpenSensor, (long)item_.getOnlineClampYminusOpenSensor());
        Assert.assertEquals((long)onlineClampYminusOpenSensorC, (long)item_.getOnlineClampYminusOpenSensorC());
        Assert.assertEquals((long)onlinePositionSensorBXminus, (long)item_.getOnlinePositionSensorBXminus());
        Assert.assertEquals((long)onlinePositionSensorBXplus, (long)item_.getOnlinePositionSensorBXplus());
        Assert.assertEquals((long)onlinePositionSensorXminus, (long)item_.getOnlinePositionSensorXminus());
        Assert.assertEquals((long)onlinePositionSensorXplus, (long)item_.getOnlinePositionSensorXplus());
        Assert.assertEquals((long)openSensorBLatchXminus, (long)item_.getOpenSensorBLatchXminus());
        Assert.assertEquals((long)openSensorBLatchXplus, (long)item_.getOpenSensorBLatchXplus());
        Assert.assertEquals((long)openSensorLatchXminus, (long)item_.getOpenSensorLatchXminus());
        Assert.assertEquals((long)openSensorLatchXplus, (long)item_.getOpenSensorLatchXplus());
        Assert.assertEquals((long)overClampedStatusSensor, (long)item_.getOverClampedStatusSensor());
        Assert.assertEquals((long)presenceLoader, (long)item_.getPresenceLoader());
        Assert.assertEquals((long)presenceloader_C, (long)item_.getPresenceloader_C());
        Assert.assertEquals((long)standbyPositionSensorBXminus, (long)item_.getStandbyPositionSensorBXminus());
        Assert.assertEquals((long)standbyPositionSensorBXplus, (long)item_.getStandbyPositionSensorBXplus());
        Assert.assertEquals((long)standbyPositionSensorXminus, (long)item_.getStandbyPositionSensorXminus());
        Assert.assertEquals((long)standbyPositionSensorXplus, (long)item_.getStandbyPositionSensorXplus());
        Assert.assertEquals((long)unclampedStatusSensor, (long)item_.getUnclampedStatusSensor());
        Assert.assertEquals((long)underClampedStatusSensor, (long)item_.getUnderClampedStatusSensor());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcTruckXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 814;
        boolean brakeActivated = false;
        int current = 155;
        int errorHistoryNB = 875;
        String errorRegister = "";
        int followingError = 717;
        boolean inError = false;
        int lastErrorCode = 470;
        String lastErrorName = "j";
        String mode = "n";
        int position = 303;
        long profileAcceleration = 733L;
        long profileDeceleration = 874L;
        long profileVelocity = 45L;
        String state = "";
        int velocity = 240;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry));
        Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcTruckXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 211;
        boolean brakeActivated = false;
        int current = 636;
        int errorHistoryNB = 184;
        String errorRegister = "";
        int followingError = 917;
        boolean inError = false;
        int lastErrorCode = 907;
        String lastErrorName = "s";
        String mode = "z";
        int position = 828;
        long profileAcceleration = 40L;
        long profileDeceleration = 391L;
        long profileVelocity = 367L;
        String state = "h";
        int velocity = 977;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry));
        Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Accelerobf_TrendingTelemetry() throws Exception {
        double accelerationX = 0.23288464546203613;
        double accelerationY = 0.7585811018943787;
        double accelerationZ = 0.9869605302810669;
        double airmass = 0.8289714455604553;
        double angularVelocityX = 0.6147958040237427;
        double angularVelocityY = 0.07330119609832764;
        double angularVelocityZ = 0.4299505352973938;
        double azimut = 0.8104814887046814;
        double elevation = 0.2115178108215332;
        int errorHistoryNB = 161;
        String errorRegister = "h";
        double gravity = 0.6259182691574097;
        boolean inError = false;
        int lastErrorCode = 186;
        String lastErrorName = "e";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Accelerobf_TrendingTelemetry(accelerationX, accelerationY, accelerationZ, airmass, angularVelocityX, angularVelocityY, angularVelocityZ, azimut, elevation, errorHistoryNB, errorRegister, gravity, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Accelerobf_TrendingTelemetry));
        Fcs_Canbus0_Accelerobf_TrendingTelemetry item_ = (Fcs_Canbus0_Accelerobf_TrendingTelemetry)item;
        Assert.assertEquals((double)accelerationX, (double)item_.getAccelerationX(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationY, (double)item_.getAccelerationY(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationZ, (double)item_.getAccelerationZ(), (double)1.0E-6f);
        Assert.assertEquals((double)airmass, (double)item_.getAirmass(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityX, (double)item_.getAngularVelocityX(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityY, (double)item_.getAngularVelocityY(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityZ, (double)item_.getAngularVelocityZ(), (double)1.0E-6f);
        Assert.assertEquals((double)azimut, (double)item_.getAzimut(), (double)1.0E-6f);
        Assert.assertEquals((double)elevation, (double)item_.getElevation(), (double)1.0E-6f);
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((double)gravity, (double)item_.getGravity(), (double)1.0E-6f);
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Ai814_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 303;
        String errorRegister = "b";
        boolean inError = false;
        int lastErrorCode = 183;
        String lastErrorName = "l";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Ai814_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Ai814_TrendingTelemetry));
        Fcs_Canbus0_Ai814_TrendingTelemetry item_ = (Fcs_Canbus0_Ai814_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_BrakeSystemGateway_TrendingTelemetry() throws Exception {
        int acAF0b = 496;
        int acAF0s = 889;
        int acAF1b = 338;
        int acAF1s = 648;
        int acAF3b = 925;
        int acAF3s = 524;
        int acAP2b = 463;
        int acAP2s = 913;
        int carouselHoldingFilterSensor0 = 62;
        int carouselHoldingFilterSensor1 = 390;
        int carouselStoppedAtStandby = 105;
        int carouselStoppedAtStandbyC = 896;
        int carousel_CF0 = 192;
        int carousel_CF0_C = 781;
        int carousel_CF1 = 980;
        int carousel_CF1_C = 974;
        int clampedStatusSensor = 881;
        int closeSensorBLatchXminus = 373;
        int closeSensorBLatchXplus = 622;
        int closeSensorLatchXminus = 302;
        int closeSensorLatchXplus = 752;
        int engineeringKey = 195;
        int engineeringkey_C = 654;
        int filterEngagedSensorBLatchXminus = 581;
        int filterEngagedSensorBLatchXplus = 969;
        int filterEngagedSensorLatchXminus = 976;
        int filterEngagedSensorLatchXplus = 690;
        int filterIDSensor0 = 988;
        int filterIDSensor1 = 117;
        int filterIDSensor2 = 298;
        int filterIDSensor3 = 781;
        int filterIDSensor4 = 641;
        int filterIDSensor5 = 58;
        int forceSensor0 = 140;
        int forceSensor1 = 193;
        int handoffPositionSensorBXminus = 500;
        int handoffPositionSensorBXplus = 716;
        int handoffPositionSensorXminus = 894;
        int handoffPositionSensorXplus = 78;
        double inclinometerXminus = 0.3725815415382385;
        double inclinometerXplus = 0.4662118f;
        int keyEng = 287;
        int keyEngb = 679;
        int keyLock = 459;
        int keyLockb = 152;
        int lps_0 = 206;
        int lps_1 = 853;
        int lrh_0 = 438;
        int lrh_1 = 143;
        int loaderCarrierRelayStatus = 217;
        int loaderChainPresenceSensor = 842;
        int loaderCloseSensor1 = 614;
        int loaderCloseSensor2 = 443;
        int loaderCloseSensor3 = 92;
        int loaderCloseSensor4 = 932;
        int loaderConnectedSensor = 709;
        int loaderConnectedSensorC = 434;
        int loaderDefaultStatus = 851;
        int loaderEngagedPositionSensor0 = 373;
        int loaderEngagedPositionSensor1 = 159;
        int loaderFilterDistanceSensor = 363;
        int loaderFilterGoodPositionStatus = 51;
        int loaderFilterPresenceSensor0 = 699;
        int loaderFilterPresenceSensor1 = 346;
        int loaderHandoffPositionSensor0 = 2;
        int loaderHandoffPositionSensor1 = 882;
        int loaderHoldingFilterSensor0 = 880;
        int loaderHoldingFilterSensor1 = 176;
        int loaderHooksRelayStatus = 847;
        int loaderOnCameraSensor0 = 247;
        int loaderOnCameraSensor1 = 160;
        int loaderOpenSensor1 = 321;
        int loaderOpenSensor2 = 916;
        int loaderOpenSensor3 = 988;
        int loaderOpenSensor4 = 586;
        int loaderStoragePositionSensor0 = 758;
        int loaderStoragePositionSensor1 = 481;
        int loader_LFD = 792;
        int loader_LFS = 94;
        int lockOut = 40;
        int lockOutShunt = 326;
        int lockout_C = 137;
        int lpmLatchesStatus = 945;
        int lpmLinearRail1Status = 215;
        int lpmLinearRail2Status = 60;
        int lpmOnlineClampsStatus = 678;
        int out_AF0 = 864;
        int out_AF0_C = 110;
        int out_AF1 = 624;
        int out_AF1_C = 19;
        int out_AF3 = 799;
        int out_AF3_C = 404;
        int out_AIN = 813;
        int out_AOL = 278;
        int out_AP1 = 524;
        int out_AP1_C = 102;
        int out_AP2 = 29;
        int out_AP2_C = 214;
        int out_AP3 = 292;
        int out_AP3_C = 767;
        int onlineClampXminusCloseSensor = 444;
        int onlineClampXminusCloseSensorC = 331;
        int onlineClampXminusOpenSensor = 41;
        int onlineClampXminusOpenSensorC = 641;
        int onlineClampXplusCloseSensor = 561;
        int onlineClampXplusCloseSensorC = 432;
        int onlineClampXplusOpenSensor = 496;
        int onlineClampXplusOpenSensorC = 421;
        int onlineClampYminusCloseSensor = 129;
        int onlineClampYminusCloseSensorC = 813;
        int onlineClampYminusOpenSensor = 643;
        int onlineClampYminusOpenSensorC = 991;
        int onlinePositionSensorBXminus = 266;
        int onlinePositionSensorBXplus = 753;
        int onlinePositionSensorXminus = 831;
        int onlinePositionSensorXplus = 501;
        int openSensorBLatchXminus = 993;
        int openSensorBLatchXplus = 581;
        int openSensorLatchXminus = 212;
        int openSensorLatchXplus = 814;
        int overClampedStatusSensor = 784;
        int presenceLoader = 420;
        int presenceloader_C = 596;
        int standbyPositionSensorBXminus = 519;
        int standbyPositionSensorBXplus = 568;
        int standbyPositionSensorXminus = 830;
        int standbyPositionSensorXplus = 650;
        int unclampedStatusSensor = 905;
        int underClampedStatusSensor = 38;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry(acAF0b, acAF0s, acAF1b, acAF1s, acAF3b, acAF3s, acAP2b, acAP2s, carouselHoldingFilterSensor0, carouselHoldingFilterSensor1, carouselStoppedAtStandby, carouselStoppedAtStandbyC, carousel_CF0, carousel_CF0_C, carousel_CF1, carousel_CF1_C, clampedStatusSensor, closeSensorBLatchXminus, closeSensorBLatchXplus, closeSensorLatchXminus, closeSensorLatchXplus, engineeringKey, engineeringkey_C, filterEngagedSensorBLatchXminus, filterEngagedSensorBLatchXplus, filterEngagedSensorLatchXminus, filterEngagedSensorLatchXplus, filterIDSensor0, filterIDSensor1, filterIDSensor2, filterIDSensor3, filterIDSensor4, filterIDSensor5, forceSensor0, forceSensor1, handoffPositionSensorBXminus, handoffPositionSensorBXplus, handoffPositionSensorXminus, handoffPositionSensorXplus, inclinometerXminus, inclinometerXplus, keyEng, keyEngb, keyLock, keyLockb, lps_0, lps_1, lrh_0, lrh_1, loaderCarrierRelayStatus, loaderChainPresenceSensor, loaderCloseSensor1, loaderCloseSensor2, loaderCloseSensor3, loaderCloseSensor4, loaderConnectedSensor, loaderConnectedSensorC, loaderDefaultStatus, loaderEngagedPositionSensor0, loaderEngagedPositionSensor1, loaderFilterDistanceSensor, loaderFilterGoodPositionStatus, loaderFilterPresenceSensor0, loaderFilterPresenceSensor1, loaderHandoffPositionSensor0, loaderHandoffPositionSensor1, loaderHoldingFilterSensor0, loaderHoldingFilterSensor1, loaderHooksRelayStatus, loaderOnCameraSensor0, loaderOnCameraSensor1, loaderOpenSensor1, loaderOpenSensor2, loaderOpenSensor3, loaderOpenSensor4, loaderStoragePositionSensor0, loaderStoragePositionSensor1, loader_LFD, loader_LFS, lockOut, lockOutShunt, lockout_C, lpmLatchesStatus, lpmLinearRail1Status, lpmLinearRail2Status, lpmOnlineClampsStatus, out_AF0, out_AF0_C, out_AF1, out_AF1_C, out_AF3, out_AF3_C, out_AIN, out_AOL, out_AP1, out_AP1_C, out_AP2, out_AP2_C, out_AP3, out_AP3_C, onlineClampXminusCloseSensor, onlineClampXminusCloseSensorC, onlineClampXminusOpenSensor, onlineClampXminusOpenSensorC, onlineClampXplusCloseSensor, onlineClampXplusCloseSensorC, onlineClampXplusOpenSensor, onlineClampXplusOpenSensorC, onlineClampYminusCloseSensor, onlineClampYminusCloseSensorC, onlineClampYminusOpenSensor, onlineClampYminusOpenSensorC, onlinePositionSensorBXminus, onlinePositionSensorBXplus, onlinePositionSensorXminus, onlinePositionSensorXplus, openSensorBLatchXminus, openSensorBLatchXplus, openSensorLatchXminus, openSensorLatchXplus, overClampedStatusSensor, presenceLoader, presenceloader_C, standbyPositionSensorBXminus, standbyPositionSensorBXplus, standbyPositionSensorXminus, standbyPositionSensorXplus, unclampedStatusSensor, underClampedStatusSensor));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry));
        Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry item_ = (Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)acAF0b, (long)item_.getAcAF0b());
        Assert.assertEquals((long)acAF0s, (long)item_.getAcAF0s());
        Assert.assertEquals((long)acAF1b, (long)item_.getAcAF1b());
        Assert.assertEquals((long)acAF1s, (long)item_.getAcAF1s());
        Assert.assertEquals((long)acAF3b, (long)item_.getAcAF3b());
        Assert.assertEquals((long)acAF3s, (long)item_.getAcAF3s());
        Assert.assertEquals((long)acAP2b, (long)item_.getAcAP2b());
        Assert.assertEquals((long)acAP2s, (long)item_.getAcAP2s());
        Assert.assertEquals((long)carouselHoldingFilterSensor0, (long)item_.getCarouselHoldingFilterSensor0());
        Assert.assertEquals((long)carouselHoldingFilterSensor1, (long)item_.getCarouselHoldingFilterSensor1());
        Assert.assertEquals((long)carouselStoppedAtStandby, (long)item_.getCarouselStoppedAtStandby());
        Assert.assertEquals((long)carouselStoppedAtStandbyC, (long)item_.getCarouselStoppedAtStandbyC());
        Assert.assertEquals((long)carousel_CF0, (long)item_.getCarousel_CF0());
        Assert.assertEquals((long)carousel_CF0_C, (long)item_.getCarousel_CF0_C());
        Assert.assertEquals((long)carousel_CF1, (long)item_.getCarousel_CF1());
        Assert.assertEquals((long)carousel_CF1_C, (long)item_.getCarousel_CF1_C());
        Assert.assertEquals((long)clampedStatusSensor, (long)item_.getClampedStatusSensor());
        Assert.assertEquals((long)closeSensorBLatchXminus, (long)item_.getCloseSensorBLatchXminus());
        Assert.assertEquals((long)closeSensorBLatchXplus, (long)item_.getCloseSensorBLatchXplus());
        Assert.assertEquals((long)closeSensorLatchXminus, (long)item_.getCloseSensorLatchXminus());
        Assert.assertEquals((long)closeSensorLatchXplus, (long)item_.getCloseSensorLatchXplus());
        Assert.assertEquals((long)engineeringKey, (long)item_.getEngineeringKey());
        Assert.assertEquals((long)engineeringkey_C, (long)item_.getEngineeringkey_C());
        Assert.assertEquals((long)filterEngagedSensorBLatchXminus, (long)item_.getFilterEngagedSensorBLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorBLatchXplus, (long)item_.getFilterEngagedSensorBLatchXplus());
        Assert.assertEquals((long)filterEngagedSensorLatchXminus, (long)item_.getFilterEngagedSensorLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorLatchXplus, (long)item_.getFilterEngagedSensorLatchXplus());
        Assert.assertEquals((long)filterIDSensor0, (long)item_.getFilterIDSensor0());
        Assert.assertEquals((long)filterIDSensor1, (long)item_.getFilterIDSensor1());
        Assert.assertEquals((long)filterIDSensor2, (long)item_.getFilterIDSensor2());
        Assert.assertEquals((long)filterIDSensor3, (long)item_.getFilterIDSensor3());
        Assert.assertEquals((long)filterIDSensor4, (long)item_.getFilterIDSensor4());
        Assert.assertEquals((long)filterIDSensor5, (long)item_.getFilterIDSensor5());
        Assert.assertEquals((long)forceSensor0, (long)item_.getForceSensor0());
        Assert.assertEquals((long)forceSensor1, (long)item_.getForceSensor1());
        Assert.assertEquals((long)handoffPositionSensorBXminus, (long)item_.getHandoffPositionSensorBXminus());
        Assert.assertEquals((long)handoffPositionSensorBXplus, (long)item_.getHandoffPositionSensorBXplus());
        Assert.assertEquals((long)handoffPositionSensorXminus, (long)item_.getHandoffPositionSensorXminus());
        Assert.assertEquals((long)handoffPositionSensorXplus, (long)item_.getHandoffPositionSensorXplus());
        Assert.assertEquals((double)inclinometerXminus, (double)item_.getInclinometerXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinometerXplus, (double)item_.getInclinometerXplus(), (double)1.0E-6f);
        Assert.assertEquals((long)keyEng, (long)item_.getKeyEng());
        Assert.assertEquals((long)keyEngb, (long)item_.getKeyEngb());
        Assert.assertEquals((long)keyLock, (long)item_.getKeyLock());
        Assert.assertEquals((long)keyLockb, (long)item_.getKeyLockb());
        Assert.assertEquals((long)lps_0, (long)item_.getLps_0());
        Assert.assertEquals((long)lps_1, (long)item_.getLps_1());
        Assert.assertEquals((long)lrh_0, (long)item_.getLrh_0());
        Assert.assertEquals((long)lrh_1, (long)item_.getLrh_1());
        Assert.assertEquals((long)loaderCarrierRelayStatus, (long)item_.getLoaderCarrierRelayStatus());
        Assert.assertEquals((long)loaderChainPresenceSensor, (long)item_.getLoaderChainPresenceSensor());
        Assert.assertEquals((long)loaderCloseSensor1, (long)item_.getLoaderCloseSensor1());
        Assert.assertEquals((long)loaderCloseSensor2, (long)item_.getLoaderCloseSensor2());
        Assert.assertEquals((long)loaderCloseSensor3, (long)item_.getLoaderCloseSensor3());
        Assert.assertEquals((long)loaderCloseSensor4, (long)item_.getLoaderCloseSensor4());
        Assert.assertEquals((long)loaderConnectedSensor, (long)item_.getLoaderConnectedSensor());
        Assert.assertEquals((long)loaderConnectedSensorC, (long)item_.getLoaderConnectedSensorC());
        Assert.assertEquals((long)loaderDefaultStatus, (long)item_.getLoaderDefaultStatus());
        Assert.assertEquals((long)loaderEngagedPositionSensor0, (long)item_.getLoaderEngagedPositionSensor0());
        Assert.assertEquals((long)loaderEngagedPositionSensor1, (long)item_.getLoaderEngagedPositionSensor1());
        Assert.assertEquals((long)loaderFilterDistanceSensor, (long)item_.getLoaderFilterDistanceSensor());
        Assert.assertEquals((long)loaderFilterGoodPositionStatus, (long)item_.getLoaderFilterGoodPositionStatus());
        Assert.assertEquals((long)loaderFilterPresenceSensor0, (long)item_.getLoaderFilterPresenceSensor0());
        Assert.assertEquals((long)loaderFilterPresenceSensor1, (long)item_.getLoaderFilterPresenceSensor1());
        Assert.assertEquals((long)loaderHandoffPositionSensor0, (long)item_.getLoaderHandoffPositionSensor0());
        Assert.assertEquals((long)loaderHandoffPositionSensor1, (long)item_.getLoaderHandoffPositionSensor1());
        Assert.assertEquals((long)loaderHoldingFilterSensor0, (long)item_.getLoaderHoldingFilterSensor0());
        Assert.assertEquals((long)loaderHoldingFilterSensor1, (long)item_.getLoaderHoldingFilterSensor1());
        Assert.assertEquals((long)loaderHooksRelayStatus, (long)item_.getLoaderHooksRelayStatus());
        Assert.assertEquals((long)loaderOnCameraSensor0, (long)item_.getLoaderOnCameraSensor0());
        Assert.assertEquals((long)loaderOnCameraSensor1, (long)item_.getLoaderOnCameraSensor1());
        Assert.assertEquals((long)loaderOpenSensor1, (long)item_.getLoaderOpenSensor1());
        Assert.assertEquals((long)loaderOpenSensor2, (long)item_.getLoaderOpenSensor2());
        Assert.assertEquals((long)loaderOpenSensor3, (long)item_.getLoaderOpenSensor3());
        Assert.assertEquals((long)loaderOpenSensor4, (long)item_.getLoaderOpenSensor4());
        Assert.assertEquals((long)loaderStoragePositionSensor0, (long)item_.getLoaderStoragePositionSensor0());
        Assert.assertEquals((long)loaderStoragePositionSensor1, (long)item_.getLoaderStoragePositionSensor1());
        Assert.assertEquals((long)loader_LFD, (long)item_.getLoader_LFD());
        Assert.assertEquals((long)loader_LFS, (long)item_.getLoader_LFS());
        Assert.assertEquals((long)lockOut, (long)item_.getLockOut());
        Assert.assertEquals((long)lockOutShunt, (long)item_.getLockOutShunt());
        Assert.assertEquals((long)lockout_C, (long)item_.getLockout_C());
        Assert.assertEquals((long)lpmLatchesStatus, (long)item_.getLpmLatchesStatus());
        Assert.assertEquals((long)lpmLinearRail1Status, (long)item_.getLpmLinearRail1Status());
        Assert.assertEquals((long)lpmLinearRail2Status, (long)item_.getLpmLinearRail2Status());
        Assert.assertEquals((long)lpmOnlineClampsStatus, (long)item_.getLpmOnlineClampsStatus());
        Assert.assertEquals((long)out_AF0, (long)item_.getOut_AF0());
        Assert.assertEquals((long)out_AF0_C, (long)item_.getOut_AF0_C());
        Assert.assertEquals((long)out_AF1, (long)item_.getOut_AF1());
        Assert.assertEquals((long)out_AF1_C, (long)item_.getOut_AF1_C());
        Assert.assertEquals((long)out_AF3, (long)item_.getOut_AF3());
        Assert.assertEquals((long)out_AF3_C, (long)item_.getOut_AF3_C());
        Assert.assertEquals((long)out_AIN, (long)item_.getOut_AIN());
        Assert.assertEquals((long)out_AOL, (long)item_.getOut_AOL());
        Assert.assertEquals((long)out_AP1, (long)item_.getOut_AP1());
        Assert.assertEquals((long)out_AP1_C, (long)item_.getOut_AP1_C());
        Assert.assertEquals((long)out_AP2, (long)item_.getOut_AP2());
        Assert.assertEquals((long)out_AP2_C, (long)item_.getOut_AP2_C());
        Assert.assertEquals((long)out_AP3, (long)item_.getOut_AP3());
        Assert.assertEquals((long)out_AP3_C, (long)item_.getOut_AP3_C());
        Assert.assertEquals((long)onlineClampXminusCloseSensor, (long)item_.getOnlineClampXminusCloseSensor());
        Assert.assertEquals((long)onlineClampXminusCloseSensorC, (long)item_.getOnlineClampXminusCloseSensorC());
        Assert.assertEquals((long)onlineClampXminusOpenSensor, (long)item_.getOnlineClampXminusOpenSensor());
        Assert.assertEquals((long)onlineClampXminusOpenSensorC, (long)item_.getOnlineClampXminusOpenSensorC());
        Assert.assertEquals((long)onlineClampXplusCloseSensor, (long)item_.getOnlineClampXplusCloseSensor());
        Assert.assertEquals((long)onlineClampXplusCloseSensorC, (long)item_.getOnlineClampXplusCloseSensorC());
        Assert.assertEquals((long)onlineClampXplusOpenSensor, (long)item_.getOnlineClampXplusOpenSensor());
        Assert.assertEquals((long)onlineClampXplusOpenSensorC, (long)item_.getOnlineClampXplusOpenSensorC());
        Assert.assertEquals((long)onlineClampYminusCloseSensor, (long)item_.getOnlineClampYminusCloseSensor());
        Assert.assertEquals((long)onlineClampYminusCloseSensorC, (long)item_.getOnlineClampYminusCloseSensorC());
        Assert.assertEquals((long)onlineClampYminusOpenSensor, (long)item_.getOnlineClampYminusOpenSensor());
        Assert.assertEquals((long)onlineClampYminusOpenSensorC, (long)item_.getOnlineClampYminusOpenSensorC());
        Assert.assertEquals((long)onlinePositionSensorBXminus, (long)item_.getOnlinePositionSensorBXminus());
        Assert.assertEquals((long)onlinePositionSensorBXplus, (long)item_.getOnlinePositionSensorBXplus());
        Assert.assertEquals((long)onlinePositionSensorXminus, (long)item_.getOnlinePositionSensorXminus());
        Assert.assertEquals((long)onlinePositionSensorXplus, (long)item_.getOnlinePositionSensorXplus());
        Assert.assertEquals((long)openSensorBLatchXminus, (long)item_.getOpenSensorBLatchXminus());
        Assert.assertEquals((long)openSensorBLatchXplus, (long)item_.getOpenSensorBLatchXplus());
        Assert.assertEquals((long)openSensorLatchXminus, (long)item_.getOpenSensorLatchXminus());
        Assert.assertEquals((long)openSensorLatchXplus, (long)item_.getOpenSensorLatchXplus());
        Assert.assertEquals((long)overClampedStatusSensor, (long)item_.getOverClampedStatusSensor());
        Assert.assertEquals((long)presenceLoader, (long)item_.getPresenceLoader());
        Assert.assertEquals((long)presenceloader_C, (long)item_.getPresenceloader_C());
        Assert.assertEquals((long)standbyPositionSensorBXminus, (long)item_.getStandbyPositionSensorBXminus());
        Assert.assertEquals((long)standbyPositionSensorBXplus, (long)item_.getStandbyPositionSensorBXplus());
        Assert.assertEquals((long)standbyPositionSensorXminus, (long)item_.getStandbyPositionSensorXminus());
        Assert.assertEquals((long)standbyPositionSensorXplus, (long)item_.getStandbyPositionSensorXplus());
        Assert.assertEquals((long)unclampedStatusSensor, (long)item_.getUnclampedStatusSensor());
        Assert.assertEquals((long)underClampedStatusSensor, (long)item_.getUnderClampedStatusSensor());
    }

    @Test
    public void sendReceiveFcs_Canbus0_CarouselController_TrendingTelemetry() throws Exception {
        int averageCurrent = 828;
        boolean brakeActivated = false;
        int current = 134;
        int errorHistoryNB = 845;
        String errorRegister = "";
        int followingError = 278;
        boolean inError = true;
        int lastErrorCode = 585;
        String lastErrorName = "j";
        String mode = "";
        int position = 27;
        long profileAcceleration = 290L;
        long profileDeceleration = 528L;
        long profileVelocity = 127L;
        String state = "e";
        int velocity = 152;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_CarouselController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_CarouselController_TrendingTelemetry));
        Fcs_Canbus0_CarouselController_TrendingTelemetry item_ = (Fcs_Canbus0_CarouselController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ClampXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 677;
        boolean brakeActivated = false;
        int current = 220;
        int errorHistoryNB = 685;
        String errorRegister = "v";
        int followingError = 618;
        boolean inError = false;
        int lastErrorCode = 261;
        String lastErrorName = "e";
        String mode = "";
        int position = 478;
        long profileAcceleration = 122L;
        long profileDeceleration = 56L;
        long profileVelocity = 418L;
        String state = "e";
        int velocity = 307;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ClampXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ClampXminusController_TrendingTelemetry));
        Fcs_Canbus0_ClampXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_ClampXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ClampXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 153;
        boolean brakeActivated = false;
        int current = 800;
        int errorHistoryNB = 29;
        String errorRegister = "l";
        int followingError = 963;
        boolean inError = false;
        int lastErrorCode = 930;
        String lastErrorName = "o";
        String mode = "d";
        int position = 899;
        long profileAcceleration = 202L;
        long profileDeceleration = 113L;
        long profileVelocity = 384L;
        String state = "";
        int velocity = 740;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ClampXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ClampXplusController_TrendingTelemetry));
        Fcs_Canbus0_ClampXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_ClampXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Hyttc580_TrendingTelemetry() throws Exception {
        long pdo1 = 370L;
        long pdo2 = 210L;
        long pdo4 = 994L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Hyttc580_TrendingTelemetry(pdo1, pdo2, pdo4));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Hyttc580_TrendingTelemetry));
        Fcs_Canbus0_Hyttc580_TrendingTelemetry item_ = (Fcs_Canbus0_Hyttc580_TrendingTelemetry)item;
        Assert.assertEquals((long)pdo1, (long)item_.getPdo1());
        Assert.assertEquals((long)pdo2, (long)item_.getPdo2());
        Assert.assertEquals((long)pdo4, (long)item_.getPdo4());
    }

    @Test
    public void sendReceiveFcs_Canbus0_LatchXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 852;
        boolean brakeActivated = true;
        int current = 546;
        int errorHistoryNB = 979;
        String errorRegister = "";
        int followingError = 223;
        boolean inError = false;
        int lastErrorCode = 386;
        String lastErrorName = "v";
        String mode = "c";
        int position = 419;
        long profileAcceleration = 439L;
        long profileDeceleration = 177L;
        long profileVelocity = 16L;
        String state = "f";
        int velocity = 563;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_LatchXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_LatchXminusController_TrendingTelemetry));
        Fcs_Canbus0_LatchXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_LatchXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_LatchXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 354;
        boolean brakeActivated = false;
        int current = 548;
        int errorHistoryNB = 609;
        String errorRegister = "j";
        int followingError = 254;
        boolean inError = false;
        int lastErrorCode = 626;
        String lastErrorName = "";
        String mode = "h";
        int position = 97;
        long profileAcceleration = 950L;
        long profileDeceleration = 666L;
        long profileVelocity = 75L;
        String state = "";
        int velocity = 936;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_LatchXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_LatchXplusController_TrendingTelemetry));
        Fcs_Canbus0_LatchXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_LatchXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 899;
        boolean brakeActivated = true;
        int current = 255;
        int errorHistoryNB = 607;
        String errorRegister = "";
        int followingError = 94;
        boolean inError = false;
        int lastErrorCode = 181;
        String lastErrorName = "";
        String mode = "s";
        int position = 756;
        long profileAcceleration = 239L;
        long profileDeceleration = 41L;
        long profileVelocity = 813L;
        String state = "";
        int velocity = 854;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 273;
        boolean brakeActivated = false;
        int current = 799;
        int errorHistoryNB = 912;
        String errorRegister = "d";
        int followingError = 869;
        boolean inError = false;
        int lastErrorCode = 63;
        String lastErrorName = "";
        String mode = "a";
        int position = 355;
        long profileAcceleration = 722L;
        long profileDeceleration = 851L;
        long profileVelocity = 115L;
        String state = "";
        int velocity = 252;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampYminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 76;
        boolean brakeActivated = false;
        int current = 847;
        int errorHistoryNB = 675;
        String errorRegister = "";
        int followingError = 757;
        boolean inError = true;
        int lastErrorCode = 540;
        String lastErrorName = "";
        String mode = "j";
        int position = 561;
        long profileAcceleration = 393L;
        long profileDeceleration = 827L;
        long profileVelocity = 556L;
        String state = "";
        int velocity = 574;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineStrainGauge_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 850;
        String errorRegister = "d";
        boolean inError = false;
        int lastErrorCode = 592;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry));
        Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 23;
        String errorRegister = "";
        boolean inError = false;
        int lastErrorCode = 292;
        String lastErrorName = "c";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry));
        Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry item_ = (Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Pt100_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 760;
        String errorRegister = "p";
        boolean inError = false;
        int lastErrorCode = 348;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Pt100_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Pt100_TrendingTelemetry));
        Fcs_Canbus0_Pt100_TrendingTelemetry item_ = (Fcs_Canbus0_Pt100_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_TempSensorsDevice1_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 271;
        String errorRegister = "";
        boolean inError = false;
        int lastErrorCode = 786;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry));
        Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry item_ = (Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_TempSensorsDevice2_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 612;
        String errorRegister = "t";
        boolean inError = false;
        int lastErrorCode = 867;
        String lastErrorName = "u";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry));
        Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry item_ = (Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus1_CarrierController_TrendingTelemetry() throws Exception {
        int averageCurrent = 160;
        boolean brakeActivated = false;
        int current = 906;
        int errorHistoryNB = 254;
        String errorRegister = "";
        int followingError = 116;
        boolean inError = true;
        int lastErrorCode = 51;
        String lastErrorName = "v";
        String mode = "e";
        int position = 389;
        long profileAcceleration = 140L;
        long profileDeceleration = 360L;
        long profileVelocity = 147L;
        String state = "c";
        int velocity = 787;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_CarrierController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_CarrierController_TrendingTelemetry));
        Fcs_Canbus1_CarrierController_TrendingTelemetry item_ = (Fcs_Canbus1_CarrierController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus1_HooksController_TrendingTelemetry() throws Exception {
        int averageCurrent = 154;
        boolean brakeActivated = false;
        int current = 256;
        int errorHistoryNB = 431;
        String errorRegister = "i";
        int followingError = 141;
        boolean inError = false;
        int lastErrorCode = 827;
        String lastErrorName = "j";
        String mode = "b";
        int position = 518;
        long profileAcceleration = 353L;
        long profileDeceleration = 402L;
        long profileVelocity = 811L;
        String state = "v";
        int velocity = 527;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_HooksController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_HooksController_TrendingTelemetry));
        Fcs_Canbus1_HooksController_TrendingTelemetry item_ = (Fcs_Canbus1_HooksController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry() throws Exception {
        int acAF0b = 250;
        int acAF0s = 151;
        int acAF1b = 245;
        int acAF1s = 252;
        int acAF3b = 262;
        int acAF3s = 985;
        int acAP2b = 82;
        int acAP2s = 390;
        int carouselHoldingFilterSensor0 = 844;
        int carouselHoldingFilterSensor1 = 488;
        int carouselStoppedAtStandby = 264;
        int carouselStoppedAtStandbyC = 869;
        int carousel_CF0 = 485;
        int carousel_CF0_C = 764;
        int carousel_CF1 = 575;
        int carousel_CF1_C = 766;
        int clampedStatusSensor = 758;
        int closeSensorBLatchXminus = 414;
        int closeSensorBLatchXplus = 812;
        int closeSensorLatchXminus = 86;
        int closeSensorLatchXplus = 842;
        int engineeringKey = 339;
        int engineeringkey_C = 156;
        int filterEngagedSensorBLatchXminus = 958;
        int filterEngagedSensorBLatchXplus = 110;
        int filterEngagedSensorLatchXminus = 640;
        int filterEngagedSensorLatchXplus = 165;
        int filterIDSensor0 = 863;
        int filterIDSensor1 = 600;
        int filterIDSensor2 = 805;
        int filterIDSensor3 = 80;
        int filterIDSensor4 = 691;
        int filterIDSensor5 = 845;
        int forceSensor0 = 182;
        int forceSensor1 = 254;
        int handoffPositionSensorBXminus = 330;
        int handoffPositionSensorBXplus = 350;
        int handoffPositionSensorXminus = 604;
        int handoffPositionSensorXplus = 390;
        double inclinometerXminus = 0.8392289280891418;
        double inclinometerXplus = 0.7476898431777954;
        int keyEng = 851;
        int keyEngb = 417;
        int keyLock = 390;
        int keyLockb = 611;
        int lps_0 = 348;
        int lps_1 = 282;
        int lrh_0 = 751;
        int lrh_1 = 614;
        int loaderCarrierRelayStatus = 379;
        int loaderChainPresenceSensor = 469;
        int loaderCloseSensor1 = 321;
        int loaderCloseSensor2 = 240;
        int loaderCloseSensor3 = 523;
        int loaderCloseSensor4 = 843;
        int loaderConnectedSensor = 421;
        int loaderConnectedSensorC = 331;
        int loaderDefaultStatus = 381;
        int loaderEngagedPositionSensor0 = 199;
        int loaderEngagedPositionSensor1 = 565;
        int loaderFilterDistanceSensor = 787;
        int loaderFilterGoodPositionStatus = 255;
        int loaderFilterPresenceSensor0 = 865;
        int loaderFilterPresenceSensor1 = 683;
        int loaderHandoffPositionSensor0 = 639;
        int loaderHandoffPositionSensor1 = 153;
        int loaderHoldingFilterSensor0 = 12;
        int loaderHoldingFilterSensor1 = 491;
        int loaderHooksRelayStatus = 856;
        int loaderOnCameraSensor0 = 315;
        int loaderOnCameraSensor1 = 181;
        int loaderOpenSensor1 = 717;
        int loaderOpenSensor2 = 556;
        int loaderOpenSensor3 = 194;
        int loaderOpenSensor4 = 50;
        int loaderStoragePositionSensor0 = 570;
        int loaderStoragePositionSensor1 = 175;
        int loader_LFD = 857;
        int loader_LFS = 501;
        int lockOut = 472;
        int lockOutShunt = 488;
        int lockout_C = 76;
        int lpmLatchesStatus = 916;
        int lpmLinearRail1Status = 152;
        int lpmLinearRail2Status = 395;
        int lpmOnlineClampsStatus = 368;
        int out_AF0 = 695;
        int out_AF0_C = 21;
        int out_AF1 = 920;
        int out_AF1_C = 678;
        int out_AF3 = 525;
        int out_AF3_C = 791;
        int out_AIN = 639;
        int out_AOL = 47;
        int out_AP1 = 98;
        int out_AP1_C = 781;
        int out_AP2 = 365;
        int out_AP2_C = 545;
        int out_AP3 = 921;
        int out_AP3_C = 321;
        int onlineClampXminusCloseSensor = 464;
        int onlineClampXminusCloseSensorC = 536;
        int onlineClampXminusOpenSensor = 794;
        int onlineClampXminusOpenSensorC = 870;
        int onlineClampXplusCloseSensor = 228;
        int onlineClampXplusCloseSensorC = 392;
        int onlineClampXplusOpenSensor = 945;
        int onlineClampXplusOpenSensorC = 508;
        int onlineClampYminusCloseSensor = 271;
        int onlineClampYminusCloseSensorC = 342;
        int onlineClampYminusOpenSensor = 515;
        int onlineClampYminusOpenSensorC = 732;
        int onlinePositionSensorBXminus = 207;
        int onlinePositionSensorBXplus = 334;
        int onlinePositionSensorXminus = 285;
        int onlinePositionSensorXplus = 599;
        int openSensorBLatchXminus = 454;
        int openSensorBLatchXplus = 670;
        int openSensorLatchXminus = 931;
        int openSensorLatchXplus = 832;
        int overClampedStatusSensor = 855;
        int presenceLoader = 106;
        int presenceloader_C = 169;
        int standbyPositionSensorBXminus = 466;
        int standbyPositionSensorBXplus = 192;
        int standbyPositionSensorXminus = 105;
        int standbyPositionSensorXplus = 705;
        int unclampedStatusSensor = 204;
        int underClampedStatusSensor = 43;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry(acAF0b, acAF0s, acAF1b, acAF1s, acAF3b, acAF3s, acAP2b, acAP2s, carouselHoldingFilterSensor0, carouselHoldingFilterSensor1, carouselStoppedAtStandby, carouselStoppedAtStandbyC, carousel_CF0, carousel_CF0_C, carousel_CF1, carousel_CF1_C, clampedStatusSensor, closeSensorBLatchXminus, closeSensorBLatchXplus, closeSensorLatchXminus, closeSensorLatchXplus, engineeringKey, engineeringkey_C, filterEngagedSensorBLatchXminus, filterEngagedSensorBLatchXplus, filterEngagedSensorLatchXminus, filterEngagedSensorLatchXplus, filterIDSensor0, filterIDSensor1, filterIDSensor2, filterIDSensor3, filterIDSensor4, filterIDSensor5, forceSensor0, forceSensor1, handoffPositionSensorBXminus, handoffPositionSensorBXplus, handoffPositionSensorXminus, handoffPositionSensorXplus, inclinometerXminus, inclinometerXplus, keyEng, keyEngb, keyLock, keyLockb, lps_0, lps_1, lrh_0, lrh_1, loaderCarrierRelayStatus, loaderChainPresenceSensor, loaderCloseSensor1, loaderCloseSensor2, loaderCloseSensor3, loaderCloseSensor4, loaderConnectedSensor, loaderConnectedSensorC, loaderDefaultStatus, loaderEngagedPositionSensor0, loaderEngagedPositionSensor1, loaderFilterDistanceSensor, loaderFilterGoodPositionStatus, loaderFilterPresenceSensor0, loaderFilterPresenceSensor1, loaderHandoffPositionSensor0, loaderHandoffPositionSensor1, loaderHoldingFilterSensor0, loaderHoldingFilterSensor1, loaderHooksRelayStatus, loaderOnCameraSensor0, loaderOnCameraSensor1, loaderOpenSensor1, loaderOpenSensor2, loaderOpenSensor3, loaderOpenSensor4, loaderStoragePositionSensor0, loaderStoragePositionSensor1, loader_LFD, loader_LFS, lockOut, lockOutShunt, lockout_C, lpmLatchesStatus, lpmLinearRail1Status, lpmLinearRail2Status, lpmOnlineClampsStatus, out_AF0, out_AF0_C, out_AF1, out_AF1_C, out_AF3, out_AF3_C, out_AIN, out_AOL, out_AP1, out_AP1_C, out_AP2, out_AP2_C, out_AP3, out_AP3_C, onlineClampXminusCloseSensor, onlineClampXminusCloseSensorC, onlineClampXminusOpenSensor, onlineClampXminusOpenSensorC, onlineClampXplusCloseSensor, onlineClampXplusCloseSensorC, onlineClampXplusOpenSensor, onlineClampXplusOpenSensorC, onlineClampYminusCloseSensor, onlineClampYminusCloseSensorC, onlineClampYminusOpenSensor, onlineClampYminusOpenSensorC, onlinePositionSensorBXminus, onlinePositionSensorBXplus, onlinePositionSensorXminus, onlinePositionSensorXplus, openSensorBLatchXminus, openSensorBLatchXplus, openSensorLatchXminus, openSensorLatchXplus, overClampedStatusSensor, presenceLoader, presenceloader_C, standbyPositionSensorBXminus, standbyPositionSensorBXplus, standbyPositionSensorXminus, standbyPositionSensorXplus, unclampedStatusSensor, underClampedStatusSensor));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry));
        Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry item_ = (Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)acAF0b, (long)item_.getAcAF0b());
        Assert.assertEquals((long)acAF0s, (long)item_.getAcAF0s());
        Assert.assertEquals((long)acAF1b, (long)item_.getAcAF1b());
        Assert.assertEquals((long)acAF1s, (long)item_.getAcAF1s());
        Assert.assertEquals((long)acAF3b, (long)item_.getAcAF3b());
        Assert.assertEquals((long)acAF3s, (long)item_.getAcAF3s());
        Assert.assertEquals((long)acAP2b, (long)item_.getAcAP2b());
        Assert.assertEquals((long)acAP2s, (long)item_.getAcAP2s());
        Assert.assertEquals((long)carouselHoldingFilterSensor0, (long)item_.getCarouselHoldingFilterSensor0());
        Assert.assertEquals((long)carouselHoldingFilterSensor1, (long)item_.getCarouselHoldingFilterSensor1());
        Assert.assertEquals((long)carouselStoppedAtStandby, (long)item_.getCarouselStoppedAtStandby());
        Assert.assertEquals((long)carouselStoppedAtStandbyC, (long)item_.getCarouselStoppedAtStandbyC());
        Assert.assertEquals((long)carousel_CF0, (long)item_.getCarousel_CF0());
        Assert.assertEquals((long)carousel_CF0_C, (long)item_.getCarousel_CF0_C());
        Assert.assertEquals((long)carousel_CF1, (long)item_.getCarousel_CF1());
        Assert.assertEquals((long)carousel_CF1_C, (long)item_.getCarousel_CF1_C());
        Assert.assertEquals((long)clampedStatusSensor, (long)item_.getClampedStatusSensor());
        Assert.assertEquals((long)closeSensorBLatchXminus, (long)item_.getCloseSensorBLatchXminus());
        Assert.assertEquals((long)closeSensorBLatchXplus, (long)item_.getCloseSensorBLatchXplus());
        Assert.assertEquals((long)closeSensorLatchXminus, (long)item_.getCloseSensorLatchXminus());
        Assert.assertEquals((long)closeSensorLatchXplus, (long)item_.getCloseSensorLatchXplus());
        Assert.assertEquals((long)engineeringKey, (long)item_.getEngineeringKey());
        Assert.assertEquals((long)engineeringkey_C, (long)item_.getEngineeringkey_C());
        Assert.assertEquals((long)filterEngagedSensorBLatchXminus, (long)item_.getFilterEngagedSensorBLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorBLatchXplus, (long)item_.getFilterEngagedSensorBLatchXplus());
        Assert.assertEquals((long)filterEngagedSensorLatchXminus, (long)item_.getFilterEngagedSensorLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorLatchXplus, (long)item_.getFilterEngagedSensorLatchXplus());
        Assert.assertEquals((long)filterIDSensor0, (long)item_.getFilterIDSensor0());
        Assert.assertEquals((long)filterIDSensor1, (long)item_.getFilterIDSensor1());
        Assert.assertEquals((long)filterIDSensor2, (long)item_.getFilterIDSensor2());
        Assert.assertEquals((long)filterIDSensor3, (long)item_.getFilterIDSensor3());
        Assert.assertEquals((long)filterIDSensor4, (long)item_.getFilterIDSensor4());
        Assert.assertEquals((long)filterIDSensor5, (long)item_.getFilterIDSensor5());
        Assert.assertEquals((long)forceSensor0, (long)item_.getForceSensor0());
        Assert.assertEquals((long)forceSensor1, (long)item_.getForceSensor1());
        Assert.assertEquals((long)handoffPositionSensorBXminus, (long)item_.getHandoffPositionSensorBXminus());
        Assert.assertEquals((long)handoffPositionSensorBXplus, (long)item_.getHandoffPositionSensorBXplus());
        Assert.assertEquals((long)handoffPositionSensorXminus, (long)item_.getHandoffPositionSensorXminus());
        Assert.assertEquals((long)handoffPositionSensorXplus, (long)item_.getHandoffPositionSensorXplus());
        Assert.assertEquals((double)inclinometerXminus, (double)item_.getInclinometerXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinometerXplus, (double)item_.getInclinometerXplus(), (double)1.0E-6f);
        Assert.assertEquals((long)keyEng, (long)item_.getKeyEng());
        Assert.assertEquals((long)keyEngb, (long)item_.getKeyEngb());
        Assert.assertEquals((long)keyLock, (long)item_.getKeyLock());
        Assert.assertEquals((long)keyLockb, (long)item_.getKeyLockb());
        Assert.assertEquals((long)lps_0, (long)item_.getLps_0());
        Assert.assertEquals((long)lps_1, (long)item_.getLps_1());
        Assert.assertEquals((long)lrh_0, (long)item_.getLrh_0());
        Assert.assertEquals((long)lrh_1, (long)item_.getLrh_1());
        Assert.assertEquals((long)loaderCarrierRelayStatus, (long)item_.getLoaderCarrierRelayStatus());
        Assert.assertEquals((long)loaderChainPresenceSensor, (long)item_.getLoaderChainPresenceSensor());
        Assert.assertEquals((long)loaderCloseSensor1, (long)item_.getLoaderCloseSensor1());
        Assert.assertEquals((long)loaderCloseSensor2, (long)item_.getLoaderCloseSensor2());
        Assert.assertEquals((long)loaderCloseSensor3, (long)item_.getLoaderCloseSensor3());
        Assert.assertEquals((long)loaderCloseSensor4, (long)item_.getLoaderCloseSensor4());
        Assert.assertEquals((long)loaderConnectedSensor, (long)item_.getLoaderConnectedSensor());
        Assert.assertEquals((long)loaderConnectedSensorC, (long)item_.getLoaderConnectedSensorC());
        Assert.assertEquals((long)loaderDefaultStatus, (long)item_.getLoaderDefaultStatus());
        Assert.assertEquals((long)loaderEngagedPositionSensor0, (long)item_.getLoaderEngagedPositionSensor0());
        Assert.assertEquals((long)loaderEngagedPositionSensor1, (long)item_.getLoaderEngagedPositionSensor1());
        Assert.assertEquals((long)loaderFilterDistanceSensor, (long)item_.getLoaderFilterDistanceSensor());
        Assert.assertEquals((long)loaderFilterGoodPositionStatus, (long)item_.getLoaderFilterGoodPositionStatus());
        Assert.assertEquals((long)loaderFilterPresenceSensor0, (long)item_.getLoaderFilterPresenceSensor0());
        Assert.assertEquals((long)loaderFilterPresenceSensor1, (long)item_.getLoaderFilterPresenceSensor1());
        Assert.assertEquals((long)loaderHandoffPositionSensor0, (long)item_.getLoaderHandoffPositionSensor0());
        Assert.assertEquals((long)loaderHandoffPositionSensor1, (long)item_.getLoaderHandoffPositionSensor1());
        Assert.assertEquals((long)loaderHoldingFilterSensor0, (long)item_.getLoaderHoldingFilterSensor0());
        Assert.assertEquals((long)loaderHoldingFilterSensor1, (long)item_.getLoaderHoldingFilterSensor1());
        Assert.assertEquals((long)loaderHooksRelayStatus, (long)item_.getLoaderHooksRelayStatus());
        Assert.assertEquals((long)loaderOnCameraSensor0, (long)item_.getLoaderOnCameraSensor0());
        Assert.assertEquals((long)loaderOnCameraSensor1, (long)item_.getLoaderOnCameraSensor1());
        Assert.assertEquals((long)loaderOpenSensor1, (long)item_.getLoaderOpenSensor1());
        Assert.assertEquals((long)loaderOpenSensor2, (long)item_.getLoaderOpenSensor2());
        Assert.assertEquals((long)loaderOpenSensor3, (long)item_.getLoaderOpenSensor3());
        Assert.assertEquals((long)loaderOpenSensor4, (long)item_.getLoaderOpenSensor4());
        Assert.assertEquals((long)loaderStoragePositionSensor0, (long)item_.getLoaderStoragePositionSensor0());
        Assert.assertEquals((long)loaderStoragePositionSensor1, (long)item_.getLoaderStoragePositionSensor1());
        Assert.assertEquals((long)loader_LFD, (long)item_.getLoader_LFD());
        Assert.assertEquals((long)loader_LFS, (long)item_.getLoader_LFS());
        Assert.assertEquals((long)lockOut, (long)item_.getLockOut());
        Assert.assertEquals((long)lockOutShunt, (long)item_.getLockOutShunt());
        Assert.assertEquals((long)lockout_C, (long)item_.getLockout_C());
        Assert.assertEquals((long)lpmLatchesStatus, (long)item_.getLpmLatchesStatus());
        Assert.assertEquals((long)lpmLinearRail1Status, (long)item_.getLpmLinearRail1Status());
        Assert.assertEquals((long)lpmLinearRail2Status, (long)item_.getLpmLinearRail2Status());
        Assert.assertEquals((long)lpmOnlineClampsStatus, (long)item_.getLpmOnlineClampsStatus());
        Assert.assertEquals((long)out_AF0, (long)item_.getOut_AF0());
        Assert.assertEquals((long)out_AF0_C, (long)item_.getOut_AF0_C());
        Assert.assertEquals((long)out_AF1, (long)item_.getOut_AF1());
        Assert.assertEquals((long)out_AF1_C, (long)item_.getOut_AF1_C());
        Assert.assertEquals((long)out_AF3, (long)item_.getOut_AF3());
        Assert.assertEquals((long)out_AF3_C, (long)item_.getOut_AF3_C());
        Assert.assertEquals((long)out_AIN, (long)item_.getOut_AIN());
        Assert.assertEquals((long)out_AOL, (long)item_.getOut_AOL());
        Assert.assertEquals((long)out_AP1, (long)item_.getOut_AP1());
        Assert.assertEquals((long)out_AP1_C, (long)item_.getOut_AP1_C());
        Assert.assertEquals((long)out_AP2, (long)item_.getOut_AP2());
        Assert.assertEquals((long)out_AP2_C, (long)item_.getOut_AP2_C());
        Assert.assertEquals((long)out_AP3, (long)item_.getOut_AP3());
        Assert.assertEquals((long)out_AP3_C, (long)item_.getOut_AP3_C());
        Assert.assertEquals((long)onlineClampXminusCloseSensor, (long)item_.getOnlineClampXminusCloseSensor());
        Assert.assertEquals((long)onlineClampXminusCloseSensorC, (long)item_.getOnlineClampXminusCloseSensorC());
        Assert.assertEquals((long)onlineClampXminusOpenSensor, (long)item_.getOnlineClampXminusOpenSensor());
        Assert.assertEquals((long)onlineClampXminusOpenSensorC, (long)item_.getOnlineClampXminusOpenSensorC());
        Assert.assertEquals((long)onlineClampXplusCloseSensor, (long)item_.getOnlineClampXplusCloseSensor());
        Assert.assertEquals((long)onlineClampXplusCloseSensorC, (long)item_.getOnlineClampXplusCloseSensorC());
        Assert.assertEquals((long)onlineClampXplusOpenSensor, (long)item_.getOnlineClampXplusOpenSensor());
        Assert.assertEquals((long)onlineClampXplusOpenSensorC, (long)item_.getOnlineClampXplusOpenSensorC());
        Assert.assertEquals((long)onlineClampYminusCloseSensor, (long)item_.getOnlineClampYminusCloseSensor());
        Assert.assertEquals((long)onlineClampYminusCloseSensorC, (long)item_.getOnlineClampYminusCloseSensorC());
        Assert.assertEquals((long)onlineClampYminusOpenSensor, (long)item_.getOnlineClampYminusOpenSensor());
        Assert.assertEquals((long)onlineClampYminusOpenSensorC, (long)item_.getOnlineClampYminusOpenSensorC());
        Assert.assertEquals((long)onlinePositionSensorBXminus, (long)item_.getOnlinePositionSensorBXminus());
        Assert.assertEquals((long)onlinePositionSensorBXplus, (long)item_.getOnlinePositionSensorBXplus());
        Assert.assertEquals((long)onlinePositionSensorXminus, (long)item_.getOnlinePositionSensorXminus());
        Assert.assertEquals((long)onlinePositionSensorXplus, (long)item_.getOnlinePositionSensorXplus());
        Assert.assertEquals((long)openSensorBLatchXminus, (long)item_.getOpenSensorBLatchXminus());
        Assert.assertEquals((long)openSensorBLatchXplus, (long)item_.getOpenSensorBLatchXplus());
        Assert.assertEquals((long)openSensorLatchXminus, (long)item_.getOpenSensorLatchXminus());
        Assert.assertEquals((long)openSensorLatchXplus, (long)item_.getOpenSensorLatchXplus());
        Assert.assertEquals((long)overClampedStatusSensor, (long)item_.getOverClampedStatusSensor());
        Assert.assertEquals((long)presenceLoader, (long)item_.getPresenceLoader());
        Assert.assertEquals((long)presenceloader_C, (long)item_.getPresenceloader_C());
        Assert.assertEquals((long)standbyPositionSensorBXminus, (long)item_.getStandbyPositionSensorBXminus());
        Assert.assertEquals((long)standbyPositionSensorBXplus, (long)item_.getStandbyPositionSensorBXplus());
        Assert.assertEquals((long)standbyPositionSensorXminus, (long)item_.getStandbyPositionSensorXminus());
        Assert.assertEquals((long)standbyPositionSensorXplus, (long)item_.getStandbyPositionSensorXplus());
        Assert.assertEquals((long)unclampedStatusSensor, (long)item_.getUnclampedStatusSensor());
        Assert.assertEquals((long)underClampedStatusSensor, (long)item_.getUnderClampedStatusSensor());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket1_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        String clampxminus1_clampState = "";
        int clampxminus1_filterPositionSensorValue = 826;
        int clampxminus1_filterPresenceOffset2 = 691;
        String clampxminus1_filterPresenceStatus = "e";
        int clampxminus1_lockSensorOffset1 = 677;
        int clampxminus1_lockSensorValue = 264;
        String clampxminus1_lockStatus = "";
        String clampxplus1_clampState = "g";
        int clampxplus1_filterPositionSensorValue = 222;
        int clampxplus1_filterPresenceOffset2 = 398;
        String clampxplus1_filterPresenceStatus = "r";
        int clampxplus1_lockSensorOffset1 = 544;
        int clampxplus1_lockSensorValue = 500;
        String clampxplus1_lockStatus = "t";
        String clampsState = "n";
        boolean empty = true;
        String filterName = "w";
        String ioStatus = "";
        int socketID = 376;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket1_TrendingTelemetry(atStandby, clampxminus1_clampState, clampxminus1_filterPositionSensorValue, clampxminus1_filterPresenceOffset2, clampxminus1_filterPresenceStatus, clampxminus1_lockSensorOffset1, clampxminus1_lockSensorValue, clampxminus1_lockStatus, clampxplus1_clampState, clampxplus1_filterPositionSensorValue, clampxplus1_filterPresenceOffset2, clampxplus1_filterPresenceStatus, clampxplus1_lockSensorOffset1, clampxplus1_lockSensorValue, clampxplus1_lockStatus, clampsState, empty, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket1_TrendingTelemetry));
        Fcs_Carousel_Socket1_TrendingTelemetry item_ = (Fcs_Carousel_Socket1_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus1_clampState, (Object)item_.getClampxminus1_clampState());
        Assert.assertEquals((long)clampxminus1_filterPositionSensorValue, (long)item_.getClampxminus1_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus1_filterPresenceOffset2, (long)item_.getClampxminus1_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus1_filterPresenceStatus, (Object)item_.getClampxminus1_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus1_lockSensorOffset1, (long)item_.getClampxminus1_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus1_lockSensorValue, (long)item_.getClampxminus1_lockSensorValue());
        Assert.assertEquals((Object)clampxminus1_lockStatus, (Object)item_.getClampxminus1_lockStatus());
        Assert.assertEquals((Object)clampxplus1_clampState, (Object)item_.getClampxplus1_clampState());
        Assert.assertEquals((long)clampxplus1_filterPositionSensorValue, (long)item_.getClampxplus1_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus1_filterPresenceOffset2, (long)item_.getClampxplus1_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus1_filterPresenceStatus, (Object)item_.getClampxplus1_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus1_lockSensorOffset1, (long)item_.getClampxplus1_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus1_lockSensorValue, (long)item_.getClampxplus1_lockSensorValue());
        Assert.assertEquals((Object)clampxplus1_lockStatus, (Object)item_.getClampxplus1_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket2_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        String clampxminus2_clampState = "";
        int clampxminus2_filterPositionSensorValue = 641;
        int clampxminus2_filterPresenceOffset2 = 402;
        String clampxminus2_filterPresenceStatus = "r";
        int clampxminus2_lockSensorOffset1 = 551;
        int clampxminus2_lockSensorValue = 267;
        String clampxminus2_lockStatus = "n";
        String clampxplus2_clampState = "";
        int clampxplus2_filterPositionSensorValue = 568;
        int clampxplus2_filterPresenceOffset2 = 646;
        String clampxplus2_filterPresenceStatus = "";
        int clampxplus2_lockSensorOffset1 = 906;
        int clampxplus2_lockSensorValue = 948;
        String clampxplus2_lockStatus = "l";
        String clampsState = "p";
        boolean empty = false;
        String filterName = "q";
        String ioStatus = "";
        int socketID = 148;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket2_TrendingTelemetry(atStandby, clampxminus2_clampState, clampxminus2_filterPositionSensorValue, clampxminus2_filterPresenceOffset2, clampxminus2_filterPresenceStatus, clampxminus2_lockSensorOffset1, clampxminus2_lockSensorValue, clampxminus2_lockStatus, clampxplus2_clampState, clampxplus2_filterPositionSensorValue, clampxplus2_filterPresenceOffset2, clampxplus2_filterPresenceStatus, clampxplus2_lockSensorOffset1, clampxplus2_lockSensorValue, clampxplus2_lockStatus, clampsState, empty, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket2_TrendingTelemetry));
        Fcs_Carousel_Socket2_TrendingTelemetry item_ = (Fcs_Carousel_Socket2_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus2_clampState, (Object)item_.getClampxminus2_clampState());
        Assert.assertEquals((long)clampxminus2_filterPositionSensorValue, (long)item_.getClampxminus2_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus2_filterPresenceOffset2, (long)item_.getClampxminus2_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus2_filterPresenceStatus, (Object)item_.getClampxminus2_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus2_lockSensorOffset1, (long)item_.getClampxminus2_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus2_lockSensorValue, (long)item_.getClampxminus2_lockSensorValue());
        Assert.assertEquals((Object)clampxminus2_lockStatus, (Object)item_.getClampxminus2_lockStatus());
        Assert.assertEquals((Object)clampxplus2_clampState, (Object)item_.getClampxplus2_clampState());
        Assert.assertEquals((long)clampxplus2_filterPositionSensorValue, (long)item_.getClampxplus2_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus2_filterPresenceOffset2, (long)item_.getClampxplus2_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus2_filterPresenceStatus, (Object)item_.getClampxplus2_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus2_lockSensorOffset1, (long)item_.getClampxplus2_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus2_lockSensorValue, (long)item_.getClampxplus2_lockSensorValue());
        Assert.assertEquals((Object)clampxplus2_lockStatus, (Object)item_.getClampxplus2_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket3_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        String clampxminus3_clampState = "";
        int clampxminus3_filterPositionSensorValue = 236;
        int clampxminus3_filterPresenceOffset2 = 156;
        String clampxminus3_filterPresenceStatus = "";
        int clampxminus3_lockSensorOffset1 = 493;
        int clampxminus3_lockSensorValue = 271;
        String clampxminus3_lockStatus = "";
        String clampxplus3_clampState = "p";
        int clampxplus3_filterPositionSensorValue = 544;
        int clampxplus3_filterPresenceOffset2 = 859;
        String clampxplus3_filterPresenceStatus = "";
        int clampxplus3_lockSensorOffset1 = 371;
        int clampxplus3_lockSensorValue = 472;
        String clampxplus3_lockStatus = "";
        String clampsState = "";
        boolean empty = true;
        String filterName = "";
        String ioStatus = "";
        int socketID = 93;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket3_TrendingTelemetry(atStandby, clampxminus3_clampState, clampxminus3_filterPositionSensorValue, clampxminus3_filterPresenceOffset2, clampxminus3_filterPresenceStatus, clampxminus3_lockSensorOffset1, clampxminus3_lockSensorValue, clampxminus3_lockStatus, clampxplus3_clampState, clampxplus3_filterPositionSensorValue, clampxplus3_filterPresenceOffset2, clampxplus3_filterPresenceStatus, clampxplus3_lockSensorOffset1, clampxplus3_lockSensorValue, clampxplus3_lockStatus, clampsState, empty, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket3_TrendingTelemetry));
        Fcs_Carousel_Socket3_TrendingTelemetry item_ = (Fcs_Carousel_Socket3_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus3_clampState, (Object)item_.getClampxminus3_clampState());
        Assert.assertEquals((long)clampxminus3_filterPositionSensorValue, (long)item_.getClampxminus3_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus3_filterPresenceOffset2, (long)item_.getClampxminus3_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus3_filterPresenceStatus, (Object)item_.getClampxminus3_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus3_lockSensorOffset1, (long)item_.getClampxminus3_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus3_lockSensorValue, (long)item_.getClampxminus3_lockSensorValue());
        Assert.assertEquals((Object)clampxminus3_lockStatus, (Object)item_.getClampxminus3_lockStatus());
        Assert.assertEquals((Object)clampxplus3_clampState, (Object)item_.getClampxplus3_clampState());
        Assert.assertEquals((long)clampxplus3_filterPositionSensorValue, (long)item_.getClampxplus3_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus3_filterPresenceOffset2, (long)item_.getClampxplus3_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus3_filterPresenceStatus, (Object)item_.getClampxplus3_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus3_lockSensorOffset1, (long)item_.getClampxplus3_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus3_lockSensorValue, (long)item_.getClampxplus3_lockSensorValue());
        Assert.assertEquals((Object)clampxplus3_lockStatus, (Object)item_.getClampxplus3_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket4_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        String clampxminus4_clampState = "o";
        int clampxminus4_filterPositionSensorValue = 554;
        int clampxminus4_filterPresenceOffset2 = 843;
        String clampxminus4_filterPresenceStatus = "e";
        int clampxminus4_lockSensorOffset1 = 424;
        int clampxminus4_lockSensorValue = 765;
        String clampxminus4_lockStatus = "";
        String clampxplus4_clampState = "";
        int clampxplus4_filterPositionSensorValue = 103;
        int clampxplus4_filterPresenceOffset2 = 927;
        String clampxplus4_filterPresenceStatus = "a";
        int clampxplus4_lockSensorOffset1 = 68;
        int clampxplus4_lockSensorValue = 485;
        String clampxplus4_lockStatus = "x";
        String clampsState = "n";
        boolean empty = false;
        String filterName = "";
        String ioStatus = "";
        int socketID = 678;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket4_TrendingTelemetry(atStandby, clampxminus4_clampState, clampxminus4_filterPositionSensorValue, clampxminus4_filterPresenceOffset2, clampxminus4_filterPresenceStatus, clampxminus4_lockSensorOffset1, clampxminus4_lockSensorValue, clampxminus4_lockStatus, clampxplus4_clampState, clampxplus4_filterPositionSensorValue, clampxplus4_filterPresenceOffset2, clampxplus4_filterPresenceStatus, clampxplus4_lockSensorOffset1, clampxplus4_lockSensorValue, clampxplus4_lockStatus, clampsState, empty, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket4_TrendingTelemetry));
        Fcs_Carousel_Socket4_TrendingTelemetry item_ = (Fcs_Carousel_Socket4_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus4_clampState, (Object)item_.getClampxminus4_clampState());
        Assert.assertEquals((long)clampxminus4_filterPositionSensorValue, (long)item_.getClampxminus4_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus4_filterPresenceOffset2, (long)item_.getClampxminus4_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus4_filterPresenceStatus, (Object)item_.getClampxminus4_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus4_lockSensorOffset1, (long)item_.getClampxminus4_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus4_lockSensorValue, (long)item_.getClampxminus4_lockSensorValue());
        Assert.assertEquals((Object)clampxminus4_lockStatus, (Object)item_.getClampxminus4_lockStatus());
        Assert.assertEquals((Object)clampxplus4_clampState, (Object)item_.getClampxplus4_clampState());
        Assert.assertEquals((long)clampxplus4_filterPositionSensorValue, (long)item_.getClampxplus4_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus4_filterPresenceOffset2, (long)item_.getClampxplus4_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus4_filterPresenceStatus, (Object)item_.getClampxplus4_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus4_lockSensorOffset1, (long)item_.getClampxplus4_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus4_lockSensorValue, (long)item_.getClampxplus4_lockSensorValue());
        Assert.assertEquals((Object)clampxplus4_lockStatus, (Object)item_.getClampxplus4_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket5_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        String clampxminus5_clampState = "";
        int clampxminus5_filterPositionSensorValue = 679;
        int clampxminus5_filterPresenceOffset2 = 771;
        String clampxminus5_filterPresenceStatus = "";
        int clampxminus5_lockSensorOffset1 = 48;
        int clampxminus5_lockSensorValue = 719;
        String clampxminus5_lockStatus = "";
        String clampxplus5_clampState = "a";
        int clampxplus5_filterPositionSensorValue = 551;
        int clampxplus5_filterPresenceOffset2 = 704;
        String clampxplus5_filterPresenceStatus = "";
        int clampxplus5_lockSensorOffset1 = 437;
        int clampxplus5_lockSensorValue = 358;
        String clampxplus5_lockStatus = "z";
        String clampsState = "l";
        boolean empty = true;
        String filterName = "n";
        String ioStatus = "";
        int socketID = 974;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket5_TrendingTelemetry(atStandby, clampxminus5_clampState, clampxminus5_filterPositionSensorValue, clampxminus5_filterPresenceOffset2, clampxminus5_filterPresenceStatus, clampxminus5_lockSensorOffset1, clampxminus5_lockSensorValue, clampxminus5_lockStatus, clampxplus5_clampState, clampxplus5_filterPositionSensorValue, clampxplus5_filterPresenceOffset2, clampxplus5_filterPresenceStatus, clampxplus5_lockSensorOffset1, clampxplus5_lockSensorValue, clampxplus5_lockStatus, clampsState, empty, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket5_TrendingTelemetry));
        Fcs_Carousel_Socket5_TrendingTelemetry item_ = (Fcs_Carousel_Socket5_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus5_clampState, (Object)item_.getClampxminus5_clampState());
        Assert.assertEquals((long)clampxminus5_filterPositionSensorValue, (long)item_.getClampxminus5_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus5_filterPresenceOffset2, (long)item_.getClampxminus5_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus5_filterPresenceStatus, (Object)item_.getClampxminus5_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus5_lockSensorOffset1, (long)item_.getClampxminus5_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus5_lockSensorValue, (long)item_.getClampxminus5_lockSensorValue());
        Assert.assertEquals((Object)clampxminus5_lockStatus, (Object)item_.getClampxminus5_lockStatus());
        Assert.assertEquals((Object)clampxplus5_clampState, (Object)item_.getClampxplus5_clampState());
        Assert.assertEquals((long)clampxplus5_filterPositionSensorValue, (long)item_.getClampxplus5_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus5_filterPresenceOffset2, (long)item_.getClampxplus5_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus5_filterPresenceStatus, (Object)item_.getClampxplus5_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus5_lockSensorOffset1, (long)item_.getClampxplus5_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus5_lockSensorValue, (long)item_.getClampxplus5_lockSensorValue());
        Assert.assertEquals((Object)clampxplus5_lockStatus, (Object)item_.getClampxplus5_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        String clampsStateAtStandby = "";
        int deltaPositionAtStandby = 311;
        boolean emptyAtStandby = true;
        int estimatedPosition = 484;
        int filterAtStandbyId = 38;
        String filterOnAutochangerName = "";
        long minLocked = 27L;
        int socketAtStandbyID = 630;
        String socketAtStandbyName = "i";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_TrendingTelemetry(atStandby, clampsStateAtStandby, deltaPositionAtStandby, emptyAtStandby, estimatedPosition, filterAtStandbyId, filterOnAutochangerName, minLocked, socketAtStandbyID, socketAtStandbyName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_TrendingTelemetry));
        Fcs_Carousel_TrendingTelemetry item_ = (Fcs_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampsStateAtStandby, (Object)item_.getClampsStateAtStandby());
        Assert.assertEquals((long)deltaPositionAtStandby, (long)item_.getDeltaPositionAtStandby());
        Assert.assertEquals((Object)emptyAtStandby, (Object)item_.isEmptyAtStandby());
        Assert.assertEquals((long)estimatedPosition, (long)item_.getEstimatedPosition());
        Assert.assertEquals((long)filterAtStandbyId, (long)item_.getFilterAtStandbyId());
        Assert.assertEquals((Object)filterOnAutochangerName, (Object)item_.getFilterOnAutochangerName());
        Assert.assertEquals((long)minLocked, (long)item_.getMinLocked());
        Assert.assertEquals((long)socketAtStandbyID, (long)item_.getSocketAtStandbyID());
        Assert.assertEquals((Object)socketAtStandbyName, (Object)item_.getSocketAtStandbyName());
    }

    @Test
    public void sendReceiveFcs_Duration_Autochanger_TrendingTelemetry() throws Exception {
        long autochangertrucks_ALIGN_FOLLOWER = 847L;
        long autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE = 440L;
        long autochangertrucks_MOVE_TO_ABSOLUTE_POSITION = 512L;
        long latches_latchXminus_CLOSE = 574L;
        long latches_latchXminus_OPEN = 611L;
        long latches_latchXplus_CLOSE = 934L;
        long latches_latchXplus_OPEN = 514L;
        long onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 674L;
        long onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 513L;
        long onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP = 232L;
        long onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT = 693L;
        long onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 414L;
        long onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 633L;
        long onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP = 577L;
        long onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT = 185L;
        long onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 595L;
        long onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP = 496L;
        long onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT = 520L;
        long onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 838L;
        long onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT = 782L;
        long onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP = 629L;
        long onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 731L;
        long onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 243L;
        long onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP = 990L;
        long onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT = 150L;
        long onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 650L;
        long onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 323L;
        long onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP = 263L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Autochanger_TrendingTelemetry(autochangertrucks_ALIGN_FOLLOWER, autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, latches_latchXminus_CLOSE, latches_latchXminus_OPEN, latches_latchXplus_CLOSE, latches_latchXplus_OPEN, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Autochanger_TrendingTelemetry));
        Fcs_Duration_Autochanger_TrendingTelemetry item_ = (Fcs_Duration_Autochanger_TrendingTelemetry)item;
        Assert.assertEquals((long)autochangertrucks_ALIGN_FOLLOWER, (long)item_.getAutochangertrucks_ALIGN_FOLLOWER());
        Assert.assertEquals((long)autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, (long)item_.getAutochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE());
        Assert.assertEquals((long)autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, (long)item_.getAutochangertrucks_MOVE_TO_ABSOLUTE_POSITION());
        Assert.assertEquals((long)latches_latchXminus_CLOSE, (long)item_.getLatches_latchXminus_CLOSE());
        Assert.assertEquals((long)latches_latchXminus_OPEN, (long)item_.getLatches_latchXminus_OPEN());
        Assert.assertEquals((long)latches_latchXplus_CLOSE, (long)item_.getLatches_latchXplus_CLOSE());
        Assert.assertEquals((long)latches_latchXplus_OPEN, (long)item_.getLatches_latchXplus_OPEN());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXminus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXplus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampYminus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP());
    }

    @Test
    public void sendReceiveFcs_Duration_Carousel_TrendingTelemetry() throws Exception {
        long rotate_CAROUSEL_TO_ABSOLUTE_POSITION = 559L;
        long rotate_CAROUSEL_TO_RELATIVE_POSITION = 503L;
        int socket1_RELEASE_CLAMPS = 593;
        int socket1_UNLOCK_CLAMPS = 163;
        long socket1_clampXminus1_RELEASE = 874L;
        long socket1_clampXminus1_UNLOCK = 960L;
        long socket1_clampXplus1_RELEASE = 291L;
        long socket1_clampXplus1_UNLOCK = 253L;
        int socket2_RELEASE_CLAMPS = 538;
        int socket2_UNLOCK_CLAMPS = 822;
        long socket2_clampXminus2_RELEASE = 737L;
        long socket2_clampXminus2_UNLOCK = 969L;
        long socket2_clampXplus2_RELEASE = 329L;
        long socket2_clampXplus2_UNLOCK = 374L;
        int socket3_RELEASE_CLAMPS = 241;
        int socket3_UNLOCK_CLAMPS = 19;
        long socket3_clampXminus3_RELEASE = 898L;
        long socket3_clampXminus3_UNLOCK = 394L;
        long socket3_clampXplus3_RELEASE = 323L;
        long socket3_clampXplus3_UNLOCK = 570L;
        int socket4_RELEASE_CLAMPS = 361;
        int socket4_UNLOCK_CLAMPS = 875;
        long socket4_clampXminus4_RELEASE = 567L;
        long socket4_clampXminus4_UNLOCK = 425L;
        long socket4_clampXplus4_RELEASE = 902L;
        long socket4_clampXplus4_UNLOCK = 388L;
        int socket5_RELEASE_CLAMPS = 791;
        int socket5_UNLOCK_CLAMPS = 346;
        long socket5_clampXminus5_RELEASE = 392L;
        long socket5_clampXminus5_UNLOCK = 630L;
        long socket5_clampXplus5_RELEASE = 838L;
        long socket5_clampXplus5_UNLOCK = 719L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Carousel_TrendingTelemetry(rotate_CAROUSEL_TO_ABSOLUTE_POSITION, rotate_CAROUSEL_TO_RELATIVE_POSITION, socket1_RELEASE_CLAMPS, socket1_UNLOCK_CLAMPS, socket1_clampXminus1_RELEASE, socket1_clampXminus1_UNLOCK, socket1_clampXplus1_RELEASE, socket1_clampXplus1_UNLOCK, socket2_RELEASE_CLAMPS, socket2_UNLOCK_CLAMPS, socket2_clampXminus2_RELEASE, socket2_clampXminus2_UNLOCK, socket2_clampXplus2_RELEASE, socket2_clampXplus2_UNLOCK, socket3_RELEASE_CLAMPS, socket3_UNLOCK_CLAMPS, socket3_clampXminus3_RELEASE, socket3_clampXminus3_UNLOCK, socket3_clampXplus3_RELEASE, socket3_clampXplus3_UNLOCK, socket4_RELEASE_CLAMPS, socket4_UNLOCK_CLAMPS, socket4_clampXminus4_RELEASE, socket4_clampXminus4_UNLOCK, socket4_clampXplus4_RELEASE, socket4_clampXplus4_UNLOCK, socket5_RELEASE_CLAMPS, socket5_UNLOCK_CLAMPS, socket5_clampXminus5_RELEASE, socket5_clampXminus5_UNLOCK, socket5_clampXplus5_RELEASE, socket5_clampXplus5_UNLOCK));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Carousel_TrendingTelemetry));
        Fcs_Duration_Carousel_TrendingTelemetry item_ = (Fcs_Duration_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((long)rotate_CAROUSEL_TO_ABSOLUTE_POSITION, (long)item_.getRotate_CAROUSEL_TO_ABSOLUTE_POSITION());
        Assert.assertEquals((long)rotate_CAROUSEL_TO_RELATIVE_POSITION, (long)item_.getRotate_CAROUSEL_TO_RELATIVE_POSITION());
        Assert.assertEquals((long)socket1_RELEASE_CLAMPS, (long)item_.getSocket1_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket1_UNLOCK_CLAMPS, (long)item_.getSocket1_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket1_clampXminus1_RELEASE, (long)item_.getSocket1_clampXminus1_RELEASE());
        Assert.assertEquals((long)socket1_clampXminus1_UNLOCK, (long)item_.getSocket1_clampXminus1_UNLOCK());
        Assert.assertEquals((long)socket1_clampXplus1_RELEASE, (long)item_.getSocket1_clampXplus1_RELEASE());
        Assert.assertEquals((long)socket1_clampXplus1_UNLOCK, (long)item_.getSocket1_clampXplus1_UNLOCK());
        Assert.assertEquals((long)socket2_RELEASE_CLAMPS, (long)item_.getSocket2_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket2_UNLOCK_CLAMPS, (long)item_.getSocket2_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket2_clampXminus2_RELEASE, (long)item_.getSocket2_clampXminus2_RELEASE());
        Assert.assertEquals((long)socket2_clampXminus2_UNLOCK, (long)item_.getSocket2_clampXminus2_UNLOCK());
        Assert.assertEquals((long)socket2_clampXplus2_RELEASE, (long)item_.getSocket2_clampXplus2_RELEASE());
        Assert.assertEquals((long)socket2_clampXplus2_UNLOCK, (long)item_.getSocket2_clampXplus2_UNLOCK());
        Assert.assertEquals((long)socket3_RELEASE_CLAMPS, (long)item_.getSocket3_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket3_UNLOCK_CLAMPS, (long)item_.getSocket3_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket3_clampXminus3_RELEASE, (long)item_.getSocket3_clampXminus3_RELEASE());
        Assert.assertEquals((long)socket3_clampXminus3_UNLOCK, (long)item_.getSocket3_clampXminus3_UNLOCK());
        Assert.assertEquals((long)socket3_clampXplus3_RELEASE, (long)item_.getSocket3_clampXplus3_RELEASE());
        Assert.assertEquals((long)socket3_clampXplus3_UNLOCK, (long)item_.getSocket3_clampXplus3_UNLOCK());
        Assert.assertEquals((long)socket4_RELEASE_CLAMPS, (long)item_.getSocket4_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket4_UNLOCK_CLAMPS, (long)item_.getSocket4_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket4_clampXminus4_RELEASE, (long)item_.getSocket4_clampXminus4_RELEASE());
        Assert.assertEquals((long)socket4_clampXminus4_UNLOCK, (long)item_.getSocket4_clampXminus4_UNLOCK());
        Assert.assertEquals((long)socket4_clampXplus4_RELEASE, (long)item_.getSocket4_clampXplus4_RELEASE());
        Assert.assertEquals((long)socket4_clampXplus4_UNLOCK, (long)item_.getSocket4_clampXplus4_UNLOCK());
        Assert.assertEquals((long)socket5_RELEASE_CLAMPS, (long)item_.getSocket5_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket5_UNLOCK_CLAMPS, (long)item_.getSocket5_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket5_clampXminus5_RELEASE, (long)item_.getSocket5_clampXminus5_RELEASE());
        Assert.assertEquals((long)socket5_clampXminus5_UNLOCK, (long)item_.getSocket5_clampXminus5_UNLOCK());
        Assert.assertEquals((long)socket5_clampXplus5_RELEASE, (long)item_.getSocket5_clampXplus5_RELEASE());
        Assert.assertEquals((long)socket5_clampXplus5_UNLOCK, (long)item_.getSocket5_clampXplus5_UNLOCK());
    }

    @Test
    public void sendReceiveFcs_Duration_Loader_TrendingTelemetry() throws Exception {
        long carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION = 662L;
        long carrier_MOVE_LOADERCARRIER_TO_ENGAGED = 260L;
        long carrier_MOVE_LOADERCARRIER_TO_HANDOFF = 768L;
        long carrier_MOVE_LOADERCARRIER_TO_STORAGE = 63L;
        long hooks_CLAMP_LOADER_HOOKS = 841L;
        long hooks_CLOSE_LOADER_HOOKS = 322L;
        long hooks_OPEN_HOMING_LOADER_HOOKS = 987L;
        long hooks_UNCLAMP_LOADER_HOOKS = 609L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Loader_TrendingTelemetry(carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, carrier_MOVE_LOADERCARRIER_TO_ENGAGED, carrier_MOVE_LOADERCARRIER_TO_HANDOFF, carrier_MOVE_LOADERCARRIER_TO_STORAGE, hooks_CLAMP_LOADER_HOOKS, hooks_CLOSE_LOADER_HOOKS, hooks_OPEN_HOMING_LOADER_HOOKS, hooks_UNCLAMP_LOADER_HOOKS));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Loader_TrendingTelemetry));
        Fcs_Duration_Loader_TrendingTelemetry item_ = (Fcs_Duration_Loader_TrendingTelemetry)item;
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_ENGAGED, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_ENGAGED());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_HANDOFF, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_HANDOFF());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_STORAGE, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_STORAGE());
        Assert.assertEquals((long)hooks_CLAMP_LOADER_HOOKS, (long)item_.getHooks_CLAMP_LOADER_HOOKS());
        Assert.assertEquals((long)hooks_CLOSE_LOADER_HOOKS, (long)item_.getHooks_CLOSE_LOADER_HOOKS());
        Assert.assertEquals((long)hooks_OPEN_HOMING_LOADER_HOOKS, (long)item_.getHooks_OPEN_HOMING_LOADER_HOOKS());
        Assert.assertEquals((long)hooks_UNCLAMP_LOADER_HOOKS, (long)item_.getHooks_UNCLAMP_LOADER_HOOKS());
    }

    @Test
    public void sendReceiveFcs_Duration_TrendingTelemetry() throws Exception {
        long sETFILTER = 861L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_TrendingTelemetry(sETFILTER));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_TrendingTelemetry));
        Fcs_Duration_TrendingTelemetry item_ = (Fcs_Duration_TrendingTelemetry)item;
        Assert.assertEquals((long)sETFILTER, (long)item_.getSETFILTER());
    }

    @Test
    public void sendReceiveFcs_Fcs_Mcm_TrendingTelemetry() throws Exception {
        String autochanger_trucks_location = "n";
        int autochanger_trucks_position = 703;
        int filter_on_autochanger_id = 350;
        String filter_on_autochanger_name = "";
        int filter_previous_socketID = 692;
        int proximity = 946;
        int setfilter_percentage = 903;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Fcs_Mcm_TrendingTelemetry(autochanger_trucks_location, autochanger_trucks_position, filter_on_autochanger_id, filter_on_autochanger_name, filter_previous_socketID, proximity, setfilter_percentage));
        Assert.assertTrue((boolean)(item instanceof Fcs_Fcs_Mcm_TrendingTelemetry));
        Fcs_Fcs_Mcm_TrendingTelemetry item_ = (Fcs_Fcs_Mcm_TrendingTelemetry)item;
        Assert.assertEquals((Object)autochanger_trucks_location, (Object)item_.getAutochanger_trucks_location());
        Assert.assertEquals((long)autochanger_trucks_position, (long)item_.getAutochanger_trucks_position());
        Assert.assertEquals((long)filter_on_autochanger_id, (long)item_.getFilter_on_autochanger_id());
        Assert.assertEquals((Object)filter_on_autochanger_name, (Object)item_.getFilter_on_autochanger_name());
        Assert.assertEquals((long)filter_previous_socketID, (long)item_.getFilter_previous_socketID());
        Assert.assertEquals((long)proximity, (long)item_.getProximity());
        Assert.assertEquals((long)setfilter_percentage, (long)item_.getSetfilter_percentage());
    }

    @Test
    public void sendReceiveFcs_Loader_Carrier_TrendingTelemetry() throws Exception {
        boolean atEngaged = true;
        boolean atHandoff = true;
        boolean atStorage = true;
        boolean controllerInError = false;
        boolean engagedSensorOn = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_Carrier_TrendingTelemetry(atEngaged, atHandoff, atStorage, controllerInError, engagedSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_Carrier_TrendingTelemetry));
        Fcs_Loader_Carrier_TrendingTelemetry item_ = (Fcs_Loader_Carrier_TrendingTelemetry)item;
        Assert.assertEquals((Object)atEngaged, (Object)item_.isAtEngaged());
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atStorage, (Object)item_.isAtStorage());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((Object)engagedSensorOn, (Object)item_.isEngagedSensorOn());
    }

    @Test
    public void sendReceiveFcs_Loader_Hooks_TrendingTelemetry() throws Exception {
        boolean allHooksInStateCLOSED = false;
        String clampState = "c";
        boolean controllerInError = false;
        boolean forceClampedStatus = true;
        boolean forceOverClampedStatus = true;
        int forceSensorVoltage0 = 872;
        int forceSensorVoltage1 = 147;
        String forceStatus = "h";
        boolean forceUnclampedStatus = true;
        boolean forceUnderClampedStatus = true;
        boolean statuspublishedbyhook1_inError = false;
        boolean statuspublishedbyhook1_lockSensorOn = true;
        String statuspublishedbyhook1_lockStatus = "r";
        boolean statuspublishedbyhook1_unlockSensorOn = true;
        boolean statuspublishedbyhook2_inError = false;
        boolean statuspublishedbyhook2_lockSensorOn = true;
        String statuspublishedbyhook2_lockStatus = "e";
        boolean statuspublishedbyhook2_unlockSensorOn = false;
        boolean statuspublishedbyhook3_inError = false;
        boolean statuspublishedbyhook3_lockSensorOn = false;
        String statuspublishedbyhook3_lockStatus = "";
        boolean statuspublishedbyhook3_unlockSensorOn = false;
        boolean statuspublishedbyhook4_inError = false;
        boolean statuspublishedbyhook4_lockSensorOn = false;
        String statuspublishedbyhook4_lockStatus = "";
        boolean statuspublishedbyhook4_unlockSensorOn = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_Hooks_TrendingTelemetry(allHooksInStateCLOSED, clampState, controllerInError, forceClampedStatus, forceOverClampedStatus, forceSensorVoltage0, forceSensorVoltage1, forceStatus, forceUnclampedStatus, forceUnderClampedStatus, statuspublishedbyhook1_inError, statuspublishedbyhook1_lockSensorOn, statuspublishedbyhook1_lockStatus, statuspublishedbyhook1_unlockSensorOn, statuspublishedbyhook2_inError, statuspublishedbyhook2_lockSensorOn, statuspublishedbyhook2_lockStatus, statuspublishedbyhook2_unlockSensorOn, statuspublishedbyhook3_inError, statuspublishedbyhook3_lockSensorOn, statuspublishedbyhook3_lockStatus, statuspublishedbyhook3_unlockSensorOn, statuspublishedbyhook4_inError, statuspublishedbyhook4_lockSensorOn, statuspublishedbyhook4_lockStatus, statuspublishedbyhook4_unlockSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_Hooks_TrendingTelemetry));
        Fcs_Loader_Hooks_TrendingTelemetry item_ = (Fcs_Loader_Hooks_TrendingTelemetry)item;
        Assert.assertEquals((Object)allHooksInStateCLOSED, (Object)item_.isAllHooksInStateCLOSED());
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((Object)forceClampedStatus, (Object)item_.isForceClampedStatus());
        Assert.assertEquals((Object)forceOverClampedStatus, (Object)item_.isForceOverClampedStatus());
        Assert.assertEquals((long)forceSensorVoltage0, (long)item_.getForceSensorVoltage0());
        Assert.assertEquals((long)forceSensorVoltage1, (long)item_.getForceSensorVoltage1());
        Assert.assertEquals((Object)forceStatus, (Object)item_.getForceStatus());
        Assert.assertEquals((Object)forceUnclampedStatus, (Object)item_.isForceUnclampedStatus());
        Assert.assertEquals((Object)forceUnderClampedStatus, (Object)item_.isForceUnderClampedStatus());
        Assert.assertEquals((Object)statuspublishedbyhook1_inError, (Object)item_.isStatuspublishedbyhook1_inError());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockSensorOn, (Object)item_.isStatuspublishedbyhook1_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockStatus, (Object)item_.getStatuspublishedbyhook1_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook1_unlockSensorOn, (Object)item_.isStatuspublishedbyhook1_unlockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook2_inError, (Object)item_.isStatuspublishedbyhook2_inError());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockSensorOn, (Object)item_.isStatuspublishedbyhook2_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockStatus, (Object)item_.getStatuspublishedbyhook2_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook2_unlockSensorOn, (Object)item_.isStatuspublishedbyhook2_unlockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook3_inError, (Object)item_.isStatuspublishedbyhook3_inError());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockSensorOn, (Object)item_.isStatuspublishedbyhook3_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockStatus, (Object)item_.getStatuspublishedbyhook3_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook3_unlockSensorOn, (Object)item_.isStatuspublishedbyhook3_unlockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook4_inError, (Object)item_.isStatuspublishedbyhook4_inError());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockSensorOn, (Object)item_.isStatuspublishedbyhook4_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockStatus, (Object)item_.getStatuspublishedbyhook4_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook4_unlockSensorOn, (Object)item_.isStatuspublishedbyhook4_unlockSensorOn());
    }

    @Test
    public void sendReceiveFcs_TrendingTelemetry() throws Exception {
        int canbus0 = 77;
        int canbus1 = 545;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_TrendingTelemetry(canbus0, canbus1));
        Assert.assertTrue((boolean)(item instanceof Fcs_TrendingTelemetry));
        Fcs_TrendingTelemetry item_ = (Fcs_TrendingTelemetry)item;
        Assert.assertEquals((long)canbus0, (long)item_.getCanbus0());
        Assert.assertEquals((long)canbus1, (long)item_.getCanbus1());
    }

    @Test
    public void sendReceiveShutter_TrendingTelemetry() throws Exception {
        double shutterstatus_axstatus_MINUSX_actPos = 0.913227915763855;
        double shutterstatus_axstatus_MINUSX_actVel = 0.6717151999473572;
        int shutterstatus_axstatus_MINUSX_brakeEngaged = 284;
        double shutterstatus_axstatus_MINUSX_ctrlTemp = 0.22381997108459473;
        int shutterstatus_axstatus_MINUSX_enabled = 121;
        int shutterstatus_axstatus_MINUSX_errorID = 274;
        int shutterstatus_axstatus_MINUSX_hasSafeTemp = 443;
        int shutterstatus_axstatus_MINUSX_highLimit = 389;
        int shutterstatus_axstatus_MINUSX_isHomed = 700;
        int shutterstatus_axstatus_MINUSX_lowLimit = 910;
        double shutterstatus_axstatus_MINUSX_setAcc = 0.5521025657653809;
        double shutterstatus_axstatus_PLUSX_actPos = 0.8842726945877075;
        double shutterstatus_axstatus_PLUSX_actVel = 0.9541825652122498;
        int shutterstatus_axstatus_PLUSX_brakeEngaged = 692;
        double shutterstatus_axstatus_PLUSX_ctrlTemp = 0.9998443722724915;
        int shutterstatus_axstatus_PLUSX_enabled = 350;
        int shutterstatus_axstatus_PLUSX_errorID = 864;
        int shutterstatus_axstatus_PLUSX_hasSafeTemp = 550;
        int shutterstatus_axstatus_PLUSX_highLimit = 765;
        int shutterstatus_axstatus_PLUSX_isHomed = 323;
        int shutterstatus_axstatus_PLUSX_lowLimit = 831;
        double shutterstatus_axstatus_PLUSX_setAcc = 0.2200194001197815;
        int shutterstatus_brakePowerIsOn = 596;
        double shutterstatus_creationTime = 0.6268398761749268;
        int shutterstatus_isCalibrated = 992;
        int shutterstatus_isSafetyOn = 341;
        int shutterstatus_leapIsValid = 912;
        int shutterstatus_leapSeconds = 910;
        int shutterstatus_motionProfile = 774;
        int shutterstatus_ptpState = 403;
        int shutterstatus_smState = 504;
        int shutterstatus_tempIsSafe_CONTROL_BOX = 932;
        int shutterstatus_tempIsSafe_MINUSX_MOTOR = 164;
        int shutterstatus_tempIsSafe_PLUSX_MOTOR = 410;
        double shutterstatus_temperature_CONTROL_BOX = 0.16493523120880127;
        double shutterstatus_temperature_MINUSX_MOTOR = 0.7883666753768921;
        double shutterstatus_temperature_PLUSX_MOTOR = 0.19449561834335327;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Shutter_TrendingTelemetry(shutterstatus_axstatus_MINUSX_actPos, shutterstatus_axstatus_MINUSX_actVel, shutterstatus_axstatus_MINUSX_brakeEngaged, shutterstatus_axstatus_MINUSX_ctrlTemp, shutterstatus_axstatus_MINUSX_enabled, shutterstatus_axstatus_MINUSX_errorID, shutterstatus_axstatus_MINUSX_hasSafeTemp, shutterstatus_axstatus_MINUSX_highLimit, shutterstatus_axstatus_MINUSX_isHomed, shutterstatus_axstatus_MINUSX_lowLimit, shutterstatus_axstatus_MINUSX_setAcc, shutterstatus_axstatus_PLUSX_actPos, shutterstatus_axstatus_PLUSX_actVel, shutterstatus_axstatus_PLUSX_brakeEngaged, shutterstatus_axstatus_PLUSX_ctrlTemp, shutterstatus_axstatus_PLUSX_enabled, shutterstatus_axstatus_PLUSX_errorID, shutterstatus_axstatus_PLUSX_hasSafeTemp, shutterstatus_axstatus_PLUSX_highLimit, shutterstatus_axstatus_PLUSX_isHomed, shutterstatus_axstatus_PLUSX_lowLimit, shutterstatus_axstatus_PLUSX_setAcc, shutterstatus_brakePowerIsOn, shutterstatus_creationTime, shutterstatus_isCalibrated, shutterstatus_isSafetyOn, shutterstatus_leapIsValid, shutterstatus_leapSeconds, shutterstatus_motionProfile, shutterstatus_ptpState, shutterstatus_smState, shutterstatus_tempIsSafe_CONTROL_BOX, shutterstatus_tempIsSafe_MINUSX_MOTOR, shutterstatus_tempIsSafe_PLUSX_MOTOR, shutterstatus_temperature_CONTROL_BOX, shutterstatus_temperature_MINUSX_MOTOR, shutterstatus_temperature_PLUSX_MOTOR));
        Assert.assertTrue((boolean)(item instanceof Shutter_TrendingTelemetry));
        Shutter_TrendingTelemetry item_ = (Shutter_TrendingTelemetry)item;
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_actPos, (double)item_.getShutterstatus_axstatus_MINUSX_actPos(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_actVel, (double)item_.getShutterstatus_axstatus_MINUSX_actVel(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_brakeEngaged, (long)item_.getShutterstatus_axstatus_MINUSX_brakeEngaged());
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_ctrlTemp, (double)item_.getShutterstatus_axstatus_MINUSX_ctrlTemp(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_enabled, (long)item_.getShutterstatus_axstatus_MINUSX_enabled());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_errorID, (long)item_.getShutterstatus_axstatus_MINUSX_errorID());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_hasSafeTemp, (long)item_.getShutterstatus_axstatus_MINUSX_hasSafeTemp());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_highLimit, (long)item_.getShutterstatus_axstatus_MINUSX_highLimit());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_isHomed, (long)item_.getShutterstatus_axstatus_MINUSX_isHomed());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_lowLimit, (long)item_.getShutterstatus_axstatus_MINUSX_lowLimit());
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_setAcc, (double)item_.getShutterstatus_axstatus_MINUSX_setAcc(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_actPos, (double)item_.getShutterstatus_axstatus_PLUSX_actPos(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_actVel, (double)item_.getShutterstatus_axstatus_PLUSX_actVel(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_brakeEngaged, (long)item_.getShutterstatus_axstatus_PLUSX_brakeEngaged());
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_ctrlTemp, (double)item_.getShutterstatus_axstatus_PLUSX_ctrlTemp(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_enabled, (long)item_.getShutterstatus_axstatus_PLUSX_enabled());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_errorID, (long)item_.getShutterstatus_axstatus_PLUSX_errorID());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_hasSafeTemp, (long)item_.getShutterstatus_axstatus_PLUSX_hasSafeTemp());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_highLimit, (long)item_.getShutterstatus_axstatus_PLUSX_highLimit());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_isHomed, (long)item_.getShutterstatus_axstatus_PLUSX_isHomed());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_lowLimit, (long)item_.getShutterstatus_axstatus_PLUSX_lowLimit());
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_setAcc, (double)item_.getShutterstatus_axstatus_PLUSX_setAcc(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_brakePowerIsOn, (long)item_.getShutterstatus_brakePowerIsOn());
        Assert.assertEquals((double)shutterstatus_creationTime, (double)item_.getShutterstatus_creationTime(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_isCalibrated, (long)item_.getShutterstatus_isCalibrated());
        Assert.assertEquals((long)shutterstatus_isSafetyOn, (long)item_.getShutterstatus_isSafetyOn());
        Assert.assertEquals((long)shutterstatus_leapIsValid, (long)item_.getShutterstatus_leapIsValid());
        Assert.assertEquals((long)shutterstatus_leapSeconds, (long)item_.getShutterstatus_leapSeconds());
        Assert.assertEquals((long)shutterstatus_motionProfile, (long)item_.getShutterstatus_motionProfile());
        Assert.assertEquals((long)shutterstatus_ptpState, (long)item_.getShutterstatus_ptpState());
        Assert.assertEquals((long)shutterstatus_smState, (long)item_.getShutterstatus_smState());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_CONTROL_BOX, (long)item_.getShutterstatus_tempIsSafe_CONTROL_BOX());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_MINUSX_MOTOR, (long)item_.getShutterstatus_tempIsSafe_MINUSX_MOTOR());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_PLUSX_MOTOR, (long)item_.getShutterstatus_tempIsSafe_PLUSX_MOTOR());
        Assert.assertEquals((double)shutterstatus_temperature_CONTROL_BOX, (double)item_.getShutterstatus_temperature_CONTROL_BOX(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_temperature_MINUSX_MOTOR, (double)item_.getShutterstatus_temperature_MINUSX_MOTOR(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_temperature_PLUSX_MOTOR, (double)item_.getShutterstatus_temperature_PLUSX_MOTOR(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_ChillerTelemetry() throws Exception {
        double cascadeSetPoint = 0.0715932846069336;
        double chillerPumpLife = 0.7462484836578369;
        double chillerValveAct = 0.3647557f;
        double compressorLife = 0.3323186f;
        double controllerLife = 0.36721545457839966;
        double coolPercentage = 0.118405282497406;
        double flowRate = 0.8010991811752319;
        double flowSetPoint = 0.508657693862915;
        double fluidTemperature = 0.8589502573013306;
        double heatPercentage = 0.4137595295906067;
        double importedColdTemp = 0.5939998030662537;
        double pressureIn = 0.7309850454330444;
        double pressureOut = 0.6179461479187012;
        double pressureTank = 0.61989426612854;
        double tankLevel = 0.7961078882217407;
        double tankSetPoint = 0.5753249526023865;
        double tempCondenser = 0.9113056659698486;
        double tempDUTInput = 0.08735036849975586;
        double tempDynamicSetPt = 0.4078601598739624;
        double tempSetPoint = 0.3205387592315674;
        double tempStage2Evap = 0.23051035404205322;
        double tempTXVBulb = 0.29538804292678833;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_ChillerTelemetry(cascadeSetPoint, chillerPumpLife, chillerValveAct, compressorLife, controllerLife, coolPercentage, flowRate, flowSetPoint, fluidTemperature, heatPercentage, importedColdTemp, pressureIn, pressureOut, pressureTank, tankLevel, tankSetPoint, tempCondenser, tempDUTInput, tempDynamicSetPt, tempSetPoint, tempStage2Evap, tempTXVBulb));
        Assert.assertTrue((boolean)(item instanceof Chiller_ChillerTelemetry));
        Chiller_ChillerTelemetry item_ = (Chiller_ChillerTelemetry)item;
        Assert.assertEquals((double)cascadeSetPoint, (double)item_.getCascadeSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)chillerPumpLife, (double)item_.getChillerPumpLife(), (double)1.0E-6f);
        Assert.assertEquals((double)chillerValveAct, (double)item_.getChillerValveAct(), (double)1.0E-6f);
        Assert.assertEquals((double)compressorLife, (double)item_.getCompressorLife(), (double)1.0E-6f);
        Assert.assertEquals((double)controllerLife, (double)item_.getControllerLife(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPercentage, (double)item_.getCoolPercentage(), (double)1.0E-6f);
        Assert.assertEquals((double)flowRate, (double)item_.getFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)flowSetPoint, (double)item_.getFlowSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)fluidTemperature, (double)item_.getFluidTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)heatPercentage, (double)item_.getHeatPercentage(), (double)1.0E-6f);
        Assert.assertEquals((double)importedColdTemp, (double)item_.getImportedColdTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureIn, (double)item_.getPressureIn(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureOut, (double)item_.getPressureOut(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureTank, (double)item_.getPressureTank(), (double)1.0E-6f);
        Assert.assertEquals((double)tankLevel, (double)item_.getTankLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)tankSetPoint, (double)item_.getTankSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCondenser, (double)item_.getTempCondenser(), (double)1.0E-6f);
        Assert.assertEquals((double)tempDUTInput, (double)item_.getTempDUTInput(), (double)1.0E-6f);
        Assert.assertEquals((double)tempDynamicSetPt, (double)item_.getTempDynamicSetPt(), (double)1.0E-6f);
        Assert.assertEquals((double)tempSetPoint, (double)item_.getTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempStage2Evap, (double)item_.getTempStage2Evap(), (double)1.0E-6f);
        Assert.assertEquals((double)tempTXVBulb, (double)item_.getTempTXVBulb(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_FParam_TrendingTelemetry() throws Exception {
        double bubblev_TIME = 0.8473324179649353;
        double clr_KI_SETPT = 0.8338084816932678;
        double cold_PERIOD = 0.713009774684906;
        double cool_CAPACITY = 0.405303418636322;
        double dut_DT_HI = 0.16961562633514404;
        double dut_DT_LO = 0.8839293122291565;
        double dut_KI = 0.7616698145866394;
        double dut_KP = 0.27010852098464966;
        double dut_TMAX = 0.05141180753707886;
        double dut_TMIN = 0.7563237547874451;
        double flowmeter_LO = 0.19395703077316284;
        double flow_ERR_MASK = 0.3737683892250061;
        double heat_CAPACITY = 0.4904951f;
        double heat_PERIOD = 0.7327471375465393;
        double pid_GAINFAC = 0.22553253173828125;
        double pid_KD = 0.518653392791748;
        double pid_KI = 0.6747376918792725;
        double pid_KP = 0.6570164561271667;
        double purge_TIME = 0.5631012916564941;
        double ramp_DEFAULT = 0.608004093170166;
        double refrig_OFF = 0.9861311316490173;
        double setpt_SETTLE = 0.3039160370826721;
        double setpt_TOL = 0.9787943959236145;
        double tank_SETPOINT = 0.23825335502624512;
        double thermsl_MASS = 0.759335994720459;
        double t_CTRL_MODE = 0.1105089783668518;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_FParam_TrendingTelemetry(bubblev_TIME, clr_KI_SETPT, cold_PERIOD, cool_CAPACITY, dut_DT_HI, dut_DT_LO, dut_KI, dut_KP, dut_TMAX, dut_TMIN, flowmeter_LO, flow_ERR_MASK, heat_CAPACITY, heat_PERIOD, pid_GAINFAC, pid_KD, pid_KI, pid_KP, purge_TIME, ramp_DEFAULT, refrig_OFF, setpt_SETTLE, setpt_TOL, tank_SETPOINT, thermsl_MASS, t_CTRL_MODE));
        Assert.assertTrue((boolean)(item instanceof Chiller_FParam_TrendingTelemetry));
        Chiller_FParam_TrendingTelemetry item_ = (Chiller_FParam_TrendingTelemetry)item;
        Assert.assertEquals((double)bubblev_TIME, (double)item_.getBubblev_TIME(), (double)1.0E-6f);
        Assert.assertEquals((double)clr_KI_SETPT, (double)item_.getClr_KI_SETPT(), (double)1.0E-6f);
        Assert.assertEquals((double)cold_PERIOD, (double)item_.getCold_PERIOD(), (double)1.0E-6f);
        Assert.assertEquals((double)cool_CAPACITY, (double)item_.getCool_CAPACITY(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_DT_HI, (double)item_.getDut_DT_HI(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_DT_LO, (double)item_.getDut_DT_LO(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_KI, (double)item_.getDut_KI(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_KP, (double)item_.getDut_KP(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_TMAX, (double)item_.getDut_TMAX(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_TMIN, (double)item_.getDut_TMIN(), (double)1.0E-6f);
        Assert.assertEquals((double)flowmeter_LO, (double)item_.getFlowmeter_LO(), (double)1.0E-6f);
        Assert.assertEquals((double)flow_ERR_MASK, (double)item_.getFlow_ERR_MASK(), (double)1.0E-6f);
        Assert.assertEquals((double)heat_CAPACITY, (double)item_.getHeat_CAPACITY(), (double)1.0E-6f);
        Assert.assertEquals((double)heat_PERIOD, (double)item_.getHeat_PERIOD(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_GAINFAC, (double)item_.getPid_GAINFAC(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KD, (double)item_.getPid_KD(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KI, (double)item_.getPid_KI(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KP, (double)item_.getPid_KP(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_TIME, (double)item_.getPurge_TIME(), (double)1.0E-6f);
        Assert.assertEquals((double)ramp_DEFAULT, (double)item_.getRamp_DEFAULT(), (double)1.0E-6f);
        Assert.assertEquals((double)refrig_OFF, (double)item_.getRefrig_OFF(), (double)1.0E-6f);
        Assert.assertEquals((double)setpt_SETTLE, (double)item_.getSetpt_SETTLE(), (double)1.0E-6f);
        Assert.assertEquals((double)setpt_TOL, (double)item_.getSetpt_TOL(), (double)1.0E-6f);
        Assert.assertEquals((double)tank_SETPOINT, (double)item_.getTank_SETPOINT(), (double)1.0E-6f);
        Assert.assertEquals((double)thermsl_MASS, (double)item_.getThermsl_MASS(), (double)1.0E-6f);
        Assert.assertEquals((double)t_CTRL_MODE, (double)item_.getT_CTRL_MODE(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_Maq20Telemetry() throws Exception {
        double ambientTemp = 0.9210597276687622;
        double cabinetTemp = 0.9468511343002319;
        double coldPlHeatXfer = 0.3025868535041809;
        double coolantHXOut = 0.41682547330856323;
        double coolantHeatXfer = 0.02113097906112671;
        double coolantPumpIn = 0.2932738661766052;
        double coolantPumpOut = 0.10521078109741211;
        double coolantReturn = 0.2363465428352356;
        double coolantSupply = 0.14390015602111816;
        double fan1Speed = 0.6882686614990234;
        double fan2Speed = 0.8476573824882507;
        double glycChillerIn = 0.6665184497833252;
        double glycChillerOut = 0.8498090505599976;
        double glycCondensOut = 0.24881380796432495;
        double glycDeSuHtrFlow = 0.24697858095169067;
        double glycDeSuHtrOut = 0.9270090460777283;
        double glycFanIn = 0.5507165193557739;
        double glycFanOut = 0.4291202425956726;
        double glycHeatXfer = 0.31646376848220825;
        double glycInputFlow = 0.14046591520309448;
        double glycSupplyP = 0.10621833801269531;
        double pBurstReturn = 0.7622305154800415;
        double pBurstSupply = 0.8990662097930908;
        double stg1CondensOut = 0.949695885181427;
        double stg1Discharge = 0.2943531274795532;
        double stg1Return = 0.5089951753616333;
        double stg1TXVBulb = 0.4099313020706177;
        double stg2DeSuHtrOut = 0.8896225690841675;
        double stg2Discharge = 0.256908655166626;
        double stg2DischargeP = 0.1336471438407898;
        double stg2EvapIn = 0.3564424514770508;
        double stg2EvapOut = 0.7358787655830383;
        double stg2Return = 0.2476483f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_Maq20Telemetry(ambientTemp, cabinetTemp, coldPlHeatXfer, coolantHXOut, coolantHeatXfer, coolantPumpIn, coolantPumpOut, coolantReturn, coolantSupply, fan1Speed, fan2Speed, glycChillerIn, glycChillerOut, glycCondensOut, glycDeSuHtrFlow, glycDeSuHtrOut, glycFanIn, glycFanOut, glycHeatXfer, glycInputFlow, glycSupplyP, pBurstReturn, pBurstSupply, stg1CondensOut, stg1Discharge, stg1Return, stg1TXVBulb, stg2DeSuHtrOut, stg2Discharge, stg2DischargeP, stg2EvapIn, stg2EvapOut, stg2Return));
        Assert.assertTrue((boolean)(item instanceof Chiller_Maq20Telemetry));
        Chiller_Maq20Telemetry item_ = (Chiller_Maq20Telemetry)item;
        Assert.assertEquals((double)ambientTemp, (double)item_.getAmbientTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTemp, (double)item_.getCabinetTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coldPlHeatXfer, (double)item_.getColdPlHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantHXOut, (double)item_.getCoolantHXOut(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantHeatXfer, (double)item_.getCoolantHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantPumpIn, (double)item_.getCoolantPumpIn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantPumpOut, (double)item_.getCoolantPumpOut(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantReturn, (double)item_.getCoolantReturn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantSupply, (double)item_.getCoolantSupply(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)glycChillerIn, (double)item_.getGlycChillerIn(), (double)1.0E-6f);
        Assert.assertEquals((double)glycChillerOut, (double)item_.getGlycChillerOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycCondensOut, (double)item_.getGlycCondensOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycDeSuHtrFlow, (double)item_.getGlycDeSuHtrFlow(), (double)1.0E-6f);
        Assert.assertEquals((double)glycDeSuHtrOut, (double)item_.getGlycDeSuHtrOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycFanIn, (double)item_.getGlycFanIn(), (double)1.0E-6f);
        Assert.assertEquals((double)glycFanOut, (double)item_.getGlycFanOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycHeatXfer, (double)item_.getGlycHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)glycInputFlow, (double)item_.getGlycInputFlow(), (double)1.0E-6f);
        Assert.assertEquals((double)glycSupplyP, (double)item_.getGlycSupplyP(), (double)1.0E-6f);
        Assert.assertEquals((double)pBurstReturn, (double)item_.getPBurstReturn(), (double)1.0E-6f);
        Assert.assertEquals((double)pBurstSupply, (double)item_.getPBurstSupply(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1CondensOut, (double)item_.getStg1CondensOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1Discharge, (double)item_.getStg1Discharge(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1Return, (double)item_.getStg1Return(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1TXVBulb, (double)item_.getStg1TXVBulb(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2DeSuHtrOut, (double)item_.getStg2DeSuHtrOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2Discharge, (double)item_.getStg2Discharge(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2DischargeP, (double)item_.getStg2DischargeP(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2EvapIn, (double)item_.getStg2EvapIn(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2EvapOut, (double)item_.getStg2EvapOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2Return, (double)item_.getStg2Return(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Cold_TempTelemetry() throws Exception {
        double avgColdTemp = 0.35570287704467773;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Cold_TempTelemetry(avgColdTemp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Cold_TempTelemetry));
        Thermal_Cold_TempTelemetry item_ = (Thermal_Cold_TempTelemetry)item;
        Assert.assertEquals((double)avgColdTemp, (double)item_.getAvgColdTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Cryo_TempTelemetry() throws Exception {
        double avgCryoTemp = 0.11056089401245117;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Cryo_TempTelemetry(avgCryoTemp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Cryo_TempTelemetry));
        Thermal_Cryo_TempTelemetry item_ = (Thermal_Cryo_TempTelemetry)item;
        Assert.assertEquals((double)avgCryoTemp, (double)item_.getAvgCryoTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_RtdTelemetry() throws Exception {
        double[] cold_TempCLP = TestHelper.generateDoubleArray((int)25, (int)1541342713);
        double[] cryo_TempCYP = TestHelper.generateDoubleArray((int)25, (int)1987919029);
        double[] grid_TempCFX = TestHelper.generateDoubleArray((int)25, (int)-1589245868);
        double[] grid_TempGFX = TestHelper.generateDoubleArray((int)25, (int)-2118293386);
        double[] grid_TempGRD = TestHelper.generateDoubleArray((int)25, (int)-1771001106);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_RtdTelemetry(cold_TempCLP, cryo_TempCYP, grid_TempCFX, grid_TempGFX, grid_TempGRD, location));
        Assert.assertTrue((boolean)(item instanceof Thermal_RtdTelemetry));
        Thermal_RtdTelemetry item_ = (Thermal_RtdTelemetry)item;
        Assert.assertArrayEquals((double[])cold_TempCLP, (double[])item_.getCold_TempCLP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_TempCYP, (double[])item_.getCryo_TempCYP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_TempCFX, (double[])item_.getGrid_TempCFX(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_TempGFX, (double[])item_.getGrid_TempGFX(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_TempGRD, (double[])item_.getGrid_TempGRD(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveThermal_TrimTelemetry() throws Exception {
        String location = "h";
        double[] trim_Htrs_ColdI = TestHelper.generateDoubleArray((int)6, (int)1235376672);
        double[] trim_Htrs_ColdP = TestHelper.generateDoubleArray((int)6, (int)-1683603258);
        double[] trim_Htrs_ColdV = TestHelper.generateDoubleArray((int)6, (int)-894605533);
        double[] trim_Htrs_CryoI = TestHelper.generateDoubleArray((int)6, (int)1869482897);
        double[] trim_Htrs_CryoP = TestHelper.generateDoubleArray((int)6, (int)-102061458);
        double[] trim_Htrs_CryoV = TestHelper.generateDoubleArray((int)6, (int)1714344973);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_TrimTelemetry(location, trim_Htrs_ColdI, trim_Htrs_ColdP, trim_Htrs_ColdV, trim_Htrs_CryoI, trim_Htrs_CryoP, trim_Htrs_CryoV));
        Assert.assertTrue((boolean)(item instanceof Thermal_TrimTelemetry));
        Thermal_TrimTelemetry item_ = (Thermal_TrimTelemetry)item;
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])trim_Htrs_ColdI, (double[])item_.getTrim_Htrs_ColdI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_ColdP, (double[])item_.getTrim_Htrs_ColdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_ColdV, (double[])item_.getTrim_Htrs_ColdV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_CryoI, (double[])item_.getTrim_Htrs_CryoI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_CryoP, (double[])item_.getTrim_Htrs_CryoP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_CryoV, (double[])item_.getTrim_Htrs_CryoV(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Trim_HtrsTelemetry() throws Exception {
        double coldtotal_P = 0.7609034776687622;
        double cryototal_P = 0.3970431685447693;
        double htrBulkTmp = 0.42832082509994507;
        double htrbulk_I = 0.18198204040527344;
        double htrbulk_P = 0.3077316880226135;
        double htrbulk_V = 0.08432018756866455;
        double htrPsTmp = 0.5854048132896423;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Trim_HtrsTelemetry(coldtotal_P, cryototal_P, htrBulkTmp, htrbulk_I, htrbulk_P, htrbulk_V, htrPsTmp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Trim_HtrsTelemetry));
        Thermal_Trim_HtrsTelemetry item_ = (Thermal_Trim_HtrsTelemetry)item;
        Assert.assertEquals((double)coldtotal_P, (double)item_.getColdtotal_P(), (double)1.0E-6f);
        Assert.assertEquals((double)cryototal_P, (double)item_.getCryototal_P(), (double)1.0E-6f);
        Assert.assertEquals((double)htrBulkTmp, (double)item_.getHtrBulkTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_I, (double)item_.getHtrbulk_I(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_P, (double)item_.getHtrbulk_P(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_V, (double)item_.getHtrbulk_V(), (double)1.0E-6f);
        Assert.assertEquals((double)htrPsTmp, (double)item_.getHtrPsTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_BodyTelemetry() throws Exception {
        double ambAirtemp = 0.013805627822875977;
        double averageTemp = 0.1874944567680359;
        double backFlngXMinusTemp = 0.9739436507225037;
        double backFlngXPlusTemp = 0.7984967827796936;
        double backFlngYMinusTemp = 0.3413194417953491;
        double camBodyXPlusTemp = 0.20059436559677124;
        double camBodyYMinusTemp = 0.06889933347702026;
        double camBodyYPlusTemp = 0.7616328597068787;
        double camHousXMinusTemp = 0.5727697610855103;
        double camHousXPlusTemp = 0.8800707459449768;
        double camHousYMinusTemp = 0.21037834882736206;
        double camHousYPlusTemp = 0.08199608325958252;
        double chgrYMinusRtnAirTemp = 0.010221540927886963;
        double chgrYMinusRtnAirVel = 0.0031989216804504395;
        double domeXMinusTemp = 0.5412513613700867;
        double domeYMinusTemp = 0.07252120971679688;
        double l1XMinusTemp = 0.5229958891868591;
        double l1YMinusTemp = 0.8749794960021973;
        double l2XMinusTemp = 0.1531773805618286;
        double l2XPlusTemp = 0.2249404788017273;
        double l2YMinusTemp = 0.32382726669311523;
        double l2YPlusTemp = 0.32756322622299194;
        double shrdRngXMinusTemp = 0.9496131539344788;
        double shrdRngXPlusTemp = 0.7465482354164124;
        double shrdRngYMinusTemp = 0.34145092964172363;
        double shrdRngYPlusTemp = 0.37691646814346313;
        double shtrEboxRtnAirTemp = 0.9638907313346863;
        double shtrEboxRtnAirVel = 0.234491229057312;
        double shtrMtrRtnAirTemp = 0.0657962f;
        double shtrMtrRtnAirVel = 0.7273004651069641;
        double vPPlenumInTemp = 0.6417178511619568;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_BodyTelemetry(ambAirtemp, averageTemp, backFlngXMinusTemp, backFlngXPlusTemp, backFlngYMinusTemp, camBodyXPlusTemp, camBodyYMinusTemp, camBodyYPlusTemp, camHousXMinusTemp, camHousXPlusTemp, camHousYMinusTemp, camHousYPlusTemp, chgrYMinusRtnAirTemp, chgrYMinusRtnAirVel, domeXMinusTemp, domeYMinusTemp, l1XMinusTemp, l1YMinusTemp, l2XMinusTemp, l2XPlusTemp, l2YMinusTemp, l2YPlusTemp, shrdRngXMinusTemp, shrdRngXPlusTemp, shrdRngYMinusTemp, shrdRngYPlusTemp, shtrEboxRtnAirTemp, shtrEboxRtnAirVel, shtrMtrRtnAirTemp, shtrMtrRtnAirVel, vPPlenumInTemp));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_BodyTelemetry));
        Utiltrunk_BodyTelemetry item_ = (Utiltrunk_BodyTelemetry)item;
        Assert.assertEquals((double)ambAirtemp, (double)item_.getAmbAirtemp(), (double)1.0E-6f);
        Assert.assertEquals((double)averageTemp, (double)item_.getAverageTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngXMinusTemp, (double)item_.getBackFlngXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngXPlusTemp, (double)item_.getBackFlngXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngYMinusTemp, (double)item_.getBackFlngYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyXPlusTemp, (double)item_.getCamBodyXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyYMinusTemp, (double)item_.getCamBodyYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyYPlusTemp, (double)item_.getCamBodyYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousXMinusTemp, (double)item_.getCamHousXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousXPlusTemp, (double)item_.getCamHousXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousYMinusTemp, (double)item_.getCamHousYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousYPlusTemp, (double)item_.getCamHousYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)chgrYMinusRtnAirTemp, (double)item_.getChgrYMinusRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)chgrYMinusRtnAirVel, (double)item_.getChgrYMinusRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)domeXMinusTemp, (double)item_.getDomeXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)domeYMinusTemp, (double)item_.getDomeYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l1XMinusTemp, (double)item_.getL1XMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l1YMinusTemp, (double)item_.getL1YMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2XMinusTemp, (double)item_.getL2XMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2XPlusTemp, (double)item_.getL2XPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2YMinusTemp, (double)item_.getL2YMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2YPlusTemp, (double)item_.getL2YPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngXMinusTemp, (double)item_.getShrdRngXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngXPlusTemp, (double)item_.getShrdRngXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngYMinusTemp, (double)item_.getShrdRngYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngYPlusTemp, (double)item_.getShrdRngYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrEboxRtnAirTemp, (double)item_.getShtrEboxRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrEboxRtnAirVel, (double)item_.getShtrEboxRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrMtrRtnAirTemp, (double)item_.getShtrMtrRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrMtrRtnAirVel, (double)item_.getShtrMtrRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)vPPlenumInTemp, (double)item_.getVPPlenumInTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_MPCTelemetry() throws Exception {
        double avgAirtempOut = 0.8696505427360535;
        double deltaPressFilt = 0.8014907240867615;
        double deltaPressTotal = 0.8320274353027344;
        double deltaTempAct = 0.2405148148536682;
        double fanRunTime = 0.6813452839851379;
        double fanSpeed = 0.006854236125946045;
        double humidity = 0.03768497705459595;
        double preFiltPress = 0.5266118049621582;
        double retnAirTemp = 0.3479401469230652;
        double retnPress = 0.6519877910614014;
        double splyAirTemp = 0.7564423680305481;
        double splyPress = 0.33132725954055786;
        double valvePosn = 0.4313966f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_MPCTelemetry(avgAirtempOut, deltaPressFilt, deltaPressTotal, deltaTempAct, fanRunTime, fanSpeed, humidity, preFiltPress, retnAirTemp, retnPress, splyAirTemp, splyPress, valvePosn));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_MPCTelemetry));
        Utiltrunk_MPCTelemetry item_ = (Utiltrunk_MPCTelemetry)item;
        Assert.assertEquals((double)avgAirtempOut, (double)item_.getAvgAirtempOut(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressFilt, (double)item_.getDeltaPressFilt(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressTotal, (double)item_.getDeltaPressTotal(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaTempAct, (double)item_.getDeltaTempAct(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)humidity, (double)item_.getHumidity(), (double)1.0E-6f);
        Assert.assertEquals((double)preFiltPress, (double)item_.getPreFiltPress(), (double)1.0E-6f);
        Assert.assertEquals((double)retnAirTemp, (double)item_.getRetnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)retnPress, (double)item_.getRetnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirTemp, (double)item_.getSplyAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)splyPress, (double)item_.getSplyPress(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_UTTelemetry() throws Exception {
        double averageTemp = 0.21207916736602783;
        double coolFlowRate = 0.44064861536026;
        double coolPipeRetnTemp = 0.4272640347480774;
        double coolPipeSplyTemp = 0.8109055161476135;
        double coolReturnPrs = 0.2599042057991028;
        double coolSupplyPrs = 0.9547948241233826;
        double domeXMinusTemp = 0.22887331247329712;
        double domeYMinusTemp = 0.687648f;
        double fanInletTemp = 0.45208728313446045;
        double fanRunTime = 0.3467797636985779;
        double fanSpeed = 0.3316415548324585;
        double midXMinusTemp = 0.8257326483726501;
        double midXPlusTemp = 0.6625066995620728;
        double suppXMinusTemp = 0.8736305236816406;
        double suppXPlusTemp = 0.1604672074317932;
        double topXMinusTemp = 0.5103719234466553;
        double topXPlusTemp = 0.8269177675247192;
        double valvePosn = 0.8123723268508911;
        double w2Q1Temp = 0.4813665747642517;
        double w4Q3Temp = 0.020921528339385986;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_UTTelemetry(averageTemp, coolFlowRate, coolPipeRetnTemp, coolPipeSplyTemp, coolReturnPrs, coolSupplyPrs, domeXMinusTemp, domeYMinusTemp, fanInletTemp, fanRunTime, fanSpeed, midXMinusTemp, midXPlusTemp, suppXMinusTemp, suppXPlusTemp, topXMinusTemp, topXPlusTemp, valvePosn, w2Q1Temp, w4Q3Temp));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_UTTelemetry));
        Utiltrunk_UTTelemetry item_ = (Utiltrunk_UTTelemetry)item;
        Assert.assertEquals((double)averageTemp, (double)item_.getAverageTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPipeRetnTemp, (double)item_.getCoolPipeRetnTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPipeSplyTemp, (double)item_.getCoolPipeSplyTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolReturnPrs, (double)item_.getCoolReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)coolSupplyPrs, (double)item_.getCoolSupplyPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)domeXMinusTemp, (double)item_.getDomeXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)domeYMinusTemp, (double)item_.getDomeYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanInletTemp, (double)item_.getFanInletTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)midXMinusTemp, (double)item_.getMidXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)midXPlusTemp, (double)item_.getMidXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)suppXMinusTemp, (double)item_.getSuppXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)suppXPlusTemp, (double)item_.getSuppXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)topXMinusTemp, (double)item_.getTopXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)topXPlusTemp, (double)item_.getTopXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)w2Q1Temp, (double)item_.getW2Q1Temp(), (double)1.0E-6f);
        Assert.assertEquals((double)w4Q3Temp, (double)item_.getW4Q3Temp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_VPCTelemetry() throws Exception {
        double deltaPressFilt = 0.7771791815757751;
        double deltaPressTotal = 0.22620874643325806;
        double deltaTempAct = 0.17614257335662842;
        double fanRunTime = 0.6016849279403687;
        double fanSpeed = 0.5912918448448181;
        double htrCurrent = 0.61680006980896;
        double humidity = 0.12476956844329834;
        double preFiltPress = 0.9761613607406616;
        double retnAirTemp = 0.2247957f;
        double retnPress = 0.69805508852005;
        double splyAirTemp = 0.8758060336112976;
        double splyAirVel = 0.2901118993759155;
        double splyPress = 0.9560574889183044;
        double valvePosn = 0.3139672875404358;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_VPCTelemetry(deltaPressFilt, deltaPressTotal, deltaTempAct, fanRunTime, fanSpeed, htrCurrent, humidity, preFiltPress, retnAirTemp, retnPress, splyAirTemp, splyAirVel, splyPress, valvePosn));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_VPCTelemetry));
        Utiltrunk_VPCTelemetry item_ = (Utiltrunk_VPCTelemetry)item;
        Assert.assertEquals((double)deltaPressFilt, (double)item_.getDeltaPressFilt(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressTotal, (double)item_.getDeltaPressTotal(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaTempAct, (double)item_.getDeltaTempAct(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)htrCurrent, (double)item_.getHtrCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)humidity, (double)item_.getHumidity(), (double)1.0E-6f);
        Assert.assertEquals((double)preFiltPress, (double)item_.getPreFiltPress(), (double)1.0E-6f);
        Assert.assertEquals((double)retnAirTemp, (double)item_.getRetnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)retnPress, (double)item_.getRetnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirTemp, (double)item_.getSplyAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirVel, (double)item_.getSplyAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)splyPress, (double)item_.getSplyPress(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
    }
}

