/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.Chiller_ChillerTelemetry;
import org.lsst.sal.camera.telemetry.Chiller_FParam_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Chiller_Maq20Telemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Reb_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Sum_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_Latches_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_OnlineClamps_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_TemperaturesTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Accelerobf_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Ai814_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_CarouselController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ClampXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ClampXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Hyttc580_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_LatchXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_LatchXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Pt100_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_CarrierController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_HooksController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket1_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket2_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket3_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket4_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket5_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Autochanger_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Loader_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Fcs_Mcm_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_Carrier_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_Hooks_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebsAverageTemp6Telemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_03Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_05Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_50Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CLP_RTD_55Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_12Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_14Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_31Telemetry;
import org.lsst.sal.camera.telemetry.Mpm_CYP_RTD_43Telemetry;
import org.lsst.sal.camera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_REB_Bulk_PSTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Shutter_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Cold_TempTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Cryo_TempTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_RtdTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_TrimTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Trim_HtrsTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_BodyTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_MPCTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_UTTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_VPCTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CipTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_HXTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_HipTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_InstTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.8448562026023865;
        double dirty_24V_I = 0.47357481718063354;
        double dirty_28V_I = 0.06600093841552734;
        double dirty_48V_I = 0.14796394109725952;
        double protection_I = 0.6016800999641418;
        double rebps_0_2_I = 0.797464907169342;
        double rebps_3_5_I = 0.4814193844795227;
        double rebps_6_8_I = 0.0751307f;
        double rebps_9_12_I = 0.10580384731292725;
        double rebps_Spr_I = 0.852108f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, protection_I, rebps_0_2_I, rebps_3_5_I, rebps_6_8_I, rebps_9_12_I, rebps_Spr_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I, (double)item_.getRebps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I, (double)item_.getRebps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I, (double)item_.getRebps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I, (double)item_.getRebps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I, (double)item_.getRebps_Spr_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double board_T = 0.4291935f;
        double body_Maq20_I = 0.46186351776123047;
        double body_Maq20_V = 0.1656639575958252;
        double cryo_Maq20_I = 0.1363620162010193;
        double cryo_Maq20_V = 0.8070361614227295;
        double fes_CarouselC_I = 0.25038015842437744;
        double fes_CarouselC_V = 0.9436920881271362;
        double fes_ChangerC_I = 0.810223400592804;
        double fes_ChangerC_V = 0.23215728998184204;
        double fes_LoaderC_I = 0.2435584f;
        double fes_LoaderC_V = 0.5742436051368713;
        double fpga_T = 0.8752353191375732;
        double gauges_I = 0.5056929588317871;
        double gauges_V = 0.6168304085731506;
        double int_Valves_I = 0.8500670790672302;
        double int_Valves_V = 0.4577585f;
        double ion_Pumps_I = 0.20925217866897583;
        double ion_Pumps_V = 0.6533224582672119;
        double main_I = 0.22056913375854492;
        double main_T = 0.8833869695663452;
        double main_V = 0.20280665159225464;
        double shtr_PLC1_I = 0.47443896532058716;
        double shtr_PLC1_V = 0.5874550342559814;
        double shtr_PLC2_I = 0.9551604986190796;
        double shtr_PLC2_V = 0.5989840626716614;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(board_T, body_Maq20_I, body_Maq20_V, cryo_Maq20_I, cryo_Maq20_V, fes_CarouselC_I, fes_CarouselC_V, fes_ChangerC_I, fes_ChangerC_V, fes_LoaderC_I, fes_LoaderC_V, fpga_T, gauges_I, gauges_V, int_Valves_I, int_Valves_V, ion_Pumps_I, ion_Pumps_V, main_I, main_T, main_V, shtr_PLC1_I, shtr_PLC1_V, shtr_PLC2_I, shtr_PLC2_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I, (double)item_.getBody_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V, (double)item_.getBody_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I, (double)item_.getCryo_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V, (double)item_.getCryo_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I, (double)item_.getFes_CarouselC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V, (double)item_.getFes_CarouselC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I, (double)item_.getFes_ChangerC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V, (double)item_.getFes_ChangerC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I, (double)item_.getFes_LoaderC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V, (double)item_.getFes_LoaderC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I, (double)item_.getInt_Valves_I(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V, (double)item_.getInt_Valves_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I, (double)item_.getShtr_PLC1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V, (double)item_.getShtr_PLC1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I, (double)item_.getShtr_PLC2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V, (double)item_.getShtr_PLC2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.9816069006919861;
        double cryo_Turbo_I = 0.9355312585830688;
        double cryo_Turbo_V = 0.8177720308303833;
        double fes_Brakes_I = 0.4128384590148926;
        double fes_Brakes_V = 0.06837540864944458;
        double fes_ChangerD_I = 0.8284186720848083;
        double fes_ChangerD_V = 0.661920428276062;
        double fes_Clamps_I = 0.6660546660423279;
        double fes_Clamps_V = 0.914297f;
        double fes_LoaderD_I = 0.1886521f;
        double fes_LoaderD_V = 0.22016805410385132;
        double fpga_T = 0.35111796855926514;
        double hex_Turbo_I = 0.2324143648147583;
        double hex_Turbo_V = 0.6052715182304382;
        double main_I = 0.9666034579277039;
        double main_T = 0.6281944513320923;
        double main_V = 0.2507822513580322;
        double shtr_Brakes_I = 0.03379279375076294;
        double shtr_Brakes_V = 0.3613848090171814;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, cryo_Turbo_I, cryo_Turbo_V, fes_Brakes_I, fes_Brakes_V, fes_ChangerD_I, fes_ChangerD_V, fes_Clamps_I, fes_Clamps_V, fes_LoaderD_I, fes_LoaderD_V, fpga_T, hex_Turbo_I, hex_Turbo_V, main_I, main_T, main_V, shtr_Brakes_I, shtr_Brakes_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I, (double)item_.getFes_Brakes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V, (double)item_.getFes_Brakes_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I, (double)item_.getFes_ChangerD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V, (double)item_.getFes_ChangerD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I, (double)item_.getFes_Clamps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V, (double)item_.getFes_Clamps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I, (double)item_.getFes_LoaderD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V, (double)item_.getFes_LoaderD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I, (double)item_.getHex_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V, (double)item_.getHex_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I, (double)item_.getShtr_Brakes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V, (double)item_.getShtr_Brakes_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.682387f;
        double fes_CarouselD_I = 0.8959237337112427;
        double fes_CarouselD_V = 0.11576986312866211;
        double fes_Heater_I = 0.5975778102874756;
        double fes_Heater_V = 0.26185494661331177;
        double fpga_T = 0.683756947517395;
        double main_I = 0.2185322f;
        double main_T = 0.5969497561454773;
        double main_V = 0.45133131742477417;
        double purge_Fan_I = 0.6732280850410461;
        double purge_Fan_V = 0.528732419013977;
        double shtr_Motor1_I = 0.4645213f;
        double shtr_Motor1_V = 0.3172866702079773;
        double shtr_Motor2_I = 0.10220718383789062;
        double shtr_Motor2_V = 0.3028267025947571;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, fes_CarouselD_I, fes_CarouselD_V, fes_Heater_I, fes_Heater_V, fpga_T, main_I, main_T, main_V, purge_Fan_I, purge_Fan_V, shtr_Motor1_I, shtr_Motor1_V, shtr_Motor2_I, shtr_Motor2_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I, (double)item_.getFes_CarouselD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V, (double)item_.getFes_CarouselD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I, (double)item_.getFes_Heater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V, (double)item_.getFes_Heater_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I, (double)item_.getPurge_Fan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V, (double)item_.getPurge_Fan_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I, (double)item_.getShtr_Motor1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V, (double)item_.getShtr_Motor1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I, (double)item_.getShtr_Motor2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V, (double)item_.getShtr_Motor2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_A_I = 0.015305638313293457;
        double otm_0_A_V = 0.749941885471344;
        double otm_0_B_I = 0.9972925782203674;
        double otm_0_B_V = 0.4384235143661499;
        double otm_1_A_I = 0.11301231384277344;
        double otm_1_A_V = 0.8862195014953613;
        double otm_1_B_I = 0.7628299593925476;
        double otm_1_B_V = 0.4655722975730896;
        double otm_2_A_I = 0.45740777254104614;
        double otm_2_A_V = 0.6423649191856384;
        double otm_2_B_I = 0.03408527374267578;
        double otm_2_B_V = 0.5276654958724976;
        double otm_3_A_I = 0.6879861354827881;
        double otm_3_A_V = 0.03431123495101929;
        double otm_3_B_I = 0.5901688933372498;
        double otm_3_B_V = 0.9169453978538513;
        double otm_4_A_I = 0.5657105445861816;
        double otm_4_A_V = 0.4899718165397644;
        double otm_4_B_I = 0.9196410775184631;
        double otm_4_B_V = 0.8170307874679565;
        double otm_5_A_I = 0.8965678215026855;
        double otm_5_A_V = 0.3357229232788086;
        double otm_5_B_I = 0.81204f;
        double otm_5_B_V = 0.4799065589904785;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_A_I, otm_0_A_V, otm_0_B_I, otm_0_B_V, otm_1_A_I, otm_1_A_V, otm_1_B_I, otm_1_B_V, otm_2_A_I, otm_2_A_V, otm_2_B_I, otm_2_B_V, otm_3_A_I, otm_3_A_V, otm_3_B_I, otm_3_B_V, otm_4_A_I, otm_4_A_V, otm_4_B_I, otm_4_B_V, otm_5_A_I, otm_5_A_V, otm_5_B_I, otm_5_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I, (double)item_.getOtm_1_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V, (double)item_.getOtm_1_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I, (double)item_.getOtm_1_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V, (double)item_.getOtm_1_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I, (double)item_.getOtm_2_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V, (double)item_.getOtm_2_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I, (double)item_.getOtm_2_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V, (double)item_.getOtm_2_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I, (double)item_.getOtm_3_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V, (double)item_.getOtm_3_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I, (double)item_.getOtm_4_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V, (double)item_.getOtm_4_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I, (double)item_.getOtm_4_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V, (double)item_.getOtm_4_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I, (double)item_.getOtm_5_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V, (double)item_.getOtm_5_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I, (double)item_.getOtm_5_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V, (double)item_.getOtm_5_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PSTelemetry() throws Exception {
        double rebbulkps_0_2_I = 0.38088494539260864;
        double rebbulkps_0_2_T = 0.09770017862319946;
        double rebbulkps_0_2_V = 0.6987639665603638;
        double rebbulkps_3_5_I = 0.601096510887146;
        double rebbulkps_3_5_T = 0.8367648124694824;
        double rebbulkps_3_5_V = 0.4286269545555115;
        double rebbulkps_6_8_I = 0.11435937881469727;
        double rebbulkps_6_8_T = 0.9560117721557617;
        double rebbulkps_6_8_V = 0.1462084f;
        double rebbulkps_9_12_I = 0.037287235260009766;
        double rebbulkps_9_12_T = 0.7124680876731873;
        double rebbulkps_9_12_V = 0.8026264905929565;
        double rebbulkps_Brd_T = 0.7157336473464966;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_REB_Bulk_PSTelemetry(rebbulkps_0_2_I, rebbulkps_0_2_T, rebbulkps_0_2_V, rebbulkps_3_5_I, rebbulkps_3_5_T, rebbulkps_3_5_V, rebbulkps_6_8_I, rebbulkps_6_8_T, rebbulkps_6_8_V, rebbulkps_9_12_I, rebbulkps_9_12_T, rebbulkps_9_12_V, rebbulkps_Brd_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PSTelemetry));
        Quadbox_REB_Bulk_PSTelemetry item_ = (Quadbox_REB_Bulk_PSTelemetry)item;
        Assert.assertEquals((double)rebbulkps_0_2_I, (double)item_.getRebbulkps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T, (double)item_.getRebbulkps_0_2_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V, (double)item_.getRebbulkps_0_2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I, (double)item_.getRebbulkps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T, (double)item_.getRebbulkps_3_5_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V, (double)item_.getRebbulkps_3_5_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I, (double)item_.getRebbulkps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T, (double)item_.getRebbulkps_6_8_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V, (double)item_.getRebbulkps_6_8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I, (double)item_.getRebbulkps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T, (double)item_.getRebbulkps_9_12_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V, (double)item_.getRebbulkps_9_12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T, (double)item_.getRebbulkps_Brd_T(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1495280782);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-2111939128);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)1497569887);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1728391462);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)403026951);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)346487498);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)50163048);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)1803060940);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)803919810);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)612237784);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-509695033);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)686994377);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)125555802);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)1534725760);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-347787531);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1639805589);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1779330549);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)1569356884);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)78517983);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-340408209);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1034095704);
        double[] dphi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1705458889);
        double[] dphi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)867054588);
        double[] dphi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1789750402);
        double[] dphi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1478254382);
        double[] dphi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)1900914529);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1602682529);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1767219717);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1715290266);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-147347444);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)750989203);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)71, (int)827049723);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)71, (int)910118967);
        String location = "";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)2028719582);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-625608556);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)1978868476);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)-1499198570);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1373649436);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1542458534);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)-1738500724);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, dphi_IaftLDO, dphi_IbefLDO, dphi_VaftLDO, dphi_VaftSwch, dphi_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO, (double[])item_.getDphi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO, (double[])item_.getDphi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO, (double[])item_.getDphi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch, (double[])item_.getDphi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO, (double[])item_.getDphi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.20269042253494263;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTotalPowerTelemetry));
        Rebpower_RebTotalPowerTelemetry item_ = (Rebpower_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)13, (int)-727360072);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)13, (int)2030734886);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)13, (int)-1230597560);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)13, (int)800158744);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)13, (int)-1037165908);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)13, (int)1014771225);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)13, (int)-187596329);
        double[] fPGATemp = TestHelper.generateDoubleArray((int)13, (int)-1490936815);
        String location = "c";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, fPGATemp, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fPGATemp, (double[])item_.getFPGATemp(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveHex_Cold1Telemetry() throws Exception {
        double returnTmp = 0.03462434f;
        double supplyTmp = 0.38666582107543945;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold1Telemetry(returnTmp, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1Telemetry));
        Hex_Cold1Telemetry item_ = (Hex_Cold1Telemetry)item;
        Assert.assertEquals((double)returnTmp, (double)item_.getReturnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2Telemetry() throws Exception {
        double returnTmp = 0.6155957579612732;
        double supplyTmp = 0.278786838054657;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold2Telemetry(returnTmp, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2Telemetry));
        Hex_Cold2Telemetry item_ = (Hex_Cold2Telemetry)item;
        Assert.assertEquals((double)returnTmp, (double)item_.getReturnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1Telemetry() throws Exception {
        double c3ExitTmp = 0.5909197330474854;
        double c4ExitTmp = 0.6687962412834167;
        double evapExitTmp = 0.0849973f;
        double hexRtrnTmp = 0.600838f;
        double liquidPrs = 0.6535108089447021;
        double preC3Tmp = 0.5135097503662109;
        double preC4Tmp = 0.2793514132499695;
        double returnPrs = 0.4285746216773987;
        double vaporPrs = 0.8122632503509521;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo1Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1Telemetry));
        Hex_Cryo1Telemetry item_ = (Hex_Cryo1Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2Telemetry() throws Exception {
        double c3ExitTmp = 0.8002185225486755;
        double c4ExitTmp = 0.5693804621696472;
        double evapExitTmp = 0.4447472095489502;
        double hexRtrnTmp = 0.3190999f;
        double liquidPrs = 0.03634554147720337;
        double preC3Tmp = 0.1288432478904724;
        double preC4Tmp = 0.15852785110473633;
        double returnPrs = 0.8869417905807495;
        double vaporPrs = 0.1780725121498108;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo2Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2Telemetry));
        Hex_Cryo2Telemetry item_ = (Hex_Cryo2Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3Telemetry() throws Exception {
        double c3ExitTmp = 0.1265236735343933;
        double c4ExitTmp = 0.68799889087677;
        double evapExitTmp = 0.7755282521247864;
        double hexRtrnTmp = 0.43794262409210205;
        double liquidPrs = 0.1682819128036499;
        double preC3Tmp = 0.8560400605201721;
        double preC4Tmp = 0.7613850831985474;
        double returnPrs = 0.39161497354507446;
        double vaporPrs = 0.2143843173980713;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo3Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3Telemetry));
        Hex_Cryo3Telemetry item_ = (Hex_Cryo3Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4Telemetry() throws Exception {
        double c3ExitTmp = 0.36885833740234375;
        double c4ExitTmp = 0.6955242156982422;
        double evapExitTmp = 0.922725f;
        double hexRtrnTmp = 0.5182716250419617;
        double liquidPrs = 0.8896235823631287;
        double preC3Tmp = 0.6626859307289124;
        double preC4Tmp = 0.7173235416412354;
        double returnPrs = 0.896554708480835;
        double vaporPrs = 0.5846288800239563;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo4Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4Telemetry));
        Hex_Cryo4Telemetry item_ = (Hex_Cryo4Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5Telemetry() throws Exception {
        double c3ExitTmp = 0.8296563029289246;
        double c4ExitTmp = 0.6309148669242859;
        double evapExitTmp = 0.10122638940811157;
        double hexRtrnTmp = 0.4883200526237488;
        double liquidPrs = 0.17009252309799194;
        double preC3Tmp = 0.43547284603118896;
        double preC4Tmp = 0.30685955286026;
        double returnPrs = 0.35428208112716675;
        double vaporPrs = 0.59520024061203;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo5Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5Telemetry));
        Hex_Cryo5Telemetry item_ = (Hex_Cryo5Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6Telemetry() throws Exception {
        double c3ExitTmp = 0.23540490865707397;
        double c4ExitTmp = 0.9090507626533508;
        double evapExitTmp = 0.5953091979026794;
        double hexRtrnTmp = 0.022459805011749268;
        double liquidPrs = 0.3852902054786682;
        double preC3Tmp = 0.44482892751693726;
        double preC4Tmp = 0.2961214780807495;
        double returnPrs = 0.4504796862602234;
        double vaporPrs = 0.6040089130401611;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo6Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6Telemetry));
        Hex_Cryo6Telemetry item_ = (Hex_Cryo6Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo1Telemetry() throws Exception {
        double afterCoolTmp = 0.558561f;
        double compCurrent = 0.95185f;
        double compPower = 0.7521445751190186;
        double compVoltage = 0.35588985681533813;
        double dischrgPrs = 0.44355857372283936;
        double dischrgtmp_M = 0.654447f;
        double dischrgtmp_P = 0.17885643243789673;
        double fanSpeed = 0.5466504693031311;
        double oilLevel = 0.06375300884246826;
        double oilSepTmp = 0.5436651706695557;
        double phaseSepTmp = 0.217274010181427;
        double suctionPrs = 0.3877224922180176;
        double suctiontmp_M = 0.0032235383987426758;
        double suctiontmp_P = 0.850786566734314;
        double surgeTankTmp = 0.6411176323890686;
        double waterInTmp = 0.5352170467376709;
        double waterOutTmp = 0.8839085102081299;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo1Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1Telemetry));
        Refrig_Cryo1Telemetry item_ = (Refrig_Cryo1Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2Telemetry() throws Exception {
        double afterCoolTmp = 0.19910532236099243;
        double compCurrent = 0.2420135736465454;
        double compPower = 0.5680676698684692;
        double compVoltage = 0.6415224075317383;
        double dischrgPrs = 0.6581142544746399;
        double dischrgtmp_M = 0.6458249092102051;
        double dischrgtmp_P = 0.6832186579704285;
        double fanSpeed = 0.3426624f;
        double oilLevel = 0.5669072270393372;
        double oilSepTmp = 0.868403434753418;
        double phaseSepTmp = 0.444133996963501;
        double suctionPrs = 0.7765841484069824;
        double suctiontmp_M = 0.3005765f;
        double suctiontmp_P = 0.33426398038864136;
        double surgeTankTmp = 0.2030550241470337;
        double waterInTmp = 0.4555372f;
        double waterOutTmp = 0.9210861325263977;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo2Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2Telemetry));
        Refrig_Cryo2Telemetry item_ = (Refrig_Cryo2Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3Telemetry() throws Exception {
        double afterCoolTmp = 0.17353105545043945;
        double ambientTmp = 0.7486221194267273;
        double cabinetTmp = 0.4283798336982727;
        double compCurrent = 0.26659804582595825;
        double compPower = 0.8799508810043335;
        double compVoltage = 0.020609617233276367;
        double dischrgPrs = 0.05208402872085571;
        double dischrgtmp_M = 0.24147897958755493;
        double dischrgtmp_P = 0.2122497f;
        double fanSpeed = 0.7351446151733398;
        double oilLevel = 0.5014378428459167;
        double oilSepTmp = 0.38984131813049316;
        double phaseSepTmp = 0.3622232675552368;
        double suctionPrs = 0.22005265951156616;
        double suctiontmp_M = 0.8336512446403503;
        double suctiontmp_P = 0.8006823062896729;
        double surgeTankTmp = 0.40835005044937134;
        double waterInTmp = 0.054684996604919434;
        double waterOutTmp = 0.1946696f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo3Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3Telemetry));
        Refrig_Cryo3Telemetry item_ = (Refrig_Cryo3Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4Telemetry() throws Exception {
        double afterCoolTmp = 0.8003453612327576;
        double compCurrent = 0.3892640471458435;
        double compPower = 0.516148567199707;
        double compVoltage = 0.6689355969429016;
        double dischrgPrs = 0.05160415172576904;
        double dischrgtmp_M = 0.6360364556312561;
        double dischrgtmp_P = 0.7693183422088623;
        double fanSpeed = 0.07337045669555664;
        double oilLevel = 0.6772706508636475;
        double oilSepTmp = 0.4179755449295044;
        double phaseSepTmp = 0.007028937339782715;
        double suctionPrs = 0.9968532919883728;
        double suctiontmp_M = 0.9545769691467285;
        double suctiontmp_P = 0.3087554f;
        double surgeTankTmp = 0.7957040667533875;
        double waterInTmp = 0.7339683175086975;
        double waterOutTmp = 0.345028817653656;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo4Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4Telemetry));
        Refrig_Cryo4Telemetry item_ = (Refrig_Cryo4Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5Telemetry() throws Exception {
        double afterCoolTmp = 0.7464436888694763;
        double ambientTmp = 0.04730475f;
        double cabinetTmp = 0.6799012422561646;
        double compCurrent = 0.008954644203186035;
        double compPower = 0.02386784553527832;
        double compVoltage = 0.7984013557434082;
        double dischrgPrs = 0.7938501834869385;
        double dischrgtmp_M = 0.1461772322654724;
        double dischrgtmp_P = 0.8392994403839111;
        double fanSpeed = 0.1995563507080078;
        double oilLevel = 0.03106069564819336;
        double oilSepTmp = 0.16134315729141235;
        double phaseSepTmp = 0.699354f;
        double suctionPrs = 0.3118462562561035;
        double suctiontmp_M = 0.1466047167778015;
        double suctiontmp_P = 0.697310209274292;
        double surgeTankTmp = 0.9871083498001099;
        double waterInTmp = 0.8716533184051514;
        double waterOutTmp = 0.02343040704727173;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo5Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5Telemetry));
        Refrig_Cryo5Telemetry item_ = (Refrig_Cryo5Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6Telemetry() throws Exception {
        double afterCoolTmp = 0.4510906934738159;
        double compCurrent = 0.6826828122138977;
        double compPower = 0.6598678231239319;
        double compVoltage = 0.03727757930755615;
        double dischrgPrs = 0.5882796049118042;
        double dischrgtmp_M = 0.29798614978790283;
        double dischrgtmp_P = 0.42802155017852783;
        double fanSpeed = 0.8841565251350403;
        double oilLevel = 0.723391056060791;
        double oilSepTmp = 0.012175381183624268;
        double phaseSepTmp = 0.06291204690933228;
        double suctionPrs = 0.5327414274215698;
        double suctiontmp_M = 0.32043081521987915;
        double suctiontmp_P = 0.6729613542556763;
        double surgeTankTmp = 0.27488642930984497;
        double waterInTmp = 0.3728615641593933;
        double waterOutTmp = 0.9913286566734314;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo6Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6Telemetry));
        Refrig_Cryo6Telemetry item_ = (Refrig_Cryo6Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CipTelemetry() throws Exception {
        double[] cryo_I = TestHelper.generateDoubleArray((int)6, (int)-568503315);
        double[] cryo_Life = TestHelper.generateDoubleArray((int)6, (int)754533135);
        double[] cryo_Usage = TestHelper.generateDoubleArray((int)6, (int)1670933752);
        double[] cryo_V = TestHelper.generateDoubleArray((int)6, (int)1271907432);
        String location = "c";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CipTelemetry(cryo_I, cryo_Life, cryo_Usage, cryo_V, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CipTelemetry));
        Vacuum_CipTelemetry item_ = (Vacuum_CipTelemetry)item;
        Assert.assertArrayEquals((double[])cryo_I, (double[])item_.getCryo_I(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life, (double[])item_.getCryo_Life(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage, (double[])item_.getCryo_Usage(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V, (double[])item_.getCryo_V(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double airPressure = 0.04965662956237793;
        double cryoVac = 0.0604214072227478;
        double flineCurrent = 0.25971394777297974;
        double flinePower = 0.18166548013687134;
        double flineVoltage = 0.15060561895370483;
        double forelineVac = 0.969784677028656;
        double gaugeDose = 0.5768238306045532;
        double pumpCartPressure = 0.723280131816864;
        double turboCurrent = 0.748953f;
        double turboCycleNumber = 0.8426942229270935;
        double turboCycleTime = 0.17643022537231445;
        double turboGaugeDose = 0.48615914583206177;
        double turboHours = 0.5553824305534363;
        double turboPower = 0.8494077324867249;
        double turboPumpStatus = 0.06183946132659912;
        double turboPumpTemp = 0.5651716589927673;
        double turboSpeed = 0.2926744818687439;
        double turboVac = 0.38204145431518555;
        double turboVoltage = 0.7304448485374451;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(airPressure, cryoVac, flineCurrent, flinePower, flineVoltage, forelineVac, gaugeDose, pumpCartPressure, turboCurrent, turboCycleNumber, turboCycleTime, turboGaugeDose, turboHours, turboPower, turboPumpStatus, turboPumpTemp, turboSpeed, turboVac, turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)airPressure, (double)item_.getAirPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoVac, (double)item_.getCryoVac(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugeDose, (double)item_.getGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleNumber, (double)item_.getTurboCycleNumber(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleTime, (double)item_.getTurboCycleTime(), (double)1.0E-6f);
        Assert.assertEquals((double)turboGaugeDose, (double)item_.getTurboGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)turboHours, (double)item_.getTurboHours(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpStatus, (double)item_.getTurboPumpStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HXTelemetry() throws Exception {
        double airPressure = 0.9954877495765686;
        double flineCurrent = 0.965650200843811;
        double flinePower = 0.8986307978630066;
        double flineVoltage = 0.1965857744216919;
        double forelineVac = 0.08702284097671509;
        double gaugeDose = 0.2001015f;
        double hexVac = 0.9886152744293213;
        double pumpCartPressure = 0.33215343952178955;
        double turboCurrent = 0.9479057192802429;
        double turboCycleNumber = 0.5957809686660767;
        double turboCycleTime = 0.03004467487335205;
        double turboGaugeDose = 0.6454641222953796;
        double turboHours = 0.5377201437950134;
        double turboPower = 0.7814640998840332;
        double turboPumpStatus = 0.03719979524612427;
        double turboPumpTemp = 0.5513439178466797;
        double turboSpeed = 0.2702589f;
        double turboVac = 0.766426146030426;
        double turboVoltage = 0.8041006922721863;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_HXTelemetry(airPressure, flineCurrent, flinePower, flineVoltage, forelineVac, gaugeDose, hexVac, pumpCartPressure, turboCurrent, turboCycleNumber, turboCycleTime, turboGaugeDose, turboHours, turboPower, turboPumpStatus, turboPumpTemp, turboSpeed, turboVac, turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HXTelemetry));
        Vacuum_HXTelemetry item_ = (Vacuum_HXTelemetry)item;
        Assert.assertEquals((double)airPressure, (double)item_.getAirPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugeDose, (double)item_.getGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)hexVac, (double)item_.getHexVac(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleNumber, (double)item_.getTurboCycleNumber(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCycleTime, (double)item_.getTurboCycleTime(), (double)1.0E-6f);
        Assert.assertEquals((double)turboGaugeDose, (double)item_.getTurboGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)turboHours, (double)item_.getTurboHours(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpStatus, (double)item_.getTurboPumpStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HipTelemetry() throws Exception {
        double[] hx_I = TestHelper.generateDoubleArray((int)2, (int)-1910799660);
        double[] hx_Life = TestHelper.generateDoubleArray((int)2, (int)-1070253627);
        double[] hx_Usage = TestHelper.generateDoubleArray((int)2, (int)-1981996956);
        double[] hx_V = TestHelper.generateDoubleArray((int)2, (int)-330658050);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_HipTelemetry(hx_I, hx_Life, hx_Usage, hx_V, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HipTelemetry));
        Vacuum_HipTelemetry item_ = (Vacuum_HipTelemetry)item;
        Assert.assertArrayEquals((double[])hx_I, (double[])item_.getHx_I(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life, (double[])item_.getHx_Life(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage, (double[])item_.getHx_Usage(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V, (double[])item_.getHx_V(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_InstTelemetry() throws Exception {
        double cryoFlineValveState = 0.47461992502212524;
        double flineCurrent = 0.2787594199180603;
        double flinePower = 0.15165424346923828;
        double flineVoltage = 0.3499273657798767;
        double hxFlineValveState = 0.4117283225059509;
        double instVac = 0.23782312870025635;
        double pumpCartCycling = 0.38809633255004883;
        double pumpCartPressure = 0.5119433999061584;
        double pumpCartTemperature = 0.18037575483322144;
        double pumpCartVenting = 0.27294737100601196;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_InstTelemetry(cryoFlineValveState, flineCurrent, flinePower, flineVoltage, hxFlineValveState, instVac, pumpCartCycling, pumpCartPressure, pumpCartTemperature, pumpCartVenting));
        Assert.assertTrue((boolean)(item instanceof Vacuum_InstTelemetry));
        Vacuum_InstTelemetry item_ = (Vacuum_InstTelemetry)item;
        Assert.assertEquals((double)cryoFlineValveState, (double)item_.getCryoFlineValveState(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)hxFlineValveState, (double)item_.getHxFlineValveState(), (double)1.0E-6f);
        Assert.assertEquals((double)instVac, (double)item_.getInstVac(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartCycling, (double)item_.getPumpCartCycling(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartTemperature, (double)item_.getPumpCartTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartVenting, (double)item_.getPumpCartVenting(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Reb_TrendingTelemetry() throws Exception {
        long[] driver_errors = TestHelper.generateLongArray((int)71, (int)-327884980);
        long[] driver_received = TestHelper.generateLongArray((int)71, (int)-29633672);
        long[] driver_rx0 = TestHelper.generateLongArray((int)71, (int)-1382439513);
        long[] driver_rx1 = TestHelper.generateLongArray((int)71, (int)1592263117);
        long[] driver_rx2 = TestHelper.generateLongArray((int)71, (int)-290152451);
        long[] driver_rx3 = TestHelper.generateLongArray((int)71, (int)-2034755745);
        long[] firmware_cell_errors = TestHelper.generateLongArray((int)71, (int)1931809978);
        long[] firmware_last_rx = TestHelper.generateLongArray((int)71, (int)-1667431112);
        long[] firmware_last_tx = TestHelper.generateLongArray((int)71, (int)1452150674);
        long[] firmware_link_down = TestHelper.generateLongArray((int)71, (int)-963626698);
        long[] firmware_link_errors = TestHelper.generateLongArray((int)71, (int)-142291839);
        long[] firmware_link_status = TestHelper.generateLongArray((int)71, (int)-130407555);
        long[] firmware_overflow_local0 = TestHelper.generateLongArray((int)71, (int)1315220405);
        long[] firmware_overflow_local1 = TestHelper.generateLongArray((int)71, (int)-882811618);
        long[] firmware_overflow_local2 = TestHelper.generateLongArray((int)71, (int)1111582477);
        long[] firmware_overflow_local3 = TestHelper.generateLongArray((int)71, (int)-372244617);
        long[] firmware_overflow_remote0 = TestHelper.generateLongArray((int)71, (int)-248392182);
        long[] firmware_overflow_remote1 = TestHelper.generateLongArray((int)71, (int)-377857248);
        long[] firmware_overflow_remote2 = TestHelper.generateLongArray((int)71, (int)-1092756634);
        long[] firmware_overflow_remote3 = TestHelper.generateLongArray((int)71, (int)-384758182);
        long[] firmware_rlink_data = TestHelper.generateLongArray((int)71, (int)613986229);
        long[] firmware_rx_clock = TestHelper.generateLongArray((int)71, (int)1127796320);
        long[] firmware_rx_errors = TestHelper.generateLongArray((int)71, (int)-1760579921);
        long[] firmware_rx_frames = TestHelper.generateLongArray((int)71, (int)-661332984);
        long[] firmware_rx_op = TestHelper.generateLongArray((int)71, (int)-1990350562);
        long[] firmware_tx_clock = TestHelper.generateLongArray((int)71, (int)399205267);
        long[] firmware_tx_errors = TestHelper.generateLongArray((int)71, (int)-1192848505);
        long[] firmware_tx_frames = TestHelper.generateLongArray((int)71, (int)-434454365);
        long[] firmware_tx_op = TestHelper.generateLongArray((int)71, (int)-1553937928);
        String location = "s";
        long[] rds_bdi_firsts = TestHelper.generateLongArray((int)71, (int)835312483);
        long[] rds_bdi_frees = TestHelper.generateLongArray((int)71, (int)-1633290882);
        long[] rds_bdi_lasts = TestHelper.generateLongArray((int)71, (int)-1400082465);
        long[] rds_bdi_nulls = TestHelper.generateLongArray((int)71, (int)-370515978);
        long[] rds_bdi_overflows = TestHelper.generateLongArray((int)71, (int)1341482664);
        long[] rds_bdi_seq_errors = TestHelper.generateLongArray((int)71, (int)-840519937);
        long[] rds_bdi_waits = TestHelper.generateLongArray((int)71, (int)1457561536);
        long[] rds_discards = TestHelper.generateLongArray((int)71, (int)1668465225);
        long[] rds_no_event = TestHelper.generateLongArray((int)71, (int)-2117486254);
        long[] rds_wakes = TestHelper.generateLongArray((int)71, (int)1289560733);
        long[] rms_in_reset = TestHelper.generateLongArray((int)71, (int)1562802890);
        long[] rms_inv_tids = TestHelper.generateLongArray((int)71, (int)-1326698964);
        long[] rms_link_down = TestHelper.generateLongArray((int)71, (int)-222852784);
        long[] rms_lists_posted = TestHelper.generateLongArray((int)71, (int)1026586193);
        long[] rms_ops_posted = TestHelper.generateLongArray((int)71, (int)630946823);
        long[] rms_orphans = TestHelper.generateLongArray((int)71, (int)-1343063213);
        long[] rms_probes = TestHelper.generateLongArray((int)71, (int)-675789961);
        long[] rms_responses = TestHelper.generateLongArray((int)71, (int)1290184497);
        long[] rms_rundowns = TestHelper.generateLongArray((int)71, (int)497882891);
        long[] rms_tid_hwm = TestHelper.generateLongArray((int)71, (int)218551942);
        long[] rms_unopened = TestHelper.generateLongArray((int)71, (int)-2082501484);
        long[] rms_waits = TestHelper.generateLongArray((int)71, (int)-2000652555);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Reb_TrendingTelemetry(driver_errors, driver_received, driver_rx0, driver_rx1, driver_rx2, driver_rx3, firmware_cell_errors, firmware_last_rx, firmware_last_tx, firmware_link_down, firmware_link_errors, firmware_link_status, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_local3, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_overflow_remote3, firmware_rlink_data, firmware_rx_clock, firmware_rx_errors, firmware_rx_frames, firmware_rx_op, firmware_tx_clock, firmware_tx_errors, firmware_tx_frames, firmware_tx_op, location, rds_bdi_firsts, rds_bdi_frees, rds_bdi_lasts, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_bdi_waits, rds_discards, rds_no_event, rds_wakes, rms_in_reset, rms_inv_tids, rms_link_down, rms_lists_posted, rms_ops_posted, rms_orphans, rms_probes, rms_responses, rms_rundowns, rms_tid_hwm, rms_unopened, rms_waits));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Reb_TrendingTelemetry));
        Daq_monitor_Reb_TrendingTelemetry item_ = (Daq_monitor_Reb_TrendingTelemetry)item;
        Assert.assertArrayEquals((long[])driver_errors, (long[])item_.getDriver_errors());
        Assert.assertArrayEquals((long[])driver_received, (long[])item_.getDriver_received());
        Assert.assertArrayEquals((long[])driver_rx0, (long[])item_.getDriver_rx0());
        Assert.assertArrayEquals((long[])driver_rx1, (long[])item_.getDriver_rx1());
        Assert.assertArrayEquals((long[])driver_rx2, (long[])item_.getDriver_rx2());
        Assert.assertArrayEquals((long[])driver_rx3, (long[])item_.getDriver_rx3());
        Assert.assertArrayEquals((long[])firmware_cell_errors, (long[])item_.getFirmware_cell_errors());
        Assert.assertArrayEquals((long[])firmware_last_rx, (long[])item_.getFirmware_last_rx());
        Assert.assertArrayEquals((long[])firmware_last_tx, (long[])item_.getFirmware_last_tx());
        Assert.assertArrayEquals((long[])firmware_link_down, (long[])item_.getFirmware_link_down());
        Assert.assertArrayEquals((long[])firmware_link_errors, (long[])item_.getFirmware_link_errors());
        Assert.assertArrayEquals((long[])firmware_link_status, (long[])item_.getFirmware_link_status());
        Assert.assertArrayEquals((long[])firmware_overflow_local0, (long[])item_.getFirmware_overflow_local0());
        Assert.assertArrayEquals((long[])firmware_overflow_local1, (long[])item_.getFirmware_overflow_local1());
        Assert.assertArrayEquals((long[])firmware_overflow_local2, (long[])item_.getFirmware_overflow_local2());
        Assert.assertArrayEquals((long[])firmware_overflow_local3, (long[])item_.getFirmware_overflow_local3());
        Assert.assertArrayEquals((long[])firmware_overflow_remote0, (long[])item_.getFirmware_overflow_remote0());
        Assert.assertArrayEquals((long[])firmware_overflow_remote1, (long[])item_.getFirmware_overflow_remote1());
        Assert.assertArrayEquals((long[])firmware_overflow_remote2, (long[])item_.getFirmware_overflow_remote2());
        Assert.assertArrayEquals((long[])firmware_overflow_remote3, (long[])item_.getFirmware_overflow_remote3());
        Assert.assertArrayEquals((long[])firmware_rlink_data, (long[])item_.getFirmware_rlink_data());
        Assert.assertArrayEquals((long[])firmware_rx_clock, (long[])item_.getFirmware_rx_clock());
        Assert.assertArrayEquals((long[])firmware_rx_errors, (long[])item_.getFirmware_rx_errors());
        Assert.assertArrayEquals((long[])firmware_rx_frames, (long[])item_.getFirmware_rx_frames());
        Assert.assertArrayEquals((long[])firmware_rx_op, (long[])item_.getFirmware_rx_op());
        Assert.assertArrayEquals((long[])firmware_tx_clock, (long[])item_.getFirmware_tx_clock());
        Assert.assertArrayEquals((long[])firmware_tx_errors, (long[])item_.getFirmware_tx_errors());
        Assert.assertArrayEquals((long[])firmware_tx_frames, (long[])item_.getFirmware_tx_frames());
        Assert.assertArrayEquals((long[])firmware_tx_op, (long[])item_.getFirmware_tx_op());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])rds_bdi_firsts, (long[])item_.getRds_bdi_firsts());
        Assert.assertArrayEquals((long[])rds_bdi_frees, (long[])item_.getRds_bdi_frees());
        Assert.assertArrayEquals((long[])rds_bdi_lasts, (long[])item_.getRds_bdi_lasts());
        Assert.assertArrayEquals((long[])rds_bdi_nulls, (long[])item_.getRds_bdi_nulls());
        Assert.assertArrayEquals((long[])rds_bdi_overflows, (long[])item_.getRds_bdi_overflows());
        Assert.assertArrayEquals((long[])rds_bdi_seq_errors, (long[])item_.getRds_bdi_seq_errors());
        Assert.assertArrayEquals((long[])rds_bdi_waits, (long[])item_.getRds_bdi_waits());
        Assert.assertArrayEquals((long[])rds_discards, (long[])item_.getRds_discards());
        Assert.assertArrayEquals((long[])rds_no_event, (long[])item_.getRds_no_event());
        Assert.assertArrayEquals((long[])rds_wakes, (long[])item_.getRds_wakes());
        Assert.assertArrayEquals((long[])rms_in_reset, (long[])item_.getRms_in_reset());
        Assert.assertArrayEquals((long[])rms_inv_tids, (long[])item_.getRms_inv_tids());
        Assert.assertArrayEquals((long[])rms_link_down, (long[])item_.getRms_link_down());
        Assert.assertArrayEquals((long[])rms_lists_posted, (long[])item_.getRms_lists_posted());
        Assert.assertArrayEquals((long[])rms_ops_posted, (long[])item_.getRms_ops_posted());
        Assert.assertArrayEquals((long[])rms_orphans, (long[])item_.getRms_orphans());
        Assert.assertArrayEquals((long[])rms_probes, (long[])item_.getRms_probes());
        Assert.assertArrayEquals((long[])rms_responses, (long[])item_.getRms_responses());
        Assert.assertArrayEquals((long[])rms_rundowns, (long[])item_.getRms_rundowns());
        Assert.assertArrayEquals((long[])rms_tid_hwm, (long[])item_.getRms_tid_hwm());
        Assert.assertArrayEquals((long[])rms_unopened, (long[])item_.getRms_unopened());
        Assert.assertArrayEquals((long[])rms_waits, (long[])item_.getRms_waits());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.3132544159889221;
        double freeFraction = 0.015797853469848633;
        double freeSpace = 0.2513923f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Sum_TrendingTelemetry() throws Exception {
        long driver_errors = 851L;
        long firmware_cell_errors = 224L;
        long firmware_link_down = 425L;
        long firmware_link_errors = 369L;
        long firmware_overflow_local0 = 660L;
        long firmware_overflow_local1 = 351L;
        long firmware_overflow_local2 = 442L;
        long firmware_overflow_remote0 = 224L;
        long firmware_overflow_remote1 = 206L;
        long firmware_overflow_remote2 = 596L;
        long firmware_rx_errors = 180L;
        long firmware_tx_errors = 21L;
        long rds_bdi_nulls = 519L;
        long rds_bdi_overflows = 736L;
        long rds_bdi_seq_errors = 802L;
        long rds_discards = 772L;
        long rds_no_event = 802L;
        long rms_in_reset = 677L;
        long rms_inv_tids = 230L;
        long rms_link_down = 258L;
        long rms_orphans = 741L;
        long rms_unopened = 285L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Sum_TrendingTelemetry(driver_errors, firmware_cell_errors, firmware_link_down, firmware_link_errors, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_rx_errors, firmware_tx_errors, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_discards, rds_no_event, rms_in_reset, rms_inv_tids, rms_link_down, rms_orphans, rms_unopened));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Sum_TrendingTelemetry));
        Daq_monitor_Sum_TrendingTelemetry item_ = (Daq_monitor_Sum_TrendingTelemetry)item;
        Assert.assertEquals((long)driver_errors, (long)item_.getDriver_errors());
        Assert.assertEquals((long)firmware_cell_errors, (long)item_.getFirmware_cell_errors());
        Assert.assertEquals((long)firmware_link_down, (long)item_.getFirmware_link_down());
        Assert.assertEquals((long)firmware_link_errors, (long)item_.getFirmware_link_errors());
        Assert.assertEquals((long)firmware_overflow_local0, (long)item_.getFirmware_overflow_local0());
        Assert.assertEquals((long)firmware_overflow_local1, (long)item_.getFirmware_overflow_local1());
        Assert.assertEquals((long)firmware_overflow_local2, (long)item_.getFirmware_overflow_local2());
        Assert.assertEquals((long)firmware_overflow_remote0, (long)item_.getFirmware_overflow_remote0());
        Assert.assertEquals((long)firmware_overflow_remote1, (long)item_.getFirmware_overflow_remote1());
        Assert.assertEquals((long)firmware_overflow_remote2, (long)item_.getFirmware_overflow_remote2());
        Assert.assertEquals((long)firmware_rx_errors, (long)item_.getFirmware_rx_errors());
        Assert.assertEquals((long)firmware_tx_errors, (long)item_.getFirmware_tx_errors());
        Assert.assertEquals((long)rds_bdi_nulls, (long)item_.getRds_bdi_nulls());
        Assert.assertEquals((long)rds_bdi_overflows, (long)item_.getRds_bdi_overflows());
        Assert.assertEquals((long)rds_bdi_seq_errors, (long)item_.getRds_bdi_seq_errors());
        Assert.assertEquals((long)rds_discards, (long)item_.getRds_discards());
        Assert.assertEquals((long)rds_no_event, (long)item_.getRds_no_event());
        Assert.assertEquals((long)rms_in_reset, (long)item_.getRms_in_reset());
        Assert.assertEquals((long)rms_inv_tids, (long)item_.getRms_inv_tids());
        Assert.assertEquals((long)rms_link_down, (long)item_.getRms_link_down());
        Assert.assertEquals((long)rms_orphans, (long)item_.getRms_orphans());
        Assert.assertEquals((long)rms_unopened, (long)item_.getRms_unopened());
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)201, (int)-1241888939);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)201, (int)-1213186888);
        double[] oDV = TestHelper.generateDoubleArray((int)201, (int)211058237);
        double[] oGV = TestHelper.generateDoubleArray((int)201, (int)-1985602132);
        double[] rDV = TestHelper.generateDoubleArray((int)201, (int)-968421639);
        double[] temp = TestHelper.generateDoubleArray((int)201, (int)-1172590970);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)71, (int)429161164);
        double[] anaV = TestHelper.generateDoubleArray((int)71, (int)-1154926906);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)71, (int)-612844273);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)71, (int)443153569);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)71, (int)1173860189);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)71, (int)1652049480);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)71, (int)-1951319130);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)71, (int)-1359822498);
        double[] clkHI = TestHelper.generateDoubleArray((int)71, (int)-1651842115);
        double[] clkHV = TestHelper.generateDoubleArray((int)71, (int)-63280328);
        double[] clkLI = TestHelper.generateDoubleArray((int)71, (int)-1605376023);
        double[] clkLV = TestHelper.generateDoubleArray((int)71, (int)-314214178);
        double[] digI = TestHelper.generateDoubleArray((int)71, (int)-1282505427);
        double[] digV = TestHelper.generateDoubleArray((int)71, (int)-882091036);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)71, (int)-615406228);
        double[] htrPI = TestHelper.generateDoubleArray((int)71, (int)458058131);
        double[] htrPV = TestHelper.generateDoubleArray((int)71, (int)-1550369127);
        double[] htrV = TestHelper.generateDoubleArray((int)71, (int)1773136898);
        double[] htrW = TestHelper.generateDoubleArray((int)71, (int)-1126083708);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)71, (int)-840736753);
        double[] oDV = TestHelper.generateDoubleArray((int)71, (int)-1450487528);
        double[] pClk0 = TestHelper.generateDoubleArray((int)71, (int)1944699858);
        double[] pClk1 = TestHelper.generateDoubleArray((int)71, (int)954013900);
        double[] pClkL = TestHelper.generateDoubleArray((int)71, (int)-1101346450);
        double[] pClkU = TestHelper.generateDoubleArray((int)71, (int)1412286750);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)800589345);
        double[] rG0 = TestHelper.generateDoubleArray((int)71, (int)1423382503);
        double[] rG1 = TestHelper.generateDoubleArray((int)71, (int)2123779165);
        double[] rGL = TestHelper.generateDoubleArray((int)71, (int)-1652193439);
        double[] rGU = TestHelper.generateDoubleArray((int)71, (int)1515593073);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)71, (int)-1462459344);
        double[] ref05V = TestHelper.generateDoubleArray((int)71, (int)128366975);
        double[] ref125V = TestHelper.generateDoubleArray((int)71, (int)-1345516631);
        double[] ref15V = TestHelper.generateDoubleArray((int)71, (int)-1926008237);
        double[] ref25V = TestHelper.generateDoubleArray((int)71, (int)-198215643);
        double[] refN12 = TestHelper.generateDoubleArray((int)71, (int)522390756);
        double[] refP12 = TestHelper.generateDoubleArray((int)71, (int)427050910);
        double[] sClk0 = TestHelper.generateDoubleArray((int)71, (int)87135863);
        double[] sClk1 = TestHelper.generateDoubleArray((int)71, (int)519549166);
        double[] sClkL = TestHelper.generateDoubleArray((int)71, (int)-678924862);
        double[] sClkU = TestHelper.generateDoubleArray((int)71, (int)-2018757017);
        double[] temp1 = TestHelper.generateDoubleArray((int)71, (int)2105617795);
        double[] temp10 = TestHelper.generateDoubleArray((int)71, (int)1587636380);
        double[] temp2 = TestHelper.generateDoubleArray((int)71, (int)1433269604);
        double[] temp3 = TestHelper.generateDoubleArray((int)71, (int)1126288019);
        double[] temp4 = TestHelper.generateDoubleArray((int)71, (int)1126436645);
        double[] temp5 = TestHelper.generateDoubleArray((int)71, (int)830156981);
        double[] temp6 = TestHelper.generateDoubleArray((int)71, (int)-1128697502);
        double[] temp7 = TestHelper.generateDoubleArray((int)71, (int)-1243654596);
        double[] temp8 = TestHelper.generateDoubleArray((int)71, (int)-223938965);
        double[] temp9 = TestHelper.generateDoubleArray((int)71, (int)1941123312);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClk1, pClkL, pClkU, power, rG0, rG1, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClk0, sClk1, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk1, (double[])item_.getPClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG1, (double[])item_.getRG1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk1, (double[])item_.getSClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.07082492113113403;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6Telemetry() throws Exception {
        double rebsAverageTemp6 = 0.5902376770973206;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebsAverageTemp6Telemetry(rebsAverageTemp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6Telemetry));
        Focal_plane_RebsAverageTemp6Telemetry item_ = (Focal_plane_RebsAverageTemp6Telemetry)item;
        Assert.assertEquals((double)rebsAverageTemp6, (double)item_.getRebsAverageTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)3024, (int)670454353);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_03Telemetry() throws Exception {
        double clp_RTD_03 = 0.941853404045105;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_03Telemetry(clp_RTD_03));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_03Telemetry));
        Mpm_CLP_RTD_03Telemetry item_ = (Mpm_CLP_RTD_03Telemetry)item;
        Assert.assertEquals((double)clp_RTD_03, (double)item_.getClp_RTD_03(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_05Telemetry() throws Exception {
        double clp_RTD_05 = 0.5864506959915161;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_05Telemetry(clp_RTD_05));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_05Telemetry));
        Mpm_CLP_RTD_05Telemetry item_ = (Mpm_CLP_RTD_05Telemetry)item;
        Assert.assertEquals((double)clp_RTD_05, (double)item_.getClp_RTD_05(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_50Telemetry() throws Exception {
        double clp_RTD_50 = 0.79039067029953;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_50Telemetry(clp_RTD_50));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_50Telemetry));
        Mpm_CLP_RTD_50Telemetry item_ = (Mpm_CLP_RTD_50Telemetry)item;
        Assert.assertEquals((double)clp_RTD_50, (double)item_.getClp_RTD_50(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CLP_RTD_55Telemetry() throws Exception {
        double clp_RTD_55 = 0.08456408977508545;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CLP_RTD_55Telemetry(clp_RTD_55));
        Assert.assertTrue((boolean)(item instanceof Mpm_CLP_RTD_55Telemetry));
        Mpm_CLP_RTD_55Telemetry item_ = (Mpm_CLP_RTD_55Telemetry)item;
        Assert.assertEquals((double)clp_RTD_55, (double)item_.getClp_RTD_55(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_12Telemetry() throws Exception {
        double cyp_RTD_12 = 0.672473f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_12Telemetry(cyp_RTD_12));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_12Telemetry));
        Mpm_CYP_RTD_12Telemetry item_ = (Mpm_CYP_RTD_12Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_12, (double)item_.getCyp_RTD_12(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_14Telemetry() throws Exception {
        double cyp_RTD_14 = 0.7774170637130737;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_14Telemetry(cyp_RTD_14));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_14Telemetry));
        Mpm_CYP_RTD_14Telemetry item_ = (Mpm_CYP_RTD_14Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_14, (double)item_.getCyp_RTD_14(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_31Telemetry() throws Exception {
        double cyp_RTD_31 = 0.9600421786308289;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_31Telemetry(cyp_RTD_31));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_31Telemetry));
        Mpm_CYP_RTD_31Telemetry item_ = (Mpm_CYP_RTD_31Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_31, (double)item_.getCyp_RTD_31(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveMpm_CYP_RTD_43Telemetry() throws Exception {
        double cyp_RTD_43 = 0.478396f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Mpm_CYP_RTD_43Telemetry(cyp_RTD_43));
        Assert.assertTrue((boolean)(item instanceof Mpm_CYP_RTD_43Telemetry));
        Mpm_CYP_RTD_43Telemetry item_ = (Mpm_CYP_RTD_43Telemetry)item;
        Assert.assertEquals((double)cyp_RTD_43, (double)item_.getCyp_RTD_43(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Autochanger_AutochangerTrucks_TrendingTelemetry() throws Exception {
        boolean actruckxminus_handoffInError = false;
        boolean actruckxminus_handoffSensorValue = false;
        boolean actruckxminus_onlineInError = true;
        boolean actruckxminus_onlineSensorValue = true;
        boolean actruckxminus_standbyInError = false;
        boolean actruckxminus_standbySensorValue = false;
        boolean actruckxplus_handoffInError = true;
        boolean actruckxplus_handoffSensorValue = true;
        boolean actruckxplus_onlineInError = true;
        boolean actruckxplus_onlineSensorValue = false;
        boolean actruckxplus_standbyInError = false;
        boolean actruckxplus_standbySensorValue = false;
        boolean atHandoff = false;
        boolean atOnline = false;
        boolean atStandby = false;
        int driverPosition = 942;
        int followerPosition = 801;
        boolean homingDone = true;
        boolean inError = false;
        int proximityDistance = 441;
        double proximityVoltage = 0.1304640769958496;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry(actruckxminus_handoffInError, actruckxminus_handoffSensorValue, actruckxminus_onlineInError, actruckxminus_onlineSensorValue, actruckxminus_standbyInError, actruckxminus_standbySensorValue, actruckxplus_handoffInError, actruckxplus_handoffSensorValue, actruckxplus_onlineInError, actruckxplus_onlineSensorValue, actruckxplus_standbyInError, actruckxplus_standbySensorValue, atHandoff, atOnline, atStandby, driverPosition, followerPosition, homingDone, inError, proximityDistance, proximityVoltage));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry));
        Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry item_ = (Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry)item;
        Assert.assertEquals((Object)actruckxminus_handoffInError, (Object)item_.isActruckxminus_handoffInError());
        Assert.assertEquals((Object)actruckxminus_handoffSensorValue, (Object)item_.isActruckxminus_handoffSensorValue());
        Assert.assertEquals((Object)actruckxminus_onlineInError, (Object)item_.isActruckxminus_onlineInError());
        Assert.assertEquals((Object)actruckxminus_onlineSensorValue, (Object)item_.isActruckxminus_onlineSensorValue());
        Assert.assertEquals((Object)actruckxminus_standbyInError, (Object)item_.isActruckxminus_standbyInError());
        Assert.assertEquals((Object)actruckxminus_standbySensorValue, (Object)item_.isActruckxminus_standbySensorValue());
        Assert.assertEquals((Object)actruckxplus_handoffInError, (Object)item_.isActruckxplus_handoffInError());
        Assert.assertEquals((Object)actruckxplus_handoffSensorValue, (Object)item_.isActruckxplus_handoffSensorValue());
        Assert.assertEquals((Object)actruckxplus_onlineInError, (Object)item_.isActruckxplus_onlineInError());
        Assert.assertEquals((Object)actruckxplus_onlineSensorValue, (Object)item_.isActruckxplus_onlineSensorValue());
        Assert.assertEquals((Object)actruckxplus_standbyInError, (Object)item_.isActruckxplus_standbyInError());
        Assert.assertEquals((Object)actruckxplus_standbySensorValue, (Object)item_.isActruckxplus_standbySensorValue());
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atOnline, (Object)item_.isAtOnline());
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((long)driverPosition, (long)item_.getDriverPosition());
        Assert.assertEquals((long)followerPosition, (long)item_.getFollowerPosition());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)proximityDistance, (long)item_.getProximityDistance());
        Assert.assertEquals((double)proximityVoltage, (double)item_.getProximityVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Autochanger_Latches_TrendingTelemetry() throws Exception {
        int filterId = 611;
        String filterName = "v";
        String filterPresenceStatus = "v";
        boolean latchxminus_filterEngagedSensorsInError = false;
        boolean latchxminus_filterPresenceSensorOn = true;
        boolean latchxminus_inError = false;
        boolean latchxminus_lockSensorOn = false;
        boolean latchxminus_lockSensorsInError = true;
        String latchxminus_lockStatus = "";
        boolean latchxminus_unlockSensorOn = false;
        boolean latchxminus_unlockSensorsInError = false;
        boolean latchxplus_filterEngagedSensorsInError = false;
        boolean latchxplus_filterPresenceSensorOn = true;
        boolean latchxplus_inError = false;
        boolean latchxplus_lockSensorOn = true;
        boolean latchxplus_lockSensorsInError = false;
        String latchxplus_lockStatus = "";
        boolean latchxplus_unlockSensorOn = false;
        boolean latchxplus_unlockSensorsInError = false;
        String lockStatus = "w";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_Latches_TrendingTelemetry(filterId, filterName, filterPresenceStatus, latchxminus_filterEngagedSensorsInError, latchxminus_filterPresenceSensorOn, latchxminus_inError, latchxminus_lockSensorOn, latchxminus_lockSensorsInError, latchxminus_lockStatus, latchxminus_unlockSensorOn, latchxminus_unlockSensorsInError, latchxplus_filterEngagedSensorsInError, latchxplus_filterPresenceSensorOn, latchxplus_inError, latchxplus_lockSensorOn, latchxplus_lockSensorsInError, latchxplus_lockStatus, latchxplus_unlockSensorOn, latchxplus_unlockSensorsInError, lockStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_Latches_TrendingTelemetry));
        Fcs_Autochanger_Latches_TrendingTelemetry item_ = (Fcs_Autochanger_Latches_TrendingTelemetry)item;
        Assert.assertEquals((long)filterId, (long)item_.getFilterId());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((Object)latchxminus_filterEngagedSensorsInError, (Object)item_.isLatchxminus_filterEngagedSensorsInError());
        Assert.assertEquals((Object)latchxminus_filterPresenceSensorOn, (Object)item_.isLatchxminus_filterPresenceSensorOn());
        Assert.assertEquals((Object)latchxminus_inError, (Object)item_.isLatchxminus_inError());
        Assert.assertEquals((Object)latchxminus_lockSensorOn, (Object)item_.isLatchxminus_lockSensorOn());
        Assert.assertEquals((Object)latchxminus_lockSensorsInError, (Object)item_.isLatchxminus_lockSensorsInError());
        Assert.assertEquals((Object)latchxminus_lockStatus, (Object)item_.getLatchxminus_lockStatus());
        Assert.assertEquals((Object)latchxminus_unlockSensorOn, (Object)item_.isLatchxminus_unlockSensorOn());
        Assert.assertEquals((Object)latchxminus_unlockSensorsInError, (Object)item_.isLatchxminus_unlockSensorsInError());
        Assert.assertEquals((Object)latchxplus_filterEngagedSensorsInError, (Object)item_.isLatchxplus_filterEngagedSensorsInError());
        Assert.assertEquals((Object)latchxplus_filterPresenceSensorOn, (Object)item_.isLatchxplus_filterPresenceSensorOn());
        Assert.assertEquals((Object)latchxplus_inError, (Object)item_.isLatchxplus_inError());
        Assert.assertEquals((Object)latchxplus_lockSensorOn, (Object)item_.isLatchxplus_lockSensorOn());
        Assert.assertEquals((Object)latchxplus_lockSensorsInError, (Object)item_.isLatchxplus_lockSensorsInError());
        Assert.assertEquals((Object)latchxplus_lockStatus, (Object)item_.getLatchxplus_lockStatus());
        Assert.assertEquals((Object)latchxplus_unlockSensorOn, (Object)item_.isLatchxplus_unlockSensorOn());
        Assert.assertEquals((Object)latchxplus_unlockSensorsInError, (Object)item_.isLatchxplus_unlockSensorsInError());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
    }

    @Test
    public void sendReceiveFcs_Autochanger_OnlineClamps_TrendingTelemetry() throws Exception {
        String lockStatus = "a";
        int onlineClampRawStrain = 278;
        int onlineClampStrain = 648;
        int onlineclampxminus_current = 49;
        boolean onlineclampxminus_inError = false;
        boolean onlineclampxminus_lockSensorInError = false;
        boolean onlineclampxminus_lockSensorOn = false;
        String onlineclampxminus_lockStatus = "g";
        int onlineclampxminus_position = 890;
        int onlineclampxminus_sentCurrent = 973;
        boolean onlineclampxminus_unlockSensorInError = false;
        boolean onlineclampxminus_unlockSensorOn = false;
        int onlineclampxplus_current = 297;
        boolean onlineclampxplus_inError = true;
        boolean onlineclampxplus_lockSensorInError = true;
        boolean onlineclampxplus_lockSensorOn = true;
        String onlineclampxplus_lockStatus = "";
        int onlineclampxplus_position = 306;
        int onlineclampxplus_sentCurrent = 440;
        boolean onlineclampxplus_unlockSensorInError = false;
        boolean onlineclampxplus_unlockSensorOn = false;
        int onlineclampyminus_current = 207;
        boolean onlineclampyminus_inError = true;
        boolean onlineclampyminus_lockSensorInError = false;
        boolean onlineclampyminus_lockSensorOn = false;
        String onlineclampyminus_lockStatus = "";
        int onlineclampyminus_position = 145;
        int onlineclampyminus_sentCurrent = 781;
        boolean onlineclampyminus_unlockSensorInError = false;
        boolean onlineclampyminus_unlockSensorOn = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_OnlineClamps_TrendingTelemetry(lockStatus, onlineClampRawStrain, onlineClampStrain, onlineclampxminus_current, onlineclampxminus_inError, onlineclampxminus_lockSensorInError, onlineclampxminus_lockSensorOn, onlineclampxminus_lockStatus, onlineclampxminus_position, onlineclampxminus_sentCurrent, onlineclampxminus_unlockSensorInError, onlineclampxminus_unlockSensorOn, onlineclampxplus_current, onlineclampxplus_inError, onlineclampxplus_lockSensorInError, onlineclampxplus_lockSensorOn, onlineclampxplus_lockStatus, onlineclampxplus_position, onlineclampxplus_sentCurrent, onlineclampxplus_unlockSensorInError, onlineclampxplus_unlockSensorOn, onlineclampyminus_current, onlineclampyminus_inError, onlineclampyminus_lockSensorInError, onlineclampyminus_lockSensorOn, onlineclampyminus_lockStatus, onlineclampyminus_position, onlineclampyminus_sentCurrent, onlineclampyminus_unlockSensorInError, onlineclampyminus_unlockSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_OnlineClamps_TrendingTelemetry));
        Fcs_Autochanger_OnlineClamps_TrendingTelemetry item_ = (Fcs_Autochanger_OnlineClamps_TrendingTelemetry)item;
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((long)onlineClampRawStrain, (long)item_.getOnlineClampRawStrain());
        Assert.assertEquals((long)onlineClampStrain, (long)item_.getOnlineClampStrain());
        Assert.assertEquals((long)onlineclampxminus_current, (long)item_.getOnlineclampxminus_current());
        Assert.assertEquals((Object)onlineclampxminus_inError, (Object)item_.isOnlineclampxminus_inError());
        Assert.assertEquals((Object)onlineclampxminus_lockSensorInError, (Object)item_.isOnlineclampxminus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampxminus_lockSensorOn, (Object)item_.isOnlineclampxminus_lockSensorOn());
        Assert.assertEquals((Object)onlineclampxminus_lockStatus, (Object)item_.getOnlineclampxminus_lockStatus());
        Assert.assertEquals((long)onlineclampxminus_position, (long)item_.getOnlineclampxminus_position());
        Assert.assertEquals((long)onlineclampxminus_sentCurrent, (long)item_.getOnlineclampxminus_sentCurrent());
        Assert.assertEquals((Object)onlineclampxminus_unlockSensorInError, (Object)item_.isOnlineclampxminus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampxminus_unlockSensorOn, (Object)item_.isOnlineclampxminus_unlockSensorOn());
        Assert.assertEquals((long)onlineclampxplus_current, (long)item_.getOnlineclampxplus_current());
        Assert.assertEquals((Object)onlineclampxplus_inError, (Object)item_.isOnlineclampxplus_inError());
        Assert.assertEquals((Object)onlineclampxplus_lockSensorInError, (Object)item_.isOnlineclampxplus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampxplus_lockSensorOn, (Object)item_.isOnlineclampxplus_lockSensorOn());
        Assert.assertEquals((Object)onlineclampxplus_lockStatus, (Object)item_.getOnlineclampxplus_lockStatus());
        Assert.assertEquals((long)onlineclampxplus_position, (long)item_.getOnlineclampxplus_position());
        Assert.assertEquals((long)onlineclampxplus_sentCurrent, (long)item_.getOnlineclampxplus_sentCurrent());
        Assert.assertEquals((Object)onlineclampxplus_unlockSensorInError, (Object)item_.isOnlineclampxplus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampxplus_unlockSensorOn, (Object)item_.isOnlineclampxplus_unlockSensorOn());
        Assert.assertEquals((long)onlineclampyminus_current, (long)item_.getOnlineclampyminus_current());
        Assert.assertEquals((Object)onlineclampyminus_inError, (Object)item_.isOnlineclampyminus_inError());
        Assert.assertEquals((Object)onlineclampyminus_lockSensorInError, (Object)item_.isOnlineclampyminus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampyminus_lockSensorOn, (Object)item_.isOnlineclampyminus_lockSensorOn());
        Assert.assertEquals((Object)onlineclampyminus_lockStatus, (Object)item_.getOnlineclampyminus_lockStatus());
        Assert.assertEquals((long)onlineclampyminus_position, (long)item_.getOnlineclampyminus_position());
        Assert.assertEquals((long)onlineclampyminus_sentCurrent, (long)item_.getOnlineclampyminus_sentCurrent());
        Assert.assertEquals((Object)onlineclampyminus_unlockSensorInError, (Object)item_.isOnlineclampyminus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampyminus_unlockSensorOn, (Object)item_.isOnlineclampyminus_unlockSensorOn());
    }

    @Test
    public void sendReceiveFcs_Autochanger_TemperaturesTelemetry() throws Exception {
        double tempCellXminus = 0.29047656059265137;
        double tempClampMotorXminus = 0.4523560404777527;
        double tempClampMotorXplus = 0.31406354904174805;
        double tempClampMotorYminus = 0.09653699398040771;
        double tempFrontBox = 0.3442919850349426;
        double tempLinearRailMotorXminus = 0.2486640214920044;
        double tempLinearRailMotorXplus = 0.23160594701766968;
        double tempRearBox = 0.43006718158721924;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_TemperaturesTelemetry(tempCellXminus, tempClampMotorXminus, tempClampMotorXplus, tempClampMotorYminus, tempFrontBox, tempLinearRailMotorXminus, tempLinearRailMotorXplus, tempRearBox));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_TemperaturesTelemetry));
        Fcs_Autochanger_TemperaturesTelemetry item_ = (Fcs_Autochanger_TemperaturesTelemetry)item;
        Assert.assertEquals((double)tempCellXminus, (double)item_.getTempCellXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempClampMotorXminus, (double)item_.getTempClampMotorXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempClampMotorXplus, (double)item_.getTempClampMotorXplus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempClampMotorYminus, (double)item_.getTempClampMotorYminus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempFrontBox, (double)item_.getTempFrontBox(), (double)1.0E-6f);
        Assert.assertEquals((double)tempLinearRailMotorXminus, (double)item_.getTempLinearRailMotorXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempLinearRailMotorXplus, (double)item_.getTempLinearRailMotorXplus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempRearBox, (double)item_.getTempRearBox(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcSensorsGateway_TrendingTelemetry() throws Exception {
        int acAF0b = 714;
        int acAF0s = 339;
        int acAF1b = 107;
        int acAF1s = 595;
        int acAF3b = 33;
        int acAF3s = 491;
        int acAP2b = 896;
        int acAP2s = 698;
        int carouselHoldingFilterSensor0 = 58;
        int carouselHoldingFilterSensor1 = 146;
        int carouselStoppedAtStandby = 122;
        int carouselStoppedAtStandbyC = 914;
        int carousel_CF0 = 489;
        int carousel_CF0_C = 456;
        int carousel_CF1 = 75;
        int carousel_CF1_C = 94;
        int clampedStatusSensor = 203;
        int closeSensorBLatchXminus = 572;
        int closeSensorBLatchXplus = 801;
        int closeSensorLatchXminus = 613;
        int closeSensorLatchXplus = 959;
        int engineeringKey = 255;
        int engineeringkey_C = 82;
        int filterEngagedSensorBLatchXminus = 759;
        int filterEngagedSensorBLatchXplus = 622;
        int filterEngagedSensorLatchXminus = 308;
        int filterEngagedSensorLatchXplus = 561;
        int filterIDSensor0 = 215;
        int filterIDSensor1 = 112;
        int filterIDSensor2 = 811;
        int filterIDSensor3 = 953;
        int filterIDSensor4 = 167;
        int filterIDSensor5 = 725;
        int forceSensor0 = 877;
        int forceSensor1 = 613;
        int handoffPositionSensorBXminus = 810;
        int handoffPositionSensorBXplus = 180;
        int handoffPositionSensorXminus = 985;
        int handoffPositionSensorXplus = 426;
        double inclinometerXminus = 0.6505237221717834;
        double inclinometerXplus = 0.7943531274795532;
        int keyEng = 437;
        int keyEngb = 18;
        int keyLock = 305;
        int keyLockb = 260;
        int lps_0 = 761;
        int lps_1 = 982;
        int lrh_0 = 45;
        int lrh_1 = 953;
        int loaderCarrierRelayStatus = 813;
        int loaderChainPresenceSensor = 887;
        int loaderCloseSensor1 = 389;
        int loaderCloseSensor2 = 180;
        int loaderCloseSensor3 = 194;
        int loaderCloseSensor4 = 449;
        int loaderConnectedSensor = 816;
        int loaderConnectedSensorC = 389;
        int loaderDefaultStatus = 950;
        int loaderEngagedPositionSensor0 = 676;
        int loaderEngagedPositionSensor1 = 597;
        int loaderFilterDistanceSensor = 208;
        int loaderFilterGoodPositionStatus = 473;
        int loaderFilterPresenceSensor0 = 472;
        int loaderFilterPresenceSensor1 = 300;
        int loaderHandoffPositionSensor0 = 154;
        int loaderHandoffPositionSensor1 = 237;
        int loaderHoldingFilterSensor0 = 580;
        int loaderHoldingFilterSensor1 = 579;
        int loaderHooksRelayStatus = 128;
        int loaderOnCameraSensor0 = 290;
        int loaderOnCameraSensor1 = 891;
        int loaderOpenSensor1 = 37;
        int loaderOpenSensor2 = 948;
        int loaderOpenSensor3 = 719;
        int loaderOpenSensor4 = 596;
        int loaderStoragePositionSensor0 = 254;
        int loaderStoragePositionSensor1 = 781;
        int loader_LFD = 485;
        int loader_LFS = 733;
        int lockOut = 769;
        int lockOutShunt = 666;
        int lockout_C = 669;
        int lpmLatchesStatus = 371;
        int lpmLinearRail1Status = 562;
        int lpmLinearRail2Status = 19;
        int lpmOnlineClampsStatus = 554;
        int out_AF0 = 185;
        int out_AF0_C = 735;
        int out_AF1 = 597;
        int out_AF1_C = 873;
        int out_AF3 = 58;
        int out_AF3_C = 233;
        int out_AIN = 391;
        int out_AOL = 957;
        int out_AP1 = 180;
        int out_AP1_C = 785;
        int out_AP2 = 421;
        int out_AP2_C = 639;
        int out_AP3 = 11;
        int out_AP3_C = 989;
        int onlineClampXminusCloseSensor = 913;
        int onlineClampXminusCloseSensorC = 34;
        int onlineClampXminusOpenSensor = 79;
        int onlineClampXminusOpenSensorC = 977;
        int onlineClampXplusCloseSensor = 360;
        int onlineClampXplusCloseSensorC = 332;
        int onlineClampXplusOpenSensor = 276;
        int onlineClampXplusOpenSensorC = 170;
        int onlineClampYminusCloseSensor = 736;
        int onlineClampYminusCloseSensorC = 801;
        int onlineClampYminusOpenSensor = 164;
        int onlineClampYminusOpenSensorC = 511;
        int onlinePositionSensorBXminus = 372;
        int onlinePositionSensorBXplus = 482;
        int onlinePositionSensorXminus = 331;
        int onlinePositionSensorXplus = 280;
        int openSensorBLatchXminus = 874;
        int openSensorBLatchXplus = 243;
        int openSensorLatchXminus = 542;
        int openSensorLatchXplus = 8;
        int overClampedStatusSensor = 250;
        int presenceLoader = 353;
        int presenceloader_C = 968;
        int standbyPositionSensorBXminus = 927;
        int standbyPositionSensorBXplus = 691;
        int standbyPositionSensorXminus = 530;
        int standbyPositionSensorXplus = 187;
        int unclampedStatusSensor = 336;
        int underClampedStatusSensor = 475;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry(acAF0b, acAF0s, acAF1b, acAF1s, acAF3b, acAF3s, acAP2b, acAP2s, carouselHoldingFilterSensor0, carouselHoldingFilterSensor1, carouselStoppedAtStandby, carouselStoppedAtStandbyC, carousel_CF0, carousel_CF0_C, carousel_CF1, carousel_CF1_C, clampedStatusSensor, closeSensorBLatchXminus, closeSensorBLatchXplus, closeSensorLatchXminus, closeSensorLatchXplus, engineeringKey, engineeringkey_C, filterEngagedSensorBLatchXminus, filterEngagedSensorBLatchXplus, filterEngagedSensorLatchXminus, filterEngagedSensorLatchXplus, filterIDSensor0, filterIDSensor1, filterIDSensor2, filterIDSensor3, filterIDSensor4, filterIDSensor5, forceSensor0, forceSensor1, handoffPositionSensorBXminus, handoffPositionSensorBXplus, handoffPositionSensorXminus, handoffPositionSensorXplus, inclinometerXminus, inclinometerXplus, keyEng, keyEngb, keyLock, keyLockb, lps_0, lps_1, lrh_0, lrh_1, loaderCarrierRelayStatus, loaderChainPresenceSensor, loaderCloseSensor1, loaderCloseSensor2, loaderCloseSensor3, loaderCloseSensor4, loaderConnectedSensor, loaderConnectedSensorC, loaderDefaultStatus, loaderEngagedPositionSensor0, loaderEngagedPositionSensor1, loaderFilterDistanceSensor, loaderFilterGoodPositionStatus, loaderFilterPresenceSensor0, loaderFilterPresenceSensor1, loaderHandoffPositionSensor0, loaderHandoffPositionSensor1, loaderHoldingFilterSensor0, loaderHoldingFilterSensor1, loaderHooksRelayStatus, loaderOnCameraSensor0, loaderOnCameraSensor1, loaderOpenSensor1, loaderOpenSensor2, loaderOpenSensor3, loaderOpenSensor4, loaderStoragePositionSensor0, loaderStoragePositionSensor1, loader_LFD, loader_LFS, lockOut, lockOutShunt, lockout_C, lpmLatchesStatus, lpmLinearRail1Status, lpmLinearRail2Status, lpmOnlineClampsStatus, out_AF0, out_AF0_C, out_AF1, out_AF1_C, out_AF3, out_AF3_C, out_AIN, out_AOL, out_AP1, out_AP1_C, out_AP2, out_AP2_C, out_AP3, out_AP3_C, onlineClampXminusCloseSensor, onlineClampXminusCloseSensorC, onlineClampXminusOpenSensor, onlineClampXminusOpenSensorC, onlineClampXplusCloseSensor, onlineClampXplusCloseSensorC, onlineClampXplusOpenSensor, onlineClampXplusOpenSensorC, onlineClampYminusCloseSensor, onlineClampYminusCloseSensorC, onlineClampYminusOpenSensor, onlineClampYminusOpenSensorC, onlinePositionSensorBXminus, onlinePositionSensorBXplus, onlinePositionSensorXminus, onlinePositionSensorXplus, openSensorBLatchXminus, openSensorBLatchXplus, openSensorLatchXminus, openSensorLatchXplus, overClampedStatusSensor, presenceLoader, presenceloader_C, standbyPositionSensorBXminus, standbyPositionSensorBXplus, standbyPositionSensorXminus, standbyPositionSensorXplus, unclampedStatusSensor, underClampedStatusSensor));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry));
        Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry item_ = (Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)acAF0b, (long)item_.getAcAF0b());
        Assert.assertEquals((long)acAF0s, (long)item_.getAcAF0s());
        Assert.assertEquals((long)acAF1b, (long)item_.getAcAF1b());
        Assert.assertEquals((long)acAF1s, (long)item_.getAcAF1s());
        Assert.assertEquals((long)acAF3b, (long)item_.getAcAF3b());
        Assert.assertEquals((long)acAF3s, (long)item_.getAcAF3s());
        Assert.assertEquals((long)acAP2b, (long)item_.getAcAP2b());
        Assert.assertEquals((long)acAP2s, (long)item_.getAcAP2s());
        Assert.assertEquals((long)carouselHoldingFilterSensor0, (long)item_.getCarouselHoldingFilterSensor0());
        Assert.assertEquals((long)carouselHoldingFilterSensor1, (long)item_.getCarouselHoldingFilterSensor1());
        Assert.assertEquals((long)carouselStoppedAtStandby, (long)item_.getCarouselStoppedAtStandby());
        Assert.assertEquals((long)carouselStoppedAtStandbyC, (long)item_.getCarouselStoppedAtStandbyC());
        Assert.assertEquals((long)carousel_CF0, (long)item_.getCarousel_CF0());
        Assert.assertEquals((long)carousel_CF0_C, (long)item_.getCarousel_CF0_C());
        Assert.assertEquals((long)carousel_CF1, (long)item_.getCarousel_CF1());
        Assert.assertEquals((long)carousel_CF1_C, (long)item_.getCarousel_CF1_C());
        Assert.assertEquals((long)clampedStatusSensor, (long)item_.getClampedStatusSensor());
        Assert.assertEquals((long)closeSensorBLatchXminus, (long)item_.getCloseSensorBLatchXminus());
        Assert.assertEquals((long)closeSensorBLatchXplus, (long)item_.getCloseSensorBLatchXplus());
        Assert.assertEquals((long)closeSensorLatchXminus, (long)item_.getCloseSensorLatchXminus());
        Assert.assertEquals((long)closeSensorLatchXplus, (long)item_.getCloseSensorLatchXplus());
        Assert.assertEquals((long)engineeringKey, (long)item_.getEngineeringKey());
        Assert.assertEquals((long)engineeringkey_C, (long)item_.getEngineeringkey_C());
        Assert.assertEquals((long)filterEngagedSensorBLatchXminus, (long)item_.getFilterEngagedSensorBLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorBLatchXplus, (long)item_.getFilterEngagedSensorBLatchXplus());
        Assert.assertEquals((long)filterEngagedSensorLatchXminus, (long)item_.getFilterEngagedSensorLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorLatchXplus, (long)item_.getFilterEngagedSensorLatchXplus());
        Assert.assertEquals((long)filterIDSensor0, (long)item_.getFilterIDSensor0());
        Assert.assertEquals((long)filterIDSensor1, (long)item_.getFilterIDSensor1());
        Assert.assertEquals((long)filterIDSensor2, (long)item_.getFilterIDSensor2());
        Assert.assertEquals((long)filterIDSensor3, (long)item_.getFilterIDSensor3());
        Assert.assertEquals((long)filterIDSensor4, (long)item_.getFilterIDSensor4());
        Assert.assertEquals((long)filterIDSensor5, (long)item_.getFilterIDSensor5());
        Assert.assertEquals((long)forceSensor0, (long)item_.getForceSensor0());
        Assert.assertEquals((long)forceSensor1, (long)item_.getForceSensor1());
        Assert.assertEquals((long)handoffPositionSensorBXminus, (long)item_.getHandoffPositionSensorBXminus());
        Assert.assertEquals((long)handoffPositionSensorBXplus, (long)item_.getHandoffPositionSensorBXplus());
        Assert.assertEquals((long)handoffPositionSensorXminus, (long)item_.getHandoffPositionSensorXminus());
        Assert.assertEquals((long)handoffPositionSensorXplus, (long)item_.getHandoffPositionSensorXplus());
        Assert.assertEquals((double)inclinometerXminus, (double)item_.getInclinometerXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinometerXplus, (double)item_.getInclinometerXplus(), (double)1.0E-6f);
        Assert.assertEquals((long)keyEng, (long)item_.getKeyEng());
        Assert.assertEquals((long)keyEngb, (long)item_.getKeyEngb());
        Assert.assertEquals((long)keyLock, (long)item_.getKeyLock());
        Assert.assertEquals((long)keyLockb, (long)item_.getKeyLockb());
        Assert.assertEquals((long)lps_0, (long)item_.getLps_0());
        Assert.assertEquals((long)lps_1, (long)item_.getLps_1());
        Assert.assertEquals((long)lrh_0, (long)item_.getLrh_0());
        Assert.assertEquals((long)lrh_1, (long)item_.getLrh_1());
        Assert.assertEquals((long)loaderCarrierRelayStatus, (long)item_.getLoaderCarrierRelayStatus());
        Assert.assertEquals((long)loaderChainPresenceSensor, (long)item_.getLoaderChainPresenceSensor());
        Assert.assertEquals((long)loaderCloseSensor1, (long)item_.getLoaderCloseSensor1());
        Assert.assertEquals((long)loaderCloseSensor2, (long)item_.getLoaderCloseSensor2());
        Assert.assertEquals((long)loaderCloseSensor3, (long)item_.getLoaderCloseSensor3());
        Assert.assertEquals((long)loaderCloseSensor4, (long)item_.getLoaderCloseSensor4());
        Assert.assertEquals((long)loaderConnectedSensor, (long)item_.getLoaderConnectedSensor());
        Assert.assertEquals((long)loaderConnectedSensorC, (long)item_.getLoaderConnectedSensorC());
        Assert.assertEquals((long)loaderDefaultStatus, (long)item_.getLoaderDefaultStatus());
        Assert.assertEquals((long)loaderEngagedPositionSensor0, (long)item_.getLoaderEngagedPositionSensor0());
        Assert.assertEquals((long)loaderEngagedPositionSensor1, (long)item_.getLoaderEngagedPositionSensor1());
        Assert.assertEquals((long)loaderFilterDistanceSensor, (long)item_.getLoaderFilterDistanceSensor());
        Assert.assertEquals((long)loaderFilterGoodPositionStatus, (long)item_.getLoaderFilterGoodPositionStatus());
        Assert.assertEquals((long)loaderFilterPresenceSensor0, (long)item_.getLoaderFilterPresenceSensor0());
        Assert.assertEquals((long)loaderFilterPresenceSensor1, (long)item_.getLoaderFilterPresenceSensor1());
        Assert.assertEquals((long)loaderHandoffPositionSensor0, (long)item_.getLoaderHandoffPositionSensor0());
        Assert.assertEquals((long)loaderHandoffPositionSensor1, (long)item_.getLoaderHandoffPositionSensor1());
        Assert.assertEquals((long)loaderHoldingFilterSensor0, (long)item_.getLoaderHoldingFilterSensor0());
        Assert.assertEquals((long)loaderHoldingFilterSensor1, (long)item_.getLoaderHoldingFilterSensor1());
        Assert.assertEquals((long)loaderHooksRelayStatus, (long)item_.getLoaderHooksRelayStatus());
        Assert.assertEquals((long)loaderOnCameraSensor0, (long)item_.getLoaderOnCameraSensor0());
        Assert.assertEquals((long)loaderOnCameraSensor1, (long)item_.getLoaderOnCameraSensor1());
        Assert.assertEquals((long)loaderOpenSensor1, (long)item_.getLoaderOpenSensor1());
        Assert.assertEquals((long)loaderOpenSensor2, (long)item_.getLoaderOpenSensor2());
        Assert.assertEquals((long)loaderOpenSensor3, (long)item_.getLoaderOpenSensor3());
        Assert.assertEquals((long)loaderOpenSensor4, (long)item_.getLoaderOpenSensor4());
        Assert.assertEquals((long)loaderStoragePositionSensor0, (long)item_.getLoaderStoragePositionSensor0());
        Assert.assertEquals((long)loaderStoragePositionSensor1, (long)item_.getLoaderStoragePositionSensor1());
        Assert.assertEquals((long)loader_LFD, (long)item_.getLoader_LFD());
        Assert.assertEquals((long)loader_LFS, (long)item_.getLoader_LFS());
        Assert.assertEquals((long)lockOut, (long)item_.getLockOut());
        Assert.assertEquals((long)lockOutShunt, (long)item_.getLockOutShunt());
        Assert.assertEquals((long)lockout_C, (long)item_.getLockout_C());
        Assert.assertEquals((long)lpmLatchesStatus, (long)item_.getLpmLatchesStatus());
        Assert.assertEquals((long)lpmLinearRail1Status, (long)item_.getLpmLinearRail1Status());
        Assert.assertEquals((long)lpmLinearRail2Status, (long)item_.getLpmLinearRail2Status());
        Assert.assertEquals((long)lpmOnlineClampsStatus, (long)item_.getLpmOnlineClampsStatus());
        Assert.assertEquals((long)out_AF0, (long)item_.getOut_AF0());
        Assert.assertEquals((long)out_AF0_C, (long)item_.getOut_AF0_C());
        Assert.assertEquals((long)out_AF1, (long)item_.getOut_AF1());
        Assert.assertEquals((long)out_AF1_C, (long)item_.getOut_AF1_C());
        Assert.assertEquals((long)out_AF3, (long)item_.getOut_AF3());
        Assert.assertEquals((long)out_AF3_C, (long)item_.getOut_AF3_C());
        Assert.assertEquals((long)out_AIN, (long)item_.getOut_AIN());
        Assert.assertEquals((long)out_AOL, (long)item_.getOut_AOL());
        Assert.assertEquals((long)out_AP1, (long)item_.getOut_AP1());
        Assert.assertEquals((long)out_AP1_C, (long)item_.getOut_AP1_C());
        Assert.assertEquals((long)out_AP2, (long)item_.getOut_AP2());
        Assert.assertEquals((long)out_AP2_C, (long)item_.getOut_AP2_C());
        Assert.assertEquals((long)out_AP3, (long)item_.getOut_AP3());
        Assert.assertEquals((long)out_AP3_C, (long)item_.getOut_AP3_C());
        Assert.assertEquals((long)onlineClampXminusCloseSensor, (long)item_.getOnlineClampXminusCloseSensor());
        Assert.assertEquals((long)onlineClampXminusCloseSensorC, (long)item_.getOnlineClampXminusCloseSensorC());
        Assert.assertEquals((long)onlineClampXminusOpenSensor, (long)item_.getOnlineClampXminusOpenSensor());
        Assert.assertEquals((long)onlineClampXminusOpenSensorC, (long)item_.getOnlineClampXminusOpenSensorC());
        Assert.assertEquals((long)onlineClampXplusCloseSensor, (long)item_.getOnlineClampXplusCloseSensor());
        Assert.assertEquals((long)onlineClampXplusCloseSensorC, (long)item_.getOnlineClampXplusCloseSensorC());
        Assert.assertEquals((long)onlineClampXplusOpenSensor, (long)item_.getOnlineClampXplusOpenSensor());
        Assert.assertEquals((long)onlineClampXplusOpenSensorC, (long)item_.getOnlineClampXplusOpenSensorC());
        Assert.assertEquals((long)onlineClampYminusCloseSensor, (long)item_.getOnlineClampYminusCloseSensor());
        Assert.assertEquals((long)onlineClampYminusCloseSensorC, (long)item_.getOnlineClampYminusCloseSensorC());
        Assert.assertEquals((long)onlineClampYminusOpenSensor, (long)item_.getOnlineClampYminusOpenSensor());
        Assert.assertEquals((long)onlineClampYminusOpenSensorC, (long)item_.getOnlineClampYminusOpenSensorC());
        Assert.assertEquals((long)onlinePositionSensorBXminus, (long)item_.getOnlinePositionSensorBXminus());
        Assert.assertEquals((long)onlinePositionSensorBXplus, (long)item_.getOnlinePositionSensorBXplus());
        Assert.assertEquals((long)onlinePositionSensorXminus, (long)item_.getOnlinePositionSensorXminus());
        Assert.assertEquals((long)onlinePositionSensorXplus, (long)item_.getOnlinePositionSensorXplus());
        Assert.assertEquals((long)openSensorBLatchXminus, (long)item_.getOpenSensorBLatchXminus());
        Assert.assertEquals((long)openSensorBLatchXplus, (long)item_.getOpenSensorBLatchXplus());
        Assert.assertEquals((long)openSensorLatchXminus, (long)item_.getOpenSensorLatchXminus());
        Assert.assertEquals((long)openSensorLatchXplus, (long)item_.getOpenSensorLatchXplus());
        Assert.assertEquals((long)overClampedStatusSensor, (long)item_.getOverClampedStatusSensor());
        Assert.assertEquals((long)presenceLoader, (long)item_.getPresenceLoader());
        Assert.assertEquals((long)presenceloader_C, (long)item_.getPresenceloader_C());
        Assert.assertEquals((long)standbyPositionSensorBXminus, (long)item_.getStandbyPositionSensorBXminus());
        Assert.assertEquals((long)standbyPositionSensorBXplus, (long)item_.getStandbyPositionSensorBXplus());
        Assert.assertEquals((long)standbyPositionSensorXminus, (long)item_.getStandbyPositionSensorXminus());
        Assert.assertEquals((long)standbyPositionSensorXplus, (long)item_.getStandbyPositionSensorXplus());
        Assert.assertEquals((long)unclampedStatusSensor, (long)item_.getUnclampedStatusSensor());
        Assert.assertEquals((long)underClampedStatusSensor, (long)item_.getUnderClampedStatusSensor());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcTruckXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 775;
        boolean brakeActivated = false;
        int current = 594;
        int errorHistoryNB = 866;
        String errorRegister = "h";
        int followingError = 865;
        boolean inError = false;
        int lastErrorCode = 561;
        String lastErrorName = "";
        String mode = "";
        int position = 81;
        long profileAcceleration = 129L;
        long profileDeceleration = 215L;
        long profileVelocity = 281L;
        String state = "";
        int velocity = 903;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry));
        Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcTruckXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 649;
        boolean brakeActivated = true;
        int current = 356;
        int errorHistoryNB = 192;
        String errorRegister = "";
        int followingError = 264;
        boolean inError = false;
        int lastErrorCode = 99;
        String lastErrorName = "";
        String mode = "y";
        int position = 565;
        long profileAcceleration = 920L;
        long profileDeceleration = 382L;
        long profileVelocity = 143L;
        String state = "";
        int velocity = 12;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry));
        Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Accelerobf_TrendingTelemetry() throws Exception {
        double accelerationX = 0.09179002046585083;
        double accelerationY = 0.7231592535972595;
        double accelerationZ = 0.06521821022033691;
        double airmass = 0.01225733757019043;
        double angularVelocityX = 0.4625069f;
        double angularVelocityY = 0.03793919086456299;
        double angularVelocityZ = 0.8818580508232117;
        double azimut = 0.9179002642631531;
        double elevation = 0.13771146535873413;
        int errorHistoryNB = 804;
        String errorRegister = "b";
        double gravity = 0.02939576f;
        boolean inError = false;
        int lastErrorCode = 248;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Accelerobf_TrendingTelemetry(accelerationX, accelerationY, accelerationZ, airmass, angularVelocityX, angularVelocityY, angularVelocityZ, azimut, elevation, errorHistoryNB, errorRegister, gravity, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Accelerobf_TrendingTelemetry));
        Fcs_Canbus0_Accelerobf_TrendingTelemetry item_ = (Fcs_Canbus0_Accelerobf_TrendingTelemetry)item;
        Assert.assertEquals((double)accelerationX, (double)item_.getAccelerationX(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationY, (double)item_.getAccelerationY(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationZ, (double)item_.getAccelerationZ(), (double)1.0E-6f);
        Assert.assertEquals((double)airmass, (double)item_.getAirmass(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityX, (double)item_.getAngularVelocityX(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityY, (double)item_.getAngularVelocityY(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityZ, (double)item_.getAngularVelocityZ(), (double)1.0E-6f);
        Assert.assertEquals((double)azimut, (double)item_.getAzimut(), (double)1.0E-6f);
        Assert.assertEquals((double)elevation, (double)item_.getElevation(), (double)1.0E-6f);
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((double)gravity, (double)item_.getGravity(), (double)1.0E-6f);
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Ai814_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 58;
        String errorRegister = "";
        boolean inError = true;
        int lastErrorCode = 944;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Ai814_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Ai814_TrendingTelemetry));
        Fcs_Canbus0_Ai814_TrendingTelemetry item_ = (Fcs_Canbus0_Ai814_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_BrakeSystemGateway_TrendingTelemetry() throws Exception {
        int acAF0b = 357;
        int acAF0s = 530;
        int acAF1b = 427;
        int acAF1s = 540;
        int acAF3b = 214;
        int acAF3s = 146;
        int acAP2b = 647;
        int acAP2s = 992;
        int carouselHoldingFilterSensor0 = 46;
        int carouselHoldingFilterSensor1 = 699;
        int carouselStoppedAtStandby = 14;
        int carouselStoppedAtStandbyC = 646;
        int carousel_CF0 = 424;
        int carousel_CF0_C = 482;
        int carousel_CF1 = 927;
        int carousel_CF1_C = 205;
        int clampedStatusSensor = 633;
        int closeSensorBLatchXminus = 480;
        int closeSensorBLatchXplus = 53;
        int closeSensorLatchXminus = 252;
        int closeSensorLatchXplus = 989;
        int engineeringKey = 484;
        int engineeringkey_C = 498;
        int filterEngagedSensorBLatchXminus = 981;
        int filterEngagedSensorBLatchXplus = 413;
        int filterEngagedSensorLatchXminus = 538;
        int filterEngagedSensorLatchXplus = 721;
        int filterIDSensor0 = 13;
        int filterIDSensor1 = 135;
        int filterIDSensor2 = 257;
        int filterIDSensor3 = 13;
        int filterIDSensor4 = 409;
        int filterIDSensor5 = 531;
        int forceSensor0 = 514;
        int forceSensor1 = 960;
        int handoffPositionSensorBXminus = 738;
        int handoffPositionSensorBXplus = 45;
        int handoffPositionSensorXminus = 317;
        int handoffPositionSensorXplus = 644;
        double inclinometerXminus = 0.9397711753845215;
        double inclinometerXplus = 0.9006848335266113;
        int keyEng = 718;
        int keyEngb = 888;
        int keyLock = 525;
        int keyLockb = 556;
        int lps_0 = 676;
        int lps_1 = 416;
        int lrh_0 = 729;
        int lrh_1 = 411;
        int loaderCarrierRelayStatus = 642;
        int loaderChainPresenceSensor = 12;
        int loaderCloseSensor1 = 747;
        int loaderCloseSensor2 = 600;
        int loaderCloseSensor3 = 79;
        int loaderCloseSensor4 = 250;
        int loaderConnectedSensor = 399;
        int loaderConnectedSensorC = 465;
        int loaderDefaultStatus = 472;
        int loaderEngagedPositionSensor0 = 98;
        int loaderEngagedPositionSensor1 = 426;
        int loaderFilterDistanceSensor = 530;
        int loaderFilterGoodPositionStatus = 637;
        int loaderFilterPresenceSensor0 = 695;
        int loaderFilterPresenceSensor1 = 170;
        int loaderHandoffPositionSensor0 = 974;
        int loaderHandoffPositionSensor1 = 536;
        int loaderHoldingFilterSensor0 = 861;
        int loaderHoldingFilterSensor1 = 843;
        int loaderHooksRelayStatus = 56;
        int loaderOnCameraSensor0 = 329;
        int loaderOnCameraSensor1 = 299;
        int loaderOpenSensor1 = 84;
        int loaderOpenSensor2 = 43;
        int loaderOpenSensor3 = 919;
        int loaderOpenSensor4 = 919;
        int loaderStoragePositionSensor0 = 176;
        int loaderStoragePositionSensor1 = 722;
        int loader_LFD = 770;
        int loader_LFS = 240;
        int lockOut = 185;
        int lockOutShunt = 284;
        int lockout_C = 932;
        int lpmLatchesStatus = 556;
        int lpmLinearRail1Status = 519;
        int lpmLinearRail2Status = 456;
        int lpmOnlineClampsStatus = 294;
        int out_AF0 = 854;
        int out_AF0_C = 845;
        int out_AF1 = 393;
        int out_AF1_C = 854;
        int out_AF3 = 219;
        int out_AF3_C = 996;
        int out_AIN = 151;
        int out_AOL = 829;
        int out_AP1 = 594;
        int out_AP1_C = 601;
        int out_AP2 = 274;
        int out_AP2_C = 783;
        int out_AP3 = 414;
        int out_AP3_C = 66;
        int onlineClampXminusCloseSensor = 75;
        int onlineClampXminusCloseSensorC = 996;
        int onlineClampXminusOpenSensor = 89;
        int onlineClampXminusOpenSensorC = 999;
        int onlineClampXplusCloseSensor = 88;
        int onlineClampXplusCloseSensorC = 275;
        int onlineClampXplusOpenSensor = 374;
        int onlineClampXplusOpenSensorC = 947;
        int onlineClampYminusCloseSensor = 596;
        int onlineClampYminusCloseSensorC = 798;
        int onlineClampYminusOpenSensor = 267;
        int onlineClampYminusOpenSensorC = 57;
        int onlinePositionSensorBXminus = 81;
        int onlinePositionSensorBXplus = 761;
        int onlinePositionSensorXminus = 353;
        int onlinePositionSensorXplus = 291;
        int openSensorBLatchXminus = 987;
        int openSensorBLatchXplus = 284;
        int openSensorLatchXminus = 170;
        int openSensorLatchXplus = 941;
        int overClampedStatusSensor = 674;
        int presenceLoader = 896;
        int presenceloader_C = 766;
        int standbyPositionSensorBXminus = 344;
        int standbyPositionSensorBXplus = 595;
        int standbyPositionSensorXminus = 182;
        int standbyPositionSensorXplus = 186;
        int unclampedStatusSensor = 19;
        int underClampedStatusSensor = 748;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry(acAF0b, acAF0s, acAF1b, acAF1s, acAF3b, acAF3s, acAP2b, acAP2s, carouselHoldingFilterSensor0, carouselHoldingFilterSensor1, carouselStoppedAtStandby, carouselStoppedAtStandbyC, carousel_CF0, carousel_CF0_C, carousel_CF1, carousel_CF1_C, clampedStatusSensor, closeSensorBLatchXminus, closeSensorBLatchXplus, closeSensorLatchXminus, closeSensorLatchXplus, engineeringKey, engineeringkey_C, filterEngagedSensorBLatchXminus, filterEngagedSensorBLatchXplus, filterEngagedSensorLatchXminus, filterEngagedSensorLatchXplus, filterIDSensor0, filterIDSensor1, filterIDSensor2, filterIDSensor3, filterIDSensor4, filterIDSensor5, forceSensor0, forceSensor1, handoffPositionSensorBXminus, handoffPositionSensorBXplus, handoffPositionSensorXminus, handoffPositionSensorXplus, inclinometerXminus, inclinometerXplus, keyEng, keyEngb, keyLock, keyLockb, lps_0, lps_1, lrh_0, lrh_1, loaderCarrierRelayStatus, loaderChainPresenceSensor, loaderCloseSensor1, loaderCloseSensor2, loaderCloseSensor3, loaderCloseSensor4, loaderConnectedSensor, loaderConnectedSensorC, loaderDefaultStatus, loaderEngagedPositionSensor0, loaderEngagedPositionSensor1, loaderFilterDistanceSensor, loaderFilterGoodPositionStatus, loaderFilterPresenceSensor0, loaderFilterPresenceSensor1, loaderHandoffPositionSensor0, loaderHandoffPositionSensor1, loaderHoldingFilterSensor0, loaderHoldingFilterSensor1, loaderHooksRelayStatus, loaderOnCameraSensor0, loaderOnCameraSensor1, loaderOpenSensor1, loaderOpenSensor2, loaderOpenSensor3, loaderOpenSensor4, loaderStoragePositionSensor0, loaderStoragePositionSensor1, loader_LFD, loader_LFS, lockOut, lockOutShunt, lockout_C, lpmLatchesStatus, lpmLinearRail1Status, lpmLinearRail2Status, lpmOnlineClampsStatus, out_AF0, out_AF0_C, out_AF1, out_AF1_C, out_AF3, out_AF3_C, out_AIN, out_AOL, out_AP1, out_AP1_C, out_AP2, out_AP2_C, out_AP3, out_AP3_C, onlineClampXminusCloseSensor, onlineClampXminusCloseSensorC, onlineClampXminusOpenSensor, onlineClampXminusOpenSensorC, onlineClampXplusCloseSensor, onlineClampXplusCloseSensorC, onlineClampXplusOpenSensor, onlineClampXplusOpenSensorC, onlineClampYminusCloseSensor, onlineClampYminusCloseSensorC, onlineClampYminusOpenSensor, onlineClampYminusOpenSensorC, onlinePositionSensorBXminus, onlinePositionSensorBXplus, onlinePositionSensorXminus, onlinePositionSensorXplus, openSensorBLatchXminus, openSensorBLatchXplus, openSensorLatchXminus, openSensorLatchXplus, overClampedStatusSensor, presenceLoader, presenceloader_C, standbyPositionSensorBXminus, standbyPositionSensorBXplus, standbyPositionSensorXminus, standbyPositionSensorXplus, unclampedStatusSensor, underClampedStatusSensor));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry));
        Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry item_ = (Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)acAF0b, (long)item_.getAcAF0b());
        Assert.assertEquals((long)acAF0s, (long)item_.getAcAF0s());
        Assert.assertEquals((long)acAF1b, (long)item_.getAcAF1b());
        Assert.assertEquals((long)acAF1s, (long)item_.getAcAF1s());
        Assert.assertEquals((long)acAF3b, (long)item_.getAcAF3b());
        Assert.assertEquals((long)acAF3s, (long)item_.getAcAF3s());
        Assert.assertEquals((long)acAP2b, (long)item_.getAcAP2b());
        Assert.assertEquals((long)acAP2s, (long)item_.getAcAP2s());
        Assert.assertEquals((long)carouselHoldingFilterSensor0, (long)item_.getCarouselHoldingFilterSensor0());
        Assert.assertEquals((long)carouselHoldingFilterSensor1, (long)item_.getCarouselHoldingFilterSensor1());
        Assert.assertEquals((long)carouselStoppedAtStandby, (long)item_.getCarouselStoppedAtStandby());
        Assert.assertEquals((long)carouselStoppedAtStandbyC, (long)item_.getCarouselStoppedAtStandbyC());
        Assert.assertEquals((long)carousel_CF0, (long)item_.getCarousel_CF0());
        Assert.assertEquals((long)carousel_CF0_C, (long)item_.getCarousel_CF0_C());
        Assert.assertEquals((long)carousel_CF1, (long)item_.getCarousel_CF1());
        Assert.assertEquals((long)carousel_CF1_C, (long)item_.getCarousel_CF1_C());
        Assert.assertEquals((long)clampedStatusSensor, (long)item_.getClampedStatusSensor());
        Assert.assertEquals((long)closeSensorBLatchXminus, (long)item_.getCloseSensorBLatchXminus());
        Assert.assertEquals((long)closeSensorBLatchXplus, (long)item_.getCloseSensorBLatchXplus());
        Assert.assertEquals((long)closeSensorLatchXminus, (long)item_.getCloseSensorLatchXminus());
        Assert.assertEquals((long)closeSensorLatchXplus, (long)item_.getCloseSensorLatchXplus());
        Assert.assertEquals((long)engineeringKey, (long)item_.getEngineeringKey());
        Assert.assertEquals((long)engineeringkey_C, (long)item_.getEngineeringkey_C());
        Assert.assertEquals((long)filterEngagedSensorBLatchXminus, (long)item_.getFilterEngagedSensorBLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorBLatchXplus, (long)item_.getFilterEngagedSensorBLatchXplus());
        Assert.assertEquals((long)filterEngagedSensorLatchXminus, (long)item_.getFilterEngagedSensorLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorLatchXplus, (long)item_.getFilterEngagedSensorLatchXplus());
        Assert.assertEquals((long)filterIDSensor0, (long)item_.getFilterIDSensor0());
        Assert.assertEquals((long)filterIDSensor1, (long)item_.getFilterIDSensor1());
        Assert.assertEquals((long)filterIDSensor2, (long)item_.getFilterIDSensor2());
        Assert.assertEquals((long)filterIDSensor3, (long)item_.getFilterIDSensor3());
        Assert.assertEquals((long)filterIDSensor4, (long)item_.getFilterIDSensor4());
        Assert.assertEquals((long)filterIDSensor5, (long)item_.getFilterIDSensor5());
        Assert.assertEquals((long)forceSensor0, (long)item_.getForceSensor0());
        Assert.assertEquals((long)forceSensor1, (long)item_.getForceSensor1());
        Assert.assertEquals((long)handoffPositionSensorBXminus, (long)item_.getHandoffPositionSensorBXminus());
        Assert.assertEquals((long)handoffPositionSensorBXplus, (long)item_.getHandoffPositionSensorBXplus());
        Assert.assertEquals((long)handoffPositionSensorXminus, (long)item_.getHandoffPositionSensorXminus());
        Assert.assertEquals((long)handoffPositionSensorXplus, (long)item_.getHandoffPositionSensorXplus());
        Assert.assertEquals((double)inclinometerXminus, (double)item_.getInclinometerXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinometerXplus, (double)item_.getInclinometerXplus(), (double)1.0E-6f);
        Assert.assertEquals((long)keyEng, (long)item_.getKeyEng());
        Assert.assertEquals((long)keyEngb, (long)item_.getKeyEngb());
        Assert.assertEquals((long)keyLock, (long)item_.getKeyLock());
        Assert.assertEquals((long)keyLockb, (long)item_.getKeyLockb());
        Assert.assertEquals((long)lps_0, (long)item_.getLps_0());
        Assert.assertEquals((long)lps_1, (long)item_.getLps_1());
        Assert.assertEquals((long)lrh_0, (long)item_.getLrh_0());
        Assert.assertEquals((long)lrh_1, (long)item_.getLrh_1());
        Assert.assertEquals((long)loaderCarrierRelayStatus, (long)item_.getLoaderCarrierRelayStatus());
        Assert.assertEquals((long)loaderChainPresenceSensor, (long)item_.getLoaderChainPresenceSensor());
        Assert.assertEquals((long)loaderCloseSensor1, (long)item_.getLoaderCloseSensor1());
        Assert.assertEquals((long)loaderCloseSensor2, (long)item_.getLoaderCloseSensor2());
        Assert.assertEquals((long)loaderCloseSensor3, (long)item_.getLoaderCloseSensor3());
        Assert.assertEquals((long)loaderCloseSensor4, (long)item_.getLoaderCloseSensor4());
        Assert.assertEquals((long)loaderConnectedSensor, (long)item_.getLoaderConnectedSensor());
        Assert.assertEquals((long)loaderConnectedSensorC, (long)item_.getLoaderConnectedSensorC());
        Assert.assertEquals((long)loaderDefaultStatus, (long)item_.getLoaderDefaultStatus());
        Assert.assertEquals((long)loaderEngagedPositionSensor0, (long)item_.getLoaderEngagedPositionSensor0());
        Assert.assertEquals((long)loaderEngagedPositionSensor1, (long)item_.getLoaderEngagedPositionSensor1());
        Assert.assertEquals((long)loaderFilterDistanceSensor, (long)item_.getLoaderFilterDistanceSensor());
        Assert.assertEquals((long)loaderFilterGoodPositionStatus, (long)item_.getLoaderFilterGoodPositionStatus());
        Assert.assertEquals((long)loaderFilterPresenceSensor0, (long)item_.getLoaderFilterPresenceSensor0());
        Assert.assertEquals((long)loaderFilterPresenceSensor1, (long)item_.getLoaderFilterPresenceSensor1());
        Assert.assertEquals((long)loaderHandoffPositionSensor0, (long)item_.getLoaderHandoffPositionSensor0());
        Assert.assertEquals((long)loaderHandoffPositionSensor1, (long)item_.getLoaderHandoffPositionSensor1());
        Assert.assertEquals((long)loaderHoldingFilterSensor0, (long)item_.getLoaderHoldingFilterSensor0());
        Assert.assertEquals((long)loaderHoldingFilterSensor1, (long)item_.getLoaderHoldingFilterSensor1());
        Assert.assertEquals((long)loaderHooksRelayStatus, (long)item_.getLoaderHooksRelayStatus());
        Assert.assertEquals((long)loaderOnCameraSensor0, (long)item_.getLoaderOnCameraSensor0());
        Assert.assertEquals((long)loaderOnCameraSensor1, (long)item_.getLoaderOnCameraSensor1());
        Assert.assertEquals((long)loaderOpenSensor1, (long)item_.getLoaderOpenSensor1());
        Assert.assertEquals((long)loaderOpenSensor2, (long)item_.getLoaderOpenSensor2());
        Assert.assertEquals((long)loaderOpenSensor3, (long)item_.getLoaderOpenSensor3());
        Assert.assertEquals((long)loaderOpenSensor4, (long)item_.getLoaderOpenSensor4());
        Assert.assertEquals((long)loaderStoragePositionSensor0, (long)item_.getLoaderStoragePositionSensor0());
        Assert.assertEquals((long)loaderStoragePositionSensor1, (long)item_.getLoaderStoragePositionSensor1());
        Assert.assertEquals((long)loader_LFD, (long)item_.getLoader_LFD());
        Assert.assertEquals((long)loader_LFS, (long)item_.getLoader_LFS());
        Assert.assertEquals((long)lockOut, (long)item_.getLockOut());
        Assert.assertEquals((long)lockOutShunt, (long)item_.getLockOutShunt());
        Assert.assertEquals((long)lockout_C, (long)item_.getLockout_C());
        Assert.assertEquals((long)lpmLatchesStatus, (long)item_.getLpmLatchesStatus());
        Assert.assertEquals((long)lpmLinearRail1Status, (long)item_.getLpmLinearRail1Status());
        Assert.assertEquals((long)lpmLinearRail2Status, (long)item_.getLpmLinearRail2Status());
        Assert.assertEquals((long)lpmOnlineClampsStatus, (long)item_.getLpmOnlineClampsStatus());
        Assert.assertEquals((long)out_AF0, (long)item_.getOut_AF0());
        Assert.assertEquals((long)out_AF0_C, (long)item_.getOut_AF0_C());
        Assert.assertEquals((long)out_AF1, (long)item_.getOut_AF1());
        Assert.assertEquals((long)out_AF1_C, (long)item_.getOut_AF1_C());
        Assert.assertEquals((long)out_AF3, (long)item_.getOut_AF3());
        Assert.assertEquals((long)out_AF3_C, (long)item_.getOut_AF3_C());
        Assert.assertEquals((long)out_AIN, (long)item_.getOut_AIN());
        Assert.assertEquals((long)out_AOL, (long)item_.getOut_AOL());
        Assert.assertEquals((long)out_AP1, (long)item_.getOut_AP1());
        Assert.assertEquals((long)out_AP1_C, (long)item_.getOut_AP1_C());
        Assert.assertEquals((long)out_AP2, (long)item_.getOut_AP2());
        Assert.assertEquals((long)out_AP2_C, (long)item_.getOut_AP2_C());
        Assert.assertEquals((long)out_AP3, (long)item_.getOut_AP3());
        Assert.assertEquals((long)out_AP3_C, (long)item_.getOut_AP3_C());
        Assert.assertEquals((long)onlineClampXminusCloseSensor, (long)item_.getOnlineClampXminusCloseSensor());
        Assert.assertEquals((long)onlineClampXminusCloseSensorC, (long)item_.getOnlineClampXminusCloseSensorC());
        Assert.assertEquals((long)onlineClampXminusOpenSensor, (long)item_.getOnlineClampXminusOpenSensor());
        Assert.assertEquals((long)onlineClampXminusOpenSensorC, (long)item_.getOnlineClampXminusOpenSensorC());
        Assert.assertEquals((long)onlineClampXplusCloseSensor, (long)item_.getOnlineClampXplusCloseSensor());
        Assert.assertEquals((long)onlineClampXplusCloseSensorC, (long)item_.getOnlineClampXplusCloseSensorC());
        Assert.assertEquals((long)onlineClampXplusOpenSensor, (long)item_.getOnlineClampXplusOpenSensor());
        Assert.assertEquals((long)onlineClampXplusOpenSensorC, (long)item_.getOnlineClampXplusOpenSensorC());
        Assert.assertEquals((long)onlineClampYminusCloseSensor, (long)item_.getOnlineClampYminusCloseSensor());
        Assert.assertEquals((long)onlineClampYminusCloseSensorC, (long)item_.getOnlineClampYminusCloseSensorC());
        Assert.assertEquals((long)onlineClampYminusOpenSensor, (long)item_.getOnlineClampYminusOpenSensor());
        Assert.assertEquals((long)onlineClampYminusOpenSensorC, (long)item_.getOnlineClampYminusOpenSensorC());
        Assert.assertEquals((long)onlinePositionSensorBXminus, (long)item_.getOnlinePositionSensorBXminus());
        Assert.assertEquals((long)onlinePositionSensorBXplus, (long)item_.getOnlinePositionSensorBXplus());
        Assert.assertEquals((long)onlinePositionSensorXminus, (long)item_.getOnlinePositionSensorXminus());
        Assert.assertEquals((long)onlinePositionSensorXplus, (long)item_.getOnlinePositionSensorXplus());
        Assert.assertEquals((long)openSensorBLatchXminus, (long)item_.getOpenSensorBLatchXminus());
        Assert.assertEquals((long)openSensorBLatchXplus, (long)item_.getOpenSensorBLatchXplus());
        Assert.assertEquals((long)openSensorLatchXminus, (long)item_.getOpenSensorLatchXminus());
        Assert.assertEquals((long)openSensorLatchXplus, (long)item_.getOpenSensorLatchXplus());
        Assert.assertEquals((long)overClampedStatusSensor, (long)item_.getOverClampedStatusSensor());
        Assert.assertEquals((long)presenceLoader, (long)item_.getPresenceLoader());
        Assert.assertEquals((long)presenceloader_C, (long)item_.getPresenceloader_C());
        Assert.assertEquals((long)standbyPositionSensorBXminus, (long)item_.getStandbyPositionSensorBXminus());
        Assert.assertEquals((long)standbyPositionSensorBXplus, (long)item_.getStandbyPositionSensorBXplus());
        Assert.assertEquals((long)standbyPositionSensorXminus, (long)item_.getStandbyPositionSensorXminus());
        Assert.assertEquals((long)standbyPositionSensorXplus, (long)item_.getStandbyPositionSensorXplus());
        Assert.assertEquals((long)unclampedStatusSensor, (long)item_.getUnclampedStatusSensor());
        Assert.assertEquals((long)underClampedStatusSensor, (long)item_.getUnderClampedStatusSensor());
    }

    @Test
    public void sendReceiveFcs_Canbus0_CarouselController_TrendingTelemetry() throws Exception {
        int averageCurrent = 499;
        boolean brakeActivated = true;
        int current = 628;
        int errorHistoryNB = 994;
        String errorRegister = "y";
        int followingError = 500;
        boolean inError = true;
        int lastErrorCode = 957;
        String lastErrorName = "";
        String mode = "";
        int position = 519;
        long profileAcceleration = 853L;
        long profileDeceleration = 685L;
        long profileVelocity = 797L;
        String state = "n";
        int velocity = 113;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_CarouselController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_CarouselController_TrendingTelemetry));
        Fcs_Canbus0_CarouselController_TrendingTelemetry item_ = (Fcs_Canbus0_CarouselController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ClampXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 267;
        boolean brakeActivated = true;
        int current = 167;
        int errorHistoryNB = 442;
        String errorRegister = "";
        int followingError = 119;
        boolean inError = true;
        int lastErrorCode = 232;
        String lastErrorName = "c";
        String mode = "z";
        int position = 890;
        long profileAcceleration = 255L;
        long profileDeceleration = 832L;
        long profileVelocity = 377L;
        String state = "t";
        int velocity = 962;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ClampXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ClampXminusController_TrendingTelemetry));
        Fcs_Canbus0_ClampXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_ClampXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ClampXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 190;
        boolean brakeActivated = true;
        int current = 31;
        int errorHistoryNB = 210;
        String errorRegister = "";
        int followingError = 814;
        boolean inError = false;
        int lastErrorCode = 155;
        String lastErrorName = "z";
        String mode = "";
        int position = 13;
        long profileAcceleration = 470L;
        long profileDeceleration = 12L;
        long profileVelocity = 517L;
        String state = "n";
        int velocity = 303;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ClampXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ClampXplusController_TrendingTelemetry));
        Fcs_Canbus0_ClampXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_ClampXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Hyttc580_TrendingTelemetry() throws Exception {
        long pdo1 = 733L;
        long pdo2 = 874L;
        long pdo4 = 45L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Hyttc580_TrendingTelemetry(pdo1, pdo2, pdo4));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Hyttc580_TrendingTelemetry));
        Fcs_Canbus0_Hyttc580_TrendingTelemetry item_ = (Fcs_Canbus0_Hyttc580_TrendingTelemetry)item;
        Assert.assertEquals((long)pdo1, (long)item_.getPdo1());
        Assert.assertEquals((long)pdo2, (long)item_.getPdo2());
        Assert.assertEquals((long)pdo4, (long)item_.getPdo4());
    }

    @Test
    public void sendReceiveFcs_Canbus0_LatchXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 580;
        boolean brakeActivated = false;
        int current = 211;
        int errorHistoryNB = 234;
        String errorRegister = "";
        int followingError = 184;
        boolean inError = false;
        int lastErrorCode = 917;
        String lastErrorName = "";
        String mode = "z";
        int position = 102;
        long profileAcceleration = 73L;
        long profileDeceleration = 441L;
        long profileVelocity = 828L;
        String state = "";
        int velocity = 391;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_LatchXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_LatchXminusController_TrendingTelemetry));
        Fcs_Canbus0_LatchXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_LatchXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_LatchXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 367;
        boolean brakeActivated = true;
        int current = 735;
        int errorHistoryNB = 977;
        String errorRegister = "";
        int followingError = 628;
        boolean inError = true;
        int lastErrorCode = 706;
        String lastErrorName = "p";
        String mode = "";
        int position = 842;
        long profileAcceleration = 166L;
        long profileDeceleration = 161L;
        long profileVelocity = 16L;
        String state = "q";
        int velocity = 903;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_LatchXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_LatchXplusController_TrendingTelemetry));
        Fcs_Canbus0_LatchXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_LatchXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 186;
        boolean brakeActivated = true;
        int current = 186;
        int errorHistoryNB = 303;
        String errorRegister = "b";
        int followingError = 374;
        boolean inError = true;
        int lastErrorCode = 932;
        String lastErrorName = "m";
        String mode = "";
        int position = 338;
        long profileAcceleration = 648L;
        long profileDeceleration = 925L;
        long profileVelocity = 524L;
        String state = "";
        int velocity = 913;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 62;
        boolean brakeActivated = false;
        int current = 105;
        int errorHistoryNB = 896;
        String errorRegister = "b";
        int followingError = 980;
        boolean inError = true;
        int lastErrorCode = 881;
        String lastErrorName = "o";
        String mode = "m";
        int position = 195;
        long profileAcceleration = 654L;
        long profileDeceleration = 581L;
        long profileVelocity = 969L;
        String state = "y";
        int velocity = 988;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampYminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 117;
        boolean brakeActivated = false;
        int current = 781;
        int errorHistoryNB = 641;
        String errorRegister = "";
        int followingError = 140;
        boolean inError = true;
        int lastErrorCode = 500;
        String lastErrorName = "k";
        String mode = "";
        int position = 781;
        long profileAcceleration = 247L;
        long profileDeceleration = 287L;
        long profileVelocity = 679L;
        String state = "";
        int velocity = 152;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineStrainGauge_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 206;
        String errorRegister = "";
        boolean inError = true;
        int lastErrorCode = 143;
        String lastErrorName = "s";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry));
        Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 614;
        String errorRegister = "a";
        boolean inError = true;
        int lastErrorCode = 709;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry));
        Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry item_ = (Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Pt100_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 851;
        String errorRegister = "";
        boolean inError = true;
        int lastErrorCode = 363;
        String lastErrorName = "p";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Pt100_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Pt100_TrendingTelemetry));
        Fcs_Canbus0_Pt100_TrendingTelemetry item_ = (Fcs_Canbus0_Pt100_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_TempSensorsDevice1_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 346;
        String errorRegister = "m";
        boolean inError = true;
        int lastErrorCode = 176;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry));
        Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry item_ = (Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_TempSensorsDevice2_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 247;
        String errorRegister = "v";
        boolean inError = true;
        int lastErrorCode = 988;
        String lastErrorName = "u";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry));
        Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry item_ = (Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus1_CarrierController_TrendingTelemetry() throws Exception {
        int averageCurrent = 481;
        boolean brakeActivated = false;
        int current = 94;
        int errorHistoryNB = 40;
        String errorRegister = "b";
        int followingError = 945;
        boolean inError = true;
        int lastErrorCode = 60;
        String lastErrorName = "";
        String mode = "e";
        int position = 624;
        long profileAcceleration = 19L;
        long profileDeceleration = 799L;
        long profileVelocity = 404L;
        String state = "o";
        int velocity = 524;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_CarrierController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_CarrierController_TrendingTelemetry));
        Fcs_Canbus1_CarrierController_TrendingTelemetry item_ = (Fcs_Canbus1_CarrierController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus1_HooksController_TrendingTelemetry() throws Exception {
        int averageCurrent = 102;
        boolean brakeActivated = false;
        int current = 214;
        int errorHistoryNB = 292;
        String errorRegister = "o";
        int followingError = 331;
        boolean inError = false;
        int lastErrorCode = 641;
        String lastErrorName = "c";
        String mode = "";
        int position = 421;
        long profileAcceleration = 129L;
        long profileDeceleration = 813L;
        long profileVelocity = 643L;
        String state = "";
        int velocity = 266;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_HooksController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_HooksController_TrendingTelemetry));
        Fcs_Canbus1_HooksController_TrendingTelemetry item_ = (Fcs_Canbus1_HooksController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry() throws Exception {
        int acAF0b = 753;
        int acAF0s = 831;
        int acAF1b = 501;
        int acAF1s = 993;
        int acAF3b = 581;
        int acAF3s = 212;
        int acAP2b = 814;
        int acAP2s = 784;
        int carouselHoldingFilterSensor0 = 420;
        int carouselHoldingFilterSensor1 = 596;
        int carouselStoppedAtStandby = 519;
        int carouselStoppedAtStandbyC = 568;
        int carousel_CF0 = 830;
        int carousel_CF0_C = 650;
        int carousel_CF1 = 905;
        int carousel_CF1_C = 38;
        int clampedStatusSensor = 828;
        int closeSensorBLatchXminus = 529;
        int closeSensorBLatchXplus = 134;
        int closeSensorLatchXminus = 845;
        int closeSensorLatchXplus = 221;
        int engineeringKey = 278;
        int engineeringkey_C = 482;
        int filterEngagedSensorBLatchXminus = 585;
        int filterEngagedSensorBLatchXplus = 127;
        int filterEngagedSensorLatchXminus = 435;
        int filterEngagedSensorLatchXplus = 614;
        int filterIDSensor0 = 27;
        int filterIDSensor1 = 290;
        int filterIDSensor2 = 528;
        int filterIDSensor3 = 127;
        int filterIDSensor4 = 990;
        int filterIDSensor5 = 54;
        int forceSensor0 = 152;
        int forceSensor1 = 677;
        int handoffPositionSensorBXminus = 604;
        int handoffPositionSensorBXplus = 220;
        int handoffPositionSensorXminus = 685;
        int handoffPositionSensorXplus = 968;
        double inclinometerXminus = 0.2994155287742615;
        double inclinometerXplus = 0.844681441783905;
        int keyEng = 513;
        int keyEngb = 261;
        int keyLock = 982;
        int keyLockb = 696;
        int lps_0 = 859;
        int lps_1 = 478;
        int lrh_0 = 122;
        int lrh_1 = 56;
        int loaderCarrierRelayStatus = 418;
        int loaderChainPresenceSensor = 432;
        int loaderCloseSensor1 = 440;
        int loaderCloseSensor2 = 307;
        int loaderCloseSensor3 = 153;
        int loaderCloseSensor4 = 478;
        int loaderConnectedSensor = 800;
        int loaderConnectedSensorC = 29;
        int loaderDefaultStatus = 495;
        int loaderEngagedPositionSensor0 = 755;
        int loaderEngagedPositionSensor1 = 963;
        int loaderFilterDistanceSensor = 346;
        int loaderFilterGoodPositionStatus = 930;
        int loaderFilterPresenceSensor0 = 468;
        int loaderFilterPresenceSensor1 = 86;
        int loaderHandoffPositionSensor0 = 219;
        int loaderHandoffPositionSensor1 = 919;
        int loaderHoldingFilterSensor0 = 899;
        int loaderHoldingFilterSensor1 = 202;
        int loaderHooksRelayStatus = 113;
        int loaderOnCameraSensor0 = 384;
        int loaderOnCameraSensor1 = 880;
        int loaderOpenSensor1 = 740;
        int loaderOpenSensor2 = 370;
        int loaderOpenSensor3 = 210;
        int loaderOpenSensor4 = 994;
        int loaderStoragePositionSensor0 = 852;
        int loaderStoragePositionSensor1 = 592;
        int loader_LFD = 546;
        int loader_LFS = 979;
        int lockOut = 252;
        int lockOutShunt = 223;
        int lockout_C = 788;
        int lpmLatchesStatus = 386;
        int lpmLinearRail1Status = 455;
        int lpmLinearRail2Status = 495;
        int lpmOnlineClampsStatus = 520;
        int out_AF0 = 378;
        int out_AF0_C = 419;
        int out_AF1 = 439;
        int out_AF1_C = 177;
        int out_AF3 = 16;
        int out_AF3_C = 780;
        int out_AIN = 899;
        int out_AOL = 563;
        int out_AP1 = 354;
        int out_AP1_C = 567;
        int out_AP2 = 548;
        int out_AP2_C = 609;
        int out_AP3 = 258;
        int out_AP3_C = 767;
        int onlineClampXminusCloseSensor = 254;
        int onlineClampXminusCloseSensorC = 960;
        int onlineClampXminusOpenSensor = 626;
        int onlineClampXminusOpenSensorC = 72;
        int onlineClampXplusCloseSensor = 991;
        int onlineClampXplusCloseSensorC = 235;
        int onlineClampXplusOpenSensor = 97;
        int onlineClampXplusOpenSensorC = 950;
        int onlineClampYminusCloseSensor = 666;
        int onlineClampYminusCloseSensorC = 75;
        int onlineClampYminusOpenSensor = 963;
        int onlineClampYminusOpenSensorC = 936;
        int onlinePositionSensorBXminus = 899;
        int onlinePositionSensorBXplus = 907;
        int onlinePositionSensorXminus = 255;
        int onlinePositionSensorXplus = 607;
        int openSensorBLatchXminus = 806;
        int openSensorBLatchXplus = 94;
        int openSensorLatchXminus = 314;
        int openSensorLatchXplus = 181;
        int overClampedStatusSensor = 56;
        int presenceLoader = 165;
        int presenceloader_C = 802;
        int standbyPositionSensorBXminus = 756;
        int standbyPositionSensorBXplus = 239;
        int standbyPositionSensorXminus = 41;
        int standbyPositionSensorXplus = 813;
        int unclampedStatusSensor = 132;
        int underClampedStatusSensor = 854;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry(acAF0b, acAF0s, acAF1b, acAF1s, acAF3b, acAF3s, acAP2b, acAP2s, carouselHoldingFilterSensor0, carouselHoldingFilterSensor1, carouselStoppedAtStandby, carouselStoppedAtStandbyC, carousel_CF0, carousel_CF0_C, carousel_CF1, carousel_CF1_C, clampedStatusSensor, closeSensorBLatchXminus, closeSensorBLatchXplus, closeSensorLatchXminus, closeSensorLatchXplus, engineeringKey, engineeringkey_C, filterEngagedSensorBLatchXminus, filterEngagedSensorBLatchXplus, filterEngagedSensorLatchXminus, filterEngagedSensorLatchXplus, filterIDSensor0, filterIDSensor1, filterIDSensor2, filterIDSensor3, filterIDSensor4, filterIDSensor5, forceSensor0, forceSensor1, handoffPositionSensorBXminus, handoffPositionSensorBXplus, handoffPositionSensorXminus, handoffPositionSensorXplus, inclinometerXminus, inclinometerXplus, keyEng, keyEngb, keyLock, keyLockb, lps_0, lps_1, lrh_0, lrh_1, loaderCarrierRelayStatus, loaderChainPresenceSensor, loaderCloseSensor1, loaderCloseSensor2, loaderCloseSensor3, loaderCloseSensor4, loaderConnectedSensor, loaderConnectedSensorC, loaderDefaultStatus, loaderEngagedPositionSensor0, loaderEngagedPositionSensor1, loaderFilterDistanceSensor, loaderFilterGoodPositionStatus, loaderFilterPresenceSensor0, loaderFilterPresenceSensor1, loaderHandoffPositionSensor0, loaderHandoffPositionSensor1, loaderHoldingFilterSensor0, loaderHoldingFilterSensor1, loaderHooksRelayStatus, loaderOnCameraSensor0, loaderOnCameraSensor1, loaderOpenSensor1, loaderOpenSensor2, loaderOpenSensor3, loaderOpenSensor4, loaderStoragePositionSensor0, loaderStoragePositionSensor1, loader_LFD, loader_LFS, lockOut, lockOutShunt, lockout_C, lpmLatchesStatus, lpmLinearRail1Status, lpmLinearRail2Status, lpmOnlineClampsStatus, out_AF0, out_AF0_C, out_AF1, out_AF1_C, out_AF3, out_AF3_C, out_AIN, out_AOL, out_AP1, out_AP1_C, out_AP2, out_AP2_C, out_AP3, out_AP3_C, onlineClampXminusCloseSensor, onlineClampXminusCloseSensorC, onlineClampXminusOpenSensor, onlineClampXminusOpenSensorC, onlineClampXplusCloseSensor, onlineClampXplusCloseSensorC, onlineClampXplusOpenSensor, onlineClampXplusOpenSensorC, onlineClampYminusCloseSensor, onlineClampYminusCloseSensorC, onlineClampYminusOpenSensor, onlineClampYminusOpenSensorC, onlinePositionSensorBXminus, onlinePositionSensorBXplus, onlinePositionSensorXminus, onlinePositionSensorXplus, openSensorBLatchXminus, openSensorBLatchXplus, openSensorLatchXminus, openSensorLatchXplus, overClampedStatusSensor, presenceLoader, presenceloader_C, standbyPositionSensorBXminus, standbyPositionSensorBXplus, standbyPositionSensorXminus, standbyPositionSensorXplus, unclampedStatusSensor, underClampedStatusSensor));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry));
        Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry item_ = (Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)acAF0b, (long)item_.getAcAF0b());
        Assert.assertEquals((long)acAF0s, (long)item_.getAcAF0s());
        Assert.assertEquals((long)acAF1b, (long)item_.getAcAF1b());
        Assert.assertEquals((long)acAF1s, (long)item_.getAcAF1s());
        Assert.assertEquals((long)acAF3b, (long)item_.getAcAF3b());
        Assert.assertEquals((long)acAF3s, (long)item_.getAcAF3s());
        Assert.assertEquals((long)acAP2b, (long)item_.getAcAP2b());
        Assert.assertEquals((long)acAP2s, (long)item_.getAcAP2s());
        Assert.assertEquals((long)carouselHoldingFilterSensor0, (long)item_.getCarouselHoldingFilterSensor0());
        Assert.assertEquals((long)carouselHoldingFilterSensor1, (long)item_.getCarouselHoldingFilterSensor1());
        Assert.assertEquals((long)carouselStoppedAtStandby, (long)item_.getCarouselStoppedAtStandby());
        Assert.assertEquals((long)carouselStoppedAtStandbyC, (long)item_.getCarouselStoppedAtStandbyC());
        Assert.assertEquals((long)carousel_CF0, (long)item_.getCarousel_CF0());
        Assert.assertEquals((long)carousel_CF0_C, (long)item_.getCarousel_CF0_C());
        Assert.assertEquals((long)carousel_CF1, (long)item_.getCarousel_CF1());
        Assert.assertEquals((long)carousel_CF1_C, (long)item_.getCarousel_CF1_C());
        Assert.assertEquals((long)clampedStatusSensor, (long)item_.getClampedStatusSensor());
        Assert.assertEquals((long)closeSensorBLatchXminus, (long)item_.getCloseSensorBLatchXminus());
        Assert.assertEquals((long)closeSensorBLatchXplus, (long)item_.getCloseSensorBLatchXplus());
        Assert.assertEquals((long)closeSensorLatchXminus, (long)item_.getCloseSensorLatchXminus());
        Assert.assertEquals((long)closeSensorLatchXplus, (long)item_.getCloseSensorLatchXplus());
        Assert.assertEquals((long)engineeringKey, (long)item_.getEngineeringKey());
        Assert.assertEquals((long)engineeringkey_C, (long)item_.getEngineeringkey_C());
        Assert.assertEquals((long)filterEngagedSensorBLatchXminus, (long)item_.getFilterEngagedSensorBLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorBLatchXplus, (long)item_.getFilterEngagedSensorBLatchXplus());
        Assert.assertEquals((long)filterEngagedSensorLatchXminus, (long)item_.getFilterEngagedSensorLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorLatchXplus, (long)item_.getFilterEngagedSensorLatchXplus());
        Assert.assertEquals((long)filterIDSensor0, (long)item_.getFilterIDSensor0());
        Assert.assertEquals((long)filterIDSensor1, (long)item_.getFilterIDSensor1());
        Assert.assertEquals((long)filterIDSensor2, (long)item_.getFilterIDSensor2());
        Assert.assertEquals((long)filterIDSensor3, (long)item_.getFilterIDSensor3());
        Assert.assertEquals((long)filterIDSensor4, (long)item_.getFilterIDSensor4());
        Assert.assertEquals((long)filterIDSensor5, (long)item_.getFilterIDSensor5());
        Assert.assertEquals((long)forceSensor0, (long)item_.getForceSensor0());
        Assert.assertEquals((long)forceSensor1, (long)item_.getForceSensor1());
        Assert.assertEquals((long)handoffPositionSensorBXminus, (long)item_.getHandoffPositionSensorBXminus());
        Assert.assertEquals((long)handoffPositionSensorBXplus, (long)item_.getHandoffPositionSensorBXplus());
        Assert.assertEquals((long)handoffPositionSensorXminus, (long)item_.getHandoffPositionSensorXminus());
        Assert.assertEquals((long)handoffPositionSensorXplus, (long)item_.getHandoffPositionSensorXplus());
        Assert.assertEquals((double)inclinometerXminus, (double)item_.getInclinometerXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinometerXplus, (double)item_.getInclinometerXplus(), (double)1.0E-6f);
        Assert.assertEquals((long)keyEng, (long)item_.getKeyEng());
        Assert.assertEquals((long)keyEngb, (long)item_.getKeyEngb());
        Assert.assertEquals((long)keyLock, (long)item_.getKeyLock());
        Assert.assertEquals((long)keyLockb, (long)item_.getKeyLockb());
        Assert.assertEquals((long)lps_0, (long)item_.getLps_0());
        Assert.assertEquals((long)lps_1, (long)item_.getLps_1());
        Assert.assertEquals((long)lrh_0, (long)item_.getLrh_0());
        Assert.assertEquals((long)lrh_1, (long)item_.getLrh_1());
        Assert.assertEquals((long)loaderCarrierRelayStatus, (long)item_.getLoaderCarrierRelayStatus());
        Assert.assertEquals((long)loaderChainPresenceSensor, (long)item_.getLoaderChainPresenceSensor());
        Assert.assertEquals((long)loaderCloseSensor1, (long)item_.getLoaderCloseSensor1());
        Assert.assertEquals((long)loaderCloseSensor2, (long)item_.getLoaderCloseSensor2());
        Assert.assertEquals((long)loaderCloseSensor3, (long)item_.getLoaderCloseSensor3());
        Assert.assertEquals((long)loaderCloseSensor4, (long)item_.getLoaderCloseSensor4());
        Assert.assertEquals((long)loaderConnectedSensor, (long)item_.getLoaderConnectedSensor());
        Assert.assertEquals((long)loaderConnectedSensorC, (long)item_.getLoaderConnectedSensorC());
        Assert.assertEquals((long)loaderDefaultStatus, (long)item_.getLoaderDefaultStatus());
        Assert.assertEquals((long)loaderEngagedPositionSensor0, (long)item_.getLoaderEngagedPositionSensor0());
        Assert.assertEquals((long)loaderEngagedPositionSensor1, (long)item_.getLoaderEngagedPositionSensor1());
        Assert.assertEquals((long)loaderFilterDistanceSensor, (long)item_.getLoaderFilterDistanceSensor());
        Assert.assertEquals((long)loaderFilterGoodPositionStatus, (long)item_.getLoaderFilterGoodPositionStatus());
        Assert.assertEquals((long)loaderFilterPresenceSensor0, (long)item_.getLoaderFilterPresenceSensor0());
        Assert.assertEquals((long)loaderFilterPresenceSensor1, (long)item_.getLoaderFilterPresenceSensor1());
        Assert.assertEquals((long)loaderHandoffPositionSensor0, (long)item_.getLoaderHandoffPositionSensor0());
        Assert.assertEquals((long)loaderHandoffPositionSensor1, (long)item_.getLoaderHandoffPositionSensor1());
        Assert.assertEquals((long)loaderHoldingFilterSensor0, (long)item_.getLoaderHoldingFilterSensor0());
        Assert.assertEquals((long)loaderHoldingFilterSensor1, (long)item_.getLoaderHoldingFilterSensor1());
        Assert.assertEquals((long)loaderHooksRelayStatus, (long)item_.getLoaderHooksRelayStatus());
        Assert.assertEquals((long)loaderOnCameraSensor0, (long)item_.getLoaderOnCameraSensor0());
        Assert.assertEquals((long)loaderOnCameraSensor1, (long)item_.getLoaderOnCameraSensor1());
        Assert.assertEquals((long)loaderOpenSensor1, (long)item_.getLoaderOpenSensor1());
        Assert.assertEquals((long)loaderOpenSensor2, (long)item_.getLoaderOpenSensor2());
        Assert.assertEquals((long)loaderOpenSensor3, (long)item_.getLoaderOpenSensor3());
        Assert.assertEquals((long)loaderOpenSensor4, (long)item_.getLoaderOpenSensor4());
        Assert.assertEquals((long)loaderStoragePositionSensor0, (long)item_.getLoaderStoragePositionSensor0());
        Assert.assertEquals((long)loaderStoragePositionSensor1, (long)item_.getLoaderStoragePositionSensor1());
        Assert.assertEquals((long)loader_LFD, (long)item_.getLoader_LFD());
        Assert.assertEquals((long)loader_LFS, (long)item_.getLoader_LFS());
        Assert.assertEquals((long)lockOut, (long)item_.getLockOut());
        Assert.assertEquals((long)lockOutShunt, (long)item_.getLockOutShunt());
        Assert.assertEquals((long)lockout_C, (long)item_.getLockout_C());
        Assert.assertEquals((long)lpmLatchesStatus, (long)item_.getLpmLatchesStatus());
        Assert.assertEquals((long)lpmLinearRail1Status, (long)item_.getLpmLinearRail1Status());
        Assert.assertEquals((long)lpmLinearRail2Status, (long)item_.getLpmLinearRail2Status());
        Assert.assertEquals((long)lpmOnlineClampsStatus, (long)item_.getLpmOnlineClampsStatus());
        Assert.assertEquals((long)out_AF0, (long)item_.getOut_AF0());
        Assert.assertEquals((long)out_AF0_C, (long)item_.getOut_AF0_C());
        Assert.assertEquals((long)out_AF1, (long)item_.getOut_AF1());
        Assert.assertEquals((long)out_AF1_C, (long)item_.getOut_AF1_C());
        Assert.assertEquals((long)out_AF3, (long)item_.getOut_AF3());
        Assert.assertEquals((long)out_AF3_C, (long)item_.getOut_AF3_C());
        Assert.assertEquals((long)out_AIN, (long)item_.getOut_AIN());
        Assert.assertEquals((long)out_AOL, (long)item_.getOut_AOL());
        Assert.assertEquals((long)out_AP1, (long)item_.getOut_AP1());
        Assert.assertEquals((long)out_AP1_C, (long)item_.getOut_AP1_C());
        Assert.assertEquals((long)out_AP2, (long)item_.getOut_AP2());
        Assert.assertEquals((long)out_AP2_C, (long)item_.getOut_AP2_C());
        Assert.assertEquals((long)out_AP3, (long)item_.getOut_AP3());
        Assert.assertEquals((long)out_AP3_C, (long)item_.getOut_AP3_C());
        Assert.assertEquals((long)onlineClampXminusCloseSensor, (long)item_.getOnlineClampXminusCloseSensor());
        Assert.assertEquals((long)onlineClampXminusCloseSensorC, (long)item_.getOnlineClampXminusCloseSensorC());
        Assert.assertEquals((long)onlineClampXminusOpenSensor, (long)item_.getOnlineClampXminusOpenSensor());
        Assert.assertEquals((long)onlineClampXminusOpenSensorC, (long)item_.getOnlineClampXminusOpenSensorC());
        Assert.assertEquals((long)onlineClampXplusCloseSensor, (long)item_.getOnlineClampXplusCloseSensor());
        Assert.assertEquals((long)onlineClampXplusCloseSensorC, (long)item_.getOnlineClampXplusCloseSensorC());
        Assert.assertEquals((long)onlineClampXplusOpenSensor, (long)item_.getOnlineClampXplusOpenSensor());
        Assert.assertEquals((long)onlineClampXplusOpenSensorC, (long)item_.getOnlineClampXplusOpenSensorC());
        Assert.assertEquals((long)onlineClampYminusCloseSensor, (long)item_.getOnlineClampYminusCloseSensor());
        Assert.assertEquals((long)onlineClampYminusCloseSensorC, (long)item_.getOnlineClampYminusCloseSensorC());
        Assert.assertEquals((long)onlineClampYminusOpenSensor, (long)item_.getOnlineClampYminusOpenSensor());
        Assert.assertEquals((long)onlineClampYminusOpenSensorC, (long)item_.getOnlineClampYminusOpenSensorC());
        Assert.assertEquals((long)onlinePositionSensorBXminus, (long)item_.getOnlinePositionSensorBXminus());
        Assert.assertEquals((long)onlinePositionSensorBXplus, (long)item_.getOnlinePositionSensorBXplus());
        Assert.assertEquals((long)onlinePositionSensorXminus, (long)item_.getOnlinePositionSensorXminus());
        Assert.assertEquals((long)onlinePositionSensorXplus, (long)item_.getOnlinePositionSensorXplus());
        Assert.assertEquals((long)openSensorBLatchXminus, (long)item_.getOpenSensorBLatchXminus());
        Assert.assertEquals((long)openSensorBLatchXplus, (long)item_.getOpenSensorBLatchXplus());
        Assert.assertEquals((long)openSensorLatchXminus, (long)item_.getOpenSensorLatchXminus());
        Assert.assertEquals((long)openSensorLatchXplus, (long)item_.getOpenSensorLatchXplus());
        Assert.assertEquals((long)overClampedStatusSensor, (long)item_.getOverClampedStatusSensor());
        Assert.assertEquals((long)presenceLoader, (long)item_.getPresenceLoader());
        Assert.assertEquals((long)presenceloader_C, (long)item_.getPresenceloader_C());
        Assert.assertEquals((long)standbyPositionSensorBXminus, (long)item_.getStandbyPositionSensorBXminus());
        Assert.assertEquals((long)standbyPositionSensorBXplus, (long)item_.getStandbyPositionSensorBXplus());
        Assert.assertEquals((long)standbyPositionSensorXminus, (long)item_.getStandbyPositionSensorXminus());
        Assert.assertEquals((long)standbyPositionSensorXplus, (long)item_.getStandbyPositionSensorXplus());
        Assert.assertEquals((long)unclampedStatusSensor, (long)item_.getUnclampedStatusSensor());
        Assert.assertEquals((long)underClampedStatusSensor, (long)item_.getUnderClampedStatusSensor());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket1_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        String clampxminus1_clampState = "";
        int clampxminus1_filterPositionSensorValue = 799;
        int clampxminus1_filterPresenceOffset2 = 912;
        String clampxminus1_filterPresenceStatus = "d";
        int clampxminus1_lockSensorOffset1 = 869;
        int clampxminus1_lockSensorValue = 573;
        String clampxminus1_lockStatus = "";
        String clampxplus1_clampState = "";
        int clampxplus1_filterPositionSensorValue = 592;
        int clampxplus1_filterPresenceOffset2 = 954;
        String clampxplus1_filterPresenceStatus = "w";
        int clampxplus1_lockSensorOffset1 = 851;
        int clampxplus1_lockSensorValue = 115;
        String clampxplus1_lockStatus = "";
        String clampsState = "";
        boolean empty = false;
        String filterName = "";
        String ioStatus = "";
        int socketID = 675;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket1_TrendingTelemetry(atStandby, clampxminus1_clampState, clampxminus1_filterPositionSensorValue, clampxminus1_filterPresenceOffset2, clampxminus1_filterPresenceStatus, clampxminus1_lockSensorOffset1, clampxminus1_lockSensorValue, clampxminus1_lockStatus, clampxplus1_clampState, clampxplus1_filterPositionSensorValue, clampxplus1_filterPresenceOffset2, clampxplus1_filterPresenceStatus, clampxplus1_lockSensorOffset1, clampxplus1_lockSensorValue, clampxplus1_lockStatus, clampsState, empty, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket1_TrendingTelemetry));
        Fcs_Carousel_Socket1_TrendingTelemetry item_ = (Fcs_Carousel_Socket1_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus1_clampState, (Object)item_.getClampxminus1_clampState());
        Assert.assertEquals((long)clampxminus1_filterPositionSensorValue, (long)item_.getClampxminus1_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus1_filterPresenceOffset2, (long)item_.getClampxminus1_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus1_filterPresenceStatus, (Object)item_.getClampxminus1_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus1_lockSensorOffset1, (long)item_.getClampxminus1_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus1_lockSensorValue, (long)item_.getClampxminus1_lockSensorValue());
        Assert.assertEquals((Object)clampxminus1_lockStatus, (Object)item_.getClampxminus1_lockStatus());
        Assert.assertEquals((Object)clampxplus1_clampState, (Object)item_.getClampxplus1_clampState());
        Assert.assertEquals((long)clampxplus1_filterPositionSensorValue, (long)item_.getClampxplus1_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus1_filterPresenceOffset2, (long)item_.getClampxplus1_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus1_filterPresenceStatus, (Object)item_.getClampxplus1_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus1_lockSensorOffset1, (long)item_.getClampxplus1_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus1_lockSensorValue, (long)item_.getClampxplus1_lockSensorValue());
        Assert.assertEquals((Object)clampxplus1_lockStatus, (Object)item_.getClampxplus1_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket2_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        String clampxminus2_clampState = "";
        int clampxminus2_filterPositionSensorValue = 783;
        int clampxminus2_filterPresenceOffset2 = 540;
        String clampxminus2_filterPresenceStatus = "";
        int clampxminus2_lockSensorOffset1 = 707;
        int clampxminus2_lockSensorValue = 535;
        String clampxminus2_lockStatus = "";
        String clampxplus2_clampState = "z";
        int clampxplus2_filterPositionSensorValue = 556;
        int clampxplus2_filterPresenceOffset2 = 85;
        String clampxplus2_filterPresenceStatus = "u";
        int clampxplus2_lockSensorOffset1 = 935;
        int clampxplus2_lockSensorValue = 491;
        String clampxplus2_lockStatus = "";
        String clampsState = "";
        boolean empty = false;
        String filterName = "";
        String ioStatus = "";
        int socketID = 835;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket2_TrendingTelemetry(atStandby, clampxminus2_clampState, clampxminus2_filterPositionSensorValue, clampxminus2_filterPresenceOffset2, clampxminus2_filterPresenceStatus, clampxminus2_lockSensorOffset1, clampxminus2_lockSensorValue, clampxminus2_lockStatus, clampxplus2_clampState, clampxplus2_filterPositionSensorValue, clampxplus2_filterPresenceOffset2, clampxplus2_filterPresenceStatus, clampxplus2_lockSensorOffset1, clampxplus2_lockSensorValue, clampxplus2_lockStatus, clampsState, empty, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket2_TrendingTelemetry));
        Fcs_Carousel_Socket2_TrendingTelemetry item_ = (Fcs_Carousel_Socket2_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus2_clampState, (Object)item_.getClampxminus2_clampState());
        Assert.assertEquals((long)clampxminus2_filterPositionSensorValue, (long)item_.getClampxminus2_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus2_filterPresenceOffset2, (long)item_.getClampxminus2_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus2_filterPresenceStatus, (Object)item_.getClampxminus2_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus2_lockSensorOffset1, (long)item_.getClampxminus2_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus2_lockSensorValue, (long)item_.getClampxminus2_lockSensorValue());
        Assert.assertEquals((Object)clampxminus2_lockStatus, (Object)item_.getClampxminus2_lockStatus());
        Assert.assertEquals((Object)clampxplus2_clampState, (Object)item_.getClampxplus2_clampState());
        Assert.assertEquals((long)clampxplus2_filterPositionSensorValue, (long)item_.getClampxplus2_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus2_filterPresenceOffset2, (long)item_.getClampxplus2_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus2_filterPresenceStatus, (Object)item_.getClampxplus2_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus2_lockSensorOffset1, (long)item_.getClampxplus2_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus2_lockSensorValue, (long)item_.getClampxplus2_lockSensorValue());
        Assert.assertEquals((Object)clampxplus2_lockStatus, (Object)item_.getClampxplus2_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket3_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        String clampxminus3_clampState = "c";
        int clampxminus3_filterPositionSensorValue = 760;
        int clampxminus3_filterPresenceOffset2 = 150;
        String clampxminus3_filterPresenceStatus = "c";
        int clampxminus3_lockSensorOffset1 = 348;
        int clampxminus3_lockSensorValue = 967;
        String clampxminus3_lockStatus = "x";
        String clampxplus3_clampState = "";
        int clampxplus3_filterPositionSensorValue = 786;
        int clampxplus3_filterPresenceOffset2 = 443;
        String clampxplus3_filterPresenceStatus = "t";
        int clampxplus3_lockSensorOffset1 = 305;
        int clampxplus3_lockSensorValue = 50;
        String clampxplus3_lockStatus = "";
        String clampsState = "u";
        boolean empty = false;
        String filterName = "";
        String ioStatus = "m";
        int socketID = 747;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket3_TrendingTelemetry(atStandby, clampxminus3_clampState, clampxminus3_filterPositionSensorValue, clampxminus3_filterPresenceOffset2, clampxminus3_filterPresenceStatus, clampxminus3_lockSensorOffset1, clampxminus3_lockSensorValue, clampxminus3_lockStatus, clampxplus3_clampState, clampxplus3_filterPositionSensorValue, clampxplus3_filterPresenceOffset2, clampxplus3_filterPresenceStatus, clampxplus3_lockSensorOffset1, clampxplus3_lockSensorValue, clampxplus3_lockStatus, clampsState, empty, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket3_TrendingTelemetry));
        Fcs_Carousel_Socket3_TrendingTelemetry item_ = (Fcs_Carousel_Socket3_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus3_clampState, (Object)item_.getClampxminus3_clampState());
        Assert.assertEquals((long)clampxminus3_filterPositionSensorValue, (long)item_.getClampxminus3_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus3_filterPresenceOffset2, (long)item_.getClampxminus3_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus3_filterPresenceStatus, (Object)item_.getClampxminus3_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus3_lockSensorOffset1, (long)item_.getClampxminus3_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus3_lockSensorValue, (long)item_.getClampxminus3_lockSensorValue());
        Assert.assertEquals((Object)clampxminus3_lockStatus, (Object)item_.getClampxminus3_lockStatus());
        Assert.assertEquals((Object)clampxplus3_clampState, (Object)item_.getClampxplus3_clampState());
        Assert.assertEquals((long)clampxplus3_filterPositionSensorValue, (long)item_.getClampxplus3_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus3_filterPresenceOffset2, (long)item_.getClampxplus3_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus3_filterPresenceStatus, (Object)item_.getClampxplus3_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus3_lockSensorOffset1, (long)item_.getClampxplus3_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus3_lockSensorValue, (long)item_.getClampxplus3_lockSensorValue());
        Assert.assertEquals((Object)clampxplus3_lockStatus, (Object)item_.getClampxplus3_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket4_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        String clampxminus4_clampState = "t";
        int clampxminus4_filterPositionSensorValue = 733;
        int clampxminus4_filterPresenceOffset2 = 531;
        String clampxminus4_filterPresenceStatus = "e";
        int clampxminus4_lockSensorOffset1 = 389;
        int clampxminus4_lockSensorValue = 140;
        String clampxminus4_lockStatus = "";
        String clampxplus4_clampState = "d";
        int clampxplus4_filterPositionSensorValue = 708;
        int clampxplus4_filterPresenceOffset2 = 787;
        String clampxplus4_filterPresenceStatus = "i";
        int clampxplus4_lockSensorOffset1 = 256;
        int clampxplus4_lockSensorValue = 431;
        String clampxplus4_lockStatus = "i";
        String clampsState = "n";
        boolean empty = true;
        String filterName = "j";
        String ioStatus = "b";
        int socketID = 518;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket4_TrendingTelemetry(atStandby, clampxminus4_clampState, clampxminus4_filterPositionSensorValue, clampxminus4_filterPresenceOffset2, clampxminus4_filterPresenceStatus, clampxminus4_lockSensorOffset1, clampxminus4_lockSensorValue, clampxminus4_lockStatus, clampxplus4_clampState, clampxplus4_filterPositionSensorValue, clampxplus4_filterPresenceOffset2, clampxplus4_filterPresenceStatus, clampxplus4_lockSensorOffset1, clampxplus4_lockSensorValue, clampxplus4_lockStatus, clampsState, empty, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket4_TrendingTelemetry));
        Fcs_Carousel_Socket4_TrendingTelemetry item_ = (Fcs_Carousel_Socket4_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus4_clampState, (Object)item_.getClampxminus4_clampState());
        Assert.assertEquals((long)clampxminus4_filterPositionSensorValue, (long)item_.getClampxminus4_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus4_filterPresenceOffset2, (long)item_.getClampxminus4_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus4_filterPresenceStatus, (Object)item_.getClampxminus4_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus4_lockSensorOffset1, (long)item_.getClampxminus4_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus4_lockSensorValue, (long)item_.getClampxminus4_lockSensorValue());
        Assert.assertEquals((Object)clampxminus4_lockStatus, (Object)item_.getClampxminus4_lockStatus());
        Assert.assertEquals((Object)clampxplus4_clampState, (Object)item_.getClampxplus4_clampState());
        Assert.assertEquals((long)clampxplus4_filterPositionSensorValue, (long)item_.getClampxplus4_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus4_filterPresenceOffset2, (long)item_.getClampxplus4_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus4_filterPresenceStatus, (Object)item_.getClampxplus4_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus4_lockSensorOffset1, (long)item_.getClampxplus4_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus4_lockSensorValue, (long)item_.getClampxplus4_lockSensorValue());
        Assert.assertEquals((Object)clampxplus4_lockStatus, (Object)item_.getClampxplus4_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket5_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        String clampxminus5_clampState = "f";
        int clampxminus5_filterPositionSensorValue = 381;
        int clampxminus5_filterPresenceOffset2 = 949;
        String clampxminus5_filterPresenceStatus = "i";
        int clampxminus5_lockSensorOffset1 = 151;
        int clampxminus5_lockSensorValue = 245;
        String clampxminus5_lockStatus = "s";
        String clampxplus5_clampState = "";
        int clampxplus5_filterPositionSensorValue = 82;
        int clampxplus5_filterPresenceOffset2 = 390;
        String clampxplus5_filterPresenceStatus = "";
        int clampxplus5_lockSensorOffset1 = 488;
        int clampxplus5_lockSensorValue = 264;
        String clampxplus5_lockStatus = "";
        String clampsState = "k";
        boolean empty = false;
        String filterName = "";
        String ioStatus = "e";
        int socketID = 812;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket5_TrendingTelemetry(atStandby, clampxminus5_clampState, clampxminus5_filterPositionSensorValue, clampxminus5_filterPresenceOffset2, clampxminus5_filterPresenceStatus, clampxminus5_lockSensorOffset1, clampxminus5_lockSensorValue, clampxminus5_lockStatus, clampxplus5_clampState, clampxplus5_filterPositionSensorValue, clampxplus5_filterPresenceOffset2, clampxplus5_filterPresenceStatus, clampxplus5_lockSensorOffset1, clampxplus5_lockSensorValue, clampxplus5_lockStatus, clampsState, empty, filterName, ioStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket5_TrendingTelemetry));
        Fcs_Carousel_Socket5_TrendingTelemetry item_ = (Fcs_Carousel_Socket5_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus5_clampState, (Object)item_.getClampxminus5_clampState());
        Assert.assertEquals((long)clampxminus5_filterPositionSensorValue, (long)item_.getClampxminus5_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus5_filterPresenceOffset2, (long)item_.getClampxminus5_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus5_filterPresenceStatus, (Object)item_.getClampxminus5_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus5_lockSensorOffset1, (long)item_.getClampxminus5_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus5_lockSensorValue, (long)item_.getClampxminus5_lockSensorValue());
        Assert.assertEquals((Object)clampxminus5_lockStatus, (Object)item_.getClampxminus5_lockStatus());
        Assert.assertEquals((Object)clampxplus5_clampState, (Object)item_.getClampxplus5_clampState());
        Assert.assertEquals((long)clampxplus5_filterPositionSensorValue, (long)item_.getClampxplus5_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus5_filterPresenceOffset2, (long)item_.getClampxplus5_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus5_filterPresenceStatus, (Object)item_.getClampxplus5_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus5_lockSensorOffset1, (long)item_.getClampxplus5_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus5_lockSensorValue, (long)item_.getClampxplus5_lockSensorValue());
        Assert.assertEquals((Object)clampxplus5_lockStatus, (Object)item_.getClampxplus5_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Carousel_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        String clampsStateAtStandby = "v";
        int deltaPositionAtStandby = 156;
        boolean emptyAtStandby = true;
        int estimatedPosition = 110;
        int filterAtStandbyId = 640;
        String filterOnAutochangerName = "";
        long minLocked = 863L;
        int socketAtStandbyID = 600;
        String socketAtStandbyName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_TrendingTelemetry(atStandby, clampsStateAtStandby, deltaPositionAtStandby, emptyAtStandby, estimatedPosition, filterAtStandbyId, filterOnAutochangerName, minLocked, socketAtStandbyID, socketAtStandbyName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_TrendingTelemetry));
        Fcs_Carousel_TrendingTelemetry item_ = (Fcs_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampsStateAtStandby, (Object)item_.getClampsStateAtStandby());
        Assert.assertEquals((long)deltaPositionAtStandby, (long)item_.getDeltaPositionAtStandby());
        Assert.assertEquals((Object)emptyAtStandby, (Object)item_.isEmptyAtStandby());
        Assert.assertEquals((long)estimatedPosition, (long)item_.getEstimatedPosition());
        Assert.assertEquals((long)filterAtStandbyId, (long)item_.getFilterAtStandbyId());
        Assert.assertEquals((Object)filterOnAutochangerName, (Object)item_.getFilterOnAutochangerName());
        Assert.assertEquals((long)minLocked, (long)item_.getMinLocked());
        Assert.assertEquals((long)socketAtStandbyID, (long)item_.getSocketAtStandbyID());
        Assert.assertEquals((Object)socketAtStandbyName, (Object)item_.getSocketAtStandbyName());
    }

    @Test
    public void sendReceiveFcs_Duration_Autochanger_TrendingTelemetry() throws Exception {
        long autochangertrucks_ALIGN_FOLLOWER = 80L;
        long autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE = 691L;
        long autochangertrucks_MOVE_TO_ABSOLUTE_POSITION = 845L;
        long latches_latchXminus_CLOSE = 182L;
        long latches_latchXminus_OPEN = 254L;
        long latches_latchXplus_CLOSE = 330L;
        long latches_latchXplus_OPEN = 350L;
        long onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 604L;
        long onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 390L;
        long onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP = 494L;
        long onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT = 766L;
        long onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 851L;
        long onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 417L;
        long onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP = 390L;
        long onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT = 611L;
        long onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 348L;
        long onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP = 282L;
        long onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT = 751L;
        long onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 614L;
        long onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT = 379L;
        long onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP = 469L;
        long onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 321L;
        long onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 240L;
        long onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP = 523L;
        long onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT = 843L;
        long onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 421L;
        long onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 331L;
        long onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP = 381L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Autochanger_TrendingTelemetry(autochangertrucks_ALIGN_FOLLOWER, autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, latches_latchXminus_CLOSE, latches_latchXminus_OPEN, latches_latchXplus_CLOSE, latches_latchXplus_OPEN, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Autochanger_TrendingTelemetry));
        Fcs_Duration_Autochanger_TrendingTelemetry item_ = (Fcs_Duration_Autochanger_TrendingTelemetry)item;
        Assert.assertEquals((long)autochangertrucks_ALIGN_FOLLOWER, (long)item_.getAutochangertrucks_ALIGN_FOLLOWER());
        Assert.assertEquals((long)autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, (long)item_.getAutochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE());
        Assert.assertEquals((long)autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, (long)item_.getAutochangertrucks_MOVE_TO_ABSOLUTE_POSITION());
        Assert.assertEquals((long)latches_latchXminus_CLOSE, (long)item_.getLatches_latchXminus_CLOSE());
        Assert.assertEquals((long)latches_latchXminus_OPEN, (long)item_.getLatches_latchXminus_OPEN());
        Assert.assertEquals((long)latches_latchXplus_CLOSE, (long)item_.getLatches_latchXplus_CLOSE());
        Assert.assertEquals((long)latches_latchXplus_OPEN, (long)item_.getLatches_latchXplus_OPEN());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXminus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXplus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampYminus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP());
    }

    @Test
    public void sendReceiveFcs_Duration_Carousel_TrendingTelemetry() throws Exception {
        long rotate_CAROUSEL_TO_ABSOLUTE_POSITION = 199L;
        long rotate_CAROUSEL_TO_RELATIVE_POSITION = 565L;
        int socket1_RELEASE_CLAMPS = 787;
        int socket1_UNLOCK_CLAMPS = 255;
        long socket1_clampXminus1_RELEASE = 865L;
        long socket1_clampXminus1_UNLOCK = 683L;
        long socket1_clampXplus1_RELEASE = 639L;
        long socket1_clampXplus1_UNLOCK = 153L;
        int socket2_RELEASE_CLAMPS = 12;
        int socket2_UNLOCK_CLAMPS = 491;
        long socket2_clampXminus2_RELEASE = 856L;
        long socket2_clampXminus2_UNLOCK = 315L;
        long socket2_clampXplus2_RELEASE = 181L;
        long socket2_clampXplus2_UNLOCK = 717L;
        int socket3_RELEASE_CLAMPS = 556;
        int socket3_UNLOCK_CLAMPS = 194;
        long socket3_clampXminus3_RELEASE = 50L;
        long socket3_clampXminus3_UNLOCK = 570L;
        long socket3_clampXplus3_RELEASE = 175L;
        long socket3_clampXplus3_UNLOCK = 857L;
        int socket4_RELEASE_CLAMPS = 501;
        int socket4_UNLOCK_CLAMPS = 472;
        long socket4_clampXminus4_RELEASE = 488L;
        long socket4_clampXminus4_UNLOCK = 76L;
        long socket4_clampXplus4_RELEASE = 916L;
        long socket4_clampXplus4_UNLOCK = 152L;
        int socket5_RELEASE_CLAMPS = 395;
        int socket5_UNLOCK_CLAMPS = 368;
        long socket5_clampXminus5_RELEASE = 695L;
        long socket5_clampXminus5_UNLOCK = 21L;
        long socket5_clampXplus5_RELEASE = 920L;
        long socket5_clampXplus5_UNLOCK = 678L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Carousel_TrendingTelemetry(rotate_CAROUSEL_TO_ABSOLUTE_POSITION, rotate_CAROUSEL_TO_RELATIVE_POSITION, socket1_RELEASE_CLAMPS, socket1_UNLOCK_CLAMPS, socket1_clampXminus1_RELEASE, socket1_clampXminus1_UNLOCK, socket1_clampXplus1_RELEASE, socket1_clampXplus1_UNLOCK, socket2_RELEASE_CLAMPS, socket2_UNLOCK_CLAMPS, socket2_clampXminus2_RELEASE, socket2_clampXminus2_UNLOCK, socket2_clampXplus2_RELEASE, socket2_clampXplus2_UNLOCK, socket3_RELEASE_CLAMPS, socket3_UNLOCK_CLAMPS, socket3_clampXminus3_RELEASE, socket3_clampXminus3_UNLOCK, socket3_clampXplus3_RELEASE, socket3_clampXplus3_UNLOCK, socket4_RELEASE_CLAMPS, socket4_UNLOCK_CLAMPS, socket4_clampXminus4_RELEASE, socket4_clampXminus4_UNLOCK, socket4_clampXplus4_RELEASE, socket4_clampXplus4_UNLOCK, socket5_RELEASE_CLAMPS, socket5_UNLOCK_CLAMPS, socket5_clampXminus5_RELEASE, socket5_clampXminus5_UNLOCK, socket5_clampXplus5_RELEASE, socket5_clampXplus5_UNLOCK));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Carousel_TrendingTelemetry));
        Fcs_Duration_Carousel_TrendingTelemetry item_ = (Fcs_Duration_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((long)rotate_CAROUSEL_TO_ABSOLUTE_POSITION, (long)item_.getRotate_CAROUSEL_TO_ABSOLUTE_POSITION());
        Assert.assertEquals((long)rotate_CAROUSEL_TO_RELATIVE_POSITION, (long)item_.getRotate_CAROUSEL_TO_RELATIVE_POSITION());
        Assert.assertEquals((long)socket1_RELEASE_CLAMPS, (long)item_.getSocket1_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket1_UNLOCK_CLAMPS, (long)item_.getSocket1_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket1_clampXminus1_RELEASE, (long)item_.getSocket1_clampXminus1_RELEASE());
        Assert.assertEquals((long)socket1_clampXminus1_UNLOCK, (long)item_.getSocket1_clampXminus1_UNLOCK());
        Assert.assertEquals((long)socket1_clampXplus1_RELEASE, (long)item_.getSocket1_clampXplus1_RELEASE());
        Assert.assertEquals((long)socket1_clampXplus1_UNLOCK, (long)item_.getSocket1_clampXplus1_UNLOCK());
        Assert.assertEquals((long)socket2_RELEASE_CLAMPS, (long)item_.getSocket2_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket2_UNLOCK_CLAMPS, (long)item_.getSocket2_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket2_clampXminus2_RELEASE, (long)item_.getSocket2_clampXminus2_RELEASE());
        Assert.assertEquals((long)socket2_clampXminus2_UNLOCK, (long)item_.getSocket2_clampXminus2_UNLOCK());
        Assert.assertEquals((long)socket2_clampXplus2_RELEASE, (long)item_.getSocket2_clampXplus2_RELEASE());
        Assert.assertEquals((long)socket2_clampXplus2_UNLOCK, (long)item_.getSocket2_clampXplus2_UNLOCK());
        Assert.assertEquals((long)socket3_RELEASE_CLAMPS, (long)item_.getSocket3_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket3_UNLOCK_CLAMPS, (long)item_.getSocket3_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket3_clampXminus3_RELEASE, (long)item_.getSocket3_clampXminus3_RELEASE());
        Assert.assertEquals((long)socket3_clampXminus3_UNLOCK, (long)item_.getSocket3_clampXminus3_UNLOCK());
        Assert.assertEquals((long)socket3_clampXplus3_RELEASE, (long)item_.getSocket3_clampXplus3_RELEASE());
        Assert.assertEquals((long)socket3_clampXplus3_UNLOCK, (long)item_.getSocket3_clampXplus3_UNLOCK());
        Assert.assertEquals((long)socket4_RELEASE_CLAMPS, (long)item_.getSocket4_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket4_UNLOCK_CLAMPS, (long)item_.getSocket4_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket4_clampXminus4_RELEASE, (long)item_.getSocket4_clampXminus4_RELEASE());
        Assert.assertEquals((long)socket4_clampXminus4_UNLOCK, (long)item_.getSocket4_clampXminus4_UNLOCK());
        Assert.assertEquals((long)socket4_clampXplus4_RELEASE, (long)item_.getSocket4_clampXplus4_RELEASE());
        Assert.assertEquals((long)socket4_clampXplus4_UNLOCK, (long)item_.getSocket4_clampXplus4_UNLOCK());
        Assert.assertEquals((long)socket5_RELEASE_CLAMPS, (long)item_.getSocket5_RELEASE_CLAMPS());
        Assert.assertEquals((long)socket5_UNLOCK_CLAMPS, (long)item_.getSocket5_UNLOCK_CLAMPS());
        Assert.assertEquals((long)socket5_clampXminus5_RELEASE, (long)item_.getSocket5_clampXminus5_RELEASE());
        Assert.assertEquals((long)socket5_clampXminus5_UNLOCK, (long)item_.getSocket5_clampXminus5_UNLOCK());
        Assert.assertEquals((long)socket5_clampXplus5_RELEASE, (long)item_.getSocket5_clampXplus5_RELEASE());
        Assert.assertEquals((long)socket5_clampXplus5_UNLOCK, (long)item_.getSocket5_clampXplus5_UNLOCK());
    }

    @Test
    public void sendReceiveFcs_Duration_Loader_TrendingTelemetry() throws Exception {
        long carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION = 525L;
        long carrier_MOVE_LOADERCARRIER_TO_ENGAGED = 791L;
        long carrier_MOVE_LOADERCARRIER_TO_HANDOFF = 639L;
        long carrier_MOVE_LOADERCARRIER_TO_STORAGE = 47L;
        long hooks_CLAMP_LOADER_HOOKS = 98L;
        long hooks_CLOSE_LOADER_HOOKS = 781L;
        long hooks_OPEN_HOMING_LOADER_HOOKS = 365L;
        long hooks_UNCLAMP_LOADER_HOOKS = 545L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Loader_TrendingTelemetry(carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, carrier_MOVE_LOADERCARRIER_TO_ENGAGED, carrier_MOVE_LOADERCARRIER_TO_HANDOFF, carrier_MOVE_LOADERCARRIER_TO_STORAGE, hooks_CLAMP_LOADER_HOOKS, hooks_CLOSE_LOADER_HOOKS, hooks_OPEN_HOMING_LOADER_HOOKS, hooks_UNCLAMP_LOADER_HOOKS));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Loader_TrendingTelemetry));
        Fcs_Duration_Loader_TrendingTelemetry item_ = (Fcs_Duration_Loader_TrendingTelemetry)item;
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_ENGAGED, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_ENGAGED());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_HANDOFF, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_HANDOFF());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_STORAGE, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_STORAGE());
        Assert.assertEquals((long)hooks_CLAMP_LOADER_HOOKS, (long)item_.getHooks_CLAMP_LOADER_HOOKS());
        Assert.assertEquals((long)hooks_CLOSE_LOADER_HOOKS, (long)item_.getHooks_CLOSE_LOADER_HOOKS());
        Assert.assertEquals((long)hooks_OPEN_HOMING_LOADER_HOOKS, (long)item_.getHooks_OPEN_HOMING_LOADER_HOOKS());
        Assert.assertEquals((long)hooks_UNCLAMP_LOADER_HOOKS, (long)item_.getHooks_UNCLAMP_LOADER_HOOKS());
    }

    @Test
    public void sendReceiveFcs_Duration_TrendingTelemetry() throws Exception {
        long sETFILTER = 921L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_TrendingTelemetry(sETFILTER));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_TrendingTelemetry));
        Fcs_Duration_TrendingTelemetry item_ = (Fcs_Duration_TrendingTelemetry)item;
        Assert.assertEquals((long)sETFILTER, (long)item_.getSETFILTER());
    }

    @Test
    public void sendReceiveFcs_Fcs_Mcm_TrendingTelemetry() throws Exception {
        String autochanger_trucks_location = "";
        int autochanger_trucks_position = 464;
        int filter_on_autochanger_id = 536;
        String filter_on_autochanger_name = "";
        int filter_previous_socketID = 870;
        int proximity = 228;
        int setfilter_percentage = 392;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Fcs_Mcm_TrendingTelemetry(autochanger_trucks_location, autochanger_trucks_position, filter_on_autochanger_id, filter_on_autochanger_name, filter_previous_socketID, proximity, setfilter_percentage));
        Assert.assertTrue((boolean)(item instanceof Fcs_Fcs_Mcm_TrendingTelemetry));
        Fcs_Fcs_Mcm_TrendingTelemetry item_ = (Fcs_Fcs_Mcm_TrendingTelemetry)item;
        Assert.assertEquals((Object)autochanger_trucks_location, (Object)item_.getAutochanger_trucks_location());
        Assert.assertEquals((long)autochanger_trucks_position, (long)item_.getAutochanger_trucks_position());
        Assert.assertEquals((long)filter_on_autochanger_id, (long)item_.getFilter_on_autochanger_id());
        Assert.assertEquals((Object)filter_on_autochanger_name, (Object)item_.getFilter_on_autochanger_name());
        Assert.assertEquals((long)filter_previous_socketID, (long)item_.getFilter_previous_socketID());
        Assert.assertEquals((long)proximity, (long)item_.getProximity());
        Assert.assertEquals((long)setfilter_percentage, (long)item_.getSetfilter_percentage());
    }

    @Test
    public void sendReceiveFcs_Loader_Carrier_TrendingTelemetry() throws Exception {
        boolean atEngaged = true;
        boolean atHandoff = false;
        boolean atStorage = true;
        boolean controllerInError = false;
        boolean engagedSensorOn = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_Carrier_TrendingTelemetry(atEngaged, atHandoff, atStorage, controllerInError, engagedSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_Carrier_TrendingTelemetry));
        Fcs_Loader_Carrier_TrendingTelemetry item_ = (Fcs_Loader_Carrier_TrendingTelemetry)item;
        Assert.assertEquals((Object)atEngaged, (Object)item_.isAtEngaged());
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atStorage, (Object)item_.isAtStorage());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((Object)engagedSensorOn, (Object)item_.isEngagedSensorOn());
    }

    @Test
    public void sendReceiveFcs_Loader_Hooks_TrendingTelemetry() throws Exception {
        boolean allHooksInStateCLOSED = true;
        String clampState = "u";
        boolean controllerInError = false;
        boolean forceClampedStatus = false;
        boolean forceOverClampedStatus = false;
        int forceSensorVoltage0 = 670;
        int forceSensorVoltage1 = 931;
        String forceStatus = "";
        boolean forceUnclampedStatus = false;
        boolean forceUnderClampedStatus = true;
        boolean statuspublishedbyhook1_inError = false;
        boolean statuspublishedbyhook1_lockSensorOn = false;
        String statuspublishedbyhook1_lockStatus = "";
        boolean statuspublishedbyhook1_unlockSensorOn = false;
        boolean statuspublishedbyhook2_inError = true;
        boolean statuspublishedbyhook2_lockSensorOn = true;
        String statuspublishedbyhook2_lockStatus = "";
        boolean statuspublishedbyhook2_unlockSensorOn = false;
        boolean statuspublishedbyhook3_inError = false;
        boolean statuspublishedbyhook3_lockSensorOn = false;
        String statuspublishedbyhook3_lockStatus = "";
        boolean statuspublishedbyhook3_unlockSensorOn = true;
        boolean statuspublishedbyhook4_inError = false;
        boolean statuspublishedbyhook4_lockSensorOn = true;
        String statuspublishedbyhook4_lockStatus = "z";
        boolean statuspublishedbyhook4_unlockSensorOn = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_Hooks_TrendingTelemetry(allHooksInStateCLOSED, clampState, controllerInError, forceClampedStatus, forceOverClampedStatus, forceSensorVoltage0, forceSensorVoltage1, forceStatus, forceUnclampedStatus, forceUnderClampedStatus, statuspublishedbyhook1_inError, statuspublishedbyhook1_lockSensorOn, statuspublishedbyhook1_lockStatus, statuspublishedbyhook1_unlockSensorOn, statuspublishedbyhook2_inError, statuspublishedbyhook2_lockSensorOn, statuspublishedbyhook2_lockStatus, statuspublishedbyhook2_unlockSensorOn, statuspublishedbyhook3_inError, statuspublishedbyhook3_lockSensorOn, statuspublishedbyhook3_lockStatus, statuspublishedbyhook3_unlockSensorOn, statuspublishedbyhook4_inError, statuspublishedbyhook4_lockSensorOn, statuspublishedbyhook4_lockStatus, statuspublishedbyhook4_unlockSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_Hooks_TrendingTelemetry));
        Fcs_Loader_Hooks_TrendingTelemetry item_ = (Fcs_Loader_Hooks_TrendingTelemetry)item;
        Assert.assertEquals((Object)allHooksInStateCLOSED, (Object)item_.isAllHooksInStateCLOSED());
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((Object)forceClampedStatus, (Object)item_.isForceClampedStatus());
        Assert.assertEquals((Object)forceOverClampedStatus, (Object)item_.isForceOverClampedStatus());
        Assert.assertEquals((long)forceSensorVoltage0, (long)item_.getForceSensorVoltage0());
        Assert.assertEquals((long)forceSensorVoltage1, (long)item_.getForceSensorVoltage1());
        Assert.assertEquals((Object)forceStatus, (Object)item_.getForceStatus());
        Assert.assertEquals((Object)forceUnclampedStatus, (Object)item_.isForceUnclampedStatus());
        Assert.assertEquals((Object)forceUnderClampedStatus, (Object)item_.isForceUnderClampedStatus());
        Assert.assertEquals((Object)statuspublishedbyhook1_inError, (Object)item_.isStatuspublishedbyhook1_inError());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockSensorOn, (Object)item_.isStatuspublishedbyhook1_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockStatus, (Object)item_.getStatuspublishedbyhook1_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook1_unlockSensorOn, (Object)item_.isStatuspublishedbyhook1_unlockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook2_inError, (Object)item_.isStatuspublishedbyhook2_inError());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockSensorOn, (Object)item_.isStatuspublishedbyhook2_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockStatus, (Object)item_.getStatuspublishedbyhook2_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook2_unlockSensorOn, (Object)item_.isStatuspublishedbyhook2_unlockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook3_inError, (Object)item_.isStatuspublishedbyhook3_inError());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockSensorOn, (Object)item_.isStatuspublishedbyhook3_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockStatus, (Object)item_.getStatuspublishedbyhook3_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook3_unlockSensorOn, (Object)item_.isStatuspublishedbyhook3_unlockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook4_inError, (Object)item_.isStatuspublishedbyhook4_inError());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockSensorOn, (Object)item_.isStatuspublishedbyhook4_lockSensorOn());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockStatus, (Object)item_.getStatuspublishedbyhook4_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook4_unlockSensorOn, (Object)item_.isStatuspublishedbyhook4_unlockSensorOn());
    }

    @Test
    public void sendReceiveFcs_TrendingTelemetry() throws Exception {
        int canbus0 = 378;
        int canbus1 = 222;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_TrendingTelemetry(canbus0, canbus1));
        Assert.assertTrue((boolean)(item instanceof Fcs_TrendingTelemetry));
        Fcs_TrendingTelemetry item_ = (Fcs_TrendingTelemetry)item;
        Assert.assertEquals((long)canbus0, (long)item_.getCanbus0());
        Assert.assertEquals((long)canbus1, (long)item_.getCanbus1());
    }

    @Test
    public void sendReceiveShutter_TrendingTelemetry() throws Exception {
        double shutterstatus_axstatus_MINUSX_actPos = 0.19903916120529175;
        double shutterstatus_axstatus_MINUSX_actVel = 0.619513750076294;
        int shutterstatus_axstatus_MINUSX_brakeEngaged = 479;
        double shutterstatus_axstatus_MINUSX_ctrlTemp = 0.94598788022995;
        int shutterstatus_axstatus_MINUSX_enabled = 500;
        int shutterstatus_axstatus_MINUSX_errorID = 60;
        int shutterstatus_axstatus_MINUSX_hasSafeTemp = 961;
        int shutterstatus_axstatus_MINUSX_highLimit = 189;
        int shutterstatus_axstatus_MINUSX_isHomed = 65;
        int shutterstatus_axstatus_MINUSX_lowLimit = 651;
        double shutterstatus_axstatus_MINUSX_setAcc = 0.7791630625724792;
        double shutterstatus_axstatus_PLUSX_actPos = 0.63848f;
        double shutterstatus_axstatus_PLUSX_actVel = 0.1971091f;
        int shutterstatus_axstatus_PLUSX_brakeEngaged = 376;
        double shutterstatus_axstatus_PLUSX_ctrlTemp = 0.8409298658370972;
        int shutterstatus_axstatus_PLUSX_enabled = 802;
        int shutterstatus_axstatus_PLUSX_errorID = 641;
        int shutterstatus_axstatus_PLUSX_hasSafeTemp = 402;
        int shutterstatus_axstatus_PLUSX_highLimit = 405;
        int shutterstatus_axstatus_PLUSX_isHomed = 925;
        int shutterstatus_axstatus_PLUSX_lowLimit = 551;
        double shutterstatus_axstatus_PLUSX_setAcc = 0.18155354261398315;
        int shutterstatus_brakePowerIsOn = 775;
        double shutterstatus_creationTime = 0.8535187840461731;
        int shutterstatus_isCalibrated = 743;
        int shutterstatus_isSafetyOn = 568;
        int shutterstatus_leapIsValid = 646;
        int shutterstatus_leapSeconds = 252;
        int shutterstatus_motionProfile = 906;
        int shutterstatus_ptpState = 948;
        int shutterstatus_smState = 302;
        int shutterstatus_tempIsSafe_CONTROL_BOX = 777;
        int shutterstatus_tempIsSafe_MINUSX_MOTOR = 663;
        int shutterstatus_tempIsSafe_PLUSX_MOTOR = 9;
        double shutterstatus_temperature_CONTROL_BOX = 0.003401815891265869;
        double shutterstatus_temperature_MINUSX_MOTOR = 0.9991077780723572;
        double shutterstatus_temperature_PLUSX_MOTOR = 0.09032237529754639;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Shutter_TrendingTelemetry(shutterstatus_axstatus_MINUSX_actPos, shutterstatus_axstatus_MINUSX_actVel, shutterstatus_axstatus_MINUSX_brakeEngaged, shutterstatus_axstatus_MINUSX_ctrlTemp, shutterstatus_axstatus_MINUSX_enabled, shutterstatus_axstatus_MINUSX_errorID, shutterstatus_axstatus_MINUSX_hasSafeTemp, shutterstatus_axstatus_MINUSX_highLimit, shutterstatus_axstatus_MINUSX_isHomed, shutterstatus_axstatus_MINUSX_lowLimit, shutterstatus_axstatus_MINUSX_setAcc, shutterstatus_axstatus_PLUSX_actPos, shutterstatus_axstatus_PLUSX_actVel, shutterstatus_axstatus_PLUSX_brakeEngaged, shutterstatus_axstatus_PLUSX_ctrlTemp, shutterstatus_axstatus_PLUSX_enabled, shutterstatus_axstatus_PLUSX_errorID, shutterstatus_axstatus_PLUSX_hasSafeTemp, shutterstatus_axstatus_PLUSX_highLimit, shutterstatus_axstatus_PLUSX_isHomed, shutterstatus_axstatus_PLUSX_lowLimit, shutterstatus_axstatus_PLUSX_setAcc, shutterstatus_brakePowerIsOn, shutterstatus_creationTime, shutterstatus_isCalibrated, shutterstatus_isSafetyOn, shutterstatus_leapIsValid, shutterstatus_leapSeconds, shutterstatus_motionProfile, shutterstatus_ptpState, shutterstatus_smState, shutterstatus_tempIsSafe_CONTROL_BOX, shutterstatus_tempIsSafe_MINUSX_MOTOR, shutterstatus_tempIsSafe_PLUSX_MOTOR, shutterstatus_temperature_CONTROL_BOX, shutterstatus_temperature_MINUSX_MOTOR, shutterstatus_temperature_PLUSX_MOTOR));
        Assert.assertTrue((boolean)(item instanceof Shutter_TrendingTelemetry));
        Shutter_TrendingTelemetry item_ = (Shutter_TrendingTelemetry)item;
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_actPos, (double)item_.getShutterstatus_axstatus_MINUSX_actPos(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_actVel, (double)item_.getShutterstatus_axstatus_MINUSX_actVel(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_brakeEngaged, (long)item_.getShutterstatus_axstatus_MINUSX_brakeEngaged());
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_ctrlTemp, (double)item_.getShutterstatus_axstatus_MINUSX_ctrlTemp(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_enabled, (long)item_.getShutterstatus_axstatus_MINUSX_enabled());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_errorID, (long)item_.getShutterstatus_axstatus_MINUSX_errorID());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_hasSafeTemp, (long)item_.getShutterstatus_axstatus_MINUSX_hasSafeTemp());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_highLimit, (long)item_.getShutterstatus_axstatus_MINUSX_highLimit());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_isHomed, (long)item_.getShutterstatus_axstatus_MINUSX_isHomed());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_lowLimit, (long)item_.getShutterstatus_axstatus_MINUSX_lowLimit());
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_setAcc, (double)item_.getShutterstatus_axstatus_MINUSX_setAcc(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_actPos, (double)item_.getShutterstatus_axstatus_PLUSX_actPos(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_actVel, (double)item_.getShutterstatus_axstatus_PLUSX_actVel(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_brakeEngaged, (long)item_.getShutterstatus_axstatus_PLUSX_brakeEngaged());
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_ctrlTemp, (double)item_.getShutterstatus_axstatus_PLUSX_ctrlTemp(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_enabled, (long)item_.getShutterstatus_axstatus_PLUSX_enabled());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_errorID, (long)item_.getShutterstatus_axstatus_PLUSX_errorID());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_hasSafeTemp, (long)item_.getShutterstatus_axstatus_PLUSX_hasSafeTemp());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_highLimit, (long)item_.getShutterstatus_axstatus_PLUSX_highLimit());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_isHomed, (long)item_.getShutterstatus_axstatus_PLUSX_isHomed());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_lowLimit, (long)item_.getShutterstatus_axstatus_PLUSX_lowLimit());
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_setAcc, (double)item_.getShutterstatus_axstatus_PLUSX_setAcc(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_brakePowerIsOn, (long)item_.getShutterstatus_brakePowerIsOn());
        Assert.assertEquals((double)shutterstatus_creationTime, (double)item_.getShutterstatus_creationTime(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_isCalibrated, (long)item_.getShutterstatus_isCalibrated());
        Assert.assertEquals((long)shutterstatus_isSafetyOn, (long)item_.getShutterstatus_isSafetyOn());
        Assert.assertEquals((long)shutterstatus_leapIsValid, (long)item_.getShutterstatus_leapIsValid());
        Assert.assertEquals((long)shutterstatus_leapSeconds, (long)item_.getShutterstatus_leapSeconds());
        Assert.assertEquals((long)shutterstatus_motionProfile, (long)item_.getShutterstatus_motionProfile());
        Assert.assertEquals((long)shutterstatus_ptpState, (long)item_.getShutterstatus_ptpState());
        Assert.assertEquals((long)shutterstatus_smState, (long)item_.getShutterstatus_smState());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_CONTROL_BOX, (long)item_.getShutterstatus_tempIsSafe_CONTROL_BOX());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_MINUSX_MOTOR, (long)item_.getShutterstatus_tempIsSafe_MINUSX_MOTOR());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_PLUSX_MOTOR, (long)item_.getShutterstatus_tempIsSafe_PLUSX_MOTOR());
        Assert.assertEquals((double)shutterstatus_temperature_CONTROL_BOX, (double)item_.getShutterstatus_temperature_CONTROL_BOX(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_temperature_MINUSX_MOTOR, (double)item_.getShutterstatus_temperature_MINUSX_MOTOR(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_temperature_PLUSX_MOTOR, (double)item_.getShutterstatus_temperature_PLUSX_MOTOR(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_ChillerTelemetry() throws Exception {
        double cascadeSetPoint = 0.2911042f;
        double chillerPumpLife = 0.11515432596206665;
        double chillerValveAct = 0.1840064525604248;
        double compressorLife = 0.41136884689331055;
        double controllerLife = 0.5856832265853882;
        double coolPercentage = 0.547085f;
        double flowRate = 0.3362230658531189;
        double flowSetPoint = 0.7708615064620972;
        double fluidTemperature = 0.4583044f;
        double heatPercentage = 0.0441548228263855;
        double importedColdTemp = 0.5807642340660095;
        double pressureIn = 0.17478978633880615;
        double pressureOut = 0.3210238814353943;
        double pressureTank = 0.49725866317749023;
        double tankLevel = 0.3278064f;
        double tankSetPoint = 0.2590084f;
        double tempCondenser = 0.6906159520149231;
        double tempDUTInput = 0.02514267f;
        double tempDynamicSetPt = 0.06614041328430176;
        double tempSetPoint = 0.7143787145614624;
        double tempStage2Evap = 0.2780084013938904;
        double tempTXVBulb = 0.07579177618026733;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_ChillerTelemetry(cascadeSetPoint, chillerPumpLife, chillerValveAct, compressorLife, controllerLife, coolPercentage, flowRate, flowSetPoint, fluidTemperature, heatPercentage, importedColdTemp, pressureIn, pressureOut, pressureTank, tankLevel, tankSetPoint, tempCondenser, tempDUTInput, tempDynamicSetPt, tempSetPoint, tempStage2Evap, tempTXVBulb));
        Assert.assertTrue((boolean)(item instanceof Chiller_ChillerTelemetry));
        Chiller_ChillerTelemetry item_ = (Chiller_ChillerTelemetry)item;
        Assert.assertEquals((double)cascadeSetPoint, (double)item_.getCascadeSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)chillerPumpLife, (double)item_.getChillerPumpLife(), (double)1.0E-6f);
        Assert.assertEquals((double)chillerValveAct, (double)item_.getChillerValveAct(), (double)1.0E-6f);
        Assert.assertEquals((double)compressorLife, (double)item_.getCompressorLife(), (double)1.0E-6f);
        Assert.assertEquals((double)controllerLife, (double)item_.getControllerLife(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPercentage, (double)item_.getCoolPercentage(), (double)1.0E-6f);
        Assert.assertEquals((double)flowRate, (double)item_.getFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)flowSetPoint, (double)item_.getFlowSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)fluidTemperature, (double)item_.getFluidTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)heatPercentage, (double)item_.getHeatPercentage(), (double)1.0E-6f);
        Assert.assertEquals((double)importedColdTemp, (double)item_.getImportedColdTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureIn, (double)item_.getPressureIn(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureOut, (double)item_.getPressureOut(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureTank, (double)item_.getPressureTank(), (double)1.0E-6f);
        Assert.assertEquals((double)tankLevel, (double)item_.getTankLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)tankSetPoint, (double)item_.getTankSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCondenser, (double)item_.getTempCondenser(), (double)1.0E-6f);
        Assert.assertEquals((double)tempDUTInput, (double)item_.getTempDUTInput(), (double)1.0E-6f);
        Assert.assertEquals((double)tempDynamicSetPt, (double)item_.getTempDynamicSetPt(), (double)1.0E-6f);
        Assert.assertEquals((double)tempSetPoint, (double)item_.getTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempStage2Evap, (double)item_.getTempStage2Evap(), (double)1.0E-6f);
        Assert.assertEquals((double)tempTXVBulb, (double)item_.getTempTXVBulb(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_FParam_TrendingTelemetry() throws Exception {
        double bubblev_TIME = 0.56568443775177;
        double clr_KI_SETPT = 0.9435044527053833;
        double cold_PERIOD = 0.7157146334648132;
        double cool_CAPACITY = 0.8211161494255066;
        double dut_DT_HI = 0.5603989362716675;
        double dut_DT_LO = 0.20266777276992798;
        double dut_KI = 0.5236191153526306;
        double dut_KP = 0.2026004195213318;
        double dut_TMAX = 0.3612499237060547;
        double dut_TMIN = 0.9044482111930847;
        double flowmeter_LO = 0.12287229299545288;
        double flow_ERR_MASK = 0.2926226258277893;
        double heat_CAPACITY = 0.9003398418426514;
        double heat_PERIOD = 0.02122288942337036;
        double pid_GAINFAC = 0.8797598481178284;
        double pid_KD = 0.0970568060874939;
        double pid_KI = 0.3743353486061096;
        double pid_KP = 0.8570195436477661;
        double purge_TIME = 0.7464203834533691;
        double ramp_DEFAULT = 0.1108478307723999;
        double refrig_OFF = 0.7083825469017029;
        double setpt_SETTLE = 0.3303794264793396;
        double setpt_TOL = 0.46652013063430786;
        double tank_SETPOINT = 0.3113839030265808;
        double thermsl_MASS = 0.3494352698326111;
        double t_CTRL_MODE = 0.3349667191505432;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_FParam_TrendingTelemetry(bubblev_TIME, clr_KI_SETPT, cold_PERIOD, cool_CAPACITY, dut_DT_HI, dut_DT_LO, dut_KI, dut_KP, dut_TMAX, dut_TMIN, flowmeter_LO, flow_ERR_MASK, heat_CAPACITY, heat_PERIOD, pid_GAINFAC, pid_KD, pid_KI, pid_KP, purge_TIME, ramp_DEFAULT, refrig_OFF, setpt_SETTLE, setpt_TOL, tank_SETPOINT, thermsl_MASS, t_CTRL_MODE));
        Assert.assertTrue((boolean)(item instanceof Chiller_FParam_TrendingTelemetry));
        Chiller_FParam_TrendingTelemetry item_ = (Chiller_FParam_TrendingTelemetry)item;
        Assert.assertEquals((double)bubblev_TIME, (double)item_.getBubblev_TIME(), (double)1.0E-6f);
        Assert.assertEquals((double)clr_KI_SETPT, (double)item_.getClr_KI_SETPT(), (double)1.0E-6f);
        Assert.assertEquals((double)cold_PERIOD, (double)item_.getCold_PERIOD(), (double)1.0E-6f);
        Assert.assertEquals((double)cool_CAPACITY, (double)item_.getCool_CAPACITY(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_DT_HI, (double)item_.getDut_DT_HI(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_DT_LO, (double)item_.getDut_DT_LO(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_KI, (double)item_.getDut_KI(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_KP, (double)item_.getDut_KP(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_TMAX, (double)item_.getDut_TMAX(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_TMIN, (double)item_.getDut_TMIN(), (double)1.0E-6f);
        Assert.assertEquals((double)flowmeter_LO, (double)item_.getFlowmeter_LO(), (double)1.0E-6f);
        Assert.assertEquals((double)flow_ERR_MASK, (double)item_.getFlow_ERR_MASK(), (double)1.0E-6f);
        Assert.assertEquals((double)heat_CAPACITY, (double)item_.getHeat_CAPACITY(), (double)1.0E-6f);
        Assert.assertEquals((double)heat_PERIOD, (double)item_.getHeat_PERIOD(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_GAINFAC, (double)item_.getPid_GAINFAC(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KD, (double)item_.getPid_KD(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KI, (double)item_.getPid_KI(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KP, (double)item_.getPid_KP(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_TIME, (double)item_.getPurge_TIME(), (double)1.0E-6f);
        Assert.assertEquals((double)ramp_DEFAULT, (double)item_.getRamp_DEFAULT(), (double)1.0E-6f);
        Assert.assertEquals((double)refrig_OFF, (double)item_.getRefrig_OFF(), (double)1.0E-6f);
        Assert.assertEquals((double)setpt_SETTLE, (double)item_.getSetpt_SETTLE(), (double)1.0E-6f);
        Assert.assertEquals((double)setpt_TOL, (double)item_.getSetpt_TOL(), (double)1.0E-6f);
        Assert.assertEquals((double)tank_SETPOINT, (double)item_.getTank_SETPOINT(), (double)1.0E-6f);
        Assert.assertEquals((double)thermsl_MASS, (double)item_.getThermsl_MASS(), (double)1.0E-6f);
        Assert.assertEquals((double)t_CTRL_MODE, (double)item_.getT_CTRL_MODE(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_Maq20Telemetry() throws Exception {
        double ambientTemp = 0.1378955841064453;
        double coldPlHeatXfer = 0.4372509f;
        double coolantHXOut = 0.5971024036407471;
        double coolantHeatXfer = 0.48422425985336304;
        double coolantPumpIn = 0.23031479120254517;
        double coolantPumpOut = 0.34547924995422363;
        double coolantReturn = 0.5456147193908691;
        double coolantSupply = 0.38366132974624634;
        double glycChillerIn = 0.7075849175453186;
        double glycChillerOut = 0.6024907827377319;
        double glycCondensOut = 0.325341f;
        double glycDeSuHtrFlow = 0.5572124719619751;
        double glycDeSuHtrOut = 0.41505998373031616;
        double glycFanIn = 0.7670267224311829;
        double glycFanOut = 0.3575679063796997;
        double glycHeatXfer = 0.846003532409668;
        double glycInputFlow = 0.28513604402542114;
        double pBurstReturn = 0.7324286103248596;
        double pBurstSupply = 0.7612669467926025;
        double stg1CondensOut = 0.827907f;
        double stg1Discharge = 0.5566155314445496;
        double stg1Return = 0.06641978025436401;
        double stg1TXVBulb = 0.44267964363098145;
        double stg2DeSuHtrOut = 0.9191878437995911;
        double stg2Discharge = 0.17409104108810425;
        double stg2DischargeP = 0.2152794f;
        double stg2EvapIn = 0.15327203273773193;
        double stg2EvapOut = 0.9256841540336609;
        double stg2Return = 0.8590456247329712;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_Maq20Telemetry(ambientTemp, coldPlHeatXfer, coolantHXOut, coolantHeatXfer, coolantPumpIn, coolantPumpOut, coolantReturn, coolantSupply, glycChillerIn, glycChillerOut, glycCondensOut, glycDeSuHtrFlow, glycDeSuHtrOut, glycFanIn, glycFanOut, glycHeatXfer, glycInputFlow, pBurstReturn, pBurstSupply, stg1CondensOut, stg1Discharge, stg1Return, stg1TXVBulb, stg2DeSuHtrOut, stg2Discharge, stg2DischargeP, stg2EvapIn, stg2EvapOut, stg2Return));
        Assert.assertTrue((boolean)(item instanceof Chiller_Maq20Telemetry));
        Chiller_Maq20Telemetry item_ = (Chiller_Maq20Telemetry)item;
        Assert.assertEquals((double)ambientTemp, (double)item_.getAmbientTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coldPlHeatXfer, (double)item_.getColdPlHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantHXOut, (double)item_.getCoolantHXOut(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantHeatXfer, (double)item_.getCoolantHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantPumpIn, (double)item_.getCoolantPumpIn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantPumpOut, (double)item_.getCoolantPumpOut(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantReturn, (double)item_.getCoolantReturn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantSupply, (double)item_.getCoolantSupply(), (double)1.0E-6f);
        Assert.assertEquals((double)glycChillerIn, (double)item_.getGlycChillerIn(), (double)1.0E-6f);
        Assert.assertEquals((double)glycChillerOut, (double)item_.getGlycChillerOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycCondensOut, (double)item_.getGlycCondensOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycDeSuHtrFlow, (double)item_.getGlycDeSuHtrFlow(), (double)1.0E-6f);
        Assert.assertEquals((double)glycDeSuHtrOut, (double)item_.getGlycDeSuHtrOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycFanIn, (double)item_.getGlycFanIn(), (double)1.0E-6f);
        Assert.assertEquals((double)glycFanOut, (double)item_.getGlycFanOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycHeatXfer, (double)item_.getGlycHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)glycInputFlow, (double)item_.getGlycInputFlow(), (double)1.0E-6f);
        Assert.assertEquals((double)pBurstReturn, (double)item_.getPBurstReturn(), (double)1.0E-6f);
        Assert.assertEquals((double)pBurstSupply, (double)item_.getPBurstSupply(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1CondensOut, (double)item_.getStg1CondensOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1Discharge, (double)item_.getStg1Discharge(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1Return, (double)item_.getStg1Return(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1TXVBulb, (double)item_.getStg1TXVBulb(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2DeSuHtrOut, (double)item_.getStg2DeSuHtrOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2Discharge, (double)item_.getStg2Discharge(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2DischargeP, (double)item_.getStg2DischargeP(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2EvapIn, (double)item_.getStg2EvapIn(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2EvapOut, (double)item_.getStg2EvapOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2Return, (double)item_.getStg2Return(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Cold_TempTelemetry() throws Exception {
        double avgColdTemp = 0.3129313588142395;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Cold_TempTelemetry(avgColdTemp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Cold_TempTelemetry));
        Thermal_Cold_TempTelemetry item_ = (Thermal_Cold_TempTelemetry)item;
        Assert.assertEquals((double)avgColdTemp, (double)item_.getAvgColdTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Cryo_TempTelemetry() throws Exception {
        double avgCryoTemp = 0.3925696015357971;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Cryo_TempTelemetry(avgCryoTemp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Cryo_TempTelemetry));
        Thermal_Cryo_TempTelemetry item_ = (Thermal_Cryo_TempTelemetry)item;
        Assert.assertEquals((double)avgCryoTemp, (double)item_.getAvgCryoTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_RtdTelemetry() throws Exception {
        double[] cold_TempCLP = TestHelper.generateDoubleArray((int)25, (int)155966055);
        double[] cryo_TempCYP = TestHelper.generateDoubleArray((int)25, (int)1102303261);
        double[] grid_TempCFX = TestHelper.generateDoubleArray((int)25, (int)-508843352);
        double[] grid_TempGFX = TestHelper.generateDoubleArray((int)25, (int)1122474149);
        double[] grid_TempGRD = TestHelper.generateDoubleArray((int)25, (int)2095279694);
        String location = "u";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_RtdTelemetry(cold_TempCLP, cryo_TempCYP, grid_TempCFX, grid_TempGFX, grid_TempGRD, location));
        Assert.assertTrue((boolean)(item instanceof Thermal_RtdTelemetry));
        Thermal_RtdTelemetry item_ = (Thermal_RtdTelemetry)item;
        Assert.assertArrayEquals((double[])cold_TempCLP, (double[])item_.getCold_TempCLP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_TempCYP, (double[])item_.getCryo_TempCYP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_TempCFX, (double[])item_.getGrid_TempCFX(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_TempGFX, (double[])item_.getGrid_TempGFX(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_TempGRD, (double[])item_.getGrid_TempGRD(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveThermal_TrimTelemetry() throws Exception {
        String location = "n";
        double[] trim_Htrs_ColdI = TestHelper.generateDoubleArray((int)6, (int)1471725869);
        double[] trim_Htrs_ColdP = TestHelper.generateDoubleArray((int)6, (int)-957802267);
        double[] trim_Htrs_ColdV = TestHelper.generateDoubleArray((int)6, (int)1544391349);
        double[] trim_Htrs_CryoI = TestHelper.generateDoubleArray((int)6, (int)-1729018270);
        double[] trim_Htrs_CryoP = TestHelper.generateDoubleArray((int)6, (int)-129340832);
        double[] trim_Htrs_CryoV = TestHelper.generateDoubleArray((int)6, (int)-1113353909);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_TrimTelemetry(location, trim_Htrs_ColdI, trim_Htrs_ColdP, trim_Htrs_ColdV, trim_Htrs_CryoI, trim_Htrs_CryoP, trim_Htrs_CryoV));
        Assert.assertTrue((boolean)(item instanceof Thermal_TrimTelemetry));
        Thermal_TrimTelemetry item_ = (Thermal_TrimTelemetry)item;
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])trim_Htrs_ColdI, (double[])item_.getTrim_Htrs_ColdI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_ColdP, (double[])item_.getTrim_Htrs_ColdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_ColdV, (double[])item_.getTrim_Htrs_ColdV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_CryoI, (double[])item_.getTrim_Htrs_CryoI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_CryoP, (double[])item_.getTrim_Htrs_CryoP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_CryoV, (double[])item_.getTrim_Htrs_CryoV(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Trim_HtrsTelemetry() throws Exception {
        double coldtotal_P = 0.648055374622345;
        double cryototal_P = 0.506066f;
        double htrBulkTmp = 0.7507975697517395;
        double htrbulk_I = 0.4495378f;
        double htrbulk_P = 0.9847127795219421;
        double htrbulk_V = 0.9761347770690918;
        double htrPsTmp = 0.913657009601593;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Trim_HtrsTelemetry(coldtotal_P, cryototal_P, htrBulkTmp, htrbulk_I, htrbulk_P, htrbulk_V, htrPsTmp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Trim_HtrsTelemetry));
        Thermal_Trim_HtrsTelemetry item_ = (Thermal_Trim_HtrsTelemetry)item;
        Assert.assertEquals((double)coldtotal_P, (double)item_.getColdtotal_P(), (double)1.0E-6f);
        Assert.assertEquals((double)cryototal_P, (double)item_.getCryototal_P(), (double)1.0E-6f);
        Assert.assertEquals((double)htrBulkTmp, (double)item_.getHtrBulkTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_I, (double)item_.getHtrbulk_I(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_P, (double)item_.getHtrbulk_P(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_V, (double)item_.getHtrbulk_V(), (double)1.0E-6f);
        Assert.assertEquals((double)htrPsTmp, (double)item_.getHtrPsTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_BodyTelemetry() throws Exception {
        double ambAirtemp = 0.5972207188606262;
        double averageTemp = 0.5012385845184326;
        double backFlngXMinusTemp = 0.961575f;
        double backFlngXPlusTemp = 0.06002265214920044;
        double backFlngYMinusTemp = 0.7410497069358826;
        double camBodyXPlusTemp = 0.5761128664016724;
        double camBodyYMinusTemp = 0.8920538425445557;
        double camBodyYPlusTemp = 0.613198f;
        double camHousXMinusTemp = 0.4049862027168274;
        double camHousXPlusTemp = 0.10606098175048828;
        double camHousYMinusTemp = 0.909494936466217;
        double camHousYPlusTemp = 0.0759924054145813;
        double chgrYMinusRtnAirTemp = 0.17908191680908203;
        double chgrYMinusRtnAirVel = 0.8294159173965454;
        double domeXMinusTemp = 0.008644461631774902;
        double domeYMinusTemp = 0.6005549430847168;
        double l1XMinusTemp = 0.6782124638557434;
        double l1YMinusTemp = 0.03945833444595337;
        double l2XMinusTemp = 0.7707338929176331;
        double l2XPlusTemp = 0.31961536407470703;
        double l2YMinusTemp = 0.19612336158752441;
        double l2YPlusTemp = 0.6689494252204895;
        double shrdRngXMinusTemp = 0.9490625262260437;
        double shrdRngXPlusTemp = 0.8739323019981384;
        double shrdRngYMinusTemp = 0.3197711110115051;
        double shrdRngYPlusTemp = 0.9838021397590637;
        double shtrEboxRtnAirTemp = 0.5847606062889099;
        double shtrEboxRtnAirVel = 0.7640329599380493;
        double shtrMtrRtnAirTemp = 0.5696356296539307;
        double shtrMtrRtnAirVel = 0.2334162f;
        double vPPlenumInTemp = 0.1792042851448059;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_BodyTelemetry(ambAirtemp, averageTemp, backFlngXMinusTemp, backFlngXPlusTemp, backFlngYMinusTemp, camBodyXPlusTemp, camBodyYMinusTemp, camBodyYPlusTemp, camHousXMinusTemp, camHousXPlusTemp, camHousYMinusTemp, camHousYPlusTemp, chgrYMinusRtnAirTemp, chgrYMinusRtnAirVel, domeXMinusTemp, domeYMinusTemp, l1XMinusTemp, l1YMinusTemp, l2XMinusTemp, l2XPlusTemp, l2YMinusTemp, l2YPlusTemp, shrdRngXMinusTemp, shrdRngXPlusTemp, shrdRngYMinusTemp, shrdRngYPlusTemp, shtrEboxRtnAirTemp, shtrEboxRtnAirVel, shtrMtrRtnAirTemp, shtrMtrRtnAirVel, vPPlenumInTemp));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_BodyTelemetry));
        Utiltrunk_BodyTelemetry item_ = (Utiltrunk_BodyTelemetry)item;
        Assert.assertEquals((double)ambAirtemp, (double)item_.getAmbAirtemp(), (double)1.0E-6f);
        Assert.assertEquals((double)averageTemp, (double)item_.getAverageTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngXMinusTemp, (double)item_.getBackFlngXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngXPlusTemp, (double)item_.getBackFlngXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngYMinusTemp, (double)item_.getBackFlngYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyXPlusTemp, (double)item_.getCamBodyXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyYMinusTemp, (double)item_.getCamBodyYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyYPlusTemp, (double)item_.getCamBodyYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousXMinusTemp, (double)item_.getCamHousXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousXPlusTemp, (double)item_.getCamHousXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousYMinusTemp, (double)item_.getCamHousYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousYPlusTemp, (double)item_.getCamHousYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)chgrYMinusRtnAirTemp, (double)item_.getChgrYMinusRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)chgrYMinusRtnAirVel, (double)item_.getChgrYMinusRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)domeXMinusTemp, (double)item_.getDomeXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)domeYMinusTemp, (double)item_.getDomeYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l1XMinusTemp, (double)item_.getL1XMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l1YMinusTemp, (double)item_.getL1YMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2XMinusTemp, (double)item_.getL2XMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2XPlusTemp, (double)item_.getL2XPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2YMinusTemp, (double)item_.getL2YMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2YPlusTemp, (double)item_.getL2YPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngXMinusTemp, (double)item_.getShrdRngXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngXPlusTemp, (double)item_.getShrdRngXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngYMinusTemp, (double)item_.getShrdRngYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngYPlusTemp, (double)item_.getShrdRngYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrEboxRtnAirTemp, (double)item_.getShtrEboxRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrEboxRtnAirVel, (double)item_.getShtrEboxRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrMtrRtnAirTemp, (double)item_.getShtrMtrRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrMtrRtnAirVel, (double)item_.getShtrMtrRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)vPPlenumInTemp, (double)item_.getVPPlenumInTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_MPCTelemetry() throws Exception {
        double avgAirtempOut = 0.17751234769821167;
        double deltaPressFilt = 0.6096802949905396;
        double deltaPressTotal = 0.3850038f;
        double deltaTempAct = 0.3212601f;
        double fanRunTime = 0.12143063545227051;
        double fanSpeed = 0.6722326874732971;
        double humidity = 0.16477346420288086;
        double preFiltPress = 0.9230954051017761;
        double retnAirTemp = 0.3010326027870178;
        double retnPress = 0.4051675796508789;
        double splyAirTemp = 0.7637467384338379;
        double splyPress = 0.23367607593536377;
        double valvePosn = 0.7125484943389893;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_MPCTelemetry(avgAirtempOut, deltaPressFilt, deltaPressTotal, deltaTempAct, fanRunTime, fanSpeed, humidity, preFiltPress, retnAirTemp, retnPress, splyAirTemp, splyPress, valvePosn));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_MPCTelemetry));
        Utiltrunk_MPCTelemetry item_ = (Utiltrunk_MPCTelemetry)item;
        Assert.assertEquals((double)avgAirtempOut, (double)item_.getAvgAirtempOut(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressFilt, (double)item_.getDeltaPressFilt(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressTotal, (double)item_.getDeltaPressTotal(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaTempAct, (double)item_.getDeltaTempAct(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)humidity, (double)item_.getHumidity(), (double)1.0E-6f);
        Assert.assertEquals((double)preFiltPress, (double)item_.getPreFiltPress(), (double)1.0E-6f);
        Assert.assertEquals((double)retnAirTemp, (double)item_.getRetnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)retnPress, (double)item_.getRetnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirTemp, (double)item_.getSplyAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)splyPress, (double)item_.getSplyPress(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_UTTelemetry() throws Exception {
        double averageTemp = 0.3489282727241516;
        double coolFlowRate = 0.7920134663581848;
        double coolPipeRetnTemp = 0.2158851f;
        double coolPipeSplyTemp = 0.29380446672439575;
        double coolReturnPrs = 0.057293057441711426;
        double coolSupplyPrs = 0.012272298336029053;
        double domeXMinusTemp = 0.848663866519928;
        double domeYMinusTemp = 0.8394546508789062;
        double fanInletTemp = 0.4971665143966675;
        double fanRunTime = 0.5095604062080383;
        double fanSpeed = 0.8725516200065613;
        double midXMinusTemp = 0.32867681980133057;
        double midXPlusTemp = 0.6984619498252869;
        double suppXMinusTemp = 0.7952814102172852;
        double suppXPlusTemp = 0.37395572662353516;
        double topXMinusTemp = 0.6260892748832703;
        double topXPlusTemp = 0.7153884172439575;
        double valvePosn = 0.7642527222633362;
        double w2Q1Temp = 0.10452711582183838;
        double w4Q3Temp = 0.4485195279121399;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_UTTelemetry(averageTemp, coolFlowRate, coolPipeRetnTemp, coolPipeSplyTemp, coolReturnPrs, coolSupplyPrs, domeXMinusTemp, domeYMinusTemp, fanInletTemp, fanRunTime, fanSpeed, midXMinusTemp, midXPlusTemp, suppXMinusTemp, suppXPlusTemp, topXMinusTemp, topXPlusTemp, valvePosn, w2Q1Temp, w4Q3Temp));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_UTTelemetry));
        Utiltrunk_UTTelemetry item_ = (Utiltrunk_UTTelemetry)item;
        Assert.assertEquals((double)averageTemp, (double)item_.getAverageTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPipeRetnTemp, (double)item_.getCoolPipeRetnTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPipeSplyTemp, (double)item_.getCoolPipeSplyTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolReturnPrs, (double)item_.getCoolReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)coolSupplyPrs, (double)item_.getCoolSupplyPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)domeXMinusTemp, (double)item_.getDomeXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)domeYMinusTemp, (double)item_.getDomeYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanInletTemp, (double)item_.getFanInletTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)midXMinusTemp, (double)item_.getMidXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)midXPlusTemp, (double)item_.getMidXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)suppXMinusTemp, (double)item_.getSuppXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)suppXPlusTemp, (double)item_.getSuppXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)topXMinusTemp, (double)item_.getTopXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)topXPlusTemp, (double)item_.getTopXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)w2Q1Temp, (double)item_.getW2Q1Temp(), (double)1.0E-6f);
        Assert.assertEquals((double)w4Q3Temp, (double)item_.getW4Q3Temp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_VPCTelemetry() throws Exception {
        double deltaPressFilt = 0.23581701517105103;
        double deltaPressTotal = 0.865895688533783;
        double deltaTempAct = 0.27686625719070435;
        double fanRunTime = 0.49128222465515137;
        double fanSpeed = 0.7071758508682251;
        double htrCurrent = 0.5853912830352783;
        double humidity = 0.7518026232719421;
        double preFiltPress = 0.581121563911438;
        double retnAirTemp = 0.5974168181419373;
        double retnPress = 0.7062533497810364;
        double splyAirTemp = 0.5366419553756714;
        double splyAirVel = 0.7753937244415283;
        double splyPress = 0.48055553436279297;
        double valvePosn = 0.5190884470939636;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_VPCTelemetry(deltaPressFilt, deltaPressTotal, deltaTempAct, fanRunTime, fanSpeed, htrCurrent, humidity, preFiltPress, retnAirTemp, retnPress, splyAirTemp, splyAirVel, splyPress, valvePosn));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_VPCTelemetry));
        Utiltrunk_VPCTelemetry item_ = (Utiltrunk_VPCTelemetry)item;
        Assert.assertEquals((double)deltaPressFilt, (double)item_.getDeltaPressFilt(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressTotal, (double)item_.getDeltaPressTotal(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaTempAct, (double)item_.getDeltaTempAct(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)htrCurrent, (double)item_.getHtrCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)humidity, (double)item_.getHumidity(), (double)1.0E-6f);
        Assert.assertEquals((double)preFiltPress, (double)item_.getPreFiltPress(), (double)1.0E-6f);
        Assert.assertEquals((double)retnAirTemp, (double)item_.getRetnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)retnPress, (double)item_.getRetnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirTemp, (double)item_.getSplyAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirVel, (double)item_.getSplyAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)splyPress, (double)item_.getSplyPress(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
    }
}

