package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Vacuum_CryoTelemetry extends CameraTelemetry {
  private final double airPressure;

  private final double cryoVac;

  private final double flineCurrent;

  private final double flinePower;

  private final double flineVoltage;

  private final double forelineVac;

  private final double gaugeDose;

  private final double pumpCartPressure;

  private final double turboCurrent;

  private final double turboCycleNumber;

  private final double turboCycleTime;

  private final double turboGaugeDose;

  private final double turboHours;

  private final double turboPower;

  private final double turboPumpStatus;

  private final double turboPumpTemp;

  private final double turboSpeed;

  private final double turboVac;

  private final double turboVoltage;

  public Vacuum_CryoTelemetry(double airPressure, double cryoVac, double flineCurrent,
      double flinePower, double flineVoltage, double forelineVac, double gaugeDose,
      double pumpCartPressure, double turboCurrent, double turboCycleNumber, double turboCycleTime,
      double turboGaugeDose, double turboHours, double turboPower, double turboPumpStatus,
      double turboPumpTemp, double turboSpeed, double turboVac, double turboVoltage) {
    this.airPressure = airPressure;
    this.cryoVac = cryoVac;
    this.flineCurrent = flineCurrent;
    this.flinePower = flinePower;
    this.flineVoltage = flineVoltage;
    this.forelineVac = forelineVac;
    this.gaugeDose = gaugeDose;
    this.pumpCartPressure = pumpCartPressure;
    this.turboCurrent = turboCurrent;
    this.turboCycleNumber = turboCycleNumber;
    this.turboCycleTime = turboCycleTime;
    this.turboGaugeDose = turboGaugeDose;
    this.turboHours = turboHours;
    this.turboPower = turboPower;
    this.turboPumpStatus = turboPumpStatus;
    this.turboPumpTemp = turboPumpTemp;
    this.turboSpeed = turboSpeed;
    this.turboVac = turboVac;
    this.turboVoltage = turboVoltage;
  }

  public double getAirPressure() {
    return airPressure;
  }

  public double getCryoVac() {
    return cryoVac;
  }

  public double getFlineCurrent() {
    return flineCurrent;
  }

  public double getFlinePower() {
    return flinePower;
  }

  public double getFlineVoltage() {
    return flineVoltage;
  }

  public double getForelineVac() {
    return forelineVac;
  }

  public double getGaugeDose() {
    return gaugeDose;
  }

  public double getPumpCartPressure() {
    return pumpCartPressure;
  }

  public double getTurboCurrent() {
    return turboCurrent;
  }

  public double getTurboCycleNumber() {
    return turboCycleNumber;
  }

  public double getTurboCycleTime() {
    return turboCycleTime;
  }

  public double getTurboGaugeDose() {
    return turboGaugeDose;
  }

  public double getTurboHours() {
    return turboHours;
  }

  public double getTurboPower() {
    return turboPower;
  }

  public double getTurboPumpStatus() {
    return turboPumpStatus;
  }

  public double getTurboPumpTemp() {
    return turboPumpTemp;
  }

  public double getTurboSpeed() {
    return turboSpeed;
  }

  public double getTurboVac() {
    return turboVac;
  }

  public double getTurboVoltage() {
    return turboVoltage;
  }

  @Override
  public String toString() {
    return "Vacuum_CryoTelemetry{" + "airPressure=" + airPressure +", cryoVac=" + cryoVac +
        ", flineCurrent=" + flineCurrent +", flinePower=" + flinePower +
        ", flineVoltage=" + flineVoltage +", forelineVac=" + forelineVac +
        ", gaugeDose=" + gaugeDose +", pumpCartPressure=" + pumpCartPressure +
        ", turboCurrent=" + turboCurrent +", turboCycleNumber=" + turboCycleNumber +
        ", turboCycleTime=" + turboCycleTime +", turboGaugeDose=" + turboGaugeDose +
        ", turboHours=" + turboHours +", turboPower=" + turboPower +
        ", turboPumpStatus=" + turboPumpStatus +", turboPumpTemp=" + turboPumpTemp +
        ", turboSpeed=" + turboSpeed +", turboVac=" + turboVac +", turboVoltage=" + turboVoltage +
        "}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double airPressure;

    private double cryoVac;

    private double flineCurrent;

    private double flinePower;

    private double flineVoltage;

    private double forelineVac;

    private double gaugeDose;

    private double pumpCartPressure;

    private double turboCurrent;

    private double turboCycleNumber;

    private double turboCycleTime;

    private double turboGaugeDose;

    private double turboHours;

    private double turboPower;

    private double turboPumpStatus;

    private double turboPumpTemp;

    private double turboSpeed;

    private double turboVac;

    private double turboVoltage;

    private Builder() {
    }

    public Builder airPressure(double airPressure) {
      this.airPressure = airPressure;
      return this;
    }

    public Builder cryoVac(double cryoVac) {
      this.cryoVac = cryoVac;
      return this;
    }

    public Builder flineCurrent(double flineCurrent) {
      this.flineCurrent = flineCurrent;
      return this;
    }

    public Builder flinePower(double flinePower) {
      this.flinePower = flinePower;
      return this;
    }

    public Builder flineVoltage(double flineVoltage) {
      this.flineVoltage = flineVoltage;
      return this;
    }

    public Builder forelineVac(double forelineVac) {
      this.forelineVac = forelineVac;
      return this;
    }

    public Builder gaugeDose(double gaugeDose) {
      this.gaugeDose = gaugeDose;
      return this;
    }

    public Builder pumpCartPressure(double pumpCartPressure) {
      this.pumpCartPressure = pumpCartPressure;
      return this;
    }

    public Builder turboCurrent(double turboCurrent) {
      this.turboCurrent = turboCurrent;
      return this;
    }

    public Builder turboCycleNumber(double turboCycleNumber) {
      this.turboCycleNumber = turboCycleNumber;
      return this;
    }

    public Builder turboCycleTime(double turboCycleTime) {
      this.turboCycleTime = turboCycleTime;
      return this;
    }

    public Builder turboGaugeDose(double turboGaugeDose) {
      this.turboGaugeDose = turboGaugeDose;
      return this;
    }

    public Builder turboHours(double turboHours) {
      this.turboHours = turboHours;
      return this;
    }

    public Builder turboPower(double turboPower) {
      this.turboPower = turboPower;
      return this;
    }

    public Builder turboPumpStatus(double turboPumpStatus) {
      this.turboPumpStatus = turboPumpStatus;
      return this;
    }

    public Builder turboPumpTemp(double turboPumpTemp) {
      this.turboPumpTemp = turboPumpTemp;
      return this;
    }

    public Builder turboSpeed(double turboSpeed) {
      this.turboSpeed = turboSpeed;
      return this;
    }

    public Builder turboVac(double turboVac) {
      this.turboVac = turboVac;
      return this;
    }

    public Builder turboVoltage(double turboVoltage) {
      this.turboVoltage = turboVoltage;
      return this;
    }

    public Vacuum_CryoTelemetry build() {
      return new Vacuum_CryoTelemetry(airPressure, cryoVac, flineCurrent, flinePower, flineVoltage, forelineVac, gaugeDose, pumpCartPressure, turboCurrent, turboCycleNumber, turboCycleTime, turboGaugeDose, turboHours, turboPower, turboPumpStatus, turboPumpTemp, turboSpeed, turboVac, turboVoltage);
    }
  }
}
