package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Utiltrunk_VPCTelemetry extends CameraTelemetry {
  private final double deltaPressFilt;

  private final double deltaPressTotal;

  private final double deltaTempAct;

  private final double fanRunTime;

  private final double fanSpeed;

  private final double htrCurrent;

  private final double humidity;

  private final double preFiltPress;

  private final double retnAirTemp;

  private final double retnPress;

  private final double splyAirTemp;

  private final double splyAirVel;

  private final double splyPress;

  private final double valvePosn;

  public Utiltrunk_VPCTelemetry(double deltaPressFilt, double deltaPressTotal, double deltaTempAct,
      double fanRunTime, double fanSpeed, double htrCurrent, double humidity, double preFiltPress,
      double retnAirTemp, double retnPress, double splyAirTemp, double splyAirVel, double splyPress,
      double valvePosn) {
    this.deltaPressFilt = deltaPressFilt;
    this.deltaPressTotal = deltaPressTotal;
    this.deltaTempAct = deltaTempAct;
    this.fanRunTime = fanRunTime;
    this.fanSpeed = fanSpeed;
    this.htrCurrent = htrCurrent;
    this.humidity = humidity;
    this.preFiltPress = preFiltPress;
    this.retnAirTemp = retnAirTemp;
    this.retnPress = retnPress;
    this.splyAirTemp = splyAirTemp;
    this.splyAirVel = splyAirVel;
    this.splyPress = splyPress;
    this.valvePosn = valvePosn;
  }

  public double getDeltaPressFilt() {
    return deltaPressFilt;
  }

  public double getDeltaPressTotal() {
    return deltaPressTotal;
  }

  public double getDeltaTempAct() {
    return deltaTempAct;
  }

  public double getFanRunTime() {
    return fanRunTime;
  }

  public double getFanSpeed() {
    return fanSpeed;
  }

  public double getHtrCurrent() {
    return htrCurrent;
  }

  public double getHumidity() {
    return humidity;
  }

  public double getPreFiltPress() {
    return preFiltPress;
  }

  public double getRetnAirTemp() {
    return retnAirTemp;
  }

  public double getRetnPress() {
    return retnPress;
  }

  public double getSplyAirTemp() {
    return splyAirTemp;
  }

  public double getSplyAirVel() {
    return splyAirVel;
  }

  public double getSplyPress() {
    return splyPress;
  }

  public double getValvePosn() {
    return valvePosn;
  }

  @Override
  public String toString() {
    return "Utiltrunk_VPCTelemetry{" + "deltaPressFilt=" + deltaPressFilt +
        ", deltaPressTotal=" + deltaPressTotal +", deltaTempAct=" + deltaTempAct +
        ", fanRunTime=" + fanRunTime +", fanSpeed=" + fanSpeed +", htrCurrent=" + htrCurrent +
        ", humidity=" + humidity +", preFiltPress=" + preFiltPress +", retnAirTemp=" + retnAirTemp +
        ", retnPress=" + retnPress +", splyAirTemp=" + splyAirTemp +", splyAirVel=" + splyAirVel +
        ", splyPress=" + splyPress +", valvePosn=" + valvePosn +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double deltaPressFilt;

    private double deltaPressTotal;

    private double deltaTempAct;

    private double fanRunTime;

    private double fanSpeed;

    private double htrCurrent;

    private double humidity;

    private double preFiltPress;

    private double retnAirTemp;

    private double retnPress;

    private double splyAirTemp;

    private double splyAirVel;

    private double splyPress;

    private double valvePosn;

    private Builder() {
    }

    public Builder deltaPressFilt(double deltaPressFilt) {
      this.deltaPressFilt = deltaPressFilt;
      return this;
    }

    public Builder deltaPressTotal(double deltaPressTotal) {
      this.deltaPressTotal = deltaPressTotal;
      return this;
    }

    public Builder deltaTempAct(double deltaTempAct) {
      this.deltaTempAct = deltaTempAct;
      return this;
    }

    public Builder fanRunTime(double fanRunTime) {
      this.fanRunTime = fanRunTime;
      return this;
    }

    public Builder fanSpeed(double fanSpeed) {
      this.fanSpeed = fanSpeed;
      return this;
    }

    public Builder htrCurrent(double htrCurrent) {
      this.htrCurrent = htrCurrent;
      return this;
    }

    public Builder humidity(double humidity) {
      this.humidity = humidity;
      return this;
    }

    public Builder preFiltPress(double preFiltPress) {
      this.preFiltPress = preFiltPress;
      return this;
    }

    public Builder retnAirTemp(double retnAirTemp) {
      this.retnAirTemp = retnAirTemp;
      return this;
    }

    public Builder retnPress(double retnPress) {
      this.retnPress = retnPress;
      return this;
    }

    public Builder splyAirTemp(double splyAirTemp) {
      this.splyAirTemp = splyAirTemp;
      return this;
    }

    public Builder splyAirVel(double splyAirVel) {
      this.splyAirVel = splyAirVel;
      return this;
    }

    public Builder splyPress(double splyPress) {
      this.splyPress = splyPress;
      return this;
    }

    public Builder valvePosn(double valvePosn) {
      this.valvePosn = valvePosn;
      return this;
    }

    public Utiltrunk_VPCTelemetry build() {
      return new Utiltrunk_VPCTelemetry(deltaPressFilt, deltaPressTotal, deltaTempAct, fanRunTime, fanSpeed, htrCurrent, humidity, preFiltPress, retnAirTemp, retnPress, splyAirTemp, splyAirVel, splyPress, valvePosn);
    }
  }
}
