package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Utiltrunk_MPCTelemetry extends CameraTelemetry {
  private final double avgAirtempOut;

  private final double deltaPressFilt;

  private final double deltaPressTotal;

  private final double deltaTempAct;

  private final double fanRunTime;

  private final double fanSpeed;

  private final double humidity;

  private final double preFiltPress;

  private final double retnAirTemp;

  private final double retnPress;

  private final double splyAirTemp;

  private final double splyPress;

  private final double valvePosn;

  public Utiltrunk_MPCTelemetry(double avgAirtempOut, double deltaPressFilt, double deltaPressTotal,
      double deltaTempAct, double fanRunTime, double fanSpeed, double humidity, double preFiltPress,
      double retnAirTemp, double retnPress, double splyAirTemp, double splyPress,
      double valvePosn) {
    this.avgAirtempOut = avgAirtempOut;
    this.deltaPressFilt = deltaPressFilt;
    this.deltaPressTotal = deltaPressTotal;
    this.deltaTempAct = deltaTempAct;
    this.fanRunTime = fanRunTime;
    this.fanSpeed = fanSpeed;
    this.humidity = humidity;
    this.preFiltPress = preFiltPress;
    this.retnAirTemp = retnAirTemp;
    this.retnPress = retnPress;
    this.splyAirTemp = splyAirTemp;
    this.splyPress = splyPress;
    this.valvePosn = valvePosn;
  }

  public double getAvgAirtempOut() {
    return avgAirtempOut;
  }

  public double getDeltaPressFilt() {
    return deltaPressFilt;
  }

  public double getDeltaPressTotal() {
    return deltaPressTotal;
  }

  public double getDeltaTempAct() {
    return deltaTempAct;
  }

  public double getFanRunTime() {
    return fanRunTime;
  }

  public double getFanSpeed() {
    return fanSpeed;
  }

  public double getHumidity() {
    return humidity;
  }

  public double getPreFiltPress() {
    return preFiltPress;
  }

  public double getRetnAirTemp() {
    return retnAirTemp;
  }

  public double getRetnPress() {
    return retnPress;
  }

  public double getSplyAirTemp() {
    return splyAirTemp;
  }

  public double getSplyPress() {
    return splyPress;
  }

  public double getValvePosn() {
    return valvePosn;
  }

  @Override
  public String toString() {
    return "Utiltrunk_MPCTelemetry{" + "avgAirtempOut=" + avgAirtempOut +
        ", deltaPressFilt=" + deltaPressFilt +", deltaPressTotal=" + deltaPressTotal +
        ", deltaTempAct=" + deltaTempAct +", fanRunTime=" + fanRunTime +", fanSpeed=" + fanSpeed +
        ", humidity=" + humidity +", preFiltPress=" + preFiltPress +", retnAirTemp=" + retnAirTemp +
        ", retnPress=" + retnPress +", splyAirTemp=" + splyAirTemp +", splyPress=" + splyPress +
        ", valvePosn=" + valvePosn +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double avgAirtempOut;

    private double deltaPressFilt;

    private double deltaPressTotal;

    private double deltaTempAct;

    private double fanRunTime;

    private double fanSpeed;

    private double humidity;

    private double preFiltPress;

    private double retnAirTemp;

    private double retnPress;

    private double splyAirTemp;

    private double splyPress;

    private double valvePosn;

    private Builder() {
    }

    public Builder avgAirtempOut(double avgAirtempOut) {
      this.avgAirtempOut = avgAirtempOut;
      return this;
    }

    public Builder deltaPressFilt(double deltaPressFilt) {
      this.deltaPressFilt = deltaPressFilt;
      return this;
    }

    public Builder deltaPressTotal(double deltaPressTotal) {
      this.deltaPressTotal = deltaPressTotal;
      return this;
    }

    public Builder deltaTempAct(double deltaTempAct) {
      this.deltaTempAct = deltaTempAct;
      return this;
    }

    public Builder fanRunTime(double fanRunTime) {
      this.fanRunTime = fanRunTime;
      return this;
    }

    public Builder fanSpeed(double fanSpeed) {
      this.fanSpeed = fanSpeed;
      return this;
    }

    public Builder humidity(double humidity) {
      this.humidity = humidity;
      return this;
    }

    public Builder preFiltPress(double preFiltPress) {
      this.preFiltPress = preFiltPress;
      return this;
    }

    public Builder retnAirTemp(double retnAirTemp) {
      this.retnAirTemp = retnAirTemp;
      return this;
    }

    public Builder retnPress(double retnPress) {
      this.retnPress = retnPress;
      return this;
    }

    public Builder splyAirTemp(double splyAirTemp) {
      this.splyAirTemp = splyAirTemp;
      return this;
    }

    public Builder splyPress(double splyPress) {
      this.splyPress = splyPress;
      return this;
    }

    public Builder valvePosn(double valvePosn) {
      this.valvePosn = valvePosn;
      return this;
    }

    public Utiltrunk_MPCTelemetry build() {
      return new Utiltrunk_MPCTelemetry(avgAirtempOut, deltaPressFilt, deltaPressTotal, deltaTempAct, fanRunTime, fanSpeed, humidity, preFiltPress, retnAirTemp, retnPress, splyAirTemp, splyPress, valvePosn);
    }
  }
}
