package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Thermal_Trim_HtrsTelemetry extends CameraTelemetry {
  private final double coldtotal_P;

  private final double cryototal_P;

  private final double htrBulkTmp;

  private final double htrbulk_I;

  private final double htrbulk_P;

  private final double htrbulk_V;

  private final double htrPsTmp;

  public Thermal_Trim_HtrsTelemetry(double coldtotal_P, double cryototal_P, double htrBulkTmp,
      double htrbulk_I, double htrbulk_P, double htrbulk_V, double htrPsTmp) {
    this.coldtotal_P = coldtotal_P;
    this.cryototal_P = cryototal_P;
    this.htrBulkTmp = htrBulkTmp;
    this.htrbulk_I = htrbulk_I;
    this.htrbulk_P = htrbulk_P;
    this.htrbulk_V = htrbulk_V;
    this.htrPsTmp = htrPsTmp;
  }

  public double getColdtotal_P() {
    return coldtotal_P;
  }

  public double getCryototal_P() {
    return cryototal_P;
  }

  public double getHtrBulkTmp() {
    return htrBulkTmp;
  }

  public double getHtrbulk_I() {
    return htrbulk_I;
  }

  public double getHtrbulk_P() {
    return htrbulk_P;
  }

  public double getHtrbulk_V() {
    return htrbulk_V;
  }

  public double getHtrPsTmp() {
    return htrPsTmp;
  }

  @Override
  public String toString() {
    return "Thermal_Trim_HtrsTelemetry{" + "coldtotal_P=" + coldtotal_P +
        ", cryototal_P=" + cryototal_P +", htrBulkTmp=" + htrBulkTmp +", htrbulk_I=" + htrbulk_I +
        ", htrbulk_P=" + htrbulk_P +", htrbulk_V=" + htrbulk_V +", htrPsTmp=" + htrPsTmp +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double coldtotal_P;

    private double cryototal_P;

    private double htrBulkTmp;

    private double htrbulk_I;

    private double htrbulk_P;

    private double htrbulk_V;

    private double htrPsTmp;

    private Builder() {
    }

    public Builder coldtotal_P(double coldtotal_P) {
      this.coldtotal_P = coldtotal_P;
      return this;
    }

    public Builder cryototal_P(double cryototal_P) {
      this.cryototal_P = cryototal_P;
      return this;
    }

    public Builder htrBulkTmp(double htrBulkTmp) {
      this.htrBulkTmp = htrBulkTmp;
      return this;
    }

    public Builder htrbulk_I(double htrbulk_I) {
      this.htrbulk_I = htrbulk_I;
      return this;
    }

    public Builder htrbulk_P(double htrbulk_P) {
      this.htrbulk_P = htrbulk_P;
      return this;
    }

    public Builder htrbulk_V(double htrbulk_V) {
      this.htrbulk_V = htrbulk_V;
      return this;
    }

    public Builder htrPsTmp(double htrPsTmp) {
      this.htrPsTmp = htrPsTmp;
      return this;
    }

    public Thermal_Trim_HtrsTelemetry build() {
      return new Thermal_Trim_HtrsTelemetry(coldtotal_P, cryototal_P, htrBulkTmp, htrbulk_I, htrbulk_P, htrbulk_V, htrPsTmp);
    }
  }
}
