package org.lsst.sal.camera.telemetry;

import java.util.Arrays;
import org.lsst.sal.camera.CameraTelemetry;

public class Thermal_RtdTelemetry extends CameraTelemetry {
  private final double[] cold_TempCLP;

  private final double[] cryo_TempCYP;

  private final double[] grid_TempCFX;

  private final double[] grid_TempGFX;

  private final double[] grid_TempGRD;

  private final String location;

  public Thermal_RtdTelemetry(double[] cold_TempCLP, double[] cryo_TempCYP, double[] grid_TempCFX,
      double[] grid_TempGFX, double[] grid_TempGRD, String location) {
    this.cold_TempCLP = cold_TempCLP;
    this.cryo_TempCYP = cryo_TempCYP;
    this.grid_TempCFX = grid_TempCFX;
    this.grid_TempGFX = grid_TempGFX;
    this.grid_TempGRD = grid_TempGRD;
    this.location = location;
  }

  public double[] getCold_TempCLP() {
    return cold_TempCLP;
  }

  public double[] getCryo_TempCYP() {
    return cryo_TempCYP;
  }

  public double[] getGrid_TempCFX() {
    return grid_TempCFX;
  }

  public double[] getGrid_TempGFX() {
    return grid_TempGFX;
  }

  public double[] getGrid_TempGRD() {
    return grid_TempGRD;
  }

  public String getLocation() {
    return location;
  }

  @Override
  public String toString() {
    return "Thermal_RtdTelemetry{" + "cold_TempCLP=" + Arrays.toString(cold_TempCLP) +
        ", cryo_TempCYP=" + Arrays.toString(cryo_TempCYP) +
        ", grid_TempCFX=" + Arrays.toString(grid_TempCFX) +
        ", grid_TempGFX=" + Arrays.toString(grid_TempGFX) +
        ", grid_TempGRD=" + Arrays.toString(grid_TempGRD) +", location=" + location +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double[] cold_TempCLP;

    private double[] cryo_TempCYP;

    private double[] grid_TempCFX;

    private double[] grid_TempGFX;

    private double[] grid_TempGRD;

    private String location;

    private Builder() {
    }

    public Builder cold_TempCLP(double[] cold_TempCLP) {
      this.cold_TempCLP = cold_TempCLP;
      return this;
    }

    public Builder cryo_TempCYP(double[] cryo_TempCYP) {
      this.cryo_TempCYP = cryo_TempCYP;
      return this;
    }

    public Builder grid_TempCFX(double[] grid_TempCFX) {
      this.grid_TempCFX = grid_TempCFX;
      return this;
    }

    public Builder grid_TempGFX(double[] grid_TempGFX) {
      this.grid_TempGFX = grid_TempGFX;
      return this;
    }

    public Builder grid_TempGRD(double[] grid_TempGRD) {
      this.grid_TempGRD = grid_TempGRD;
      return this;
    }

    public Builder location(String location) {
      this.location = location;
      return this;
    }

    public Thermal_RtdTelemetry build() {
      return new Thermal_RtdTelemetry(cold_TempCLP, cryo_TempCYP, grid_TempCFX, grid_TempGFX, grid_TempGRD, location);
    }
  }
}
