package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Quadbox_PDU_24VCTelemetry extends CameraTelemetry {
  private final double board_T;

  private final double body_Maq20_I;

  private final double body_Maq20_V;

  private final double cryo_Maq20_I;

  private final double cryo_Maq20_V;

  private final double fes_CarouselC_I;

  private final double fes_CarouselC_V;

  private final double fes_ChangerC_I;

  private final double fes_ChangerC_V;

  private final double fes_LoaderC_I;

  private final double fes_LoaderC_V;

  private final double fpga_T;

  private final double gauges_I;

  private final double gauges_V;

  private final double int_Valves_I;

  private final double int_Valves_V;

  private final double ion_Pumps_I;

  private final double ion_Pumps_V;

  private final double main_I;

  private final double main_T;

  private final double main_V;

  private final double shtr_PLC1_I;

  private final double shtr_PLC1_V;

  private final double shtr_PLC2_I;

  private final double shtr_PLC2_V;

  public Quadbox_PDU_24VCTelemetry(double board_T, double body_Maq20_I, double body_Maq20_V,
      double cryo_Maq20_I, double cryo_Maq20_V, double fes_CarouselC_I, double fes_CarouselC_V,
      double fes_ChangerC_I, double fes_ChangerC_V, double fes_LoaderC_I, double fes_LoaderC_V,
      double fpga_T, double gauges_I, double gauges_V, double int_Valves_I, double int_Valves_V,
      double ion_Pumps_I, double ion_Pumps_V, double main_I, double main_T, double main_V,
      double shtr_PLC1_I, double shtr_PLC1_V, double shtr_PLC2_I, double shtr_PLC2_V) {
    this.board_T = board_T;
    this.body_Maq20_I = body_Maq20_I;
    this.body_Maq20_V = body_Maq20_V;
    this.cryo_Maq20_I = cryo_Maq20_I;
    this.cryo_Maq20_V = cryo_Maq20_V;
    this.fes_CarouselC_I = fes_CarouselC_I;
    this.fes_CarouselC_V = fes_CarouselC_V;
    this.fes_ChangerC_I = fes_ChangerC_I;
    this.fes_ChangerC_V = fes_ChangerC_V;
    this.fes_LoaderC_I = fes_LoaderC_I;
    this.fes_LoaderC_V = fes_LoaderC_V;
    this.fpga_T = fpga_T;
    this.gauges_I = gauges_I;
    this.gauges_V = gauges_V;
    this.int_Valves_I = int_Valves_I;
    this.int_Valves_V = int_Valves_V;
    this.ion_Pumps_I = ion_Pumps_I;
    this.ion_Pumps_V = ion_Pumps_V;
    this.main_I = main_I;
    this.main_T = main_T;
    this.main_V = main_V;
    this.shtr_PLC1_I = shtr_PLC1_I;
    this.shtr_PLC1_V = shtr_PLC1_V;
    this.shtr_PLC2_I = shtr_PLC2_I;
    this.shtr_PLC2_V = shtr_PLC2_V;
  }

  public double getBoard_T() {
    return board_T;
  }

  public double getBody_Maq20_I() {
    return body_Maq20_I;
  }

  public double getBody_Maq20_V() {
    return body_Maq20_V;
  }

  public double getCryo_Maq20_I() {
    return cryo_Maq20_I;
  }

  public double getCryo_Maq20_V() {
    return cryo_Maq20_V;
  }

  public double getFes_CarouselC_I() {
    return fes_CarouselC_I;
  }

  public double getFes_CarouselC_V() {
    return fes_CarouselC_V;
  }

  public double getFes_ChangerC_I() {
    return fes_ChangerC_I;
  }

  public double getFes_ChangerC_V() {
    return fes_ChangerC_V;
  }

  public double getFes_LoaderC_I() {
    return fes_LoaderC_I;
  }

  public double getFes_LoaderC_V() {
    return fes_LoaderC_V;
  }

  public double getFpga_T() {
    return fpga_T;
  }

  public double getGauges_I() {
    return gauges_I;
  }

  public double getGauges_V() {
    return gauges_V;
  }

  public double getInt_Valves_I() {
    return int_Valves_I;
  }

  public double getInt_Valves_V() {
    return int_Valves_V;
  }

  public double getIon_Pumps_I() {
    return ion_Pumps_I;
  }

  public double getIon_Pumps_V() {
    return ion_Pumps_V;
  }

  public double getMain_I() {
    return main_I;
  }

  public double getMain_T() {
    return main_T;
  }

  public double getMain_V() {
    return main_V;
  }

  public double getShtr_PLC1_I() {
    return shtr_PLC1_I;
  }

  public double getShtr_PLC1_V() {
    return shtr_PLC1_V;
  }

  public double getShtr_PLC2_I() {
    return shtr_PLC2_I;
  }

  public double getShtr_PLC2_V() {
    return shtr_PLC2_V;
  }

  @Override
  public String toString() {
    return "Quadbox_PDU_24VCTelemetry{" + "board_T=" + board_T +", body_Maq20_I=" + body_Maq20_I +
        ", body_Maq20_V=" + body_Maq20_V +", cryo_Maq20_I=" + cryo_Maq20_I +
        ", cryo_Maq20_V=" + cryo_Maq20_V +", fes_CarouselC_I=" + fes_CarouselC_I +
        ", fes_CarouselC_V=" + fes_CarouselC_V +", fes_ChangerC_I=" + fes_ChangerC_I +
        ", fes_ChangerC_V=" + fes_ChangerC_V +", fes_LoaderC_I=" + fes_LoaderC_I +
        ", fes_LoaderC_V=" + fes_LoaderC_V +", fpga_T=" + fpga_T +", gauges_I=" + gauges_I +
        ", gauges_V=" + gauges_V +", int_Valves_I=" + int_Valves_I +
        ", int_Valves_V=" + int_Valves_V +", ion_Pumps_I=" + ion_Pumps_I +
        ", ion_Pumps_V=" + ion_Pumps_V +", main_I=" + main_I +", main_T=" + main_T +
        ", main_V=" + main_V +", shtr_PLC1_I=" + shtr_PLC1_I +", shtr_PLC1_V=" + shtr_PLC1_V +
        ", shtr_PLC2_I=" + shtr_PLC2_I +", shtr_PLC2_V=" + shtr_PLC2_V +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double board_T;

    private double body_Maq20_I;

    private double body_Maq20_V;

    private double cryo_Maq20_I;

    private double cryo_Maq20_V;

    private double fes_CarouselC_I;

    private double fes_CarouselC_V;

    private double fes_ChangerC_I;

    private double fes_ChangerC_V;

    private double fes_LoaderC_I;

    private double fes_LoaderC_V;

    private double fpga_T;

    private double gauges_I;

    private double gauges_V;

    private double int_Valves_I;

    private double int_Valves_V;

    private double ion_Pumps_I;

    private double ion_Pumps_V;

    private double main_I;

    private double main_T;

    private double main_V;

    private double shtr_PLC1_I;

    private double shtr_PLC1_V;

    private double shtr_PLC2_I;

    private double shtr_PLC2_V;

    private Builder() {
    }

    public Builder board_T(double board_T) {
      this.board_T = board_T;
      return this;
    }

    public Builder body_Maq20_I(double body_Maq20_I) {
      this.body_Maq20_I = body_Maq20_I;
      return this;
    }

    public Builder body_Maq20_V(double body_Maq20_V) {
      this.body_Maq20_V = body_Maq20_V;
      return this;
    }

    public Builder cryo_Maq20_I(double cryo_Maq20_I) {
      this.cryo_Maq20_I = cryo_Maq20_I;
      return this;
    }

    public Builder cryo_Maq20_V(double cryo_Maq20_V) {
      this.cryo_Maq20_V = cryo_Maq20_V;
      return this;
    }

    public Builder fes_CarouselC_I(double fes_CarouselC_I) {
      this.fes_CarouselC_I = fes_CarouselC_I;
      return this;
    }

    public Builder fes_CarouselC_V(double fes_CarouselC_V) {
      this.fes_CarouselC_V = fes_CarouselC_V;
      return this;
    }

    public Builder fes_ChangerC_I(double fes_ChangerC_I) {
      this.fes_ChangerC_I = fes_ChangerC_I;
      return this;
    }

    public Builder fes_ChangerC_V(double fes_ChangerC_V) {
      this.fes_ChangerC_V = fes_ChangerC_V;
      return this;
    }

    public Builder fes_LoaderC_I(double fes_LoaderC_I) {
      this.fes_LoaderC_I = fes_LoaderC_I;
      return this;
    }

    public Builder fes_LoaderC_V(double fes_LoaderC_V) {
      this.fes_LoaderC_V = fes_LoaderC_V;
      return this;
    }

    public Builder fpga_T(double fpga_T) {
      this.fpga_T = fpga_T;
      return this;
    }

    public Builder gauges_I(double gauges_I) {
      this.gauges_I = gauges_I;
      return this;
    }

    public Builder gauges_V(double gauges_V) {
      this.gauges_V = gauges_V;
      return this;
    }

    public Builder int_Valves_I(double int_Valves_I) {
      this.int_Valves_I = int_Valves_I;
      return this;
    }

    public Builder int_Valves_V(double int_Valves_V) {
      this.int_Valves_V = int_Valves_V;
      return this;
    }

    public Builder ion_Pumps_I(double ion_Pumps_I) {
      this.ion_Pumps_I = ion_Pumps_I;
      return this;
    }

    public Builder ion_Pumps_V(double ion_Pumps_V) {
      this.ion_Pumps_V = ion_Pumps_V;
      return this;
    }

    public Builder main_I(double main_I) {
      this.main_I = main_I;
      return this;
    }

    public Builder main_T(double main_T) {
      this.main_T = main_T;
      return this;
    }

    public Builder main_V(double main_V) {
      this.main_V = main_V;
      return this;
    }

    public Builder shtr_PLC1_I(double shtr_PLC1_I) {
      this.shtr_PLC1_I = shtr_PLC1_I;
      return this;
    }

    public Builder shtr_PLC1_V(double shtr_PLC1_V) {
      this.shtr_PLC1_V = shtr_PLC1_V;
      return this;
    }

    public Builder shtr_PLC2_I(double shtr_PLC2_I) {
      this.shtr_PLC2_I = shtr_PLC2_I;
      return this;
    }

    public Builder shtr_PLC2_V(double shtr_PLC2_V) {
      this.shtr_PLC2_V = shtr_PLC2_V;
      return this;
    }

    public Quadbox_PDU_24VCTelemetry build() {
      return new Quadbox_PDU_24VCTelemetry(board_T, body_Maq20_I, body_Maq20_V, cryo_Maq20_I, cryo_Maq20_V, fes_CarouselC_I, fes_CarouselC_V, fes_ChangerC_I, fes_ChangerC_V, fes_LoaderC_I, fes_LoaderC_V, fpga_T, gauges_I, gauges_V, int_Valves_I, int_Valves_V, ion_Pumps_I, ion_Pumps_V, main_I, main_T, main_V, shtr_PLC1_I, shtr_PLC1_V, shtr_PLC2_I, shtr_PLC2_V);
    }
  }
}
