package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Fcs_Carousel_TrendingTelemetry extends CameraTelemetry {
  private final boolean atStandby;

  private final String clampsStateAtStandby;

  private final int deltaPositionAtStandby;

  private final boolean emptyAtStandby;

  private final int estimatedPosition;

  private final int filterAtStandbyId;

  private final String filterOnAutochangerName;

  private final long minLocked;

  private final int socketAtStandbyID;

  private final String socketAtStandbyName;

  public Fcs_Carousel_TrendingTelemetry(boolean atStandby, String clampsStateAtStandby,
      int deltaPositionAtStandby, boolean emptyAtStandby, int estimatedPosition,
      int filterAtStandbyId, String filterOnAutochangerName, long minLocked, int socketAtStandbyID,
      String socketAtStandbyName) {
    this.atStandby = atStandby;
    this.clampsStateAtStandby = clampsStateAtStandby;
    this.deltaPositionAtStandby = deltaPositionAtStandby;
    this.emptyAtStandby = emptyAtStandby;
    this.estimatedPosition = estimatedPosition;
    this.filterAtStandbyId = filterAtStandbyId;
    this.filterOnAutochangerName = filterOnAutochangerName;
    this.minLocked = minLocked;
    this.socketAtStandbyID = socketAtStandbyID;
    this.socketAtStandbyName = socketAtStandbyName;
  }

  public boolean isAtStandby() {
    return atStandby;
  }

  public String getClampsStateAtStandby() {
    return clampsStateAtStandby;
  }

  public int getDeltaPositionAtStandby() {
    return deltaPositionAtStandby;
  }

  public boolean isEmptyAtStandby() {
    return emptyAtStandby;
  }

  public int getEstimatedPosition() {
    return estimatedPosition;
  }

  public int getFilterAtStandbyId() {
    return filterAtStandbyId;
  }

  public String getFilterOnAutochangerName() {
    return filterOnAutochangerName;
  }

  public long getMinLocked() {
    return minLocked;
  }

  public int getSocketAtStandbyID() {
    return socketAtStandbyID;
  }

  public String getSocketAtStandbyName() {
    return socketAtStandbyName;
  }

  @Override
  public String toString() {
    return "Fcs_Carousel_TrendingTelemetry{" + "atStandby=" + atStandby +
        ", clampsStateAtStandby=" + clampsStateAtStandby +
        ", deltaPositionAtStandby=" + deltaPositionAtStandby +", emptyAtStandby=" + emptyAtStandby +
        ", estimatedPosition=" + estimatedPosition +", filterAtStandbyId=" + filterAtStandbyId +
        ", filterOnAutochangerName=" + filterOnAutochangerName +", minLocked=" + minLocked +
        ", socketAtStandbyID=" + socketAtStandbyID +", socketAtStandbyName=" + socketAtStandbyName +
        "}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private boolean atStandby;

    private String clampsStateAtStandby;

    private int deltaPositionAtStandby;

    private boolean emptyAtStandby;

    private int estimatedPosition;

    private int filterAtStandbyId;

    private String filterOnAutochangerName;

    private long minLocked;

    private int socketAtStandbyID;

    private String socketAtStandbyName;

    private Builder() {
    }

    public Builder atStandby(boolean atStandby) {
      this.atStandby = atStandby;
      return this;
    }

    public Builder clampsStateAtStandby(String clampsStateAtStandby) {
      this.clampsStateAtStandby = clampsStateAtStandby;
      return this;
    }

    public Builder deltaPositionAtStandby(int deltaPositionAtStandby) {
      this.deltaPositionAtStandby = deltaPositionAtStandby;
      return this;
    }

    public Builder emptyAtStandby(boolean emptyAtStandby) {
      this.emptyAtStandby = emptyAtStandby;
      return this;
    }

    public Builder estimatedPosition(int estimatedPosition) {
      this.estimatedPosition = estimatedPosition;
      return this;
    }

    public Builder filterAtStandbyId(int filterAtStandbyId) {
      this.filterAtStandbyId = filterAtStandbyId;
      return this;
    }

    public Builder filterOnAutochangerName(String filterOnAutochangerName) {
      this.filterOnAutochangerName = filterOnAutochangerName;
      return this;
    }

    public Builder minLocked(long minLocked) {
      this.minLocked = minLocked;
      return this;
    }

    public Builder socketAtStandbyID(int socketAtStandbyID) {
      this.socketAtStandbyID = socketAtStandbyID;
      return this;
    }

    public Builder socketAtStandbyName(String socketAtStandbyName) {
      this.socketAtStandbyName = socketAtStandbyName;
      return this;
    }

    public Fcs_Carousel_TrendingTelemetry build() {
      return new Fcs_Carousel_TrendingTelemetry(atStandby, clampsStateAtStandby, deltaPositionAtStandby, emptyAtStandby, estimatedPosition, filterAtStandbyId, filterOnAutochangerName, minLocked, socketAtStandbyID, socketAtStandbyName);
    }
  }
}
