package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Fcs_Autochanger_TemperaturesTelemetry extends CameraTelemetry {
  private final double tempCellXminus;

  private final double tempClampMotorXminus;

  private final double tempClampMotorXplus;

  private final double tempClampMotorYminus;

  private final double tempFrontBox;

  private final double tempLinearRailMotorXminus;

  private final double tempLinearRailMotorXplus;

  private final double tempRearBox;

  public Fcs_Autochanger_TemperaturesTelemetry(double tempCellXminus, double tempClampMotorXminus,
      double tempClampMotorXplus, double tempClampMotorYminus, double tempFrontBox,
      double tempLinearRailMotorXminus, double tempLinearRailMotorXplus, double tempRearBox) {
    this.tempCellXminus = tempCellXminus;
    this.tempClampMotorXminus = tempClampMotorXminus;
    this.tempClampMotorXplus = tempClampMotorXplus;
    this.tempClampMotorYminus = tempClampMotorYminus;
    this.tempFrontBox = tempFrontBox;
    this.tempLinearRailMotorXminus = tempLinearRailMotorXminus;
    this.tempLinearRailMotorXplus = tempLinearRailMotorXplus;
    this.tempRearBox = tempRearBox;
  }

  public double getTempCellXminus() {
    return tempCellXminus;
  }

  public double getTempClampMotorXminus() {
    return tempClampMotorXminus;
  }

  public double getTempClampMotorXplus() {
    return tempClampMotorXplus;
  }

  public double getTempClampMotorYminus() {
    return tempClampMotorYminus;
  }

  public double getTempFrontBox() {
    return tempFrontBox;
  }

  public double getTempLinearRailMotorXminus() {
    return tempLinearRailMotorXminus;
  }

  public double getTempLinearRailMotorXplus() {
    return tempLinearRailMotorXplus;
  }

  public double getTempRearBox() {
    return tempRearBox;
  }

  @Override
  public String toString() {
    return "Fcs_Autochanger_TemperaturesTelemetry{" + "tempCellXminus=" + tempCellXminus +
        ", tempClampMotorXminus=" + tempClampMotorXminus +
        ", tempClampMotorXplus=" + tempClampMotorXplus +
        ", tempClampMotorYminus=" + tempClampMotorYminus +", tempFrontBox=" + tempFrontBox +
        ", tempLinearRailMotorXminus=" + tempLinearRailMotorXminus +
        ", tempLinearRailMotorXplus=" + tempLinearRailMotorXplus +", tempRearBox=" + tempRearBox +
        "}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double tempCellXminus;

    private double tempClampMotorXminus;

    private double tempClampMotorXplus;

    private double tempClampMotorYminus;

    private double tempFrontBox;

    private double tempLinearRailMotorXminus;

    private double tempLinearRailMotorXplus;

    private double tempRearBox;

    private Builder() {
    }

    public Builder tempCellXminus(double tempCellXminus) {
      this.tempCellXminus = tempCellXminus;
      return this;
    }

    public Builder tempClampMotorXminus(double tempClampMotorXminus) {
      this.tempClampMotorXminus = tempClampMotorXminus;
      return this;
    }

    public Builder tempClampMotorXplus(double tempClampMotorXplus) {
      this.tempClampMotorXplus = tempClampMotorXplus;
      return this;
    }

    public Builder tempClampMotorYminus(double tempClampMotorYminus) {
      this.tempClampMotorYminus = tempClampMotorYminus;
      return this;
    }

    public Builder tempFrontBox(double tempFrontBox) {
      this.tempFrontBox = tempFrontBox;
      return this;
    }

    public Builder tempLinearRailMotorXminus(double tempLinearRailMotorXminus) {
      this.tempLinearRailMotorXminus = tempLinearRailMotorXminus;
      return this;
    }

    public Builder tempLinearRailMotorXplus(double tempLinearRailMotorXplus) {
      this.tempLinearRailMotorXplus = tempLinearRailMotorXplus;
      return this;
    }

    public Builder tempRearBox(double tempRearBox) {
      this.tempRearBox = tempRearBox;
      return this;
    }

    public Fcs_Autochanger_TemperaturesTelemetry build() {
      return new Fcs_Autochanger_TemperaturesTelemetry(tempCellXminus, tempClampMotorXminus, tempClampMotorXplus, tempClampMotorYminus, tempFrontBox, tempLinearRailMotorXminus, tempLinearRailMotorXplus, tempRearBox);
    }
  }
}
