package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

public class ImageReadinessDetailedStateEvent extends CameraStateChangeEvent {
  private final ImageReadinessState substate;

  private final double timestampTransition;

  public ImageReadinessDetailedStateEvent(ImageReadinessState substate,
      double timestampTransition) {
    this.substate = substate;
    this.timestampTransition = timestampTransition;
  }

  @Override
  public ImageReadinessState getSubstate() {
    return substate;
  }

  public double getTimestampTransition() {
    return timestampTransition;
  }

  @Override
  public String toString() {
    return "ImageReadinessDetailedStateEvent{" + "substate=" + substate +
        ", timestampTransition=" + timestampTransition +"}";
  }

  public enum ImageReadinessState implements SALEnum {
    READY,

    NOT_READY,

    GETTING_READY
  }
}
