package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

public class CCSCommandStateEvent extends CameraStateChangeEvent {
  private final CCSCommandState substate;

  private final double timestampTransition;

  public CCSCommandStateEvent(CCSCommandState substate, double timestampTransition) {
    this.substate = substate;
    this.timestampTransition = timestampTransition;
  }

  @Override
  public CCSCommandState getSubstate() {
    return substate;
  }

  public double getTimestampTransition() {
    return timestampTransition;
  }

  @Override
  public String toString() {
    return "CCSCommandStateEvent{" + "substate=" + substate +
        ", timestampTransition=" + timestampTransition +"}";
  }

  public enum CCSCommandState implements SALEnum {
    IDLE,

    BUSY
  }
}
