package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Vacuum_VacuumConfigurationEvent extends CameraEvent {
  private final String version;

  private final double cryoPScale;

  private final double cryoPdiffFloor;

  private final double delayCCOff;

  private final double hxPScale;

  private final double hxPdiffFloor;

  private final double pChangeStateUpdate;

  private final double pFLChangeStateUpdate;

  private final double pPCChangeStateUpdate;

  private final double pcPdiffFloor;

  private final double pcPdiffScaleFactor;

  private final double pressCCEnable;

  private final double pressCCOff;

  private final double pressDiffHighMin;

  private final double pressDiffLow;

  private final double pressForelineLow;

  private final double pressIonEnable;

  private final double pressIonOff;

  private final double pressRefrigOk;

  private final double pressTurboLow;

  private final double pressVacuum;

  private final double speedFractTurboLow;

  private final long tranTimeCryoGate;

  private final long tranTimeHxGate;

  public Vacuum_VacuumConfigurationEvent(String version, double cryoPScale, double cryoPdiffFloor,
      double delayCCOff, double hxPScale, double hxPdiffFloor, double pChangeStateUpdate,
      double pFLChangeStateUpdate, double pPCChangeStateUpdate, double pcPdiffFloor,
      double pcPdiffScaleFactor, double pressCCEnable, double pressCCOff, double pressDiffHighMin,
      double pressDiffLow, double pressForelineLow, double pressIonEnable, double pressIonOff,
      double pressRefrigOk, double pressTurboLow, double pressVacuum, double speedFractTurboLow,
      long tranTimeCryoGate, long tranTimeHxGate) {
    this.version = version;
    this.cryoPScale = cryoPScale;
    this.cryoPdiffFloor = cryoPdiffFloor;
    this.delayCCOff = delayCCOff;
    this.hxPScale = hxPScale;
    this.hxPdiffFloor = hxPdiffFloor;
    this.pChangeStateUpdate = pChangeStateUpdate;
    this.pFLChangeStateUpdate = pFLChangeStateUpdate;
    this.pPCChangeStateUpdate = pPCChangeStateUpdate;
    this.pcPdiffFloor = pcPdiffFloor;
    this.pcPdiffScaleFactor = pcPdiffScaleFactor;
    this.pressCCEnable = pressCCEnable;
    this.pressCCOff = pressCCOff;
    this.pressDiffHighMin = pressDiffHighMin;
    this.pressDiffLow = pressDiffLow;
    this.pressForelineLow = pressForelineLow;
    this.pressIonEnable = pressIonEnable;
    this.pressIonOff = pressIonOff;
    this.pressRefrigOk = pressRefrigOk;
    this.pressTurboLow = pressTurboLow;
    this.pressVacuum = pressVacuum;
    this.speedFractTurboLow = speedFractTurboLow;
    this.tranTimeCryoGate = tranTimeCryoGate;
    this.tranTimeHxGate = tranTimeHxGate;
  }

  public String getVersion() {
    return version;
  }

  public double getCryoPScale() {
    return cryoPScale;
  }

  public double getCryoPdiffFloor() {
    return cryoPdiffFloor;
  }

  public double getDelayCCOff() {
    return delayCCOff;
  }

  public double getHxPScale() {
    return hxPScale;
  }

  public double getHxPdiffFloor() {
    return hxPdiffFloor;
  }

  public double getPChangeStateUpdate() {
    return pChangeStateUpdate;
  }

  public double getPFLChangeStateUpdate() {
    return pFLChangeStateUpdate;
  }

  public double getPPCChangeStateUpdate() {
    return pPCChangeStateUpdate;
  }

  public double getPcPdiffFloor() {
    return pcPdiffFloor;
  }

  public double getPcPdiffScaleFactor() {
    return pcPdiffScaleFactor;
  }

  public double getPressCCEnable() {
    return pressCCEnable;
  }

  public double getPressCCOff() {
    return pressCCOff;
  }

  public double getPressDiffHighMin() {
    return pressDiffHighMin;
  }

  public double getPressDiffLow() {
    return pressDiffLow;
  }

  public double getPressForelineLow() {
    return pressForelineLow;
  }

  public double getPressIonEnable() {
    return pressIonEnable;
  }

  public double getPressIonOff() {
    return pressIonOff;
  }

  public double getPressRefrigOk() {
    return pressRefrigOk;
  }

  public double getPressTurboLow() {
    return pressTurboLow;
  }

  public double getPressVacuum() {
    return pressVacuum;
  }

  public double getSpeedFractTurboLow() {
    return speedFractTurboLow;
  }

  public long getTranTimeCryoGate() {
    return tranTimeCryoGate;
  }

  public long getTranTimeHxGate() {
    return tranTimeHxGate;
  }

  @Override
  public String toString() {
    return "Vacuum_VacuumConfigurationEvent{" + "version=" + version +", cryoPScale=" + cryoPScale +
        ", cryoPdiffFloor=" + cryoPdiffFloor +", delayCCOff=" + delayCCOff +
        ", hxPScale=" + hxPScale +", hxPdiffFloor=" + hxPdiffFloor +
        ", pChangeStateUpdate=" + pChangeStateUpdate +
        ", pFLChangeStateUpdate=" + pFLChangeStateUpdate +
        ", pPCChangeStateUpdate=" + pPCChangeStateUpdate +", pcPdiffFloor=" + pcPdiffFloor +
        ", pcPdiffScaleFactor=" + pcPdiffScaleFactor +", pressCCEnable=" + pressCCEnable +
        ", pressCCOff=" + pressCCOff +", pressDiffHighMin=" + pressDiffHighMin +
        ", pressDiffLow=" + pressDiffLow +", pressForelineLow=" + pressForelineLow +
        ", pressIonEnable=" + pressIonEnable +", pressIonOff=" + pressIonOff +
        ", pressRefrigOk=" + pressRefrigOk +", pressTurboLow=" + pressTurboLow +
        ", pressVacuum=" + pressVacuum +", speedFractTurboLow=" + speedFractTurboLow +
        ", tranTimeCryoGate=" + tranTimeCryoGate +", tranTimeHxGate=" + tranTimeHxGate +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private double cryoPScale;

    private double cryoPdiffFloor;

    private double delayCCOff;

    private double hxPScale;

    private double hxPdiffFloor;

    private double pChangeStateUpdate;

    private double pFLChangeStateUpdate;

    private double pPCChangeStateUpdate;

    private double pcPdiffFloor;

    private double pcPdiffScaleFactor;

    private double pressCCEnable;

    private double pressCCOff;

    private double pressDiffHighMin;

    private double pressDiffLow;

    private double pressForelineLow;

    private double pressIonEnable;

    private double pressIonOff;

    private double pressRefrigOk;

    private double pressTurboLow;

    private double pressVacuum;

    private double speedFractTurboLow;

    private long tranTimeCryoGate;

    private long tranTimeHxGate;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder cryoPScale(double cryoPScale) {
      this.cryoPScale = cryoPScale;
      return this;
    }

    public Builder cryoPdiffFloor(double cryoPdiffFloor) {
      this.cryoPdiffFloor = cryoPdiffFloor;
      return this;
    }

    public Builder delayCCOff(double delayCCOff) {
      this.delayCCOff = delayCCOff;
      return this;
    }

    public Builder hxPScale(double hxPScale) {
      this.hxPScale = hxPScale;
      return this;
    }

    public Builder hxPdiffFloor(double hxPdiffFloor) {
      this.hxPdiffFloor = hxPdiffFloor;
      return this;
    }

    public Builder pChangeStateUpdate(double pChangeStateUpdate) {
      this.pChangeStateUpdate = pChangeStateUpdate;
      return this;
    }

    public Builder pFLChangeStateUpdate(double pFLChangeStateUpdate) {
      this.pFLChangeStateUpdate = pFLChangeStateUpdate;
      return this;
    }

    public Builder pPCChangeStateUpdate(double pPCChangeStateUpdate) {
      this.pPCChangeStateUpdate = pPCChangeStateUpdate;
      return this;
    }

    public Builder pcPdiffFloor(double pcPdiffFloor) {
      this.pcPdiffFloor = pcPdiffFloor;
      return this;
    }

    public Builder pcPdiffScaleFactor(double pcPdiffScaleFactor) {
      this.pcPdiffScaleFactor = pcPdiffScaleFactor;
      return this;
    }

    public Builder pressCCEnable(double pressCCEnable) {
      this.pressCCEnable = pressCCEnable;
      return this;
    }

    public Builder pressCCOff(double pressCCOff) {
      this.pressCCOff = pressCCOff;
      return this;
    }

    public Builder pressDiffHighMin(double pressDiffHighMin) {
      this.pressDiffHighMin = pressDiffHighMin;
      return this;
    }

    public Builder pressDiffLow(double pressDiffLow) {
      this.pressDiffLow = pressDiffLow;
      return this;
    }

    public Builder pressForelineLow(double pressForelineLow) {
      this.pressForelineLow = pressForelineLow;
      return this;
    }

    public Builder pressIonEnable(double pressIonEnable) {
      this.pressIonEnable = pressIonEnable;
      return this;
    }

    public Builder pressIonOff(double pressIonOff) {
      this.pressIonOff = pressIonOff;
      return this;
    }

    public Builder pressRefrigOk(double pressRefrigOk) {
      this.pressRefrigOk = pressRefrigOk;
      return this;
    }

    public Builder pressTurboLow(double pressTurboLow) {
      this.pressTurboLow = pressTurboLow;
      return this;
    }

    public Builder pressVacuum(double pressVacuum) {
      this.pressVacuum = pressVacuum;
      return this;
    }

    public Builder speedFractTurboLow(double speedFractTurboLow) {
      this.speedFractTurboLow = speedFractTurboLow;
      return this;
    }

    public Builder tranTimeCryoGate(long tranTimeCryoGate) {
      this.tranTimeCryoGate = tranTimeCryoGate;
      return this;
    }

    public Builder tranTimeHxGate(long tranTimeHxGate) {
      this.tranTimeHxGate = tranTimeHxGate;
      return this;
    }

    public Vacuum_VacuumConfigurationEvent build() {
      return new Vacuum_VacuumConfigurationEvent(version, cryoPScale, cryoPdiffFloor, delayCCOff, hxPScale, hxPdiffFloor, pChangeStateUpdate, pFLChangeStateUpdate, pPCChangeStateUpdate, pcPdiffFloor, pcPdiffScaleFactor, pressCCEnable, pressCCOff, pressDiffHighMin, pressDiffLow, pressForelineLow, pressIonEnable, pressIonOff, pressRefrigOk, pressTurboLow, pressVacuum, speedFractTurboLow, tranTimeCryoGate, tranTimeHxGate);
    }
  }
}
