package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Vacuum_PumpCart_CryoConfigurationEvent extends CameraEvent {
  private final String version;

  private final String devcId;

  private final double maxVentPressure;

  private final double minPumpPressure;

  public Vacuum_PumpCart_CryoConfigurationEvent(String version, String devcId,
      double maxVentPressure, double minPumpPressure) {
    this.version = version;
    this.devcId = devcId;
    this.maxVentPressure = maxVentPressure;
    this.minPumpPressure = minPumpPressure;
  }

  public String getVersion() {
    return version;
  }

  public String getDevcId() {
    return devcId;
  }

  public double getMaxVentPressure() {
    return maxVentPressure;
  }

  public double getMinPumpPressure() {
    return minPumpPressure;
  }

  @Override
  public String toString() {
    return "Vacuum_PumpCart_CryoConfigurationEvent{" + "version=" + version +", devcId=" + devcId +
        ", maxVentPressure=" + maxVentPressure +", minPumpPressure=" + minPumpPressure +"}";
  }
}
