package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Vacuum_Inst_LimitsConfigurationEvent extends CameraEvent {
  private final String version;

  private final double cryoflinevalvestate_warnHi;

  private final double cryoflinevalvestate_warnLo;

  private final double cryoflinevalvestate_limitHi;

  private final double cryoflinevalvestate_limitLo;

  private final double flinepower_warnHi;

  private final double flinepower_limitHi;

  private final double hxflinevalvestate_warnHi;

  private final double hxflinevalvestate_warnLo;

  private final double hxflinevalvestate_limitHi;

  private final double hxflinevalvestate_limitLo;

  private final double instvac_warnHi;

  private final double instvac_warnLo;

  private final double instvac_limitHi;

  private final double instvac_limitLo;

  private final double pumpcartcycling_warnHi;

  private final double pumpcartcycling_warnLo;

  private final double pumpcartcycling_limitHi;

  private final double pumpcartcycling_limitLo;

  private final double pumpcartpressure_warnHi;

  private final double pumpcartpressure_warnLo;

  private final double pumpcartpressure_limitHi;

  private final double pumpcartpressure_limitLo;

  private final double pumpcarttemperature_warnHi;

  private final double pumpcarttemperature_warnLo;

  private final double pumpcarttemperature_limitHi;

  private final double pumpcarttemperature_limitLo;

  private final double pumpcartventing_warnHi;

  private final double pumpcartventing_warnLo;

  private final double pumpcartventing_limitHi;

  private final double pumpcartventing_limitLo;

  public Vacuum_Inst_LimitsConfigurationEvent(String version, double cryoflinevalvestate_warnHi,
      double cryoflinevalvestate_warnLo, double cryoflinevalvestate_limitHi,
      double cryoflinevalvestate_limitLo, double flinepower_warnHi, double flinepower_limitHi,
      double hxflinevalvestate_warnHi, double hxflinevalvestate_warnLo,
      double hxflinevalvestate_limitHi, double hxflinevalvestate_limitLo, double instvac_warnHi,
      double instvac_warnLo, double instvac_limitHi, double instvac_limitLo,
      double pumpcartcycling_warnHi, double pumpcartcycling_warnLo, double pumpcartcycling_limitHi,
      double pumpcartcycling_limitLo, double pumpcartpressure_warnHi,
      double pumpcartpressure_warnLo, double pumpcartpressure_limitHi,
      double pumpcartpressure_limitLo, double pumpcarttemperature_warnHi,
      double pumpcarttemperature_warnLo, double pumpcarttemperature_limitHi,
      double pumpcarttemperature_limitLo, double pumpcartventing_warnHi,
      double pumpcartventing_warnLo, double pumpcartventing_limitHi,
      double pumpcartventing_limitLo) {
    this.version = version;
    this.cryoflinevalvestate_warnHi = cryoflinevalvestate_warnHi;
    this.cryoflinevalvestate_warnLo = cryoflinevalvestate_warnLo;
    this.cryoflinevalvestate_limitHi = cryoflinevalvestate_limitHi;
    this.cryoflinevalvestate_limitLo = cryoflinevalvestate_limitLo;
    this.flinepower_warnHi = flinepower_warnHi;
    this.flinepower_limitHi = flinepower_limitHi;
    this.hxflinevalvestate_warnHi = hxflinevalvestate_warnHi;
    this.hxflinevalvestate_warnLo = hxflinevalvestate_warnLo;
    this.hxflinevalvestate_limitHi = hxflinevalvestate_limitHi;
    this.hxflinevalvestate_limitLo = hxflinevalvestate_limitLo;
    this.instvac_warnHi = instvac_warnHi;
    this.instvac_warnLo = instvac_warnLo;
    this.instvac_limitHi = instvac_limitHi;
    this.instvac_limitLo = instvac_limitLo;
    this.pumpcartcycling_warnHi = pumpcartcycling_warnHi;
    this.pumpcartcycling_warnLo = pumpcartcycling_warnLo;
    this.pumpcartcycling_limitHi = pumpcartcycling_limitHi;
    this.pumpcartcycling_limitLo = pumpcartcycling_limitLo;
    this.pumpcartpressure_warnHi = pumpcartpressure_warnHi;
    this.pumpcartpressure_warnLo = pumpcartpressure_warnLo;
    this.pumpcartpressure_limitHi = pumpcartpressure_limitHi;
    this.pumpcartpressure_limitLo = pumpcartpressure_limitLo;
    this.pumpcarttemperature_warnHi = pumpcarttemperature_warnHi;
    this.pumpcarttemperature_warnLo = pumpcarttemperature_warnLo;
    this.pumpcarttemperature_limitHi = pumpcarttemperature_limitHi;
    this.pumpcarttemperature_limitLo = pumpcarttemperature_limitLo;
    this.pumpcartventing_warnHi = pumpcartventing_warnHi;
    this.pumpcartventing_warnLo = pumpcartventing_warnLo;
    this.pumpcartventing_limitHi = pumpcartventing_limitHi;
    this.pumpcartventing_limitLo = pumpcartventing_limitLo;
  }

  public String getVersion() {
    return version;
  }

  public double getCryoflinevalvestate_warnHi() {
    return cryoflinevalvestate_warnHi;
  }

  public double getCryoflinevalvestate_warnLo() {
    return cryoflinevalvestate_warnLo;
  }

  public double getCryoflinevalvestate_limitHi() {
    return cryoflinevalvestate_limitHi;
  }

  public double getCryoflinevalvestate_limitLo() {
    return cryoflinevalvestate_limitLo;
  }

  public double getFlinepower_warnHi() {
    return flinepower_warnHi;
  }

  public double getFlinepower_limitHi() {
    return flinepower_limitHi;
  }

  public double getHxflinevalvestate_warnHi() {
    return hxflinevalvestate_warnHi;
  }

  public double getHxflinevalvestate_warnLo() {
    return hxflinevalvestate_warnLo;
  }

  public double getHxflinevalvestate_limitHi() {
    return hxflinevalvestate_limitHi;
  }

  public double getHxflinevalvestate_limitLo() {
    return hxflinevalvestate_limitLo;
  }

  public double getInstvac_warnHi() {
    return instvac_warnHi;
  }

  public double getInstvac_warnLo() {
    return instvac_warnLo;
  }

  public double getInstvac_limitHi() {
    return instvac_limitHi;
  }

  public double getInstvac_limitLo() {
    return instvac_limitLo;
  }

  public double getPumpcartcycling_warnHi() {
    return pumpcartcycling_warnHi;
  }

  public double getPumpcartcycling_warnLo() {
    return pumpcartcycling_warnLo;
  }

  public double getPumpcartcycling_limitHi() {
    return pumpcartcycling_limitHi;
  }

  public double getPumpcartcycling_limitLo() {
    return pumpcartcycling_limitLo;
  }

  public double getPumpcartpressure_warnHi() {
    return pumpcartpressure_warnHi;
  }

  public double getPumpcartpressure_warnLo() {
    return pumpcartpressure_warnLo;
  }

  public double getPumpcartpressure_limitHi() {
    return pumpcartpressure_limitHi;
  }

  public double getPumpcartpressure_limitLo() {
    return pumpcartpressure_limitLo;
  }

  public double getPumpcarttemperature_warnHi() {
    return pumpcarttemperature_warnHi;
  }

  public double getPumpcarttemperature_warnLo() {
    return pumpcarttemperature_warnLo;
  }

  public double getPumpcarttemperature_limitHi() {
    return pumpcarttemperature_limitHi;
  }

  public double getPumpcarttemperature_limitLo() {
    return pumpcarttemperature_limitLo;
  }

  public double getPumpcartventing_warnHi() {
    return pumpcartventing_warnHi;
  }

  public double getPumpcartventing_warnLo() {
    return pumpcartventing_warnLo;
  }

  public double getPumpcartventing_limitHi() {
    return pumpcartventing_limitHi;
  }

  public double getPumpcartventing_limitLo() {
    return pumpcartventing_limitLo;
  }

  @Override
  public String toString() {
    return "Vacuum_Inst_LimitsConfigurationEvent{" + "version=" + version +
        ", cryoflinevalvestate_warnHi=" + cryoflinevalvestate_warnHi +
        ", cryoflinevalvestate_warnLo=" + cryoflinevalvestate_warnLo +
        ", cryoflinevalvestate_limitHi=" + cryoflinevalvestate_limitHi +
        ", cryoflinevalvestate_limitLo=" + cryoflinevalvestate_limitLo +
        ", flinepower_warnHi=" + flinepower_warnHi +", flinepower_limitHi=" + flinepower_limitHi +
        ", hxflinevalvestate_warnHi=" + hxflinevalvestate_warnHi +
        ", hxflinevalvestate_warnLo=" + hxflinevalvestate_warnLo +
        ", hxflinevalvestate_limitHi=" + hxflinevalvestate_limitHi +
        ", hxflinevalvestate_limitLo=" + hxflinevalvestate_limitLo +
        ", instvac_warnHi=" + instvac_warnHi +", instvac_warnLo=" + instvac_warnLo +
        ", instvac_limitHi=" + instvac_limitHi +", instvac_limitLo=" + instvac_limitLo +
        ", pumpcartcycling_warnHi=" + pumpcartcycling_warnHi +
        ", pumpcartcycling_warnLo=" + pumpcartcycling_warnLo +
        ", pumpcartcycling_limitHi=" + pumpcartcycling_limitHi +
        ", pumpcartcycling_limitLo=" + pumpcartcycling_limitLo +
        ", pumpcartpressure_warnHi=" + pumpcartpressure_warnHi +
        ", pumpcartpressure_warnLo=" + pumpcartpressure_warnLo +
        ", pumpcartpressure_limitHi=" + pumpcartpressure_limitHi +
        ", pumpcartpressure_limitLo=" + pumpcartpressure_limitLo +
        ", pumpcarttemperature_warnHi=" + pumpcarttemperature_warnHi +
        ", pumpcarttemperature_warnLo=" + pumpcarttemperature_warnLo +
        ", pumpcarttemperature_limitHi=" + pumpcarttemperature_limitHi +
        ", pumpcarttemperature_limitLo=" + pumpcarttemperature_limitLo +
        ", pumpcartventing_warnHi=" + pumpcartventing_warnHi +
        ", pumpcartventing_warnLo=" + pumpcartventing_warnLo +
        ", pumpcartventing_limitHi=" + pumpcartventing_limitHi +
        ", pumpcartventing_limitLo=" + pumpcartventing_limitLo +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private double cryoflinevalvestate_warnHi;

    private double cryoflinevalvestate_warnLo;

    private double cryoflinevalvestate_limitHi;

    private double cryoflinevalvestate_limitLo;

    private double flinepower_warnHi;

    private double flinepower_limitHi;

    private double hxflinevalvestate_warnHi;

    private double hxflinevalvestate_warnLo;

    private double hxflinevalvestate_limitHi;

    private double hxflinevalvestate_limitLo;

    private double instvac_warnHi;

    private double instvac_warnLo;

    private double instvac_limitHi;

    private double instvac_limitLo;

    private double pumpcartcycling_warnHi;

    private double pumpcartcycling_warnLo;

    private double pumpcartcycling_limitHi;

    private double pumpcartcycling_limitLo;

    private double pumpcartpressure_warnHi;

    private double pumpcartpressure_warnLo;

    private double pumpcartpressure_limitHi;

    private double pumpcartpressure_limitLo;

    private double pumpcarttemperature_warnHi;

    private double pumpcarttemperature_warnLo;

    private double pumpcarttemperature_limitHi;

    private double pumpcarttemperature_limitLo;

    private double pumpcartventing_warnHi;

    private double pumpcartventing_warnLo;

    private double pumpcartventing_limitHi;

    private double pumpcartventing_limitLo;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder cryoflinevalvestate_warnHi(double cryoflinevalvestate_warnHi) {
      this.cryoflinevalvestate_warnHi = cryoflinevalvestate_warnHi;
      return this;
    }

    public Builder cryoflinevalvestate_warnLo(double cryoflinevalvestate_warnLo) {
      this.cryoflinevalvestate_warnLo = cryoflinevalvestate_warnLo;
      return this;
    }

    public Builder cryoflinevalvestate_limitHi(double cryoflinevalvestate_limitHi) {
      this.cryoflinevalvestate_limitHi = cryoflinevalvestate_limitHi;
      return this;
    }

    public Builder cryoflinevalvestate_limitLo(double cryoflinevalvestate_limitLo) {
      this.cryoflinevalvestate_limitLo = cryoflinevalvestate_limitLo;
      return this;
    }

    public Builder flinepower_warnHi(double flinepower_warnHi) {
      this.flinepower_warnHi = flinepower_warnHi;
      return this;
    }

    public Builder flinepower_limitHi(double flinepower_limitHi) {
      this.flinepower_limitHi = flinepower_limitHi;
      return this;
    }

    public Builder hxflinevalvestate_warnHi(double hxflinevalvestate_warnHi) {
      this.hxflinevalvestate_warnHi = hxflinevalvestate_warnHi;
      return this;
    }

    public Builder hxflinevalvestate_warnLo(double hxflinevalvestate_warnLo) {
      this.hxflinevalvestate_warnLo = hxflinevalvestate_warnLo;
      return this;
    }

    public Builder hxflinevalvestate_limitHi(double hxflinevalvestate_limitHi) {
      this.hxflinevalvestate_limitHi = hxflinevalvestate_limitHi;
      return this;
    }

    public Builder hxflinevalvestate_limitLo(double hxflinevalvestate_limitLo) {
      this.hxflinevalvestate_limitLo = hxflinevalvestate_limitLo;
      return this;
    }

    public Builder instvac_warnHi(double instvac_warnHi) {
      this.instvac_warnHi = instvac_warnHi;
      return this;
    }

    public Builder instvac_warnLo(double instvac_warnLo) {
      this.instvac_warnLo = instvac_warnLo;
      return this;
    }

    public Builder instvac_limitHi(double instvac_limitHi) {
      this.instvac_limitHi = instvac_limitHi;
      return this;
    }

    public Builder instvac_limitLo(double instvac_limitLo) {
      this.instvac_limitLo = instvac_limitLo;
      return this;
    }

    public Builder pumpcartcycling_warnHi(double pumpcartcycling_warnHi) {
      this.pumpcartcycling_warnHi = pumpcartcycling_warnHi;
      return this;
    }

    public Builder pumpcartcycling_warnLo(double pumpcartcycling_warnLo) {
      this.pumpcartcycling_warnLo = pumpcartcycling_warnLo;
      return this;
    }

    public Builder pumpcartcycling_limitHi(double pumpcartcycling_limitHi) {
      this.pumpcartcycling_limitHi = pumpcartcycling_limitHi;
      return this;
    }

    public Builder pumpcartcycling_limitLo(double pumpcartcycling_limitLo) {
      this.pumpcartcycling_limitLo = pumpcartcycling_limitLo;
      return this;
    }

    public Builder pumpcartpressure_warnHi(double pumpcartpressure_warnHi) {
      this.pumpcartpressure_warnHi = pumpcartpressure_warnHi;
      return this;
    }

    public Builder pumpcartpressure_warnLo(double pumpcartpressure_warnLo) {
      this.pumpcartpressure_warnLo = pumpcartpressure_warnLo;
      return this;
    }

    public Builder pumpcartpressure_limitHi(double pumpcartpressure_limitHi) {
      this.pumpcartpressure_limitHi = pumpcartpressure_limitHi;
      return this;
    }

    public Builder pumpcartpressure_limitLo(double pumpcartpressure_limitLo) {
      this.pumpcartpressure_limitLo = pumpcartpressure_limitLo;
      return this;
    }

    public Builder pumpcarttemperature_warnHi(double pumpcarttemperature_warnHi) {
      this.pumpcarttemperature_warnHi = pumpcarttemperature_warnHi;
      return this;
    }

    public Builder pumpcarttemperature_warnLo(double pumpcarttemperature_warnLo) {
      this.pumpcarttemperature_warnLo = pumpcarttemperature_warnLo;
      return this;
    }

    public Builder pumpcarttemperature_limitHi(double pumpcarttemperature_limitHi) {
      this.pumpcarttemperature_limitHi = pumpcarttemperature_limitHi;
      return this;
    }

    public Builder pumpcarttemperature_limitLo(double pumpcarttemperature_limitLo) {
      this.pumpcarttemperature_limitLo = pumpcarttemperature_limitLo;
      return this;
    }

    public Builder pumpcartventing_warnHi(double pumpcartventing_warnHi) {
      this.pumpcartventing_warnHi = pumpcartventing_warnHi;
      return this;
    }

    public Builder pumpcartventing_warnLo(double pumpcartventing_warnLo) {
      this.pumpcartventing_warnLo = pumpcartventing_warnLo;
      return this;
    }

    public Builder pumpcartventing_limitHi(double pumpcartventing_limitHi) {
      this.pumpcartventing_limitHi = pumpcartventing_limitHi;
      return this;
    }

    public Builder pumpcartventing_limitLo(double pumpcartventing_limitLo) {
      this.pumpcartventing_limitLo = pumpcartventing_limitLo;
      return this;
    }

    public Vacuum_Inst_LimitsConfigurationEvent build() {
      return new Vacuum_Inst_LimitsConfigurationEvent(version, cryoflinevalvestate_warnHi, cryoflinevalvestate_warnLo, cryoflinevalvestate_limitHi, cryoflinevalvestate_limitLo, flinepower_warnHi, flinepower_limitHi, hxflinevalvestate_warnHi, hxflinevalvestate_warnLo, hxflinevalvestate_limitHi, hxflinevalvestate_limitLo, instvac_warnHi, instvac_warnLo, instvac_limitHi, instvac_limitLo, pumpcartcycling_warnHi, pumpcartcycling_warnLo, pumpcartcycling_limitHi, pumpcartcycling_limitLo, pumpcartpressure_warnHi, pumpcartpressure_warnLo, pumpcartpressure_limitHi, pumpcartpressure_limitLo, pumpcarttemperature_warnHi, pumpcarttemperature_warnLo, pumpcarttemperature_limitHi, pumpcarttemperature_limitLo, pumpcartventing_warnHi, pumpcartventing_warnLo, pumpcartventing_limitHi, pumpcartventing_limitLo);
    }
  }
}
