package org.lsst.sal.camera.event;

import java.util.Arrays;
import org.lsst.sal.camera.CameraEvent;

public class Vacuum_Hip_LimitsConfigurationEvent extends CameraEvent {
  private final String version;

  private final double[] hx_I_warnHi;

  private final double[] hx_I_warnLo;

  private final double[] hx_I_limitHi;

  private final double[] hx_I_limitLo;

  private final double[] hx_Life_warnHi;

  private final double[] hx_Life_warnLo;

  private final double[] hx_Life_limitHi;

  private final double[] hx_Life_limitLo;

  private final double[] hx_Usage_warnHi;

  private final double[] hx_Usage_warnLo;

  private final double[] hx_Usage_limitHi;

  private final double[] hx_Usage_limitLo;

  private final double[] hx_V_warnHi;

  private final double[] hx_V_warnLo;

  private final double[] hx_V_limitHi;

  private final double[] hx_V_limitLo;

  private final String location;

  public Vacuum_Hip_LimitsConfigurationEvent(String version, double[] hx_I_warnHi,
      double[] hx_I_warnLo, double[] hx_I_limitHi, double[] hx_I_limitLo, double[] hx_Life_warnHi,
      double[] hx_Life_warnLo, double[] hx_Life_limitHi, double[] hx_Life_limitLo,
      double[] hx_Usage_warnHi, double[] hx_Usage_warnLo, double[] hx_Usage_limitHi,
      double[] hx_Usage_limitLo, double[] hx_V_warnHi, double[] hx_V_warnLo, double[] hx_V_limitHi,
      double[] hx_V_limitLo, String location) {
    this.version = version;
    this.hx_I_warnHi = hx_I_warnHi;
    this.hx_I_warnLo = hx_I_warnLo;
    this.hx_I_limitHi = hx_I_limitHi;
    this.hx_I_limitLo = hx_I_limitLo;
    this.hx_Life_warnHi = hx_Life_warnHi;
    this.hx_Life_warnLo = hx_Life_warnLo;
    this.hx_Life_limitHi = hx_Life_limitHi;
    this.hx_Life_limitLo = hx_Life_limitLo;
    this.hx_Usage_warnHi = hx_Usage_warnHi;
    this.hx_Usage_warnLo = hx_Usage_warnLo;
    this.hx_Usage_limitHi = hx_Usage_limitHi;
    this.hx_Usage_limitLo = hx_Usage_limitLo;
    this.hx_V_warnHi = hx_V_warnHi;
    this.hx_V_warnLo = hx_V_warnLo;
    this.hx_V_limitHi = hx_V_limitHi;
    this.hx_V_limitLo = hx_V_limitLo;
    this.location = location;
  }

  public String getVersion() {
    return version;
  }

  public double[] getHx_I_warnHi() {
    return hx_I_warnHi;
  }

  public double[] getHx_I_warnLo() {
    return hx_I_warnLo;
  }

  public double[] getHx_I_limitHi() {
    return hx_I_limitHi;
  }

  public double[] getHx_I_limitLo() {
    return hx_I_limitLo;
  }

  public double[] getHx_Life_warnHi() {
    return hx_Life_warnHi;
  }

  public double[] getHx_Life_warnLo() {
    return hx_Life_warnLo;
  }

  public double[] getHx_Life_limitHi() {
    return hx_Life_limitHi;
  }

  public double[] getHx_Life_limitLo() {
    return hx_Life_limitLo;
  }

  public double[] getHx_Usage_warnHi() {
    return hx_Usage_warnHi;
  }

  public double[] getHx_Usage_warnLo() {
    return hx_Usage_warnLo;
  }

  public double[] getHx_Usage_limitHi() {
    return hx_Usage_limitHi;
  }

  public double[] getHx_Usage_limitLo() {
    return hx_Usage_limitLo;
  }

  public double[] getHx_V_warnHi() {
    return hx_V_warnHi;
  }

  public double[] getHx_V_warnLo() {
    return hx_V_warnLo;
  }

  public double[] getHx_V_limitHi() {
    return hx_V_limitHi;
  }

  public double[] getHx_V_limitLo() {
    return hx_V_limitLo;
  }

  public String getLocation() {
    return location;
  }

  @Override
  public String toString() {
    return "Vacuum_Hip_LimitsConfigurationEvent{" + "version=" + version +
        ", hx_I_warnHi=" + Arrays.toString(hx_I_warnHi) +
        ", hx_I_warnLo=" + Arrays.toString(hx_I_warnLo) +
        ", hx_I_limitHi=" + Arrays.toString(hx_I_limitHi) +
        ", hx_I_limitLo=" + Arrays.toString(hx_I_limitLo) +
        ", hx_Life_warnHi=" + Arrays.toString(hx_Life_warnHi) +
        ", hx_Life_warnLo=" + Arrays.toString(hx_Life_warnLo) +
        ", hx_Life_limitHi=" + Arrays.toString(hx_Life_limitHi) +
        ", hx_Life_limitLo=" + Arrays.toString(hx_Life_limitLo) +
        ", hx_Usage_warnHi=" + Arrays.toString(hx_Usage_warnHi) +
        ", hx_Usage_warnLo=" + Arrays.toString(hx_Usage_warnLo) +
        ", hx_Usage_limitHi=" + Arrays.toString(hx_Usage_limitHi) +
        ", hx_Usage_limitLo=" + Arrays.toString(hx_Usage_limitLo) +
        ", hx_V_warnHi=" + Arrays.toString(hx_V_warnHi) +
        ", hx_V_warnLo=" + Arrays.toString(hx_V_warnLo) +
        ", hx_V_limitHi=" + Arrays.toString(hx_V_limitHi) +
        ", hx_V_limitLo=" + Arrays.toString(hx_V_limitLo) +", location=" + location +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private double[] hx_I_warnHi;

    private double[] hx_I_warnLo;

    private double[] hx_I_limitHi;

    private double[] hx_I_limitLo;

    private double[] hx_Life_warnHi;

    private double[] hx_Life_warnLo;

    private double[] hx_Life_limitHi;

    private double[] hx_Life_limitLo;

    private double[] hx_Usage_warnHi;

    private double[] hx_Usage_warnLo;

    private double[] hx_Usage_limitHi;

    private double[] hx_Usage_limitLo;

    private double[] hx_V_warnHi;

    private double[] hx_V_warnLo;

    private double[] hx_V_limitHi;

    private double[] hx_V_limitLo;

    private String location;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder hx_I_warnHi(double[] hx_I_warnHi) {
      this.hx_I_warnHi = hx_I_warnHi;
      return this;
    }

    public Builder hx_I_warnLo(double[] hx_I_warnLo) {
      this.hx_I_warnLo = hx_I_warnLo;
      return this;
    }

    public Builder hx_I_limitHi(double[] hx_I_limitHi) {
      this.hx_I_limitHi = hx_I_limitHi;
      return this;
    }

    public Builder hx_I_limitLo(double[] hx_I_limitLo) {
      this.hx_I_limitLo = hx_I_limitLo;
      return this;
    }

    public Builder hx_Life_warnHi(double[] hx_Life_warnHi) {
      this.hx_Life_warnHi = hx_Life_warnHi;
      return this;
    }

    public Builder hx_Life_warnLo(double[] hx_Life_warnLo) {
      this.hx_Life_warnLo = hx_Life_warnLo;
      return this;
    }

    public Builder hx_Life_limitHi(double[] hx_Life_limitHi) {
      this.hx_Life_limitHi = hx_Life_limitHi;
      return this;
    }

    public Builder hx_Life_limitLo(double[] hx_Life_limitLo) {
      this.hx_Life_limitLo = hx_Life_limitLo;
      return this;
    }

    public Builder hx_Usage_warnHi(double[] hx_Usage_warnHi) {
      this.hx_Usage_warnHi = hx_Usage_warnHi;
      return this;
    }

    public Builder hx_Usage_warnLo(double[] hx_Usage_warnLo) {
      this.hx_Usage_warnLo = hx_Usage_warnLo;
      return this;
    }

    public Builder hx_Usage_limitHi(double[] hx_Usage_limitHi) {
      this.hx_Usage_limitHi = hx_Usage_limitHi;
      return this;
    }

    public Builder hx_Usage_limitLo(double[] hx_Usage_limitLo) {
      this.hx_Usage_limitLo = hx_Usage_limitLo;
      return this;
    }

    public Builder hx_V_warnHi(double[] hx_V_warnHi) {
      this.hx_V_warnHi = hx_V_warnHi;
      return this;
    }

    public Builder hx_V_warnLo(double[] hx_V_warnLo) {
      this.hx_V_warnLo = hx_V_warnLo;
      return this;
    }

    public Builder hx_V_limitHi(double[] hx_V_limitHi) {
      this.hx_V_limitHi = hx_V_limitHi;
      return this;
    }

    public Builder hx_V_limitLo(double[] hx_V_limitLo) {
      this.hx_V_limitLo = hx_V_limitLo;
      return this;
    }

    public Builder location(String location) {
      this.location = location;
      return this;
    }

    public Vacuum_Hip_LimitsConfigurationEvent build() {
      return new Vacuum_Hip_LimitsConfigurationEvent(version, hx_I_warnHi, hx_I_warnLo, hx_I_limitHi, hx_I_limitLo, hx_Life_warnHi, hx_Life_warnLo, hx_Life_limitHi, hx_Life_limitLo, hx_Usage_warnHi, hx_Usage_warnLo, hx_Usage_limitHi, hx_Usage_limitLo, hx_V_warnHi, hx_V_warnLo, hx_V_limitHi, hx_V_limitLo, location);
    }
  }
}
