package org.lsst.sal.camera.event;

import java.util.Arrays;
import org.lsst.sal.camera.CameraEvent;

public class Vacuum_CryoFlineGauge_CryoConfigurationEvent extends CameraEvent {
  private final String version;

  private final int busAddr;

  private final String devcId;

  private final double[] relayTrip;

  public Vacuum_CryoFlineGauge_CryoConfigurationEvent(String version, int busAddr, String devcId,
      double[] relayTrip) {
    this.version = version;
    this.busAddr = busAddr;
    this.devcId = devcId;
    this.relayTrip = relayTrip;
  }

  public String getVersion() {
    return version;
  }

  public int getBusAddr() {
    return busAddr;
  }

  public String getDevcId() {
    return devcId;
  }

  public double[] getRelayTrip() {
    return relayTrip;
  }

  @Override
  public String toString() {
    return "Vacuum_CryoFlineGauge_CryoConfigurationEvent{" + "version=" + version +
        ", busAddr=" + busAddr +", devcId=" + devcId +", relayTrip=" + Arrays.toString(relayTrip) +
        "}";
  }
}
